/* $Id: RTSystemFirmware-solaris.cpp $ */
/** @file
 * IPRT - System firmware information for Solaris.
 */

/*
 * Copyright (C) 2022 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 *
 * The contents of this file may alternatively be used under the terms
 * of the Common Development and Distribution License Version 1.0
 * (CDDL) only, as it comes in the "COPYING.CDDL" file of the
 * VirtualBox OSE distribution, in which case the provisions of the
 * CDDL are applicable instead of those of the GPL.
 *
 * You may elect to license modified versions of this file under the
 * terms and conditions of either the GPL or the CDDL or both.
 */


/*********************************************************************************************************************************
*   Header Files                                                                                                                 *
*********************************************************************************************************************************/
#include "internal/iprt.h"
#include <iprt/system.h>
#include <iprt/errcore.h>

#include <libdevinfo.h>


RTDECL(int) RTSystemQueryFirmwareType(PRTSYSFWTYPE penmFirmwareType)
{
    di_node_t di_node;
    di_node = di_init("/", DINFOSUBTREE|DINFOPROP);
    if (di_node == DI_NODE_NIL)
    {
        *penmFirmwareType = RTSYSFWTYPE_INVALID;
        return VERR_NOT_SUPPORTED;
    }

    int64_t *efiprop;
    int rc = di_prop_lookup_int64(DDI_DEV_T_ANY, di_node, "efi-systab", &efiprop);
    if (rc == -1)
        *penmFirmwareType = RTSYSFWTYPE_BIOS;
    else
        *penmFirmwareType = RTSYSFWTYPE_UEFI;

    di_fini(di_node);

    return VINF_SUCCESS;
}
RT_EXPORT_SYMBOL(RTSystemQueryFirmwareType);


RTDECL(int) RTSystemQueryFirmwareBoolean(RTSYSFWBOOL enmBoolean, bool *pfValue)
{
    RT_NOREF(enmBoolean, pfValue);
    return VERR_NOT_SUPPORTED;
}
RT_EXPORT_SYMBOL(RTSystemQueryFirmwareBoolean);

