#if defined HAVE_CONFIG_H
#include "config.h"
#endif
!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_Vector
!! NAME
!!  m_Vector
!! 
!! FUNCTION 
!!  Manage a double precision vector
!!
!! COPYRIGHT
!!  Copyright (C) 2013-2014 ABINIT group (J. Bieder)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

#include "defs.h"
MODULE m_Vector
USE m_Global
IMPLICIT NONE

!!***

PRIVATE

!!****t* m_Vector/Vector
!! NAME
!!  Vector
!!
!! FUNCTION
!!  This structured datatype contains the necessary data
!!
!! COPYRIGHT
!!  Copyright (C) 2013-2014 ABINIT group (J. Bieder)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

TYPE, PUBLIC :: Vector
  INTEGER         :: size
  INTEGER         :: tail
  DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:)         :: vec 
END TYPE Vector
!!***

PUBLIC :: Vector_init
PUBLIC :: Vector_setSize
PUBLIC :: Vector_enlarge
PUBLIC :: Vector_pushBack
PUBLIC :: Vector_clear
PUBLIC :: Vector_print
PUBLIC :: Vector_destroy

CONTAINS
!!***

!!****f* ABINIT/m_Vector/Vector_init
!! NAME
!!  Vector_init
!!
!! FUNCTION
!!  initialize
!!
!! COPYRIGHT
!!  Copyright (C) 2013-2014 ABINIT group (J. Bieder)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  vector_1=ListCdagC
!!  size=size of initialization
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

SUBROUTINE Vector_init(vector_1, size)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Vector_init'
!End of the abilint section

  TYPE(Vector)     , INTENT(INOUT) :: vector_1
  INTEGER, OPTIONAL, INTENT(IN   ) :: size
!Local variables ------------------------------
  INTEGER                          :: size_val

  size_val = Global_SIZE
  IF ( PRESENT(size) ) size_val = size
  vector_1%size = size_val
  FREEIF(vector_1%vec)
  MALLOC(vector_1%vec,(1:size_val))
  vector_1%tail     = 0 
  vector_1%vec = 0.d0
END SUBROUTINE Vector_init
!!***

!!****f* ABINIT/m_Vector/Vector_setSize
!! NAME
!!  Vector_setSize
!!
!! FUNCTION
!!  impose size
!!
!! COPYRIGHT
!!  Copyright (C) 2013-2014 ABINIT group (J. Bieder)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  vector_1=vector
!!  new_tail=new_size
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

SUBROUTINE Vector_setSize(vector_1,new_tail)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Vector_setSize'
!End of the abilint section

  TYPE(Vector), INTENT(INOUT) :: vector_1
  INTEGER     , INTENT(IN   ) :: new_tail
!Local variables ------------------------------
  INTEGER                     :: size

  IF ( .NOT. ALLOCATED(vector_1%vec) ) THEN
    CALL Vector_init(vector_1,new_tail)
  ELSE
    size = vector_1%size
    IF( new_tail .GT. size ) THEN
      CALL Vector_enlarge(vector_1,MAX(Global_SIZE,new_tail-size))
    END IF
  END IF
  vector_1%tail = new_tail
END SUBROUTINE Vector_setSize  
!!***

!!****f* ABINIT/m_Vector/Vector_enlarge
!! NAME
!!  Vector_enlarge
!!
!! FUNCTION
!!  enlarge memory size
!!
!! COPYRIGHT
!!  Copyright (C) 2013-2014 ABINIT group (J. Bieder)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  vector_1=vector
!!  size=memory size to add
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

SUBROUTINE Vector_enlarge(vector_1, size)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Vector_enlarge'
!End of the abilint section

  TYPE(Vector)     , INTENT(INOUT)        :: vector_1
  INTEGER          , INTENT(IN   )        :: size
!Local variables ------------------------------
  INTEGER                                 :: width
  INTEGER                                 :: tail
  DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:) :: vector_temp 
  INTEGER                                 :: size_val

  IF ( ALLOCATED(vector_1%vec) ) THEN
    FREEIF(vector_temp)
    width = vector_1%size
    tail  = vector_1%tail
    size_val = size 
    MALLOC(vector_temp,(1:tail))
    vector_temp(1:tail) = vector_1%vec(1:tail)
    FREE(vector_1%vec)
    vector_1%size = width + size_val
    MALLOC(vector_1%vec,(1:vector_1%size))
    vector_1%vec(1:tail) = vector_temp(1:tail)
    FREE(vector_temp)
  ELSE
    CALL Vector_init(vector_1, Global_SIZE)
  END IF
END SUBROUTINE Vector_enlarge
!!***

!!****f* ABINIT/m_Vector/Vector_pushBack
!! NAME
!!  Vector_pushBack
!!
!! FUNCTION
!!  push an element at the end
!!
!! COPYRIGHT
!!  Copyright (C) 2013-2014 ABINIT group (J. Bieder)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  vector_1=vector
!!  value=value to add
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

SUBROUTINE Vector_pushBack(vector_1, value)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Vector_pushBack'
!End of the abilint section

  TYPE(Vector)    , INTENT(INOUT) :: vector_1
  DOUBLE PRECISION, INTENT(IN   ) :: value
!Local variables ------------------------------
  INTEGER                         :: tail

  IF ( vector_1%size .EQ. 0 ) THEN
    CALL Vector_init(vector_1, Global_SIZE)
  END IF
  tail = vector_1%tail
  tail = tail + 1
  IF ( tail .GT. vector_1%size ) THEN
    CALL Vector_enlarge(vector_1,Global_SIZE)
  END IF
  vector_1%vec(tail) = value
  vector_1%tail      = tail
END SUBROUTINE Vector_pushBack
!!***

!!****f* ABINIT/m_Vector/Vector_clear
!! NAME
!!  Vector_clear
!!
!! FUNCTION
!!  Clear vector
!!
!! COPYRIGHT
!!  Copyright (C) 2013-2014 ABINIT group (J. Bieder)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  vector_1=vector
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

SUBROUTINE Vector_clear(vector_1)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Vector_clear'
!End of the abilint section

  TYPE(Vector), INTENT(INOUT) :: vector_1
  vector_1%tail = 0 
END SUBROUTINE Vector_clear
!!***

!!****f* ABINIT/m_Vector/Vector_print
!! NAME
!!  Vector_print
!!
!! FUNCTION
!!  print vector
!!
!! COPYRIGHT
!!  Copyright (C) 2013-2014 ABINIT group (J. Bieder)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  vector_1=vector
!!  ostream=file stream
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

SUBROUTINE Vector_print(vector_1,ostream)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Vector_print'
!End of the abilint section

  TYPE(Vector), INTENT(IN) :: vector_1
  INTEGER, OPTIONAL, INTENT(IN) :: ostream
!Local variables ------------------------------
  INTEGER                       :: ostream_val
  INTEGER                       :: it1
  CHARACTER(LEN=4 )             :: size
  CHARACTER(LEN=15)             :: string

  ostream_val = 6
  IF ( PRESENT(ostream) ) ostream_val = ostream
  WRITE(size,'(I4)') vector_1%tail
  WRITE(ostream_val,'(A)') "("
  string ='(1x,1ES10.2)'
  DO it1 = 1, vector_1%tail
    WRITE(ostream_val,string) vector_1%vec(it1)
  END DO
  WRITE(ostream_val,'(A)') ")"
END SUBROUTINE Vector_print
!!***

!!****f* ABINIT/m_Vector/Vector_destroy
!! NAME
!!  Vector_destroy
!!
!! FUNCTION
!!  Destroy vector 
!!
!! COPYRIGHT
!!  Copyright (C) 2013-2014 ABINIT group (J. Bieder)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  vector_1=vector
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

SUBROUTINE Vector_destroy(vector_1)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Vector_destroy'
!End of the abilint section

  TYPE(Vector), INTENT(INOUT) :: vector_1

  FREEIF(vector_1%vec)

  vector_1%tail     = 0
  vector_1%size     = 0
END SUBROUTINE Vector_destroy
!!***

END MODULE m_Vector
!!***

