/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Loader;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.FunctionProxy;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.GlobalValidationContext;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationContext;
import net.sf.saxon.xpath.XPathException;

public class StaticQueryContext
implements StaticContext {
    private Configuration config;
    private NamePool namePool;
    private HashMap passiveNamespaces;
    private Stack activeNamespaces;
    private HashMap collations;
    private HashMap variables;
    private HashMap functions;
    private HashSet importedSchemata;
    private List unboundFunctionCalls;
    private String defaultCollationName;
    private String defaultFunctionNamespace;
    private short defaultElementNamespace;
    private String baseURI;
    private int localStackFrameSize;
    private String moduleNamespace;
    private short moduleNamespaceURICode;
    private Stack validationModeStack;
    private Stack validationContextStack;

    public StaticQueryContext(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getTargetNamePool();
        this.reset();
    }

    public void reset() {
        this.passiveNamespaces = new HashMap();
        this.activeNamespaces = new Stack();
        this.collations = new HashMap();
        this.variables = new HashMap();
        this.functions = new HashMap();
        this.importedSchemata = new HashSet();
        this.unboundFunctionCalls = new ArrayList();
        this.defaultCollationName = null;
        this.defaultFunctionNamespace = "http://www.w3.org/2003/11/xpath-functions";
        this.defaultElementNamespace = 0;
        this.localStackFrameSize = 0;
        this.moduleNamespace = null;
        this.moduleNamespaceURICode = 0;
        this.validationModeStack = new Stack();
        this.validationModeStack.push(this.config.isSchemaAware() ? new Integer(2) : new Integer(4));
        this.validationContextStack = new Stack();
        this.validationContextStack.push(GlobalValidationContext.getInstance());
        this.clearNamespaces();
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    protected void declarePassiveNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declarePassiveNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declarePassiveNamespace()");
        }
        this.passiveNamespaces.put(string, string2);
        this.namePool.allocateNamespaceCode(string, string2);
    }

    protected void declareActiveNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareActiveNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareActiveNamespace()");
        }
        int n = this.namePool.allocateNamespaceCode(string, string2);
        ActiveNamespace activeNamespace = new ActiveNamespace();
        activeNamespace.prefix = string;
        activeNamespace.uri = string2;
        activeNamespace.code = n;
        this.activeNamespaces.push(activeNamespace);
        if (string.equals("")) {
            this.defaultElementNamespace = (short)(n & 0xFFFF);
        }
    }

    public void undeclareNamespace() {
        this.activeNamespaces.pop();
    }

    public void clearNamespaces() {
        if (this.passiveNamespaces != null) {
            this.passiveNamespaces.clear();
            this.declarePassiveNamespace("xml", "http://www.w3.org/XML/1998/namespace");
            this.declarePassiveNamespace("saxon", "http://saxon.sf.net/");
            this.declarePassiveNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            this.declarePassiveNamespace("fn", "http://www.w3.org/2003/11/xpath-functions");
            this.declarePassiveNamespace("xdt", "http://www.w3.org/2003/11/xpath-datatypes");
            this.declarePassiveNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.declarePassiveNamespace("local", "http://www.w3.org/2003/11/xquery-local-functions");
            this.declarePassiveNamespace("", "");
        }
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.checkURIForPrefix(string);
        if (string2 == null) {
            throw new XPathException.Static("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public String checkURIForPrefix(String string) {
        int n = this.activeNamespaces.size() - 1;
        while (n >= 0) {
            if (((ActiveNamespace)this.activeNamespaces.get((int)n)).prefix.equals(string)) {
                return ((ActiveNamespace)this.activeNamespaces.get((int)n)).uri;
            }
            --n;
        }
        return (String)this.passiveNamespaces.get(string);
    }

    public int[] getActiveNamespaceCodes() {
        Object object;
        Object object2 = new int[this.activeNamespaces.size()];
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = this.activeNamespaces.size() - 1;
        while (n2 >= 0) {
            object = (ActiveNamespace)this.activeNamespaces.get(n2);
            if (!hashSet.contains(((ActiveNamespace)object).prefix)) {
                hashSet.add(((ActiveNamespace)object).prefix);
                object2[n++] = ((ActiveNamespace)object).code;
            }
            --n2;
        }
        if (n < ((int[])object2).length) {
            object = new int[n];
            System.arraycopy(object2, 0, object, 0, n);
            object2 = object;
        }
        return object2;
    }

    public NamespaceResolver getNamespaceContext() {
        Object object;
        int[] nArray = this.getActiveNamespaceCodes();
        Object object2 = new int[this.passiveNamespaces.size() + nArray.length];
        System.arraycopy(nArray, 0, object2, 0, nArray.length);
        int n = 0;
        Iterator iterator = this.passiveNamespaces.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string = (String)this.passiveNamespaces.get(object);
            int n2 = this.namePool.getNamespaceCode((String)object, string);
            boolean bl = false;
            int n3 = 0;
            while (n3 < n) {
                if (object2[n3] >> 16 == n2 >> 16) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl) continue;
            object2[n++] = n2;
        }
        if (n < ((int[])object2).length) {
            object = new int[n];
            System.arraycopy(object2, 0, object, 0, n);
            object2 = object;
        }
        return new NamespaceContext((int[])object2);
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNamespace = string;
    }

    protected void setDefaultElementNamespace(String string) {
        int n = this.namePool.allocateNamespaceCode("", string);
        this.defaultElementNamespace = (short)(n & 0xFFFF);
        this.declarePassiveNamespace("", string);
    }

    public short getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setModuleNamespace(String string) {
        this.moduleNamespace = string;
        this.moduleNamespaceURICode = this.namePool.getCodeForURI(string);
    }

    public String getModuleNamespace() {
        return this.moduleNamespace;
    }

    public short getModuleNamespaceCode() {
        return this.moduleNamespaceURICode;
    }

    public void declareCollation(String string, Comparator comparator) {
        this.collations.put(string, comparator);
    }

    public void declareDefaultCollation(String string) throws XPathException {
        Object v = this.collations.get(string);
        if (v == null) {
            throw new XPathException.Static("Collation " + string + " is not recognized");
        }
    }

    public Comparator getCollation(String string) {
        Comparator comparator = (Comparator)this.collations.get(string);
        if (comparator != null) {
            return comparator;
        }
        try {
            return CollationFactory.makeCollationFromURI(string);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return CodepointCollator.URI;
    }

    public HashMap getAllCollations() {
        return new HashMap(this.collations);
    }

    public void declareVariable(VariableDeclaration variableDeclaration) throws XPathException {
        int n = variableDeclaration.getVariableFingerprint();
        Integer n2 = new Integer(n);
        if (this.variables.get(n2) != null) {
            throw new XPathException.Static("Duplicate definition of global variable " + variableDeclaration.getVariableName());
        }
        this.variables.put(n2, variableDeclaration);
    }

    public void fixupGlobalVariables() throws XPathException {
        int n = 1;
        Iterator iterator = this.variables.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)v;
            globalVariableDefinition.compile(this, n++);
        }
    }

    public Iterator getVariableDeclarations() {
        return this.variables.values().iterator();
    }

    public int getNumberOfGlobalVariables() {
        return this.variables.size();
    }

    public void allocateLocalSlots(int n) {
        if (n > this.localStackFrameSize) {
            this.localStackFrameSize = n;
        }
    }

    public int getNumberOfLocalVariables() {
        return this.localStackFrameSize;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string) {
        System.err.println(string);
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public VariableDeclaration bindVariable(int n) throws XPathException {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.variables.get(new Integer(n));
        if (variableDeclaration == null) {
            throw new XPathException.Static("Undeclared variable in query");
        }
        return variableDeclaration;
    }

    public void declareFunction(XQueryFunction xQueryFunction) throws XPathException {
        int n = xQueryFunction.getFunctionFingerprint();
        Integer n2 = new Integer(n);
        if (this.functions.get(n2) != null) {
            throw new XPathException.Static("Duplicate definition of function " + this.namePool.getDisplayName(n));
        }
        if (this.moduleNamespace != null && this.namePool.getURICode(n) != this.moduleNamespaceURICode) {
            throw new XPathException.Static("Function " + this.namePool.getDisplayName(n) + " is not defined in the module namespace");
        }
        this.functions.put(n2, xQueryFunction);
    }

    public Expression bindFunction(String string, Expression[] expressionArray) throws XPathException {
        Serializable serializable;
        String[] stringArray;
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static("Invalid function name. " + qNameException.getMessage());
        }
        String string2 = stringArray[0] == null || stringArray[0].equals("") ? this.getDefaultFunctionNamespace() : this.getURIForPrefix(stringArray[0]);
        if (string2.equals("http://www.w3.org/2003/11/xpath-functions")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction(stringArray[1]);
            if (functionCall == null) {
                throw new XPathException.Static("Unknown system function: " + string);
            }
            if (functionCall instanceof XSLTFunction) {
                throw new XPathException.Static("Function " + string + " is available only in XSLT");
            }
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        int n = this.namePool.allocate(stringArray[0], string2, stringArray[1]);
        int n2 = n & 0xFFFFF;
        if (string2.equals("http://www.w3.org/2001/XMLSchema") || string2.equals("http://www.w3.org/2001/XMLSchema-datatypes") || string2.equals("http://www.w3.org/2003/11/xpath-datatypes")) {
            if (expressionArray.length != 1) {
                throw new XPathException.Static("A constructor function must have exactly one argument");
            }
            return new CastExpression(expressionArray[0], (AtomicType)Type.getBuiltInItemType(string2, stringArray[1]));
        }
        if (expressionArray.length == 1 && (serializable = this.getNamePool().getSchemaType(n2)) != null && serializable instanceof AtomicType) {
            return new CastExpression(expressionArray[0], (AtomicType)serializable, false);
        }
        if (n2 == this.namePool.getFingerprint("http://saxon.sf.net/", "evaluate")) {
            serializable = SystemFunction.makeSystemFunction("saxon:evaluate");
            ((FunctionCall)serializable).setArguments(expressionArray);
            return serializable;
        }
        if (n2 == this.namePool.getFingerprint("http://saxon.sf.net/", "expression")) {
            serializable = SystemFunction.makeSystemFunction("saxon:expression");
            ((FunctionCall)serializable).setArguments(expressionArray);
            return serializable;
        }
        if (n2 == this.namePool.getFingerprint("http://saxon.sf.net/", "parse")) {
            serializable = SystemFunction.makeSystemFunction("saxon:parse");
            ((FunctionCall)serializable).setArguments(expressionArray);
            return serializable;
        }
        if (n2 == this.namePool.getFingerprint("http://saxon.sf.net/", "serialize")) {
            serializable = SystemFunction.makeSystemFunction("saxon:serialize");
            ((FunctionCall)serializable).setArguments(expressionArray);
            return serializable;
        }
        serializable = null;
        try {
            serializable = this.getExternalJavaClass(string2);
        }
        catch (Exception exception) {
            throw new XPathException.Static("Cannot load external Java class", exception);
        }
        if (serializable != null) {
            if (!this.config.isAllowExternalFunctions()) {
                throw new XPathException.Static("External functions are disabled");
            }
            FunctionProxy functionProxy = new FunctionProxy();
            functionProxy.setDebug(this.config.isTraceExternalFunctions());
            functionProxy.setArguments(expressionArray);
            functionProxy.setFunctionName((Class)serializable, stringArray[1], expressionArray.length);
            return functionProxy;
        }
        UserFunctionCall userFunctionCall = new UserFunctionCall();
        userFunctionCall.setFingerprint(n2);
        userFunctionCall.setArguments(expressionArray);
        this.unboundFunctionCalls.add(userFunctionCall);
        return userFunctionCall;
    }

    protected void bindUnboundFunctionCalls() throws XPathException {
        Iterator iterator = this.unboundFunctionCalls.iterator();
        while (iterator.hasNext()) {
            UserFunctionCall userFunctionCall = (UserFunctionCall)iterator.next();
            int n = userFunctionCall.getFingerprint();
            Integer n2 = new Integer(n);
            XQueryFunction xQueryFunction = (XQueryFunction)this.functions.get(n2);
            if (xQueryFunction != null) {
                userFunctionCall.setStaticType(xQueryFunction.getResultType());
                xQueryFunction.registerReference(userFunctionCall);
                continue;
            }
            throw new XPathException.Static("Function " + this.namePool.getDisplayName(n) + " has not been declared", ExpressionTool.getLocator(userFunctionCall));
        }
    }

    public Iterator getFunctionDefinitions() {
        return this.functions.values().iterator();
    }

    protected void fixupGlobalFunctions() throws XPathException {
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            XQueryFunction xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.compile(this);
        }
    }

    public void explainGlobalFunctions() throws XPathException {
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            XQueryFunction xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.explain(this.getNamePool());
        }
    }

    private Class getExternalJavaClass(String string) {
        Class clazz = FunctionProxy.getVendorExtensionClass(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            if (string.startsWith("java:")) {
                return Loader.getClass(string.substring(5));
            }
        }
        catch (TransformerException transformerException) {
            return null;
        }
        return null;
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public void addImportedSchema(String string) {
        if (this.importedSchemata == null) {
            this.importedSchemata = new HashSet();
        }
        this.importedSchemata.add(string);
    }

    public boolean isImportedSchema(String string) {
        if (this.importedSchemata == null) {
            return false;
        }
        return this.importedSchemata.contains(string);
    }

    public void pushValidationMode(int n) {
        this.validationModeStack.push(new Integer(n));
    }

    public void popValidationMode() {
        this.validationModeStack.pop();
    }

    public int getValidationMode() {
        return (Integer)this.validationModeStack.peek();
    }

    public void pushValidationContext(ValidationContext validationContext) {
        this.validationContextStack.push(validationContext);
    }

    public void popValidationContext() {
        this.validationContextStack.pop();
    }

    public ValidationContext getValidationContext() {
        return (ValidationContext)this.validationContextStack.peek();
    }

    public void setContainedValidationContext(int n) throws XPathException {
        ValidationContext validationContext = this.getConfiguration().getContainedValidationContext(this.getValidationContext(), n, false);
        this.pushValidationContext(validationContext);
    }

    protected StaticQueryContext loadModule(String string, String string2) throws XPathException {
        URL uRL;
        StaticQueryContext staticQueryContext = this.config.getQueryLibraryModule(string);
        if (staticQueryContext != null) {
            this.allocateLocalSlots(staticQueryContext.getNumberOfLocalVariables());
            return staticQueryContext;
        }
        if (string2 == null) {
            throw new XPathException.Static("import module must either specify a known namespace or a location");
        }
        if (this.baseURI == null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathException.Dynamic("Cannot resolve URI (no base URI available)", malformedURLException);
            }
        }
        try {
            uRL = new URL(new URL(this.baseURI), string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XPathException.Dynamic("Cannot resolve relative URI", malformedURLException);
        }
        try {
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[2048];
            int n = 0;
            while ((n = bufferedReader.read(cArray, 0, 2048)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            StaticQueryContext staticQueryContext2 = new StaticQueryContext(this.config);
            staticQueryContext2.setBaseURI(uRL.toString());
            QueryParser queryParser = new QueryParser();
            queryParser.parseLibraryModule(stringBuffer.toString(), staticQueryContext2);
            if (staticQueryContext2.getModuleNamespace() == null) {
                throw new XPathException.Static("Imported module must be a library module");
            }
            if (!staticQueryContext2.getModuleNamespace().equals(string)) {
                throw new XPathException.Static("Imported module's namespace does not match requested namespace");
            }
            this.config.addQueryLibraryModule(staticQueryContext2);
            this.allocateLocalSlots(staticQueryContext2.getNumberOfLocalVariables());
            return staticQueryContext2;
        }
        catch (IOException iOException) {
            throw new XPathException.Dynamic(iOException);
        }
    }

    public static class ActiveNamespace {
        public String prefix;
        public String uri;
        public int code;
    }
}

