if("IPA" IN_LIST NAMES)
	set(IPA ON)
	set(TARGET ipa)
	set(PRESET ci-ios)
elseif("Framework" IN_LIST NAMES)
	set(TARGET zip)
	set(PRESET ci-ios-framework)
	if("Simulator" IN_LIST NAMES)
		set(PRESET ${PRESET}-simulator)
		if("arm64" IN_LIST NAMES)
			set(PRESET ${PRESET}-arm64)
		endif()
	endif()
elseif("SwiftPackage" IN_LIST NAMES)
	step(${CMAKE_COMMAND} -DDIST_DIR=${T_DIST_DIR} -P ${CMAKE_DIR}/SwiftPackage.cmake)
	return()
endif()

block()
	include(Libraries)
endblock()

if("Simulator" IN_LIST NAMES)
	set(PLATFORM "iOS Simulator")
else()
	set(PLATFORM "iOS")
endif()

step(security unlock-keychain $ENV{KEYCHAIN_CREDENTIALS} $ENV{HOME}/Library/Keychains/login.keychain-db)

step(${T_CFG} --preset ${PRESET})

if(IPA AND NOT REVIEW)
	step(xcodebuild -configuration MinSizeRel -archivePath AusweisApp.xcarchive -scheme AusweisAppBinary -destination "generic/platform=${PLATFORM}" archive CHDIR ${T_BUILD_DIR})
	step(xcodebuild -configuration MinSizeRel -archivePath AusweisApp.xcarchive -exportArchive -exportOptionsPlist exportOptions.plist -exportPath . CHDIR ${T_BUILD_DIR})
else()
	step(xcodebuild -configuration MinSizeRel -scheme AusweisAppBinary -destination "generic/platform=${PLATFORM}" CHDIR ${T_BUILD_DIR})
endif()

if(RELEASE)
	step(${CMAKE_COMMAND} -E tar cf AusweisApp_BuildDir.tar.zstd --zstd build)
endif()

step(xcodebuild -configuration MinSizeRel -target ${TARGET} CHDIR ${T_BUILD_DIR})

if(IPA AND NOT RELEASE)
	step(${T_CTEST} -C MinSizeRel)
endif()

if(IPA AND RELEASE AND DEFINED ENV{USE_DISTRIBUTION_PROFILE})
	if($ENV{USE_DISTRIBUTION_PROFILE})
		file(GLOB ipafile "${T_BUILD_DIR}/*.ipa")
		step(xcrun altool -t ios --validate-app --verbose -u $ENV{APPSTORE_USER} -p @env:APPSTORE_PSW -f ${ipafile})
		step(xcrun altool -t ios --upload-app -u $ENV{APPSTORE_USER} -p @env:APPSTORE_PSW -f ${ipafile})
	endif()
endif()
