/*
 * Copyright 2001-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.axis.client.async;

/**
 * Access the results of the Async call
 * 
 * @author Davanum Srinivas (dims@yahoo.com)
 */
public interface IAsyncResult {

    /**
     * Method abort
     */
    public void abort();

    /**
     * Method getStatus
     * 
     * @return 
     */
    public Status getStatus();

    /**
     * Method waitFor
     * 
     * @param timeout 
     * @throws InterruptedException 
     */
    public void waitFor(long timeout) throws InterruptedException;

    /**
     * Method getResponse
     * 
     * @return 
     */
    public Object getResponse();

    /**
     * Method getException
     * 
     * @return 
     */
    public Throwable getException();
}
