//
// BAGEL - Parallel electron correlation program.
// Filename: _breitroot_4.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot4(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[4] = {5.235260767382691e-01,2.156648763269094e+00,5.137387546176711e+00,1.018243761381592e+01};
  constexpr double aw[4] = {2.265043732793038e-01,1.908084800858998e-01,2.539731378612038e-02,4.032955750550154e-04};
  constexpr double x[1536] = {  1.921924733818690e-01, -8.768074777695027e-03,  2.697283662746131e-04, -6.156764037308125e-06,  8.656755354488836e-08,
  4.930598884081129e-10, -8.129348133428441e-11,  2.989041249051197e-12, -6.267650683931552e-14,  1.834053994496536e-16,  5.067953578564245e-17, -2.140982816017785e-18,
  7.046383416398344e-01, -2.362767640081116e-02,  2.843174635746880e-04,  6.366780422478742e-06, -2.841085218433418e-07, -3.967910644055882e-10,  2.570067972734486e-10,
 -4.214464090675120e-12, -1.883605499629383e-13,  7.856665055474796e-15,  7.202700678166175e-17, -9.231252526904441e-18,  1.351600377893622e+00, -2.347156772002677e-02,
 -3.178739137304022e-04,  6.185682714597534e-06,  3.156193890420951e-07, -2.134360470794064e-11, -2.988367789013087e-10, -5.299409672284384e-12,  2.225133946269828e-13,
  9.834291020656903e-15, -6.903591476672221e-17, -1.167179239200633e-17,  1.860892748112846e+00, -7.133926069023022e-03, -2.529066718383007e-04, -6.997082676989979e-06,
 -1.424934662981404e-07, -1.268889905631642e-09,  5.525563585729408e-11,  3.616262531788601e-12,  1.185499220930466e-13,  2.146799683283320e-15, -1.251835569337882e-17,
 -2.370947887754754e-18,  1.610014297810022e-01, -6.882040097963437e-03,  2.042080403261496e-04, -4.774238915987806e-06,  8.258999753840196e-08, -6.641948331742860e-10,
 -2.280999323943257e-11,  1.327317265861786e-12, -3.756786320838638e-14,  8.369368587527379e-16, -6.521426873297228e-18, -5.800436973895828e-19,  6.150531524241462e-01,
 -2.112347164406682e-02,  3.341364234160824e-04,  2.043716510977268e-06, -2.423179770347907e-07,  3.937575836842092e-09,  9.700062710197492e-11, -5.848677396495178e-12,
  6.550178212945426e-14,  4.616761352439555e-15, -1.713610244751770e-16, -1.077016795419411e-18,  1.253215982423403e+00, -2.563454022535912e-02, -2.147172516068343e-04,
  1.081032034759145e-05,  2.368475741097227e-07, -7.886803185860226e-09, -3.040423643335729e-10,  5.937275315812545e-12,  4.041836085081913e-13, -2.605160222682996e-15,
 -4.783445609136390e-16, -1.562417907835541e-18,  1.827722337247015e+00, -9.533053042001843e-03, -3.510406391261850e-04, -9.364977790484558e-06, -1.439231881216684e-07,
  1.762296391826825e-09,  2.189388552742050e-10,  8.256511079527905e-12,  1.477444396140102e-13, -2.028964861501546e-15, -2.421006686835183e-16, -8.505102314615018e-18,
  1.364079620013450e-01, -5.456223614904171e-03,  1.543404657554422e-04, -3.578291016992316e-06,  6.624856254097723e-08, -8.763670918596240e-10,  1.492777825846908e-12,
  5.243071844109685e-13, -1.571547411060368e-14,  3.359433110946378e-16, -1.330656314272499e-17,  1.419957193008193e-19,  5.359763369407602e-01, -1.841163917295756e-02,
  3.382684982308793e-04, -1.126788118989202e-06, -1.518480260187309e-07,  4.643626557766748e-09, -2.178360138093210e-11, -2.386648160679449e-12,  1.148095068795320e-13,
 -1.338613316859139e-15, -9.585179292291475e-17,  3.145852722178887e-18,  1.148136289631620e+00, -2.678314446337343e-02, -6.853285603829215e-05,  1.302196165371168e-05,
  2.632521557096552e-08, -1.194113909097292e-08,  4.257926467955102e-12,  1.398612831415490e-11,  1.603077284598520e-14, -1.597730064292317e-14, -4.523378903067256e-17,
  1.720361003555453e-17,  1.783212854142117e+00, -1.282508682556472e-02, -4.749146805952682e-04, -1.101374607322847e-05, -3.523780045373364e-08,  1.017132946155021e-08,
  4.873918928421688e-10,  9.146270885100671e-12, -1.983514578697310e-13, -1.978134601261414e-14, -6.067807718386178e-16, -2.008446088165513e-18,  1.168042897529070e-01,
 -4.376536656377803e-03,  1.172001611068752e-04, -2.652507072607808e-06,  5.001021580229525e-08, -7.133043748001134e-10,  1.031302589920501e-11,  1.290459529788479e-13,
 -1.102939647910429e-14, -4.215206252050380e-18, -2.749451636535032e-18,  2.822747137877920e-19,  4.676070995254384e-01, -1.579409101820196e-02,  3.130966395688647e-04,
 -2.857811301710235e-06, -6.773486869120403e-08,  3.669679287728811e-09, -4.815859903322292e-11,  3.918429073126886e-14,  2.948478069759154e-14, -2.611851140199167e-15,
  2.220367486800418e-17,  1.890793406053363e-18,  1.040883863324612e+00, -2.671666512417432e-02,  8.274648889747601e-05,  1.166567850800115e-05, -1.816425034951818e-07,
 -7.590563113121364e-09,  3.221806577946974e-10,  6.313309675462088e-12, -4.298802573169116e-13, -5.412025122970496e-15,  4.489217804771419e-16,  1.275135570283621e-18,
  1.723489305605170e+00, -1.714271348338795e-02, -6.015054068179950e-04, -9.250426337674307e-06,  2.988235824682255e-07,  2.340883192284732e-08,  5.169964910263151e-10,
 -1.264189748624670e-11, -1.238376735474470e-12, -3.035589892339003e-14,  5.982441133561863e-16,  6.747973805595775e-17,  1.009896436400195e-01, -3.553646609795848e-03,
  8.974545788060034e-05, -1.952517583950263e-06,  3.830441008353557e-08, -4.626062406675263e-10,  8.953247874502965e-12, -2.229546483116265e-13, -1.012578108725639e-14,
  1.378299231325247e-16,  9.749281495435182e-18,  2.555561008952173e-19,  4.092039252423571e-01, -1.343974077535780e-02,  2.745223074871987e-04, -3.415951969210432e-06,
 -5.594274243007044e-09,  2.556446889243926e-09, -4.595040013252585e-11, -2.129538507746658e-13, -3.224360656015808e-14, -4.511341420183271e-16,  7.827452952292766e-17,
  7.907042101428337e-19,  9.361464378911315e-01, -2.555277506312160e-02,  2.017423607200612e-04,  7.996060602615858e-06, -2.501668094414958e-07,  6.493001051959415e-10,
  3.008891174138265e-10, -7.285645059367489e-12, -3.312740875884433e-13,  9.335514044745351e-15,  2.353870476053227e-16, -6.177956546642279e-18,  1.644757349156374e+00,
 -2.227849689960642e-02, -6.667351332081556e-04, -2.606058831778575e-07,  8.361098650483040e-07,  2.641198875658041e-08, -4.839906686450066e-10, -5.829737896875558e-11,
 -1.049229405917795e-12,  6.383571421553987e-14,  3.796399476758200e-15,  1.479690235201738e-17,  8.807645488152975e-02, -2.919625218671814e-03,  6.971777173147981e-05,
 -1.404681523582073e-06,  3.053686026355187e-08, -3.515506747729954e-10, -4.481418037362569e-13, -3.773626419934095e-13,  3.388514495308039e-15,  6.048686305486806e-16,
  7.563908379100765e-18, -5.678484583081194e-19,  3.595801688389800e-01, -1.140557171845493e-02,  2.344764327075855e-04, -3.160443390257189e-06,  3.343986551871700e-08,
  1.273213379015154e-09, -6.425361293373859e-11, -8.660691346310141e-13,  1.065232008973649e-14,  2.678119216996154e-15,  5.014911752197647e-17, -3.066026615794987e-18,
  8.376788583335723e-01, -2.361995093480102e-02,  2.751469606390671e-04,  4.403248786462307e-06, -1.861658531703952e-07,  4.588552304130771e-09,  9.246756127891270e-12,
 -1.115433194395595e-11,  1.179797062620687e-13,  1.406046356291736e-14, -2.026631619428905e-17, -9.683330099055186e-18,  1.545321079977633e+00, -2.736432697222174e-02,
 -5.758097897638907e-04,  1.612569869244104e-05,  1.108971772119116e-06, -5.494578572564902e-09, -2.054643975023378e-09, -3.072996337610106e-11,  3.180064882382652e-12,
  1.221052173657695e-13, -3.444383120626497e-15, -3.014222070095451e-16,  7.741767982109678e-02, -2.421555901192472e-03,  5.555051091479759e-05, -9.760304774657830e-07,
  2.269364167215712e-08, -4.562566048106872e-10, -6.195720052706624e-12,  6.807138940170695e-14,  2.158172981657891e-14,  1.122580038236878e-16, -3.425343964178713e-17,
 -7.444133520502070e-19,  3.174839762496361e-01, -9.671008883210945e-03,  2.003120346963091e-04, -2.511818461389163e-06,  4.211967000735811e-08, -4.269322359421531e-10,
 -6.851997352952545e-11,  1.039297322301733e-12,  9.607890372259056e-14,  5.521813253244338e-16, -1.662682523323008e-16, -3.856154039726172e-18,  7.478732770922886e-01,
 -2.125147941079186e-02,  3.129224384776826e-04,  2.078039653946309e-06, -1.133879525250622e-07,  1.924920443623068e-09, -1.815861058390234e-10, -5.711791060360974e-13,
  4.632922646678406e-13,  4.261471410692936e-16, -6.872035085567532e-16, -1.074617788511329e-17,  1.428268667393871e+00, -3.092136329646445e-02, -2.883609267070882e-04,
  3.026319270460345e-05,  5.075928765044631e-07, -5.109324472923499e-08, -1.148803268186730e-09,  9.356375416992853e-11,  2.734525968486137e-12, -1.709580524010091e-13,
 -6.450959481221793e-15,  3.033515392153253e-16,  6.855383052419306e-02, -2.018565826238054e-03,  4.569448836673126e-05, -6.920124578549639e-07,  1.261799707723594e-08,
 -5.104966194022409e-10,  3.960545859483693e-12,  5.426691189864671e-13,  5.092630490877914e-16, -1.076769232867095e-15, -3.916992503348102e-18,  1.921593615645520e-18,
  2.818287115412045e-01, -8.178778946626197e-03,  1.736841098634972e-04, -1.979670559361427e-06,  2.118570776000863e-08, -1.406184920878052e-09, -3.286745063354147e-12,
  3.060203522219473e-12, -6.703566942147045e-15, -5.229224189285097e-15, -1.456159233752731e-17,  9.670615538640123e-18,  6.679905347857967e-01, -1.867771794101280e-02,
  3.275312821463325e-04,  3.579788254936865e-07, -1.117645789876918e-07, -1.131705447752098e-09, -2.644140248794324e-11,  9.193054896924758e-12,  1.323614874240911e-14,
 -2.049743229017232e-14,  3.408324883540999e-17,  3.776398445235537e-17,  1.302355620600184e+00, -3.172009152853994e-02,  8.763175187253136e-05,  2.969626703881082e-05,
 -5.547403705612402e-07, -4.400441112700998e-08,  1.605795795562994e-09,  6.605392514880558e-11, -3.927410187292842e-12, -8.931187603004601e-14,  8.810214099802091e-15,
  9.133859427953016e-17,  6.116198026435948e-02, -1.683512577998727e-03,  3.829470184789055e-05, -5.618775439276287e-07,  4.455825716876034e-09, -2.642082129596617e-10,
  1.425085790394263e-11,  6.135276270769123e-14, -2.322014992549721e-14,  8.364863321627348e-17,  4.191827265895909e-17, -5.840583664056496e-19,  2.517475343648413e-01,
 -6.880597541574464e-03,  1.510938394760208e-04, -1.843385572685437e-06, -1.600006459932088e-09, -6.392933637762912e-10,  5.483274875190790e-11,  4.814592210902716e-13,
 -1.169873844042380e-13,  6.603682156374271e-16,  2.047453873110571e-16, -3.341049915872120e-18,  5.985024029556323e-01, -1.607221925722701e-02,  3.204624903850964e-04,
 -1.565467098796209e-06, -1.222647474065636e-07,  7.719240521749949e-10,  1.447168928144395e-10,  8.725709128321175e-13, -3.796959083087309e-13,  3.565793216533632e-15,
  7.257053447516199e-16, -1.728594095317043e-17,  1.178852712123103e+00, -2.979576356176258e-02,  3.695397842273645e-04,  1.623256443703579e-05, -9.769340596305918e-07,
  1.915634433796029e-09,  1.673084584908190e-09, -4.900736997599687e-11, -1.839117748238175e-12,  1.399960767900078e-13, -3.979050700736146e-17, -2.661664476665041e-16,
  5.499927287085501e-02, -1.403196769428971e-03,  3.186398603749757e-05, -5.150675022178281e-07,  2.344510109462973e-09,  2.673388466569612e-11,  7.820467318525518e-12,
 -4.013751382786165e-13, -1.950582080128989e-15,  7.083485977600358e-16, -1.265428604585419e-17, -9.219523516029186e-19,  2.265012317632202e-01, -5.761277421566440e-03,
  1.286250705177152e-04, -1.902046159961067e-06, -2.056249674929385e-09,  4.827872544573763e-10,  2.805795879213329e-11, -1.784152711182576e-12, -8.151562853362314e-15,
  3.424846021486421e-15, -6.997208562087180e-17, -4.246340177367244e-18,  5.391780348101474e-01, -1.361456720613150e-02,  2.910300294909956e-04, -3.222772480586827e-06,
 -7.613405590357719e-08,  3.435120115201074e-09,  4.657899235972085e-11, -5.686149574429773e-12,  1.137400739607607e-14,  1.083055872632536e-14, -3.045151203878056e-16,
 -1.195173712002404e-17,  1.066459348163041e+00, -2.631152775588551e-02,  4.774364271405146e-04,  2.559493422782789e-06, -6.643391340635077e-07,  2.315815209803195e-08,
  1.337091375345885e-10, -4.346678739693108e-11,  1.417062514588132e-12,  2.137323417137082e-14, -3.200962021544556e-15,  7.935481744835572e-17,  4.985817908971417e-02,
 -1.172282098081818e-03,  2.594874891971617e-05, -4.667716175153783e-07,  3.892237615702245e-09,  9.128904890456281e-11, -1.436012834150220e-12, -1.969083248280257e-13,
  1.002516805579060e-14, -4.086235564105018e-17, -1.392103030359984e-17,  5.151777307268443e-19,  2.053699447478692e-01, -4.823244960782081e-03,  1.059952938530909e-04,
 -1.837407523605668e-06,  1.052855461843231e-08,  6.162016435812863e-10, -1.208235323746141e-11, -7.972385254553332e-13,  4.658076610643371e-14, -2.872869007069036e-16,
 -6.399856264492941e-17,  2.610523628887916e-18,  4.891091526540363e-01, -1.145636509610642e-02,  2.473738671176820e-04, -3.880279710114083e-06, -7.758730918511093e-09,
  2.946902186418706e-09, -6.834969741339937e-11, -1.808970839948493e-12,  1.512181647975454e-13, -1.978038062894840e-15, -1.777415278413261e-16,  9.492504864885417e-18,
  9.688374226929972e-01, -2.251521859036043e-02,  4.593193936364225e-04, -4.509971949323252e-06, -2.407822215197485e-07,  1.690219013868836e-08, -4.648883497546170e-10,
 -2.904526937066475e-12,  8.128655261351932e-13, -3.163110516018422e-14,  1.758747535499752e-16,  3.918026847292200e-17,  4.555040990237078e-02, -9.859186722275385e-04,
  2.077167974298438e-05, -3.930309595784699e-07,  5.097888847797379e-09,  2.279714255819976e-11, -3.194274338780387e-12,  3.558220426268473e-14,  3.637703590318514e-15,
 -1.993259405474991e-16,  2.988793288647305e-18,  1.492576893998113e-19,  1.876383632526139e-01, -4.059806350271992e-03,  8.529882369832086e-05, -1.590925968581108e-06,
  1.892768574683786e-08,  2.049225840032029e-10, -1.737696042231081e-11,  2.431423872549594e-13,  1.504751112719193e-14, -9.248627722428654e-16,  1.598006736905777e-17,
  6.210691712036334e-19,  4.469489083409813e-01, -9.661887263294812e-03,  2.016960170878713e-04, -3.630602783460103e-06,  3.310051570849478e-08,  1.148966963706797e-09,
 -6.753939492485201e-11,  1.222625845002323e-12,  3.448254226481782e-14, -2.877622966098407e-15,  6.725161104112996e-17,  1.197631587479154e-18,  8.857193878200795e-01,
 -1.910084856552985e-02,  3.913006238533277e-04, -6.251638012032180e-06, -9.805963609030172e-09,  6.761478271528528e-09, -3.310022347241324e-10,  8.233500367534025e-12,
  1.355381663667669e-14, -1.104680105692942e-14,  5.027335884220711e-16, -9.545575550197222e-18,  4.191118380548584e-02, -8.372141274351451e-04,  1.654758852561265e-05,
 -3.114823067627834e-07,  4.911397739779468e-09, -3.437291699032945e-11, -1.441962028850909e-12,  6.640802915157489e-14, -7.775328812225875e-16, -4.817300691298847e-17,
  2.994892060865744e-18, -7.170220906280671e-20,  1.726505194240945e-01, -3.448453362078721e-03,  6.809453971070311e-05, -1.275005589865383e-06,  1.957632125447821e-08,
 -1.016483330590339e-10, -7.800447827611906e-12,  3.378985519432113e-13, -4.633904989596280e-15, -1.949132524627598e-16,  1.362999357308758e-17, -3.546415479944488e-19,
  4.112669390932508e-01, -8.212347262726356e-03,  1.618143772872535e-04, -2.992383845179253e-06,  4.295218432895337e-08, -1.283614731497141e-11, -2.958412628848567e-11,
  1.202498568684554e-12, -2.066786585055056e-14, -4.025315001439742e-16,  3.977019468886085e-17, -1.246525503690233e-18,  8.151083950283168e-01, -1.626533614159069e-02,
  3.186124675263954e-04, -5.682572686790331e-06,  6.378683693307626e-08,  1.382724918153729e-09, -1.315241973309607e-10,  5.321992386718666e-12, -1.275173781804517e-13,
  5.470828989381215e-16,  1.103139847631927e-16, -5.815497789727317e-18,  3.880522128573909e-02, -7.185102494000641e-04,  1.325409300452425e-05, -2.397119152517726e-07,
  4.009674525943087e-09, -5.040490411538261e-11, -6.172659897838870e-14,  3.093305991281790e-14, -1.074649199829325e-15,  1.454516510981882e-17,  4.467587396687563e-19,
 -3.400281240466347e-20,  1.598565663347076e-01, -2.959778589612790e-03,  5.458170844804600e-05, -9.853565685950774e-07,  1.633482796798787e-08, -1.955317374600165e-10,
 -8.887980825331571e-13,  1.538628451733616e-13, -5.280348828672881e-15,  7.909566498287166e-17,  1.693801835513410e-18, -1.508025372728007e-19,  3.807953735224466e-01,
 -7.050002768746178e-03,  1.299235941197414e-04, -2.335760549644456e-06,  3.791150719842205e-08, -3.984058140230622e-10, -5.725778085740065e-12,  5.213117414094674e-13,
 -1.779561755886748e-14,  3.155771651275277e-16,  2.593736070655675e-18, -4.093114129960301e-19,  7.547391042612421e-01, -1.397064306226751e-02,  2.570215906287012e-04,
 -4.569436298997376e-06,  6.971757396243546e-08, -4.082589139037750e-10, -3.290825490007273e-11,  2.026671165423354e-12, -7.239793298718708e-14,  1.707023318045490e-15,
 -1.581574872442723e-17, -8.006006102975197e-19,  3.612646718815778e-02, -6.229689822425427e-04,  1.072960219494269e-05, -1.834708972316713e-07,  3.039147016309201e-09,
 -4.482943867735400e-11,  4.131651193668325e-13,  6.214130056839220e-15, -4.760635284080730e-16,  1.445962350483822e-17, -2.229111207602420e-19, -2.538279444509085e-21,
  1.488217508083393e-01, -2.566277699955682e-03,  4.419602202309986e-05, -7.552859371984920e-07,  1.247319628642289e-08, -1.814132905184703e-10,  1.517805326039447e-12,
  3.412257587435854e-14, -2.284625215015785e-15,  6.943584009119243e-17, -1.143120387363560e-18, -7.740762026472987e-21,  3.545103456599243e-01, -6.113052267313178e-03,
  1.052579091541375e-04, -1.796446639406045e-06,  2.946393161344353e-08, -4.144632658550473e-10,  2.599725634397245e-12,  1.292689912783023e-13, -7.313866619284824e-15,
  2.248232642242735e-16, -4.175217562403680e-18,  3.391187887358577e-21,  7.026472993067404e-01, -1.211566042273637e-02,  2.085156493076997e-04, -3.546929729085550e-06,
  5.711938932968660e-08, -7.275359078264203e-10, -4.607522345819016e-13,  5.348470701495892e-13, -2.609696220065873e-14,  8.496266326794421e-16, -1.976425527481941e-17,
  2.522117904486153e-19,  3.379340294091961e-02, -5.451765727559839e-04,  8.791966595992006e-06, -1.414447624759010e-07,  2.248725117103567e-09, -3.412931797292048e-11,
  4.395392824093600e-13, -2.447744047486160e-15, -1.166759510063177e-16,  5.945366273207069e-18, -1.663664519887181e-19,  2.810752796335346e-21,  1.392108183399920e-01,
 -2.245832326394226e-03,  3.621728411026434e-05, -5.825590300588850e-07,  9.252543254116386e-09, -1.397889726948379e-10,  1.762693251006190e-12, -7.708803782785728e-15,
 -5.794296415298144e-16,  2.794805939144099e-17, -7.855456833006183e-19,  1.386959170411373e-20,  3.316162500020035e-01, -5.349807726420884e-03,  8.626892629074407e-05,
 -1.387108212159060e-06,  2.198277200333825e-08, -3.287123448856396e-10,  3.940725041497906e-12, -5.384462330281589e-15, -1.930623655195338e-15,  8.631817891281778e-17,
 -2.464280660184896e-18,  4.741300309303265e-20,  6.572718362032941e-01, -1.060334164992705e-02,  1.709643497178629e-04, -2.746319239553776e-06,  4.328530324839481e-08,
 -6.298803760390050e-10,  6.466140176298356e-12,  5.939027103490867e-14, -6.934134864582095e-15,  2.892693862098934e-16, -8.733721343425428e-18,  1.997439363637414e-19,
  3.174341795063217e-02, -4.810668271118779e-04,  7.289761084232587e-06, -1.103814568549724e-07,  1.664587100212411e-09, -2.466704468536729e-11,  3.431045771963413e-13,
 -3.809982223440275e-15,  5.547928947036695e-18,  1.532550427857753e-18, -6.321547516947569e-20,  1.666263792693155e-21,  1.307659821599772e-01, -1.981738222861293e-03,
  3.002973564895872e-05, -4.546871009542618e-07,  6.854745455548482e-09, -1.014285161156787e-10,  1.401857882586892e-12, -1.509561013623496e-14, -3.628257830728567e-18,
  7.316946711725288e-18, -2.930577612041365e-19,  7.765284837448156e-21,  3.114997256039768e-01, -4.720725108421811e-03,  7.153329513344533e-05, -1.082985136730982e-06,
  1.631602152006305e-08, -2.406396565678878e-10,  3.278420375444403e-12, -3.275718281286980e-14, -1.521347329450387e-16,  2.296403724243247e-17, -8.822018378447666e-19,
  2.374054012146612e-20,  6.174006088885480e-01, -9.356577871138694e-03,  1.417761858104364e-04, -2.145886482390607e-06,  3.227797219007246e-08, -4.722200770553846e-10,
  6.194852164169263e-12, -4.856472027331649e-14, -1.059165191540459e-15,  7.594491693070731e-17, -2.814747183748779e-18,  7.961955311226995e-20,  2.992799104341930e-02,
 -4.276290445969441e-04,  6.110055878524195e-06, -8.728278536514597e-08,  1.245216888097525e-09, -1.765598339606072e-11,  2.444403676294782e-13, -3.117567876823111e-15,
  2.939591573539376e-17,  9.853627752744272e-20, -1.635721469135430e-20,  5.871568298765539e-22,  1.232873918785250e-01, -1.761603828269474e-03,  2.517013681606019e-05,
 -3.595532197732738e-07,  5.129101828796549e-09, -7.269220411039467e-11,  1.004345227904432e-12, -1.270186678678314e-14,  1.146000959743075e-16,  6.656187051664900e-19,
 -7.643941017671749e-20,  2.694165135220841e-21,  2.936848672165574e-01, -4.196343634336878e-03,  5.995797873088014e-05, -8.564700748111069e-07,  1.221541102361388e-08,
 -1.729498040560246e-10,  2.378862257806329e-12, -2.951861165930815e-14,  2.385453872836282e-16,  2.980990007755325e-18, -2.315330760283150e-19,  7.952074891053010e-21,
  5.820911405044881e-01, -8.317259101987837e-03,  1.188373634746868e-04, -1.697421390928086e-06,  2.419876125285356e-08, -3.417970608514626e-10,  4.649805897617553e-12,
 -5.489133494988742e-14,  2.999254902436289e-16,  1.312468512164893e-17, -7.241137437661824e-19,  2.437689633099225e-20,  2.830904748638519e-02, -3.826243780164539e-04,
  5.171506370397897e-06, -6.989328292218068e-08,  9.442425189471313e-10, -1.273080948597185e-11,  1.701904863373979e-13, -2.206459795237379e-15,  2.582995623387952e-17,
 -2.030490396815925e-19, -1.862767501732580e-21,  1.496325158863492e-22,  1.166182066326869e-01, -1.576208725531242e-03,  2.130384527581482e-05, -2.879220277040901e-07,
  3.889667295687757e-09, -5.243549656014308e-11,  7.005280421334807e-13, -9.058129616204726e-15,  1.049139320359102e-16, -7.744406814540281e-19, -9.942181541092264e-21,
  6.897244094017859e-22,  2.777980965040617e-01, -3.754711835589252e-03,  5.074818998061842e-05, -6.858581709953574e-07,  9.265086107411637e-09, -1.248633493625460e-10,
  1.665837202138531e-12, -2.141576984656993e-14,  2.421417817948723e-16, -1.518227571307785e-18, -3.577590310889164e-20,  2.039548317805522e-21,  5.506031518200553e-01,
 -7.441936997007828e-03,  1.005840706356131e-04, -1.359364465914855e-06,  1.836115125752012e-08, -2.472807558622864e-10,  3.288250944854983e-12, -4.168191153422703e-14,
  4.424299914971373e-16, -1.397196447354821e-18, -1.322459121724045e-19,  6.120906872436009e-21,  2.685632096020580e-02, -3.443683774164632e-04,  4.415697263285773e-06,
 -5.661981830138250e-08,  7.259208092770527e-10, -9.301220873452406e-12,  1.188377981304617e-13, -1.501694271733882e-15,  1.827630773771261e-17, -1.967442376887120e-19,
  1.262155251925025e-21,  2.073294499717339e-23,  1.106337467179883e-01, -1.418614399836078e-03,  1.819032066087062e-05, -2.332432971555942e-07,  2.990385451227364e-09,
 -3.831431370123254e-11,  4.894307680315075e-13, -6.179523529676035e-15,  7.496318345300593e-17, -7.965397394793911e-19,  4.670991314685912e-21,  1.032345907169402e-22,
  2.635424191642262e-01, -3.379304034529114e-03,  4.333144618276392e-05, -5.556115178326039e-07,  7.123335462698814e-09, -9.126024825884008e-11,  1.165284445421087e-12,
 -1.468638346202835e-14,  1.768985045782673e-16, -1.825207283121432e-18,  8.362375642058751e-21,  3.402192400986141e-22,  5.223480252200843e-01, -6.697869557910512e-03,
  8.588403503952276e-05, -1.101231983741425e-06,  1.411815441412357e-08, -1.808404620681470e-10,  2.306923109733895e-12, -2.895275566988733e-14,  3.428063691566507e-16,
 -3.273923159734883e-18,  3.140275641433421e-21,  1.144104934649014e-21,  2.554545680162141e-02, -3.115762976175650e-04,  3.800274631049870e-06, -4.635150349751199e-08,
  5.653267623218567e-10, -6.893763201659077e-12,  8.398915991363504e-14, -1.019440286047767e-15,  1.220690899980639e-17, -1.398347922280879e-19,  1.388226796424681e-21,
 -7.106382641309347e-24,  1.052336841740924e-01, -1.283528492668055e-03,  1.565510829234623e-05, -1.909434800704353e-07,  2.328841073690633e-09, -2.839828555601876e-11,
  3.459669496038655e-13, -4.198186622803933e-15,  5.021783316648811e-17, -5.730558047595385e-19,  5.602298822871747e-21, -2.521720974646623e-23,  2.506788438070783e-01,
 -3.057513763981585e-03,  3.729228260954194e-05, -4.548493158249619e-07,  5.547548422256207e-09, -6.764626714341323e-11,  8.240145886097676e-13, -9.993681577786871e-15,
  1.192787657576450e-16, -1.349802985454095e-18,  1.274524436964445e-20, -3.897715421775190e-23,  4.968520799385014e-01, -6.060072890686603e-03,  7.391428136640398e-05,
 -9.015224588635592e-07,  1.099529534578924e-08, -1.340690421131686e-10,  1.632691986034293e-12, -1.977684611049508e-14,  2.348404930465132e-16, -2.604788670143465e-18,
  2.244312693591529e-20,  2.376408407061907e-23,  2.435663740255006e-02, -2.832550159749313e-04,  3.294108116114509e-06, -3.830872242890999e-08,  4.455065308589591e-10,
 -5.180700601087792e-12,  6.022908418564487e-14, -6.993593956803539e-16,  8.082842097267742e-18, -9.193251157107896e-20,  9.941215581054283e-22, -9.139763851349072e-24,
  1.003363810614951e-01, -1.166859888920248e-03,  1.356997192872298e-05, -1.578115368793345e-07,  1.835248952161604e-09, -2.134166141185518e-11,  2.481071330967088e-13,
 -2.880717177176523e-15,  3.328322506724700e-17, -3.780964306171714e-19,  4.070691019777027e-21, -3.677332659258023e-23,  2.390128996736282e-01, -2.779595621088453e-03,
  3.232524710698720e-05, -3.759253501988379e-07,  4.371771906711808e-09, -5.083797966305931e-11,  5.909969240880103e-13, -6.860846571415972e-15,  7.921524451293947e-17,
 -8.975527361314999e-19,  9.571890503035213e-21, -8.310009251192742e-23,  4.737298710437232e-01, -5.509231826577437e-03,  6.406949117947241e-05, -7.450937966637248e-07,
  8.664950117598455e-09, -1.007607786142588e-10,  1.171271211285696e-12, -1.359241824084691e-14,  1.566987497988839e-16, -1.764938107473351e-18,  1.840101416959948e-20,
 -1.438352485090686e-22,  2.327357290284065e-02, -2.586271873974286e-04,  2.873990212968841e-06, -3.193715998888435e-08,  3.549003657793962e-10, -3.943762229253899e-12,
  4.382094117123592e-14, -4.867352272485629e-16,  5.398091401555705e-18, -5.953419033122535e-20,  6.447054238504701e-22, -6.601391057068812e-24,  9.587473183841508e-02,
 -1.065406344795030e-03,  1.183930984237924e-05, -1.315640975664920e-07,  1.462000442101748e-09, -1.624618840708223e-11,  1.805180666028191e-13, -2.005037528883815e-15,
  2.223455512070500e-17, -2.451260173980319e-19,  2.650846853456050e-21, -2.701197616645655e-23,  2.283847336326530e-01, -2.537921510480254e-03,  2.820260946875497e-05,
 -3.134009360786176e-07,  3.482653917171959e-09, -3.870024298906462e-11,  4.300106069965558e-13, -4.775971632552971e-15,  5.295180189526660e-17, -5.833020993039923e-19,
  6.289474273529924e-21, -6.342265513729500e-23,  4.526645656468649e-01, -5.030227369818726e-03,  5.589831559595220e-05, -6.211688917685114e-07,  6.902708791507788e-09,
 -7.670463693328853e-11,  8.522736608443133e-13, -9.464977198868048e-15,  1.048930392478895e-16, -1.153402112068246e-18,  1.235369980399059e-20, -1.215330887470964e-22,
  2.228274959214767e-02, -2.370773614030554e-04,  2.522385077204866e-06, -2.683691984724061e-08,  2.855313127435970e-10, -3.037898790867958e-12,  3.232092201665946e-14,
 -3.438330008894656e-16,  3.655990412797948e-18, -3.880254186324288e-20,  4.091979863977700e-22, -4.228624492087745e-24,  9.179306721363883e-02, -9.766325327095413e-04,
  1.039088385084183e-05, -1.105538242187521e-07,  1.176236992453499e-09, -1.251452359252242e-11,  1.331448287224114e-13, -1.416399002820890e-15,  1.506021538393436e-17,
 -1.598218816825094e-19,  1.684691766049581e-21, -1.738309433822708e-23,  2.186617349844459e-01, -2.326451991670558e-03,  2.475229076655886e-05, -2.633520333304374e-07,
  2.801932835706450e-09, -2.981103550832735e-11,  3.171656163281912e-13, -3.373977826539892e-15,  3.587261526740392e-17, -3.805954552800289e-19,  4.008213064483692e-21,
 -4.122511256430456e-23,  4.333933258865446e-01, -4.611089206898272e-03,  4.905969309790451e-05, -5.219706706557426e-07,  5.553504218213001e-09, -5.908621048191657e-11,
  6.286271911892610e-13, -6.687105005835505e-15,  7.108946776363991e-17, -7.538358824891254e-19,  7.922875506971697e-21, -8.089809393307125e-23,  2.137286258413768e-02,
 -2.181131475434870e-04,  2.225876150242516e-06, -2.271538710202011e-08,  2.318137749693195e-10, -2.365690680389809e-12,  2.414205705847570e-14, -2.463641653740266e-16,
  2.513735039182035e-18, -2.563350824958451e-20,  2.608337368211988e-22, -2.635011941683883e-24,  8.804481707344416e-02, -8.985100662650380e-04,  9.169424904958086e-06,
 -9.357530341467447e-08,  9.549493534142617e-10, -9.745385918333916e-12,  9.945239386625854e-14, -1.014887378126919e-15,  1.035515294967028e-17, -1.055918654071755e-19,
  1.074306477306095e-21, -1.084770682722570e-23,  2.097329683174008e-01, -2.140355213674798e-03,  2.184263386380927e-05, -2.229072281462013e-07,  2.274800118935420e-09,
 -2.321463773748387e-11,  2.369069914768016e-13, -2.417570456634262e-15,  2.466669788073442e-17, -2.515096877594056e-19,  2.558184296918939e-21, -2.580501393537403e-23,
  4.156962748588641e-01, -4.242240484799157e-03,  4.329267640556121e-05, -4.418080043832839e-07,  4.508713733260832e-09, -4.601201566969403e-11,  4.695552881711247e-13,
 -4.791650585101056e-15,  4.888802634417126e-17, -4.984034454723114e-19,  5.066355024668545e-21, -5.099223307307907e-23,  2.053438216278818e-02, -2.013368259098467e-04,
  1.974080210376955e-06, -1.935558807729046e-08,  1.897789047001969e-10, -1.860755919725116e-12,  1.824442868808619e-14, -1.788823979551349e-16,  1.753829849790028e-18,
 -1.719217165787098e-20,  1.684128802124398e-22, -1.645624587129815e-24,  8.459072406055473e-02, -8.294005511705081e-04,  8.132159663943133e-06, -7.973471989206414e-08,
  7.817880671784282e-10, -7.665323832388234e-12,  7.515732919621198e-14, -7.368999244883916e-16,  7.224827501947946e-18, -7.082175079558065e-20,  6.937357412228451e-22,
 -6.777737574796038e-24,  2.015049180525897e-01, -1.975728331355094e-03,  1.937174772823880e-05, -1.899373527402473e-07,  1.862309866693252e-09, -1.825969024988133e-11,
  1.790334505087298e-13, -1.755379474204748e-15,  1.721028988393859e-17, -1.687014909047329e-19,  1.652383762072698e-21, -1.613865153825030e-23,  3.993880622213316e-01,
 -3.915945662074287e-03,  3.839531492118990e-05, -3.764608425199342e-07,  3.691147256272851e-09, -3.619118615269740e-11,  3.548489112328362e-13, -3.479201644614106e-15,
  3.411088387944522e-17, -3.343534256665655e-19,  3.274326069423678e-21, -3.195860181311752e-23,  1.975921844888456e-02, -1.864243143900817e-04,  1.758876500322950e-06,
 -1.659465157123608e-08,  1.565672513795807e-10, -1.477180938959408e-12,  1.393690405780546e-14, -1.314915991815264e-16,  1.240580335043197e-18, -1.170387164753472e-20,
  1.103932679765371e-22, -1.040345224470588e-24,  8.139746217886093e-02, -7.679689416380980e-04,  7.245634931487386e-06, -6.836113114023113e-08,  6.449737347913773e-10,
 -6.085199151668722e-12,  5.741262512794582e-14, -5.416753353775486e-16,  5.110527377521987e-18, -4.821356687766141e-20,  4.547549199531609e-22, -4.285414998057466e-24,
  1.938981978012022e-01, -1.829391110790402e-03,  1.725994297033294e-05, -1.628441449200957e-07,  1.536402258702245e-09, -1.449565025597975e-11,  1.367635287605230e-13,
 -1.290333196920137e-15,  1.217385336037267e-17, -1.148495587110421e-19,  1.083246851009590e-21, -1.020711378897720e-23,  3.843113420577747e-01, -3.625901431312302e-03,
  3.420966219362815e-05, -3.227613901770007e-07,  3.045189795945720e-09, -2.873076086223929e-11,  2.710689018872557e-13, -2.557473233109689e-15,  2.412883358691564e-17,
 -2.276317379453944e-19,  2.146889585242471e-21, -2.022554132270640e-23,  1.904045932489173e-02, -1.731093925156031e-04,  1.573851831280002e-06, -1.430892657265099e-08,
  1.300919027645479e-10, -1.182751402494852e-12,  1.075317319519029e-14, -9.776413841217666e-17,  8.888351743688720e-19, -8.080842908357059e-21,  7.346239396244735e-23,
 -6.676242006993153e-25,  7.843655718343999e-02, -7.131185510472303e-04,  6.483431783656570e-06, -5.894516083850048e-08,  5.359093914525204e-10, -4.872306197431675e-12,
  4.429734947925038e-14, -4.027361997507118e-16,  3.661527213571095e-18, -3.328874361054208e-20,  3.026247656807012e-22, -2.750209919838320e-24,  1.868449786085556e-01,
 -1.698731117228486e-03,  1.544428664931844e-05, -1.404142113236470e-07,  1.276598340972000e-09, -1.160639858551059e-11,  1.055214245556428e-13, -9.593642977694085e-16,
  8.722179806482381e-18, -7.929751486986222e-20,  7.208815075717078e-22, -6.551093141174048e-24,  3.703316755910836e-01, -3.366929877949126e-03,  3.061098347806057e-05,
 -2.783046702279735e-07,  2.530251581246574e-09, -2.300418806680581e-11,  2.091462432406092e-13, -1.901485132755299e-15,  1.728757903723931e-17, -1.571692148865866e-19,
  1.428782241540572e-21, -1.298350026972702e-23,  1.837216360015717e-02, -1.611717324218029e-04,  1.413895929578164e-06, -1.240355035955755e-08,  1.088114466287681e-10,
 -9.545598271356519e-13,  8.373976026038085e-15, -7.346157174162964e-17,  6.444487533124130e-19, -5.653467145587302e-21,  4.959451719300911e-23, -4.349982210635141e-25,
  7.568353453129927e-02, -6.639417458763797e-04,  5.824498613161258e-06, -5.109602507238055e-08,  4.482452397807612e-10, -3.932278375265014e-12,  3.449632373066526e-14,
 -3.026225701236899e-16,  2.654785721982083e-18, -2.328927038509941e-20,  2.043027985789432e-22, -1.791952764433887e-24,  1.802869592739602e-01, -1.581586262327560e-03,
  1.387463139459841e-05, -1.217166593542310e-07,  1.067772161909397e-09, -9.367143270178776e-12,  8.217424489051789e-14, -7.208820602482229e-16,  6.324007082320645e-18,
 -5.547772017236882e-20,  4.866719384550417e-22, -4.268598907595919e-24,  3.573335083038190e-01, -3.134745685869776e-03,  2.749988536397304e-05, -2.412456290853143e-07,
  2.116352587036675e-09, -1.856592500976847e-11,  1.628715201272855e-13, -1.428807220568705e-15,  1.253434685677381e-17, -1.099582083984970e-19,  9.645924132508234e-22,
 -8.460309319525502e-24,  1.774919629150040e-02, -1.504277219853521e-04,  1.274902771374047e-06, -1.080503683096261e-08,  9.157468595497315e-11, -7.761124033360206e-13,
  6.577696156619484e-15, -5.574718967039769e-17,  4.724676370812733e-19, -4.004245617198436e-21,  3.393651418525626e-23, -2.875897794505523e-25,  7.311724082508647e-02,
 -6.196821419141775e-04,  5.251920787408540e-06, -4.451100022323950e-08,  3.772389609350281e-10, -3.197169977099028e-12,  2.709660685297461e-14, -2.296487468954548e-16,
  1.946315152627426e-18, -1.649535962370647e-20,  1.398003365079036e-22, -1.184715324458345e-24,  1.741737499509249e-01, -1.476154751148404e-03,  1.251068458910301e-05,
 -1.060303662373113e-07,  8.986269683035937e-10, -7.616029787691687e-12,  6.454726096733397e-14, -5.470499550410657e-16,  4.636348400436663e-18, -3.929385612412084e-20,
  3.330204393909527e-22, -2.822122197168583e-24,  3.452169661912174e-01, -2.925777649983339e-03,  2.479650682173458e-05, -2.101549824062382e-07,  1.781102352221376e-09,
 -1.509517190874993e-11,  1.279343735580707e-13, -1.084267433066776e-15,  9.189364473465791e-18, -7.788144260407965e-20,  6.600545640965597e-22, -5.593491559213690e-24,
  1.716709634157846e-02, -1.407233597479347e-04,  1.153547669606933e-06, -9.455944119283717e-09,  7.751294683505348e-11, -6.353947158027820e-13,  5.208503365402452e-15,
 -4.269551891141553e-17,  3.499867661636875e-19, -2.868935840207110e-21,  2.351740943153047e-23, -1.927642065918047e-25,  7.071929888316911e-02, -5.797053351273311e-04,
  4.752002365439915e-06, -3.895345637308071e-08,  3.193120808243247e-10, -2.617488008534695e-12,  2.145626137862681e-14, -1.758828110384798e-16,  1.441759175630158e-18,
 -1.181848837874983e-20,  9.687920201402668e-23, -7.940856631051583e-25,  1.684615740608706e-01, -1.380925359686745e-03,  1.131982091261242e-05, -9.279165205754035e-08,
  7.606384198058786e-10, -6.235160090143557e-12,  5.111130373315404e-14, -4.189732597358740e-16,  3.434437599872999e-18, -2.815300966755046e-20,  2.307774668799627e-22,
 -1.891602925648535e-24,  3.338952829199394e-01, -2.737030484455285e-03,  2.243618360620352e-05, -1.839155017343139e-07,  1.507605409698218e-09, -1.235825174921152e-11,
  1.013039520305036e-13, -8.304160500744203e-16,  6.807145847842352e-18, -5.580000485515647e-20,  4.574069006754924e-22, -3.749201867462861e-24,  1.662196955841791e-02,
 -1.319287037903401e-04,  1.047119164947848e-06, -8.310993090202397e-09,  6.596441785941575e-11, -5.235601060176711e-13,  4.155500699403304e-15, -3.298224183730703e-17,
  2.617803107352888e-19, -2.077752232374722e-21,  1.649112892523732e-23, -1.308817120296073e-25,  6.847366670749469e-02, -5.434760339767682e-04,  4.313573578129783e-06,
 -3.423686759061618e-08,  2.717382887259414e-10, -2.156788945784478e-12,  1.711845090867526e-14, -1.358692799154771e-16,  1.078395534072974e-18, -8.559233184614987e-21,
  6.793467182233259e-23, -5.391629402991021e-25,  1.631122177034099e-01, -1.294622961397532e-03,  1.027543267926924e-05, -8.155619040789736e-08,  6.473121280090477e-10,
 -5.137721477181574e-12,  4.077813596928306e-14, -3.236563868623139e-16,  2.568863264000944e-18, -2.038908627854799e-20,  1.618282640060131e-22, -1.284348457254842e-24,
  3.232927175315348e-01, -2.565976854842198e-03,  2.036617858224267e-05, -1.616465204122882e-07,  1.282989710406743e-09, -1.018309947383852e-11,  8.082334100139870e-14,
 -6.414954949427716e-16,  5.091554732685975e-18, -4.041170628171492e-20,  3.207478661259268e-22, -2.545611658328662e-24  };
  constexpr double w[1536] = {  5.330565315787104e-02, -5.725700631895237e-03,  4.327690947643411e-04, -2.735356204516888e-05,  1.528603139360458e-06,
 -7.766091732541141e-08,  3.647194732909942e-09, -1.600845048296128e-10,  6.616927499132635e-12, -2.589853603118810e-13,  9.639032972581570e-15, -3.417453776195249e-16,
  1.359532044695186e-01, -2.649064635399328e-02,  3.250223532983477e-03, -3.052215827427357e-04,  2.374332961231276e-05, -1.595341017065699e-06,  9.498194505601250e-08,
 -5.097129169840624e-09,  2.495745616527642e-10, -1.125176927076223e-11,  4.703877640141090e-13, -1.831555126335759e-14,  1.463540138620439e-01, -4.443562901671851e-02,
  7.618772520520277e-03, -9.341889159310328e-04,  9.029243086589573e-05, -7.251056956189271e-06,  4.999961482885049e-07, -3.027633820051677e-08,  1.636447373186813e-09,
 -7.993862385056299e-11,  3.563821126671371e-12, -1.459624154231441e-13,  7.795248698638596e-02, -2.999199445663223e-02,  6.219702660064232e-03, -8.872710473646053e-04,
  9.680361887198013e-05, -8.569636035893115e-06,  6.391939770523569e-07, -4.123167764502821e-08,  2.344569396921933e-09, -1.192559175781545e-10,  5.489029247684678e-12,
 -2.304468424227157e-13,  3.571104349591302e-02, -3.254018966540718e-03,  2.120967546611684e-04, -1.174823214125771e-05,  5.825152610436830e-07, -2.652626408189274e-08,
  1.125871271157102e-09, -4.499378232216463e-11,  1.705368881461580e-12, -6.156620543397590e-14,  2.125677900426105e-15, -7.036883642580413e-17,  6.550034106613563e-02,
 -1.048996504322867e-02,  1.113330843892045e-03, -9.278569809289608e-05,  6.519470074081793e-06, -4.010841816755477e-07,  2.210846304752115e-08, -1.108768833876037e-09,
  5.114593468792181e-11, -2.187698610993137e-12,  8.731027091520189e-14, -3.263446709804670e-15,  4.364983399676855e-02, -1.164555007044222e-02,  1.812951100544633e-03,
 -2.058463489998791e-04,  1.868545028729196e-05, -1.424398906654983e-06,  9.401721366687888e-08, -5.486162785049257e-09,  2.873217974864718e-10, -1.366115777249621e-11,
  5.950410772528764e-13, -2.388705272501605e-14,  1.508493197751607e-02, -5.572446301912780e-03,  1.117394074173308e-03, -1.551106446472234e-04,  1.654746330038425e-05,
 -1.437690445351164e-06,  1.055477647604608e-07, -6.716600229163658e-09,  3.774660757528522e-10, -1.900368214538388e-11,  8.668209832184599e-13, -3.610217119358593e-14,
  2.537604653997398e-02, -1.995249718406888e-03,  1.133369651477477e-04, -5.542911040678967e-06,  2.450708388806475e-07, -1.003924029268006e-08,  3.862339171990799e-10,
 -1.405528593630559e-11,  4.885227959116933e-13, -1.627523405197618e-14,  5.199288721250087e-16, -1.600486301707095e-17,  3.618679799577340e-02, -4.727612299415922e-03,
  4.319677982141279e-04, -3.178697026874296e-05,  2.005768365383326e-06, -1.122681951307554e-07,  5.691103542807998e-09, -2.649071825605112e-10,  1.143180392960479e-11,
 -4.606928944152038e-13,  1.743393247775806e-14, -6.214784935143196e-16,  1.550979442780254e-02, -3.508278137617107e-03,  4.858410206713166e-04, -5.025568518956243e-05,
  4.227060253326733e-06, -3.023903095161138e-07,  1.891776238512571e-08, -1.054765013347547e-09,  5.313077053646034e-11, -2.443085891877571e-12,  1.033887913210254e-13,
 -4.048334595413698e-15,  3.190006525499363e-03, -1.108817218834673e-03,  2.121135893187153e-04, -2.837206544122875e-05,  2.937774396344709e-06, -2.490674729943695e-07,
  1.791562692745449e-08, -1.120563271884719e-09,  6.205190456549522e-11, -3.084456615731991e-12,  1.391377837286845e-13, -5.738765548698195e-15,  1.886460803321839e-02,
 -1.300497575042795e-03,  6.505256337069372e-05, -2.832184792228385e-06,  1.123678822130561e-07, -4.151530465164915e-09,  1.457083857568915e-10, -4.842484894453345e-12,
  1.537870330446560e-13, -4.749067997934374e-15,  1.408159304393873e-16, -4.009916650021892e-18,  2.236565926893010e-02, -2.384569689278564e-03,  1.875701151665818e-04,
 -1.217229605989620e-05,  6.881107368994277e-07, -3.492464862438926e-08,  1.620819499458217e-09, -6.968703305922593e-11,  2.799010587897804e-12, -1.056558029397279e-13,
  3.768801857589520e-15, -1.273955590335106e-16,  6.602303486992918e-03, -1.222152941235193e-03,  1.479731963255043e-04, -1.373765437786355e-05,  1.056957490387855e-06,
 -7.015652821637733e-08,  4.117727362516998e-09, -2.173848962909495e-10,  1.044752078252606e-11, -4.612729626403923e-13,  1.884547844527513e-14, -7.157471563878880e-16,
  7.631271717805832e-04, -2.416917745417180e-04,  4.327926352159374e-05, -5.502752918833682e-06,  5.474595963771060e-07, -4.494083453879948e-08,  3.147991219374769e-09,
 -1.925836242796802e-10,  1.046659980191568e-11, -5.120100341771830e-13,  2.277971593150582e-14, -9.283566192815072e-16,  1.452435953936235e-02, -8.907280226769700e-04,
  3.962349081281088e-05, -1.546334830978343e-06,  5.564646690129087e-08, -1.851702899716898e-09,  5.944650906732651e-11, -1.839134594860537e-12,  5.277424074965900e-14,
 -1.494676823656055e-15,  4.250445090967762e-17, -1.096892359984663e-18,  1.511166244830165e-02, -1.323151003473666e-03,  8.990186816901906e-05, -5.154839542181352e-06,
  2.610265363860615e-07, -1.201211350471235e-08,  5.092966943394465e-10, -2.014987157816239e-11,  7.513789127854776e-13, -2.647407793550054e-14,  8.851020678908621e-16,
 -2.824844341340516e-17,  3.336531645342583e-03, -4.901030092654873e-04,  5.131605650103459e-05, -4.227036559276163e-06,  2.941586390048616e-07, -1.794248564460072e-08,
  9.786180753816993e-10, -4.847647237463572e-11,  2.205105598005525e-12, -9.278125213935290e-14,  3.634154676418257e-15, -1.330692542162276e-16,  2.158617820305492e-04,
 -5.926228113853942e-05,  9.692432579659330e-06, -1.150530526829121e-06,  1.085189346708767e-07, -8.537908402049614e-09,  5.777312176960663e-10, -3.434858929055242e-11,
  1.822701931779127e-12, -8.737632086385657e-14,  3.820720007682696e-15, -1.534057980131950e-16,  1.149610207525834e-02, -6.352141717562230e-04,  2.539774939763383e-05,
 -8.893584345478573e-07,  2.951995689846848e-08, -8.920614228953522e-10,  2.539308142233952e-11, -7.585543956403969e-13,  2.071613861144118e-14, -4.728338396508636e-16,
  1.353807849432700e-17, -3.951504668500470e-19,  1.094635408540060e-02, -7.950995854983246e-04,  4.689860976489296e-05, -2.388456340147731e-06,  1.083489172651122e-07,
 -4.527798891511656e-09,  1.759728187150522e-10, -6.379439221670348e-12,  2.198860283159059e-13, -7.263518937211155e-15,  2.266551002307362e-16, -6.746864256883790e-18,
  1.961133794221912e-03, -2.232638027699326e-04,  2.013693045295797e-05, -1.464748803056890e-06,  9.125545652733487e-08, -5.079080337523750e-09,  2.557806991835831e-10,
 -1.177978582941757e-11,  5.032667072387331e-13, -2.006114361471099e-14,  7.474067819474886e-16, -2.620093487826733e-17,  7.565043619192810e-05, -1.675959450173934e-05,
  2.436809334907721e-06, -2.643266591869353e-07,  2.324035414543730e-08, -1.730403074507104e-09,  1.119661499936520e-10, -6.415935036536356e-12,  3.302406803882355e-13,
 -1.543003160252804e-14,  6.601059794437237e-16, -2.601600730076367e-17,  9.303799196161490e-03, -4.678637395891288e-04,  1.706099943989400e-05, -5.327009888409465e-07,
  1.638419257340594e-08, -4.753473915280744e-10,  1.144431779967580e-11, -2.933058230312247e-13,  9.880482058397123e-15, -2.104435232655198e-16,  1.320865923541033e-18,
 -1.436577275673405e-19,  8.368911870786739e-03, -5.107296781575957e-04,  2.625638788615755e-05, -1.198856934043218e-06,  4.883084286741288e-08, -1.843713810420244e-09,
  6.632626509286293e-11, -2.225624128494584e-12,  6.938299032439216e-14, -2.133716736932423e-15,  6.496769389992189e-17, -1.768513455997917e-18,  1.305992536137038e-03,
 -1.136563499535293e-04,  8.805828106033354e-06, -5.700672553318516e-07,  3.152205016628246e-08, -1.584346071200222e-09,  7.379682496961270e-11, -3.146283218606389e-12,
  1.243421812444213e-13, -4.681936389722089e-15,  1.665041050051334e-16, -5.485781292247343e-18,  3.387622784807779e-05, -5.547408731668366e-06,  7.002491973387831e-07,
 -6.807978834460288e-08,  5.466452522056694e-09, -3.794391606344141e-10,  2.321886427776529e-11, -1.268973841333515e-12,  6.279972847703341e-14, -2.842770886639206e-15,
  1.183285222847871e-16, -4.551154007320711e-18,  7.670281868276093e-03, -3.531260203654133e-04,  1.196980788832781e-05, -3.339232823903441e-07,  9.114297206915492e-09,
 -2.703277362399484e-10,  6.552536395175336e-12, -9.397610720997647e-14,  2.721489277749845e-15, -1.771137773051308e-16,  2.608706590636123e-18,  1.449319829441173e-19,
  6.670636716731172e-03, -3.472717983743341e-04,  1.557247174255449e-05, -6.435012267957247e-07,  2.387746474437569e-08, -8.050404673720304e-10,  2.638959586842533e-11,
 -8.552023627857555e-13,  2.496195819268889e-14, -6.381718048047459e-16,  1.799636376062344e-17, -5.972844903836245e-19,  9.585032992581359e-04, -6.390357234636389e-05,
  4.191228644565024e-06, -2.464631086097145e-07,  1.220964563408409e-08, -5.400212306073442e-10,  2.307214888734963e-11, -9.372798352822199e-13,  3.406434300650556e-14,
 -1.144267725134919e-15,  3.944283156561642e-17, -1.327245795458089e-18,  1.924566008862179e-05, -2.153192840011783e-06,  2.304281553312684e-07, -1.999780896775486e-08,
  1.438247114911893e-09, -9.103199875875041e-11,  5.213760740490942e-12, -2.699473078164503e-13,  1.267198103075419e-14, -5.489708814679529e-16,  2.221895548308772e-17,
 -8.327494284453428e-19,  6.426939791491122e-03, -2.712761278702948e-04,  8.684798240857239e-06, -2.235861901498926e-07,  5.096598203891978e-09, -1.396983421103146e-10,
  4.387813332552488e-12, -7.856186412377032e-14, -6.368978604108541e-16,  3.207934404884255e-18,  4.311958299458167e-18, -1.152206059801683e-19,  5.489597858009583e-03,
 -2.481201461190485e-04,  9.703988821287902e-06, -3.626056213270642e-07,  1.256156530566030e-08, -3.861014163748122e-10,  1.092090344059064e-11, -3.253996031781700e-13,
  1.027110249232826e-14, -2.662529059877849e-16,  4.374022978220746e-18, -8.527518309822098e-20,  7.550250329899798e-04, -3.954503256698787e-05,  2.126909749958999e-06,
 -1.145325651101464e-07,  5.327845877258392e-09, -2.075515712163982e-10,  7.534703032106396e-12, -2.903620611132347e-13,  1.098321304865491e-14, -3.377264846661164e-16,
  8.443074335424851e-18, -2.692761746187804e-19,  1.321305945200152e-05, -9.827280514731098e-07,  8.501963019546864e-08, -6.682978609436807e-09,  4.336849768175787e-10,
 -2.432171273515061e-11,  1.263751337009380e-12, -6.210122244538674e-14,  2.797979319495211e-15, -1.133329070502270e-16,  4.271290563649234e-18, -1.578484573743485e-19,
  5.465518778309587e-03, -2.113226195118698e-04,  6.415249484908559e-06, -1.594492679598889e-07,  3.169457881937660e-09, -6.209332683531708e-11,  2.086512100450166e-12,
 -7.621697846033657e-14,  1.037085618395273e-15,  4.774614266586498e-17, -1.656609145646477e-18, -6.845433176477828e-20,  4.628973564456074e-03, -1.849839382871954e-04,
  6.342853357781035e-06, -2.116880897654404e-07,  6.880926023217005e-09, -2.039565439434469e-10,  5.185948241454820e-12, -1.202839518321979e-13,  3.403978838337257e-15,
 -1.208823664764839e-16,  3.262620478009396e-18, -2.458352504204576e-20,  6.238675590327994e-04, -2.684104946129595e-05,  1.152727295712957e-06, -5.484427941289704e-08,
  2.491261402171295e-09, -9.389458662049312e-11,  2.866197592628436e-12, -8.387540520219012e-14,  3.137453890035726e-15, -1.271273285827979e-16,  3.640968280077281e-18,
 -4.474190190968663e-20,  1.026297483037832e-05, -5.339884524117632e-07,  3.448003147460715e-08, -2.435626177958518e-09,  1.494164959445549e-10, -7.596512222168900e-12,
  3.399727575287952e-13, -1.480329356462743e-14,  6.510906134872074e-16, -2.686347815612032e-17,  9.518901779345415e-19, -2.907638778653179e-20,  4.711865049924188e-03,
 -1.668720742400282e-04,  4.772171917572839e-06, -1.165950080438558e-07,  2.279687373103272e-09, -3.282008117269300e-11,  5.686955683338079e-13, -3.051505957417065e-14,
  1.380414750126652e-15, -2.252806961883427e-17, -9.307321602291104e-19,  5.633494360696875e-20,  3.976718020299325e-03, -1.428015454643865e-04,  4.347768009542955e-06,
 -1.284306964926455e-07,  3.823223873616971e-09, -1.107922774709783e-10,  2.851133864299338e-12, -5.889088748143050e-14,  9.990092824614322e-16, -2.625492146679895e-17,
  1.295729332451828e-18, -4.737215747409411e-20,  5.315738657470778e-04, -1.969586616461725e-05,  6.821032496188389e-07, -2.690916866339391e-08,  1.155054756260632e-09,
 -4.526691440270346e-11,  1.412035028138386e-12, -3.271891676231700e-14,  6.656707337216135e-16, -2.537364671949299e-17,  1.384793504046058e-18, -4.972680357133678e-20,
  8.538687595035631e-06, -3.436440705231344e-07,  1.571519023655674e-08, -9.249285705835197e-10,  5.467189066098500e-11, -2.738346455897597e-12,  1.125947016620998e-13,
 -4.022068912486447e-15,  1.443115279069941e-16, -5.845920394306883e-18,  2.414439400636694e-19, -8.348695374008723e-21,  4.112684611078324e-03, -1.337173689992631e-04,
  3.572020803305393e-06, -8.484157626007203e-08,  1.712603435346868e-09, -2.532959731843637e-11,  1.846961989390151e-13, -2.288231549171321e-15,  3.931994831308239e-16,
 -2.253900070263619e-17,  5.335158458866251e-19,  6.275990724705300e-21,  3.466588796207367e-03, -1.132909569609565e-04,  3.111155311486686e-06, -8.177204718597813e-08,
  2.174060292366245e-09, -5.914497320923719e-11,  1.558501232908968e-12, -3.547031118747749e-14,  5.848413777427070e-16, -4.888402049788089e-18,  6.061996319352752e-20,
 -9.624828468697576e-21,  4.620251423346881e-04, -1.527474704359209e-05,  4.454024516856809e-07, -1.410570219826080e-08,  5.243416690806459e-10, -2.052046270713966e-11,
  7.114378661352909e-13, -1.896014197394039e-14,  3.244387738687289e-16, -2.265247972954080e-18,  6.801176695405468e-20, -1.074326558130559e-20,  7.361773156276256e-06,
 -2.508157068944922e-07,  8.446472310499288e-09, -3.723495585653870e-10,  1.987125141427197e-11, -1.008365963435052e-12,  4.288085224282885e-14, -1.473276425693177e-15,
  4.181222467723531e-17, -1.144438313943532e-18,  4.084300741032258e-20, -1.828665153292135e-21,  3.629128316422019e-03, -1.087847394382459e-04,  2.702378521742373e-06,
 -6.125614383301817e-08,  1.249861541789947e-09, -2.084425160714682e-11,  2.043841311124252e-13,  1.401569036666778e-15, -4.919861506785673e-17, -3.847031089199895e-18,
  2.944324515271304e-19, -9.254664738373811e-21,  3.057719854249177e-03, -9.181365406622388e-05,  2.305312466879716e-06, -5.471965323172702e-08,  1.295010492683128e-09,
 -3.170324647466549e-11,  8.013274792642616e-13, -1.955720564895600e-14,  4.045647200175872e-16, -5.448746197075492e-18, -7.749584621998049e-21,  1.991979275008950e-21,
  4.071473823551708e-04, -1.227195756533973e-05,  3.154880707463550e-07, -8.232097408617601e-09,  2.474369034890794e-10, -8.715084826068892e-12,  3.140543268438284e-13,
 -9.884274245359354e-15,  2.355796748621516e-16, -3.146488572639134e-18, -2.444875054091741e-20,  1.812467011189837e-21,  6.471349315053260e-06, -1.969411656968407e-07,
  5.368862600436503e-09, -1.715382907258649e-10,  7.305048143038370e-12, -3.528132108635602e-13,  1.574667574446722e-14, -5.886296645383916e-16,  1.759629255572253e-17,
 -4.067638001305480e-19,  7.549613933115000e-21, -1.835902992624732e-22,  3.233012365232715e-03, -8.979594595810375e-05,  2.074424125998718e-06, -4.431776666525747e-08,
  8.839822498376390e-10, -1.571074743898655e-11,  2.128176657497347e-13, -8.162309211685689e-16, -5.873571903744834e-17,  1.513378104960178e-18,  2.214048867711680e-20,
 -2.939119065754297e-21,  2.723632837051239e-03, -7.568768041699804e-05,  1.755007890336465e-06, -3.818924830857065e-08,  8.157052913718861e-10, -1.775899876901216e-11,
  4.059997132729147e-13, -9.649909049325607e-15,  2.217459461206018e-16, -4.305708719452875e-18,  5.177279624728604e-20,  3.838463967892234e-22,  3.625621230240314e-04,
 -1.008688679939277e-05,  2.358082370363308e-07, -5.338142169691148e-09,  1.300368906274101e-10, -3.754632735669861e-12,  1.253444984341725e-13, -4.196811095137866e-15,
  1.225919458917007e-16, -2.737709678937598e-18,  3.349635437588978e-20,  4.491168591672545e-22,  5.758686664789992e-06, -1.606637178256290e-07,  3.832447815735502e-09,
 -9.518818256472412e-11,  2.971035120298977e-12, -1.207785864073561e-13,  5.297474532819101e-15, -2.121973339507471e-16,  7.172595406514984e-18, -1.944862508628457e-19,
  3.919335918350113e-21, -4.827053724214173e-23,  2.903961390384476e-03, -7.510949170679923e-05,  1.617974093022882e-06, -3.242118223338044e-08,  6.181148804526362e-10,
 -1.103804851348632e-11,  1.719935415615066e-13, -1.826647695103932e-15, -7.818115166709201e-18,  1.022946644283804e-18, -2.529824803076987e-20,  4.736404988309152e-23,
  2.446341340053353e-03, -6.328278686039612e-05,  1.364818622220430e-06, -2.752911190395768e-08,  5.396686670245757e-10, -1.058415899550188e-11,  2.147522874396853e-13,
 -4.627261593104485e-15,  1.043104514979969e-16, -2.285679030324594e-18,  4.282522896358444e-20, -5.127149836650261e-22,  3.256253486612613e-04, -8.426096544450025e-06,
  1.821931481240687e-07, -3.727893274841897e-09,  7.744849489276916e-11, -1.794526810883219e-12,  4.988554289509462e-14, -1.577398966458357e-15,  4.942996518287818e-17,
 -1.361203609803111e-18,  2.941856010331436e-20, -3.788851721917447e-22,  5.171061753654878e-06, -1.339121414662228e-07,  2.913514374032447e-09, -6.169481690075643e-11,
  1.455797048044136e-12, -4.448967250454752e-14,  1.708961747128936e-15, -6.847389580289930e-17,  2.500128045794552e-18, -7.798677540448152e-20,  1.980605711516711e-21,
 -3.752923473043183e-23,  2.627163964385669e-03, -6.356919625633237e-05,  1.281652401622766e-06, -2.409068089258210e-08,  4.344634484700905e-10, -7.524834155898042e-12,
  1.215758483693600e-13, -1.666547781446784e-15,  1.302811053040680e-17,  2.213988359399776e-19, -1.306845242091197e-20,  3.180392740734184e-22,  2.213143154575966e-03,
 -5.355330811088436e-05,  1.080093104210883e-06, -2.034597364408973e-08,  3.706975960396835e-10, -6.672997298131916e-12,  1.216479068703432e-13, -2.319886246017978e-15,
  4.739731570343536e-17, -1.019102490236822e-18,  2.147151195809063e-20, -3.948669750022353e-22,  2.945793318783328e-04, -7.128792578966116e-06,  1.438854059863320e-07,
 -2.723098718859212e-09,  5.071146405094282e-11, -9.865261727532497e-13,  2.192235352713901e-14, -5.858267082595467e-16,  1.753661424261087e-17, -5.170837760698190e-19,
  1.355062717991805e-20, -2.877366749735672e-22,  4.677825440714414e-06, -1.132252232704124e-07,  2.289336157586455e-09, -4.380959617444061e-11,  8.583212755425567e-13,
 -1.956252051778694e-14,  5.816722225811346e-16, -2.098664851319994e-17,  7.730482165712748e-19, -2.602436611422753e-20,  7.591719997757362e-22, -1.840115338813493e-23,
  2.391715686021876e-03, -5.436463851781432e-05,  1.029778701759892e-06, -1.819965834079226e-08,  3.096288476231449e-10, -5.115483904727684e-12,  8.137175898193107e-14,
 -1.198688410823726e-15,  1.449091051132971e-17, -7.403958045737541e-20, -3.066446584154618e-21,  1.367401464049266e-22,  2.014795270853856e-03, -4.579755109191246e-05,
  8.675842884267086e-07, -1.534324674876852e-08,  2.619326523579151e-10, -4.390277828401177e-12,  7.341520179466053e-14, -1.254240180638245e-15,  2.260977687388187e-17,
 -4.396962485467198e-19,  9.048018476533616e-21, -1.840729728551164e-22,  2.681770736894209e-04, -6.095962065198592e-06,  1.155051074271412e-07, -2.045596942182875e-09,
  3.518021307300784e-11, -6.078260376337603e-13,  1.119609389194339e-14, -2.393011068885221e-16,  6.131352917877622e-18, -1.737492015981358e-19,  4.839392086601425e-21,
 -1.212526787206941e-22,  4.258519991529932e-06, -9.680555899344361e-08,  1.835120154933021e-09, -3.260676674471876e-11,  5.704989527822036e-13, -1.054897958536403e-14,
  2.334396244915618e-16, -6.701218372360695e-18,  2.265191305375346e-19, -7.716792969997431e-21,  2.415483222255396e-22, -6.641850197237313e-24,  2.189459866918587e-03,
 -4.692291256701567e-05,  8.380456732917370e-07, -1.396847207493448e-08,  2.243878421719428e-10, -3.515985852740221e-12,  5.378694607422303e-14, -7.919614756438810e-16,
  1.070684235004975e-17, -1.144850283837759e-19,  2.878010940886723e-22,  3.218311252487842e-23,  1.844412830003045e-03, -3.952821208564410e-05,  7.059939354747072e-07,
 -1.176967038761243e-08,  1.892705634967698e-10, -2.980454393286035e-12,  4.646473112088403e-14, -7.274866099189406e-16,  1.171474071914359e-17, -2.003869773942913e-19,
  3.717996678522105e-21, -7.333012057241188e-23,  2.454982402602871e-04, -5.261379795669374e-06,  9.397596869573004e-08, -1.567307969660072e-09,  2.526221330579208e-11,
 -4.020207641910716e-13,  6.517431339531244e-15, -1.143858646995438e-16,  2.351900481181271e-18, -5.763409262369762e-20,  1.546689886976324e-21, -4.079110969428713e-23,
  3.898381660166246e-06, -8.354887015652536e-08,  1.492485698734512e-09, -2.491400475233573e-11,  4.036938809714645e-13, -6.580996274466602e-15,  1.160644911988821e-16,
 -2.493105612847178e-18,  6.863977824015220e-20, -2.173092441686089e-21,  6.883458440965308e-23, -2.014972394377281e-24,  2.014194993988543e-03, -4.083292373085031e-05,
  6.898528588806729e-07, -1.087757664541146e-08,  1.653652150592863e-10, -2.456158733478865e-12,  3.581672687151297e-14, -5.111384853709387e-16,  7.010014464064788e-18,
 -8.751058825767285e-20,  8.314598186357304e-22, -8.518980166650812e-26,  1.696768554060843e-03, -3.439789138613127e-05,  5.811397752150502e-07, -9.163864017419570e-09,
  1.393570031287551e-10, -2.073151683545881e-12,  3.043213003417512e-14, -4.446015378942754e-16,  6.554819412062756e-18, -9.990626928226653e-20,  1.625810954158471e-21,
 -2.880794309833825e-23,  2.258461798261752e-04, -4.578492221566268e-06,  7.735298811804243e-08, -1.219894056736675e-09,  1.856368508800826e-11, -2.770954834032553e-13,
  4.124640380527532e-15, -6.319904338291987e-17,  1.060424298640775e-18, -2.095130331592170e-20,  4.900748993015481e-22, -1.245657704871161e-23,  3.586315429847179e-06,
 -7.270417430012430e-08,  1.228363252315445e-09, -1.937655137537328e-11,  2.953084954227751e-13, -4.441808275185408e-15,  6.821576310258984e-17, -1.153725022382215e-18,
  2.399196516499172e-20, -6.304567841401571e-22,  1.871255425382337e-23, -5.533632904511821e-25,  1.861133181923238e-03, -3.579469755120850e-05,  5.737149501043102e-07,
 -8.582458636559485e-09,  1.237982681322445e-10, -1.745636733217193e-12,  2.421654589272586e-14, -3.309899601919978e-16,  4.431782017763594e-18, -5.691673742628419e-20,
  6.600822705038116e-22, -5.615091710582637e-24,  1.567828430799973e-03, -3.015364633927634e-05,  4.833013212528404e-07, -7.230017505918803e-09,  1.042991769539798e-10,
 -1.471392909508120e-12,  2.045624188147303e-14, -2.819293241926304e-16,  3.881315767210722e-18, -5.411751996264940e-20,  7.831271341072585e-22, -1.214122590206487e-23,
  2.086837606345977e-04, -4.013562884488602e-06,  6.432941765936010e-08, -9.623722889339440e-10,  1.388563286806732e-11, -1.960885373176535e-13,  2.738604248081680e-15,
 -3.840515015986013e-17,  5.588629924219985e-19, -8.979339511863009e-21,  1.702066295845501e-22, -3.792782087392647e-24,  3.313785091975540e-06, -6.373324145214193e-08,
  1.021524048903813e-09, -1.528299990569906e-11,  2.206024380084432e-13, -3.122311331309888e-15,  4.405457027248204e-17, -6.418379064168376e-19,  1.043500725436071e-20,
 -2.093622633003276e-22,  5.234101291453460e-24, -1.457789763189090e-25,  1.726525845008186e-03, -3.158572559322599e-05,  4.815522855086154e-07, -6.852295111014013e-09,
  9.402223123481762e-11, -1.261349973165175e-12,  1.665977320540052e-14, -2.173412349200461e-16,  2.799244224839716e-18, -3.533090980474955e-20,  4.269578447801924e-22,
 -4.628423539505645e-24,  1.454434490660540e-03, -2.660798281905172e-05,  4.056623479304177e-07, -5.772431182871386e-09,  7.920700831759779e-11, -1.062743568171192e-12,
  1.404596394741479e-14, -1.837489016146921e-16,  2.390304900819478e-18, -3.114267433988516e-20,  4.120550003767224e-22, -5.673039182577350e-24,  1.935906057816183e-04,
 -3.541621053615749e-06,  5.399520138120749e-08, -7.683378684921962e-10,  1.054334944355521e-11, -1.415038933148913e-13,  1.872830617559116e-15, -2.464273247450213e-17,
  3.272509462002906e-19, -4.537345629418703e-21,  6.984743872791180e-23, -1.267563865269116e-24,  3.074113893305353e-06, -5.623902972715231e-08,  8.574160137982496e-10,
 -1.220099209456643e-11,  1.674434935829487e-13, -2.248703366371083e-15,  2.985421317916355e-17, -3.978974535220064e-19,  5.524230461787768e-21, -8.638756457682400e-23,
  1.666671229181251e-24, -3.953595353140371e-26,  1.607400747657367e-03, -2.803842911970683e-05,  4.075835125250760e-07, -5.529932012055752e-09,  7.234837156414302e-11,
 -9.254867092156928e-13,  1.165841121967729e-14, -1.451878632118270e-16,  1.790275548843002e-18, -2.182090239237779e-20,  2.606645033060377e-22, -2.976902162209245e-24,
  1.354082877945123e-03, -2.361972089500171e-05,  3.433505337285867e-07, -4.658448107665406e-09,  6.094707853323658e-11, -7.796698363856412e-13,  9.823467819156349e-15,
 -1.224426219609122e-16,  1.514889693321237e-18, -1.867771047633108e-20,  2.310943163459942e-22, -2.908906210658895e-24,  1.802334348460131e-04, -3.143872172938705e-06,
  4.570123314367141e-08, -6.200578009781216e-10,  8.112398970435245e-12, -1.037865697271268e-13,  1.308193427923091e-15, -1.633528347956168e-17,  2.035252549744118e-19,
 -2.569209228933054e-21,  3.401623053814303e-23, -5.015067091906734e-25,  2.862009244393884e-06, -4.992298717352406e-08,  7.257110867549827e-10, -9.846220301436403e-12,
  1.288244927017220e-13, -1.648404416480039e-15,  2.079599046928443e-17, -2.607120003008601e-19,  3.298488513769791e-21, -4.376708086246825e-23,  6.580654826283844e-25,
 -1.216611453073292e-26,  1.501374136224453e-03, -2.502483338815515e-05,  3.476046807451098e-07, -4.506507729186270e-09,  5.633798941384124e-11, -6.886541249561547e-13,
  8.290081766367917e-15, -9.868776452610868e-17,  1.164439290673742e-18, -1.362576264271075e-20,  1.577317527372751e-22, -1.789414437941936e-24,  1.264765500294338e-03,
 -2.108105181542912e-05,  2.928240242909044e-07, -3.796306699984762e-09,  4.745950191687596e-11, -5.801326574628364e-13,  6.984073338743849e-15, -8.316218649812401e-17,
  9.823012268492857e-19, -1.153957471334092e-20,  1.353040845241914e-22, -1.594095088029557e-24,  1.683449617441145e-04, -2.805965904124695e-06,  3.897596124925182e-08,
 -5.053026657099200e-10,  6.317057495838096e-12, -7.721965873008638e-14,  9.297336979225026e-16, -1.107667197041519e-17,  1.311281351812817e-19, -1.552999169027833e-21,
  1.869012418330337e-23, -2.366048505612364e-25,  2.673226733425217e-06, -4.455721769360786e-08,  6.189171872791127e-10, -8.023939587459383e-12,  1.003122000919766e-13,
 -1.226269077951754e-15,  1.476801494713164e-17, -1.761482762973234e-19,  2.095420506746049e-21, -2.525741434995723e-23,  3.208951035205677e-25, -4.633211071536992e-27,
  1.406514319829910e-03, -2.244596527641916e-05,  2.985131439968224e-07, -3.705343451167047e-09,  4.435068746688032e-11, -5.190538815784617e-13,  5.982614837090475e-15,
 -6.819541434636719e-17,  7.707582476388071e-19, -8.649327924762809e-21,  9.636364698423120e-23, -1.062580984053542e-24,  1.184855090006602e-03, -1.890859967781009e-05,
  2.514690498323574e-07, -3.121401036592728e-09,  3.736126876232330e-11, -4.372550210188983e-13,  5.039875737524239e-15, -5.745345750479756e-17,  6.495619022627064e-19,
 -7.298517829707309e-21,  8.167353985397501e-23, -9.131695530089700e-25,  1.577085908293891e-04, -2.516804490658116e-06,  3.347146006142618e-08, -4.154700522888357e-10,
  4.972927124143979e-12, -5.820061029498228e-14,  6.708505028062514e-16, -7.648714881515196e-18,  8.653368779413257e-20, -9.748529154430613e-22,  1.100884395000251e-23,
 -1.265820937359855e-25,  2.504326928751314e-06, -3.996549099826092e-08,  5.315086502712740e-10, -6.597440519714947e-12,  7.896752583590584e-14, -9.242058552706572e-16,
  1.065356242087569e-17, -1.215064237287506e-19,  1.376653049456978e-21, -1.559693243368985e-23,  1.796038060797745e-25, -2.186969705720091e-27,  1.321241113550624e-03,
 -2.022439453188371e-05,  2.579877228444119e-07, -3.071582261211127e-09,  3.526404328036282e-11, -3.958609345201589e-13,  4.376451024591387e-15, -4.785181526290209e-17,
  5.188249228965804e-19, -5.587489516724148e-21,  5.981912884379317e-23, -6.362504792377403e-25,  1.113020490748990e-03, -1.703713674762664e-05,  2.173302201967424e-07,
 -2.587517143089752e-09,  2.970661912364386e-11, -3.334755823584413e-13,  3.686762312824712e-15, -4.031162888613957e-17,  4.371131902618999e-19, -4.709332974734781e-21,
  5.049048406605224e-23, -5.396217795849730e-25,  1.481471402179121e-04, -2.267705857982949e-06,  2.892745545120524e-08, -3.444081005705112e-10,  3.954061549928296e-12,
 -4.438689748341515e-14,  4.907262656389204e-16, -5.365901104401607e-18,  5.819568792802025e-20, -6.274888085822749e-22,  6.747617537357394e-24, -7.283323269752348e-26,
  2.352496276204574e-06, -3.600993971075810e-08,  4.593523126848751e-10, -5.469014171087470e-12,  6.278837919888960e-14, -7.048420200950336e-16,  7.792619010765053e-18,
 -8.521676561161234e-20,  9.245973763736712e-22, -9.986534943113577e-24,  1.080768625114139e-25, -1.191325854665887e-27,  1.244250690925920e-03, -1.829890364160741e-05,
  2.242701334211353e-07, -2.565412450984077e-09,  2.829760805855913e-11, -3.051988591109800e-13,  3.241795282649207e-15, -3.405558834797288e-17,  3.547736988947234e-19,
 -3.671495839945355e-21,  3.778797497514468e-23, -3.869284324826382e-25,  1.048163352187213e-03, -1.541509305352390e-05,  1.889263446661316e-07, -2.161117000013175e-09,
  2.383805497106831e-11, -2.571011746863888e-13,  2.730908587245411e-15, -2.868879585474033e-17,  2.988731342541373e-19, -3.093347081959295e-21,  3.185188072613285e-23,
 -3.266658056658884e-25,  1.395144154109246e-04, -2.051805848223777e-06,  2.514679461598603e-08, -2.876526598963955e-10,  3.172933344056516e-12, -3.422112831248349e-14,
  3.634948680269991e-16, -3.818635782020003e-18,  3.978380815985091e-20, -4.118612437793576e-22,  4.244827164797692e-24, -4.367690625590297e-26,  2.215413286048037e-06,
 -3.258156458847558e-08,  3.993174667360794e-10, -4.567768345113487e-12,  5.038446599385779e-14, -5.434133551077905e-16,  5.772129153011640e-18, -6.063955189451313e-20,
  6.318347022175108e-22, -6.544327066272468e-24,  6.758167716126274e-26, -7.002426357656090e-28,  1.174458714550344e-03, -1.662062338127238e-05,  1.960131829672300e-07,
 -2.157557835308953e-09,  2.290057092294086e-11, -2.376680543873410e-13,  2.429209414671725e-15, -2.455613898249098e-17,  2.461611452440062e-19, -2.451457326324920e-21,
  2.428344078891580e-23, -2.394265067191127e-25,  9.893702227580057e-04, -1.400130090007872e-05,  1.651225403671907e-07, -1.817538114118399e-09,  1.929156196306014e-11,
 -2.002128319908308e-13,  2.046379407476812e-15, -2.068625579578853e-17,  2.073692861646797e-19, -2.065206807543982e-21,  2.046011960995837e-23, -2.018314421664080e-25,
  1.316888326279864e-04, -1.863624888236447e-06,  2.197842029499306e-08, -2.419210394946995e-10,  2.567778209538628e-12, -2.664906991920399e-14,  2.723808141048858e-16,
 -2.753426427815772e-18,  2.760211499179363e-20, -2.749100310281316e-22,  2.724302345276397e-24, -2.690197894787783e-26,  2.091147273695817e-06, -2.959335295550404e-08,
  3.490053998478781e-10, -3.841574969367092e-12,  4.077492677974761e-14, -4.231728532100546e-16,  4.325264647793412e-18, -4.372322437602074e-20,  4.383229529315939e-22,
 -4.366195356516694e-24,  4.329323082705128e-26, -4.284449886423347e-28,  1.110956799672471e-03, -1.515019351253683e-05,  1.721737414597541e-07, -1.826226642681904e-09,
  1.867880385939957e-11, -1.868030912196929e-13,  1.839876702468522e-15, -1.792233461639346e-17,  1.731274202824471e-19, -1.661450722647174e-21,  1.586022533588617e-23,
 -1.507224942450539e-25,  9.358758743488312e-04, -1.276260301416302e-05,  1.450400689542959e-07, -1.538422967169255e-09,  1.573512301936833e-11, -1.573639118651628e-13,
  1.549921951763548e-15, -1.509787559395943e-17,  1.458437886794398e-19, -1.399630752554608e-21,  1.336141151259761e-23, -1.269952474043897e-25,  1.245685371792556e-04,
 -1.698749622305650e-06,  1.930536913866962e-08, -2.047697818416986e-10,  2.094403023628309e-12, -2.094571855027459e-14,  2.063003665284089e-16, -2.009584716114332e-18,
  1.941243749637222e-20, -1.863003113688531e-22,  1.778635549672364e-24, -1.691054306906635e-26,  1.978080841877364e-06, -2.697522311110395e-08,  3.065587965020106e-10,
 -3.251633131365127e-12,  3.325798478121196e-14, -3.326066681317204e-16,  3.275938867909109e-18, -3.191117043843746e-20,  3.082619232830381e-22, -2.958488240225069e-24,
  2.824976989193961e-26, -2.687623454893659e-28,  1.052978829222157e-03, -1.385565098199257e-05,  1.519362279719490e-07, -1.555015101160280e-09,  1.534668043916596e-11,
 -1.480931153182536e-13,  1.407423975844447e-15, -1.322867260551662e-17,  1.233029029820123e-19, -1.141778993802761e-21,  1.051711906038686e-23, -9.644557145971624e-26,
  8.870349258941607e-04, -1.167207355071616e-05,  1.279918807289674e-07, -1.309952932357600e-09,  1.292812464157210e-11, -1.247544225871958e-13,  1.185621407168541e-15,
 -1.114390477673967e-17,  1.038710769765455e-19, -9.618435369255082e-22,  8.859799987307617e-24, -8.125102913008225e-26,  1.180676264599988e-04, -1.553596120931337e-06,
  1.703619228817916e-08, -1.743595759187614e-10,  1.720781163325354e-12, -1.660527471302545e-14,  1.578105953099009e-16, -1.483295204956837e-18,  1.382564035673179e-20,
 -1.280257031773046e-22,  1.179305321492483e-24, -1.081609981127440e-26,  1.874849903795283e-06, -2.467026419687110e-08,  2.705254982281973e-10, -2.768735545591400e-12,
  2.732507206352209e-14, -2.636827628610251e-16,  2.505946859197174e-18, -2.355393338205748e-20,  2.195441960503929e-22, -2.033003863561288e-24,  1.872781136304843e-26,
 -1.717959986136833e-28,  9.998746344353066e-04, -1.271084135810033e-05,  1.346572057820149e-07, -1.331446206530404e-09,  1.269475032068452e-11, -1.183491805388738e-13,
  1.086615735787941e-15, -9.867064713887255e-18,  8.885170071867791e-20, -7.948690761384190e-22,  7.073479299930802e-24, -6.266862179077551e-26,  8.422996717939226e-04,
 -1.070767987848719e-05,  1.134359411957339e-07, -1.121617314964467e-09,  1.069412470410138e-11, -9.969797466159894e-14,  9.153708367819488e-16, -8.312067614863134e-18,
  7.484915258939465e-20, -6.696024228774086e-22,  5.958758555577938e-24, -5.279324521414268e-26,  1.121131988309218e-04, -1.425231759473409e-06,  1.509874294830379e-08,
 -1.492914092890707e-10,  1.423427515805257e-12, -1.327016884886018e-14,  1.218392417525329e-16, -1.106366967419845e-18,  9.962701659040808e-21, -8.912669476089268e-23,
  7.931387431192093e-25, -7.027209005625986e-27,  1.780296820937174e-06, -2.263190772315664e-08,  2.397598529998256e-10, -2.370666648765032e-12,  2.260325731596060e-14,
 -2.107230879361128e-16,  1.934741136869679e-18, -1.756850935946712e-20,  1.582023931789858e-22, -1.415288030855460e-24,  1.259480577609681e-26, -1.115958316312057e-28,
  9.510892430504534e-04, -1.169421128661740e-05,  1.198247832907357e-07, -1.145937597936478e-09,  1.056773094755160e-11, -9.528906248697012e-14,  8.462018879149571e-16,
 -7.432008061675015e-18,  6.472978283757591e-20, -5.600854770051478e-22,  4.820727173737393e-24, -4.130992464408568e-26,  8.012026004845704e-04, -9.851265338048694e-06,
  1.009410301678176e-07, -9.653438835200743e-10,  8.902312352230155e-12, -8.027200941165451e-14,  7.128449392218019e-16, -6.260762869675907e-18,  5.452871274512120e-20,
 -4.718190544421192e-22,  4.061009983203598e-24, -3.479985408322457e-26,  1.066430267753386e-04, -1.311239819467771e-06,  1.343562411855311e-08, -1.284908380920668e-10,
  1.184930670451241e-12, -1.068450108052172e-14,  9.488229570283315e-17, -8.333306822402600e-19,  7.257973664531024e-21, -6.280088390851350e-23,  5.405364911528358e-25,
 -4.632030745756201e-27,  1.693433454071501e-06, -2.082177751082845e-08,  2.133504275588882e-10, -2.040364854102166e-12,  1.881605669726933e-14, -1.696640851596877e-16,
  1.506679424728528e-18, -1.323283977542384e-20,  1.152527031479507e-22, -9.972447662174210e-25,  8.583460277403222e-27, -7.355547486008791e-29,  9.061463788503948e-04,
 -1.078788160748161e-05,  1.070285341821981e-07, -9.910634733638131e-10,  8.849317544750280e-12, -7.726069195795248e-14,  6.643195356854187e-16, -5.649326736716914e-18,
  4.764114144188013e-20, -3.991350147601777e-22,  3.326332805000601e-24, -2.759927478616168e-26,  7.633424943657991e-04, -9.087768430554552e-06,  9.016140234936999e-08,
 -8.348771031809065e-10,  7.454711827715856e-12, -6.508481487461210e-14,  5.596262848339654e-16, -4.759022679710294e-18,  4.013314944212353e-20, -3.362334599420155e-22,
  2.802121014572695e-24, -2.324980231031696e-26,  1.016037067480454e-04, -1.209615559761742e-06,  1.200081582240358e-08, -1.111252275202532e-10,  9.922496913612072e-13,
 -8.663029365375581e-15,  7.448832650025229e-17, -6.334435060628351e-19,  5.341870579679046e-21, -4.475392021022420e-23,  3.729728464449196e-25, -3.094641926590341e-27,
  1.613411783850450e-06, -1.920803935714679e-08,  1.905664496247142e-10, -1.764608372103488e-12,  1.575638720097277e-14, -1.375642101097407e-16,  1.182834245529700e-18,
 -1.005873953641280e-20,  8.482601171180554e-23, -7.106681255816148e-25,  5.922612489687230e-27, -4.914147001899122e-29  };
  int offset = -4;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 4;
    if (std::isnan(t)) {
      fill_n(rr+offset, 4, 0.5);
      fill_n(ww+offset, 4, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 4; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=4; ++j) {
        const int boxof = it*48+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
