/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.yes_common;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import yuku.alkitabconverter.util.Rec;
import yuku.alkitabconverter.yes1.Yes1File;

public class Yes1Common {
    public static final String TAG = Yes1Common.class.getSimpleName();
    public static final Charset ascii = Charset.forName("ascii");

    public static Yes1File.Teks teks(List<Rec> xrec, String _encoding) {
        final ArrayList<String> ss = new ArrayList<String>();
        for (Rec rec : xrec) {
            ss.add(rec.text);
        }
        return new Yes1File.Teks(_encoding){
            {
                super(encoding);
                this.xisi = ss.toArray(new String[ss.size()]);
            }
        };
    }

    public static Yes1File.InfoEdisi infoEdisi(final String _nama, final String _shortName, final String _longName, final int _nkitab, final int _perikopAda, final String _keterangan, final int _encoding, final String _locale) {
        return new Yes1File.InfoEdisi(){
            {
                this.versi = 1;
                this.nama = _nama;
                this.shortName = _shortName;
                this.longName = _longName;
                this.nkitab = _nkitab;
                this.perikopAda = _perikopAda;
                this.keterangan = _keterangan;
                this.encoding = _encoding;
                this.locale = _locale;
            }
        };
    }

    public static Yes1File.InfoKitab infoKitab(List<Rec> xrec, String _namafileInputKitab, String _encoding, int _encodingYes) throws Exception {
        ArrayList<String> xnamaKitab = new ArrayList<String>();
        Scanner sc = new Scanner(new File(_namafileInputKitab));
        while (sc.hasNextLine()) {
            String judul = sc.nextLine().trim();
            judul = judul.replace('_', ' ');
            System.out.println("kitabPos " + xnamaKitab.size() + " judul: " + judul);
            xnamaKitab.add(judul);
        }
        sc.close();
        return Yes1Common.infoKitab(xrec, _encoding, xnamaKitab);
    }

    public static Yes1File.InfoKitab infoKitab(List<Rec> xrec, String _encoding, List<String> xnamaKitab) throws Exception {
        ArrayList<Integer> xkitab_1 = new ArrayList<Integer>();
        for (Rec rec : xrec) {
            if (xkitab_1.contains(rec.book_1)) continue;
            xkitab_1.add(rec.book_1);
        }
        System.out.println("Total ada " + xkitab_1.size() + " kitab");
        final Yes1File.Kitab[] xkitab_ = new Yes1File.Kitab[xkitab_1.size()];
        int offsetTotal = 0;
        int offsetLewat = 0;
        int maxpasal_1 = 1;
        int lastpasal_1 = 1;
        int[] xnayat = new int[256];
        int[] xpasal_offset = new int[256];
        for (int kitabIndex = 0; kitabIndex < xkitab_1.size(); ++kitabIndex) {
            int kitabPos = (Integer)xkitab_1.get(kitabIndex) - 1;
            Arrays.fill(xpasal_offset, 0);
            for (Rec rec : xrec) {
                if (kitabPos + 1 != rec.book_1) continue;
                int n = rec.chapter_1 - 1;
                xnayat[n] = xnayat[n] + 1;
                if (rec.chapter_1 > maxpasal_1) {
                    maxpasal_1 = rec.chapter_1;
                }
                if (rec.chapter_1 != lastpasal_1) {
                    xpasal_offset[lastpasal_1] = offsetLewat;
                    lastpasal_1 = rec.chapter_1;
                }
                offsetLewat += rec.text.getBytes(_encoding).length + 1;
            }
            xpasal_offset[maxpasal_1] = offsetLewat;
            System.out.println("kitabIndex " + kitabIndex + ", kitabPos " + kitabPos + ":");
            Yes1File.Kitab kitab = new Yes1File.Kitab();
            kitab.versi = 1;
            kitab.pos = kitabPos;
            kitab.nama = xnamaKitab.get(kitabPos);
            kitab.judul = xnamaKitab.get(kitabPos);
            kitab.npasal = maxpasal_1;
            kitab.nayat = new int[kitab.npasal];
            System.arraycopy(xnayat, 0, kitab.nayat, 0, kitab.npasal);
            System.out.println("kitab " + kitab.judul + " nayat: " + Arrays.toString(kitab.nayat));
            kitab.ayatLoncat = 0;
            kitab.pasal_offset = new int[kitab.npasal + 1];
            System.arraycopy(xpasal_offset, 0, kitab.pasal_offset, 0, kitab.npasal + 1);
            System.out.println("kitab " + kitab.judul + " pasal_offset: " + Arrays.toString(kitab.pasal_offset));
            kitab.offset = offsetTotal;
            System.out.println("kitab " + kitab.judul + " offset: " + kitab.offset);
            xkitab_[kitabIndex] = kitab;
            offsetTotal += offsetLewat;
            offsetLewat = 0;
            for (int i = 0; i < xnayat.length; ++i) {
                xnayat[i] = 0;
            }
            maxpasal_1 = 1;
            lastpasal_1 = 0;
        }
        return new Yes1File.InfoKitab(){
            {
                this.xkitab = xkitab_;
            }
        };
    }

    public static Yes1File bikinYesFile(final Yes1File.InfoEdisi infoEdisi, final Yes1File.InfoKitab infoKitab, final Yes1File.Teks teks, final Yes1File.PerikopBlok perikopBlok, final Yes1File.PerikopIndex perikopIndex) {
        return new Yes1File(){
            {
                this.xseksi = new Yes1File.Seksi[]{new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "infoEdisi___".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return infoEdisi;
                    }
                }, new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "infoKitab___".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return infoKitab;
                    }
                }, new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "teks________".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return teks;
                    }
                }, new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "perikopBlok_".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return perikopBlok;
                    }
                }, new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "perikopIndex".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return perikopIndex;
                    }
                }};
            }
        };
    }

    public static Yes1File bikinYesFile(final Yes1File.InfoEdisi infoEdisi, final Yes1File.InfoKitab infoKitab, final Yes1File.Teks teks) {
        return new Yes1File(){
            {
                this.xseksi = new Yes1File.Seksi[]{new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "infoEdisi___".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return infoEdisi;
                    }
                }, new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "infoKitab___".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return infoKitab;
                    }
                }, new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "teks________".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return teks;
                    }
                }};
            }
        };
    }
}

