/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-12-04 16:09
 */
 
#ifndef NEWTASKWINDOW_H_
#define NEWTASKWINDOW_H_

#include <string>
#include <gtk/gtk.h>
#include "BitStorm.h"

class CNewTaskWindow
{
public:
	CNewTaskWindow();
	virtual ~CNewTaskWindow();
private:
	IBTTask* _task;
	
	GtkWidget* _dialog;
	GtkWidget* _downloadToEntry;
	GtkListStore* _store;
	GtkWidget* _view;
	GtkWidget* _selectedSizeLabel;
	GtkWidget* _encodingComboBox;
private:
	void createWindow();
	void createFileList();
	std::string getUserInputDestPath(const char* fileName);
	void updateSelectedSize();
	void updateEncoding();
	
	static void toggle_event(GtkCellRendererToggle*cell_renderer, gchar *path, gpointer user_data);
	static void select_dir_event(GtkWidget* widget, gpointer data);
	static void encoding_changed(GtkComboBox *widget, gpointer user_data);
    static void select_all_cb (GtkWidget *widget, gpointer data);
    static void unselect_all_cb (GtkWidget *widget, gpointer data);
    static void reverse_selected_cb (GtkWidget *widget, gpointer data);

public:
	bool show(IBTTask* task);
    GtkListStore *get_store (void) { return _store; }
};

#endif /*NEWTASKWINDOW_H_*/
