/*
 * BndPluginConvention for Gradle.
 *
 * Adds bnd and bndUnprocessed methods to projects that apply
 * the bnd plugin.
 */

package aQute.bnd.gradle

import org.gradle.api.Project

class BndPluginConvention {
  private final Project project
  BndPluginConvention(BndPlugin plugin) {
   this.project = plugin.project
  }
  String bnd(String name) {
    return project.bnd.get(name)
  }
  Object bnd(String name, Object defaultValue) {
    return project.bnd.get(name, defaultValue)
  }
  Object bndUnprocessed(String name, Object defaultValue) {
    def value = project.bnd.project.getUnprocessedProperty(name, null)
    if (value == null) {
      value = defaultValue
    }
    if (value instanceof String) {
      value = value.trim()
    }
    return value
  }
}
