{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdTexture: TMFNode;
    { Internal wrapper for property @link(Texture). This wrapper API may change, we advise to access simpler @link(Texture) instead. }
    public property FdTexture: TMFNode read FFdTexture;
    {  }
    procedure SetTexture(const Value: array of TAbstractTexture2DNode);

{$endif read_interface}

{$ifdef read_implementation}

{ TComposedTexture3DNode ----------------------------------------------- }

procedure TComposedTexture3DNode.SetTexture(const Value: array of TAbstractTexture2DNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractTexture2DNode));
  FdTexture.Send(A);
end;

class function TComposedTexture3DNode.ClassX3DType: String;
begin
  Result := 'ComposedTexture3D';
end;

procedure TComposedTexture3DNode.CreateNode;
begin
  inherited;

  FFdTexture := TMFNode.Create(Self, True, 'texture', [TAbstractTexture2DNode]);
   FdTexture.ChangeAlways := chTextureImage;
  AddField(FFdTexture);
end;

{$endif read_implementation}
