{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAxis1Angle: Single;
    procedure SetAxis1Angle(const Value: Single);
    function GetAxis1Torque: Single;
    procedure SetAxis1Torque(const Value: Single);
    function GetAxis2Angle: Single;
    procedure SetAxis2Angle(const Value: Single);
    function GetAxis2Torque: Single;
    procedure SetAxis2Torque(const Value: Single);
    function GetAxis3Angle: Single;
    procedure SetAxis3Angle(const Value: Single);
    function GetAxis3Torque: Single;
    procedure SetAxis3Torque(const Value: Single);
    function GetEnabledAxes: Integer;
    procedure SetEnabledAxes(const Value: Integer);
    function GetMotor1Axis: TVector3;
    procedure SetMotor1Axis(const Value: TVector3);
    function GetMotor2Axis: TVector3;
    procedure SetMotor2Axis(const Value: TVector3);
    function GetMotor3Axis: TVector3;
    procedure SetMotor3Axis(const Value: TVector3);
    function GetStop1Bounce: Single;
    procedure SetStop1Bounce(const Value: Single);
    function GetStop1ErrorCorrection: Single;
    procedure SetStop1ErrorCorrection(const Value: Single);
    function GetStop2Bounce: Single;
    procedure SetStop2Bounce(const Value: Single);
    function GetStop2ErrorCorrection: Single;
    procedure SetStop2ErrorCorrection(const Value: Single);
    function GetStop3Bounce: Single;
    procedure SetStop3Bounce(const Value: Single);
    function GetStop3ErrorCorrection: Single;
    procedure SetStop3ErrorCorrection(const Value: Single);
    function GetAutoCalc: Boolean;
    procedure SetAutoCalc(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdAxis1Angle: TSFFloat;
    { Internal wrapper for property @link(Axis1Angle). This wrapper API may change, we advise to access simpler @link(Axis1Angle) instead. }
    public property FdAxis1Angle: TSFFloat read FFdAxis1Angle;
    {  }
    property Axis1Angle: Single read GetAxis1Angle write SetAxis1Angle;

    strict private FFdAxis1Torque: TSFFloat;
    { Internal wrapper for property @link(Axis1Torque). This wrapper API may change, we advise to access simpler @link(Axis1Torque) instead. }
    public property FdAxis1Torque: TSFFloat read FFdAxis1Torque;
    {  }
    property Axis1Torque: Single read GetAxis1Torque write SetAxis1Torque;

    strict private FFdAxis2Angle: TSFFloat;
    { Internal wrapper for property @link(Axis2Angle). This wrapper API may change, we advise to access simpler @link(Axis2Angle) instead. }
    public property FdAxis2Angle: TSFFloat read FFdAxis2Angle;
    {  }
    property Axis2Angle: Single read GetAxis2Angle write SetAxis2Angle;

    strict private FFdAxis2Torque: TSFFloat;
    { Internal wrapper for property @link(Axis2Torque). This wrapper API may change, we advise to access simpler @link(Axis2Torque) instead. }
    public property FdAxis2Torque: TSFFloat read FFdAxis2Torque;
    {  }
    property Axis2Torque: Single read GetAxis2Torque write SetAxis2Torque;

    strict private FFdAxis3Angle: TSFFloat;
    { Internal wrapper for property @link(Axis3Angle). This wrapper API may change, we advise to access simpler @link(Axis3Angle) instead. }
    public property FdAxis3Angle: TSFFloat read FFdAxis3Angle;
    {  }
    property Axis3Angle: Single read GetAxis3Angle write SetAxis3Angle;

    strict private FFdAxis3Torque: TSFFloat;
    { Internal wrapper for property @link(Axis3Torque). This wrapper API may change, we advise to access simpler @link(Axis3Torque) instead. }
    public property FdAxis3Torque: TSFFloat read FFdAxis3Torque;
    {  }
    property Axis3Torque: Single read GetAxis3Torque write SetAxis3Torque;

    strict private FFdEnabledAxes: TSFInt32;
    { Internal wrapper for property @link(EnabledAxes). This wrapper API may change, we advise to access simpler @link(EnabledAxes) instead. }
    public property FdEnabledAxes: TSFInt32 read FFdEnabledAxes;
    {  }
    property EnabledAxes: Integer read GetEnabledAxes write SetEnabledAxes;

    strict private FFdMotor1Axis: TSFVec3f;
    { Internal wrapper for property @link(Motor1Axis). This wrapper API may change, we advise to access simpler @link(Motor1Axis) instead. }
    public property FdMotor1Axis: TSFVec3f read FFdMotor1Axis;
    {  }
    property Motor1Axis: TVector3 read GetMotor1Axis write SetMotor1Axis;

    strict private FFdMotor2Axis: TSFVec3f;
    { Internal wrapper for property @link(Motor2Axis). This wrapper API may change, we advise to access simpler @link(Motor2Axis) instead. }
    public property FdMotor2Axis: TSFVec3f read FFdMotor2Axis;
    {  }
    property Motor2Axis: TVector3 read GetMotor2Axis write SetMotor2Axis;

    strict private FFdMotor3Axis: TSFVec3f;
    { Internal wrapper for property @link(Motor3Axis). This wrapper API may change, we advise to access simpler @link(Motor3Axis) instead. }
    public property FdMotor3Axis: TSFVec3f read FFdMotor3Axis;
    {  }
    property Motor3Axis: TVector3 read GetMotor3Axis write SetMotor3Axis;

    strict private FFdStop1Bounce: TSFFloat;
    { Internal wrapper for property @link(Stop1Bounce). This wrapper API may change, we advise to access simpler @link(Stop1Bounce) instead. }
    public property FdStop1Bounce: TSFFloat read FFdStop1Bounce;
    {  }
    property Stop1Bounce: Single read GetStop1Bounce write SetStop1Bounce;

    strict private FFdStop1ErrorCorrection: TSFFloat;
    { Internal wrapper for property @link(Stop1ErrorCorrection). This wrapper API may change, we advise to access simpler @link(Stop1ErrorCorrection) instead. }
    public property FdStop1ErrorCorrection: TSFFloat read FFdStop1ErrorCorrection;
    {  }
    property Stop1ErrorCorrection: Single read GetStop1ErrorCorrection write SetStop1ErrorCorrection;

    strict private FFdStop2Bounce: TSFFloat;
    { Internal wrapper for property @link(Stop2Bounce). This wrapper API may change, we advise to access simpler @link(Stop2Bounce) instead. }
    public property FdStop2Bounce: TSFFloat read FFdStop2Bounce;
    {  }
    property Stop2Bounce: Single read GetStop2Bounce write SetStop2Bounce;

    strict private FFdStop2ErrorCorrection: TSFFloat;
    { Internal wrapper for property @link(Stop2ErrorCorrection). This wrapper API may change, we advise to access simpler @link(Stop2ErrorCorrection) instead. }
    public property FdStop2ErrorCorrection: TSFFloat read FFdStop2ErrorCorrection;
    {  }
    property Stop2ErrorCorrection: Single read GetStop2ErrorCorrection write SetStop2ErrorCorrection;

    strict private FFdStop3Bounce: TSFFloat;
    { Internal wrapper for property @link(Stop3Bounce). This wrapper API may change, we advise to access simpler @link(Stop3Bounce) instead. }
    public property FdStop3Bounce: TSFFloat read FFdStop3Bounce;
    {  }
    property Stop3Bounce: Single read GetStop3Bounce write SetStop3Bounce;

    strict private FFdStop3ErrorCorrection: TSFFloat;
    { Internal wrapper for property @link(Stop3ErrorCorrection). This wrapper API may change, we advise to access simpler @link(Stop3ErrorCorrection) instead. }
    public property FdStop3ErrorCorrection: TSFFloat read FFdStop3ErrorCorrection;
    {  }
    property Stop3ErrorCorrection: Single read GetStop3ErrorCorrection write SetStop3ErrorCorrection;

    strict private FEventMotor1Angle: TSFFloatEvent;
    {  }
    public property EventMotor1Angle: TSFFloatEvent read FEventMotor1Angle;

    strict private FEventMotor1AngleRate: TSFFloatEvent;
    {  }
    public property EventMotor1AngleRate: TSFFloatEvent read FEventMotor1AngleRate;

    strict private FEventMotor2Angle: TSFFloatEvent;
    {  }
    public property EventMotor2Angle: TSFFloatEvent read FEventMotor2Angle;

    strict private FEventMotor2AngleRate: TSFFloatEvent;
    {  }
    public property EventMotor2AngleRate: TSFFloatEvent read FEventMotor2AngleRate;

    strict private FEventMotor3Angle: TSFFloatEvent;
    {  }
    public property EventMotor3Angle: TSFFloatEvent read FEventMotor3Angle;

    strict private FEventMotor3AngleRate: TSFFloatEvent;
    {  }
    public property EventMotor3AngleRate: TSFFloatEvent read FEventMotor3AngleRate;

    strict private FFdAutoCalc: TSFBool;
    { Internal wrapper for property @link(AutoCalc). This wrapper API may change, we advise to access simpler @link(AutoCalc) instead. }
    public property FdAutoCalc: TSFBool read FFdAutoCalc;
    {  }
    property AutoCalc: Boolean read GetAutoCalc write SetAutoCalc;

{$endif read_interface}

{$ifdef read_implementation}

{ TMotorJointNode ----------------------------------------------- }

function TMotorJointNode.GetAxis1Angle: Single;
begin
  Result := FdAxis1Angle.Value;
end;

procedure TMotorJointNode.SetAxis1Angle(const Value: Single);
begin
  FdAxis1Angle.Send(Value);
end;

function TMotorJointNode.GetAxis1Torque: Single;
begin
  Result := FdAxis1Torque.Value;
end;

procedure TMotorJointNode.SetAxis1Torque(const Value: Single);
begin
  FdAxis1Torque.Send(Value);
end;

function TMotorJointNode.GetAxis2Angle: Single;
begin
  Result := FdAxis2Angle.Value;
end;

procedure TMotorJointNode.SetAxis2Angle(const Value: Single);
begin
  FdAxis2Angle.Send(Value);
end;

function TMotorJointNode.GetAxis2Torque: Single;
begin
  Result := FdAxis2Torque.Value;
end;

procedure TMotorJointNode.SetAxis2Torque(const Value: Single);
begin
  FdAxis2Torque.Send(Value);
end;

function TMotorJointNode.GetAxis3Angle: Single;
begin
  Result := FdAxis3Angle.Value;
end;

procedure TMotorJointNode.SetAxis3Angle(const Value: Single);
begin
  FdAxis3Angle.Send(Value);
end;

function TMotorJointNode.GetAxis3Torque: Single;
begin
  Result := FdAxis3Torque.Value;
end;

procedure TMotorJointNode.SetAxis3Torque(const Value: Single);
begin
  FdAxis3Torque.Send(Value);
end;

function TMotorJointNode.GetEnabledAxes: Integer;
begin
  Result := FdEnabledAxes.Value;
end;

procedure TMotorJointNode.SetEnabledAxes(const Value: Integer);
begin
  FdEnabledAxes.Send(Value);
end;

function TMotorJointNode.GetMotor1Axis: TVector3;
begin
  Result := FdMotor1Axis.Value;
end;

procedure TMotorJointNode.SetMotor1Axis(const Value: TVector3);
begin
  FdMotor1Axis.Send(Value);
end;

function TMotorJointNode.GetMotor2Axis: TVector3;
begin
  Result := FdMotor2Axis.Value;
end;

procedure TMotorJointNode.SetMotor2Axis(const Value: TVector3);
begin
  FdMotor2Axis.Send(Value);
end;

function TMotorJointNode.GetMotor3Axis: TVector3;
begin
  Result := FdMotor3Axis.Value;
end;

procedure TMotorJointNode.SetMotor3Axis(const Value: TVector3);
begin
  FdMotor3Axis.Send(Value);
end;

function TMotorJointNode.GetStop1Bounce: Single;
begin
  Result := FdStop1Bounce.Value;
end;

procedure TMotorJointNode.SetStop1Bounce(const Value: Single);
begin
  FdStop1Bounce.Send(Value);
end;

function TMotorJointNode.GetStop1ErrorCorrection: Single;
begin
  Result := FdStop1ErrorCorrection.Value;
end;

procedure TMotorJointNode.SetStop1ErrorCorrection(const Value: Single);
begin
  FdStop1ErrorCorrection.Send(Value);
end;

function TMotorJointNode.GetStop2Bounce: Single;
begin
  Result := FdStop2Bounce.Value;
end;

procedure TMotorJointNode.SetStop2Bounce(const Value: Single);
begin
  FdStop2Bounce.Send(Value);
end;

function TMotorJointNode.GetStop2ErrorCorrection: Single;
begin
  Result := FdStop2ErrorCorrection.Value;
end;

procedure TMotorJointNode.SetStop2ErrorCorrection(const Value: Single);
begin
  FdStop2ErrorCorrection.Send(Value);
end;

function TMotorJointNode.GetStop3Bounce: Single;
begin
  Result := FdStop3Bounce.Value;
end;

procedure TMotorJointNode.SetStop3Bounce(const Value: Single);
begin
  FdStop3Bounce.Send(Value);
end;

function TMotorJointNode.GetStop3ErrorCorrection: Single;
begin
  Result := FdStop3ErrorCorrection.Value;
end;

procedure TMotorJointNode.SetStop3ErrorCorrection(const Value: Single);
begin
  FdStop3ErrorCorrection.Send(Value);
end;

function TMotorJointNode.GetAutoCalc: Boolean;
begin
  Result := FdAutoCalc.Value;
end;

procedure TMotorJointNode.SetAutoCalc(const Value: Boolean);
begin
  FdAutoCalc.Send(Value);
end;

class function TMotorJointNode.ClassX3DType: String;
begin
  Result := 'MotorJoint';
end;

procedure TMotorJointNode.CreateNode;
begin
  inherited;

  FFdAxis1Angle := TSFFloat.Create(Self, True, 'axis1Angle', 0);
   FdAxis1Angle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxis1Angle);

  FFdAxis1Torque := TSFFloat.Create(Self, True, 'axis1Torque', 0);
   FdAxis1Torque.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxis1Torque);

  FFdAxis2Angle := TSFFloat.Create(Self, True, 'axis2Angle', 0);
   FdAxis2Angle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxis2Angle);

  FFdAxis2Torque := TSFFloat.Create(Self, True, 'axis2Torque', 0);
   FdAxis2Torque.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxis2Torque);

  FFdAxis3Angle := TSFFloat.Create(Self, True, 'axis3Angle', 0);
   FdAxis3Angle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxis3Angle);

  FFdAxis3Torque := TSFFloat.Create(Self, True, 'axis3Torque', 0);
   FdAxis3Torque.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxis3Torque);

  FFdEnabledAxes := TSFInt32.Create(Self, True, 'enabledAxes', 1);
   FdEnabledAxes.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnabledAxes);

  FFdMotor1Axis := TSFVec3f.Create(Self, True, 'motor1Axis', Vector3(0, 0, 0));
   FdMotor1Axis.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMotor1Axis);

  FFdMotor2Axis := TSFVec3f.Create(Self, True, 'motor2Axis', Vector3(0, 0, 0));
   FdMotor2Axis.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMotor2Axis);

  FFdMotor3Axis := TSFVec3f.Create(Self, True, 'motor3Axis', Vector3(0, 0, 0));
   FdMotor3Axis.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMotor3Axis);

  FFdStop1Bounce := TSFFloat.Create(Self, True, 'stop1Bounce', 0);
   FdStop1Bounce.ChangeAlways := chVisibleNonGeometry;
   FdStop1Bounce.MustBeNonnegative := true;
  AddField(FFdStop1Bounce);

  FFdStop1ErrorCorrection := TSFFloat.Create(Self, True, 'stop1ErrorCorrection', 0.8);
   FdStop1ErrorCorrection.ChangeAlways := chVisibleNonGeometry;
   FdStop1ErrorCorrection.MustBeNonnegative := true;
  AddField(FFdStop1ErrorCorrection);

  FFdStop2Bounce := TSFFloat.Create(Self, True, 'stop2Bounce', 0);
   FdStop2Bounce.ChangeAlways := chVisibleNonGeometry;
   FdStop2Bounce.MustBeNonnegative := true;
  AddField(FFdStop2Bounce);

  FFdStop2ErrorCorrection := TSFFloat.Create(Self, True, 'stop2ErrorCorrection', 0.8);
   FdStop2ErrorCorrection.ChangeAlways := chVisibleNonGeometry;
   FdStop2ErrorCorrection.MustBeNonnegative := true;
  AddField(FFdStop2ErrorCorrection);

  FFdStop3Bounce := TSFFloat.Create(Self, True, 'stop3Bounce', 0);
   FdStop3Bounce.ChangeAlways := chVisibleNonGeometry;
   FdStop3Bounce.MustBeNonnegative := true;
  AddField(FFdStop3Bounce);

  FFdStop3ErrorCorrection := TSFFloat.Create(Self, True, 'stop3ErrorCorrection', 0.8);
   FdStop3ErrorCorrection.ChangeAlways := chVisibleNonGeometry;
   FdStop3ErrorCorrection.MustBeNonnegative := true;
  AddField(FFdStop3ErrorCorrection);

  FEventMotor1Angle := TSFFloatEvent.Create(Self, 'motor1Angle', false);
  AddEvent(FEventMotor1Angle);

  FEventMotor1AngleRate := TSFFloatEvent.Create(Self, 'motor1AngleRate', false);
  AddEvent(FEventMotor1AngleRate);

  FEventMotor2Angle := TSFFloatEvent.Create(Self, 'motor2Angle', false);
  AddEvent(FEventMotor2Angle);

  FEventMotor2AngleRate := TSFFloatEvent.Create(Self, 'motor2AngleRate', false);
  AddEvent(FEventMotor2AngleRate);

  FEventMotor3Angle := TSFFloatEvent.Create(Self, 'motor3Angle', false);
  AddEvent(FEventMotor3Angle);

  FEventMotor3AngleRate := TSFFloatEvent.Create(Self, 'motor3AngleRate', false);
  AddEvent(FEventMotor3AngleRate);

  FFdAutoCalc := TSFBool.Create(Self, False, 'autoCalc', false);
   FdAutoCalc.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAutoCalc);
end;

{$endif read_implementation}
