{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetGeoCenter: TVector3Double;
    procedure SetGeoCenter(const Value: TVector3Double);
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdGeoCenter: TSFVec3d;
    { Internal wrapper for property @code(GeoCenter). This wrapper API may change, we advise to access simpler @code(GeoCenter) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoCenter: TSFVec3d read FFdGeoCenter;
    {  }
    property GeoCenter: TVector3Double read GetGeoCenter write SetGeoCenter;

    strict private FEventCenterOfRotation_changed: TSFVec3fEvent;
    {  }
    public property EventCenterOfRotation_changed: TSFVec3fEvent read FEventCenterOfRotation_changed;

    strict private FEventGeoCoord_changed: TSFVec3dEvent;
    {  }
    public property EventGeoCoord_changed: TSFVec3dEvent read FEventGeoCoord_changed;

    strict private FEventOrientation_changed: TSFRotationEvent;
    {  }
    public property EventOrientation_changed: TSFRotationEvent read FEventOrientation_changed;

    strict private FEventPosition_changed: TSFVec3fEvent;
    {  }
    public property EventPosition_changed: TSFVec3fEvent read FEventPosition_changed;

    strict private FFdGeoOrigin: TSFNode;
    { Internal wrapper for property @code(GeoOrigin). This wrapper API may change, we advise to access simpler @code(GeoOrigin) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoOrigin: TSFNode read FFdGeoOrigin;
    {  }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;

    strict private FFdGeoSystem: TMFString;
    { Internal wrapper for property @code(GeoSystem). This wrapper API may change, we advise to access simpler @code(GeoSystem) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoSystem: TMFString read FFdGeoSystem;
    {  }
    procedure SetGeoSystem(const Value: array of string); overload;
    {  }
    procedure SetGeoSystem(const Value: TCastleStringList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoProximitySensorNode ----------------------------------------------- }

function TGeoProximitySensorNode.GetGeoCenter: TVector3Double;
begin
  Result := FdGeoCenter.Value;
end;

procedure TGeoProximitySensorNode.SetGeoCenter(const Value: TVector3Double);
begin
  FdGeoCenter.Send(Value);
end;

function TGeoProximitySensorNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoProximitySensorNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoProximitySensorNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoProximitySensorNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

class function TGeoProximitySensorNode.ClassX3DType: String;
begin
  Result := 'GeoProximitySensor';
end;

procedure TGeoProximitySensorNode.CreateNode;
begin
  inherited;

  FFdGeoCenter := TSFVec3d.Create(Self, True, 'geoCenter', Vector3Double(0, 0, 0));
   FdGeoCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoCenter);

  FEventCenterOfRotation_changed := TSFVec3fEvent.Create(Self, 'centerOfRotation_changed', false);
  AddEvent(FEventCenterOfRotation_changed);

  FEventGeoCoord_changed := TSFVec3dEvent.Create(Self, 'geoCoord_changed', false);
  AddEvent(FEventGeoCoord_changed);

  FEventOrientation_changed := TSFRotationEvent.Create(Self, 'orientation_changed', false);
  AddEvent(FEventOrientation_changed);

  FEventPosition_changed := TSFVec3fEvent.Create(Self, 'position_changed', false);
  AddEvent(FEventPosition_changed);

  FFdGeoOrigin := TSFNode.Create(Self, False, 'geoOrigin', [TGeoOriginNode]);
   FdGeoOrigin.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoOrigin);

  FFdGeoSystem := TMFString.Create(Self, False, 'geoSystem', ['GD','WE']);
   FdGeoSystem.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoSystem);
end;

{$endif read_implementation}
