{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetProjector: TX3DNode;
    procedure SetProjector(const Value: TX3DNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdProjector: TSFNode;
    { Internal wrapper for property @code(Projector). This wrapper API may change, we advise to access simpler @code(Projector) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdProjector: TSFNode read FFdProjector;
    { Viewpoint or light that determine how is the texture projected. }
    property Projector: TX3DNode read GetProjector write SetProjector;

{$endif read_interface}

{$ifdef read_implementation}

{ TProjectedTextureCoordinateNode ----------------------------------------------- }

function TProjectedTextureCoordinateNode.GetProjector: TX3DNode;
begin
  if FdProjector.Value is TX3DNode then
    Result := TX3DNode(FdProjector.Value)
  else
    Result := nil;
end;

procedure TProjectedTextureCoordinateNode.SetProjector(const Value: TX3DNode);
begin
  FdProjector.Send(Value);
end;

class function TProjectedTextureCoordinateNode.ClassX3DType: String;
begin
  Result := 'ProjectedTextureCoordinate';
end;

procedure TProjectedTextureCoordinateNode.CreateNode;
begin
  inherited;

  FFdProjector := TSFNode.Create(Self, True, 'projector', [TSpotLightNode, TDirectionalLightNode, TAbstractViewpointNode, TSpotLightNode_1, TDirectionalLightNode_1]);
   FdProjector.ChangeAlways := chTextureCoordinate;
  AddField(FFdProjector);
end;

{$endif read_implementation}
