# Copyright (c) 2017-2019 David Steele <dsteele@gmail.com>
#
# SPDX-License-Identifier: GPL-2.0-or-later
# License-Filename: LICENSE
#
# Copyright 2016-2017 David Steele <steele@debian.org>
# This file is part of comitup
# Available under the terms of the GNU General Public License version 2
# or later
#

import sys

from setuptools import setup

sys.path.append(".")
from comitup import __version__  # noqa

setup(
    name="comitup",
    packages=["comitup", "web", "cli"],
    version=__version__.__version__,
    description="Remotely manage wifi connections on a headless computer",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Web Environment",
        "Framework :: Flask",
        "Intended Audience :: End Users/Desktop",
        "License :: OSI Approved "
        + ":: GNU General Public License v2 or later (GPLv2+)",
        "Natural Language :: English",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python",
        "Topic :: System :: Networking",
    ],
    entry_points={
        "console_scripts": [
            "comitup-cmd=comitup.comitup:main",
            "comitup-cli=cli.comitupcli:main",
            "comitup-web=web.comitupweb:main",
        ],
    },
    options={
        "build_scripts": {
            "executable": "/usr/bin/python3",
        },
    },
    data_files=[
        ("/etc", ["conf/comitup.conf"]),
        ("/usr/share/dbus-1/system.d", ["conf/comitup-dbus.conf"]),
        (
            "/web/templates",
            [
                "web/templates/index.html",
                "web/templates/connect.html",
                "web/templates/confirm.html",
            ],
        ),
        (
            "/web/templates/css",
            [
                "web/templates/css/uikit.css",
                "web/templates/css/uikit-rtl.css",
                "web/templates/css/uikit.min.css",
                "web/templates/css/uikit-rtl.min.css",
            ],
        ),
        (
            "/web/templates/js",
            [
                "web/templates/js/uikit",
                "web/templates/js/uikit-icons",
                "web/templates/js/blink.js",
            ],
        ),
        (
            "/web/templates/images",
            [
                "web/templates/images/ledon.gif",
                "web/templates/images/ledoff.gif",
            ],
        ),
        (
            "/dns",
            [
                "conf/dns-hotspot.conf",
                "conf/dns-connected.conf",
            ],
        ),
    ],
    install_requires=[
        "cachetools",
        "jinja2",
        "pygobject",
        "flask",
        "python-networkmanager",
        "pycairo",
    ],
    setup_requires=["pytest-runner"],
    tests_require=["pytest"],
    author="David Steele",
    author_email="steele@debian.org",
    url="https://davesteele.github.io/comitup/",
)
