// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace BasicWebSite;

public class StartupWithCookieTempDataProviderAndCookieConsent
{
    public void ConfigureServices(IServiceCollection services)
    {
        services.AddMvc()
            .AddNewtonsoftJson();

        services.Configure<CookiePolicyOptions>(o =>
        {
            o.CheckConsentNeeded = httpContext => true;
        });

        services.ConfigureBaseWebSiteAuthPolicies();
    }

    public void Configure(IApplicationBuilder app)
    {
        app.UseDeveloperExceptionPage();

        app.UseCookiePolicy();
        app.UseRouting();
        app.UseEndpoints(endpoints =>
        {
            endpoints.MapDefaultControllerRoute();
            endpoints.MapRazorPages();
        });
    }
}

