/*
FatRat download manager
http://fatrat.dolezel.info

Copyright (C) 2006-2008 Lubos Dolezel <lubos a dolezel.info>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2 as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef SUBTITLESDLG_H
#define SUBTITLESDLG_H
#include <QDialog>
#include <QTimer>
#include "ui_SubtitlesDlg.h"

class QBuffer;
class QHttp;

class SubtitlesDlg : public QDialog, Ui_SubtitlesDlg
{
Q_OBJECT
public:
	SubtitlesDlg(QWidget* parent);
	static QWidget* create();
	void search(QString file);
	void search(QString checksum, qint64 fileSize);
	static QString computeMovieHash(QString filename, qint64& fsize);
	static void decompressFile(int infd, QString unzipped);
protected:
	void createSession();
	void performSearch();
public slots:
	void requestDone(bool error);
	void chooseFile();
	void noOperation();
	void itemDoubleClicked(QTreeWidgetItem* item);
private:
	QString m_strChecksum, m_strSession;
	QByteArray m_strLastFunction;
	qint64 m_fileSize;
	int m_sel;
	
	QHttp* m_http;
	QBuffer* m_buffer;
	QTimer m_timer;
};

class SubtitleTreeWidgetItem : public QTreeWidgetItem
{
public:
	SubtitleTreeWidgetItem(QTreeWidget* parent) : QTreeWidgetItem(parent) {}
	
	int m_id;
	QString m_lang, m_format;
};

#endif
