/* $Id: UndefinedSymbol.hpp 5085 2010-12-17 16:38:59Z potyra $ 
 * UndefinedSymbol: error meaning that a symbol could not get looked up.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __UNDEFINED_SYMBOL_HPP_INCLUDED
#define __UNDEFINED_SYMBOL_HPP_INCLUDED

#include "frontend/reporting/CompileError.hpp"

namespace ast {

//! symbol lookup failed.
class UndefinedSymbol : public CompileError {
public:
	//! c'tor
        /** @param name name which cannot be resolved.
          * @param loc location of the undefined symbol.
          */
	UndefinedSymbol(
		const std::string &name,
		const Location &loc
	);

	//! write error to stream.
	/** @param stream write the compile error to this stream.
	 */
	virtual void put(std::ostream &stream) const;
protected:
	/** name which couldn't be resolved */
	std::string failedName;
};

}; /* namespace ast */

#endif /* __UNDEFINED_SYMBOL_HPP_INCLUDED */
