/* $Id: RegisterFactory.hpp 4985 2010-10-19 15:06:35Z potyra $ 
 *
 * RegisterFactory: create and keep track of virtual registers.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __REGISTER_FACTORY_HPP_INCLUDED
#define __REGISTER_FACTORY_HPP_INCLUDED

#include <vector>
#include "intermediate/operands/Register.hpp"

namespace intermediate {

//FIXME nest class in CodeContainer
//! create virtual register (operands).
/** TODO keep better track of handed out vregs?
 */
class RegisterFactory {
public:
	
	//! obtain the vector of register types.
	/** @return vector of register types. Do not fiddle with it!
	 */
	const std::vector<enum OpType>& 
	getRegTypes(void) const {
		return this->regTypes;
	}

private:
	friend class CodeContainer;

	//! c'tor
	RegisterFactory() : regTypes(std::vector<enum OpType>()) {}

	//! create a virtual Register.
	/** @param type type of the virtual register operand
	 *  @return newly created virtual register.
	 */
	Register *
	getReg(enum OpType type);

	/** return the number of created virtual registers.
	 *  @return number of created virtual registers.
	 */
	size_t getNumUsedRegs(void) const;

	//! vector containing the types of the Registers.
	std::vector<enum OpType> regTypes;
};

}; /* namespace intermediate */

#endif /* __REGISTER_FACTORY_HPP_INCLUDED */
