/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import loci.formats.DummyMetadata;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.ImageTools;
import loci.formats.MetadataRetrieve;

public abstract class FormatWriter
extends FormatHandler
implements IFormatWriter {
    protected int fps = 10;
    protected ColorModel cm;
    protected String[] compressionTypes;
    protected String compression;
    protected boolean initialized;
    protected MetadataRetrieve metadataRetrieve = new DummyMetadata();

    public FormatWriter(String format, String suffix) {
        super(format, suffix);
    }

    public FormatWriter(String format, String[] suffixes) {
        super(format, suffixes);
    }

    public void saveBytes(byte[] bytes, boolean last) throws FormatException, IOException {
        this.saveBytes(bytes, 0, last, last);
    }

    public void saveBytes(byte[] bytes, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        MetadataRetrieve r = this.getMetadataRetrieve();
        if (r == null) {
            throw new FormatException("MetadataRetrieve cannot be null");
        }
        Integer ss = new Integer(series);
        int width = r.getSizeX(ss);
        int height = r.getSizeY(ss);
        int channels = r.getSizeC(ss);
        int type = FormatTools.pixelTypeFromString(r.getPixelType(ss));
        boolean littleEndian = r.getBigEndian(ss) == false;
        BufferedImage img = ImageTools.makeImage(bytes, width, height, channels, true, FormatTools.getBytesPerPixel(type), littleEndian);
        this.saveImage(img, series, lastInSeries, last);
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        throw new FormatException("Not implemented yet.");
    }

    public boolean canDoStacks() {
        return false;
    }

    public void setMetadataRetrieve(MetadataRetrieve retrieve) {
        FormatTools.assertId(this.currentId, false, 1);
        if (retrieve == null) {
            throw new IllegalArgumentException("Metadata object is null");
        }
        this.metadataRetrieve = retrieve;
    }

    public MetadataRetrieve getMetadataRetrieve() {
        return this.metadataRetrieve;
    }

    public void setColorModel(ColorModel model) {
        this.cm = model;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public void setFramesPerSecond(int rate) {
        this.fps = rate;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public String[] getCompressionTypes() {
        return this.compressionTypes;
    }

    public void setCompression(String compress) throws FormatException {
        for (int i = 0; i < this.compressionTypes.length; ++i) {
            if (!this.compressionTypes[i].equals(compress)) continue;
            this.compression = compress;
            return;
        }
        throw new FormatException("Invalid compression type: " + compress);
    }

    public int[] getPixelTypes() {
        return new int[]{1, 3, 5, 6};
    }

    public boolean isSupportedType(int type) {
        int[] types = this.getPixelTypes();
        for (int i = 0; i < types.length; ++i) {
            if (type != types[i]) continue;
            return true;
        }
        return false;
    }

    public void setId(String id, boolean force) throws FormatException, IOException {
        if (id.equals(this.currentId) && !force) {
            return;
        }
        this.close();
        this.currentId = id;
        this.initialized = false;
    }

    public boolean canDoStacks(String id) throws FormatException {
        try {
            this.setId(id);
        }
        catch (IOException exc) {
            throw new FormatException(exc);
        }
        return this.canDoStacks(id);
    }

    public int[] getPixelTypes(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getPixelTypes(id);
    }

    public boolean isSupportedType(String id, int type) throws FormatException, IOException {
        this.setId(id);
        return this.isSupportedType(type);
    }

    public void save(String id, Image image, boolean last) throws FormatException, IOException {
        this.setId(id);
        this.saveImage(image, last);
    }
}

