/* chess.c
**
**    code for chess
**
**    Updated Version foobillard++ started at 12/2010
**    Copyright (C) 2010 - 2013 Holger Schaekel (foobillardplus@go4more.de)
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License Version 2 as
**    published by the Free Software Foundation;
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "chess.h"

static int chess_id = -1;

/***********************************************************************
 *        This is a general routine to make a new material active      *
 ***********************************************************************/

void chess_Material_Parameters(float shininess, float r_diffuseColor, float g_diffuseColor, float b_diffuseColor, float r_specularColor, float g_specularColor, float b_specularColor)
{
	GLfloat glfModelSpecular[4];

	// This causes the polygon's ambient & diffuse colors to be derived from the glColor() value.
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess);
	/* Set the specular shading color. */
	glfModelSpecular[0] = r_specularColor;
	glfModelSpecular[1] = g_specularColor;
	glfModelSpecular[2] = b_specularColor;
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, glfModelSpecular);
	glColor3f(r_diffuseColor, g_diffuseColor, b_diffuseColor);
}

/***********************************************************************
 *                          Make an glcallist                          *
 ***********************************************************************/

void init_chess(void) {
	 if(chess_id != -1) {
	 	glDeleteLists(chess_id,1);
	 }
  fprintf(stderr,"Initialize chess graphics\n");
  chess_id = glGenLists(1);
  glNewList(chess_id, GL_COMPILE);
  chess();
  glEndList();
}

/***********************************************************************
 *                         display the chess                           *
 ***********************************************************************/

void display_chess(void) {
	 if(chess_id == -1) {
	 	init_chess();
	 } else {
	 	glCallList(chess_id);
	 }
}

/***********************************************************************
 *                           build the chess                           *
 *                 Polygons for object (5872 polygons)                 *
 ***********************************************************************/

void chess(void) {
	static const GLfloat VertexData[] = {
		3.34472f, 0.217805f, 2.13542f, 3.34472f, 0.217805f, 2.62767f, 3.34472f, 0.273742f, 2.13542f, 
		3.34472f, 0.273742f, 2.62767f, 3.35591f, 0.273742f, 2.14661f, 
		3.35591f, 0.273742f, 2.61648f, 3.36710f, 0.266331f, 2.15780f, 
		3.36710f, 0.266331f, 2.21374f, 3.36710f, 0.266331f, 2.26967f, 
		3.36710f, 0.266331f, 2.32561f, 3.36710f, 0.266331f, 2.38154f, 
		3.36710f, 0.266331f, 2.43748f, 3.36710f, 0.266331f, 2.49342f, 
		3.36710f, 0.266331f, 2.54935f, 3.36710f, 0.266331f, 2.60529f, 
		3.37322f, 0.284178f, 2.57643f, 3.37345f, 0.284254f, 2.18760f, 
		3.37346f, 0.266951f, 2.19046f, 3.37372f, 0.270528f, 2.18654f, 
		3.37421f, 0.267668f, 2.57230f, 3.37429f, 0.270935f, 2.58204f, 
		3.37617f, 0.305163f, 2.18713f, 3.37620f, 0.284741f, 2.58734f, 
		3.37633f, 0.305191f, 2.57774f, 3.37633f, 0.267297f, 2.58810f, 
		3.37639f, 0.284203f, 2.17598f, 3.37674f, 0.267066f, 2.17548f, 
		3.37681f, 0.284261f, 2.19880f, 3.37698f, 0.318869f, 2.18680f, 
		3.37706f, 0.318949f, 2.57504f, 3.37791f, 0.282018f, 2.18510f, 
		3.37832f, 0.282053f, 2.57959f, 3.37836f, 0.274668f, 2.52350f, 
		3.37839f, 0.318868f, 2.19391f, 3.37851f, 0.290625f, 2.19143f, 
		3.37854f, 0.274762f, 2.24306f, 3.37857f, 0.318861f, 2.17948f, 
		3.37869f, 0.267290f, 2.23750f, 3.37870f, 0.318743f, 2.58485f, 
		3.37871f, 0.290831f, 2.58231f, 3.37895f, 0.272892f, 2.23354f, 
		3.37903f, 0.282095f, 2.57177f, 3.37912f, 0.290196f, 2.18015f, 
		3.37913f, 0.266953f, 2.51700f, 3.37917f, 0.284395f, 2.23996f, 
		3.37918f, 0.282944f, 2.52409f, 3.37924f, 0.274363f, 2.51500f, 
		3.37934f, 0.314688f, 2.18763f, 3.37940f, 0.270978f, 2.52984f, 
		3.37957f, 0.284309f, 2.56249f, 3.37966f, 0.281914f, 2.17849f, 
		3.37996f, 0.266918f, 2.56204f, 3.38006f, 0.314933f, 2.57232f, 
		3.38032f, 0.295810f, 2.57753f, 3.38038f, 0.305021f, 2.17563f, 
		3.38062f, 0.305059f, 2.56621f, 3.38079f, 0.270365f, 2.17102f, 
		3.38080f, 0.270443f, 2.59335f, 3.38088f, 0.281987f, 2.19690f, 
		3.38089f, 0.267399f, 2.20356f, 3.38095f, 0.285142f, 2.51914f, 
		3.38096f, 0.290606f, 2.56741f, 3.38115f, 0.304377f, 2.18687f, 
		3.38116f, 0.282959f, 2.24841f, 3.38143f, 0.296475f, 2.18313f, 
		3.38152f, 0.305157f, 2.19949f, 3.38155f, 0.266884f, 2.25002f, 
		3.38156f, 0.304292f, 2.57784f, 3.38167f, 0.305171f, 2.59017f, 
		3.38179f, 0.280810f, 2.23808f, 3.38208f, 0.280777f, 2.52105f, 
		3.38212f, 0.271431f, 2.50916f, 3.38232f, 0.296240f, 2.19302f, 
		3.38249f, 0.282039f, 2.56597f, 3.38255f, 0.314561f, 2.17727f, 
		3.38272f, 0.319055f, 2.56466f, 3.38308f, 0.282154f, 2.58965f, 
		3.38324f, 0.287071f, 2.23748f, 3.38339f, 0.314917f, 2.19772f, 
		3.38345f, 0.283773f, 2.53253f, 3.38355f, 0.282969f, 2.50922f, 
		3.38355f, 0.282964f, 2.22728f, 3.38362f, 0.266783f, 2.53350f, 
		3.38396f, 0.284201f, 2.59618f, 3.38396f, 0.269792f, 2.22549f, 
		3.38399f, 0.311596f, 2.18925f, 3.38411f, 0.290330f, 2.20014f, 
		3.38419f, 0.290309f, 2.59076f, 3.38423f, 0.290388f, 2.17367f, 
		3.38435f, 0.276237f, 2.25278f, 3.38486f, 0.318916f, 2.17157f, 
		3.38491f, 0.319030f, 2.20210f, 3.38509f, 0.319092f, 2.59282f, 
		3.38526f, 0.276294f, 2.22587f, 3.38528f, 0.301879f, 2.24147f, 
		3.38538f, 0.301893f, 2.51772f, 3.38543f, 0.283927f, 2.20629f, 
		3.38550f, 0.304153f, 2.58687f, 3.38550f, 0.280673f, 2.53157f, 
		3.38572f, 0.311163f, 2.58119f, 3.38572f, 0.285229f, 2.25022f, 
		3.38577f, 0.296365f, 2.56705f, 3.38586f, 0.284154f, 2.16700f, 
		3.38606f, 0.280778f, 2.24956f, 3.38606f, 0.302779f, 2.23343f, 
		3.38612f, 0.266862f, 2.59730f, 3.38657f, 0.304338f, 2.17576f, 
		3.38663f, 0.301873f, 2.52760f, 3.38672f, 0.266745f, 2.22491f, 
		3.38689f, 0.295723f, 2.58928f, 3.38690f, 0.285211f, 2.22774f, 
		3.38690f, 0.285211f, 2.50967f, 3.38694f, 0.311575f, 2.51865f, 
		3.38707f, 0.274038f, 2.53781f, 3.38710f, 0.304380f, 2.56625f, 
		3.38715f, 0.312052f, 2.23568f, 3.38715f, 0.296539f, 2.17519f, 
		3.38733f, 0.304309f, 2.19863f, 3.38744f, 0.291432f, 2.52309f, 
		3.38759f, 0.272211f, 2.25640f, 3.38768f, 0.292399f, 2.23950f, 
		3.38770f, 0.313633f, 2.24509f, 3.38775f, 0.313897f, 2.52690f, 
		3.38794f, 0.266763f, 2.16662f, 3.38814f, 0.314709f, 2.59172f, 
		3.38823f, 0.305114f, 2.16979f, 3.38823f, 0.280688f, 2.50913f, 
		3.38833f, 0.280740f, 2.22723f, 3.38849f, 0.305176f, 2.56044f, 
		3.38856f, 0.301937f, 2.24841f, 3.38856f, 0.270612f, 2.59780f, 
		3.38865f, 0.296314f, 2.19935f, 3.38868f, 0.305252f, 2.24068f, 
		3.38874f, 0.317818f, 2.52055f, 3.38874f, 0.317818f, 2.23862f, 
		3.38881f, 0.305392f, 2.52148f, 3.38884f, 0.270462f, 2.16649f, 
		3.38885f, 0.314983f, 2.56288f, 3.38887f, 0.284245f, 2.55696f, 
		3.38899f, 0.270517f, 2.55719f, 3.38927f, 0.266688f, 2.50556f, 
		3.38958f, 0.282039f, 2.20319f, 3.38971f, 0.311177f, 2.56831f, 
		3.38975f, 0.311079f, 2.17883f, 3.39025f, 0.282148f, 2.59392f, 
		3.39026f, 0.267069f, 2.20767f, 3.39026f, 0.313654f, 2.51317f, 
		3.39033f, 0.299563f, 2.51925f, 3.39038f, 0.291702f, 2.51470f, 
		3.39067f, 0.274189f, 2.50357f, 3.39092f, 0.299491f, 2.24325f, 
		3.39094f, 0.283511f, 2.25652f, 3.39104f, 0.299329f, 2.52501f, 
		3.39113f, 0.267039f, 2.25649f, 3.39148f, 0.282120f, 2.17000f, 
		3.39163f, 0.282170f, 2.56070f, 3.39165f, 0.310278f, 2.53019f, 
		3.39193f, 0.292006f, 2.52873f, 3.39210f, 0.303488f, 2.51037f, 
		3.39216f, 0.284402f, 2.53748f, 3.39275f, 0.283675f, 2.50421f, 
		3.39276f, 0.304101f, 2.59064f, 3.39284f, 0.313169f, 2.24980f, 
		3.39285f, 0.283643f, 2.22223f, 3.39287f, 0.302005f, 2.22845f, 
		3.39302f, 0.299589f, 2.23376f, 3.39305f, 0.291776f, 2.23144f, 
		3.39306f, 0.310339f, 2.23006f, 3.39317f, 0.268318f, 2.53985f, 
		3.39324f, 0.290447f, 2.56046f, 3.39329f, 0.296270f, 2.56374f, 
		3.39331f, 0.290345f, 2.16974f, 3.39359f, 0.303012f, 2.53275f, 
		3.39364f, 0.292285f, 2.24782f, 3.39388f, 0.269729f, 2.22093f, 
		3.39393f, 0.317373f, 2.20467f, 3.39395f, 0.321396f, 2.24145f, 
		3.39395f, 0.321396f, 2.52338f, 3.39409f, 0.318728f, 2.55956f, 
		3.39440f, 0.319057f, 2.23259f, 3.39449f, 0.305140f, 2.59603f, 
		3.39459f, 0.305200f, 2.20538f, 3.39460f, 0.318959f, 2.59541f, 
		3.39505f, 0.311240f, 2.58763f, 3.39509f, 0.285878f, 2.25396f, 
		3.39523f, 0.318752f, 2.16909f, 3.39534f, 0.284779f, 2.59886f, 
		3.39550f, 0.312023f, 2.17449f, 3.39553f, 0.280648f, 2.53621f, 
		3.39554f, 0.280471f, 2.25488f, 3.39563f, 0.299104f, 2.51514f, 
		3.39612f, 0.317317f, 2.53063f, 3.39618f, 0.305532f, 2.52953f, 
		3.39631f, 0.320202f, 2.51605f, 3.39633f, 0.267201f, 2.55595f, 
		3.39649f, 0.296636f, 2.20062f, 3.39651f, 0.290336f, 2.20416f, 
		3.39657f, 0.290414f, 2.59489f, 3.39657f, 0.267885f, 2.52152f, 
		3.39660f, 0.284202f, 2.20839f, 3.39668f, 0.305353f, 2.23120f, 
		3.39670f, 0.267842f, 2.23948f, 3.39677f, 0.274248f, 2.54013f, 
		3.39684f, 0.310956f, 2.19673f, 3.39713f, 0.305496f, 2.51330f, 
		3.39719f, 0.299709f, 2.51253f, 3.39721f, 0.280362f, 2.22400f, 
		3.39732f, 0.303535f, 2.25167f, 3.39753f, 0.270497f, 2.50229f, 
		3.39762f, 0.305143f, 2.55944f, 3.39764f, 0.285714f, 2.50692f, 
		3.39765f, 0.285713f, 2.22499f, 3.39769f, 0.312932f, 2.51070f, 
		3.39774f, 0.304135f, 2.17372f, 3.39821f, 0.295654f, 2.59166f, 
		3.39853f, 0.305238f, 2.24740f, 3.39859f, 0.315202f, 2.22982f, 
		3.39910f, 0.281986f, 2.20345f, 3.39915f, 0.299353f, 2.52778f, 
		3.39940f, 0.321845f, 2.52177f, 3.39940f, 0.321845f, 2.23984f, 
		3.39958f, 0.304312f, 2.56499f, 3.39961f, 0.299126f, 2.24605f, 
		3.39962f, 0.284325f, 2.16560f, 3.39964f, 0.295680f, 2.17320f, 
		3.39985f, 0.271183f, 2.16632f, 3.39994f, 0.305099f, 2.16896f, 
		3.40012f, 0.291381f, 2.23077f, 3.40013f, 0.300476f, 2.53187f, 
		3.40021f, 0.270407f, 2.59828f, 3.40021f, 0.289201f, 2.53211f, 
		3.40023f, 0.282083f, 2.59369f, 3.40024f, 0.284491f, 2.55639f, 
		3.40025f, 0.304222f, 2.58993f, 3.40034f, 0.280546f, 2.50698f, 
		3.40043f, 0.318487f, 2.24668f, 3.40045f, 0.266591f, 2.53895f, 
		3.40050f, 0.269684f, 2.20756f, 3.40056f, 0.292402f, 2.51379f, 
		3.40059f, 0.303184f, 2.22800f, 3.40066f, 0.310186f, 2.53107f, 
		3.40070f, 0.310530f, 2.24914f, 3.40089f, 0.266713f, 2.25768f, 
		3.40097f, 0.299457f, 2.23429f, 3.40118f, 0.282252f, 2.56122f, 
		3.40149f, 0.288798f, 2.24990f, 3.40155f, 0.315256f, 2.59241f, 
		3.40179f, 0.295329f, 2.56451f, 3.40212f, 0.283665f, 2.53842f, 
		3.40223f, 0.315583f, 2.20158f, 3.40236f, 0.304284f, 2.19875f, 
		3.40302f, 0.266920f, 2.59705f, 3.40304f, 0.283607f, 2.25604f, 
		3.40329f, 0.318634f, 2.59372f, 3.40330f, 0.314637f, 2.17333f, 
		3.40341f, 0.318737f, 2.20272f, 3.40342f, 0.290644f, 2.17204f, 
		3.40347f, 0.314843f, 2.56395f, 3.40356f, 0.299132f, 2.23953f, 
		3.40357f, 0.282051f, 2.17226f, 3.40359f, 0.299104f, 2.52139f, 
		3.40403f, 0.318835f, 2.56197f, 3.40430f, 0.319010f, 2.23802f, 
		3.40438f, 0.274353f, 2.53837f, 3.40447f, 0.274214f, 2.25647f, 
		3.40461f, 0.302191f, 2.51226f, 3.40473f, 0.293240f, 2.24137f, 
		3.40473f, 0.293240f, 2.52331f, 3.40477f, 0.312290f, 2.23247f, 
		3.40478f, 0.312328f, 2.51443f, 3.40479f, 0.315035f, 2.52804f, 
		3.40487f, 0.301004f, 2.23146f, 3.40492f, 0.303987f, 2.17828f, 
		3.40498f, 0.303082f, 2.53086f, 3.40500f, 0.266825f, 2.20556f, 
		3.40502f, 0.305389f, 2.23882f, 3.40504f, 0.311153f, 2.18533f, 
		3.40522f, 0.305392f, 2.52225f, 3.40523f, 0.311121f, 2.57525f, 
		3.40541f, 0.283774f, 2.22385f, 3.40542f, 0.283746f, 2.50576f, 
		3.40550f, 0.266846f, 2.16847f, 3.40551f, 0.274395f, 2.22314f, 
		3.40560f, 0.266943f, 2.55915f, 3.40561f, 0.318755f, 2.17205f, 
		3.40569f, 0.281243f, 2.20033f, 3.40570f, 0.317602f, 2.51959f, 
		3.40590f, 0.284199f, 2.59626f, 3.40599f, 0.266701f, 2.22411f, 
		3.40599f, 0.266701f, 2.50604f, 3.40605f, 0.296241f, 2.19576f, 
		3.40616f, 0.284324f, 2.20514f, 3.40642f, 0.305073f, 2.56311f, 
		3.40653f, 0.304430f, 2.57055f, 3.40663f, 0.296843f, 2.58503f, 
		3.40671f, 0.288072f, 2.51446f, 3.40671f, 0.288072f, 2.23252f, 
		3.40695f, 0.303324f, 2.24569f, 3.40724f, 0.280475f, 2.53203f, 
		3.40726f, 0.305033f, 2.20087f, 3.40757f, 0.312212f, 2.24170f, 
		3.40759f, 0.296589f, 2.57150f, 3.40766f, 0.314415f, 2.58627f, 
		3.40766f, 0.305214f, 2.59127f, 3.40783f, 0.280554f, 2.24959f, 
		3.40785f, 0.314267f, 2.19491f, 3.40827f, 0.303978f, 2.18656f, 
		3.40832f, 0.290351f, 2.56649f, 3.40840f, 0.301583f, 2.24012f, 
		3.40841f, 0.273840f, 2.50692f, 3.40866f, 0.304490f, 2.58081f, 
		3.40868f, 0.270303f, 2.17049f, 3.40871f, 0.290349f, 2.19705f, 
		3.40877f, 0.270559f, 2.59373f, 3.40883f, 0.270353f, 2.56118f, 
		3.40883f, 0.290423f, 2.58779f, 3.40895f, 0.295764f, 2.18351f, 
		3.40896f, 0.296601f, 2.57803f, 3.40920f, 0.302380f, 2.52019f, 
		3.40920f, 0.305143f, 2.17552f, 3.40933f, 0.280466f, 2.23135f, 
		3.40972f, 0.286690f, 2.24274f, 3.40972f, 0.286690f, 2.52467f, 
		3.40974f, 0.280387f, 2.51327f, 3.41001f, 0.290329f, 2.17942f, 
		3.41019f, 0.282090f, 2.58564f, 3.41040f, 0.282133f, 2.19387f, 
		3.41063f, 0.283344f, 2.53259f, 3.41069f, 0.282055f, 2.18041f, 
		3.41071f, 0.314826f, 2.57587f, 3.41089f, 0.319045f, 2.19512f, 
		3.41089f, 0.282077f, 2.57120f, 3.41091f, 0.318559f, 2.58647f, 
		3.41105f, 0.319111f, 2.56934f, 3.41123f, 0.271025f, 2.25173f, 
		3.41124f, 0.283276f, 2.24989f, 3.41130f, 0.280549f, 2.24054f, 
		3.41150f, 0.280497f, 2.52112f, 3.41165f, 0.318047f, 2.18102f, 
		3.41167f, 0.282273f, 2.18688f, 3.41182f, 0.290954f, 2.18785f, 
		3.41190f, 0.282306f, 2.57786f, 3.41200f, 0.291018f, 2.57840f, 
		3.41203f, 0.266606f, 2.53139f, 3.41207f, 0.284270f, 2.17366f, 
		3.41209f, 0.284218f, 2.56408f, 3.41227f, 0.305290f, 2.57151f, 
		3.41266f, 0.318977f, 2.18678f, 3.41269f, 0.268097f, 2.19921f, 
		3.41285f, 0.318639f, 2.57749f, 3.41287f, 0.266931f, 2.24724f, 
		3.41301f, 0.270585f, 2.22948f, 3.41319f, 0.274475f, 2.52978f, 
		3.41340f, 0.304985f, 2.57816f, 3.41344f, 0.304994f, 2.18686f, 
		3.41346f, 0.284297f, 2.58816f, 3.41357f, 0.284279f, 2.19764f, 
		3.41386f, 0.266524f, 2.52124f, 3.41387f, 0.266529f, 2.23936f, 
		3.41401f, 0.267276f, 2.58746f, 3.41424f, 0.267903f, 2.17758f, 
		3.41432f, 0.268106f, 2.56818f, 3.41459f, 0.283105f, 2.23728f, 
		3.41460f, 0.283102f, 2.51922f, 3.41532f, 0.273153f, 2.24234f, 
		3.41537f, 0.270475f, 2.51757f, 3.41630f, 0.284214f, 2.18645f, 
		3.41632f, 0.284387f, 2.57770f, 3.41641f, 0.266860f, 2.18725f, 
		3.41693f, 0.266912f, 2.57758f, 3.42303f, 0.266331f, 2.15780f, 
		3.42303f, 0.266331f, 2.21374f, 3.42303f, 0.266331f, 2.26967f, 
		3.42303f, 0.266331f, 2.32561f, 3.42303f, 0.266331f, 2.38154f, 
		3.42303f, 0.266331f, 2.43748f, 3.42303f, 0.266331f, 2.49342f, 
		3.42303f, 0.266331f, 2.54935f, 3.42303f, 0.266331f, 2.60529f, 
		3.43273f, 0.270479f, 2.51740f, 3.43314f, 0.266973f, 2.24418f, 
		3.43322f, 0.268559f, 2.57908f, 3.43329f, 0.267202f, 2.18722f, 
		3.43355f, 0.266901f, 2.52731f, 3.43385f, 0.275203f, 2.24598f, 
		3.43402f, 0.270712f, 2.57260f, 3.43404f, 0.283387f, 2.51871f, 
		3.43426f, 0.276095f, 2.52829f, 3.43430f, 0.271664f, 2.23163f, 
		3.43491f, 0.283418f, 2.24855f, 3.43520f, 0.267072f, 2.17760f, 
		3.43583f, 0.284914f, 2.24246f, 3.43590f, 0.288253f, 2.18253f, 
		3.43594f, 0.285072f, 2.52441f, 3.43604f, 0.289348f, 2.58166f, 
		3.43607f, 0.266905f, 2.56977f, 3.43633f, 0.280671f, 2.51946f, 
		3.43653f, 0.269814f, 2.58780f, 3.43661f, 0.268432f, 2.19734f, 
		3.43671f, 0.280711f, 2.23795f, 3.43675f, 0.283517f, 2.53237f, 
		3.43711f, 0.282869f, 2.22917f, 3.43732f, 0.266813f, 2.58617f, 
		3.43771f, 0.280715f, 2.24676f, 3.43815f, 0.283394f, 2.18581f, 
		3.43867f, 0.283576f, 2.57864f, 3.43915f, 0.288226f, 2.19631f, 
		3.43918f, 0.292113f, 2.19101f, 3.43921f, 0.285141f, 2.23018f, 
		3.43922f, 0.288412f, 2.56742f, 3.43929f, 0.302554f, 2.52515f, 
		3.43931f, 0.272764f, 2.50778f, 3.43945f, 0.338721f, 2.18632f, 
		3.43946f, 0.337825f, 2.57821f, 3.43972f, 0.274315f, 2.25527f, 
		3.43986f, 0.342470f, 2.57953f, 3.43994f, 0.301772f, 2.24453f, 
		3.43998f, 0.291789f, 2.17903f, 3.44000f, 0.284941f, 2.51116f, 
		3.44011f, 0.280471f, 2.22987f, 3.44027f, 0.291861f, 2.57065f, 
		3.44043f, 0.302735f, 2.23483f, 3.44064f, 0.334529f, 2.57695f, 
		3.44082f, 0.334635f, 2.18615f, 3.44087f, 0.313618f, 2.52351f, 
		3.44089f, 0.272484f, 2.53870f, 3.44091f, 0.346972f, 2.57463f, 
		3.44091f, 0.346972f, 2.18293f, 3.44101f, 0.285779f, 2.25073f, 
		3.44117f, 0.294360f, 2.58301f, 3.44125f, 0.266777f, 2.22529f, 
		3.44133f, 0.266752f, 2.50769f, 3.44137f, 0.302309f, 2.51586f, 
		3.44143f, 0.315337f, 2.18291f, 3.44143f, 0.315337f, 2.57460f, 
		3.44144f, 0.283489f, 2.56963f, 3.44156f, 0.269198f, 2.56236f, 
		3.44157f, 0.269195f, 2.17066f, 3.44160f, 0.266698f, 2.25581f, 
		3.44166f, 0.343303f, 2.19151f, 3.44171f, 0.343890f, 2.17975f, 
		3.44173f, 0.343318f, 2.58333f, 3.44186f, 0.347666f, 2.58183f, 
		3.44187f, 0.341932f, 2.17894f, 3.44187f, 0.283929f, 2.58610f, 
		3.44190f, 0.266681f, 2.53784f, 3.44190f, 0.280763f, 2.51045f, 
		3.44206f, 0.315517f, 2.23913f, 3.44206f, 0.315310f, 2.19082f, 
		3.44206f, 0.315310f, 2.58252f, 3.44213f, 0.314632f, 2.24502f, 
		3.44214f, 0.337801f, 2.17842f, 3.44222f, 0.283275f, 2.17683f, 
		3.44239f, 0.343117f, 2.57069f, 3.44246f, 0.283599f, 2.19507f, 
		3.44255f, 0.303716f, 2.24858f, 3.44288f, 0.292490f, 2.52390f, 
		3.44303f, 0.331322f, 2.19047f, 3.44308f, 0.321151f, 2.18553f, 
		3.44310f, 0.321280f, 2.57737f, 3.44314f, 0.292054f, 2.23710f, 
		3.44315f, 0.352139f, 2.18427f, 3.44315f, 0.352140f, 2.57597f, 
		3.44326f, 0.280687f, 2.53578f, 3.44327f, 0.347405f, 2.19370f, 
		3.44332f, 0.292316f, 2.24309f, 3.44334f, 0.334552f, 2.58420f, 
		3.44335f, 0.334492f, 2.19249f, 3.44336f, 0.288628f, 2.17247f, 
		3.44359f, 0.339035f, 2.58673f, 3.44364f, 0.300434f, 2.18893f, 
		3.44366f, 0.339187f, 2.19515f, 3.44380f, 0.267023f, 2.59376f, 
		3.44382f, 0.330341f, 2.58348f, 3.44390f, 0.302728f, 2.57837f, 
		3.44390f, 0.276545f, 2.22453f, 3.44423f, 0.305526f, 2.51865f, 
		3.44432f, 0.305444f, 2.23659f, 3.44435f, 0.336121f, 2.56857f, 
		3.44467f, 0.331139f, 2.57046f, 3.44469f, 0.266925f, 2.20205f, 
		3.44486f, 0.288521f, 2.59217f, 3.44489f, 0.313643f, 2.23218f, 
		3.44491f, 0.299530f, 2.23838f, 3.44494f, 0.313731f, 2.51411f, 
		3.44498f, 0.299563f, 2.52019f, 3.44515f, 0.319758f, 2.19220f, 
		3.44515f, 0.291683f, 2.51545f, 3.44516f, 0.319759f, 2.58391f, 
		3.44521f, 0.330972f, 2.17855f, 3.44537f, 0.334406f, 2.17714f, 
		3.44540f, 0.313491f, 2.53146f, 3.44544f, 0.351851f, 2.58374f, 
		3.44544f, 0.351851f, 2.19205f, 3.44551f, 0.305375f, 2.24601f, 
		3.44551f, 0.325722f, 2.18626f, 3.44581f, 0.309415f, 2.57281f, 
		3.44581f, 0.309742f, 2.19012f, 3.44586f, 0.270022f, 2.25861f, 
		3.44587f, 0.309597f, 2.18071f, 3.44640f, 0.275096f, 2.59336f, 
		3.44642f, 0.300872f, 2.17953f, 3.44642f, 0.300871f, 2.57122f, 
		3.44645f, 0.284697f, 2.22520f, 3.44663f, 0.283069f, 2.25774f, 
		3.44664f, 0.347552f, 2.56842f, 3.44676f, 0.284392f, 2.53848f, 
		3.44678f, 0.291959f, 2.24791f, 3.44678f, 0.291960f, 2.52985f, 
		3.44681f, 0.326057f, 2.57331f, 3.44688f, 0.308138f, 2.58237f, 
		3.44692f, 0.325754f, 2.18139f, 3.44692f, 0.283841f, 2.19819f, 
		3.44699f, 0.303478f, 2.53377f, 3.44709f, 0.312015f, 2.24992f, 
		3.44714f, 0.320848f, 2.23989f, 3.44714f, 0.318922f, 2.17767f, 
		3.44724f, 0.288773f, 2.56287f, 3.44738f, 0.283583f, 2.50509f, 
		3.44756f, 0.305299f, 2.52914f, 3.44771f, 0.346332f, 2.17510f, 
		3.44773f, 0.302849f, 2.22882f, 3.44775f, 0.342833f, 2.19634f, 
		3.44780f, 0.318524f, 2.56867f, 3.44788f, 0.330673f, 2.19472f, 
		3.44793f, 0.342853f, 2.58820f, 3.44810f, 0.325916f, 2.19151f, 
		3.44817f, 0.288739f, 2.20133f, 3.44835f, 0.299967f, 2.19342f, 
		3.44837f, 0.313780f, 2.56814f, 3.44843f, 0.269812f, 2.22184f, 
		3.44854f, 0.299479f, 2.24707f, 3.44870f, 0.338391f, 2.56610f, 
		3.44870f, 0.299608f, 2.52901f, 3.44872f, 0.267166f, 2.16809f, 
		3.44872f, 0.267166f, 2.55978f, 3.44876f, 0.321821f, 2.52456f, 
		3.44879f, 0.347203f, 2.58849f, 3.44881f, 0.285113f, 2.25576f, 
		3.44889f, 0.338376f, 2.17439f, 3.44896f, 0.325795f, 2.58382f, 
		3.44932f, 0.352657f, 2.17838f, 3.44933f, 0.352650f, 2.57006f, 
		3.44963f, 0.314776f, 2.19624f, 3.44963f, 0.314777f, 2.58794f, 
		3.44967f, 0.283634f, 2.56526f, 3.44970f, 0.280918f, 2.22521f, 
		3.44975f, 0.299347f, 2.23407f, 3.44988f, 0.334311f, 2.19641f, 
		3.45019f, 0.343570f, 2.56659f, 3.45025f, 0.337400f, 2.58952f, 
		3.45031f, 0.303258f, 2.51046f, 3.45034f, 0.298781f, 2.51565f, 
		3.45036f, 0.337333f, 2.19793f, 3.45037f, 0.283522f, 2.59025f, 
		3.45040f, 0.315729f, 2.53216f, 3.45073f, 0.315491f, 2.17572f, 
		3.45085f, 0.280379f, 2.25608f, 3.45097f, 0.319262f, 2.24789f, 
		3.45101f, 0.334236f, 2.58841f, 3.45116f, 0.283443f, 2.17337f, 
		3.45122f, 0.268283f, 2.18600f, 3.45122f, 0.268283f, 2.57770f, 
		3.45123f, 0.267885f, 2.52244f, 3.45125f, 0.292452f, 2.23151f, 
		3.45140f, 0.300997f, 2.58553f, 3.45154f, 0.267857f, 2.24052f, 
		3.45154f, 0.308048f, 2.19238f, 3.45173f, 0.309033f, 2.58445f, 
		3.45198f, 0.270496f, 2.50318f, 3.45215f, 0.305756f, 2.23197f, 
		3.45229f, 0.285722f, 2.50786f, 3.45230f, 0.305793f, 2.51393f, 
		3.45235f, 0.325993f, 2.17999f, 3.45240f, 0.280392f, 2.50690f, 
		3.45243f, 0.345930f, 2.19734f, 3.45257f, 0.317259f, 2.51331f, 
		3.45258f, 0.317269f, 2.23138f, 3.45269f, 0.342718f, 2.17451f, 
		3.45278f, 0.326104f, 2.57193f, 3.45313f, 0.347669f, 2.17578f, 
		3.45325f, 0.352131f, 2.19411f, 3.45325f, 0.352130f, 2.58580f, 
		3.45334f, 0.270528f, 2.54138f, 3.45372f, 0.331036f, 2.58682f, 
		3.45401f, 0.302130f, 2.22888f, 3.45411f, 0.294200f, 2.19697f, 
		3.45416f, 0.321854f, 2.52258f, 3.45442f, 0.331074f, 2.17723f, 
		3.45448f, 0.355033f, 2.18671f, 3.45448f, 0.355033f, 2.57841f, 
		3.45464f, 0.288914f, 2.59280f, 3.45468f, 0.298784f, 2.24613f, 
		3.45469f, 0.318903f, 2.58624f, 3.45478f, 0.288128f, 2.17053f, 
		3.45482f, 0.292331f, 2.51442f, 3.45483f, 0.318929f, 2.19450f, 
		3.45489f, 0.325922f, 2.19111f, 3.45489f, 0.343389f, 2.58812f, 
		3.45496f, 0.305222f, 2.24865f, 3.45497f, 0.341158f, 2.56626f, 
		3.45510f, 0.301085f, 2.53334f, 3.45512f, 0.274125f, 2.22229f, 
		3.45515f, 0.292861f, 2.17444f, 3.45516f, 0.335549f, 2.56713f, 
		3.45526f, 0.300452f, 2.57074f, 3.45527f, 0.335523f, 2.17559f, 
		3.45529f, 0.300390f, 2.17905f, 3.45530f, 0.300829f, 2.25110f, 
		3.45547f, 0.310385f, 2.25004f, 3.45553f, 0.309703f, 2.57224f, 
		3.45553f, 0.309703f, 2.18054f, 3.45566f, 0.288570f, 2.53334f, 
		3.45566f, 0.288570f, 2.25141f, 3.45592f, 0.269007f, 2.20383f, 
		3.45595f, 0.283597f, 2.19771f, 3.45600f, 0.269834f, 2.25901f, 
		3.45603f, 0.326010f, 2.58146f, 3.45620f, 0.287155f, 2.22869f, 
		3.45623f, 0.321119f, 2.23894f, 3.45632f, 0.339243f, 2.19684f, 
		3.45641f, 0.299469f, 2.52734f, 3.45648f, 0.305299f, 2.52885f, 
		3.45658f, 0.280422f, 2.53695f, 3.45661f, 0.313363f, 2.53228f, 
		3.45671f, 0.268550f, 2.59536f, 3.45671f, 0.330917f, 2.56978f, 
		3.45692f, 0.325985f, 2.18382f, 3.45692f, 0.292167f, 2.56606f, 
		3.45702f, 0.326105f, 2.57609f, 3.45705f, 0.308138f, 2.58018f, 
		3.45722f, 0.288851f, 2.20022f, 3.45723f, 0.351886f, 2.57168f, 
		3.45725f, 0.331198f, 2.19360f, 3.45725f, 0.351861f, 2.17995f, 
		3.45729f, 0.283525f, 2.53932f, 3.45744f, 0.299587f, 2.51894f, 
		3.45759f, 0.300339f, 2.19072f, 3.45766f, 0.299473f, 2.23720f, 
		3.45770f, 0.269276f, 2.56069f, 3.45774f, 0.283516f, 2.58847f, 
		3.45786f, 0.334757f, 2.19411f, 3.45787f, 0.288173f, 2.56344f, 
		3.45789f, 0.283602f, 2.17541f, 3.45791f, 0.346197f, 2.56842f, 
		3.45793f, 0.283649f, 2.25703f, 3.45794f, 0.315781f, 2.17821f, 
		3.45794f, 0.292508f, 2.52804f, 3.45797f, 0.309601f, 2.18734f, 
		3.45811f, 0.283523f, 2.56712f, 3.45828f, 0.315893f, 2.57012f, 
		3.45860f, 0.268529f, 2.16951f, 3.45879f, 0.334292f, 2.58514f, 
		3.45895f, 0.346094f, 2.17772f, 3.45898f, 0.318990f, 2.52087f, 
		3.45905f, 0.284395f, 2.22505f, 3.45912f, 0.347610f, 2.19255f, 
		3.45926f, 0.299837f, 2.57687f, 3.45926f, 0.299837f, 2.18517f, 
		3.45927f, 0.315636f, 2.19236f, 3.45928f, 0.315637f, 2.58405f, 
		3.45937f, 0.277100f, 2.17256f, 3.45941f, 0.305378f, 2.52121f, 
		3.45942f, 0.312261f, 2.51531f, 3.45943f, 0.312313f, 2.23341f, 
		3.45950f, 0.314965f, 2.24698f, 3.45965f, 0.293518f, 2.24107f, 
		3.45975f, 0.301668f, 2.51361f, 3.45984f, 0.283685f, 2.50640f, 
		3.45989f, 0.330546f, 2.18311f, 3.45990f, 0.276555f, 2.25589f, 
		3.45994f, 0.292266f, 2.52061f, 3.45996f, 0.305662f, 2.24082f, 
		3.46003f, 0.346648f, 2.58434f, 3.46021f, 0.340104f, 2.58532f, 
		3.46028f, 0.343127f, 2.57217f, 3.46031f, 0.266584f, 2.53758f, 
		3.46033f, 0.343566f, 2.19266f, 3.46036f, 0.266557f, 2.25560f, 
		3.46060f, 0.266877f, 2.20003f, 3.46063f, 0.292738f, 2.58571f, 
		3.46069f, 0.332078f, 2.57929f, 3.46081f, 0.266719f, 2.22516f, 
		3.46081f, 0.266719f, 2.50709f, 3.46098f, 0.339421f, 2.17906f, 
		3.46099f, 0.343110f, 2.58183f, 3.46103f, 0.339453f, 2.57080f, 
		3.46106f, 0.266912f, 2.59229f, 3.46109f, 0.282367f, 2.22567f, 
		3.46118f, 0.316150f, 2.24042f, 3.46124f, 0.348711f, 2.18704f, 
		3.46131f, 0.301918f, 2.23381f, 3.46136f, 0.334507f, 2.18784f, 
		3.46140f, 0.335521f, 2.57352f, 3.46141f, 0.335575f, 2.18126f, 
		3.46153f, 0.316142f, 2.57670f, 3.46157f, 0.316228f, 2.18521f, 
		3.46159f, 0.266919f, 2.56423f, 3.46159f, 0.266919f, 2.17253f, 
		3.46161f, 0.343219f, 2.18234f, 3.46178f, 0.280500f, 2.22962f, 
		3.46223f, 0.312360f, 2.52445f, 3.46223f, 0.347565f, 2.57836f, 
		3.46227f, 0.283706f, 2.19205f, 3.46233f, 0.337684f, 2.58256f, 
		3.46253f, 0.283479f, 2.58292f, 3.46255f, 0.338447f, 2.18956f, 
		3.46271f, 0.286786f, 2.23393f, 3.46283f, 0.280482f, 2.51313f, 
		3.46315f, 0.273953f, 2.50795f, 3.46316f, 0.272833f, 2.22585f, 
		3.46319f, 0.283595f, 2.18254f, 3.46338f, 0.302100f, 2.52449f, 
		3.46343f, 0.288994f, 2.17679f, 3.46360f, 0.283592f, 2.57534f, 
		3.46364f, 0.302354f, 2.24266f, 3.46372f, 0.288795f, 2.19510f, 
		3.46378f, 0.292202f, 2.57521f, 3.46382f, 0.270781f, 2.53699f, 
		3.46394f, 0.288320f, 2.58669f, 3.46412f, 0.285256f, 2.51399f, 
		3.46455f, 0.283340f, 2.25184f, 3.46482f, 0.270069f, 2.58916f, 
		3.46567f, 0.280594f, 2.24541f, 3.46614f, 0.280483f, 2.52290f, 
		3.46637f, 0.269006f, 2.56760f, 3.46647f, 0.268623f, 2.17636f, 
		3.46664f, 0.288988f, 2.18530f, 3.46671f, 0.283278f, 2.53107f, 
		3.46697f, 0.288649f, 2.57551f, 3.46713f, 0.268561f, 2.19501f, 
		3.46762f, 0.284238f, 2.24124f, 3.46766f, 0.266839f, 2.18601f, 
		3.46766f, 0.266839f, 2.57770f, 3.46778f, 0.270108f, 2.24980f, 
		3.46786f, 0.274353f, 2.53077f, 3.46850f, 0.276229f, 2.24536f, 
		3.46864f, 0.275429f, 2.51737f, 3.46874f, 0.269312f, 2.51566f, 
		3.46888f, 0.283249f, 2.52087f, 3.46905f, 0.272155f, 2.23329f, 
		3.46907f, 0.282627f, 2.23793f, 3.46928f, 0.266590f, 2.24174f, 
		3.46929f, 0.266587f, 2.52363f, 3.46931f, 0.269358f, 2.18573f, 
		3.46952f, 0.268641f, 2.57879f, 3.47897f, 0.266331f, 2.15780f, 
		3.47897f, 0.266331f, 2.21374f, 3.47897f, 0.266331f, 2.26967f, 
		3.47897f, 0.266331f, 2.32561f, 3.47897f, 0.266331f, 2.38154f, 
		3.47897f, 0.266331f, 2.43748f, 3.47897f, 0.266331f, 2.49342f, 
		3.47897f, 0.266331f, 2.54935f, 3.47897f, 0.266331f, 2.60529f, 
		3.48604f, 0.267638f, 2.57708f, 3.48655f, 0.267652f, 2.18283f, 
		3.48732f, 0.279573f, 2.57653f, 3.48759f, 0.279808f, 2.18660f, 
		3.48761f, 0.268093f, 2.19464f, 3.48898f, 0.269394f, 2.58850f, 
		3.48915f, 0.273476f, 2.52032f, 3.48931f, 0.280423f, 2.19397f, 
		3.48988f, 0.267228f, 2.52129f, 3.49008f, 0.266850f, 2.23922f, 
		3.49010f, 0.275383f, 2.24653f, 3.49029f, 0.269644f, 2.24827f, 
		3.49031f, 0.283873f, 2.52249f, 3.49085f, 0.267669f, 2.56497f, 
		3.49104f, 0.271621f, 2.23203f, 3.49124f, 0.280099f, 2.58855f, 
		3.49125f, 0.269395f, 2.17352f, 3.49136f, 0.270851f, 2.53348f, 
		3.49161f, 0.281626f, 2.24359f, 3.49165f, 0.280299f, 2.17620f, 
		3.49181f, 0.284863f, 2.24099f, 3.49187f, 0.269323f, 2.20156f, 
		3.49238f, 0.283185f, 2.53250f, 3.49243f, 0.281006f, 2.56561f, 
		3.49253f, 0.291303f, 2.18189f, 3.49282f, 0.295802f, 2.18916f, 
		3.49297f, 0.272655f, 2.51133f, 3.49305f, 0.286881f, 2.57867f, 
		3.49331f, 0.287171f, 2.18524f, 3.49336f, 0.291050f, 2.19432f, 
		3.49345f, 0.295832f, 2.57922f, 3.49383f, 0.267498f, 2.17281f, 
		3.49401f, 0.280738f, 2.51744f, 3.49432f, 0.280435f, 2.23336f, 
		3.49463f, 0.291355f, 2.56939f, 3.49475f, 0.282941f, 2.51103f, 
		3.49476f, 0.282947f, 2.22909f, 3.49493f, 0.280642f, 2.53205f, 
		3.49522f, 0.295724f, 2.57080f, 3.49522f, 0.283712f, 2.25325f, 
		3.49525f, 0.267601f, 2.59435f, 3.49578f, 0.273972f, 2.25585f, 
		3.49580f, 0.285148f, 2.53319f, 3.49613f, 0.287000f, 2.57020f, 
		3.49615f, 0.295866f, 2.58617f, 3.49657f, 0.303407f, 2.51945f, 
		3.49668f, 0.280553f, 2.20291f, 3.49678f, 0.301925f, 2.24572f, 
		3.49718f, 0.302676f, 2.23544f, 3.49761f, 0.266875f, 2.22684f, 
		3.49774f, 0.286988f, 2.19647f, 3.49807f, 0.285211f, 2.51153f, 
		3.49811f, 0.311872f, 2.52662f, 3.49811f, 0.266701f, 2.25673f, 
		3.49815f, 0.267465f, 2.20378f, 3.49824f, 0.290279f, 2.52631f, 
		3.49834f, 0.311726f, 2.51933f, 3.49835f, 0.311881f, 2.23741f, 
		3.49837f, 0.313763f, 2.24621f, 3.49838f, 0.295914f, 2.17710f, 
		3.49842f, 0.266684f, 2.53877f, 3.49843f, 0.290308f, 2.23815f, 
		3.49843f, 0.290308f, 2.52009f, 3.49851f, 0.287022f, 2.58827f, 
		3.49892f, 0.269008f, 2.55903f, 3.49907f, 0.274626f, 2.50704f, 
		3.49941f, 0.302438f, 2.53247f, 3.49963f, 0.291017f, 2.59126f, 
		3.49973f, 0.266735f, 2.50709f, 3.49986f, 0.305341f, 2.24257f, 
		3.49991f, 0.317818f, 2.24047f, 3.49991f, 0.317818f, 2.52241f, 
		3.49995f, 0.274608f, 2.54023f, 3.50013f, 0.280712f, 2.22863f, 
		3.50014f, 0.280373f, 2.17022f, 3.50026f, 0.290444f, 2.20027f, 
		3.50068f, 0.305477f, 2.52184f, 3.50074f, 0.302285f, 2.17044f, 
		3.50075f, 0.295408f, 2.18289f, 3.50081f, 0.280322f, 2.59533f, 
		3.50088f, 0.291998f, 2.56420f, 3.50095f, 0.299147f, 2.52248f, 
		3.50095f, 0.269423f, 2.20682f, 3.50096f, 0.291986f, 2.24733f, 
		3.50097f, 0.295080f, 2.19326f, 3.50107f, 0.295253f, 2.57108f, 
		3.50107f, 0.285686f, 2.22833f, 3.50112f, 0.295432f, 2.58314f, 
		3.50113f, 0.313671f, 2.23314f, 3.50121f, 0.313750f, 2.51506f, 
		3.50122f, 0.317847f, 2.17120f, 3.50128f, 0.303064f, 2.56070f, 
		3.50134f, 0.291360f, 2.17327f, 3.50139f, 0.302900f, 2.59480f, 
		3.50143f, 0.283581f, 2.25814f, 3.50147f, 0.307976f, 2.56162f, 
		3.50148f, 0.302958f, 2.20453f, 3.50160f, 0.313924f, 2.19298f, 
		3.50166f, 0.307650f, 2.20413f, 3.50172f, 0.314407f, 2.57274f, 
		3.50173f, 0.320270f, 2.19039f, 3.50185f, 0.316869f, 2.59356f, 
		3.50186f, 0.274687f, 2.22358f, 3.50187f, 0.337183f, 2.17168f, 
		3.50187f, 0.287028f, 2.17541f, 3.50188f, 0.319915f, 2.57686f, 
		3.50191f, 0.313490f, 2.53238f, 3.50194f, 0.322281f, 2.57119f, 
		3.50196f, 0.323413f, 2.56353f, 3.50205f, 0.299434f, 2.23721f, 
		3.50214f, 0.329537f, 2.56337f, 3.50218f, 0.323546f, 2.20175f, 
		3.50223f, 0.334285f, 2.56341f, 3.50224f, 0.342988f, 2.18004f, 
		3.50228f, 0.329560f, 2.20203f, 3.50235f, 0.269908f, 2.25950f, 
		3.50237f, 0.303478f, 2.25179f, 3.50237f, 0.342792f, 2.18694f, 
		3.50242f, 0.334622f, 2.20121f, 3.50247f, 0.336596f, 2.59398f, 
		3.50258f, 0.350523f, 2.18409f, 3.50259f, 0.342650f, 2.57813f, 
		3.50262f, 0.295922f, 2.19938f, 3.50265f, 0.342844f, 2.58545f, 
		3.50266f, 0.337759f, 2.57142f, 3.50280f, 0.269584f, 2.59804f, 
		3.50292f, 0.350756f, 2.58089f, 3.50297f, 0.291214f, 2.51542f, 
		3.50310f, 0.292005f, 2.53058f, 3.50314f, 0.299428f, 2.24594f, 
		3.50316f, 0.299475f, 2.52788f, 3.50333f, 0.284402f, 2.53933f, 
		3.50373f, 0.287195f, 2.56572f, 3.50394f, 0.283644f, 2.22411f, 
		3.50400f, 0.313150f, 2.25166f, 3.50402f, 0.283583f, 2.50601f, 
		3.50405f, 0.305290f, 2.53004f, 3.50406f, 0.280663f, 2.25597f, 
		3.50486f, 0.268931f, 2.16685f, 3.50489f, 0.295938f, 2.59025f, 
		3.50513f, 0.321396f, 2.52523f, 3.50513f, 0.321396f, 2.24330f, 
		3.50549f, 0.302469f, 2.22962f, 3.50562f, 0.299437f, 2.51710f, 
		3.50571f, 0.295049f, 2.23409f, 3.50597f, 0.266641f, 2.22384f, 
		3.50607f, 0.268156f, 2.18728f, 3.50607f, 0.268156f, 2.57786f, 
		3.50611f, 0.287173f, 2.19985f, 3.50616f, 0.267543f, 2.55799f, 
		3.50624f, 0.285843f, 2.25579f, 3.50669f, 0.301908f, 2.51125f, 
		3.50671f, 0.267557f, 2.20710f, 3.50681f, 0.279547f, 2.55883f, 
		3.50703f, 0.295944f, 2.56524f, 3.50728f, 0.272691f, 2.50459f, 
		3.50729f, 0.317317f, 2.53249f, 3.50749f, 0.320203f, 2.51791f, 
		3.50749f, 0.320203f, 2.23597f, 3.50757f, 0.305510f, 2.51532f, 
		3.50769f, 0.280689f, 2.50822f, 3.50774f, 0.267885f, 2.52337f, 
		3.50803f, 0.305561f, 2.23314f, 3.50805f, 0.267857f, 2.24145f, 
		3.50811f, 0.279454f, 2.20584f, 3.50836f, 0.279035f, 2.16862f, 
		3.50882f, 0.285714f, 2.50878f, 3.50889f, 0.312913f, 2.23062f, 
		3.50889f, 0.312907f, 2.51256f, 3.50901f, 0.303408f, 2.53541f, 
		3.50909f, 0.287013f, 2.58996f, 3.50923f, 0.350499f, 2.18442f, 
		3.50934f, 0.343046f, 2.17991f, 3.50937f, 0.336950f, 2.17120f, 
		3.50949f, 0.350370f, 2.58090f, 3.50960f, 0.342652f, 2.18685f, 
		3.50976f, 0.342763f, 2.57826f, 3.50977f, 0.337798f, 2.19436f, 
		3.50978f, 0.343019f, 2.58514f, 3.50982f, 0.280535f, 2.53813f, 
		3.50994f, 0.337561f, 2.59343f, 3.50996f, 0.305124f, 2.24933f, 
		3.50998f, 0.317568f, 2.17153f, 3.51001f, 0.334492f, 2.56382f, 
		3.51011f, 0.291664f, 2.56394f, 3.51012f, 0.329957f, 2.56313f, 
		3.51013f, 0.334532f, 2.20131f, 3.51027f, 0.329651f, 2.20175f, 
		3.51030f, 0.319712f, 2.18870f, 3.51034f, 0.323535f, 2.56389f, 
		3.51039f, 0.322503f, 2.57050f, 3.51042f, 0.323078f, 2.19908f, 
		3.51043f, 0.303004f, 2.17030f, 3.51049f, 0.319967f, 2.57690f, 
		3.51051f, 0.314401f, 2.19243f, 3.51054f, 0.286999f, 2.17563f, 
		3.51057f, 0.321845f, 2.24169f, 3.51057f, 0.321845f, 2.52363f, 
		3.51062f, 0.295943f, 2.17544f, 3.51063f, 0.317958f, 2.59401f, 
		3.51064f, 0.313975f, 2.57212f, 3.51076f, 0.299144f, 2.52987f, 
		3.51083f, 0.307458f, 2.56100f, 3.51093f, 0.295432f, 2.18191f, 
		3.51095f, 0.302968f, 2.56066f, 3.51103f, 0.307994f, 2.20351f, 
		3.51104f, 0.300422f, 2.25165f, 3.51114f, 0.302292f, 2.59479f, 
		3.51118f, 0.295104f, 2.19299f, 3.51119f, 0.302563f, 2.20425f, 
		3.51129f, 0.295096f, 2.57189f, 3.51132f, 0.295409f, 2.58234f, 
		3.51139f, 0.289201f, 2.25203f, 3.51139f, 0.289201f, 2.53396f, 
		3.51160f, 0.318488f, 2.24853f, 3.51170f, 0.303385f, 2.25248f, 
		3.51174f, 0.292402f, 2.51564f, 3.51182f, 0.310732f, 2.53298f, 
		3.51190f, 0.310777f, 2.25102f, 3.51190f, 0.294412f, 2.20050f, 
		3.51190f, 0.267655f, 2.59692f, 3.51200f, 0.280430f, 2.59494f, 
		3.51206f, 0.299262f, 2.24704f, 3.51230f, 0.291734f, 2.17427f, 
		3.51234f, 0.271660f, 2.54216f, 3.51237f, 0.271626f, 2.26021f, 
		3.51246f, 0.283952f, 2.25840f, 3.51254f, 0.287115f, 2.56710f, 
		3.51269f, 0.287948f, 2.23029f, 3.51281f, 0.291360f, 2.59074f, 
		3.51290f, 0.283964f, 2.54007f, 3.51323f, 0.305401f, 2.52924f, 
		3.51330f, 0.287058f, 2.19748f, 3.51358f, 0.299221f, 2.23742f, 
		3.51364f, 0.295910f, 2.58808f, 3.51366f, 0.266796f, 2.50608f, 
		3.51386f, 0.298641f, 2.52047f, 3.51397f, 0.300797f, 2.23232f, 
		3.51452f, 0.267457f, 2.17057f, 3.51510f, 0.317048f, 2.51761f, 
		3.51530f, 0.283374f, 2.22522f, 3.51548f, 0.319010f, 2.23988f, 
		3.51565f, 0.294371f, 2.24067f, 3.51573f, 0.295424f, 2.56916f, 
		3.51577f, 0.280527f, 2.25423f, 3.51581f, 0.310459f, 2.51680f, 
		3.51583f, 0.299521f, 2.52392f, 3.51590f, 0.293239f, 2.52516f, 
		3.51591f, 0.305299f, 2.24081f, 3.51592f, 0.312299f, 2.23432f, 
		3.51596f, 0.315035f, 2.52990f, 3.51624f, 0.280391f, 2.17236f, 
		3.51637f, 0.287175f, 2.58514f, 3.51645f, 0.305538f, 2.52365f, 
		3.51647f, 0.276510f, 2.50796f, 3.51656f, 0.283779f, 2.50764f, 
		3.51659f, 0.273814f, 2.22470f, 3.51683f, 0.266583f, 2.53850f, 
		3.51694f, 0.266921f, 2.25672f, 3.51721f, 0.280424f, 2.22927f, 
		3.51729f, 0.302712f, 2.51522f, 3.51734f, 0.295688f, 2.19398f, 
		3.51734f, 0.287012f, 2.18190f, 3.51769f, 0.316147f, 2.52328f, 
		3.51787f, 0.287055f, 2.57301f, 3.51788f, 0.288709f, 2.23591f, 
		3.51789f, 0.288072f, 2.51631f, 3.51841f, 0.266520f, 2.22705f, 
		3.51846f, 0.295817f, 2.18460f, 3.51849f, 0.286905f, 2.19110f, 
		3.51855f, 0.290976f, 2.18037f, 3.51858f, 0.303334f, 2.23647f, 
		3.51874f, 0.312345f, 2.24349f, 3.51884f, 0.295823f, 2.57870f, 
		3.51888f, 0.288042f, 2.24603f, 3.51893f, 0.290964f, 2.57114f, 
		3.51916f, 0.280333f, 2.20014f, 3.51925f, 0.269221f, 2.17192f, 
		3.51947f, 0.267450f, 2.20034f, 3.51963f, 0.303074f, 2.52700f, 
		3.51966f, 0.302082f, 2.24567f, 3.51980f, 0.291632f, 2.58226f, 
		3.52019f, 0.280087f, 2.56589f, 3.52024f, 0.267431f, 2.56510f, 
		3.52028f, 0.280502f, 2.53138f, 3.52031f, 0.280362f, 2.58906f, 
		3.52039f, 0.269254f, 2.20177f, 3.52079f, 0.266816f, 2.51048f, 
		3.52090f, 0.286690f, 2.52653f, 3.52132f, 0.276450f, 2.53488f, 
		3.52133f, 0.276551f, 2.25287f, 3.52151f, 0.269170f, 2.56428f, 
		3.52165f, 0.280349f, 2.51700f, 3.52176f, 0.283378f, 2.53444f, 
		3.52191f, 0.269400f, 2.59051f, 3.52230f, 0.283168f, 2.25213f, 
		3.52266f, 0.280430f, 2.24243f, 3.52296f, 0.280426f, 2.18050f, 
		3.52317f, 0.283259f, 2.23258f, 3.52384f, 0.267489f, 2.58370f, 
		3.52406f, 0.279804f, 2.19088f, 3.52430f, 0.270110f, 2.53266f, 
		3.52430f, 0.270110f, 2.25073f, 3.52449f, 0.267592f, 2.18010f, 
		3.52467f, 0.279732f, 2.57967f, 3.52469f, 0.283618f, 2.24035f, 
		3.52529f, 0.276223f, 2.52429f, 3.52542f, 0.266555f, 2.52425f, 
		3.52542f, 0.266548f, 2.24268f, 3.52570f, 0.272037f, 2.23431f, 
		3.52576f, 0.283102f, 2.52106f, 3.52604f, 0.272239f, 2.51741f, 
		3.52632f, 0.274135f, 2.24132f, 3.52639f, 0.269125f, 2.57779f, 
		3.52647f, 0.268941f, 2.18810f, 3.53490f, 0.266331f, 2.15780f, 
		3.53490f, 0.266331f, 2.21374f, 3.53490f, 0.266331f, 2.26967f, 
		3.53490f, 0.266331f, 2.32561f, 3.53490f, 0.266331f, 2.38154f, 
		3.53490f, 0.266331f, 2.43748f, 3.53490f, 0.266331f, 2.49342f, 
		3.53490f, 0.266331f, 2.54935f, 3.53490f, 0.266331f, 2.60529f, 
		3.53982f, 0.269082f, 2.57978f, 3.54103f, 0.268227f, 2.18252f, 
		3.54152f, 0.350003f, 2.58080f, 3.54171f, 0.348448f, 2.57274f, 
		3.54190f, 0.269197f, 2.19065f, 3.54194f, 0.267122f, 2.57408f, 
		3.54195f, 0.292356f, 2.57568f, 3.54208f, 0.349225f, 2.18119f, 
		3.54230f, 0.287493f, 2.57418f, 3.54248f, 0.311970f, 2.58048f, 
		3.54299f, 0.293014f, 2.18783f, 3.54314f, 0.315097f, 2.18796f, 
		3.54314f, 0.316811f, 2.57369f, 3.54320f, 0.287493f, 2.18017f, 
		3.54355f, 0.291357f, 2.58855f, 3.54357f, 0.311811f, 2.18531f, 
		3.54374f, 0.268411f, 2.56667f, 3.54381f, 0.273476f, 2.52032f, 
		3.54410f, 0.292198f, 2.17658f, 3.54421f, 0.287708f, 2.58903f, 
		3.54421f, 0.317324f, 2.58492f, 3.54434f, 0.283468f, 2.24203f, 
		3.54437f, 0.268351f, 2.52814f, 3.54437f, 0.346065f, 2.58839f, 
		3.54473f, 0.266871f, 2.23920f, 3.54476f, 0.275384f, 2.24653f, 
		3.54489f, 0.349540f, 2.59008f, 3.54495f, 0.269645f, 2.24827f, 
		3.54511f, 0.287708f, 2.19502f, 3.54514f, 0.349516f, 2.19562f, 
		3.54525f, 0.267239f, 2.19243f, 3.54531f, 0.348888f, 2.56596f, 
		3.54536f, 0.315571f, 2.17548f, 3.54561f, 0.346071f, 2.19453f, 
		3.54570f, 0.271622f, 2.23203f, 3.54586f, 0.286249f, 2.57593f, 
		3.54594f, 0.268637f, 2.17067f, 3.54609f, 0.291189f, 2.56533f, 
		3.54610f, 0.283387f, 2.53148f, 3.54651f, 0.349798f, 2.17262f, 
		3.54668f, 0.346035f, 2.56709f, 3.54669f, 0.346148f, 2.17242f, 
		3.54670f, 0.266781f, 2.51533f, 3.54676f, 0.286249f, 2.18192f, 
		3.54697f, 0.284924f, 2.52547f, 3.54712f, 0.269236f, 2.59482f, 
		3.54714f, 0.316363f, 2.56637f, 3.54737f, 0.267201f, 2.17461f, 
		3.54779f, 0.311896f, 2.59144f, 3.54802f, 0.269236f, 2.20081f, 
		3.54806f, 0.273031f, 2.53554f, 3.54827f, 0.280786f, 2.52794f, 
		3.54834f, 0.282857f, 2.51194f, 3.54837f, 0.332460f, 2.57828f, 
		3.54837f, 0.303715f, 2.58009f, 3.54867f, 0.280737f, 2.51745f, 
		3.54881f, 0.311867f, 2.19753f, 3.54882f, 0.280871f, 2.23503f, 
		3.54900f, 0.270157f, 2.56143f, 3.54906f, 0.291671f, 2.20037f, 
		3.54908f, 0.287086f, 2.23927f, 3.54935f, 0.280762f, 2.24781f, 
		3.54946f, 0.303834f, 2.18455f, 3.54959f, 0.349186f, 2.59540f, 
		3.54968f, 0.311904f, 2.56402f, 3.54982f, 0.283667f, 2.25357f, 
		3.54983f, 0.333022f, 2.17919f, 3.54988f, 0.286353f, 2.58961f, 
		3.54993f, 0.269663f, 2.50923f, 3.55027f, 0.316407f, 2.19963f, 
		3.55042f, 0.285153f, 2.51299f, 3.55043f, 0.277005f, 2.22855f, 
		3.55044f, 0.311017f, 2.57324f, 3.55044f, 0.273971f, 2.25585f, 
		3.55051f, 0.316725f, 2.59444f, 3.55058f, 0.311906f, 2.17001f, 
		3.55068f, 0.311032f, 2.58456f, 3.55072f, 0.332887f, 2.58654f, 
		3.55078f, 0.286353f, 2.19559f, 3.55081f, 0.302719f, 2.52595f, 
		3.55103f, 0.304018f, 2.57130f, 3.55111f, 0.347890f, 2.20260f, 
		3.55112f, 0.302622f, 2.24594f, 3.55119f, 0.276506f, 2.50969f, 
		3.55122f, 0.284953f, 2.23011f, 3.55133f, 0.311043f, 2.19021f, 
		3.55143f, 0.267275f, 2.59628f, 3.55159f, 0.311010f, 2.17889f, 
		3.55185f, 0.335979f, 2.57710f, 3.55196f, 0.332820f, 2.19303f, 
		3.55204f, 0.302752f, 2.23494f, 3.55208f, 0.285799f, 2.53349f, 
		3.55214f, 0.324239f, 2.18149f, 3.55227f, 0.348895f, 2.56000f, 
		3.55229f, 0.313541f, 2.52143f, 3.55232f, 0.302433f, 2.51685f, 
		3.55255f, 0.328079f, 2.18563f, 3.55257f, 0.303774f, 2.58806f, 
		3.55261f, 0.335842f, 2.18596f, 3.55262f, 0.325591f, 2.57875f, 
		3.55272f, 0.266708f, 2.53863f, 3.55273f, 0.314012f, 2.24366f, 
		3.55293f, 0.266756f, 2.25681f, 3.55301f, 0.311867f, 2.23741f, 
		3.55304f, 0.292919f, 2.59666f, 3.55307f, 0.344871f, 2.18286f, 
		3.55314f, 0.291384f, 2.16621f, 3.55315f, 0.291881f, 2.52284f, 
		3.55321f, 0.348932f, 2.16602f, 3.55359f, 0.313345f, 2.52914f, 
		3.55369f, 0.333234f, 2.56745f, 3.55372f, 0.344850f, 2.58418f, 
		3.55378f, 0.344749f, 2.57418f, 3.55381f, 0.303665f, 2.17484f, 
		3.55401f, 0.324937f, 2.19008f, 3.55406f, 0.316905f, 2.16762f, 
		3.55431f, 0.286309f, 2.56481f, 3.55435f, 0.280665f, 2.53672f, 
		3.55445f, 0.316066f, 2.56077f, 3.55448f, 0.281147f, 2.22772f, 
		3.55481f, 0.335735f, 2.17826f, 3.55488f, 0.291324f, 2.24648f, 
		3.55490f, 0.301734f, 2.53247f, 3.55493f, 0.266649f, 2.22497f, 
		3.55494f, 0.287978f, 2.59757f, 3.55501f, 0.305428f, 2.52181f, 
		3.55511f, 0.303995f, 2.19587f, 3.55519f, 0.287331f, 2.56041f, 
		3.55521f, 0.286309f, 2.17080f, 3.55527f, 0.335957f, 2.57143f, 
		3.55545f, 0.305420f, 2.24465f, 3.55567f, 0.336235f, 2.58690f, 
		3.55584f, 0.287977f, 2.20356f, 3.55589f, 0.270135f, 2.16452f, 
		3.55593f, 0.367633f, 2.57813f, 3.55609f, 0.287332f, 2.16640f, 
		3.55609f, 0.283581f, 2.25814f, 3.55620f, 0.313738f, 2.51498f, 
		3.55627f, 0.317580f, 2.23560f, 3.55638f, 0.312153f, 2.59654f, 
		3.55641f, 0.325484f, 2.57115f, 3.55646f, 0.267987f, 2.20556f, 
		3.55647f, 0.299720f, 2.24526f, 3.55659f, 0.268466f, 2.55775f, 
		3.55670f, 0.271395f, 2.22324f, 3.55671f, 0.299441f, 2.51914f, 
		3.55681f, 0.325475f, 2.17729f, 3.55682f, 0.367618f, 2.18413f, 
		3.55691f, 0.377095f, 2.58031f, 3.55698f, 0.305303f, 2.23626f, 
		3.55703f, 0.270021f, 2.54147f, 3.55707f, 0.325700f, 2.58652f, 
		3.55708f, 0.344806f, 2.19172f, 3.55728f, 0.312153f, 2.20253f, 
		3.55735f, 0.368632f, 2.58170f, 3.55739f, 0.332784f, 2.59128f, 
		3.55747f, 0.319132f, 2.24676f, 3.55756f, 0.299083f, 2.23684f, 
		3.55776f, 0.292005f, 2.53058f, 3.55778f, 0.267202f, 2.56084f, 
		3.55781f, 0.377094f, 2.18630f, 3.55782f, 0.299475f, 2.52788f, 
		3.55783f, 0.335789f, 2.19388f, 3.55792f, 0.292053f, 2.23412f, 
		3.55796f, 0.310852f, 2.25049f, 3.55799f, 0.284402f, 2.53933f, 
		3.55804f, 0.266853f, 2.50612f, 3.55812f, 0.368779f, 2.57487f, 
		3.55826f, 0.332884f, 2.17209f, 3.55843f, 0.333270f, 2.19755f, 
		3.55864f, 0.283643f, 2.22410f, 3.55871f, 0.368615f, 2.18849f, 
		3.55872f, 0.280663f, 2.25597f, 3.55872f, 0.267188f, 2.16665f, 
		3.55873f, 0.283585f, 2.50599f, 3.55875f, 0.310373f, 2.23197f, 
		3.55876f, 0.325590f, 2.19283f, 3.55901f, 0.321066f, 2.52510f, 
		3.55902f, 0.368781f, 2.18086f, 3.55935f, 0.291550f, 2.25013f, 
		3.55937f, 0.311014f, 2.59072f, 3.55938f, 0.300960f, 2.25204f, 
		3.55940f, 0.303989f, 2.56572f, 3.55944f, 0.311018f, 2.56676f, 
		3.55946f, 0.267274f, 2.59702f, 3.55983f, 0.349821f, 2.59868f, 
		3.55985f, 0.369102f, 2.58321f, 3.55994f, 0.291642f, 2.55831f, 
		3.55998f, 0.377849f, 2.57415f, 3.55999f, 0.293146f, 2.51532f, 
		3.56013f, 0.320497f, 2.51856f, 3.56024f, 0.311853f, 2.56030f, 
		3.56027f, 0.311014f, 2.19671f, 3.56028f, 0.311017f, 2.17276f, 
		3.56031f, 0.316293f, 2.20362f, 3.56033f, 0.346170f, 2.59858f, 
		3.56035f, 0.305340f, 2.53109f, 3.56036f, 0.267274f, 2.20301f, 
		3.56055f, 0.311989f, 2.53405f, 3.56062f, 0.302277f, 2.22912f, 
		3.56068f, 0.301756f, 2.51155f, 3.56074f, 0.345722f, 2.56130f, 
		3.56088f, 0.377849f, 2.18014f, 3.56090f, 0.285843f, 2.25579f, 
		3.56097f, 0.269116f, 2.60054f, 3.56114f, 0.311853f, 2.16629f, 
		3.56131f, 0.349369f, 2.20510f, 3.56145f, 0.305505f, 2.24935f, 
		3.56147f, 0.383991f, 2.57843f, 3.56148f, 0.269369f, 2.57878f, 
		3.56151f, 0.303604f, 2.59163f, 3.56159f, 0.336412f, 2.56923f, 
		3.56166f, 0.270635f, 2.26069f, 3.56176f, 0.316041f, 2.25106f, 
		3.56194f, 0.272691f, 2.50459f, 3.56205f, 0.380170f, 2.58271f, 
		3.56227f, 0.346034f, 2.20355f, 3.56233f, 0.280689f, 2.50822f, 
		3.56237f, 0.383991f, 2.18442f, 3.56240f, 0.267885f, 2.52337f, 
		3.56243f, 0.305374f, 2.51528f, 3.56253f, 0.267842f, 2.24133f, 
		3.56266f, 0.317155f, 2.59757f, 3.56276f, 0.286166f, 2.59435f, 
		3.56280f, 0.346376f, 2.16488f, 3.56295f, 0.380171f, 2.18869f, 
		3.56309f, 0.320001f, 2.52977f, 3.56313f, 0.344829f, 2.56958f, 
		3.56331f, 0.285920f, 2.50901f, 3.56355f, 0.312966f, 2.51256f, 
		3.56365f, 0.336300f, 2.17514f, 3.56366f, 0.286165f, 2.20034f, 
		3.56371f, 0.303472f, 2.25313f, 3.56383f, 0.368457f, 2.57395f, 
		3.56389f, 0.304386f, 2.17185f, 3.56395f, 0.315646f, 2.23170f, 
		3.56398f, 0.298874f, 2.23531f, 3.56401f, 0.322113f, 2.24166f, 
		3.56404f, 0.344816f, 2.17556f, 3.56409f, 0.302911f, 2.53558f, 
		3.56415f, 0.269218f, 2.18475f, 3.56416f, 0.327045f, 2.56990f, 
		3.56417f, 0.348622f, 2.55839f, 3.56420f, 0.268296f, 2.16293f, 
		3.56448f, 0.280535f, 2.53813f, 3.56454f, 0.268549f, 2.55718f, 
		3.56460f, 0.335902f, 2.58786f, 3.56468f, 0.325714f, 2.19340f, 
		3.56474f, 0.368452f, 2.17992f, 3.56502f, 0.327018f, 2.17582f, 
		3.56507f, 0.320526f, 2.23640f, 3.56507f, 0.284810f, 2.22568f, 
		3.56540f, 0.298936f, 2.52933f, 3.56544f, 0.367947f, 2.58280f, 
		3.56578f, 0.368321f, 2.18935f, 3.56595f, 0.344799f, 2.58663f, 
		3.56596f, 0.299413f, 2.24761f, 3.56600f, 0.344801f, 2.19325f, 
		3.56605f, 0.376532f, 2.57725f, 3.56606f, 0.275793f, 2.22389f, 
		3.56607f, 0.305429f, 2.23444f, 3.56610f, 0.332859f, 2.56623f, 
		3.56615f, 0.285830f, 2.56347f, 3.56619f, 0.304079f, 2.19695f, 
		3.56639f, 0.325659f, 2.58628f, 3.56643f, 0.287599f, 2.59766f, 
		3.56648f, 0.288772f, 2.53424f, 3.56649f, 0.292241f, 2.59842f, 
		3.56650f, 0.316555f, 2.56008f, 3.56653f, 0.349905f, 2.16521f, 
		3.56676f, 0.368016f, 2.57873f, 3.56678f, 0.268587f, 2.20572f, 
		3.56687f, 0.332864f, 2.19725f, 3.56695f, 0.376532f, 2.18323f, 
		3.56696f, 0.333009f, 2.59107f, 3.56697f, 0.332847f, 2.17220f, 
		3.56700f, 0.271660f, 2.54216f, 3.56705f, 0.285829f, 2.16946f, 
		3.56712f, 0.283952f, 2.25840f, 3.56717f, 0.291409f, 2.23353f, 
		3.56723f, 0.303223f, 2.51248f, 3.56730f, 0.303209f, 2.23056f, 
		3.56732f, 0.287599f, 2.20365f, 3.56739f, 0.292242f, 2.20441f, 
		3.56745f, 0.316532f, 2.16608f, 3.56756f, 0.283964f, 2.54007f, 
		3.56761f, 0.325313f, 2.57187f, 3.56763f, 0.336219f, 2.57151f, 
		3.56766f, 0.368011f, 2.18471f, 3.56771f, 0.289694f, 2.25053f, 
		3.56801f, 0.313383f, 2.25114f, 3.56801f, 0.320604f, 2.52151f, 
		3.56840f, 0.299276f, 2.51949f, 3.56844f, 0.266588f, 2.50623f, 
		3.56849f, 0.286154f, 2.22868f, 3.56858f, 0.325354f, 2.17798f, 
		3.56891f, 0.348991f, 2.59788f, 3.56908f, 0.299013f, 2.23999f, 
		3.56921f, 0.335720f, 2.58467f, 3.56931f, 0.335993f, 2.19182f, 
		3.56937f, 0.310999f, 2.56953f, 3.56941f, 0.313181f, 2.23276f, 
		3.56943f, 0.311010f, 2.17498f, 3.56945f, 0.303998f, 2.58869f, 
		3.56946f, 0.311018f, 2.19445f, 3.56953f, 0.291088f, 2.16548f, 
		3.56954f, 0.273968f, 2.25861f, 3.56954f, 0.349730f, 2.20336f, 
		3.56965f, 0.313524f, 2.53183f, 3.56975f, 0.325284f, 2.19008f, 
		3.57022f, 0.325606f, 2.57987f, 3.57034f, 0.344854f, 2.57844f, 
		3.57038f, 0.294719f, 2.52390f, 3.57038f, 0.311884f, 2.59559f, 
		3.57043f, 0.280527f, 2.25423f, 3.57048f, 0.305174f, 2.24379f, 
		3.57060f, 0.289625f, 2.51591f, 3.57062f, 0.312316f, 2.51629f, 
		3.57062f, 0.346362f, 2.20269f, 3.57087f, 0.311004f, 2.58688f, 
		3.57092f, 0.266591f, 2.22513f, 3.57099f, 0.305338f, 2.52453f, 
		3.57102f, 0.325585f, 2.18444f, 3.57107f, 0.282854f, 2.22580f, 
		3.57113f, 0.276510f, 2.50796f, 3.57122f, 0.283799f, 2.50765f, 
		3.57129f, 0.311866f, 2.20157f, 3.57129f, 0.335632f, 2.57802f, 
		3.57133f, 0.344896f, 2.18440f, 3.57138f, 0.266591f, 2.25665f, 
		3.57159f, 0.291111f, 2.24380f, 3.57161f, 0.336009f, 2.18165f, 
		3.57179f, 0.301863f, 2.24934f, 3.57184f, 0.303736f, 2.57075f, 
		3.57189f, 0.280433f, 2.22929f, 3.57208f, 0.286200f, 2.58991f, 
		3.57217f, 0.311679f, 2.24602f, 3.57220f, 0.301892f, 2.53082f, 
		3.57221f, 0.316437f, 2.59436f, 3.57230f, 0.309451f, 2.23921f, 
		3.57236f, 0.316091f, 2.24141f, 3.57254f, 0.288709f, 2.23591f, 
		3.57261f, 0.346241f, 2.56256f, 3.57290f, 0.303886f, 2.19211f, 
		3.57292f, 0.268376f, 2.59695f, 3.57298f, 0.286200f, 2.19590f, 
		3.57301f, 0.304012f, 2.17753f, 3.57302f, 0.346300f, 2.59456f, 
		3.57304f, 0.290948f, 2.56171f, 3.57307f, 0.333160f, 2.57194f, 
		3.57311f, 0.316436f, 2.20035f, 3.57341f, 0.311033f, 2.57809f, 
		3.57341f, 0.312698f, 2.52533f, 3.57354f, 0.349208f, 2.56236f, 
		3.57367f, 0.349031f, 2.16775f, 3.57367f, 0.300990f, 2.51937f, 
		3.57372f, 0.304745f, 2.58146f, 3.57382f, 0.268376f, 2.20294f, 
		3.57385f, 0.303279f, 2.52065f, 3.57396f, 0.333166f, 2.17794f, 
		3.57397f, 0.269878f, 2.56160f, 3.57419f, 0.311752f, 2.56567f, 
		3.57432f, 0.332830f, 2.58225f, 3.57438f, 0.346111f, 2.16936f, 
		3.57454f, 0.301774f, 2.23758f, 3.57455f, 0.286209f, 2.57075f, 
		3.57472f, 0.304348f, 2.18482f, 3.57484f, 0.267111f, 2.56409f, 
		3.57492f, 0.267141f, 2.53693f, 3.57493f, 0.280502f, 2.53138f, 
		3.57493f, 0.311062f, 2.18472f, 3.57497f, 0.271446f, 2.22692f, 
		3.57502f, 0.332697f, 2.18863f, 3.57510f, 0.311750f, 2.17166f, 
		3.57545f, 0.286209f, 2.17674f, 3.57571f, 0.287523f, 2.59189f, 
		3.57572f, 0.270011f, 2.16817f, 3.57581f, 0.267114f, 2.17014f, 
		3.57590f, 0.286501f, 2.52594f, 3.57598f, 0.276449f, 2.53488f, 
		3.57599f, 0.276550f, 2.25287f, 3.57610f, 0.267077f, 2.59171f, 
		3.57610f, 0.314634f, 2.56580f, 3.57615f, 0.349515f, 2.59278f, 
		3.57629f, 0.280340f, 2.51695f, 3.57631f, 0.318427f, 2.56960f, 
		3.57633f, 0.267713f, 2.51097f, 3.57642f, 0.283378f, 2.53444f, 
		3.57660f, 0.287523f, 2.19788f, 3.57662f, 0.287044f, 2.56741f, 
		3.57694f, 0.349370f, 2.19900f, 3.57696f, 0.283168f, 2.25213f, 
		3.57699f, 0.267077f, 2.19770f, 3.57700f, 0.314633f, 2.17178f, 
		3.57710f, 0.286322f, 2.57919f, 3.57721f, 0.318428f, 2.17559f, 
		3.57752f, 0.287044f, 2.17340f, 3.57783f, 0.283260f, 2.23258f, 
		3.57788f, 0.280406f, 2.24229f, 3.57800f, 0.286322f, 2.18518f, 
		3.57816f, 0.267371f, 2.25118f, 3.57842f, 0.315560f, 2.58778f, 
		3.57859f, 0.292031f, 2.56872f, 3.57877f, 0.350085f, 2.56889f, 
		3.57910f, 0.291144f, 2.17342f, 3.57925f, 0.346408f, 2.58701f, 
		3.57926f, 0.266476f, 2.24137f, 3.57932f, 0.315560f, 2.19377f, 
		3.57935f, 0.283618f, 2.24035f, 3.57939f, 0.350150f, 2.58700f, 
		3.57966f, 0.269921f, 2.58961f, 3.57979f, 0.349922f, 2.17486f, 
		3.57980f, 0.291981f, 2.58692f, 3.57991f, 0.311750f, 2.57969f, 
		3.58010f, 0.266496f, 2.52451f, 3.58017f, 0.346397f, 2.19294f, 
		3.58031f, 0.350131f, 2.19302f, 3.58042f, 0.283102f, 2.52106f, 
		3.58044f, 0.272292f, 2.51683f, 3.58049f, 0.267061f, 2.57922f, 
		3.58051f, 0.272268f, 2.23514f, 3.58056f, 0.269922f, 2.19560f, 
		3.58070f, 0.291981f, 2.19291f, 3.58082f, 0.311768f, 2.18568f, 
		3.58085f, 0.287654f, 2.57870f, 3.58085f, 0.316033f, 2.57939f, 
		3.58094f, 0.269740f, 2.24511f, 3.58104f, 0.269135f, 2.57025f, 
		3.58109f, 0.292721f, 2.57819f, 3.58128f, 0.346389f, 2.57486f, 
		3.58139f, 0.267061f, 2.18521f, 3.58139f, 0.272679f, 2.52548f, 
		3.58175f, 0.287654f, 2.18469f, 3.58175f, 0.316034f, 2.18537f, 
		3.58199f, 0.292720f, 2.18418f, 3.58200f, 0.268846f, 2.17647f, 
		3.58218f, 0.348414f, 2.57855f, 3.58224f, 0.346399f, 2.18101f, 
		3.58271f, 0.269248f, 2.57916f, 3.58307f, 0.348420f, 2.18453f, 
		3.58361f, 0.269248f, 2.18514f, 3.59084f, 0.266331f, 2.15780f, 
		3.59084f, 0.266331f, 2.21374f, 3.59084f, 0.266331f, 2.26967f, 
		3.59084f, 0.266331f, 2.32561f, 3.59084f, 0.266331f, 2.38154f, 
		3.59084f, 0.266331f, 2.43748f, 3.59084f, 0.266331f, 2.49342f, 
		3.59084f, 0.266331f, 2.54935f, 3.59084f, 0.266331f, 2.60529f, 
		3.59842f, 0.266859f, 2.18976f, 3.59876f, 0.290422f, 2.18180f, 
		3.59895f, 0.275522f, 2.19032f, 3.59919f, 0.272951f, 2.51922f, 
		3.59924f, 0.273858f, 2.23766f, 3.59949f, 0.267689f, 2.57945f, 
		3.59959f, 0.275674f, 2.17830f, 3.59975f, 0.266778f, 2.17770f, 
		3.59978f, 0.295965f, 2.18406f, 3.60009f, 0.283678f, 2.24035f, 
		3.60010f, 0.290422f, 2.57366f, 3.60022f, 0.267290f, 2.23750f, 
		3.60043f, 0.275874f, 2.57152f, 3.60047f, 0.290013f, 2.58205f, 
		3.60049f, 0.275279f, 2.58299f, 3.60067f, 0.266953f, 2.51700f, 
		3.60071f, 0.282960f, 2.52405f, 3.60083f, 0.292739f, 2.19556f, 
		3.60094f, 0.270979f, 2.52984f, 3.60101f, 0.343012f, 2.18706f, 
		3.60109f, 0.266778f, 2.56956f, 3.60112f, 0.295963f, 2.57592f, 
		3.60169f, 0.341982f, 2.17895f, 3.60182f, 0.338502f, 2.18822f, 
		3.60238f, 0.342337f, 2.58080f, 3.60249f, 0.285142f, 2.51914f, 
		3.60265f, 0.288202f, 2.18670f, 3.60266f, 0.269706f, 2.25071f, 
		3.60297f, 0.317714f, 2.18184f, 3.60331f, 0.338520f, 2.57917f, 
		3.60338f, 0.339375f, 2.17595f, 3.60360f, 0.322515f, 2.18496f, 
		3.60383f, 0.337928f, 2.17957f, 3.60391f, 0.293690f, 2.56515f, 
		3.60397f, 0.280786f, 2.52608f, 3.60404f, 0.294298f, 2.58858f, 
		3.60411f, 0.340852f, 2.19595f, 3.60425f, 0.343609f, 2.56983f, 
		3.60428f, 0.294108f, 2.17103f, 3.60438f, 0.280738f, 2.51559f, 
		3.60451f, 0.317395f, 2.19289f, 3.60452f, 0.266747f, 2.59003f, 
		3.60452f, 0.280863f, 2.23321f, 3.60452f, 0.275727f, 2.19970f, 
		3.60461f, 0.301534f, 2.18254f, 3.60463f, 0.345789f, 2.17784f, 
		3.60464f, 0.288532f, 2.57528f, 3.60466f, 0.289421f, 2.17129f, 
		3.60470f, 0.317235f, 2.58214f, 3.60497f, 0.322543f, 2.57707f, 
		3.60499f, 0.283755f, 2.53256f, 3.60512f, 0.282940f, 2.50918f, 
		3.60513f, 0.282947f, 2.22724f, 3.60516f, 0.266783f, 2.53350f, 
		3.60526f, 0.337871f, 2.57029f, 3.60527f, 0.274908f, 2.16979f, 
		3.60544f, 0.341525f, 2.58799f, 3.60549f, 0.335562f, 2.18707f, 
		3.60550f, 0.269791f, 2.22549f, 3.60550f, 0.269791f, 2.50742f, 
		3.60561f, 0.280259f, 2.24900f, 3.60564f, 0.283702f, 2.25145f, 
		3.60566f, 0.317108f, 2.57007f, 3.60586f, 0.275727f, 2.59157f, 
		3.60595f, 0.301534f, 2.57440f, 3.60599f, 0.289421f, 2.56315f, 
		3.60613f, 0.277007f, 2.22670f, 3.60659f, 0.340816f, 2.19919f, 
		3.60661f, 0.274912f, 2.56166f, 3.60688f, 0.276455f, 2.50782f, 
		3.60688f, 0.288521f, 2.58530f, 3.60692f, 0.301894f, 2.51772f, 
		3.60698f, 0.345782f, 2.19556f, 3.60711f, 0.288606f, 2.24220f, 
		3.60716f, 0.302822f, 2.24485f, 3.60722f, 0.322652f, 2.19495f, 
		3.60722f, 0.322648f, 2.17542f, 3.60734f, 0.337499f, 2.19571f, 
		3.60740f, 0.315343f, 2.18644f, 3.60750f, 0.266758f, 2.20206f, 
		3.60758f, 0.333736f, 2.57585f, 3.60759f, 0.301167f, 2.19417f, 
		3.60792f, 0.349362f, 2.18670f, 3.60794f, 0.337704f, 2.58752f, 
		3.60796f, 0.288493f, 2.17407f, 3.60799f, 0.308165f, 2.18861f, 
		3.60813f, 0.309233f, 2.18145f, 3.60813f, 0.302065f, 2.23359f, 
		3.60820f, 0.340569f, 2.59118f, 3.60838f, 0.266800f, 2.25485f, 
		3.60851f, 0.301336f, 2.52718f, 3.60853f, 0.311753f, 2.23656f, 
		3.60853f, 0.322646f, 2.58678f, 3.60855f, 0.322649f, 2.56728f, 
		3.60857f, 0.348549f, 2.57826f, 3.60863f, 0.311938f, 2.51773f, 
		3.60894f, 0.266743f, 2.16740f, 3.60897f, 0.291432f, 2.52309f, 
		3.60907f, 0.345868f, 2.58830f, 3.60914f, 0.340309f, 2.56266f, 
		3.60919f, 0.271467f, 2.53848f, 3.60923f, 0.313795f, 2.24498f, 
		3.60929f, 0.313353f, 2.52728f, 3.60929f, 0.288493f, 2.56593f, 
		3.60932f, 0.327240f, 2.18221f, 3.60933f, 0.289794f, 2.20320f, 
		3.60960f, 0.349125f, 2.17894f, 3.60962f, 0.302886f, 2.58496f, 
		3.60978f, 0.314882f, 2.57449f, 3.60982f, 0.288505f, 2.19789f, 
		3.60993f, 0.316715f, 2.23484f, 3.61008f, 0.339598f, 2.16920f, 
		3.61015f, 0.285441f, 2.22670f, 3.61015f, 0.285441f, 2.50863f, 
		3.61028f, 0.317819f, 2.52055f, 3.61028f, 0.266743f, 2.55926f, 
		3.61029f, 0.266713f, 2.22308f, 3.61056f, 0.326559f, 2.57296f, 
		3.61064f, 0.301368f, 2.56665f, 3.61064f, 0.305530f, 2.51811f, 
		3.61066f, 0.289793f, 2.59506f, 3.61079f, 0.317285f, 2.17094f, 
		3.61081f, 0.293662f, 2.20369f, 3.61094f, 0.349126f, 2.57080f, 
		3.61121f, 0.327217f, 2.19159f, 3.61125f, 0.317624f, 2.59075f, 
		3.61130f, 0.280692f, 2.53520f, 3.61131f, 0.315339f, 2.58363f, 
		3.61143f, 0.317453f, 2.19936f, 3.61166f, 0.291300f, 2.23273f, 
		3.61176f, 0.313805f, 2.51311f, 3.61177f, 0.314898f, 2.19278f, 
		3.61177f, 0.317382f, 2.56281f, 3.61179f, 0.274384f, 2.25699f, 
		3.61180f, 0.283581f, 2.25628f, 3.61193f, 0.284247f, 2.53759f, 
		3.61202f, 0.315425f, 2.17589f, 3.61204f, 0.333990f, 2.58636f, 
		3.61215f, 0.293662f, 2.59556f, 3.61227f, 0.299413f, 2.24246f, 
		3.61236f, 0.303389f, 2.53183f, 3.61244f, 0.305286f, 2.24521f, 
		3.61245f, 0.299440f, 2.52520f, 3.61253f, 0.292342f, 2.51478f, 
		3.61270f, 0.308314f, 2.17574f, 3.61274f, 0.335600f, 2.17331f, 
		3.61277f, 0.305676f, 2.23381f, 3.61284f, 0.293692f, 2.55827f, 
		3.61290f, 0.359564f, 2.18543f, 3.61301f, 0.293635f, 2.16575f, 
		3.61311f, 0.301628f, 2.17228f, 3.61311f, 0.326328f, 2.58552f, 
		3.61316f, 0.349454f, 2.19462f, 3.61331f, 0.266778f, 2.59633f, 
		3.61336f, 0.335476f, 2.56579f, 3.61340f, 0.302842f, 2.50997f, 
		3.61346f, 0.310570f, 2.53042f, 3.61347f, 0.266674f, 2.50446f, 
		3.61355f, 0.311395f, 2.24881f, 3.61368f, 0.299707f, 2.23457f, 
		3.61386f, 0.345756f, 2.56264f, 3.61416f, 0.359479f, 2.57668f, 
		3.61426f, 0.326701f, 2.17615f, 3.61434f, 0.283643f, 2.22225f, 
		3.61443f, 0.283585f, 2.50414f, 3.61445f, 0.310373f, 2.23012f, 
		3.61446f, 0.349394f, 2.58649f, 3.61455f, 0.359139f, 2.18955f, 
		3.61461f, 0.299650f, 2.51547f, 3.61465f, 0.302024f, 2.22840f, 
		3.61466f, 0.267806f, 2.20520f, 3.61471f, 0.359082f, 2.18050f, 
		3.61476f, 0.338333f, 2.20157f, 3.61478f, 0.345685f, 2.17043f, 
		3.61515f, 0.286717f, 2.25275f, 3.61528f, 0.301142f, 2.25035f, 
		3.61532f, 0.286600f, 2.53491f, 3.61538f, 0.366636f, 2.18760f, 
		3.61546f, 0.321432f, 2.24168f, 3.61549f, 0.321396f, 2.52338f, 
		3.61561f, 0.315026f, 2.56745f, 3.61570f, 0.275065f, 2.20540f, 
		3.61573f, 0.342459f, 2.20283f, 3.61584f, 0.359141f, 2.57241f, 
		3.61589f, 0.359140f, 2.58141f, 3.61603f, 0.275088f, 2.16476f, 
		3.61610f, 0.366137f, 2.57819f, 3.61630f, 0.293046f, 2.52967f, 
		3.61634f, 0.339756f, 2.55948f, 3.61638f, 0.305184f, 2.52918f, 
		3.61659f, 0.341186f, 2.16727f, 3.61694f, 0.326895f, 2.56791f, 
		3.61703f, 0.338458f, 2.59359f, 3.61704f, 0.275063f, 2.59726f, 
		3.61737f, 0.275090f, 2.55662f, 3.61765f, 0.288518f, 2.59255f, 
		3.61766f, 0.317317f, 2.53063f, 3.61778f, 0.322501f, 2.20044f, 
		3.61784f, 0.272759f, 2.50277f, 3.61785f, 0.366559f, 2.18113f, 
		3.61785f, 0.320202f, 2.51605f, 3.61786f, 0.322499f, 2.16995f, 
		3.61792f, 0.366018f, 2.57325f, 3.61797f, 0.288515f, 2.16983f, 
		3.61804f, 0.280689f, 2.50637f, 3.61808f, 0.302564f, 2.19860f, 
		3.61811f, 0.267885f, 2.52152f, 3.61818f, 0.316763f, 2.24867f, 
		3.61821f, 0.326743f, 2.19516f, 3.61823f, 0.267860f, 2.16464f, 
		3.61824f, 0.267842f, 2.23948f, 3.61832f, 0.349646f, 2.17448f, 
		3.61842f, 0.280604f, 2.22431f, 3.61848f, 0.267985f, 2.18519f, 
		3.61848f, 0.280640f, 2.25492f, 3.61914f, 0.322483f, 2.56179f, 
		3.61923f, 0.322455f, 2.59235f, 3.61927f, 0.312882f, 2.51072f, 
		3.61931f, 0.288515f, 2.56170f, 3.61941f, 0.302564f, 2.59046f, 
		3.61943f, 0.317757f, 2.23068f, 3.61944f, 0.288464f, 2.20042f, 
		3.61946f, 0.315201f, 2.19627f, 3.61951f, 0.303453f, 2.25158f, 
		3.61954f, 0.274765f, 2.22106f, 3.61956f, 0.267860f, 2.55650f, 
		3.61966f, 0.349646f, 2.56634f, 3.61968f, 0.370240f, 2.57906f, 
		3.61971f, 0.299348f, 2.23308f, 3.61982f, 0.267985f, 2.57705f, 
		3.61991f, 0.370599f, 2.18624f, 3.61995f, 0.285446f, 2.50673f, 
		3.61998f, 0.302124f, 2.56335f, 3.62016f, 0.270527f, 2.25851f, 
		3.62021f, 0.289678f, 2.16514f, 3.62021f, 0.270526f, 2.54046f, 
		3.62046f, 0.359570f, 2.19046f, 3.62073f, 0.299325f, 2.52774f, 
		3.62076f, 0.315144f, 2.58814f, 3.62077f, 0.315043f, 2.17494f, 
		3.62078f, 0.299327f, 2.24627f, 3.62094f, 0.321845f, 2.52177f, 
		3.62099f, 0.305856f, 2.24776f, 3.62109f, 0.317426f, 2.20079f, 
		3.62111f, 0.335015f, 2.19791f, 3.62142f, 0.292438f, 2.51344f, 
		3.62151f, 0.291316f, 2.23086f, 3.62163f, 0.305287f, 2.51447f, 
		3.62163f, 0.289720f, 2.55696f, 3.62171f, 0.302137f, 2.17228f, 
		3.62184f, 0.359571f, 2.58231f, 3.62196f, 0.280611f, 2.53603f, 
		3.62222f, 0.334445f, 2.58941f, 3.62222f, 0.302929f, 2.22815f, 
		3.62234f, 0.288658f, 2.25045f, 3.62237f, 0.310741f, 2.53109f, 
		3.62243f, 0.332835f, 2.17426f, 3.62244f, 0.308387f, 2.56642f, 
		3.62255f, 0.360022f, 2.18131f, 3.62259f, 0.301638f, 2.53310f, 
		3.62262f, 0.321242f, 2.24030f, 3.62273f, 0.305909f, 2.23222f, 
		3.62282f, 0.283952f, 2.25655f, 3.62283f, 0.341816f, 2.59485f, 
		3.62301f, 0.367876f, 2.57553f, 3.62303f, 0.326859f, 2.56804f, 
		3.62312f, 0.303525f, 2.51101f, 3.62316f, 0.284773f, 2.22416f, 
		3.62319f, 0.317160f, 2.17007f, 3.62321f, 0.326501f, 2.17625f, 
		3.62326f, 0.283964f, 2.53821f, 3.62347f, 0.298978f, 2.51749f, 
		3.62366f, 0.288612f, 2.53163f, 3.62380f, 0.359227f, 2.57254f, 
		3.62396f, 0.268285f, 2.22189f, 3.62399f, 0.266821f, 2.50420f, 
		3.62399f, 0.289530f, 2.20391f, 3.62401f, 0.359278f, 2.18645f, 
		3.62409f, 0.266598f, 2.53876f, 3.62413f, 0.299185f, 2.23668f, 
		3.62425f, 0.308316f, 2.19465f, 3.62431f, 0.293951f, 2.20438f, 
		3.62437f, 0.294239f, 2.24483f, 3.62448f, 0.317152f, 2.56192f, 
		3.62453f, 0.339191f, 2.20120f, 3.62455f, 0.349129f, 2.19449f, 
		3.62457f, 0.345101f, 2.17054f, 3.62462f, 0.266713f, 2.20436f, 
		3.62475f, 0.346006f, 2.19938f, 3.62477f, 0.283689f, 2.50498f, 
		3.62500f, 0.337689f, 2.17068f, 3.62508f, 0.326500f, 2.58564f, 
		3.62509f, 0.313845f, 2.24789f, 3.62533f, 0.289530f, 2.59577f, 
		3.62536f, 0.337146f, 2.56331f, 3.62541f, 0.359219f, 2.57833f, 
		3.62549f, 0.316917f, 2.23377f, 3.62552f, 0.348952f, 2.17708f, 
		3.62559f, 0.308315f, 2.58651f, 3.62565f, 0.293951f, 2.59624f, 
		3.62565f, 0.317743f, 2.59249f, 3.62569f, 0.266742f, 2.59635f, 
		3.62586f, 0.266588f, 2.25533f, 3.62589f, 0.349137f, 2.58634f, 
		3.62603f, 0.346127f, 2.59099f, 3.62605f, 0.344435f, 2.56168f, 
		3.62613f, 0.291393f, 2.52612f, 3.62624f, 0.312242f, 2.51431f, 
		3.62629f, 0.326645f, 2.19117f, 3.62633f, 0.315036f, 2.52804f, 
		3.62634f, 0.305330f, 2.24118f, 3.62634f, 0.337660f, 2.59168f, 
		3.62657f, 0.274760f, 2.20387f, 3.62670f, 0.305577f, 2.52287f, 
		3.62684f, 0.276507f, 2.50610f, 3.62684f, 0.341260f, 2.16926f, 
		3.62685f, 0.299690f, 2.52192f, 3.62687f, 0.348978f, 2.56898f, 
		3.62690f, 0.292546f, 2.52120f, 3.62698f, 0.301502f, 2.51326f, 
		3.62711f, 0.341254f, 2.20102f, 3.62717f, 0.315230f, 2.17879f, 
		3.62724f, 0.317602f, 2.51959f, 3.62754f, 0.292896f, 2.16695f, 
		3.62758f, 0.315356f, 2.56892f, 3.62777f, 0.291199f, 2.23865f, 
		3.62783f, 0.307250f, 2.17847f, 3.62793f, 0.327093f, 2.18450f, 
		3.62794f, 0.274748f, 2.59572f, 3.62804f, 0.326969f, 2.57204f, 
		3.62812f, 0.300592f, 2.24483f, 3.62825f, 0.341066f, 2.56105f, 
		3.62832f, 0.331943f, 2.18001f, 3.62840f, 0.303416f, 2.24570f, 
		3.62868f, 0.275198f, 2.16768f, 3.62875f, 0.315155f, 2.18748f, 
		3.62889f, 0.288074f, 2.19679f, 3.62890f, 0.282906f, 2.22487f, 
		3.62917f, 0.307254f, 2.57033f, 3.62920f, 0.287193f, 2.23211f, 
		3.62926f, 0.312774f, 2.23883f, 3.62931f, 0.274431f, 2.25446f, 
		3.62932f, 0.349281f, 2.18451f, 3.62935f, 0.326666f, 2.57895f, 
		3.62945f, 0.300375f, 2.19531f, 3.62945f, 0.301023f, 2.17619f, 
		3.62966f, 0.335369f, 2.19179f, 3.62968f, 0.303417f, 2.52539f, 
		3.62983f, 0.302406f, 2.23447f, 3.63001f, 0.275198f, 2.55953f, 
		3.63009f, 0.315118f, 2.57934f, 3.63012f, 0.280617f, 2.53074f, 
		3.63023f, 0.288074f, 2.58865f, 3.63049f, 0.317543f, 2.19600f, 
		3.63053f, 0.322576f, 2.19448f, 3.63053f, 0.322585f, 2.17593f, 
		3.63056f, 0.288605f, 2.17517f, 3.63057f, 0.266783f, 2.16913f, 
		3.63065f, 0.349310f, 2.57636f, 3.63070f, 0.342658f, 2.59164f, 
		3.63070f, 0.270781f, 2.53606f, 3.63072f, 0.300994f, 2.56789f, 
		3.63079f, 0.300375f, 2.58717f, 3.63092f, 0.275655f, 2.22668f, 
		3.63114f, 0.266800f, 2.22636f, 3.63116f, 0.284234f, 2.51116f, 
		3.63159f, 0.280550f, 2.23326f, 3.63161f, 0.286501f, 2.24216f, 
		3.63161f, 0.344048f, 2.17471f, 3.63176f, 0.292463f, 2.56026f, 
		3.63179f, 0.302255f, 2.18587f, 3.63180f, 0.336198f, 2.57038f, 
		3.63187f, 0.322576f, 2.56778f, 3.63187f, 0.322588f, 2.58631f, 
		3.63188f, 0.266560f, 2.50926f, 3.63190f, 0.288605f, 2.56703f, 
		3.63191f, 0.335271f, 2.58228f, 3.63191f, 0.266783f, 2.56100f, 
		3.63200f, 0.280339f, 2.51509f, 3.63213f, 0.283378f, 2.53259f, 
		3.63226f, 0.286021f, 2.52344f, 3.63235f, 0.345252f, 2.56772f, 
		3.63235f, 0.283218f, 2.25060f, 3.63251f, 0.339000f, 2.17531f, 
		3.63270f, 0.280538f, 2.24402f, 3.63313f, 0.302254f, 2.57773f, 
		3.63335f, 0.322644f, 2.18515f, 3.63335f, 0.317434f, 2.56882f, 
		3.63336f, 0.291593f, 2.19884f, 3.63383f, 0.345616f, 2.18519f, 
		3.63388f, 0.317252f, 2.17980f, 3.63396f, 0.288347f, 2.18664f, 
		3.63411f, 0.337478f, 2.18508f, 3.63419f, 0.323004f, 2.57705f, 
		3.63427f, 0.341093f, 2.19468f, 3.63441f, 0.266931f, 2.24724f, 
		3.63470f, 0.291593f, 2.59070f, 3.63473f, 0.274352f, 2.52984f, 
		3.63488f, 0.271305f, 2.24898f, 3.63498f, 0.340101f, 2.56744f, 
		3.63512f, 0.345669f, 2.57711f, 3.63513f, 0.275454f, 2.17396f, 
		3.63525f, 0.275854f, 2.19655f, 3.63530f, 0.288347f, 2.57850f, 
		3.63531f, 0.266819f, 2.19671f, 3.63535f, 0.294767f, 2.17532f, 
		3.63537f, 0.289362f, 2.17629f, 3.63541f, 0.266529f, 2.23936f, 
		3.63542f, 0.317217f, 2.58080f, 3.63562f, 0.276333f, 2.51772f, 
		3.63568f, 0.337937f, 2.57802f, 3.63582f, 0.266501f, 2.52265f, 
		3.63599f, 0.266809f, 2.58897f, 3.63613f, 0.283102f, 2.51921f, 
		3.63614f, 0.283119f, 2.23735f, 3.63635f, 0.341265f, 2.18267f, 
		3.63638f, 0.341894f, 2.18680f, 3.63647f, 0.275455f, 2.56582f, 
		3.63661f, 0.275763f, 2.58844f, 3.63668f, 0.267725f, 2.17619f, 
		3.63670f, 0.269210f, 2.51859f, 3.63672f, 0.289354f, 2.56819f, 
		3.63699f, 0.270878f, 2.23683f, 3.63710f, 0.339436f, 2.58123f, 
		3.63739f, 0.340486f, 2.57473f, 3.63750f, 0.294806f, 2.56915f, 
		3.63787f, 0.294247f, 2.18943f, 3.63802f, 0.267724f, 2.56806f, 
		3.63849f, 0.289935f, 2.18645f, 3.63858f, 0.266697f, 2.18510f, 
		3.63868f, 0.275617f, 2.18478f, 3.63920f, 0.294245f, 2.58129f, 
		3.63982f, 0.289935f, 2.57831f, 3.64000f, 0.275655f, 2.57663f, 
		3.64002f, 0.266715f, 2.57704f, 3.64678f, 0.266331f, 2.15780f, 
		3.64678f, 0.266331f, 2.21374f, 3.64678f, 0.266331f, 2.26967f, 
		3.64678f, 0.266331f, 2.32561f, 3.64678f, 0.266331f, 2.38154f, 
		3.64678f, 0.266331f, 2.43748f, 3.64678f, 0.266331f, 2.49342f, 
		3.64678f, 0.266331f, 2.54935f, 3.64678f, 0.266331f, 2.60529f, 
		3.65514f, 0.268764f, 2.57727f, 3.65624f, 0.267521f, 2.18488f, 
		3.65655f, 0.279052f, 2.18672f, 3.65681f, 0.267595f, 2.58589f, 
		3.65705f, 0.279921f, 2.57554f, 3.65708f, 0.269118f, 2.19654f, 
		3.65758f, 0.271967f, 2.52794f, 3.65774f, 0.266991f, 2.24171f, 
		3.65787f, 0.283678f, 2.24110f, 3.65787f, 0.283559f, 2.52303f, 
		3.65856f, 0.266815f, 2.52282f, 3.65896f, 0.271664f, 2.51339f, 
		3.65896f, 0.271664f, 2.23146f, 3.65974f, 0.267630f, 2.17567f, 
		3.65991f, 0.280481f, 2.58888f, 3.66011f, 0.280504f, 2.19826f, 
		3.66012f, 0.267669f, 2.56611f, 3.66030f, 0.280164f, 2.24180f, 
		3.66060f, 0.269812f, 2.25162f, 3.66118f, 0.289796f, 2.57937f, 
		3.66118f, 0.285907f, 2.51993f, 3.66166f, 0.291633f, 2.18389f, 
		3.66172f, 0.267619f, 2.20308f, 3.66176f, 0.280786f, 2.52683f, 
		3.66188f, 0.280696f, 2.51736f, 3.66198f, 0.267673f, 2.59405f, 
		3.66243f, 0.290972f, 2.19501f, 3.66259f, 0.295823f, 2.18746f, 
		3.66273f, 0.295832f, 2.58036f, 3.66286f, 0.286228f, 2.24700f, 
		3.66291f, 0.282947f, 2.22799f, 3.66299f, 0.287133f, 2.58203f, 
		3.66306f, 0.283612f, 2.53369f, 3.66333f, 0.266916f, 2.25285f, 
		3.66339f, 0.280260f, 2.24975f, 3.66340f, 0.280222f, 2.17414f, 
		3.66353f, 0.287078f, 2.19239f, 3.66382f, 0.283189f, 2.50911f, 
		3.66450f, 0.295724f, 2.57195f, 3.66456f, 0.302055f, 2.52568f, 
		3.66458f, 0.266794f, 2.53617f, 3.66496f, 0.287132f, 2.18101f, 
		3.66500f, 0.302182f, 2.24520f, 3.66507f, 0.280516f, 2.56424f, 
		3.66538f, 0.280580f, 2.22880f, 3.66542f, 0.313346f, 2.52340f, 
		3.66543f, 0.295866f, 2.58732f, 3.66576f, 0.286998f, 2.57106f, 
		3.66586f, 0.266778f, 2.22515f, 3.66593f, 0.276961f, 2.50764f, 
		3.66593f, 0.283588f, 2.25564f, 3.66594f, 0.302194f, 2.51610f, 
		3.66598f, 0.302011f, 2.23421f, 3.66612f, 0.311348f, 2.24320f, 
		3.66612f, 0.266767f, 2.50691f, 3.66622f, 0.285211f, 2.51042f, 
		3.66640f, 0.285457f, 2.22916f, 3.66653f, 0.291354f, 2.56727f, 
		3.66672f, 0.315518f, 2.23895f, 3.66675f, 0.291432f, 2.24191f, 
		3.66682f, 0.290122f, 2.23626f, 3.66699f, 0.292421f, 2.52181f, 
		3.66706f, 0.271254f, 2.53950f, 3.66739f, 0.269302f, 2.16973f, 
		3.66788f, 0.295910f, 2.17813f, 3.66790f, 0.294956f, 2.20015f, 
		3.66819f, 0.269008f, 2.56018f, 3.66827f, 0.280834f, 2.53534f, 
		3.66857f, 0.313318f, 2.51453f, 3.66863f, 0.313343f, 2.23256f, 
		3.66875f, 0.291359f, 2.17546f, 3.66890f, 0.291016f, 2.59240f, 
		3.66909f, 0.299428f, 2.52263f, 3.66919f, 0.286987f, 2.19935f, 
		3.66939f, 0.305341f, 2.52588f, 3.66950f, 0.303464f, 2.53220f, 
		3.66973f, 0.280584f, 2.25447f, 3.66994f, 0.299437f, 2.24269f, 
		3.67008f, 0.295080f, 2.19426f, 3.67012f, 0.305362f, 2.24599f, 
		3.67015f, 0.295424f, 2.18340f, 3.67028f, 0.313710f, 2.53136f, 
		3.67029f, 0.303031f, 2.20564f, 3.67034f, 0.295253f, 2.57222f, 
		3.67040f, 0.295432f, 2.58428f, 3.67042f, 0.276808f, 2.22343f, 
		3.67048f, 0.308018f, 2.20464f, 3.67048f, 0.302395f, 2.17160f, 
		3.67050f, 0.269907f, 2.25840f, 3.67053f, 0.305512f, 2.51640f, 
		3.67054f, 0.305535f, 2.23461f, 3.67056f, 0.303064f, 2.56184f, 
		3.67066f, 0.312867f, 2.19560f, 3.67067f, 0.302899f, 2.59594f, 
		3.67074f, 0.307952f, 2.56273f, 3.67091f, 0.319641f, 2.18985f, 
		3.67094f, 0.317902f, 2.17225f, 3.67099f, 0.314210f, 2.57360f, 
		3.67105f, 0.323629f, 2.20295f, 3.67111f, 0.284696f, 2.22503f, 
		3.67112f, 0.316824f, 2.59475f, 3.67115f, 0.319746f, 2.57754f, 
		3.67117f, 0.329618f, 2.20277f, 3.67118f, 0.323029f, 2.56549f, 
		3.67123f, 0.323039f, 2.57182f, 3.67129f, 0.334631f, 2.20224f, 
		3.67134f, 0.284426f, 2.53824f, 3.67143f, 0.329466f, 2.56448f, 
		3.67147f, 0.311533f, 2.24962f, 3.67160f, 0.334502f, 2.56532f, 
		3.67160f, 0.279915f, 2.20664f, 3.67163f, 0.338961f, 2.17417f, 
		3.67166f, 0.342766f, 2.18799f, 3.67171f, 0.342879f, 2.18090f, 
		3.67176f, 0.336675f, 2.59504f, 3.67177f, 0.283654f, 2.50504f, 
		3.67177f, 0.291218f, 2.53052f, 3.67187f, 0.342703f, 2.57938f, 
		3.67191f, 0.291944f, 2.51442f, 3.67193f, 0.342844f, 2.58659f, 
		3.67197f, 0.350552f, 2.18512f, 3.67218f, 0.350536f, 2.58231f, 
		3.67288f, 0.316747f, 2.24932f, 3.67296f, 0.302465f, 2.22847f, 
		3.67297f, 0.302691f, 2.51035f, 3.67297f, 0.292672f, 2.24824f, 
		3.67307f, 0.279536f, 2.59782f, 3.67309f, 0.269813f, 2.50359f, 
		3.67309f, 0.269812f, 2.22166f, 3.67318f, 0.287236f, 2.59159f, 
		3.67320f, 0.299110f, 2.23449f, 3.67342f, 0.321821f, 2.52438f, 
		3.67342f, 0.321821f, 2.24245f, 3.67404f, 0.280751f, 2.50744f, 
		3.67404f, 0.295940f, 2.20100f, 3.67417f, 0.295939f, 2.59139f, 
		3.67440f, 0.287256f, 2.56654f, 3.67464f, 0.268468f, 2.59902f, 
		3.67492f, 0.299315f, 2.52877f, 3.67506f, 0.315730f, 2.53198f, 
		3.67507f, 0.267543f, 2.20829f, 3.67510f, 0.287053f, 2.17588f, 
		3.67531f, 0.339700f, 2.57385f, 3.67535f, 0.268156f, 2.18842f, 
		3.67535f, 0.268156f, 2.57900f, 3.67536f, 0.333224f, 2.17214f, 
		3.67544f, 0.267543f, 2.55914f, 3.67560f, 0.287248f, 2.20084f, 
		3.67588f, 0.303252f, 2.25250f, 3.67589f, 0.267885f, 2.52227f, 
		3.67610f, 0.280951f, 2.22465f, 3.67611f, 0.279602f, 2.55998f, 
		3.67620f, 0.267857f, 2.24034f, 3.67630f, 0.295944f, 2.56638f, 
		3.67639f, 0.310295f, 2.23023f, 3.67652f, 0.290897f, 2.20263f, 
		3.67658f, 0.305299f, 2.53006f, 3.67664f, 0.295939f, 2.17604f, 
		3.67664f, 0.286473f, 2.25422f, 3.67683f, 0.299720f, 2.51493f, 
		3.67692f, 0.302386f, 2.53423f, 3.67723f, 0.317259f, 2.51313f, 
		3.67723f, 0.317259f, 2.23120f, 3.67743f, 0.279268f, 2.16971f, 
		3.67748f, 0.305730f, 2.51368f, 3.67751f, 0.299283f, 2.24702f, 
		3.67807f, 0.292578f, 2.56477f, 3.67837f, 0.285937f, 2.50810f, 
		3.67850f, 0.280569f, 2.53713f, 3.67856f, 0.267610f, 2.16914f, 
		3.67856f, 0.350489f, 2.18563f, 3.67864f, 0.288862f, 2.53314f, 
		3.67876f, 0.350507f, 2.58179f, 3.67884f, 0.337317f, 2.19640f, 
		3.67884f, 0.343018f, 2.18114f, 3.67897f, 0.342652f, 2.18811f, 
		3.67899f, 0.339556f, 2.17479f, 3.67902f, 0.342084f, 2.57885f, 
		3.67905f, 0.343255f, 2.58675f, 3.67908f, 0.294181f, 2.51504f, 
		3.67908f, 0.294181f, 2.23310f, 3.67909f, 0.332767f, 2.20342f, 
		3.67930f, 0.334702f, 2.56475f, 3.67935f, 0.335007f, 2.59503f, 
		3.67935f, 0.323171f, 2.20253f, 3.67940f, 0.329784f, 2.56432f, 
		3.67941f, 0.322677f, 2.19554f, 3.67950f, 0.324177f, 2.56436f, 
		3.67953f, 0.319942f, 2.18934f, 3.67962f, 0.320419f, 2.17147f, 
		3.67965f, 0.322634f, 2.57131f, 3.67966f, 0.280594f, 2.25487f, 
		3.67967f, 0.266678f, 2.25790f, 3.67969f, 0.314076f, 2.19387f, 
		3.67969f, 0.300689f, 2.25088f, 3.67972f, 0.307612f, 2.20518f, 
		3.67978f, 0.319739f, 2.57829f, 3.67981f, 0.314142f, 2.17313f, 
		3.67982f, 0.320667f, 2.59599f, 3.67993f, 0.313479f, 2.57260f, 
		3.67996f, 0.310265f, 2.53184f, 3.68001f, 0.314693f, 2.59433f, 
		3.68001f, 0.302361f, 2.20527f, 3.68007f, 0.307599f, 2.56217f, 
		3.68007f, 0.286905f, 2.22801f, 3.68007f, 0.305385f, 2.23352f, 
		3.68012f, 0.310439f, 2.24987f, 3.68020f, 0.301907f, 2.17182f, 
		3.68023f, 0.302967f, 2.56180f, 3.68030f, 0.295104f, 2.19427f, 
		3.68033f, 0.266927f, 2.53955f, 3.68034f, 0.295414f, 2.18398f, 
		3.68040f, 0.302292f, 2.59594f, 3.68044f, 0.291696f, 2.17472f, 
		3.68056f, 0.295096f, 2.57303f, 3.68059f, 0.295409f, 2.58349f, 
		3.68061f, 0.298734f, 2.52685f, 3.68090f, 0.321110f, 2.23874f, 
		3.68090f, 0.321110f, 2.52068f, 3.68104f, 0.291833f, 2.24791f, 
		3.68153f, 0.299359f, 2.23632f, 3.68166f, 0.283766f, 2.25721f, 
		3.68168f, 0.272864f, 2.54044f, 3.68168f, 0.305258f, 2.24584f, 
		3.68197f, 0.272726f, 2.25844f, 3.68198f, 0.283805f, 2.53895f, 
		3.68209f, 0.291361f, 2.59189f, 3.68222f, 0.284540f, 2.22456f, 
		3.68232f, 0.269006f, 2.20731f, 3.68250f, 0.298963f, 2.24192f, 
		3.68259f, 0.299371f, 2.52056f, 3.68282f, 0.287011f, 2.17861f, 
		3.68287f, 0.275507f, 2.50512f, 3.68289f, 0.301502f, 2.53153f, 
		3.68291f, 0.295910f, 2.58923f, 3.68319f, 0.280225f, 2.20511f, 
		3.68326f, 0.301969f, 2.51210f, 3.68326f, 0.301968f, 2.23017f, 
		3.68340f, 0.286959f, 2.19809f, 3.68371f, 0.283563f, 2.50587f, 
		3.68379f, 0.274405f, 2.22344f, 3.68407f, 0.312286f, 2.23319f, 
		3.68411f, 0.286857f, 2.56966f, 3.68412f, 0.312364f, 2.51522f, 
		3.68416f, 0.314966f, 2.52873f, 3.68416f, 0.314966f, 2.24680f, 
		3.68421f, 0.294304f, 2.19957f, 3.68451f, 0.305589f, 2.52332f, 
		3.68459f, 0.305579f, 2.24104f, 3.68500f, 0.295424f, 2.57031f, 
		3.68531f, 0.286765f, 2.58716f, 3.68531f, 0.266701f, 2.50679f, 
		3.68531f, 0.266701f, 2.22486f, 3.68535f, 0.295866f, 2.18020f, 
		3.68540f, 0.291207f, 2.23886f, 3.68540f, 0.291206f, 2.52080f, 
		3.68566f, 0.280260f, 2.59399f, 3.68574f, 0.267621f, 2.59612f, 
		3.68584f, 0.316149f, 2.24024f, 3.68584f, 0.316149f, 2.52218f, 
		3.68615f, 0.285326f, 2.51169f, 3.68643f, 0.282821f, 2.22556f, 
		3.68673f, 0.280416f, 2.17423f, 3.68710f, 0.286964f, 2.18311f, 
		3.68756f, 0.285425f, 2.24976f, 3.68772f, 0.286138f, 2.52998f, 
		3.68775f, 0.286933f, 2.19211f, 3.68784f, 0.286333f, 2.23287f, 
		3.68784f, 0.287017f, 2.58086f, 3.68787f, 0.269249f, 2.17273f, 
		3.68802f, 0.302717f, 2.24461f, 3.68809f, 0.280162f, 2.25014f, 
		3.68812f, 0.295823f, 2.57985f, 3.68817f, 0.295797f, 2.18997f, 
		3.68817f, 0.302756f, 2.52594f, 3.68821f, 0.290971f, 2.57229f, 
		3.68857f, 0.276859f, 2.53428f, 3.68877f, 0.280467f, 2.51429f, 
		3.68908f, 0.291632f, 2.58341f, 3.68919f, 0.282658f, 2.53393f, 
		3.68931f, 0.267735f, 2.53498f, 3.68949f, 0.279991f, 2.56704f, 
		3.68952f, 0.267431f, 2.56625f, 3.68957f, 0.274234f, 2.22748f, 
		3.69013f, 0.280574f, 2.52723f, 3.69034f, 0.285291f, 2.24191f, 
		3.69043f, 0.268458f, 2.20170f, 3.69079f, 0.269170f, 2.56543f, 
		3.69098f, 0.280435f, 2.23780f, 3.69123f, 0.266591f, 2.25058f, 
		3.69168f, 0.280281f, 2.19597f, 3.69212f, 0.282397f, 2.24823f, 
		3.69225f, 0.270652f, 2.51208f, 3.69270f, 0.283369f, 2.51674f, 
		3.69290f, 0.267682f, 2.58809f, 3.69313f, 0.267516f, 2.19503f, 
		3.69318f, 0.266525f, 2.24004f, 3.69332f, 0.268333f, 2.17967f, 
		3.69332f, 0.280288f, 2.18523f, 3.69337f, 0.269369f, 2.23346f, 
		3.69347f, 0.283234f, 2.23643f, 3.69350f, 0.283203f, 2.52510f, 
		3.69363f, 0.266535f, 2.52325f, 3.69365f, 0.280159f, 2.58252f, 
		3.69464f, 0.273152f, 2.24309f, 3.69501f, 0.271675f, 2.52458f, 
		3.69557f, 0.268969f, 2.19180f, 3.69566f, 0.269125f, 2.57894f, 
		3.70271f, 0.266331f, 2.15780f, 3.70271f, 0.266331f, 2.21374f, 
		3.70271f, 0.266331f, 2.26967f, 3.70271f, 0.266331f, 2.32561f, 
		3.70271f, 0.266331f, 2.38154f, 3.70271f, 0.266331f, 2.43748f, 
		3.70271f, 0.266331f, 2.49342f, 3.70271f, 0.266331f, 2.54935f, 
		3.70271f, 0.266331f, 2.60529f, 3.71208f, 0.273476f, 2.51997f, 
		3.71208f, 0.274387f, 2.23856f, 3.71226f, 0.267236f, 2.58129f, 
		3.71227f, 0.268514f, 2.18951f, 3.71263f, 0.283453f, 2.52368f, 
		3.71304f, 0.266782f, 2.52084f, 3.71311f, 0.270752f, 2.18320f, 
		3.71322f, 0.266973f, 2.24643f, 3.71325f, 0.282943f, 2.24355f, 
		3.71326f, 0.271356f, 2.53066f, 3.71428f, 0.267072f, 2.57158f, 
		3.71448f, 0.288542f, 2.18666f, 3.71453f, 0.269995f, 2.25150f, 
		3.71467f, 0.270987f, 2.19684f, 3.71489f, 0.284959f, 2.24024f, 
		3.71492f, 0.266892f, 2.23299f, 3.71515f, 0.266905f, 2.18036f, 
		3.71540f, 0.288318f, 2.58536f, 3.71617f, 0.288370f, 2.57365f, 
		3.71632f, 0.268286f, 2.59196f, 3.71639f, 0.266813f, 2.19676f, 
		3.71642f, 0.269721f, 2.51083f, 3.71664f, 0.280691f, 2.51820f, 
		3.71673f, 0.267918f, 2.53540f, 3.71678f, 0.282114f, 2.57960f, 
		3.71708f, 0.280863f, 2.23471f, 3.71717f, 0.283480f, 2.53441f, 
		3.71753f, 0.291765f, 2.58242f, 3.71768f, 0.283577f, 2.18899f, 
		3.71768f, 0.282943f, 2.22876f, 3.71786f, 0.280642f, 2.53170f, 
		3.71807f, 0.269748f, 2.22698f, 3.71810f, 0.280255f, 2.25042f, 
		3.71817f, 0.285191f, 2.51358f, 3.71828f, 0.338261f, 2.58051f, 
		3.71838f, 0.338118f, 2.18927f, 3.71853f, 0.283531f, 2.57529f, 
		3.71869f, 0.283171f, 2.50975f, 3.71870f, 0.277008f, 2.22820f, 
		3.71882f, 0.291708f, 2.57327f, 3.71884f, 0.287252f, 2.52760f, 
		3.71898f, 0.302608f, 2.23612f, 3.71929f, 0.274762f, 2.50836f, 
		3.71935f, 0.303419f, 2.24348f, 3.71936f, 0.302728f, 2.52784f, 
		3.71951f, 0.293026f, 2.19380f, 3.71969f, 0.301890f, 2.51825f, 
		3.71998f, 0.346972f, 2.57691f, 3.71999f, 0.346972f, 2.18522f, 
		3.72014f, 0.334215f, 2.19165f, 3.72017f, 0.315884f, 2.57741f, 
		3.72024f, 0.283671f, 2.25612f, 3.72026f, 0.337262f, 2.57333f, 
		3.72034f, 0.342594f, 2.57407f, 3.72036f, 0.316007f, 2.18642f, 
		3.72042f, 0.334288f, 2.58306f, 3.72052f, 0.289360f, 2.24483f, 
		3.72063f, 0.313695f, 2.52105f, 3.72064f, 0.269196f, 2.56465f, 
		3.72064f, 0.269196f, 2.17295f, 3.72065f, 0.343332f, 2.58539f, 
		3.72072f, 0.283644f, 2.58834f, 3.72074f, 0.343303f, 2.19380f, 
		3.72079f, 0.343890f, 2.18204f, 3.72094f, 0.347667f, 2.19243f, 
		3.72094f, 0.341931f, 2.18123f, 3.72100f, 0.285211f, 2.22924f, 
		3.72109f, 0.331091f, 2.18943f, 3.72124f, 0.283427f, 2.17929f, 
		3.72130f, 0.313763f, 2.24585f, 3.72135f, 0.288289f, 2.20166f, 
		3.72140f, 0.337558f, 2.58794f, 3.72146f, 0.331087f, 2.57680f, 
		3.72146f, 0.276528f, 2.59300f, 3.72150f, 0.315520f, 2.23970f, 
		3.72152f, 0.335373f, 2.18134f, 3.72174f, 0.313496f, 2.52854f, 
		3.72175f, 0.330522f, 2.18388f, 3.72187f, 0.316092f, 2.19426f, 
		3.72192f, 0.315990f, 2.58622f, 3.72213f, 0.292083f, 2.58968f, 
		3.72222f, 0.352139f, 2.57825f, 3.72222f, 0.352139f, 2.18656f, 
		3.72223f, 0.347423f, 2.58752f, 3.72247f, 0.300295f, 2.58090f, 
		3.72248f, 0.321117f, 2.57739f, 3.72261f, 0.305482f, 2.24128f, 
		3.72263f, 0.283621f, 2.19871f, 3.72270f, 0.300297f, 2.18612f, 
		3.72275f, 0.275114f, 2.53959f, 3.72279f, 0.291276f, 2.51851f, 
		3.72310f, 0.269295f, 2.20499f, 3.72317f, 0.288657f, 2.17396f, 
		3.72318f, 0.266669f, 2.50655f, 3.72322f, 0.345843f, 2.57090f, 
		3.72339f, 0.339341f, 2.19813f, 3.72340f, 0.302368f, 2.25081f, 
		3.72349f, 0.266865f, 2.59503f, 3.72351f, 0.305363f, 2.52028f, 
		3.72352f, 0.290933f, 2.23458f, 3.72360f, 0.266860f, 2.20341f, 
		3.72373f, 0.288832f, 2.56606f, 3.72381f, 0.283646f, 2.56924f, 
		3.72392f, 0.291936f, 2.17694f, 3.72401f, 0.309682f, 2.19133f, 
		3.72404f, 0.338982f, 2.59041f, 3.72404f, 0.316019f, 2.17981f, 
		3.72413f, 0.325769f, 2.18799f, 3.72414f, 0.326153f, 2.58061f, 
		3.72431f, 0.288507f, 2.59457f, 3.72432f, 0.313644f, 2.23276f, 
		3.72440f, 0.313696f, 2.51465f, 3.72448f, 0.351884f, 2.58594f, 
		3.72451f, 0.351851f, 2.19433f, 3.72454f, 0.299638f, 2.24478f, 
		3.72468f, 0.334327f, 2.57078f, 3.72475f, 0.301313f, 2.19405f, 
		3.72476f, 0.299428f, 2.51955f, 3.72486f, 0.295455f, 2.24551f, 
		3.72486f, 0.295456f, 2.52745f, 3.72488f, 0.309414f, 2.57510f, 
		3.72489f, 0.309761f, 2.18422f, 3.72502f, 0.266785f, 2.54016f, 
		3.72524f, 0.316099f, 2.57096f, 3.72550f, 0.300873f, 2.57351f, 
		3.72564f, 0.346899f, 2.19819f, 3.72565f, 0.303755f, 2.53351f, 
		3.72571f, 0.306181f, 2.53003f, 3.72583f, 0.337997f, 2.17720f, 
		3.72590f, 0.336913f, 2.19948f, 3.72596f, 0.308138f, 2.58466f, 
		3.72615f, 0.330907f, 2.19691f, 3.72619f, 0.338182f, 2.56864f, 
		3.72620f, 0.267037f, 2.25891f, 3.72637f, 0.330873f, 2.58867f, 
		3.72639f, 0.266794f, 2.22385f, 3.72649f, 0.289040f, 2.51273f, 
		3.72652f, 0.286300f, 2.53643f, 3.72662f, 0.298916f, 2.52796f, 
		3.72663f, 0.283640f, 2.22383f, 3.72670f, 0.334651f, 2.58985f, 
		3.72682f, 0.342833f, 2.19863f, 3.72682f, 0.342833f, 2.59032f, 
		3.72687f, 0.283658f, 2.50569f, 3.72692f, 0.313150f, 2.25131f, 
		3.72697f, 0.299363f, 2.23573f, 3.72699f, 0.280663f, 2.25558f, 
		3.72701f, 0.300682f, 2.18101f, 3.72702f, 0.283731f, 2.54026f, 
		3.72706f, 0.286829f, 2.25402f, 3.72737f, 0.325801f, 2.58515f, 
		3.72749f, 0.330931f, 2.57104f, 3.72753f, 0.268087f, 2.59799f, 
		3.72758f, 0.280603f, 2.22639f, 3.72763f, 0.325746f, 2.19380f, 
		3.72772f, 0.321211f, 2.52508f, 3.72777f, 0.321259f, 2.24305f, 
		3.72779f, 0.273135f, 2.26001f, 3.72780f, 0.267166f, 2.17037f, 
		3.72780f, 0.267166f, 2.56207f, 3.72803f, 0.331967f, 2.17883f, 
		3.72820f, 0.280651f, 2.50816f, 3.72838f, 0.320490f, 2.51821f, 
		3.72839f, 0.320489f, 2.23627f, 3.72841f, 0.352650f, 2.18065f, 
		3.72842f, 0.352645f, 2.57234f, 3.72859f, 0.326106f, 2.18229f, 
		3.72859f, 0.325908f, 2.57397f, 3.72869f, 0.291942f, 2.20127f, 
		3.72870f, 0.314776f, 2.59023f, 3.72875f, 0.302360f, 2.51101f, 
		3.72886f, 0.305558f, 2.51535f, 3.72887f, 0.343443f, 2.56901f, 
		3.72897f, 0.347812f, 2.17752f, 3.72918f, 0.343869f, 2.17711f, 
		3.72927f, 0.315158f, 2.19872f, 3.72956f, 0.302212f, 2.22859f, 
		3.72957f, 0.283620f, 2.59248f, 3.73013f, 0.308898f, 2.19528f, 
		3.73018f, 0.317428f, 2.53208f, 3.73021f, 0.283532f, 2.17570f, 
		3.73029f, 0.268283f, 2.18829f, 3.73029f, 0.268283f, 2.57998f, 
		3.73040f, 0.272760f, 2.50427f, 3.73047f, 0.300998f, 2.58782f, 
		3.73080f, 0.309034f, 2.58673f, 3.73095f, 0.267784f, 2.24105f, 
		3.73097f, 0.267735f, 2.52307f, 3.73122f, 0.305542f, 2.23284f, 
		3.73132f, 0.334426f, 2.19906f, 3.73139f, 0.299523f, 2.51606f, 
		3.73152f, 0.345954f, 2.59131f, 3.73166f, 0.305359f, 2.53068f, 
		3.73174f, 0.309676f, 2.18157f, 3.73175f, 0.285713f, 2.22649f, 
		3.73182f, 0.312912f, 2.23027f, 3.73187f, 0.312952f, 2.51222f, 
		3.73199f, 0.283711f, 2.56717f, 3.73210f, 0.274765f, 2.22256f, 
		3.73233f, 0.299716f, 2.19623f, 3.73252f, 0.352101f, 2.19641f, 
		3.73254f, 0.336334f, 2.56877f, 3.73254f, 0.288373f, 2.56423f, 
		3.73266f, 0.283623f, 2.20072f, 3.73275f, 0.305211f, 2.24914f, 
		3.73292f, 0.325871f, 2.19446f, 3.73292f, 0.302381f, 2.53529f, 
		3.73299f, 0.280534f, 2.53777f, 3.73309f, 0.300295f, 2.18090f, 
		3.73318f, 0.299321f, 2.52926f, 3.73324f, 0.326008f, 2.18302f, 
		3.73327f, 0.288917f, 2.59512f, 3.73330f, 0.299324f, 2.24730f, 
		3.73330f, 0.338234f, 2.17669f, 3.73342f, 0.318937f, 2.58871f, 
		3.73348f, 0.331812f, 2.58915f, 3.73348f, 0.292167f, 2.56794f, 
		3.73356f, 0.318886f, 2.19691f, 3.73356f, 0.355033f, 2.58069f, 
		3.73356f, 0.355033f, 2.18900f, 3.73375f, 0.292081f, 2.24987f, 
		3.73383f, 0.284721f, 2.50735f, 3.73398f, 0.299577f, 2.23466f, 
		3.73404f, 0.341159f, 2.56855f, 3.73415f, 0.326147f, 2.58464f, 
		3.73434f, 0.300451f, 2.57303f, 3.73437f, 0.352206f, 2.58773f, 
		3.73437f, 0.285058f, 2.53804f, 3.73441f, 0.291487f, 2.51444f, 
		3.73445f, 0.316092f, 2.57046f, 3.73447f, 0.316066f, 2.17872f, 
		3.73449f, 0.292443f, 2.17637f, 3.73455f, 0.292381f, 2.23327f, 
		3.73456f, 0.343184f, 2.17842f, 3.73459f, 0.318549f, 2.24810f, 
		3.73461f, 0.268806f, 2.20629f, 3.73461f, 0.309703f, 2.57453f, 
		3.73477f, 0.310476f, 2.53261f, 3.73483f, 0.310778f, 2.25067f, 
		3.73495f, 0.338266f, 2.59125f, 3.73499f, 0.332359f, 2.17966f, 
		3.73545f, 0.301343f, 2.25180f, 3.73556f, 0.352000f, 2.57363f, 
		3.73565f, 0.283950f, 2.25783f, 3.73575f, 0.321112f, 2.52150f, 
		3.73581f, 0.325909f, 2.57788f, 3.73586f, 0.266904f, 2.54013f, 
		3.73591f, 0.345711f, 2.56990f, 3.73606f, 0.268883f, 2.59741f, 
		3.73611f, 0.347709f, 2.19715f, 3.73613f, 0.308138f, 2.58246f, 
		3.73617f, 0.331700f, 2.57214f, 3.73619f, 0.273117f, 2.54120f, 
		3.73623f, 0.288754f, 2.20274f, 3.73626f, 0.325989f, 2.18721f, 
		3.73644f, 0.292423f, 2.52966f, 3.73656f, 0.320859f, 2.24022f, 
		3.73659f, 0.266797f, 2.50573f, 3.73666f, 0.300338f, 2.19301f, 
		3.73667f, 0.266603f, 2.22391f, 3.73674f, 0.330996f, 2.19535f, 
		3.73677f, 0.337609f, 2.19854f, 3.73693f, 0.283660f, 2.17766f, 
		3.73699f, 0.350962f, 2.18206f, 3.73702f, 0.283780f, 2.59054f, 
		3.73716f, 0.342740f, 2.19737f, 3.73734f, 0.309328f, 2.18831f, 
		3.73742f, 0.283477f, 2.56966f, 3.73768f, 0.268529f, 2.17179f, 
		3.73772f, 0.266591f, 2.25719f, 3.73777f, 0.299355f, 2.52208f, 
		3.73791f, 0.268626f, 2.56354f, 3.73794f, 0.305138f, 2.51947f, 
		3.73825f, 0.301398f, 2.51388f, 3.73827f, 0.299856f, 2.18575f, 
		3.73829f, 0.315552f, 2.58637f, 3.73830f, 0.315546f, 2.19466f, 
		3.73830f, 0.334483f, 2.58669f, 3.73833f, 0.299837f, 2.57915f, 
		3.73844f, 0.277097f, 2.17485f, 3.73847f, 0.283554f, 2.22469f, 
		3.73851f, 0.292914f, 2.23844f, 3.73866f, 0.320882f, 2.57988f, 
		3.73870f, 0.280527f, 2.25388f, 3.73870f, 0.344426f, 2.19727f, 
		3.73872f, 0.299499f, 2.24180f, 3.73883f, 0.293239f, 2.24287f, 
		3.73884f, 0.347844f, 2.58567f, 3.73885f, 0.312292f, 2.51590f, 
		3.73885f, 0.312297f, 2.23396f, 3.73887f, 0.338012f, 2.57175f, 
		3.73887f, 0.305340f, 2.24049f, 3.73889f, 0.315036f, 2.52954f, 
		3.73915f, 0.288294f, 2.17472f, 3.73919f, 0.305559f, 2.52502f, 
		3.73919f, 0.315137f, 2.18315f, 3.73935f, 0.330916f, 2.58159f, 
		3.73939f, 0.330950f, 2.18581f, 3.73942f, 0.343569f, 2.58663f, 
		3.73944f, 0.349425f, 2.57667f, 3.73956f, 0.334047f, 2.19281f, 
		3.73961f, 0.335278f, 2.18197f, 3.73969f, 0.292736f, 2.58801f, 
		3.73979f, 0.275024f, 2.25708f, 3.74013f, 0.266912f, 2.20288f, 
		3.74014f, 0.280424f, 2.22892f, 3.74024f, 0.291892f, 2.57147f, 
		3.74026f, 0.303941f, 2.51621f, 3.74030f, 0.274611f, 2.50700f, 
		3.74032f, 0.348739f, 2.18954f, 3.74039f, 0.315056f, 2.57696f, 
		3.74040f, 0.316181f, 2.18873f, 3.74057f, 0.285408f, 2.25259f, 
		3.74060f, 0.342730f, 2.18351f, 3.74062f, 0.316149f, 2.52293f, 
		3.74067f, 0.266919f, 2.17482f, 3.74067f, 0.266919f, 2.56652f, 
		3.74078f, 0.342773f, 2.57544f, 3.74079f, 0.335678f, 2.57652f, 
		3.74080f, 0.283168f, 2.50785f, 3.74090f, 0.283612f, 2.19529f, 
		3.74113f, 0.344898f, 2.18349f, 3.74122f, 0.290018f, 2.52241f, 
		3.74125f, 0.302392f, 2.23430f, 3.74133f, 0.291790f, 2.18145f, 
		3.74146f, 0.339006f, 2.58376f, 3.74165f, 0.273074f, 2.22587f, 
		3.74167f, 0.345456f, 2.57781f, 3.74167f, 0.312345f, 2.24313f, 
		3.74187f, 0.283798f, 2.57552f, 3.74216f, 0.301590f, 2.52779f, 
		3.74220f, 0.266988f, 2.59335f, 3.74226f, 0.283595f, 2.18482f, 
		3.74240f, 0.283582f, 2.58343f, 3.74245f, 0.339192f, 2.18984f, 
		3.74247f, 0.303208f, 2.24515f, 3.74315f, 0.280470f, 2.51379f, 
		3.74337f, 0.285414f, 2.51473f, 3.74350f, 0.288969f, 2.19587f, 
		3.74356f, 0.285258f, 2.23263f, 3.74358f, 0.288407f, 2.57120f, 
		3.74377f, 0.288387f, 2.58790f, 3.74379f, 0.282957f, 2.25358f, 
		3.74388f, 0.282910f, 2.53542f, 3.74396f, 0.284813f, 2.53182f, 
		3.74426f, 0.276324f, 2.58749f, 3.74427f, 0.276735f, 2.53434f, 
		3.74433f, 0.266489f, 2.51198f, 3.74452f, 0.266569f, 2.53462f, 
		3.74505f, 0.285680f, 2.24179f, 3.74513f, 0.289595f, 2.57997f, 
		3.74533f, 0.280497f, 2.24213f, 3.74544f, 0.269006f, 2.56989f, 
		3.74555f, 0.268623f, 2.17865f, 3.74571f, 0.289000f, 2.18758f, 
		3.74580f, 0.280500f, 2.52581f, 3.74628f, 0.268834f, 2.19709f, 
		3.74630f, 0.267371f, 2.23125f, 3.74653f, 0.282924f, 2.23311f, 
		3.74654f, 0.267367f, 2.25078f, 3.74674f, 0.266839f, 2.18829f, 
		3.74689f, 0.266821f, 2.58003f, 3.74765f, 0.274313f, 2.24847f, 
		3.74797f, 0.266456f, 2.24099f, 3.74832f, 0.266484f, 2.52355f, 
		3.74835f, 0.269493f, 2.18780f, 3.74839f, 0.269239f, 2.57964f, 
		3.74852f, 0.283449f, 2.24294f, 3.74860f, 0.282965f, 2.52120f, 
		3.74908f, 0.270725f, 2.51795f, 3.74914f, 0.272697f, 2.52657f, 
		3.74914f, 0.274729f, 2.23817f, 3.75865f, 0.266331f, 2.15780f, 
		3.75865f, 0.266331f, 2.21374f, 3.75865f, 0.266331f, 2.26967f, 
		3.75865f, 0.266331f, 2.32561f, 3.75865f, 0.266331f, 2.38154f, 
		3.75865f, 0.266331f, 2.43748f, 3.75865f, 0.266331f, 2.49342f, 
		3.75865f, 0.266331f, 2.54935f, 3.75865f, 0.266331f, 2.60529f, 
		3.76479f, 0.283858f, 2.18307f, 3.76515f, 0.267397f, 2.19034f, 
		3.76633f, 0.266849f, 2.17803f, 3.76731f, 0.273076f, 2.52005f, 
		3.76771f, 0.268365f, 2.57804f, 3.76795f, 0.305069f, 2.18552f, 
		3.76805f, 0.266991f, 2.24171f, 3.76818f, 0.283678f, 2.24110f, 
		3.76819f, 0.283559f, 2.52303f, 3.76849f, 0.270620f, 2.19629f, 
		3.76859f, 0.318779f, 2.18825f, 3.76868f, 0.284167f, 2.58025f, 
		3.76871f, 0.284148f, 2.57019f, 3.76871f, 0.271011f, 2.52999f, 
		3.76873f, 0.284338f, 2.19748f, 3.76910f, 0.266903f, 2.51679f, 
		3.76928f, 0.271664f, 2.23146f, 3.76972f, 0.282035f, 2.18212f, 
		3.76991f, 0.290340f, 2.18796f, 3.77052f, 0.319001f, 2.17735f, 
		3.77061f, 0.280165f, 2.24179f, 3.77085f, 0.305082f, 2.57589f, 
		3.77091f, 0.269812f, 2.25162f, 3.77099f, 0.290327f, 2.17860f, 
		3.77147f, 0.314420f, 2.18866f, 3.77149f, 0.285907f, 2.51993f, 
		3.77173f, 0.318939f, 2.57580f, 3.77184f, 0.266908f, 2.58871f, 
		3.77187f, 0.305288f, 2.19602f, 3.77219f, 0.305109f, 2.17411f, 
		3.77219f, 0.280696f, 2.51736f, 3.77221f, 0.269601f, 2.16973f, 
		3.77237f, 0.266926f, 2.53335f, 3.77275f, 0.290403f, 2.57801f, 
		3.77283f, 0.282065f, 2.57162f, 3.77314f, 0.303967f, 2.18472f, 
		3.77317f, 0.286228f, 2.24700f, 3.77322f, 0.282947f, 2.22799f, 
		3.77322f, 0.318769f, 2.58305f, 3.77323f, 0.319063f, 2.56795f, 
		3.77326f, 0.267058f, 2.56116f, 3.77339f, 0.280642f, 2.53095f, 
		3.77355f, 0.284159f, 2.16792f, 3.77364f, 0.281895f, 2.19646f, 
		3.77364f, 0.266916f, 2.25285f, 3.77370f, 0.280260f, 2.24975f, 
		3.77384f, 0.295845f, 2.19276f, 3.77393f, 0.284182f, 2.59045f, 
		3.77396f, 0.290413f, 2.56878f, 3.77412f, 0.314336f, 2.17657f, 
		3.77412f, 0.283181f, 2.50910f, 3.77414f, 0.282025f, 2.17376f, 
		3.77418f, 0.290280f, 2.19706f, 3.77430f, 0.295511f, 2.17784f, 
		3.77476f, 0.268161f, 2.50760f, 3.77483f, 0.302262f, 2.52478f, 
		3.77506f, 0.305174f, 2.56447f, 3.77531f, 0.304008f, 2.19258f, 
		3.77534f, 0.301975f, 2.24534f, 3.77569f, 0.280580f, 2.22880f, 
		3.77594f, 0.296464f, 2.57163f, 3.77601f, 0.290389f, 2.17217f, 
		3.77601f, 0.314502f, 2.56719f, 3.77604f, 0.318713f, 2.20019f, 
		3.77607f, 0.313469f, 2.52031f, 3.77614f, 0.282001f, 2.58662f, 
		3.77618f, 0.266778f, 2.22515f, 3.77619f, 0.305160f, 2.58841f, 
		3.77624f, 0.276961f, 2.50764f, 3.77624f, 0.283588f, 2.25564f, 
		3.77625f, 0.302194f, 2.51610f, 3.77628f, 0.302015f, 2.23426f, 
		3.77637f, 0.283766f, 2.53750f, 3.77650f, 0.304360f, 2.57244f, 
		3.77653f, 0.285211f, 2.51042f, 3.77671f, 0.285457f, 2.22916f, 
		3.77678f, 0.304145f, 2.17645f, 3.77682f, 0.303666f, 2.57967f, 
		3.77698f, 0.282030f, 2.56415f, 3.77699f, 0.283926f, 2.20465f, 
		3.77703f, 0.315519f, 2.23895f, 3.77706f, 0.291430f, 2.52384f, 
		3.77706f, 0.291431f, 2.24191f, 3.77711f, 0.314632f, 2.24485f, 
		3.77713f, 0.290122f, 2.23627f, 3.77717f, 0.284509f, 2.55762f, 
		3.77721f, 0.290486f, 2.58746f, 3.77723f, 0.274336f, 2.53874f, 
		3.77731f, 0.266894f, 2.20501f, 3.77741f, 0.313341f, 2.52808f, 
		3.77824f, 0.318972f, 2.16932f, 3.77851f, 0.305653f, 2.24263f, 
		3.77861f, 0.297232f, 2.58398f, 3.77864f, 0.305575f, 2.52068f, 
		3.77891f, 0.311097f, 2.17916f, 3.77896f, 0.305543f, 2.23728f, 
		3.77897f, 0.304973f, 2.20209f, 3.77900f, 0.290332f, 2.56246f, 
		3.77908f, 0.286265f, 2.53502f, 3.77957f, 0.319069f, 2.59098f, 
		3.77973f, 0.266800f, 2.16512f, 3.77981f, 0.313639f, 2.23204f, 
		3.78000f, 0.302258f, 2.53250f, 3.78001f, 0.291701f, 2.51545f, 
		3.78002f, 0.313760f, 2.51387f, 3.78003f, 0.314658f, 2.19961f, 
		3.78004f, 0.280584f, 2.25447f, 3.78025f, 0.299437f, 2.24269f, 
		3.78025f, 0.299437f, 2.52463f, 3.78058f, 0.311062f, 2.19291f, 
		3.78062f, 0.270462f, 2.16501f, 3.78067f, 0.266886f, 2.53950f, 
		3.78073f, 0.311382f, 2.57157f, 3.78073f, 0.276807f, 2.22343f, 
		3.78081f, 0.269907f, 2.25840f, 3.78085f, 0.319039f, 2.55988f, 
		3.78101f, 0.267372f, 2.59573f, 3.78137f, 0.282031f, 2.20171f, 
		3.78144f, 0.305127f, 2.16764f, 3.78145f, 0.305547f, 2.52929f, 
		3.78152f, 0.315093f, 2.17022f, 3.78155f, 0.311122f, 2.58197f, 
		3.78175f, 0.305573f, 2.24761f, 3.78181f, 0.266644f, 2.50519f, 
		3.78208f, 0.291217f, 2.24859f, 3.78208f, 0.291218f, 2.53052f, 
		3.78232f, 0.283656f, 2.50497f, 3.78243f, 0.283643f, 2.22300f, 
		3.78272f, 0.304424f, 2.56365f, 3.78278f, 0.290646f, 2.20195f, 
		3.78280f, 0.305179f, 2.55871f, 3.78288f, 0.314705f, 2.59005f, 
		3.78288f, 0.304306f, 2.19816f, 3.78289f, 0.304441f, 2.58776f, 
		3.78298f, 0.296208f, 2.17195f, 3.78302f, 0.301922f, 2.22908f, 
		3.78322f, 0.282080f, 2.16850f, 3.78325f, 0.321211f, 2.52433f, 
		3.78325f, 0.321211f, 2.24240f, 3.78340f, 0.269812f, 2.22166f, 
		3.78350f, 0.270514f, 2.55536f, 3.78351f, 0.299110f, 2.51643f, 
		3.78351f, 0.299110f, 2.23449f, 3.78391f, 0.320491f, 2.23553f, 
		3.78391f, 0.320491f, 2.51746f, 3.78394f, 0.296508f, 2.56285f, 
		3.78434f, 0.296417f, 2.58886f, 3.78435f, 0.280751f, 2.50744f, 
		3.78437f, 0.284545f, 2.59693f, 3.78451f, 0.301853f, 2.25202f, 
		3.78472f, 0.285838f, 2.25473f, 3.78490f, 0.302267f, 2.51008f, 
		3.78506f, 0.290262f, 2.16821f, 3.78549f, 0.304299f, 2.17186f, 
		3.78569f, 0.290700f, 2.59230f, 3.78572f, 0.317427f, 2.53133f, 
		3.78572f, 0.317427f, 2.24940f, 3.78584f, 0.314971f, 2.56048f, 
		3.78591f, 0.305544f, 2.23212f, 3.78600f, 0.296255f, 2.19934f, 
		3.78614f, 0.282179f, 2.55888f, 3.78620f, 0.267885f, 2.52227f, 
		3.78632f, 0.282173f, 2.59267f, 3.78638f, 0.284867f, 2.16428f, 
		3.78651f, 0.267857f, 2.24034f, 3.78656f, 0.274130f, 2.50366f, 
		3.78656f, 0.318622f, 2.20322f, 3.78682f, 0.305500f, 2.51413f, 
		3.78701f, 0.284680f, 2.20665f, 3.78727f, 0.285714f, 2.22574f, 
		3.78728f, 0.285713f, 2.50767f, 3.78733f, 0.312856f, 2.22952f, 
		3.78742f, 0.312903f, 2.51147f, 3.78778f, 0.290451f, 2.55862f, 
		3.78837f, 0.272482f, 2.54087f, 3.78852f, 0.299352f, 2.52912f, 
		3.78853f, 0.299279f, 2.24720f, 3.78898f, 0.280564f, 2.53711f, 
		3.78907f, 0.294123f, 2.53004f, 3.78907f, 0.294124f, 2.24811f, 
		3.78925f, 0.305155f, 2.59427f, 3.78929f, 0.318662f, 2.59358f, 
		3.78938f, 0.321746f, 2.24052f, 3.78938f, 0.321746f, 2.52246f, 
		3.78957f, 0.318644f, 2.16740f, 3.78964f, 0.283948f, 2.53894f, 
		3.78997f, 0.280594f, 2.25487f, 3.79010f, 0.266681f, 2.25791f, 
		3.79020f, 0.292402f, 2.51454f, 3.79020f, 0.292402f, 2.23261f, 
		3.79030f, 0.310198f, 2.53181f, 3.79033f, 0.310849f, 2.24993f, 
		3.79060f, 0.301952f, 2.22924f, 3.79076f, 0.311243f, 2.56548f, 
		3.79083f, 0.267198f, 2.20702f, 3.79115f, 0.304423f, 2.19821f, 
		3.79127f, 0.305144f, 2.20330f, 3.79128f, 0.305280f, 2.24630f, 
		3.79130f, 0.280621f, 2.22660f, 3.79139f, 0.266905f, 2.53938f, 
		3.79143f, 0.266897f, 2.55420f, 3.79155f, 0.311324f, 2.17623f, 
		3.79157f, 0.305220f, 2.55750f, 3.79164f, 0.287785f, 2.25174f, 
		3.79164f, 0.287785f, 2.53367f, 3.79170f, 0.302689f, 2.25168f, 
		3.79179f, 0.311318f, 2.19451f, 3.79180f, 0.304478f, 2.58902f, 
		3.79184f, 0.290166f, 2.20153f, 3.79185f, 0.302393f, 2.53358f, 
		3.79186f, 0.282015f, 2.20152f, 3.79197f, 0.283766f, 2.25721f, 
		3.79206f, 0.268285f, 2.50458f, 3.79215f, 0.318756f, 2.55780f, 
		3.79224f, 0.272769f, 2.25844f, 3.79231f, 0.305373f, 2.52785f, 
		3.79240f, 0.267168f, 2.16461f, 3.79264f, 0.299533f, 2.51900f, 
		3.79277f, 0.282236f, 2.16904f, 3.79291f, 0.283658f, 2.22378f, 
		3.79315f, 0.282908f, 2.59446f, 3.79320f, 0.270910f, 2.59653f, 
		3.79323f, 0.315198f, 2.20023f, 3.79324f, 0.283883f, 2.55410f, 
		3.79328f, 0.296611f, 2.17302f, 3.79357f, 0.317025f, 2.23457f, 
		3.79357f, 0.317025f, 2.51650f, 3.79361f, 0.299223f, 2.23824f, 
		3.79395f, 0.304295f, 2.56267f, 3.79404f, 0.296604f, 2.58892f, 
		3.79411f, 0.274405f, 2.22344f, 3.79415f, 0.293632f, 2.24233f, 
		3.79419f, 0.276504f, 2.55694f, 3.79419f, 0.310318f, 2.23372f, 
		3.79429f, 0.310507f, 2.51571f, 3.79442f, 0.315036f, 2.52879f, 
		3.79442f, 0.315035f, 2.24686f, 3.79444f, 0.296317f, 2.56265f, 
		3.79445f, 0.292213f, 2.23733f, 3.79462f, 0.293519f, 2.52283f, 
		3.79469f, 0.304870f, 2.16876f, 3.79469f, 0.301658f, 2.51344f, 
		3.79475f, 0.290227f, 2.59187f, 3.79488f, 0.305388f, 2.24007f, 
		3.79495f, 0.305434f, 2.52241f, 3.79496f, 0.283692f, 2.16535f, 
		3.79501f, 0.283752f, 2.50648f, 3.79526f, 0.318689f, 2.20117f, 
		3.79547f, 0.315052f, 2.17164f, 3.79554f, 0.290493f, 2.17077f, 
		3.79562f, 0.266701f, 2.22486f, 3.79578f, 0.311425f, 2.58441f, 
		3.79605f, 0.311040f, 2.18477f, 3.79609f, 0.276372f, 2.50764f, 
		3.79615f, 0.316149f, 2.24024f, 3.79615f, 0.316149f, 2.52218f, 
		3.79635f, 0.288072f, 2.51521f, 3.79651f, 0.314728f, 2.56158f, 
		3.79665f, 0.304381f, 2.17600f, 3.79670f, 0.296811f, 2.19533f, 
		3.79683f, 0.303316f, 2.24541f, 3.79737f, 0.274662f, 2.53704f, 
		3.79751f, 0.302955f, 2.23540f, 3.79753f, 0.284123f, 2.20407f, 
		3.79791f, 0.317674f, 2.59173f, 3.79814f, 0.290558f, 2.56094f, 
		3.79824f, 0.302018f, 2.52472f, 3.79840f, 0.280161f, 2.25014f, 
		3.79886f, 0.297001f, 2.17912f, 3.79897f, 0.280469f, 2.51403f, 
		3.79909f, 0.285257f, 2.23188f, 3.79910f, 0.281329f, 2.59003f, 
		3.79918f, 0.314297f, 2.19414f, 3.79919f, 0.266617f, 2.53488f, 
		3.79923f, 0.283090f, 2.53439f, 3.79924f, 0.266800f, 2.50904f, 
		3.79970f, 0.286501f, 2.24291f, 3.79971f, 0.311219f, 2.57437f, 
		3.79988f, 0.274234f, 2.22748f, 3.79994f, 0.281942f, 2.56213f, 
		3.80007f, 0.267232f, 2.20284f, 3.80034f, 0.304391f, 2.18856f, 
		3.80042f, 0.270412f, 2.16903f, 3.80044f, 0.280574f, 2.52723f, 
		3.80045f, 0.290361f, 2.19562f, 3.80049f, 0.296559f, 2.18577f, 
		3.80056f, 0.304396f, 2.58397f, 3.80097f, 0.296952f, 2.58353f, 
		3.80108f, 0.283262f, 2.25012f, 3.80141f, 0.280417f, 2.23811f, 
		3.80145f, 0.267239f, 2.55770f, 3.80160f, 0.266591f, 2.25042f, 
		3.80171f, 0.305303f, 2.17516f, 3.80182f, 0.282102f, 2.19341f, 
		3.80184f, 0.296208f, 2.56888f, 3.80184f, 0.290283f, 2.17805f, 
		3.80190f, 0.281954f, 2.17811f, 3.80197f, 0.305188f, 2.58971f, 
		3.80201f, 0.318669f, 2.17538f, 3.80211f, 0.314680f, 2.18333f, 
		3.80215f, 0.267077f, 2.59343f, 3.80239f, 0.304410f, 2.57154f, 
		3.80244f, 0.305133f, 2.56237f, 3.80263f, 0.318464f, 2.19417f, 
		3.80266f, 0.305115f, 2.19489f, 3.80284f, 0.318674f, 2.56368f, 
		3.80309f, 0.297831f, 2.57660f, 3.80314f, 0.283132f, 2.23240f, 
		3.80330f, 0.290444f, 2.58602f, 3.80347f, 0.282226f, 2.18540f, 
		3.80349f, 0.266525f, 2.24004f, 3.80354f, 0.283447f, 2.51945f, 
		3.80357f, 0.290985f, 2.18637f, 3.80368f, 0.269369f, 2.23346f, 
		3.80369f, 0.271105f, 2.51467f, 3.80377f, 0.283311f, 2.52531f, 
		3.80388f, 0.266541f, 2.52269f, 3.80401f, 0.269414f, 2.19796f, 
		3.80442f, 0.290454f, 2.56778f, 3.80451f, 0.318907f, 2.18582f, 
		3.80481f, 0.267037f, 2.17447f, 3.80492f, 0.273313f, 2.52491f, 
		3.80495f, 0.273152f, 2.24309f, 3.80503f, 0.284384f, 2.17395f, 
		3.80508f, 0.305030f, 2.18457f, 3.80513f, 0.284251f, 2.19603f, 
		3.80542f, 0.282025f, 2.56940f, 3.80543f, 0.284634f, 2.59106f, 
		3.80546f, 0.318204f, 2.58429f, 3.80614f, 0.318069f, 2.56942f, 
		3.80617f, 0.282700f, 2.58409f, 3.80622f, 0.270225f, 2.17708f, 
		3.80648f, 0.282178f, 2.57767f, 3.80650f, 0.291020f, 2.57658f, 
		3.80704f, 0.284252f, 2.56295f, 3.80741f, 0.318610f, 2.57554f, 
		3.80747f, 0.270022f, 2.58731f, 3.80803f, 0.284207f, 2.18595f, 
		3.80810f, 0.304880f, 2.57569f, 3.80820f, 0.266832f, 2.18586f, 
		3.80885f, 0.267877f, 2.56635f, 3.81090f, 0.284369f, 2.57583f, 
		3.81108f, 0.266900f, 2.57618f, 3.81459f, 0.266331f, 2.15780f, 
		3.81459f, 0.266331f, 2.21374f, 3.81459f, 0.266331f, 2.26967f, 
		3.81459f, 0.266331f, 2.32561f, 3.81459f, 0.266331f, 2.38154f, 
		3.81459f, 0.266331f, 2.43748f, 3.81459f, 0.266331f, 2.49342f, 
		3.81459f, 0.266331f, 2.54935f, 3.81459f, 0.266331f, 2.60529f, 
		3.82578f, 0.273742f, 2.14661f, 3.82578f, 0.273742f, 2.61648f, 
		3.83696f, 0.217805f, 2.13542f, 3.83696f, 0.217805f, 2.62767f, 
		3.83696f, 0.273742f, 2.13542f, 3.83696f, 0.273742f, 2.62767f
	};
	static const GLfloat NormalData[] = {
		-1.00000f, 0.000000f, 0.000000f, -0.999904f, 0.0104057f, 0.00910612f, -0.999903f, -0.00864407f, 0.0109238f, 
		-0.999804f, 0.0112211f, 0.0163249f, -0.999753f, -0.0201499f, -0.00941891f, 
		-0.999716f, -0.0235476f, 0.00375638f, -0.999679f, -0.0169807f, 0.0187915f, 
		-0.999608f, -0.0271932f, -0.00670430f, -0.999574f, -0.0286618f, 0.00555761f, 
		-0.999571f, -0.0281866f, 0.00801295f, -0.999564f, -0.0276306f, -0.0103709f, 
		-0.999559f, -0.0278135f, 0.0103571f, -0.999555f, -0.0291963f, 0.00609962f, 
		-0.999545f, -0.0293758f, 0.00689513f, -0.999521f, -0.0307446f, 0.00348772f, 
		-0.999513f, -0.0311063f, 0.00263558f, -0.999512f, -0.0311899f, 0.00147123f, 
		-0.999495f, -0.0310900f, 0.00663424f, -0.999494f, -0.0306598f, -0.00845153f, 
		-0.999488f, -0.0314560f, -0.00583041f, -0.999488f, -0.0315343f, -0.00542019f, 
		-0.999486f, -0.0319420f, 0.00283788f, -0.999483f, -0.0319801f, 0.00326673f, 
		-0.999475f, -0.0318949f, -0.00565326f, -0.999475f, -0.0229743f, 0.0228459f, 
		-0.999470f, -0.0320459f, -0.00568523f, -0.999470f, -0.0304856f, -0.0114377f, 
		-0.999467f, -0.0323710f, 0.00426650f, -0.999466f, -0.0321859f, 0.00570791f, 
		-0.999463f, -0.0323418f, -0.00529216f, -0.999461f, -0.0325041f, 0.00454696f, 
		-0.999459f, -0.0326173f, 0.00425543f, -0.999458f, -0.0326584f, 0.00421449f, 
		-0.999446f, -0.0328469f, 0.00536806f, -0.999443f, -0.0333438f, 0.00117753f, 
		-0.999442f, -0.0256853f, 0.0213399f, -0.999438f, -0.0331760f, 0.00485992f, 
		-0.999430f, -0.0336476f, 0.00256924f, -0.999430f, -0.0332515f, -0.00586855f, 
		-0.999429f, -0.0336827f, 0.00258274f, -0.999419f, -0.0335444f, 0.00608176f, 
		-0.999417f, -0.0337942f, -0.00477700f, -0.999417f, -0.0340764f, 0.00206076f, 
		-0.999414f, -0.0334639f, 0.00719351f, -0.999406f, -0.0342296f, 0.00412385f, 
		-0.999398f, -0.0336007f, 0.00863077f, -0.999395f, -0.0343017f, 0.00578817f, 
		-0.999394f, -0.0344205f, 0.00512234f, -0.999393f, -0.0343810f, 0.00569684f, 
		-0.999389f, -0.0348411f, -0.00264656f, -0.999381f, -0.0351801f, 0.000183957f, 
		-0.999316f, -0.0368185f, 0.00348886f, -0.999294f, 0.0264915f, -0.0266399f, 
		-0.999288f, -0.0298190f, 0.0231324f, -0.999282f, -0.0320216f, 0.0202288f, 
		-0.999263f, -0.0288708f, 0.0253071f, -0.999243f, -0.0319978f, 0.0221417f, 
		-0.999228f, -0.0323605f, 0.0222862f, -0.999217f, -0.0335274f, 0.0209929f, 
		-0.999207f, -0.0335511f, 0.0214481f, -0.999207f, -0.0380792f, -0.0116734f, 
		-0.999198f, 0.0346816f, 0.0200025f, -0.999197f, -0.0306021f, 0.0258463f, 
		-0.999157f, -0.0251881f, 0.0324189f, -0.999056f, 0.0101824f, 0.0422395f, 
		-0.999042f, -0.0402377f, -0.0171914f, -0.999013f, -0.0354589f, 0.0267617f, 
		-0.998935f, -0.0302770f, 0.0348059f, -0.998893f, -0.0376576f, 0.0281859f, 
		-0.998885f, -0.0262552f, 0.0392389f, -0.998877f, -0.0441393f, -0.0172360f, 
		-0.998610f, 0.0148709f, -0.0505560f, -0.998465f, -0.0542508f, 0.0111187f, 
		-0.998324f, 0.0578519f, 0.00174244f, -0.998239f, 0.0585626f, -0.00949871f, 
		-0.998203f, 0.00761785f, -0.0594431f, -0.998003f, -0.0559282f, -0.0293730f, 
		-0.997922f, 0.0638902f, 0.00829561f, -0.997473f, 0.0510951f, 0.0493679f, 
		-0.997391f, 0.0429208f, 0.0580504f, -0.997200f, 0.00732894f, 0.0744257f, 
		-0.996950f, -0.0416129f, 0.0660235f, -0.996605f, -0.0635041f, 0.0523964f, 
		-0.995927f, 0.0390968f, 0.0812478f, -0.995592f, -0.00146448f, 0.0937800f, 
		-0.995552f, 0.0266180f, 0.0903777f, -0.995516f, 0.0890073f, 0.0320331f, 
		-0.995390f, 0.0936328f, 0.0207703f, -0.995360f, 0.00336220f, 0.0961646f, 
		-0.995178f, 0.0819856f, 0.0538360f, -0.995144f, -0.0357111f, 0.0917236f, 
		-0.994809f, 0.0476443f, -0.0899163f, -0.994740f, 0.0778715f, 0.0665433f, 
		-0.994611f, 0.0756973f, 0.0708461f, -0.994363f, 0.0904873f, -0.0552598f, 
		-0.993982f, -0.0882674f, 0.0648741f, -0.993511f, -0.103668f, 0.0467759f, 
		-0.993461f, 0.0142226f, -0.113286f, -0.992616f, 0.114615f, 0.0397111f, 
		-0.992420f, 0.0723199f, -0.0993574f, -0.992096f, 0.103275f, -0.0712743f, 
		-0.991995f, -0.0651436f, 0.108179f, -0.991844f, 0.125213f, 0.0238129f, 
		-0.991644f, 0.123898f, -0.0359307f, -0.991634f, 0.0791004f, -0.102006f, 
		-0.991098f, -0.0333867f, -0.128883f, -0.990797f, 0.131789f, 0.0308841f, 
		-0.990555f, -0.119786f, -0.0667275f, -0.990401f, -0.0697863f, 0.119310f, 
		-0.989337f, 0.139873f, -0.0406023f, -0.988198f, 0.0495233f, -0.144958f, 
		-0.987255f, -0.149522f, 0.0545136f, -0.987231f, -0.148590f, 0.0574042f, 
		-0.986505f, 0.146700f, -0.0727176f, -0.986345f, 0.137776f, -0.0902253f, 
		-0.986084f, -0.0992289f, 0.133386f, -0.985305f, 0.0900943f, 0.145108f, 
		-0.985029f, 0.0557771f, 0.163119f, -0.984731f, -0.0451288f, -0.168130f, 
		-0.984374f, -0.149788f, -0.0925781f, -0.984306f, 0.108762f, 0.138973f, 
		-0.984155f, 0.134611f, -0.115405f, -0.984054f, 0.0289549f, 0.175500f, 
		-0.983810f, 0.132632f, -0.120523f, -0.983479f, -0.136396f, 0.119016f, 
		-0.983142f, 0.104724f, -0.149880f, -0.983131f, 0.179917f, 0.0329201f, 
		-0.983092f, 0.131298f, 0.127635f, -0.983067f, -0.147734f, -0.108413f, 
		-0.982736f, 0.151417f, -0.106317f, -0.982284f, 0.0502255f, -0.180543f, 
		-0.982118f, -0.0450380f, -0.182800f, -0.981810f, 0.150300f, 0.116013f, 
		-0.981759f, 0.0884186f, -0.168320f, -0.981662f, 0.111750f, -0.154438f, 
		-0.981560f, 0.0667220f, -0.179131f, -0.981439f, -0.143509f, 0.127209f, 
		-0.981385f, 0.0867411f, 0.171348f, -0.981318f, 0.169045f, 0.0918603f, 
		-0.981264f, 0.149041f, 0.122094f, -0.981256f, 0.149058f, 0.122138f, 
		-0.981118f, 0.0608180f, 0.183601f, -0.980735f, 0.103121f, 0.165909f, 
		-0.980599f, 0.178000f, 0.0821108f, -0.979594f, 0.166332f, 0.112821f, 
		-0.979355f, 0.147717f, -0.138001f, -0.978751f, 0.203568f, -0.0246223f, 
		-0.978580f, -0.198660f, 0.0540026f, -0.978215f, -0.112233f, -0.174639f, 
		-0.977797f, -0.205722f, 0.0399027f, -0.977629f, -0.149957f, -0.147491f, 
		-0.977173f, 0.188873f, 0.0972607f, -0.977165f, 0.188909f, 0.0972683f, 
		-0.977155f, 0.201953f, 0.0662100f, -0.976629f, 0.157775f, -0.145952f, 
		-0.976361f, 0.165895f, -0.138560f, -0.976260f, 0.149801f, 0.156447f, 
		-0.975907f, 0.202377f, 0.0815413f, -0.975896f, 0.181636f, -0.120981f, 
		-0.975888f, -0.0495881f, -0.212565f, -0.975780f, 0.193140f, 0.102718f, 
		-0.975138f, 0.200816f, -0.0936979f, -0.975068f, 0.175479f, -0.135827f, 
		-0.975056f, 0.123882f, -0.184172f, -0.974845f, 0.137941f, 0.175071f, 
		-0.974818f, 0.214042f, -0.0625720f, -0.974705f, 0.221522f, -0.0296187f, 
		-0.974446f, 0.194654f, -0.112092f, -0.974176f, 0.0512865f, -0.219888f, 
		-0.974025f, 0.0610637f, -0.218050f, -0.973591f, 0.219747f, 0.0619013f, 
		-0.973531f, 0.228358f, -0.00950259f, -0.973363f, -0.224429f, 0.0468700f, 
		-0.973221f, 0.0116315f, 0.229575f, -0.973143f, 0.152799f, 0.172176f, 
		-0.972836f, 0.140358f, 0.184094f, -0.972688f, 0.132570f, 0.190536f, 
		-0.972208f, 0.233014f, -0.0226998f, -0.972067f, 0.0505411f, -0.229196f, 
		-0.972034f, 0.0783177f, 0.221395f, -0.971780f, 0.0130526f, -0.235526f, 
		-0.971486f, 0.229936f, 0.0578220f, -0.971453f, -0.229250f, -0.0610138f, 
		-0.971310f, 0.228852f, -0.0646811f, -0.971118f, 0.0861956f, -0.222485f, 
		-0.970783f, -0.157450f, -0.181079f, -0.970540f, 0.0734810f, 0.229462f, 
		-0.970484f, 0.229418f, 0.0743496f, -0.970131f, -0.227127f, -0.0851978f, 
		-0.969776f, -0.167717f, -0.177218f, -0.969751f, 0.147269f, -0.194666f, 
		-0.969334f, 0.234588f, -0.0732054f, -0.969252f, -0.138812f, -0.203179f, 
		-0.968901f, 0.212961f, 0.126010f, -0.968782f, 0.219236f, 0.115742f, 
		-0.968761f, 0.223881f, -0.106677f, -0.968688f, 0.234870f, 0.0805009f, 
		-0.968518f, -0.0103587f, 0.248729f, -0.968492f, 0.228764f, -0.0984398f, 
		-0.968420f, 0.112320f, -0.222592f, -0.968124f, -0.201470f, 0.148817f, 
		-0.968048f, -0.123812f, -0.218066f, -0.967959f, 0.231707f, 0.0967817f, 
		-0.967917f, 0.247442f, 0.0436948f, -0.967753f, 0.176421f, 0.179804f, 
		-0.967707f, -0.170670f, -0.185512f, -0.967690f, -0.169499f, -0.186669f, 
		-0.967655f, 0.249011f, 0.0404729f, -0.967571f, 0.0529969f, 0.246977f, 
		-0.967343f, 0.253419f, 0.00505273f, -0.966910f, 0.207689f, -0.148158f, 
		-0.966192f, -0.112955f, 0.231764f, -0.966142f, 0.0926824f, 0.240789f, 
		-0.965952f, -0.251839f, 0.0592744f, -0.965602f, -0.135280f, 0.222063f, 
		-0.965569f, 0.259270f, -0.0213535f, -0.965208f, 0.203500f, -0.164202f, 
		-0.965145f, -0.155322f, -0.210644f, -0.964803f, 0.0867419f, -0.248255f, 
		-0.964262f, -0.125483f, 0.233353f, -0.964074f, 0.254141f, 0.0772897f, 
		-0.963886f, 0.208298f, -0.165937f, -0.963586f, 0.154544f, -0.218215f, 
		-0.963370f, -0.248286f, 0.101355f, -0.962951f, 0.216619f, -0.160629f, 
		-0.962779f, 0.131296f, -0.236257f, -0.962175f, 0.0508837f, -0.267637f, 
		-0.962165f, 0.0445483f, 0.268800f, -0.962011f, 0.211861f, -0.172191f, 
		-0.962009f, 0.250770f, -0.107947f, -0.961879f, 0.272353f, 0.0247508f, 
		-0.961819f, 0.118844f, -0.246538f, -0.961723f, -0.114545f, -0.248933f, 
		-0.961376f, 0.208348f, 0.179851f, -0.961307f, -0.268942f, 0.0596527f, 
		-0.960959f, 0.226337f, 0.159149f, -0.960938f, 0.0852674f, 0.263303f, 
		-0.960726f, -0.107916f, 0.255655f, -0.960658f, -0.276812f, 0.0226242f, 
		-0.960581f, 0.277557f, -0.0157197f, -0.960379f, -0.267797f, 0.0771755f, 
		-0.960284f, 0.210577f, -0.183065f, -0.960036f, -0.167676f, -0.224088f, 
		-0.959899f, 0.0901627f, 0.265452f, -0.959838f, 0.278659f, -0.0325489f, 
		-0.959738f, -0.279886f, -0.0237960f, -0.959332f, -0.282102f, -0.0100347f, 
		-0.959169f, -0.126992f, 0.252720f, -0.958928f, -0.228895f, -0.167526f, 
		-0.958853f, -0.149855f, -0.241132f, -0.958689f, 0.00608723f, 0.284393f, 
		-0.958668f, 0.0952271f, 0.268119f, -0.958078f, 0.178679f, -0.223964f, 
		-0.957786f, 0.0114082f, -0.287255f, -0.957776f, 0.0731727f, -0.278049f, 
		-0.957374f, 0.213361f, -0.194710f, -0.957285f, 0.0742253f, 0.279456f, 
		-0.956981f, -0.139680f, 0.254315f, -0.956748f, 0.262628f, -0.125143f, 
		-0.956739f, -0.285754f, -0.0547229f, -0.956562f, 0.234084f, 0.173763f, 
		-0.956449f, 0.156282f, 0.246537f, -0.956315f, 0.233713f, -0.175610f, 
		-0.956259f, 0.290113f, 0.0374638f, -0.956166f, 0.0960111f, -0.276638f, 
		-0.956138f, 0.147646f, 0.252985f, -0.956097f, 0.191815f, 0.221553f, 
		-0.955823f, 0.179278f, 0.232941f, -0.955349f, 0.256727f, -0.146285f, 
		-0.955275f, 0.0379354f, 0.293276f, -0.955176f, 0.118179f, 0.271427f, 
		-0.954903f, 0.112787f, -0.274661f, -0.954489f, 0.119273f, -0.273358f, 
		-0.954340f, 0.189053f, 0.231287f, -0.954319f, 0.236880f, 0.182106f, 
		-0.954266f, 0.0231665f, 0.298061f, -0.953951f, -0.117222f, 0.276111f, 
		-0.953598f, -0.143701f, -0.264577f, -0.953502f, 0.203707f, 0.222121f, 
		-0.953355f, 0.296354f, 0.0573413f, -0.952770f, 0.206933f, 0.222280f, 
		-0.952768f, -0.248986f, -0.173892f, -0.952627f, 0.144826f, -0.267447f, 
		-0.952115f, 0.272641f, -0.138357f, -0.952054f, 0.285966f, 0.108706f, 
		-0.951710f, -0.00562269f, -0.306947f, -0.951702f, 0.0300258f, 0.305551f, 
		-0.951691f, 0.185684f, -0.244551f, -0.951403f, 0.305006f, 0.0424785f, 
		-0.951362f, 0.291896f, -0.0985260f, -0.951276f, 0.0884287f, 0.295389f, 
		-0.951242f, 0.287770f, 0.111028f, -0.951165f, 0.0650367f, -0.301753f, 
		-0.950446f, 0.137014f, -0.279068f, -0.950313f, 0.305281f, 0.0608975f, 
		-0.950311f, 0.305295f, 0.0608693f, -0.950091f, 0.279085f, 0.139423f, 
		-0.949956f, -0.206677f, 0.234238f, -0.948870f, -0.297815f, 0.104652f, 
		-0.948839f, 0.274462f, 0.156125f, -0.948735f, 0.206124f, 0.239614f, 
		-0.948506f, 0.175754f, -0.263530f, -0.948452f, 0.313581f, 0.0458849f, 
		-0.948401f, -0.283653f, 0.141692f, -0.948202f, 0.313158f, 0.0533439f, 
		-0.948125f, 0.317515f, -0.0155710f, -0.947410f, 0.195401f, -0.253440f, 
		-0.946940f, -0.116462f, 0.299568f, -0.946768f, 0.0888587f, -0.309409f, 
		-0.946654f, 0.299738f, 0.118334f, -0.946145f, 0.0820775f, 0.313165f, 
		-0.946143f, -0.161568f, -0.280551f, -0.946044f, -0.265410f, -0.185898f, 
		-0.945803f, 0.323586f, 0.0273801f, -0.945763f, -0.324283f, 0.0192875f, 
		-0.945705f, 0.284349f, 0.157440f, -0.945322f, 0.131864f, 0.298293f, 
		-0.944749f, 0.271737f, 0.183327f, -0.944717f, -0.136398f, -0.298171f, 
		-0.944631f, -0.317389f, -0.0832893f, -0.944206f, 0.328983f, -0.0156837f, 
		-0.943533f, 0.294781f, -0.151160f, -0.943495f, 0.331239f, 0.00986964f, 
		-0.943359f, -0.314036f, -0.107026f, -0.943300f, 0.152375f, 0.294903f, 
		-0.943256f, 0.331812f, -0.0130252f, -0.943080f, -0.205391f, -0.261563f, 
		-0.943010f, 0.0904153f, 0.320247f, -0.942808f, 0.274539f, 0.189056f, 
		-0.942787f, 0.241313f, 0.230043f, -0.942194f, 0.322737f, 0.0900613f, 
		-0.942132f, 0.165176f, -0.291727f, -0.942014f, 0.317130f, 0.109716f, 
		-0.941848f, 0.301014f, 0.149375f, -0.941832f, 0.333381f, -0.0425487f, 
		-0.941817f, 0.317564f, -0.110154f, -0.941594f, -0.332320f, -0.0544470f, 
		-0.941561f, 0.0850328f, -0.325934f, -0.941071f, -0.215507f, -0.260656f, 
		-0.941050f, 0.142054f, -0.306994f, -0.940893f, -0.0541102f, -0.334355f, 
		-0.940885f, 0.334347f, -0.0542969f, -0.940660f, -0.214713f, -0.262788f, 
		-0.940469f, 0.301754f, 0.156404f, -0.940389f, 0.327936f, 0.0901494f, 
		-0.940385f, 0.209309f, -0.268077f, -0.940157f, 0.119938f, 0.318934f, 
		-0.939682f, 0.341906f, -0.00990401f, -0.939637f, 0.247015f, -0.236782f, 
		-0.939544f, 0.316500f, -0.130711f, -0.939443f, -0.267082f, 0.214741f, 
		-0.939278f, 0.315024f, 0.136076f, -0.939150f, -0.249826f, 0.235765f, 
		-0.939031f, -0.277572f, 0.202914f, -0.938891f, 0.203601f, -0.277543f, 
		-0.938733f, 0.169610f, 0.300020f, -0.938464f, 0.270789f, 0.214380f, 
		-0.938415f, 0.191303f, -0.287717f, -0.938333f, -0.179926f, -0.295226f, 
		-0.938013f, 0.299621f, -0.174236f, -0.937814f, 0.277286f, -0.208846f, 
		-0.937762f, -0.328914f, 0.111437f, -0.937694f, 0.337898f, 0.0809657f, 
		-0.937543f, 0.190204f, 0.291267f, -0.937513f, -0.342933f, -0.0588670f, 
		-0.935987f, -0.343572f, -0.0767274f, -0.935489f, 0.344545f, -0.0784169f, 
		-0.935414f, -0.149555f, 0.320364f, -0.934714f, 0.156201f, 0.319235f, 
		-0.934656f, -0.354648f, -0.0253401f, -0.934635f, -0.272420f, 0.228570f, 
		-0.934602f, 0.291909f, -0.203244f, -0.934242f, -0.170638f, -0.313168f, 
		-0.933849f, -0.237611f, -0.267334f, -0.933697f, 0.308999f, -0.180912f, 
		-0.933621f, -0.357513f, 0.0231734f, -0.933599f, 0.333328f, -0.131471f, 
		-0.933579f, -0.355394f, -0.0461039f, -0.933510f, -0.339717f, -0.114676f, 
		-0.933108f, 0.336470f, 0.126876f, -0.932849f, -0.160201f, -0.322689f, 
		-0.932770f, -0.305392f, -0.191512f, -0.932392f, -0.354846f, -0.0687680f, 
		-0.932089f, -0.312535f, -0.183117f, -0.931807f, -0.320444f, 0.170447f, 
		-0.931676f, 0.298021f, 0.207757f, -0.931312f, -0.353868f, 0.0862272f, 
		-0.931269f, -0.312195f, -0.187810f, -0.931168f, -0.262122f, -0.253412f, 
		-0.930751f, 0.356447f, -0.0815342f, -0.930649f, -0.360690f, -0.0616095f, 
		-0.930280f, 0.233616f, -0.282848f, -0.930218f, -0.365873f, 0.0288551f, 
		-0.930185f, 0.349915f, -0.110972f, -0.930092f, 0.325531f, 0.170169f, 
		-0.930032f, -0.261366f, 0.258317f, -0.930001f, -0.367539f, 0.00373299f, 
		-0.929878f, 0.307166f, 0.202424f, -0.929864f, 0.357412f, -0.0872347f, 
		-0.928861f, -0.320348f, -0.185998f, -0.928710f, 0.327549f, 0.173811f, 
		-0.928685f, 0.370407f, 0.0185030f, -0.928682f, -0.301379f, 0.216150f, 
		-0.928462f, 0.371383f, -0.00579835f, -0.928442f, 0.339907f, 0.149864f, 
		-0.928159f, 0.290240f, -0.232986f, -0.928087f, -0.0364147f, 0.370578f, 
		-0.927860f, 0.354535f, -0.115673f, -0.927854f, 0.323931f, -0.184811f, 
		-0.927387f, 0.318913f, 0.195570f, -0.927146f, 0.200190f, 0.316738f, 
		-0.926980f, 0.312610f, 0.207322f, -0.926910f, -0.357052f, 0.115549f, 
		-0.926568f, -0.0946380f, 0.364026f, -0.926357f, 0.255386f, -0.276841f, 
		-0.926270f, 0.251755f, 0.280435f, -0.925735f, -0.173994f, 0.335770f, 
		-0.925624f, 0.327428f, 0.189765f, -0.925616f, -0.0999950f, 0.365016f, 
		-0.925235f, 0.379122f, -0.0143697f, -0.925109f, -0.0401049f, -0.377577f, 
		-0.924972f, 0.348294f, 0.152047f, -0.924911f, 0.179323f, -0.335235f, 
		-0.924873f, -0.346442f, 0.156807f, -0.924602f, 0.155000f, -0.347973f, 
		-0.924577f, 0.321046f, -0.205149f, -0.924437f, 0.101642f, 0.367539f, 
		-0.924424f, 0.306434f, -0.227023f, -0.924276f, -0.372329f, 0.0841743f, 
		-0.924233f, 0.349464f, -0.153844f, -0.924059f, 0.0659861f, 0.376510f, 
		-0.923833f, 0.297214f, 0.241241f, -0.923694f, 0.123324f, -0.362741f, 
		-0.923266f, 0.221450f, -0.313910f, -0.923156f, 0.237255f, 0.302479f, 
		-0.923079f, 0.219269f, 0.315984f, -0.923064f, 0.147552f, -0.355221f, 
		-0.923024f, -0.333815f, -0.191295f, -0.922833f, -0.384048f, 0.0297753f, 
		-0.922549f, 0.163683f, -0.349444f, -0.922385f, 0.380718f, -0.0652734f, 
		-0.922185f, 0.157100f, -0.353404f, -0.921621f, 0.388022f, 0.00737699f, 
		-0.921483f, -0.230445f, -0.312673f, -0.920902f, 0.353469f, -0.164312f, 
		-0.920683f, -0.380231f, -0.0881306f, -0.920431f, 0.351737f, -0.170554f, 
		-0.920419f, 0.351753f, -0.170586f, -0.920298f, 0.0859030f, -0.381670f, 
		-0.920161f, 0.358400f, -0.157653f, -0.919847f, 0.385849f, 0.0707279f, 
		-0.919824f, 0.392196f, 0.0103212f, -0.919815f, 0.0726768f, -0.385562f, 
		-0.919345f, 0.392426f, -0.0283957f, -0.919273f, -0.391565f, 0.0401770f, 
		-0.918906f, 0.382525f, 0.0963624f, -0.918356f, 0.350019f, 0.184684f, 
		-0.918232f, -0.381287f, -0.107099f, -0.918228f, -0.230549f, 0.322032f, 
		-0.918096f, -0.396150f, 0.0128213f, -0.918063f, 0.381080f, -0.109259f, 
		-0.918036f, 0.162302f, -0.361757f, -0.917561f, 0.0562811f, -0.393591f, 
		-0.917510f, -0.285695f, -0.276683f, -0.917341f, -0.377645f, 0.125976f, 
		-0.917129f, 0.298904f, -0.263686f, -0.917095f, -0.116385f, -0.381302f, 
		-0.917089f, 0.383046f, -0.110556f, -0.916919f, -0.301949f, 0.260933f, 
		-0.916829f, 0.366709f, 0.157952f, -0.916815f, 0.180314f, 0.356283f, 
		-0.916814f, 0.341065f, -0.207670f, -0.916783f, -0.254636f, 0.307683f, 
		-0.916682f, 0.356526f, -0.180510f, -0.916642f, 0.274438f, -0.290605f, 
		-0.916528f, -0.155907f, 0.368334f, -0.916518f, -0.0560579f, -0.396045f, 
		-0.916382f, 0.0694495f, -0.394235f, -0.916050f, -0.313399f, 0.250265f, 
		-0.915985f, 0.0325532f, -0.399889f, -0.915857f, 0.0317818f, -0.400244f, 
		-0.915397f, 0.294777f, -0.274145f, -0.915245f, 0.346185f, 0.206114f, 
		-0.915099f, 0.376447f, -0.144506f, -0.914906f, -0.296865f, 0.273529f, 
		-0.914724f, 0.189101f, -0.357101f, -0.914654f, 0.398809f, 0.0660251f, 
		-0.914326f, 0.0384341f, 0.403151f, -0.913669f, -0.388047f, -0.120951f, 
		-0.913551f, 0.355231f, -0.198082f, -0.913117f, 0.0622138f, 0.402924f, 
		-0.912901f, 0.334339f, -0.234155f, -0.912631f, -0.00767769f, -0.408712f, 
		-0.912290f, 0.00738561f, 0.409477f, -0.911993f, 0.283253f, -0.296709f, 
		-0.911951f, 0.393700f, 0.115523f, -0.911810f, -0.340418f, -0.229604f, 
		-0.911610f, 0.394935f, -0.113989f, -0.911458f, 0.350835f, -0.214847f, 
		-0.911100f, -0.293775f, -0.289126f, -0.911081f, 0.323979f, -0.254889f, 
		-0.910960f, 0.113114f, 0.396682f, -0.910778f, -0.412096f, 0.0257085f, 
		-0.910604f, 0.0300882f, 0.412182f, -0.910300f, -0.389642f, 0.139758f, 
		-0.909947f, -0.0958097f, -0.403505f, -0.909936f, 0.0314553f, 0.413553f, 
		-0.909906f, 0.0425516f, -0.412626f, -0.909583f, 0.289777f, -0.297807f, 
		-0.909438f, 0.359553f, 0.208913f, -0.909229f, 0.355082f, 0.217299f, 
		-0.909220f, 0.117879f, 0.399280f, -0.909074f, 0.386195f, 0.156327f, 
		-0.909056f, 0.416517f, -0.0114079f, -0.909038f, 0.351309f, 0.224124f, 
		-0.909032f, 0.393700f, -0.136604f, -0.908611f, 0.292684f, -0.297931f, 
		-0.908592f, -0.354671f, 0.220611f, -0.908514f, -0.306339f, 0.284179f, 
		-0.908355f, 0.113468f, -0.402512f, -0.908277f, 0.409717f, -0.0846440f, 
		-0.908268f, 0.412821f, 0.0680329f, -0.907884f, 0.0424630f, -0.417065f, 
		-0.907682f, 0.0346225f, -0.418228f, -0.907431f, 0.297103f, -0.297153f, 
		-0.907280f, 0.391915f, 0.152468f, -0.907248f, 0.321268f, -0.271454f, 
		-0.907200f, -0.417641f, -0.0506436f, -0.907144f, -0.0184816f, 0.420415f, 
		-0.907026f, 0.298511f, -0.296976f, -0.906983f, 0.207583f, 0.366457f, 
		-0.906894f, 0.247975f, -0.340663f, -0.906551f, 0.387232f, 0.167977f, 
		-0.906514f, -0.0215762f, 0.421624f, -0.906439f, -0.412836f, -0.0890761f, 
		-0.906248f, 0.413472f, -0.0880676f, -0.906085f, -0.422991f, -0.00943524f, 
		-0.906028f, -0.382208f, 0.181741f, -0.905621f, 0.391749f, -0.162430f, 
		-0.905293f, 0.358601f, -0.227704f, -0.904938f, -0.252611f, -0.342455f, 
		-0.904884f, -0.101563f, -0.413364f, -0.904881f, 0.201665f, 0.374862f, 
		-0.904772f, -0.0981896f, 0.414423f, -0.904578f, -0.408258f, 0.122736f, 
		-0.904547f, 0.349785f, 0.243814f, -0.904351f, 0.303189f, -0.300377f, 
		-0.904349f, -0.303318f, 0.300250f, -0.904134f, 0.144599f, -0.402036f, 
		-0.903571f, -0.285745f, -0.319232f, -0.903140f, -0.0452000f, 0.426960f, 
		-0.903013f, -0.413140f, -0.117826f, -0.902880f, 0.422897f, -0.0772392f, 
		-0.902817f, 0.276624f, -0.329243f, -0.902760f, 0.354537f, -0.243572f, 
		-0.902492f, 0.329722f, 0.277113f, -0.902322f, -0.423945f, -0.0780110f, 
		-0.901986f, 0.377093f, 0.210289f, -0.901878f, -0.0801323f, 0.424493f, 
		-0.901861f, 0.373876f, 0.216480f, -0.901627f, -0.0341561f, 0.431164f, 
		-0.901460f, -0.0604791f, -0.428616f, -0.901352f, -0.368198f, -0.228024f, 
		-0.901280f, 0.140523f, 0.409813f, -0.900982f, 0.396993f, 0.175009f, 
		-0.900925f, -0.433065f, -0.0280931f, -0.900772f, 0.426763f, -0.0805173f, 
		-0.900743f, 0.330343f, 0.282020f, -0.900589f, 0.274813f, -0.336775f, 
		-0.900484f, -0.381065f, -0.209565f, -0.900401f, -0.0520847f, 0.431933f, 
		-0.900336f, 0.398641f, 0.174586f, -0.900131f, 0.201183f, -0.386380f, 
		-0.899993f, -0.00928993f, 0.435805f, -0.899815f, -0.381430f, 0.211766f, 
		-0.899646f, -0.433767f, 0.0498294f, -0.899635f, 0.375933f, 0.222106f, 
		-0.899540f, 0.426873f, -0.0927777f, -0.899331f, 0.364670f, -0.241288f, 
		-0.898739f, 0.391558f, -0.197356f, -0.898620f, 0.362712f, -0.246825f, 
		-0.898564f, -0.301534f, -0.318843f, -0.897998f, 0.259512f, -0.355322f, 
		-0.897769f, -0.403067f, 0.177618f, -0.897708f, 0.375143f, -0.231058f, 
		-0.897206f, 0.434305f, 0.0800069f, -0.896961f, 0.418706f, 0.141936f, 
		-0.896832f, -0.428298f, -0.110693f, -0.896733f, 0.154334f, 0.414791f, 
		-0.896722f, 0.316110f, -0.309780f, -0.896686f, -0.340447f, -0.282931f, 
		-0.896653f, 0.0517764f, 0.439695f, -0.896544f, 0.0275563f, 0.442096f, 
		-0.896539f, 0.253863f, -0.363003f, -0.895714f, 0.0949971f, 0.434364f, 
		-0.895358f, -0.385168f, -0.223562f, -0.895353f, 0.311797f, -0.318003f, 
		-0.895271f, 0.0795697f, -0.438360f, -0.894959f, -0.389217f, -0.218077f, 
		-0.894932f, -0.406283f, -0.184476f, -0.894732f, 0.334931f, -0.295425f, 
		-0.894570f, -0.250859f, 0.369884f, -0.893913f, 0.444896f, 0.0546484f, 
		-0.893885f, -0.221516f, -0.389744f, -0.893544f, 0.448964f, 0.00336776f, 
		-0.893058f, 0.145692f, -0.425701f, -0.893027f, -0.317614f, -0.318784f, 
		-0.892669f, 0.216807f, 0.395141f, -0.892304f, 0.361764f, -0.270039f, 
		-0.892096f, 0.396288f, -0.217070f, -0.892064f, 0.122663f, 0.434942f, 
		-0.891861f, 0.379970f, -0.245372f, -0.891669f, 0.429143f, -0.144093f, 
		-0.891667f, -0.0661525f, 0.447832f, -0.891661f, -0.0661059f, 0.447851f, 
		-0.891559f, 0.174021f, 0.418138f, -0.891216f, -0.422183f, -0.165818f, 
		-0.891204f, -0.165100f, -0.422490f, -0.890513f, 0.0345067f, 0.453647f, 
		-0.890427f, -0.156815f, -0.427257f, -0.890300f, -0.318773f, 0.325191f, 
		-0.890284f, -0.279532f, -0.359522f, -0.889963f, 0.315337f, -0.329437f, 
		-0.889738f, -0.418790f, -0.181609f, -0.889726f, 0.237406f, -0.389904f, 
		-0.889262f, -0.0850800f, 0.449416f, -0.889221f, 0.447182f, 0.0965103f, 
		-0.889088f, 0.414863f, 0.193419f, -0.888931f, 0.259992f, 0.377103f, 
		-0.888914f, 0.406479f, 0.211201f, -0.888778f, 0.0276434f, 0.457503f, 
		-0.888530f, 0.417558f, -0.190157f, -0.888404f, 0.389713f, -0.242617f, 
		-0.888339f, -0.459168f, 0.00417631f, -0.888329f, -0.459189f, 0.00413757f, 
		-0.887951f, 0.268048f, 0.373755f, -0.887633f, -0.456693f, 0.0594900f, 
		-0.887610f, -0.452013f, 0.0884980f, -0.887595f, -0.0438826f, -0.458530f, 
		-0.887547f, 0.335148f, -0.316125f, -0.887451f, -0.00731216f, 0.460843f, 
		-0.887302f, 0.337471f, 0.314338f, -0.887038f, -0.461669f, -0.00507304f, 
		-0.886923f, 0.280746f, 0.366810f, -0.886865f, 0.409587f, -0.213796f, 
		-0.886730f, -0.444773f, -0.126042f, -0.886479f, -0.195953f, -0.419234f, 
		-0.886363f, 0.313796f, -0.340431f, -0.886250f, -0.388793f, -0.251796f, 
		-0.886151f, 0.453167f, -0.0968332f, -0.885755f, -0.462612f, 0.0377993f, 
		-0.885754f, -0.456528f, 0.0838016f, -0.885746f, -0.304982f, -0.349916f, 
		-0.885465f, 0.464476f, -0.0146393f, -0.885268f, 0.284208f, 0.368140f, 
		-0.885147f, 0.464972f, -0.0177517f, -0.885027f, 0.457990f, 0.0835059f, 
		-0.885021f, -0.410550f, -0.219513f, -0.884962f, 0.0119775f, 0.465509f, 
		-0.884917f, 0.344460f, 0.313478f, -0.884841f, -0.303971f, 0.353070f, 
		-0.884836f, -0.0420197f, -0.464004f, -0.884799f, 0.154283f, 0.439689f, 
		-0.884653f, 0.428109f, -0.184692f, -0.884652f, -0.438632f, -0.158095f, 
		-0.884628f, -0.386513f, -0.260845f, -0.884627f, 0.419114f, -0.204398f, 
		-0.884545f, 0.466043f, 0.0196243f, -0.884169f, -0.452790f, 0.115011f, 
		-0.884118f, 0.430580f, -0.181486f, -0.883984f, 0.458506f, 0.0913539f, 
		-0.883899f, 0.395420f, -0.249733f, -0.883764f, 0.321180f, 0.340300f, 
		-0.883554f, -0.228880f, 0.408591f, -0.883524f, 0.300674f, -0.359138f, 
		-0.883521f, -0.461163f, 0.0819693f, -0.883446f, 0.171204f, 0.436133f, 
		-0.883230f, -0.233390f, 0.406735f, -0.883144f, -0.275705f, 0.379532f, 
		-0.883023f, -0.312677f, -0.350006f, -0.882953f, 0.207589f, 0.421071f, 
		-0.882286f, -0.400209f, -0.247797f, -0.882282f, 0.381229f, 0.276119f, 
		-0.881976f, 0.172125f, 0.438739f, -0.881745f, 0.465175f, -0.0783444f, 
		-0.881328f, -0.471626f, -0.0288107f, -0.881221f, 0.360189f, 0.306127f, 
		-0.881070f, -0.238589f, 0.408401f, -0.880972f, 0.472985f, -0.0131299f, 
		-0.880725f, 0.424811f, -0.209427f, -0.880523f, -0.246881f, 0.404635f, 
		-0.880404f, 0.340769f, -0.329795f, -0.880173f, 0.355541f, 0.314461f, 
		-0.880162f, 0.175208f, -0.441154f, -0.879916f, 0.440106f, -0.179035f, 
		-0.879633f, 0.115345f, -0.461455f, -0.879568f, 0.440806f, 0.179024f, 
		-0.879365f, -0.469282f, 0.0805751f, -0.879298f, 0.366508f, -0.304150f, 
		-0.879085f, 0.283999f, -0.382824f, -0.878905f, 0.468127f, -0.0915628f, 
		-0.878630f, 0.272590f, 0.392052f, -0.878200f, 0.296122f, -0.375601f, 
		-0.877895f, -0.0748128f, 0.472973f, -0.877414f, -0.479239f, 0.0217946f, 
		-0.877313f, 0.467324f, 0.109224f, -0.877286f, -0.312563f, 0.364243f, 
		-0.876852f, 0.203457f, -0.435587f, -0.876504f, 0.428809f, -0.218775f, 
		-0.876479f, 0.285000f, -0.388021f, -0.875996f, 0.426384f, 0.225449f, 
		-0.875652f, -0.277480f, 0.395269f, -0.875436f, -0.416067f, -0.245970f, 
		-0.875400f, 0.483389f, -0.00315054f, -0.875315f, -0.469820f, 0.114424f, 
		-0.875249f, -0.461044f, 0.146209f, -0.875209f, 0.295110f, -0.383299f, 
		-0.875014f, 0.481307f, -0.0518992f, -0.874822f, -0.462980f, 0.142608f, 
		-0.874629f, -0.262548f, -0.407544f, -0.874483f, 0.286288f, -0.391559f, 
		-0.874423f, 0.322437f, 0.362518f, -0.874145f, 0.0191266f, -0.485288f, 
		-0.874125f, 0.369684f, -0.315023f, -0.873886f, -0.426880f, 0.232586f, 
		-0.873847f, 0.308388f, 0.375882f, -0.873786f, -0.0298550f, 0.485393f, 
		-0.873699f, 0.481654f, -0.0682625f, -0.872813f, -0.470772f, -0.128729f, 
		-0.872696f, 0.481912f, 0.0784964f, -0.872675f, 0.434644f, 0.222539f, 
		-0.872313f, 0.483749f, -0.0711144f, -0.872218f, -0.446292f, 0.200150f, 
		-0.872179f, 0.217074f, -0.438386f, -0.872090f, -0.407588f, 0.270798f, 
		-0.872050f, -0.133273f, 0.470922f, -0.871964f, -0.0819889f, 0.482656f, 
		-0.871739f, 0.331252f, 0.361030f, -0.871549f, -0.451787f, 0.190500f, 
		-0.871547f, -0.451773f, 0.190544f, -0.871508f, 0.177487f, 0.457135f, 
		-0.870981f, 0.150621f, 0.467659f, -0.870730f, -0.432532f, 0.233976f, 
		-0.870579f, 0.190465f, -0.453669f, -0.870374f, 0.491774f, -0.0246490f, 
		-0.870194f, 0.353436f, 0.343287f, -0.869798f, 0.385257f, -0.308266f, 
		-0.869284f, 0.209844f, 0.447561f, -0.868953f, 0.361164f, -0.338351f, 
		-0.868770f, 0.484922f, 0.100444f, -0.868725f, -0.407056f, 0.282173f, 
		-0.868472f, 0.457750f, 0.190318f, -0.868398f, -0.370751f, -0.329284f, 
		-0.868307f, -0.0642580f, 0.491847f, -0.868301f, 0.124421f, 0.480180f, 
		-0.867888f, 0.440050f, -0.230492f, -0.867106f, -0.208110f, 0.452568f, 
		-0.866977f, 0.187470f, 0.461743f, -0.866947f, -0.416889f, 0.273143f, 
		-0.866886f, 0.461450f, 0.188606f, -0.866709f, 0.496273f, 0.0502806f, 
		-0.866386f, -0.352090f, 0.354129f, -0.866376f, -0.435530f, 0.244347f, 
		-0.866037f, 0.250280f, -0.432827f, -0.865868f, -0.308858f, 0.393548f, 
		-0.865851f, 0.498628f, 0.0408883f, -0.865422f, 0.412187f, -0.284862f, 
		-0.865062f, 0.428878f, 0.260252f, -0.865010f, -0.463674f, 0.191740f, 
		-0.864966f, 0.341803f, -0.367429f, -0.864949f, 0.340177f, 0.368976f, 
		-0.864871f, -0.472968f, 0.168227f, -0.864572f, 0.144348f, -0.481331f, 
		-0.864416f, 0.472798f, 0.171017f, -0.864056f, -0.502970f, -0.0207211f, 
		-0.863886f, -0.117653f, 0.489753f, -0.862968f, 0.309469f, -0.399395f, 
		-0.862806f, -0.460423f, -0.208751f, -0.862791f, 0.320382f, -0.391086f, 
		-0.862779f, 0.320316f, -0.391165f, -0.862367f, 0.277232f, -0.423633f, 
		-0.861721f, 0.507376f, 0.00268980f, -0.861558f, -0.403020f, 0.308696f, 
		-0.861508f, 0.258760f, -0.436861f, -0.861371f, 0.334996f, -0.381860f, 
		-0.861368f, 0.504763f, -0.0570949f, -0.861331f, 0.258448f, -0.437394f, 
		-0.861255f, 0.495665f, 0.112055f, -0.860922f, 0.508725f, -0.00359301f, 
		-0.860690f, 0.170449f, 0.479750f, -0.860614f, -0.507257f, -0.0450905f, 
		-0.860561f, 0.500659f, 0.0936808f, -0.860483f, 0.360949f, -0.359561f, 
		-0.860318f, 0.509692f, 0.00813901f, -0.860184f, -0.161818f, -0.483631f, 
		-0.860149f, 0.385026f, -0.334511f, -0.860111f, 0.509851f, -0.0161940f, 
		-0.859508f, 0.243816f, 0.449221f, -0.859088f, -0.508146f, -0.0612797f, 
		-0.858739f, 0.213841f, -0.465660f, -0.858189f, 0.492638f, -0.144286f, 
		-0.858060f, -0.486667f, 0.163979f, -0.858021f, -0.0553524f, -0.510624f, 
		-0.857853f, -0.115366f, 0.500779f, -0.857851f, 0.322846f, 0.399827f, 
		-0.857587f, 0.271745f, -0.436690f, -0.857488f, -0.0188326f, 0.514159f, 
		-0.857219f, -0.424474f, 0.291544f, -0.856614f, 0.430775f, 0.283981f, 
		-0.856148f, 0.309608f, 0.413707f, -0.856093f, -0.464568f, 0.226456f, 
		-0.856060f, 0.375525f, -0.355166f, -0.856051f, 0.375568f, -0.355140f, 
		-0.856050f, 0.375562f, -0.355151f, -0.855908f, 0.180988f, -0.484422f, 
		-0.855872f, 0.418583f, -0.303763f, -0.855822f, 0.183712f, 0.483547f, 
		-0.855671f, 0.157651f, 0.492923f, -0.855604f, -0.510103f, 0.0879531f, 
		-0.855337f, 0.277294f, 0.437615f, -0.855274f, 0.0780044f, -0.512271f, 
		-0.855027f, 0.407548f, 0.320677f, -0.854971f, 0.0756991f, -0.513122f, 
		-0.854856f, 0.408176f, -0.320335f, -0.854776f, 0.0326663f, -0.517969f, 
		-0.853667f, 0.0883661f, -0.513268f, -0.853666f, 0.487134f, -0.184269f, 
		-0.853363f, 0.439336f, 0.280634f, -0.853063f, -0.310340f, 0.419490f, 
		-0.852451f, 0.493504f, -0.172572f, -0.852260f, 0.248606f, -0.460269f, 
		-0.852192f, 0.521654f, -0.0405772f, -0.851814f, -0.222751f, -0.474125f, 
		-0.851796f, 0.521688f, -0.0478007f, -0.851715f, -0.324650f, -0.411320f, 
		-0.851694f, 0.380855f, 0.359953f, -0.851605f, -0.291835f, 0.435432f, 
		-0.851427f, -0.517846f, 0.0831162f, -0.851376f, 0.328413f, 0.409028f, 
		-0.851035f, 0.425978f, -0.307054f, -0.850985f, -0.204145f, 0.483890f, 
		-0.850724f, 0.461712f, 0.251181f, -0.850424f, 0.520791f, -0.0745374f, 
		-0.850019f, -0.418542f, 0.319828f, -0.849555f, -0.427159f, -0.309501f, 
		-0.849398f, 0.484522f, -0.209191f, -0.849395f, 0.484511f, -0.209231f, 
		-0.849101f, -0.521327f, 0.0851174f, -0.848961f, -0.179012f, -0.497212f, 
		-0.848920f, 0.371827f, -0.375605f, -0.848828f, 0.527169f, 0.0397993f, 
		-0.848702f, -0.494767f, 0.186846f, -0.847565f, -0.436808f, 0.301384f, 
		-0.847293f, 0.498399f, 0.183557f, -0.847003f, 0.464144f, 0.259145f, 
		-0.846615f, 0.530096f, 0.0473431f, -0.846578f, -0.385606f, -0.366898f, 
		-0.845954f, 0.280165f, 0.453728f, -0.845897f, 0.436173f, 0.306938f, 
		-0.845848f, 0.183211f, 0.500974f, -0.845634f, -0.254887f, -0.468972f, 
		-0.845630f, 0.433160f, 0.311901f, -0.845233f, 0.186701f, 0.500723f, 
		-0.844256f, 0.301446f, 0.443127f, -0.844084f, -0.530866f, 0.0755290f, 
		-0.843857f, 0.313924f, 0.435152f, -0.843583f, 0.204850f, -0.496391f, 
		-0.843508f, -0.365577f, -0.393506f, -0.843388f, 0.534614f, -0.0536990f, 
		-0.843248f, -0.367328f, -0.392431f, -0.843039f, 0.298307f, 0.447547f, 
		-0.842956f, 0.493556f, -0.214073f, -0.842943f, 0.286883f, -0.455132f, 
		-0.842790f, -0.0698827f, 0.533687f, -0.842736f, -0.533509f, -0.0718616f, 
		-0.842677f, 0.0223853f, -0.537953f, -0.842606f, -0.399699f, -0.360909f, 
		-0.842554f, 0.414658f, 0.343747f, -0.842356f, 0.527497f, 0.110379f, 
		-0.842346f, -0.393196f, 0.368577f, -0.841923f, 0.203609f, 0.499709f, 
		-0.841361f, 0.513301f, -0.169214f, -0.841233f, -0.494257f, -0.219173f, 
		-0.840810f, 0.481331f, 0.247709f, -0.840805f, -0.398383f, -0.366520f, 
		-0.840739f, -0.466275f, 0.275218f, -0.840330f, -0.387938f, -0.378615f, 
		-0.839643f, -0.462490f, 0.284784f, -0.839454f, 0.159295f, -0.519560f, 
		-0.839310f, -0.203135f, 0.504277f, -0.839283f, -0.462457f, 0.285897f, 
		-0.839198f, 0.542092f, -0.0433932f, -0.839194f, 0.539950f, -0.0648714f, 
		-0.839008f, 0.517446f, -0.168272f, -0.838991f, 0.507829f, -0.195456f, 
		-0.838327f, 0.214084f, 0.501374f, -0.838076f, -0.537302f, 0.0945308f, 
		-0.838047f, 0.545598f, 0.000195804f, -0.837891f, 0.343233f, 0.424417f, 
		-0.837370f, 0.162992f, -0.521772f, -0.836918f, 0.517354f, -0.178641f, 
		-0.836860f, 0.474855f, 0.272357f, -0.836686f, 0.492294f, -0.240006f, 
		-0.836534f, 0.538367f, -0.101839f, -0.836466f, 0.0564524f, -0.545103f, 
		-0.836005f, -0.329407f, -0.438846f, -0.835917f, -0.544709f, 0.0673484f, 
		-0.835766f, 0.294418f, -0.463480f, -0.835732f, 0.109432f, -0.538124f, 
		-0.835729f, 0.549065f, 0.00915743f, -0.835402f, 0.526052f, 0.159287f, 
		-0.835387f, -0.536280f, 0.120551f, -0.835222f, 0.515440f, -0.191641f, 
		-0.834585f, -0.248448f, -0.491672f, -0.834473f, 0.513906f, 0.198883f, 
		-0.834099f, -0.419039f, -0.358728f, -0.833957f, 0.523544f, 0.174405f, 
		-0.833781f, 0.444082f, 0.328026f, -0.833758f, 0.485361f, -0.263198f, 
		-0.833754f, 0.485356f, -0.263218f, -0.833630f, 0.327276f, 0.444917f, 
		-0.833590f, 0.456498f, -0.311024f, -0.833445f, 0.481371f, -0.271388f, 
		-0.833095f, -0.544023f, 0.0999601f, -0.833056f, 0.443510f, -0.330632f, 
		-0.832392f, 0.535137f, 0.144057f, -0.832377f, 0.409315f, 0.373644f, 
		-0.832268f, -0.495046f, 0.249519f, -0.832004f, 0.493852f, -0.252745f, 
		-0.831750f, 0.207599f, -0.514873f, -0.831071f, -0.347972f, 0.433862f, 
		-0.830896f, -0.296375f, -0.470929f, -0.830594f, -0.500170f, 0.244834f, 
		-0.830572f, 0.204075f, -0.518174f, -0.830513f, -0.493404f, -0.258459f, 
		-0.830412f, -0.425279f, 0.359936f, -0.830259f, 0.125127f, -0.543151f, 
		-0.829692f, 0.321484f, -0.456354f, -0.829646f, -0.557976f, 0.0187457f, 
		-0.829632f, -0.277421f, -0.484508f, -0.829578f, 0.557131f, 0.0374930f, 
		-0.829477f, 0.0128128f, 0.558393f, -0.829340f, -0.558733f, 0.00347664f, 
		-0.829219f, 0.400671f, 0.389691f, -0.829117f, 0.552510f, 0.0854292f, 
		-0.829112f, 0.365058f, -0.423445f, -0.828986f, 0.520193f, -0.205382f, 
		-0.828155f, -0.101096f, -0.551306f, -0.827949f, -0.498606f, 0.256695f, 
		-0.827943f, 0.488025f, 0.276301f, -0.827803f, 0.531278f, 0.180239f, 
		-0.827377f, -0.491958f, -0.270968f, -0.827303f, -0.396626f, 0.397816f, 
		-0.827196f, 0.0204566f, -0.561541f, -0.826629f, 0.260116f, 0.499023f, 
		-0.825985f, -0.291000f, -0.482771f, -0.825578f, -0.563478f, 0.0302142f, 
		-0.825567f, -0.563498f, 0.0301472f, -0.825532f, 0.560984f, -0.0615996f, 
		-0.825359f, -0.370035f, -0.426447f, -0.824923f, -0.197822f, -0.529498f, 
		-0.824623f, 0.261026f, 0.501859f, -0.824481f, -0.560417f, -0.0785118f, 
		-0.823673f, 0.401797f, -0.400153f, -0.823631f, 0.127328f, 0.552648f, 
		-0.823073f, 0.557107f, -0.110374f, -0.823037f, 0.554878f, -0.121326f, 
		-0.822596f, 0.507426f, -0.256622f, -0.822586f, -0.0808808f, -0.562859f, 
		-0.822430f, 0.519841f, -0.231029f, -0.822285f, -0.538170f, -0.184989f, 
		-0.821962f, -0.448438f, -0.351116f, -0.821824f, 0.549165f, 0.151732f, 
		-0.821793f, 0.553517f, -0.135186f, -0.821737f, 0.539106f, -0.184701f, 
		-0.821667f, -0.496577f, -0.279778f, -0.821580f, -0.461722f, 0.334394f, 
		-0.821562f, 0.570033f, -0.00991695f, -0.821552f, 0.446042f, -0.355104f, 
		-0.821537f, 0.348619f, 0.451156f, -0.821510f, 0.446051f, -0.355190f, 
		-0.821383f, 0.448217f, -0.352748f, -0.821314f, -0.270374f, 0.502336f, 
		-0.820781f, -0.179029f, 0.542463f, -0.820651f, 0.536411f, 0.196963f, 
		-0.820138f, -0.450991f, 0.352109f, -0.819880f, 0.376634f, 0.431211f, 
		-0.819626f, 0.142494f, 0.554895f, -0.819602f, 0.142491f, 0.554932f, 
		-0.819339f, 0.320139f, -0.475600f, -0.819307f, 0.506615f, -0.268471f, 
		-0.819238f, 0.467930f, 0.331497f, -0.819046f, -0.0564855f, -0.570940f, 
		-0.818061f, 0.183538f, -0.545060f, -0.817917f, 0.434114f, 0.377566f, 
		-0.817911f, 0.434114f, 0.377580f, -0.817815f, 0.556762f, 0.145585f, 
		-0.817388f, 0.566650f, 0.103850f, -0.817302f, 0.463541f, -0.342267f, 
		-0.817250f, 0.323580f, -0.476864f, -0.817241f, 0.334332f, 0.469403f, 
		-0.817191f, 0.0860189f, 0.569912f, -0.817104f, -0.346271f, 0.460909f, 
		-0.817056f, 0.285010f, -0.501187f, -0.817044f, 0.285010f, -0.501206f, 
		-0.816266f, 0.368070f, -0.445236f, -0.815805f, 0.0520855f, -0.575977f, 
		-0.815653f, 0.339815f, -0.468226f, -0.815285f, 0.506410f, 0.280820f, 
		-0.815255f, 0.342204f, 0.467178f, -0.815107f, 0.574757f, -0.0724889f, 
		-0.814972f, 0.230053f, 0.531879f, -0.814811f, 0.405263f, -0.414542f, 
		-0.814560f, 0.338637f, -0.470975f, -0.814370f, 0.159046f, 0.558127f, 
		-0.814315f, 0.570870f, -0.104872f, -0.814288f, 0.310227f, -0.490606f, 
		-0.813687f, -0.572612f, 0.100145f, -0.813496f, -0.581478f, 0.0103822f, 
		-0.813467f, -0.480252f, 0.328070f, -0.813419f, 0.541682f, 0.211968f, 
		-0.813214f, -0.453104f, 0.365211f, -0.812836f, 0.101370f, -0.573604f, 
		-0.812697f, -0.103407f, 0.573438f, -0.812684f, -0.475616f, -0.336652f, 
		-0.812578f, 0.574808f, -0.0964970f, -0.812475f, 0.556513f, -0.173717f, 
		-0.812386f, -0.581757f, 0.0398564f, -0.812106f, 0.561120f, 0.160087f, 
		-0.812030f, 0.575683f, 0.0958996f, -0.811952f, 0.177327f, 0.556137f, 
		-0.811708f, 0.223486f, -0.539614f, -0.811574f, 0.114626f, 0.572895f, 
		-0.811438f, 0.407870f, -0.418582f, -0.811281f, -0.289150f, 0.508149f, 
		-0.811136f, 0.432264f, 0.393962f, -0.811043f, 0.583571f, 0.0406777f, 
		-0.810741f, -0.282718f, 0.512610f, -0.810673f, 0.570514f, 0.131618f, 
		-0.810529f, 0.392482f, 0.434742f, -0.810201f, -0.518305f, -0.273741f, 
		-0.809823f, 0.370573f, -0.454822f, -0.809792f, -0.227333f, -0.540884f, 
		-0.809753f, 0.437527f, 0.390986f, -0.809711f, 0.0416997f, -0.585346f, 
		-0.809552f, 0.583291f, -0.0663172f, -0.809148f, -0.581686f, 0.0831895f, 
		-0.809038f, -0.0102537f, -0.587667f, -0.808367f, -0.416620f, -0.415896f, 
		-0.808239f, 0.578391f, 0.110517f, -0.807816f, 0.530356f, 0.257209f, 
		-0.806463f, 0.588329f, -0.0590526f, -0.806357f, 0.0192836f, -0.591115f, 
		-0.806135f, 0.547503f, 0.224470f, -0.806001f, 0.497522f, -0.320677f, 
		-0.805499f, 0.218166f, 0.550976f, -0.805491f, 0.588296f, -0.0713601f, 
		-0.805276f, 0.316974f, -0.501057f, -0.805067f, -0.592342f, 0.0316005f, 
		-0.804978f, -0.184422f, 0.563914f, -0.804952f, -0.184402f, 0.563957f, 
		-0.804841f, 0.417552f, -0.421760f, -0.804637f, 0.138533f, -0.577381f, 
		-0.804632f, -0.00582737f, -0.593745f, -0.804625f, 0.570879f, -0.163327f, 
		-0.804546f, 0.585941f, 0.0968442f, -0.804438f, -0.432725f, 0.406974f, 
		-0.804224f, 0.341841f, -0.486177f, -0.804215f, 0.508042f, -0.308434f, 
		-0.804016f, 0.187183f, 0.564377f, -0.803907f, -0.330080f, -0.494753f, 
		-0.803649f, 0.345245f, -0.484721f, -0.803539f, 0.0517927f, -0.592994f, 
		-0.803332f, 0.578645f, -0.140811f, -0.803063f, -0.516846f, 0.296579f, 
		-0.802943f, -0.538419f, 0.255711f, -0.802540f, 0.329127f, -0.497599f, 
		-0.801869f, -0.390477f, 0.452255f, -0.801576f, -0.595393f, -0.0546088f, 
		-0.801430f, -0.597864f, 0.0163908f, -0.801335f, 0.316304f, -0.507755f, 
		-0.801268f, 0.585365f, -0.123765f, -0.801184f, 0.597652f, -0.0302677f, 
		-0.801068f, 0.182929f, 0.569936f, -0.800930f, -0.409140f, -0.437167f, 
		-0.800755f, 0.431858f, 0.415078f, -0.800626f, 0.0859293f, 0.592971f, 
		-0.800443f, 0.566486f, 0.195919f, -0.800426f, 0.117671f, 0.587769f, 
		-0.800362f, 0.561539f, 0.209987f, -0.799857f, -0.179288f, -0.572787f, 
		-0.799449f, -0.417624f, -0.431824f, -0.798161f, 0.389397f, 0.459685f, 
		-0.797414f, -0.0324325f, 0.602560f, -0.797335f, 0.342621f, 0.496858f, 
		-0.797246f, 0.570517f, -0.197253f, -0.797202f, 0.558271f, -0.229790f, 
		-0.796948f, -0.568107f, 0.205252f, -0.796739f, -0.583258f, 0.158168f, 
		-0.796722f, 0.499988f, 0.339478f, -0.796541f, 0.500729f, 0.338811f, 
		-0.796324f, 0.298979f, -0.525814f, -0.796143f, 0.304936f, -0.522658f, 
		-0.795976f, -0.160755f, 0.583593f, -0.795966f, -0.160783f, 0.583598f, 
		-0.795901f, 0.522453f, 0.305915f, -0.795563f, -0.349440f, -0.494945f, 
		-0.795448f, -0.0670915f, 0.602297f, -0.795186f, -0.464806f, -0.389403f, 
		-0.795169f, 0.000492769f, -0.606387f, -0.795144f, 0.539541f, 0.276842f, 
		-0.795118f, 0.272075f, -0.541998f, -0.794856f, 0.563676f, 0.224663f, 
		-0.794838f, -0.606733f, 0.0103605f, -0.794820f, -0.606757f, 0.0103816f, 
		-0.794739f, 0.190411f, 0.576311f, -0.794650f, -0.601408f, 0.0827008f, 
		-0.794501f, 0.537186f, 0.283193f, -0.794129f, -0.203442f, -0.572688f, 
		-0.794102f, -0.436198f, -0.423241f, -0.794063f, -0.604776f, 0.0609150f, 
		-0.793814f, -0.365794f, 0.485854f, -0.793379f, 0.605335f, 0.0641824f, 
		-0.793149f, 0.356617f, 0.493699f, -0.793116f, 0.602988f, 0.0858593f, 
		-0.793076f, 0.522738f, -0.312691f, -0.792811f, 0.578842f, -0.190770f, 
		-0.792756f, -0.252836f, 0.554628f, -0.792542f, 0.539755f, -0.283799f, 
		-0.792432f, -0.600588f, 0.106511f, -0.792254f, -0.382421f, 0.475486f, 
		-0.792116f, -0.400635f, 0.460483f, -0.791978f, 0.567261f, -0.225801f, 
		-0.791927f, 0.519975f, -0.320122f, -0.791802f, -0.433304f, 0.430462f, 
		-0.791734f, 0.610839f, -0.00564909f, -0.791426f, 0.165723f, 0.588371f, 
		-0.790777f, 0.585491f, -0.178528f, -0.789856f, 0.613049f, 0.0172599f, 
		-0.789813f, -0.606651f, -0.0903942f, -0.789481f, 0.334404f, 0.514678f, 
		-0.789186f, 0.611066f, -0.0615144f, -0.788990f, 0.548504f, -0.276834f, 
		-0.788381f, 0.120828f, 0.603205f, -0.788352f, 0.346024f, 0.508693f, 
		-0.788147f, -0.498151f, 0.361484f, -0.787706f, 0.476645f, -0.390292f, 
		-0.787694f, 0.458865f, 0.411074f, -0.787563f, -0.613509f, 0.0578837f, 
		-0.787551f, 0.0295652f, 0.615540f, -0.787446f, 0.457426f, -0.413148f, 
		-0.787327f, 0.394248f, 0.474009f, -0.787290f, -0.210018f, -0.579713f, 
		-0.787160f, 0.277598f, 0.550743f, -0.786834f, 0.309256f, 0.534090f, 
		-0.786512f, -0.404317f, 0.466826f, -0.786344f, -0.590961f, -0.180079f, 
		-0.786279f, 0.448654f, 0.424824f, -0.786247f, 0.148099f, -0.599902f, 
		-0.786180f, 0.610788f, 0.0941240f, -0.785882f, 0.000852963f, -0.618376f, 
		-0.785150f, -0.614538f, 0.0767057f, -0.785081f, 0.613596f, -0.0845397f, 
		-0.784888f, 0.526047f, -0.327453f, -0.784342f, 0.273196f, -0.556930f, 
		-0.784177f, -0.580907f, -0.218207f, -0.783995f, 0.518873f, 0.340767f, 
		-0.783985f, -0.581195f, 0.218128f, -0.783869f, -0.560687f, 0.266795f, 
		-0.783559f, 0.271351f, 0.558931f, -0.783544f, 0.271358f, 0.558949f, 
		-0.783257f, 0.191834f, 0.591361f, -0.783103f, 0.193179f, -0.591127f, 
		-0.783028f, -0.604690f, 0.145657f, -0.782475f, 0.584996f, 0.213337f, 
		-0.782208f, -0.0356866f, 0.621995f, -0.781390f, 0.101176f, 0.615786f, 
		-0.780798f, -0.289990f, 0.553409f, -0.780761f, -0.530900f, 0.329480f, 
		-0.780556f, 0.624973f, 0.0118590f, -0.780375f, 0.576729f, 0.241655f, 
		-0.780245f, -0.539570f, -0.316357f, -0.780200f, 0.164172f, 0.603602f, 
		-0.780129f, -0.279177f, -0.559874f, -0.779901f, 0.604712f, -0.161486f, 
		-0.779578f, 0.559375f, 0.281706f, -0.779241f, -0.554603f, 0.291889f, 
		-0.779153f, 0.0352370f, -0.625842f, -0.779123f, 0.281339f, 0.560192f, 
		-0.779056f, 0.0644938f, 0.623628f, -0.779006f, -0.482813f, -0.400051f, 
		-0.778885f, 0.561003f, -0.280382f, -0.778773f, -0.624464f, 0.0596450f, 
		-0.778761f, 0.337729f, 0.528650f, -0.778484f, 0.467808f, -0.418472f, 
		-0.778289f, -0.384441f, -0.496460f, -0.777859f, -0.390108f, -0.492698f, 
		-0.777774f, 0.313447f, 0.544811f, -0.777768f, 0.550480f, -0.303394f, 
		-0.777621f, -0.489327f, 0.394797f, -0.777590f, 0.603696f, -0.175799f, 
		-0.776614f, 0.556434f, -0.295385f, -0.776471f, 0.00794794f, -0.630102f, 
		-0.775684f, 0.618087f, 0.127606f, -0.775534f, -0.283731f, -0.563954f, 
		-0.775103f, -0.533653f, 0.338273f, -0.773864f, 0.587269f, 0.237172f, 
		-0.773557f, 0.620093f, 0.130744f, -0.773548f, 0.350773f, -0.527808f, 
		-0.773178f, 0.605435f, 0.188798f, -0.773129f, 0.624679f, -0.109763f, 
		-0.773077f, -0.448174f, 0.448879f, -0.772823f, 0.538127f, 0.336398f, 
		-0.772685f, 0.634564f, 0.0169199f, -0.772652f, -0.521166f, 0.362485f, 
		-0.772628f, 0.569360f, -0.280847f, -0.771456f, 0.387779f, 0.504463f, 
		-0.771205f, 0.564880f, 0.293518f, -0.770934f, 0.361684f, 0.524257f, 
		-0.770897f, -0.0688933f, 0.633223f, -0.770676f, -0.476187f, -0.423443f, 
		-0.770479f, 0.113368f, -0.627303f, -0.770399f, 0.318272f, -0.552438f, 
		-0.770289f, 0.631479f, -0.0888216f, -0.770110f, -0.244374f, -0.589247f, 
		-0.770044f, 0.625273f, 0.126754f, -0.769906f, 0.429853f, 0.471669f, 
		-0.769708f, 0.0785866f, -0.633540f, -0.769654f, 0.369477f, -0.520691f, 
		-0.769644f, 0.565727f, 0.295976f, -0.769631f, -0.0674609f, 0.634915f, 
		-0.769442f, 0.316383f, -0.554852f, -0.769383f, -0.618219f, 0.160795f, 
		-0.769354f, 0.586625f, 0.252916f, -0.769143f, -0.127595f, 0.626210f, 
		-0.768990f, -0.635091f, -0.0728929f, -0.768962f, -0.635119f, -0.0729450f, 
		-0.768586f, -0.126014f, 0.627213f, -0.768331f, 0.0160381f, 0.639851f, 
		-0.768324f, 0.541601f, -0.341095f, -0.768016f, 0.00384137f, -0.640419f, 
		-0.767963f, -0.0641182f, -0.637277f, -0.767909f, 0.334377f, 0.546359f, 
		-0.767880f, -0.632062f, 0.104199f, -0.767696f, -0.210153f, 0.605374f, 
		-0.766917f, 0.531416f, -0.359772f, -0.766874f, 0.456488f, 0.451135f, 
		-0.766593f, 0.305577f, 0.564764f, -0.766524f, 0.642210f, -0.00265019f, 
		-0.766026f, -0.457012f, 0.452046f, -0.766012f, 0.573848f, 0.289698f, 
		-0.765869f, 0.638059f, 0.0795308f, -0.765849f, 0.0279172f, 0.642414f, 
		-0.765618f, 0.576257f, -0.285933f, -0.765605f, 0.290671f, -0.573898f, 
		-0.765546f, 0.642771f, 0.0280231f, -0.765446f, 0.643266f, 0.0173516f, 
		-0.765288f, 0.538725f, -0.352291f, -0.765140f, -0.410918f, 0.495688f, 
		-0.764815f, -0.582609f, 0.274998f, -0.764345f, 0.391839f, -0.512093f, 
		-0.764288f, 0.299364f, 0.571178f, -0.764219f, 0.334681f, -0.551324f, 
		-0.764104f, -0.427795f, 0.482842f, -0.763664f, -0.402808f, -0.504543f, 
		-0.763259f, -0.642481f, 0.0682180f, -0.763013f, 0.419488f, -0.491773f, 
		-0.762769f, -0.624680f, 0.167208f, -0.762579f, 0.289325f, 0.578588f, 
		-0.762514f, 0.224353f, -0.606826f, -0.762269f, 0.589334f, 0.267641f, 
		-0.762203f, 0.0959567f, -0.640187f, -0.762135f, 0.148269f, -0.630212f, 
		-0.761874f, 0.104783f, 0.639194f, -0.761848f, -0.0578275f, -0.645169f, 
		-0.761821f, 0.448802f, 0.467125f, -0.761727f, 0.557523f, -0.330061f, 
		-0.760956f, -0.384106f, -0.522885f, -0.760859f, 0.367800f, -0.534618f, 
		-0.760806f, 0.623513f, 0.180016f, -0.760546f, 0.496377f, -0.418544f, 
		-0.760364f, 0.552404f, -0.341610f, -0.760018f, 0.568315f, -0.315263f, 
		-0.759831f, 0.622635f, -0.187036f, -0.759768f, -0.650084f, 0.0119670f, 
		-0.759475f, 0.621789f, -0.191251f, -0.759434f, 0.487022f, 0.431359f, 
		-0.759425f, -0.186519f, 0.623285f, -0.759290f, 0.0469045f, 0.649059f, 
		-0.759116f, 0.650954f, 0.00123704f, -0.759012f, -0.539312f, -0.364752f, 
		-0.758984f, 0.648152f, -0.0619872f, -0.758841f, 0.628072f, -0.172296f, 
		-0.758839f, 0.628085f, -0.172256f, -0.758406f, 0.158388f, 0.632245f, 
		-0.758357f, 0.550965f, -0.348327f, -0.758005f, -0.551596f, 0.348096f, 
		-0.757623f, -0.0906444f, -0.646367f, -0.757410f, 0.526298f, 0.386446f, 
		-0.757196f, 0.321658f, 0.568498f, -0.756233f, -0.0755360f, 0.649927f, 
		-0.756103f, 0.181969f, 0.628646f, -0.756096f, -0.467713f, -0.457781f, 
		-0.756089f, 0.181979f, 0.628660f, -0.756052f, 0.293323f, 0.585105f, 
		-0.755614f, -0.553888f, -0.349652f, -0.755581f, 0.295956f, 0.584387f, 
		-0.755487f, 0.330711f, -0.565570f, -0.755086f, 0.500419f, 0.423587f, 
		-0.754864f, -0.406152f, 0.514997f, -0.754853f, 0.599677f, 0.265676f, 
		-0.754829f, -0.478533f, -0.448598f, -0.754619f, 0.381459f, 0.533891f, 
		-0.754490f, -0.580447f, 0.306311f, -0.754471f, 0.471826f, 0.456239f, 
		-0.754442f, 0.624248f, 0.202811f, -0.754223f, 0.655607f, 0.0364195f, 
		-0.754090f, 0.655725f, 0.0370480f, -0.753978f, 0.656488f, 0.0232692f, 
		-0.753100f, 0.499783f, 0.427851f, -0.753045f, 0.595004f, -0.280878f, 
		-0.753028f, 0.585173f, 0.300868f, -0.752886f, 0.556964f, -0.350649f, 
		-0.752384f, -0.139365f, -0.643814f, -0.752139f, -0.658842f, 0.0146151f, 
		-0.751770f, 0.506620f, -0.422112f, -0.751467f, 0.650452f, 0.110493f, 
		-0.751236f, -0.303476f, -0.586128f, -0.750934f, -0.659699f, -0.0299167f, 
		-0.750804f, 0.461723f, 0.472340f, -0.750718f, 0.349237f, 0.560764f, 
		-0.750651f, 0.242919f, -0.614421f, -0.749562f, 0.203651f, 0.629828f, 
		-0.749518f, -0.485878f, 0.449606f, -0.749088f, -0.314315f, -0.583158f, 
		-0.748915f, 0.514602f, 0.417506f, -0.748883f, 0.118909f, 0.651947f, 
		-0.748767f, 0.572480f, 0.334086f, -0.748743f, 0.279425f, -0.601087f, 
		-0.748683f, 0.543278f, 0.379897f, -0.748679f, 0.375833f, -0.546103f, 
		-0.748335f, 0.518305f, 0.413951f, -0.747990f, 0.605415f, 0.272000f, 
		-0.747653f, 0.664083f, 0.00294360f, -0.747620f, 0.663726f, 0.0230785f, 
		-0.747406f, 0.601804f, -0.281454f, -0.747287f, 0.352532f, 0.563279f, 
		-0.747217f, 0.620566f, -0.237834f, -0.746416f, 0.590053f, -0.307735f, 
		-0.746379f, 0.579889f, -0.326570f, -0.746301f, 0.383619f, -0.543941f, 
		-0.745192f, 0.389412f, -0.541338f, -0.744705f, 0.653401f, 0.135948f, 
		-0.744390f, 0.667701f, -0.00767678f, -0.744243f, 0.562078f, -0.360791f, 
		-0.744142f, 0.575332f, -0.339479f, -0.743659f, 0.155164f, 0.650304f, 
		-0.743653f, 0.549515f, 0.380805f, -0.743503f, -0.128041f, -0.656360f, 
		-0.743458f, -0.464666f, 0.480994f, -0.743452f, -0.609577f, -0.275126f, 
		-0.743278f, 0.444741f, -0.499743f, -0.742908f, 0.0381341f, -0.668306f, 
		-0.742889f, 0.242227f, 0.624053f, -0.742639f, 0.258665f, -0.617722f, 
		-0.742581f, -0.137720f, 0.655444f, -0.741871f, 0.236091f, -0.627605f, 
		-0.741576f, 0.670650f, -0.0171057f, -0.741555f, 0.324772f, -0.587043f, 
		-0.741478f, 0.486273f, -0.462329f, -0.740961f, -0.278079f, -0.611268f, 
		-0.740956f, 0.0207373f, -0.671233f, -0.740892f, 0.604305f, 0.293078f, 
		-0.740612f, 0.667931f, -0.0732301f, -0.740558f, -0.659898f, -0.126919f, 
		-0.740421f, 0.546892f, 0.390750f, -0.740295f, 0.378853f, 0.555368f, 
		-0.740127f, -0.351537f, -0.573266f, -0.739483f, -0.0150497f, 0.673007f, 
		-0.739460f, 0.635596f, 0.221847f, -0.739056f, -0.512885f, 0.436743f, 
		-0.738861f, 0.541009f, 0.401739f, -0.738805f, 0.449560f, 0.502060f, 
		-0.738652f, 0.571064f, 0.358161f, -0.738446f, -0.0142059f, 0.674162f, 
		-0.738356f, 0.404604f, -0.539561f, -0.738211f, -0.246249f, 0.628018f, 
		-0.738155f, -0.0469202f, -0.672998f, -0.737954f, -0.0157647f, 0.674667f, 
		-0.737865f, -0.0897306f, 0.668957f, -0.737784f, 0.425426f, 0.524106f, 
		-0.737109f, 0.603939f, -0.303196f, -0.737094f, 0.582883f, 0.341965f, 
		-0.736248f, 0.588537f, -0.334011f, -0.736061f, 0.662202f, -0.140365f, 
		-0.736060f, 0.117103f, -0.666710f, -0.735835f, -0.399679f, 0.546629f, 
		-0.735420f, 0.661403f, -0.147323f, -0.735382f, 0.423089f, 0.529348f, 
		-0.735013f, 0.0164974f, -0.677853f, -0.734921f, 0.423581f, -0.529595f, 
		-0.734892f, -0.323771f, -0.595908f, -0.734489f, -0.663656f, -0.141731f, 
		-0.734302f, 0.0504487f, -0.676946f, -0.733900f, 0.469794f, -0.490596f, 
		-0.733743f, 0.431233f, -0.525033f, -0.733629f, -0.581050f, -0.352378f, 
		-0.733616f, 0.468205f, -0.492536f, -0.733605f, -0.581098f, -0.352347f, 
		-0.733539f, -0.538270f, -0.414953f, -0.733503f, -0.653342f, -0.187398f, 
		-0.733204f, 0.433444f, -0.523964f, -0.733181f, 0.532433f, 0.423036f, 
		-0.732563f, 0.0254815f, 0.680222f, -0.732546f, 0.0255007f, 0.680240f, 
		-0.732312f, -0.679561f, 0.0437839f, -0.732018f, 0.106006f, -0.672987f, 
		-0.731907f, -0.479937f, 0.483708f, -0.731796f, 0.192313f, -0.653827f, 
		-0.731769f, 0.574867f, 0.366118f, -0.731733f, 0.668100f, -0.134940f, 
		-0.731453f, 0.602528f, -0.319275f, -0.731272f, 0.676298f, -0.0886742f, 
		-0.731114f, 0.555218f, -0.396491f, -0.730730f, 0.665221f, 0.153345f, 
		-0.730320f, 0.0567069f, 0.680747f, -0.730297f, 0.0782820f, 0.678629f, 
		-0.730275f, 0.197566f, -0.653962f, -0.730017f, -0.338949f, 0.593455f, 
		-0.729914f, 0.375306f, 0.571289f, -0.729622f, -0.669193f, -0.140825f, 
		-0.729358f, 0.679762f, 0.0772043f, -0.728797f, 0.653641f, 0.203983f, 
		-0.728781f, 0.649478f, 0.216927f, -0.728572f, -0.428584f, -0.534320f, 
		-0.728468f, -0.214909f, -0.650499f, -0.728438f, 0.332959f, 0.598763f, 
		-0.728351f, 0.604147f, 0.323282f, -0.728246f, -0.163547f, -0.665515f, 
		-0.728244f, 0.362406f, -0.581655f, -0.728009f, 0.0643069f, 0.682545f, 
		-0.727824f, 0.390560f, -0.563680f, -0.727630f, -0.530283f, 0.435149f, 
		-0.727565f, 0.336341f, 0.597933f, -0.727428f, -0.677069f, -0.111471f, 
		-0.727134f, 0.674370f, 0.128457f, -0.726620f, -0.640909f, -0.247506f, 
		-0.726460f, 0.613269f, -0.310093f, -0.726412f, 0.672907f, -0.139717f, 
		-0.726270f, 0.685803f, 0.0469653f, -0.726198f, 0.365721f, 0.582138f, 
		-0.726118f, 0.563841f, -0.393493f, -0.725987f, -0.321321f, 0.608026f, 
		-0.725738f, -0.0526214f, 0.685956f, -0.725351f, 0.534954f, 0.433232f, 
		-0.725109f, -0.244637f, 0.643715f, -0.725076f, -0.269024f, -0.633948f, 
		-0.724789f, 0.674251f, -0.141658f, -0.724789f, 0.535049f, 0.434055f, 
		-0.724725f, 0.578456f, 0.374383f, -0.724413f, -0.492861f, 0.481990f, 
		-0.724407f, -0.492836f, 0.482024f, -0.723799f, 0.686740f, 0.0671119f, 
		-0.723790f, 0.453563f, -0.520008f, -0.723329f, 0.533178f, 0.438767f, 
		-0.723269f, 0.490041f, -0.486562f, -0.723186f, 0.534823f, -0.436996f, 
		-0.723109f, 0.687903f, 0.0624675f, -0.723101f, 0.644350f, -0.248875f, 
		-0.722970f, -0.689772f, -0.0391093f, -0.722766f, -0.682929f, -0.105910f, 
		-0.722386f, 0.587109f, -0.365324f, -0.721606f, -0.541052f, -0.431913f, 
		-0.721520f, 0.691361f, 0.0377983f, -0.721486f, 0.691864f, -0.0279586f, 
		-0.721393f, 0.658278f, 0.215088f, -0.721254f, 0.184197f, 0.667731f, 
		-0.721131f, -0.603076f, -0.340983f, -0.720747f, -0.287056f, -0.630970f, 
		-0.720630f, 0.486165f, 0.494304f, -0.720439f, 0.164173f, -0.673806f, 
		-0.720416f, -0.519613f, 0.459350f, -0.720259f, 0.548889f, 0.424203f, 
		-0.719643f, 0.129603f, 0.682141f, -0.719450f, 0.628717f, -0.295138f, 
		-0.719026f, -0.0608195f, 0.692317f, -0.718736f, 0.499176f, -0.483986f, 
		-0.718519f, 0.136412f, 0.681999f, -0.718437f, -0.284617f, -0.634698f, 
		-0.718184f, 0.615178f, 0.325218f, -0.718087f, 0.171849f, 0.674402f, 
		-0.718007f, 0.365497f, 0.592349f, -0.717789f, -0.399345f, 0.570352f, 
		-0.717429f, -0.576443f, -0.391163f, -0.717372f, -0.354833f, 0.599560f, 
		-0.717370f, 0.692226f, 0.0787630f, -0.717299f, -0.628308f, -0.301183f, 
		-0.716932f, 0.0554138f, 0.694937f, -0.716765f, 0.383217f, 0.582573f, 
		-0.716729f, -0.278704f, 0.639236f, -0.716717f, 0.374803f, -0.588081f, 
		-0.716684f, -0.0191980f, 0.697133f, -0.716575f, 0.142457f, -0.682808f, 
		-0.716489f, 0.403675f, 0.568938f, -0.716327f, -0.0626708f, -0.694945f, 
		-0.715872f, 0.508759f, 0.478217f, -0.715786f, 0.258325f, 0.648783f, 
		-0.714875f, 0.693308f, -0.0909822f, -0.714360f, 0.507644f, 0.481651f, 
		-0.714355f, 0.596224f, -0.366352f, -0.714220f, -0.498232f, 0.491584f, 
		-0.714168f, 0.674205f, 0.188178f, -0.714155f, 0.517515f, 0.471339f, 
		-0.713475f, 0.298573f, -0.633883f, -0.713438f, 0.222951f, 0.664303f, 
		-0.713290f, 0.681600f, 0.163213f, -0.713254f, 0.681615f, 0.163308f, 
		-0.712980f, 0.686632f, -0.142111f, -0.712936f, 0.622856f, 0.322138f, 
		-0.712752f, -0.509774f, 0.481784f, -0.712718f, -0.454980f, -0.533879f, 
		-0.712396f, 0.565710f, -0.415289f, -0.712112f, 0.625839f, -0.318153f, 
		-0.712032f, -0.117266f, -0.692285f, -0.711876f, 0.690297f, -0.129319f, 
		-0.711867f, 0.0600778f, 0.699740f, -0.711531f, 0.300889f, -0.634972f, 
		-0.711507f, 0.300898f, -0.634995f, -0.711432f, 0.650270f, 0.266483f, 
		-0.711077f, 0.396480f, -0.580666f, -0.710661f, 0.0767524f, 0.699335f, 
		-0.710316f, -0.0360353f, 0.702960f, -0.710151f, -0.384083f, -0.590056f, 
		-0.709807f, 0.506936f, 0.489070f, -0.709660f, 0.342982f, 0.615423f, 
		-0.709426f, 0.696677f, 0.106566f, -0.709312f, -0.519940f, -0.475961f, 
		-0.709040f, 0.656134f, 0.258361f, -0.708934f, -0.334725f, 0.620783f, 
		-0.708879f, 0.492855f, -0.504564f, -0.708568f, 0.569721f, 0.416352f, 
		-0.708339f, -0.319510f, 0.629420f, -0.708292f, -0.498436f, 0.499884f, 
		-0.708227f, 0.687134f, 0.162055f, -0.707935f, 0.359281f, -0.608066f, 
		-0.707395f, 0.100329f, -0.699662f, -0.707295f, 0.690790f, -0.150141f, 
		-0.707229f, 0.701547f, 0.0875186f, -0.707164f, -0.690649f, -0.151405f, 
		-0.707003f, 0.430390f, -0.561170f, -0.706829f, 0.681344f, 0.190165f, 
		-0.706790f, 0.443807f, 0.550893f, -0.705853f, 0.579841f, 0.406886f, 
		-0.705592f, 0.687485f, 0.171766f, -0.705350f, -0.535780f, -0.464135f, 
		-0.705129f, 0.156309f, 0.691636f, -0.705074f, 0.545593f, -0.452989f, 
		-0.705007f, -0.519074f, 0.483246f, -0.704885f, 0.680635f, 0.199681f, 
		-0.704700f, 0.613423f, -0.356525f, -0.704017f, 0.572660f, -0.420024f, 
		-0.703982f, -0.701805f, 0.108993f, -0.703942f, 0.307411f, -0.640284f, 
		-0.703308f, 0.391552f, 0.593334f, -0.702825f, 0.582541f, -0.408269f, 
		-0.702735f, 0.711411f, -0.00765416f, -0.702569f, 0.682766f, 0.200569f, 
		-0.702504f, 0.267047f, 0.659678f, -0.702202f, 0.202345f, -0.682619f, 
		-0.702169f, 0.259900f, 0.662881f, -0.701999f, 0.692587f, -0.165895f, 
		-0.701620f, 0.310810f, -0.641192f, -0.701075f, -0.242998f, -0.670407f, 
		-0.700999f, 0.709298f, -0.0741345f, -0.700399f, -0.0322657f, 0.713022f, 
		-0.700241f, 0.638521f, -0.319303f, -0.699995f, 0.542088f, -0.464917f, 
		-0.699836f, 0.674888f, 0.233999f, -0.699733f, -0.694865f, -0.165942f, 
		-0.699691f, 0.706471f, 0.106450f, -0.699299f, -0.152005f, 0.698481f, 
		-0.697967f, 0.477738f, 0.533487f, -0.697892f, -0.363140f, -0.617314f, 
		-0.696766f, 0.686264f, 0.208709f, -0.696755f, 0.279497f, 0.660616f, 
		-0.696417f, 0.229301f, 0.680018f, -0.695387f, 0.169258f, -0.698419f, 
		-0.695299f, -0.152984f, -0.702250f, -0.695176f, -0.0365814f, -0.717908f, 
		-0.695163f, 0.563255f, -0.446646f, -0.694970f, 0.699589f, 0.166107f, 
		-0.694665f, -0.198263f, -0.691472f, -0.694452f, -0.214555f, -0.686806f, 
		-0.694309f, 0.344107f, -0.632080f, -0.693541f, -0.533434f, 0.484200f, 
		-0.693538f, -0.354825f, 0.626980f, -0.693510f, 0.509366f, -0.509500f, 
		-0.692880f, 0.242109f, 0.679191f, -0.692702f, -0.388454f, -0.607674f, 
		-0.692432f, -0.709066f, -0.133282f, -0.692371f, 0.660785f, -0.289803f, 
		-0.692262f, 0.572079f, -0.439886f, -0.692142f, 0.661265f, 0.289254f, 
		-0.692062f, -0.154717f, -0.705062f, -0.691868f, 0.696874f, 0.188904f, 
		-0.691633f, 0.453547f, -0.562084f, -0.691618f, 0.516070f, 0.505308f, 
		-0.691217f, 0.545644f, -0.473806f, -0.691160f, 0.722478f, -0.0179965f, 
		-0.690931f, 0.696787f, 0.192616f, -0.690345f, 0.574191f, -0.440146f, 
		-0.689585f, -0.0273612f, 0.723687f, -0.689572f, 0.220196f, -0.689930f, 
		-0.689291f, 0.310808f, 0.654428f, -0.689152f, -0.311002f, -0.654482f, 
		-0.689097f, 0.710897f, -0.140609f, -0.688961f, 0.607688f, 0.395029f, 
		-0.688817f, 0.265368f, -0.674619f, -0.687936f, 0.585319f, -0.429122f, 
		-0.687791f, -0.392422f, 0.610694f, -0.687618f, 0.00341602f, 0.726064f, 
		-0.687577f, -0.285352f, -0.667691f, -0.687180f, 0.708945f, 0.158681f, 
		-0.686964f, 0.540399f, -0.485849f, -0.686777f, -0.0394214f, 0.725799f, 
		-0.686613f, 0.703211f, 0.184545f, -0.686603f, -0.390247f, 0.613419f, 
		-0.686407f, 0.695365f, 0.212866f, -0.686287f, 0.414956f, 0.597346f, 
		-0.686021f, 0.150751f, 0.711793f, -0.685971f, 0.215399f, -0.695015f, 
		-0.685655f, 0.120815f, -0.717830f, -0.685621f, 0.370033f, 0.626897f, 
		-0.685588f, 0.726556f, 0.0456667f, -0.685541f, -0.563034f, 0.461548f, 
		-0.684837f, -0.410222f, -0.602260f, -0.684806f, 0.207343f, 0.698606f, 
		-0.684701f, 0.728718f, 0.0124763f, -0.683969f, -0.518456f, 0.513215f, 
		-0.683701f, 0.644975f, -0.341408f, -0.683375f, 0.479535f, -0.550495f, 
		-0.683322f, -0.383489f, 0.621295f, -0.683321f, -0.383500f, 0.621289f, 
		-0.683221f, 0.502226f, 0.530073f, -0.682361f, 0.573851f, 0.452856f, 
		-0.682206f, 0.714031f, -0.157336f, -0.682167f, -0.643055f, 0.348036f, 
		-0.682089f, 0.0776192f, -0.727138f, -0.681542f, 0.731639f, 0.0143051f, 
		-0.681345f, -0.00922026f, 0.731904f, -0.680822f, 0.505661f, -0.529895f, 
		-0.680718f, -0.615581f, -0.397093f, -0.680571f, -0.557684f, 0.475198f, 
		-0.680310f, -0.719805f, -0.138050f, -0.680281f, 0.645581f, -0.347048f, 
		-0.679196f, -0.328757f, -0.656210f, -0.678872f, 0.683891f, -0.267254f, 
		-0.678483f, 0.679395f, 0.279434f, -0.678408f, 0.397173f, -0.618075f, 
		-0.678400f, -0.428427f, 0.596845f, -0.678093f, -0.149129f, 0.719688f, 
		-0.677727f, 0.269220f, 0.684256f, -0.677585f, 0.693237f, 0.245563f, 
		-0.677496f, -0.454725f, 0.578121f, -0.677359f, 0.719233f, 0.154562f, 
		-0.677322f, 0.112147f, 0.727088f, -0.676884f, 0.242388f, -0.695036f, 
		-0.676796f, 0.292823f, -0.675427f, -0.676472f, -0.584897f, -0.447528f, 
		-0.676462f, -0.484830f, 0.554382f, -0.676347f, 0.465730f, 0.570657f, 
		-0.676125f, 0.326019f, -0.660732f, -0.675663f, 0.216141f, 0.704814f, 
		-0.675273f, -0.473031f, 0.565905f, -0.675051f, 0.359245f, 0.644398f, 
		-0.674768f, 0.404364f, 0.617397f, -0.674408f, 0.113739f, -0.729546f, 
		-0.674172f, 0.359957f, 0.644921f, -0.674090f, -0.190872f, -0.713562f, 
		-0.673865f, 0.450941f, -0.585285f, -0.673598f, 0.654097f, 0.344126f, 
		-0.673522f, -0.707128f, 0.215264f, -0.673492f, -0.465030f, 0.574592f, 
		-0.673460f, 0.646397f, -0.358641f, -0.673264f, 0.390182f, -0.628072f, 
		-0.673242f, -0.278734f, -0.684874f, -0.672922f, -0.368697f, 0.641279f, 
		-0.672726f, 0.0996974f, -0.733144f, -0.672646f, -0.392591f, -0.627232f, 
		-0.672366f, 0.563703f, -0.479753f, -0.671995f, -0.204774f, -0.711681f, 
		-0.671963f, 0.124610f, -0.730026f, -0.671571f, 0.138002f, -0.727975f, 
		-0.671437f, 0.289912f, 0.682000f, -0.671261f, 0.220744f, 0.707588f, 
		-0.670840f, -0.721209f, 0.172718f, -0.670787f, 0.414495f, 0.615011f, 
		-0.670738f, -0.113195f, 0.733006f, -0.670587f, 0.154558f, 0.725551f, 
		-0.670013f, -0.120782f, 0.732458f, -0.669797f, -0.573916f, -0.471161f, 
		-0.669763f, 0.715134f, -0.200003f, -0.669287f, -0.331570f, -0.664918f, 
		-0.669053f, 0.465243f, 0.579583f, -0.668846f, 0.603998f, 0.433394f, 
		-0.668713f, 0.743395f, 0.0136412f, -0.668509f, 0.740118f, -0.0729441f, 
		-0.668443f, 0.291384f, -0.684309f, -0.668268f, -0.646136f, -0.368681f, 
		-0.668198f, 0.523858f, -0.528285f, -0.668149f, 0.555615f, -0.494843f, 
		-0.667901f, 0.533892f, 0.518524f, -0.667693f, 0.708971f, -0.227039f, 
		-0.667588f, 0.164453f, 0.726141f, -0.667109f, 0.562649f, -0.488254f, 
		-0.667106f, -0.744838f, -0.0136515f, -0.666858f, 0.143321f, 0.731272f, 
		-0.666409f, 0.745086f, 0.0273278f, -0.666295f, 0.619509f, -0.415042f, 
		-0.665669f, -0.468059f, -0.581210f, -0.665580f, 0.550447f, 0.503995f, 
		-0.665511f, 0.139046f, 0.733322f, -0.665009f, 0.732695f, 0.144639f, 
		-0.664731f, -0.343788f, -0.663282f, -0.664538f, 0.660019f, 0.350378f, 
		-0.664337f, 0.131801f, -0.735721f, -0.664234f, 0.336172f, -0.667669f, 
		-0.663643f, -0.738105f, 0.121567f, -0.663620f, -0.0377449f, -0.747117f, 
		-0.663087f, -0.377330f, 0.646481f, -0.663076f, 0.655981f, 0.360581f, 
		-0.662976f, 0.108442f, -0.740745f, -0.662966f, 0.105295f, -0.741207f, 
		-0.662939f, 0.748094f, -0.0294554f, -0.662930f, 0.748195f, -0.0269831f, 
		-0.662914f, 0.748209f, -0.0269906f, -0.662766f, 0.0865396f, 0.743809f, 
		-0.662647f, 0.735812f, -0.139567f, -0.662383f, -0.739947f, 0.117161f, 
		-0.661799f, 0.423838f, 0.618371f, -0.661550f, 0.351461f, -0.662440f, 
		-0.661489f, -0.510782f, 0.549122f, -0.661126f, 0.666605f, 0.344312f, 
		-0.661018f, 0.357138f, 0.659930f, -0.660954f, 0.490429f, -0.567995f, 
		-0.660191f, 0.625917f, 0.415181f, -0.659483f, -0.142179f, 0.738151f, 
		-0.659214f, 0.656980f, 0.365806f, -0.659197f, -0.725946f, 0.196116f, 
		-0.658927f, 0.0296822f, -0.751621f, -0.658797f, 0.518375f, 0.545229f, 
		-0.658513f, 0.220101f, 0.719664f, -0.658222f, 0.739049f, 0.143353f, 
		-0.657732f, -0.536594f, -0.528636f, -0.657620f, 0.469355f, 0.589272f, 
		-0.657585f, 0.335671f, -0.674467f, -0.657303f, 0.391306f, 0.644075f, 
		-0.657290f, 0.721399f, -0.218070f, -0.657265f, 0.492425f, 0.570544f, 
		-0.657161f, -0.433353f, -0.616722f, -0.657099f, 0.668413f, 0.348488f, 
		-0.656973f, 0.744735f, -0.117284f, -0.656951f, 0.685941f, 0.312890f, 
		-0.656382f, 0.543427f, 0.523306f, -0.656322f, -0.363853f, 0.660948f, 
		-0.656252f, 0.448909f, -0.606477f, -0.656242f, 0.721223f, -0.221772f, 
		-0.656071f, 0.735380f, -0.169667f, -0.655889f, 0.366268f, 0.660044f, 
		-0.655876f, -0.535592f, -0.531947f, -0.655585f, 0.322502f, -0.682789f, 
		-0.655450f, 0.723981f, -0.215029f, -0.655271f, 0.748871f, -0.0990499f, 
		-0.655158f, -0.414825f, -0.631417f, -0.655050f, 0.0748406f, -0.751870f, 
		-0.654858f, 0.234276f, 0.718524f, -0.654855f, 0.656364f, 0.374636f, 
		-0.654634f, 0.755282f, 0.0316559f, -0.654450f, 0.580606f, -0.484346f, 
		-0.654225f, 0.391309f, -0.647199f, -0.653928f, 0.613437f, -0.442802f, 
		-0.653751f, 0.603451f, -0.456571f, -0.653602f, 0.379698f, 0.654701f, 
		-0.653564f, -0.756779f, 0.0117876f, -0.652924f, 0.393656f, 0.647090f, 
		-0.652810f, 0.315170f, 0.688844f, -0.652651f, 0.575942f, -0.492278f, 
		-0.652496f, 0.671984f, -0.350268f, -0.652493f, -0.529609f, -0.542003f, 
		-0.652394f, 0.614412f, 0.443711f, -0.651708f, -0.496891f, 0.573041f, 
		-0.651652f, 0.728588f, -0.210973f, -0.651195f, 0.740455f, 0.166345f, 
		-0.651142f, 0.0769496f, -0.755045f, -0.650972f, 0.226829f, -0.724420f, 
		-0.650881f, 0.172206f, -0.739391f, -0.650676f, 0.458074f, -0.605631f, 
		-0.650636f, -0.756777f, -0.0629323f, -0.650324f, 0.743698f, -0.154894f, 
		-0.650262f, 0.516914f, 0.556740f, -0.650250f, -0.744931f, 0.149173f, 
		-0.650116f, 0.218793f, 0.727653f, -0.649791f, -0.746912f, -0.141045f, 
		-0.649773f, 0.591352f, 0.477596f, -0.649410f, -0.192943f, -0.735554f, 
		-0.648794f, -0.120509f, 0.751362f, -0.648395f, 0.185692f, -0.738311f, 
		-0.648127f, 0.642627f, -0.408610f, -0.648081f, -0.574675f, 0.499741f, 
		-0.648080f, 0.278331f, 0.708889f, -0.647997f, -0.759773f, 0.0533439f, 
		-0.647996f, -0.107938f, -0.753957f, -0.647965f, 0.0643155f, -0.758950f, 
		-0.647936f, 0.395660f, -0.650870f, -0.647908f, -0.444432f, 0.618623f, 
		-0.647897f, 0.703015f, -0.293257f, -0.647648f, -0.533239f, -0.544251f, 
		-0.647537f, 0.315778f, 0.693527f, -0.647505f, -0.762049f, 0.00438100f, 
		-0.647414f, 0.306424f, -0.697825f, -0.646855f, 0.521816f, -0.556136f, 
		-0.646529f, 0.671479f, 0.362099f, -0.646336f, 0.490810f, 0.584256f, 
		-0.645881f, 0.114986f, -0.754729f, -0.645856f, 0.457122f, -0.611481f, 
		-0.645856f, -0.517428f, 0.561372f, -0.645817f, -0.285692f, -0.708026f, 
		-0.645304f, -0.367838f, 0.669536f, -0.644834f, -0.221348f, -0.731570f, 
		-0.644323f, 0.0617166f, -0.762259f, -0.643207f, 0.530854f, 0.551795f, 
		-0.643026f, 0.579475f, 0.500725f, -0.642892f, 0.461150f, -0.611581f, 
		-0.641510f, 0.326608f, -0.694113f, -0.641307f, -0.0305637f, -0.766676f, 
		-0.640618f, 0.165687f, 0.749771f, -0.640562f, -0.555230f, -0.530472f, 
		-0.640494f, -0.523730f, -0.561671f, -0.639816f, 0.115340f, -0.759824f, 
		-0.639776f, 0.445601f, -0.626200f, -0.639407f, -0.746122f, 0.185635f, 
		-0.639325f, 0.719367f, 0.271614f, -0.639225f, 0.472730f, -0.606562f, 
		-0.639138f, 0.617293f, 0.458750f, -0.638292f, -0.722262f, 0.266310f, 
		-0.638207f, 0.768633f, 0.0435286f, -0.638196f, -0.365443f, 0.677611f, 
		-0.637512f, -0.201701f, -0.743569f, -0.637451f, -0.418515f, -0.646917f, 
		-0.637388f, 0.717189f, 0.281740f, -0.636653f, -0.657797f, -0.402462f, 
		-0.635783f, 0.394152f, -0.663644f, -0.635737f, 0.732101f, 0.244678f, 
		-0.635530f, 0.339292f, -0.693529f, -0.634624f, 0.765218f, -0.108138f, 
		-0.634563f, -0.0589727f, -0.770618f, -0.634424f, 0.750676f, -0.184366f, 
		-0.633850f, 0.277816f, -0.721840f, -0.633592f, 0.773088f, -0.0299367f, 
		-0.633579f, 0.353461f, 0.688218f, -0.633520f, 0.272996f, -0.723965f, 
		-0.633413f, 0.633201f, -0.444797f, -0.633403f, 0.400723f, 0.661983f, 
		-0.633391f, 0.766821f, 0.103924f, -0.633274f, 0.697628f, -0.335081f, 
		-0.632610f, -0.491374f, -0.598628f, -0.632215f, 0.322416f, -0.704523f, 
		-0.631799f, -0.445649f, 0.634213f, -0.631763f, 0.386292f, -0.672052f, 
		-0.631330f, 0.287542f, 0.720237f, -0.631016f, 0.240449f, 0.737565f, 
		-0.630894f, 0.124294f, -0.765849f, -0.630527f, 0.675798f, -0.381750f, 
		-0.630260f, 0.768980f, -0.106967f, -0.630085f, 0.194336f, -0.751815f, 
		-0.629929f, -0.557315f, -0.540916f, -0.629890f, 0.448920f, -0.633805f, 
		-0.629838f, 0.489570f, -0.603013f, -0.629446f, 0.523002f, 0.574688f, 
		-0.629142f, 0.250875f, 0.735692f, -0.628918f, 0.666072f, -0.401011f, 
		-0.628561f, 0.194674f, 0.753002f, -0.628544f, 0.549002f, 0.550935f, 
		-0.627653f, 0.311157f, -0.713606f, -0.627474f, 0.666176f, -0.403095f, 
		-0.627336f, -0.582542f, -0.516812f, -0.627158f, 0.593774f, -0.504089f, 
		-0.626877f, 0.560738f, -0.540924f, -0.626610f, -0.755741f, 0.190302f, 
		-0.626601f, -0.518828f, -0.581539f, -0.626406f, 0.556364f, -0.545962f, 
		-0.626063f, -0.490926f, 0.605835f, -0.625873f, 0.207724f, -0.751754f, 
		-0.625834f, -0.761865f, -0.167017f, -0.625623f, 0.489610f, 0.607353f, 
		-0.625598f, 0.0832482f, 0.775691f, -0.625026f, 0.301296f, -0.720113f, 
		-0.624127f, 0.327654f, -0.709302f, -0.624086f, 0.577874f, 0.525906f, 
		-0.623842f, 0.550298f, -0.554971f, -0.623662f, 0.770549f, -0.131525f, 
		-0.623623f, 0.547053f, 0.558415f, -0.623404f, 0.388749f, 0.678411f, 
		-0.623356f, 0.773362f, -0.115494f, -0.622977f, -0.573508f, -0.531966f, 
		-0.622903f, 0.388106f, -0.679239f, -0.622880f, -0.658827f, -0.421863f, 
		-0.622526f, 0.781244f, -0.0460312f, -0.622216f, 0.386235f, 0.680933f, 
		-0.622206f, 0.706430f, 0.337368f, -0.621573f, 0.360823f, -0.695309f, 
		-0.621275f, 0.331405f, -0.710062f, -0.621247f, 0.331288f, 0.710141f, 
		-0.621121f, 0.681241f, 0.387451f, -0.621073f, 0.322951f, 0.714122f, 
		-0.621061f, 0.0643614f, 0.781115f, -0.620998f, 0.670926f, -0.405241f, 
		-0.620240f, 0.375506f, -0.688693f, -0.620133f, 0.0638869f, -0.781891f, 
		-0.620114f, -0.171267f, -0.765589f, -0.620074f, 0.767341f, 0.163388f, 
		-0.619481f, 0.313907f, 0.719517f, -0.618742f, 0.785452f, 0.0149611f, 
		-0.618410f, 0.0481183f, 0.784381f, -0.618044f, 0.783417f, -0.0654108f, 
		-0.617830f, 0.769713f, -0.160713f, -0.617436f, 0.785272f, -0.0460579f, 
		-0.617376f, 0.280904f, 0.734805f, -0.617065f, 0.681668f, -0.393142f, 
		-0.616706f, 0.600754f, -0.508692f, -0.616450f, 0.637385f, -0.462308f, 
		-0.616065f, 0.476604f, -0.627146f, -0.615904f, 0.00137912f, 0.787820f, 
		-0.615790f, -0.567324f, -0.546760f, -0.615765f, -0.776556f, -0.133397f, 
		-0.615340f, -0.310237f, -0.724644f, -0.615294f, 0.203140f, -0.761674f, 
		-0.615209f, 0.516527f, 0.595582f, -0.614886f, 0.738114f, 0.277672f, 
		-0.614387f, 0.523924f, 0.589943f, -0.614296f, 0.0462992f, -0.787716f, 
		-0.614089f, 0.737410f, 0.281285f, -0.613904f, 0.226482f, -0.756193f, 
		-0.613217f, 0.608912f, -0.503181f, -0.613147f, 0.587057f, -0.528598f, 
		-0.612877f, 0.762681f, -0.206639f, -0.612736f, -0.309432f, 0.727190f, 
		-0.612181f, 0.300895f, 0.731229f, -0.612108f, 0.315300f, -0.725197f, 
		-0.610761f, -0.748535f, 0.258199f, -0.610760f, 0.367094f, 0.701580f, 
		-0.610349f, 0.684659f, -0.398392f, -0.610130f, 0.710641f, 0.350330f, 
		-0.610045f, 0.542169f, 0.577839f, -0.609695f, 0.727940f, -0.313649f, 
		-0.609616f, 0.367802f, 0.702204f, -0.609428f, -0.664312f, -0.432767f, 
		-0.608826f, 0.793289f, -0.00484979f, -0.608585f, 0.262331f, -0.748871f, 
		-0.607993f, 0.764302f, -0.214911f, -0.607628f, -0.579636f, 0.542964f, 
		-0.607300f, 0.575085f, 0.548145f, -0.607016f, 0.663384f, 0.437554f, 
		-0.607005f, 0.271124f, 0.747018f, -0.606939f, -0.734452f, 0.303653f, 
		-0.606839f, 0.366097f, -0.705492f, -0.606450f, -0.560502f, 0.563964f, 
		-0.606145f, 0.178387f, -0.775092f, -0.604966f, 0.0535977f, -0.794446f, 
		-0.604560f, -0.227157f, -0.763483f, -0.604517f, 0.553228f, 0.573148f, 
		-0.603780f, 0.128295f, 0.786759f, -0.603596f, 0.731203f, -0.317827f, 
		-0.603513f, 0.721502f, 0.339421f, -0.603491f, 0.796039f, -0.0460446f, 
		-0.603075f, 0.345011f, -0.719213f, -0.602939f, 0.453029f, -0.656680f, 
		-0.602816f, 0.733195f, -0.314703f, -0.602753f, -0.669522f, -0.434084f, 
		-0.602517f, -0.474280f, -0.641896f, -0.601529f, -0.439414f, 0.667142f, 
		-0.601280f, -0.511730f, 0.613673f, -0.601092f, 0.508303f, 0.616698f, 
		-0.600913f, -0.561680f, 0.568700f, -0.600579f, -0.605291f, 0.522425f, 
		-0.600578f, 0.225209f, -0.767194f, -0.600419f, 0.464683f, 0.650820f, 
		-0.600263f, 0.793550f, -0.0998100f, -0.599969f, 0.205477f, -0.773186f, 
		-0.599877f, 0.554339f, 0.576936f, -0.599855f, 0.554320f, 0.576977f, 
		-0.599372f, 0.795843f, 0.0859496f, -0.599309f, 0.468721f, -0.648945f, 
		-0.599086f, 0.429283f, -0.675878f, -0.598967f, 0.642095f, -0.478489f, 
		-0.598625f, 0.534159f, -0.596928f, -0.598597f, -0.357927f, -0.716638f, 
		-0.598567f, -0.515821f, -0.612900f, -0.598278f, 0.532914f, -0.598385f, 
		-0.598018f, 0.787872f, 0.147082f, -0.597966f, -0.0589330f, 0.799352f, 
		-0.597114f, -0.624718f, 0.503172f, -0.596960f, -0.754452f, 0.272838f, 
		-0.595916f, -0.629380f, -0.498764f, -0.595837f, 0.727275f, 0.340660f, 
		-0.595681f, -0.206685f, -0.776173f, -0.595675f, 0.594282f, 0.540370f, 
		-0.595491f, -0.253680f, -0.762257f, -0.595342f, 0.743254f, -0.305190f, 
		-0.594447f, -0.574052f, 0.563114f, -0.593978f, 0.573982f, 0.563679f, 
		-0.593969f, 0.163133f, -0.787775f, -0.593777f, 0.184497f, -0.783192f, 
		-0.593444f, 0.208891f, 0.777296f, -0.593128f, -0.706815f, 0.385502f, 
		-0.593122f, 0.387038f, -0.705980f, -0.592341f, 0.127121f, 0.795595f, 
		-0.592143f, 0.735328f, 0.329636f, -0.591886f, 0.462356f, 0.660226f, 
		-0.591660f, 0.590213f, 0.549169f, -0.591184f, 0.263701f, -0.762210f, 
		-0.590997f, -0.171257f, 0.788285f, -0.590992f, 0.757532f, -0.277261f, 
		-0.590879f, 0.688592f, -0.420360f, -0.590691f, -0.0965228f, 0.801104f, 
		-0.590516f, 0.298476f, -0.749802f, -0.590504f, 0.786927f, -0.179025f, 
		-0.590480f, 0.786944f, -0.179032f, -0.590372f, 0.732740f, 0.338456f, 
		-0.590317f, 0.679090f, -0.436306f, -0.589849f, -0.573884f, -0.568098f, 
		-0.589829f, 0.457933f, -0.665131f, -0.589745f, 0.304097f, 0.748148f, 
		-0.589389f, -0.663289f, -0.461160f, -0.589189f, 0.0567208f, -0.806002f, 
		-0.588910f, -0.396556f, -0.704222f, -0.588725f, 0.806743f, 0.0506934f, 
		-0.588579f, 0.782749f, 0.202185f, -0.588027f, 0.338645f, 0.734537f, 
		-0.587913f, 0.626994f, 0.511113f, -0.587709f, 0.404187f, -0.700879f, 
		-0.587563f, -0.773736f, -0.236858f, -0.587362f, 0.787322f, -0.187432f, 
		-0.587303f, 0.334882f, 0.736837f, -0.587214f, -0.765078f, 0.264263f, 
		-0.587019f, 0.649757f, 0.482933f, -0.586934f, -0.771206f, 0.246476f, 
		-0.586663f, 0.689626f, 0.424548f, -0.586642f, -0.314522f, 0.746275f, 
		-0.586278f, 0.640356f, 0.496208f, -0.586221f, 0.785631f, 0.197811f, 
		-0.585693f, -0.608926f, 0.534951f, -0.585376f, 0.539466f, 0.605236f, 
		-0.585169f, -0.502772f, 0.636237f, -0.585099f, 0.270474f, -0.764528f, 
		-0.584874f, 0.606157f, 0.538977f, -0.584656f, -0.523880f, -0.619457f, 
		-0.584472f, -0.640999f, -0.497506f, -0.584321f, -0.353955f, 0.730263f, 
		-0.584223f, -0.567659f, -0.580040f, -0.583936f, -0.366931f, -0.724141f, 
		-0.583842f, 0.646477f, -0.491117f, -0.583170f, 0.0193284f, 0.812120f, 
		-0.582740f, -0.782965f, -0.217670f, -0.582604f, 0.276885f, 0.764138f, 
		-0.581915f, 0.520782f, 0.624629f, -0.581859f, 0.620830f, -0.525367f, 
		-0.580674f, -0.691935f, -0.429003f, -0.580425f, 0.159213f, 0.798598f, 
		-0.580404f, -0.347570f, 0.736428f, -0.580046f, 0.255695f, 0.773412f, 
		-0.580004f, 0.0810814f, 0.810569f, -0.579882f, -0.321198f, 0.748712f, 
		-0.579780f, 0.122640f, -0.805490f, -0.579734f, 0.412972f, -0.702398f, 
		-0.578739f, -0.764035f, 0.285152f, -0.578717f, -0.545801f, 0.605960f, 
		-0.578611f, 0.0328601f, 0.814941f, -0.578350f, 0.398561f, 0.711801f, 
		-0.578253f, 0.399151f, -0.711549f, -0.577973f, 0.551203f, -0.601767f, 
		-0.577796f, -0.786201f, -0.219179f, -0.577545f, 0.675379f, 0.458589f, 
		-0.577352f, 0.803307f, 0.146161f, -0.576950f, -0.639508f, -0.508093f, 
		-0.576746f, 0.748679f, 0.326870f, -0.576714f, 0.148490f, -0.803338f, 
		-0.576287f, 0.413203f, -0.705093f, -0.575981f, 0.750012f, -0.325157f, 
		-0.575311f, 0.688339f, -0.441822f, -0.575074f, 0.681329f, 0.452858f, 
		-0.574926f, 0.377664f, -0.725830f, -0.574746f, 0.259229f, 0.776188f, 
		-0.574366f, -0.788168f, -0.221123f, -0.574241f, -0.521712f, -0.630923f, 
		-0.574100f, -0.564072f, -0.593492f, -0.573982f, 0.443564f, -0.688328f, 
		-0.573777f, 0.401274f, -0.713974f, -0.573485f, 0.634138f, -0.518637f, 
		-0.573275f, 0.564230f, 0.594138f, -0.573205f, 0.272792f, 0.772671f, 
		-0.572886f, 0.784211f, 0.238360f, -0.572408f, -0.251315f, -0.780506f, 
		-0.572397f, 0.811733f, 0.115979f, -0.572215f, 0.556321f, 0.602558f, 
		-0.572210f, 0.501729f, 0.648724f, -0.572126f, 0.819986f, -0.0171462f, 
		-0.571969f, 0.403042f, 0.714429f, -0.571711f, -0.789822f, -0.222098f, 
		-0.571683f, 0.0867544f, -0.815875f, -0.571673f, -0.475462f, 0.668675f, 
		-0.571469f, 0.759570f, -0.310607f, -0.571256f, -0.542339f, -0.616065f, 
		-0.570635f, -0.793755f, -0.210542f, -0.570476f, 0.820287f, 0.0410753f, 
		-0.570351f, 0.397300f, -0.718924f, -0.570344f, 0.797882f, 0.195170f, 
		-0.570274f, -0.741124f, -0.354291f, -0.569855f, -0.473959f, -0.671288f, 
		-0.569344f, 0.677493f, 0.465673f, -0.568876f, 0.407357f, -0.714451f, 
		-0.568767f, -0.496272f, 0.655910f, -0.568666f, 0.744512f, 0.349744f, 
		-0.568559f, 0.315206f, 0.759859f, -0.568494f, 0.00207044f, 0.822685f, 
		-0.568304f, 0.692141f, -0.444939f, -0.568134f, 0.568333f, 0.595165f, 
		-0.567975f, 0.492221f, 0.659638f, -0.567911f, 0.740356f, -0.359653f, 
		-0.567883f, 0.157570f, -0.807886f, -0.567812f, 0.708189f, -0.419593f, 
		-0.567500f, 0.110731f, -0.815894f, -0.567272f, 0.390592f, -0.725011f, 
		-0.566749f, 0.392627f, 0.724320f, -0.565934f, 0.153835f, 0.809972f, 
		-0.565781f, 0.533871f, 0.628390f, -0.565739f, 0.578779f, 0.587329f, 
		-0.565016f, 0.372039f, 0.736440f, -0.564824f, 0.302677f, -0.767698f, 
		-0.564780f, 0.722613f, 0.398566f, -0.564063f, 0.764869f, -0.311140f, 
		-0.563630f, 0.662946f, -0.492772f, -0.563432f, -0.561958f, 0.605597f, 
		-0.563421f, 0.708688f, -0.424638f, -0.563343f, 0.551720f, -0.615020f, 
		-0.563325f, 0.272772f, -0.779910f, -0.563129f, -0.368428f, 0.739694f, 
		-0.562508f, 0.670319f, -0.484001f, -0.561528f, -0.409331f, 0.719121f, 
		-0.561383f, 0.571982f, -0.598068f, -0.561268f, 0.742350f, -0.365916f, 
		-0.561231f, 0.486103f, -0.669868f, -0.561101f, 0.537983f, -0.629078f, 
		-0.561044f, 0.397921f, -0.725871f, -0.561017f, 0.357165f, 0.746789f, 
		-0.560936f, 0.241214f, -0.791939f, -0.560699f, 0.309044f, 0.768185f, 
		-0.560461f, 0.0934611f, 0.822890f, -0.560329f, -0.822755f, -0.0954241f, 
		-0.560199f, 0.527114f, -0.639005f, -0.560051f, 0.320641f, 0.763893f, 
		-0.559286f, 0.362061f, -0.745728f, -0.559210f, 0.391440f, 0.730793f, 
		-0.558150f, -0.643383f, 0.523953f, -0.557890f, 0.249708f, -0.791457f, 
		-0.557610f, 0.635283f, 0.534310f, -0.557519f, 0.0337098f, -0.829480f, 
		-0.557390f, 0.230974f, -0.797476f, -0.556986f, 0.419222f, -0.716952f, 
		-0.556902f, -0.699987f, 0.447078f, -0.556898f, 0.829396f, -0.0443524f, 
		-0.556864f, -0.723169f, -0.408570f, -0.556363f, 0.720766f, -0.413469f, 
		-0.556286f, -0.485106f, 0.674699f, -0.556199f, 0.711411f, -0.429578f, 
		-0.556154f, 0.0483792f, -0.829670f, -0.555618f, -0.298352f, 0.776064f, 
		-0.555406f, -0.139552f, -0.819786f, -0.555275f, 0.622323f, -0.551709f, 
		-0.554720f, -0.656186f, -0.511572f, -0.554457f, -0.00170346f, 0.832211f, 
		-0.554284f, 0.756806f, 0.346430f, -0.554212f, -0.529901f, 0.641914f, 
		-0.553909f, -0.784453f, 0.278958f, -0.553027f, 0.822164f, 0.134934f, 
		-0.552934f, 0.359107f, -0.751869f, -0.552701f, 0.427697f, -0.715260f, 
		-0.552517f, 0.381079f, -0.741285f, -0.552317f, 0.520106f, -0.651487f, 
		-0.552290f, -0.214035f, -0.805707f, -0.551192f, -0.0480428f, -0.832994f, 
		-0.550911f, 0.371414f, -0.747361f, -0.550469f, 0.826799f, 0.115704f, 
		-0.550459f, 0.130433f, -0.824610f, -0.550026f, 0.745515f, -0.376402f, 
		-0.549847f, 0.591803f, -0.589438f, -0.549783f, 0.222808f, 0.805044f, 
		-0.549613f, -0.376234f, -0.745905f, -0.549572f, 0.591093f, -0.590406f, 
		-0.549443f, -0.00830066f, 0.835490f, -0.549342f, 0.501243f, 0.668565f, 
		-0.548932f, -0.143309f, 0.823490f, -0.548697f, 0.431438f, 0.716096f, 
		-0.548639f, 0.152655f, 0.822005f, -0.547719f, 0.548375f, -0.631893f, 
		-0.547638f, 0.653521f, 0.522497f, -0.547606f, 0.180633f, -0.817006f, 
		-0.547405f, 0.623635f, 0.558056f, -0.547385f, -0.486384f, -0.681028f, 
		-0.547166f, 0.787903f, -0.282520f, -0.546918f, 0.132919f, 0.826567f, 
		-0.546443f, 0.725915f, 0.417669f, -0.546368f, 0.392473f, 0.739897f, 
		-0.546265f, -0.809821f, -0.213973f, -0.546159f, 0.333854f, 0.768279f, 
		-0.545893f, 0.816267f, -0.188970f, -0.545838f, 0.0437616f, 0.836747f, 
		-0.545716f, 0.624100f, 0.559191f, -0.545683f, 0.500721f, 0.671944f, 
		-0.545540f, 0.563263f, 0.620581f, -0.545179f, -0.662658f, 0.513483f, 
		-0.544919f, -0.575298f, 0.609996f, -0.544602f, 0.781084f, -0.305478f, 
		-0.544551f, 0.724716f, -0.422197f, -0.544493f, 0.648690f, 0.531721f, 
		-0.544484f, 0.310044f, -0.779365f, -0.544359f, -0.297180f, 0.784447f, 
		-0.544301f, -0.435080f, -0.717246f, -0.544216f, 0.724447f, -0.423091f, 
		-0.544010f, 0.525863f, 0.653851f, -0.543967f, 0.664037f, 0.512986f, 
		-0.543201f, -0.838049f, 0.0510493f, -0.543161f, 0.341748f, 0.766932f, 
		-0.543038f, -0.517745f, 0.661098f, -0.542797f, -0.817048f, -0.194431f, 
		-0.542651f, -0.518452f, 0.660862f, -0.542491f, -0.620051f, 0.566781f, 
		-0.542472f, 0.508794f, -0.668470f, -0.542414f, 0.668914f, 0.508272f, 
		-0.542335f, 0.0824147f, -0.836111f, -0.542243f, 0.821751f, -0.175208f, 
		-0.541983f, -0.435425f, 0.718790f, -0.541971f, 0.311469f, 0.780548f, 
		-0.541967f, 0.658874f, 0.521687f, -0.541812f, 0.759868f, 0.359222f, 
		-0.541335f, 0.821558f, 0.178882f, -0.541219f, -0.829938f, -0.135222f, 
		-0.540895f, -0.473523f, -0.695132f, -0.540757f, -0.0531827f, 0.839496f, 
		-0.539693f, 0.716135f, -0.442587f, -0.539452f, 0.352466f, 0.764696f, 
		-0.539303f, 0.393157f, -0.744701f, -0.538945f, 0.595025f, -0.596224f, 
		-0.538777f, 0.550745f, 0.637495f, -0.537331f, 0.105418f, 0.836757f, 
		-0.537085f, 0.839972f, -0.0773775f, -0.536996f, 0.395434f, -0.745162f, 
		-0.536873f, -0.220984f, -0.814208f, -0.536473f, 0.305428f, -0.786709f, 
		-0.535620f, 0.543097f, -0.646651f, -0.535595f, -0.723121f, 0.436159f, 
		-0.534919f, -0.596243f, -0.598629f, -0.534766f, 0.343960f, 0.771827f, 
		-0.534654f, 0.773027f, -0.341431f, -0.534412f, 0.547286f, -0.644113f, 
		-0.534392f, 0.430041f, -0.727661f, -0.534349f, 0.0993814f, -0.839401f, 
		-0.534302f, 0.0994012f, -0.839429f, -0.534213f, 0.685670f, -0.494442f, 
		-0.534002f, 0.721291f, 0.441113f, -0.533982f, 0.0219769f, -0.845210f, 
		-0.533941f, 0.737018f, -0.414382f, -0.533866f, 0.724174f, -0.436530f, 
		-0.532700f, 0.822425f, -0.199618f, -0.532569f, 0.737512f, -0.415267f, 
		-0.532420f, 0.799875f, 0.277001f, -0.532160f, 0.801958f, 0.271421f, 
		-0.532108f, 0.841177f, -0.0963423f, -0.532073f, 0.532124f, 0.658591f, 
		-0.531994f, 0.820495f, -0.209215f, -0.531840f, 0.744465f, 0.403630f, 
		-0.531794f, -0.753269f, 0.387016f, -0.531742f, -0.588288f, -0.609236f, 
		-0.531622f, 0.295961f, 0.793590f, -0.531595f, 0.288424f, 0.796378f, 
		-0.531439f, 0.449052f, -0.718279f, -0.531437f, -0.847087f, 0.00436774f, 
		-0.530935f, -0.727846f, -0.433991f, -0.530485f, 0.653283f, 0.540192f, 
		-0.530095f, 0.816036f, -0.230402f, -0.528906f, 0.845860f, 0.0691389f, 
		-0.528363f, -0.184986f, 0.828621f, -0.528274f, 0.766732f, -0.364759f, 
		-0.528088f, 0.777055f, 0.342504f, -0.528039f, 0.695286f, 0.487598f, 
		-0.527892f, -0.214231f, 0.821848f, -0.527684f, -0.686275f, 0.500576f, 
		-0.527412f, 0.514383f, 0.676200f, -0.527172f, 0.842890f, 0.107823f, 
		-0.526885f, 0.398822f, -0.750556f, -0.526316f, -0.354905f, -0.772680f, 
		-0.525645f, -0.454084f, 0.719378f, -0.525382f, 0.699652f, -0.484211f, 
		-0.524651f, -0.591234f, -0.612522f, -0.523327f, 0.739502f, 0.423397f, 
		-0.522971f, -0.617856f, -0.587159f, -0.522267f, 0.832987f, 0.182675f, 
		-0.522258f, 0.502523f, 0.688997f, -0.521719f, -0.605290f, -0.601194f, 
		-0.521051f, -0.560372f, 0.643808f, -0.520869f, -0.423577f, -0.741133f, 
		-0.520613f, 0.144887f, 0.841410f, -0.520469f, -0.327468f, 0.788591f, 
		-0.520249f, 0.558846f, 0.645780f, -0.520106f, 0.819201f, 0.241661f, 
		-0.519936f, 0.524479f, -0.674232f, -0.519652f, -0.126574f, -0.844950f, 
		-0.519341f, -0.369075f, -0.770758f, -0.519191f, -0.110174f, 0.847527f, 
		-0.519173f, 0.0406148f, -0.853703f, -0.518256f, -0.0459182f, -0.853992f, 
		-0.518255f, 0.788872f, 0.330292f, -0.518141f, 0.835539f, 0.182767f, 
		-0.518019f, 0.703042f, -0.487226f, -0.517867f, -0.726655f, -0.451427f, 
		-0.517214f, 0.342906f, 0.784159f, -0.517002f, 0.565400f, -0.642676f, 
		-0.516986f, 0.742599f, 0.425761f, -0.516871f, 0.436062f, -0.736678f, 
		-0.516702f, 0.595031f, -0.615594f, -0.516504f, 0.380199f, -0.767250f, 
		-0.516499f, 0.130145f, 0.846340f, -0.515791f, 0.695929f, -0.499642f, 
		-0.515529f, -0.762452f, -0.391021f, -0.514309f, -0.730011f, 0.450078f, 
		-0.514113f, 0.745262f, 0.424585f, -0.514047f, 0.776194f, 0.365074f, 
		-0.513810f, 0.752344f, 0.412283f, -0.513724f, 0.375221f, 0.771555f, 
		-0.513559f, -0.799046f, 0.312702f, -0.513230f, 0.369518f, 0.774630f, 
		-0.512434f, 0.323900f, -0.795299f, -0.511971f, 0.521699f, 0.682434f, 
		-0.511949f, -0.694352f, 0.505750f, -0.511935f, -0.255656f, 0.820099f, 
		-0.511533f, -0.483839f, -0.710094f, -0.510275f, 0.768840f, -0.385363f, 
		-0.509676f, 0.702947f, 0.496080f, -0.509665f, 0.482320f, -0.712467f, 
		-0.509133f, -0.350853f, 0.785930f, -0.508968f, -0.664306f, 0.547402f, 
		-0.508879f, 0.553562f, -0.659251f, -0.508592f, 0.309807f, 0.803340f, 
		-0.508562f, 0.729135f, 0.457960f, -0.507532f, -0.0842298f, 0.857506f, 
		-0.506986f, 0.565255f, -0.650732f, -0.506763f, -0.140851f, 0.850501f, 
		-0.506757f, 0.861845f, -0.0205046f, -0.506476f, 0.453290f, -0.733492f, 
		-0.506343f, 0.570621f, -0.646535f, -0.506160f, 0.253944f, 0.824206f, 
		-0.505605f, 0.859295f, 0.0773017f, -0.504803f, 0.0153495f, 0.863098f, 
		-0.504565f, 0.0166815f, 0.863212f, -0.504399f, 0.450502f, -0.736634f, 
		-0.504039f, 0.852695f, 0.137317f, -0.503853f, 0.0430494f, -0.862716f, 
		-0.503733f, 0.735396f, -0.453262f, -0.503021f, -0.157531f, 0.849796f, 
		-0.502595f, 0.761353f, -0.409560f, -0.502025f, 0.323131f, -0.802220f, 
		-0.502000f, 0.832742f, -0.233530f, -0.501853f, -0.762126f, 0.409033f, 
		-0.501829f, 0.354001f, -0.789209f, -0.501579f, 0.753982f, 0.424181f, 
		-0.500675f, 0.0191352f, 0.865424f, -0.500268f, 0.803232f, -0.323342f, 
		-0.499259f, 0.377982f, 0.779660f, -0.499153f, 0.862036f, 0.0879781f, 
		-0.498607f, -0.469143f, 0.728901f, -0.498236f, -0.679372f, 0.538715f, 
		-0.498106f, -0.0631448f, 0.864814f, -0.497846f, -0.393608f, 0.772802f, 
		-0.497404f, -0.692154f, 0.522984f, -0.497272f, -0.301146f, -0.813653f, 
		-0.496735f, -0.109986f, 0.860905f, -0.496641f, 0.847825f, 0.185851f, 
		-0.496542f, 0.541338f, 0.678527f, -0.496490f, 0.783617f, -0.373420f, 
		-0.495592f, -0.304583f, 0.813399f, -0.495387f, -0.0459261f, -0.867457f, 
		-0.495381f, -0.0460211f, -0.867456f, -0.495309f, 0.834234f, -0.242329f, 
		-0.494783f, 0.394572f, -0.774275f, -0.494654f, 0.202354f, 0.845204f, 
		-0.494244f, -0.420636f, -0.760781f, -0.494062f, 0.218488f, 0.841526f, 
		-0.493688f, -0.366239f, 0.788759f, -0.493596f, 0.501081f, 0.710831f, 
		-0.493438f, 0.251906f, -0.832503f, -0.493251f, 0.829157f, 0.263062f, 
		-0.493185f, 0.616158f, -0.614099f, -0.493103f, 0.808306f, 0.321700f, 
		-0.492435f, 0.179903f, 0.851553f, -0.492362f, -0.645431f, 0.583951f, 
		-0.492060f, 0.209922f, -0.844873f, -0.491926f, -0.857103f, 0.152918f, 
		-0.491299f, -0.374134f, 0.786542f, -0.491110f, 0.359607f, -0.793407f, 
		-0.491093f, -0.500508f, 0.712965f, -0.491069f, -0.500528f, 0.712968f, 
		-0.490679f, 0.797275f, -0.351548f, -0.490422f, -0.730349f, -0.475475f, 
		-0.490353f, -0.485819f, -0.723556f, -0.490349f, 0.855249f, 0.167650f, 
		-0.490215f, 0.363148f, 0.792346f, -0.490160f, 0.511492f, 0.705775f, 
		-0.488592f, -0.850901f, -0.192993f, -0.488580f, 0.244691f, -0.837506f, 
		-0.488023f, 0.511152f, -0.707501f, -0.487713f, -0.854724f, 0.177717f, 
		-0.487656f, -0.191109f, -0.851862f, -0.487509f, 0.738984f, -0.465013f, 
		-0.487190f, 0.468820f, -0.736786f, -0.487098f, -0.633191f, -0.601502f, 
		-0.486707f, 0.831726f, 0.267111f, -0.486311f, 0.533206f, 0.692238f, 
		-0.486260f, 0.214193f, -0.847155f, -0.486238f, -0.873729f, 0.0130287f, 
		-0.485926f, 0.496207f, 0.719482f, -0.485918f, -0.872181f, -0.0564213f, 
		-0.485852f, -0.137929f, 0.863089f, -0.485803f, -0.393913f, 0.780274f, 
		-0.485120f, -0.765871f, -0.422020f, -0.484660f, 0.561914f, 0.670342f, 
		-0.484609f, -0.471307f, 0.736901f, -0.484459f, 0.415975f, -0.769587f, 
		-0.484434f, 0.798019f, -0.358454f, -0.484184f, -0.257508f, -0.836215f, 
		-0.484025f, 0.0213669f, -0.874793f, -0.483650f, -0.0881338f, 0.870813f, 
		-0.483599f, 0.712130f, 0.508922f, -0.483575f, 0.356309f, 0.799499f, 
		-0.483432f, 0.406416f, -0.775319f, -0.483213f, 0.774824f, -0.407618f, 
		-0.483140f, 0.631127f, -0.606839f, -0.483022f, 0.511614f, 0.710592f, 
		-0.482950f, 0.505581f, 0.714946f, -0.482599f, -0.479577f, 0.732874f, 
		-0.482478f, 0.134487f, 0.865522f, -0.481548f, -0.747162f, -0.458105f, 
		-0.481372f, -0.287208f, 0.828126f, -0.480918f, 0.119220f, 0.868622f, 
		-0.480427f, -0.747080f, -0.459414f, -0.479388f, -0.858292f, -0.183090f, 
		-0.479121f, 0.695993f, -0.534824f, -0.478654f, -0.853950f, 0.204107f, 
		-0.478448f, 0.559396f, -0.676877f, -0.478076f, -0.331603f, -0.813316f, 
		-0.477666f, -0.148525f, -0.865896f, -0.476957f, 0.312655f, 0.821437f, 
		-0.476795f, -0.842011f, 0.252356f, -0.476755f, 0.810706f, 0.339794f, 
		-0.476747f, -0.186717f, 0.858982f, -0.476674f, 0.0919768f, 0.874255f, 
		-0.476139f, 0.829129f, -0.292980f, -0.476031f, -0.685137f, -0.551345f, 
		-0.476025f, -0.878113f, 0.0481404f, -0.475657f, -0.853714f, -0.211949f, 
		-0.475596f, 0.528198f, 0.703431f, -0.475532f, 0.581926f, -0.659721f, 
		-0.474970f, -0.195661f, -0.857975f, -0.474900f, 0.384720f, -0.791492f, 
		-0.474782f, -0.412609f, -0.777391f, -0.474756f, -0.412362f, -0.777537f, 
		-0.474719f, 0.0943875f, -0.875062f, -0.474392f, 0.764117f, -0.437124f, 
		-0.474282f, 0.876275f, 0.0848441f, -0.474151f, -0.853573f, -0.215856f, 
		-0.473481f, -0.390681f, -0.789420f, -0.473245f, 0.303055f, 0.827162f, 
		-0.473101f, -0.358026f, -0.804980f, -0.473048f, 0.741961f, 0.475100f, 
		-0.472929f, -0.482177f, -0.737458f, -0.472887f, 0.122244f, 0.872602f, 
		-0.472644f, 0.216144f, 0.854336f, -0.472419f, 0.00478295f, -0.881361f, 
		-0.472382f, 0.877635f, 0.0813146f, -0.471994f, 0.357690f, 0.805779f, 
		-0.471794f, 0.847179f, -0.244332f, -0.471659f, 0.874009f, 0.116814f, 
		-0.471620f, -0.880482f, -0.0482274f, -0.471595f, 0.611488f, -0.635359f, 
		-0.471418f, 0.106284f, 0.875482f, -0.470933f, -0.876896f, -0.0963134f, 
		-0.470898f, -0.731894f, -0.492531f, -0.470408f, 0.235784f, 0.850366f, 
		-0.470230f, 0.390375f, -0.791512f, -0.470077f, -0.213088f, 0.856517f, 
		-0.469832f, 0.609223f, -0.638831f, -0.469621f, 0.282798f, -0.836350f, 
		-0.469154f, 0.464948f, -0.750811f, -0.469065f, 0.611089f, -0.637611f, 
		-0.468346f, 0.878637f, 0.0929973f, -0.468117f, -0.328955f, 0.820156f, 
		-0.467757f, 0.786565f, -0.403136f, -0.467593f, 0.263094f, 0.843883f, 
		-0.467327f, 0.265133f, -0.843392f, -0.467282f, -0.751120f, -0.466333f, 
		-0.466960f, -0.376218f, -0.800255f, -0.466940f, 0.360777f, -0.807346f, 
		-0.466858f, 0.442255f, -0.765803f, -0.466710f, -0.755743f, -0.459385f, 
		-0.466610f, -0.852641f, 0.235112f, -0.466397f, 0.311626f, -0.827866f, 
		-0.466058f, -0.813677f, 0.347447f, -0.465898f, 0.429262f, 0.773740f, 
		-0.465689f, 0.694571f, -0.548366f, -0.465443f, 0.770554f, -0.435441f, 
		-0.465367f, 0.875484f, 0.130235f, -0.464786f, 0.573945f, -0.674211f, 
		-0.464726f, -0.353131f, 0.811990f, -0.464058f, -0.492729f, 0.736117f, 
		-0.463522f, 0.0209742f, 0.885837f, -0.463512f, -0.420883f, -0.779752f, 
		-0.463224f, 0.739950f, 0.487748f, -0.463116f, 0.419602f, -0.780678f, 
		-0.462704f, -0.857471f, 0.225051f, -0.462530f, 0.656809f, 0.595540f, 
		-0.462480f, 0.320769f, -0.826571f, -0.462334f, 0.332552f, -0.821983f, 
		-0.462181f, 0.389421f, -0.796705f, -0.462004f, 0.241826f, 0.853272f, 
		-0.461716f, -0.780221f, -0.421987f, -0.461695f, 0.708275f, 0.534026f, 
		-0.461589f, 0.469259f, 0.752816f, -0.461121f, 0.589815f, 0.662937f, 
		-0.460326f, 0.810820f, 0.361483f, -0.459854f, -0.440233f, -0.771187f, 
		-0.459400f, 0.599827f, 0.655103f, -0.459360f, -0.0445980f, -0.887130f, 
		-0.459246f, 0.704863f, -0.540613f, -0.458631f, 0.296085f, 0.837849f, 
		-0.458255f, 0.853501f, -0.248068f, -0.458233f, -0.296745f, 0.837834f, 
		-0.458175f, 0.605291f, -0.650922f, -0.458156f, 0.502093f, 0.733482f, 
		-0.457980f, 0.445801f, 0.769101f, -0.457857f, 0.767145f, -0.449285f, 
		-0.457678f, 0.606003f, -0.650609f, -0.457505f, -0.132201f, 0.879325f, 
		-0.457487f, -0.877486f, 0.143959f, -0.456776f, -0.0217186f, 0.889316f, 
		-0.456749f, -0.686140f, -0.566209f, -0.456733f, -0.882382f, 0.113124f, 
		-0.456580f, -0.228132f, -0.859936f, -0.456541f, 0.351643f, -0.817262f, 
		-0.456173f, 0.790542f, 0.408595f, -0.456167f, 0.395160f, 0.797346f, 
		-0.456094f, 0.599794f, -0.657438f, -0.455925f, -0.723772f, -0.517963f, 
		-0.455795f, 0.771280f, 0.444273f, -0.455541f, -0.841976f, -0.289067f, 
		-0.455421f, 0.886641f, 0.0803712f, -0.455384f, 0.886655f, 0.0804301f, 
		-0.455106f, -0.687773f, -0.565550f, -0.454868f, 0.770004f, -0.447424f, 
		-0.454644f, -0.848506f, 0.270807f, -0.454619f, -0.782106f, -0.426182f, 
		-0.454564f, 0.448503f, -0.769556f, -0.453690f, 0.887015f, 0.0858483f, 
		-0.453680f, 0.814706f, 0.361150f, -0.453625f, 0.411139f, 0.790689f, 
		-0.453499f, 0.348428f, 0.820327f, -0.453115f, 0.407892f, 0.792661f, 
		-0.452971f, 0.122746f, -0.883035f, -0.452791f, 0.0653646f, -0.889218f, 
		-0.452215f, 0.537708f, -0.711598f, -0.452017f, 0.887118f, -0.0932898f, 
		-0.451968f, -0.605331f, -0.655209f, -0.451773f, 0.729773f, 0.513160f, 
		-0.451654f, 0.418431f, 0.787988f, -0.451522f, -0.869515f, -0.200180f, 
		-0.450954f, 0.394309f, 0.800725f, -0.450868f, 0.401312f, 0.797287f, 
		-0.450701f, 0.101470f, -0.886889f, -0.450682f, -0.855907f, -0.253593f, 
		-0.450033f, -0.383678f, -0.806388f, -0.450010f, 0.460886f, 0.764902f, 
		-0.449984f, 0.148208f, -0.880653f, -0.449878f, -0.522688f, 0.724159f, 
		-0.449781f, 0.891014f, -0.0615685f, -0.449523f, 0.422454f, 0.787059f, 
		-0.449237f, 0.181511f, 0.874780f, -0.449125f, 0.546919f, -0.706517f, 
		-0.448993f, 0.854220f, -0.262133f, -0.448874f, 0.575120f, 0.683922f, 
		-0.448594f, 0.181096f, 0.875196f, -0.448594f, -0.893004f, 0.0361520f, 
		-0.448544f, 0.734068f, -0.509855f, -0.448236f, 0.857523f, 0.252464f, 
		-0.448186f, 0.764146f, -0.463907f, -0.447992f, 0.879234f, 0.162022f, 
		-0.447566f, 0.800005f, -0.399596f, -0.447477f, 0.382442f, 0.808395f, 
		-0.447471f, 0.893882f, -0.0272888f, -0.447035f, 0.856995f, -0.256358f, 
		-0.447023f, -0.713772f, 0.539166f, -0.446741f, 0.442898f, 0.777344f, 
		-0.446550f, -0.714313f, 0.538841f, -0.446541f, -0.886727f, 0.119650f, 
		-0.446461f, 0.782351f, 0.434280f, -0.445929f, 0.285115f, 0.848443f, 
		-0.445923f, -0.392769f, -0.804292f, -0.445278f, 0.232277f, -0.864740f, 
		-0.445160f, -0.482980f, -0.754031f, -0.445101f, -0.222409f, 0.867421f, 
		-0.445013f, 0.253269f, -0.858963f, -0.444727f, 0.655884f, 0.609947f, 
		-0.444583f, 0.278986f, -0.851183f, -0.444085f, -0.00362444f, -0.895977f, 
		-0.443897f, 0.796541f, -0.410461f, -0.443743f, -0.895535f, 0.0333062f, 
		-0.443634f, 0.387135f, 0.808279f, -0.443629f, -0.497782f, -0.745256f, 
		-0.443622f, -0.236091f, -0.864558f, -0.443570f, 0.0223369f, -0.895961f, 
		-0.443352f, 0.798197f, 0.407825f, -0.443203f, 0.192800f, 0.875443f, 
		-0.442706f, 0.265663f, -0.856408f, -0.442349f, -0.537668f, 0.717802f, 
		-0.442324f, 0.598773f, -0.667698f, -0.442038f, 0.573459f, 0.689744f, 
		-0.442022f, 0.802178f, -0.401407f, -0.441968f, -0.341955f, -0.829296f, 
		-0.441917f, -0.856626f, -0.266273f, -0.441637f, 0.396493f, -0.804829f, 
		-0.441433f, -0.604971f, -0.662682f, -0.440918f, -0.687004f, 0.577596f, 
		-0.440816f, 0.801590f, -0.403899f, -0.440410f, 0.896556f, -0.0471824f, 
		-0.439926f, -0.607351f, -0.661506f, -0.439343f, 0.852584f, -0.282980f, 
		-0.439283f, 0.860014f, 0.259627f, -0.438779f, -0.398055f, -0.805621f, 
		-0.438128f, 0.873159f, -0.213629f, -0.438003f, 0.183577f, -0.880030f, 
		-0.437562f, 0.884067f, 0.164211f, -0.437529f, 0.138556f, 0.888465f, 
		-0.437256f, 0.849200f, -0.296084f, -0.436967f, 0.897708f, -0.0563866f, 
		-0.436827f, -0.893493f, 0.104177f, -0.436413f, 0.783104f, -0.443048f, 
		-0.436048f, -0.816563f, -0.378269f, -0.435885f, 0.898059f, -0.0591167f, 
		-0.435646f, 0.334471f, -0.835669f, -0.435165f, -0.500410f, -0.748479f, 
		-0.434980f, 0.664178f, -0.607996f, -0.434961f, 0.226779f, 0.871424f, 
		-0.434679f, 0.0832739f, 0.896727f, -0.434315f, -0.581078f, 0.688273f, 
		-0.433298f, -0.882975f, -0.180576f, -0.433272f, 0.261644f, -0.862449f, 
		-0.433201f, -0.841324f, 0.323283f, -0.432700f, -0.256518f, 0.864274f, 
		-0.432590f, 0.266281f, 0.861371f, -0.432553f, -0.139953f, -0.890680f, 
		-0.432370f, 0.673843f, 0.599159f, -0.432302f, -0.818682f, -0.377987f, 
		-0.431981f, 0.784179f, 0.445484f, -0.431551f, 0.400251f, -0.808432f, 
		-0.431451f, 0.900278f, 0.0578735f, -0.431400f, 0.585704f, 0.686181f, 
		-0.431374f, 0.862068f, -0.265999f, -0.431087f, 0.229638f, -0.872600f, 
		-0.431011f, 0.618645f, -0.656893f, -0.430994f, 0.760918f, -0.485024f, 
		-0.430851f, 0.593543f, -0.679760f, -0.430632f, 0.765336f, -0.478348f, 
		-0.430390f, -0.352813f, -0.830835f, -0.430316f, 0.861097f, 0.270812f, 
		-0.430199f, 0.885563f, 0.175234f, -0.430048f, 0.373803f, -0.821784f, 
		-0.429466f, 0.124936f, -0.894400f, -0.429423f, 0.852277f, 0.298696f, 
		-0.429351f, 0.179886f, -0.885042f, -0.429120f, -0.476736f, -0.767189f, 
		-0.428974f, -0.278683f, -0.859254f, -0.428639f, 0.388186f, 0.815831f, 
		-0.428470f, 0.903168f, 0.0264903f, -0.428460f, 0.253266f, -0.867340f, 
		-0.428440f, 0.568699f, 0.702154f, -0.428318f, 0.600600f, 0.675147f, 
		-0.428283f, 0.622016f, 0.655492f, -0.428211f, 0.522221f, -0.737510f, 
		-0.427722f, 0.825398f, -0.368472f, -0.427358f, 0.485396f, -0.762729f, 
		-0.426881f, 0.282214f, 0.859144f, -0.426761f, 0.817974f, -0.385737f, 
		-0.426726f, 0.812133f, -0.397925f, -0.426704f, -0.554576f, -0.714401f, 
		-0.426515f, -0.898663f, 0.102422f, -0.426224f, -0.504963f, 0.750564f, 
		-0.426082f, -0.337807f, -0.839250f, -0.425898f, -0.488690f, -0.761441f, 
		-0.425304f, -0.882032f, 0.202818f, -0.425073f, 0.764469f, -0.484664f, 
		-0.424929f, -0.407195f, -0.808472f, -0.424905f, 0.832840f, 0.354729f, 
		-0.424864f, 0.348371f, 0.835541f, -0.424752f, 0.787949f, -0.445782f, 
		-0.424515f, -0.728291f, 0.537941f, -0.424219f, -0.460417f, -0.779778f, 
		-0.424168f, -0.288261f, 0.858480f, -0.423998f, 0.788257f, 0.445956f, 
		-0.423926f, 0.681672f, -0.596330f, -0.423734f, 0.279931f, -0.861446f, 
		-0.423563f, 0.857813f, 0.291121f, -0.423040f, 0.497926f, 0.757038f, 
		-0.422956f, -0.454296f, -0.784043f, -0.422707f, 0.152884f, 0.893278f, 
		-0.422197f, 0.821585f, 0.383077f, -0.421933f, 0.409155f, -0.809052f, 
		-0.421861f, -0.890908f, -0.168274f, -0.421460f, -0.286542f, -0.860386f, 
		-0.421446f, 0.365696f, 0.829849f, -0.421279f, -0.906531f, 0.0269264f, 
		-0.421262f, -0.889636f, -0.176312f, -0.420790f, 0.765022f, 0.487521f, 
		-0.420751f, -0.0657050f, 0.904794f, -0.420475f, -0.889958f, 0.176567f, 
		-0.420469f, -0.182348f, 0.888794f, -0.420387f, -0.399316f, 0.814753f, 
		-0.420309f, 0.420517f, 0.804055f, -0.420257f, -0.904560f, -0.0717956f, 
		-0.419924f, 0.870767f, 0.255792f, -0.419882f, 0.905362f, -0.0633977f, 
		-0.419531f, 0.355866f, -0.835077f, -0.419390f, 0.334365f, 0.843986f, 
		-0.419263f, 0.312765f, 0.852289f, -0.419234f, -0.562723f, -0.712450f, 
		-0.419041f, 0.710087f, 0.565845f, -0.418644f, 0.627864f, 0.656143f, 
		-0.418537f, -0.894086f, -0.159488f, -0.418381f, 0.605040f, -0.677410f, 
		-0.417795f, 0.664853f, 0.619207f, -0.417711f, 0.608044f, 0.675130f, 
		-0.417692f, 0.562971f, 0.713160f, -0.417663f, 0.145164f, 0.896931f, 
		-0.417415f, 0.529313f, -0.738642f, -0.417407f, -0.163518f, 0.893887f, 
		-0.416833f, 0.597516f, 0.685000f, -0.416024f, 0.492349f, 0.764537f, 
		-0.415422f, 0.652201f, 0.634081f, -0.414122f, -0.449091f, 0.791720f, 
		-0.414056f, -0.904576f, 0.101491f, -0.413958f, 0.294274f, 0.861418f, 
		-0.413560f, -0.168020f, 0.894839f, -0.413355f, -0.907873f, -0.0700263f, 
		-0.413341f, 0.734992f, -0.537528f, -0.412862f, 0.472282f, 0.778778f, 
		-0.412846f, 0.417998f, 0.809219f, -0.412714f, -0.660261f, -0.627473f, 
		-0.412538f, 0.451285f, -0.791299f, -0.412492f, 0.891519f, 0.187201f, 
		-0.412362f, 0.647651f, -0.640707f, -0.412296f, -0.706932f, 0.574682f, 
		-0.412084f, 0.877220f, -0.246315f, -0.411858f, 0.562577f, 0.716854f, 
		-0.411702f, 0.291003f, -0.863608f, -0.411614f, 0.208507f, 0.887186f, 
		-0.411539f, 0.858118f, 0.307032f, -0.411436f, 0.806282f, -0.425006f, 
		-0.411411f, -0.879493f, 0.239234f, -0.411333f, 0.754859f, -0.510875f, 
		-0.411249f, 0.0500802f, 0.910146f, -0.410441f, 0.514658f, 0.752771f, 
		-0.410341f, -0.297489f, 0.862045f, -0.410316f, 0.291841f, 0.863984f, 
		-0.410195f, 0.586844f, -0.698108f, -0.409709f, -0.696445f, -0.589155f, 
		-0.409545f, -0.696666f, -0.589007f, -0.409416f, -0.0873210f, 0.908160f, 
		-0.408894f, 0.565968f, 0.715881f, -0.408854f, -0.802984f, 0.433653f, 
		-0.408852f, -0.808517f, 0.423250f, -0.408453f, -0.862690f, 0.298216f, 
		-0.408218f, 0.310807f, -0.858346f, -0.407978f, -0.0893862f, 0.908605f, 
		-0.407694f, -0.620700f, 0.669714f, -0.407470f, -0.847718f, -0.339622f, 
		-0.407435f, 0.377229f, 0.831682f, -0.407201f, 0.862330f, 0.300954f, 
		-0.407099f, 0.600316f, 0.688398f, -0.407076f, 0.154355f, 0.900258f, 
		-0.406825f, 0.611327f, 0.678802f, -0.406684f, 0.613948f, -0.676518f, 
		-0.406626f, -0.862739f, -0.300559f, -0.406614f, 0.0409443f, 0.912682f, 
		-0.406510f, -0.887759f, 0.215950f, -0.406188f, -0.912473f, -0.0490376f, 
		-0.406134f, 0.428152f, 0.807305f, -0.406077f, -0.482518f, 0.776066f, 
		-0.405544f, 0.910403f, 0.0818535f, -0.405325f, 0.865680f, -0.293785f, 
		-0.405270f, 0.352774f, -0.843390f, -0.405195f, 0.615506f, -0.675995f, 
		-0.404677f, -0.178596f, -0.896850f, -0.404534f, 0.507376f, 0.760869f, 
		-0.404089f, -0.859384f, 0.313322f, -0.402983f, 0.234164f, 0.884744f, 
		-0.402976f, -0.432926f, 0.806341f, -0.402582f, -0.746711f, -0.529481f, 
		-0.402458f, -0.284861f, 0.869990f, -0.402423f, -0.746940f, -0.529279f, 
		-0.402227f, 0.808762f, -0.429089f, -0.402171f, -0.893160f, -0.201304f, 
		-0.402083f, 0.696746f, 0.594033f, -0.401954f, 0.747688f, -0.528579f, 
		-0.401651f, 0.563259f, -0.722091f, -0.401434f, 0.364315f, 0.840313f, 
		-0.401372f, 0.779587f, -0.480775f, -0.400417f, 0.566893f, 0.719930f, 
		-0.400368f, 0.503674f, 0.765518f, -0.400334f, 0.406719f, 0.821166f, 
		-0.400197f, -0.700322f, -0.591093f, -0.400150f, -0.897880f, -0.183553f, 
		-0.399936f, -0.915727f, 0.0386667f, -0.399769f, 0.887851f, -0.227827f, 
		-0.399621f, 0.549718f, 0.733562f, -0.399564f, 0.689422f, -0.604190f, 
		-0.399477f, -0.724322f, -0.561940f, -0.398924f, 0.164211f, 0.902161f, 
		-0.398889f, -0.887707f, -0.229920f, -0.398861f, 0.665425f, -0.630967f, 
		-0.398435f, -0.889187f, -0.224937f, -0.398287f, -0.840744f, 0.366766f, 
		-0.397272f, -0.855094f, 0.333150f, -0.397229f, -0.897567f, -0.191265f, 
		-0.396900f, -0.451978f, 0.798866f, -0.396713f, 0.790775f, 0.466147f, 
		-0.396709f, 0.423666f, 0.814327f, -0.396695f, 0.603124f, 0.692008f, 
		-0.396169f, -0.916137f, -0.0611881f, -0.395482f, -0.909798f, 0.125945f, 
		-0.395482f, -0.444387f, 0.803812f, -0.395302f, 0.478859f, 0.783856f, 
		-0.395098f, 0.398604f, 0.827655f, -0.394728f, 0.795932f, -0.459001f, 
		-0.394651f, 0.218826f, 0.892393f, -0.394470f, -0.112715f, 0.911970f, 
		-0.394467f, 0.797222f, -0.456983f, -0.393933f, -0.0672277f, -0.916677f, 
		-0.393770f, 0.131873f, 0.909700f, -0.393593f, 0.784021f, 0.479995f, 
		-0.393592f, -0.911586f, -0.118726f, -0.393434f, 0.333913f, 0.856570f, 
		-0.393253f, -0.880547f, 0.264554f, -0.393173f, -0.557545f, 0.731135f, 
		-0.392825f, 0.0682489f, -0.917077f, -0.392735f, 0.236855f, 0.888628f, 
		-0.392638f, -0.397631f, 0.829292f, -0.392307f, -0.918657f, -0.0465376f, 
		-0.392156f, -0.321440f, 0.861911f, -0.391901f, 0.584096f, 0.710806f, 
		-0.391824f, 0.562070f, 0.728390f, -0.391307f, 0.554974f, -0.734087f, 
		-0.391117f, 0.900332f, -0.190866f, -0.390219f, 0.770519f, -0.504014f, 
		-0.390082f, -0.912260f, 0.124970f, -0.389905f, 0.217071f, 0.894905f, 
		-0.389692f, 0.275980f, 0.878621f, -0.389459f, 0.126128f, 0.912367f, 
		-0.388819f, 0.618508f, 0.682838f, -0.388811f, -0.915889f, 0.0998693f, 
		-0.388725f, 0.183099f, 0.902977f, -0.388724f, 0.286304f, 0.875742f, 
		-0.388480f, 0.00573553f, -0.921439f, -0.388369f, 0.135794f, -0.911443f, 
		-0.388355f, 0.565220f, 0.727810f, -0.388205f, -0.901442f, -0.191570f, 
		-0.387666f, -0.271287f, 0.880976f, -0.387554f, 0.557292f, 0.734321f, 
		-0.386970f, 0.792858f, 0.470777f, -0.386687f, 0.676655f, 0.626586f, 
		-0.386257f, 0.896602f, -0.216590f, -0.386203f, 0.825746f, -0.411084f, 
		-0.386173f, 0.388948f, -0.836415f, -0.386095f, 0.316584f, 0.866432f, 
		-0.385693f, 0.668176f, 0.636225f, -0.385532f, -0.913550f, 0.129583f, 
		-0.385276f, 0.339218f, 0.858192f, -0.385052f, -0.922715f, -0.0182310f, 
		-0.384999f, 0.367238f, -0.846707f, -0.384760f, 0.832834f, 0.397929f, 
		-0.384658f, 0.150576f, -0.910695f, -0.384634f, -0.882199f, -0.271626f, 
		-0.384544f, -0.879525f, 0.280288f, -0.384292f, 0.841596f, 0.379520f, 
		-0.384245f, 0.662000f, 0.643515f, -0.384013f, 0.315203f, 0.867860f, 
		-0.383983f, 0.836793f, 0.390300f, -0.383972f, -0.632036f, 0.673124f, 
		-0.383923f, 0.500799f, -0.775760f, -0.383826f, 0.776473f, 0.499767f, 
		-0.383711f, 0.354427f, -0.852729f, -0.383494f, -0.0335670f, 0.922933f, 
		-0.383274f, -0.121671f, 0.915586f, -0.383110f, -0.902480f, 0.196866f, 
		-0.382569f, 0.923927f, 0.000000f, -0.382407f, 0.832870f, 0.400115f, 
		-0.382276f, 0.919950f, 0.0869273f, -0.382060f, 0.250266f, 0.889605f, 
		-0.381990f, 0.656388f, 0.650568f, -0.381965f, 0.308820f, 0.871053f, 
		-0.381731f, 0.287435f, 0.878444f, -0.381535f, 0.156662f, -0.910982f, 
		-0.380920f, 0.717974f, 0.582592f, -0.380910f, 0.197166f, 0.903345f, 
		-0.380877f, -0.428707f, -0.819233f, -0.380664f, -0.899166f, 0.215860f, 
		-0.380363f, -0.887008f, 0.261802f, -0.380228f, -0.496816f, 0.780129f, 
		-0.380192f, -0.901601f, -0.206325f, -0.380178f, -0.877479f, 0.292396f, 
		-0.379818f, 0.0537093f, 0.923501f, -0.379752f, -0.719523f, -0.581441f, 
		-0.379504f, 0.780455f, -0.496858f, -0.379360f, 0.306150f, 0.873131f, 
		-0.379359f, 0.886664f, -0.264413f, -0.379308f, 0.231928f, -0.895732f, 
		-0.379195f, -0.915637f, 0.133493f, -0.379168f, -0.0182809f, 0.925147f, 
		-0.379146f, 0.175288f, 0.908583f, -0.379116f, 0.0888570f, 0.921073f, 
		-0.378760f, -0.415304f, -0.827081f, -0.378440f, 0.901336f, -0.210659f, 
		-0.378401f, 0.380128f, -0.843988f, -0.378363f, 0.352666f, 0.855843f, 
		-0.378080f, -0.701766f, 0.603805f, -0.377964f, -0.151969f, 0.913263f, 
		-0.377803f, 0.338067f, 0.861960f, -0.377656f, 0.328080f, -0.865875f, 
		-0.377431f, -0.919346f, 0.111127f, -0.377356f, 0.738904f, 0.558232f, 
		-0.377258f, -0.477442f, 0.793552f, -0.377218f, 0.0297915f, -0.925645f, 
		-0.377086f, 0.704199f, 0.601589f, -0.376927f, 0.495831f, -0.782354f, 
		-0.376839f, 0.361734f, 0.852725f, -0.376463f, -0.763067f, 0.525361f, 
		-0.376374f, 0.631162f, 0.678216f, -0.376218f, 0.355217f, 0.855734f, 
		-0.375611f, -0.917569f, 0.130323f, -0.375432f, 0.0590080f, 0.924969f, 
		-0.374792f, 0.766456f, 0.521609f, -0.374292f, 0.641314f, -0.669792f, 
		-0.373676f, 0.660724f, -0.651007f, -0.373555f, 0.451289f, 0.810429f, 
		-0.373543f, 0.750862f, 0.544676f, -0.373499f, -0.905103f, -0.203191f, 
		-0.373340f, 0.924874f, 0.0722889f, -0.372807f, 0.0731719f, 0.925019f, 
		-0.372691f, -0.923866f, 0.0870206f, -0.372607f, -0.125884f, -0.919411f, 
		-0.372357f, 0.331364f, -0.866919f, -0.372038f, -0.577669f, -0.726558f, 
		-0.371507f, 0.905865f, -0.203445f, -0.371154f, -0.915931f, 0.152695f, 
		-0.371084f, -0.914439f, -0.161550f, -0.370975f, -0.855848f, 0.360418f, 
		-0.370017f, 0.648607f, -0.665128f, -0.369979f, 0.568900f, -0.734485f, 
		-0.369288f, 0.841711f, -0.393891f, -0.369255f, 0.785251f, 0.497023f, 
		-0.369180f, 0.732009f, 0.572599f, -0.368782f, -0.784052f, -0.499263f, 
		-0.368715f, 0.125152f, -0.921079f, -0.368428f, 0.782509f, -0.501937f, 
		-0.368100f, -0.0367413f, 0.929060f, -0.367459f, 0.445186f, -0.816568f, 
		-0.367359f, 0.631851f, -0.682504f, -0.367339f, 0.263003f, 0.892127f, 
		-0.367168f, 0.794554f, 0.483602f, -0.367001f, 0.605613f, 0.706076f, 
		-0.366985f, 0.650192f, -0.665261f, -0.365862f, -0.911739f, -0.186754f, 
		-0.365357f, -0.402367f, 0.839413f, -0.363818f, 0.847507f, 0.386481f, 
		-0.363746f, -0.891393f, 0.270383f, -0.363682f, -0.876907f, -0.314276f, 
		-0.363676f, -0.910165f, 0.198341f, -0.363666f, -0.352706f, -0.862175f, 
		-0.363363f, 0.272515f, 0.890900f, -0.362859f, -0.765872f, -0.530824f, 
		-0.362787f, 0.788058f, 0.497344f, -0.362784f, -0.397964f, -0.842622f, 
		-0.362719f, 0.145275f, -0.920505f, -0.362197f, -0.648584f, 0.669442f, 
		-0.362174f, 0.390389f, 0.846420f, -0.361762f, -0.458177f, 0.811913f, 
		-0.361734f, 0.681256f, 0.636427f, -0.361733f, 0.180007f, 0.914739f, 
		-0.361626f, -0.496436f, 0.789163f, -0.361454f, 0.651134f, -0.667364f, 
		-0.360909f, 0.127852f, -0.923796f, -0.360708f, -0.703069f, 0.612849f, 
		-0.360667f, 0.161590f, 0.918590f, -0.359916f, -0.883635f, 0.299416f, 
		-0.359802f, 0.787283f, -0.500728f, -0.359766f, 0.683904f, 0.634700f, 
		-0.359369f, 0.688097f, 0.630378f, -0.359368f, 0.540468f, 0.760756f, 
		-0.359248f, 0.385224f, 0.850026f, -0.359130f, 0.540510f, 0.760838f, 
		-0.358846f, -0.902535f, 0.238033f, -0.358800f, 0.872852f, 0.330744f, 
		-0.358619f, -0.622739f, -0.695406f, -0.358043f, 0.725608f, 0.587620f, 
		-0.357238f, 0.420450f, 0.834028f, -0.357157f, -0.0217472f, 0.933791f, 
		-0.356871f, 0.577250f, 0.734456f, -0.356825f, -0.471235f, 0.806606f, 
		-0.356754f, 0.779832f, -0.514381f, -0.356741f, 0.00432229f, -0.934193f, 
		-0.356284f, 0.474731f, 0.804793f, -0.355936f, -0.932714f, -0.0579076f, 
		-0.355904f, -0.141318f, 0.923776f, -0.355862f, 0.512423f, 0.781527f, 
		-0.355625f, 0.473883f, -0.805584f, -0.354817f, 0.725469f, 0.589745f, 
		-0.354686f, -0.480281f, 0.802202f, -0.354315f, -0.888780f, -0.290742f, 
		-0.354229f, 0.829017f, -0.432727f, -0.354187f, -0.0954239f, 0.930293f, 
		-0.353822f, 0.535468f, 0.766867f, -0.353144f, 0.00396312f, 0.935561f, 
		-0.352087f, -0.473776f, -0.807200f, -0.352058f, -0.929046f, -0.113709f, 
		-0.351921f, 0.689875f, 0.632632f, -0.351420f, 0.531833f, 0.770492f, 
		-0.350972f, 0.0147897f, -0.936269f, -0.350927f, 0.679421f, 0.644389f, 
		-0.350729f, 0.755935f, 0.552767f, -0.350356f, -0.719066f, -0.600162f, 
		-0.350012f, 0.139166f, -0.926350f, -0.349942f, 0.371313f, -0.860039f, 
		-0.349939f, -0.663999f, -0.660793f, -0.349707f, 0.853010f, 0.387402f, 
		-0.349079f, 0.809033f, 0.472873f, -0.349040f, 0.603975f, -0.716509f, 
		-0.348883f, -0.901480f, -0.256151f, -0.348860f, 0.144088f, -0.926032f, 
		-0.348850f, 0.604134f, 0.716468f, -0.348809f, -0.0355357f, 0.936520f, 
		-0.348501f, 0.624233f, -0.699200f, -0.348277f, -0.933304f, 0.0874481f, 
		-0.348092f, 0.383276f, 0.855530f, -0.347005f, 0.343206f, -0.872810f, 
		-0.346815f, -0.229999f, 0.909296f, -0.346772f, 0.398198f, 0.849227f, 
		-0.346769f, 0.279195f, -0.895434f, -0.346723f, -0.229879f, 0.909362f, 
		-0.346703f, 0.881943f, 0.319332f, -0.346629f, 0.189537f, -0.918653f, 
		-0.346553f, 0.503317f, 0.791563f, -0.346142f, 0.230152f, -0.909514f, 
		-0.346095f, 0.615207f, 0.708335f, -0.345924f, 0.147507f, -0.926595f, 
		-0.345738f, -0.917898f, 0.194751f, -0.344519f, -0.165617f, 0.924055f, 
		-0.344355f, 0.811650f, -0.471851f, -0.344233f, 0.141723f, 0.928126f, 
		-0.344207f, -0.889895f, -0.299346f, -0.344137f, -0.287764f, 0.893735f, 
		-0.343980f, 0.858269f, 0.380857f, -0.343601f, -0.919566f, -0.190622f, 
		-0.343520f, 0.777979f, 0.526064f, -0.343518f, -0.611934f, 0.712413f, 
		-0.342743f, -0.937453f, -0.0609046f, -0.341966f, 0.535500f, 0.772204f, 
		-0.341690f, 0.814590f, -0.468711f, -0.341472f, -0.335212f, 0.878083f, 
		-0.341459f, 0.449608f, -0.825384f, -0.341441f, -0.0800186f, -0.936491f, 
		-0.341198f, 0.121125f, 0.932155f, -0.340926f, -0.771777f, -0.536777f, 
		-0.340845f, 0.886987f, 0.311574f, -0.340751f, 0.176459f, 0.923445f, 
		-0.340694f, 0.577898f, -0.741594f, -0.340142f, 0.775330f, 0.532135f, 
		-0.340063f, 0.815326f, -0.468616f, -0.339878f, 0.298396f, 0.891876f, 
		-0.339645f, -0.298247f, -0.892015f, -0.339634f, 0.275940f, -0.899169f, 
		-0.339609f, -0.867748f, 0.362876f, -0.339446f, -0.939025f, -0.0548509f, 
		-0.339160f, -0.616121f, 0.710890f, -0.338943f, 0.668604f, 0.661881f, 
		-0.338840f, 0.496367f, 0.799254f, -0.338553f, 0.853403f, -0.396339f, 
		-0.338248f, 0.923935f, 0.178698f, -0.338071f, -0.354587f, 0.871766f, 
		-0.338018f, -0.137744f, 0.931005f, -0.337993f, 0.502845f, 0.795555f, 
		-0.337846f, -0.907609f, 0.249212f, -0.337241f, 0.815915f, -0.469629f, 
		-0.337146f, 0.273145f, -0.900957f, -0.337052f, 0.688524f, -0.642130f, 
		-0.337031f, 0.172544f, 0.925548f, -0.336919f, -0.326619f, -0.883066f, 
		-0.336815f, -0.729898f, 0.594815f, -0.336754f, 0.657524f, 0.673987f, 
		-0.336472f, -0.0148303f, -0.941577f, -0.336404f, 0.656824f, 0.674844f, 
		-0.335908f, 0.573163f, -0.747429f, -0.335615f, -0.846448f, 0.413387f, 
		-0.335596f, -0.941247f, 0.0378194f, -0.335121f, 0.426531f, 0.840098f, 
		-0.334952f, -0.734460f, 0.590233f, -0.334827f, 0.499933f, -0.798722f, 
		-0.334640f, -0.891278f, -0.306007f, -0.334281f, -0.212977f, 0.918094f, 
		-0.334218f, -0.225492f, 0.915124f, -0.333616f, -0.888802f, 0.314216f, 
		-0.333448f, -0.933718f, 0.130317f, -0.333237f, 0.361247f, -0.870892f, 
		-0.332762f, 0.502601f, -0.797910f, -0.332669f, -0.905170f, -0.264570f, 
		-0.332279f, -0.869892f, 0.364525f, -0.332108f, 0.250077f, -0.909487f, 
		-0.331845f, -0.652280f, 0.681476f, -0.331692f, -0.219151f, -0.917580f, 
		-0.331129f, 0.192467f, 0.923748f, -0.330629f, -0.455994f, -0.826289f, 
		-0.330419f, -0.0916400f, 0.939375f, -0.330006f, -0.213843f, -0.919438f, 
		-0.329738f, -0.898906f, 0.288514f, -0.328975f, 0.398176f, -0.856289f, 
		-0.328722f, -0.113513f, -0.937580f, -0.328649f, 0.287234f, -0.899715f, 
		-0.328596f, -0.928809f, 0.171286f, -0.328444f, 0.633941f, 0.700174f, 
		-0.328360f, -0.829552f, -0.451690f, -0.328268f, -0.0262984f, 0.944219f, 
		-0.327816f, -0.907184f, 0.263729f, -0.327599f, 0.286950f, 0.900188f, 
		-0.327569f, 0.793717f, 0.512554f, -0.327292f, -0.928887f, -0.173346f, 
		-0.327217f, -0.907156f, 0.264570f, -0.326362f, 0.251021f, 0.911305f, 
		-0.326173f, 0.215712f, -0.920369f, -0.325916f, 0.140223f, -0.934942f, 
		-0.325857f, 0.835436f, -0.442566f, -0.325710f, 0.490538f, -0.808261f, 
		-0.325599f, 0.334984f, 0.884178f, -0.325574f, 0.330097f, -0.886023f, 
		-0.325419f, 0.821934f, -0.467469f, -0.325142f, 0.334486f, 0.884535f, 
		-0.325087f, 0.792692f, 0.515711f, -0.324594f, 0.136869f, 0.935898f, 
		-0.324507f, -0.364007f, 0.873037f, -0.324258f, 0.936313f, -0.134811f, 
		-0.324253f, -0.441994f, -0.836362f, -0.324003f, 0.196927f, -0.925333f, 
		-0.323795f, -0.918552f, 0.226756f, -0.323604f, -0.441358f, -0.836949f, 
		-0.323465f, 0.791945f, -0.517874f, -0.323251f, 0.654379f, 0.683591f, 
		-0.323214f, 0.165174f, 0.931799f, -0.323069f, 0.332574f, -0.886014f, 
		-0.323039f, 0.584488f, 0.744325f, -0.322897f, -0.628179f, -0.707904f, 
		-0.322344f, 0.257088f, 0.911043f, -0.322329f, 0.100338f, -0.941295f, 
		-0.321787f, -0.701811f, 0.635543f, -0.321691f, 0.438286f, 0.839297f, 
		-0.321415f, -0.507990f, -0.799149f, -0.321061f, 0.306856f, 0.895968f, 
		-0.321061f, 0.435658f, -0.840905f, -0.320925f, -0.612725f, -0.722202f, 
		-0.320491f, 0.863133f, 0.390240f, -0.320270f, 0.238077f, -0.916922f, 
		-0.320163f, -0.120444f, 0.939675f, -0.320103f, -0.945905f, -0.0528966f, 
		-0.319844f, -0.596742f, 0.735934f, -0.317949f, 0.209052f, 0.924774f, 
		-0.317828f, 0.228609f, 0.920176f, -0.317645f, 0.621432f, 0.716187f, 
		-0.317645f, 0.370874f, 0.872671f, -0.317431f, 0.862327f, 0.394498f, 
		-0.317340f, -0.136456f, -0.938443f, -0.317195f, -0.377977f, -0.869782f, 
		-0.317166f, 0.751011f, -0.579127f, -0.316968f, 0.437146f, 0.841686f, 
		-0.316961f, 0.231908f, 0.919649f, -0.316712f, 0.760118f, -0.567375f, 
		-0.316074f, -0.0831096f, -0.945087f, -0.315794f, -0.233566f, 0.919631f, 
		-0.315309f, -0.893605f, -0.319452f, -0.315273f, 0.0993523f, 0.943786f, 
		-0.315043f, 0.127090f, 0.940530f, -0.314888f, 0.514174f, 0.797791f, 
		-0.314482f, 0.608989f, 0.728171f, -0.314418f, 0.618571f, 0.720078f, 
		-0.314292f, 0.536383f, 0.783271f, -0.313735f, 0.759484f, -0.569872f, 
		-0.313697f, 0.924846f, -0.215066f, -0.313303f, -0.894580f, -0.318699f, 
		-0.313063f, 0.783554f, -0.536688f, -0.312885f, 0.681291f, 0.661775f, 
		-0.312812f, 0.350724f, 0.882690f, -0.312650f, 0.0848808f, 0.946068f, 
		-0.312626f, -0.504052f, -0.805106f, -0.312558f, 0.0235433f, -0.949607f, 
		-0.312133f, 0.0843304f, 0.946288f, -0.311867f, -0.932310f, 0.183132f, 
		-0.311729f, 0.392064f, 0.865512f, -0.311506f, -0.0900252f, 0.945970f, 
		-0.311461f, 0.801407f, 0.510626f, -0.311388f, -0.834821f, -0.453995f, 
		-0.311355f, 0.606430f, 0.731642f, -0.311309f, 0.0899884f, 0.946038f, 
		-0.311283f, -0.0901466f, 0.946032f, -0.310916f, -0.128737f, 0.941678f, 
		-0.310896f, -0.432245f, 0.846468f, -0.310642f, 0.0431242f, -0.949548f, 
		-0.310474f, -0.680340f, -0.663885f, -0.310288f, 0.621444f, -0.719395f, 
		-0.310003f, -0.323754f, 0.893914f, -0.309425f, -0.584933f, 0.749740f, 
		-0.309277f, -0.0192275f, 0.950778f, -0.309271f, 0.423636f, -0.851401f, 
		-0.309148f, -0.0506434f, 0.949665f, -0.308918f, -0.351967f, 0.883566f, 
		-0.308785f, -0.0314684f, 0.950611f, -0.308531f, 0.00402322f, -0.951206f, 
		-0.308393f, -0.814515f, 0.491384f, -0.308191f, -0.724576f, 0.616448f, 
		-0.307889f, 0.293889f, -0.904894f, -0.307510f, -0.910771f, 0.275560f, 
		-0.307241f, 0.240237f, 0.920809f, -0.307056f, -0.164948f, 0.937288f, 
		-0.307042f, 0.398549f, 0.864224f, -0.306747f, -0.281639f, 0.909168f, 
		-0.306694f, 0.648308f, -0.696876f, -0.306654f, -0.281297f, 0.909305f, 
		-0.306369f, 0.817217f, 0.488154f, -0.305480f, 0.820176f, 0.483729f, 
		-0.305060f, -0.864130f, 0.400273f, -0.304273f, -0.302315f, 0.903340f, 
		-0.304221f, 0.485740f, 0.819455f, -0.303626f, 0.502095f, 0.809760f, 
		-0.302969f, -0.882494f, 0.359743f, -0.302576f, -0.842809f, -0.445108f, 
		-0.302358f, 0.0420776f, -0.952265f, -0.301963f, -0.637622f, -0.708700f, 
		-0.301826f, 0.529350f, 0.792899f, -0.301805f, 0.893226f, -0.333259f, 
		-0.301338f, -0.949418f, -0.0883216f, -0.301303f, -0.949429f, -0.0883228f, 
		-0.301196f, -0.801056f, -0.517292f, -0.301097f, 0.238033f, 0.923407f, 
		-0.300741f, -0.473979f, 0.827586f, -0.300459f, 0.738667f, -0.603404f, 
		-0.300407f, 0.107103f, 0.947779f, -0.300178f, -0.360964f, 0.882949f, 
		-0.299916f, 0.615660f, 0.728706f, -0.299860f, -0.902748f, -0.308432f, 
		-0.299525f, -0.802482f, 0.516049f, -0.299402f, -0.429661f, 0.851910f, 
		-0.299158f, 0.343344f, 0.890291f, -0.298755f, 0.697643f, 0.651183f, 
		-0.298568f, 0.352801f, -0.886785f, -0.298493f, 0.711924f, 0.635662f, 
		-0.298370f, 0.728241f, 0.616960f, -0.297805f, 0.589000f, -0.751260f, 
		-0.297709f, 0.536124f, -0.789899f, -0.297586f, -0.363087f, 0.882956f, 
		-0.296985f, 0.630232f, 0.717362f, -0.296791f, 0.164807f, -0.940614f, 
		-0.296572f, -0.508056f, 0.808656f, -0.296555f, -0.952149f, -0.0739487f, 
		-0.296114f, 0.468892f, -0.832140f, -0.296100f, -0.931746f, 0.210177f, 
		-0.296074f, -0.496587f, 0.815930f, -0.294622f, 0.313113f, 0.902861f, 
		-0.293567f, 0.164547f, -0.941670f, -0.293518f, -0.904277f, 0.310050f, 
		-0.293395f, -0.343379f, -0.892194f, -0.293235f, 0.439037f, 0.849270f, 
		-0.293134f, -0.870352f, 0.395675f, -0.292389f, -0.782158f, 0.550216f, 
		-0.292153f, 0.398065f, 0.869592f, -0.291602f, 0.204597f, -0.934403f, 
		-0.291511f, -0.894377f, 0.339281f, -0.291319f, 0.767306f, 0.571293f, 
		-0.291318f, -0.498359f, 0.816561f, -0.291137f, -0.238194f, -0.926554f, 
		-0.290554f, 0.913356f, -0.285236f, -0.290019f, 0.564912f, -0.772505f, 
		-0.289665f, 0.284187f, 0.913965f, -0.289438f, 0.255600f, 0.922439f, 
		-0.289400f, -0.758708f, 0.583618f, -0.289159f, 0.146745f, -0.945967f, 
		-0.288974f, -0.275718f, 0.916774f, -0.288747f, -0.303442f, -0.908046f, 
		-0.288369f, 0.957519f, 0.000000f, -0.287968f, -0.0665789f, 0.955323f, 
		-0.286987f, -0.441971f, 0.849882f, -0.286861f, -0.778442f, 0.558336f, 
		-0.286741f, -0.957799f, -0.0200274f, -0.286645f, -0.557312f, 0.779254f, 
		-0.286546f, -0.375364f, 0.881472f, -0.286507f, 0.776533f, -0.561169f, 
		-0.286180f, -0.937354f, -0.198665f, -0.285900f, -0.461778f, -0.839656f, 
		-0.285785f, -0.831587f, 0.476225f, -0.284980f, 0.677409f, 0.678162f, 
		-0.284968f, -0.160932f, -0.944931f, -0.284091f, 0.821491f, 0.494414f, 
		-0.283218f, 0.893584f, -0.348274f, -0.283174f, 0.307960f, 0.908280f, 
		-0.282658f, -0.510746f, 0.811938f, -0.282212f, 0.267065f, -0.921430f, 
		-0.282174f, -0.421748f, -0.861688f, -0.282007f, 0.432308f, 0.856494f, 
		-0.281451f, 0.815610f, 0.505535f, -0.281188f, 0.149616f, 0.947918f, 
		-0.281052f, -0.267592f, 0.921631f, -0.280991f, 0.425060f, -0.860446f, 
		-0.280690f, -0.723795f, -0.630345f, -0.280523f, 0.628170f, 0.725748f, 
		-0.280255f, 0.390366f, -0.876967f, -0.280223f, 0.425223f, -0.860617f, 
		-0.280133f, -0.892829f, 0.352679f, -0.279942f, -0.923750f, 0.261378f, 
		-0.279824f, 0.603207f, -0.746887f, -0.279367f, 0.304669f, -0.910566f, 
		-0.279206f, -0.263181f, 0.923461f, -0.278968f, 0.235332f, 0.931019f, 
		-0.278723f, -0.661123f, -0.696584f, -0.278479f, -0.917028f, -0.285497f, 
		-0.278289f, -0.231890f, -0.932085f, -0.278278f, 0.668126f, 0.690050f, 
		-0.277750f, -0.235476f, -0.931346f, -0.277490f, 0.189301f, -0.941894f, 
		-0.277215f, 0.574369f, -0.770229f, -0.276904f, 0.764520f, 0.582094f, 
		-0.276834f, -0.172649f, 0.945280f, -0.276813f, 0.958016f, 0.0746917f, 
		-0.276538f, -0.881869f, -0.381883f, -0.276323f, 0.182954f, 0.943490f, 
		-0.276147f, -0.927521f, -0.251888f, -0.275840f, -0.436200f, 0.856529f, 
		-0.275812f, 0.854549f, -0.440085f, -0.275709f, 0.574871f, -0.770395f, 
		-0.275477f, 0.0386272f, -0.960531f, -0.275270f, 0.854766f, -0.440001f, 
		-0.274497f, 0.260603f, -0.925601f, -0.274099f, -0.960793f, -0.0417820f, 
		-0.274095f, -0.00956468f, -0.961655f, -0.273977f, 0.645171f, 0.713226f, 
		-0.273871f, -0.959370f, 0.0678460f, -0.273845f, 0.156904f, -0.948889f, 
		-0.273737f, -0.936990f, 0.217065f, -0.273709f, -0.960784f, 0.0444605f, 
		-0.273575f, 0.366964f, 0.889097f, -0.273333f, -0.926355f, -0.259145f, 
		-0.273193f, -0.928714f, -0.250709f, -0.272555f, 0.314496f, -0.909289f, 
		-0.272399f, 0.206614f, 0.939739f, -0.271915f, -0.847602f, 0.455668f, 
		-0.271854f, -0.225339f, 0.935584f, -0.271749f, 0.381480f, 0.883530f, 
		-0.271254f, -0.750282f, -0.602908f, -0.271168f, -0.277085f, 0.921787f, 
		-0.270918f, 0.368993f, -0.889071f, -0.270800f, -0.359280f, 0.893076f, 
		-0.270557f, -0.359151f, 0.893202f, -0.270364f, 0.566307f, 0.778588f, 
		-0.270238f, 0.633948f, 0.724625f, -0.269358f, 0.356442f, -0.894648f, 
		-0.269022f, 0.500992f, -0.822578f, -0.268985f, 0.168073f, -0.948366f, 
		-0.268868f, 0.460827f, 0.845783f, -0.268672f, -0.0624997f, -0.961202f, 
		-0.268633f, -0.148410f, -0.951741f, -0.268383f, 0.206554f, 0.940907f, 
		-0.267952f, 0.340134f, -0.901394f, -0.267212f, 0.925083f, 0.269850f, 
		-0.266522f, 0.468475f, 0.842317f, -0.266311f, 0.205614f, 0.941701f, 
		-0.266155f, 0.560624f, 0.784131f, -0.266152f, 0.429781f, -0.862816f, 
		-0.266089f, 0.210247f, -0.940741f, -0.265882f, -0.874616f, -0.405405f, 
		-0.265468f, 0.595807f, 0.757984f, -0.265198f, -0.334813f, 0.904196f, 
		-0.264829f, 0.962762f, 0.0543535f, -0.264619f, 0.716211f, 0.645769f, 
		-0.264234f, -0.386294f, -0.883718f, -0.264233f, 0.555960f, 0.788092f, 
		-0.264000f, -0.785993f, -0.559034f, -0.263880f, -0.148351f, 0.953079f, 
		-0.263082f, 0.277604f, -0.923972f, -0.262552f, 0.376404f, -0.888474f, 
		-0.262408f, 0.307249f, 0.914735f, -0.262284f, -0.559054f, 0.786553f, 
		-0.262216f, 0.816389f, 0.514541f, -0.262099f, -0.501228f, -0.824666f, 
		-0.262011f, 0.334835f, 0.905116f, -0.261515f, -0.933307f, -0.246063f, 
		-0.261498f, -0.913696f, -0.311094f, -0.261382f, 0.229011f, -0.937675f, 
		-0.260557f, 0.183049f, -0.947947f, -0.260474f, 0.185969f, 0.947401f, 
		-0.260059f, -0.530731f, 0.806656f, -0.259828f, 0.886675f, 0.382489f, 
		-0.259628f, 0.292838f, 0.920239f, -0.259546f, 0.681776f, -0.683972f, 
		-0.259160f, -0.0213231f, 0.965599f, -0.258858f, -0.909320f, -0.325775f, 
		-0.258373f, -0.444339f, 0.857791f, -0.258228f, 0.330720f, -0.907713f, 
		-0.258090f, 0.756697f, 0.600665f, -0.257824f, 0.959506f, 0.113465f, 
		-0.257076f, -0.0219666f, 0.966142f, -0.256148f, 0.286690f, 0.923145f, 
		-0.256074f, -0.956600f, 0.139074f, -0.255893f, 0.477775f, -0.840387f, 
		-0.255440f, -0.126297f, 0.958540f, -0.254848f, 0.569870f, 0.781217f, 
		-0.254834f, 0.164786f, -0.952841f, -0.254743f, 0.102792f, -0.961530f, 
		-0.254710f, -0.855253f, -0.451293f, -0.254514f, 0.177264f, -0.950684f, 
		-0.254326f, 0.620264f, -0.742018f, -0.254260f, -0.662000f, 0.705059f, 
		-0.254115f, -0.959315f, -0.123044f, -0.253625f, -0.477212f, 0.841394f, 
		-0.253464f, -0.852297f, -0.457543f, -0.253295f, -0.921441f, 0.294598f, 
		-0.253262f, 0.401548f, 0.880124f, -0.252615f, 0.308854f, 0.916949f, 
		-0.252536f, 0.383955f, 0.888146f, -0.252443f, 0.326898f, -0.910720f, 
		-0.252345f, -0.271282f, -0.928832f, -0.252240f, -0.934801f, 0.250043f, 
		-0.252201f, -0.934808f, 0.250059f, -0.252086f, 0.603645f, -0.756350f, 
		-0.251974f, -0.912362f, 0.322651f, -0.251856f, -0.437346f, 0.863306f, 
		-0.251482f, 0.515131f, -0.819388f, -0.251085f, -0.895702f, 0.366981f, 
		-0.251066f, -0.895714f, 0.366964f, -0.250535f, -0.852153f, 0.459421f, 
		-0.249546f, 0.588091f, -0.769334f, -0.249428f, 0.158992f, 0.955253f, 
		-0.249267f, -0.849454f, -0.465075f, -0.248725f, -0.942778f, 0.222048f, 
		-0.248562f, 0.834943f, 0.491007f, -0.248534f, 0.398875f, 0.882683f, 
		-0.248437f, -0.819533f, 0.516377f, -0.248211f, 0.319122f, 0.914632f, 
		-0.248142f, -0.472325f, -0.845775f, -0.247895f, 0.501397f, 0.828945f, 
		-0.247852f, 0.812961f, 0.526938f, -0.247772f, 0.868873f, -0.428565f, 
		-0.247341f, 0.345636f, -0.905184f, -0.247110f, 0.795280f, -0.553594f, 
		-0.245732f, 0.901363f, 0.356597f, -0.245281f, -0.606734f, 0.756116f, 
		-0.245243f, -0.606748f, 0.756117f, -0.245060f, 0.307692f, 0.919386f, 
		-0.244619f, 0.881039f, -0.404884f, -0.244577f, 0.969534f, -0.0136298f, 
		-0.244474f, 0.969553f, -0.0141399f, -0.244213f, -0.437155f, 0.865595f, 
		-0.243960f, 0.417875f, -0.875137f, -0.243835f, 0.230311f, -0.942073f, 
		-0.243321f, -0.334900f, -0.910295f, -0.242909f, -0.748661f, -0.616848f, 
		-0.242021f, -0.764104f, 0.597972f, -0.241850f, -0.176394f, -0.954145f, 
		-0.241709f, 0.740906f, -0.626606f, -0.240485f, 0.830219f, -0.502895f, 
		-0.240390f, -0.823902f, -0.513224f, -0.240369f, -0.823988f, -0.513095f, 
		-0.240065f, 0.625661f, -0.742238f, -0.239952f, 0.334020f, -0.911512f, 
		-0.239709f, 0.940787f, -0.239709f, -0.239337f, 0.970918f, -0.00601387f, 
		-0.238945f, -0.758112f, -0.606771f, -0.238894f, 0.167034f, 0.956572f, 
		-0.238555f, 0.890904f, -0.386500f, -0.238213f, 0.285085f, 0.928429f, 
		-0.238190f, 0.894400f, -0.378568f, -0.237982f, -0.389324f, -0.889826f, 
		-0.237843f, -0.962195f, 0.132708f, -0.237695f, 0.878073f, 0.415318f, 
		-0.237625f, -0.139051f, 0.961353f, -0.237571f, -0.958044f, 0.160348f, 
		-0.237552f, 0.737824f, -0.631811f, -0.237410f, 0.0426374f, -0.970473f, 
		-0.237370f, -0.683792f, 0.689988f, -0.237034f, 0.715866f, 0.656773f, 
		-0.236551f, 0.344226f, 0.908599f, -0.236541f, 0.673459f, -0.700358f, 
		-0.235483f, -0.525860f, -0.817325f, -0.234820f, -0.772725f, -0.589709f, 
		-0.234683f, 0.672201f, -0.702189f, -0.234632f, 0.165164f, 0.957950f, 
		-0.234158f, 0.200262f, -0.951349f, -0.233996f, 0.530553f, 0.814714f, 
		-0.233758f, -0.958739f, 0.161789f, -0.233702f, -0.933799f, 0.270930f, 
		-0.233509f, 0.600016f, 0.765150f, -0.233492f, 0.493377f, -0.837891f, 
		-0.233316f, -0.967720f, 0.0953034f, -0.233183f, 0.00783821f, 0.972401f, 
		-0.232609f, -0.0227976f, 0.972303f, -0.232518f, 0.294461f, 0.926945f, 
		-0.232234f, -0.899235f, 0.370734f, -0.231567f, 0.287858f, 0.929255f, 
		-0.231533f, 0.845618f, 0.480960f, -0.231175f, -0.972207f, -0.0370420f, 
		-0.231151f, 0.655580f, -0.718877f, -0.230892f, -0.277403f, 0.932597f, 
		-0.230684f, 0.798080f, -0.556645f, -0.230411f, 0.635520f, -0.736902f, 
		-0.229899f, 0.313069f, 0.921485f, -0.229796f, -0.427686f, 0.874230f, 
		-0.229476f, -0.177972f, 0.956905f, -0.229448f, -0.874295f, 0.427740f, 
		-0.229167f, -0.867674f, -0.441162f, -0.228933f, 0.504626f, -0.832431f, 
		-0.228817f, -0.886651f, 0.401861f, -0.228696f, 0.596842f, -0.769076f, 
		-0.228548f, -0.894311f, -0.384674f, -0.228428f, 0.822830f, -0.520358f, 
		-0.228013f, 0.759792f, -0.608873f, -0.227947f, 0.514892f, -0.826394f, 
		-0.227897f, -0.00635584f, -0.973664f, -0.227461f, -0.883185f, 0.410178f, 
		-0.227232f, 0.562573f, 0.794907f, -0.226629f, 0.393203f, -0.891084f, 
		-0.225779f, 0.161007f, 0.960781f, -0.225770f, 0.908465f, 0.351738f, 
		-0.225301f, 0.270319f, 0.936038f, -0.225297f, 0.818938f, 0.527808f, 
		-0.225284f, 0.757253f, -0.613038f, -0.225067f, 0.369875f, -0.901409f, 
		-0.224603f, 0.873041f, -0.432842f, -0.224571f, -0.0894503f, 0.970343f, 
		-0.223965f, -0.907239f, 0.356028f, -0.223546f, 0.471914f, -0.852833f, 
		-0.223241f, 0.651616f, -0.724955f, -0.222782f, 0.972761f, 0.0640682f, 
		-0.222537f, 0.434029f, -0.872981f, -0.222434f, 0.752849f, 0.619469f, 
		-0.222017f, 0.518983f, 0.825449f, -0.221781f, 0.651896f, 0.725152f, 
		-0.221148f, 0.576937f, 0.786281f, -0.220581f, 0.814232f, -0.537001f, 
		-0.220188f, 0.278292f, 0.934918f, -0.220022f, 0.331987f, 0.917265f, 
		-0.220009f, 0.263810f, 0.939149f, -0.219534f, 0.733319f, -0.643465f, 
		-0.219174f, 0.325618f, -0.919747f, -0.219145f, -0.873563f, -0.434584f, 
		-0.218905f, -0.892280f, -0.394864f, -0.218764f, 0.326834f, -0.919414f, 
		-0.218383f, 0.332220f, 0.917572f, -0.218371f, -0.416021f, -0.882746f, 
		-0.218053f, 0.177591f, -0.959643f, -0.217923f, 0.334764f, -0.916756f, 
		-0.217905f, 0.258535f, -0.941104f, -0.217904f, -0.755339f, 0.618046f, 
		-0.217847f, 0.130815f, -0.967176f, -0.217784f, -0.975393f, 0.0343459f, 
		-0.217640f, -0.0381198f, 0.975285f, -0.217420f, 0.507149f, -0.833983f, 
		-0.217347f, -0.848642f, -0.482253f, -0.217054f, 0.868454f, 0.445730f, 
		-0.216502f, -0.940450f, -0.262071f, -0.216501f, 0.425027f, 0.878908f, 
		-0.216460f, -0.940481f, -0.261994f, -0.216402f, -0.289990f, 0.932243f, 
		-0.216381f, 0.443120f, 0.869956f, -0.215944f, 0.877990f, 0.427202f, 
		-0.215493f, 0.921817f, 0.322206f, -0.215338f, -0.700389f, 0.680503f, 
		-0.215132f, -0.118437f, 0.969377f, -0.214641f, 0.514430f, -0.830235f, 
		-0.214521f, -0.964565f, -0.153607f, -0.213956f, 0.000813284f, -0.976843f, 
		-0.213082f, 0.594101f, -0.775655f, -0.212563f, -0.270442f, 0.938977f, 
		-0.212545f, 0.673933f, -0.707559f, -0.211777f, -0.976867f, -0.0296805f, 
		-0.211391f, 0.0860481f, 0.973606f, -0.211297f, 0.00601464f, 0.977403f, 
		-0.210953f, 0.918427f, 0.334650f, -0.210704f, -0.477905f, 0.852766f, 
		-0.210537f, -0.0732730f, 0.974836f, -0.210336f, -0.296933f, -0.931445f, 
		-0.209952f, -0.376832f, 0.902174f, -0.209947f, 0.0882226f, 0.973724f, 
		-0.209782f, 0.477700f, 0.853108f, -0.209692f, -0.871435f, -0.443431f, 
		-0.209672f, 0.931891f, 0.296002f, -0.209217f, -0.578644f, -0.788289f, 
		-0.209097f, 0.853565f, -0.477184f, -0.208942f, -0.977428f, 0.0312769f, 
		-0.208838f, 0.564795f, 0.798369f, -0.207945f, 0.756698f, 0.619813f, 
		-0.207740f, -0.351254f, -0.912943f, -0.207515f, 0.334836f, 0.919142f, 
		-0.206969f, -0.540072f, 0.815774f, -0.206882f, 0.831029f, 0.516324f, 
		-0.206877f, -0.842202f, 0.497893f, -0.206769f, -0.234090f, -0.949973f, 
		-0.206752f, -0.975973f, -0.0687713f, -0.206724f, 0.262831f, 0.942436f, 
		-0.206615f, 0.302971f, -0.930333f, -0.206531f, -0.820248f, 0.533422f, 
		-0.206520f, -0.277293f, 0.938327f, -0.206245f, 0.972303f, 0.109958f, 
		-0.206077f, 0.864460f, -0.458521f, -0.205830f, -0.970194f, 0.127900f, 
		-0.205810f, -0.890450f, -0.405883f, -0.205020f, 0.558406f, -0.803834f, 
		-0.204690f, 0.799089f, 0.565296f, -0.204656f, -0.581553f, 0.787345f, 
		-0.204451f, 0.924716f, 0.321092f, -0.204313f, -0.459733f, -0.864235f, 
		-0.204239f, -0.964932f, -0.164901f, -0.204112f, -0.435979f, -0.876505f, 
		-0.203929f, -0.696012f, 0.688462f, -0.203906f, -0.869629f, -0.449631f, 
		-0.203781f, 0.219818f, 0.954020f, -0.203706f, 0.280451f, -0.938004f, 
		-0.203585f, -0.596332f, 0.776492f, -0.203566f, 0.736230f, 0.645388f, 
		-0.203260f, 0.523778f, -0.827250f, -0.202745f, -0.366407f, -0.908097f, 
		-0.202006f, 0.624175f, 0.754718f, -0.201482f, -0.923507f, 0.326406f, 
		-0.201316f, -0.424176f, -0.882919f, -0.201048f, 0.441189f, -0.874604f, 
		-0.200776f, -0.970054f, 0.136689f, -0.200613f, 0.309304f, 0.929562f, 
		-0.200429f, -0.971630f, -0.125550f, -0.200363f, 0.494654f, -0.845678f, 
		-0.200307f, 0.241282f, -0.949558f, -0.200225f, 0.979377f, -0.0270185f, 
		-0.200008f, 0.849581f, -0.488067f, -0.199970f, 0.247926f, 0.947916f, 
		-0.199445f, 0.972650f, 0.119058f, -0.199395f, -0.248177f, -0.947971f, 
		-0.199085f, 0.837387f, 0.509065f, -0.198859f, 0.601229f, -0.773938f, 
		-0.198694f, 0.959707f, 0.198706f, -0.198678f, -0.502366f, 0.841520f, 
		-0.198610f, -0.920394f, -0.336792f, -0.197548f, 0.735133f, 0.648502f, 
		-0.197296f, 0.306292f, 0.931268f, -0.196419f, 0.978584f, 0.0615832f, 
		-0.196311f, 0.494088f, 0.846959f, -0.196237f, 0.360806f, 0.911762f, 
		-0.196211f, 0.748084f, 0.633934f, -0.195951f, 0.406049f, 0.892596f, 
		-0.195670f, 0.116367f, 0.973741f, -0.195648f, 0.392406f, -0.898744f, 
		-0.195500f, 0.717436f, -0.668629f, -0.195286f, 0.813956f, -0.547118f, 
		-0.195257f, 0.510794f, 0.837236f, -0.193931f, -0.0219468f, -0.980770f, 
		-0.193869f, 0.852321f, -0.485761f, -0.193767f, 0.596154f, 0.779137f, 
		-0.193553f, 0.331865f, 0.923257f, -0.193282f, 0.594212f, 0.780739f, 
		-0.192845f, -0.543708f, 0.816818f, -0.192819f, 0.671056f, -0.715894f, 
		-0.192284f, -0.0348561f, 0.980720f, -0.192234f, -0.398930f, 0.896605f, 
		-0.191715f, -0.902244f, -0.386266f, -0.191568f, 0.553407f, 0.810582f, 
		-0.191285f, 0.981535f, 0.000000f, -0.190810f, 0.0428221f, -0.980693f, 
		-0.190612f, -0.917294f, -0.349626f, -0.190531f, -0.424776f, -0.885022f, 
		-0.190238f, 0.747485f, -0.636456f, -0.189929f, -0.424078f, -0.885486f, 
		-0.189737f, -0.133808f, -0.972674f, -0.189136f, -0.770634f, 0.608565f, 
		-0.188773f, -0.891808f, -0.411148f, -0.188619f, 0.256853f, 0.947866f, 
		-0.188444f, 0.371355f, 0.909167f, -0.188402f, 0.388081f, -0.902163f, 
		-0.188384f, 0.0470078f, -0.980970f, -0.188115f, 0.266420f, 0.945322f, 
		-0.187940f, -0.407424f, -0.893691f, -0.187869f, 0.982036f, -0.0176010f, 
		-0.187853f, 0.921705f, 0.339368f, -0.187787f, 0.451340f, -0.872369f, 
		-0.187360f, -0.763861f, -0.617586f, -0.187246f, -0.883567f, 0.429242f, 
		-0.186626f, -0.538889f, -0.821443f, -0.186485f, 0.815751f, 0.547516f, 
		-0.186239f, -0.948204f, 0.257342f, -0.185897f, -0.504208f, 0.843337f, 
		-0.185811f, 0.846287f, 0.499272f, -0.185795f, 0.905611f, -0.381246f, 
		-0.185484f, 0.594111f, 0.782706f, -0.185204f, 0.465044f, 0.865698f, 
		-0.185118f, 0.424960f, -0.886082f, -0.185052f, 0.635204f, 0.749848f, 
		-0.184614f, 0.982806f, -0.00323778f, -0.184608f, 0.982807f, -0.00320660f, 
		-0.184563f, 0.982816f, -0.00320334f, -0.184145f, 0.634938f, -0.750296f, 
		-0.184077f, -0.512768f, -0.838561f, -0.183455f, 0.453858f, -0.871984f, 
		-0.183402f, 0.209635f, -0.960425f, -0.183303f, 0.480984f, 0.857353f, 
		-0.183264f, 0.418423f, -0.889571f, -0.182362f, 0.839183f, 0.512363f, 
		-0.182337f, -0.133863f, -0.974081f, -0.181884f, -0.974752f, 0.129523f, 
		-0.181846f, 0.756764f, -0.627886f, -0.181821f, 0.199364f, -0.962910f, 
		-0.181771f, -0.776539f, 0.603280f, -0.181735f, 0.199322f, -0.962935f, 
		-0.181260f, 0.572537f, -0.799591f, -0.180842f, -0.975708f, -0.123656f, 
		-0.180567f, -0.980937f, -0.0718234f, -0.180491f, 0.390558f, 0.902711f, 
		-0.180446f, -0.750494f, 0.635765f, -0.180036f, -0.383131f, -0.905979f, 
		-0.179924f, 0.784083f, 0.594004f, -0.179885f, -0.540598f, -0.821824f, 
		-0.179742f, -0.240919f, -0.953756f, -0.179730f, -0.982383f, 0.0511985f, 
		-0.179708f, 0.781342f, 0.597670f, -0.179540f, 0.800734f, 0.571481f, 
		-0.178975f, 0.662792f, 0.727101f, -0.178887f, -0.983693f, 0.0186340f, 
		-0.178852f, 0.642392f, -0.745214f, -0.178301f, -0.0871186f, -0.980112f, 
		-0.178264f, -0.738379f, 0.650399f, -0.177959f, 0.574340f, -0.799040f, 
		-0.177802f, 0.914760f, -0.362767f, -0.177733f, -0.976271f, -0.123717f, 
		-0.177573f, 0.138640f, 0.974293f, -0.177103f, 0.708059f, -0.683584f, 
		-0.176876f, 0.112650f, 0.977765f, -0.176275f, 0.186406f, 0.966530f, 
		-0.175846f, 0.339932f, -0.923864f, -0.175694f, 0.784400f, -0.594852f, 
		-0.175689f, -0.862542f, 0.474505f, -0.174592f, -0.524824f, 0.833113f, 
		-0.174302f, 0.669400f, 0.722165f, -0.174195f, -0.151954f, -0.972916f, 
		-0.174142f, 0.255058f, 0.951115f, -0.174035f, 0.749273f, 0.638984f, 
		-0.173913f, 0.838629f, 0.516194f, -0.173762f, -0.600981f, 0.780146f, 
		-0.173738f, -0.600986f, 0.780148f, -0.173438f, -0.409214f, -0.895803f, 
		-0.172812f, -0.980979f, -0.0884077f, -0.172661f, 0.383368f, -0.907313f, 
		-0.172638f, 0.984784f, 0.0199036f, -0.172361f, -0.256872f, 0.950951f, 
		-0.172131f, -0.596986f, 0.783568f, -0.171821f, -0.256316f, 0.951199f, 
		-0.171736f, 0.564260f, 0.807538f, -0.171621f, 0.165678f, 0.971132f, 
		-0.171252f, -0.960998f, 0.217152f, -0.170852f, 0.481809f, -0.859459f, 
		-0.170705f, -0.705757f, 0.687580f, -0.170217f, 0.772704f, 0.611518f, 
		-0.170032f, 0.369428f, 0.913571f, -0.169965f, 0.369479f, 0.913563f, 
		-0.169948f, -0.776567f, -0.606680f, -0.169799f, 0.675750f, 0.717307f, 
		-0.169363f, -0.952252f, 0.254031f, -0.169328f, -0.876570f, 0.450504f, 
		-0.168945f, 0.535965f, 0.827163f, -0.168800f, 0.724796f, 0.667965f, 
		-0.168796f, 0.484787f, -0.858190f, -0.168102f, 0.808260f, 0.564320f, 
		-0.167936f, -0.00375525f, 0.985791f, -0.167872f, -0.759911f, -0.627976f, 
		-0.167801f, 0.353491f, 0.920265f, -0.167752f, -0.981847f, 0.0885235f, 
		-0.167253f, -0.965519f, 0.199498f, -0.166550f, -0.970390f, -0.174944f, 
		-0.165841f, 0.228595f, -0.959292f, -0.165445f, -0.452560f, -0.876252f, 
		-0.165210f, 0.483598f, 0.859557f, -0.164982f, 0.217024f, 0.962123f, 
		-0.164972f, -0.0409818f, -0.985446f, -0.164909f, -0.949078f, 0.268431f, 
		-0.164731f, 0.797291f, -0.580682f, -0.164581f, 0.428888f, -0.888239f, 
		-0.164339f, 0.839850f, -0.517343f, -0.164138f, -0.977340f, -0.133662f, 
		-0.163929f, 0.0889800f, -0.982451f, -0.163721f, 0.517304f, 0.839996f, 
		-0.163562f, 0.388146f, 0.906967f, -0.163359f, 0.556532f, -0.814608f, 
		-0.162953f, -0.559051f, 0.812963f, -0.162769f, 0.554900f, -0.815838f, 
		-0.162492f, -0.760550f, -0.628617f, -0.162465f, -0.586920f, -0.793177f, 
		-0.162222f, 0.205986f, 0.965015f, -0.162092f, 0.653540f, 0.739332f, 
		-0.161929f, -0.541842f, 0.824734f, -0.161759f, 0.508587f, 0.845679f, 
		-0.161420f, -0.337070f, 0.927538f, -0.161415f, -0.115160f, -0.980145f, 
		-0.160852f, 0.819104f, 0.550632f, -0.160496f, -0.590292f, 0.791073f, 
		-0.160385f, -0.597002f, -0.786044f, -0.160150f, -0.986902f, -0.0193775f, 
		-0.160074f, -0.367338f, -0.916209f, -0.159920f, -0.881682f, -0.443916f, 
		-0.159834f, -0.975272f, 0.152638f, -0.159755f, -0.0218729f, -0.986914f, 
		-0.159436f, 0.424995f, 0.891044f, -0.159396f, 0.311488f, 0.936786f, 
		-0.159262f, -0.982585f, 0.0957228f, -0.158975f, -0.963516f, 0.215321f, 
		-0.158432f, -0.889768f, -0.428033f, -0.158162f, 0.524429f, -0.836636f, 
		-0.157994f, 0.861663f, -0.482259f, -0.157951f, 0.709823f, -0.686442f, 
		-0.157892f, 0.778942f, 0.606893f, -0.157709f, -0.490194f, 0.857227f, 
		-0.157437f, 0.820059f, -0.550197f, -0.156910f, 0.666106f, 0.729165f, 
		-0.156849f, -0.879363f, -0.449577f, -0.156666f, 0.424577f, 0.891734f, 
		-0.156594f, -0.922759f, 0.352128f, -0.156409f, 0.389535f, 0.907633f, 
		-0.156405f, 0.519570f, 0.839991f, -0.156044f, 0.796748f, -0.583817f, 
		-0.156008f, -0.986924f, 0.0405295f, -0.155975f, -0.911158f, 0.381395f, 
		-0.155923f, 0.314245f, -0.936450f, -0.155792f, 0.205722f, -0.966130f, 
		-0.155449f, 0.754205f, -0.637973f, -0.155422f, 0.789907f, -0.593204f, 
		-0.155397f, -0.926824f, -0.341831f, -0.155173f, -0.987838f, 0.00987156f, 
		-0.154974f, 0.672584f, 0.723612f, -0.154920f, 0.175045f, -0.972296f, 
		-0.154732f, 0.796212f, -0.584897f, -0.154465f, 0.337417f, 0.928596f, 
		-0.154384f, 0.918932f, -0.362945f, -0.154278f, -0.893399f, 0.421945f, 
		-0.154182f, 0.795276f, -0.586314f, -0.153997f, -0.882395f, 0.444595f, 
		-0.153895f, 0.903537f, 0.399922f, -0.153669f, 0.729145f, 0.666883f, 
		-0.153580f, 0.731874f, 0.663908f, -0.153577f, -0.981669f, 0.112874f, 
		-0.153478f, -0.178000f, -0.971988f, -0.152732f, -0.879573f, -0.450582f, 
		-0.152431f, 0.834005f, 0.530283f, -0.152318f, -0.680113f, 0.717109f, 
		-0.151628f, -0.498466f, 0.853546f, -0.151192f, 0.440833f, -0.884764f, 
		-0.151066f, 0.179525f, 0.972085f, -0.151058f, -0.986972f, 0.0553858f, 
		-0.150915f, 0.681437f, 0.716148f, -0.150881f, -0.910850f, -0.384171f, 
		-0.150855f, 0.847827f, 0.508362f, -0.150690f, 0.793341f, -0.589832f, 
		-0.150452f, -0.988530f, -0.0131654f, -0.150353f, -0.680862f, 0.716813f, 
		-0.150247f, -0.483689f, 0.862248f, -0.150102f, 0.788525f, -0.596405f, 
		-0.150075f, -0.0668280f, -0.986413f, -0.149999f, -0.900398f, -0.408392f, 
		-0.149778f, -0.988712f, -0.00386102f, -0.149632f, 0.559775f, 0.815023f, 
		-0.149536f, 0.799509f, 0.581743f, -0.149264f, 0.556855f, -0.817088f, 
		-0.148562f, 0.0980569f, -0.984029f, -0.147803f, 0.182669f, -0.972001f, 
		-0.147770f, -0.988398f, 0.0351148f, -0.147521f, 0.712234f, 0.686266f, 
		-0.147500f, 0.845593f, 0.513046f, -0.147464f, -0.988963f, -0.0143863f, 
		-0.147343f, 0.549467f, -0.822421f, -0.147317f, -0.985471f, 0.0845298f, 
		-0.147279f, 0.978067f, 0.147288f, -0.147279f, 0.978068f, -0.147279f, 
		-0.146886f, -0.987815f, 0.0514322f, -0.146751f, 0.922246f, -0.357669f, 
		-0.146488f, -0.985056f, -0.0905809f, -0.146441f, 0.209429f, 0.966796f, 
		-0.146065f, -0.963407f, 0.224747f, -0.145756f, 0.350649f, -0.925095f, 
		-0.145295f, -0.878161f, -0.455766f, -0.145076f, 0.539477f, 0.829408f, 
		-0.144599f, 0.204658f, 0.968094f, -0.144251f, -0.307573f, -0.940527f, 
		-0.144249f, -0.630018f, -0.763066f, -0.143597f, -0.291590f, 0.945704f, 
		-0.143361f, 0.457443f, 0.877607f, -0.143344f, 0.213950f, 0.966270f, 
		-0.143325f, 0.501020f, 0.853485f, -0.143114f, 0.570466f, -0.808757f, 
		-0.142717f, 0.355273f, 0.923804f, -0.142480f, -0.400861f, -0.904992f, 
		-0.142423f, 0.557339f, 0.817978f, -0.142372f, -0.929871f, -0.339219f, 
		-0.142370f, -0.979702f, -0.141123f, -0.142201f, -0.965593f, 0.217736f, 
		-0.142053f, 0.588435f, 0.795968f, -0.141933f, -0.866963f, -0.477735f, 
		-0.141814f, 0.695167f, -0.704720f, -0.141726f, -0.273820f, 0.951281f, 
		-0.141563f, 0.422735f, 0.895128f, -0.141374f, 0.0818200f, -0.986569f, 
		-0.141325f, 0.259976f, 0.955217f, -0.140843f, -0.909148f, -0.391935f, 
		-0.140760f, -0.483434f, -0.863990f, -0.139684f, 0.429144f, -0.892370f, 
		-0.139590f, 0.821195f, -0.553312f, -0.139537f, 0.643590f, -0.752543f, 
		-0.139488f, -0.920382f, -0.365295f, -0.139140f, -0.900378f, 0.412262f, 
		-0.138792f, -0.351505f, 0.925841f, -0.138495f, -0.0694335f, 0.987926f, 
		-0.138472f, -0.990327f, 0.00884661f, -0.138269f, -0.976628f, 0.164560f, 
		-0.137929f, -0.990430f, -0.00482677f, -0.137690f, -0.876169f, 0.461919f, 
		-0.137671f, -0.989300f, 0.0482841f, -0.137161f, -0.977340f, -0.161227f, 
		-0.137069f, 0.0194615f, 0.990370f, -0.137017f, 0.303201f, -0.943025f, 
		-0.136977f, -0.985396f, -0.101153f, -0.136782f, -0.979799f, -0.145891f, 
		-0.136614f, -0.490430f, 0.860706f, -0.136246f, 0.786508f, 0.602363f, 
		-0.136199f, 0.167584f, -0.976404f, -0.136039f, -0.458420f, -0.878262f, 
		-0.136017f, 0.811509f, -0.568289f, -0.135880f, 0.302967f, -0.943264f, 
		-0.135383f, 0.592873f, -0.793835f, -0.135329f, 0.867440f, -0.478784f, 
		-0.134854f, 0.340935f, 0.930364f, -0.134778f, -0.0327691f, -0.990334f, 
		-0.134502f, 0.829549f, -0.541994f, -0.134234f, -0.958203f, 0.252641f, 
		-0.133569f, -0.991025f, -0.00543749f, -0.133476f, 0.390293f, 0.910964f, 
		-0.133454f, 0.340321f, 0.930791f, -0.133390f, 0.811962f, -0.568265f, 
		-0.133323f, -0.810385f, -0.570527f, -0.133255f, 0.0797824f, -0.987865f, 
		-0.133204f, -0.691931f, 0.709569f, -0.132819f, -0.983911f, -0.119490f, 
		-0.132753f, 0.0472668f, -0.990021f, -0.132587f, -0.968406f, -0.211214f, 
		-0.132420f, 0.803907f, 0.579827f, -0.132213f, 0.791062f, 0.597278f, 
		-0.132160f, -0.912990f, 0.385983f, -0.131700f, 0.259155f, -0.956814f, 
		-0.131038f, -0.983595f, 0.123976f, -0.130826f, -0.908854f, -0.396067f, 
		-0.130765f, -0.931632f, 0.339062f, -0.130572f, 0.730759f, -0.670031f, 
		-0.130453f, 0.257379f, -0.957464f, -0.130402f, -0.989167f, 0.0674067f, 
		-0.130247f, -0.571164f, 0.810437f, -0.129423f, -0.969039f, -0.210268f, 
		-0.127941f, -0.945494f, -0.299453f, -0.127876f, -0.892871f, 0.431774f, 
		-0.127412f, 0.264743f, -0.955865f, -0.126768f, -0.929439f, -0.346516f, 
		-0.126728f, -0.982718f, 0.134925f, -0.126699f, 0.725397f, -0.676570f, 
		-0.125660f, -0.888192f, -0.441956f, -0.125409f, 0.899150f, 0.419286f, 
		-0.125253f, 0.217364f, -0.968021f, -0.125048f, 0.0951316f, 0.987579f, 
		-0.124694f, 0.0227220f, -0.991935f, -0.124190f, -0.981886f, 0.143095f, 
		-0.124140f, -0.925351f, 0.358211f, -0.124053f, 0.354689f, 0.926718f, 
		-0.124005f, -0.455501f, -0.881556f, -0.123988f, -0.988710f, -0.0841403f, 
		-0.123917f, -0.238271f, -0.963261f, -0.123282f, -0.730920f, -0.671236f, 
		-0.123235f, -0.990843f, -0.0551688f, -0.123120f, -0.925818f, 0.357355f, 
		-0.122957f, 0.317043f, -0.940407f, -0.122921f, 0.895253f, 0.428266f, 
		-0.122637f, 0.838274f, 0.531278f, -0.122624f, 0.338312f, -0.933010f, 
		-0.122601f, 0.140538f, 0.982455f, -0.122522f, -0.268488f, -0.955459f, 
		-0.122080f, -0.438632f, -0.890336f, -0.121199f, 0.926597f, -0.355989f, 
		-0.121156f, 0.104687f, -0.987098f, -0.121064f, 0.452799f, 0.883355f, 
		-0.120701f, 0.883059f, -0.453474f, -0.120696f, 0.166790f, -0.978577f, 
		-0.120679f, 0.808355f, -0.576193f, -0.120357f, 0.343845f, 0.931281f, 
		-0.120109f, -0.878198f, -0.462972f, -0.119563f, -0.956246f, 0.267017f, 
		-0.119332f, -0.456944f, 0.881454f, -0.119138f, -0.161908f, 0.979588f, 
		-0.118871f, 0.933111f, -0.339371f, -0.118866f, -0.834622f, -0.537845f, 
		-0.118781f, -0.460834f, -0.879502f, -0.118547f, 0.210534f, 0.970372f, 
		-0.118396f, 0.702525f, 0.701742f, -0.118340f, -0.0924426f, 0.988661f, 
		-0.118339f, -0.835019f, -0.537345f, -0.118219f, 0.468667f, -0.875429f, 
		-0.118023f, -0.131830f, 0.984221f, -0.117909f, 0.677668f, -0.725854f, 
		-0.117447f, 0.993005f, -0.0121379f, -0.117355f, 0.993017f, -0.0120318f, 
		-0.117349f, 0.0356675f, 0.992450f, -0.117141f, 0.488201f, 0.864834f, 
		-0.117132f, -0.118830f, -0.985981f, -0.116766f, -0.914630f, 0.387062f, 
		-0.116737f, 0.119320f, 0.985969f, -0.116236f, 0.123004f, -0.985576f, 
		-0.116195f, 0.371331f, -0.921202f, -0.116130f, -0.984286f, -0.133023f, 
		-0.115681f, -0.433427f, -0.893733f, -0.115194f, 0.214170f, 0.969980f, 
		-0.115183f, 0.906285f, -0.406671f, -0.115153f, 0.341576f, -0.932773f, 
		-0.115152f, -0.685137f, -0.719254f, -0.115151f, 0.906288f, -0.406672f, 
		-0.114952f, 0.375797f, 0.919545f, -0.114819f, 0.993385f, -0.00176774f, 
		-0.114592f, 0.250573f, -0.961292f, -0.114458f, -0.339106f, 0.933760f, 
		-0.114416f, -0.667418f, -0.735841f, -0.114230f, 0.0802351f, -0.990209f, 
		-0.114093f, 0.332415f, -0.936207f, -0.113967f, -0.992489f, -0.0444566f, 
		-0.113530f, -0.771861f, -0.625573f, -0.113170f, -0.492766f, -0.862772f, 
		-0.112262f, -0.446046f, -0.887942f, -0.112261f, -0.475936f, -0.872285f, 
		-0.112194f, 0.395489f, 0.911592f, -0.111869f, -0.992195f, -0.0550791f, 
		-0.111515f, -0.449218f, 0.886435f, -0.111461f, 0.0828632f, 0.990308f, 
		-0.111198f, 0.752070f, 0.649635f, -0.110825f, 0.746139f, 0.656502f, 
		-0.110763f, -0.989140f, 0.0966134f, -0.110416f, 0.313841f, 0.943034f, 
		-0.110402f, -0.901413f, -0.418648f, -0.110297f, -0.764873f, -0.634668f, 
		-0.110191f, -0.990575f, -0.0813532f, -0.109948f, -0.992456f, 0.0542374f, 
		-0.109709f, 0.319588f, -0.941184f, -0.109525f, 0.421521f, -0.900180f, 
		-0.109439f, -0.961767f, 0.251051f, -0.109018f, -0.992359f, -0.0577767f, 
		-0.107975f, -0.742908f, 0.660627f, -0.107840f, -0.172819f, -0.979032f, 
		-0.107706f, -0.977055f, 0.183746f, -0.107559f, -0.989259f, -0.0989884f, 
		-0.107423f, 0.0103447f, -0.994160f, -0.107317f, 0.321131f, -0.940934f, 
		-0.107038f, -0.464021f, -0.879333f, -0.106796f, -0.623234f, 0.774709f, 
		-0.106473f, -0.753494f, -0.648777f, -0.106359f, -0.225162f, 0.968499f, 
		-0.106272f, 0.830307f, -0.547080f, -0.105987f, 0.287212f, -0.951985f, 
		-0.105977f, -0.429998f, -0.896588f, -0.105188f, 0.686108f, -0.719855f, 
		-0.104870f, 0.697497f, -0.708873f, -0.104827f, 0.0412236f, -0.993636f, 
		-0.104785f, 0.549639f, -0.828804f, -0.104649f, 0.464182f, -0.879536f, 
		-0.104563f, 0.970382f, 0.217772f, -0.104176f, 0.400630f, 0.910298f, 
		-0.103769f, -0.180878f, -0.978016f, -0.103681f, 0.421468f, -0.900897f, 
		-0.103551f, -0.645302f, 0.756877f, -0.103310f, 0.369602f, 0.923429f, 
		-0.103299f, -0.990248f, -0.0934800f, -0.103265f, -0.203907f, -0.973529f, 
		-0.103151f, -0.178934f, -0.978439f, -0.102552f, 0.262564f, 0.959450f, 
		-0.102164f, -0.903082f, -0.417140f, -0.102119f, -0.446497f, -0.888939f, 
		-0.102104f, -0.989599f, -0.101332f, -0.101808f, 0.443435f, -0.890506f, 
		-0.101691f, -0.993504f, 0.0510697f, -0.101479f, -0.993460f, -0.0523446f, 
		-0.101373f, 0.932682f, -0.346162f, -0.101113f, 0.177104f, 0.978984f, 
		-0.100948f, 0.821799f, 0.560764f, -0.100794f, -0.986262f, -0.130873f, 
		-0.100755f, 0.193757f, 0.975862f, -0.100654f, -0.457451f, -0.883520f, 
		-0.100401f, -0.850061f, 0.517026f, -0.100356f, -0.786004f, -0.610022f, 
		-0.0999673f, 0.838505f, -0.535646f, -0.0999576f, 0.310784f, 0.945210f, 
		-0.0990399f, 0.107291f, 0.989282f, -0.0989758f, 0.249055f, 0.963419f, 
		-0.0989043f, 0.312072f, 0.944896f, -0.0986312f, 0.818604f, 0.565826f, 
		-0.0984215f, -0.989714f, -0.103819f, -0.0981688f, -0.0257304f, -0.994837f, 
		-0.0980913f, 0.0682738f, 0.992833f, -0.0980270f, -0.655902f, -0.748454f, 
		-0.0977544f, 0.610931f, -0.785625f, -0.0976473f, -0.796253f, 0.597031f, 
		-0.0976466f, -0.625818f, 0.773833f, -0.0972614f, 0.995042f, -0.0207581f, 
		-0.0971594f, -0.894109f, -0.437183f, -0.0970711f, -0.134570f, 0.986138f, 
		-0.0970163f, 0.186026f, 0.977743f, -0.0968966f, -0.483494f, 0.869968f, 
		-0.0968820f, 0.628645f, 0.771634f, -0.0968555f, -0.917498f, -0.385767f, 
		-0.0966677f, -0.679486f, -0.727292f, -0.0964555f, -0.995076f, -0.0227918f, 
		-0.0963467f, 0.444119f, 0.890773f, -0.0962632f, -0.986003f, -0.136129f, 
		-0.0960254f, 0.0543571f, -0.993894f, -0.0959486f, 0.137593f, -0.985831f, 
		-0.0954631f, -0.776302f, -0.623090f, -0.0954476f, -0.110334f, -0.989301f, 
		-0.0949883f, 0.135617f, -0.986197f, -0.0946652f, -0.995508f, 0.00127593f, 
		-0.0945840f, 0.992949f, 0.0714533f, -0.0944672f, 0.319277f, -0.942941f, 
		-0.0943097f, -0.988173f, 0.120911f, -0.0940577f, -0.962332f, -0.255088f, 
		-0.0939354f, 0.402382f, 0.910640f, -0.0936179f, -0.276987f, 0.956302f, 
		-0.0935918f, -0.995334f, 0.0234577f, -0.0934960f, -0.990280f, -0.102980f, 
		-0.0932086f, -0.989972f, 0.106152f, -0.0930636f, -0.427317f, -0.899299f, 
		-0.0925979f, 0.144959f, 0.985095f, -0.0924740f, 0.942988f, -0.319721f, 
		-0.0924140f, 0.595944f, 0.797690f, -0.0923896f, -0.412745f, -0.906149f, 
		-0.0921603f, 0.850734f, 0.517453f, -0.0920283f, 0.686195f, -0.721573f, 
		-0.0920084f, 0.373142f, 0.923201f, -0.0919991f, 0.222158f, -0.970661f, 
		-0.0917809f, -0.557435f, 0.825132f, -0.0916766f, -0.917295f, -0.387511f, 
		-0.0916362f, -0.850921f, 0.517238f, -0.0915859f, -0.786664f, 0.610551f, 
		-0.0915770f, -0.752579f, -0.652103f, -0.0915683f, 0.833707f, -0.544562f, 
		-0.0915118f, -0.528930f, -0.843717f, -0.0913903f, 0.509662f, -0.855507f, 
		-0.0913075f, -0.845591f, 0.525964f, -0.0912947f, -0.372880f, 0.923377f, 
		-0.0912941f, 0.717275f, 0.690783f, -0.0907709f, -0.994373f, 0.0546200f, 
		-0.0906238f, -0.169609f, -0.981336f, -0.0905485f, 0.772506f, -0.628519f, 
		-0.0900087f, 0.0227231f, 0.995682f, -0.0898743f, -0.983443f, -0.157358f, 
		-0.0898656f, -0.983452f, -0.157313f, -0.0898335f, -0.520789f, 0.848946f, 
		-0.0897784f, -0.681140f, -0.726628f, -0.0897347f, -0.995697f, 0.0231343f, 
		-0.0897274f, 0.196725f, -0.976344f, -0.0893478f, -0.990490f, 0.104627f, 
		-0.0892060f, 0.170338f, 0.981340f, -0.0890674f, -0.874135f, -0.477447f, 
		-0.0888150f, -0.904679f, 0.416736f, -0.0887654f, -0.693904f, 0.714575f, 
		-0.0886525f, -0.995911f, -0.0173755f, -0.0882227f, -0.873958f, -0.477926f, 
		-0.0882148f, 0.507621f, -0.857052f, -0.0877541f, 0.532889f, -0.841623f, 
		-0.0877459f, -0.996116f, 0.00738303f, -0.0876314f, -0.996112f, -0.00905025f, 
		-0.0874737f, -0.996167f, -0.000574805f, -0.0870841f, -0.943479f, 0.319786f, 
		-0.0870823f, -0.943492f, 0.319749f, -0.0869599f, 0.246991f, 0.965108f, 
		-0.0869527f, -0.996135f, -0.0124109f, -0.0866052f, 0.368628f, 0.925534f, 
		-0.0865055f, 0.176617f, -0.980471f, -0.0863850f, -0.923146f, 0.374618f, 
		-0.0863466f, 0.835456f, -0.542731f, -0.0862740f, 0.0551600f, 0.994743f, 
		-0.0858825f, 0.878571f, -0.469827f, -0.0858569f, -0.989540f, -0.115924f, 
		-0.0857016f, 0.153749f, 0.984386f, -0.0856581f, -0.532937f, 0.841808f, 
		-0.0856507f, 0.159979f, 0.983398f, -0.0851785f, 0.545813f, -0.833566f, 
		-0.0850441f, -0.873378f, -0.479560f, -0.0850039f, -0.735006f, 0.672711f, 
		-0.0849352f, -0.995727f, 0.0362459f, -0.0849128f, 0.449023f, -0.889476f, 
		-0.0845617f, -0.800797f, -0.592937f, -0.0845111f, -0.735091f, 0.672680f, 
		-0.0840937f, 0.483579f, -0.871252f, -0.0840060f, 0.186806f, 0.978798f, 
		-0.0839564f, 0.589708f, -0.803241f, -0.0838361f, 0.0399280f, -0.995679f, 
		-0.0837769f, 0.690204f, -0.718748f, -0.0836207f, 0.848989f, 0.521752f, 
		-0.0829440f, 0.693815f, -0.715361f, -0.0825433f, 0.755309f, -0.650150f, 
		-0.0820143f, 0.593449f, 0.800682f, -0.0819193f, -0.117144f, 0.989730f, 
		-0.0817765f, 0.534898f, 0.840950f, -0.0812117f, -0.847365f, -0.524763f, 
		-0.0811722f, -0.817242f, -0.570550f, -0.0811543f, -0.985811f, 0.146938f, 
		-0.0809642f, -0.992877f, -0.0874098f, -0.0806759f, -0.935565f, 0.343816f, 
		-0.0805729f, -0.909075f, 0.408767f, -0.0805201f, 0.0782927f, 0.993673f, 
		-0.0802688f, -0.637308f, 0.766418f, -0.0800942f, -0.898238f, -0.432150f, 
		-0.0795618f, 0.791745f, 0.605648f, -0.0792281f, 0.327253f, 0.941610f, 
		-0.0783681f, 0.920815f, 0.382045f, -0.0783401f, -0.0491994f, -0.995712f, 
		-0.0782309f, 0.745845f, -0.661510f, -0.0781961f, -0.510585f, -0.856264f, 
		-0.0781727f, -0.0180190f, -0.996777f, -0.0779969f, 0.571417f, 0.816945f, 
		-0.0777082f, -0.666688f, -0.741275f, -0.0774156f, 0.795030f, -0.601609f, 
		-0.0770417f, 0.309357f, 0.947820f, -0.0769956f, -0.996922f, -0.0147857f, 
		-0.0767864f, -0.820186f, 0.566921f, -0.0754320f, 0.524620f, -0.847988f, 
		-0.0754068f, 0.501247f, 0.862012f, -0.0749557f, 0.409190f, 0.909365f, 
		-0.0748461f, 0.345452f, -0.935447f, -0.0744978f, -0.253740f, 0.964399f, 
		-0.0742201f, -0.994126f, 0.0787646f, -0.0741501f, -0.143069f, 0.986931f, 
		-0.0741349f, -0.134514f, -0.988135f, -0.0741273f, 0.506834f, -0.858851f, 
		-0.0739976f, -0.217118f, 0.973337f, -0.0733717f, -0.575643f, -0.814403f, 
		-0.0733171f, -0.662750f, -0.745243f, -0.0728062f, -0.364659f, 0.928290f, 
		-0.0727953f, -0.983535f, -0.165407f, -0.0724387f, -0.917081f, 0.392065f, 
		-0.0722278f, -0.873005f, -0.482334f, -0.0720214f, -0.997396f, 0.00388841f, 
		-0.0717556f, -0.0730912f, 0.994741f, -0.0715578f, -0.576451f, 0.813992f, 
		-0.0715272f, -0.183453f, -0.980423f, -0.0714074f, -0.905671f, 0.417924f, 
		-0.0713819f, 0.663735f, -0.744554f, -0.0712178f, -0.515239f, 0.854082f, 
		-0.0709870f, 0.0992762f, -0.992525f, -0.0709378f, -0.551111f, 0.831411f, 
		-0.0709174f, -0.340603f, 0.937529f, -0.0708308f, 0.291063f, 0.954078f, 
		-0.0708246f, 0.542501f, 0.837064f, -0.0705910f, -0.903134f, -0.423517f, 
		-0.0704689f, -0.150652f, -0.986072f, -0.0704141f, 0.259926f, -0.963058f, 
		-0.0702878f, -0.197608f, -0.977758f, -0.0702847f, 0.0217295f, 0.997290f, 
		-0.0701430f, 0.667366f, -0.741420f, -0.0699753f, 0.673995f, -0.735414f, 
		-0.0697615f, 0.462207f, -0.884024f, -0.0695770f, 0.128804f, -0.989226f, 
		-0.0692519f, -0.536166f, -0.841267f, -0.0692293f, 0.317886f, 0.945598f, 
		-0.0690914f, -0.806625f, -0.587012f, -0.0688690f, 0.208957f, 0.975497f, 
		-0.0687402f, -0.0320175f, -0.997121f, -0.0684563f, 0.521090f, -0.850752f, 
		-0.0677833f, -0.832051f, 0.550542f, -0.0675772f, 0.354739f, 0.932520f, 
		-0.0673185f, 0.631636f, 0.772337f, -0.0671616f, -0.564456f, -0.822727f, 
		-0.0671113f, 0.317183f, 0.945987f, -0.0669157f, 0.316907f, 0.946093f, 
		-0.0669155f, 0.309344f, -0.948593f, -0.0667008f, -0.444198f, -0.893442f, 
		-0.0666148f, -0.995191f, 0.0718197f, -0.0656554f, 0.0638977f, -0.995794f, 
		-0.0656372f, 0.0638997f, -0.995795f, -0.0655151f, -0.618630f, -0.782946f, 
		-0.0654345f, -0.250128f, 0.965999f, -0.0653569f, -0.993297f, 0.0953341f, 
		-0.0650426f, 0.589723f, 0.804982f, -0.0644045f, -0.986325f, -0.151710f, 
		-0.0643571f, 0.353627f, -0.933170f, -0.0643216f, -0.809156f, -0.584062f, 
		-0.0640771f, 0.184633f, -0.980717f, -0.0635715f, -0.707627f, -0.703721f, 
		-0.0631971f, -0.214321f, 0.974717f, -0.0631324f, -0.417082f, -0.906673f, 
		-0.0628210f, 0.535751f, -0.842036f, -0.0626230f, -0.992558f, 0.104438f, 
		-0.0623114f, 0.874298f, 0.481374f, -0.0621674f, -0.987992f, 0.141446f, 
		-0.0619964f, 0.522721f, -0.850246f, -0.0619417f, -0.316215f, 0.946663f, 
		-0.0618969f, -0.988046f, 0.141185f, -0.0618578f, 0.381120f, 0.922454f, 
		-0.0618326f, -0.997549f, -0.0327495f, -0.0613989f, -0.997560f, -0.0332261f, 
		-0.0613257f, -0.896104f, 0.439586f, -0.0608505f, -0.137852f, -0.988582f, 
		-0.0608164f, 0.657580f, 0.750926f, -0.0607862f, -0.873646f, 0.482750f, 
		-0.0606960f, -0.996388f, 0.0593961f, -0.0605907f, -0.119925f, -0.990932f, 
		-0.0604909f, -0.998096f, 0.0120556f, -0.0603106f, -0.903473f, -0.424382f, 
		-0.0600358f, 0.803338f, 0.592490f, -0.0599812f, -0.998192f, -0.00390924f, 
		-0.0598284f, -0.997577f, -0.0355133f, -0.0593066f, 0.938878f, -0.339103f, 
		-0.0590978f, -0.439188f, -0.896449f, -0.0588511f, 0.458015f, 0.886994f, 
		-0.0585818f, -0.953985f, -0.294075f, -0.0582959f, 0.680430f, -0.730491f, 
		-0.0567329f, -0.920777f, -0.385941f, -0.0566789f, 0.589957f, 0.805443f, 
		-0.0566473f, -0.981873f, 0.180875f, -0.0563792f, 0.773089f, 0.631787f, 
		-0.0562989f, -0.223128f, 0.973162f, -0.0562888f, 0.100460f, 0.993348f, 
		-0.0562284f, -0.899273f, 0.433758f, -0.0561302f, -0.158152f, -0.985818f, 
		-0.0561088f, -0.158143f, -0.985821f, -0.0559578f, 0.681352f, 0.729814f, 
		-0.0558546f, 0.913144f, -0.403793f, -0.0557986f, -0.998423f, -0.00611771f, 
		-0.0557980f, -0.871457f, -0.487288f, -0.0556772f, 0.393861f, -0.917482f, 
		-0.0550302f, -0.486039f, -0.872203f, -0.0549166f, -0.984272f, -0.167906f, 
		-0.0546678f, 0.773377f, 0.631585f, -0.0542697f, -0.895302f, 0.442143f, 
		-0.0542398f, -0.700993f, -0.711103f, -0.0540187f, 0.170422f, -0.983889f, 
		-0.0539582f, 0.663856f, 0.745911f, -0.0537278f, 0.159309f, -0.985766f, 
		-0.0536095f, -0.997170f, 0.0526989f, -0.0536006f, 0.835424f, 0.546986f, 
		-0.0535055f, 0.373198f, -0.926208f, -0.0533239f, -0.426444f, 0.902941f, 
		-0.0532595f, -0.998251f, 0.0256756f, -0.0531391f, 0.133161f, 0.989669f, 
		-0.0530105f, -0.890094f, -0.452684f, -0.0529884f, -0.997109f, 0.0544523f, 
		-0.0527575f, -0.998000f, 0.0348136f, -0.0527566f, -0.998004f, 0.0347064f, 
		-0.0527234f, -0.262648f, -0.963450f, -0.0525753f, -0.00807578f, 0.998584f, 
		-0.0524051f, 0.0446397f, -0.997628f, -0.0523213f, 0.134060f, -0.989591f, 
		-0.0522194f, -0.0888437f, -0.994676f, -0.0521766f, 0.472824f, 0.879611f, 
		-0.0521035f, 0.233798f, -0.970888f, -0.0518073f, -0.201536f, -0.978110f, 
		-0.0516044f, -0.0891780f, 0.994678f, -0.0515931f, -0.959799f, -0.275907f, 
		-0.0513616f, -0.998218f, 0.0303620f, -0.0512059f, 0.564246f, 0.824017f, 
		-0.0511522f, 0.831826f, -0.552675f, -0.0509687f, 0.965096f, -0.256890f, 
		-0.0503439f, -0.192950f, -0.979916f, -0.0502291f, -0.998398f, 0.0260595f, 
		-0.0502046f, -0.998455f, 0.0238030f, -0.0501803f, -0.728170f, 0.683557f, 
		-0.0501250f, -0.841915f, -0.537277f, -0.0498557f, 0.824464f, -0.563714f, 
		-0.0498196f, 0.242485f, -0.968875f, -0.0497645f, 0.127997f, 0.990525f, 
		-0.0496298f, -0.464069f, -0.884408f, -0.0495470f, 0.374049f, -0.926084f, 
		-0.0495209f, 0.0447752f, 0.997769f, -0.0494305f, 0.576968f, -0.815269f, 
		-0.0493919f, -0.343217f, -0.937957f, -0.0492394f, -0.351742f, 0.934801f, 
		-0.0492178f, 0.640824f, 0.766109f, -0.0491898f, -0.985985f, 0.159415f, 
		-0.0487593f, -0.761278f, -0.646590f, -0.0486650f, -0.998697f, 0.0153871f, 
		-0.0486518f, 0.797699f, -0.601090f, -0.0483040f, 0.872535f, -0.486158f, 
		-0.0481709f, -0.560093f, 0.827028f, -0.0480276f, 0.982449f, -0.180241f, 
		-0.0479411f, -0.998594f, 0.0225997f, -0.0476255f, -0.998291f, -0.0338532f, 
		-0.0472777f, -0.998369f, -0.0320029f, -0.0470332f, -0.994375f, 0.0949053f, 
		-0.0469244f, -0.987998f, -0.147169f, -0.0463424f, -0.998810f, 0.0152194f, 
		-0.0463177f, -0.110729f, -0.992771f, -0.0462993f, 0.286627f, 0.956923f, 
		-0.0461274f, 0.219719f, 0.974472f, -0.0460336f, -0.498398f, 0.865725f, 
		-0.0458528f, 0.0910113f, -0.994794f, -0.0458421f, -0.978098f, 0.203033f, 
		-0.0453632f, -0.709332f, -0.703414f, -0.0446203f, 0.279960f, -0.958974f, 
		-0.0444622f, -0.989890f, -0.134687f, -0.0443463f, 0.494958f, 0.867785f, 
		-0.0443416f, 0.548199f, -0.835171f, -0.0442306f, -0.401863f, 0.914631f, 
		-0.0442190f, 0.115687f, 0.992301f, -0.0442142f, -0.998894f, -0.0159912f, 
		-0.0441731f, 0.0375015f, 0.998320f, -0.0440892f, -0.995042f, 0.0891537f, 
		-0.0440768f, 0.453046f, 0.890397f, -0.0440607f, 0.343670f, 0.938056f, 
		-0.0439495f, -0.517060f, 0.854820f, -0.0432383f, -0.203574f, -0.978104f, 
		-0.0431941f, 0.636687f, 0.769912f, -0.0429644f, 0.413802f, 0.909353f, 
		-0.0429184f, -0.997574f, 0.0548108f, -0.0426776f, -0.628504f, -0.776635f, 
		-0.0423744f, 0.452250f, 0.890884f, -0.0420760f, -0.998765f, 0.0264304f, 
		-0.0419356f, -0.107755f, -0.993293f, -0.0418712f, 0.523884f, 0.850760f, 
		-0.0416147f, 0.854732f, 0.517398f, -0.0415084f, -0.987242f, -0.153720f, 
		-0.0412954f, -0.553910f, 0.831552f, -0.0411135f, 0.414082f, 0.909311f, 
		-0.0408741f, -0.568508f, -0.821662f, -0.0406309f, 0.582372f, -0.811907f, 
		-0.0405898f, -0.457505f, 0.888280f, -0.0404300f, -0.709321f, -0.703725f, 
		-0.0401774f, -0.998131f, 0.0460414f, -0.0399250f, -0.999069f, -0.0163591f, 
		-0.0397919f, -0.997288f, -0.0619147f, -0.0396437f, -0.276828f, 0.960101f, 
		-0.0396183f, 0.609788f, 0.791574f, -0.0395842f, 0.00114994f, 0.999216f, 
		-0.0394961f, -0.155007f, 0.987123f, -0.0393165f, -0.988801f, -0.143971f, 
		-0.0392822f, 0.398727f, 0.916228f, -0.0390414f, -0.965340f, 0.258060f, 
		-0.0389141f, -0.0194441f, -0.999053f, -0.0389138f, 0.373413f, 0.926849f, 
		-0.0388676f, -0.999162f, -0.0128284f, -0.0387938f, -0.285297f, 0.957654f, 
		-0.0386867f, 0.409222f, 0.911614f, -0.0386528f, 0.409301f, 0.911580f, 
		-0.0386397f, 0.0558112f, 0.997693f, -0.0383453f, -0.808650f, -0.587039f, 
		-0.0382245f, -0.997241f, -0.0636318f, -0.0381519f, -0.0114391f, 0.999206f, 
		-0.0380715f, -0.811391f, -0.583263f, -0.0378625f, 0.834221f, 0.550129f, 
		-0.0375839f, -0.997295f, -0.0631611f, -0.0374670f, 0.792487f, 0.608737f, 
		-0.0373491f, -0.991944f, -0.121043f, -0.0370529f, 0.274307f, 0.960928f, 
		-0.0367530f, -0.127008f, 0.991221f, -0.0366902f, -0.999031f, -0.0242962f, 
		-0.0365236f, -0.877516f, -0.478155f, -0.0361453f, 0.759672f, 0.649301f, 
		-0.0361171f, -0.364694f, 0.930427f, -0.0357662f, 0.0450977f, 0.998342f, 
		-0.0357473f, 0.789584f, -0.612600f, -0.0356948f, 0.874368f, -0.483948f, 
		-0.0356738f, -0.988060f, -0.149880f, -0.0356501f, 0.874349f, -0.483986f, 
		-0.0355594f, 0.249620f, -0.967691f, -0.0355569f, -0.984051f, 0.174295f, 
		-0.0346983f, -0.0565054f, -0.997799f, -0.0346954f, 0.826285f, -0.562183f, 
		-0.0346913f, 0.960673f, -0.275508f, -0.0345028f, 0.941949f, -0.333980f, 
		-0.0344795f, -0.983995f, 0.174831f, -0.0344684f, 0.635799f, -0.771085f, 
		-0.0344346f, -0.933273f, -0.357513f, -0.0343337f, 0.393765f, -0.918570f, 
		-0.0340633f, 0.580854f, 0.813295f, -0.0338391f, -0.998405f, 0.0452035f, 
		-0.0334930f, -0.955828f, -0.292014f, -0.0330931f, 0.788362f, -0.614321f, 
		-0.0329951f, 0.849844f, -0.526000f, -0.0329860f, -0.574521f, -0.817825f, 
		-0.0329588f, 0.818008f, 0.574261f, -0.0329329f, 0.818044f, 0.574212f, 
		-0.0328911f, 0.745147f, 0.666089f, -0.0327540f, 0.922931f, 0.383569f, 
		-0.0327457f, 0.250640f, -0.967526f, -0.0327146f, 0.926136f, 0.375767f, 
		-0.0324479f, 0.111632f, 0.993220f, -0.0322115f, 0.259193f, -0.965288f, 
		-0.0321025f, -0.439501f, 0.897668f, -0.0319388f, 0.811653f, 0.583266f, 
		-0.0317404f, -0.0834984f, -0.996002f, -0.0317353f, 0.703836f, 0.709653f, 
		-0.0317151f, -0.999381f, 0.0152481f, -0.0316243f, 0.278658f, 0.959870f, 
		-0.0315912f, -0.999301f, 0.0199881f, -0.0315137f, -0.646687f, 0.762104f, 
		-0.0313868f, -0.997483f, -0.0635822f, -0.0313300f, -0.998579f, 0.0431087f, 
		-0.0312118f, -0.999474f, 0.00879765f, -0.0311478f, -0.875496f, 0.482221f, 
		-0.0310808f, 0.356341f, 0.933839f, -0.0305875f, 0.834212f, 0.550595f, 
		-0.0305417f, -0.998638f, 0.0422957f, -0.0304438f, 0.811110f, 0.584101f, 
		-0.0304103f, -0.988986f, -0.144849f, -0.0303593f, 0.637271f, -0.770042f, 
		-0.0301859f, 0.0706378f, -0.997045f, -0.0300918f, -0.807032f, -0.589741f, 
		-0.0300626f, -0.999547f, -0.00146809f, -0.0299241f, 0.636038f, -0.771077f, 
		-0.0298327f, -0.651904f, -0.757714f, -0.0295449f, -0.361006f, 0.932096f, 
		-0.0293370f, -0.00316639f, 0.999565f, -0.0293074f, -0.993697f, 0.108196f, 
		-0.0293032f, -0.992648f, -0.117437f, -0.0292217f, 0.759008f, 0.650425f, 
		-0.0289069f, -0.999488f, 0.0136964f, -0.0288067f, -0.999582f, -0.00243639f, 
		-0.0286016f, -0.805572f, -0.591807f, -0.0285851f, 0.993639f, 0.108920f, 
		-0.0285092f, 0.120562f, -0.992296f, -0.0281107f, -0.107632f, 0.993793f, 
		-0.0280985f, -0.992807f, -0.116381f, -0.0280782f, -0.429186f, -0.902780f, 
		-0.0278555f, -0.499947f, -0.865608f, -0.0278458f, 0.610569f, -0.791473f, 
		-0.0277336f, 0.836508f, 0.547252f, -0.0275479f, 0.671109f, -0.740846f, 
		-0.0272964f, 0.999456f, -0.0185039f, -0.0272451f, -0.990119f, 0.137556f, 
		-0.0269262f, 0.965582f, -0.258702f, -0.0269117f, -0.990235f, 0.136785f, 
		-0.0268275f, -0.499268f, -0.866032f, -0.0265233f, 0.789089f, -0.613706f, 
		-0.0264637f, 0.711685f, 0.702000f, -0.0263068f, 0.881727f, 0.471026f, 
		-0.0257152f, -0.611823f, -0.790576f, -0.0256419f, -0.729119f, -0.683906f, 
		-0.0252757f, 0.302510f, -0.952811f, -0.0249716f, 0.809473f, 0.586626f, 
		-0.0249687f, 0.264506f, 0.964061f, -0.0248988f, 0.583828f, 0.811495f, 
		-0.0247022f, 0.838161f, 0.544864f, -0.0241914f, 0.892330f, -0.450735f, 
		-0.0240930f, -0.379586f, 0.924843f, -0.0238765f, -0.994100f, -0.105807f, 
		-0.0238366f, -0.452976f, -0.891204f, -0.0237445f, 0.432105f, 0.901511f, 
		-0.0237340f, -0.977859f, 0.207914f, -0.0233902f, -0.0382111f, 0.998996f, 
		-0.0232016f, 0.275140f, 0.961124f, -0.0228876f, 0.311676f, 0.949913f, 
		-0.0226964f, -0.999469f, 0.0233845f, -0.0220474f, -0.341833f, 0.939502f, 
		-0.0219108f, 0.603574f, 0.797006f, -0.0218828f, -0.990423f, 0.136324f, 
		-0.0217449f, -0.999757f, 0.00364705f, -0.0217043f, -0.719658f, -0.693990f, 
		-0.0216530f, -0.626287f, 0.779291f, -0.0216494f, -0.999274f, 0.0313599f, 
		-0.0215687f, -0.999761f, 0.00347182f, -0.0214623f, 0.425387f, 0.904757f, 
		-0.0213019f, 0.234960f, -0.971772f, -0.0210046f, -0.999236f, 0.0329694f, 
		-0.0209899f, 0.236304f, 0.971452f, -0.0209327f, -0.328430f, 0.944296f, 
		-0.0209174f, 0.987786f, 0.154405f, -0.0206247f, 0.0510116f, 0.998485f, 
		-0.0204090f, -0.425126f, 0.904904f, -0.0203335f, 0.560622f, -0.827822f, 
		-0.0203033f, -0.921025f, 0.388974f, -0.0202123f, -0.667733f, 0.744126f, 
		-0.0201680f, -0.977964f, 0.207797f, -0.0200337f, -0.270001f, -0.962652f, 
		-0.0200305f, -0.372305f, 0.927894f, -0.0197546f, 0.449321f, -0.893152f, 
		-0.0197431f, 0.670931f, 0.741257f, -0.0196084f, -0.717468f, 0.696315f, 
		-0.0195522f, -0.626339f, -0.779306f, -0.0194877f, -0.748509f, 0.662838f, 
		-0.0193853f, -0.725315f, -0.688144f, -0.0190185f, 0.250378f, -0.967961f, 
		-0.0189055f, 0.614095f, -0.789006f, -0.0187836f, -0.966838f, 0.254701f, 
		-0.0184341f, 0.449208f, -0.893237f, -0.0184152f, -0.0384607f, 0.999090f, 
		-0.0183954f, 0.999782f, -0.00985756f, -0.0183896f, 0.282385f, 0.959125f, 
		-0.0183201f, -0.217960f, 0.975786f, -0.0176258f, -0.998107f, -0.0589298f, 
		-0.0175609f, 0.461883f, -0.886767f, -0.0174321f, 0.988490f, 0.150280f, 
		-0.0174118f, 0.193120f, 0.981021f, -0.0173951f, -0.112875f, -0.993457f, 
		-0.0173519f, -0.484401f, 0.874674f, -0.0172216f, -0.228187f, -0.973465f, 
		-0.0171574f, -0.0280416f, 0.999460f, -0.0168678f, 0.453353f, 0.891172f, 
		-0.0167918f, -0.915298f, -0.402427f, -0.0167906f, 0.455508f, -0.890073f, 
		-0.0167536f, 0.956271f, -0.292002f, -0.0167388f, 0.351287f, -0.936118f, 
		-0.0166680f, -0.810208f, -0.585905f, -0.0165895f, -0.967051f, -0.254043f, 
		-0.0164020f, -0.324973f, 0.945581f, -0.0163754f, 0.833650f, -0.552051f, 
		-0.0163241f, 0.113178f, -0.993441f, -0.0162460f, -0.940392f, -0.339703f, 
		-0.0161847f, -0.999859f, 0.00436808f, -0.0161268f, -0.964105f, 0.265032f, 
		-0.0160544f, -0.999739f, 0.0162821f, -0.0159795f, 0.786763f, -0.617048f, 
		-0.0159020f, -0.980900f, 0.193864f, -0.0157745f, -0.994836f, 0.100263f, 
		-0.0157393f, -0.999872f, 0.00287641f, -0.0154981f, -0.968759f, -0.247521f, 
		-0.0152154f, 0.614067f, -0.789108f, -0.0151382f, 0.649631f, -0.760099f, 
		-0.0149659f, -0.999884f, -0.00273943f, -0.0148316f, 0.999887f, 0.00245780f, 
		-0.0144696f, -0.707715f, 0.706350f, -0.0144646f, -0.681366f, 0.731800f, 
		-0.0144209f, -0.862807f, 0.505328f, -0.0140659f, 0.0143034f, -0.999799f, 
		-0.0140190f, -0.999858f, 0.00934529f, -0.0138815f, -0.200692f, 0.979556f, 
		-0.0137243f, -0.987576f, 0.156542f, -0.0137026f, -0.481200f, 0.876504f, 
		-0.0136564f, -0.999880f, -0.00730817f, -0.0134567f, -0.0227184f, 0.999651f, 
		-0.0133658f, -0.618699f, 0.785515f, -0.0128982f, -0.989834f, 0.141643f, 
		-0.0128136f, -0.999911f, 0.00358039f, -0.0127223f, -0.272766f, -0.961996f, 
		-0.0126477f, -0.999911f, -0.00419802f, -0.0126049f, -0.868114f, 0.496205f, 
		-0.0123194f, -0.906028f, 0.423038f, -0.0122906f, -0.999898f, 0.00728386f, 
		-0.0122592f, -0.999920f, 0.00301219f, -0.0122517f, -0.495913f, 0.868286f, 
		-0.0121616f, 0.120715f, -0.992613f, -0.0119050f, -0.999906f, 0.00676857f, 
		-0.0118814f, -0.361195f, -0.932414f, -0.0118587f, -0.998585f, 0.0518378f, 
		-0.0116460f, -0.649450f, 0.760315f, -0.0116448f, -0.999929f, 0.00263680f, 
		-0.0113671f, -0.990280f, -0.138623f, -0.0111900f, 0.808748f, 0.588049f, 
		-0.0111392f, 0.808771f, 0.588019f, -0.0110433f, 0.264287f, 0.964381f, 
		-0.0110145f, -0.999608f, 0.0257529f, -0.0108869f, -0.881059f, -0.472881f, 
		-0.0107577f, -0.864248f, 0.502952f, -0.0105534f, -0.123934f, -0.992234f, 
		-0.0105396f, 0.0578457f, -0.998270f, -0.0105000f, -0.999939f, -0.00344940f, 
		-0.0104820f, -0.752489f, 0.658522f, -0.0103520f, -0.999946f, -0.000399373f, 
		-0.0102885f, -0.527238f, -0.849655f, -0.0100990f, 0.0536674f, -0.998508f, 
		-0.0100118f, -0.998704f, 0.0498997f, -0.00992412f, -0.536298f, 0.843971f, 
		-0.00986243f, -0.999946f, -0.00340812f, -0.00980875f, -0.999951f, 0.00155267f, 
		-0.00972505f, -0.999952f, -0.00142018f, -0.00961929f, -0.00616436f, -0.999935f, 
		-0.00954929f, 0.395419f, 0.918451f, -0.00944024f, -0.999949f, -0.00352300f, 
		-0.00917333f, -0.998681f, 0.0505261f, -0.00905572f, -0.990510f, -0.137143f, 
		-0.00898088f, 0.0670221f, 0.997711f, -0.00896694f, -0.129889f, 0.991488f, 
		-0.00896107f, -0.868806f, 0.495071f, -0.00893827f, -0.999927f, 0.00814104f, 
		-0.00892797f, -0.0656585f, 0.997802f, -0.00892320f, -0.912359f, -0.409293f, 
		-0.00878474f, 0.999961f, -0.000842500f, -0.00875057f, -0.999962f, 0.000467713f, 
		-0.00873910f, 0.964106f, 0.265372f, -0.00858071f, 0.999962f, 0.00126802f, 
		-0.00856348f, -0.804200f, 0.594297f, -0.00833892f, 0.511220f, 0.859409f, 
		-0.00829113f, -0.999918f, 0.00974540f, -0.00811632f, 0.789194f, -0.614091f, 
		-0.00804562f, 0.999967f, 0.000850784f, -0.00791308f, -0.989759f, -0.142529f, 
		-0.00772694f, 0.0704821f, 0.997483f, -0.00770978f, -0.998732f, 0.0497399f, 
		-0.00748883f, -0.739824f, 0.672759f, -0.00747256f, -0.0795465f, 0.996803f, 
		-0.00736340f, 0.850501f, -0.525921f, -0.00727832f, -0.544007f, -0.839049f, 
		-0.00725160f, 0.929662f, 0.368341f, -0.00698837f, 0.105029f, -0.994445f, 
		-0.00681821f, -0.151566f, -0.988424f, -0.00674844f, -0.999977f, -0.00119714f, 
		-0.00637622f, -0.999976f, -0.00260914f, -0.00617003f, -0.999007f, -0.0441250f, 
		-0.00612248f, -0.998009f, -0.0627732f, -0.00607770f, -0.0883594f, -0.996070f, 
		-0.00598014f, 0.276142f, -0.961098f, -0.00597658f, -0.999002f, -0.0442537f, 
		-0.00590377f, -0.997277f, 0.0735095f, -0.00579468f, -0.0849374f, -0.996369f, 
		-0.00566111f, -0.999295f, 0.0371077f, -0.00557037f, 0.185079f, -0.982708f, 
		-0.00554236f, 0.320479f, -0.947239f, -0.00543915f, -0.928397f, -0.371551f, 
		-0.00519775f, -0.932777f, -0.360416f, -0.00515484f, 0.320154f, -0.947352f, 
		-0.00512278f, 0.857188f, 0.514977f, -0.00496695f, -0.905155f, -0.425052f, 
		-0.00481156f, -0.999233f, 0.0388671f, -0.00454582f, 0.959801f, 0.280644f, 
		-0.00452487f, 0.856573f, 0.516006f, -0.00451280f, -0.0194242f, 0.999801f, 
		-0.00447771f, -0.641210f, -0.767352f, -0.00445043f, -0.999986f, 0.00269700f, 
		-0.00437612f, 0.561744f, 0.827300f, -0.00398341f, -0.450640f, -0.892697f, 
		-0.00392872f, -0.997241f, -0.0741278f, -0.00386099f, 0.903474f, 0.428625f, 
		-0.00384808f, 0.562649f, 0.826687f, -0.00364158f, 0.528292f, -0.849055f, 
		-0.00329702f, 0.963486f, 0.267739f, -0.00328640f, -0.871109f, 0.491080f, 
		-0.00288540f, -0.993593f, 0.112982f, -0.00276540f, -0.429298f, 0.903159f, 
		-0.00246757f, -0.522433f, -0.852677f, -0.00246121f, 0.705762f, -0.708445f, 
		-0.00234049f, 0.999997f, 1.45968e-005f, -0.00218116f, 0.905051f, -0.425297f, 
		-0.00212359f, -0.0944852f, 0.995524f, -0.00195099f, -0.737552f, -0.675287f, 
		-0.00187837f, 0.999726f, 0.0233533f, -0.00186959f, 0.220511f, 0.975383f, 
		-0.00149145f, -0.999995f, 0.00271199f, -0.00148981f, -0.998971f, -0.0453303f, 
		-0.00121979f, -0.999980f, -0.00623664f, -0.00117076f, 0.834678f, -0.550738f, 
		-0.00111226f, -0.999081f, 0.0428517f, -0.000906951f, 0.394949f, -0.918702f, 
		-0.000813068f, 0.175872f, -0.984413f, -0.000699925f, 0.649851f, -0.760061f, 
		-0.000696431f, -0.871625f, -0.490172f, -0.000660828f, -0.999544f, -0.0301890f, 
		-0.000537285f, 0.725846f, -0.687857f, -0.000478541f, -0.999997f, -0.00230178f, 
		-0.000362634f, 0.664210f, -0.747546f, -0.000330441f, -1.00000f, 0.000303999f, 
		-0.000268654f, 0.639843f, -0.768506f, -0.000131398f, -0.598468f, 0.801147f, 
		-3.04253e-005f, 0.685012f, 0.728532f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.923917f, 0.382594f, 
		0.000000f, 0.923927f, -0.382569f, 0.000000f, 0.957514f, 0.288388f, 
		0.000000f, 0.973125f, -0.230278f, 0.000000f, 0.981532f, 0.191297f, 
		0.000000f, 0.981535f, -0.191285f, 0.000000f, 0.989782f, 0.142586f, 
		0.000000f, 1.00000f, 0.000000f, 7.59827e-005f, 0.926304f, 0.376777f, 
		0.000252742f, 0.361142f, 0.932511f, 0.000337006f, 0.826596f, -0.562795f, 
		0.000661747f, 0.650316f, 0.759664f, 0.000786357f, 0.777253f, 0.629187f, 
		0.000865882f, 0.193951f, -0.981011f, 0.000932841f, -0.674863f, 0.737943f, 
		0.000942845f, -0.795995f, 0.605303f, 0.000974917f, -0.999548f, 0.0300337f, 
		0.00100337f, 0.225696f, 0.974197f, 0.00111997f, -0.999925f, -0.0122327f, 
		0.00118579f, 0.152522f, -0.988299f, 0.00119431f, 0.951283f, -0.308317f, 
		0.00124758f, -0.999973f, -0.00728515f, 0.00133136f, -0.999996f, -0.00260834f, 
		0.00149408f, -0.534776f, -0.844993f, 0.00177130f, -0.998075f, 0.0619947f, 
		0.00192468f, 0.807831f, 0.589410f, 0.00201039f, -0.999849f, 0.0172438f, 
		0.00224655f, 0.345483f, -0.938422f, 0.00230052f, 0.999997f, 0.000183402f, 
		0.00231893f, 0.757987f, 0.652266f, 0.00245858f, -0.997690f, 0.0678860f, 
		0.00246114f, -0.999994f, -0.00255691f, 0.00251655f, 0.998044f, 0.0624668f, 
		0.00252307f, -0.767404f, 0.641158f, 0.00256007f, 0.765215f, -0.643769f, 
		0.00259152f, -0.998401f, 0.0564757f, 0.00264325f, 0.871485f, 0.490415f, 
		0.00272126f, -0.875981f, 0.482339f, 0.00289806f, -0.456633f, -0.889651f, 
		0.00310839f, 0.807636f, -0.589673f, 0.00327510f, 0.367835f, 0.929885f, 
		0.00332690f, -0.999690f, -0.0246699f, 0.00341390f, -0.917486f, 0.397754f, 
		0.00347777f, 0.882287f, -0.470700f, 0.00352740f, -0.812356f, 0.583151f, 
		0.00353465f, -0.0784852f, 0.996909f, 0.00359331f, 0.682415f, 0.730956f, 
		0.00364064f, -0.0765162f, 0.997062f, 0.00385843f, -0.999393f, 0.0346181f, 
		0.00399374f, 0.882899f, -0.469545f, 0.00420091f, -0.876645f, 0.481120f, 
		0.00421453f, -0.999989f, -0.00215982f, 0.00422031f, 0.999989f, 0.00226621f, 
		0.00445221f, -0.999834f, -0.0176739f, 0.00450150f, -0.220358f, 0.975409f, 
		0.00464064f, 0.775712f, 0.631071f, 0.00465063f, -0.0446628f, 0.998991f, 
		0.00482514f, -0.613030f, 0.790045f, 0.00497027f, -0.109233f, -0.994004f, 
		0.00518192f, -0.874726f, -0.484589f, 0.00530218f, -0.300952f, -0.953625f, 
		0.00576059f, -0.999914f, -0.0117843f, 0.00578965f, -0.707622f, 0.706568f, 
		0.00593611f, -0.998420f, 0.0558852f, 0.00607029f, -0.998374f, -0.0566817f, 
		0.00624306f, 0.300996f, 0.953605f, 0.00649918f, 0.0640200f, 0.997927f, 
		0.00652762f, -0.999384f, -0.0344888f, 0.00696080f, 0.784704f, 0.619832f, 
		0.00743072f, -0.868476f, -0.495676f, 0.00746954f, -0.00326369f, 0.999967f, 
		0.00753630f, 0.303733f, -0.952727f, 0.00754945f, -0.985519f, -0.169395f, 
		0.00760804f, -0.361078f, 0.932505f, 0.00788241f, 0.817029f, 0.576543f, 
		0.00790310f, -0.991048f, -0.133272f, 0.00793470f, 0.920131f, -0.391531f, 
		0.00806176f, -0.283842f, 0.958837f, 0.00807506f, 0.999967f, -0.000848375f, 
		0.00825061f, 0.858668f, -0.512465f, 0.00830737f, 0.858668f, -0.512465f, 
		0.00851186f, -0.999743f, 0.0210152f, 0.00864843f, -0.991253f, -0.131693f, 
		0.00896945f, -0.169449f, 0.985498f, 0.00910593f, 0.591977f, -0.805903f, 
		0.00933651f, -0.993293f, -0.115245f, 0.00933806f, 0.574647f, 0.818348f, 
		0.00934814f, -0.994595f, -0.103408f, 0.00960595f, 0.340186f, -0.940309f, 
		0.0100448f, -0.998098f, 0.0608293f, 0.0101481f, 0.266436f, 0.963799f, 
		0.0102259f, 0.312444f, 0.949881f, 0.0103874f, 0.999944f, 0.00208465f, 
		0.0104424f, -0.854876f, -0.518728f, 0.0104692f, 0.790866f, 0.611900f, 
		0.0104743f, 0.999824f, -0.0155544f, 0.0104962f, -0.999903f, 0.00911924f, 
		0.0105873f, 0.798881f, 0.601395f, 0.0106630f, 0.798890f, 0.601383f, 
		0.0107808f, -0.729605f, -0.683783f, 0.0109829f, 0.569716f, 0.821768f, 
		0.0110687f, -0.393866f, -0.919101f, 0.0111744f, -0.996877f, 0.0781794f, 
		0.0112039f, -0.870324f, -0.492352f, 0.0112895f, -0.819370f, 0.573153f, 
		0.0115863f, -0.322070f, 0.946645f, 0.0116013f, -0.973425f, -0.228713f, 
		0.0117004f, -0.999368f, 0.0335635f, 0.0120586f, -0.0886150f, -0.995993f, 
		0.0120827f, 0.300420f, -0.953731f, 0.0120867f, -0.610721f, 0.791754f, 
		0.0121614f, 0.754444f, 0.656251f, 0.0121693f, 0.0583689f, 0.998221f, 
		0.0122222f, -0.997436f, -0.0705185f, 0.0123201f, 0.959475f, -0.281525f, 
		0.0123687f, 0.205680f, 0.978541f, 0.0124015f, -0.999871f, -0.0102424f, 
		0.0127497f, -0.999780f, -0.0166486f, 0.0129058f, -0.0200519f, -0.999716f, 
		0.0129134f, -0.00544937f, 0.999902f, 0.0129554f, -0.997752f, -0.0657509f, 
		0.0132469f, -0.999201f, 0.0377107f, 0.0132925f, -0.729036f, 0.684346f, 
		0.0135044f, 0.521597f, -0.853085f, 0.0136150f, -0.234511f, 0.972018f, 
		0.0136400f, -0.322210f, -0.946570f, 0.0140608f, -0.820514f, 0.571453f, 
		0.0142114f, 0.272594f, 0.962024f, 0.0142742f, -0.880812f, 0.473251f, 
		0.0144031f, -0.614927f, 0.788453f, 0.0147102f, -0.997707f, -0.0660652f, 
		0.0147778f, -0.999634f, -0.0226673f, 0.0148127f, -0.979476f, 0.201014f, 
		0.0149502f, 0.771548f, 0.635995f, 0.0153180f, 0.524255f, -0.851424f, 
		0.0153632f, -0.926023f, 0.377155f, 0.0155187f, -0.984053f, -0.177200f, 
		0.0157425f, -0.888555f, 0.458499f, 0.0159741f, -0.973689f, -0.227319f, 
		0.0161525f, -0.978769f, 0.204329f, 0.0161602f, -0.831477f, -0.555324f, 
		0.0162548f, 0.750621f, -0.660533f, 0.0162895f, -0.638621f, 0.769349f, 
		0.0163516f, 0.999812f, 0.0104347f, 0.0166149f, 0.148531f, -0.988768f, 
		0.0167101f, -0.911407f, 0.411167f, 0.0168519f, 0.827019f, -0.561922f, 
		0.0170493f, 0.819176f, -0.573289f, 0.0172378f, 0.486946f, -0.873262f, 
		0.0172579f, -0.997565f, -0.0675693f, 0.0172843f, 0.152860f, 0.988097f, 
		0.0174245f, -0.999612f, -0.0217198f, 0.0180116f, -0.999323f, 0.0320780f, 
		0.0180778f, -0.998243f, -0.0564276f, 0.0183110f, 0.0160824f, -0.999703f, 
		0.0183224f, -0.999309f, 0.0323328f, 0.0186633f, -0.666155f, 0.745580f, 
		0.0190364f, 0.290049f, 0.956822f, 0.0191705f, 0.941293f, 0.337047f, 
		0.0194987f, 0.896450f, 0.442716f, 0.0197488f, 0.346185f, 0.937958f, 
		0.0200806f, -0.999743f, 0.0105225f, 0.0201947f, -0.999764f, 0.00804655f, 
		0.0205793f, 0.814099f, -0.580361f, 0.0205957f, -0.920918f, -0.389212f, 
		0.0213166f, 0.437778f, -0.898830f, 0.0213695f, -0.825056f, -0.564647f, 
		0.0214618f, -0.0839312f, 0.996240f, 0.0215811f, 0.566732f, 0.823620f, 
		0.0218513f, -0.677829f, -0.734895f, 0.0218574f, -0.0397065f, 0.998972f, 
		0.0219956f, -0.987549f, -0.155766f, 0.0220638f, -0.997797f, 0.0625594f, 
		0.0220938f, 0.377195f, -0.925870f, 0.0221224f, -0.370093f, -0.928731f, 
		0.0224029f, 0.812298f, -0.582812f, 0.0226261f, -0.999117f, -0.0353940f, 
		0.0226795f, 0.613065f, 0.789707f, 0.0228535f, -0.989877f, 0.140078f, 
		0.0228599f, 0.796755f, -0.603870f, 0.0231145f, -0.997807f, -0.0620199f, 
		0.0231163f, -0.997811f, -0.0619605f, 0.0231191f, -0.905863f, 0.422939f, 
		0.0231650f, 0.787314f, -0.616116f, 0.0237105f, 0.0405310f, -0.998897f, 
		0.0238007f, 0.323633f, 0.945883f, 0.0240378f, -0.999337f, -0.0273470f, 
		0.0240473f, 0.0297655f, -0.999268f, 0.0240954f, -0.240606f, 0.970324f, 
		0.0246194f, 0.950569f, 0.309537f, 0.0246898f, 0.372715f, -0.927617f, 
		0.0248250f, -0.999678f, -0.00534668f, 0.0249042f, 0.347147f, -0.937480f, 
		0.0250014f, -0.553223f, 0.832658f, 0.0252533f, 0.815121f, -0.578740f, 
		0.0253437f, 0.292906f, 0.955805f, 0.0253630f, -0.0867251f, -0.995909f, 
		0.0253985f, -0.999600f, -0.0124422f, 0.0254298f, -0.998837f, -0.0409703f, 
		0.0254916f, -0.999597f, -0.0125212f, 0.0255314f, 0.457817f, 0.888680f, 
		0.0257112f, -0.340132f, -0.940026f, 0.0258165f, -0.953669f, -0.299749f, 
		0.0258494f, -0.953716f, -0.299594f, 0.0258972f, -0.0680920f, -0.997343f, 
		0.0260646f, -0.999647f, -0.00515930f, 0.0263538f, -0.536599f, -0.843426f, 
		0.0270984f, -0.998508f, -0.0474049f, 0.0273474f, 0.363415f, 0.931226f, 
		0.0273804f, 0.997675f, 0.0624167f, 0.0274795f, -0.945966f, -0.323098f, 
		0.0274929f, -0.945927f, -0.323214f, 0.0278071f, -0.990468f, -0.134904f, 
		0.0278764f, -0.122764f, -0.992044f, 0.0280420f, -0.129489f, 0.991184f, 
		0.0283752f, 0.941142f, 0.336819f, 0.0284381f, 0.858802f, 0.511518f, 
		0.0284920f, -0.573853f, 0.818463f, 0.0287316f, -0.821219f, -0.569889f, 
		0.0289544f, 0.490513f, -0.870953f, 0.0290656f, -0.131347f, 0.990910f, 
		0.0294532f, -0.391833f, 0.919565f, 0.0296307f, -0.992099f, 0.121910f, 
		0.0296587f, -0.981454f, 0.189388f, 0.0301249f, 0.439954f, -0.897515f, 
		0.0301553f, 0.710298f, 0.703255f, 0.0302452f, 0.927672f, 0.372168f, 
		0.0302864f, -0.354179f, -0.934687f, 0.0305275f, -0.875196f, 0.482805f, 
		0.0305548f, -0.898444f, -0.438023f, 0.0307432f, 0.581037f, 0.813296f, 
		0.0308964f, -0.894190f, 0.446620f, 0.0310340f, 0.763253f, 0.645354f, 
		0.0314864f, -0.0813051f, 0.996192f, 0.0315898f, 0.860093f, 0.509158f, 
		0.0319032f, -0.497617f, 0.866810f, 0.0323690f, -0.828584f, 0.558928f, 
		0.0328864f, 0.530571f, -0.847002f, 0.0331139f, -0.0135000f, -0.999360f, 
		0.0333111f, 0.809498f, -0.586177f, 0.0334861f, -0.650753f, 0.758551f, 
		0.0338136f, -0.0388449f, -0.998673f, 0.0340126f, -0.754832f, -0.655035f, 
		0.0340818f, 0.259887f, -0.965037f, 0.0344004f, -0.932195f, 0.360318f, 
		0.0345038f, -0.0912764f, -0.995228f, 0.0346008f, 0.714501f, 0.698779f, 
		0.0346019f, -0.435317f, 0.899612f, 0.0346227f, 0.464729f, -0.884776f, 
		0.0346505f, 0.0656491f, 0.997241f, 0.0348660f, 0.818939f, -0.572821f, 
		0.0350172f, 0.267411f, 0.962946f, 0.0350271f, -0.0999431f, 0.994376f, 
		0.0353965f, -0.990482f, 0.133012f, 0.0355727f, 0.379857f, -0.924361f, 
		0.0355749f, -0.999258f, -0.0147520f, 0.0361845f, 0.379476f, -0.924494f, 
		0.0363897f, -0.990306f, 0.134053f, 0.0363902f, 0.515120f, -0.856345f, 
		0.0365180f, -0.988362f, 0.147672f, 0.0367349f, 0.771032f, -0.635736f, 
		0.0368622f, 0.423839f, -0.904987f, 0.0370277f, 0.545814f, -0.837088f, 
		0.0371858f, -0.357935f, -0.933006f, 0.0373531f, -0.999198f, -0.0144079f, 
		0.0374098f, -0.913653f, 0.404770f, 0.0374462f, -0.999299f, 0.000427934f, 
		0.0375378f, 0.771358f, -0.635293f, 0.0380339f, -0.858491f, 0.511417f, 
		0.0382037f, -0.985591f, -0.164776f, 0.0390082f, -0.974116f, -0.222656f, 
		0.0390664f, 0.000971934f, 0.999236f, 0.0390856f, -0.649423f, 0.759422f, 
		0.0394727f, 0.397430f, 0.916783f, 0.0396752f, 0.775655f, 0.629909f, 
		0.0400206f, -0.324560f, -0.945018f, 0.0400553f, 0.435425f, -0.899334f, 
		0.0400845f, -0.998721f, 0.0308015f, 0.0400996f, 0.487883f, 0.871988f, 
		0.0404887f, 0.456934f, 0.888578f, 0.0407145f, 0.540457f, -0.840386f, 
		0.0407909f, 0.765756f, -0.641837f, 0.0410271f, 0.711638f, -0.701347f, 
		0.0411631f, -0.464019f, 0.884868f, 0.0411817f, 0.421873f, -0.905719f, 
		0.0416935f, 0.369984f, 0.928102f, 0.0417749f, -0.376250f, -0.925576f, 
		0.0418544f, 0.814972f, -0.577987f, 0.0419531f, 0.307575f, -0.950599f, 
		0.0422340f, -0.890913f, -0.452205f, 0.0423009f, -0.0237879f, 0.998822f, 
		0.0424511f, -0.448240f, 0.892905f, 0.0425082f, -0.717929f, 0.694817f, 
		0.0429476f, -0.184600f, 0.981875f, 0.0429628f, -0.891434f, -0.451110f, 
		0.0433289f, 0.800396f, -0.597903f, 0.0436519f, -0.341072f, -0.939023f, 
		0.0442510f, -0.417874f, 0.907427f, 0.0443540f, -0.342100f, -0.938616f, 
		0.0444420f, -0.0994750f, -0.994047f, 0.0445078f, 0.998341f, 0.0365367f, 
		0.0445198f, 0.514228f, 0.856497f, 0.0445681f, 0.874453f, 0.483058f, 
		0.0448008f, 0.797565f, -0.601567f, 0.0448502f, -0.346822f, -0.936858f, 
		0.0449959f, -0.823460f, -0.565587f, 0.0450376f, -0.998453f, 0.0326061f, 
		0.0463113f, -0.998890f, -0.00864870f, 0.0465754f, -0.0115239f, 0.998848f, 
		0.0468347f, -0.998902f, -0.000865231f, 0.0469998f, 0.0711975f, -0.996354f, 
		0.0471044f, 0.872531f, -0.486282f, 0.0479235f, 0.998445f, -0.0284850f, 
		0.0479286f, 0.998445f, -0.0284609f, 0.0480943f, -0.333034f, -0.941687f, 
		0.0483054f, -0.0361811f, 0.998177f, 0.0487932f, 0.833759f, 0.549968f, 
		0.0488049f, -0.197928f, -0.979001f, 0.0489800f, 0.567254f, 0.822085f, 
		0.0490665f, 0.423623f, 0.904509f, 0.0493145f, -0.909554f, 0.412649f, 
		0.0494596f, -0.332805f, -0.941698f, 0.0495279f, 0.471270f, 0.880597f, 
		0.0498029f, -0.457577f, 0.887774f, 0.0499159f, -0.557086f, 0.828953f, 
		0.0502171f, 0.669307f, 0.741287f, 0.0502286f, -0.329630f, -0.942773f, 
		0.0504100f, -0.127571f, 0.990548f, 0.0504300f, 0.549177f, 0.834183f, 
		0.0505733f, -0.331373f, 0.942144f, 0.0507951f, 0.679524f, -0.731893f, 
		0.0508085f, 0.0155254f, 0.998588f, 0.0508471f, 0.487775f, 0.871487f, 
		0.0510452f, -0.345946f, -0.936865f, 0.0512763f, 0.761619f, -0.645993f, 
		0.0513192f, 0.996230f, -0.0699423f, 0.0518359f, 0.166980f, 0.984597f, 
		0.0520711f, 0.562128f, -0.825410f, 0.0521713f, 0.840400f, -0.539449f, 
		0.0521923f, 0.997958f, -0.0368232f, 0.0522120f, 0.997956f, -0.0368370f, 
		0.0522400f, 0.840420f, -0.539412f, 0.0522683f, 0.559928f, -0.826891f, 
		0.0524586f, -0.180074f, 0.982253f, 0.0527161f, -0.998503f, -0.0145986f, 
		0.0527448f, -0.998186f, 0.0290177f, 0.0528249f, 0.998320f, -0.0237987f, 
		0.0531205f, 0.436089f, 0.898334f, 0.0531374f, -0.997679f, 0.0425831f, 
		0.0531507f, 0.775676f, 0.628889f, 0.0532708f, -0.137042f, -0.989132f, 
		0.0534854f, 0.657397f, -0.751644f, 0.0540681f, -0.997703f, 0.0407992f, 
		0.0541108f, 0.663541f, 0.746180f, 0.0541122f, -0.662293f, -0.747288f, 
		0.0543834f, -0.185693f, 0.981102f, 0.0548671f, 0.998248f, -0.0221381f, 
		0.0552688f, -0.165701f, -0.984626f, 0.0554114f, 0.923577f, 0.379387f, 
		0.0556838f, 0.282752f, -0.957575f, 0.0557327f, -0.848775f, 0.525808f, 
		0.0558634f, -0.380287f, 0.923180f, 0.0558841f, -0.997012f, -0.0533202f, 
		0.0560287f, 0.101550f, 0.993251f, 0.0565829f, 0.701225f, -0.710691f, 
		0.0565870f, 0.701157f, -0.710758f, 0.0568089f, -0.863355f, 0.501388f, 
		0.0568597f, 0.262444f, 0.963270f, 0.0569191f, -0.340245f, 0.938613f, 
		0.0569266f, 0.308409f, -0.949549f, 0.0569828f, 0.802261f, -0.594248f, 
		0.0574654f, -0.0163956f, -0.998213f, 0.0576093f, 0.397251f, -0.915900f, 
		0.0578010f, 0.825580f, 0.561317f, 0.0578568f, -0.327418f, 0.943107f, 
		0.0580192f, -0.329547f, 0.942355f, 0.0583291f, -0.429650f, -0.901109f, 
		0.0584633f, 0.485633f, -0.872206f, 0.0586442f, -0.0244628f, 0.997979f, 
		0.0587206f, -0.992700f, -0.105348f, 0.0587481f, 0.00183087f, 0.998271f, 
		0.0588479f, 0.334700f, 0.940485f, 0.0588876f, 0.130132f, -0.989746f, 
		0.0592672f, 0.813597f, -0.578400f, 0.0594289f, -0.376317f, 0.924583f, 
		0.0597726f, 0.337862f, -0.939296f, 0.0603707f, -0.0289811f, -0.997755f, 
		0.0607377f, 0.870478f, -0.488446f, 0.0609542f, -0.374840f, 0.925083f, 
		0.0610085f, -0.805731f, -0.589132f, 0.0611797f, 0.859324f, -0.507759f, 
		0.0613051f, 0.997797f, 0.0253660f, 0.0614660f, 0.156800f, 0.985716f, 
		0.0616545f, -0.998096f, 0.00190754f, 0.0618855f, 0.964359f, 0.257260f, 
		0.0619615f, -0.926062f, -0.372249f, 0.0621518f, 0.742996f, 0.666403f, 
		0.0623039f, 0.327019f, -0.942962f, 0.0625542f, -0.672684f, -0.737280f, 
		0.0627191f, 0.777304f, -0.625991f, 0.0630667f, -0.657434f, -0.750869f, 
		0.0631202f, -0.0268790f, 0.997644f, 0.0631445f, -0.140461f, 0.988071f, 
		0.0637792f, -0.926126f, 0.371784f, 0.0644034f, -0.0454585f, -0.996888f, 
		0.0644829f, 0.0689592f, 0.995533f, 0.0646016f, -0.949674f, 0.306505f, 
		0.0647340f, 0.276707f, 0.958772f, 0.0650241f, -0.964776f, -0.254912f, 
		0.0651368f, -0.988860f, 0.133837f, 0.0652378f, -0.697319f, 0.713786f, 
		0.0652856f, -0.990599f, 0.120217f, 0.0653937f, 0.741337f, -0.667939f, 
		0.0655573f, 0.851964f, 0.519480f, 0.0656629f, 0.211322f, 0.975208f, 
		0.0657795f, -0.537995f, -0.840378f, 0.0658058f, 0.150777f, 0.986375f, 
		0.0658170f, 0.915252f, -0.397470f, 0.0661873f, -0.904416f, 0.421487f, 
		0.0662654f, 0.0791607f, 0.994657f, 0.0665881f, -0.699557f, 0.711467f, 
		0.0671376f, -0.833101f, 0.549031f, 0.0671675f, 0.990017f, -0.123914f, 
		0.0672499f, -0.870967f, 0.486717f, 0.0674040f, 0.127090f, 0.989598f, 
		0.0676769f, 0.429454f, 0.900549f, 0.0680116f, -0.967842f, 0.242189f, 
		0.0680275f, 0.284288f, -0.956322f, 0.0682542f, -0.230387f, -0.970702f, 
		0.0685316f, -0.159174f, -0.984869f, 0.0685740f, -0.908283f, -0.412699f, 
		0.0686590f, 0.209040f, -0.975494f, 0.0686922f, -0.980156f, -0.185947f, 
		0.0689522f, 0.733466f, 0.676219f, 0.0692960f, 0.996519f, 0.0463466f, 
		0.0693119f, -0.347686f, -0.935045f, 0.0694695f, -0.991194f, 0.112730f, 
		0.0695053f, -0.849167f, 0.523531f, 0.0699312f, -0.982953f, -0.170041f, 
		0.0699363f, 0.0909772f, -0.993394f, 0.0700146f, 0.364682f, 0.928496f, 
		0.0700179f, 0.0933480f, 0.993168f, 0.0701148f, 0.297617f, 0.952107f, 
		0.0702105f, -0.995740f, 0.0597632f, 0.0703355f, 0.390563f, -0.917885f, 
		0.0704488f, 0.390531f, -0.917890f, 0.0704738f, -0.703444f, 0.707248f, 
		0.0706630f, 0.416061f, 0.906587f, 0.0707666f, -0.508678f, 0.858044f, 
		0.0708784f, 0.0232740f, 0.997213f, 0.0709117f, 0.252910f, 0.964888f, 
		0.0710814f, 0.319062f, 0.945065f, 0.0711436f, 0.996061f, -0.0529282f, 
		0.0711491f, 0.996061f, -0.0529150f, 0.0715203f, -0.995352f, 0.0644856f, 
		0.0716197f, -0.424383f, -0.902646f, 0.0717170f, -0.351692f, 0.933365f, 
		0.0718657f, 0.339456f, -0.937872f, 0.0718871f, 0.985611f, 0.152979f, 
		0.0724065f, -0.981618f, -0.176588f, 0.0726027f, -0.937843f, 0.339381f, 
		0.0735094f, 0.0504486f, 0.996018f, 0.0736389f, -0.966126f, 0.247342f, 
		0.0742118f, -0.154371f, 0.985222f, 0.0743565f, -0.660497f, -0.747138f, 
		0.0746506f, -0.458600f, -0.885502f, 0.0748146f, -0.896224f, 0.437248f, 
		0.0750616f, -0.889322f, 0.451078f, 0.0751207f, 0.531294f, -0.843850f, 
		0.0751926f, -0.995360f, -0.0600429f, 0.0753067f, 0.870228f, 0.486859f, 
		0.0753078f, -0.995626f, 0.0552965f, 0.0754647f, 0.734837f, -0.674032f, 
		0.0755393f, -0.766637f, -0.637621f, 0.0756378f, 0.607130f, 0.790995f, 
		0.0757826f, -0.982396f, -0.170748f, 0.0758391f, 0.690238f, -0.719597f, 
		0.0761270f, 0.801336f, 0.593351f, 0.0762543f, 0.708759f, -0.701317f, 
		0.0763990f, -0.995536f, -0.0554245f, 0.0764481f, -0.888613f, 0.452243f, 
		0.0765075f, 0.617370f, 0.782944f, 0.0765116f, -0.899217f, -0.430761f, 
		0.0767731f, 0.734383f, 0.674380f, 0.0768125f, -0.0764041f, 0.994114f, 
		0.0769473f, -0.995419f, -0.0567396f, 0.0769775f, 0.307192f, -0.948529f, 
		0.0769971f, -0.167147f, 0.982921f, 0.0771893f, 0.995311f, 0.0582876f, 
		0.0772378f, -0.995374f, -0.0571458f, 0.0777530f, -0.928931f, 0.361996f, 
		0.0781291f, -0.336310f, -0.938505f, 0.0782872f, -0.788052f, 0.610610f, 
		0.0783818f, 0.339420f, -0.937364f, 0.0784670f, 0.343130f, -0.936005f, 
		0.0786359f, 0.874133f, 0.479278f, 0.0789011f, -0.559002f, 0.825403f, 
		0.0789855f, 0.371870f, -0.924918f, 0.0790121f, 0.985945f, -0.147204f, 
		0.0793352f, -0.833537f, 0.546737f, 0.0793873f, -0.991997f, -0.0981778f, 
		0.0794008f, -0.995744f, -0.0468012f, 0.0794459f, -0.992709f, -0.0906475f, 
		0.0796028f, -0.956760f, 0.279774f, 0.0796120f, -0.514771f, 0.853623f, 
		0.0797164f, -0.991992f, -0.0979642f, 0.0798416f, -0.983411f, 0.162874f, 
		0.0800320f, 0.0833718f, 0.993300f, 0.0803278f, 0.889528f, 0.449764f, 
		0.0803798f, -0.903321f, -0.421367f, 0.0803920f, -0.992766f, -0.0891729f, 
		0.0805127f, 0.449866f, -0.889459f, 0.0810445f, -0.992448f, -0.0920851f, 
		0.0811148f, 0.806599f, -0.585507f, 0.0812174f, 0.768068f, 0.635197f, 
		0.0812405f, -0.0552519f, -0.995162f, 0.0816551f, -0.0667135f, 0.994425f, 
		0.0819086f, -0.00364812f, 0.996633f, 0.0820852f, -0.517658f, -0.851641f, 
		0.0821427f, -0.944375f, 0.318447f, 0.0822474f, 0.403099f, 0.911453f, 
		0.0825441f, -0.315364f, 0.945374f, 0.0826276f, 0.530917f, 0.843386f, 
		0.0828226f, -0.107550f, 0.990744f, 0.0828667f, -0.0542691f, -0.995082f, 
		0.0831239f, 0.983761f, 0.159075f, 0.0831496f, 0.764739f, 0.638952f, 
		0.0832480f, 0.540353f, 0.837310f, 0.0833603f, -0.988937f, 0.122698f, 
		0.0836928f, -0.696649f, 0.712514f, 0.0841022f, 0.872687f, 0.480983f, 
		0.0842393f, 0.0132622f, 0.996357f, 0.0842642f, 0.166849f, 0.982375f, 
		0.0845783f, -0.992069f, 0.0929860f, 0.0846673f, 0.222812f, -0.971178f, 
		0.0847999f, 0.380730f, 0.920790f, 0.0849531f, -0.865060f, 0.494422f, 
		0.0852365f, 0.713524f, 0.695426f, 0.0853005f, 0.463272f, -0.882101f, 
		0.0856017f, 0.892544f, 0.442762f, 0.0856978f, -0.791895f, -0.604614f, 
		0.0857601f, 0.116440f, 0.989488f, 0.0858422f, -0.990110f, 0.110966f, 
		0.0861543f, -0.0608470f, 0.994422f, 0.0861631f, -0.0477462f, 0.995136f, 
		0.0863272f, 0.886564f, -0.454480f, 0.0864178f, -0.992568f, 0.0856774f, 
		0.0864799f, -0.994310f, 0.0622052f, 0.0865931f, -0.497325f, -0.863232f, 
		0.0868362f, -0.991707f, 0.0947414f, 0.0870003f, 0.377610f, 0.921869f, 
		0.0871761f, 0.790223f, 0.606587f, 0.0872753f, -0.494317f, 0.864890f, 
		0.0874840f, 0.542813f, 0.835285f, 0.0875686f, -0.995697f, -0.0303158f, 
		0.0876034f, 0.639112f, 0.764108f, 0.0880245f, 0.0259365f, 0.995781f, 
		0.0883031f, 0.299315f, -0.950059f, 0.0885185f, -0.579853f, 0.809898f, 
		0.0885468f, 0.788996f, 0.607984f, 0.0885686f, -0.991487f, 0.0954446f, 
		0.0892596f, 0.318089f, -0.943850f, 0.0894514f, 0.505845f, -0.857974f, 
		0.0895988f, 0.0261019f, 0.995636f, 0.0899009f, -0.676781f, 0.730674f, 
		0.0900026f, -0.556181f, 0.826173f, 0.0900167f, -0.989193f, -0.115736f, 
		0.0900313f, 0.993489f, -0.0698113f, 0.0902087f, -0.925393f, 0.368118f, 
		0.0902708f, 0.305545f, 0.947889f, 0.0906106f, 0.296976f, 0.950576f, 
		0.0906179f, -0.514911f, 0.852441f, 0.0908535f, 0.0496597f, 0.994625f, 
		0.0908767f, 0.838692f, -0.536971f, 0.0910445f, -0.653443f, -0.751481f, 
		0.0911765f, 0.0690813f, 0.993436f, 0.0912465f, 0.295724f, 0.950906f, 
		0.0913151f, -0.985625f, 0.142143f, 0.0913177f, -0.992538f, -0.0808013f, 
		0.0914896f, 0.993247f, -0.0713456f, 0.0915269f, 0.993242f, -0.0713710f, 
		0.0915933f, -0.993238f, -0.0713402f, 0.0917667f, -0.982584f, 0.161576f, 
		0.0919509f, 0.332455f, -0.938626f, 0.0919711f, 0.0520790f, 0.994399f, 
		0.0919959f, 0.0520059f, 0.994400f, 0.0920178f, 0.722762f, -0.684944f, 
		0.0920606f, -0.575962f, 0.812276f, 0.0921774f, -0.995689f, 0.0103129f, 
		0.0922827f, 0.454256f, -0.886079f, 0.0924581f, -0.986152f, -0.137683f, 
		0.0926233f, -0.987367f, 0.128558f, 0.0928316f, -0.937946f, 0.334125f, 
		0.0928426f, -0.937939f, 0.334143f, 0.0935238f, -0.986766f, 0.132463f, 
		0.0937074f, 0.885297f, 0.455486f, 0.0938860f, 0.103173f, -0.990223f, 
		0.0939636f, -0.201038f, 0.975066f, 0.0941780f, 0.316777f, -0.943813f, 
		0.0946942f, 0.307203f, 0.946921f, 0.0947599f, -0.607596f, 0.788573f, 
		0.0948611f, 0.673635f, -0.732951f, 0.0951103f, -0.514989f, -0.851904f, 
		0.0951944f, 0.868080f, -0.487211f, 0.0952737f, -0.967365f, -0.234791f, 
		0.0953184f, -0.687591f, 0.719814f, 0.0954408f, -0.987677f, 0.124039f, 
		0.0961918f, 0.615213f, -0.782471f, 0.0962277f, 0.993795f, -0.0557900f, 
		0.0965651f, -0.723336f, 0.683711f, 0.0967058f, 0.0214452f, 0.995082f, 
		0.0967228f, 0.795730f, -0.597878f, 0.0968613f, -0.982094f, -0.161584f, 
		0.0969740f, 0.569994f, -0.815906f, 0.0970741f, -0.980938f, -0.168335f, 
		0.0974174f, 0.590006f, 0.801501f, 0.0975192f, 0.0430618f, -0.994302f, 
		0.0975271f, -0.0251668f, -0.994915f, 0.0975659f, -0.0251095f, -0.994912f, 
		0.0976360f, -0.995221f, 0.00159623f, 0.0978863f, -0.390760f, -0.915273f, 
		0.0979577f, 0.975719f, -0.195901f, 0.0986318f, 0.258422f, 0.960984f, 
		0.0987805f, 0.614179f, -0.782960f, 0.0987857f, 0.282291f, 0.954229f, 
		0.0990657f, 0.389125f, 0.915843f, 0.0990884f, -0.531685f, 0.841126f, 
		0.0996248f, -0.884817f, -0.455164f, 0.0998464f, -0.992981f, 0.0634037f, 
		0.100141f, 0.723865f, -0.682636f, 0.100189f, -0.994837f, -0.0161566f, 
		0.100234f, 0.988231f, 0.115552f, 0.100306f, 0.528123f, -0.843223f, 
		0.100343f, 0.155552f, 0.982718f, 0.100490f, 0.132091f, 0.986131f, 
		0.101043f, -0.992014f, 0.0754838f, 0.101082f, 0.161506f, 0.981681f, 
		0.101498f, -0.991668f, 0.0793325f, 0.101528f, -0.938766f, -0.329256f, 
		0.101728f, 0.503847f, 0.857782f, 0.101873f, 0.683587f, 0.722724f, 
		0.101948f, 0.0644033f, 0.992703f, 0.102085f, 0.145001f, 0.984151f, 
		0.102236f, -0.896216f, -0.431677f, 0.102387f, 0.882725f, 0.458600f, 
		0.102928f, -0.900773f, 0.421916f, 0.103273f, -0.599278f, 0.793852f, 
		0.103363f, -0.926959f, -0.360642f, 0.103443f, -0.505981f, -0.856319f, 
		0.103520f, -0.483092f, -0.869428f, 0.103657f, -0.991737f, 0.0755899f, 
		0.103935f, 0.420870f, -0.901147f, 0.103981f, -0.987919f, -0.114910f, 
		0.104466f, -0.599687f, 0.793386f, 0.104757f, 0.456788f, -0.883386f, 
		0.105197f, 0.580611f, 0.807357f, 0.105623f, -0.134585f, -0.985257f, 
		0.105712f, 0.451672f, -0.885899f, 0.106118f, -0.888676f, -0.446086f, 
		0.106360f, 0.527579f, 0.842822f, 0.106998f, -0.981548f, 0.158475f, 
		0.107270f, -0.984734f, -0.137086f, 0.107270f, 0.352677f, 0.929576f, 
		0.107555f, 0.485439f, 0.867630f, 0.107817f, 0.675114f, 0.729792f, 
		0.107896f, 0.684544f, -0.720942f, 0.108154f, -0.527965f, -0.842351f, 
		0.108690f, -0.0700082f, -0.991607f, 0.108900f, -0.574876f, 0.810961f, 
		0.109188f, -0.930970f, 0.348386f, 0.109223f, 0.386265f, 0.915898f, 
		0.109552f, -0.927501f, -0.357408f, 0.109760f, 0.677841f, -0.726969f, 
		0.109775f, 0.418617f, 0.901504f, 0.110118f, 0.375896f, 0.920096f, 
		0.110180f, -0.468880f, -0.876363f, 0.110197f, -0.468869f, -0.876366f, 
		0.110342f, 0.425710f, 0.898107f, 0.110581f, 0.117536f, 0.986893f, 
		0.110639f, 0.0819035f, 0.990480f, 0.110755f, -0.983622f, -0.142198f, 
		0.111486f, 0.871234f, -0.478040f, 0.111544f, -0.508186f, -0.853993f, 
		0.111569f, 0.807288f, -0.579516f, 0.111874f, 0.636788f, 0.762879f, 
		0.111889f, -0.992224f, -0.0545170f, 0.111901f, -0.992226f, -0.0544522f, 
		0.111986f, 0.193166f, 0.974754f, 0.112093f, -0.874752f, -0.471428f, 
		0.112096f, 0.149376f, 0.982406f, 0.112127f, -0.991952f, -0.0588182f, 
		0.112987f, 0.938883f, 0.325166f, 0.113002f, -0.993499f, -0.0137683f, 
		0.113128f, -0.991545f, 0.0635644f, 0.113783f, -0.989088f, -0.0935849f, 
		0.113797f, -0.990594f, -0.0759858f, 0.114032f, -0.598187f, 0.793202f, 
		0.114162f, 0.254379f, -0.960343f, 0.114219f, 0.144574f, -0.982880f, 
		0.114316f, -0.599278f, 0.792337f, 0.114930f, -0.821812f, 0.558047f, 
		0.115163f, -0.455654f, -0.882676f, 0.115213f, 0.238032f, 0.964400f, 
		0.115248f, 0.313399f, -0.942602f, 0.115419f, -0.930561f, -0.347468f, 
		0.115848f, 0.838622f, 0.532251f, 0.116325f, 0.685903f, -0.718335f, 
		0.116796f, 0.369648f, -0.921802f, 0.116874f, -0.993125f, -0.00661785f, 
		0.116907f, -0.992735f, -0.0284547f, 0.117263f, -0.993032f, -0.0117125f, 
		0.117328f, -0.397811f, 0.909934f, 0.117353f, 0.467388f, -0.876229f, 
		0.117418f, -0.993032f, 0.00999807f, 0.118289f, -0.991999f, -0.0441113f, 
		0.118435f, -0.991590f, 0.0521707f, 0.118448f, 0.517273f, 0.847584f, 
		0.118615f, -0.984302f, 0.130692f, 0.118690f, 0.990857f, -0.0641562f, 
		0.118732f, 0.990852f, -0.0641528f, 0.118868f, -0.0326561f, -0.992373f, 
		0.118881f, -0.988842f, 0.0897720f, 0.119039f, 0.143212f, -0.982507f, 
		0.119322f, 0.398776f, -0.909252f, 0.119366f, -0.713775f, -0.690129f, 
		0.119481f, 0.317092f, -0.940838f, 0.119537f, 0.674587f, -0.728453f, 
		0.119594f, -0.929804f, 0.348084f, 0.120308f, 0.950563f, 0.286279f, 
		0.120378f, 0.0415136f, 0.991860f, 0.120604f, -0.434840f, 0.892395f, 
		0.120946f, 0.0830325f, 0.989180f, 0.121046f, 0.670134f, 0.732303f, 
		0.121046f, -0.991416f, 0.0494113f, 0.121052f, -0.992573f, 0.0120605f, 
		0.121288f, 0.193444f, 0.973585f, 0.121390f, 0.867250f, 0.482848f, 
		0.121481f, 0.267828f, -0.955777f, 0.121543f, 0.223841f, 0.967017f, 
		0.121666f, 0.982126f, -0.143616f, 0.121769f, -0.167296f, -0.978358f, 
		0.121992f, -0.991963f, 0.0335707f, 0.122091f, 0.0780203f, 0.989448f, 
		0.122474f, -0.394242f, 0.910809f, 0.122548f, -0.484228f, 0.866317f, 
		0.122656f, 0.779623f, 0.614120f, 0.122798f, -0.927545f, 0.352960f, 
		0.123233f, -0.992322f, -0.0104964f, 0.123296f, 0.505541f, -0.853947f, 
		0.123455f, -0.108159f, -0.986438f, 0.124394f, -0.563000f, 0.817042f, 
		0.124425f, -0.928530f, 0.349786f, 0.124783f, -0.585423f, -0.801067f, 
		0.124808f, -0.232165f, -0.964636f, 0.125146f, -0.991923f, -0.0206595f, 
		0.125406f, -0.861608f, 0.491838f, 0.125463f, -0.946108f, -0.298561f, 
		0.125713f, -0.491686f, 0.861650f, 0.125747f, -0.586420f, 0.800187f, 
		0.125781f, 0.629708f, 0.766582f, 0.125782f, -0.991803f, -0.0225075f, 
		0.126119f, -0.989863f, -0.0653037f, 0.126121f, 0.799760f, -0.586922f, 
		0.126514f, -0.620244f, -0.774139f, 0.126618f, 0.315441f, 0.940460f, 
		0.127514f, 0.824739f, 0.550949f, 0.127632f, -0.523362f, 0.842498f, 
		0.127700f, 0.874560f, 0.467800f, 0.127737f, 0.704311f, 0.698305f, 
		0.127744f, -0.991772f, 0.00836548f, 0.127944f, 0.608555f, -0.783129f, 
		0.128071f, 0.0624026f, -0.989800f, 0.128142f, 0.0620594f, -0.989812f, 
		0.128392f, -0.216546f, -0.967793f, 0.128518f, 0.317903f, -0.939372f, 
		0.128660f, 0.402021f, -0.906546f, 0.128688f, 0.587167f, 0.799171f, 
		0.128718f, -0.991506f, 0.0186176f, 0.128829f, 0.521930f, -0.843204f, 
		0.128850f, 0.602524f, -0.787631f, 0.128948f, -0.242772f, -0.961475f, 
		0.129049f, -0.988812f, -0.0748179f, 0.129112f, 0.195827f, -0.972102f, 
		0.129592f, -0.618793f, 0.774791f, 0.130684f, 0.311721f, -0.941144f, 
		0.131331f, 0.685776f, -0.715866f, 0.131445f, 0.931713f, -0.338574f, 
		0.131458f, 0.353315f, 0.926222f, 0.131461f, 0.931710f, -0.338577f, 
		0.131621f, -0.991156f, 0.0169179f, 0.131638f, 0.697869f, -0.704024f, 
		0.132066f, 0.527861f, -0.839000f, 0.132253f, 0.798238f, -0.587644f, 
		0.132597f, -0.286796f, 0.948771f, 0.132658f, 0.853365f, -0.504153f, 
		0.133140f, -0.559101f, -0.818339f, 0.133222f, 0.840400f, 0.525338f, 
		0.133309f, 0.905467f, -0.402937f, 0.133655f, -0.990967f, 0.0110285f, 
		0.133686f, -0.935312f, -0.327596f, 0.134253f, -0.912320f, 0.386844f, 
		0.134341f, 0.853571f, 0.503357f, 0.134400f, 0.657663f, 0.741226f, 
		0.134501f, 0.0953746f, 0.986313f, 0.135093f, -0.990832f, -0.00134968f, 
		0.135108f, 0.175691f, -0.975130f, 0.135253f, -0.461731f, -0.876648f, 
		0.135293f, -0.755391f, -0.641156f, 0.135426f, 0.810995f, -0.569164f, 
		0.135541f, 0.962483f, -0.235064f, 0.136026f, 0.481553f, -0.865797f, 
		0.136742f, 0.975183f, 0.174124f, 0.136776f, -0.463974f, 0.875226f, 
		0.136854f, 0.861488f, -0.488989f, 0.137338f, 0.697061f, -0.703736f, 
		0.137802f, 0.451312f, 0.881662f, 0.138179f, 0.315695f, 0.938746f, 
		0.138295f, -0.965022f, 0.222727f, 0.138994f, 0.643842f, 0.752428f, 
		0.139601f, 0.853857f, 0.501438f, 0.139750f, 0.853927f, 0.501277f, 
		0.140489f, 0.566736f, -0.811833f, 0.140499f, -0.973952f, 0.177984f, 
		0.141084f, -0.580212f, 0.802153f, 0.141110f, -0.580144f, 0.802198f, 
		0.141390f, 0.0152957f, -0.989836f, 0.141533f, -0.545724f, -0.825926f, 
		0.142127f, -0.989040f, -0.0399959f, 0.142409f, 0.281394f, 0.948966f, 
		0.142588f, 0.989782f, 0.000000f, 0.142720f, -0.231613f, -0.962282f, 
		0.142735f, 0.752583f, -0.642842f, 0.142773f, 0.541768f, 0.828314f, 
		0.142911f, -0.421260f, -0.895610f, 0.142948f, 0.564754f, 0.812785f, 
		0.142973f, -0.922609f, 0.358261f, 0.143424f, 0.581033f, -0.801143f, 
		0.143465f, 0.569779f, 0.809179f, 0.143482f, 0.405620f, -0.902710f, 
		0.143809f, 0.773711f, -0.617001f, 0.144048f, -0.547429f, -0.824361f, 
		0.144142f, -0.876246f, -0.459800f, 0.144149f, 0.440134f, 0.886286f, 
		0.144297f, -0.974559f, -0.171502f, 0.144314f, -0.0470646f, -0.988412f, 
		0.144824f, 0.895822f, -0.420153f, 0.145226f, -0.218488f, 0.964973f, 
		0.146090f, 0.240280f, -0.959647f, 0.146351f, -0.984615f, 0.0954757f, 
		0.146356f, 0.740522f, -0.655902f, 0.146859f, 0.418729f, 0.896158f, 
		0.147313f, 0.803517f, 0.576766f, 0.147356f, -0.928435f, 0.341021f, 
		0.147436f, 0.716135f, -0.682212f, 0.147494f, 0.231430f, -0.961606f, 
		0.147641f, 0.812120f, -0.564503f, 0.147732f, 0.334992f, 0.930567f, 
		0.147790f, -0.863319f, -0.482534f, 0.147891f, 0.493002f, 0.857366f, 
		0.148119f, -0.902272f, 0.404927f, 0.148212f, -0.985265f, -0.0853643f, 
		0.148330f, 0.912976f, -0.380096f, 0.148392f, -0.926232f, 0.346516f, 
		0.148587f, 0.163476f, 0.975293f, 0.148632f, -0.365818f, -0.918741f, 
		0.148766f, 0.943052f, 0.297527f, 0.149161f, 0.400037f, -0.904279f, 
		0.149898f, 0.615208f, -0.773983f, 0.149900f, 0.230695f, -0.961410f, 
		0.149920f, 0.417611f, -0.896172f, 0.149953f, -0.0373922f, 0.987986f, 
		0.150239f, 0.491261f, 0.857957f, 0.150338f, -0.918086f, -0.366765f, 
		0.150709f, 0.0412804f, -0.987716f, 0.150792f, 0.936645f, 0.316162f, 
		0.151990f, 0.554352f, -0.818286f, 0.152012f, -0.983551f, -0.0975690f, 
		0.152164f, -0.987367f, -0.0441954f, 0.152206f, -0.746378f, -0.647883f, 
		0.152459f, 0.321867f, 0.934429f, 0.152847f, 0.364373f, 0.918624f, 
		0.152893f, 0.178255f, 0.972033f, 0.153348f, 0.0634830f, -0.986131f, 
		0.153537f, 0.327334f, 0.932351f, 0.153631f, -0.397253f, 0.904758f, 
		0.153666f, 0.872800f, -0.463256f, 0.153775f, 0.686766f, 0.710427f, 
		0.154005f, -0.553739f, -0.818325f, 0.154178f, 0.116007f, 0.981209f, 
		0.154715f, -0.152523f, -0.976115f, 0.154816f, -0.457912f, -0.875414f, 
		0.155172f, -0.852793f, -0.498664f, 0.155398f, -0.987831f, 0.00648813f, 
		0.155461f, 0.229497f, -0.960814f, 0.155900f, 0.929804f, 0.333405f, 
		0.156238f, -0.979035f, -0.130695f, 0.156350f, 0.306540f, 0.938929f, 
		0.156887f, -0.982563f, -0.0997851f, 0.157032f, 0.500469f, -0.851394f, 
		0.157048f, -0.126274f, -0.979485f, 0.157571f, 0.336751f, 0.928316f, 
		0.158010f, 0.0737216f, 0.984682f, 0.158089f, -0.723391f, -0.672096f, 
		0.158151f, -0.235483f, 0.958924f, 0.158712f, 0.335917f, 0.928423f, 
		0.158724f, 0.335798f, 0.928464f, 0.158750f, 0.788925f, 0.593629f, 
		0.158920f, -0.858229f, -0.488044f, 0.158958f, 0.901276f, 0.403030f, 
		0.159488f, -0.791937f, 0.589406f, 0.159496f, 0.0457201f, -0.986139f, 
		0.160312f, 0.345956f, -0.924454f, 0.160670f, -0.983772f, -0.0798642f, 
		0.160722f, 0.451857f, 0.877493f, 0.160926f, 0.243141f, -0.956549f, 
		0.161026f, 0.626214f, -0.762841f, 0.161152f, -0.461985f, -0.872124f, 
		0.161435f, 0.587548f, -0.792923f, 0.161554f, 0.622399f, -0.765846f, 
		0.161667f, 0.380770f, -0.910427f, 0.161954f, 0.418474f, 0.893672f, 
		0.162143f, 0.533946f, -0.829826f, 0.162492f, 0.0782979f, 0.983598f, 
		0.162635f, -0.436832f, -0.884719f, 0.164473f, -0.845971f, -0.507230f, 
		0.164594f, -0.799385f, -0.577834f, 0.164751f, -0.599217f, 0.783451f, 
		0.165002f, 0.315239f, 0.934558f, 0.165238f, 0.624797f, -0.763102f, 
		0.165283f, 0.170961f, -0.971315f, 0.165473f, 0.744977f, -0.646241f, 
		0.165968f, -0.741534f, 0.650063f, 0.166604f, 0.692157f, -0.702255f, 
		0.166973f, 0.357657f, -0.918804f, 0.167353f, 0.969650f, -0.178244f, 
		0.167858f, 0.134900f, 0.976538f, 0.167905f, 0.604270f, 0.778887f, 
		0.168017f, -0.548235f, -0.819273f, 0.168269f, -0.464027f, 0.869692f, 
		0.168581f, 0.970245f, 0.173797f, 0.169195f, 0.0920186f, -0.981277f, 
		0.169446f, 0.815088f, -0.554003f, 0.169626f, 0.747468f, 0.642277f, 
		0.169865f, -0.972055f, 0.162031f, 0.169916f, 0.0910296f, -0.981245f, 
		0.170061f, 0.354380f, -0.919508f, 0.170210f, -0.115399f, -0.978627f, 
		0.170239f, -0.977939f, -0.121051f, 0.170279f, -0.978565f, 0.115829f, 
		0.170326f, -0.959862f, -0.222831f, 0.170335f, -0.576033f, -0.799482f, 
		0.170558f, 0.645185f, -0.744746f, 0.170666f, 0.194464f, 0.965949f, 
		0.171024f, 0.106375f, 0.979508f, 0.171134f, 0.826675f, -0.536023f, 
		0.171143f, 0.634173f, -0.754012f, 0.171210f, -0.165569f, 0.971223f, 
		0.171245f, 0.742556f, -0.647523f, 0.171423f, 0.666931f, -0.725133f, 
		0.171427f, 0.333867f, 0.926901f, 0.171973f, 0.501740f, -0.847751f, 
		0.171977f, 0.148713f, -0.973811f, 0.172350f, 0.393028f, -0.903230f, 
		0.172474f, 0.965980f, 0.192704f, 0.172475f, 0.852070f, -0.494195f, 
		0.172513f, -0.975005f, -0.140015f, 0.172890f, -0.648879f, 0.740989f, 
		0.172922f, -0.912691f, -0.370261f, 0.173371f, -0.894498f, -0.412088f, 
		0.173394f, -0.869236f, 0.462994f, 0.173698f, -0.575131f, -0.799408f, 
		0.174202f, -0.530090f, -0.829854f, 0.174474f, 0.0837566f, 0.981093f, 
		0.174598f, 0.0134638f, -0.984548f, 0.175169f, 0.431125f, 0.885126f, 
		0.175478f, 0.366859f, 0.913576f, 0.175657f, 0.635077f, -0.752212f, 
		0.176526f, 0.0328786f, -0.983747f, 0.176858f, -0.872462f, -0.455556f, 
		0.177035f, -0.915553f, 0.361140f, 0.177520f, 0.0242351f, 0.983819f, 
		0.177586f, 0.742848f, 0.645476f, 0.177596f, 0.256714f, 0.950030f, 
		0.177629f, -0.0924479f, 0.979746f, 0.177778f, 0.0898903f, 0.979956f, 
		0.178014f, -0.976136f, -0.124376f, 0.178906f, 0.393409f, 0.901788f, 
		0.179132f, 0.0395077f, -0.983031f, 0.179141f, -0.983823f, 0.000635525f, 
		0.179252f, 0.204667f, 0.962279f, 0.179569f, 0.489944f, -0.853059f, 
		0.179691f, 0.320062f, -0.930200f, 0.180305f, -0.908947f, -0.375907f, 
		0.180697f, 0.477256f, -0.859986f, 0.181091f, 0.609654f, -0.771704f, 
		0.181284f, 0.487738f, -0.853960f, 0.181327f, 0.963898f, -0.194990f, 
		0.181384f, 0.900033f, 0.396283f, 0.181870f, -0.621531f, 0.761986f, 
		0.181891f, -0.621485f, 0.762018f, 0.182755f, 0.847356f, 0.498587f, 
		0.182902f, -0.979195f, -0.0878835f, 0.182950f, 0.430599f, -0.883806f, 
		0.183090f, -0.490239f, 0.852140f, 0.183375f, -0.381708f, 0.905910f, 
		0.183602f, -0.369917f, 0.910742f, 0.183933f, -0.980509f, 0.0690712f, 
		0.183976f, 0.485413f, -0.854709f, 0.184236f, 0.617949f, -0.764328f, 
		0.184345f, -0.826144f, 0.532450f, 0.184461f, 0.335858f, -0.923674f, 
		0.184653f, -0.00950977f, -0.982758f, 0.184657f, 0.804958f, 0.563866f, 
		0.184837f, 0.757427f, -0.626210f, 0.184989f, 0.559987f, -0.807585f, 
		0.185225f, 0.490281f, -0.851655f, 0.185283f, -0.366831f, 0.911650f, 
		0.185484f, 0.427407f, -0.884827f, 0.185630f, 0.956429f, 0.225357f, 
		0.185710f, -0.209621f, -0.959985f, 0.185711f, 0.166791f, 0.968345f, 
		0.185825f, -0.623538f, 0.759388f, 0.186479f, 0.382739f, 0.904841f, 
		0.186953f, 0.478444f, 0.857986f, 0.187426f, 0.478430f, -0.857891f, 
		0.187677f, 0.186050f, 0.964449f, 0.187740f, 0.491497f, -0.850403f, 
		0.188271f, 0.309190f, -0.932178f, 0.188728f, -0.528902f, -0.827433f, 
		0.188740f, -0.528691f, -0.827564f, 0.188811f, -0.931477f, 0.310968f, 
		0.189436f, 0.373647f, 0.908021f, 0.189759f, 0.189688f, 0.963333f, 
		0.189784f, -0.150889f, -0.970162f, 0.190046f, 0.355089f, -0.915311f, 
		0.191492f, 0.642852f, 0.741668f, 0.191497f, 0.139712f, -0.971499f, 
		0.191586f, 0.401727f, -0.895494f, 0.191751f, 0.933010f, -0.304506f, 
		0.191764f, 0.0465808f, -0.980335f, 0.191905f, -0.331449f, 0.923750f, 
		0.191928f, 0.244947f, -0.950350f, 0.192039f, -0.665932f, 0.720871f, 
		0.192057f, -0.981239f, 0.0168351f, 0.192987f, -0.160096f, -0.968052f, 
		0.193015f, 0.505490f, -0.840967f, 0.193031f, -0.815265f, -0.545968f, 
		0.193304f, 0.569834f, 0.798701f, 0.193558f, 0.780536f, 0.594389f, 
		0.193827f, 0.529914f, -0.825604f, 0.194113f, 0.0224301f, 0.980723f, 
		0.194142f, 0.0772039f, -0.977931f, 0.194236f, -0.946733f, -0.256844f, 
		0.194772f, 0.705373f, -0.681552f, 0.194795f, -0.946764f, -0.256307f, 
		0.195306f, 0.357922f, 0.913098f, 0.195377f, 0.356919f, 0.913475f, 
		0.195452f, 0.385812f, -0.901636f, 0.195537f, 0.883869f, -0.424902f, 
		0.195669f, 0.329916f, -0.923509f, 0.195897f, 0.553726f, 0.809328f, 
		0.195917f, 0.975716f, 0.0979569f, 0.195938f, 0.728628f, 0.656284f, 
		0.196269f, -0.194284f, 0.961110f, 0.196658f, 0.131208f, 0.971653f, 
		0.197193f, 0.870670f, 0.450608f, 0.197319f, 0.375037f, -0.905766f, 
		0.197741f, -0.700242f, 0.685974f, 0.197959f, 0.559908f, -0.804559f, 
		0.197989f, -0.745681f, 0.636208f, 0.198294f, 0.738823f, -0.644065f, 
		0.198528f, -0.929608f, 0.310509f, 0.198727f, -0.478001f, -0.855583f, 
		0.199187f, -0.838077f, -0.507888f, 0.199261f, -0.527265f, -0.826006f, 
		0.199420f, -0.737326f, -0.645432f, 0.199834f, -0.711097f, 0.674098f, 
		0.199949f, -0.518025f, -0.831667f, 0.200003f, -0.966564f, -0.160475f, 
		0.200080f, -0.966395f, -0.161398f, 0.200326f, -0.301907f, 0.932052f, 
		0.200398f, -0.912912f, -0.355575f, 0.201127f, -0.895743f, -0.396474f, 
		0.201501f, 0.749270f, -0.630865f, 0.201651f, -0.962481f, 0.181567f, 
		0.202120f, 0.277239f, -0.939301f, 0.202166f, 0.556687f, 0.805747f, 
		0.202178f, -0.0943061f, 0.974798f, 0.202758f, 0.508515f, -0.836841f, 
		0.202817f, 0.496511f, -0.844004f, 0.203336f, 0.635235f, -0.745071f, 
		0.203371f, -0.0652458f, 0.976925f, 0.203535f, -0.174372f, -0.963415f, 
		0.203882f, 0.320598f, 0.925013f, 0.203959f, -0.366232f, -0.907896f, 
		0.204444f, 0.696639f, -0.687675f, 0.204518f, -0.664318f, 0.718925f, 
		0.204798f, 0.234019f, -0.950417f, 0.205076f, 0.403692f, -0.891615f, 
		0.205192f, -0.909700f, -0.361029f, 0.205200f, -0.909689f, -0.361053f, 
		0.205946f, 0.628065f, -0.750414f, 0.205949f, 0.471996f, -0.857208f, 
		0.206253f, -0.292101f, -0.933882f, 0.206390f, -0.465755f, 0.860509f, 
		0.206403f, 0.776805f, 0.594956f, 0.206691f, 0.194412f, -0.958897f, 
		0.207267f, -0.495568f, -0.843477f, 0.209086f, -0.913110f, 0.350019f, 
		0.209158f, -0.890312f, -0.404473f, 0.210485f, 0.905482f, -0.368509f, 
		0.210506f, 0.331567f, 0.919647f, 0.210722f, 0.668101f, -0.713609f, 
		0.210863f, -0.892144f, -0.399519f, 0.210901f, 0.902719f, -0.374992f, 
		0.210990f, -0.664644f, 0.716751f, 0.211032f, 0.567078f, 0.796171f, 
		0.211369f, 0.333449f, -0.918768f, 0.211749f, 0.143090f, 0.966792f, 
		0.211804f, 0.844173f, -0.492454f, 0.212305f, 0.790959f, -0.573855f, 
		0.212873f, -0.0326041f, 0.976536f, 0.212922f, 0.455953f, 0.864159f, 
		0.213301f, 0.692616f, -0.689047f, 0.214152f, 0.804750f, 0.553639f, 
		0.214947f, -0.450730f, -0.866395f, 0.214949f, -0.908910f, -0.357322f, 
		0.215241f, -0.884799f, 0.413283f, 0.216574f, -0.512293f, -0.831054f, 
		0.217122f, -0.280887f, -0.934859f, 0.217325f, 0.385224f, 0.896868f, 
		0.217458f, 0.579772f, -0.785224f, 0.217515f, 0.608652f, -0.763040f, 
		0.217566f, 0.0289213f, 0.975617f, 0.217634f, 0.266988f, -0.938804f, 
		0.217722f, -0.623017f, 0.751297f, 0.217957f, 0.489264f, 0.844461f, 
		0.218112f, -0.903607f, 0.368674f, 0.219202f, 0.535326f, 0.815706f, 
		0.219245f, 0.653692f, 0.724305f, 0.219388f, -0.610760f, -0.760816f, 
		0.219583f, 0.271052f, -0.937184f, 0.219992f, 0.626898f, 0.747397f, 
		0.220074f, 0.607415f, -0.763292f, 0.220631f, -0.174206f, -0.959674f, 
		0.220650f, 0.959819f, 0.173379f, 0.220674f, -0.174314f, -0.959644f, 
		0.220691f, 0.932763f, 0.285043f, 0.220751f, 0.461461f, -0.859257f, 
		0.220841f, 0.690220f, -0.689076f, 0.221184f, -0.969479f, -0.105778f, 
		0.221218f, -0.969468f, -0.105807f, 0.221228f, -0.387557f, 0.894907f, 
		0.221384f, -0.899837f, 0.375875f, 0.222295f, -0.179378f, -0.958336f, 
		0.222650f, 0.574369f, -0.787736f, 0.222809f, -0.851444f, 0.474762f, 
		0.223012f, -0.593298f, -0.773475f, 0.223024f, 0.385196f, 0.895480f, 
		0.223113f, 0.670300f, 0.707756f, 0.223574f, 0.567871f, 0.792173f, 
		0.223680f, 0.974404f, 0.0224687f, 0.223820f, 0.606697f, -0.762774f, 
		0.223934f, -0.148393f, -0.963241f, 0.223996f, 0.313865f, -0.922667f, 
		0.224138f, -0.905536f, -0.360230f, 0.224165f, -0.443723f, 0.867675f, 
		0.224202f, 0.810502f, 0.541128f, 0.224220f, 0.730382f, -0.645187f, 
		0.225304f, 0.648379f, -0.727215f, 0.225444f, 0.955353f, -0.190984f, 
		0.225535f, -0.178568f, -0.957730f, 0.225665f, 0.0815801f, -0.970783f, 
		0.225950f, 0.376378f, -0.898491f, 0.226554f, -0.572443f, -0.788024f, 
		0.227236f, -0.554532f, -0.800536f, 0.227281f, -0.962245f, -0.149759f, 
		0.227587f, 0.650492f, 0.724613f, 0.227664f, 0.552305f, -0.801953f, 
		0.228544f, 0.197417f, -0.953307f, 0.228601f, 0.622343f, -0.748619f, 
		0.228661f, -0.187284f, -0.955321f, 0.229278f, 0.0825334f, -0.969856f, 
		0.229293f, 0.969056f, -0.0914029f, 0.229412f, 0.0618963f, 0.971359f, 
		0.229493f, -0.475580f, -0.849209f, 0.229849f, -0.380344f, 0.895828f, 
		0.229862f, 0.697093f, 0.679135f, 0.229978f, 0.491155f, 0.840165f, 
		0.230201f, 0.738030f, -0.634286f, 0.230297f, 0.973121f, 0.000000f, 
		0.230478f, 0.663497f, -0.711795f, 0.230571f, 0.477020f, -0.848109f, 
		0.231076f, -0.283338f, -0.930765f, 0.231088f, -0.970421f, 0.0698625f, 
		0.231268f, -0.118590f, 0.965635f, 0.231315f, -0.118518f, 0.965633f, 
		0.231601f, 0.740426f, -0.630976f, 0.231914f, -0.780456f, -0.580607f, 
		0.231917f, -0.780441f, -0.580627f, 0.232106f, -0.948431f, 0.215882f, 
		0.232563f, -0.474067f, -0.849220f, 0.232991f, -0.429029f, -0.872725f, 
		0.233043f, 0.619007f, 0.750014f, 0.233347f, -0.875771f, 0.422580f, 
		0.233350f, 0.572718f, -0.785838f, 0.233606f, -0.908873f, 0.345512f, 
		0.233622f, 0.487904f, -0.841053f, 0.233865f, 0.816474f, -0.527899f, 
		0.234007f, 0.773704f, 0.588747f, 0.234156f, -0.220578f, -0.946846f, 
		0.235347f, -0.914139f, -0.330093f, 0.235724f, -0.950038f, 0.204601f, 
		0.235927f, -0.950366f, 0.202837f, 0.235965f, -0.950353f, 0.202852f, 
		0.236128f, -0.649920f, -0.722390f, 0.236195f, 0.774341f, -0.587034f, 
		0.236657f, 0.964362f, -0.118320f, 0.237075f, 0.525296f, 0.817227f, 
		0.237270f, 0.470271f, 0.850028f, 0.237292f, 0.284948f, 0.928707f, 
		0.238184f, 0.622917f, 0.745146f, 0.238293f, 0.873494f, -0.424528f, 
		0.238599f, -0.176882f, -0.954873f, 0.238818f, 0.616872f, 0.749956f, 
		0.238831f, 0.849235f, -0.470914f, 0.238873f, -0.948642f, 0.207410f, 
		0.238873f, -0.948646f, 0.207389f, 0.239220f, 0.570645f, 0.785582f, 
		0.239357f, 0.462173f, 0.853876f, 0.239407f, 0.470616f, 0.849238f, 
		0.239452f, 0.382617f, -0.892338f, 0.239603f, 0.561839f, 0.791788f, 
		0.240172f, -0.908553f, -0.341832f, 0.240663f, -0.562350f, -0.791103f, 
		0.240734f, 0.424947f, 0.872621f, 0.240907f, 0.695464f, -0.676974f, 
		0.240974f, -0.545273f, -0.802876f, 0.241017f, -0.507648f, 0.827166f, 
		0.241637f, 0.507083f, -0.827332f, 0.242249f, 0.743187f, -0.623689f, 
		0.242407f, -0.901556f, 0.358380f, 0.242725f, -0.725294f, -0.644230f, 
		0.243706f, -0.432465f, -0.868091f, 0.244080f, 0.922621f, 0.298657f, 
		0.244124f, 0.922610f, 0.298654f, 0.244641f, 0.824597f, -0.510089f, 
		0.244803f, 0.151037f, -0.957737f, 0.244956f, -0.367288f, -0.897271f, 
		0.245249f, -0.447057f, 0.860228f, 0.245440f, 0.697332f, 0.673415f, 
		0.245529f, 0.451415f, 0.857870f, 0.245734f, 0.554101f, -0.795353f, 
		0.245876f, -0.363258f, 0.898659f, 0.245965f, 0.922698f, 0.296865f, 
		0.246003f, 0.729917f, -0.637733f, 0.247492f, -0.463114f, -0.851043f, 
		0.247498f, -0.434338f, -0.866081f, 0.247513f, 0.838665f, -0.485158f, 
		0.247550f, 0.260814f, -0.933110f, 0.248082f, 0.741607f, -0.623277f, 
		0.248250f, -0.627688f, 0.737821f, 0.248434f, 0.513979f, 0.821040f, 
		0.248625f, 0.497569f, 0.831030f, 0.248920f, 0.250663f, -0.935525f, 
		0.248948f, 0.918278f, 0.307882f, 0.249003f, -0.0598947f, 0.966649f, 
		0.249209f, -0.241900f, -0.937752f, 0.249243f, 0.792768f, 0.556235f, 
		0.249295f, 0.419431f, -0.872886f, 0.250123f, 0.263922f, 0.931549f, 
		0.250394f, -0.287914f, -0.924342f, 0.250566f, -0.963539f, 0.0938613f, 
		0.250674f, 0.700095f, -0.668603f, 0.250695f, 0.0954734f, 0.963347f, 
		0.250837f, 0.916181f, 0.312559f, 0.250850f, 0.916184f, 0.312540f, 
		0.250867f, 0.828909f, 0.499975f, 0.251836f, -0.920387f, -0.299110f, 
		0.252046f, 0.699359f, -0.668857f, 0.252923f, 0.634933f, 0.729993f, 
		0.252942f, 0.00331796f, 0.967476f, 0.253162f, -0.601519f, 0.757684f, 
		0.253286f, -0.621723f, 0.741153f, 0.253942f, -0.640454f, 0.724798f, 
		0.254103f, -0.617801f, 0.744147f, 0.254758f, 0.759678f, 0.598321f, 
		0.255037f, -0.760899f, -0.596648f, 0.255463f, 0.327617f, -0.909618f, 
		0.255840f, 0.368834f, -0.893592f, 0.256174f, 0.882945f, 0.393426f, 
		0.256200f, -0.823662f, -0.505907f, 0.256235f, -0.476485f, -0.841014f, 
		0.256287f, -0.921751f, 0.291018f, 0.256480f, -0.760522f, -0.596511f, 
		0.257198f, -0.580330f, -0.772701f, 0.257209f, -0.962486f, 0.0863916f, 
		0.257264f, 0.862594f, 0.435600f, 0.257408f, 0.668608f, -0.697642f, 
		0.257498f, 0.0479173f, 0.965090f, 0.257523f, 0.0478478f, 0.965087f, 
		0.258129f, -0.447083f, -0.856438f, 0.258241f, 0.304373f, -0.916880f, 
		0.259449f, 0.816890f, 0.515147f, 0.259568f, 0.0258893f, -0.965378f, 
		0.259814f, -0.919831f, -0.293952f, 0.259871f, 0.956596f, 0.131878f, 
		0.260407f, 0.695315f, -0.669869f, 0.260429f, -0.840383f, 0.475324f, 
		0.261311f, 0.751414f, 0.605882f, 0.261686f, -0.945646f, -0.193067f, 
		0.261882f, -0.952741f, -0.153956f, 0.261979f, 0.785520f, 0.560647f, 
		0.262076f, 0.954619f, 0.141486f, 0.262308f, 0.352779f, 0.898188f, 
		0.262339f, -0.898457f, -0.352070f, 0.262789f, 0.258913f, 0.929465f, 
		0.262799f, 0.615311f, 0.743188f, 0.263336f, 0.664300f, -0.699543f, 
		0.263397f, -0.944425f, -0.196679f, 0.263402f, -0.0395108f, -0.963877f, 
		0.263677f, 0.491567f, 0.829962f, 0.263689f, 0.589994f, 0.763135f, 
		0.264106f, 0.160538f, -0.951039f, 0.264150f, 0.170574f, 0.949278f, 
		0.264506f, -0.159527f, 0.951098f, 0.264590f, -0.159641f, 0.951056f, 
		0.265054f, 0.617359f, 0.740685f, 0.265081f, -0.539473f, 0.799188f, 
		0.265589f, 0.130449f, -0.955220f, 0.265589f, -0.371518f, -0.889627f, 
		0.266449f, -0.562597f, -0.782617f, 0.266792f, 0.139026f, -0.953674f, 
		0.267186f, 0.505003f, 0.820721f, 0.267386f, -0.372755f, -0.888571f, 
		0.267761f, 0.853271f, 0.447474f, 0.267864f, -0.0722097f, -0.960747f, 
		0.268034f, 0.673147f, -0.689225f, 0.268410f, -0.493225f, 0.827457f, 
		0.268474f, -0.647661f, 0.713062f, 0.268792f, 0.535452f, 0.800651f, 
		0.269009f, -0.292143f, 0.917762f, 0.269077f, 0.802299f, -0.532835f, 
		0.269109f, 0.403226f, 0.874636f, 0.269169f, 0.327707f, -0.905625f, 
		0.269228f, 0.599099f, 0.754054f, 0.269379f, -0.315922f, 0.909741f, 
		0.269680f, 0.923139f, -0.274020f, 0.269819f, 0.462102f, -0.844784f, 
		0.269821f, 0.245544f, 0.931077f, 0.270366f, -0.0953436f, 0.958025f, 
		0.270570f, 0.502148f, 0.821364f, 0.270938f, 0.0115954f, -0.962527f, 
		0.271849f, 0.897375f, 0.347587f, 0.273013f, 0.688742f, 0.671639f, 
		0.273473f, 0.698032f, 0.661789f, 0.273487f, 0.683789f, 0.676489f, 
		0.273641f, 0.420546f, 0.865021f, 0.273705f, 0.691429f, 0.668589f, 
		0.273738f, 0.692675f, 0.667285f, 0.274031f, -0.229436f, -0.933952f, 
		0.274069f, 0.420097f, 0.865104f, 0.274175f, -0.927497f, 0.254120f, 
		0.274444f, 0.659624f, -0.699698f, 0.274632f, -0.177098f, 0.945100f, 
		0.274922f, -0.912795f, -0.302033f, 0.275013f, -0.0359124f, 0.960770f, 
		0.275706f, -0.325492f, 0.904456f, 0.276260f, 0.953474f, -0.120696f, 
		0.276655f, 0.795489f, -0.539128f, 0.276656f, 0.507618f, -0.815957f, 
		0.276674f, 0.245713f, 0.929019f, 0.276802f, 0.364571f, 0.889083f, 
		0.276817f, 0.702993f, -0.655113f, 0.276869f, 0.824637f, -0.493272f, 
		0.277006f, -0.931198f, -0.236933f, 0.277013f, -0.523338f, -0.805842f, 
		0.277539f, 0.397464f, 0.874639f, 0.277754f, -0.435331f, -0.856353f, 
		0.278019f, 0.852380f, 0.442892f, 0.278057f, -0.189979f, 0.941590f, 
		0.278121f, -0.377225f, -0.883375f, 0.278578f, 0.198280f, -0.939723f, 
		0.278827f, 0.339575f, 0.898301f, 0.278862f, -0.937145f, -0.209753f, 
		0.279552f, 0.950282f, 0.137165f, 0.279607f, 0.813208f, 0.510404f, 
		0.279635f, -0.888864f, -0.362941f, 0.279856f, -0.397236f, 0.874005f, 
		0.279981f, -0.410183f, 0.867963f, 0.280375f, 0.373071f, 0.884425f, 
		0.280398f, 0.594108f, 0.753932f, 0.280423f, 0.594089f, 0.753937f, 
		0.280942f, 0.871916f, 0.401041f, 0.281047f, 0.454840f, 0.845064f, 
		0.282043f, 0.603308f, 0.745970f, 0.282326f, -0.949750f, 0.135160f, 
		0.282485f, -0.655274f, 0.700584f, 0.282834f, -0.949677f, 0.134607f, 
		0.282870f, 0.189115f, 0.940330f, 0.282934f, 0.327689f, -0.901426f, 
		0.283681f, 0.647096f, -0.707666f, 0.283761f, 0.354877f, -0.890810f, 
		0.283992f, 0.126172f, 0.950489f, 0.284464f, -0.182791f, 0.941099f, 
		0.284570f, 0.176334f, 0.942298f, 0.284574f, 0.707188f, -0.647228f, 
		0.285770f, -0.925861f, -0.247220f, 0.285779f, -0.572334f, 0.768612f, 
		0.285808f, -0.428526f, -0.857134f, 0.285943f, 0.808694f, -0.514053f, 
		0.286263f, -0.900099f, -0.328444f, 0.286525f, -0.925119f, -0.249117f, 
		0.286558f, -0.158322f, -0.944891f, 0.286652f, 0.791702f, 0.539480f, 
		0.286804f, 0.211872f, -0.934266f, 0.286824f, 0.675085f, 0.679700f, 
		0.286833f, 0.332902f, -0.898278f, 0.286872f, 0.207008f, -0.935335f, 
		0.286958f, -0.0575929f, -0.956210f, 0.287059f, -0.246953f, -0.925533f, 
		0.287168f, 0.0394683f, -0.957067f, 0.287253f, 0.211185f, -0.934284f, 
		0.287405f, -0.943267f, -0.166269f, 0.287541f, 0.248467f, 0.924978f, 
		0.287675f, 0.190868f, 0.938516f, 0.287767f, -0.904763f, -0.313996f, 
		0.288205f, -0.149804f, -0.945778f, 0.288393f, 0.957512f, 0.000000f, 
		0.288518f, -0.0532159f, -0.955994f, 0.289050f, 0.946793f, -0.141534f, 
		0.289096f, -0.945500f, -0.149841f, 0.289135f, -0.931434f, 0.220981f, 
		0.289208f, 0.483145f, 0.826396f, 0.289316f, 0.196585f, 0.936830f, 
		0.289714f, 0.193062f, 0.937440f, 0.290355f, -0.892166f, -0.346025f, 
		0.291275f, 0.798998f, 0.526082f, 0.291322f, -0.932673f, 0.212728f, 
		0.291492f, 0.947576f, 0.130893f, 0.291686f, -0.930248f, -0.222618f, 
		0.291701f, -0.553685f, 0.779964f, 0.292163f, 0.601381f, -0.743627f, 
		0.292189f, 0.807944f, -0.511715f, 0.292217f, -0.121291f, 0.948629f, 
		0.293194f, 0.226126f, 0.928927f, 0.293216f, -0.754298f, 0.587417f, 
		0.293294f, 0.125237f, -0.947784f, 0.293660f, 0.796930f, -0.527888f, 
		0.293698f, 0.762423f, -0.576588f, 0.293734f, 0.615597f, 0.731273f, 
		0.294238f, 0.538438f, -0.789626f, 0.294404f, 0.641786f, 0.708122f, 
		0.295129f, 0.385085f, -0.874419f, 0.295189f, 0.0167533f, -0.955292f, 
		0.295284f, 0.509320f, -0.808332f, 0.295300f, 0.321092f, -0.899832f, 
		0.295527f, -0.419575f, -0.858266f, 0.295541f, 0.335921f, -0.894323f, 
		0.295615f, 0.670080f, 0.680885f, 0.296168f, 0.257950f, 0.919645f, 
		0.296896f, 0.651469f, -0.698170f, 0.297103f, 0.610385f, 0.734275f, 
		0.297915f, 0.220045f, 0.928885f, 0.298030f, 0.372432f, -0.878904f, 
		0.299227f, 0.294718f, -0.907526f, 0.299883f, 0.554163f, -0.776514f, 
		0.300007f, 0.329633f, 0.895175f, 0.300274f, -0.900725f, -0.313894f, 
		0.300286f, 0.873815f, 0.382460f, 0.300414f, -0.308780f, -0.902445f, 
		0.300933f, 0.374582f, 0.876999f, 0.301880f, -0.920160f, -0.249350f, 
		0.301935f, 0.434863f, -0.848369f, 0.302648f, -0.928268f, -0.216153f, 
		0.302778f, 0.874487f, 0.378943f, 0.303038f, 0.242846f, -0.921517f, 
		0.303341f, -0.915697f, 0.263596f, 0.303470f, -0.910653f, -0.280389f, 
		0.303525f, -0.807053f, -0.506495f, 0.303927f, -0.889804f, 0.340408f, 
		0.303973f, 0.355417f, -0.883900f, 0.304524f, 0.634504f, -0.710401f, 
		0.304948f, 0.711123f, -0.633491f, 0.305047f, -0.820545f, 0.483375f, 
		0.305149f, -0.125270f, 0.944030f, 0.305647f, 0.578601f, -0.756175f, 
		0.306058f, -0.790418f, -0.530630f, 0.306106f, -0.837096f, 0.453397f, 
		0.306846f, 0.789961f, 0.530855f, 0.307204f, -0.702320f, -0.642162f, 
		0.307338f, 0.180788f, 0.934269f, 0.307469f, 0.791210f, 0.528631f, 
		0.307568f, 0.353725f, -0.883335f, 0.307575f, -0.499892f, 0.809633f, 
		0.307879f, 0.779786f, -0.545109f, 0.307989f, -0.881817f, -0.357129f, 
		0.308017f, 0.779658f, -0.545215f, 0.308396f, 0.781371f, -0.542542f, 
		0.308697f, 0.780011f, -0.544325f, 0.308710f, 0.837465f, -0.450945f, 
		0.308730f, -0.885110f, 0.348234f, 0.308834f, 0.157010f, -0.938067f, 
		0.308955f, -0.137576f, 0.941074f, 0.309004f, 0.609615f, -0.729991f, 
		0.309203f, 0.318308f, 0.896144f, 0.309313f, 0.907837f, 0.283122f, 
		0.309511f, 0.0841626f, 0.947164f, 0.310503f, 0.557284f, -0.770079f, 
		0.311032f, 0.0772992f, -0.947251f, 0.311551f, 0.307326f, -0.899159f, 
		0.312070f, 0.224952f, -0.923043f, 0.312310f, 0.308686f, -0.898429f, 
		0.312320f, 0.0168491f, -0.949828f, 0.312464f, 0.107988f, -0.943771f, 
		0.312623f, 0.0995573f, 0.944646f, 0.312843f, -0.924400f, 0.218208f, 
		0.313058f, 0.662847f, 0.680168f, 0.313165f, -0.383682f, -0.868744f, 
		0.313632f, -0.929586f, 0.193662f, 0.313706f, 0.776308f, 0.546749f, 
		0.313756f, 0.593958f, 0.740791f, 0.313854f, -0.671537f, -0.671218f, 
		0.314234f, -0.923945f, -0.218134f, 0.314327f, 0.925828f, 0.209859f, 
		0.314598f, 0.107826f, 0.943081f, 0.314924f, -0.922104f, -0.224828f, 
		0.315279f, -0.895826f, -0.313201f, 0.315338f, 0.407356f, 0.857102f, 
		0.315723f, 0.386044f, -0.866769f, 0.317441f, -0.947244f, 0.0442638f, 
		0.317573f, 0.869190f, 0.379020f, 0.317719f, 0.626391f, 0.711821f, 
		0.317787f, 0.337358f, -0.886116f, 0.318011f, 0.0553031f, 0.946473f, 
		0.318047f, 0.707419f, 0.631192f, 0.318272f, -0.947991f, 0.00386785f, 
		0.318337f, -0.947970f, 0.00389062f, 0.318929f, 0.669786f, -0.670575f, 
		0.319312f, -0.630482f, -0.707483f, 0.319323f, -0.915230f, 0.245738f, 
		0.319393f, 0.269199f, 0.908581f, 0.320224f, -0.945981f, 0.0507614f, 
		0.321463f, -0.741198f, -0.589311f, 0.321901f, 0.335599f, -0.885298f, 
		0.321924f, -0.235918f, -0.916901f, 0.322112f, 0.0556598f, -0.945064f, 
		0.322374f, -0.832866f, -0.449899f, 0.322851f, 0.393760f, -0.860651f, 
		0.322870f, 0.422055f, 0.847127f, 0.323084f, -0.941711f, 0.0937882f, 
		0.323104f, -0.944326f, 0.0620675f, 0.323120f, -0.944320f, 0.0620671f, 
		0.323788f, 0.338600f, 0.883465f, 0.323917f, -0.250352f, 0.912360f, 
		0.324567f, -0.744755f, 0.583092f, 0.324733f, 0.546112f, 0.772211f, 
		0.324984f, 0.655353f, 0.681834f, 0.325330f, 0.358124f, 0.875161f, 
		0.325439f, -0.569268f, 0.754999f, 0.325439f, -0.126465f, -0.937068f, 
		0.325570f, 0.923099f, -0.204678f, 0.326036f, 0.259728f, -0.908978f, 
		0.326478f, -0.518352f, 0.790394f, 0.326505f, 0.396529f, 0.857997f, 
		0.326519f, 0.0301724f, -0.944709f, 0.326946f, -0.937918f, -0.115831f, 
		0.327224f, -0.918610f, -0.221539f, 0.327405f, 0.816197f, 0.476055f, 
		0.328083f, -0.899457f, 0.288684f, 0.328766f, 0.554155f, -0.764738f, 
		0.328813f, -0.922898f, -0.200354f, 0.328872f, -0.873131f, -0.359842f, 
		0.329103f, 0.594941f, -0.733305f, 0.329310f, -0.787061f, -0.521622f, 
		0.329509f, -0.691502f, -0.642845f, 0.329827f, -0.175697f, -0.927548f, 
		0.330128f, 0.418727f, -0.845981f, 0.330203f, -0.626004f, 0.706460f, 
		0.330465f, 0.921695f, 0.203151f, 0.331290f, 0.783725f, -0.525378f, 
		0.331436f, -0.897569f, 0.290725f, 0.331445f, -0.133836f, 0.933934f, 
		0.331544f, -0.681198f, -0.652723f, 0.331606f, -0.943340f, 0.0121267f, 
		0.331642f, -0.943327f, 0.0121410f, 0.331685f, 0.717667f, 0.612323f, 
		0.332162f, -0.504739f, -0.796810f, 0.332329f, 0.185518f, 0.924738f, 
		0.332511f, -0.931794f, -0.145590f, 0.333081f, 0.391384f, -0.857832f, 
		0.333185f, 0.337492f, 0.880390f, 0.333362f, -0.938600f, 0.0888763f, 
		0.333694f, -0.594096f, -0.731914f, 0.334000f, -0.938414f, 0.0884453f, 
		0.334006f, 0.105343f, -0.936666f, 0.334336f, -0.492273f, -0.803671f, 
		0.334497f, 0.291382f, 0.896219f, 0.334569f, 0.530170f, -0.779091f, 
		0.334901f, -0.555438f, 0.761137f, 0.335043f, 0.495503f, -0.801388f, 
		0.335205f, -0.687480f, 0.644212f, 0.335426f, 0.0856636f, 0.938164f, 
		0.335706f, 0.595012f, -0.730248f, 0.335903f, -0.0287786f, -0.941457f, 
		0.336794f, 0.608025f, 0.718941f, 0.337026f, -0.929663f, -0.148796f, 
		0.337147f, 0.493143f, -0.801961f, 0.337577f, -0.688254f, -0.642143f, 
		0.338027f, -0.731736f, 0.591862f, 0.338285f, -0.727006f, 0.597516f, 
		0.338438f, -0.735936f, 0.586394f, 0.339037f, 0.401933f, 0.850590f, 
		0.339080f, 0.592402f, 0.730811f, 0.339336f, -0.940663f, -0.00190427f, 
		0.339424f, -0.686394f, 0.643160f, 0.339446f, -0.471015f, 0.814200f, 
		0.339756f, -0.172690f, -0.924524f, 0.340092f, -0.312846f, -0.886829f, 
		0.340193f, 0.557575f, -0.757218f, 0.340312f, 0.611669f, 0.714177f, 
		0.340317f, 0.646615f, 0.682696f, 0.340460f, -0.940139f, -0.0150425f, 
		0.340640f, -0.916250f, -0.210831f, 0.340936f, 0.719384f, -0.605186f, 
		0.341114f, 0.119265f, -0.932425f, 0.341358f, 0.930248f, -0.134588f, 
		0.341714f, 0.354774f, 0.870269f, 0.341992f, 0.352420f, 0.871115f, 
		0.342126f, 0.141614f, 0.928922f, 0.342361f, -0.934903f, 0.0935163f, 
		0.342533f, 0.314608f, -0.885264f, 0.342962f, 0.498816f, -0.795965f, 
		0.342983f, -0.305576f, -0.888249f, 0.343227f, 0.809859f, 0.475734f, 
		0.343493f, -0.655389f, -0.672665f, 0.343501f, -0.763135f, -0.547387f, 
		0.343508f, 0.155678f, 0.926157f, 0.344270f, -0.335346f, 0.876939f, 
		0.344497f, 0.716402f, 0.606704f, 0.344552f, -0.914459f, 0.212248f, 
		0.344604f, -0.380378f, 0.858231f, 0.344986f, 0.791888f, 0.503884f, 
		0.345348f, 0.245032f, -0.905922f, 0.345928f, 0.803327f, 0.484768f, 
		0.345998f, -0.378882f, 0.858332f, 0.346175f, 0.837722f, 0.422355f, 
		0.346628f, 0.452822f, -0.821463f, 0.347390f, 0.848053f, 0.400158f, 
		0.347801f, 0.292681f, 0.890715f, 0.348530f, 0.930328f, 0.114087f, 
		0.348639f, -0.607854f, 0.713417f, 0.348687f, 0.218494f, 0.911415f, 
		0.348919f, 0.496838f, -0.794611f, 0.349261f, 0.575948f, -0.739121f, 
		0.349514f, 0.204298f, 0.914386f, 0.350846f, 0.366242f, -0.861843f, 
		0.350884f, -0.422476f, -0.835700f, 0.350949f, 0.807550f, 0.474023f, 
		0.351180f, -0.448537f, 0.821880f, 0.351367f, -0.936169f, -0.0113199f, 
		0.351375f, -0.918508f, -0.181326f, 0.351554f, -0.931018f, 0.0980540f, 
		0.351570f, -0.918406f, -0.181464f, 0.351914f, 0.568917f, -0.743297f, 
		0.352075f, -0.919900f, 0.172709f, 0.352338f, 0.236704f, -0.905444f, 
		0.352736f, 0.798100f, -0.488481f, 0.353388f, -0.893292f, 0.277753f, 
		0.353456f, -0.934836f, -0.0339134f, 0.353495f, 0.544340f, 0.760746f, 
		0.354060f, 0.823017f, 0.444168f, 0.354110f, 0.470248f, 0.808377f, 
		0.354113f, 0.823001f, 0.444155f, 0.354635f, -0.889539f, -0.288017f, 
		0.354840f, 0.259538f, -0.898181f, 0.354942f, 0.797706f, -0.487526f, 
		0.354988f, 0.659625f, 0.662479f, 0.355364f, 0.270895f, 0.894613f, 
		0.355421f, 0.433343f, 0.828184f, 0.355463f, 0.433392f, 0.828141f, 
		0.355547f, 0.385000f, 0.851682f, 0.356129f, -0.514996f, 0.779713f, 
		0.356225f, -0.579110f, 0.733304f, 0.356439f, 0.652938f, -0.668299f, 
		0.356498f, 0.653318f, 0.667895f, 0.356567f, 0.104159f, 0.928445f, 
		0.356942f, 0.620386f, -0.698365f, 0.357181f, -0.913285f, 0.195788f, 
		0.358278f, 0.891094f, 0.278546f, 0.358882f, 0.363807f, -0.859563f, 
		0.359176f, -0.477772f, -0.801702f, 0.359240f, 0.0615013f, 0.931216f, 
		0.359638f, -0.908997f, -0.210678f, 0.360017f, -0.204582f, -0.910238f, 
		0.360046f, 0.800050f, -0.479882f, 0.360087f, 0.336276f, -0.870205f, 
		0.360125f, 0.0602695f, -0.930955f, 0.360281f, -0.877054f, -0.317763f, 
		0.360395f, 0.157794f, 0.919356f, 0.360928f, 0.772421f, 0.522587f, 
		0.361051f, -0.852488f, 0.378030f, 0.361229f, -0.482679f, 0.797831f, 
		0.361495f, -0.875484f, -0.320702f, 0.362517f, 0.727974f, 0.581924f, 
		0.362808f, 0.348696f, -0.864165f, 0.362809f, -0.466446f, -0.806720f, 
		0.362903f, 0.761897f, -0.536483f, 0.363339f, -0.0847617f, 0.927793f, 
		0.363384f, -0.0911764f, 0.927167f, 0.363434f, 0.467439f, -0.805864f, 
		0.363626f, -0.882321f, -0.298806f, 0.363828f, 0.519087f, 0.773420f, 
		0.364025f, -0.0662842f, 0.929028f, 0.364244f, 0.359671f, 0.859048f, 
		0.364410f, -0.923182f, -0.122231f, 0.364801f, 0.792256f, -0.489132f, 
		0.365004f, 0.242301f, -0.898923f, 0.365030f, 0.503618f, -0.783021f, 
		0.365052f, 0.792804f, -0.488056f, 0.365126f, -0.457824f, 0.810605f, 
		0.365230f, 0.575464f, 0.731743f, 0.365336f, -0.0982014f, -0.925681f, 
		0.365557f, 0.757359f, 0.541087f, 0.365878f, -0.901831f, 0.229859f, 
		0.366558f, -0.927291f, -0.0759386f, 0.366581f, 0.307894f, -0.877964f, 
		0.366644f, 0.616248f, 0.697001f, 0.367397f, -0.881367f, -0.297004f, 
		0.367676f, 0.664572f, 0.650506f, 0.367742f, 0.446399f, 0.815778f, 
		0.367792f, -0.262688f, -0.892034f, 0.367920f, -0.236604f, -0.899251f, 
		0.368118f, 0.271697f, 0.889196f, 0.368346f, -0.380524f, -0.848247f, 
		0.368525f, 0.412604f, -0.833035f, 0.368558f, 0.467866f, -0.803285f, 
		0.368666f, 0.548492f, 0.750494f, 0.369015f, 0.137773f, -0.919155f, 
		0.369137f, 0.562173f, 0.740067f, 0.369175f, 0.264023f, -0.891068f, 
		0.369244f, 0.564384f, 0.738329f, 0.369287f, 0.776668f, 0.510309f, 
		0.369423f, -0.457285f, 0.808960f, 0.369547f, 0.550755f, 0.748401f, 
		0.369612f, 0.548889f, 0.749739f, 0.369714f, -0.924184f, -0.0958990f, 
		0.369775f, -0.906873f, -0.202109f, 0.369933f, -0.336725f, -0.865890f, 
		0.369977f, 0.262644f, 0.891143f, 0.370106f, 0.680841f, 0.632042f, 
		0.370186f, -0.806628f, 0.460774f, 0.370477f, 0.565620f, 0.736764f, 
		0.370640f, -0.589782f, -0.717484f, 0.372022f, 0.711989f, 0.595543f, 
		0.372104f, -0.870441f, -0.322289f, 0.372234f, 0.711664f, 0.595798f, 
		0.372308f, -0.860806f, 0.346986f, 0.372994f, 0.109048f, 0.921403f, 
		0.373711f, 0.711189f, 0.595441f, 0.373714f, -0.895178f, -0.242887f, 
		0.373970f, 0.870461f, 0.320069f, 0.374236f, -0.533959f, -0.758179f, 
		0.374593f, -0.890301f, -0.258928f, 0.375159f, -0.362825f, 0.853002f, 
		0.375205f, 0.316926f, -0.871080f, 0.376335f, 0.392426f, 0.839270f, 
		0.376940f, 0.615196f, 0.692423f, 0.377031f, 0.272014f, -0.885356f, 
		0.377562f, -0.399817f, 0.835221f, 0.377646f, 0.325956f, -0.866681f, 
		0.377993f, 0.923828f, -0.0605171f, 0.378080f, 0.375995f, 0.845981f, 
		0.378100f, -0.281769f, 0.881843f, 0.378578f, -0.756786f, -0.532873f, 
		0.378762f, 0.351413f, 0.856183f, 0.378972f, -0.239218f, 0.893955f, 
		0.379112f, 0.901431f, 0.209035f, 0.379243f, 0.133278f, 0.915648f, 
		0.379378f, 0.691408f, 0.614839f, 0.379565f, 0.359423f, 0.852494f, 
		0.379940f, 0.606574f, 0.698365f, 0.380042f, 0.426398f, 0.820825f, 
		0.380046f, 0.886448f, -0.264149f, 0.380154f, -0.545399f, 0.747009f, 
		0.381038f, -0.236599f, 0.893774f, 0.381264f, -0.234449f, 0.894244f, 
		0.381666f, -0.391211f, 0.837428f, 0.381808f, 0.122957f, -0.916026f, 
		0.381815f, -0.0280275f, 0.923814f, 0.382029f, 0.682207f, -0.623416f, 
		0.382037f, -0.176612f, 0.907114f, 0.382146f, -0.451192f, -0.806468f, 
		0.382408f, 0.233775f, -0.893931f, 0.382456f, -0.923742f, -0.0207019f, 
		0.382682f, -0.870441f, 0.309656f, 0.382848f, 0.396251f, 0.834513f, 
		0.383116f, 0.632723f, -0.672966f, 0.383207f, 0.279426f, -0.880383f, 
		0.383323f, 0.279378f, -0.880347f, 0.383567f, 0.719691f, -0.578725f, 
		0.383675f, -0.790649f, -0.477145f, 0.383679f, -0.790670f, -0.477108f, 
		0.383834f, -0.0948768f, -0.918515f, 0.383865f, -0.789844f, -0.478325f, 
		0.384431f, 0.660152f, -0.645300f, 0.384509f, 0.515152f, -0.766010f, 
		0.384526f, -0.709453f, -0.590606f, 0.384603f, -0.659691f, 0.645669f, 
		0.384808f, 0.731615f, 0.562727f, 0.385696f, -0.813820f, -0.434668f, 
		0.385814f, 0.704554f, 0.595609f, 0.385992f, 0.167594f, -0.907151f, 
		0.386171f, 0.109506f, -0.915904f, 0.386613f, 0.730709f, -0.562668f, 
		0.386790f, 0.338676f, 0.857725f, 0.387126f, 0.911865f, -0.136512f, 
		0.387154f, 0.611905f, 0.689699f, 0.387233f, 0.873496f, -0.295051f, 
		0.387294f, -0.0164189f, 0.921810f, 0.387335f, 0.577475f, -0.718675f, 
		0.387495f, 0.506220f, 0.770447f, 0.387866f, 0.405087f, 0.827928f, 
		0.388484f, 0.349018f, -0.852799f, 0.389265f, 0.0644199f, 0.918871f, 
		0.389418f, 0.388023f, -0.835339f, 0.389501f, 0.350904f, -0.851560f, 
		0.389987f, 0.560055f, -0.730923f, 0.390071f, -0.0899110f, 0.916385f, 
		0.390299f, 0.246874f, 0.886972f, 0.390991f, -0.474474f, 0.788670f, 
		0.391112f, 0.289308f, 0.873689f, 0.391239f, -0.212014f, 0.895535f, 
		0.391368f, -0.918929f, 0.0489947f, 0.391374f, -0.0969054f, 0.915115f, 
		0.391664f, 0.475862f, -0.787499f, 0.392050f, -0.915061f, -0.0946595f, 
		0.393937f, -0.906138f, 0.154039f, 0.393960f, 0.496961f, 0.773192f, 
		0.393989f, -0.493906f, -0.775132f, 0.393990f, 0.275519f, -0.876847f, 
		0.394475f, -0.918864f, -0.00887995f, 0.394946f, 0.492356f, 0.775631f, 
		0.394947f, -0.691493f, -0.604858f, 0.395154f, 0.835207f, 0.382468f, 
		0.395239f, 0.645168f, 0.653869f, 0.395364f, 0.471362f, -0.788356f, 
		0.395928f, -0.905955f, -0.149958f, 0.395961f, 0.666110f, 0.632070f, 
		0.396063f, -0.547676f, 0.737011f, 0.396259f, 0.206215f, 0.894681f, 
		0.396286f, -0.0347917f, 0.917468f, 0.397163f, -0.206063f, 0.894315f, 
		0.397768f, 0.792218f, -0.462786f, 0.397997f, 0.475125f, 0.784764f, 
		0.398231f, 0.728185f, -0.557816f, 0.399385f, 0.385216f, -0.831925f, 
		0.399412f, -0.411880f, 0.819039f, 0.399906f, 0.567520f, -0.719720f, 
		0.400012f, -0.869567f, -0.289559f, 0.400697f, 0.797450f, 0.451127f, 
		0.401130f, -0.513336f, 0.758670f, 0.401415f, -0.888645f, 0.221756f, 
		0.401477f, 0.737065f, 0.543647f, 0.401570f, 0.467193f, 0.787701f, 
		0.402418f, 0.498618f, 0.767750f, 0.402554f, -0.656984f, 0.637434f, 
		0.402683f, -0.854421f, -0.328345f, 0.403558f, 0.784051f, 0.471599f, 
		0.403750f, -0.0789137f, -0.911460f, 0.404053f, 0.741688f, -0.535387f, 
		0.404888f, -0.902520f, -0.146707f, 0.405020f, -0.765785f, -0.499532f, 
		0.405043f, -0.900656f, 0.157347f, 0.405156f, 0.575932f, 0.710037f, 
		0.405361f, 0.324609f, -0.854583f, 0.405473f, -0.442980f, 0.799600f, 
		0.405880f, -0.140293f, -0.903094f, 0.406357f, 0.611675f, -0.678769f, 
		0.406726f, -0.889423f, -0.208568f, 0.407472f, -0.220352f, 0.886235f, 
		0.407594f, 0.821551f, 0.398650f, 0.407725f, -0.889266f, -0.207283f, 
		0.407764f, 0.426626f, -0.807291f, 0.407895f, -0.888512f, -0.210162f, 
		0.408052f, 0.159657f, 0.898890f, 0.408575f, 0.149812f, -0.900346f, 
		0.408753f, 0.838133f, 0.361183f, 0.409009f, 0.520537f, 0.749502f, 
		0.409136f, -0.907312f, 0.0969138f, 0.409256f, -0.352619f, -0.841528f, 
		0.409330f, 0.636063f, 0.654119f, 0.409333f, 0.758610f, 0.506909f, 
		0.409351f, 0.780473f, -0.472541f, 0.409368f, 0.876718f, -0.252554f, 
		0.409530f, 0.600469f, -0.686820f, 0.409549f, 0.660487f, -0.629306f, 
		0.409813f, 0.217540f, 0.885850f, 0.409840f, 0.837971f, 0.360328f, 
		0.409905f, 0.905675f, 0.108312f, 0.410049f, -0.854403f, -0.319147f, 
		0.410229f, -0.439452f, -0.799121f, 0.410291f, 0.162386f, -0.897381f, 
		0.410468f, 0.829690f, 0.378325f, 0.410813f, 0.783415f, 0.466363f, 
		0.410829f, 0.562744f, 0.717314f, 0.410892f, -0.794492f, -0.447159f, 
		0.411645f, 0.307627f, -0.857855f, 0.412009f, 0.821197f, -0.394822f, 
		0.412435f, 0.599316f, -0.686089f, 0.412610f, 0.672653f, -0.614240f, 
		0.412755f, 0.528935f, -0.741526f, 0.412911f, 0.484563f, -0.771170f, 
		0.413473f, 0.336682f, 0.845982f, 0.413527f, 0.672864f, -0.613392f, 
		0.414091f, 0.795784f, -0.441877f, 0.414566f, 0.863416f, 0.287485f, 
		0.414818f, 0.688263f, 0.595164f, 0.415068f, -0.909788f, -0.00227179f, 
		0.415210f, 0.785681f, 0.458591f, 0.415308f, 0.590077f, 0.692335f, 
		0.415797f, 0.733557f, 0.537593f, 0.415930f, 0.586515f, 0.694984f, 
		0.416070f, 0.602430f, 0.681150f, 0.416347f, 0.372848f, 0.829240f, 
		0.416409f, 0.168988f, 0.893334f, 0.416542f, 0.298038f, 0.858875f, 
		0.416627f, -0.740786f, 0.526933f, 0.416699f, 0.337281f, 0.844158f, 
		0.416822f, -0.613393f, -0.670827f, 0.418313f, 0.551710f, -0.721547f, 
		0.418399f, 0.640431f, 0.644042f, 0.418428f, -0.610619f, -0.672356f, 
		0.418628f, 0.177752f, -0.890593f, 0.418738f, 0.126773f, 0.899215f, 
		0.418804f, 0.824018f, 0.381572f, 0.418831f, 0.603724f, -0.678305f, 
		0.418973f, 0.0254257f, 0.907642f, 0.419125f, -0.833357f, 0.360347f, 
		0.419351f, -0.336199f, 0.843276f, 0.420110f, -0.800109f, -0.428174f, 
		0.420282f, -0.307691f, -0.853633f, 0.420570f, 0.650794f, -0.632130f, 
		0.420635f, 0.400675f, -0.813957f, 0.421355f, -0.0557996f, -0.905178f, 
		0.421542f, -0.331796f, 0.843927f, 0.421672f, 0.568191f, 0.706649f, 
		0.421917f, -0.887047f, 0.187440f, 0.422053f, 0.888848f, 0.178382f, 
		0.422407f, -0.132105f, -0.896728f, 0.422552f, 0.679046f, 0.600288f, 
		0.422717f, -0.905784f, 0.0294251f, 0.422787f, -0.890941f, -0.165756f, 
		0.422788f, -0.512050f, 0.747700f, 0.423003f, -0.131800f, -0.896492f, 
		0.423824f, -0.249116f, -0.870812f, 0.423973f, -0.0719634f, 0.902811f, 
		0.424436f, 0.0587096f, 0.903553f, 0.424469f, -0.835533f, -0.348871f, 
		0.424505f, 0.233966f, 0.874675f, 0.425493f, 0.0476313f, 0.903707f, 
		0.425538f, -0.895231f, 0.132209f, 0.425584f, 0.901797f, -0.0751062f, 
		0.425656f, 0.679730f, 0.597314f, 0.425811f, 0.165633f, 0.889523f, 
		0.426070f, -0.903350f, 0.0492171f, 0.426248f, 0.333196f, -0.841007f, 
		0.426498f, 0.682291f, 0.593783f, 0.426630f, 0.140407f, -0.893461f, 
		0.427595f, -0.434960f, -0.792447f, 0.427995f, 0.901678f, 0.0616144f, 
		0.428029f, 0.0405263f, 0.902856f, 0.428189f, 0.417634f, 0.801396f, 
		0.428718f, 0.525186f, -0.735106f, 0.428743f, 0.376261f, -0.821345f, 
		0.428792f, 0.585344f, 0.688121f, 0.428838f, 0.590623f, 0.683566f, 
		0.430763f, 0.184311f, -0.883444f, 0.430820f, 0.488720f, -0.758648f, 
		0.430888f, 0.184296f, -0.883386f, 0.431154f, 0.564867f, -0.703585f, 
		0.431250f, 0.665464f, -0.609246f, 0.432233f, 0.334241f, 0.837531f, 
		0.432337f, -0.885050f, 0.172544f, 0.432381f, 0.795033f, 0.425405f, 
		0.432636f, 0.753460f, -0.495100f, 0.432659f, -0.900951f, -0.0330684f, 
		0.432707f, 0.778092f, -0.455343f, 0.433031f, -0.428803f, -0.792850f, 
		0.433188f, 0.404987f, -0.805191f, 0.433305f, 0.187891f, -0.881444f, 
		0.433567f, -0.889667f, -0.143221f, 0.433922f, 0.728514f, -0.530075f, 
		0.433922f, 0.768363f, 0.470457f, 0.434154f, 0.615232f, -0.658027f, 
		0.434284f, 0.525140f, -0.731864f, 0.434839f, 0.488511f, 0.756487f, 
		0.435230f, -0.128605f, -0.891087f, 0.435305f, 0.206825f, -0.876204f, 
		0.435596f, -0.273157f, -0.857695f, 0.435882f, 0.771854f, -0.462870f, 
		0.436338f, 0.878981f, 0.192359f, 0.436485f, 0.363672f, -0.822936f, 
		0.436493f, 0.805010f, 0.401787f, 0.436642f, 0.844600f, 0.309831f, 
		0.436722f, 0.266414f, 0.859242f, 0.436813f, 0.584649f, 0.683652f, 
		0.436923f, 0.816592f, -0.377194f, 0.437268f, 0.584251f, -0.683701f, 
		0.437617f, 0.885573f, 0.155729f, 0.437820f, 0.827981f, 0.350373f, 
		0.438052f, -0.295363f, 0.849041f, 0.438162f, -0.0852815f, -0.894841f, 
		0.438622f, 0.662607f, -0.607093f, 0.438981f, 0.664005f, -0.605304f, 
		0.439050f, 0.509382f, -0.740111f, 0.440234f, -0.897361f, -0.0306163f, 
		0.440387f, 0.845808f, 0.301111f, 0.440402f, -0.540682f, -0.716735f, 
		0.440687f, -0.894345f, 0.0770818f, 0.441742f, 0.329349f, -0.834502f, 
		0.441809f, 0.754440f, -0.485413f, 0.441862f, -0.172621f, -0.880318f, 
		0.441941f, 0.627118f, 0.641414f, 0.442082f, 0.144515f, 0.885257f, 
		0.442127f, 0.240280f, -0.864170f, 0.442240f, -0.727072f, 0.525157f, 
		0.442314f, 0.795534f, 0.414106f, 0.442729f, -0.752781f, 0.487147f, 
		0.443022f, -0.527288f, -0.725051f, 0.443872f, -0.453443f, -0.772895f, 
		0.444090f, -0.541387f, -0.713922f, 0.444122f, 0.791090f, 0.420632f, 
		0.444314f, -0.170528f, 0.879492f, 0.444777f, -0.529913f, -0.722057f, 
		0.444863f, -0.895583f, 0.00527142f, 0.445130f, 0.391041f, -0.805572f, 
		0.445163f, -0.309194f, -0.840375f, 0.445350f, 0.895055f, 0.0232353f, 
		0.445694f, 0.549950f, -0.706337f, 0.445833f, 0.415033f, -0.793083f, 
		0.445878f, -0.768589f, -0.458763f, 0.446094f, -0.436361f, -0.781402f, 
		0.446806f, 0.748638f, 0.489802f, 0.447254f, 0.844449f, 0.294735f, 
		0.447269f, 0.844447f, 0.294719f, 0.447751f, 0.650248f, 0.613756f, 
		0.447757f, 0.644633f, -0.619647f, 0.448062f, -0.892879f, -0.0448050f, 
		0.448196f, 0.795763f, 0.407286f, 0.448272f, -0.782438f, 0.432253f, 
		0.448355f, -0.463495f, -0.764297f, 0.448368f, -0.509479f, 0.734437f, 
		0.448556f, 0.445048f, 0.775067f, 0.448690f, -0.621645f, -0.642055f, 
		0.449544f, 0.0158772f, -0.893117f, 0.449612f, 0.633503f, -0.629701f, 
		0.449856f, 0.496773f, -0.742190f, 0.450438f, 0.892162f, -0.0339522f, 
		0.450647f, 0.682031f, -0.575978f, 0.451034f, 0.613691f, -0.648036f, 
		0.451081f, -0.882241f, -0.134822f, 0.451512f, -0.887842f, 0.0887326f, 
		0.451658f, -0.743064f, -0.493823f, 0.451926f, 0.864783f, 0.218890f, 
		0.451945f, 0.528762f, -0.718440f, 0.452113f, 0.0155886f, -0.891825f, 
		0.452238f, -0.342896f, 0.823349f, 0.453008f, 0.832576f, 0.318750f, 
		0.453136f, -0.519995f, -0.724067f, 0.453157f, -0.519548f, -0.724375f, 
		0.453400f, 0.551961f, -0.699833f, 0.453466f, 0.0750213f, 0.888110f, 
		0.453566f, 0.257592f, 0.853185f, 0.453729f, -0.543826f, -0.705962f, 
		0.453956f, 0.742004f, -0.493308f, 0.454380f, 0.717715f, 0.527659f, 
		0.454604f, 0.561186f, 0.691668f, 0.454797f, 0.519078f, -0.723683f, 
		0.455216f, -0.382700f, -0.803939f, 0.455313f, -0.888649f, 0.0547082f, 
		0.455486f, -0.788385f, -0.413498f, 0.455557f, 0.501418f, -0.735559f, 
		0.455988f, -0.673170f, -0.582166f, 0.456312f, 0.847459f, -0.271279f, 
		0.456699f, 0.502534f, -0.734088f, 0.456859f, -0.857740f, -0.235715f, 
		0.456981f, -0.534953f, -0.710629f, 0.457244f, -0.803190f, 0.381856f, 
		0.457267f, -0.803155f, 0.381901f, 0.457811f, 0.537157f, 0.708429f, 
		0.457900f, 0.563707f, -0.687431f, 0.458623f, -0.704872f, 0.541130f, 
		0.458842f, -0.333749f, 0.823453f, 0.458975f, 0.361526f, -0.811567f, 
		0.459305f, 0.0804080f, 0.884632f, 0.459766f, 0.363063f, -0.810432f, 
		0.459852f, 0.697586f, -0.549463f, 0.460561f, 0.0436843f, -0.886552f, 
		0.460629f, -0.871428f, 0.168625f, 0.460674f, 0.852736f, 0.246211f, 
		0.460685f, 0.243688f, 0.853455f, 0.461013f, 0.687479f, -0.561105f, 
		0.461134f, 0.184202f, -0.868001f, 0.461801f, 0.846875f, 0.263708f, 
		0.462020f, 0.779127f, 0.423672f, 0.462307f, -0.495394f, -0.735430f, 
		0.462465f, 0.0830529f, 0.882739f, 0.462556f, -0.483553f, -0.743114f, 
		0.462724f, 0.323055f, 0.825544f, 0.462755f, -0.367070f, 0.806919f, 
		0.462885f, -0.786098f, -0.409619f, 0.463268f, -0.263019f, -0.846288f, 
		0.463546f, 0.723786f, 0.511136f, 0.464087f, -0.137242f, -0.875093f, 
		0.464290f, 0.647315f, 0.604498f, 0.464359f, -0.336001f, -0.819436f, 
		0.464495f, 0.878370f, -0.112737f, 0.464897f, 0.884737f, 0.0333334f, 
		0.465054f, 0.879111f, -0.104348f, 0.465127f, 0.0723519f, -0.882282f, 
		0.465191f, -0.558694f, 0.686628f, 0.465269f, 0.638182f, 0.613391f, 
		0.466006f, -0.449889f, -0.761865f, 0.466761f, -0.837872f, -0.283027f, 
		0.466814f, 0.615236f, -0.635270f, 0.466855f, -0.828719f, -0.308661f, 
		0.467004f, -0.0316269f, -0.883690f, 0.467049f, 0.645987f, 0.603793f, 
		0.467274f, 0.883028f, 0.0437755f, 0.467481f, 0.568592f, 0.676879f, 
		0.467657f, 0.658703f, -0.589413f, 0.467923f, -0.875529f, -0.120404f, 
		0.467942f, -0.883329f, -0.0275529f, 0.468024f, 0.473125f, 0.746396f, 
		0.468183f, 0.561237f, -0.682508f, 0.469321f, 0.249974f, -0.846907f, 
		0.469647f, -0.836408f, 0.282582f, 0.469816f, 0.882462f, -0.0230902f, 
		0.469990f, -0.516534f, 0.715753f, 0.470118f, 0.381962f, -0.795672f, 
		0.470557f, -0.260318f, -0.843096f, 0.470559f, 0.331419f, 0.817763f, 
		0.470616f, -0.650551f, 0.596075f, 0.470739f, 0.658846f, 0.586794f, 
		0.470765f, -0.103536f, -0.876163f, 0.470858f, 0.443363f, -0.762707f, 
		0.470902f, 0.858956f, 0.201112f, 0.471277f, 0.733279f, -0.490102f, 
		0.471320f, 0.644759f, 0.601783f, 0.471399f, -0.168133f, -0.865745f, 
		0.471462f, 0.442362f, -0.762915f, 0.471487f, -0.521080f, 0.711460f, 
		0.471973f, -0.565103f, 0.676683f, 0.472063f, 0.652855f, -0.592399f, 
		0.472156f, 0.756180f, -0.453058f, 0.472196f, 0.635121f, 0.611272f, 
		0.472200f, 0.400024f, -0.785499f, 0.472380f, -0.881269f, -0.0149067f, 
		0.472740f, 0.881183f, 0.00575010f, 0.472796f, 0.805254f, -0.357814f, 
		0.473352f, -0.381133f, -0.794151f, 0.474055f, -0.387174f, -0.790802f, 
		0.474110f, 0.725179f, 0.499336f, 0.474656f, 0.713019f, -0.516047f, 
		0.474805f, -0.373349f, 0.796976f, 0.474894f, -0.477712f, -0.739099f, 
		0.475038f, 0.594540f, 0.648738f, 0.475136f, 0.0203740f, -0.879676f, 
		0.475162f, 0.720816f, 0.504625f, 0.475530f, 0.845731f, 0.242096f, 
		0.475571f, 0.190040f, 0.858905f, 0.475914f, 0.843554f, 0.248841f, 
		0.476142f, -0.752295f, 0.455346f, 0.476312f, -0.703439f, 0.527542f, 
		0.476435f, -0.794709f, -0.376095f, 0.476835f, -0.237765f, 0.846225f, 
		0.476934f, 0.703990f, -0.526244f, 0.477211f, 0.774746f, -0.414775f, 
		0.477486f, -0.272971f, -0.835161f, 0.478377f, 0.0772914f, -0.874747f, 
		0.478708f, -0.432374f, -0.764128f, 0.479182f, -0.530048f, -0.699596f, 
		0.479306f, -0.764148f, 0.431675f, 0.480137f, 0.648463f, 0.590731f, 
		0.480341f, 0.486886f, -0.729530f, 0.480995f, -0.723616f, 0.494999f, 
		0.481204f, 0.663150f, 0.573302f, 0.481391f, 0.726753f, -0.489992f, 
		0.481393f, 0.521090f, 0.704788f, 0.481719f, 0.274018f, 0.832383f, 
		0.481728f, 0.246141f, 0.841043f, 0.482033f, 0.726466f, -0.489787f, 
		0.482154f, -0.852640f, -0.201329f, 0.482305f, 0.332330f, 0.810517f, 
		0.482523f, -0.110326f, 0.868907f, 0.482663f, -0.875611f, -0.0184912f, 
		0.482730f, 0.359977f, -0.798366f, 0.483022f, 0.418521f, -0.769110f, 
		0.483057f, 0.418519f, -0.769089f, 0.483137f, 0.873068f, -0.0658108f, 
		0.483184f, -0.529040f, 0.697603f, 0.483276f, 0.302275f, 0.821629f, 
		0.483448f, 0.852837f, 0.197351f, 0.483537f, -0.496629f, -0.720799f, 
		0.484419f, 0.743883f, -0.460409f, 0.484482f, -0.864041f, 0.136790f, 
		0.484504f, -0.864022f, 0.136824f, 0.484571f, 0.318908f, -0.814548f, 
		0.484619f, 0.319468f, -0.814300f, 0.484872f, 0.120484f, 0.866246f, 
		0.484879f, 0.274896f, 0.830256f, 0.485105f, 0.778856f, 0.397563f, 
		0.485114f, 0.778878f, 0.397509f, 0.485665f, -0.791572f, 0.370869f, 
		0.485828f, -0.414550f, -0.769493f, 0.485996f, 0.847366f, 0.213959f, 
		0.486140f, 0.820458f, 0.300860f, 0.486220f, 0.604852f, 0.630669f, 
		0.486224f, -0.345084f, 0.802810f, 0.486394f, 0.291466f, 0.823692f, 
		0.486716f, 0.326873f, -0.810100f, 0.487529f, 0.349480f, -0.800112f, 
		0.487918f, 0.768105f, 0.414670f, 0.487958f, 0.768092f, 0.414646f, 
		0.488143f, -0.398666f, -0.776390f, 0.488217f, 0.595216f, -0.638250f, 
		0.488257f, -0.495708f, 0.718247f, 0.488362f, -0.868657f, 0.0832917f, 
		0.488577f, 0.342642f, 0.802427f, 0.488583f, -0.503050f, -0.712901f, 
		0.488941f, 0.184571f, 0.852567f, 0.488971f, 0.839493f, 0.236977f, 
		0.489970f, 0.513037f, 0.704785f, 0.490026f, 0.513024f, 0.704756f, 
		0.490316f, 0.318781f, 0.811153f, 0.490536f, 0.281640f, -0.824653f, 
		0.490599f, 0.672398f, -0.554250f, 0.490603f, 0.395868f, -0.776271f, 
		0.490871f, -0.661714f, -0.566727f, 0.491032f, 0.122858f, -0.862435f, 
		0.491055f, 0.538646f, -0.684635f, 0.491164f, 0.122550f, -0.862403f, 
		0.491220f, -0.855038f, -0.166174f, 0.491416f, 0.767693f, 0.411289f, 
		0.491862f, 0.521674f, -0.697085f, 0.492290f, 0.238230f, 0.837196f, 
		0.492571f, 0.346087f, 0.798497f, 0.492587f, 0.237839f, 0.837132f, 
		0.492895f, 0.820800f, 0.288689f, 0.492901f, 0.435310f, -0.753362f, 
		0.493075f, 0.0283283f, -0.869525f, 0.493469f, 0.663878f, 0.561921f, 
		0.493707f, 0.719852f, -0.487920f, 0.493748f, 0.325665f, -0.806322f, 
		0.493814f, -0.781177f, -0.381983f, 0.493824f, 0.834856f, -0.243215f, 
		0.495215f, 0.137184f, 0.857871f, 0.495277f, -0.240271f, 0.834847f, 
		0.495296f, 0.443864f, 0.746771f, 0.495598f, 0.413499f, -0.763807f, 
		0.496251f, 0.585027f, -0.641465f, 0.497153f, 0.382853f, 0.778628f, 
		0.497325f, 0.531190f, 0.685933f, 0.497793f, 0.786386f, -0.365787f, 
		0.498018f, 0.587364f, -0.637951f, 0.498129f, 0.569750f, 0.653646f, 
		0.498365f, -0.829664f, 0.251575f, 0.498393f, -0.530955f, -0.685340f, 
		0.498545f, 0.597812f, -0.627753f, 0.499000f, 0.762966f, 0.410953f, 
		0.499014f, 0.330015f, -0.801296f, 0.499027f, 0.762960f, 0.410931f, 
		0.499067f, 0.253996f, 0.828503f, 0.499176f, 0.669462f, -0.550130f, 
		0.499240f, -0.457232f, -0.736002f, 0.499263f, 0.772343f, -0.392712f, 
		0.499369f, -0.715558f, 0.488474f, 0.499399f, -0.715567f, 0.488431f, 
		0.499562f, -0.542040f, -0.675744f, 0.500178f, 0.746472f, -0.438865f, 
		0.500330f, -0.822847f, -0.269429f, 0.500727f, 0.735453f, -0.456487f, 
		0.500751f, 0.146123f, 0.853169f, 0.500816f, -0.514226f, -0.696243f, 
		0.501119f, 0.295864f, 0.813231f, 0.501343f, 0.129353f, 0.855525f, 
		0.501346f, -0.865247f, -0.000386013f, 0.501978f, -0.148807f, -0.851983f, 
		0.502874f, 0.0292811f, 0.863864f, 0.503305f, 0.322040f, -0.801857f, 
		0.503378f, 0.806513f, 0.310076f, 0.503804f, -0.678353f, -0.534807f, 
		0.504118f, -0.542994f, -0.671582f, 0.504413f, 0.421561f, 0.753561f, 
		0.504450f, 0.740597f, 0.443899f, 0.504685f, 0.852127f, -0.138469f, 
		0.505225f, -0.743401f, 0.438295f, 0.505863f, -0.318851f, 0.801521f, 
		0.506093f, 0.755220f, -0.416550f, 0.506573f, 0.568101f, -0.648571f, 
		0.506647f, 0.426189f, -0.749448f, 0.506706f, 0.775488f, 0.376653f, 
		0.506763f, 0.643478f, 0.573696f, 0.506811f, -0.495005f, -0.705771f, 
		0.506901f, -0.537579f, -0.673840f, 0.507259f, -0.856004f, 0.0997231f, 
		0.507283f, -0.451258f, -0.734187f, 0.507639f, 0.353569f, -0.785679f, 
		0.507799f, 0.771102f, 0.384112f, 0.507902f, 0.715055f, -0.480346f, 
		0.507965f, -0.508283f, 0.695428f, 0.508129f, 0.860577f, 0.0348217f, 
		0.508357f, -0.556867f, 0.656866f, 0.508418f, -0.779900f, -0.365059f, 
		0.508507f, -0.0886393f, -0.856484f, 0.509882f, 0.637207f, 0.577916f, 
		0.510065f, 0.831663f, 0.219477f, 0.511165f, -0.741462f, 0.434678f, 
		0.511192f, 0.579242f, -0.634950f, 0.511445f, 0.402887f, 0.759016f, 
		0.511671f, -0.315992f, -0.798963f, 0.511757f, 0.637319f, 0.576133f, 
		0.511930f, 0.225090f, -0.829013f, 0.511990f, 0.639984f, 0.572963f, 
		0.512126f, 0.514433f, -0.687812f, 0.512555f, 0.0774617f, -0.855153f, 
		0.512786f, 0.792692f, -0.329683f, 0.513353f, 0.0993293f, -0.852410f, 
		0.513455f, 0.792676f, 0.328677f, 0.513459f, 0.435122f, -0.739614f, 
		0.513554f, 0.856966f, 0.0432651f, 0.513565f, 0.856959f, 0.0432564f, 
		0.513771f, -0.649893f, 0.560071f, 0.514183f, 0.597143f, 0.615659f, 
		0.514727f, 0.0532224f, -0.855701f, 0.514790f, 0.361678f, -0.777290f, 
		0.514835f, 0.439890f, -0.735828f, 0.514898f, -0.377640f, -0.769590f, 
		0.514938f, 0.361689f, -0.777187f, 0.514968f, 0.269397f, 0.813777f, 
		0.515319f, -0.472808f, 0.714772f, 0.515392f, 0.251861f, -0.819107f, 
		0.516019f, -0.283336f, 0.808360f, 0.516229f, 0.215281f, -0.828952f, 
		0.516790f, -0.677005f, 0.524016f, 0.517258f, 0.0268205f, 0.855409f, 
		0.517516f, -0.281371f, 0.808089f, 0.517603f, 0.512074f, 0.685469f, 
		0.517683f, 0.00272793f, -0.855568f, 0.518344f, 0.516320f, -0.681713f, 
		0.518966f, 0.573224f, 0.634104f, 0.519286f, -0.296139f, -0.801651f, 
		0.519539f, -0.848210f, 0.103044f, 0.519569f, -0.324855f, -0.790264f, 
		0.519707f, 0.722344f, -0.456205f, 0.520221f, 0.593669f, 0.613944f, 
		0.520509f, 0.851536f, 0.0628964f, 0.521144f, 0.559858f, 0.644180f, 
		0.521557f, -0.465515f, -0.715034f, 0.522007f, 0.828216f, 0.203877f, 
		0.522278f, 0.473774f, 0.709058f, 0.522627f, -0.502953f, -0.688404f, 
		0.522674f, 0.467889f, -0.712665f, 0.523044f, -0.600507f, 0.604828f, 
		0.523131f, 0.781451f, -0.340100f, 0.523199f, -0.665069f, -0.532865f, 
		0.523703f, 0.324272f, -0.787771f, 0.525023f, 0.0957866f, -0.845681f, 
		0.525090f, -0.314097f, 0.790963f, 0.525137f, 0.206441f, 0.825599f, 
		0.525820f, 0.0161192f, 0.850443f, 0.525885f, -0.763972f, -0.373887f, 
		0.526117f, 0.230709f, -0.818520f, 0.526401f, -0.296570f, 0.796836f, 
		0.526406f, 0.658306f, -0.538080f, 0.526559f, 0.752028f, -0.396472f, 
		0.526603f, 0.312884f, 0.790438f, 0.526629f, -0.525960f, 0.667853f, 
		0.527346f, -0.443283f, 0.724849f, 0.527463f, 0.729812f, -0.434923f, 
		0.527463f, 0.139485f, -0.838049f, 0.527808f, 0.601369f, 0.599811f, 
		0.527903f, 0.361701f, -0.768434f, 0.528577f, -0.0971656f, -0.843306f, 
		0.528631f, 0.0353075f, 0.848117f, 0.528719f, 0.480451f, -0.699731f, 
		0.528763f, 0.363451f, -0.767015f, 0.529106f, 0.310410f, -0.789742f, 
		0.529327f, 0.558789f, 0.638410f, 0.529415f, 0.453136f, -0.717208f, 
		0.529578f, 0.607625f, 0.591894f, 0.529586f, 0.499414f, -0.685656f, 
		0.529858f, -0.807856f, -0.258107f, 0.529991f, -0.774012f, -0.346432f, 
		0.530981f, 0.283862f, 0.798425f, 0.531024f, -0.129261f, -0.837439f, 
		0.531026f, -0.129275f, -0.837436f, 0.531178f, 0.286962f, 0.797184f, 
		0.531749f, 0.700584f, 0.475842f, 0.532123f, 0.718559f, -0.447793f, 
		0.532304f, 0.138524f, -0.835143f, 0.532881f, 0.650237f, 0.541507f, 
		0.532930f, 0.340924f, -0.774440f, 0.533168f, 0.554413f, -0.639028f, 
		0.533675f, 0.845486f, -0.0185687f, 0.534446f, 0.116439f, 0.837143f, 
		0.535048f, 0.403882f, 0.742027f, 0.535141f, 0.807205f, -0.249087f, 
		0.535542f, 0.0364531f, 0.843721f, 0.535622f, 0.747508f, -0.392862f, 
		0.535716f, 0.449902f, -0.714560f, 0.536084f, 0.286329f, -0.794122f, 
		0.536412f, 0.420496f, 0.731741f, 0.536485f, -0.720820f, 0.438865f, 
		0.536652f, 0.302719f, 0.787633f, 0.537431f, 0.360289f, -0.762470f, 
		0.537754f, 0.112738f, -0.835530f, 0.538046f, -0.584027f, 0.607798f, 
		0.538452f, 0.477682f, -0.694182f, 0.538795f, 0.0101491f, 0.842376f, 
		0.538824f, 0.597110f, -0.594246f, 0.539018f, 0.261730f, -0.800598f, 
		0.539059f, -0.840869f, 0.0485239f, 0.539113f, 0.668889f, -0.511805f, 
		0.539406f, -0.830904f, 0.136531f, 0.539506f, 0.833715f, -0.117699f, 
		0.539574f, -0.674467f, 0.503939f, 0.539995f, -0.720888f, -0.434425f, 
		0.540057f, 0.641649f, 0.544633f, 0.540326f, 0.491008f, -0.683344f, 
		0.540339f, 0.511948f, -0.667789f, 0.540568f, 0.129398f, -0.831290f, 
		0.540614f, 0.217497f, -0.812670f, 0.540647f, -0.293420f, -0.788420f, 
		0.540738f, 0.378423f, -0.751265f, 0.540812f, 0.391752f, -0.744347f, 
		0.541066f, -0.817863f, 0.195823f, 0.541138f, -0.233199f, -0.807953f, 
		0.541319f, 0.142274f, 0.828693f, 0.541480f, -0.448295f, -0.711218f, 
		0.541481f, -0.448174f, -0.711293f, 0.541739f, 0.579745f, 0.608617f, 
		0.541824f, 0.838149f, -0.0627114f, 0.541839f, -0.726799f, 0.422106f, 
		0.541938f, -0.813456f, 0.211170f, 0.541988f, 0.500667f, 0.674968f, 
		0.542030f, 0.702242f, -0.461584f, 0.542317f, 0.799901f, -0.257003f, 
		0.542376f, 0.758822f, 0.360578f, 0.542791f, 0.600371f, -0.587310f, 
		0.543512f, -0.372069f, 0.752436f, 0.543639f, -0.329986f, 0.771729f, 
		0.543663f, -0.462838f, 0.700151f, 0.543802f, -0.328557f, -0.772224f, 
		0.543884f, 0.349034f, 0.763129f, 0.543929f, 0.495011f, 0.677573f, 
		0.544110f, 0.607675f, -0.578511f, 0.544232f, -0.829568f, -0.125016f, 
		0.544350f, -0.837822f, 0.0416844f, 0.544383f, 0.730679f, -0.412014f, 
		0.544456f, 0.726390f, -0.419434f, 0.544902f, -0.641838f, -0.539561f, 
		0.544930f, -0.0183280f, -0.838281f, 0.544946f, -0.371957f, 0.751453f, 
		0.545575f, 0.837625f, -0.0270759f, 0.545668f, 0.673568f, -0.498550f, 
		0.545679f, 0.285057f, -0.788021f, 0.545738f, 0.837787f, -0.0167929f, 
		0.545851f, -0.296424f, 0.783696f, 0.546217f, 0.539830f, -0.640492f, 
		0.546224f, 0.465693f, 0.696254f, 0.546410f, 0.712927f, -0.439514f, 
		0.546676f, 0.269884f, 0.792659f, 0.546871f, 0.670706f, -0.501084f, 
		0.546905f, 0.712657f, -0.439334f, 0.547243f, 0.0614859f, 0.834712f, 
		0.547498f, -0.744334f, -0.382379f, 0.547513f, 0.750002f, -0.371116f, 
		0.547806f, -0.255923f, 0.796500f, 0.547863f, 0.646435f, -0.531007f, 
		0.547885f, 0.570167f, -0.612152f, 0.547933f, 0.122657f, -0.827481f, 
		0.548085f, -0.685197f, -0.479695f, 0.548138f, 0.337955f, 0.765069f, 
		0.548184f, 0.729299f, 0.409411f, 0.548619f, -0.682563f, -0.482829f, 
		0.549125f, 0.0855984f, 0.831345f, 0.550268f, -0.0228709f, -0.834675f, 
		0.550754f, 0.278175f, -0.786949f, 0.550822f, 0.804260f, 0.223072f, 
		0.550856f, -0.637981f, -0.538088f, 0.550951f, 0.415709f, 0.723629f, 
		0.551076f, 0.0475052f, 0.833102f, 0.551171f, 0.385888f, -0.739798f, 
		0.551180f, -0.819410f, -0.157376f, 0.551524f, -0.832053f, 0.0592310f, 
		0.552168f, 0.663548f, 0.504791f, 0.552491f, 0.428671f, 0.714839f, 
		0.552908f, 0.832820f, 0.0265029f, 0.553301f, 0.804096f, 0.217458f, 
		0.553412f, 0.457345f, -0.696111f, 0.553414f, 0.139040f, 0.821219f, 
		0.553569f, -0.436347f, -0.709339f, 0.553734f, -0.469759f, 0.687536f, 
		0.553901f, -0.437685f, -0.708255f, 0.553941f, -0.583057f, -0.594302f, 
		0.554242f, 0.536658f, -0.636250f, 0.554311f, 0.316412f, -0.769820f, 
		0.554620f, 0.135379f, -0.821017f, 0.554686f, 0.715726f, 0.424334f, 
		0.554810f, -0.488165f, -0.673706f, 0.554879f, 0.0825878f, 0.827822f, 
		0.554923f, 0.602399f, -0.573738f, 0.554947f, 0.698896f, 0.451196f, 
		0.555203f, 0.830476f, -0.0453720f, 0.555395f, 0.619644f, -0.554597f, 
		0.555499f, -0.773898f, -0.304144f, 0.555605f, -0.196306f, -0.807940f, 
		0.555628f, -0.769839f, 0.314046f, 0.555687f, -0.779110f, 0.290172f, 
		0.555745f, -0.223672f, 0.800699f, 0.555856f, -0.284089f, -0.781228f, 
		0.555940f, -0.284422f, -0.781047f, 0.555981f, -0.778846f, 0.290317f, 
		0.556099f, -0.409859f, 0.723028f, 0.556146f, -0.735617f, -0.386743f, 
		0.556354f, 0.227579f, 0.799173f, 0.556511f, -0.204933f, 0.805169f, 
		0.556549f, -0.814649f, 0.163094f, 0.556623f, 0.715935f, -0.421435f, 
		0.556770f, 0.675619f, 0.483266f, 0.557198f, 0.812479f, 0.171489f, 
		0.557387f, 0.748277f, 0.359725f, 0.557429f, 0.672640f, 0.486649f, 
		0.557621f, 0.720070f, 0.412986f, 0.557643f, 0.602307f, -0.571192f, 
		0.558108f, -0.784230f, -0.271105f, 0.558238f, 0.256886f, -0.788910f, 
		0.558275f, 0.768182f, 0.313409f, 0.558676f, 0.371993f, -0.741284f, 
		0.559504f, -0.387068f, -0.732894f, 0.559533f, 0.355625f, 0.748635f, 
		0.559841f, 0.0735815f, -0.825327f, 0.560158f, 0.322276f, 0.763126f, 
		0.560854f, 0.0763851f, -0.824383f, 0.561077f, 0.826286f, 0.0494337f, 
		0.561560f, 0.229971f, 0.794836f, 0.561779f, -0.650453f, -0.511190f, 
		0.561782f, -0.650374f, -0.511287f, 0.561944f, 0.816426f, 0.132915f, 
		0.562102f, -0.660604f, -0.497638f, 0.562288f, 0.162736f, 0.810771f, 
		0.562616f, 0.520867f, -0.641998f, 0.564079f, 0.201996f, 0.800632f, 
		0.564155f, 0.209239f, 0.798716f, 0.564905f, 0.0299236f, -0.824613f, 
		0.564989f, -0.825070f, -0.00689872f, 0.565328f, -0.296769f, 0.769632f, 
		0.565371f, -0.474240f, -0.674871f, 0.565638f, 0.574583f, -0.591530f, 
		0.565709f, -0.403432f, 0.719177f, 0.565814f, 0.774601f, -0.282576f, 
		0.565979f, -0.794175f, 0.221255f, 0.566017f, 0.791308f, -0.231205f, 
		0.566130f, -0.279293f, -0.775559f, 0.566289f, 0.206156f, 0.798008f, 
		0.566473f, -0.748914f, -0.343855f, 0.566740f, 0.667640f, -0.482765f, 
		0.566915f, -0.414349f, -0.711985f, 0.566985f, -0.606416f, 0.557484f, 
		0.567131f, -0.480534f, -0.668916f, 0.567395f, -0.439338f, 0.696451f, 
		0.567399f, 0.810601f, 0.144859f, 0.567455f, 0.0455044f, 0.822146f, 
		0.567513f, -0.818247f, 0.0916588f, 0.567516f, -0.746788f, -0.346747f, 
		0.567521f, 0.167589f, -0.806122f, 0.567564f, 0.490396f, -0.661349f, 
		0.567818f, -0.309022f, 0.762947f, 0.567884f, 0.598082f, 0.565514f, 
		0.567953f, -0.618381f, -0.543171f, 0.568277f, -0.687717f, 0.451781f, 
		0.569040f, -0.256967f, -0.781128f, 0.569135f, 0.753809f, -0.328416f, 
		0.569149f, 0.655471f, 0.496414f, 0.569160f, -0.552875f, -0.608594f, 
		0.569694f, 0.567605f, -0.594368f, 0.570475f, 0.426426f, -0.701940f, 
		0.570649f, -0.743874f, 0.347867f, 0.570678f, -0.743858f, 0.347853f, 
		0.570902f, 0.787239f, 0.233079f, 0.571019f, -0.331021f, 0.751241f, 
		0.571032f, -0.615190f, -0.543566f, 0.571296f, 0.693988f, -0.438180f, 
		0.571299f, -0.498665f, -0.651882f, 0.571432f, 0.661563f, -0.485593f, 
		0.571586f, 0.744291f, 0.345428f, 0.571638f, 0.207717f, 0.793778f, 
		0.571762f, 0.495635f, -0.653784f, 0.572106f, -0.367381f, 0.733298f, 
		0.572110f, 0.530220f, 0.625746f, 0.572579f, 0.740799f, -0.351242f, 
		0.572685f, 0.206126f, 0.793438f, 0.572914f, -0.739954f, 0.352473f, 
		0.573293f, 0.315408f, -0.756210f, 0.573781f, -0.448841f, -0.685067f, 
		0.573782f, 0.724981f, 0.381021f, 0.573981f, 0.571302f, 0.586651f, 
		0.574477f, -0.516863f, -0.634688f, 0.574524f, -0.784067f, 0.234862f, 
		0.574675f, 0.668933f, 0.471462f, 0.574740f, 0.810359f, -0.113987f, 
		0.574898f, 0.798141f, -0.180176f, 0.574993f, -0.516858f, -0.634224f, 
		0.575181f, 0.616584f, 0.537579f, 0.575202f, 0.632557f, -0.518665f, 
		0.575674f, 0.440906f, -0.688623f, 0.575743f, -0.523651f, -0.627941f, 
		0.576009f, -0.369332f, 0.729252f, 0.576081f, 0.119814f, -0.808564f, 
		0.576500f, 0.362395f, 0.732337f, 0.576811f, 0.658619f, -0.483229f, 
		0.577055f, 0.788117f, 0.214195f, 0.577255f, -0.798062f, -0.172838f, 
		0.577495f, -0.231491f, -0.782886f, 0.577549f, 0.809458f, -0.105902f, 
		0.577863f, 0.378232f, 0.723198f, 0.578106f, 0.507666f, 0.638802f, 
		0.578440f, 0.405596f, 0.707742f, 0.578467f, -0.812137f, -0.0762177f, 
		0.578672f, -0.438881f, -0.687403f, 0.578903f, -0.541762f, -0.609397f, 
		0.578940f, 0.270786f, -0.769093f, 0.579308f, 0.811313f, -0.0785654f, 
		0.579538f, -0.813875f, -0.0417472f, 0.579576f, -0.382513f, 0.719566f, 
		0.579694f, 0.643586f, -0.499752f, 0.579910f, 0.430152f, 0.691862f, 
		0.580215f, -0.539885f, -0.609815f, 0.581353f, 0.549102f, -0.600429f, 
		0.581468f, -0.212584f, 0.785304f, 0.581949f, 0.645583f, 0.494528f, 
		0.582005f, 0.573710f, -0.576305f, 0.582076f, 0.772042f, -0.255222f, 
		0.582103f, -0.310312f, -0.751573f, 0.582105f, -0.310279f, -0.751586f, 
		0.582166f, -0.0985823f, 0.807071f, 0.582563f, 0.700511f, -0.412195f, 
		0.583038f, 0.513616f, -0.629496f, 0.583339f, 0.299303f, 0.755071f, 
		0.583372f, -0.194127f, 0.788665f, 0.583762f, -0.587001f, -0.560938f, 
		0.583919f, -0.725883f, 0.363499f, 0.584090f, 0.808159f, -0.0756247f, 
		0.584139f, 0.363488f, -0.725712f, 0.584229f, -0.786641f, 0.199681f, 
		0.584266f, 0.744214f, 0.323696f, 0.584326f, -0.695338f, -0.418412f, 
		0.584373f, 0.463280f, -0.666243f, 0.584582f, 0.465799f, -0.664301f, 
		0.584723f, -0.483350f, 0.651515f, 0.585134f, 0.0525845f, 0.809230f, 
		0.585228f, 0.0440448f, -0.809672f, 0.585443f, 0.0253740f, 0.810316f, 
		0.586049f, 0.0516975f, 0.808625f, 0.586371f, 0.280772f, 0.759826f, 
		0.586389f, -0.809836f, -0.0177330f, 0.586666f, 0.609939f, 0.532726f, 
		0.586746f, 0.252596f, 0.769366f, 0.587108f, 0.758519f, 0.282760f, 
		0.587164f, 0.526912f, 0.614494f, 0.587175f, 0.749095f, -0.306729f, 
		0.587403f, -0.481809f, -0.650244f, 0.587705f, 0.140394f, 0.796802f, 
		0.587723f, 0.662224f, 0.464801f, 0.587727f, 0.176457f, 0.789582f, 
		0.587902f, 0.659329f, 0.468675f, 0.588501f, 0.262735f, 0.764615f, 
		0.588580f, 0.390124f, 0.708079f, 0.588626f, 0.138530f, 0.796447f, 
		0.588876f, 0.307321f, 0.747515f, 0.589319f, 0.516138f, 0.621534f, 
		0.589350f, -0.0959870f, -0.802155f, 0.589553f, 0.747407f, 0.306283f, 
		0.589638f, 0.799501f, -0.114566f, 0.589653f, 0.792717f, -0.154629f, 
		0.589869f, 0.505841f, -0.629428f, 0.589892f, -0.766091f, 0.255210f, 
		0.589984f, 0.686119f, -0.425628f, 0.590075f, 0.546053f, 0.594674f, 
		0.590378f, 0.534532f, -0.604756f, 0.590568f, 0.678610f, 0.436713f, 
		0.590721f, 0.557498f, 0.583305f, 0.590759f, 0.557515f, 0.583250f, 
		0.590762f, -0.691150f, -0.416309f, 0.590891f, 0.451442f, 0.668617f, 
		0.591345f, 0.381248f, 0.710606f, 0.591959f, 0.508891f, 0.624991f, 
		0.591992f, -0.486419f, -0.642606f, 0.592247f, 0.140920f, 0.793338f, 
		0.592379f, -0.786042f, -0.176709f, 0.592448f, 0.0443956f, 0.804384f, 
		0.592478f, 0.0441613f, 0.804375f, 0.592690f, 0.355400f, 0.722779f, 
		0.592825f, -0.0635022f, -0.802824f, 0.593385f, -0.784281f, 0.181101f, 
		0.593401f, -0.788679f, 0.160810f, 0.593568f, 0.766584f, 0.245003f, 
		0.593902f, 0.186750f, -0.782563f, 0.594661f, 0.306722f, 0.743169f, 
		0.594727f, 0.664064f, 0.453122f, 0.594853f, 0.762660f, 0.253967f, 
		0.594930f, 0.327751f, -0.733919f, 0.595033f, -0.744779f, 0.302061f, 
		0.595072f, 0.103092f, 0.797033f, 0.595343f, 0.618985f, 0.512274f, 
		0.596024f, 0.188175f, 0.780606f, 0.596312f, 0.582344f, 0.552528f, 
		0.596389f, 0.00528373f, -0.802678f, 0.596481f, 0.523422f, -0.608473f, 
		0.596790f, 0.797527f, 0.0882714f, 0.596850f, 0.677722f, 0.429491f, 
		0.597929f, 0.800701f, -0.0368581f, 0.598237f, -0.741324f, -0.304222f, 
		0.598487f, -0.397469f, -0.695580f, 0.598564f, -0.657585f, 0.457496f, 
		0.598807f, -0.799269f, -0.0509792f, 0.599047f, -0.799053f, -0.0515418f, 
		0.599241f, 0.594748f, 0.535896f, 0.599454f, -0.393941f, 0.696753f, 
		0.599752f, 0.336191f, -0.726136f, 0.599847f, 0.792605f, -0.109369f, 
		0.599916f, 0.193028f, -0.776428f, 0.599928f, 0.590395f, 0.539926f, 
		0.600312f, -0.581296f, -0.549291f, 0.600439f, -0.650393f, 0.465255f, 
		0.600808f, -0.0623209f, -0.796960f, 0.600943f, 0.238802f, 0.762785f, 
		0.601036f, 0.355681f, -0.715714f, 0.601048f, 0.693914f, -0.396515f, 
		0.601104f, 0.348552f, -0.719156f, 0.601290f, 0.775278f, -0.193375f, 
		0.601661f, 0.743997f, 0.290643f, 0.601721f, 0.743964f, 0.290604f, 
		0.601809f, -0.665185f, 0.441989f, 0.602121f, -0.737685f, 0.305404f, 
		0.602335f, 0.700133f, 0.383415f, 0.602767f, 0.334717f, -0.724318f, 
		0.603231f, 0.209953f, -0.769436f, 0.603722f, -0.709323f, 0.363840f, 
		0.604535f, -0.399198f, 0.689332f, 0.604923f, -0.792588f, 0.0766305f, 
		0.605237f, -0.540475f, -0.584445f, 0.605452f, 0.429306f, 0.670167f, 
		0.605466f, 0.429260f, 0.670184f, 0.605631f, 0.381305f, 0.698439f, 
		0.605841f, -0.490018f, 0.626769f, 0.605973f, 0.657520f, 0.447732f, 
		0.606006f, 0.526978f, -0.595862f, 0.606368f, 0.722754f, 0.331579f, 
		0.607310f, 0.268932f, -0.747563f, 0.607353f, -0.418284f, -0.675397f, 
		0.607525f, 0.691521f, -0.390783f, 0.607540f, 0.474017f, -0.637340f, 
		0.607595f, 0.137261f, 0.782296f, 0.607823f, 0.627070f, 0.487170f, 
		0.607960f, 0.265993f, 0.748086f, 0.608551f, -0.160526f, -0.777108f, 
		0.609937f, -0.661852f, -0.435807f, 0.610208f, -0.652462f, 0.449376f, 
		0.610870f, -0.245577f, -0.752682f, 0.611978f, 0.391392f, -0.687237f, 
		0.612556f, -0.0309675f, -0.789820f, 0.612589f, -0.0309714f, -0.789795f, 
		0.612683f, 0.330597f, -0.717861f, 0.612709f, -0.290083f, 0.735146f, 
		0.612827f, -0.386863f, -0.689043f, 0.612982f, 0.699553f, 0.367259f, 
		0.613096f, 0.213852f, -0.760513f, 0.613159f, 0.459220f, 0.642770f, 
		0.613344f, -0.774960f, 0.152468f, 0.613354f, 0.517345f, -0.596784f, 
		0.613407f, -0.274043f, -0.740697f, 0.614013f, 0.768145f, 0.181495f, 
		0.614059f, 0.157999f, 0.773284f, 0.614317f, 0.709975f, -0.344310f, 
		0.614724f, 0.788550f, 0.0173787f, 0.615043f, -0.784605f, 0.0782194f, 
		0.615145f, -0.788407f, -0.00328226f, 0.615520f, -0.770096f, -0.167591f, 
		0.616183f, 0.747628f, -0.247733f, 0.616273f, -0.0502391f, 0.785928f, 
		0.616440f, 0.493847f, 0.613283f, 0.616563f, 0.235396f, -0.751292f, 
		0.616648f, -0.522452f, -0.588888f, 0.616695f, 0.158516f, 0.771077f, 
		0.616700f, 0.442291f, -0.651199f, 0.616802f, 0.550231f, -0.562850f, 
		0.616926f, -0.434494f, -0.656214f, 0.617359f, 0.764619f, -0.185002f, 
		0.617875f, -0.114195f, -0.777940f, 0.617956f, 0.0854490f, 0.781556f, 
		0.618299f, 0.436297f, -0.653722f, 0.618479f, 0.769547f, 0.159002f, 
		0.618501f, 0.684135f, -0.386542f, 0.619022f, -0.690315f, 0.374535f, 
		0.619209f, 0.669481f, -0.410335f, 0.619282f, -0.405111f, -0.672588f, 
		0.619299f, 0.760889f, -0.193693f, 0.619309f, -0.0451274f, -0.783850f, 
		0.619368f, 0.331411f, -0.711723f, 0.619489f, 0.164511f, -0.767573f, 
		0.619578f, -0.782576f, -0.0608111f, 0.619665f, 0.775496f, -0.120914f, 
		0.619807f, 0.158988f, -0.768480f, 0.620618f, -0.454231f, -0.639145f, 
		0.620711f, -0.0158121f, 0.783880f, 0.621021f, -0.656176f, -0.428680f, 
		0.621187f, 0.318203f, 0.716152f, 0.621216f, 0.318295f, 0.716086f, 
		0.621386f, 0.472016f, -0.625364f, 0.621649f, 0.671039f, -0.404053f, 
		0.621830f, -0.219088f, 0.751883f, 0.621868f, 0.721941f, -0.303449f, 
		0.622483f, 0.734538f, -0.270126f, 0.622770f, 0.441688f, -0.645809f, 
		0.622782f, 0.183688f, 0.760527f, 0.623636f, -0.317514f, 0.714327f, 
		0.623757f, 0.551793f, 0.553580f, 0.623904f, 0.629659f, 0.462897f, 
		0.624056f, -0.382653f, 0.681272f, 0.624096f, 0.660878f, 0.416827f, 
		0.624259f, 0.522291f, 0.580959f, 0.624531f, 0.0273656f, 0.780520f, 
		0.624688f, -0.323354f, -0.710779f, 0.624916f, 0.629240f, 0.462101f, 
		0.625271f, -0.771507f, 0.117530f, 0.625347f, 0.544033f, -0.559437f, 
		0.625460f, 0.534374f, -0.568546f, 0.625565f, 0.777481f, 0.0647452f, 
		0.625568f, 0.323085f, -0.710127f, 0.626126f, -0.305814f, -0.717248f, 
		0.626293f, 0.754881f, -0.194707f, 0.626712f, 0.491174f, 0.604963f, 
		0.626842f, -0.765193f, 0.146797f, 0.626966f, 0.370307f, -0.685409f, 
		0.627331f, -0.507524f, -0.590657f, 0.627383f, 0.106344f, -0.771416f, 
		0.627528f, -0.0171322f, -0.778405f, 0.627870f, -0.505926f, -0.591454f, 
		0.628067f, -0.770546f, 0.108587f, 0.628699f, 0.596756f, 0.498618f, 
		0.628721f, 0.596778f, 0.498564f, 0.628800f, -0.543977f, 0.555607f, 
		0.629142f, 0.0227022f, -0.776959f, 0.629182f, -0.777048f, -0.0180490f, 
		0.629408f, 0.139582f, -0.764436f, 0.629562f, 0.647327f, -0.429673f, 
		0.629906f, 0.139709f, -0.764002f, 0.630153f, -0.638927f, -0.441224f, 
		0.630154f, 0.365508f, 0.685061f, 0.630189f, -0.651332f, 0.422645f, 
		0.630201f, 0.677951f, -0.378456f, 0.630603f, 0.767077f, -0.118039f, 
		0.630812f, 0.555732f, -0.541514f, 0.631481f, 0.213562f, -0.745402f, 
		0.631679f, 0.673503f, -0.383895f, 0.631683f, 0.214206f, -0.745046f, 
		0.632066f, 0.724783f, -0.274196f, 0.632292f, -0.659989f, 0.405737f, 
		0.632776f, 0.717552f, 0.291057f, 0.632794f, 0.717553f, 0.291014f, 
		0.632928f, 0.330432f, -0.700155f, 0.633050f, 0.00862570f, -0.774063f, 
		0.633250f, 0.406678f, 0.658489f, 0.633698f, 0.716681f, 0.291195f, 
		0.633835f, 0.0823139f, -0.769076f, 0.634303f, -0.337865f, 0.695347f, 
		0.634357f, 0.465664f, 0.617048f, 0.634362f, 0.0961855f, -0.767029f, 
		0.634606f, -0.772593f, 0.0193673f, 0.634743f, 0.772654f, 0.0103695f, 
		0.635043f, 0.718111f, -0.284670f, 0.635315f, -0.510314f, -0.579616f, 
		0.635337f, 0.735966f, 0.233884f, 0.635553f, 0.706736f, 0.310801f, 
		0.635769f, 0.631665f, 0.443618f, 0.635774f, -0.350771f, -0.687569f, 
		0.636005f, 0.572963f, 0.516924f, 0.636409f, 0.285087f, 0.716735f, 
		0.636455f, 0.768713f, -0.0632859f, 0.636622f, 0.203291f, -0.743899f, 
		0.636667f, -0.749581f, 0.181063f, 0.637045f, 0.665841f, -0.388368f, 
		0.637056f, -0.490244f, 0.594828f, 0.637286f, 0.658173f, -0.400843f, 
		0.637289f, 0.283749f, 0.716483f, 0.637312f, -0.452273f, 0.623925f, 
		0.637328f, 0.730308f, 0.245893f, 0.637350f, -0.184430f, 0.748178f, 
		0.637511f, -0.756034f, 0.148296f, 0.637595f, 0.298029f, -0.710389f, 
		0.637702f, -0.662694f, 0.392648f, 0.637741f, 0.767857f, 0.0606761f, 
		0.637857f, 0.193095f, 0.745555f, 0.637944f, -0.755614f, 0.148576f, 
		0.638111f, 0.660817f, -0.395140f, 0.638182f, 0.525529f, -0.562621f, 
		0.638500f, 0.654864f, 0.404316f, 0.638995f, 0.418896f, -0.645144f, 
		0.639139f, 0.405598f, -0.653446f, 0.639373f, 0.695034f, 0.328830f, 
		0.639418f, 0.562358f, -0.524308f, 0.639448f, -0.419548f, 0.644272f, 
		0.639767f, 0.561613f, -0.524680f, 0.639802f, 0.642616f, 0.421542f, 
		0.639815f, 0.560283f, -0.526042f, 0.639989f, 0.669472f, -0.377124f, 
		0.640199f, 0.681318f, 0.354895f, 0.640412f, 0.742227f, 0.197412f, 
		0.640519f, 0.669095f, -0.376891f, 0.640608f, -0.550610f, 0.535210f, 
		0.640777f, 0.713354f, -0.283781f, 0.640887f, -0.766213f, 0.0467056f, 
		0.640935f, 0.705305f, 0.302898f, 0.641233f, -0.508054f, 0.575066f, 
		0.641402f, 0.711517f, 0.286961f, 0.641461f, 0.676325f, 0.362094f, 
		0.641702f, 0.589521f, 0.490595f, 0.641986f, 0.557798f, -0.526038f, 
		0.642158f, 0.550495f, -0.533468f, 0.642214f, 0.571389f, -0.510956f, 
		0.642460f, 0.262874f, 0.719822f, 0.642665f, 0.568237f, -0.513896f, 
		0.642671f, 0.555257f, -0.527886f, 0.643630f, 0.765266f, 0.0104260f, 
		0.643652f, -0.704703f, -0.298507f, 0.644199f, -0.318021f, -0.695608f, 
		0.644277f, 0.556873f, -0.524214f, 0.644319f, 0.0312185f, -0.764119f, 
		0.644396f, 0.760586f, 0.0791343f, 0.644409f, 0.692022f, -0.325334f, 
		0.644541f, 0.587998f, -0.488697f, 0.644544f, -0.763597f, -0.0385072f, 
		0.644551f, 0.566707f, 0.513222f, 0.644592f, 0.428694f, -0.633026f, 
		0.645055f, 0.393704f, -0.654906f, 0.645181f, 0.590944f, -0.484279f, 
		0.646251f, 0.181323f, -0.741270f, 0.646317f, 0.426268f, -0.632906f, 
		0.647058f, 0.157076f, -0.746085f, 0.647117f, 0.448512f, -0.616504f, 
		0.647119f, -0.758195f, 0.0798509f, 0.647503f, 0.0159435f, -0.761896f, 
		0.647644f, -0.653541f, 0.391715f, 0.648092f, 0.168792f, -0.742621f, 
		0.648239f, 0.592803f, 0.477881f, 0.648430f, 0.368667f, -0.666050f, 
		0.648786f, 0.744256f, 0.158618f, 0.648788f, 0.676351f, 0.348746f, 
		0.649089f, -0.758525f, 0.0576463f, 0.649685f, 0.393203f, 0.650616f, 
		0.649809f, 0.223963f, -0.726354f, 0.650078f, -0.554906f, -0.519113f, 
		0.650230f, -0.528783f, -0.545517f, 0.650255f, 0.239299f, -0.721044f, 
		0.650875f, 0.00243754f, 0.759181f, 0.652421f, 0.757126f, -0.0332560f, 
		0.652523f, -0.755674f, 0.0563133f, 0.652608f, -0.748285f, 0.119048f, 
		0.652783f, 0.617639f, -0.438630f, 0.652846f, 0.567887f, -0.501295f, 
		0.652858f, -0.743457f, -0.145077f, 0.652890f, -0.441288f, -0.615630f, 
		0.653427f, -0.731307f, 0.195507f, 0.653494f, -0.698041f, 0.292717f, 
		0.653589f, 0.707805f, 0.268019f, 0.653853f, -0.190660f, -0.732205f, 
		0.653977f, 0.243054f, -0.716407f, 0.654637f, -0.306122f, -0.691188f, 
		0.654921f, 0.387399f, -0.648846f, 0.655199f, 0.755128f, 0.0222618f, 
		0.655970f, 0.750421f, 0.0810624f, 0.656209f, 0.431188f, -0.619246f, 
		0.656655f, 0.470476f, 0.589454f, 0.656668f, 0.530225f, 0.536329f, 
		0.656990f, -0.252572f, -0.710332f, 0.657642f, -0.350785f, -0.666676f, 
		0.658515f, 0.357117f, 0.662439f, 0.658542f, 0.357122f, 0.662410f, 
		0.658618f, 0.0584958f, 0.750201f, 0.658816f, 0.155189f, -0.736124f, 
		0.658994f, 0.673108f, 0.335637f, 0.658999f, 0.467574f, -0.589148f, 
		0.659347f, -0.633671f, 0.404627f, 0.659417f, -0.608413f, 0.441591f, 
		0.659509f, 0.429569f, -0.616861f, 0.659676f, 0.720023f, 0.215395f, 
		0.660178f, 0.699006f, 0.274872f, 0.660278f, 0.744491f, -0.0988264f, 
		0.660287f, -0.0505462f, 0.749311f, 0.660681f, 0.613973f, -0.431900f, 
		0.660870f, -0.450667f, 0.600125f, 0.660983f, 0.500838f, -0.558805f, 
		0.661185f, -0.0221889f, 0.749894f, 0.661377f, -0.668019f, -0.341073f, 
		0.661459f, 0.0140131f, -0.749850f, 0.661532f, 0.577236f, -0.478720f, 
		0.661885f, 0.251227f, 0.706253f, 0.661885f, -0.676956f, -0.321930f, 
		0.661915f, 0.587900f, -0.465018f, 0.661961f, 0.634670f, 0.398751f, 
		0.662629f, 0.701715f, -0.261761f, 0.663111f, -0.293589f, -0.688542f, 
		0.663344f, 0.480171f, -0.573943f, 0.663599f, 0.732890f, 0.150027f, 
		0.664110f, 0.647730f, -0.373370f, 0.664110f, -0.124505f, 0.737195f, 
		0.664222f, 0.661885f, -0.347443f, 0.664410f, 0.652067f, -0.365197f, 
		0.664504f, 0.551105f, 0.504696f, 0.664508f, 0.643592f, -0.379760f, 
		0.665444f, 0.691534f, 0.281009f, 0.665506f, 0.286749f, 0.689113f, 
		0.665713f, -0.0738146f, -0.742548f, 0.665887f, 0.368285f, 0.648815f, 
		0.666073f, 0.740220f, -0.0917658f, 0.666920f, 0.739452f, -0.0918117f, 
		0.667406f, 0.681188f, 0.300919f, 0.667961f, 0.394026f, 0.631325f, 
		0.668002f, -0.0307773f, -0.743523f, 0.668016f, 0.494422f, 0.556148f, 
		0.668169f, 0.738871f, -0.0872889f, 0.668352f, 0.705646f, 0.235306f, 
		0.668492f, 0.535239f, -0.516370f, 0.668503f, 0.701838f, 0.246023f, 
		0.668670f, 0.730088f, 0.140896f, 0.668881f, 0.586055f, 0.457315f, 
		0.668974f, -0.0278450f, -0.742764f, 0.669079f, -0.734869f, -0.110908f, 
		0.669218f, -0.554005f, -0.495202f, 0.669401f, 0.705894f, 0.231551f, 
		0.669478f, -0.122493f, 0.732663f, 0.669481f, -0.375464f, 0.640954f, 
		0.670049f, 0.672913f, 0.313405f, 0.670329f, 0.724642f, 0.159855f, 
		0.670426f, -0.718950f, 0.183413f, 0.670446f, -0.737698f, 0.0793934f, 
		0.671293f, 0.0469622f, -0.739703f, 0.671610f, 0.566648f, 0.477335f, 
		0.671620f, -0.221033f, -0.707157f, 0.671915f, 0.288067f, -0.682311f, 
		0.672130f, 0.553009f, 0.492364f, 0.672388f, 0.248944f, 0.697080f, 
		0.672389f, 0.545911f, -0.499874f, 0.672610f, 0.617933f, 0.407131f, 
		0.672628f, 0.389558f, 0.629139f, 0.672712f, 0.721245f, 0.165119f, 
		0.672778f, 0.454168f, -0.584038f, 0.673102f, 0.346588f, 0.653307f, 
		0.673182f, 0.585858f, 0.451217f, 0.673539f, -0.435348f, 0.597342f, 
		0.673584f, -0.609466f, 0.418134f, 0.673617f, -0.214535f, -0.707258f, 
		0.674107f, -0.0107775f, -0.738555f, 0.674132f, 0.143695f, 0.724498f, 
		0.674225f, 0.673720f, 0.302525f, 0.674358f, 0.735149f, 0.0692645f, 
		0.674572f, 0.643596f, -0.361574f, 0.674688f, -0.411710f, -0.612611f, 
		0.674922f, -0.358023f, 0.645213f, 0.674989f, 0.392044f, 0.625053f, 
		0.675013f, 0.689009f, 0.263863f, 0.675042f, 0.538312f, -0.504519f, 
		0.675659f, 0.533246f, -0.509052f, 0.676188f, 0.642998f, 0.359615f, 
		0.676397f, 0.479612f, 0.558980f, 0.676594f, 0.412802f, 0.609766f, 
		0.676669f, 0.726677f, 0.118576f, 0.676799f, 0.650997f, 0.343722f, 
		0.676990f, -0.502863f, 0.537413f, 0.677258f, 0.613079f, -0.406762f, 
		0.677396f, 0.522541f, 0.517769f, 0.677992f, 0.00184609f, 0.735067f, 
		0.678029f, -0.567569f, 0.467057f, 0.678063f, 0.673107f, -0.295224f, 
		0.678321f, 0.150070f, -0.719277f, 0.678407f, 0.108963f, -0.726561f, 
		0.678594f, 0.646512f, 0.348615f, 0.678953f, -0.298360f, -0.670824f, 
		0.678990f, 0.730783f, -0.0702106f, 0.679092f, 0.625208f, -0.384640f, 
		0.679140f, -0.440759f, -0.586942f, 0.679718f, -0.406624f, -0.610443f, 
		0.680403f, 0.107488f, -0.724913f, 0.680658f, 0.727597f, 0.0854841f, 
		0.681364f, -0.715049f, -0.156357f, 0.681627f, -0.655732f, -0.324655f, 
		0.681636f, 0.728159f, 0.0718120f, 0.681721f, -0.717975f, -0.140600f, 
		0.681834f, 0.701565f, 0.207144f, 0.682293f, -0.637429f, -0.357995f, 
		0.682320f, 0.534506f, 0.498741f, 0.682418f, 0.546250f, -0.485713f, 
		0.682434f, 0.326767f, -0.653840f, 0.682510f, 0.726776f, 0.0773081f, 
		0.682541f, 0.718011f, 0.136375f, 0.682874f, 0.244538f, 0.688393f, 
		0.683163f, 0.464688f, 0.563341f, 0.683188f, 0.513220f, 0.519480f, 
		0.683227f, 0.645478f, 0.341407f, 0.683654f, 0.649885f, 0.332064f, 
		0.683908f, 0.646006f, 0.339038f, 0.684131f, 0.158809f, -0.711860f, 
		0.684345f, 0.539379f, 0.490655f, 0.684359f, -0.670656f, -0.286136f, 
		0.685089f, -0.0164319f, 0.728274f, 0.685159f, 0.477879f, -0.549717f, 
		0.685190f, 0.710139f, 0.161919f, 0.685790f, 0.222122f, -0.693075f, 
		0.685950f, 0.726142f, -0.0468049f, 0.685952f, -0.702743f, -0.188737f, 
		0.686566f, -0.380879f, 0.619321f, 0.686642f, -0.483467f, 0.542939f, 
		0.686741f, 0.653830f, 0.317637f, 0.686893f, -0.641415f, -0.341709f, 
		0.687172f, -0.386656f, -0.615055f, 0.687331f, -0.00332851f, 0.726336f, 
		0.687385f, 0.704554f, -0.176370f, 0.687852f, -0.562853f, 0.458319f, 
		0.688136f, 0.392607f, 0.610187f, 0.688464f, 0.388942f, -0.612161f, 
		0.688918f, -0.698444f, 0.193824f, 0.688994f, 0.133103f, 0.712440f, 
		0.689038f, 0.268233f, -0.673259f, 0.689147f, 0.708435f, 0.152304f, 
		0.689193f, 0.615015f, -0.383105f, 0.690038f, -0.0668091f, 0.720683f, 
		0.690639f, -0.722895f, 0.0210152f, 0.691112f, 1.62693e-005f, 0.722747f, 
		0.691397f, 0.390429f, -0.607894f, 0.691462f, -0.0177400f, 0.722195f, 
		0.691508f, 0.547121f, -0.471674f, 0.692000f, 0.545527f, -0.472796f, 
		0.692327f, -0.478819f, 0.539830f, 0.692340f, 0.553830f, -0.462534f, 
		0.692485f, 0.550276f, 0.466541f, 0.692912f, 0.547558f, -0.469098f, 
		0.692984f, 0.700723f, 0.169589f, 0.693245f, 0.545876f, 0.470564f, 
		0.693262f, -0.719161f, 0.0468620f, 0.693478f, -0.210961f, -0.688900f, 
		0.693561f, 0.543899f, -0.472385f, 0.693782f, 0.699524f, 0.171268f, 
		0.693843f, 0.300443f, 0.654459f, 0.694201f, 0.480941f, 0.535519f, 
		0.694395f, 0.719486f, 0.0124838f, 0.694436f, 0.325032f, 0.641960f, 
		0.694637f, -0.562450f, -0.448475f, 0.694640f, 0.440016f, 0.569089f, 
		0.695569f, -0.713726f, -0.0823335f, 0.695601f, -0.338948f, 0.633446f, 
		0.695798f, -0.475049f, 0.538695f, 0.695932f, 0.390674f, -0.602538f, 
		0.695942f, 0.388612f, -0.603859f, 0.696030f, -0.698775f, -0.165092f, 
		0.696789f, 0.376079f, -0.610778f, 0.696868f, 0.710842f, 0.0952791f, 
		0.697182f, 0.597759f, 0.395753f, 0.697466f, 0.689501f, 0.195268f, 
		0.697839f, -0.184604f, -0.692056f, 0.697843f, 0.579592f, 0.420819f, 
		0.697949f, -0.539190f, -0.471318f, 0.698118f, 0.715927f, -0.00898127f, 
		0.698146f, 0.710859f, 0.0852766f, 0.698214f, 0.366283f, 0.615088f, 
		0.698329f, 0.573706f, 0.428016f, 0.698712f, 0.576594f, 0.423487f, 
		0.699305f, -0.702582f, 0.131726f, 0.699524f, 0.288493f, 0.653787f, 
		0.699661f, 0.113405f, -0.705418f, 0.699761f, 0.278033f, 0.658052f, 
		0.699773f, -0.208634f, 0.683220f, 0.699926f, -0.589622f, -0.403051f, 
		0.699970f, -0.703388f, 0.123642f, 0.699972f, -0.624316f, 0.346799f, 
		0.700003f, -0.624303f, 0.346758f, 0.700100f, 0.534765f, -0.473166f, 
		0.700265f, 0.675544f, 0.230802f, 0.700583f, 0.695267f, 0.160586f, 
		0.700820f, 0.235324f, -0.673404f, 0.700916f, 0.0478352f, -0.711638f, 
		0.701351f, 0.486796f, -0.520708f, 0.701661f, 0.663113f, -0.260677f, 
		0.701666f, -0.473837f, 0.532112f, 0.701812f, 0.629711f, -0.333052f, 
		0.702091f, -0.471760f, -0.533396f, 0.702111f, 0.318598f, -0.636816f, 
		0.702116f, 0.685872f, 0.191346f, 0.702229f, 0.689525f, 0.177285f, 
		0.702592f, -0.545717f, -0.456681f, 0.702627f, -0.482719f, 0.522780f, 
		0.702817f, -0.425391f, -0.570167f, 0.702961f, 0.421788f, -0.572662f, 
		0.703051f, 0.0426318f, 0.709861f, 0.703289f, -0.173185f, 0.689486f, 
		0.703444f, -0.544822f, -0.456438f, 0.703505f, 0.365578f, 0.609453f, 
		0.703642f, -0.588523f, 0.398155f, 0.703644f, -0.588567f, 0.398087f, 
		0.703796f, 0.131597f, 0.698107f, 0.703845f, -0.321525f, -0.633422f, 
		0.704112f, 0.384433f, -0.597025f, 0.704288f, -0.617516f, -0.350217f, 
		0.704432f, -0.284715f, -0.650164f, 0.704636f, -0.329615f, -0.628365f, 
		0.704903f, 0.424864f, 0.567981f, 0.705009f, 0.618793f, 0.346493f, 
		0.705039f, -0.705194f, -0.0749786f, 0.705195f, -0.345457f, 0.619161f, 
		0.705309f, -0.594410f, -0.386285f, 0.705416f, 0.647976f, -0.287253f, 
		0.705613f, -0.372084f, 0.603046f, 0.705745f, 0.533614f, 0.466027f, 
		0.705776f, 0.558860f, -0.435380f, 0.705807f, 0.506739f, 0.495027f, 
		0.705972f, 0.601913f, -0.373235f, 0.706644f, 0.380532f, 0.596532f, 
		0.706875f, 0.426176f, 0.564536f, 0.706968f, -0.496384f, -0.503784f, 
		0.707238f, 0.706893f, 0.0108083f, 0.707275f, 0.394079f, -0.586911f, 
		0.707387f, 0.0117214f, -0.706729f, 0.707428f, -0.705730f, -0.0385994f, 
		0.708067f, 0.0877838f, 0.700667f, 0.708089f, 0.0878801f, 0.700633f, 
		0.708165f, 0.224416f, -0.669432f, 0.708232f, 0.683900f, 0.175183f, 
		0.708466f, 0.571055f, 0.414696f, 0.708676f, 0.556800f, 0.433304f, 
		0.708922f, -0.705286f, -0.000735509f, 0.709028f, 0.584851f, 0.393991f, 
		0.709235f, 0.611351f, -0.351050f, 0.709641f, 0.226517f, 0.667158f, 
		0.709655f, 0.611137f, -0.350573f, 0.709709f, 0.476977f, -0.518466f, 
		0.709733f, 0.687613f, 0.153189f, 0.709901f, 0.0647461f, 0.701319f, 
		0.709979f, -0.591765f, -0.381764f, 0.710193f, 0.678508f, -0.187757f, 
		0.710473f, 0.462959f, -0.529997f, 0.710530f, -0.156280f, 0.686093f, 
		0.711016f, 0.665166f, -0.228058f, 0.711130f, 0.622438f, -0.326901f, 
		0.711216f, 0.682500f, -0.168419f, 0.711788f, -0.0368571f, 0.701426f, 
		0.713220f, 0.113656f, -0.691664f, 0.713702f, 0.674745f, 0.188010f, 
		0.713738f, -0.232564f, 0.660676f, 0.713808f, -0.625669f, -0.314669f, 
		0.714323f, 0.651733f, 0.254924f, 0.714509f, 0.565201f, 0.412340f, 
		0.714869f, 0.642366f, -0.276275f, 0.715239f, 0.605450f, 0.349090f, 
		0.715489f, -0.456789f, -0.528601f, 0.715586f, 0.389987f, -0.579522f, 
		0.715690f, 0.389973f, 0.579404f, 0.715772f, -0.435621f, 0.545807f, 
		0.716273f, 0.628821f, -0.302552f, 0.716431f, -0.0229685f, -0.697279f, 
		0.717035f, 0.398509f, -0.571883f, 0.717469f, 0.282767f, 0.636617f, 
		0.717471f, 0.541545f, 0.438137f, 0.717682f, 0.281299f, 0.637027f, 
		0.717819f, -0.448858f, 0.532224f, 0.717971f, 0.695720f, -0.0221587f, 
		0.718066f, 0.533488f, 0.446957f, 0.718166f, 0.587966f, -0.372201f, 
		0.718291f, 0.282418f, -0.635845f, 0.718463f, 0.689983f, 0.0879498f, 
		0.718543f, -0.647185f, -0.254653f, 0.718859f, 0.226078f, 0.657367f, 
		0.719122f, 0.483303f, 0.499282f, 0.719459f, 0.670083f, -0.182670f, 
		0.719484f, 0.170845f, -0.673168f, 0.719609f, 0.669770f, -0.183224f, 
		0.719646f, 0.0204795f, -0.694039f, 0.719889f, 0.0822610f, 0.689198f, 
		0.720397f, 0.194592f, -0.665704f, 0.720571f, 0.0145988f, 0.693228f, 
		0.720619f, -0.446494f, 0.530425f, 0.720680f, -0.476852f, 0.503221f, 
		0.720764f, 0.129265f, 0.681021f, 0.720791f, 0.356929f, 0.594190f, 
		0.720796f, 0.0429354f, -0.691817f, 0.720822f, 0.562847f, 0.404498f, 
		0.720881f, 0.386145f, 0.575519f, 0.720988f, 0.479042f, 0.500695f, 
		0.721158f, -0.117849f, 0.682673f, 0.721171f, -0.118049f, 0.682625f, 
		0.721468f, 0.691079f, 0.0435189f, 0.721491f, 0.690204f, 0.0553982f, 
		0.721555f, 0.291146f, 0.628166f, 0.721972f, -0.430255f, -0.541883f, 
		0.722113f, -0.474518f, 0.503374f, 0.722242f, 0.428864f, -0.542625f, 
		0.722264f, -0.464222f, -0.512671f, 0.722437f, -0.461320f, 0.515042f, 
		0.722660f, 0.270802f, -0.635947f, 0.722680f, -0.393289f, -0.568381f, 
		0.723142f, 0.351104f, -0.594804f, 0.723190f, -0.297144f, 0.623460f, 
		0.723391f, -0.426929f, -0.542621f, 0.723946f, -0.322469f, 0.609849f, 
		0.724024f, 0.468359f, -0.506388f, 0.724159f, 0.468197f, -0.506345f, 
		0.724223f, 0.530210f, -0.440883f, 0.724302f, -0.478526f, 0.496385f, 
		0.724495f, 0.307158f, 0.617058f, 0.724930f, 0.688311f, -0.0265206f, 
		0.725137f, -0.532574f, 0.436510f, 0.725320f, -0.341498f, -0.597738f, 
		0.725978f, -0.430095f, 0.536632f, 0.726153f, 0.647550f, 0.231042f, 
		0.726259f, -0.683647f, -0.0719382f, 0.726684f, -0.462605f, -0.507866f, 
		0.726754f, -0.297088f, 0.619328f, 0.726787f, -0.297206f, 0.619233f, 
		0.726895f, 0.175882f, 0.663844f, 0.726916f, 0.431937f, 0.533877f, 
		0.727005f, 0.0536268f, 0.684535f, 0.727046f, -0.223068f, 0.649342f, 
		0.727182f, -0.647737f, 0.227252f, 0.727429f, 0.618573f, -0.297010f, 
		0.727993f, 0.372563f, 0.575520f, 0.728020f, 0.529995f, -0.434848f, 
		0.728091f, 0.367409f, 0.578701f, 0.728452f, 0.206656f, 0.653186f, 
		0.728490f, -0.673031f, 0.127799f, 0.728962f, -0.521591f, 0.443348f, 
		0.729195f, 0.684223f, -0.0106493f, 0.729482f, -0.450592f, 0.514609f, 
		0.729566f, 0.204577f, 0.652596f, 0.729716f, -0.600969f, 0.326115f, 
		0.729749f, 0.360571f, 0.580909f, 0.729813f, -0.295412f, 0.616526f, 
		0.730221f, 0.652749f, 0.201731f, 0.730233f, 0.276041f, 0.624949f, 
		0.730477f, -0.682832f, -0.0119555f, 0.730582f, 0.110819f, -0.673773f, 
		0.730709f, 0.602758f, -0.320543f, 0.730993f, 0.306601f, -0.609626f, 
		0.731211f, 0.263369f, 0.629259f, 0.731409f, -0.455026f, 0.507930f, 
		0.731595f, 0.538751f, -0.417751f, 0.731666f, 0.414444f, -0.541204f, 
		0.731857f, -0.203863f, 0.650250f, 0.731999f, -0.442742f, -0.517839f, 
		0.732145f, -0.656368f, 0.182056f, 0.732166f, -0.484949f, 0.478285f, 
		0.732186f, 0.622704f, 0.275942f, 0.732450f, 0.265651f, -0.626854f, 
		0.732966f, 0.658457f, 0.170867f, 0.733088f, 0.545113f, -0.406735f, 
		0.733600f, -0.378168f, 0.564641f, 0.733601f, 0.618176f, 0.282291f, 
		0.733834f, 0.167270f, 0.658414f, 0.734191f, -0.673383f, 0.0867120f, 
		0.734460f, -0.658491f, -0.164186f, 0.734642f, -0.632417f, 0.245661f, 
		0.734764f, -0.674818f, -0.0688663f, 0.735019f, 0.195558f, 0.649234f, 
		0.735575f, -0.380013f, -0.560821f, 0.735706f, -0.540027f, 0.408788f, 
		0.735879f, 0.138007f, 0.662900f, 0.736204f, 0.676735f, -0.00571367f, 
		0.736323f, 0.523257f, 0.428988f, 0.736366f, -0.535490f, 0.413540f, 
		0.736785f, -0.238181f, 0.632786f, 0.736842f, -0.341649f, -0.583387f, 
		0.736855f, 0.652819f, 0.175704f, 0.736860f, 0.505049f, 0.449404f, 
		0.737224f, 0.401225f, 0.543617f, 0.737307f, -0.464961f, 0.490091f, 
		0.738108f, 0.670959f, -0.0707818f, 0.738109f, 0.615735f, 0.275799f, 
		0.738591f, 0.122324f, 0.662963f, 0.738813f, -0.430030f, -0.518873f, 
		0.738870f, 0.649843f, -0.178255f, 0.738910f, 0.405523f, -0.538110f, 
		0.739144f, -0.670513f, -0.0638658f, 0.739287f, 0.0325100f, 0.672605f, 
		0.739467f, 0.637179f, -0.217234f, 0.740079f, 0.184852f, -0.646617f, 
		0.740130f, 0.595931f, -0.311567f, 0.740395f, 0.587492f, 0.326601f, 
		0.740508f, 0.633365f, 0.224713f, 0.740559f, 0.424585f, 0.520865f, 
		0.740670f, 0.185093f, -0.645870f, 0.740671f, 0.618903f, 0.261466f, 
		0.740910f, 0.395513f, -0.542791f, 0.741113f, -0.0374347f, 0.670336f, 
		0.741369f, -0.551017f, -0.383083f, 0.741569f, 0.525432f, -0.417129f, 
		0.741575f, 0.146533f, -0.654671f, 0.741643f, 0.485956f, 0.462399f, 
		0.741670f, -0.252493f, 0.621428f, 0.742180f, -0.657165f, 0.131543f, 
		0.742943f, -0.669105f, 0.0182838f, 0.743063f, -0.122565f, 0.657902f, 
		0.743244f, 0.376306f, -0.553156f, 0.743324f, 0.376291f, -0.553060f, 
		0.743502f, 0.331559f, 0.580752f, 0.744605f, -0.667452f, 0.00849949f, 
		0.744699f, -0.252842f, 0.617652f, 0.745053f, 0.576129f, -0.336112f, 
		0.745060f, -0.0900010f, 0.660897f, 0.745061f, -0.392515f, -0.539273f, 
		0.745297f, 0.277567f, -0.606208f, 0.745610f, -0.515156f, -0.422706f, 
		0.745957f, 0.473171f, -0.468676f, 0.745972f, 0.530860f, 0.402136f, 
		0.746254f, 0.660135f, 0.0855936f, 0.746320f, -0.634527f, -0.200952f, 
		0.746449f, 0.248324f, 0.617373f, 0.746637f, -0.0888481f, 0.659272f, 
		0.746705f, -0.271492f, -0.607226f, 0.746768f, -0.662658f, -0.0567682f, 
		0.746885f, -0.0929102f, 0.658431f, 0.747112f, 0.566517f, 0.347681f, 
		0.747334f, 0.525079f, 0.407166f, 0.747862f, -0.535243f, 0.392705f, 
		0.747990f, 0.662896f, 0.0328553f, 0.748036f, 0.404060f, 0.526476f, 
		0.748045f, 0.459067f, 0.479256f, 0.748440f, 0.662408f, 0.0324496f, 
		0.748477f, 0.638112f, 0.180543f, 0.748569f, -0.430095f, 0.504641f, 
		0.749007f, 0.325923f, -0.576856f, 0.749193f, -0.135015f, -0.648445f, 
		0.749209f, 0.376313f, 0.545045f, 0.749407f, 0.220170f, 0.624431f, 
		0.749623f, 0.661810f, -0.00851953f, 0.749744f, 0.490476f, -0.444203f, 
		0.750008f, -0.661417f, -0.00378342f, 0.750386f, 0.136324f, 0.646790f, 
		0.750455f, 0.428075f, -0.503556f, 0.750786f, 0.369676f, -0.547412f, 
		0.750833f, 0.659648f, 0.0333849f, 0.751083f, -0.103098f, -0.652108f, 
		0.751296f, 0.654612f, -0.0838941f, 0.751498f, -0.271787f, 0.601151f, 
		0.751934f, 0.555135f, -0.355557f, 0.752028f, -0.462756f, -0.469373f, 
		0.752078f, 0.0998465f, -0.651467f, 0.752105f, -0.659008f, -0.00680012f, 
		0.752142f, 0.658820f, -0.0154676f, 0.752189f, 0.215903f, -0.622574f, 
		0.752191f, 0.622387f, 0.216431f, 0.752200f, 0.598476f, 0.275721f, 
		0.752232f, 0.527698f, 0.394565f, 0.752408f, 0.420141f, -0.507311f, 
		0.752456f, -0.0498629f, 0.656752f, 0.752479f, 0.594557f, 0.283332f, 
		0.752620f, -0.230665f, 0.616730f, 0.752830f, -0.101350f, -0.650365f, 
		0.752948f, 0.238550f, -0.613321f, 0.753191f, -0.509020f, 0.416655f, 
		0.753221f, -0.416519f, -0.509087f, 0.753315f, 0.357242f, -0.552172f, 
		0.753454f, 0.355522f, 0.553093f, 0.753560f, -0.303189f, -0.583287f, 
		0.753820f, 0.305213f, 0.581894f, 0.753947f, 0.591215f, -0.286407f, 
		0.754084f, -0.544530f, -0.367211f, 0.754333f, -0.228625f, 0.615396f, 
		0.754474f, 0.452310f, 0.475590f, 0.754477f, -0.155261f, 0.637698f, 
		0.754631f, -0.645595f, -0.117217f, 0.754696f, 0.111631f, -0.646508f, 
		0.754928f, 0.378035f, 0.535886f, 0.755400f, 0.346744f, 0.556004f, 
		0.755436f, -0.131845f, 0.641821f, 0.755474f, 0.134751f, 0.641171f, 
		0.755627f, 0.480616f, -0.445013f, 0.756459f, -0.461237f, -0.463713f, 
		0.756482f, -0.0907827f, 0.647684f, 0.756527f, -0.0380920f, 0.652852f, 
		0.757179f, 0.540139f, 0.367328f, 0.757451f, -0.0755936f, -0.648501f, 
		0.757985f, 0.630306f, -0.167851f, 0.758209f, -0.532821f, 0.375794f, 
		0.758580f, 0.435008f, -0.485103f, 0.758740f, 0.561154f, 0.330787f, 
		0.758741f, 0.316444f, 0.569364f, 0.758766f, 0.437315f, -0.482731f, 
		0.758773f, 0.645503f, -0.0871146f, 0.758871f, 0.390232f, 0.521377f, 
		0.758978f, 0.542697f, -0.359768f, 0.759268f, -0.569656f, 0.314650f, 
		0.759329f, 0.0227694f, 0.650309f, 0.759336f, -0.178507f, 0.625735f, 
		0.759338f, 0.444632f, -0.475087f, 0.759370f, -0.477335f, 0.442163f, 
		0.759674f, 0.334520f, -0.557666f, 0.760031f, 0.401158f, -0.511297f, 
		0.760268f, 0.207189f, -0.615682f, 0.760652f, -0.601093f, -0.245144f, 
		0.760740f, 0.454856f, 0.463012f, 0.760854f, 0.452259f, 0.465362f, 
		0.761049f, 0.424735f, 0.490310f, 0.761671f, 0.528587f, -0.374771f, 
		0.761928f, 0.645379f, -0.0543289f, 0.761989f, 0.355277f, -0.541434f, 
		0.761994f, 0.224927f, 0.607267f, 0.762173f, 0.297672f, -0.574877f, 
		0.762491f, 0.218636f, -0.608938f, 0.763161f, -0.0215713f, 0.645848f, 
		0.763421f, 0.539688f, -0.354860f, 0.763919f, 0.269567f, -0.586312f, 
		0.763967f, -0.393538f, -0.511353f, 0.764168f, 0.234156f, -0.601014f, 
		0.764819f, 0.108057f, 0.635119f, 0.764835f, 0.623689f, -0.161364f, 
		0.764863f, -0.0974486f, 0.636780f, 0.764961f, -0.496976f, -0.409694f, 
		0.765077f, 0.617883f, -0.181324f, 0.765091f, 0.496287f, 0.410286f, 
		0.765174f, -0.0689121f, -0.640125f, 0.765555f, 0.637968f, -0.0831967f, 
		0.765606f, 0.579849f, 0.278610f, 0.765634f, 0.438755f, -0.470425f, 
		0.766127f, -0.470540f, -0.437768f, 0.766569f, 0.398554f, -0.503514f, 
		0.766860f, 0.505475f, -0.395502f, 0.766918f, -0.342679f, -0.542593f, 
		0.767018f, 0.351162f, -0.537000f, 0.767395f, -0.415712f, -0.488148f, 
		0.767772f, 0.512936f, 0.383957f, 0.767889f, -0.261159f, 0.584930f, 
		0.768220f, 0.327041f, 0.550347f, 0.768251f, -0.337075f, -0.544215f, 
		0.768498f, -0.365714f, -0.525037f, 0.768599f, 0.451042f, -0.453671f, 
		0.768812f, 0.419538f, -0.482614f, 0.768838f, 0.616756f, 0.168817f, 
		0.768865f, 0.0880857f, 0.633315f, 0.768903f, 0.0881819f, 0.633255f, 
		0.768913f, 0.393691f, -0.503767f, 0.769059f, 0.325573f, 0.550045f, 
		0.769265f, 0.473365f, 0.429136f, 0.769477f, -0.295473f, -0.566217f, 
		0.769666f, 0.190276f, -0.609433f, 0.769677f, 0.361336f, -0.526339f, 
		0.769712f, -0.607463f, -0.196297f, 0.770134f, 0.283955f, -0.571195f, 
		0.770145f, 0.305352f, 0.560033f, 0.770163f, 0.387837f, -0.506391f, 
		0.770484f, 0.156634f, 0.617917f, 0.770762f, 0.440144f, 0.460650f, 
		0.770810f, 0.383753f, 0.508513f, 0.771007f, 0.189925f, -0.607846f, 
		0.771426f, -0.421599f, -0.476610f, 0.771472f, -0.497350f, -0.396831f, 
		0.771483f, -0.570127f, -0.282435f, 0.771565f, 0.434147f, -0.464977f, 
		0.771877f, 0.313772f, 0.552949f, 0.771892f, 0.313763f, 0.552934f, 
		0.772445f, 0.239670f, 0.588122f, 0.772450f, 0.522459f, -0.361050f, 
		0.772579f, 0.524979f, -0.357096f, 0.773302f, 0.422392f, -0.472853f, 
		0.773358f, -0.227745f, -0.591650f, 0.773401f, 0.394226f, 0.496423f, 
		0.773517f, -0.355180f, -0.524899f, 0.773757f, -0.238310f, -0.586948f, 
		0.773841f, 0.630138f, 0.0640084f, 0.773902f, 0.499730f, 0.389031f, 
		0.773915f, -0.355195f, -0.524302f, 0.774168f, -0.627350f, -0.0842363f, 
		0.774313f, -0.539569f, -0.330611f, 0.774328f, 0.204725f, 0.598751f, 
		0.774485f, 0.341401f, -0.532558f, 0.774528f, 0.542460f, -0.325336f, 
		0.774586f, -0.590245f, 0.227217f, 0.775231f, 0.628726f, -0.0609968f, 
		0.775904f, 0.308844f, -0.550080f, 0.776434f, 0.395875f, 0.490340f, 
		0.776627f, 0.351597f, -0.522715f, 0.776689f, -0.429147f, -0.461072f, 
		0.776841f, 0.383748f, 0.499255f, 0.776849f, 0.492201f, 0.392739f, 
		0.777284f, 0.423956f, -0.464856f, 0.777346f, -0.427020f, 0.461939f, 
		0.777363f, 0.613095f, -0.140784f, 0.777613f, -0.471223f, 0.416252f, 
		0.778478f, -0.425208f, 0.461704f, 0.778684f, 0.517978f, -0.354049f, 
		0.778696f, 0.148235f, 0.609638f, 0.778847f, 0.312030f, 0.544091f, 
		0.779106f, -0.314356f, -0.542379f, 0.779248f, 0.613288f, -0.129031f, 
		0.779337f, 0.300826f, 0.549670f, 0.779432f, -0.315009f, -0.541530f, 
		0.779660f, 0.0955030f, 0.618877f, 0.779968f, -0.619950f, -0.0855121f, 
		0.780282f, -0.503151f, -0.371482f, 0.780344f, 0.592911f, -0.198794f, 
		0.780428f, 0.625245f, -0.000114390f, 0.780584f, 0.313874f, 0.540529f, 
		0.780667f, 0.580539f, -0.231373f, 0.781195f, 0.620082f, 0.0723338f, 
		0.781408f, -0.0943049f, 0.616854f, 0.781426f, 0.405285f, 0.474466f, 
		0.781436f, 0.354254f, -0.513676f, 0.781658f, -0.458077f, -0.423292f, 
		0.781682f, -0.425663f, -0.455834f, 0.781682f, 0.409665f, 0.470264f, 
		0.781929f, 0.544302f, -0.303845f, 0.782116f, 0.617355f, 0.0846637f, 
		0.782510f, 0.561325f, 0.269431f, 0.783073f, -0.568030f, -0.253258f, 
		0.783368f, -0.567043f, -0.254553f, 0.783423f, -0.404812f, -0.471567f, 
		0.783765f, 0.451981f, 0.425940f, 0.783777f, 0.392291f, 0.481457f, 
		0.783858f, 0.382978f, 0.488768f, 0.784308f, 0.612596f, -0.0979080f, 
		0.784312f, -0.340033f, 0.518876f, 0.784349f, 0.521943f, -0.335219f, 
		0.784608f, 0.449403f, 0.427115f, 0.784743f, -0.320325f, 0.530632f, 
		0.784854f, 0.292068f, -0.546535f, 0.785078f, -0.521645f, 0.333973f, 
		0.785111f, 0.257973f, -0.563072f, 0.785554f, 0.427850f, 0.447045f, 
		0.785695f, 0.244359f, -0.568306f, 0.785719f, 0.00510371f, 0.618562f, 
		0.785757f, 0.396407f, 0.474813f, 0.785939f, -0.266233f, -0.558051f, 
		0.785976f, 0.406143f, -0.466142f, 0.786008f, 0.487139f, 0.380639f, 
		0.786220f, 0.227183f, -0.574670f, 0.786392f, 0.454203f, 0.418673f, 
		0.786393f, 0.454283f, 0.418584f, 0.786524f, -0.112662f, 0.607196f, 
		0.786538f, 0.376945f, 0.489153f, 0.786790f, 0.570965f, 0.234437f, 
		0.787047f, 0.598118f, -0.151039f, 0.787077f, 0.206434f, -0.581287f, 
		0.787100f, -0.613639f, 0.0626067f, 0.787402f, 0.0682131f, -0.612654f, 
		0.787887f, 0.599485f, -0.140896f, 0.788180f, 0.599121f, -0.140809f, 
		0.789290f, -0.248685f, 0.561406f, 0.789534f, -0.243170f, -0.563476f, 
		0.789619f, -0.538137f, 0.294807f, 0.789619f, -0.612025f, 0.0438998f, 
		0.789771f, 0.269014f, -0.551265f, 0.790433f, 0.377593f, -0.482327f, 
		0.790549f, 0.457223f, -0.407405f, 0.790592f, 0.604116f, -0.100042f, 
		0.790954f, -0.398610f, -0.464222f, 0.790990f, 0.235032f, 0.564885f, 
		0.791225f, 0.414831f, 0.449309f, 0.791289f, 0.600985f, 0.112597f, 
		0.791413f, 0.212923f, -0.573001f, 0.791415f, 0.519502f, -0.322150f, 
		0.791711f, 0.359561f, 0.493872f, 0.791716f, -0.467641f, 0.393062f, 
		0.791774f, -0.0660408f, 0.607234f, 0.791833f, 0.568131f, -0.224115f, 
		0.792362f, 0.490240f, -0.363081f, 0.792414f, 0.370398f, -0.484649f, 
		0.792453f, 0.477123f, -0.379963f, 0.792731f, 0.608169f, 0.0413313f, 
		0.792967f, 0.600799f, -0.101209f, 0.792971f, -0.322258f, -0.517056f, 
		0.793684f, -0.538145f, 0.283666f, 0.793844f, -0.445940f, 0.413460f, 
		0.793938f, 0.398033f, -0.459600f, 0.793959f, 0.258225f, 0.550408f, 
		0.794335f, 0.570194f, -0.209546f, 0.794386f, 0.377000f, -0.476258f, 
		0.794583f, 0.265931f, 0.545819f, 0.794629f, 0.514465f, -0.322320f, 
		0.794944f, 0.295726f, 0.529726f, 0.794977f, -0.373463f, 0.478055f, 
		0.795538f, 0.521630f, -0.308254f, 0.795827f, 0.520652f, 0.309161f, 
		0.795841f, -0.206188f, -0.569319f, 0.795932f, -0.544264f, -0.265081f, 
		0.796117f, -0.202291f, 0.570331f, 0.796780f, 0.602881f, 0.0409363f, 
		0.796860f, 0.586467f, -0.145158f, 0.796941f, -0.345535f, 0.495470f, 
		0.796966f, 0.577184f, -0.178058f, 0.797009f, -0.543024f, 0.264390f, 
		0.797060f, 0.597693f, 0.0863657f, 0.797403f, 0.587619f, 0.137304f, 
		0.797437f, 0.302716f, -0.521974f, 0.798202f, 0.403376f, -0.447394f, 
		0.799227f, -0.590180f, -0.113688f, 0.799437f, 0.549413f, -0.242991f, 
		0.799471f, 0.584205f, 0.139824f, 0.799676f, -0.0443473f, 0.598792f, 
		0.799917f, 0.338778f, -0.495340f, 0.800085f, 0.373088f, 0.469755f, 
		0.800166f, 0.308498f, 0.514357f, 0.800309f, 0.570771f, 0.183647f, 
		0.800329f, -0.0438387f, 0.597957f, 0.800671f, -0.138182f, -0.582950f, 
		0.800929f, -0.293941f, 0.521644f, 0.800959f, 0.560105f, -0.211534f, 
		0.801004f, 0.598306f, 0.0205273f, 0.801466f, 0.536399f, -0.264439f, 
		0.801607f, -0.0428911f, 0.596311f, 0.801673f, 0.480951f, 0.354974f, 
		0.801694f, -0.319365f, 0.505265f, 0.801828f, 0.346406f, 0.486904f, 
		0.802056f, 0.417456f, 0.427126f, 0.802497f, -0.512882f, 0.304878f, 
		0.802853f, 0.421465f, 0.421656f, 0.803209f, 0.413765f, -0.428548f, 
		0.803210f, 0.174515f, 0.569560f, 0.803343f, -0.271149f, 0.530206f, 
		0.803402f, 0.514387f, 0.299920f, 0.803404f, -0.528161f, -0.274933f, 
		0.803553f, -0.388468f, 0.450995f, 0.803685f, -0.260164f, -0.535168f, 
		0.803913f, 0.484631f, 0.344756f, 0.803920f, 0.332405f, -0.493173f, 
		0.804125f, 0.550032f, 0.225492f, 0.804142f, 0.338058f, -0.488950f, 
		0.804367f, 0.364643f, 0.469073f, 0.805608f, 0.567581f, -0.169846f, 
		0.805795f, -0.496678f, -0.322498f, 0.805834f, 0.359606f, 0.470441f, 
		0.806088f, 0.359251f, -0.470277f, 0.806204f, 0.308633f, -0.504759f, 
		0.806235f, -0.546744f, 0.225957f, 0.806382f, 0.336943f, 0.486021f, 
		0.806476f, -0.524886f, -0.272197f, 0.806479f, -0.0237000f, 0.590787f, 
		0.806543f, -0.00194526f, -0.591172f, 0.806611f, -0.486852f, 0.335191f, 
		0.807268f, -0.347409f, -0.477102f, 0.807523f, 0.378745f, 0.452171f, 
		0.807648f, -0.0238032f, 0.589184f, 0.807933f, -0.374971f, 0.454579f, 
		0.807999f, 0.339972f, -0.481204f, 0.808023f, 0.576656f, 0.120690f, 
		0.808089f, 0.283748f, 0.516217f, 0.808129f, 0.273849f, -0.521473f, 
		0.808211f, 0.552010f, 0.205135f, 0.808853f, 0.481440f, 0.337599f, 
		0.808907f, 0.341264f, 0.478757f, 0.809187f, -0.586858f, 0.0285234f, 
		0.809276f, -0.0827276f, -0.581574f, 0.809290f, 0.401539f, -0.428737f, 
		0.809546f, -0.259488f, -0.526594f, 0.809546f, 0.281997f, -0.514891f, 
		0.809813f, 0.415628f, -0.414073f, 0.810495f, 0.348891f, 0.470503f, 
		0.810544f, 0.544211f, 0.216456f, 0.810616f, 0.585333f, -0.0169636f, 
		0.811481f, 0.432906f, -0.392546f, 0.811611f, -0.274899f, -0.515479f, 
		0.811866f, 0.427513f, -0.397626f, 0.811968f, 0.573842f, 0.106833f, 
		0.812054f, 0.561801f, 0.157947f, 0.812336f, 0.260562f, 0.521745f, 
		0.812491f, 0.579230f, -0.0659582f, 0.812526f, -0.0439630f, 0.581265f, 
		0.812920f, 0.315940f, 0.489227f, 0.812985f, 0.340301f, 0.472494f, 
		0.813077f, 0.570636f, -0.115240f, 0.813259f, -0.522998f, -0.255115f, 
		0.813306f, -0.262014f, 0.519502f, 0.814049f, -0.170530f, -0.555197f, 
		0.814431f, 0.431091f, 0.388409f, 0.814499f, 0.580157f, -0.00305807f, 
		0.814656f, -0.223218f, 0.535265f, 0.814994f, 0.0749663f, 0.574600f, 
		0.815202f, 0.578509f, 0.0278046f, 0.815391f, -0.407023f, -0.411666f, 
		0.815760f, 0.184640f, -0.548127f, 0.816258f, -0.0723097f, 0.573144f, 
		0.816444f, -0.0506672f, 0.575197f, 0.816486f, 0.541559f, 0.200158f, 
		0.816573f, -0.226011f, 0.531157f, 0.816605f, 0.574422f, 0.0565284f, 
		0.816898f, 0.422693f, 0.392438f, 0.817152f, 0.435992f, 0.377060f, 
		0.817556f, 0.239072f, 0.523877f, 0.817760f, 0.236997f, -0.524501f, 
		0.817769f, -0.517288f, -0.252323f, 0.817897f, 0.439642f, -0.371159f, 
		0.817925f, 0.574088f, -0.0376978f, 0.818003f, 0.439425f, -0.371182f, 
		0.818283f, 0.384372f, 0.427402f, 0.818390f, -0.505194f, -0.273891f, 
		0.818424f, -0.0994313f, 0.565947f, 0.818459f, 0.398972f, -0.413457f, 
		0.818468f, 0.556617f, -0.142433f, 0.818470f, 0.00722909f, 0.574503f, 
		0.818598f, 0.574367f, -0.000617134f, 0.818804f, 0.469195f, 0.330781f, 
		0.818931f, 0.573088f, 0.0303501f, 0.818986f, -0.538448f, -0.198333f, 
		0.819503f, 0.150546f, -0.552947f, 0.819517f, -0.0426768f, 0.571464f, 
		0.819555f, 0.150691f, -0.552830f, 0.819618f, 0.0986901f, 0.564346f, 
		0.819618f, 0.435610f, 0.372115f, 0.819782f, -0.315499f, 0.477931f, 
		0.819845f, -0.552901f, -0.148845f, 0.820158f, -0.314718f, 0.477800f, 
		0.820200f, 0.571618f, 0.0229092f, 0.820304f, -0.556214f, -0.133141f, 
		0.820405f, 0.397667f, -0.410848f, 0.821050f, -0.426296f, -0.379668f, 
		0.821082f, 0.386041f, -0.420472f, 0.821608f, 0.567098f, 0.0579615f, 
		0.821727f, 0.569872f, 0.00333641f, 0.821775f, 0.364155f, -0.438266f, 
		0.821811f, 0.0166227f, 0.569517f, 0.821880f, 0.427449f, 0.376564f, 
		0.821934f, -0.516797f, 0.239469f, 0.822308f, 0.568214f, 0.0306950f, 
		0.822529f, 0.563391f, 0.0776980f, 0.822664f, -0.463549f, -0.329160f, 
		0.823261f, 0.0418327f, -0.566120f, 0.823298f, -0.411538f, -0.390918f, 
		0.823906f, -0.357755f, -0.439533f, 0.823996f, 0.531905f, -0.195210f, 
		0.824078f, 0.537242f, 0.179632f, 0.824405f, -0.436554f, -0.360246f, 
		0.824541f, 0.551252f, 0.127486f, 0.824695f, 0.527863f, -0.203073f, 
		0.825075f, -0.471607f, 0.311188f, 0.825824f, 0.508732f, 0.243324f, 
		0.825863f, 0.218630f, 0.519762f, 0.826419f, 0.408938f, 0.387042f, 
		0.826437f, 0.272460f, -0.492714f, 0.826443f, 0.400338f, -0.395880f, 
		0.826626f, 0.0169703f, 0.562496f, 0.826800f, 0.513366f, -0.229908f, 
		0.827102f, 0.556090f, 0.0816493f, 0.827154f, 0.401502f, 0.393208f, 
		0.827203f, 0.335302f, 0.450897f, 0.827212f, 0.335288f, 0.450891f, 
		0.827261f, 0.364634f, -0.427412f, 0.827326f, 0.453520f, 0.331438f, 
		0.827373f, 0.559441f, -0.0497970f, 0.827565f, 0.365111f, 0.426416f, 
		0.827597f, 0.401982f, 0.391782f, 0.828114f, 0.542036f, -0.142917f, 
		0.828131f, -0.489019f, 0.273970f, 0.828487f, 0.422371f, -0.367712f, 
		0.828527f, -0.0162469f, 0.559713f, 0.829228f, 0.0149732f, -0.558710f, 
		0.829247f, 0.288328f, -0.478765f, 0.829572f, -0.483170f, -0.279922f, 
		0.829903f, 0.555590f, 0.0508044f, 0.830090f, 0.479121f, -0.285295f, 
		0.830585f, 0.240760f, 0.502158f, 0.830634f, -0.516600f, -0.207776f, 
		0.830844f, -0.345197f, 0.436506f, 0.831070f, 0.363822f, 0.420662f, 
		0.831920f, 0.431033f, -0.349456f, 0.831975f, -0.00952089f, -0.554731f, 
		0.832073f, 0.459030f, -0.311362f, 0.832442f, 0.282632f, -0.476613f, 
		0.832474f, 0.230323f, 0.503923f, 0.832752f, 0.131375f, -0.537833f, 
		0.832792f, 0.0734778f, 0.548689f, 0.832945f, 0.445012f, -0.328888f, 
		0.833116f, 0.464319f, 0.300540f, 0.833140f, 0.464235f, 0.300607f, 
		0.833149f, -0.0912510f, 0.545468f, 0.833345f, 0.503264f, -0.228607f, 
		0.834120f, -0.182162f, -0.520635f, 0.834340f, 0.293388f, -0.466691f, 
		0.834436f, 0.550361f, 0.0286175f, 0.834687f, -0.478674f, 0.272341f, 
		0.834863f, -0.414494f, -0.362214f, 0.834870f, -0.414438f, -0.362262f, 
		0.834915f, 0.327774f, 0.442133f, 0.835623f, -0.0464825f, -0.547333f, 
		0.835883f, 0.515914f, 0.187437f, 0.836057f, 0.542471f, 0.0820621f, 
		0.836204f, -0.495180f, 0.235713f, 0.836450f, 0.529865f, -0.139981f, 
		0.836486f, 0.529215f, -0.142207f, 0.836638f, -0.544845f, 0.0564082f, 
		0.836709f, -0.543800f, -0.0647992f, 0.837102f, 0.467314f, -0.284392f, 
		0.837495f, 0.434328f, -0.331604f, 0.837541f, 0.341793f, -0.426265f, 
		0.837594f, 0.341787f, -0.426167f, 0.837635f, 0.0913496f, 0.538538f, 
		0.837667f, 0.275421f, -0.471654f, 0.837682f, 0.0135365f, 0.545991f, 
		0.838056f, 0.104746f, -0.535435f, 0.838130f, 0.104053f, -0.535455f, 
		0.838312f, 0.123783f, 0.530953f, 0.838394f, 0.335105f, -0.429884f, 
		0.838669f, 0.432137f, -0.331499f, 0.838848f, 0.476278f, 0.263617f, 
		0.838933f, 0.331597f, 0.431550f, 0.839100f, 0.444965f, -0.312917f, 
		0.839101f, -0.468648f, -0.276186f, 0.839420f, 0.274662f, 0.468972f, 
		0.839572f, 0.395133f, 0.372812f, 0.840011f, 0.520994f, 0.151479f, 
		0.840039f, -0.451030f, 0.301509f, 0.840454f, 0.214942f, 0.497431f, 
		0.840501f, 0.263070f, -0.473657f, 0.840609f, 0.525140f, 0.132679f, 
		0.840744f, 0.446210f, 0.306670f, 0.840890f, -0.0557975f, 0.538322f, 
		0.840910f, 0.0755899f, 0.535870f, 0.841252f, 0.512973f, 0.170745f, 
		0.841351f, 0.319761f, -0.435754f, 0.841791f, 0.392646f, 0.370429f, 
		0.841907f, 0.0487983f, 0.537412f, 0.841924f, 0.0713148f, 0.534862f, 
		0.842037f, 0.355818f, -0.405422f, 0.842067f, 0.530611f, -0.0968275f, 
		0.842235f, 0.536217f, -0.0557790f, 0.842251f, -0.356499f, 0.404378f, 
		0.842260f, 0.378608f, 0.383736f, 0.842462f, -0.157965f, -0.515077f, 
		0.842800f, -0.486261f, 0.230735f, 0.842853f, -0.537652f, -0.0229820f, 
		0.842984f, 0.506115f, 0.182281f, 0.843073f, 0.437163f, 0.313236f, 
		0.843825f, 0.450082f, -0.292206f, 0.843854f, 0.525436f, 0.108751f, 
		0.843884f, -0.193851f, -0.500281f, 0.843960f, 0.390192f, 0.368078f, 
		0.844017f, 0.532771f, -0.0615679f, 0.844146f, -0.193910f, -0.499817f, 
		0.844432f, 0.233514f, 0.482085f, 0.844826f, 0.505752f, 0.174598f, 
		0.844915f, 0.496211f, 0.199734f, 0.844974f, 0.361626f, 0.394012f, 
		0.844982f, 0.435054f, -0.311019f, 0.844989f, 0.455303f, 0.280524f, 
		0.845849f, -0.0563725f, -0.530435f, 0.845955f, -0.503501f, 0.175631f, 
		0.846105f, 0.230903f, -0.480407f, 0.846184f, -0.339711f, -0.410572f, 
		0.846286f, 0.152828f, 0.510336f, 0.846463f, 0.522421f, 0.102843f, 
		0.846544f, 0.133701f, 0.515254f, 0.846664f, -0.331364f, 0.416364f, 
		0.846960f, 0.140602f, -0.512727f, 0.847191f, -0.0598683f, 0.527905f, 
		0.847211f, 0.338670f, 0.409311f, 0.847322f, -0.363651f, -0.387044f, 
		0.847485f, -0.263251f, -0.460942f, 0.847545f, -0.529825f, -0.0308528f, 
		0.847620f, -0.0262225f, 0.529955f, 0.847637f, -0.0900892f, -0.522872f, 
		0.847901f, -0.529905f, 0.0162434f, 0.848290f, -0.275905f, -0.451974f, 
		0.848558f, 0.376947f, 0.371294f, 0.848574f, -0.504864f, 0.158222f, 
		0.848919f, -0.125890f, 0.513311f, 0.848992f, 0.237261f, -0.472144f, 
		0.849067f, -0.494316f, -0.186376f, 0.849371f, 0.246794f, -0.466543f, 
		0.849376f, -0.452245f, 0.272092f, 0.849390f, -0.507733f, 0.144030f, 
		0.849395f, 0.246821f, -0.466485f, 0.849510f, -0.522587f, 0.0723528f, 
		0.849601f, 0.151608f, -0.505167f, 0.849674f, -0.489884f, -0.195111f, 
		0.850529f, 0.0523318f, -0.523318f, 0.851005f, -0.510125f, -0.124750f, 
		0.851139f, 0.355496f, 0.386244f, 0.851298f, 0.325584f, 0.411445f, 
		0.851539f, 0.350562f, 0.389856f, 0.851608f, 0.514114f, 0.102223f, 
		0.851643f, 0.506774f, 0.133729f, 0.851753f, -0.135886f, 0.506016f, 
		0.851836f, -0.519251f, 0.0689508f, 0.851943f, 0.357829f, -0.382298f, 
		0.852131f, 0.350993f, 0.388171f, 0.852175f, -0.345369f, 0.393087f, 
		0.852485f, -0.426034f, -0.302927f, 0.852578f, -0.153686f, 0.499491f, 
		0.852743f, -0.496990f, 0.160718f, 0.852774f, 0.509783f, -0.113565f, 
		0.852917f, 0.207674f, -0.478961f, 0.852948f, 0.250513f, 0.457956f, 
		0.853015f, 0.490292f, 0.178830f, 0.853173f, 0.00699575f, 0.521582f, 
		0.853377f, 0.427934f, -0.297692f, 0.853402f, 0.356958f, -0.379848f, 
		0.853542f, 0.261364f, -0.450727f, 0.854012f, 0.348953f, -0.385868f, 
		0.854019f, 0.513850f, -0.0813043f, 0.854088f, -0.118172f, -0.506527f, 
		0.854314f, -0.174116f, 0.489726f, 0.854513f, 0.339178f, -0.393402f, 
		0.854545f, 0.395064f, -0.337161f, 0.855184f, 0.171919f, 0.488982f, 
		0.855197f, -0.180927f, -0.485698f, 0.855582f, -0.461746f, -0.234031f, 
		0.855599f, -0.431121f, 0.286506f, 0.855694f, 0.397596f, -0.331219f, 
		0.855706f, 0.426969f, -0.292343f, 0.855837f, -0.134075f, -0.499567f, 
		0.856001f, 0.401122f, 0.326134f, 0.856467f, -0.404091f, -0.321209f, 
		0.856509f, 0.499642f, -0.129424f, 0.856558f, -0.318570f, 0.405983f, 
		0.856857f, -0.217040f, -0.467643f, 0.856956f, -0.512539f, -0.0541281f, 
		0.857247f, 0.267906f, -0.439721f, 0.857709f, 0.107748f, -0.502719f, 
		0.857785f, -0.484148f, 0.172643f, 0.858028f, 0.495219f, -0.136187f, 
		0.858077f, -0.414145f, 0.303624f, 0.858173f, -0.495279f, -0.135045f, 
		0.858252f, 0.512631f, 0.0247657f, 0.858295f, 0.508027f, 0.0723796f, 
		0.858557f, -0.443502f, -0.257268f, 0.858608f, 0.185045f, 0.478070f, 
		0.858974f, 0.0529516f, 0.509273f, 0.859229f, 0.469790f, 0.202538f, 
		0.859662f, -0.424055f, 0.284885f, 0.859881f, 0.502779f, 0.0884236f, 
		0.860392f, 0.178924f, -0.477192f, 0.860408f, 0.395095f, -0.321866f, 
		0.860423f, 0.509429f, 0.0124443f, 0.860546f, -0.322241f, -0.394487f, 
		0.860991f, -0.225836f, -0.455733f, 0.861147f, -0.119662f, 0.494071f, 
		0.861218f, -0.494077f, -0.119125f, 0.861580f, 0.301299f, -0.408533f, 
		0.861665f, 0.367959f, -0.349483f, 0.861682f, -0.330917f, -0.384705f, 
		0.861718f, 0.429562f, -0.270034f, 0.862307f, 0.428538f, -0.269782f, 
		0.862483f, 0.0353895f, -0.504847f, 0.862493f, 0.498801f, 0.0854573f, 
		0.862514f, -0.483591f, -0.149027f, 0.862749f, -0.457770f, -0.214734f, 
		0.862904f, -0.208144f, 0.460514f, 0.862919f, 0.180858f, -0.471870f, 
		0.862999f, 0.106801f, -0.493788f, 0.863117f, 0.492511f, 0.111632f, 
		0.863304f, 0.447179f, 0.233958f, 0.863384f, -0.465686f, -0.194175f, 
		0.863909f, -0.285976f, 0.414583f, 0.864067f, 0.409973f, -0.292079f, 
		0.864095f, 0.280140f, 0.418164f, 0.864131f, -0.364934f, -0.346555f, 
		0.864253f, -0.00561220f, 0.503025f, 0.864776f, 0.326447f, -0.381569f, 
		0.864997f, 0.136426f, 0.482876f, 0.865071f, -0.300725f, -0.401518f, 
		0.865444f, 0.270838f, 0.421490f, 0.865550f, 0.500421f, 0.0200657f, 
		0.865653f, 0.0630551f, -0.496657f, 0.865697f, 0.280312f, -0.414722f, 
		0.866020f, 0.473932f, 0.159367f, 0.866282f, 0.148138f, -0.477085f, 
		0.866367f, 0.206739f, -0.454607f, 0.866521f, 0.208860f, 0.453341f, 
		0.866588f, 0.496448f, -0.0506414f, 0.866800f, 0.0365314f, 0.497317f, 
		0.866844f, 0.262958f, -0.423598f, 0.867281f, 0.215987f, 0.448523f, 
		0.867329f, -0.488591f, -0.0949692f, 0.867520f, 0.339586f, -0.363442f, 
		0.867523f, 0.00853518f, 0.497324f, 0.867777f, 0.0689818f, -0.492143f, 
		0.867779f, 0.0658864f, -0.492563f, 0.867811f, 0.362724f, -0.339611f, 
		0.868191f, -0.0847057f, -0.488948f, 0.868251f, -0.263532f, 0.420346f, 
		0.868258f, -0.492980f, 0.0556593f, 0.868317f, 0.407706f, 0.282491f, 
		0.868417f, 0.277982f, -0.410582f, 0.868433f, -0.488799f, 0.0830657f, 
		0.868560f, 0.323000f, -0.375865f, 0.868981f, -0.443680f, -0.219135f, 
		0.869057f, 0.488777f, 0.0764037f, 0.869248f, 0.492375f, 0.0444302f, 
		0.869325f, 0.419785f, 0.260874f, 0.869434f, 0.0287041f, 0.493215f, 
		0.869545f, 0.400928f, 0.288355f, 0.869599f, -0.441126f, -0.221822f, 
		0.869667f, 0.471744f, 0.145384f, 0.869760f, -0.481214f, 0.109320f, 
		0.869955f, -0.482878f, 0.100031f, 0.870094f, 0.401912f, 0.285311f, 
		0.870128f, 0.0528037f, -0.489989f, 0.870211f, 0.107941f, -0.480709f, 
		0.870769f, 0.227545f, -0.435871f, 0.871028f, 0.146456f, -0.468893f, 
		0.871033f, -0.491164f, -0.00773930f, 0.871119f, 0.489499f, 0.0392809f, 
		0.871123f, 0.476268f, -0.119637f, 0.871227f, 0.487278f, 0.0593595f, 
		0.871252f, -0.488384f, -0.0490109f, 0.871316f, 0.381362f, -0.308822f, 
		0.871321f, 0.262018f, -0.414904f, 0.871761f, 0.0134120f, 0.489748f, 
		0.871877f, -0.467159f, 0.146942f, 0.872618f, -0.218817f, 0.436642f, 
		0.872637f, 0.473929f, -0.117884f, 0.872757f, 0.318034f, 0.370338f, 
		0.872768f, -0.471559f, 0.126129f, 0.873186f, 0.465662f, 0.143896f, 
		0.873999f, -0.359081f, -0.327393f, 0.874057f, 0.274749f, 0.400671f, 
		0.874316f, 0.476849f, 0.0904751f, 0.874540f, 0.262746f, -0.407608f, 
		0.875434f, 0.481519f, 0.0418785f, 0.875841f, 0.457359f, 0.154032f, 
		0.876189f, 0.309486f, -0.369475f, 0.876333f, 0.350127f, -0.330835f, 
		0.876608f, -0.345806f, 0.334630f, 0.876654f, 0.290521f, -0.383505f, 
		0.876694f, -0.216923f, 0.429362f, 0.876716f, -0.342115f, -0.338122f, 
		0.876724f, 0.327577f, 0.352204f, 0.876814f, -0.0322478f, -0.479747f, 
		0.876884f, 0.325745f, -0.353504f, 0.876994f, 0.461647f, 0.133280f, 
		0.877383f, 0.215494f, -0.428674f, 0.877572f, 0.422285f, -0.227028f, 
		0.877581f, 0.316117f, 0.360446f, 0.877674f, 0.361841f, -0.314259f, 
		0.877709f, -0.424372f, 0.222567f, 0.877762f, -0.476194f, -0.0526602f, 
		0.878295f, 0.452522f, 0.154343f, 0.878504f, 0.415226f, -0.236257f, 
		0.878608f, 0.477014f, 0.0224869f, 0.878717f, 0.102925f, 0.466115f, 
		0.878770f, -0.209384f, 0.428861f, 0.878887f, 0.359014f, -0.314111f, 
		0.879143f, -0.187849f, 0.437973f, 0.879188f, -0.183740f, 0.439623f, 
		0.879375f, -0.0129207f, -0.475954f, 0.879427f, 0.308372f, 0.362651f, 
		0.879657f, -0.470226f, -0.0713552f, 0.879694f, 0.281413f, 0.383334f, 
		0.879837f, 0.472935f, 0.0471067f, 0.880172f, 0.469999f, -0.0663261f, 
		0.880310f, -0.0925721f, -0.465280f, 0.880352f, 0.417245f, 0.225584f, 
		0.880428f, -0.293970f, -0.372059f, 0.880495f, 0.148674f, 0.450138f, 
		0.880546f, -0.458316f, -0.120770f, 0.880607f, 0.423179f, 0.213193f, 
		0.880809f, 0.394867f, 0.261259f, 0.881074f, 0.167972f, -0.442147f, 
		0.881332f, 0.446116f, 0.155672f, 0.881511f, -0.0620841f, 0.468064f, 
		0.881970f, 0.452262f, 0.132619f, 0.882004f, -0.180354f, 0.435364f, 
		0.882111f, -0.470251f, -0.0272681f, 0.882442f, -0.206173f, -0.422834f, 
		0.882532f, 0.0204208f, -0.469808f, 0.882567f, 0.351800f, -0.311950f, 
		0.882757f, -0.00877215f, -0.469749f, 0.882812f, 0.195224f, 0.427236f, 
		0.882919f, 0.322126f, -0.341598f, 0.883118f, -0.278715f, -0.377386f, 
		0.883874f, -0.467702f, 0.00462431f, 0.884025f, -0.324920f, 0.336047f, 
		0.884132f, 0.434010f, -0.173047f, 0.884381f, -0.145565f, -0.443487f, 
		0.884556f, 0.321417f, 0.338011f, 0.884623f, -0.177074f, -0.431378f, 
		0.884854f, -0.259160f, -0.387130f, 0.885048f, 0.442030f, 0.145944f, 
		0.885146f, -0.465226f, 0.00907000f, 0.885174f, 0.162678f, -0.435893f, 
		0.885282f, -0.124312f, -0.448131f, 0.885348f, 0.453101f, -0.104199f, 
		0.885380f, 0.402742f, -0.232165f, 0.885389f, -0.223601f, -0.407540f, 
		0.885426f, -0.269181f, -0.378896f, 0.885605f, -0.222233f, 0.407818f, 
		0.886067f, 0.341922f, -0.313010f, 0.886132f, -0.238353f, 0.397440f, 
		0.886586f, 0.0719160f, 0.456940f, 0.886697f, -0.172249f, -0.429067f, 
		0.887346f, 0.301916f, 0.348517f, 0.887384f, 0.417843f, 0.194825f, 
		0.887481f, -0.340560f, -0.310479f, 0.887538f, -0.380495f, 0.259808f, 
		0.887636f, -0.365830f, -0.279767f, 0.887803f, 0.0221743f, 0.459688f, 
		0.887879f, -0.303786f, -0.345520f, 0.887919f, -0.204997f, 0.411796f, 
		0.888232f, 0.282476f, 0.362287f, 0.888238f, 0.0287890f, 0.458482f, 
		0.888242f, -0.307817f, 0.340992f, 0.888874f, 0.228732f, -0.396971f, 
		0.888949f, -0.401415f, 0.220535f, 0.889457f, 0.210010f, -0.405910f, 
		0.889688f, -0.447812f, -0.0889992f, 0.890034f, 0.321547f, -0.323183f, 
		0.890098f, 0.153174f, -0.429260f, 0.890117f, 0.150970f, 0.430000f, 
		0.890129f, 0.414646f, 0.189046f, 0.890711f, -0.207735f, 0.404328f, 
		0.890733f, 0.228657f, -0.392824f, 0.890776f, -0.395248f, -0.224271f, 
		0.890892f, 0.0672528f, -0.449209f, 0.890944f, -0.216729f, 0.399059f, 
		0.891254f, -0.194043f, -0.409895f, 0.891312f, -0.424863f, -0.158285f, 
		0.892151f, 0.399265f, 0.211314f, 0.892251f, 0.277791f, 0.355977f, 
		0.892275f, -0.232405f, 0.387082f, 0.892471f, 0.0305415f, 0.450069f, 
		0.892475f, 0.406663f, 0.195224f, 0.892783f, -0.217336f, 0.394594f, 
		0.892925f, 0.350458f, -0.282603f, 0.893051f, 0.366625f, 0.260855f, 
		0.893123f, 0.199800f, -0.403003f, 0.893280f, -0.293819f, 0.340179f, 
		0.893292f, -0.437130f, -0.104625f, 0.893310f, -0.0322788f, -0.448280f, 
		0.893450f, 0.107139f, -0.436198f, 0.893485f, -0.178700f, 0.412007f, 
		0.893570f, -0.270196f, 0.358507f, 0.893913f, 0.0821416f, -0.440649f, 
		0.893950f, 0.402943f, 0.196191f, 0.894000f, -0.165807f, -0.416259f, 
		0.894040f, 0.316219f, -0.317330f, 0.894055f, -0.377590f, 0.241023f, 
		0.894339f, 0.258955f, -0.364829f, 0.894506f, 0.443557f, 0.0558265f, 
		0.894525f, 0.418113f, -0.158132f, 0.894821f, 0.318433f, -0.312883f, 
		0.894825f, 0.0955066f, -0.436081f, 0.894865f, 0.316889f, 0.314323f, 
		0.895074f, -0.440803f, -0.0673436f, 0.895150f, -0.441429f, -0.0620203f, 
		0.895229f, -0.440347f, -0.0682541f, 0.895409f, 0.177382f, 0.408385f, 
		0.895493f, 0.433483f, -0.100916f, 0.895556f, 0.337969f, 0.289408f, 
		0.895897f, 0.303660f, -0.324281f, 0.896063f, -0.440762f, -0.0529154f, 
		0.896076f, 0.403895f, 0.184164f, 0.896174f, 0.335213f, 0.290697f, 
		0.896198f, 0.103476f, 0.431418f, 0.896810f, 0.392678f, 0.203803f, 
		0.896854f, -0.304906f, -0.320444f, 0.896979f, 0.136695f, -0.420409f, 
		0.897121f, 0.385439f, -0.215894f, 0.897358f, -0.441264f, -0.00591966f, 
		0.897419f, -0.116969f, -0.425391f, 0.897765f, 0.118332f, 0.424284f, 
		0.897842f, -0.0593131f, -0.436304f, 0.897872f, 0.369920f, -0.238716f, 
		0.898132f, 0.400322f, -0.181938f, 0.898399f, -0.272984f, 0.344034f, 
		0.898714f, -0.0449949f, -0.436221f, 0.898798f, 0.413297f, 0.146107f, 
		0.898852f, 0.322259f, -0.297007f, 0.899305f, 0.109114f, -0.423491f, 
		0.899536f, 0.260513f, -0.350667f, 0.899561f, -0.329677f, -0.286536f, 
		0.899607f, -0.373498f, 0.226287f, 0.899632f, 0.0689375f, 0.431172f, 
		0.899705f, -0.138027f, 0.414101f, 0.899811f, 0.395258f, -0.184693f, 
		0.899970f, -0.421234f, 0.112322f, 0.900708f, 0.269842f, -0.340456f, 
		0.900895f, 0.428196f, 0.0709658f, 0.900930f, -0.0827354f, -0.426005f, 
		0.901518f, 0.431448f, 0.0334325f, 0.901674f, 0.415603f, -0.119410f, 
		0.901715f, -0.169399f, -0.397762f, 0.901734f, 0.268508f, 0.338791f, 
		0.901832f, 0.414030f, 0.123605f, 0.901847f, -0.289317f, 0.320885f, 
		0.902065f, 0.410744f, 0.132549f, 0.902470f, 0.418586f, 0.101657f, 
		0.902493f, 0.246829f, -0.352962f, 0.902837f, -0.429928f, -0.00689972f, 
		0.902896f, 0.428302f, 0.0365606f, 0.903253f, 0.414605f, -0.110619f, 
		0.903282f, -0.0879211f, 0.419943f, 0.903545f, -0.210103f, 0.373447f, 
		0.903991f, 0.267259f, 0.333726f, 0.904148f, -0.0769328f, -0.420235f, 
		0.904496f, -0.223343f, 0.363325f, 0.904785f, 0.423817f, -0.0417566f, 
		0.904794f, 0.298580f, -0.303642f, 0.904844f, 0.280438f, 0.320333f, 
		0.905181f, -0.250489f, 0.343370f, 0.905191f, 0.00812548f, -0.424927f, 
		0.905485f, 0.357325f, 0.228944f, 0.906056f, 0.401968f, -0.132228f, 
		0.906731f, 0.421458f, 0.0145851f, 0.907283f, -0.219520f, -0.358676f, 
		0.907290f, -0.219455f, -0.358699f, 0.907437f, -0.0561106f, -0.416425f, 
		0.908130f, 0.124497f, -0.399751f, 0.908201f, 0.391873f, -0.146988f, 
		0.908687f, -0.354410f, 0.220640f, 0.908842f, -0.416929f, 0.0132877f, 
		0.908943f, -0.125347f, 0.397632f, 0.908963f, 0.239904f, -0.340929f, 
		0.909175f, -0.409911f, 0.0733127f, 0.909212f, -0.416123f, 0.0132537f, 
		0.909271f, -0.303213f, -0.285109f, 0.909987f, -0.407980f, 0.0739999f, 
		0.910078f, 0.302062f, 0.283754f, 0.910159f, -0.164682f, -0.380120f, 
		0.910857f, 0.0174419f, -0.412353f, 0.910879f, 0.412615f, 0.00691163f, 
		0.911090f, 0.361460f, -0.198147f, 0.911230f, 0.373320f, 0.174044f, 
		0.911725f, -0.410774f, 0.00468203f, 0.911772f, -0.391571f, -0.123873f, 
		0.911787f, 0.297816f, -0.282754f, 0.911789f, 0.121072f, -0.392405f, 
		0.912139f, -0.409595f, 0.0152918f, 0.912152f, 0.148215f, 0.382114f, 
		0.912335f, 0.289161f, 0.289881f, 0.913543f, 0.406573f, 0.0117446f, 
		0.913564f, -0.242265f, 0.326661f, 0.913709f, -0.329534f, 0.237789f, 
		0.913718f, 0.406183f, 0.0115639f, 0.913751f, 0.359661f, -0.188953f, 
		0.913850f, 0.189351f, -0.359199f, 0.914211f, 0.377749f, 0.146712f, 
		0.914341f, 0.377463f, 0.146639f, 0.914381f, 0.273706f, 0.298315f, 
		0.914595f, -0.404138f, 0.0137287f, 0.914680f, 0.0685685f, -0.398320f, 
		0.914763f, 0.397773f, -0.0706045f, 0.914781f, 0.296645f, -0.274185f, 
		0.915089f, -0.370189f, 0.159913f, 0.915096f, 0.0190390f, -0.402787f, 
		0.915187f, -0.272203f, -0.297219f, 0.915236f, 0.187279f, 0.356748f, 
		0.915578f, 0.346968f, 0.203298f, 0.915682f, 0.183688f, 0.357471f, 
		0.915826f, 0.0755778f, 0.394399f, 0.915949f, 0.0155379f, -0.400994f, 
		0.916074f, -0.322161f, 0.238791f, 0.916209f, 0.305601f, 0.259172f, 
		0.916209f, 0.371072f, 0.151213f, 0.916290f, -0.397645f, 0.0478658f, 
		0.916660f, -0.146024f, -0.372036f, 0.917257f, -0.206298f, 0.340706f, 
		0.917420f, -0.183084f, -0.353300f, 0.918834f, -0.209168f, 0.334653f, 
		0.919049f, 0.0945691f, -0.382631f, 0.919161f, 0.378992f, 0.107273f, 
		0.919232f, -0.0647211f, 0.388360f, 0.919314f, -0.0908865f, 0.382886f, 
		0.919475f, 0.167336f, 0.355759f, 0.919509f, -0.106441f, 0.378383f, 
		0.919526f, 0.393025f, 0.00168197f, 0.919899f, -0.391216f, 0.0271325f, 
		0.919908f, -0.159750f, 0.358120f, 0.920483f, 0.215758f, 0.325822f, 
		0.920500f, -0.233891f, -0.313009f, 0.920776f, 0.380736f, -0.0849248f, 
		0.920844f, -0.294501f, -0.255568f, 0.920858f, 0.187477f, -0.341867f, 
		0.920858f, 0.187457f, -0.341878f, 0.920867f, -0.387536f, -0.0426703f, 
		0.920868f, -0.389715f, 0.0111349f, 0.921191f, -0.00721698f, 0.389045f, 
		0.921557f, 0.0977266f, 0.375742f, 0.921711f, 0.222800f, -0.317503f, 
		0.921930f, -0.379699f, -0.0766369f, 0.922170f, 0.368633f, 0.117104f, 
		0.922465f, 0.174533f, 0.344379f, 0.922705f, -0.340323f, 0.181095f, 
		0.922717f, -0.167911f, 0.346986f, 0.923135f, 0.353467f, 0.151274f, 
		0.923569f, 0.0984095f, 0.370588f, 0.923714f, -0.292525f, -0.247351f, 
		0.924137f, 0.114033f, 0.364646f, 0.924202f, 0.188527f, 0.332127f, 
		0.924534f, -0.380845f, 0.0139635f, 0.925129f, 0.338095f, -0.172707f, 
		0.925639f, 0.374334f, 0.0553682f, 0.925980f, 0.166337f, 0.338958f, 
		0.926534f, 0.113582f, -0.358657f, 0.926616f, -0.247651f, 0.282933f, 
		0.926665f, 0.301456f, -0.224536f, 0.926894f, 0.375089f, 0.0132514f, 
		0.926972f, -0.329956f, 0.178472f, 0.927023f, 0.370242f, 0.0595737f, 
		0.927297f, 0.173238f, -0.331827f, 0.927677f, -0.0575444f, -0.368923f, 
		0.927716f, -0.356588f, 0.110402f, 0.927873f, 0.139584f, 0.345785f, 
		0.927954f, 0.309340f, -0.207870f, 0.928094f, 0.281112f, 0.244169f, 
		0.928720f, 0.178241f, 0.325129f, 0.928929f, -0.117262f, -0.351198f, 
		0.929205f, 0.249886f, -0.272278f, 0.929253f, 0.0349518f, -0.367788f, 
		0.929524f, -0.277028f, -0.243392f, 0.929771f, 0.333387f, 0.156139f, 
		0.929779f, 0.0348531f, -0.366465f, 0.929798f, 0.00631482f, -0.368015f, 
		0.929818f, 0.0929828f, 0.356079f, 0.929922f, 0.349722f, 0.113749f, 
		0.930384f, 0.0672723f, 0.360361f, 0.930451f, 0.365003f, -0.0321460f, 
		0.930471f, 0.201093f, -0.306243f, 0.930534f, 0.270655f, 0.246684f, 
		0.930651f, 0.365781f, 0.00961495f, 0.930899f, 0.254474f, -0.262049f, 
		0.930958f, 0.246047f, -0.269774f, 0.931603f, 0.130943f, -0.339072f, 
		0.931970f, 0.252247f, 0.260389f, 0.932192f, 0.359984f, -0.0378079f, 
		0.932608f, 0.360224f, 0.0219278f, 0.932701f, 0.360596f, -0.00627458f, 
		0.932750f, 0.357267f, -0.0483516f, 0.932831f, 0.127980f, -0.336820f, 
		0.932975f, 0.133310f, 0.334345f, 0.933004f, 0.241115f, 0.267146f, 
		0.933359f, 0.349139f, 0.0833181f, 0.933871f, 0.302873f, 0.190140f, 
		0.934140f, 0.356867f, -0.00543646f, 0.934356f, 0.173239f, 0.311395f, 
		0.934447f, -0.330863f, 0.131679f, 0.934754f, 0.202296f, 0.292082f, 
		0.934857f, -0.201515f, 0.292291f, 0.935175f, 0.321478f, 0.148656f, 
		0.935594f, 0.349541f, 0.0498433f, 0.935968f, 0.123477f, -0.329723f, 
		0.936257f, 0.348096f, 0.0474611f, 0.936386f, 0.121771f, 0.329172f, 
		0.936681f, -0.347827f, 0.0405630f, 0.936695f, 0.326740f, -0.125867f, 
		0.936831f, 0.231841f, 0.261910f, 0.937071f, -0.325094f, -0.127323f, 
		0.937362f, -0.324306f, -0.127190f, 0.937469f, 0.215470f, 0.273360f, 
		0.937829f, -0.301157f, 0.172572f, 0.937955f, -0.319672f, 0.134353f, 
		0.938420f, -0.198142f, 0.283031f, 0.938482f, 0.225104f, 0.261878f, 
		0.938953f, -0.216243f, -0.267595f, 0.939085f, -0.176326f, 0.295006f, 
		0.939322f, 0.294014f, 0.176722f, 0.939324f, 0.323055f, -0.115352f, 
		0.939459f, -0.00687057f, -0.342592f, 0.939460f, -0.00693140f, -0.342588f, 
		0.939571f, -0.177376f, 0.292822f, 0.939999f, 0.130611f, -0.315188f, 
		0.940518f, 0.202679f, -0.272666f, 0.940817f, 0.219354f, -0.258354f, 
		0.941918f, 0.226651f, -0.247830f, 0.942009f, 0.108290f, -0.317637f, 
		0.942034f, -0.334634f, -0.0243150f, 0.942475f, -0.0339226f, 0.332551f, 
		0.942702f, -0.187631f, 0.275876f, 0.942908f, -0.229780f, 0.241093f, 
		0.942929f, -0.229629f, 0.241156f, 0.943617f, 0.00778386f, 0.330947f, 
		0.944191f, 0.182659f, -0.274114f, 0.944369f, 0.193263f, -0.266114f, 
		0.944380f, 0.326031f, 0.0430072f, 0.944447f, -0.327589f, 0.0265445f, 
		0.945010f, -0.197177f, 0.260918f, 0.945363f, -0.291989f, 0.145021f, 
		0.945378f, -0.325272f, 0.0214068f, 0.945390f, -0.286424f, -0.155563f, 
		0.945721f, 0.324299f, 0.0210068f, 0.945857f, 0.266735f, 0.184952f, 
		0.945884f, 0.293292f, 0.138864f, 0.946027f, 0.0229065f, -0.323276f, 
		0.946269f, 0.0780895f, -0.313809f, 0.946975f, 0.308969f, -0.0881857f, 
		0.946988f, -0.285745f, -0.146843f, 0.947003f, -0.0761780f, 0.312062f, 
		0.947616f, 0.317013f, -0.0390770f, 0.947788f, 0.0132164f, -0.318628f, 
		0.947879f, 0.307842f, -0.0822089f, 0.948061f, 0.178094f, -0.263558f, 
		0.948074f, 0.303494f, -0.0951173f, 0.948130f, -0.126102f, 0.291799f, 
		0.948294f, -0.311807f, 0.0592868f, 0.948356f, -0.0601786f, 0.311447f, 
		0.949214f, 0.314609f, -0.00381333f, 0.949425f, 0.311934f, 0.0359072f, 
		0.949563f, 0.311983f, 0.0315652f, 0.949854f, 0.308302f, -0.0522186f, 
		0.949910f, 0.00437338f, 0.312492f, 0.950249f, 0.0916307f, -0.297710f, 
		0.950316f, 0.309791f, 0.0304807f, 0.950539f, 0.231676f, 0.206888f, 
		0.951680f, 0.235813f, -0.196714f, 0.951682f, 0.186439f, 0.244011f, 
		0.952023f, 0.0519607f, -0.301582f, 0.952164f, 0.101079f, 0.288387f, 
		0.952190f, 0.0880691f, -0.292537f, 0.952249f, 0.304203f, 0.0261367f, 
		0.952505f, -0.136589f, 0.272171f, 0.953240f, 0.172836f, -0.247915f, 
		0.953460f, 0.293203f, 0.0703263f, 0.953816f, -0.267676f, -0.136328f, 
		0.954016f, 0.221676f, 0.201776f, 0.954115f, 0.0792338f, 0.288767f, 
		0.954373f, -0.298609f, 0.00211559f, 0.954392f, -0.298314f, -0.0120220f, 
		0.954686f, 0.296520f, 0.0255098f, 0.954748f, -0.111135f, 0.275870f, 
		0.954986f, 0.0114047f, -0.296433f, 0.955108f, -0.220698f, -0.197636f, 
		0.955159f, 0.0261407f, -0.294938f, 0.955725f, 0.294004f, 0.0122974f, 
		0.955862f, 0.250911f, 0.152879f, 0.955866f, 0.0163711f, -0.293347f, 
		0.955905f, -0.169255f, -0.239996f, 0.956062f, 0.288423f, 0.0525056f, 
		0.956463f, 0.0327810f, -0.290005f, 0.956472f, -0.290449f, -0.0282905f, 
		0.956588f, -0.164246f, 0.240756f, 0.956676f, -0.278737f, 0.0841218f, 
		0.956736f, 0.0922239f, 0.275955f, 0.956751f, 0.0173374f, -0.290392f, 
		0.956946f, 0.271988f, 0.101371f, 0.957063f, 0.198194f, 0.211539f, 
		0.957066f, 0.0131915f, -0.289569f, 0.957094f, 0.289632f, 0.00916238f, 
		0.957247f, 0.143546f, -0.251143f, 0.957383f, 0.0360659f, 0.286562f, 
		0.957564f, 0.0115434f, 0.287988f, 0.957789f, -0.239638f, 0.158789f, 
		0.957934f, 0.277138f, -0.0745406f, 0.958478f, -0.244871f, 0.146144f, 
		0.958518f, -0.284993f, 0.00475232f, 0.958601f, 0.0971456f, -0.267668f, 
		0.958614f, -0.211130f, -0.191008f, 0.958628f, -0.0144397f, 0.284297f, 
		0.958683f, 0.264071f, -0.105803f, 0.958765f, -0.0187244f, 0.283583f, 
		0.959080f, 0.281858f, 0.0268538f, 0.959127f, 0.132703f, -0.249930f, 
		0.959519f, 0.280240f, -0.0280901f, 0.959972f, 0.260735f, -0.102331f, 
		0.960041f, -0.269470f, -0.0755512f, 0.960746f, -0.203827f, -0.188206f, 
		0.960909f, 0.274258f, -0.0379019f, 0.961202f, 0.202299f, 0.187527f, 
		0.961286f, 0.245480f, 0.125172f, 0.961358f, -0.275300f, 0.000571683f, 
		0.961622f, 0.271515f, -0.0395363f, 0.961784f, 0.178940f, 0.207248f, 
		0.962118f, 0.263839f, -0.0686930f, 0.962137f, 0.129601f, -0.239783f, 
		0.962226f, 0.148880f, -0.227938f, 0.963534f, -0.166713f, -0.209308f, 
		0.964386f, 0.202534f, -0.170118f, 0.964509f, -0.232129f, -0.125850f, 
		0.964849f, 0.257701f, 0.0515482f, 0.965433f, -0.191695f, -0.176614f, 
		0.965872f, 0.246255f, 0.0803064f, 0.966406f, -0.0913655f, 0.240233f, 
		0.966993f, 0.224284f, 0.120921f, 0.967124f, 0.124809f, 0.221573f, 
		0.967238f, 0.184326f, 0.174569f, 0.967618f, 0.0731608f, 0.241582f, 
		0.967720f, 0.250208f, -0.0302369f, 0.967931f, -0.204352f, 0.146112f, 
		0.968025f, -0.120193f, 0.220184f, 0.968157f, 0.0766419f, 0.238324f, 
		0.968431f, 0.225967f, 0.105260f, 0.968465f, 0.0856347f, 0.233969f, 
		0.968523f, -0.0144562f, 0.248504f, 0.968703f, -0.245230f, 0.0384372f, 
		0.968757f, 0.210445f, -0.131237f, 0.969725f, -0.102496f, 0.221646f, 
		0.970034f, 0.0243561f, -0.241745f, 0.970082f, 0.231801f, -0.0721731f, 
		0.970159f, -0.133984f, 0.202091f, 0.970407f, 0.229079f, 0.0763759f, 
		0.970894f, 0.193803f, -0.140731f, 0.970986f, 0.195226f, -0.138105f, 
		0.971478f, -0.135550f, 0.194566f, 0.971622f, 0.186690f, -0.145248f, 
		0.971690f, -0.217472f, -0.0923310f, 0.971855f, 0.223531f, -0.0743819f, 
		0.972122f, 0.228432f, 0.0528994f, 0.972205f, 0.169646f, 0.161362f, 
		0.972756f, -0.140684f, 0.184264f, 0.973233f, 0.104085f, 0.204901f, 
		0.973617f, 0.0119447f, 0.227876f, 0.973632f, -0.226833f, -0.0242307f, 
		0.973826f, 0.220223f, -0.0562628f, 0.974234f, 0.0544668f, 0.218864f, 
		0.974253f, -0.119455f, 0.191211f, 0.974510f, -0.0377829f, 0.221140f, 
		0.974532f, 0.170060f, 0.146174f, 0.974628f, 0.0540863f, 0.217200f, 
		0.974729f, -0.148323f, 0.167042f, 0.975113f, 0.0879618f, 0.203515f, 
		0.975186f, 0.192863f, 0.108703f, 0.975740f, 0.00468767f, 0.218882f, 
		0.976214f, 0.194657f, -0.0954771f, 0.976269f, -0.215653f, -0.0198125f, 
		0.976368f, 0.0330734f, -0.213568f, 0.976474f, -0.214725f, -0.0197742f, 
		0.976904f, -0.0735938f, -0.200607f, 0.977564f, -0.208863f, -0.0272785f, 
		0.978167f, 0.139177f, -0.154337f, 0.978200f, -0.155090f, 0.138103f, 
		0.978276f, 0.207304f, -0.00122676f, 0.978920f, 0.197977f, 0.0501972f, 
		0.979372f, 0.108091f, 0.170727f, 0.980129f, -0.0269104f, 0.196530f, 
		0.980152f, 0.170759f, -0.100717f, 0.980316f, 0.0883438f, -0.176568f, 
		0.980316f, -0.0563467f, -0.189222f, 0.980685f, 0.0313105f, -0.193073f, 
		0.980812f, -0.138231f, 0.137479f, 0.980877f, -0.138264f, 0.136978f, 
		0.981185f, 0.161124f, -0.106374f, 0.981772f, 0.161172f, 0.100732f, 
		0.981792f, 0.143498f, 0.124469f, 0.982457f, 0.148009f, -0.113454f, 
		0.982572f, 0.132869f, 0.129991f, 0.982620f, 0.114565f, 0.146060f, 
		0.982720f, 0.0666627f, 0.172679f, 0.982844f, 0.113918f, -0.145054f, 
		0.982907f, -0.157499f, -0.0953323f, 0.983600f, 0.00860772f, 0.180158f, 
		0.983611f, 0.0868541f, 0.158004f, 0.984159f, 0.0689505f, -0.163334f, 
		0.984260f, 0.0969381f, -0.147768f, 0.984833f, 0.134234f, -0.109929f, 
		0.984938f, -0.163535f, -0.0561616f, 0.985007f, 0.171292f, 0.0205223f, 
		0.985383f, 0.165618f, -0.0398808f, 0.986167f, 0.154370f, -0.0603758f, 
		0.986484f, 0.156197f, -0.0495155f, 0.986514f, -0.158941f, -0.0390912f, 
		0.986924f, 0.159969f, 0.0197787f, 0.987018f, 0.0572512f, -0.150063f, 
		0.987039f, 0.153065f, -0.0482140f, 0.987170f, -0.0991260f, -0.125177f, 
		0.987553f, -0.108348f, -0.114018f, 0.987556f, 0.150426f, -0.0458810f, 
		0.987911f, 0.128928f, -0.0860827f, 0.987933f, -0.0285733f, 0.152222f, 
		0.988200f, 0.00143270f, 0.153165f, 0.989122f, -0.0164054f, -0.146177f, 
		0.989134f, -0.146119f, -0.0162454f, 0.989160f, 0.0874399f, 0.117970f, 
		0.989255f, -0.0468517f, 0.138490f, 0.989749f, 0.00675590f, 0.142654f, 
		0.989769f, -0.0427008f, -0.136140f, 0.989799f, -0.0420808f, -0.136116f, 
		0.989949f, -0.123233f, -0.0693940f, 0.989969f, 0.0635145f, 0.126206f, 
		0.990186f, 0.116374f, 0.0773864f, 0.990331f, 0.133867f, -0.0363788f, 
		0.991031f, 0.118959f, 0.0608836f, 0.991181f, -0.125591f, 0.0422781f, 
		0.991260f, 0.0165720f, -0.130879f, 0.991450f, -0.0131793f, 0.129819f, 
		0.991457f, 0.109007f, -0.0716321f, 0.991738f, -0.0634992f, -0.111461f, 
		0.991860f, -0.0332285f, -0.122920f, 0.992052f, -0.121369f, 0.0332092f, 
		0.992062f, 0.0386176f, -0.119676f, 0.992725f, 0.0223300f, -0.118317f, 
		0.992772f, -0.0272348f, -0.116881f, 0.992775f, -0.0240767f, -0.117550f, 
		0.992802f, 0.102545f, 0.0618750f, 0.992963f, -0.115048f, 0.0280593f, 
		0.993052f, -0.0459500f, 0.108334f, 0.993120f, -0.114173f, 0.0260145f, 
		0.993690f, -0.0312305f, 0.107728f, 0.994081f, 0.0436139f, 0.0995054f, 
		0.994412f, -0.00363464f, 0.105502f, 0.994423f, -0.00492564f, 0.105352f, 
		0.994506f, -0.0878935f, 0.0568498f, 0.994633f, 0.0931941f, -0.0449352f, 
		0.994953f, -0.0671674f, -0.0745453f, 0.994956f, 0.100052f, -0.00720429f, 
		0.995387f, 0.0698105f, -0.0658137f, 0.995516f, 0.0716051f, 0.0618085f, 
		0.995680f, -0.0797331f, 0.0475855f, 0.995903f, 0.0372132f, 0.0824198f, 
		0.995985f, 0.0790185f, 0.0420700f, 0.996146f, 0.0362705f, 0.0798583f, 
		0.996148f, 0.0683704f, 0.0548984f, 0.996544f, 0.0784431f, 0.0273262f, 
		0.996627f, 0.0774156f, 0.0272303f, 0.996645f, 0.0499919f, 0.0648057f, 
		0.996726f, 0.0542444f, -0.0599563f, 0.996800f, 0.0535402f, 0.0593491f, 
		0.996817f, 0.0323455f, 0.0728677f, 0.996877f, -0.0789075f, 0.00314442f, 
		0.997075f, 0.0573498f, 0.0505178f, 0.997310f, 0.0724443f, -0.0111892f, 
		0.997319f, 0.0457984f, -0.0570701f, 0.997332f, 0.0540232f, -0.0490944f, 
		0.997508f, -0.0587136f, -0.0391131f, 0.997939f, 0.0118029f, -0.0630682f, 
		0.998121f, 0.0158501f, -0.0591955f, 0.998268f, 0.0584989f, 0.00618580f, 
		0.998342f, 0.0484455f, -0.0311002f, 0.998356f, 0.0556264f, 0.0137911f, 
		0.998659f, -0.0206058f, -0.0474927f, 0.998696f, 0.0373162f, 0.0348389f, 
		0.998728f, 0.0500327f, 0.00630546f, 0.998806f, -0.0176447f, -0.0455573f, 
		0.998884f, -0.0355702f, -0.0310851f, 0.998939f, -0.0458020f, -0.00477423f, 
		0.998982f, -0.0341999f, -0.0294109f, 0.999040f, -0.0400416f, -0.0177607f, 
		0.999088f, -0.0370873f, -0.0211791f, 0.999101f, -0.0347739f, -0.0242561f, 
		0.999124f, -0.0408561f, -0.00907900f, 0.999162f, -0.0406286f, -0.00496502f, 
		0.999203f, -0.0342850f, -0.0204292f, 0.999213f, -0.0298096f, -0.0261579f, 
		0.999231f, -0.0386198f, -0.00674395f, 0.999237f, -0.0326086f, -0.0214934f, 
		0.999240f, -0.0328808f, -0.0209465f, 0.999259f, -0.0321208f, -0.0212110f, 
		0.999262f, -0.0377632f, -0.00707385f, 0.999268f, -0.0316666f, -0.0214429f, 
		0.999272f, -0.0374744f, -0.00708159f, 0.999278f, -0.0313633f, -0.0214220f, 
		0.999283f, -0.0371248f, -0.00743713f, 0.999284f, -0.0151578f, -0.0346605f, 
		0.999286f, -0.0370408f, -0.00743879f, 0.999289f, -0.0370159f, -0.00717498f, 
		0.999291f, -0.0371507f, 0.00612744f, 0.999313f, -0.0364157f, -0.00681558f, 
		0.999314f, -0.0312901f, -0.0198262f, 0.999317f, -0.0357862f, -0.00926230f, 
		0.999324f, -0.0363578f, -0.00551652f, 0.999330f, -0.0362869f, -0.00469934f, 
		0.999331f, -0.0234807f, -0.0280219f, 0.999335f, -0.0358668f, 0.00650848f, 
		0.999341f, -0.0358646f, -0.00563300f, 0.999359f, -0.0353763f, -0.00541593f, 
		0.999368f, -0.0351884f, -0.00494893f, 0.999375f, -0.0348553f, -0.00584377f, 
		0.999381f, -0.0345830f, -0.00652601f, 0.999384f, -0.0347578f, -0.00479064f, 
		0.999393f, -0.0301066f, -0.0175515f, 0.999395f, -0.0344571f, 0.00474927f, 
		0.999395f, -0.0345449f, 0.00396097f, 0.999405f, -0.0340416f, -0.00554162f, 
		0.999408f, -0.0343369f, 0.00220864f, 0.999408f, -0.0337507f, 0.00662971f, 
		0.999414f, -0.0336935f, 0.00601483f, 0.999421f, -0.0336730f, 0.00494082f, 
		0.999428f, -0.0335946f, -0.00391750f, 0.999434f, -0.0330052f, 0.00657345f, 
		0.999448f, -0.0330959f, -0.00296674f, 0.999455f, -0.0327255f, 0.00430263f, 
		0.999460f, -0.0327999f, -0.00206414f, 0.999460f, -0.0322610f, 0.00618252f, 
		0.999462f, -0.0327296f, -0.00213115f, 0.999466f, -0.0326225f, -0.00206636f, 
		0.999468f, -0.0325485f, -0.00221745f, 0.999475f, -0.0314594f, 0.00772731f, 
		0.999477f, -0.0321532f, -0.00348595f, 0.999482f, -0.00919098f, 0.0308392f, 
		0.999485f, -0.0318821f, -0.00362772f, 0.999486f, 0.0289714f, 0.0137529f, 
		0.999490f, -0.0303258f, 0.0100147f, 0.999492f, -0.0318835f, -0.000143460f, 
		0.999492f, -0.0318666f, -0.000516283f, 0.999535f, -0.0304100f, -0.00209927f, 
		0.999576f, -0.0289606f, 0.00297374f, 0.999586f, 0.0204595f, -0.0202319f, 
		0.999600f, -0.0281460f, 0.00288984f, 0.999726f, 0.0207577f, -0.0108544f, 
		0.999740f, -0.0226010f, -0.00308087f, 0.999772f, -0.0209073f, -0.00438887f, 
		0.999777f, 0.00251224f, 0.0209717f, 0.999952f, -0.00798909f, 0.00569517f, 
		0.999978f, -0.000784296f, -0.00665551f, 1.00000f, 0.000000f, 0.000000f
	};
	static const GLfloat TexCoordData[] = {
		0.000000f, 0.000000f, 0.000000f, 0.000839165f, 0.000000f, 0.00790788f, 
		0.000000f, 0.0640890f, 0.000000f, 0.0640890f, 
		0.000000f, 0.0687983f, 0.000000f, 0.0806269f, 
		0.000000f, 0.108893f, 0.000000f, 0.108924f, 
		0.000000f, 0.178469f, 0.000000f, 0.183288f, 
		0.000000f, 0.183288f, 0.000000f, 0.198950f, 
		0.000000f, 0.202457f, 0.000000f, 0.232217f, 
		0.000000f, 0.256762f, 0.000000f, 0.266300f, 
		0.000000f, 0.291312f, 0.000000f, 0.304633f, 
		0.000000f, 0.313723f, 0.000000f, 0.313723f, 
		0.000000f, 0.343722f, 0.000000f, 0.355716f, 
		0.000000f, 0.385622f, 0.000000f, 0.432922f, 
		0.000000f, 0.432922f, 0.000000f, 0.467985f, 
		0.000000f, 0.485184f, 0.000000f, 0.499268f, 
		0.000000f, 0.510753f, 0.000000f, 0.511009f, 
		0.000000f, 0.512947f, 0.000000f, 0.522489f, 
		0.000000f, 0.545271f, 0.000000f, 0.553723f, 
		0.000000f, 0.553733f, 0.000000f, 0.563357f, 
		0.000000f, 0.661642f, 0.000000f, 0.661661f, 
		0.000000f, 0.682556f, 0.000000f, 0.682556f, 
		0.000000f, 0.752327f, 0.000000f, 0.812990f, 
		0.000000f, 0.812990f, 0.000000f, 0.932189f, 
		0.000000f, 0.932189f, 0.000000f, 0.998535f, 
		1.00139e-005f, 0.491674f, 8.45919e-005f, 0.0733746f, 
		0.000219950f, 0.322526f, 0.000238822f, 0.0115178f, 
		0.000320329f, 0.743594f, 0.000460412f, 0.188644f, 
		0.000586584f, 0.133299f, 0.000700733f, 0.137280f, 
		0.000709240f, 0.389595f, 0.000728280f, 0.748459f, 
		0.000760795f, 0.202652f, 0.000785353f, 0.810932f, 
		0.000808724f, 0.210942f, 0.000852910f, 0.322150f, 
		0.000864063f, 0.246514f, 0.000881939f, 0.247012f, 
		0.000896623f, 0.214476f, 0.000898124f, 0.322100f, 
		0.000899247f, 0.235083f, 0.000899554f, 0.246513f, 
		0.000905383f, 0.322139f, 0.000906133f, 0.322615f, 
		0.000913558f, 0.246513f, 0.000984328f, 0.0662579f, 
		0.00127580f, 0.152782f, 0.00130718f, 0.388568f, 
		0.00134105f, 0.0733943f, 0.00148529f, 0.0143014f, 
		0.00150585f, 0.559410f, 0.00151409f, 0.127356f, 
		0.00152738f, 0.00133195f, 0.00152808f, 0.141051f, 
		0.00153135f, 0.485115f, 0.00154587f, 0.212730f, 
		0.00155239f, 0.481075f, 0.00156727f, 0.0694690f, 
		0.00164830f, 0.152782f, 0.00193257f, 0.486488f, 
		0.00207333f, 0.464987f, 0.00211874f, 0.680605f, 
		0.00216117f, 0.114807f, 0.00225321f, 0.808016f, 
		0.00226087f, 0.0263009f, 0.00264469f, 0.206000f, 
		0.00311825f, 0.675804f, 0.00337928f, 0.746270f, 
		0.00339125f, 0.498601f, 0.00453477f, 0.0143075f, 
		0.00456842f, 0.0531877f, 0.00465586f, 0.301831f, 
		0.00465822f, 0.301813f, 0.00466988f, 0.127130f, 
		0.00476548f, 0.150683f, 0.00477106f, 0.150706f, 
		0.00519181f, 0.233809f, 0.00519327f, 0.233799f, 
		0.00530710f, 0.510911f, 0.00531503f, 0.510676f, 
		0.00540313f, 0.987611f, 0.00541316f, 0.614615f, 
		0.00556649f, 0.398961f, 0.00556717f, 0.509948f, 
		0.00565200f, 0.00343275f, 0.00565200f, 0.531477f, 
		0.00583258f, 0.170177f, 0.00587861f, 0.381239f, 
		0.00590479f, 0.744540f, 0.00591956f, 0.381682f, 
		0.00592658f, 0.381663f, 0.00595487f, 0.172346f, 
		0.00608569f, 0.0186534f, 0.00618708f, 0.517412f, 
		0.00631029f, 0.514173f, 0.00647311f, 0.509928f, 
		0.00676710f, 0.0143002f, 0.00735271f, 0.0143010f, 
		0.00771607f, 0.997231f, 0.00775705f, 0.997573f, 
		0.00787200f, 0.000000f, 0.00787200f, 0.998535f, 
		0.00800665f, 0.424400f, 0.00812025f, 0.253782f, 
		0.00833794f, 0.000982448f, 0.00836767f, 0.480517f, 
		0.00856303f, 0.00132617f, 0.00863167f, 0.240805f, 
		0.00866742f, 0.00167714f, 0.00868155f, 0.00132607f, 
		0.00874158f, 0.996701f, 0.00885360f, 0.00206970f, 
		0.00893242f, 0.253783f, 0.00901421f, 0.423843f, 
		0.00909291f, 0.230856f, 0.00911516f, 0.0502147f, 
		0.00911801f, 0.0855798f, 0.00916568f, 0.230801f, 
		0.00927243f, 0.614582f, 0.00939914f, 0.476788f, 
		0.00951555f, 0.296088f, 0.00951635f, 0.296070f, 
		0.00962724f, 0.422439f, 0.00964195f, 0.741877f, 
		0.00971868f, 0.00132522f, 0.00976819f, 0.117500f, 
		0.00996471f, 0.00639840f, 0.0100549f, 0.240809f, 
		0.0101537f, 0.123187f, 0.0102288f, 0.521967f, 
		0.0102326f, 0.0584793f, 0.0102907f, 0.112320f, 
		0.0104518f, 0.0646888f, 0.0104878f, 0.472813f, 
		0.0106313f, 0.0586610f, 0.0107293f, 0.00132439f, 
		0.0107387f, 0.349598f, 0.0108193f, 0.177169f, 
		0.0108363f, 0.0142979f, 0.0108393f, 0.240810f, 
		0.0108851f, 0.614578f, 0.0108861f, 0.240812f, 
		0.0110199f, 0.253785f, 0.0110505f, 0.423562f, 
		0.0113059f, 0.0635087f, 0.0113866f, 0.911653f, 
		0.0114120f, 0.469667f, 0.0114494f, 0.116562f, 
		0.0114926f, 0.181885f, 0.0116121f, 0.0799556f, 
		0.0116275f, 0.181732f, 0.0116594f, 0.480850f, 
		0.0118096f, 0.0121445f, 0.0118096f, 0.527541f, 
		0.0120154f, 0.181246f, 0.0121343f, 0.0126038f, 
		0.0122000f, 0.462112f, 0.0122916f, 0.519355f, 
		0.0132765f, 0.507179f, 0.0133683f, 0.786695f, 
		0.0134497f, 0.253787f, 0.0136522f, 0.0850595f, 
		0.0138674f, 0.787455f, 0.0139217f, 0.914949f, 
		0.0139260f, 0.914928f, 0.0140665f, 0.909635f, 
		0.0141242f, 0.762245f, 0.0141690f, 0.0154825f, 
		0.0141690f, 0.0615374f, 0.0141690f, 0.0901822f, 
		0.0141690f, 0.109006f, 0.0141690f, 0.110702f, 
		0.0141690f, 0.182865f, 0.0141690f, 0.184042f, 
		0.0141690f, 0.257859f, 0.0141690f, 0.257873f, 
		0.0141690f, 0.344029f, 0.0141690f, 0.344106f, 
		0.0141690f, 0.344126f, 0.0141690f, 0.344170f, 
		0.0141690f, 0.403717f, 0.0141690f, 0.413284f, 
		0.0141690f, 0.413425f, 0.0141690f, 0.422932f, 
		0.0141690f, 0.520935f, 0.0141690f, 0.526033f, 
		0.0144572f, 0.485109f, 0.0145685f, 0.841512f, 
		0.0148958f, 0.841368f, 0.0150127f, 0.841614f, 
		0.0154096f, 0.550168f, 0.0155649f, 0.747413f, 
		0.0156291f, 0.487962f, 0.0159346f, 0.487527f, 
		0.0159974f, 0.487676f, 0.0160024f, 0.00132006f, 
		0.0160527f, 0.0142911f, 0.0165350f, 0.0730640f, 
		0.0165350f, 0.0896889f, 0.0165350f, 0.112393f, 
		0.0165350f, 0.113505f, 0.0165350f, 0.207014f, 
		0.0165350f, 0.230338f, 0.0165350f, 0.230688f, 
		0.0165350f, 0.232638f, 0.0165350f, 0.255722f, 
		0.0165350f, 0.742813f, 0.0165350f, 0.840231f, 
		0.0165350f, 0.925472f, 0.0174642f, 0.0153020f, 
		0.0176230f, 0.739347f, 0.0176230f, 0.745837f, 
		0.0176230f, 0.752289f, 0.0176230f, 0.752327f, 
		0.0176324f, 0.491674f, 0.0187341f, 0.760963f, 
		0.0188562f, 0.413965f, 0.0190601f, 0.761808f, 
		0.0192033f, 0.841884f, 0.0193339f, 0.761519f, 
		0.0194770f, 0.483730f, 0.0194899f, 0.252358f, 
		0.0195951f, 0.744653f, 0.0205112f, 0.252349f, 
		0.0205221f, 0.000000f, 0.0207200f, 0.0365320f, 
		0.0207200f, 0.962003f, 0.0207687f, 0.749741f, 
		0.0207776f, 0.252347f, 0.0209676f, 0.485429f, 
		0.0218372f, 0.0145606f, 0.0225895f, 0.0145556f, 
		0.0230145f, 0.244977f, 0.0232071f, 0.0885563f, 
		0.0232588f, 0.0157920f, 0.0232588f, 0.970530f, 
		0.0239210f, 0.0895697f, 0.0240372f, 0.0291529f, 
		0.0240372f, 0.981530f, 0.0244007f, 0.00150127f, 
		0.0244806f, 0.447517f, 0.0246367f, 0.441939f, 
		0.0249163f, 0.864175f, 0.0253741f, 0.00149261f, 
		0.0255237f, 0.0178112f, 0.0255420f, 0.104758f, 
		0.0256085f, 0.231369f, 0.0256688f, 0.741765f, 
		0.0256708f, 0.569676f, 0.0258225f, 0.499760f, 
		0.0259102f, 0.451391f, 0.0262422f, 0.471726f, 
		0.0263420f, 0.00148600f, 0.0265418f, 0.116537f, 
		0.0266676f, 0.00717684f, 0.0266829f, 0.0145270f, 
		0.0267689f, 0.468032f, 0.0268648f, 0.0168113f, 
		0.0268648f, 0.972299f, 0.0272306f, 0.239076f, 
		0.0272370f, 0.00581838f, 0.0274831f, 0.00148004f, 
		0.0275375f, 0.175138f, 0.0279162f, 0.747540f, 
		0.0280346f, 0.329582f, 0.0280936f, 0.473469f, 
		0.0282079f, 0.907282f, 0.0283970f, 0.482361f, 
		0.0285656f, 0.0145151f, 0.0287216f, 0.177558f, 
		0.0290546f, 0.576273f, 0.0291241f, 0.480537f, 
		0.0294035f, 0.860534f, 0.0299104f, 0.747644f, 
		0.0299367f, 0.000000f, 0.0299367f, 0.468764f, 
		0.0302383f, 0.808195f, 0.0304470f, 0.748358f, 
		0.0304907f, 0.239048f, 0.0309386f, 0.646535f, 
		0.0312339f, 0.960944f, 0.0314848f, 0.610532f, 
		0.0315134f, 0.688624f, 0.0316015f, 0.951028f, 
		0.0320275f, 0.277240f, 0.0320940f, 7.27196e-015f, 
		0.0320940f, 0.998535f, 0.0323915f, 0.746838f, 
		0.0324793f, 0.561016f, 0.0326344f, 0.805605f, 
		0.0328560f, 0.706279f, 0.0330304f, 0.482117f, 
		0.0333253f, 0.487928f, 0.0336620f, 0.239021f, 
		0.0338026f, 0.666046f, 0.0339059f, 0.346606f, 
		0.0340970f, 0.00981550f, 0.0340970f, 0.0196310f, 
		0.0340970f, 0.0280440f, 0.0340970f, 0.0437047f, 
		0.0340970f, 0.0438155f, 0.0340970f, 0.0473722f, 
		0.0340970f, 0.0509200f, 0.0340970f, 0.0587067f, 
		0.0340970f, 0.0652194f, 0.0340970f, 0.0656525f, 
		0.0340970f, 0.0658905f, 0.0340970f, 0.0664229f, 
		0.0340970f, 0.0953099f, 0.0340970f, 0.0953463f, 
		0.0340970f, 0.0960388f, 0.0340970f, 0.100119f, 
		0.0340970f, 0.100130f, 0.0340970f, 0.101274f, 
		0.0340970f, 0.103055f, 0.0340970f, 0.108958f, 
		0.0340970f, 0.114627f, 0.0340970f, 0.137829f, 
		0.0340970f, 0.140826f, 0.0340970f, 0.140840f, 
		0.0340970f, 0.140852f, 0.0340970f, 0.147953f, 
		0.0340970f, 0.155862f, 0.0340970f, 0.157540f, 
		0.0340970f, 0.158260f, 0.0340970f, 0.162170f, 
		0.0340970f, 0.169247f, 0.0340970f, 0.179067f, 
		0.0340970f, 0.181823f, 0.0340970f, 0.185850f, 
		0.0340970f, 0.187584f, 0.0340970f, 0.188837f, 
		0.0340970f, 0.206821f, 0.0340970f, 0.206833f, 
		0.0340970f, 0.214951f, 0.0340970f, 0.221393f, 
		0.0340970f, 0.245618f, 0.0340970f, 0.277663f, 
		0.0340970f, 0.277679f, 0.0340970f, 0.280992f, 
		0.0340970f, 0.305267f, 0.0340970f, 0.309383f, 
		0.0340970f, 0.319197f, 0.0340970f, 0.319340f, 
		0.0340970f, 0.322710f, 0.0340970f, 0.325893f, 
		0.0340970f, 0.341141f, 0.0340970f, 0.346465f, 
		0.0340970f, 0.352729f, 0.0340970f, 0.356481f, 
		0.0340970f, 0.358622f, 0.0340970f, 0.381836f, 
		0.0340970f, 0.381870f, 0.0340970f, 0.382309f, 
		0.0340970f, 0.382529f, 0.0340970f, 0.382951f, 
		0.0340970f, 0.393563f, 0.0340970f, 0.395871f, 
		0.0340970f, 0.399318f, 0.0340970f, 0.412541f, 
		0.0340970f, 0.422255f, 0.0340970f, 0.422914f, 
		0.0340970f, 0.423163f, 0.0340970f, 0.430476f, 
		0.0340970f, 0.431556f, 0.0340970f, 0.449032f, 
		0.0340970f, 0.449066f, 0.0340970f, 0.449901f, 
		0.0340970f, 0.457121f, 0.0340970f, 0.462765f, 
		0.0340970f, 0.466433f, 0.0340970f, 0.471955f, 
		0.0340970f, 0.482361f, 0.0340970f, 0.503155f, 
		0.0340970f, 0.517893f, 0.0340970f, 0.518831f, 
		0.0340970f, 0.554854f, 0.0340970f, 0.554882f, 
		0.0343585f, 0.487846f, 0.0352460f, 0.499998f, 
		0.0352460f, 0.739411f, 0.0356214f, 0.193228f, 
		0.0358110f, 0.894535f, 0.0365075f, 0.232575f, 
		0.0386000f, 0.364796f, 0.0386538f, 0.00127315f, 
		0.0387438f, 0.0526069f, 0.0397070f, 0.0153673f, 
		0.0399435f, 0.347071f, 0.0400270f, 0.0157821f, 
		0.0401131f, 0.202950f, 0.0401171f, 0.501810f, 
		0.0401730f, 0.605714f, 0.0402058f, 0.224958f, 
		0.0403382f, 0.605761f, 0.0404113f, 0.220200f, 
		0.0406866f, 0.266928f, 0.0411356f, 0.437898f, 
		0.0412282f, 0.421141f, 0.0413730f, 0.558239f, 
		0.0414423f, 0.0899778f, 0.0416527f, 0.473837f, 
		0.0416695f, 0.364275f, 0.0416695f, 0.388277f, 
		0.0417292f, 0.0443533f, 0.0417360f, 0.000000f, 
		0.0417360f, 0.499998f, 0.0417410f, 0.0443528f, 
		0.0417835f, 0.103772f, 0.0417949f, 0.133780f, 
		0.0419409f, 0.185068f, 0.0419624f, 0.0150365f, 
		0.0419658f, 0.0468395f, 0.0419843f, 0.370302f, 
		0.0420313f, 0.514552f, 0.0420426f, 0.165898f, 
		0.0420534f, 0.0469012f, 0.0420925f, 0.244779f, 
		0.0421247f, 0.435685f, 0.0422581f, 0.358960f, 
		0.0422581f, 0.366522f, 0.0424169f, 0.596215f, 
		0.0424187f, 0.596200f, 0.0424620f, 0.513880f, 
		0.0424650f, 0.521534f, 0.0426207f, 0.317820f, 
		0.0428511f, 0.137428f, 0.0429090f, 0.544793f, 
		0.0429509f, 0.267955f, 0.0430943f, 0.381775f, 
		0.0432448f, 0.0143619f, 0.0432730f, 0.000000f, 
		0.0432730f, 0.645419f, 0.0434808f, 0.174188f, 
		0.0437150f, 0.644182f, 0.0437404f, 0.513470f, 
		0.0438718f, 0.318491f, 0.0442255f, 0.432210f, 
		0.0442543f, 0.543508f, 0.0442756f, 0.106791f, 
		0.0443280f, 5.21805e-015f, 0.0443280f, 0.998535f, 
		0.0443501f, 0.551134f, 0.0446119f, 0.00220474f, 
		0.0446194f, 0.312667f, 0.0446194f, 0.319699f, 
		0.0447357f, 0.486554f, 0.0448049f, 0.252230f, 
		0.0448049f, 0.260726f, 0.0450009f, 0.486682f, 
		0.0456932f, 0.485080f, 0.0466007f, 0.511508f, 
		0.0482260f, 0.00619993f, 0.0482260f, 0.511144f, 
		0.0513190f, 0.0398889f, 0.0513190f, 0.0763409f, 
		0.0513190f, 0.0764044f, 0.0513190f, 0.142380f, 
		0.0513190f, 0.145091f, 0.0513190f, 0.286907f, 
		0.0513190f, 0.308662f, 0.0513190f, 0.309581f, 
		0.0513190f, 0.368889f, 0.0513190f, 0.369655f, 
		0.0513190f, 0.420404f, 0.0513190f, 0.525382f, 
		0.0513190f, 0.591718f, 0.0513190f, 0.591748f, 
		0.0513190f, 0.600390f, 0.0532637f, 0.516146f, 
		0.0534092f, 0.0145669f, 0.0536643f, 0.0146669f, 
		0.0539630f, 0.00269185f, 0.0541575f, 0.0140216f, 
		0.0547160f, 0.000000f, 0.0547160f, 0.517622f, 
		0.0555537f, 0.00210066f, 0.0557790f, 0.277549f, 
		0.0569809f, 0.502254f, 0.0573305f, 0.844649f, 
		0.0578453f, 0.516370f, 0.0579228f, 0.00374023f, 
		0.0580366f, 0.688159f, 0.0585452f, 0.501023f, 
		0.0588520f, 0.844622f, 0.0589721f, 0.000000f, 
		0.0593352f, 0.516076f, 0.0598150f, 0.531271f, 
		0.0598301f, 0.531264f, 0.0599460f, 0.761508f, 
		0.0599962f, 0.761390f, 0.0600097f, 0.762208f, 
		0.0600971f, 0.761873f, 0.0603177f, 0.573767f, 
		0.0604322f, 0.0437680f, 0.0606786f, 0.844614f, 
		0.0606880f, 0.573375f, 0.0611656f, 0.499998f, 
		0.0612060f, 0.0176230f, 0.0612060f, 0.499998f, 
		0.0612411f, 0.481408f, 0.0612838f, 0.164397f, 
		0.0612971f, 0.389561f, 0.0617153f, 0.163636f, 
		0.0617176f, 0.205969f, 0.0617846f, 0.272060f, 
		0.0621430f, 0.381373f, 0.0622081f, 0.248168f, 
		0.0622910f, 0.759525f, 0.0630864f, 0.488097f, 
		0.0630988f, 0.488108f, 0.0631290f, 0.0968883f, 
		0.0632817f, 0.379167f, 0.0633079f, 0.0967297f, 
		0.0633250f, 0.543181f, 0.0633478f, 0.482841f, 
		0.0634519f, 0.543265f, 0.0636072f, 0.163057f, 
		0.0636431f, 0.325121f, 0.0636660f, 0.644875f, 
		0.0636700f, 0.121861f, 0.0636700f, 0.140806f, 
		0.0636797f, 0.644894f, 0.0637533f, 0.116005f, 
		0.0637595f, 0.436764f, 0.0638717f, 0.436847f, 
		0.0641307f, 0.437037f, 0.0641629f, 0.631384f, 
		0.0643427f, 0.388360f, 0.0644000f, 0.0607240f, 
		0.0646841f, 0.164971f, 0.0646931f, 0.427779f, 
		0.0647546f, 0.165068f, 0.0648992f, 0.136552f, 
		0.0650141f, 0.131510f, 0.0650633f, 0.330648f, 
		0.0650708f, 0.596517f, 0.0650750f, 0.596535f, 
		0.0651610f, 0.131611f, 0.0651738f, 0.131619f, 
		0.0657912f, 0.678064f, 0.0658253f, 0.677994f, 
		0.0659984f, 0.831895f, 0.0661340f, 0.142056f, 
		0.0661340f, 0.151625f, 0.0668128f, 0.207547f, 
		0.0673195f, 0.137324f, 0.0673560f, 0.137178f, 
		0.0675061f, 0.136579f, 0.0677634f, 0.310362f, 
		0.0682387f, 0.762588f, 0.0683083f, 0.0723658f, 
		0.0683965f, 0.762740f, 0.0684238f, 0.831982f, 
		0.0685835f, 0.132278f, 0.0691203f, 0.832780f, 
		0.0693287f, 0.116798f, 0.0693775f, 0.998535f, 
		0.0696304f, 0.145473f, 0.0696307f, 0.116229f, 
		0.0698978f, 0.165940f, 0.0699274f, 0.168774f, 
		0.0700090f, 0.168925f, 0.0701051f, 0.118765f, 
		0.0704257f, 0.149239f, 0.0705892f, 0.152015f, 
		0.0706324f, 0.152608f, 0.0706559f, 0.124275f, 
		0.0706656f, 0.124238f, 0.0708343f, 0.122063f, 
		0.0710330f, 0.122819f, 0.0710330f, 0.145212f, 
		0.0710330f, 0.161763f, 0.0712160f, 0.0521820f, 
		0.0712160f, 0.113061f, 0.0712160f, 0.144685f, 
		0.0712160f, 0.225417f, 0.0712160f, 0.308927f, 
		0.0712160f, 0.354130f, 0.0712160f, 0.373969f, 
		0.0712160f, 0.391363f, 0.0715426f, 0.168938f, 
		0.0716900f, 0.115504f, 0.0718199f, 0.646154f, 
		0.0721627f, 0.115502f, 0.0728237f, 0.168948f, 
		0.0731619f, 0.349688f, 0.0731996f, 0.549980f, 
		0.0732084f, 0.324563f, 0.0735472f, 0.115493f, 
		0.0735563f, 0.168951f, 0.0740113f, 0.707490f, 
		0.0746452f, 0.486855f, 0.0748280f, 0.112604f, 
		0.0751030f, 0.115476f, 0.0751030f, 0.168967f, 
		0.0751269f, 0.140737f, 0.0754116f, 0.677264f, 
		0.0755230f, 0.130260f, 0.0755383f, 0.450913f, 
		0.0755639f, 0.158482f, 0.0757299f, 0.158500f, 
		0.0757940f, 0.137048f, 0.0758273f, 0.0631308f, 
		0.0759429f, 0.733263f, 0.0759499f, 0.733357f, 
		0.0759960f, 0.246527f, 0.0759960f, 0.246580f, 
		0.0759960f, 0.322570f, 0.0759960f, 0.322596f, 
		0.0760769f, 0.158530f, 0.0760920f, 0.158536f, 
		0.0761136f, 0.147732f, 0.0761207f, 0.131630f, 
		0.0761250f, 0.131500f, 0.0764220f, 0.000000f, 
		0.0764220f, 0.998535f, 0.0764804f, 0.168973f, 
		0.0765089f, 0.116352f, 0.0766009f, 0.128627f, 
		0.0766474f, 0.168969f, 0.0767537f, 0.144219f, 
		0.0768065f, 0.000000f, 0.0768065f, 0.0226867f, 
		0.0768065f, 0.175352f, 0.0768065f, 0.398050f, 
		0.0768065f, 0.740438f, 0.0768539f, 0.132742f, 
		0.0769637f, 0.127672f, 0.0770133f, 0.127531f, 
		0.0771401f, 0.209859f, 0.0772240f, 0.126980f, 
		0.0774610f, 0.337120f, 0.0775139f, 0.127982f, 
		0.0775408f, 0.240410f, 0.0775784f, 0.469567f, 
		0.0776383f, 0.0699727f, 0.0776383f, 0.503759f, 
		0.0776593f, 0.256560f, 0.0777426f, 0.174132f, 
		0.0777679f, 0.725525f, 0.0779685f, 0.137509f, 
		0.0780800f, 0.0693278f, 0.0781321f, 0.332570f, 
		0.0782661f, 0.535658f, 0.0783516f, 0.380526f, 
		0.0785921f, 0.459700f, 0.0786035f, 0.421530f, 
		0.0788090f, 0.0959415f, 0.0788278f, 0.149098f, 
		0.0789800f, 0.492892f, 0.0791719f, 0.0634194f, 
		0.0791938f, 0.00158101f, 0.0792489f, 0.141103f, 
		0.0794115f, 0.149828f, 0.0796542f, 0.612074f, 
		0.0797673f, 0.0729887f, 0.0798653f, 0.832230f, 
		0.0799138f, 0.504739f, 0.0801615f, 0.205067f, 
		0.0801851f, 0.491281f, 0.0804854f, 0.661610f, 
		0.0804888f, 0.661576f, 0.0806017f, 0.235590f, 
		0.0807032f, 0.00346807f, 0.0807137f, 0.577913f, 
		0.0808040f, 0.00299185f, 0.0808973f, 0.629093f, 
		0.0811533f, 0.0955464f, 0.0812647f, 0.417476f, 
		0.0812730f, 0.105887f, 0.0813911f, 0.139566f, 
		0.0814064f, 0.745651f, 0.0815010f, 0.00116577f, 
		0.0815010f, 0.00147303f, 0.0815010f, 0.0692393f, 
		0.0815010f, 0.0693989f, 0.0815010f, 0.138643f, 
		0.0815010f, 0.138833f, 0.0815010f, 0.201336f, 
		0.0815010f, 0.201353f, 0.0815010f, 0.276881f, 
		0.0815010f, 0.332471f, 0.0815010f, 0.338201f, 
		0.0815010f, 0.403843f, 0.0815010f, 0.413038f, 
		0.0815010f, 0.474395f, 0.0815010f, 0.474444f, 
		0.0815010f, 0.543313f, 0.0815010f, 0.543323f, 
		0.0815010f, 0.620752f, 0.0815010f, 0.620787f, 
		0.0815010f, 0.673116f, 0.0815010f, 0.740443f, 
		0.0820426f, 0.0866964f, 0.0820454f, 0.0718698f, 
		0.0822892f, 0.0980795f, 0.0823394f, 0.102893f, 
		0.0823873f, 0.600185f, 0.0824089f, 0.587128f, 
		0.0824953f, 0.0908422f, 0.0825050f, 0.102428f, 
		0.0825196f, 0.401892f, 0.0825387f, 0.0995536f, 
		0.0826705f, 0.399846f, 0.0827124f, 0.298153f, 
		0.0827696f, 0.108400f, 0.0829389f, 0.290054f, 
		0.0829660f, 0.0134819f, 0.0829660f, 0.0140418f, 
		0.0829660f, 0.111680f, 0.0829660f, 0.111705f, 
		0.0829660f, 0.134886f, 0.0829660f, 0.134899f, 
		0.0829660f, 0.144196f, 0.0829660f, 0.205298f, 
		0.0829660f, 0.224553f, 0.0829660f, 0.224576f, 
		0.0829660f, 0.291279f, 0.0829660f, 0.300729f, 
		0.0829660f, 0.306055f, 0.0829660f, 0.359244f, 
		0.0834123f, 0.193381f, 0.0837370f, 0.0663330f, 
		0.0837370f, 0.0891245f, 0.0837370f, 0.0989690f, 
		0.0841134f, 0.0846920f, 0.0848600f, 0.0735000f, 
		0.0849615f, 0.102470f, 0.0850762f, 0.0589220f, 
		0.0856786f, 0.0383541f, 0.0859377f, 0.0589148f, 
		0.0859623f, 0.248462f, 0.0859655f, 0.0589146f, 
		0.0861860f, 0.0891245f, 0.0864345f, 0.360750f, 
		0.0868681f, 0.111861f, 0.0869135f, 0.360956f, 
		0.0871982f, 0.0266170f, 0.0872042f, 0.112494f, 
		0.0874070f, 0.0187440f, 0.0874070f, 0.117929f, 
		0.0874070f, 0.187696f, 0.0874070f, 0.236406f, 
		0.0874070f, 0.307633f, 0.0874070f, 0.356447f, 
		0.0874070f, 0.427697f, 0.0876100f, 0.0589010f, 
		0.0876616f, 0.0684905f, 0.0876616f, 0.0693491f, 
		0.0876693f, 0.0683770f, 0.0876693f, 0.0693283f, 
		0.0876695f, 0.0683840f, 0.0876695f, 0.0693325f, 
		0.0877806f, 0.0262734f, 0.0882128f, 0.108976f, 
		0.0882514f, 0.0694246f, 0.0886350f, 0.105971f, 
		0.0886560f, 0.000000f, 0.0886560f, 0.998535f, 
		0.0886830f, 0.0695544f, 0.0890495f, 0.612279f, 
		0.0890511f, 0.113271f, 0.0891581f, 0.113272f, 
		0.0891912f, 0.183930f, 0.0894425f, 0.0821318f, 
		0.0894433f, 0.0821469f, 0.0896154f, 0.524954f, 
		0.0896195f, 0.524972f, 0.0896388f, 0.321121f, 
		0.0896771f, 0.141479f, 0.0897992f, 0.641331f, 
		0.0899774f, 0.00589994f, 0.0901105f, 0.212825f, 
		0.0903733f, 0.00532306f, 0.0911882f, 0.0215044f, 
		0.0911963f, 0.0215213f, 0.0914307f, 0.989850f, 
		0.0915114f, 0.113288f, 0.0916697f, 0.0310564f, 
		0.0918435f, 0.330876f, 0.0920842f, 0.440659f, 
		0.0921522f, 0.0636655f, 0.0927767f, 0.0607921f, 
		0.0928200f, 0.0961900f, 0.0928612f, 0.105942f, 
		0.0929062f, 0.105942f, 0.0929071f, 0.239874f, 
		0.0929400f, 0.0954271f, 0.0929681f, 0.0731514f, 
		0.0930010f, 0.345430f, 0.0930091f, 0.345416f, 
		0.0930219f, 0.983998f, 0.0931567f, 0.0611061f, 
		0.0931749f, 0.153390f, 0.0931768f, 0.153373f, 
		0.0932487f, 0.0958787f, 0.0935320f, 0.100492f, 
		0.0935474f, 0.0614284f, 0.0935845f, 0.100382f, 
		0.0936273f, 0.105931f, 0.0936350f, 0.100282f, 
		0.0937345f, 0.582332f, 0.0938349f, 0.112414f, 
		0.0939144f, 0.321223f, 0.0940228f, 0.0859056f, 
		0.0942486f, 0.0710747f, 0.0942533f, 0.248262f, 
		0.0942551f, 0.0710645f, 0.0947310f, 0.0872350f, 
		0.0947310f, 0.0980456f, 0.0947345f, 0.0792603f, 
		0.0947374f, 0.0793119f, 0.0947375f, 0.0793222f, 
		0.0947889f, 0.0589534f, 0.0952248f, 0.100351f, 
		0.0953172f, 0.0716285f, 0.0956264f, 0.338235f, 
		0.0959402f, 0.608959f, 0.0964120f, 0.0376005f, 
		0.0968375f, 0.246513f, 0.0974266f, 0.244573f, 
		0.0978905f, 0.854548f, 0.0978925f, 0.854535f, 
		0.0984029f, 0.742471f, 0.0984157f, 0.757201f, 
		0.0987315f, 0.000000f, 0.0988361f, 0.0472085f, 
		0.0988643f, 0.511936f, 0.0988755f, 0.0137880f, 
		0.0988976f, 0.0312749f, 0.0991437f, 0.0306483f, 
		0.0991938f, 0.710458f, 0.0993345f, 0.0402507f, 
		0.0993721f, 0.513521f, 0.0993762f, 0.513556f, 
		0.0994191f, 0.513512f, 0.0997860f, 0.759249f, 
		0.0999668f, 0.00518693f, 0.100077f, 0.00545837f, 
		0.100206f, 0.396984f, 0.100210f, 0.396964f, 
		0.100210f, 0.396983f, 0.100335f, 0.00579988f, 
		0.100547f, 0.850454f, 0.100680f, 0.0383264f, 
		0.100807f, 0.0246423f, 0.100847f, 0.0375195f, 
		0.101031f, 0.759285f, 0.101106f, 0.398269f, 
		0.101190f, 0.257421f, 0.101192f, 0.257437f, 
		0.101193f, 0.257449f, 0.101327f, 0.230559f, 
		0.101339f, 0.0250615f, 0.101339f, 0.0351630f, 
		0.101908f, 0.639269f, 0.101909f, 0.639302f, 
		0.102896f, 0.977962f, 0.103096f, 0.758827f, 
		0.103096f, 0.759819f, 0.103096f, 0.830177f, 
		0.103096f, 0.831765f, 0.103142f, 0.0450721f, 
		0.103751f, 0.0526663f, 0.104645f, 0.0444347f, 
		0.104945f, 0.0443132f, 0.105214f, 0.0568150f, 
		0.105349f, 0.00274349f, 0.105783f, 0.0605888f, 
		0.105783f, 0.129292f, 0.105783f, 0.133665f, 
		0.105783f, 0.133677f, 0.105783f, 0.685041f, 
		0.105783f, 0.892385f, 0.105821f, 0.0439400f, 
		0.105870f, 0.169520f, 0.106238f, 0.0492050f, 
		0.106639f, 0.00410828f, 0.106917f, 0.177117f, 
		0.107198f, 0.0568321f, 0.107299f, 0.00195279f, 
		0.108071f, 0.0439493f, 0.108139f, 0.0568379f, 
		0.108286f, 0.641643f, 0.108529f, 0.0568436f, 
		0.108577f, 0.00587365f, 0.108716f, 0.376151f, 
		0.108807f, 0.717738f, 0.109045f, 0.646353f, 
		0.109245f, 0.286489f, 0.109637f, 0.0471205f, 
		0.109681f, 0.0472162f, 0.109774f, 0.160199f, 
		0.109850f, 0.483285f, 0.109969f, 0.160612f, 
		0.110057f, 0.602472f, 0.110106f, 0.601501f, 
		0.110162f, 0.0206026f, 0.110198f, 0.0458870f, 
		0.110308f, 0.00192400f, 0.110308f, 0.0568590f, 
		0.110336f, 0.0460176f, 0.110380f, 0.188135f, 
		0.110478f, 0.189684f, 0.110516f, 0.216915f, 
		0.110545f, 0.0761324f, 0.110574f, 0.520966f, 
		0.110576f, 0.520929f, 0.110598f, 0.521818f, 
		0.110620f, 0.585274f, 0.110680f, 0.583676f, 
		0.110684f, 0.583759f, 0.110691f, 0.133233f, 
		0.110712f, 0.210359f, 0.110721f, 0.547296f, 
		0.110726f, 0.739618f, 0.110751f, 0.624388f, 
		0.110852f, 0.218574f, 0.110854f, 0.0464890f, 
		0.110950f, 0.499072f, 0.110981f, 0.0466092f, 
		0.110985f, 0.475000f, 0.111015f, 0.0399378f, 
		0.111022f, 0.0256540f, 0.111074f, 0.110519f, 
		0.111203f, 0.249096f, 0.111240f, 0.282294f, 
		0.111275f, 0.000000f, 0.111275f, 0.00869700f, 
		0.111275f, 0.0472438f, 0.111275f, 0.0472653f, 
		0.111275f, 0.0507731f, 0.111275f, 0.110449f, 
		0.111275f, 0.116023f, 0.111275f, 0.116035f, 
		0.111275f, 0.256561f, 0.111275f, 0.265086f, 
		0.111275f, 0.284633f, 0.111275f, 0.296854f, 
		0.111275f, 0.325625f, 0.111275f, 0.353756f, 
		0.111275f, 0.369621f, 0.111275f, 0.373969f, 
		0.111275f, 0.390570f, 0.111275f, 0.404815f, 
		0.111275f, 0.408757f, 0.111275f, 0.413105f, 
		0.111275f, 0.421472f, 0.111275f, 0.430499f, 
		0.111275f, 0.455229f, 0.111275f, 0.462747f, 
		0.111275f, 0.478070f, 0.111275f, 0.489327f, 
		0.111275f, 0.565303f, 0.111275f, 0.643020f, 
		0.111275f, 0.645666f, 0.111275f, 0.700105f, 
		0.111275f, 0.719117f, 0.111275f, 0.739242f, 
		0.111275f, 0.746170f, 0.111401f, 0.0394245f, 
		0.111401f, 0.0568594f, 0.111452f, 0.00248519f, 
		0.111666f, 0.0568656f, 0.111927f, 0.0190213f, 
		0.112020f, 0.0190802f, 0.112054f, 0.0187473f, 
		0.112284f, 0.0399630f, 0.112309f, 0.0400789f, 
		0.113174f, 0.00963150f, 0.113456f, 0.0366217f, 
		0.114014f, 0.204915f, 0.114736f, 0.199480f, 
		0.114756f, 0.199333f, 0.116368f, 0.203480f, 
		0.116560f, 0.198498f, 0.117027f, 0.186888f, 
		0.117034f, 0.217127f, 0.117235f, 0.216810f, 
		0.117240f, 0.199473f, 0.117716f, 0.228991f, 
		0.117794f, 0.217707f, 0.118257f, 0.0809634f, 
		0.118257f, 0.0809808f, 0.118257f, 0.0810175f, 
		0.118257f, 0.127972f, 0.118257f, 0.135779f, 
		0.118257f, 0.182512f, 0.118257f, 0.220607f, 
		0.118257f, 0.313493f, 0.118257f, 0.357419f, 
		0.118257f, 0.372128f, 0.118257f, 0.434414f, 
		0.118257f, 0.473021f, 0.118257f, 0.474299f, 
		0.118257f, 0.580544f, 0.118257f, 0.605342f, 
		0.118257f, 0.615474f, 0.118257f, 0.660942f, 
		0.118257f, 0.714069f, 0.118257f, 0.835983f, 
		0.118257f, 0.878211f, 0.118257f, 0.916772f, 
		0.118257f, 0.916805f, 0.118257f, 0.916840f, 
		0.118257f, 0.916867f, 0.118257f, 0.998535f, 
		0.118942f, 0.201911f, 0.118942f, 0.204541f, 
		0.118942f, 0.215476f, 0.120375f, 0.235569f, 
		0.120509f, 0.940449f, 0.120510f, 0.940498f, 
		0.120516f, 0.940513f, 0.120542f, 0.0502046f, 
		0.120559f, 0.777981f, 0.120665f, 0.866638f, 
		0.120750f, 8.88178e-015f, 0.120750f, 0.998535f, 
		0.120810f, 0.532435f, 0.120831f, 0.744807f, 
		0.121166f, 0.493240f, 0.121392f, 0.205319f, 
		0.121392f, 0.217174f, 0.121687f, 0.749199f, 
		0.122341f, 0.507496f, 0.122612f, 0.189129f, 
		0.122815f, 0.177174f, 0.122817f, 0.232655f, 
		0.122830f, 0.773348f, 0.122958f, 0.775129f, 
		0.122962f, 0.775113f, 0.122971f, 0.223070f, 
		0.123006f, 0.189231f, 0.123098f, 0.189252f, 
		0.123193f, 0.229939f, 0.123216f, 0.223984f, 
		0.123270f, 0.249700f, 0.123366f, 0.224544f, 
		0.123434f, 0.189335f, 0.123515f, 0.359327f, 
		0.123625f, 0.967292f, 0.123841f, 0.184932f, 
		0.123841f, 0.189432f, 0.123841f, 0.208728f, 
		0.123841f, 0.218872f, 0.123841f, 0.226316f, 
		0.124224f, 0.488368f, 0.124427f, 0.763475f, 
		0.124492f, 0.232667f, 0.124686f, 0.193361f, 
		0.124748f, 0.765221f, 0.124752f, 0.765208f, 
		0.124939f, 0.292908f, 0.125498f, 0.663087f, 
		0.125543f, 0.200586f, 0.125556f, 0.683445f, 
		0.125599f, 0.683416f, 0.125685f, 0.000000f, 
		0.125961f, 0.177629f, 0.125987f, 0.177634f, 
		0.126145f, 0.335522f, 0.126438f, 0.194638f, 
		0.126558f, 0.177146f, 0.126575f, 0.744707f, 
		0.126674f, 0.739541f, 0.126697f, 0.189759f, 
		0.126810f, 0.232685f, 0.126951f, 0.603632f, 
		0.127102f, 0.189800f, 0.127119f, 0.855722f, 
		0.127290f, 0.189829f, 0.127463f, 0.189845f, 
		0.127532f, 0.177858f, 0.127576f, 0.205291f, 
		0.127590f, 0.527838f, 0.127900f, 0.591533f, 
		0.127914f, 0.220136f, 0.127993f, 0.970057f, 
		0.127993f, 0.970043f, 0.127993f, 0.970058f, 
		0.128068f, 0.213196f, 0.128089f, 0.218989f, 
		0.128118f, 0.0989781f, 0.128161f, 0.283958f, 
		0.128161f, 0.499268f, 0.128161f, 0.783226f, 
		0.128169f, 0.232695f, 0.128334f, 0.211352f, 
		0.128557f, 0.178007f, 0.128624f, 0.409445f, 
		0.128963f, 0.231842f, 0.129043f, 0.206699f, 
		0.129250f, 0.216120f, 0.129764f, 0.232706f, 
		0.130133f, 0.204941f, 0.130262f, 0.221142f, 
		0.130382f, 0.219554f, 0.130439f, 0.202658f, 
		0.130590f, 0.277449f, 0.130771f, 0.00571279f, 
		0.130791f, 0.425807f, 0.131587f, 0.000000f, 
		0.132667f, 0.844152f, 0.132984f, 1.88738e-015f, 
		0.132984f, 0.998535f, 0.133380f, 0.0110253f, 
		0.133443f, 0.0109240f, 0.133514f, 0.0109721f, 
		0.133963f, 0.272331f, 0.134015f, 0.00965351f, 
		0.134021f, 0.998461f, 0.134079f, 0.758854f, 
		0.134310f, 0.00987599f, 0.134391f, 0.985555f, 
		0.134487f, 0.00987788f, 0.134607f, 0.00176818f, 
		0.134607f, 0.727395f, 0.134670f, 0.614178f, 
		0.135296f, 0.456254f, 0.135429f, 0.337575f, 
		0.135565f, 0.137752f, 0.136058f, 0.253208f, 
		0.136147f, 0.873975f, 0.136200f, 0.331804f, 
		0.136205f, 0.278511f, 0.136516f, 0.00249136f, 
		0.136580f, 0.00214238f, 0.137022f, 0.732558f, 
		0.137029f, 0.000000f, 0.137029f, 0.732558f, 
		0.137092f, 0.761509f, 0.137182f, 0.761482f, 
		0.137227f, 0.332235f, 0.137329f, 0.252057f, 
		0.137556f, 0.0138240f, 0.137864f, 0.356647f, 
		0.137880f, 0.273623f, 0.138061f, 0.555357f, 
		0.138376f, 0.979630f, 0.138385f, 0.000000f, 
		0.138393f, 0.250717f, 0.138406f, 0.996359f, 
		0.138591f, 0.333879f, 0.138683f, 0.845285f, 
		0.138773f, 0.658119f, 0.139060f, 0.0653136f, 
		0.139060f, 0.0653246f, 0.139060f, 0.0653448f, 
		0.139060f, 0.0873720f, 0.139060f, 0.133365f, 
		0.139060f, 0.133375f, 0.139060f, 0.137298f, 
		0.139060f, 0.158140f, 0.139060f, 0.174744f, 
		0.139060f, 0.199707f, 0.139060f, 0.294252f, 
		0.139060f, 0.294315f, 0.139060f, 0.324524f, 
		0.139060f, 0.337005f, 0.139060f, 0.384807f, 
		0.139060f, 0.409268f, 0.139060f, 0.430130f, 
		0.139060f, 0.430164f, 0.139060f, 0.430479f, 
		0.139060f, 0.430510f, 0.139060f, 0.449341f, 
		0.139060f, 0.555696f, 0.139060f, 0.574158f, 
		0.139060f, 0.586640f, 0.139060f, 0.604285f, 
		0.139060f, 0.604355f, 0.139060f, 0.604375f, 
		0.139060f, 0.636566f, 0.139060f, 0.659962f, 
		0.139060f, 0.674011f, 0.139060f, 0.698975f, 
		0.139060f, 0.727360f, 0.139060f, 0.727696f, 
		0.139060f, 0.795788f, 0.139060f, 0.823792f, 
		0.139060f, 0.839494f, 0.139060f, 0.839504f, 
		0.139060f, 0.848755f, 0.139060f, 0.879862f, 
		0.139060f, 0.911164f, 0.139060f, 0.923645f, 
		0.139155f, 0.363830f, 0.139208f, 0.000000f, 
		0.139208f, 0.732558f, 0.139208f, 0.180841f, 
		0.139274f, 0.984379f, 0.139319f, 0.0115731f, 
		0.139324f, 0.998475f, 0.139379f, 0.984451f, 
		0.139394f, 0.984432f, 0.139407f, 0.845285f, 
		0.139659f, 0.0118308f, 0.140159f, 0.118990f, 
		0.140164f, 0.119019f, 0.140420f, 0.103333f, 
		0.140420f, 0.323688f, 0.140420f, 0.374898f, 
		0.140420f, 0.404610f, 0.140420f, 0.611986f, 
		0.140420f, 0.698485f, 0.140420f, 0.700311f, 
		0.140473f, 0.0131675f, 0.140500f, 0.0132514f, 
		0.140733f, 0.00389072f, 0.140745f, 0.0555250f, 
		0.141012f, 0.0554642f, 0.141033f, 0.0134482f, 
		0.141042f, 0.0553637f, 0.141315f, 0.645691f, 
		0.141324f, 0.0577190f, 0.141434f, 0.0136249f, 
		0.141461f, 0.171008f, 0.141461f, 0.171020f, 
		0.141461f, 0.224944f, 0.141461f, 0.224973f, 
		0.141461f, 0.320122f, 0.141479f, 0.0136506f, 
		0.141579f, 0.998481f, 0.141620f, 0.0136953f, 
		0.141637f, 0.0137039f, 0.141950f, 0.998479f, 
		0.142134f, 0.998479f, 0.142149f, 0.998479f, 
		0.142152f, 0.200080f, 0.142323f, 0.0285227f, 
		0.142387f, 0.509829f, 0.142488f, 0.0609122f, 
		0.142800f, 0.413152f, 0.142817f, 0.414267f, 
		0.142889f, 0.336765f, 0.142926f, 0.000000f, 
		0.142926f, 0.309131f, 0.142936f, 0.140797f, 
		0.142976f, 0.992296f, 0.143007f, 0.509829f, 
		0.143086f, 0.00989418f, 0.143117f, 0.122935f, 
		0.143388f, 0.614615f, 0.143388f, 0.760346f, 
		0.143388f, 0.843656f, 0.143640f, 0.696102f, 
		0.143756f, 0.684500f, 0.144470f, 0.508105f, 
		0.144520f, 0.240997f, 0.144853f, 0.778365f, 
		0.144853f, 0.811779f, 0.144853f, 0.863285f, 
		0.144989f, 0.992149f, 0.145038f, 0.617824f, 
		0.145073f, 0.131882f, 0.145193f, 0.129801f, 
		0.145927f, 0.0481157f, 0.146084f, 0.210854f, 
		0.146586f, 0.778365f, 0.146593f, 0.778108f, 
		0.146640f, 0.204773f, 0.147077f, 0.00475016f, 
		0.147185f, 0.0704698f, 0.147583f, 0.617631f, 
		0.147643f, 0.0638862f, 0.147660f, 0.617859f, 
		0.147661f, 0.778365f, 0.147662f, 0.617860f, 
		0.147787f, 0.811763f, 0.148056f, 0.213005f, 
		0.148118f, 0.0146878f, 0.148425f, 0.102290f, 
		0.148467f, 0.965920f, 0.148640f, 0.152782f, 
		0.148723f, 0.198605f, 0.148807f, 0.965225f, 
		0.148900f, 0.0694577f, 0.148941f, 0.142201f, 
		0.149132f, 0.0643838f, 0.149224f, 0.000000f, 
		0.149224f, 0.0336788f, 0.149224f, 0.0364011f, 
		0.149224f, 0.0678183f, 0.149224f, 0.0691080f, 
		0.149224f, 0.114861f, 0.149224f, 0.120954f, 
		0.149224f, 0.135571f, 0.149224f, 0.155904f, 
		0.149224f, 0.204197f, 0.149224f, 0.211818f, 
		0.149224f, 0.225293f, 0.149224f, 0.242289f, 
		0.149224f, 0.272958f, 0.149224f, 0.358415f, 
		0.149224f, 0.370470f, 0.149224f, 0.381954f, 
		0.149224f, 0.433877f, 0.149224f, 0.441881f, 
		0.149224f, 0.462447f, 0.149224f, 0.465703f, 
		0.149224f, 0.466226f, 0.149224f, 0.547641f, 
		0.149224f, 0.615997f, 0.149224f, 0.637724f, 
		0.149224f, 0.667725f, 0.149224f, 0.693459f, 
		0.149224f, 0.702134f, 0.149224f, 0.706832f, 
		0.149269f, 0.479871f, 0.149656f, 0.178427f, 
		0.149656f, 0.210507f, 0.149838f, 0.985803f, 
		0.150321f, 0.460135f, 0.150445f, 0.348984f, 
		0.150649f, 0.640094f, 0.150676f, 0.445168f, 
		0.150728f, 0.342101f, 0.150948f, 0.525294f, 
		0.150951f, 0.00565722f, 0.150991f, 0.313904f, 
		0.151101f, 0.813170f, 0.151121f, 0.000000f, 
		0.151121f, 0.0122048f, 0.151121f, 0.136948f, 
		0.151124f, 0.145109f, 0.151232f, 0.144978f, 
		0.151257f, 0.254776f, 0.151431f, 0.641020f, 
		0.151434f, 0.183014f, 0.151450f, 0.494040f, 
		0.151608f, 0.144404f, 0.151704f, 0.271629f, 
		0.151920f, 0.213400f, 0.151947f, 0.106796f, 
		0.151964f, 0.892022f, 0.152030f, 0.496745f, 
		0.152046f, 0.662975f, 0.152049f, 0.431391f, 
		0.152054f, 0.812986f, 0.152172f, 0.568292f, 
		0.152179f, 0.576901f, 0.152187f, 0.662923f, 
		0.152264f, 0.139676f, 0.152334f, 0.562130f, 
		0.152353f, 0.584504f, 0.152355f, 0.0131171f, 
		0.152355f, 0.694369f, 0.152393f, 0.684609f, 
		0.152463f, 0.132071f, 0.152473f, 0.346981f, 
		0.152479f, 0.345261f, 0.152530f, 0.106093f, 
		0.152974f, 0.300577f, 0.153024f, 0.253934f, 
		0.153057f, 0.344985f, 0.153075f, 0.647541f, 
		0.153169f, 0.305034f, 0.153295f, 0.106157f, 
		0.153296f, 0.370013f, 0.153393f, 0.301615f, 
		0.153425f, 0.238355f, 0.153449f, 0.622391f, 
		0.153464f, 0.625231f, 0.153518f, 0.131002f, 
		0.153635f, 0.241888f, 0.153703f, 0.366005f, 
		0.153787f, 0.367384f, 0.153834f, 0.678629f, 
		0.153836f, 0.436309f, 0.153988f, 0.678708f, 
		0.154070f, 0.360032f, 0.154198f, 0.128186f, 
		0.154286f, 0.659786f, 0.154457f, 0.204123f, 
		0.154488f, 0.642006f, 0.154535f, 0.188836f, 
		0.154707f, 0.422685f, 0.154753f, 0.526627f, 
		0.154761f, 0.846949f, 0.154810f, 0.367099f, 
		0.154845f, 0.380749f, 0.154878f, 0.526832f, 
		0.155106f, 0.262847f, 0.155242f, 0.643158f, 
		0.155400f, 0.264313f, 0.155420f, 0.188511f, 
		0.155474f, 0.167917f, 0.155532f, 0.112894f, 
		0.155572f, 0.676005f, 0.155613f, 0.0107733f, 
		0.155661f, 0.534566f, 0.155670f, 0.375310f, 
		0.155740f, 0.677448f, 0.155756f, 0.468662f, 
		0.155771f, 0.112021f, 0.155842f, 0.642984f, 
		0.155895f, 0.305463f, 0.155975f, 0.125388f, 
		0.156080f, 0.279894f, 0.156117f, 0.534752f, 
		0.156139f, 0.139843f, 0.156141f, 0.139830f, 
		0.156153f, 0.107031f, 0.156217f, 0.557704f, 
		0.156322f, 0.782012f, 0.156442f, 0.125349f, 
		0.156464f, 0.932140f, 0.156530f, 0.812877f, 
		0.156532f, 0.312247f, 0.156572f, 0.189988f, 
		0.156737f, 0.00842629f, 0.156741f, 0.605919f, 
		0.156746f, 0.433596f, 0.156761f, 0.689062f, 
		0.156953f, 0.634605f, 0.156966f, 0.496569f, 
		0.157248f, 0.931583f, 0.157294f, 0.931547f, 
		0.157348f, 0.497970f, 0.157766f, 0.309843f, 
		0.157779f, 0.497089f, 0.157821f, 0.730183f, 
		0.158060f, 0.178151f, 0.158083f, 0.851808f, 
		0.158090f, 0.340536f, 0.158335f, 0.179420f, 
		0.158512f, 0.852000f, 0.158576f, 0.801183f, 
		0.158652f, 0.801755f, 0.158834f, 0.260532f, 
		0.158861f, 0.449997f, 0.158883f, 0.262473f, 
		0.159028f, 0.852184f, 0.159143f, 0.256639f, 
		0.159207f, 0.473316f, 0.159477f, 0.000000f, 
		0.159477f, 0.0160486f, 0.159477f, 0.0658947f, 
		0.159477f, 0.0766709f, 0.159477f, 0.119927f, 
		0.159477f, 0.128797f, 0.159477f, 0.183410f, 
		0.159477f, 0.194098f, 0.159477f, 0.240823f, 
		0.159477f, 0.279461f, 0.159477f, 0.336139f, 
		0.159477f, 0.362989f, 0.159477f, 0.366569f, 
		0.159477f, 0.448471f, 0.159477f, 0.464840f, 
		0.159477f, 0.492701f, 0.159477f, 0.531884f, 
		0.159477f, 0.559181f, 0.159477f, 0.595620f, 
		0.159477f, 0.596280f, 0.159477f, 0.671884f, 
		0.159477f, 0.689675f, 0.159477f, 0.718607f, 
		0.159477f, 0.735180f, 0.159477f, 0.785857f, 
		0.159477f, 0.789965f, 0.159477f, 0.843713f, 
		0.159477f, 0.851658f, 0.159477f, 0.880966f, 
		0.159477f, 0.902755f, 0.159477f, 0.974024f, 
		0.159477f, 0.981241f, 0.159714f, 0.104913f, 
		0.159714f, 0.105324f, 0.159714f, 0.124817f, 
		0.159714f, 0.186895f, 0.159714f, 0.186908f, 
		0.159714f, 0.230911f, 0.159714f, 0.312150f, 
		0.159714f, 0.461823f, 0.159714f, 0.498713f, 
		0.159714f, 0.498897f, 0.159714f, 0.517990f, 
		0.159714f, 0.604201f, 0.159714f, 0.628035f, 
		0.159714f, 0.686157f, 0.159714f, 0.686211f, 
		0.159714f, 0.719867f, 0.159714f, 0.759501f, 
		0.159714f, 0.789101f, 0.159714f, 0.789137f, 
		0.159714f, 0.811416f, 0.159714f, 0.811485f, 
		0.159714f, 0.852209f, 0.159714f, 0.852333f, 
		0.159714f, 0.873718f, 0.159714f, 0.929938f, 
		0.159714f, 0.931974f, 0.159714f, 0.939635f, 
		0.159714f, 0.961090f, 0.160427f, 0.361037f, 
		0.161893f, 0.376460f, 0.161982f, 0.423990f, 
		0.162476f, 0.580856f, 0.164008f, 0.0573129f, 
		0.164432f, 0.548005f, 0.165078f, 8.27116e-015f, 
		0.165078f, 0.998535f, 0.165695f, 0.603638f, 
		0.166201f, 0.518859f, 0.167028f, 0.000000f, 
		0.167028f, 0.704152f, 0.167398f, 0.0200015f, 
		0.167398f, 0.645068f, 0.167399f, 0.0200023f, 
		0.167399f, 0.645068f, 0.167715f, 0.491690f, 
		0.167962f, 0.00281486f, 0.168284f, 0.0113134f, 
		0.168940f, 0.181368f, 0.169158f, 0.304244f, 
		0.169274f, 0.104789f, 0.169276f, 0.104810f, 
		0.169869f, 0.991433f, 0.169886f, 0.164315f, 
		0.170428f, 0.399120f, 0.170476f, 0.998535f, 
		0.170590f, 0.175356f, 0.171193f, 0.141003f, 
		0.171202f, 0.605408f, 0.171322f, 0.291826f, 
		0.171396f, 0.545650f, 0.171562f, 0.262067f, 
		0.171897f, 0.235467f, 0.171903f, 0.235490f, 
		0.172125f, 0.298207f, 0.172329f, 0.503567f, 
		0.172332f, 0.519466f, 0.172531f, 0.000000f, 
		0.172660f, 0.0651769f, 0.172687f, 0.317347f, 
		0.173188f, 0.471298f, 0.173616f, 0.334721f, 
		0.173938f, 0.517897f, 0.174792f, 0.356594f, 
		0.175211f, 0.000000f, 0.175211f, 0.00206713f, 
		0.175211f, 0.0483330f, 0.175211f, 0.0493140f, 
		0.175211f, 0.0566750f, 0.175211f, 0.0568913f, 
		0.175211f, 0.0674943f, 0.175211f, 0.0860010f, 
		0.175211f, 0.114359f, 0.175211f, 0.131818f, 
		0.175211f, 0.132335f, 0.175211f, 0.141841f, 
		0.175211f, 0.149276f, 0.175211f, 0.163247f, 
		0.175211f, 0.166969f, 0.175211f, 0.173556f, 
		0.175211f, 0.202120f, 0.175211f, 0.203860f, 
		0.175211f, 0.215302f, 0.175211f, 0.227316f, 
		0.175211f, 0.227459f, 0.175211f, 0.258378f, 
		0.175211f, 0.272423f, 0.175211f, 0.312819f, 
		0.175211f, 0.342726f, 0.175211f, 0.379867f, 
		0.175211f, 0.394194f, 0.175211f, 0.400404f, 
		0.175211f, 0.460921f, 0.175211f, 0.461361f, 
		0.175211f, 0.467477f, 0.175211f, 0.472705f, 
		0.175211f, 0.496466f, 0.175211f, 0.500906f, 
		0.175211f, 0.514944f, 0.175211f, 0.582213f, 
		0.175211f, 0.586146f, 0.175211f, 0.612772f, 
		0.175211f, 0.641511f, 0.175211f, 0.648716f, 
		0.175211f, 0.653827f, 0.175211f, 0.657801f, 
		0.175211f, 0.689844f, 0.175211f, 0.706832f, 
		0.175317f, 0.378761f, 0.175394f, 0.148440f, 
		0.175570f, 0.634506f, 0.175840f, 0.00980046f, 
		0.175973f, 0.375724f, 0.176114f, 0.630516f, 
		0.176219f, 0.0927315f, 0.176347f, 0.311168f, 
		0.176424f, 0.311209f, 0.176441f, 0.311222f, 
		0.176481f, 0.311246f, 0.176972f, 0.125929f, 
		0.177148f, 0.0152752f, 0.177148f, 0.141506f, 
		0.177148f, 0.300032f, 0.177311f, 7.27196e-015f, 
		0.177311f, 0.998535f, 0.177365f, 0.383994f, 
		0.177444f, 0.000000f, 0.177444f, 0.00659087f, 
		0.177444f, 0.755753f, 0.177586f, 0.240444f, 
		0.177632f, 0.535985f, 0.177653f, 0.109863f, 
		0.177742f, 0.231390f, 0.177750f, 0.240410f, 
		0.177869f, 0.230548f, 0.178133f, 0.00776200f, 
		0.178133f, 0.0105467f, 0.178133f, 0.170767f, 
		0.178133f, 0.208708f, 0.178133f, 0.258587f, 
		0.178133f, 0.320660f, 0.178133f, 0.378135f, 
		0.178133f, 0.423355f, 0.178133f, 0.423384f, 
		0.178133f, 0.461607f, 0.178133f, 0.462009f, 
		0.178133f, 0.481428f, 0.178133f, 0.481791f, 
		0.178133f, 0.588843f, 0.178133f, 0.619084f, 
		0.178695f, 0.399209f, 0.179228f, 0.219776f, 
		0.179373f, 0.375155f, 0.179582f, 0.637759f, 
		0.179598f, 0.0508930f, 0.179598f, 0.145708f, 
		0.179598f, 0.228357f, 0.179598f, 0.287527f, 
		0.179598f, 0.428941f, 0.179598f, 0.428960f, 
		0.179598f, 0.501369f, 0.179598f, 0.503637f, 
		0.179598f, 0.665752f, 0.179598f, 0.678569f, 
		0.179648f, 0.127813f, 0.179678f, 0.755753f, 
		0.179706f, 0.637652f, 0.179849f, 0.0503749f, 
		0.179875f, 0.149753f, 0.179911f, 0.372367f, 
		0.179954f, 0.345962f, 0.180049f, 0.225826f, 
		0.180108f, 0.166834f, 0.180250f, 0.692063f, 
		0.180294f, 0.632625f, 0.180384f, 0.578638f, 
		0.180605f, 0.00476435f, 0.180605f, 0.00635247f, 
		0.180655f, 0.749056f, 0.180713f, 0.143430f, 
		0.180713f, 0.153205f, 0.180726f, 0.00538529f, 
		0.180726f, 0.00718039f, 0.180895f, 0.522778f, 
		0.181003f, 0.238374f, 0.181021f, 0.682976f, 
		0.181122f, 0.0706361f, 0.181193f, 0.298126f, 
		0.181247f, 0.537560f, 0.181300f, 0.457798f, 
		0.181324f, 0.690063f, 0.181372f, 0.580100f, 
		0.181404f, 0.384547f, 0.181416f, 0.615503f, 
		0.181432f, 0.138909f, 0.181432f, 0.162292f, 
		0.181528f, 0.0943347f, 0.181541f, 0.475020f, 
		0.181557f, 0.227110f, 0.181561f, 0.689562f, 
		0.181571f, 0.273343f, 0.181649f, 0.533719f, 
		0.181916f, 0.292684f, 0.182043f, 0.605836f, 
		0.182106f, 0.619029f, 0.182131f, 0.738944f, 
		0.182158f, 0.738758f, 0.182169f, 0.0931476f, 
		0.182178f, 0.520737f, 0.182192f, 0.000000f, 
		0.182192f, 0.739729f, 0.182253f, 0.233148f, 
		0.182256f, 0.233162f, 0.182257f, 0.233152f, 
		0.182328f, 0.603723f, 0.182376f, 0.286335f, 
		0.182381f, 0.379626f, 0.182388f, 0.521321f, 
		0.182623f, 0.379607f, 0.182708f, 0.0686040f, 
		0.182756f, 0.460103f, 0.182758f, 0.0998899f, 
		0.182793f, 0.610252f, 0.182924f, 0.0222466f, 
		0.182924f, 0.755753f, 0.182958f, 0.0691530f, 
		0.182983f, 0.162175f, 0.182998f, 0.162915f, 
		0.183024f, 0.302662f, 0.183120f, 0.460641f, 
		0.183288f, 0.348237f, 0.183305f, 0.405944f, 
		0.183305f, 0.423959f, 0.183662f, 0.330640f, 
		0.183883f, 0.0786236f, 0.184431f, 0.322879f, 
		0.184468f, 0.385370f, 0.184638f, 0.863495f, 
		0.185109f, 0.0777326f, 0.185192f, 0.000000f, 
		0.185192f, 0.0263635f, 0.185192f, 0.0566810f, 
		0.185192f, 0.0647360f, 0.185192f, 0.0738893f, 
		0.185192f, 0.0789293f, 0.185192f, 0.0971045f, 
		0.185192f, 0.170197f, 0.185192f, 0.181416f, 
		0.185192f, 0.181428f, 0.185192f, 0.218331f, 
		0.185192f, 0.226462f, 0.185192f, 0.226478f, 
		0.185192f, 0.248156f, 0.185192f, 0.285826f, 
		0.185192f, 0.286158f, 0.185192f, 0.302205f, 
		0.185192f, 0.358379f, 0.185192f, 0.358485f, 
		0.185192f, 0.377877f, 0.185192f, 0.396745f, 
		0.185192f, 0.463907f, 0.185192f, 0.463943f, 
		0.185192f, 0.472464f, 0.185192f, 0.529315f, 
		0.185192f, 0.571041f, 0.185192f, 0.571064f, 
		0.185192f, 0.571080f, 0.185192f, 0.585544f, 
		0.185192f, 0.588784f, 0.185192f, 0.679731f, 
		0.185192f, 0.681862f, 0.185192f, 0.681891f, 
		0.185192f, 0.699072f, 0.185192f, 0.703026f, 
		0.185192f, 0.727413f, 0.185192f, 0.766046f, 
		0.185192f, 0.830781f, 0.185192f, 0.844405f, 
		0.185192f, 0.849413f, 0.185192f, 0.849697f, 
		0.185192f, 0.849779f, 0.185192f, 0.863150f, 
		0.185192f, 0.879334f, 0.186433f, 0.195100f, 
		0.186434f, 0.195085f, 0.187124f, 0.533975f, 
		0.187544f, 0.384465f, 0.187653f, 0.480514f, 
		0.187660f, 0.467405f, 0.187784f, 0.000000f, 
		0.187791f, 0.467242f, 0.188348f, 0.0870509f, 
		0.188348f, 0.100408f, 0.188468f, 0.0911516f, 
		0.188468f, 0.100865f, 0.188468f, 0.100879f, 
		0.188468f, 0.239737f, 0.188468f, 0.254087f, 
		0.188468f, 0.254099f, 0.188468f, 0.282724f, 
		0.188468f, 0.282756f, 0.188468f, 0.316263f, 
		0.188468f, 0.340130f, 0.188468f, 0.443625f, 
		0.188468f, 0.443647f, 0.188468f, 0.626187f, 
		0.188468f, 0.659218f, 0.188468f, 0.671670f, 
		0.188468f, 0.671863f, 0.188468f, 0.680994f, 
		0.188555f, 0.561438f, 0.188692f, 0.466847f, 
		0.188699f, 0.634232f, 0.188763f, 0.649567f, 
		0.188794f, 0.634163f, 0.188802f, 0.634177f, 
		0.188880f, 0.287711f, 0.189089f, 0.0748702f, 
		0.189126f, 0.133898f, 0.189134f, 0.366038f, 
		0.189266f, 0.145354f, 0.189267f, 0.145371f, 
		0.189414f, 0.157765f, 0.189735f, 0.511647f, 
		0.189920f, 0.0653403f, 0.189995f, 0.606310f, 
		0.190034f, 0.0149385f, 0.190034f, 0.0390362f, 
		0.190034f, 0.0458797f, 0.190034f, 0.0531859f, 
		0.190034f, 0.0545606f, 0.190034f, 0.0556248f, 
		0.190034f, 0.0564447f, 0.190034f, 0.0603567f, 
		0.190034f, 0.0630721f, 0.190034f, 0.0722247f, 
		0.190034f, 0.0857397f, 0.190034f, 0.103917f, 
		0.190034f, 0.104846f, 0.190034f, 0.111051f, 
		0.190034f, 0.111122f, 0.190034f, 0.143106f, 
		0.190034f, 0.154497f, 0.190034f, 0.167661f, 
		0.190034f, 0.172113f, 0.190034f, 0.183623f, 
		0.190034f, 0.214071f, 0.190034f, 0.246240f, 
		0.190034f, 0.248349f, 0.190034f, 0.256883f, 
		0.190034f, 0.259223f, 0.190034f, 0.278010f, 
		0.190034f, 0.298869f, 0.190034f, 0.299990f, 
		0.190034f, 0.318363f, 0.190034f, 0.318456f, 
		0.190034f, 0.333089f, 0.190034f, 0.342177f, 
		0.190034f, 0.342473f, 0.190034f, 0.357036f, 
		0.190034f, 0.394406f, 0.190034f, 0.429955f, 
		0.190034f, 0.438707f, 0.190034f, 0.448531f, 
		0.190034f, 0.449053f, 0.190034f, 0.456567f, 
		0.190034f, 0.457350f, 0.190034f, 0.492214f, 
		0.190034f, 0.494715f, 0.190034f, 0.494866f, 
		0.190034f, 0.536430f, 0.190034f, 0.623278f, 
		0.190034f, 0.623344f, 0.190034f, 0.623839f, 
		0.190034f, 0.626688f, 0.190034f, 0.628372f, 
		0.190034f, 0.629184f, 0.190034f, 0.629205f, 
		0.190034f, 0.648769f, 0.190034f, 0.649816f, 
		0.190034f, 0.687787f, 0.190034f, 0.687797f, 
		0.190034f, 0.692379f, 0.190034f, 0.731977f, 
		0.190034f, 0.755194f, 0.190034f, 0.757461f, 
		0.190034f, 0.758399f, 0.190034f, 0.776792f, 
		0.190064f, 0.377055f, 0.190144f, 0.224607f, 
		0.190497f, 0.000000f, 0.190497f, 0.927886f, 
		0.190607f, 0.216803f, 0.190607f, 0.216815f, 
		0.190742f, 0.000000f, 0.190742f, 0.925676f, 
		0.190743f, 0.000000f, 0.190743f, 0.925678f, 
		0.190745f, 0.000000f, 0.190745f, 0.925684f, 
		0.190854f, 0.230026f, 0.190890f, 0.0951723f, 
		0.190890f, 0.103058f, 0.190906f, 0.623112f, 
		0.190935f, 0.475107f, 0.190998f, 0.531272f, 
		0.191121f, 0.716646f, 0.191396f, 0.0655290f, 
		0.191439f, 0.367203f, 0.191620f, 0.000000f, 
		0.191620f, 0.927886f, 0.191656f, 0.862324f, 
		0.191716f, 0.862317f, 0.191747f, 0.561797f, 
		0.191785f, 0.665568f, 0.191851f, 0.172369f, 
		0.191920f, 0.674807f, 0.192009f, 0.408689f, 
		0.192015f, 0.674895f, 0.192022f, 0.674859f, 
		0.192148f, 0.862262f, 0.192167f, 0.769988f, 
		0.192200f, 0.000000f, 0.192200f, 0.0125378f, 
		0.192200f, 0.0138461f, 0.192200f, 0.0147015f, 
		0.192200f, 0.422630f, 0.192200f, 0.436464f, 
		0.192202f, 0.727117f, 0.192231f, 0.572218f, 
		0.192245f, 0.329890f, 0.192263f, 0.291395f, 
		0.192303f, 0.440032f, 0.192303f, 0.459140f, 
		0.192399f, 0.290993f, 0.192419f, 0.862227f, 
		0.192444f, 0.356420f, 0.192493f, 0.485614f, 
		0.192555f, 0.863532f, 0.192569f, 0.572263f, 
		0.192569f, 0.572281f, 0.192633f, 0.171322f, 
		0.192651f, 0.572310f, 0.192665f, 0.171283f, 
		0.192802f, 0.472389f, 0.192856f, 0.399081f, 
		0.192860f, 0.399071f, 0.192903f, 0.0409292f, 
		0.192906f, 0.0411632f, 0.192945f, 0.0376305f, 
		0.192948f, 0.482434f, 0.192962f, 0.0374279f, 
		0.192977f, 0.480148f, 0.193166f, 0.774991f, 
		0.193238f, 0.775059f, 0.193271f, 0.492056f, 
		0.193287f, 0.775254f, 0.193453f, 0.150312f, 
		0.193458f, 0.863535f, 0.193463f, 0.150325f, 
		0.193474f, 0.630850f, 0.193567f, 0.625807f, 
		0.193582f, 0.673016f, 0.193589f, 0.515504f, 
		0.193601f, 0.0232926f, 0.193652f, 0.672901f, 
		0.193665f, 0.0160687f, 0.193665f, 0.0192825f, 
		0.193665f, 0.0502769f, 0.193665f, 0.0638686f, 
		0.193665f, 0.0655755f, 0.193665f, 0.494924f, 
		0.193678f, 0.0243944f, 0.194136f, 0.0151388f, 
		0.194136f, 0.545812f, 0.194310f, 0.487709f, 
		0.194487f, 0.0917806f, 0.194608f, 0.467610f, 
		0.194613f, 0.467581f, 0.194871f, 0.245523f, 
		0.195209f, 0.420461f, 0.195329f, 0.483692f, 
		0.195385f, 0.0131778f, 0.195385f, 0.756723f, 
		0.195432f, 0.475107f, 0.195494f, 0.376032f, 
		0.195547f, 0.125947f, 0.195555f, 0.125935f, 
		0.195564f, 0.125946f, 0.195676f, 0.557977f, 
		0.195692f, 0.0130769f, 0.195692f, 0.757027f, 
		0.195723f, 0.332800f, 0.195820f, 0.00708797f, 
		0.195820f, 0.545579f, 0.195863f, 0.557951f, 
		0.196010f, 0.0455025f, 0.196015f, 0.405377f, 
		0.196239f, 0.469885f, 0.196298f, 0.367417f, 
		0.196312f, 0.367423f, 0.196438f, 0.366376f, 
		0.196447f, 0.770512f, 0.196749f, 0.445621f, 
		0.196896f, 0.354984f, 0.197257f, 0.0143634f, 
		0.197257f, 0.0143779f, 0.197257f, 0.0151300f, 
		0.197257f, 0.0527862f, 0.197257f, 0.0528158f, 
		0.197257f, 0.0552623f, 0.197257f, 0.0744196f, 
		0.197257f, 0.0823197f, 0.197257f, 0.0833856f, 
		0.197257f, 0.100281f, 0.197257f, 0.102049f, 
		0.197257f, 0.109711f, 0.197257f, 0.109731f, 
		0.197257f, 0.121509f, 0.197257f, 0.145422f, 
		0.197257f, 0.165025f, 0.197257f, 0.174510f, 
		0.197257f, 0.186158f, 0.197257f, 0.188279f, 
		0.197257f, 0.188294f, 0.197257f, 0.188309f, 
		0.197257f, 0.203454f, 0.197257f, 0.224540f, 
		0.197257f, 0.254731f, 0.197257f, 0.276645f, 
		0.197257f, 0.277381f, 0.197257f, 0.281783f, 
		0.197257f, 0.300586f, 0.197257f, 0.321943f, 
		0.197257f, 0.342434f, 0.197257f, 0.361108f, 
		0.197257f, 0.364922f, 0.197257f, 0.370410f, 
		0.197257f, 0.399378f, 0.197257f, 0.428829f, 
		0.197257f, 0.452897f, 0.197257f, 0.474422f, 
		0.197257f, 0.474990f, 0.197257f, 0.483781f, 
		0.197257f, 0.505924f, 0.197257f, 0.509553f, 
		0.197257f, 0.549537f, 0.197257f, 0.575821f, 
		0.197257f, 0.603679f, 0.197257f, 0.613177f, 
		0.197257f, 0.635606f, 0.197257f, 0.673041f, 
		0.197257f, 0.673061f, 0.197257f, 0.693567f, 
		0.197257f, 0.694230f, 0.197257f, 0.694252f, 
		0.197257f, 0.697201f, 0.197257f, 0.707747f, 
		0.197257f, 0.718254f, 0.197257f, 0.793656f, 
		0.197257f, 0.794769f, 0.197257f, 0.809244f, 
		0.197257f, 0.833977f, 0.197257f, 0.855549f, 
		0.197257f, 0.857373f, 0.197257f, 0.861609f, 
		0.197257f, 0.872023f, 0.197257f, 0.872046f, 
		0.197257f, 0.872070f, 0.197434f, 0.218479f, 
		0.197539f, 0.00759200f, 0.197733f, 0.238975f, 
		0.197834f, 0.212246f, 0.197847f, 0.211017f, 
		0.197897f, 0.234655f, 0.197897f, 0.234645f, 
		0.197922f, 0.188897f, 0.197937f, 0.188891f, 
		0.197959f, 0.297798f, 0.197961f, 0.297787f, 
		0.198189f, 0.469481f, 0.198568f, 0.578204f, 
		0.198691f, 0.158627f, 0.198720f, 0.578466f, 
		0.198726f, 0.156523f, 0.198753f, 0.00601970f, 
		0.199067f, 0.722878f, 0.199250f, 0.531166f, 
		0.199870f, 0.670106f, 0.199995f, 0.0116664f, 
		0.200079f, 0.156170f, 0.200239f, 0.0586569f, 
		0.200342f, 0.486665f, 0.200406f, 0.466848f, 
		0.200460f, 0.483005f, 0.200645f, 0.470570f, 
		0.200802f, 0.474168f, 0.200841f, 0.612163f, 
		0.201235f, 0.174375f, 0.201301f, 0.582780f, 
		0.201304f, 0.582798f, 0.201467f, 0.476282f, 
		0.201733f, 0.479757f, 0.201801f, 0.507794f, 
		0.201937f, 0.355616f, 0.202164f, 0.863574f, 
		0.202255f, 0.383195f, 0.202383f, 0.759541f, 
		0.202540f, 0.493079f, 0.202639f, 0.491908f, 
		0.202730f, 0.718921f, 0.203042f, 0.351634f, 
		0.203692f, 0.538588f, 0.205022f, 0.492593f, 
		0.205320f, 0.00383421f, 0.205969f, 0.478221f, 
		0.205994f, 0.112378f, 0.206024f, 0.466848f, 
		0.206026f, 0.469058f, 0.206030f, 0.475488f, 
		0.206032f, 0.478625f, 0.206140f, 0.112204f, 
		0.206578f, 0.716366f, 0.206600f, 0.290156f, 
		0.206605f, 0.290143f, 0.206848f, 0.345314f, 
		0.206860f, 0.345334f, 0.206921f, 0.483631f, 
		0.206923f, 0.395567f, 0.206930f, 0.395553f, 
		0.206980f, 0.716918f, 0.207242f, 0.0398580f, 
		0.207313f, 0.0374110f, 0.207960f, 0.429259f, 
		0.208174f, 0.403307f, 0.208177f, 0.403369f, 
		0.208311f, 0.727098f, 0.208333f, 0.477677f, 
		0.208491f, 0.181976f, 0.208507f, 0.181976f, 
		0.208509f, 0.0768175f, 0.208511f, 0.181976f, 
		0.208517f, 0.0768175f, 0.208545f, 0.530618f, 
		0.208611f, 0.156191f, 0.208922f, 0.0972616f, 
		0.209075f, 0.176424f, 0.209115f, 0.150131f, 
		0.209142f, 0.108305f, 0.209193f, 0.000000f, 
		0.209195f, 0.0566284f, 0.209454f, 0.0489547f, 
		0.209662f, 0.0428243f, 0.209683f, 0.0421995f, 
		0.209792f, 0.516742f, 0.209810f, 0.329325f, 
		0.209951f, 0.0340834f, 0.210027f, 0.619434f, 
		0.210374f, 0.451094f, 0.210438f, 0.128857f, 
		0.210471f, 0.128998f, 0.211009f, 0.472521f, 
		0.211386f, 0.101149f, 0.211446f, 0.0187548f, 
		0.211506f, 0.215011f, 0.211506f, 0.248702f, 
		0.211506f, 0.424080f, 0.211572f, 0.982500f, 
		0.211710f, 0.0191255f, 0.211895f, 0.981876f, 
		0.212016f, 0.0590322f, 0.212031f, 0.396588f, 
		0.212169f, 0.469353f, 0.212538f, 0.0909234f, 
		0.212539f, 0.396693f, 0.212539f, 0.0909288f, 
		0.212543f, 0.0909556f, 0.212885f, 0.467424f, 
		0.212907f, 0.727172f, 0.212936f, 0.114292f, 
		0.212953f, 0.863624f, 0.213027f, 0.114436f, 
		0.213979f, 0.475019f, 0.213995f, 0.474981f, 
		0.214146f, 0.538790f, 0.214147f, 0.0466489f, 
		0.214147f, 0.538793f, 0.214168f, 0.505051f, 
		0.214330f, 0.0461659f, 0.214439f, 0.000000f, 
		0.214439f, 0.998535f, 0.214504f, 0.121871f, 
		0.214883f, 0.156495f, 0.214900f, 0.338954f, 
		0.215029f, 0.502440f, 0.215146f, 0.00667550f, 
		0.215146f, 0.762991f, 0.215431f, 0.414725f, 
		0.215592f, 0.0388938f, 0.215696f, 0.0389718f, 
		0.215882f, 0.00384081f, 0.215925f, 0.0391667f, 
		0.216010f, 0.00390302f, 0.216026f, 0.149869f, 
		0.216354f, 0.111764f, 0.216554f, 0.448215f, 
		0.216609f, 0.543689f, 0.216624f, 0.155293f, 
		0.216757f, 0.149770f, 0.216841f, 0.000000f, 
		0.216921f, 0.577151f, 0.217050f, 0.610646f, 
		0.217115f, 0.000000f, 0.217115f, 0.0222228f, 
		0.217115f, 0.0895861f, 0.217115f, 0.138228f, 
		0.217115f, 0.138347f, 0.217115f, 0.157637f, 
		0.217115f, 0.192903f, 0.217115f, 0.263500f, 
		0.217115f, 0.265808f, 0.217115f, 0.278725f, 
		0.217115f, 0.278957f, 0.217115f, 0.356297f, 
		0.217115f, 0.357262f, 0.217115f, 0.387714f, 
		0.217115f, 0.404133f, 0.217115f, 0.446831f, 
		0.217115f, 0.449572f, 0.217115f, 0.488698f, 
		0.217115f, 0.505882f, 0.217115f, 0.526995f, 
		0.217115f, 0.544475f, 0.217115f, 0.597802f, 
		0.217115f, 0.605881f, 0.217115f, 0.650124f, 
		0.217115f, 0.658951f, 0.217115f, 0.691709f, 
		0.217115f, 0.723199f, 0.217115f, 0.733433f, 
		0.217115f, 0.787451f, 0.217115f, 0.791301f, 
		0.217115f, 0.816821f, 0.217115f, 0.865715f, 
		0.217115f, 0.875953f, 0.217115f, 0.902451f, 
		0.217115f, 0.923209f, 0.217115f, 0.978053f, 
		0.217115f, 0.998535f, 0.217169f, 0.233712f, 
		0.217173f, 0.233729f, 0.217290f, 0.0741964f, 
		0.217390f, 0.0741701f, 0.217606f, 0.232588f, 
		0.217774f, 0.454081f, 0.217892f, 0.525861f, 
		0.217971f, 0.619506f, 0.218004f, 0.619663f, 
		0.218049f, 0.622300f, 0.218233f, 0.234089f, 
		0.218234f, 0.234078f, 0.218253f, 0.233936f, 
		0.218456f, 0.713634f, 0.218891f, 0.326935f, 
		0.218939f, 0.156285f, 0.219095f, 0.344540f, 
		0.219453f, 0.672532f, 0.219881f, 0.450234f, 
		0.219962f, 0.407934f, 0.220126f, 0.334436f, 
		0.220279f, 0.334700f, 0.220581f, 0.532546f, 
		0.220591f, 0.541300f, 0.220771f, 0.623366f, 
		0.221112f, 0.705331f, 0.221579f, 0.404438f, 
		0.221954f, 0.729461f, 0.221987f, 0.174909f, 
		0.222001f, 0.198483f, 0.222011f, 0.0112986f, 
		0.222088f, 0.543235f, 0.222088f, 0.543225f, 
		0.222089f, 0.251845f, 0.222115f, 0.644781f, 
		0.222175f, 0.0444917f, 0.222175f, 0.128872f, 
		0.222175f, 0.234590f, 0.222175f, 0.234604f, 
		0.222175f, 0.337841f, 0.222175f, 0.398652f, 
		0.222175f, 0.511062f, 0.222175f, 0.511077f, 
		0.222177f, 0.0548425f, 0.222177f, 0.106823f, 
		0.222177f, 0.106854f, 0.222177f, 0.298843f, 
		0.222177f, 0.364887f, 0.222177f, 0.378293f, 
		0.222177f, 0.379438f, 0.222177f, 0.431433f, 
		0.222177f, 0.431449f, 0.222177f, 0.459091f, 
		0.222177f, 0.684565f, 0.222256f, 0.0133510f, 
		0.222256f, 0.326297f, 0.222256f, 0.401747f, 
		0.222256f, 0.666315f, 0.222256f, 0.666331f, 
		0.222304f, 0.00257988f, 0.222403f, 0.00516507f, 
		0.223072f, 0.546166f, 0.223597f, 0.105177f, 
		0.223693f, 0.156582f, 0.223874f, 0.621684f, 
		0.224060f, 0.146256f, 0.224270f, 0.180844f, 
		0.224827f, 0.340272f, 0.224829f, 0.179561f, 
		0.225030f, 0.412752f, 0.225148f, 0.765738f, 
		0.225473f, 0.414117f, 0.225491f, 0.396812f, 
		0.225587f, 0.874353f, 0.225682f, 0.406126f, 
		0.225687f, 0.150330f, 0.225703f, 0.860857f, 
		0.225734f, 0.861816f, 0.225805f, 0.0820478f, 
		0.225859f, 0.873842f, 0.225954f, 0.108896f, 
		0.226013f, 0.870101f, 0.226261f, 0.000000f, 
		0.226261f, 0.998535f, 0.226578f, 0.277435f, 
		0.226615f, 0.150231f, 0.226616f, 0.385468f, 
		0.226653f, 0.875162f, 0.226775f, 0.861639f, 
		0.226809f, 0.717047f, 0.226860f, 0.0986724f, 
		0.227040f, 0.862395f, 0.227124f, 0.811380f, 
		0.227182f, 0.00147619f, 0.227217f, 0.0704492f, 
		0.227255f, 0.00116827f, 0.227299f, 0.741914f, 
		0.227353f, 0.318393f, 0.227414f, 0.0705953f, 
		0.227750f, 0.811374f, 0.227755f, 0.335693f, 
		0.227894f, 0.340286f, 0.227897f, 0.236261f, 
		0.228008f, 0.669615f, 0.228148f, 0.236337f, 
		0.228159f, 0.675415f, 0.228189f, 0.675401f, 
		0.228331f, 0.236389f, 0.228332f, 0.395258f, 
		0.228415f, 0.452505f, 0.228492f, 0.548127f, 
		0.228628f, 0.573728f, 0.228859f, 0.0354027f, 
		0.228903f, 0.0477049f, 0.228913f, 0.658396f, 
		0.228986f, 0.0479581f, 0.229047f, 0.156377f, 
		0.229397f, 0.0796435f, 0.229426f, 0.865407f, 
		0.229539f, 0.324401f, 0.229737f, 0.0939823f, 
		0.229767f, 0.110224f, 0.229911f, 0.453426f, 
		0.229913f, 0.766307f, 0.229937f, 0.475469f, 
		0.229958f, 0.475513f, 0.229975f, 0.218475f, 
		0.230031f, 0.203125f, 0.230043f, 0.203111f, 
		0.230059f, 0.453301f, 0.230166f, 0.323378f, 
		0.230314f, 0.0708841f, 0.230375f, 0.511917f, 
		0.230420f, 0.558856f, 0.230446f, 0.622509f, 
		0.230447f, 0.622476f, 0.230506f, 0.320711f, 
		0.230514f, 0.289915f, 0.230517f, 0.0789268f, 
		0.230667f, 0.193997f, 0.230667f, 0.193962f, 
		0.230669f, 0.194000f, 0.230683f, 0.661354f, 
		0.230683f, 0.864489f, 0.230685f, 0.544534f, 
		0.230693f, 0.00864100f, 0.230749f, 0.499078f, 
		0.230818f, 0.00989776f, 0.230866f, 0.498904f, 
		0.230885f, 0.337260f, 0.230978f, 0.773831f, 
		0.231058f, 0.512177f, 0.231096f, 0.661134f, 
		0.231395f, 0.319263f, 0.231424f, 0.428439f, 
		0.231446f, 0.0782815f, 0.231497f, 0.137256f, 
		0.231503f, 0.137449f, 0.231528f, 0.295746f, 
		0.231849f, 0.00708700f, 0.231849f, 0.205518f, 
		0.231849f, 0.341636f, 0.231849f, 0.341655f, 
		0.231849f, 0.381478f, 0.231849f, 0.416226f, 
		0.231849f, 0.446470f, 0.231849f, 0.545686f, 
		0.231853f, 0.232638f, 0.231901f, 0.0116821f, 
		0.231944f, 0.0779296f, 0.231953f, 0.406803f, 
		0.232308f, 0.0776912f, 0.232334f, 0.630969f, 
		0.232387f, 0.441238f, 0.232393f, 0.334702f, 
		0.232414f, 0.647273f, 0.232529f, 0.222356f, 
		0.232602f, 0.435605f, 0.232635f, 0.318909f, 
		0.232672f, 0.518628f, 0.232675f, 0.100238f, 
		0.232676f, 0.130241f, 0.232678f, 0.518641f, 
		0.232681f, 0.130251f, 0.232683f, 0.660211f, 
		0.232683f, 0.130255f, 0.232718f, 0.100572f, 
		0.233045f, 0.426493f, 0.233218f, 0.427128f, 
		0.233264f, 0.317884f, 0.233314f, 0.0171563f, 
		0.233314f, 0.0623995f, 0.233314f, 0.0862116f, 
		0.233314f, 0.0969378f, 0.233314f, 0.109316f, 
		0.233314f, 0.159465f, 0.233314f, 0.185027f, 
		0.233314f, 0.209601f, 0.233314f, 0.209617f, 
		0.233314f, 0.303747f, 0.233314f, 0.303766f, 
		0.233314f, 0.366403f, 0.233314f, 0.366416f, 
		0.233314f, 0.366438f, 0.233314f, 0.421232f, 
		0.233314f, 0.483680f, 0.233314f, 0.483710f, 
		0.233314f, 0.503500f, 0.233314f, 0.503516f, 
		0.233314f, 0.533861f, 0.233314f, 0.550441f, 
		0.233314f, 0.561594f, 0.233408f, 0.660316f, 
		0.233489f, 0.651034f, 0.233692f, 0.878910f, 
		0.233831f, 0.648868f, 0.233949f, 0.659394f, 
		0.234183f, 0.606927f, 0.234233f, 0.493641f, 
		0.234299f, 0.322308f, 0.234433f, 0.322245f, 
		0.234613f, 0.442610f, 0.234631f, 0.450236f, 
		0.234635f, 0.450261f, 0.234659f, 0.321722f, 
		0.234746f, 0.322105f, 0.234787f, 0.321669f, 
		0.234812f, 0.0162126f, 0.234812f, 0.562493f, 
		0.234818f, 0.465982f, 0.234873f, 0.619630f, 
		0.234921f, 0.0161422f, 0.234921f, 0.562559f, 
		0.235003f, 0.694461f, 0.235051f, 0.731242f, 
		0.235084f, 0.321554f, 0.235186f, 0.347508f, 
		0.235235f, 0.694065f, 0.235297f, 0.490114f, 
		0.235302f, 0.316625f, 0.235370f, 0.730616f, 
		0.235380f, 0.234920f, 0.235393f, 0.321957f, 
		0.235394f, 0.321968f, 0.235438f, 0.811346f, 
		0.235477f, 0.159925f, 0.235562f, 0.471672f, 
		0.235565f, 0.301870f, 0.235565f, 0.303774f, 
		0.235617f, 0.488822f, 0.235691f, 0.686199f, 
		0.235746f, 0.315903f, 0.235763f, 0.301688f, 
		0.235763f, 0.303760f, 0.235763f, 0.301704f, 
		0.235763f, 0.303775f, 0.235800f, 0.321651f, 
		0.235805f, 0.303761f, 0.235815f, 0.321280f, 
		0.235815f, 0.321268f, 0.235954f, 0.0404365f, 
		0.236013f, 0.0374110f, 0.236036f, 0.545429f, 
		0.236085f, 0.321187f, 0.236097f, 0.430895f, 
		0.236124f, 0.109630f, 0.236133f, 0.321642f, 
		0.236176f, 0.727067f, 0.236380f, 0.621959f, 
		0.236504f, 0.321036f, 0.236883f, 0.868006f, 
		0.237269f, 0.0989431f, 0.237307f, 0.700821f, 
		0.237389f, 0.00749379f, 0.237404f, 0.424431f, 
		0.237443f, 0.00808588f, 0.237448f, 0.245200f, 
		0.237695f, 0.204331f, 0.237695f, 0.210078f, 
		0.237702f, 0.204332f, 0.237702f, 0.210076f, 
		0.237734f, 0.0740522f, 0.237741f, 0.0740687f, 
		0.237742f, 0.462457f, 0.237742f, 0.0740531f, 
		0.237746f, 0.462455f, 0.237748f, 0.462473f, 
		0.237870f, 0.415265f, 0.237977f, 0.0567896f, 
		0.237977f, 0.423440f, 0.238086f, 0.252383f, 
		0.238103f, 0.449806f, 0.238145f, 0.0140682f, 
		0.238145f, 0.546305f, 0.238175f, 0.207424f, 
		0.238374f, 0.403936f, 0.238374f, 0.407359f, 
		0.238374f, 0.494238f, 0.238391f, 0.403936f, 
		0.238391f, 0.407302f, 0.238493f, 0.875652f, 
		0.238500f, 0.633588f, 0.238692f, 0.517219f, 
		0.238694f, 0.117904f, 0.238713f, 0.117937f, 
		0.238768f, 0.511564f, 0.238831f, 0.0108402f, 
		0.238938f, 0.874168f, 0.238973f, 0.235737f, 
		0.239044f, 0.0901203f, 0.239044f, 0.103394f, 
		0.239129f, 0.210471f, 0.239302f, 0.0290701f, 
		0.239316f, 0.400611f, 0.239476f, 0.00834824f, 
		0.239476f, 0.862566f, 0.239510f, 0.378336f, 
		0.239535f, 0.865569f, 0.239565f, 0.378431f, 
		0.239566f, 0.814790f, 0.239687f, 0.485271f, 
		0.239714f, 0.0373386f, 0.239784f, 0.401315f, 
		0.239786f, 0.00822834f, 0.239786f, 0.862723f, 
		0.239846f, 0.746497f, 0.239973f, 0.0671429f, 
		0.239986f, 0.725045f, 0.240042f, 0.725062f, 
		0.240048f, 0.150352f, 0.240155f, 0.224222f, 
		0.240215f, 0.0135686f, 0.240260f, 0.149043f, 
		0.240260f, 0.170984f, 0.240313f, 0.243507f, 
		0.240363f, 0.156494f, 0.240426f, 0.243452f, 
		0.240448f, 0.0134905f, 0.240488f, 0.729101f, 
		0.240521f, 0.0675332f, 0.240543f, 0.0111215f, 
		0.240654f, 0.806515f, 0.240758f, 0.224952f, 
		0.240813f, 0.00719876f, 0.240813f, 0.863274f, 
		0.240818f, 0.00719017f, 0.240818f, 0.863285f, 
		0.240849f, 0.0566407f, 0.240939f, 0.0411967f, 
		0.241155f, 0.280065f, 0.241169f, 0.413913f, 
		0.241261f, 0.00816115f, 0.241303f, 0.622025f, 
		0.241547f, 0.0100132f, 0.241547f, 0.0771288f, 
		0.241547f, 0.0771399f, 0.241547f, 0.0771642f, 
		0.241547f, 0.124999f, 0.241547f, 0.161417f, 
		0.241547f, 0.200937f, 0.241547f, 0.296371f, 
		0.241547f, 0.319144f, 0.241547f, 0.319160f, 
		0.241547f, 0.319175f, 0.241547f, 0.368846f, 
		0.241547f, 0.395135f, 0.241547f, 0.408422f, 
		0.241547f, 0.417427f, 0.241547f, 0.417452f, 
		0.241547f, 0.465525f, 0.241547f, 0.465538f, 
		0.241547f, 0.549809f, 0.241547f, 0.550398f, 
		0.241547f, 0.589333f, 0.241547f, 0.654938f, 
		0.241547f, 0.654995f, 0.241547f, 0.695907f, 
		0.241547f, 0.707545f, 0.241547f, 0.707557f, 
		0.241547f, 0.707578f, 0.241547f, 0.707825f, 
		0.241547f, 0.716468f, 0.241547f, 0.719661f, 
		0.241547f, 0.731533f, 0.241547f, 0.735744f, 
		0.241547f, 0.744339f, 0.241547f, 0.766968f, 
		0.241547f, 0.770242f, 0.241584f, 0.236518f, 
		0.241630f, 0.146987f, 0.241630f, 0.173256f, 
		0.241643f, 0.718637f, 0.241749f, 0.621942f, 
		0.241932f, 0.434208f, 0.241983f, 0.452980f, 
		0.241983f, 0.455360f, 0.241997f, 0.0699007f, 
		0.242133f, 0.109863f, 0.242134f, 0.407377f, 
		0.242152f, 0.128581f, 0.242153f, 0.114971f, 
		0.242201f, 0.198913f, 0.242201f, 0.214103f, 
		0.242291f, 0.0869277f, 0.242318f, 0.0867365f, 
		0.242359f, 0.862972f, 0.242381f, 0.0864341f, 
		0.242404f, 0.621955f, 0.242452f, 0.535956f, 
		0.242600f, 0.0863442f, 0.242748f, 0.808425f, 
		0.242776f, 0.236868f, 0.242824f, 0.342884f, 
		0.242824f, 0.370723f, 0.242840f, 0.436862f, 
		0.242840f, 0.441737f, 0.242846f, 0.321086f, 
		0.242886f, 0.865407f, 0.242919f, 0.383579f, 
		0.243033f, 0.561498f, 0.243049f, 0.439022f, 
		0.243102f, 0.561519f, 0.243179f, 0.342007f, 
		0.243179f, 0.370884f, 0.243381f, 0.463831f, 
		0.243382f, 0.432001f, 0.243394f, 0.301508f, 
		0.243399f, 0.321887f, 0.243455f, 0.643897f, 
		0.243565f, 0.147895f, 0.243569f, 0.132280f, 
		0.243569f, 0.139590f, 0.243569f, 0.146045f, 
		0.243653f, 0.0574679f, 0.243663f, 0.0344709f, 
		0.243777f, 0.635284f, 0.243838f, 0.704377f, 
		0.243845f, 0.301756f, 0.243854f, 0.704364f, 
		0.243886f, 0.549875f, 0.243892f, 0.316608f, 
		0.243924f, 0.808625f, 0.243947f, 0.562020f, 
		0.244088f, 0.618601f, 0.244101f, 0.653385f, 
		0.244119f, 0.145226f, 0.244136f, 0.771320f, 
		0.244148f, 0.145259f, 0.244148f, 0.469490f, 
		0.244190f, 0.726358f, 0.244192f, 0.412220f, 
		0.244205f, 0.624972f, 0.244206f, 0.236563f, 
		0.244209f, 0.624976f, 0.244261f, 0.709709f, 
		0.244274f, 0.315385f, 0.244291f, 0.0100132f, 
		0.244340f, 0.769687f, 0.244392f, 0.372923f, 
		0.244399f, 0.703610f, 0.244534f, 0.329519f, 
		0.244654f, 0.470264f, 0.244659f, 0.213200f, 
		0.244662f, 0.145938f, 0.244672f, 0.363563f, 
		0.244708f, 0.518900f, 0.244807f, 0.748203f, 
		0.244861f, 0.105621f, 0.244866f, 0.00977150f, 
		0.244866f, 0.0450300f, 0.244866f, 0.0535700f, 
		0.244866f, 0.0706280f, 0.244866f, 0.0790070f, 
		0.244866f, 0.113743f, 0.244866f, 0.113764f, 
		0.244866f, 0.141946f, 0.244866f, 0.142132f, 
		0.244866f, 0.142404f, 0.244866f, 0.158352f, 
		0.244866f, 0.158375f, 0.244866f, 0.158386f, 
		0.244866f, 0.178622f, 0.244866f, 0.184545f, 
		0.244866f, 0.195702f, 0.244866f, 0.210825f, 
		0.244866f, 0.210860f, 0.244866f, 0.246489f, 
		0.244866f, 0.255789f, 0.244866f, 0.281979f, 
		0.244866f, 0.294035f, 0.244866f, 0.320753f, 
		0.244866f, 0.337834f, 0.244866f, 0.371650f, 
		0.244866f, 0.388621f, 0.244866f, 0.397367f, 
		0.244866f, 0.397402f, 0.244866f, 0.426395f, 
		0.244866f, 0.438568f, 0.244866f, 0.438594f, 
		0.244866f, 0.442774f, 0.244866f, 0.445939f, 
		0.244866f, 0.513781f, 0.244866f, 0.522267f, 
		0.244866f, 0.534950f, 0.244866f, 0.535186f, 
		0.244866f, 0.535477f, 0.244866f, 0.549354f, 
		0.244866f, 0.568527f, 0.244869f, 0.0539651f, 
		0.244872f, 0.712448f, 0.244926f, 0.712536f, 
		0.244967f, 0.105438f, 0.245245f, 0.158083f, 
		0.245359f, 0.410922f, 0.245394f, 0.342256f, 
		0.245396f, 0.409110f, 0.245419f, 0.0665546f, 
		0.245469f, 0.206819f, 0.245556f, 0.313621f, 
		0.245561f, 0.205621f, 0.245730f, 0.248800f, 
		0.245736f, 0.0760379f, 0.245748f, 0.521628f, 
		0.245773f, 0.583076f, 0.245783f, 0.249912f, 
		0.245791f, 0.638308f, 0.245819f, 0.317661f, 
		0.245856f, 0.492272f, 0.245889f, 0.408063f, 
		0.246020f, 0.468178f, 0.246104f, 0.492630f, 
		0.246107f, 0.0735340f, 0.246125f, 0.861447f, 
		0.246305f, 0.536041f, 0.246409f, 0.133508f, 
		0.246512f, 0.872963f, 0.246584f, 0.145518f, 
		0.246617f, 0.860689f, 0.246618f, 0.861248f, 
		0.246670f, 0.411703f, 0.246698f, 0.386879f, 
		0.246700f, 0.708596f, 0.246701f, 0.307592f, 
		0.246704f, 0.413799f, 0.246721f, 0.723391f, 
		0.246740f, 0.386812f, 0.246740f, 0.0131716f, 
		0.246745f, 0.545093f, 0.246812f, 0.490059f, 
		0.246952f, 0.280804f, 0.246968f, 0.477889f, 
		0.246977f, 0.369019f, 0.246994f, 0.345129f, 
		0.246996f, 0.751828f, 0.246998f, 0.0227324f, 
		0.247035f, 0.731951f, 0.247065f, 0.522994f, 
		0.247071f, 0.736700f, 0.247117f, 0.507021f, 
		0.247180f, 0.101292f, 0.247184f, 0.0134419f, 
		0.247193f, 0.707726f, 0.247249f, 0.730610f, 
		0.247280f, 0.173879f, 0.247340f, 0.318927f, 
		0.247351f, 0.0135434f, 0.247383f, 0.169934f, 
		0.247414f, 0.488855f, 0.247417f, 0.318870f, 
		0.247439f, 0.173858f, 0.247440f, 0.216937f, 
		0.247445f, 0.197618f, 0.247510f, 0.0587609f, 
		0.247539f, 0.0136573f, 0.247572f, 0.0850944f, 
		0.247578f, 0.493029f, 0.247696f, 0.404158f, 
		0.247705f, 0.187703f, 0.247722f, 0.440243f, 
		0.247765f, 0.0908233f, 0.247784f, 0.461728f, 
		0.247801f, 0.0249562f, 0.247848f, 0.590731f, 
		0.247898f, 0.440341f, 0.247898f, 0.450745f, 
		0.247922f, 0.460388f, 0.247948f, 0.395135f, 
		0.247963f, 0.763615f, 0.247970f, 0.536816f, 
		0.248005f, 0.157033f, 0.248005f, 0.517497f, 
		0.248011f, 0.186161f, 0.248026f, 0.460839f, 
		0.248031f, 0.0217686f, 0.248048f, 0.279603f, 
		0.248148f, 0.718004f, 0.248248f, 0.156893f, 
		0.248383f, 0.166052f, 0.248386f, 0.276843f, 
		0.248401f, 0.198328f, 0.248401f, 0.548180f, 
		0.248472f, 0.103046f, 0.248620f, 0.0220433f, 
		0.248621f, 0.619841f, 0.248632f, 0.320038f, 
		0.248644f, 0.0234782f, 0.248654f, 0.0543768f, 
		0.248710f, 0.337780f, 0.248724f, 0.0292980f, 
		0.248804f, 0.404031f, 0.248810f, 0.315632f, 
		0.248817f, 0.670575f, 0.248906f, 0.320089f, 
		0.248978f, 0.368600f, 0.249038f, 0.594854f, 
		0.249040f, 0.708489f, 0.249047f, 0.0362699f, 
		0.249049f, 0.544841f, 0.249125f, 0.0303767f, 
		0.249177f, 0.613811f, 0.249188f, 0.432559f, 
		0.249216f, 0.428023f, 0.249250f, 0.736333f, 
		0.249274f, 0.511148f, 0.249382f, 0.0780454f, 
		0.249429f, 0.0780740f, 0.249430f, 0.650766f, 
		0.249479f, 0.126812f, 0.249521f, 0.536169f, 
		0.249579f, 0.320161f, 0.249655f, 0.0780758f, 
		0.249675f, 0.237027f, 0.249675f, 0.301837f, 
		0.249675f, 0.301847f, 0.249675f, 0.301892f, 
		0.249675f, 0.565301f, 0.249675f, 0.565332f, 
		0.249675f, 0.565351f, 0.249675f, 0.621537f, 
		0.249675f, 0.621593f, 0.249776f, 0.320185f, 
		0.249785f, 0.405717f, 0.249846f, 0.737332f, 
		0.249860f, 0.466488f, 0.249894f, 0.692000f, 
		0.250031f, 0.417293f, 0.250047f, 0.559290f, 
		0.250061f, 0.550847f, 0.250081f, 0.209540f, 
		0.250164f, 0.0371778f, 0.250185f, 0.593150f, 
		0.250281f, 0.390457f, 0.250281f, 0.395095f, 
		0.250299f, 0.632269f, 0.250335f, 0.0425690f, 
		0.250336f, 0.0381058f, 0.250337f, 0.0380723f, 
		0.250400f, 0.162488f, 0.250650f, 0.269921f, 
		0.250723f, 0.269982f, 0.250800f, 0.142360f, 
		0.250806f, 0.511928f, 0.250817f, 0.705814f, 
		0.250859f, 0.0936843f, 0.250891f, 0.0782209f, 
		0.250905f, 0.524914f, 0.250925f, 0.0106284f, 
		0.250989f, 0.323352f, 0.251032f, 0.0754399f, 
		0.251035f, 0.0639467f, 0.251105f, 0.107985f, 
		0.251140f, 0.0695717f, 0.251140f, 0.0695988f, 
		0.251140f, 0.0696376f, 0.251140f, 0.103783f, 
		0.251140f, 0.128255f, 0.251140f, 0.200159f, 
		0.251140f, 0.207305f, 0.251140f, 0.229282f, 
		0.251140f, 0.290223f, 0.251140f, 0.350929f, 
		0.251140f, 0.412347f, 0.251140f, 0.487351f, 
		0.251140f, 0.521679f, 0.251140f, 0.630366f, 
		0.251140f, 0.647591f, 0.251140f, 0.707392f, 
		0.251140f, 0.707436f, 0.251140f, 0.707475f, 
		0.251140f, 0.707569f, 0.251140f, 0.776978f, 
		0.251140f, 0.840401f, 0.251140f, 0.840486f, 
		0.251140f, 0.840546f, 0.251140f, 0.924906f, 
		0.251179f, 0.772288f, 0.251190f, 0.769535f, 
		0.251201f, 0.620306f, 0.251237f, 0.319618f, 
		0.251332f, 0.605080f, 0.251602f, 0.128584f, 
		0.251602f, 0.179329f, 0.251663f, 0.547025f, 
		0.251684f, 0.550216f, 0.251711f, 0.466712f, 
		0.251793f, 0.466721f, 0.251830f, 0.00384313f, 
		0.251866f, 0.772434f, 0.251869f, 0.317206f, 
		0.251885f, 0.705608f, 0.251925f, 0.245699f, 
		0.251952f, 0.251914f, 0.252030f, 0.391048f, 
		0.252030f, 0.394335f, 0.252038f, 0.191985f, 
		0.252041f, 0.318426f, 0.252092f, 0.143819f, 
		0.252093f, 0.143153f, 0.252161f, 0.745467f, 
		0.252191f, 0.252974f, 0.252225f, 0.251748f, 
		0.252239f, 0.544536f, 0.252287f, 0.150007f, 
		0.252289f, 0.150529f, 0.252297f, 0.323701f, 
		0.252303f, 0.648662f, 0.252307f, 0.405817f, 
		0.252333f, 0.488495f, 0.252338f, 0.317118f, 
		0.252347f, 0.374536f, 0.252398f, 0.747702f, 
		0.252499f, 0.550245f, 0.252578f, 0.233406f, 
		0.252596f, 0.678013f, 0.252704f, 0.314790f, 
		0.252725f, 0.416688f, 0.252748f, 0.314802f, 
		0.252753f, 0.599709f, 0.252844f, 0.0738907f, 
		0.252865f, 0.152727f, 0.252914f, 0.233982f, 
		0.253125f, 0.620145f, 0.253170f, 0.239348f, 
		0.253313f, 0.152352f, 0.253314f, 0.629618f, 
		0.253319f, 0.315811f, 0.253340f, 0.540757f, 
		0.253364f, 0.227157f, 0.253413f, 0.562285f, 
		0.253470f, 0.239523f, 0.253543f, 0.536192f, 
		0.253607f, 0.628571f, 0.253749f, 0.232436f, 
		0.253806f, 0.232421f, 0.253926f, 0.407540f, 
		0.253998f, 0.238292f, 0.254111f, 0.386928f, 
		0.254226f, 0.609751f, 0.254355f, 0.428584f, 
		0.254363f, 0.154204f, 0.254375f, 0.624920f, 
		0.254376f, 0.632500f, 0.254496f, 0.141175f, 
		0.254592f, 0.534663f, 0.254605f, 0.00878789f, 
		0.254829f, 0.157567f, 0.254838f, 0.727583f, 
		0.254839f, 0.628899f, 0.254841f, 0.240509f, 
		0.254849f, 0.628912f, 0.254856f, 0.240496f, 
		0.254869f, 0.217343f, 0.255081f, 0.216336f, 
		0.255148f, 0.210180f, 0.255166f, 0.212792f, 
		0.255172f, 0.142793f, 0.255251f, 0.131646f, 
		0.255307f, 0.629636f, 0.255423f, 0.169311f, 
		0.255456f, 0.476317f, 0.255491f, 0.141695f, 
		0.255513f, 0.317964f, 0.255545f, 0.169026f, 
		0.255637f, 0.518926f, 0.255710f, 0.0102675f, 
		0.255784f, 0.154687f, 0.255825f, 0.0363237f, 
		0.255868f, 0.621877f, 0.255890f, 0.629168f, 
		0.255892f, 0.00946743f, 0.255986f, 0.0102638f, 
		0.255990f, 0.150579f, 0.256013f, 0.735641f, 
		0.256047f, 0.706521f, 0.256055f, 0.166663f, 
		0.256085f, 0.442712f, 0.256112f, 0.149567f, 
		0.256228f, 0.0651123f, 0.256287f, 0.236857f, 
		0.256306f, 0.507956f, 0.256345f, 0.000000f, 
		0.256345f, 0.0280165f, 0.256345f, 0.108243f, 
		0.256345f, 0.132546f, 0.256345f, 0.274677f, 
		0.256345f, 0.290411f, 0.256345f, 0.312280f, 
		0.256345f, 0.392510f, 0.256345f, 0.416808f, 
		0.256345f, 0.445303f, 0.256360f, 0.997006f, 
		0.256516f, 0.560248f, 0.256586f, 0.131004f, 
		0.256589f, 0.130990f, 0.256802f, 0.716544f, 
		0.256830f, 0.000000f, 0.256851f, 0.0991833f, 
		0.256964f, 0.241939f, 0.257049f, 0.00443223f, 
		0.257098f, 0.00423980f, 0.257164f, 0.00748477f, 
		0.257247f, 0.614613f, 0.257255f, 0.167177f, 
		0.257309f, 0.624255f, 0.257326f, 0.0297005f, 
		0.257401f, 0.598781f, 0.257410f, 0.598601f, 
		0.257575f, 0.306988f, 0.257583f, 0.170716f, 
		0.257586f, 0.702707f, 0.257729f, 0.436764f, 
		0.257775f, 0.435789f, 0.257777f, 0.714130f, 
		0.257936f, 0.754434f, 0.257987f, 0.455299f, 
		0.258011f, 0.000000f, 0.258011f, 0.00970905f, 
		0.258011f, 0.00998834f, 0.258011f, 0.0100189f, 
		0.258011f, 0.0159271f, 0.258011f, 0.0192091f, 
		0.258011f, 0.0192565f, 0.258011f, 0.0200265f, 
		0.258011f, 0.0484326f, 0.258011f, 0.0542554f, 
		0.258011f, 0.0549938f, 0.258011f, 0.0790435f, 
		0.258011f, 0.0790616f, 0.258011f, 0.163403f, 
		0.258011f, 0.296371f, 0.258011f, 0.321202f, 
		0.258011f, 0.321212f, 0.258011f, 0.321228f, 
		0.258011f, 0.343416f, 0.258011f, 0.395135f, 
		0.258011f, 0.425292f, 0.258011f, 0.467425f, 
		0.258011f, 0.467439f, 0.258011f, 0.490570f, 
		0.258011f, 0.496363f, 0.258011f, 0.551804f, 
		0.258011f, 0.597614f, 0.258011f, 0.684767f, 
		0.258011f, 0.696303f, 0.258011f, 0.709619f, 
		0.258011f, 0.714047f, 0.258011f, 0.731533f, 
		0.258011f, 0.731812f, 0.258011f, 0.749798f, 
		0.258011f, 0.766968f, 0.258040f, 0.255087f, 
		0.258173f, 0.000000f, 0.258193f, 0.714951f, 
		0.258194f, 0.158275f, 0.258239f, 0.146845f, 
		0.258314f, 0.144901f, 0.258324f, 0.159009f, 
		0.258345f, 0.458217f, 0.258358f, 0.235633f, 
		0.258374f, 0.148624f, 0.258397f, 0.245930f, 
		0.258431f, 0.255023f, 0.258460f, 0.425136f, 
		0.258638f, 0.376955f, 0.258640f, 0.0926685f, 
		0.258726f, 0.407364f, 0.258738f, 0.362794f, 
		0.258743f, 0.143876f, 0.258876f, 0.0310809f, 
		0.259027f, 0.159000f, 0.259239f, 0.535555f, 
		0.259246f, 0.541383f, 0.259254f, 0.523023f, 
		0.259348f, 0.707695f, 0.259632f, 0.795205f, 
		0.259709f, 0.626673f, 0.259766f, 0.461398f, 
		0.259846f, 0.402035f, 0.260064f, 0.206267f, 
		0.260104f, 0.383014f, 0.260146f, 0.0738105f, 
		0.260285f, 0.0993372f, 0.260287f, 0.517136f, 
		0.260392f, 0.320046f, 0.260438f, 0.928747f, 
		0.260485f, 0.145125f, 0.260496f, 0.461121f, 
		0.260545f, 0.228005f, 0.260592f, 0.00331138f, 
		0.260595f, 0.930317f, 0.260596f, 0.597440f, 
		0.260604f, 0.768063f, 0.260755f, 0.422625f, 
		0.260757f, 0.849431f, 0.260768f, 0.229661f, 
		0.260770f, 0.229679f, 0.260772f, 0.229689f, 
		0.260791f, 0.518143f, 0.260817f, 0.525755f, 
		0.260834f, 0.543665f, 0.260848f, 0.238320f, 
		0.260863f, 0.358527f, 0.261141f, 0.472862f, 
		0.261457f, 0.929196f, 0.261483f, 0.550597f, 
		0.261484f, 0.550610f, 0.261573f, 0.438433f, 
		0.261610f, 0.468316f, 0.261655f, 0.596028f, 
		0.261695f, 0.000000f, 0.261695f, 0.0435220f, 
		0.261695f, 0.123386f, 0.261695f, 0.164390f, 
		0.261695f, 0.227157f, 0.261707f, 0.0454333f, 
		0.261717f, 0.520121f, 0.261812f, 0.315331f, 
		0.261814f, 0.703730f, 0.261814f, 0.315334f, 
		0.261876f, 0.242019f, 0.261965f, 0.764067f, 
		0.262086f, 0.666028f, 0.262236f, 0.0895861f, 
		0.262236f, 0.138228f, 0.262236f, 0.138347f, 
		0.262236f, 0.157637f, 0.262236f, 0.192903f, 
		0.262236f, 0.356297f, 0.262236f, 0.357262f, 
		0.262236f, 0.387714f, 0.262236f, 0.404133f, 
		0.262236f, 0.446831f, 0.262236f, 0.449572f, 
		0.262236f, 0.597802f, 0.262236f, 0.605881f, 
		0.262236f, 0.650124f, 0.262236f, 0.658951f, 
		0.262236f, 0.691709f, 0.262236f, 0.816821f, 
		0.262236f, 0.865715f, 0.262236f, 0.875953f, 
		0.262236f, 0.902451f, 0.262255f, 0.655096f, 
		0.262269f, 0.553928f, 0.262335f, 0.630223f, 
		0.262366f, 0.726675f, 0.262378f, 0.734381f, 
		0.262399f, 0.524967f, 0.262500f, 0.726829f, 
		0.262545f, 0.549941f, 0.262709f, 0.749265f, 
		0.262824f, 0.00304959f, 0.262882f, 0.460631f, 
		0.262901f, 0.362707f, 0.263016f, 0.578664f, 
		0.263029f, 0.488843f, 0.263070f, 0.729261f, 
		0.263123f, 0.0789830f, 0.263193f, 0.279785f, 
		0.263206f, 0.317642f, 0.263215f, 0.237202f, 
		0.263265f, 0.227468f, 0.263344f, 0.323628f, 
		0.263389f, 0.000000f, 0.263389f, 0.998535f, 
		0.263434f, 0.349011f, 0.263499f, 0.273286f, 
		0.263499f, 0.273307f, 0.263499f, 0.395135f, 
		0.263499f, 0.490621f, 0.263499f, 0.623102f, 
		0.263551f, 0.532218f, 0.263803f, 0.475656f, 
		0.263893f, 0.544437f, 0.263930f, 0.000000f, 
		0.263930f, 0.998535f, 0.263964f, 0.716308f, 
		0.264053f, 0.591235f, 0.264125f, 0.625076f, 
		0.264220f, 0.625841f, 0.264221f, 0.625822f, 
		0.264227f, 0.625858f, 0.264251f, 0.644672f, 
		0.264263f, 0.588328f, 0.264372f, 0.591391f, 
		0.264374f, 0.206574f, 0.264388f, 0.243909f, 
		0.264394f, 0.00947362f, 0.264394f, 0.998535f, 
		0.264512f, 0.229894f, 0.264566f, 0.595343f, 
		0.264636f, 0.398232f, 0.264728f, 0.144568f, 
		0.264892f, 0.0284444f, 0.264931f, 0.000000f, 
		0.264937f, 0.279280f, 0.265059f, 0.00535162f, 
		0.265092f, 0.00551237f, 0.265094f, 0.0111844f, 
		0.265130f, 0.322393f, 0.265272f, 0.558950f, 
		0.265296f, 0.0108496f, 0.265332f, 0.228189f, 
		0.265345f, 0.00342806f, 0.265360f, 0.998535f, 
		0.265389f, 0.998535f, 0.265478f, 0.316272f, 
		0.265491f, 0.680816f, 0.265493f, 0.680833f, 
		0.265498f, 0.611511f, 0.265513f, 0.722623f, 
		0.265649f, 0.0870430f, 0.265657f, 0.000000f, 
		0.265882f, 0.153554f, 0.265907f, 0.484290f, 
		0.265913f, 0.151606f, 0.265917f, 0.0312713f, 
		0.265917f, 0.770307f, 0.266012f, 0.232368f, 
		0.266021f, 0.153102f, 0.266150f, 0.263967f, 
		0.266211f, 0.00146624f, 0.266211f, 0.00436566f, 
		0.266211f, 0.0692237f, 0.266211f, 0.0753599f, 
		0.266211f, 0.262933f, 0.266211f, 0.288656f, 
		0.266211f, 0.314998f, 0.266211f, 0.349707f, 
		0.266211f, 0.364392f, 0.266211f, 0.426827f, 
		0.266211f, 0.426990f, 0.266211f, 0.474991f, 
		0.266211f, 0.475010f, 0.266211f, 0.489154f, 
		0.266211f, 0.502575f, 0.266211f, 0.626184f, 
		0.266211f, 0.626199f, 0.266211f, 0.739926f, 
		0.266211f, 0.740759f, 0.266232f, 0.705614f, 
		0.266272f, 0.232620f, 0.266320f, 0.726113f, 
		0.266406f, 0.0883095f, 0.266432f, 0.716087f, 
		0.266447f, 0.0162423f, 0.266563f, 0.321288f, 
		0.266593f, 0.0831895f, 0.266708f, 0.658478f, 
		0.266927f, 0.925063f, 0.266990f, 6.88631e-007f, 
		0.267017f, 0.698801f, 0.267077f, 0.0323641f, 
		0.267258f, 0.786969f, 0.267263f, 0.706188f, 
		0.267291f, 0.0469083f, 0.267425f, 0.293299f, 
		0.267452f, 0.171224f, 0.267452f, 0.188227f, 
		0.267452f, 0.316918f, 0.267452f, 0.693868f, 
		0.267452f, 0.694952f, 0.267452f, 0.831791f, 
		0.267452f, 0.832282f, 0.267452f, 0.913480f, 
		0.267501f, 0.317775f, 0.267676f, 0.000876139f, 
		0.267676f, 0.00133980f, 0.267676f, 0.0659828f, 
		0.267676f, 0.121124f, 0.267676f, 0.141439f, 
		0.267676f, 0.211170f, 0.267676f, 0.290325f, 
		0.267676f, 0.388758f, 0.267676f, 0.472437f, 
		0.267676f, 0.472453f, 0.267676f, 0.606168f, 
		0.267676f, 0.606216f, 0.267676f, 0.702577f, 
		0.267676f, 0.702731f, 0.268202f, 0.0760491f, 
		0.268284f, 0.705598f, 0.268386f, 0.000578349f, 
		0.268451f, 0.662327f, 0.268769f, 0.0833013f, 
		0.268776f, 0.0960203f, 0.268782f, 0.0933019f, 
		0.268875f, 0.372354f, 0.268910f, 0.621505f, 
		0.268937f, 0.0871977f, 0.269034f, 0.309605f, 
		0.269044f, 0.0813459f, 0.269058f, 0.359750f, 
		0.269060f, 0.364339f, 0.269141f, 0.0826394f, 
		0.269195f, 0.617138f, 0.269330f, 0.513049f, 
		0.269375f, 0.0764699f, 0.269402f, 0.588873f, 
		0.269433f, 0.0870404f, 0.269619f, 0.144290f, 
		0.269629f, 0.000000f, 0.269629f, 0.130049f, 
		0.269629f, 0.197696f, 0.269629f, 0.235586f, 
		0.269629f, 0.286484f, 0.269629f, 0.309835f, 
		0.269629f, 0.356750f, 0.269629f, 0.361552f, 
		0.269629f, 0.406266f, 0.269629f, 0.481386f, 
		0.269629f, 0.567153f, 0.269629f, 0.571287f, 
		0.269629f, 0.580380f, 0.269629f, 0.614107f, 
		0.269629f, 0.655234f, 0.269629f, 0.740801f, 
		0.269802f, 0.537653f, 0.269839f, 0.353642f, 
		0.269961f, 0.134432f, 0.270047f, 0.000635231f, 
		0.270111f, 0.0178840f, 0.270188f, 0.998535f, 
		0.270205f, 0.0174795f, 0.270433f, 0.984318f, 
		0.270457f, 0.617998f, 0.270539f, 0.983765f, 
		0.270723f, 0.00676800f, 0.270723f, 0.0101522f, 
		0.270723f, 0.0220750f, 0.270723f, 0.0934232f, 
		0.270723f, 0.142132f, 0.270723f, 0.144438f, 
		0.270723f, 0.169525f, 0.270723f, 0.169544f, 
		0.270723f, 0.169563f, 0.270723f, 0.236887f, 
		0.270723f, 0.269566f, 0.270723f, 0.280680f, 
		0.270723f, 0.291032f, 0.270723f, 0.309249f, 
		0.270723f, 0.384936f, 0.270723f, 0.426396f, 
		0.270723f, 0.428436f, 0.270723f, 0.458015f, 
		0.270723f, 0.458059f, 0.270723f, 0.494077f, 
		0.270723f, 0.548223f, 0.270723f, 0.554582f, 
		0.270723f, 0.568527f, 0.271023f, 0.623504f, 
		0.271079f, 0.147675f, 0.271229f, 0.785902f, 
		0.271777f, 0.980281f, 0.271864f, 0.0823243f, 
		0.271998f, 0.237239f, 0.272188f, 0.00739700f, 
		0.272188f, 0.214520f, 0.272385f, 0.00667550f, 
		0.272385f, 0.771880f, 0.272385f, 0.776792f, 
		0.273420f, 0.398924f, 0.273558f, 0.0414023f, 
		0.273723f, 0.471128f, 0.273847f, 0.265011f, 
		0.274128f, 0.302286f, 0.274361f, 0.00797648f, 
		0.274484f, 0.0296458f, 0.275073f, 0.548942f, 
		0.275210f, 8.27116e-015f, 0.275210f, 0.998535f, 
		0.275437f, 0.508561f, 0.275955f, 0.269666f, 
		0.276100f, 0.523614f, 0.276183f, 0.572714f, 
		0.276382f, 0.425847f, 0.276435f, 0.352114f, 
		0.276441f, 0.339181f, 0.276527f, 0.329082f, 
		0.276551f, 0.327849f, 0.276844f, 0.407243f, 
		0.276871f, 0.342257f, 0.276896f, 0.338876f, 
		0.277114f, 0.525147f, 0.277474f, 0.419639f, 
		0.277493f, 0.330585f, 0.277622f, 0.244058f, 
		0.277638f, 0.244049f, 0.277935f, 0.0814228f, 
		0.277941f, 0.0576702f, 0.278936f, 0.111861f, 
		0.278959f, 0.449284f, 0.279061f, 0.190654f, 
		0.279198f, 0.613309f, 0.279344f, 0.0422579f, 
		0.279349f, 0.195901f, 0.279349f, 0.0385909f, 
		0.279351f, 0.195896f, 0.279356f, 0.0427960f, 
		0.279357f, 0.0380657f, 0.279552f, 0.00772586f, 
		0.279702f, 0.336996f, 0.279899f, 0.727056f, 
		0.280644f, 0.746972f, 0.280696f, 0.717172f, 
		0.280914f, 0.350975f, 0.281165f, 0.180145f, 
		0.281177f, 0.180135f, 0.281185f, 0.533234f, 
		0.281272f, 0.401747f, 0.281272f, 0.517107f, 
		0.281312f, 0.716982f, 0.281639f, 0.0614564f, 
		0.281639f, 0.241286f, 0.281639f, 0.349305f, 
		0.281788f, 0.505648f, 0.281802f, 0.531069f, 
		0.281867f, 0.0846472f, 0.283012f, 0.727036f, 
		0.283257f, 0.659335f, 0.283477f, 0.351468f, 
		0.283505f, 0.351473f, 0.283707f, 0.750386f, 
		0.284005f, 0.463991f, 0.284050f, 0.331619f, 
		0.284092f, 0.340341f, 0.284135f, 0.331693f, 
		0.284489f, 0.333490f, 0.284514f, 0.333287f, 
		0.284870f, 0.627090f, 0.285674f, 0.537284f, 
		0.285684f, 0.00848921f, 0.285684f, 0.742492f, 
		0.286145f, 0.352114f, 0.286341f, 0.537358f, 
		0.286359f, 0.537360f, 0.286380f, 0.441378f, 
		0.286446f, 0.537371f, 0.286896f, 0.517130f, 
		0.286916f, 0.298769f, 0.287430f, 0.692527f, 
		0.287434f, 0.333533f, 0.287543f, 0.0707117f, 
		0.288287f, 0.0725051f, 0.288469f, 0.287349f, 
		0.288503f, 0.107897f, 0.288572f, 0.0577643f, 
		0.288623f, 0.352722f, 0.288626f, 0.352707f, 
		0.288914f, 0.478354f, 0.288918f, 0.478373f, 
		0.288921f, 0.478354f, 0.288934f, 0.478348f, 
		0.289065f, 0.0719146f, 0.289258f, 0.115693f, 
		0.289862f, 0.474904f, 0.289910f, 0.118833f, 
		0.289971f, 0.576985f, 0.290254f, 0.0667191f, 
		0.290526f, 0.516841f, 0.291116f, 0.338337f, 
		0.291134f, 0.00904076f, 0.291134f, 0.744602f, 
		0.291157f, 0.618531f, 0.291240f, 0.0577988f, 
		0.291358f, 0.699253f, 0.291372f, 0.339918f, 
		0.291434f, 0.0612105f, 0.291646f, 0.345240f, 
		0.291648f, 0.345287f, 0.292335f, 0.174572f, 
		0.292432f, 0.330477f, 0.292578f, 0.234678f, 
		0.292579f, 0.742910f, 0.292608f, 0.150150f, 
		0.292762f, 0.00764980f, 0.293098f, 0.767749f, 
		0.293195f, 0.120981f, 0.293272f, 0.603450f, 
		0.293345f, 0.243041f, 0.293419f, 0.413808f, 
		0.293469f, 0.522702f, 0.293556f, 0.407245f, 
		0.293604f, 0.475858f, 0.293670f, 0.0284778f, 
		0.293670f, 0.0320941f, 0.293670f, 0.0321087f, 
		0.293670f, 0.0457000f, 0.293670f, 0.154163f, 
		0.293670f, 0.548087f, 0.293670f, 0.576985f, 
		0.293807f, 0.687924f, 0.293868f, 0.0427960f, 
		0.293870f, 0.0382276f, 0.293897f, 0.0725780f, 
		0.293897f, 0.0810920f, 0.293897f, 0.102668f, 
		0.293897f, 0.202730f, 0.293897f, 0.226658f, 
		0.293897f, 0.243276f, 0.293897f, 0.243276f, 
		0.293897f, 0.387717f, 0.293897f, 0.387774f, 
		0.293897f, 0.405460f, 0.293897f, 0.486552f, 
		0.293897f, 0.527097f, 0.293897f, 0.533686f, 
		0.293897f, 0.533706f, 0.294275f, 0.776792f, 
		0.294343f, 0.548651f, 0.294351f, 0.194176f, 
		0.294383f, 0.320128f, 0.294614f, 0.530705f, 
		0.294758f, 0.433008f, 0.294947f, 0.00949601f, 
		0.295075f, 0.462585f, 0.295220f, 0.372597f, 
		0.295402f, 0.208042f, 0.295440f, 0.207598f, 
		0.295552f, 0.000558869f, 0.295585f, 0.000570035f, 
		0.295627f, 0.183486f, 0.295781f, 0.0981488f, 
		0.295798f, 0.0980970f, 0.295841f, 0.607545f, 
		0.296292f, 0.721422f, 0.296361f, 0.498097f, 
		0.296369f, 0.498071f, 0.297022f, 0.192556f, 
		0.297034f, 0.192568f, 0.297034f, 0.192588f, 
		0.297408f, 0.404189f, 0.297409f, 0.530464f, 
		0.297409f, 0.404209f, 0.297412f, 0.404197f, 
		0.297412f, 0.404211f, 0.297476f, 0.530169f, 
		0.297479f, 0.224429f, 0.297538f, 0.529843f, 
		0.297541f, 0.529860f, 0.297732f, 0.0593837f, 
		0.297954f, 0.735375f, 0.298314f, 0.770075f, 
		0.298594f, 0.0457000f, 0.298731f, 0.765393f, 
		0.298778f, 0.667157f, 0.298866f, 0.156432f, 
		0.298920f, 0.217940f, 0.299181f, 0.0889863f, 
		0.299184f, 0.0669125f, 0.299199f, 0.0547317f, 
		0.299199f, 0.161034f, 0.299199f, 0.260019f, 
		0.299199f, 0.312372f, 0.299199f, 0.440782f, 
		0.299199f, 0.500119f, 0.299199f, 0.603105f, 
		0.299199f, 0.626863f, 0.299199f, 0.877686f, 
		0.299239f, 0.521818f, 0.299246f, 0.521829f, 
		0.299250f, 0.767388f, 0.299561f, 0.677842f, 
		0.299607f, 0.767926f, 0.299706f, 0.767760f, 
		0.299926f, 0.555712f, 0.300082f, 0.116665f, 
		0.300170f, 0.392322f, 0.300436f, 0.291878f, 
		0.300504f, 0.0204537f, 0.300527f, 0.150134f, 
		0.300637f, 0.397273f, 0.300965f, 0.536503f, 
		0.301043f, 0.000000f, 0.301061f, 0.200552f, 
		0.301165f, 0.170770f, 0.301180f, 0.304865f, 
		0.301218f, 0.407084f, 0.301232f, 0.304875f, 
		0.301418f, 0.183176f, 0.301464f, 0.697889f, 
		0.301545f, 0.532730f, 0.301548f, 0.192471f, 
		0.301573f, 0.347969f, 0.301731f, 0.357957f, 
		0.301926f, 0.477051f, 0.301953f, 0.360863f, 
		0.301988f, 0.624753f, 0.302142f, 0.188477f, 
		0.302380f, 0.119239f, 0.302529f, 0.0221757f, 
		0.302529f, 0.776792f, 0.302535f, 0.183538f, 
		0.302535f, 0.195825f, 0.302564f, 0.294812f, 
		0.302595f, 0.404434f, 0.302628f, 0.691271f, 
		0.302656f, 0.135259f, 0.302714f, 0.139510f, 
		0.302738f, 0.569029f, 0.302847f, 0.835659f, 
		0.302856f, 0.608460f, 0.302909f, 0.0256142f, 
		0.302909f, 0.776792f, 0.302959f, 0.617887f, 
		0.303039f, 0.223757f, 0.303057f, 0.864513f, 
		0.303113f, 0.192566f, 0.303186f, 0.288494f, 
		0.303293f, 0.578986f, 0.303381f, 0.392480f, 
		0.303393f, 0.107748f, 0.303711f, 0.187790f, 
		0.303735f, 0.338370f, 0.303789f, 0.391682f, 
		0.303894f, 0.748974f, 0.303902f, 0.193230f, 
		0.303942f, 0.580779f, 0.304006f, 0.778365f, 
		0.304092f, 0.0527599f, 0.304314f, 0.0509223f, 
		0.304384f, 0.451877f, 0.304384f, 0.451905f, 
		0.304419f, 0.530197f, 0.304432f, 0.0238318f, 
		0.304513f, 0.314437f, 0.304632f, 0.863946f, 
		0.304671f, 0.414796f, 0.304773f, 0.0251728f, 
		0.304836f, 0.740272f, 0.304918f, 0.617911f, 
		0.304923f, 0.811115f, 0.304965f, 0.117099f, 
		0.304984f, 0.778365f, 0.305017f, 0.219904f, 
		0.305113f, 0.750526f, 0.305133f, 0.385577f, 
		0.305138f, 0.000000f, 0.305138f, 0.0135488f, 
		0.305138f, 0.0246410f, 0.305138f, 0.0254753f, 
		0.305138f, 0.0255967f, 0.305138f, 0.0361300f, 
		0.305138f, 0.0560707f, 0.305138f, 0.0767763f, 
		0.305138f, 0.128833f, 0.305138f, 0.134425f, 
		0.305138f, 0.134436f, 0.305138f, 0.294591f, 
		0.305138f, 0.304313f, 0.305138f, 0.369416f, 
		0.305138f, 0.375055f, 0.305138f, 0.382039f, 
		0.305138f, 0.422583f, 0.305138f, 0.424525f, 
		0.305138f, 0.442591f, 0.305138f, 0.444707f, 
		0.305138f, 0.469488f, 0.305138f, 0.485825f, 
		0.305138f, 0.506847f, 0.305138f, 0.507530f, 
		0.305138f, 0.525925f, 0.305138f, 0.533125f, 
		0.305138f, 0.545659f, 0.305138f, 0.600061f, 
		0.305138f, 0.605175f, 0.305138f, 0.631779f, 
		0.305138f, 0.641305f, 0.305138f, 0.670488f, 
		0.305138f, 0.670823f, 0.305138f, 0.683537f, 
		0.305138f, 0.700016f, 0.305138f, 0.750223f, 
		0.305138f, 0.750556f, 0.305138f, 0.758727f, 
		0.305138f, 0.760761f, 0.305138f, 0.761262f, 
		0.305138f, 0.776792f, 0.305164f, 0.198093f, 
		0.305208f, 0.0224839f, 0.305268f, 0.377278f, 
		0.305317f, 0.567043f, 0.305347f, 0.544457f, 
		0.305627f, 0.863949f, 0.305744f, 0.118330f, 
		0.305770f, 0.671987f, 0.305803f, 0.203064f, 
		0.305806f, 0.811113f, 0.305836f, 0.580624f, 
		0.305906f, 0.210273f, 0.306129f, 0.863950f, 
		0.306252f, 0.863951f, 0.306603f, 0.000000f, 
		0.306603f, 0.0541777f, 0.306603f, 0.0864318f, 
		0.306603f, 0.0864450f, 0.306603f, 0.0874249f, 
		0.306603f, 0.167405f, 0.306603f, 0.190475f, 
		0.306603f, 0.190494f, 0.306603f, 0.216272f, 
		0.306603f, 0.216296f, 0.306603f, 0.216309f, 
		0.306603f, 0.216323f, 0.306603f, 0.241526f, 
		0.306603f, 0.302256f, 0.306603f, 0.302434f, 
		0.306603f, 0.302448f, 0.306603f, 0.302467f, 
		0.306603f, 0.319939f, 0.306603f, 0.320193f, 
		0.306603f, 0.389845f, 0.306603f, 0.391724f, 
		0.306603f, 0.411628f, 0.306603f, 0.426040f, 
		0.306603f, 0.466312f, 0.306603f, 0.467523f, 
		0.306603f, 0.470273f, 0.306603f, 0.470847f, 
		0.306603f, 0.513223f, 0.306603f, 0.534337f, 
		0.306603f, 0.553726f, 0.306603f, 0.554496f, 
		0.306603f, 0.554508f, 0.306603f, 0.554532f, 
		0.306603f, 0.596499f, 0.306603f, 0.640857f, 
		0.306603f, 0.640910f, 0.306603f, 0.640921f, 
		0.306603f, 0.640935f, 0.306603f, 0.646730f, 
		0.306603f, 0.723315f, 0.306603f, 0.829589f, 
		0.306603f, 0.881386f, 0.306603f, 0.897659f, 
		0.306603f, 0.903097f, 0.306713f, 0.536717f, 
		0.306738f, 0.778365f, 0.306751f, 0.000000f, 
		0.306751f, 0.00357169f, 0.306751f, 0.00553521f, 
		0.306751f, 0.00580450f, 0.306751f, 0.0827258f, 
		0.306751f, 0.0870430f, 0.306751f, 0.617809f, 
		0.306751f, 0.811110f, 0.306793f, 0.204245f, 
		0.306885f, 0.210751f, 0.306938f, 0.335078f, 
		0.307111f, 0.504600f, 0.307317f, 0.504164f, 
		0.307609f, 0.784125f, 0.307854f, 0.280600f, 
		0.307911f, 0.0870079f, 0.307911f, 0.0869973f, 
		0.307933f, 0.807735f, 0.308090f, 0.572130f, 
		0.308179f, 0.442158f, 0.308350f, 0.894579f, 
		0.308377f, 0.0830252f, 0.308476f, 0.571985f, 
		0.308497f, 0.202192f, 0.308520f, 0.167960f, 
		0.308557f, 0.804725f, 0.308670f, 0.670921f, 
		0.308745f, 0.0536454f, 0.308757f, 0.0731862f, 
		0.308894f, 0.0812673f, 0.309086f, 0.0216764f, 
		0.309316f, 0.131617f, 0.309359f, 0.301998f, 
		0.310045f, 0.0158341f, 0.310045f, 0.571442f, 
		0.310047f, 0.152495f, 0.310413f, 0.276939f, 
		0.310730f, 0.302833f, 0.310805f, 0.286596f, 
		0.310978f, 0.871626f, 0.311183f, 0.117646f, 
		0.311326f, 0.204698f, 0.311526f, 0.477156f, 
		0.311632f, 0.113606f, 0.311632f, 0.417110f, 
		0.311650f, 0.442141f, 0.311879f, 0.623624f, 
		0.312107f, 0.0990570f, 0.312258f, 0.450451f, 
		0.312290f, 0.0953882f, 0.312338f, 0.000000f, 
		0.312338f, 0.998535f, 0.312382f, 0.739078f, 
		0.312415f, 0.880285f, 0.312995f, 0.0873927f, 
		0.313076f, 0.000000f, 0.313094f, 0.000000f, 
		0.313195f, 0.132012f, 0.313220f, 0.491239f, 
		0.313263f, 0.630212f, 0.313339f, 0.819751f, 
		0.313406f, 0.846378f, 0.313560f, 0.845444f, 
		0.313796f, 0.636913f, 0.313821f, 0.162841f, 
		0.313885f, 0.0174113f, 0.313885f, 0.0174273f, 
		0.313885f, 0.0379110f, 0.313885f, 0.0633275f, 
		0.313885f, 0.212719f, 0.313885f, 0.212735f, 
		0.313885f, 0.228308f, 0.313885f, 0.279477f, 
		0.313885f, 0.308285f, 0.313885f, 0.371854f, 
		0.313885f, 0.371867f, 0.313885f, 0.371890f, 
		0.313885f, 0.415147f, 0.313885f, 0.428253f, 
		0.313885f, 0.490888f, 0.313885f, 0.510990f, 
		0.313885f, 0.511007f, 0.313885f, 0.541803f, 
		0.313941f, 0.865017f, 0.313944f, 0.865007f, 
		0.314320f, 0.425929f, 0.314331f, 0.136893f, 
		0.314369f, 0.181006f, 0.314847f, 0.134390f, 
		0.315350f, 0.0963933f, 0.315350f, 0.418843f, 
		0.315371f, 0.631868f, 0.315490f, 0.282494f, 
		0.315504f, 0.244254f, 0.316428f, 0.00198690f, 
		0.316452f, 0.00297740f, 0.316464f, 0.00198334f, 
		0.316886f, 0.000974832f, 0.316970f, 0.0798700f, 
		0.316977f, 0.0798572f, 0.317049f, 0.163089f, 
		0.317539f, 0.307506f, 0.317875f, 0.0634745f, 
		0.318776f, 0.483914f, 0.319104f, 0.838217f, 
		0.319471f, 0.676075f, 0.319725f, 0.0122233f, 
		0.319725f, 0.0251629f, 0.319725f, 0.0975385f, 
		0.319725f, 0.173476f, 0.319725f, 0.189128f, 
		0.319725f, 0.204864f, 0.319725f, 0.230647f, 
		0.319725f, 0.329412f, 0.319725f, 0.368053f, 
		0.319725f, 0.416535f, 0.321832f, 0.730938f, 
		0.322297f, 0.126927f, 0.322595f, 0.0721840f, 
		0.322698f, 0.293377f, 0.322743f, 0.308585f, 
		0.323725f, 0.00307589f, 0.323725f, 0.427209f, 
		0.324119f, 0.0740889f, 0.324119f, 0.0941881f, 
		0.324122f, 0.0254952f, 0.324147f, 0.150678f, 
		0.324147f, 0.150881f, 0.324160f, 8.88178e-015f, 
		0.324160f, 0.998535f, 0.324235f, 0.730683f, 
		0.324380f, 0.156626f, 0.324964f, 0.0673486f, 
		0.325190f, 0.357441f, 0.325212f, 0.739800f, 
		0.325296f, 0.169112f, 0.325303f, 0.110821f, 
		0.325543f, 0.400128f, 0.325549f, 0.212995f, 
		0.325996f, 0.293659f, 0.326108f, 0.735879f, 
		0.326137f, 0.0630236f, 0.326404f, 0.392016f, 
		0.326533f, 0.355770f, 0.326753f, 0.726998f, 
		0.326795f, 0.0324381f, 0.326950f, 0.338352f, 
		0.326969f, 0.375633f, 0.327086f, 0.350221f, 
		0.327134f, 0.207745f, 0.327137f, 0.0107274f, 
		0.327137f, 0.420516f, 0.327205f, 0.242600f, 
		0.327345f, 0.212603f, 0.327349f, 0.218230f, 
		0.327434f, 0.355297f, 0.327476f, 0.706559f, 
		0.327516f, 0.0782537f, 0.327545f, 0.148799f, 
		0.327565f, 0.212936f, 0.328082f, 0.00694440f, 
		0.328082f, 0.432310f, 0.328137f, 0.227358f, 
		0.328387f, 0.432492f, 0.328610f, 0.392646f, 
		0.328970f, 0.241498f, 0.328970f, 0.244843f, 
		0.328989f, 0.304930f, 0.329004f, 0.194238f, 
		0.329009f, 0.0828869f, 0.329026f, 0.147631f, 
		0.329034f, 0.126292f, 0.329108f, 0.200299f, 
		0.329297f, 0.152524f, 0.329877f, 0.0150182f, 
		0.330148f, 0.282888f, 0.330205f, 0.148968f, 
		0.330224f, 0.276064f, 0.330248f, 0.124392f, 
		0.330269f, 0.0964280f, 0.330358f, 0.0795012f, 
		0.330384f, 0.278986f, 0.330386f, 0.212995f, 
		0.330404f, 0.339202f, 0.330468f, 0.275774f, 
		0.330487f, 0.498498f, 0.330565f, 0.0804306f, 
		0.330662f, 0.205750f, 0.330663f, 0.176280f, 
		0.331377f, 0.254025f, 0.331499f, 0.291920f, 
		0.331558f, 0.304616f, 0.331701f, 0.307482f, 
		0.332129f, 0.858239f, 0.332510f, 0.470142f, 
		0.332542f, 0.721090f, 0.332849f, 0.000000f, 
		0.332849f, 0.0386684f, 0.332849f, 0.110675f, 
		0.332849f, 0.132809f, 0.332849f, 0.156217f, 
		0.332849f, 0.166423f, 0.332849f, 0.198479f, 
		0.332849f, 0.207119f, 0.332849f, 0.211614f, 
		0.332849f, 0.237739f, 0.332849f, 0.249209f, 
		0.332849f, 0.249746f, 0.332849f, 0.255404f, 
		0.332849f, 0.293050f, 0.332849f, 0.342571f, 
		0.332849f, 0.399382f, 0.332849f, 0.428068f, 
		0.333402f, 0.0752238f, 0.333627f, 0.231130f, 
		0.333658f, 0.0109995f, 0.333732f, 0.190946f, 
		0.333900f, 0.339530f, 0.334324f, 0.248624f, 
		0.334945f, 0.00976395f, 0.335122f, 0.239174f, 
		0.335153f, 0.857630f, 0.335318f, 0.279239f, 
		0.335679f, 0.344347f, 0.335783f, 0.527466f, 
		0.336286f, 0.522398f, 0.336467f, 0.0807079f, 
		0.336518f, 0.120714f, 0.336805f, 0.0651291f, 
		0.336890f, 0.367409f, 0.336917f, 0.0123242f, 
		0.336981f, 0.269186f, 0.337041f, 0.404846f, 
		0.337179f, 0.519932f, 0.337183f, 0.435152f, 
		0.337372f, 0.119082f, 0.337372f, 0.143101f, 
		0.337500f, 0.745887f, 0.337605f, 0.370867f, 
		0.337693f, 0.183854f, 0.337775f, 0.251823f, 
		0.337782f, 0.0722004f, 0.337835f, 0.305990f, 
		0.338061f, 0.00931948f, 0.338136f, 0.0800464f, 
		0.338156f, 0.0115943f, 0.338192f, 0.0786286f, 
		0.338197f, 0.316391f, 0.338238f, 0.154254f, 
		0.338359f, 0.312169f, 0.338533f, 0.000000f, 
		0.338753f, 0.243877f, 0.338870f, 0.381764f, 
		0.338887f, 0.755706f, 0.338888f, 0.316861f, 
		0.338900f, 0.755679f, 0.338901f, 0.316834f, 
		0.339225f, 0.433549f, 0.339333f, 0.356727f, 
		0.339506f, 0.891189f, 0.339558f, 0.573188f, 
		0.339750f, 0.173974f, 0.339898f, 0.566718f, 
		0.340064f, 0.371007f, 0.340067f, 0.0902756f, 
		0.340074f, 0.0171873f, 0.340097f, 0.415666f, 
		0.340220f, 0.415012f, 0.340585f, 0.342173f, 
		0.340658f, 0.317768f, 0.340688f, 0.415202f, 
		0.340750f, 0.317788f, 0.340751f, 0.249355f, 
		0.341341f, 0.159720f, 0.341347f, 0.734583f, 
		0.341361f, 0.734644f, 0.341370f, 0.174660f, 
		0.341377f, 0.498283f, 0.341559f, 0.430750f, 
		0.341604f, 0.144971f, 0.341844f, 0.0631586f, 
		0.341921f, 0.484915f, 0.342061f, 0.398163f, 
		0.342064f, 0.430144f, 0.342144f, 0.281372f, 
		0.342352f, 0.757252f, 0.342552f, 0.347262f, 
		0.342638f, 0.627945f, 0.342728f, 0.281406f, 
		0.342850f, 0.396275f, 0.342973f, 0.279970f, 
		0.342982f, 0.775645f, 0.343133f, 0.720758f, 
		0.343192f, 0.131198f, 0.343327f, 0.530839f, 
		0.343396f, 0.556078f, 0.343427f, 0.277058f, 
		0.343664f, 0.678929f, 0.343794f, 0.338244f, 
		0.343854f, 0.335539f, 0.343994f, 0.542902f, 
		0.344055f, 0.535254f, 0.344174f, 0.615205f, 
		0.344458f, 0.330964f, 0.345663f, 0.0488536f, 
		0.345932f, 0.153130f, 0.346014f, 0.204919f, 
		0.346994f, 0.424720f, 0.347045f, 0.736209f, 
		0.347054f, 0.762523f, 0.347513f, 0.519642f, 
		0.347793f, 0.895551f, 0.347834f, 0.520839f, 
		0.347842f, 0.520350f, 0.348090f, 0.600673f, 
		0.348339f, 0.161364f, 0.348882f, 0.379302f, 
		0.349058f, 0.773606f, 0.349322f, 0.299318f, 
		0.349352f, 0.287288f, 0.349782f, 0.332418f, 
		0.349909f, 0.439678f, 0.349923f, 0.155499f, 
		0.350112f, 0.170325f, 0.350159f, 0.0140486f, 
		0.350348f, 0.397072f, 0.351121f, 0.0168017f, 
		0.351200f, 0.250065f, 0.351286f, 0.000000f, 
		0.351286f, 0.0809634f, 0.351286f, 0.0809808f, 
		0.351286f, 0.0810175f, 0.351286f, 0.109437f, 
		0.351286f, 0.127972f, 0.351286f, 0.135779f, 
		0.351286f, 0.182512f, 0.351286f, 0.201689f, 
		0.351286f, 0.267050f, 0.351286f, 0.334616f, 
		0.351286f, 0.342442f, 0.351286f, 0.357419f, 
		0.351286f, 0.372128f, 0.351286f, 0.409614f, 
		0.351286f, 0.434414f, 0.351286f, 0.450855f, 
		0.351286f, 0.498952f, 0.351286f, 0.501568f, 
		0.351286f, 0.533182f, 0.351286f, 0.580544f, 
		0.351286f, 0.595762f, 0.351286f, 0.605342f, 
		0.351286f, 0.615474f, 0.351286f, 0.615831f, 
		0.351286f, 0.660942f, 0.351286f, 0.677247f, 
		0.351286f, 0.688545f, 0.351286f, 0.696652f, 
		0.351286f, 0.755495f, 0.351286f, 0.766318f, 
		0.351286f, 0.835983f, 0.351286f, 0.860809f, 
		0.351286f, 0.860893f, 0.351286f, 0.878211f, 
		0.351286f, 0.938752f, 0.351286f, 0.938807f, 
		0.351286f, 0.981777f, 0.351286f, 0.998535f, 
		0.351910f, 0.000000f, 0.351927f, 0.602981f, 
		0.352161f, 0.852159f, 0.352684f, 0.754839f, 
		0.353085f, 0.716781f, 0.353131f, 0.627940f, 
		0.353161f, 0.169946f, 0.353339f, 0.473254f, 
		0.353353f, 0.473231f, 0.353361f, 0.473309f, 
		0.353646f, 0.437999f, 0.353956f, 0.823477f, 
		0.354552f, 0.428782f, 0.354624f, 0.166773f, 
		0.354730f, 0.0224232f, 0.355158f, 0.560488f, 
		0.355261f, 0.701449f, 0.355267f, 0.702291f, 
		0.355402f, 0.328369f, 0.355625f, 0.148544f, 
		0.356297f, 0.218160f, 0.356297f, 0.895483f, 
		0.356590f, 0.704437f, 0.356644f, 0.288528f, 
		0.357339f, 0.528743f, 0.357532f, 0.287194f, 
		0.357790f, 0.278791f, 0.357970f, 0.773374f, 
		0.358818f, 0.0523114f, 0.359055f, 0.393178f, 
		0.360527f, 0.208650f, 0.361188f, 0.446429f, 
		0.361288f, 0.000000f, 0.361288f, 0.998535f, 
		0.361540f, 0.0470002f, 0.361580f, 0.599427f, 
		0.361672f, 0.164676f, 0.361921f, 0.603374f, 
		0.362175f, 0.184439f, 0.362188f, 0.624173f, 
		0.362566f, 0.159679f, 0.362749f, 0.222943f, 
		0.363094f, 0.157677f, 0.363706f, 0.0317929f, 
		0.364594f, 0.301558f, 0.365001f, 0.619417f, 
		0.365025f, 0.112072f, 0.365359f, 0.477915f, 
		0.365485f, 0.504570f, 0.366631f, 0.0126951f, 
		0.366639f, 0.00470610f, 0.367828f, 0.00552705f, 
		0.368071f, 0.725939f, 0.368785f, 0.267858f, 
		0.369033f, 0.859257f, 0.369038f, 0.859242f, 
		0.369082f, 0.803507f, 0.369472f, 0.360274f, 
		0.369742f, 0.219402f, 0.369944f, 0.820269f, 
		0.370111f, 0.000000f, 0.370146f, 0.443124f, 
		0.370159f, 0.218610f, 0.370547f, 0.222278f, 
		0.370599f, 0.662639f, 0.370782f, 0.00100505f, 
		0.371279f, 0.212602f, 0.371626f, 0.641792f, 
		0.372137f, 0.446434f, 0.372199f, 0.446400f, 
		0.372208f, 0.658530f, 0.372208f, 0.660374f, 
		0.372251f, 0.865990f, 0.372262f, 0.865987f, 
		0.372399f, 0.754892f, 0.372407f, 0.754913f, 
		0.372433f, 0.727584f, 0.372437f, 0.727597f, 
		0.372695f, 0.223158f, 0.372915f, 0.214635f, 
		0.373109f, 0.000000f, 0.373109f, 0.998535f, 
		0.373495f, 0.872131f, 0.373984f, 0.354647f, 
		0.374016f, 0.362085f, 0.374042f, 0.346258f, 
		0.374083f, 0.0760930f, 0.374091f, 0.0596679f, 
		0.374099f, 0.114096f, 0.374114f, 0.138775f, 
		0.374137f, 0.295593f, 0.374139f, 0.00555832f, 
		0.374158f, 0.000000f, 0.374158f, 0.00358698f, 
		0.374158f, 0.0494066f, 0.374158f, 0.0530597f, 
		0.374158f, 0.142902f, 0.374158f, 0.144378f, 
		0.374158f, 0.213030f, 0.374158f, 0.261987f, 
		0.374158f, 0.303886f, 0.374158f, 0.308488f, 
		0.374158f, 0.412889f, 0.374158f, 0.419159f, 
		0.374158f, 0.423079f, 0.374158f, 0.423988f, 
		0.374230f, 0.217637f, 0.374235f, 0.0486696f, 
		0.374594f, 0.152290f, 0.374594f, 0.378065f, 
		0.374703f, 0.857308f, 0.375057f, 0.218585f, 
		0.375115f, 0.890736f, 0.375183f, 0.208730f, 
		0.375534f, 0.364526f, 0.375562f, 0.814004f, 
		0.375622f, 0.00612250f, 0.375622f, 0.0306125f, 
		0.375622f, 0.0733889f, 0.375622f, 0.331550f, 
		0.375622f, 0.347477f, 0.375622f, 0.466194f, 
		0.375622f, 0.471431f, 0.375804f, 0.176763f, 
		0.375845f, 0.226147f, 0.376562f, 0.872018f, 
		0.376720f, 0.737439f, 0.376833f, 0.736951f, 
		0.377060f, 0.404138f, 0.377114f, 0.216648f, 
		0.377165f, 0.110163f, 0.377202f, 0.00595785f, 
		0.377210f, 0.820011f, 0.377513f, 0.175501f, 
		0.377650f, 0.0240589f, 0.377987f, 0.759533f, 
		0.378605f, 0.0152007f, 0.378605f, 0.498634f, 
		0.379055f, 0.0114354f, 0.379175f, 0.00247701f, 
		0.379276f, 0.254987f, 0.379352f, 0.444385f, 
		0.379427f, 0.872253f, 0.379512f, 0.0124395f, 
		0.379524f, 0.163581f, 0.379607f, 0.0110716f, 
		0.379607f, 0.506563f, 0.379633f, 0.0742451f, 
		0.379714f, 0.171681f, 0.379716f, 0.428815f, 
		0.379717f, 0.428779f, 0.379723f, 0.218801f, 
		0.379840f, 0.117207f, 0.379853f, 0.117212f, 
		0.379935f, 0.781281f, 0.379956f, 0.598845f, 
		0.379962f, 0.0241940f, 0.379962f, 0.0874360f, 
		0.379962f, 0.129191f, 0.379962f, 0.175955f, 
		0.379962f, 0.263391f, 0.379962f, 0.305146f, 
		0.379962f, 0.351910f, 0.379962f, 0.376104f, 
		0.379962f, 0.439346f, 0.379962f, 0.481101f, 
		0.379962f, 0.527865f, 0.379962f, 0.594183f, 
		0.379962f, 0.615300f, 0.379962f, 0.657056f, 
		0.380022f, 0.349073f, 0.380097f, 0.266836f, 
		0.380114f, 0.660427f, 0.380138f, 0.147347f, 
		0.380168f, 0.879380f, 0.380181f, 0.879386f, 
		0.380515f, 0.520597f, 0.380598f, 0.261777f, 
		0.380784f, 0.365090f, 0.380831f, 0.269089f, 
		0.380928f, 0.433247f, 0.381087f, 0.532101f, 
		0.381130f, 0.440618f, 0.381163f, 0.443033f, 
		0.381306f, 0.508803f, 0.381423f, 0.226355f, 
		0.381427f, 0.0319730f, 0.381427f, 0.487438f, 
		0.381673f, 0.466279f, 0.381732f, 0.260138f, 
		0.381769f, 0.0222740f, 0.381790f, 0.493086f, 
		0.381863f, 0.00750947f, 0.381864f, 0.870596f, 
		0.381870f, 0.00752561f, 0.381873f, 0.00749453f, 
		0.382232f, 0.661307f, 0.382283f, 0.326252f, 
		0.382407f, 0.670443f, 0.382436f, 0.0238010f, 
		0.382495f, 0.0915150f, 0.382507f, 0.581455f, 
		0.382579f, 0.671854f, 0.382617f, 0.250214f, 
		0.382636f, 0.0631964f, 0.382889f, 0.475749f, 
		0.382889f, 0.481429f, 0.383002f, 0.0725769f, 
		0.383016f, 0.206217f, 0.383023f, 0.206200f, 
		0.383064f, 0.410406f, 0.383121f, 0.410480f, 
		0.383259f, 0.532470f, 0.383262f, 0.532481f, 
		0.383580f, 0.519939f, 0.383609f, 0.0644867f, 
		0.383631f, 0.506287f, 0.383708f, 0.0450613f, 
		0.383851f, 0.354702f, 0.383852f, 0.741889f, 
		0.384163f, 0.138896f, 0.384163f, 0.590445f, 
		0.384163f, 0.816218f, 0.384248f, 0.0830411f, 
		0.384355f, 0.210501f, 0.384523f, 0.140803f, 
		0.384546f, 0.147762f, 0.384573f, 0.00703410f, 
		0.384573f, 0.0172384f, 0.384573f, 0.247421f, 
		0.384573f, 0.258482f, 0.384573f, 0.274383f, 
		0.384573f, 0.504565f, 0.384573f, 0.505649f, 
		0.384583f, 0.153627f, 0.384586f, 0.519612f, 
		0.384624f, 0.410608f, 0.384723f, 0.00819761f, 
		0.384723f, 0.167075f, 0.384723f, 0.272911f, 
		0.384723f, 0.292061f, 0.384723f, 0.292111f, 
		0.384723f, 0.294007f, 0.384723f, 0.433381f, 
		0.384723f, 0.449385f, 0.384911f, 0.796381f, 
		0.384952f, 0.350242f, 0.384964f, 0.409346f, 
		0.384965f, 0.152210f, 0.384966f, 0.409355f, 
		0.385170f, 0.302958f, 0.385424f, 0.0154040f, 
		0.385425f, 0.108781f, 0.385563f, 0.262478f, 
		0.385667f, 0.126163f, 0.385786f, 0.0654964f, 
		0.385893f, 0.497984f, 0.385893f, 0.500895f, 
		0.386017f, 0.132235f, 0.386051f, 0.509838f, 
		0.386056f, 0.336964f, 0.386064f, 0.299819f, 
		0.386111f, 0.233174f, 0.386188f, 0.0384080f, 
		0.386188f, 0.577526f, 0.386353f, 0.0322025f, 
		0.386584f, 0.199915f, 0.386716f, 0.0364936f, 
		0.386777f, 0.360379f, 0.386816f, 0.496794f, 
		0.386825f, 0.630943f, 0.386847f, 0.146200f, 
		0.386904f, 0.797969f, 0.386917f, 0.647860f, 
		0.386994f, 0.645782f, 0.387003f, 0.173799f, 
		0.387112f, 0.170176f, 0.387125f, 0.169446f, 
		0.387149f, 0.169066f, 0.387183f, 0.608859f, 
		0.387224f, 0.712916f, 0.387315f, 0.843300f, 
		0.387332f, 0.899493f, 0.387382f, 0.710401f, 
		0.387426f, 0.897917f, 0.387443f, 0.810316f, 
		0.387453f, 0.506521f, 0.387483f, 0.900188f, 
		0.387507f, 0.319024f, 0.387556f, 0.0519138f, 
		0.387556f, 0.309091f, 0.387556f, 0.469351f, 
		0.387569f, 0.477462f, 0.387786f, 0.539477f, 
		0.387798f, 0.539480f, 0.387923f, 0.418556f, 
		0.387930f, 0.0745177f, 0.387963f, 0.418067f, 
		0.388016f, 0.417680f, 0.388018f, 0.0760410f, 
		0.388041f, 0.0767395f, 0.388098f, 0.0775999f, 
		0.388193f, 0.741949f, 0.388225f, 0.479507f, 
		0.388315f, 0.882951f, 0.388341f, 0.740235f, 
		0.388411f, 0.453112f, 0.388417f, 0.549990f, 
		0.388433f, 0.252355f, 0.388697f, 0.408328f, 
		0.388700f, 0.408317f, 0.388716f, 0.553058f, 
		0.388732f, 0.950877f, 0.388733f, 0.408332f, 
		0.388792f, 0.0178634f, 0.388940f, 0.485457f, 
		0.388983f, 0.710514f, 0.388992f, 0.951854f, 
		0.389111f, 0.465852f, 0.389123f, 0.331204f, 
		0.389179f, 0.864293f, 0.389226f, 0.236998f, 
		0.389295f, 0.125571f, 0.389305f, 0.473029f, 
		0.389395f, 0.878303f, 0.389417f, 0.501225f, 
		0.389444f, 0.241423f, 0.389545f, 0.0988565f, 
		0.389629f, 0.539314f, 0.389784f, 0.466393f, 
		0.389796f, 0.194226f, 0.389869f, 0.0490987f, 
		0.389877f, 0.306221f, 0.390106f, 0.241175f, 
		0.390132f, 0.243597f, 0.390376f, 0.333181f, 
		0.390386f, 0.333443f, 0.390386f, 0.143939f, 
		0.390424f, 0.245384f, 0.390424f, 0.262207f, 
		0.390441f, 0.338866f, 0.390589f, 0.951052f, 
		0.390601f, 0.132234f, 0.390606f, 0.951025f, 
		0.390627f, 0.333394f, 0.390639f, 0.143945f, 
		0.390654f, 0.546215f, 0.390814f, 0.00273778f, 
		0.391007f, 0.470320f, 0.391029f, 0.510257f, 
		0.391132f, 0.0766999f, 0.391370f, 0.00412118f, 
		0.391373f, 0.368240f, 0.391391f, 0.368236f, 
		0.391440f, 0.419150f, 0.391447f, 0.419161f, 
		0.391500f, 0.509369f, 0.392166f, 0.000723047f, 
		0.392256f, 0.000556859f, 0.392708f, 0.413195f, 
		0.392757f, 0.431688f, 0.393034f, 0.500891f, 
		0.393089f, 0.464771f, 0.393580f, 0.307027f, 
		0.394151f, 0.311005f, 0.394163f, 0.231324f, 
		0.395041f, 0.544510f, 0.395061f, 0.544512f, 
		0.395993f, 0.488118f, 0.396677f, 0.00883950f, 
		0.396677f, 0.216631f, 0.396677f, 0.231387f, 
		0.396677f, 0.280810f, 0.396677f, 0.328615f, 
		0.396677f, 0.394557f, 0.396677f, 0.457187f, 
		0.396677f, 0.514289f, 0.397088f, 0.518267f, 
		0.398348f, 0.582234f, 0.398385f, 0.582212f, 
		0.398396f, 0.582206f, 0.399098f, 0.428763f, 
		0.399157f, 0.0911989f, 0.399483f, 0.426860f, 
		0.399766f, 0.269567f, 0.400368f, 0.0121722f, 
		0.400373f, 0.0121619f, 0.400379f, 0.0121516f, 
		0.400392f, 0.0121266f, 0.401772f, 0.0118404f, 
		0.401832f, 0.286254f, 0.402149f, 0.367875f, 
		0.402542f, 0.330266f, 0.402634f, 0.0319730f, 
		0.402850f, 0.0205459f, 0.402886f, 0.508031f, 
		0.402989f, 0.0225636f, 0.402997f, 0.466335f, 
		0.403075f, 0.487640f, 0.403392f, 0.0267898f, 
		0.403791f, 0.509834f, 0.404239f, 0.535757f, 
		0.404654f, 0.353724f, 0.404772f, 0.0141576f, 
		0.404958f, 0.181049f, 0.405609f, 0.164466f, 
		0.405711f, 0.519791f, 0.405747f, 0.163133f, 
		0.405787f, 0.519159f, 0.405875f, 0.154631f, 
		0.405912f, 0.438121f, 0.406295f, 0.153460f, 
		0.406606f, 0.181655f, 0.406761f, 0.0681513f, 
		0.406761f, 0.217467f, 0.406761f, 0.217478f, 
		0.406761f, 0.217497f, 0.406761f, 0.689001f, 
		0.406761f, 0.903097f, 0.406916f, 0.159907f, 
		0.407239f, 0.516077f, 0.407357f, 0.250840f, 
		0.407486f, 0.241242f, 0.407498f, 0.0543035f, 
		0.407630f, 0.245910f, 0.407760f, 0.250113f, 
		0.407784f, 0.286757f, 0.407870f, 0.203090f, 
		0.407922f, 0.0420408f, 0.408085f, 0.000000f, 
		0.408085f, 0.00714300f, 0.408085f, 0.0107145f, 
		0.408085f, 0.0214290f, 0.408085f, 0.0724906f, 
		0.408085f, 0.0758253f, 0.408085f, 0.0759329f, 
		0.408085f, 0.0760923f, 0.408085f, 0.100116f, 
		0.408085f, 0.121429f, 0.408085f, 0.207144f, 
		0.408085f, 0.212856f, 0.408085f, 0.221392f, 
		0.408085f, 0.223216f, 0.408085f, 0.235716f, 
		0.408085f, 0.239287f, 0.408085f, 0.265324f, 
		0.408085f, 0.280777f, 0.408085f, 0.307260f, 
		0.408085f, 0.336849f, 0.408085f, 0.351034f, 
		0.408085f, 0.369243f, 0.408085f, 0.392860f, 
		0.408085f, 0.413046f, 0.408085f, 0.436455f, 
		0.408085f, 0.454588f, 0.408085f, 0.458223f, 
		0.408085f, 0.466564f, 0.408085f, 0.478575f, 
		0.408085f, 0.495015f, 0.408085f, 0.495556f, 
		0.408085f, 0.507146f, 0.408085f, 0.519895f, 
		0.408085f, 0.611312f, 0.408085f, 0.613046f, 
		0.408085f, 0.614868f, 0.408085f, 0.640152f, 
		0.408085f, 0.695430f, 0.408085f, 0.702091f, 
		0.408085f, 0.757943f, 0.408123f, 0.0420733f, 
		0.408123f, 0.365423f, 0.408443f, 0.368600f, 
		0.408880f, 0.518073f, 0.409463f, 0.000000f, 
		0.409463f, 0.605897f, 0.409465f, 0.145161f, 
		0.409468f, 0.000000f, 0.409468f, 0.605896f, 
		0.410123f, 0.0738855f, 0.410123f, 0.0754179f, 
		0.410123f, 0.116155f, 0.410123f, 0.118768f, 
		0.410123f, 0.126546f, 0.410123f, 0.211358f, 
		0.410123f, 0.211582f, 0.410123f, 0.293169f, 
		0.410123f, 0.321574f, 0.410123f, 0.342492f, 
		0.410123f, 0.414294f, 0.410123f, 0.414790f, 
		0.410123f, 0.473957f, 0.410123f, 0.475677f, 
		0.410123f, 0.558370f, 0.410123f, 0.558511f, 
		0.411587f, 0.000000f, 0.411587f, 0.0104203f, 
		0.411587f, 0.0430995f, 0.411587f, 0.0566593f, 
		0.411587f, 0.105326f, 0.411587f, 0.160075f, 
		0.411587f, 0.162143f, 0.411587f, 0.218205f, 
		0.411587f, 0.220256f, 0.411587f, 0.274946f, 
		0.411587f, 0.275282f, 0.411587f, 0.323369f, 
		0.411587f, 0.328304f, 0.411587f, 0.373110f, 
		0.411587f, 0.376856f, 0.416718f, 0.757422f, 
		0.417268f, 0.758152f, 0.417796f, 0.758851f, 
		0.423201f, 0.387060f, 0.423349f, 0.000000f, 
		0.423349f, 0.771348f, 0.423841f, 0.0194370f, 
		0.423927f, 0.0314803f, 0.424209f, 0.0282946f, 
		0.424520f, 0.0244979f, 0.424551f, 0.519756f, 
		0.424615f, 0.164922f, 0.425383f, 0.282400f, 
		0.425655f, 0.681670f, 0.425707f, 0.154465f, 
		0.426359f, 0.147631f, 0.426866f, 0.330706f, 
		0.426971f, 0.0680767f, 0.427081f, 0.00219752f, 
		0.427440f, 0.559829f, 0.427989f, 0.219753f, 
		0.428126f, 0.0658851f, 0.428142f, 0.521115f, 
		0.428611f, 0.0217403f, 0.428711f, 0.752673f, 
		0.428795f, 0.0220264f, 0.429003f, 0.405430f, 
		0.429348f, 0.741907f, 0.429368f, 0.247031f, 
		0.429485f, 0.741518f, 0.430105f, 0.138066f, 
		0.431219f, 0.00582075f, 0.431219f, 0.369798f, 
		0.431219f, 0.369815f, 0.431219f, 0.369832f, 
		0.431219f, 0.897386f, 0.431906f, 0.00356661f, 
		0.431906f, 0.00413431f, 0.431906f, 0.0347775f, 
		0.431906f, 0.0540900f, 0.431906f, 0.0756546f, 
		0.431906f, 0.0833581f, 0.431906f, 0.117195f, 
		0.431906f, 0.250008f, 0.431906f, 0.258735f, 
		0.431906f, 0.258868f, 0.431906f, 0.258887f, 
		0.431906f, 0.264948f, 0.431906f, 0.292119f, 
		0.431906f, 0.315524f, 0.431906f, 0.334762f, 
		0.431906f, 0.348007f, 0.431906f, 0.354887f, 
		0.431906f, 0.354906f, 0.431906f, 0.369568f, 
		0.431906f, 0.396767f, 0.431906f, 0.423959f, 
		0.431906f, 0.440225f, 0.431906f, 0.441734f, 
		0.431906f, 0.479540f, 0.431906f, 0.499201f, 
		0.431906f, 0.515127f, 0.431906f, 0.599075f, 
		0.431906f, 0.603460f, 0.431906f, 0.625574f, 
		0.431906f, 0.642965f, 0.431906f, 0.701530f, 
		0.431906f, 0.762754f, 0.431906f, 0.762856f, 
		0.432232f, 0.767726f, 0.433648f, 0.474530f, 
		0.433662f, 0.863769f, 0.433793f, 0.415534f, 
		0.433821f, 0.860138f, 0.433869f, 0.856423f, 
		0.433879f, 0.559199f, 0.433905f, 0.416852f, 
		0.433939f, 0.705495f, 0.433949f, 0.861880f, 
		0.433957f, 0.410243f, 0.433969f, 0.566918f, 
		0.433970f, 0.705725f, 0.433991f, 0.709874f, 
		0.434006f, 0.565930f, 0.434016f, 0.411428f, 
		0.434026f, 0.554894f, 0.434028f, 0.559417f, 
		0.434047f, 0.553813f, 0.434157f, 0.181828f, 
		0.434180f, 0.181699f, 0.434187f, 0.710343f, 
		0.434467f, 0.870808f, 0.434949f, 0.370363f, 
		0.434960f, 0.370358f, 0.435369f, 0.0138497f, 
		0.435445f, 0.0830725f, 0.435943f, 0.0122646f, 
		0.436278f, 0.0158749f, 0.437377f, 0.109577f, 
		0.438459f, 0.0876306f, 0.438685f, 0.230103f, 
		0.438685f, 0.289177f, 0.438685f, 0.344445f, 
		0.438685f, 0.399050f, 0.438685f, 0.460205f, 
		0.438685f, 0.519280f, 0.438685f, 0.574548f, 
		0.438685f, 0.629153f, 0.438685f, 0.690308f, 
		0.438685f, 0.749383f, 0.439931f, 0.252928f, 
		0.440240f, 0.866687f, 0.440428f, 0.507863f, 
		0.440531f, 0.868329f, 0.440538f, 0.418221f, 
		0.440615f, 0.409323f, 0.440634f, 0.864753f, 
		0.440648f, 0.568324f, 0.440662f, 0.703458f, 
		0.440676f, 0.859311f, 0.440694f, 0.858604f, 
		0.440704f, 0.714316f, 0.440721f, 0.861755f, 
		0.440725f, 0.705153f, 0.440727f, 0.555778f, 
		0.440727f, 0.409092f, 0.440734f, 0.565742f, 
		0.440741f, 0.555780f, 0.440744f, 0.416057f, 
		0.440794f, 0.711703f, 0.440810f, 0.558396f, 
		0.440813f, 0.560446f, 0.440842f, 0.330755f, 
		0.440868f, 0.710580f, 0.440988f, 0.368018f, 
		0.441873f, 0.0899401f, 0.441897f, 0.542561f, 
		0.442140f, 0.0913114f, 0.442494f, 0.323983f, 
		0.442635f, 0.0923574f, 0.442639f, 0.0935277f, 
		0.442853f, 0.000994214f, 0.442853f, 0.380239f, 
		0.444089f, 0.792710f, 0.444351f, 0.115519f, 
		0.444660f, 0.208104f, 0.444713f, 0.0120009f, 
		0.445048f, 0.0194370f, 0.445048f, 0.0319730f, 
		0.445189f, 0.337359f, 0.445756f, 0.0254097f, 
		0.445763f, 0.0255428f, 0.445843f, 0.812950f, 
		0.445992f, 0.812978f, 0.446693f, 0.459936f, 
		0.447114f, 0.0359253f, 0.447114f, 0.0550150f, 
		0.447114f, 0.0755807f, 0.447114f, 0.0928856f, 
		0.447114f, 0.130138f, 0.447114f, 0.132762f, 
		0.447114f, 0.189804f, 0.447114f, 0.190924f, 
		0.447114f, 0.229717f, 0.447114f, 0.242419f, 
		0.447114f, 0.273791f, 0.447114f, 0.296729f, 
		0.447114f, 0.338759f, 0.447114f, 0.346246f, 
		0.447153f, 0.309116f, 0.447221f, 0.731433f, 
		0.447489f, 0.0774403f, 0.448085f, 0.0339901f, 
		0.448109f, 0.0376776f, 0.448228f, 0.319774f, 
		0.448579f, 0.0738601f, 0.448579f, 0.129729f, 
		0.448834f, 0.344189f, 0.448954f, 0.245906f, 
		0.449213f, 0.291599f, 0.449217f, 0.291635f, 
		0.449426f, 0.717525f, 0.449573f, 0.0679646f, 
		0.449603f, 0.194525f, 0.449669f, 0.235366f, 
		0.449773f, 0.213778f, 0.449863f, 0.0254998f, 
		0.450053f, 0.197604f, 0.450091f, 0.0454429f, 
		0.450162f, 0.345976f, 0.450431f, 0.138816f, 
		0.450456f, 0.347144f, 0.450507f, 0.903097f, 
		0.450509f, 0.0161001f, 0.450592f, 0.0121262f, 
		0.450601f, 0.873050f, 0.450817f, 0.142207f, 
		0.451097f, 0.142541f, 0.451138f, 0.466638f, 
		0.451262f, 0.254541f, 0.451393f, 0.102540f, 
		0.451463f, 0.903097f, 0.451835f, 0.114854f, 
		0.451937f, 0.812402f, 0.451983f, 0.291899f, 
		0.451993f, 0.291896f, 0.452222f, 0.812029f, 
		0.452298f, 0.283292f, 0.452471f, 0.726099f, 
		0.452484f, 0.726109f, 0.452720f, 0.361798f, 
		0.452779f, 0.377337f, 0.452794f, 0.150412f, 
		0.452794f, 0.365829f, 0.452813f, 0.377437f, 
		0.453236f, 0.361609f, 0.453301f, 0.105086f, 
		0.453405f, 0.730696f, 0.453536f, 0.0207003f, 
		0.453888f, 0.731345f, 0.453891f, 0.731334f, 
		0.453931f, 0.731274f, 0.453959f, 0.812184f, 
		0.453996f, 0.328336f, 0.454112f, 0.764231f, 
		0.454234f, 0.812194f, 0.454450f, 0.883596f, 
		0.454455f, 0.563532f, 0.454471f, 0.505212f, 
		0.454559f, 0.653335f, 0.454789f, 0.563696f, 
		0.455069f, 0.581918f, 0.455135f, 0.380408f, 
		0.455304f, 0.410470f, 0.455318f, 0.0854546f, 
		0.455438f, 0.295217f, 0.455448f, 0.295197f, 
		0.455451f, 0.719858f, 0.455564f, 0.263996f, 
		0.455887f, 0.0198609f, 0.455955f, 0.0817955f, 
		0.456045f, 0.134047f, 0.456100f, 0.720677f, 
		0.456160f, 0.525160f, 0.456198f, 0.420757f, 
		0.456302f, 0.789781f, 0.456322f, 0.901266f, 
		0.456486f, 0.525456f, 0.456510f, 0.748095f, 
		0.456685f, 0.885711f, 0.456744f, 0.400007f, 
		0.456802f, 0.400308f, 0.457896f, 0.725586f, 
		0.458101f, 0.302309f, 0.458269f, 0.204021f, 
		0.458651f, 0.0735154f, 0.458818f, 0.0972590f, 
		0.458977f, 0.0641361f, 0.458995f, 0.0641366f, 
		0.459540f, 0.528040f, 0.459767f, 0.0676734f, 
		0.459825f, 0.0685142f, 0.460716f, 0.622505f, 
		0.460918f, 0.211914f, 0.460945f, 0.00358320f, 
		0.461482f, 0.167585f, 0.461654f, 0.253868f, 
		0.462305f, 0.486380f, 0.462305f, 0.124769f, 
		0.462648f, 0.124492f, 0.462858f, 0.396190f, 
		0.462957f, 0.00952621f, 0.463024f, 0.394373f, 
		0.463111f, 0.188579f, 0.463211f, 0.189444f, 
		0.463420f, 0.530406f, 0.463718f, 0.350500f, 
		0.464069f, 0.136897f, 0.464124f, 0.480068f, 
		0.464164f, 0.443518f, 0.464326f, 0.483006f, 
		0.464567f, 0.163634f, 0.464601f, 0.454606f, 
		0.464866f, 0.456421f, 0.465138f, 0.614518f, 
		0.465211f, 0.470057f, 0.465653f, 0.131958f, 
		0.465724f, 0.472167f, 0.465745f, 0.427856f, 
		0.466239f, 0.500041f, 0.466255f, 0.0319730f, 
		0.466291f, 0.0196016f, 0.466333f, 0.0198349f, 
		0.466348f, 0.0313732f, 0.466455f, 0.478059f, 
		0.466948f, 0.0268008f, 0.467052f, 0.0267520f, 
		0.467312f, 0.00970521f, 0.467368f, 0.426194f, 
		0.467574f, 0.422382f, 0.467617f, 0.439701f, 
		0.467874f, 0.477776f, 0.468166f, 0.0173670f, 
		0.468166f, 0.120814f, 0.468166f, 0.538384f, 
		0.468166f, 0.877972f, 0.468166f, 0.880864f, 
		0.468166f, 0.903097f, 0.468267f, 0.326871f, 
		0.468282f, 0.317067f, 0.468391f, 0.256701f, 
		0.468465f, 0.00917607f, 0.468580f, 0.333646f, 
		0.468719f, 0.502270f, 0.469474f, 0.0628098f, 
		0.469631f, 0.0725287f, 0.469631f, 0.0740760f, 
		0.469631f, 0.0843387f, 0.469631f, 0.190370f, 
		0.469631f, 0.199436f, 0.469631f, 0.211522f, 
		0.469631f, 0.259870f, 0.469631f, 0.296131f, 
		0.469631f, 0.305197f, 0.469631f, 0.308218f, 
		0.469631f, 0.320305f, 0.469631f, 0.363486f, 
		0.469631f, 0.468371f, 0.469671f, 0.421486f, 
		0.470151f, 0.330421f, 0.470158f, 0.179026f, 
		0.470474f, 0.264649f, 0.470965f, 0.154546f, 
		0.471186f, 0.424805f, 0.471219f, 0.361145f, 
		0.471305f, 0.361350f, 0.471385f, 0.262152f, 
		0.471628f, 0.174936f, 0.471631f, 0.245252f, 
		0.471710f, 0.418105f, 0.471799f, 0.245686f, 
		0.471846f, 0.0525749f, 0.471850f, 0.0525992f, 
		0.471872f, 0.000000f, 0.471895f, 0.227143f, 
		0.471918f, 0.00322901f, 0.471950f, 0.375733f, 
		0.472150f, 0.483870f, 0.472168f, 0.360138f, 
		0.472216f, 0.321036f, 0.472224f, 0.138116f, 
		0.472244f, 0.156769f, 0.472393f, 0.425117f, 
		0.472402f, 0.410893f, 0.472566f, 0.208462f, 
		0.472611f, 0.0882097f, 0.472644f, 0.102737f, 
		0.472683f, 0.0873767f, 0.472692f, 0.0531354f, 
		0.472703f, 0.0527672f, 0.472816f, 0.477706f, 
		0.472979f, 0.0325237f, 0.473162f, 0.492875f, 
		0.473193f, 0.366810f, 0.473207f, 0.433500f, 
		0.473208f, 0.233751f, 0.473210f, 0.0508365f, 
		0.473250f, 0.426794f, 0.473261f, 0.401855f, 
		0.473313f, 0.177497f, 0.473313f, 0.161021f, 
		0.473441f, 0.176300f, 0.473470f, 0.332295f, 
		0.473491f, 0.332329f, 0.473547f, 0.0806503f, 
		0.473624f, 0.191014f, 0.473642f, 0.191014f, 
		0.473674f, 0.491081f, 0.473675f, 0.00844050f, 
		0.473797f, 0.177148f, 0.473815f, 0.366295f, 
		0.473961f, 0.313589f, 0.473982f, 0.0178810f, 
		0.473988f, 0.429826f, 0.473990f, 0.0179160f, 
		0.474018f, 0.0347501f, 0.474018f, 0.0574133f, 
		0.474018f, 0.128424f, 0.474018f, 0.132957f, 
		0.474018f, 0.219077f, 0.474018f, 0.267425f, 
		0.474018f, 0.491034f, 0.474023f, 0.114176f, 
		0.474055f, 0.0821592f, 0.474056f, 0.0821284f, 
		0.474103f, 0.415952f, 0.474114f, 0.350172f, 
		0.474139f, 0.442719f, 0.474246f, 0.312073f, 
		0.474301f, 0.475146f, 0.474327f, 0.475366f, 
		0.474341f, 0.356638f, 0.474376f, 0.360926f, 
		0.474397f, 0.114001f, 0.474399f, 0.267944f, 
		0.474400f, 0.267956f, 0.474497f, 0.277341f, 
		0.474501f, 0.0370810f, 0.474532f, 0.755756f, 
		0.474547f, 0.114804f, 0.474594f, 0.420277f, 
		0.474597f, 0.311414f, 0.474603f, 0.311434f, 
		0.474608f, 0.277188f, 0.474630f, 0.412899f, 
		0.474633f, 0.181830f, 0.474643f, 0.450622f, 
		0.474679f, 0.379597f, 0.474683f, 0.448101f, 
		0.474687f, 0.359132f, 0.474724f, 0.0244748f, 
		0.474772f, 0.0944607f, 0.474927f, 0.290060f, 
		0.474986f, 0.161636f, 0.475163f, 0.473615f, 
		0.475201f, 0.453205f, 0.475203f, 0.290234f, 
		0.475276f, 0.0209049f, 0.475343f, 0.128402f, 
		0.475384f, 0.103724f, 0.475439f, 0.416435f, 
		0.475569f, 0.321008f, 0.475571f, 0.755061f, 
		0.475571f, 0.321016f, 0.475707f, 0.145497f, 
		0.475707f, 0.179491f, 0.475812f, 0.754956f, 
		0.475844f, 0.0356975f, 0.475980f, 0.352800f, 
		0.475996f, 0.115799f, 0.476105f, 0.450179f, 
		0.476105f, 0.451681f, 0.476105f, 0.451715f, 
		0.476105f, 0.454103f, 0.476105f, 0.458028f, 
		0.476105f, 0.460714f, 0.476105f, 0.466719f, 
		0.476105f, 0.499151f, 0.476163f, 0.409154f, 
		0.476168f, 0.754734f, 0.476211f, 0.271958f, 
		0.476250f, 0.363116f, 0.476390f, 0.754595f, 
		0.476441f, 0.132549f, 0.476486f, 0.0427192f, 
		0.476508f, 0.399737f, 0.476542f, 0.467182f, 
		0.476622f, 0.112015f, 0.476715f, 0.119352f, 
		0.476779f, 0.0993671f, 0.476953f, 0.199475f, 
		0.476953f, 0.356622f, 0.476953f, 0.357393f, 
		0.477386f, 0.291433f, 0.477386f, 0.108526f, 
		0.477388f, 0.291457f, 0.477922f, 0.460511f, 
		0.478131f, 0.460797f, 0.478213f, 0.0220827f, 
		0.478213f, 0.148968f, 0.478213f, 0.183362f, 
		0.478405f, 0.0425825f, 0.478405f, 0.0426024f, 
		0.478405f, 0.103781f, 0.478405f, 0.114654f, 
		0.478405f, 0.326436f, 0.478405f, 0.404987f, 
		0.478746f, 0.444019f, 0.478768f, 0.239268f, 
		0.478837f, 0.00844050f, 0.478840f, 0.491081f, 
		0.478847f, 0.0612544f, 0.478973f, 0.0806323f, 
		0.479030f, 0.134542f, 0.479034f, 0.134552f, 
		0.479040f, 0.134542f, 0.479935f, 0.248060f, 
		0.479998f, 0.0491599f, 0.480142f, 0.223009f, 
		0.480360f, 0.00837062f, 0.480877f, 0.112834f, 
		0.480891f, 0.0489422f, 0.481045f, 0.231733f, 
		0.481103f, 0.321816f, 0.481208f, 0.0422032f, 
		0.481286f, 0.321645f, 0.481325f, 0.267050f, 
		0.481514f, 0.429215f, 0.481525f, 0.429210f, 
		0.481621f, 0.358472f, 0.481667f, 0.358851f, 
		0.481892f, 0.443921f, 0.482019f, 0.199561f, 
		0.482021f, 0.199573f, 0.482032f, 0.199485f, 
		0.482090f, 0.299061f, 0.482214f, 0.000000f, 
		0.482219f, 0.109671f, 0.482235f, 0.298741f, 
		0.482253f, 0.000000f, 0.482301f, 0.168054f, 
		0.482301f, 0.174574f, 0.482614f, 0.114977f, 
		0.482875f, 0.391379f, 0.482892f, 0.191943f, 
		0.482926f, 0.0183749f, 0.482927f, 0.443504f, 
		0.483030f, 0.146333f, 0.483123f, 0.474214f, 
		0.483129f, 0.473469f, 0.483134f, 0.474433f, 
		0.483135f, 0.474314f, 0.483493f, 0.146829f, 
		0.484082f, 0.146778f, 0.484254f, 0.0116110f, 
		0.484254f, 0.198523f, 0.484254f, 0.198565f, 
		0.484254f, 0.303148f, 0.484254f, 0.303158f, 
		0.484254f, 0.303174f, 0.484254f, 0.499268f, 
		0.484254f, 0.522006f, 0.484254f, 0.522802f, 
		0.484254f, 0.523049f, 0.484254f, 0.523265f, 
		0.484254f, 0.524868f, 0.484254f, 0.615376f, 
		0.484254f, 0.661690f, 0.484254f, 0.666932f, 
		0.484254f, 0.681786f, 0.484254f, 0.695772f, 
		0.484254f, 0.695785f, 0.484254f, 0.714069f, 
		0.484254f, 0.799805f, 0.484254f, 0.812287f, 
		0.484254f, 0.812303f, 0.484254f, 0.812314f, 
		0.484254f, 0.946286f, 0.484254f, 0.971084f, 
		0.484254f, 0.998535f, 0.484283f, 0.569299f, 
		0.484334f, 0.789484f, 0.484641f, 0.655161f, 
		0.484748f, 0.796807f, 0.485023f, 0.186356f, 
		0.485077f, 0.583226f, 0.485079f, 0.653970f, 
		0.485104f, 0.583385f, 0.485352f, 0.583934f, 
		0.485462f, 0.179464f, 0.485490f, 0.179023f, 
		0.485491f, 0.178992f, 0.485506f, 0.178791f, 
		0.485514f, 0.178639f, 0.485516f, 0.148158f, 
		0.485588f, 0.180673f, 0.485595f, 0.104956f, 
		0.485596f, 0.104944f, 0.485742f, 0.174983f, 
		0.485769f, 0.000000f, 0.485769f, 0.00471158f, 
		0.485769f, 0.0161395f, 0.485769f, 0.0477345f, 
		0.485769f, 0.134496f, 0.485769f, 0.145907f, 
		0.485769f, 0.193539f, 0.485769f, 0.209814f, 
		0.485769f, 0.247416f, 0.485769f, 0.304848f, 
		0.485769f, 0.305508f, 0.485769f, 0.320952f, 
		0.485769f, 0.320980f, 0.485769f, 0.333550f, 
		0.485846f, 0.193265f, 0.485895f, 0.656521f, 
		0.485920f, 0.813375f, 0.485930f, 0.180617f, 
		0.485934f, 0.0342940f, 0.485934f, 0.0343040f, 
		0.486098f, 0.369131f, 0.486131f, 0.660946f, 
		0.486136f, 0.927441f, 0.486140f, 0.520657f, 
		0.486174f, 0.147866f, 0.486181f, 0.477234f, 
		0.486237f, 0.476594f, 0.486241f, 0.00953975f, 
		0.486241f, 0.998535f, 0.486242f, 0.00953871f, 
		0.486242f, 0.998535f, 0.486272f, 0.583115f, 
		0.486410f, 0.367860f, 0.486458f, 0.147740f, 
		0.486505f, 0.923744f, 0.486536f, 0.366049f, 
		0.486579f, 0.000000f, 0.486579f, 0.998535f, 
		0.486723f, 0.860776f, 0.486725f, 0.00821016f, 
		0.486725f, 0.998535f, 0.486795f, 0.690441f, 
		0.486830f, 0.998535f, 0.486884f, 0.480136f, 
		0.487060f, 0.918195f, 0.487061f, 0.918180f, 
		0.487083f, 0.917949f, 0.487114f, 0.754640f, 
		0.487196f, 0.635986f, 0.487221f, 0.635897f, 
		0.487234f, 0.00920875f, 0.487234f, 0.112632f, 
		0.487234f, 0.297058f, 0.487234f, 0.311429f, 
		0.487234f, 0.381541f, 0.487234f, 0.408403f, 
		0.487234f, 0.435264f, 0.487234f, 0.449555f, 
		0.487234f, 0.455410f, 0.487234f, 0.575420f, 
		0.487234f, 0.575503f, 0.487241f, 0.607983f, 
		0.487254f, 0.344941f, 0.487261f, 0.975392f, 
		0.487280f, 0.608030f, 0.487355f, 0.616940f, 
		0.487382f, 0.199701f, 0.487462f, 0.0196570f, 
		0.487462f, 0.0320190f, 0.487878f, 0.636027f, 
		0.487903f, 0.985038f, 0.487956f, 0.729765f, 
		0.487994f, 0.998535f, 0.488029f, 0.785091f, 
		0.488044f, 0.293866f, 0.488094f, 0.734746f, 
		0.488191f, 0.0258555f, 0.488195f, 0.0257993f, 
		0.488258f, 0.246628f, 0.488298f, 0.00747160f, 
		0.488340f, 0.244060f, 0.488369f, 0.245230f, 
		0.488402f, 0.255281f, 0.488460f, 0.185916f, 
		0.488524f, 0.129286f, 0.488553f, 0.233334f, 
		0.488821f, 0.746094f, 0.488996f, 0.129364f, 
		0.489103f, 0.125749f, 0.489120f, 0.0229879f, 
		0.489162f, 0.00658778f, 0.489249f, 0.884292f, 
		0.489506f, 0.831301f, 0.489692f, 0.256480f, 
		0.489751f, 0.521892f, 0.490050f, 0.885193f, 
		0.490132f, 0.105136f, 0.490261f, 0.231297f, 
		0.490304f, 0.198961f, 0.490356f, 0.0917635f, 
		0.490515f, 0.504123f, 0.490581f, 0.0833125f, 
		0.490697f, 0.276920f, 0.490699f, 0.495431f, 
		0.490728f, 0.304435f, 0.490857f, 0.363155f, 
		0.490962f, 0.570276f, 0.491237f, 0.487865f, 
		0.491282f, 0.853163f, 0.491420f, 0.904387f, 
		0.491569f, 0.949733f, 0.491629f, 0.951079f, 
		0.491645f, 0.951415f, 0.491681f, 0.00496886f, 
		0.491686f, 0.00487998f, 0.491687f, 0.00496707f, 
		0.491765f, 0.499442f, 0.491783f, 0.000000f, 
		0.491795f, 0.955841f, 0.491929f, 0.444057f, 
		0.492017f, 0.0488011f, 0.492069f, 0.247111f, 
		0.492085f, 0.707523f, 0.492098f, 0.0461905f, 
		0.492104f, 0.362768f, 0.492219f, 0.707356f, 
		0.492428f, 0.219500f, 0.492452f, 0.318390f, 
		0.492584f, 0.375015f, 0.492689f, 0.266796f, 
		0.492689f, 0.355176f, 0.492689f, 0.667064f, 
		0.492689f, 0.998535f, 0.492759f, 0.241679f, 
		0.492776f, 0.245797f, 0.492877f, 0.374557f, 
		0.492918f, 0.351011f, 0.493030f, 0.522587f, 
		0.493034f, 0.905953f, 0.493040f, 0.507521f, 
		0.493073f, 0.0414925f, 0.493116f, 0.357376f, 
		0.493176f, 0.151965f, 0.493194f, 0.708502f, 
		0.493202f, 0.141750f, 0.493215f, 0.352208f, 
		0.493421f, 0.0431827f, 0.493470f, 0.153828f, 
		0.493673f, 0.147580f, 0.493714f, 0.520279f, 
		0.493915f, 0.155786f, 0.493926f, 0.0373793f, 
		0.493987f, 0.0358124f, 0.494035f, 0.000000f, 
		0.494035f, 0.0860674f, 0.494035f, 0.0861078f, 
		0.494035f, 0.0866005f, 0.494035f, 0.272800f, 
		0.494035f, 0.272835f, 0.494035f, 0.347445f, 
		0.494035f, 0.347457f, 0.494035f, 0.347508f, 
		0.494035f, 0.366804f, 0.494035f, 0.366818f, 
		0.494035f, 0.471111f, 0.494035f, 0.471141f, 
		0.494035f, 0.471917f, 0.494035f, 0.567230f, 
		0.494035f, 0.567240f, 0.494035f, 0.567272f, 
		0.494035f, 0.579644f, 0.494035f, 0.579678f, 
		0.494035f, 0.609269f, 0.494035f, 0.650719f, 
		0.494035f, 0.650755f, 0.494035f, 0.650777f, 
		0.494035f, 0.650794f, 0.494035f, 0.936441f, 
		0.494035f, 0.937865f, 0.494035f, 0.937881f, 
		0.494035f, 0.998535f, 0.494142f, 0.106047f, 
		0.494217f, 0.238714f, 0.494223f, 0.237393f, 
		0.494259f, 0.501865f, 0.494411f, 0.747126f, 
		0.494415f, 0.746345f, 0.494417f, 0.746015f, 
		0.494421f, 0.215544f, 0.494422f, 0.200021f, 
		0.494423f, 0.200047f, 0.494502f, 0.505523f, 
		0.494541f, 0.715853f, 0.494546f, 0.715798f, 
		0.494584f, 0.145736f, 0.494630f, 0.476952f, 
		0.494634f, 0.476939f, 0.494762f, 0.0378161f, 
		0.494889f, 0.620971f, 0.495124f, 0.892824f, 
		0.495125f, 0.451324f, 0.495269f, 0.321934f, 
		0.495392f, 0.000000f, 0.495481f, 0.145497f, 
		0.495481f, 0.179491f, 0.495508f, 0.747695f, 
		0.495541f, 0.570255f, 0.495592f, 0.000000f, 
		0.495592f, 0.998535f, 0.495707f, 0.565306f, 
		0.495824f, 0.797735f, 0.495854f, 0.452019f, 
		0.495925f, 0.383793f, 0.495961f, 0.622701f, 
		0.496339f, 0.842426f, 0.496351f, 0.842321f, 
		0.496366f, 0.360944f, 0.496495f, 0.840485f, 
		0.496593f, 0.399734f, 0.496645f, 0.123213f, 
		0.496774f, 0.130117f, 0.497428f, 0.828896f, 
		0.497499f, 0.668076f, 0.497598f, 0.523145f, 
		0.497623f, 0.131272f, 0.497639f, 0.131284f, 
		0.497682f, 0.565263f, 0.497779f, 0.565493f, 
		0.498122f, 0.460637f, 0.498135f, 0.992524f, 
		0.498326f, 0.460768f, 0.498554f, 0.891636f, 
		0.498782f, 0.131383f, 0.499075f, 0.130401f, 
		0.499342f, 0.142015f, 0.499557f, 0.0669627f, 
		0.499578f, 0.980655f, 0.499579f, 0.571297f, 
		0.499737f, 0.0669383f, 0.499870f, 0.000000f, 
		0.500232f, 0.990209f, 0.500376f, 0.443422f, 
		0.500684f, 0.136897f, 0.501143f, 0.443847f, 
		0.501174f, 0.136897f, 0.501187f, 0.721159f, 
		0.501248f, 0.136894f, 0.501432f, 0.0654322f, 
		0.501806f, 0.450829f, 0.501893f, 0.860141f, 
		0.502360f, 0.313262f, 0.502596f, 0.607483f, 
		0.502718f, 0.318390f, 0.502977f, 0.266879f, 
		0.503384f, 0.318390f, 0.503573f, 0.230810f, 
		0.503613f, 0.141574f, 0.503804f, 0.340225f, 
		0.503867f, 0.141598f, 0.503942f, 0.974533f, 
		0.504008f, 0.417510f, 0.504103f, 0.402408f, 
		0.504380f, 0.402053f, 0.504526f, 0.625608f, 
		0.504677f, 0.420306f, 0.504856f, 0.918187f, 
		0.504926f, 0.441859f, 0.504932f, 0.441847f, 
		0.505173f, 0.236667f, 0.505180f, 0.236649f, 
		0.505185f, 0.236670f, 0.505186f, 0.236654f, 
		0.505282f, 0.236625f, 0.505381f, 0.574761f, 
		0.505385f, 0.624750f, 0.505556f, 0.477093f, 
		0.506139f, 0.405206f, 0.506247f, 0.516310f, 
		0.506272f, 0.000000f, 0.506318f, 0.000000f, 
		0.506588f, 0.229680f, 0.506771f, 0.145325f, 
		0.506805f, 0.410390f, 0.507282f, 0.437537f, 
		0.507390f, 0.964854f, 0.508360f, 0.528100f, 
		0.508491f, 0.405489f, 0.508541f, 0.238499f, 
		0.508697f, 0.961164f, 0.508701f, 0.961174f, 
		0.508714f, 0.0320190f, 0.508795f, 0.411245f, 
		0.508848f, 0.0202907f, 0.508862f, 0.0203599f, 
		0.508941f, 0.0304025f, 0.509437f, 0.0268686f, 
		0.509792f, 0.733575f, 0.509833f, 0.733472f, 
		0.509979f, 0.733362f, 0.510955f, 0.177002f, 
		0.511333f, 0.734863f, 0.511448f, 0.205769f, 
		0.511551f, 0.734620f, 0.511831f, 0.0964675f, 
		0.512500f, 0.318390f, 0.512556f, 0.703772f, 
		0.512892f, 0.566651f, 0.513030f, 0.667603f, 
		0.513691f, 0.000117400f, 0.514157f, 0.000526825f, 
		0.514216f, 0.483138f, 0.514274f, 0.000000f, 
		0.514713f, 0.258371f, 0.514980f, 0.268729f, 
		0.515061f, 0.245271f, 0.515309f, 0.257513f, 
		0.515323f, 0.473330f, 0.515441f, 3.02757e-006f, 
		0.515471f, 0.759394f, 0.515638f, 0.405764f, 
		0.515756f, 0.181339f, 0.516001f, 0.619571f, 
		0.516523f, 0.420632f, 0.517100f, 0.713270f, 
		0.517455f, 0.422253f, 0.517496f, 0.623148f, 
		0.517860f, 0.895086f, 0.517893f, 0.174833f, 
		0.517930f, 0.887756f, 0.517935f, 0.895238f, 
		0.518056f, 0.934877f, 0.518060f, 0.934898f, 
		0.518099f, 0.170147f, 0.518099f, 0.169656f, 
		0.518195f, 0.159620f, 0.518196f, 0.159606f, 
		0.518238f, 0.888219f, 0.518491f, 0.314867f, 
		0.518500f, 0.0817416f, 0.518747f, 0.695466f, 
		0.518787f, 0.744127f, 0.518951f, 0.145959f, 
		0.519045f, 0.770635f, 0.519261f, 0.981119f, 
		0.519407f, 0.417487f, 0.519486f, 0.587483f, 
		0.519711f, 0.126836f, 0.519873f, 0.767241f, 
		0.519894f, 0.818659f, 0.519895f, 0.420826f, 
		0.519901f, 0.818641f, 0.520004f, 0.998535f, 
		0.520128f, 0.321468f, 0.520166f, 0.901787f, 
		0.520247f, 0.381131f, 0.520608f, 0.179957f, 
		0.520613f, 0.179939f, 0.520615f, 0.179955f, 
		0.520772f, 0.245904f, 0.520940f, 0.330027f, 
		0.520952f, 0.299616f, 0.520970f, 0.319924f, 
		0.521191f, 0.329407f, 0.521245f, 0.243841f, 
		0.521325f, 0.519403f, 0.521332f, 0.0840002f, 
		0.521382f, 0.193165f, 0.521383f, 0.0896861f, 
		0.521386f, 0.193158f, 0.521387f, 0.0896937f, 
		0.521387f, 0.193179f, 0.521422f, 0.0753106f, 
		0.521423f, 0.0752592f, 0.521425f, 0.0753099f, 
		0.521426f, 0.0752651f, 0.521665f, 0.125815f, 
		0.521669f, 0.125851f, 0.521671f, 0.125879f, 
		0.521688f, 0.399897f, 0.521699f, 0.708486f, 
		0.521714f, 0.209052f, 0.521727f, 0.128951f, 
		0.521756f, 0.301838f, 0.521773f, 0.246754f, 
		0.521789f, 0.784200f, 0.521809f, 0.0149412f, 
		0.521823f, 0.987215f, 0.521837f, 0.385630f, 
		0.521972f, 0.290328f, 0.521992f, 0.144675f, 
		0.521997f, 0.144723f, 0.522001f, 0.144738f, 
		0.522005f, 0.453341f, 0.522007f, 0.419877f, 
		0.522009f, 0.419856f, 0.522052f, 0.986321f, 
		0.522054f, 0.227354f, 0.522097f, 0.786851f, 
		0.522155f, 0.487440f, 0.522209f, 0.0145009f, 
		0.522247f, 0.476122f, 0.522247f, 0.346175f, 
		0.522248f, 0.346187f, 0.522249f, 0.346248f, 
		0.522253f, 0.990825f, 0.522260f, 0.671163f, 
		0.522269f, 0.0170049f, 0.522312f, 0.548801f, 
		0.522351f, 0.330750f, 0.522352f, 0.330781f, 
		0.522468f, 0.0338402f, 0.522468f, 0.0338503f, 
		0.522468f, 0.0338621f, 0.522468f, 0.211673f, 
		0.522468f, 0.229046f, 0.522468f, 0.261950f, 
		0.522468f, 0.261961f, 0.522468f, 0.279408f, 
		0.522468f, 0.292378f, 0.522468f, 0.292404f, 
		0.522468f, 0.296002f, 0.522468f, 0.296497f, 
		0.522468f, 0.312714f, 0.522468f, 0.313394f, 
		0.522468f, 0.313442f, 0.522468f, 0.448746f, 
		0.522499f, 0.0807847f, 0.522499f, 0.302939f, 
		0.522622f, 0.0800389f, 0.522631f, 0.914372f, 
		0.522660f, 0.245804f, 0.522699f, 0.488421f, 
		0.522956f, 0.512374f, 0.523093f, 0.990109f, 
		0.523245f, 0.220217f, 0.523676f, 0.228733f, 
		0.523688f, 0.0128717f, 0.523933f, 0.0950787f, 
		0.523933f, 0.357307f, 0.523933f, 0.523029f, 
		0.523933f, 0.523063f, 0.524006f, 0.0716183f, 
		0.524006f, 0.615826f, 0.524006f, 0.865459f, 
		0.524006f, 0.878400f, 0.524006f, 0.914648f, 
		0.524006f, 0.928822f, 0.524100f, 0.655806f, 
		0.524199f, 0.727079f, 0.524247f, 0.0633732f, 
		0.524247f, 0.0936632f, 0.524247f, 0.0936744f, 
		0.524247f, 0.0936888f, 0.524247f, 0.0982497f, 
		0.524247f, 0.185093f, 0.524247f, 0.431042f, 
		0.524247f, 0.431053f, 0.524247f, 0.431069f, 
		0.524247f, 0.433119f, 0.524247f, 0.499268f, 
		0.524247f, 0.592155f, 0.524247f, 0.613145f, 
		0.524247f, 0.731485f, 0.524247f, 0.799746f, 
		0.524247f, 0.823497f, 0.524247f, 0.829862f, 
		0.524247f, 0.829875f, 0.524247f, 0.830493f, 
		0.524247f, 0.836463f, 0.524247f, 0.836703f, 
		0.524525f, 0.402460f, 0.524878f, 0.238379f, 
		0.524981f, 0.415368f, 0.525028f, 0.415351f, 
		0.525132f, 0.338120f, 0.525177f, 0.807974f, 
		0.525253f, 0.778894f, 0.525427f, 0.420406f, 
		0.525445f, 0.402169f, 0.525491f, 0.419856f, 
		0.525504f, 0.402578f, 0.525508f, 0.121305f, 
		0.525517f, 0.716126f, 0.525665f, 0.286114f, 
		0.525758f, 0.0339325f, 0.525862f, 0.223849f, 
		0.526181f, 0.431726f, 0.526217f, 0.197055f, 
		0.526230f, 0.197062f, 0.526230f, 0.197086f, 
		0.526550f, 0.459999f, 0.526551f, 0.459987f, 
		0.526622f, 0.206172f, 0.526626f, 0.206263f, 
		0.526628f, 0.206135f, 0.526635f, 0.206279f, 
		0.526642f, 0.365712f, 0.526731f, 0.474660f, 
		0.526779f, 0.703533f, 0.526784f, 0.703566f, 
		0.526797f, 0.703575f, 0.526835f, 0.645361f, 
		0.526868f, 0.00894227f, 0.526897f, 0.0127561f, 
		0.526897f, 0.423563f, 0.526915f, 0.0124287f, 
		0.527011f, 0.0684451f, 0.527065f, 0.547917f, 
		0.527135f, 0.00657015f, 0.527189f, 0.164510f, 
		0.527228f, 0.751962f, 0.527272f, 0.783897f, 
		0.527318f, 0.708563f, 0.527372f, 0.0257435f, 
		0.527372f, 0.525011f, 0.527372f, 0.971237f, 
		0.527393f, 0.264368f, 0.527427f, 0.427065f, 
		0.527449f, 0.737194f, 0.527461f, 0.737209f, 
		0.527552f, 0.735482f, 0.527557f, 0.735462f, 
		0.527583f, 0.000000f, 0.527583f, 0.900936f, 
		0.527803f, 0.706794f, 0.527945f, 0.680684f, 
		0.527947f, 0.890344f, 0.527989f, 0.590058f, 
		0.528036f, 0.887874f, 0.528048f, 0.887440f, 
		0.528083f, 0.00744134f, 0.528096f, 0.899323f, 
		0.528170f, 0.288922f, 0.528192f, 0.806615f, 
		0.528408f, 0.0986114f, 0.528425f, 0.00701875f, 
		0.528521f, 0.883381f, 0.528553f, 0.166019f, 
		0.528577f, 0.0976984f, 0.528603f, 0.0122913f, 
		0.528643f, 0.611133f, 0.528667f, 0.171305f, 
		0.528695f, 0.366026f, 0.528707f, 0.828121f, 
		0.528740f, 0.0759544f, 0.528764f, 0.307635f, 
		0.528807f, 0.413931f, 0.528837f, 0.510143f, 
		0.528851f, 0.107603f, 0.528857f, 0.805870f, 
		0.528882f, 0.509687f, 0.529005f, 0.709037f, 
		0.529009f, 0.413958f, 0.529139f, 0.458233f, 
		0.529166f, 0.0723795f, 0.529236f, 0.878887f, 
		0.529300f, 0.444405f, 0.529317f, 0.000000f, 
		0.529317f, 0.0157154f, 0.529317f, 0.0163353f, 
		0.529317f, 0.0223737f, 0.529317f, 0.0364614f, 
		0.529317f, 0.0804573f, 0.529317f, 0.0805109f, 
		0.529317f, 0.128192f, 0.529317f, 0.128553f, 
		0.529317f, 0.128572f, 0.529317f, 0.150055f, 
		0.529317f, 0.197227f, 0.529317f, 0.216262f, 
		0.529317f, 0.227798f, 0.529317f, 0.231872f, 
		0.529317f, 0.234330f, 0.529317f, 0.253013f, 
		0.529317f, 0.253037f, 0.529317f, 0.253147f, 
		0.529317f, 0.253205f, 0.529317f, 0.257694f, 
		0.529317f, 0.291392f, 0.529317f, 0.312779f, 
		0.529317f, 0.335894f, 0.529317f, 0.335906f, 
		0.529317f, 0.346079f, 0.529317f, 0.354404f, 
		0.529317f, 0.424943f, 0.529317f, 0.424954f, 
		0.529317f, 0.440909f, 0.529317f, 0.440966f, 
		0.529317f, 0.447019f, 0.529317f, 0.458305f, 
		0.529317f, 0.458317f, 0.529317f, 0.486805f, 
		0.529317f, 0.568420f, 0.529317f, 0.569659f, 
		0.529317f, 0.571771f, 0.529317f, 0.577775f, 
		0.529317f, 0.617672f, 0.529317f, 0.744101f, 
		0.529317f, 0.802949f, 0.529317f, 0.858016f, 
		0.529317f, 0.893220f, 0.529317f, 0.933226f, 
		0.529317f, 0.938799f, 0.529317f, 0.949498f, 
		0.529317f, 0.953005f, 0.529317f, 0.975313f, 
		0.529317f, 0.979300f, 0.529317f, 0.981119f, 
		0.529317f, 0.998535f, 0.529319f, 0.921348f, 
		0.529333f, 0.198456f, 0.529351f, 0.444400f, 
		0.529452f, 0.197963f, 0.529579f, 0.367647f, 
		0.529653f, 0.0182733f, 0.529693f, 0.257963f, 
		0.529729f, 0.439240f, 0.529731f, 0.624295f, 
		0.529741f, 0.439241f, 0.529774f, 0.450211f, 
		0.529817f, 0.0793870f, 0.529824f, 0.670960f, 
		0.529832f, 5.21805e-015f, 0.529832f, 0.998535f, 
		0.529836f, 0.330034f, 0.529897f, 0.744692f, 
		0.529961f, 0.443445f, 0.529962f, 0.443432f, 
		0.529967f, 0.0320190f, 0.530043f, 0.807725f, 
		0.530046f, 0.807714f, 0.530050f, 0.807724f, 
		0.530160f, 0.619648f, 0.530162f, 0.619665f, 
		0.530167f, 0.0326716f, 0.530211f, 0.113318f, 
		0.530241f, 0.0209549f, 0.530280f, 0.767873f, 
		0.530319f, 0.0295457f, 0.530353f, 0.838288f, 
		0.530354f, 0.838277f, 0.530470f, 0.0238457f, 
		0.530577f, 0.236307f, 0.530577f, 0.440453f, 
		0.530581f, 0.440434f, 0.530584f, 0.793412f, 
		0.530584f, 0.163583f, 0.530700f, 0.163657f, 
		0.530733f, 0.769465f, 0.530738f, 0.490849f, 
		0.530748f, 0.980085f, 0.530779f, 0.940938f, 
		0.530837f, 0.759886f, 0.530855f, 0.442956f, 
		0.530885f, 0.0770725f, 0.530925f, 0.442820f, 
		0.530990f, 0.0124028f, 0.530992f, 0.892606f, 
		0.531015f, 0.462153f, 0.531039f, 0.852025f, 
		0.531045f, 0.663330f, 0.531046f, 0.0631586f, 
		0.531070f, 0.570886f, 0.531083f, 0.600641f, 
		0.531087f, 0.600627f, 0.531094f, 0.0860616f, 
		0.531102f, 0.0773129f, 0.531105f, 0.0772989f, 
		0.531105f, 0.0861952f, 0.531114f, 0.783573f, 
		0.531158f, 0.000000f, 0.531158f, 0.979577f, 
		0.531159f, 0.000000f, 0.531159f, 0.979574f, 
		0.531182f, 0.785358f, 0.531294f, 0.694200f, 
		0.531322f, 0.320229f, 0.531322f, 0.328856f, 
		0.531332f, 0.320242f, 0.531332f, 0.328874f, 
		0.531352f, 0.760570f, 0.531377f, 0.424104f, 
		0.531387f, 0.222969f, 0.531451f, 0.222887f, 
		0.531459f, 0.357901f, 0.531554f, 0.512671f, 
		0.531554f, 0.512682f, 0.531580f, 0.978572f, 
		0.531585f, 0.160621f, 0.531585f, 0.704313f, 
		0.531586f, 0.704333f, 0.531597f, 0.614687f, 
		0.531668f, 0.901132f, 0.531669f, 0.901162f, 
		0.531683f, 0.639400f, 0.531756f, 0.161113f, 
		0.531781f, 0.123139f, 0.531782f, 0.704952f, 
		0.531784f, 0.704975f, 0.531905f, 0.448850f, 
		0.531919f, 0.447803f, 0.531940f, 0.507959f, 
		0.532139f, 0.120537f, 0.532234f, 0.994326f, 
		0.532308f, 0.321903f, 0.532314f, 0.154247f, 
		0.532314f, 0.154230f, 0.532835f, 0.335229f, 
		0.532955f, 0.916497f, 0.533188f, 0.325340f, 
		0.533229f, 0.903998f, 0.533284f, 0.967520f, 
		0.533333f, 0.310991f, 0.533462f, 0.701419f, 
		0.533614f, 0.121966f, 0.533619f, 0.738648f, 
		0.533632f, 0.643146f, 0.533652f, 0.740971f, 
		0.533784f, 0.587590f, 0.533805f, 0.975929f, 
		0.533887f, 0.369817f, 0.534104f, 0.465718f, 
		0.534104f, 0.736273f, 0.534104f, 0.789947f, 
		0.534110f, 0.930118f, 0.534194f, 0.323099f, 
		0.534445f, 0.490849f, 0.534496f, 0.335229f, 
		0.534656f, 0.486285f, 0.534775f, 0.0713585f, 
		0.534775f, 0.0733398f, 0.534775f, 0.0912398f, 
		0.534775f, 0.0984075f, 0.534775f, 0.337157f, 
		0.534775f, 0.357383f, 0.534775f, 0.377160f, 
		0.534775f, 0.420084f, 0.534775f, 0.508293f, 
		0.534775f, 0.548875f, 0.534775f, 0.746149f, 
		0.534775f, 0.746176f, 0.534775f, 0.816556f, 
		0.534775f, 0.816571f, 0.534775f, 0.841075f, 
		0.534820f, 0.636855f, 0.534820f, 0.636843f, 
		0.534824f, 0.636871f, 0.534949f, 0.650101f, 
		0.534953f, 0.650117f, 0.535003f, 0.588218f, 
		0.535007f, 0.527156f, 0.535231f, 0.378491f, 
		0.535397f, 0.478284f, 0.535412f, 0.978735f, 
		0.535616f, 0.677019f, 0.535750f, 0.709710f, 
		0.535788f, 0.0716183f, 0.535788f, 0.567136f, 
		0.535788f, 0.570886f, 0.535788f, 0.925095f, 
		0.535788f, 0.985907f, 0.535915f, 0.821647f, 
		0.535968f, 0.476743f, 0.536439f, 0.337135f, 
		0.536439f, 0.337154f, 0.536439f, 0.836422f, 
		0.536440f, 0.337165f, 0.536605f, 0.520697f, 
		0.536938f, 0.273105f, 0.537120f, 0.000000f, 
		0.537360f, 0.152504f, 0.537366f, 0.152476f, 
		0.537466f, 0.651158f, 0.537471f, 0.116558f, 
		0.537471f, 0.410613f, 0.537471f, 0.858828f, 
		0.537471f, 0.880307f, 0.537471f, 0.895071f, 
		0.537471f, 0.925095f, 0.537471f, 0.940357f, 
		0.537683f, 0.415876f, 0.537705f, 0.415845f, 
		0.537775f, 0.368993f, 0.537864f, 0.339925f, 
		0.537957f, 0.535625f, 0.538097f, 0.679739f, 
		0.538153f, 0.177560f, 0.538215f, 0.515095f, 
		0.538215f, 0.515075f, 0.538216f, 0.515095f, 
		0.538316f, 0.788447f, 0.538373f, 0.241215f, 
		0.538394f, 0.653327f, 0.538665f, 0.296087f, 
		0.538673f, 0.144855f, 0.538677f, 0.144831f, 
		0.538747f, 0.331333f, 0.538886f, 0.800921f, 
		0.539113f, 0.550707f, 0.539148f, 0.330312f, 
		0.539152f, 0.0848803f, 0.539268f, 0.330111f, 
		0.539442f, 0.345399f, 0.539564f, 0.000000f, 
		0.539587f, 0.0859474f, 0.539655f, 0.458187f, 
		0.539659f, 0.237072f, 0.539782f, 0.0980017f, 
		0.539788f, 0.105500f, 0.539805f, 0.791849f, 
		0.539822f, 0.458182f, 0.539838f, 0.591663f, 
		0.539839f, 0.204541f, 0.539901f, 0.312738f, 
		0.539970f, 0.00388170f, 0.539970f, 0.00398547f, 
		0.539970f, 0.581679f, 0.539970f, 0.582316f, 
		0.539992f, 0.328169f, 0.540177f, 0.327858f, 
		0.540319f, 0.716452f, 0.540707f, 0.159670f, 
		0.540707f, 0.159700f, 0.540777f, 0.423924f, 
		0.541209f, 0.277034f, 0.541214f, 0.277000f, 
		0.541417f, 0.881959f, 0.541435f, 0.00747658f, 
		0.541435f, 0.0116670f, 0.541435f, 0.0256110f, 
		0.541435f, 0.128053f, 0.541435f, 0.277741f, 
		0.541435f, 0.418307f, 0.541435f, 0.529287f, 
		0.541435f, 0.571441f, 0.541455f, 0.0309700f, 
		0.541455f, 0.210042f, 0.541455f, 0.225234f, 
		0.541455f, 0.633740f, 0.541455f, 0.633761f, 
		0.541455f, 0.652307f, 0.541455f, 0.652326f, 
		0.541455f, 0.675702f, 0.541486f, 0.564108f, 
		0.541645f, 0.0758389f, 0.541772f, 0.818507f, 
		0.542130f, 0.392396f, 0.542178f, 0.231178f, 
		0.542321f, 0.000000f, 0.542321f, 0.136897f, 
		0.542341f, 0.254956f, 0.542357f, 0.335229f, 
		0.542394f, 0.380423f, 0.542485f, 0.526316f, 
		0.542616f, 0.374233f, 0.542641f, 0.0300342f, 
		0.542649f, 0.350932f, 0.542740f, 0.379142f, 
		0.543051f, 0.500025f, 0.543349f, 0.490539f, 
		0.543374f, 0.564182f, 0.543376f, 0.489393f, 
		0.543486f, 0.111346f, 0.543486f, 0.135571f, 
		0.543508f, 0.0933527f, 0.543530f, 0.730479f, 
		0.543530f, 0.730490f, 0.543533f, 0.730519f, 
		0.543654f, 0.192064f, 0.543764f, 0.783274f, 
		0.543834f, 0.467809f, 0.543996f, 0.127373f, 
		0.544286f, 0.378160f, 0.544651f, 0.292906f, 
		0.544819f, 0.174603f, 0.544871f, 0.0706081f, 
		0.544941f, 0.769544f, 0.544968f, 0.321965f, 
		0.544986f, 0.415091f, 0.545084f, 0.332071f, 
		0.545141f, 0.433647f, 0.545259f, 0.728088f, 
		0.545259f, 0.728075f, 0.545259f, 0.728108f, 
		0.545260f, 0.728083f, 0.545515f, 0.232577f, 
		0.545716f, 0.663763f, 0.545827f, 0.000000f, 
		0.545827f, 0.343837f, 0.545827f, 0.343848f, 
		0.545827f, 0.343858f, 0.545827f, 0.343873f, 
		0.545827f, 0.964860f, 0.545827f, 0.981697f, 
		0.545827f, 0.988269f, 0.545827f, 0.998535f, 
		0.545890f, 0.332326f, 0.545998f, 0.751302f, 
		0.546005f, 0.00179232f, 0.546206f, 0.000500677f, 
		0.546206f, 0.900778f, 0.546206f, 0.000501389f, 
		0.546206f, 0.900778f, 0.546206f, 0.000500664f, 
		0.546206f, 0.900778f, 0.546348f, 0.401077f, 
		0.546374f, 0.780223f, 0.546519f, 0.959975f, 
		0.546619f, 0.267063f, 0.546635f, 0.423622f, 
		0.546810f, 0.317870f, 0.546854f, 0.434425f, 
		0.546947f, 0.413307f, 0.547012f, 0.423944f, 
		0.547137f, 0.335229f, 0.547620f, 0.304128f, 
		0.547811f, 0.510075f, 0.547811f, 0.897439f, 
		0.548056f, 0.240649f, 0.548117f, 0.310067f, 
		0.548212f, 0.284948f, 0.548400f, 0.538277f, 
		0.548928f, 0.285761f, 0.548929f, 0.285774f, 
		0.548975f, 0.0116367f, 0.549425f, 0.939701f, 
		0.549699f, 0.000000f, 0.549699f, 0.139938f, 
		0.549699f, 0.152445f, 0.549740f, 0.975453f, 
		0.549989f, 0.302908f, 0.549994f, 0.302924f, 
		0.550322f, 0.0227195f, 0.550456f, 0.200562f, 
		0.551220f, 0.000000f, 0.551220f, 0.0216920f, 
		0.551220f, 0.0618215f, 0.551220f, 0.0619905f, 
		0.551220f, 0.0873161f, 0.551220f, 0.151992f, 
		0.551220f, 0.152667f, 0.551220f, 0.216569f, 
		0.551220f, 0.229158f, 0.551220f, 0.229387f, 
		0.551220f, 0.296343f, 0.551220f, 0.297947f, 
		0.551220f, 0.363836f, 0.551220f, 0.363872f, 
		0.551220f, 0.376319f, 0.551220f, 0.376343f, 
		0.551220f, 0.440428f, 0.551220f, 0.440783f, 
		0.551220f, 0.444077f, 0.551220f, 0.444239f, 
		0.551220f, 0.505597f, 0.551220f, 0.505620f, 
		0.551220f, 0.531006f, 0.551220f, 0.531056f, 
		0.551220f, 0.571220f, 0.551220f, 0.592912f, 
		0.551421f, 0.557071f, 0.551773f, 0.00977044f, 
		0.551774f, 0.954471f, 0.551814f, 0.994326f, 
		0.552435f, 0.988500f, 0.553160f, 0.882109f, 
		0.553173f, 0.952027f, 0.553173f, 0.967804f, 
		0.553738f, 0.387949f, 0.553982f, 0.000000f, 
		0.554417f, 0.000000f, 0.554417f, 0.592912f, 
		0.554576f, 0.215553f, 0.554577f, 0.215535f, 
		0.555022f, 0.528145f, 0.555028f, 0.000887698f, 
		0.555165f, 0.509930f, 0.555184f, 0.528139f, 
		0.555234f, 0.393026f, 0.555279f, 0.528111f, 
		0.555280f, 0.527410f, 0.555580f, 0.00303336f, 
		0.555658f, 0.137029f, 0.555825f, 0.205787f, 
		0.555838f, 0.389674f, 0.555932f, 0.0273583f, 
		0.556002f, 0.514321f, 0.556099f, 0.390485f, 
		0.556149f, 0.326212f, 0.556166f, 0.360696f, 
		0.556207f, 0.360779f, 0.556214f, 0.470441f, 
		0.556244f, 0.913788f, 0.556274f, 0.514301f, 
		0.556301f, 0.360924f, 0.556306f, 0.360935f, 
		0.556453f, 0.975515f, 0.556459f, 0.975500f, 
		0.556540f, 0.361307f, 0.556551f, 0.172617f, 
		0.556593f, 0.975421f, 0.556716f, 0.156955f, 
		0.556753f, 0.361653f, 0.556763f, 0.903361f, 
		0.556770f, 0.977679f, 0.556850f, 0.486492f, 
		0.556922f, 0.875212f, 0.556978f, 0.914005f, 
		0.557016f, 0.0455906f, 0.557020f, 0.583041f, 
		0.557024f, 0.874971f, 0.557050f, 0.890736f, 
		0.557116f, 0.975118f, 0.557119f, 0.874320f, 
		0.557125f, 0.975125f, 0.557125f, 0.975112f, 
		0.557151f, 0.583856f, 0.557151f, 0.399781f, 
		0.557240f, 0.0379568f, 0.557266f, 0.684402f, 
		0.557267f, 0.684419f, 0.557268f, 0.684403f, 
		0.557315f, 0.283704f, 0.557339f, 0.00765380f, 
		0.557415f, 0.128113f, 0.557493f, 0.584727f, 
		0.557613f, 0.873948f, 0.557642f, 0.149529f, 
		0.557698f, 0.148858f, 0.557720f, 0.0559715f, 
		0.557802f, 0.0716183f, 0.557802f, 0.880242f, 
		0.558073f, 0.699626f, 0.558352f, 0.956925f, 
		0.558362f, 0.811985f, 0.558435f, 0.645648f, 
		0.558616f, 0.639671f, 0.558648f, 0.0800080f, 
		0.558724f, 0.0818592f, 0.558754f, 0.559060f, 
		0.558859f, 0.907083f, 0.558878f, 0.000000f, 
		0.559173f, 0.155151f, 0.559264f, 0.0321034f, 
		0.559274f, 0.0331677f, 0.559302f, 0.795383f, 
		0.559331f, 0.0321694f, 0.559349f, 0.0314439f, 
		0.559394f, 0.613698f, 0.559395f, 0.613710f, 
		0.559406f, 0.869710f, 0.559409f, 0.0532433f, 
		0.559412f, 0.869714f, 0.559477f, 0.0779088f, 
		0.559517f, 0.0532630f, 0.559535f, 0.993529f, 
		0.559543f, 0.805013f, 0.559584f, 0.0325294f, 
		0.559608f, 0.777803f, 0.559627f, 0.870538f, 
		0.559649f, 0.940715f, 0.559664f, 0.386301f, 
		0.559672f, 0.386509f, 0.559673f, 0.0778928f, 
		0.559689f, 0.386020f, 0.559691f, 0.386031f, 
		0.559712f, 0.386155f, 0.559722f, 0.575785f, 
		0.559742f, 0.251419f, 0.559778f, 0.0277714f, 
		0.559851f, 0.575413f, 0.559877f, 0.165456f, 
		0.559878f, 0.386587f, 0.559889f, 0.167008f, 
		0.559929f, 0.793752f, 0.559931f, 0.793697f, 
		0.559938f, 0.374757f, 0.559992f, 0.184421f, 
		0.559996f, 0.184385f, 0.560250f, 0.805369f, 
		0.560322f, 0.367447f, 0.560322f, 0.367464f, 
		0.560323f, 0.367476f, 0.560323f, 0.367486f, 
		0.560330f, 0.614080f, 0.560331f, 0.614069f, 
		0.560332f, 0.614053f, 0.560351f, 0.613619f, 
		0.560353f, 0.613630f, 0.560353f, 0.613611f, 
		0.560376f, 0.0535384f, 0.560377f, 0.0535180f, 
		0.560377f, 0.0535071f, 0.560393f, 0.613644f, 
		0.560458f, 0.375994f, 0.560485f, 0.375829f, 
		0.560592f, 0.172623f, 0.560593f, 0.172599f, 
		0.560596f, 0.172564f, 0.560596f, 0.172599f, 
		0.560799f, 0.267300f, 0.560800f, 0.267326f, 
		0.560813f, 0.391699f, 0.560816f, 0.391868f, 
		0.560908f, 0.153002f, 0.561295f, 0.186937f, 
		0.561301f, 0.891712f, 0.561303f, 0.891702f, 
		0.561305f, 0.891745f, 0.561307f, 0.891700f, 
		0.561476f, 0.194699f, 0.561495f, 0.0257435f, 
		0.561495f, 0.0855105f, 0.561495f, 0.0855211f, 
		0.561495f, 0.116558f, 0.561495f, 0.425470f, 
		0.561495f, 0.490849f, 0.561495f, 0.507930f, 
		0.561495f, 0.525011f, 0.561495f, 0.555915f, 
		0.561495f, 0.614005f, 0.561495f, 0.614026f, 
		0.561495f, 0.614038f, 0.561495f, 0.658131f, 
		0.561495f, 0.690549f, 0.561495f, 0.690564f, 
		0.561495f, 0.690590f, 0.561495f, 0.690618f, 
		0.561495f, 0.740483f, 0.561495f, 0.774645f, 
		0.561495f, 0.956693f, 0.561509f, 0.623182f, 
		0.561533f, 0.204380f, 0.561577f, 0.193940f, 
		0.561911f, 0.390583f, 0.561992f, 0.609729f, 
		0.561994f, 0.609714f, 0.562023f, 0.0651585f, 
		0.562080f, 0.168855f, 0.562129f, 0.694563f, 
		0.562212f, 0.168524f, 0.562304f, 0.173191f, 
		0.562362f, 0.803184f, 0.562402f, 0.805936f, 
		0.562403f, 0.714630f, 0.562456f, 0.329977f, 
		0.562494f, 0.171190f, 0.562762f, 0.282015f, 
		0.562865f, 0.171516f, 0.562930f, 0.209097f, 
		0.562970f, 0.825515f, 0.563052f, 0.171758f, 
		0.563118f, 0.171183f, 0.563146f, 0.374386f, 
		0.563213f, 0.374533f, 0.563273f, 0.171298f, 
		0.563286f, 0.374717f, 0.563589f, 0.285813f, 
		0.563592f, 0.286238f, 0.563592f, 0.285798f, 
		0.563672f, 0.285973f, 0.563730f, 0.288996f, 
		0.563744f, 0.0323270f, 0.563877f, 0.193403f, 
		0.563910f, 0.884335f, 0.563912f, 0.952510f, 
		0.564008f, 0.193939f, 0.564158f, 0.289334f, 
		0.564189f, 0.286602f, 0.564199f, 0.286276f, 
		0.564206f, 0.286257f, 0.564251f, 0.285713f, 
		0.564265f, 0.449436f, 0.564362f, 0.343236f, 
		0.564388f, 0.866041f, 0.564395f, 0.865986f, 
		0.564413f, 0.286292f, 0.564485f, 0.286841f, 
		0.564495f, 0.770602f, 0.564499f, 0.477255f, 
		0.564501f, 0.770599f, 0.564521f, 0.770705f, 
		0.564553f, 0.530317f, 0.564554f, 0.908604f, 
		0.564554f, 0.286524f, 0.564559f, 0.476981f, 
		0.564593f, 0.771563f, 0.564606f, 0.771665f, 
		0.564616f, 0.530777f, 0.564637f, 0.530931f, 
		0.564772f, 0.880242f, 0.564809f, 0.155950f, 
		0.564903f, 0.127217f, 0.565007f, 0.154396f, 
		0.565087f, 0.774645f, 0.565101f, 0.474529f, 
		0.565188f, 0.0128717f, 0.565188f, 0.441447f, 
		0.565188f, 0.474137f, 0.565231f, 0.379470f, 
		0.565232f, 0.379484f, 0.565255f, 0.379536f, 
		0.565292f, 0.912441f, 0.565296f, 0.379627f, 
		0.565312f, 0.379674f, 0.565374f, 0.912887f, 
		0.565377f, 0.940715f, 0.565526f, 0.602416f, 
		0.565554f, 0.571727f, 0.565596f, 0.602197f, 
		0.565622f, 0.572348f, 0.565673f, 0.0863928f, 
		0.565719f, 0.601860f, 0.565756f, 0.264820f, 
		0.565773f, 0.800257f, 0.565789f, 0.949261f, 
		0.565823f, 0.144813f, 0.565881f, 0.144992f, 
		0.566110f, 0.150796f, 0.566111f, 0.948704f, 
		0.566146f, 0.904445f, 0.566194f, 0.0365181f, 
		0.566237f, 0.149347f, 0.566243f, 0.696390f, 
		0.566248f, 0.696379f, 0.566258f, 0.696540f, 
		0.566267f, 0.912268f, 0.566267f, 0.922686f, 
		0.566288f, 0.696412f, 0.566319f, 0.802327f, 
		0.566319f, 0.623203f, 0.566358f, 0.951853f, 
		0.566408f, 0.867357f, 0.566449f, 0.599762f, 
		0.566537f, 0.599510f, 0.566558f, 0.886110f, 
		0.566558f, 0.896777f, 0.566674f, 0.692597f, 
		0.566684f, 0.692611f, 0.566700f, 0.829817f, 
		0.566711f, 0.0774098f, 0.566758f, 0.692655f, 
		0.566769f, 0.692641f, 0.566783f, 0.774645f, 
		0.566791f, 0.612074f, 0.566927f, 0.161166f, 
		0.566941f, 0.00675923f, 0.567010f, 0.583383f, 
		0.567026f, 0.803355f, 0.567034f, 0.548474f, 
		0.567036f, 0.611928f, 0.567207f, 0.701456f, 
		0.567210f, 0.830405f, 0.567423f, 0.0407621f, 
		0.567427f, 0.626889f, 0.567473f, 0.0473423f, 
		0.567551f, 0.108369f, 0.567573f, 0.0472444f, 
		0.567575f, 0.0472344f, 0.567578f, 0.547743f, 
		0.567578f, 0.570297f, 0.567581f, 0.0472494f, 
		0.567587f, 0.824682f, 0.567589f, 0.824670f, 
		0.567589f, 0.824684f, 0.567612f, 0.0194622f, 
		0.567699f, 0.414016f, 0.567710f, 0.547566f, 
		0.567710f, 0.570608f, 0.567891f, 0.413365f, 
		0.567896f, 0.180343f, 0.567896f, 0.413357f, 
		0.567962f, 0.0700653f, 0.568050f, 0.512089f, 
		0.568166f, 0.185230f, 0.568308f, 0.481781f, 
		0.568358f, 0.198568f, 0.568452f, 0.283989f, 
		0.568454f, 0.607423f, 0.568455f, 0.0293403f, 
		0.568491f, 0.284096f, 0.568553f, 0.284238f, 
		0.568577f, 0.607310f, 0.568621f, 0.287226f, 
		0.568670f, 0.284500f, 0.568671f, 0.284483f, 
		0.568674f, 0.284510f, 0.568678f, 0.284487f, 
		0.568735f, 0.287445f, 0.568753f, 0.106744f, 
		0.568787f, 0.284720f, 0.568809f, 0.284796f, 
		0.568818f, 0.964106f, 0.568834f, 0.186344f, 
		0.568880f, 0.000000f, 0.568880f, 0.0566480f, 
		0.568880f, 0.0830432f, 0.568880f, 0.101578f, 
		0.568880f, 0.457425f, 0.568880f, 0.608336f, 
		0.568880f, 0.736273f, 0.568880f, 0.880242f, 
		0.568880f, 0.917286f, 0.568880f, 0.990116f, 
		0.568898f, 0.0732877f, 0.568901f, 0.285004f, 
		0.568907f, 0.186463f, 0.568988f, 0.591452f, 
		0.568990f, 0.670221f, 0.569012f, 0.504596f, 
		0.569034f, 0.186674f, 0.569185f, 0.186943f, 
		0.569273f, 0.187087f, 0.569458f, 0.141028f, 
		0.569693f, 0.969603f, 0.569700f, 0.888358f, 
		0.569834f, 0.309305f, 0.569886f, 0.913188f, 
		0.569895f, 0.616975f, 0.569933f, 0.494237f, 
		0.570316f, 0.897020f, 0.570498f, 0.498884f, 
		0.570727f, 0.940715f, 0.570727f, 0.969195f, 
		0.570741f, 0.884339f, 0.570767f, 0.942440f, 
		0.570786f, 0.497712f, 0.570875f, 0.948013f, 
		0.570911f, 0.211439f, 0.570921f, 0.211421f, 
		0.571195f, 0.0157901f, 0.571353f, 0.895412f, 
		0.571550f, 0.895633f, 0.571605f, 0.717160f, 
		0.571832f, 0.456448f, 0.571871f, 0.0468472f, 
		0.572183f, 0.525211f, 0.572212f, 0.820904f, 
		0.572374f, 0.0150171f, 0.572400f, 0.119465f, 
		0.572557f, 0.894673f, 0.572573f, 0.000000f, 
		0.572573f, 0.101578f, 0.572573f, 0.125255f, 
		0.572573f, 0.142444f, 0.572573f, 0.146123f, 
		0.572573f, 0.163566f, 0.572573f, 0.163603f, 
		0.572573f, 0.381040f, 0.572573f, 0.396043f, 
		0.572573f, 0.396054f, 0.572573f, 0.397408f, 
		0.572573f, 0.397423f, 0.572573f, 0.421744f, 
		0.572573f, 0.541033f, 0.572573f, 0.552461f, 
		0.572573f, 0.694934f, 0.572573f, 0.861714f, 
		0.572985f, 0.929337f, 0.573224f, 0.790897f, 
		0.573280f, 0.476242f, 0.573514f, 0.905208f, 
		0.573541f, 0.477358f, 0.573619f, 0.963699f, 
		0.573744f, 0.371854f, 0.573832f, 0.597849f, 
		0.573884f, 0.785634f, 0.573961f, 0.792187f, 
		0.574164f, 0.00582105f, 0.574294f, 0.469376f, 
		0.574338f, 0.819176f, 0.574439f, 0.148210f, 
		0.574461f, 0.942441f, 0.574499f, 0.0604620f, 
		0.574596f, 0.455534f, 0.574606f, 0.596548f, 
		0.574670f, 0.694186f, 0.574702f, 0.472737f, 
		0.574723f, 0.694190f, 0.574774f, 0.490011f, 
		0.574824f, 0.122936f, 0.574824f, 0.137919f, 
		0.574824f, 0.122934f, 0.574824f, 0.137918f, 
		0.574824f, 0.122936f, 0.574824f, 0.137918f, 
		0.574824f, 0.122942f, 0.574824f, 0.137917f, 
		0.574824f, 0.122938f, 0.574824f, 0.137917f, 
		0.574916f, 0.592912f, 0.574929f, 0.800878f, 
		0.574975f, 0.694229f, 0.575044f, 0.789791f, 
		0.575074f, 0.694278f, 0.575106f, 0.822743f, 
		0.575143f, 0.794879f, 0.575152f, 0.794896f, 
		0.575165f, 0.600513f, 0.575344f, 0.987167f, 
		0.575396f, 0.624119f, 0.575446f, 0.455252f, 
		0.575562f, 0.987499f, 0.575584f, 0.987533f, 
		0.575705f, 0.987724f, 0.575789f, 0.195941f, 
		0.575802f, 0.195938f, 0.575923f, 0.988056f, 
		0.575976f, 0.202456f, 0.576341f, 0.0200914f, 
		0.576352f, 0.994640f, 0.576363f, 0.201893f, 
		0.576379f, 0.313130f, 0.576615f, 0.123925f, 
		0.576672f, 0.790332f, 0.576693f, 0.175944f, 
		0.576735f, 0.530046f, 0.577679f, 0.0186772f, 
		0.577679f, 0.495058f, 0.577679f, 0.621153f, 
		0.577679f, 0.661010f, 0.577863f, 0.298020f, 
		0.577895f, 0.000000f, 0.577895f, 0.00730358f, 
		0.577895f, 0.0118588f, 0.577895f, 0.0206830f, 
		0.577895f, 0.0446373f, 0.577895f, 0.0530884f, 
		0.577895f, 0.0659301f, 0.577895f, 0.0876627f, 
		0.577895f, 0.0929495f, 0.577895f, 0.111868f, 
		0.577895f, 0.129484f, 0.577895f, 0.140103f, 
		0.577895f, 0.142042f, 0.577895f, 0.142719f, 
		0.577895f, 0.179252f, 0.577895f, 0.183381f, 
		0.577895f, 0.191179f, 0.577895f, 0.198476f, 
		0.577895f, 0.220789f, 0.577895f, 0.247067f, 
		0.577895f, 0.276813f, 0.577895f, 0.288644f, 
		0.577895f, 0.307060f, 0.577895f, 0.317202f, 
		0.577895f, 0.328793f, 0.577895f, 0.360929f, 
		0.577895f, 0.379891f, 0.577895f, 0.398195f, 
		0.577895f, 0.401923f, 0.577895f, 0.423736f, 
		0.577895f, 0.429441f, 0.577895f, 0.446509f, 
		0.577895f, 0.472513f, 0.577895f, 0.491095f, 
		0.577895f, 0.528617f, 0.577895f, 0.539538f, 
		0.577895f, 0.539913f, 0.577895f, 0.561267f, 
		0.577993f, 0.995634f, 0.578214f, 0.305323f, 
		0.578268f, 0.711024f, 0.578279f, 0.711031f, 
		0.578754f, 0.202919f, 0.578763f, 0.202932f, 
		0.578938f, 0.813660f, 0.579055f, 0.383585f, 
		0.579412f, 0.969199f, 0.579470f, 0.407446f, 
		0.579483f, 0.188347f, 0.579570f, 0.188315f, 
		0.580142f, 0.416604f, 0.580144f, 0.416655f, 
		0.580157f, 0.894804f, 0.580178f, 0.519855f, 
		0.580316f, 0.521230f, 0.580384f, 0.793890f, 
		0.580695f, 0.945321f, 0.580907f, 0.000000f, 
		0.580907f, 0.0696650f, 0.580907f, 0.0849831f, 
		0.580907f, 0.0850316f, 0.580907f, 0.0884168f, 
		0.580907f, 0.104498f, 0.580907f, 0.195243f, 
		0.580907f, 0.267050f, 0.580907f, 0.307588f, 
		0.580907f, 0.307946f, 0.580907f, 0.384882f, 
		0.580907f, 0.423788f, 0.580907f, 0.469615f, 
		0.580907f, 0.525072f, 0.580907f, 0.526226f, 
		0.580907f, 0.526243f, 0.580907f, 0.545711f, 
		0.580907f, 0.614520f, 0.580907f, 0.614544f, 
		0.580907f, 0.614561f, 0.580907f, 0.685041f, 
		0.580907f, 0.706547f, 0.580907f, 0.706653f, 
		0.580907f, 0.706820f, 0.580907f, 0.708546f, 
		0.580907f, 0.731485f, 0.580907f, 0.803871f, 
		0.580907f, 0.808822f, 0.580907f, 0.808975f, 
		0.580907f, 0.809255f, 0.580907f, 0.824372f, 
		0.580907f, 0.894037f, 0.580907f, 0.914087f, 
		0.580907f, 0.914393f, 0.580907f, 0.914481f, 
		0.580907f, 0.916028f, 0.580907f, 0.928870f, 
		0.580907f, 0.981119f, 0.580907f, 0.998535f, 
		0.581711f, 0.911899f, 0.581712f, 0.529887f, 
		0.582784f, 0.0580540f, 0.582784f, 0.0873562f, 
		0.582784f, 0.0873689f, 0.582784f, 0.0881401f, 
		0.582784f, 0.0883529f, 0.582784f, 0.121914f, 
		0.582784f, 0.400575f, 0.582784f, 0.423218f, 
		0.582784f, 0.452824f, 0.582784f, 0.499268f, 
		0.582784f, 0.524871f, 0.582784f, 0.615376f, 
		0.582784f, 0.695765f, 0.582784f, 0.799787f, 
		0.582784f, 0.812287f, 0.582784f, 0.876621f, 
		0.582784f, 0.894037f, 0.582784f, 0.946286f, 
		0.582784f, 0.974746f, 0.582784f, 0.998535f, 
		0.585172f, 0.192989f, 0.585172f, 0.222680f, 
		0.585172f, 0.282061f, 0.585172f, 0.341443f, 
		0.585172f, 0.393401f, 0.585172f, 0.448252f, 
		0.585172f, 0.460205f, 0.585172f, 0.489896f, 
		0.585172f, 0.556700f, 0.585172f, 0.578968f, 
		0.585172f, 0.608659f, 0.585172f, 0.697730f, 
		0.585172f, 0.724555f, 0.585172f, 0.786803f, 
		0.586637f, 0.0125525f, 0.586637f, 0.0125809f, 
		0.586637f, 0.0230432f, 0.586637f, 0.0812760f, 
		0.586637f, 0.133665f, 0.586637f, 0.133677f, 
		0.586637f, 0.218850f, 0.586637f, 0.263716f, 
		0.586637f, 0.263732f, 0.586637f, 0.263746f, 
		0.586637f, 0.405457f, 0.586637f, 0.405984f, 
		0.586637f, 0.405997f, 0.586637f, 0.521192f, 
		0.586637f, 0.521224f, 0.586637f, 0.566492f, 
		0.586637f, 0.685041f, 0.586637f, 0.977922f, 
		0.586637f, 0.985974f, 0.587246f, 0.598377f, 
		0.587535f, 0.144559f, 0.588770f, 0.688765f, 
		0.589108f, 0.0605270f, 0.589848f, 0.642655f, 
		0.589852f, 0.642679f, 0.590239f, 0.354661f, 
		0.590321f, 0.123712f, 0.590321f, 0.397782f, 
		0.590321f, 0.870104f, 0.590321f, 0.933468f, 
		0.590373f, 0.601552f, 0.590604f, 0.851263f, 
		0.590605f, 0.851245f, 0.590812f, 0.844443f, 
		0.591060f, 0.601835f, 0.591104f, 0.373763f, 
		0.591127f, 0.204131f, 0.591215f, 0.913125f, 
		0.591243f, 0.106193f, 0.591308f, 0.890721f, 
		0.591318f, 0.106247f, 0.591364f, 0.256791f, 
		0.591418f, 0.125627f, 0.591479f, 0.752698f, 
		0.591481f, 0.452515f, 0.591543f, 0.740189f, 
		0.591699f, 0.589982f, 0.592117f, 0.373105f, 
		0.592161f, 0.481613f, 0.592167f, 0.397383f, 
		0.592184f, 0.0346939f, 0.592204f, 0.246030f, 
		0.592236f, 0.397338f, 0.592291f, 0.310292f, 
		0.592337f, 0.841923f, 0.592381f, 0.761784f, 
		0.592397f, 0.440816f, 0.592404f, 0.455976f, 
		0.592419f, 0.455840f, 0.592559f, 0.000000f, 
		0.592562f, 0.229580f, 0.592574f, 0.587401f, 
		0.592584f, 0.0807089f, 0.592625f, 0.957499f, 
		0.592634f, 0.592828f, 0.592685f, 0.592717f, 
		0.592720f, 0.741556f, 0.592728f, 0.802066f, 
		0.592757f, 0.471309f, 0.592767f, 0.0808694f, 
		0.592835f, 0.00133446f, 0.592835f, 0.00136118f, 
		0.592835f, 0.0170242f, 0.592835f, 0.0170634f, 
		0.592835f, 0.0219488f, 0.592835f, 0.0267445f, 
		0.592835f, 0.0309817f, 0.592835f, 0.0571227f, 
		0.592835f, 0.0929075f, 0.592835f, 0.112482f, 
		0.592835f, 0.125864f, 0.592835f, 0.151663f, 
		0.592835f, 0.159244f, 0.592835f, 0.165664f, 
		0.592835f, 0.166307f, 0.592835f, 0.170144f, 
		0.592835f, 0.178568f, 0.592835f, 0.188162f, 
		0.592835f, 0.191264f, 0.592835f, 0.202553f, 
		0.592835f, 0.229921f, 0.592835f, 0.249352f, 
		0.592835f, 0.262011f, 0.592835f, 0.262867f, 
		0.592835f, 0.264879f, 0.592835f, 0.294074f, 
		0.592835f, 0.294820f, 0.592835f, 0.322841f, 
		0.592835f, 0.326585f, 0.592835f, 0.328970f, 
		0.592835f, 0.333548f, 0.592835f, 0.357418f, 
		0.592835f, 0.359708f, 0.592835f, 0.377116f, 
		0.592835f, 0.385496f, 0.592835f, 0.390192f, 
		0.592835f, 0.413671f, 0.592835f, 0.429117f, 
		0.592835f, 0.440376f, 0.592835f, 0.440412f, 
		0.592835f, 0.452394f, 0.592835f, 0.459315f, 
		0.592835f, 0.459799f, 0.592835f, 0.485953f, 
		0.592835f, 0.488858f, 0.592835f, 0.491601f, 
		0.592835f, 0.495218f, 0.592835f, 0.515418f, 
		0.592835f, 0.521348f, 0.592835f, 0.522141f, 
		0.592835f, 0.527072f, 0.592835f, 0.529533f, 
		0.592835f, 0.535649f, 0.592835f, 0.537783f, 
		0.592835f, 0.550005f, 0.592835f, 0.566310f, 
		0.592835f, 0.567686f, 0.592835f, 0.576546f, 
		0.592835f, 0.576886f, 0.592835f, 0.594308f, 
		0.592835f, 0.597450f, 0.592835f, 0.606924f, 
		0.592835f, 0.634347f, 0.592835f, 0.660232f, 
		0.592835f, 0.665235f, 0.592835f, 0.665504f, 
		0.592835f, 0.667936f, 0.592835f, 0.668546f, 
		0.592835f, 0.687443f, 0.592859f, 0.822829f, 
		0.592878f, 0.479026f, 0.592882f, 0.247845f, 
		0.592885f, 0.372509f, 0.593075f, 0.0851659f, 
		0.593305f, 0.249867f, 0.593354f, 0.193167f, 
		0.593428f, 0.479763f, 0.593519f, 0.714982f, 
		0.593644f, 0.697578f, 0.593837f, 0.659263f, 
		0.593930f, 0.308706f, 0.593942f, 0.662976f, 
		0.593943f, 0.658947f, 0.594092f, 0.277565f, 
		0.594308f, 0.687005f, 0.594372f, 0.666791f, 
		0.594373f, 0.742490f, 0.594435f, 0.771797f, 
		0.594543f, 0.00878902f, 0.594705f, 0.350177f, 
		0.594736f, 0.212271f, 0.595220f, 0.0912617f, 
		0.595490f, 0.000000f, 0.595635f, 0.961704f, 
		0.595660f, 0.207818f, 0.595832f, 0.684313f, 
		0.595863f, 0.00522994f, 0.595876f, 0.00513817f, 
		0.595924f, 0.960661f, 0.596033f, 0.497416f, 
		0.596069f, 0.874957f, 0.596094f, 0.00532745f, 
		0.596158f, 0.0165660f, 0.596197f, 0.661633f, 
		0.596538f, 0.966038f, 0.596577f, 0.208648f, 
		0.596700f, 0.224912f, 0.596864f, 0.209151f, 
		0.596879f, 0.576035f, 0.597142f, 0.397436f, 
		0.597211f, 0.00535374f, 0.597343f, 0.173772f, 
		0.597474f, 0.303488f, 0.597652f, 0.199582f, 
		0.597693f, 0.671864f, 0.597880f, 0.442399f, 
		0.598020f, 0.643663f, 0.598182f, 0.117078f, 
		0.598544f, 0.118177f, 0.598830f, 0.156630f, 
		0.598832f, 0.359133f, 0.599247f, 0.400605f, 
		0.599328f, 0.646827f, 0.599365f, 0.397403f, 
		0.599422f, 0.0171063f, 0.599500f, 0.347936f, 
		0.599502f, 0.668391f, 0.599503f, 0.347931f, 
		0.599581f, 0.0231979f, 0.599667f, 0.665121f, 
		0.600334f, 0.408512f, 0.600393f, 0.646448f, 
		0.600561f, 0.0482330f, 0.600874f, 0.339689f, 
		0.601031f, 0.334979f, 0.601489f, 0.395991f, 
		0.602318f, 0.270920f, 0.603049f, 0.343840f, 
		0.603121f, 0.275932f, 0.603342f, 0.0968414f, 
		0.603361f, 0.356860f, 0.603377f, 0.0851092f, 
		0.603405f, 0.274037f, 0.603543f, 0.153469f, 
		0.603763f, 0.276001f, 0.603840f, 0.276896f, 
		0.603857f, 0.0156870f, 0.603857f, 0.404858f, 
		0.604027f, 0.438354f, 0.604210f, 0.0805275f, 
		0.604294f, 0.0817925f, 0.604375f, 0.0829187f, 
		0.604618f, 0.352506f, 0.604635f, 0.148917f, 
		0.604638f, 0.148784f, 0.604638f, 0.148958f, 
		0.604716f, 0.215835f, 0.604960f, 0.0127187f, 
		0.604960f, 0.0140676f, 0.604960f, 0.0164176f, 
		0.604960f, 0.215794f, 0.604960f, 0.215905f, 
		0.604960f, 0.215921f, 0.604960f, 0.295988f, 
		0.604960f, 0.296004f, 0.604960f, 0.394924f, 
		0.604960f, 0.404459f, 0.604976f, 0.144845f, 
		0.605186f, 0.280811f, 0.605387f, 0.139882f, 
		0.605387f, 0.139897f, 0.605387f, 0.140345f, 
		0.605387f, 0.141164f, 0.605387f, 0.310307f, 
		0.605387f, 0.310324f, 0.605387f, 0.317168f, 
		0.605387f, 0.317385f, 0.606055f, 0.509693f, 
		0.606425f, 0.0208923f, 0.606425f, 0.0209044f, 
		0.606425f, 0.0415835f, 0.606425f, 0.0416105f, 
		0.606425f, 0.0934953f, 0.606425f, 0.0935624f, 
		0.606425f, 0.110453f, 0.606425f, 0.110464f, 
		0.606425f, 0.217999f, 0.606425f, 0.235531f, 
		0.606425f, 0.235562f, 0.606425f, 0.255615f, 
		0.606425f, 0.260108f, 0.606425f, 0.281457f, 
		0.606425f, 0.321889f, 0.606425f, 0.321903f, 
		0.606425f, 0.343342f, 0.606425f, 0.359280f, 
		0.606425f, 0.359312f, 0.606425f, 0.363733f, 
		0.606425f, 0.364341f, 0.606425f, 0.384269f, 
		0.606425f, 0.385104f, 0.606425f, 0.385163f, 
		0.606425f, 0.406475f, 0.606425f, 0.406513f, 
		0.606425f, 0.425469f, 0.606425f, 0.425483f, 
		0.606425f, 0.425558f, 0.606425f, 0.474357f, 
		0.606425f, 0.492030f, 0.606425f, 0.492040f, 
		0.606425f, 0.516301f, 0.606425f, 0.516331f, 
		0.606425f, 0.551429f, 0.606425f, 0.598970f, 
		0.607102f, 0.153674f, 0.607116f, 0.153742f, 
		0.607215f, 0.157482f, 0.607343f, 0.585677f, 
		0.607377f, 0.195753f, 0.607483f, 0.662544f, 
		0.607771f, 0.176570f, 0.607775f, 0.176621f, 
		0.607797f, 0.176626f, 0.608251f, 0.890546f, 
		0.608538f, 0.475858f, 0.608842f, 0.301619f, 
		0.609560f, 0.553508f, 0.609815f, 0.0177706f, 
		0.609843f, 0.00195131f, 0.609947f, 0.600694f, 
		0.610080f, 0.681644f, 0.610316f, 0.0219643f, 
		0.610557f, 0.666364f, 0.610566f, 0.000000f, 
		0.610566f, 0.539538f, 0.610573f, 0.000000f, 
		0.610573f, 0.539538f, 0.610787f, 0.309296f, 
		0.610918f, 0.147832f, 0.611361f, 0.205823f, 
		0.611692f, 0.546854f, 0.611714f, 0.0196861f, 
		0.611848f, 0.0245917f, 0.612080f, 0.681462f, 
		0.612949f, 0.120311f, 0.612954f, 0.0129772f, 
		0.613023f, 0.383139f, 0.613198f, 0.681028f, 
		0.613601f, 0.0567352f, 0.613621f, 0.536991f, 
		0.613873f, 0.0863301f, 0.614177f, 0.186610f, 
		0.614177f, 0.204466f, 0.614177f, 0.318390f, 
		0.614193f, 0.145852f, 0.614274f, 0.943361f, 
		0.614421f, 0.0397455f, 0.614421f, 0.0397646f, 
		0.614421f, 0.0587093f, 0.614421f, 0.0588338f, 
		0.614421f, 0.0794557f, 0.614421f, 0.138310f, 
		0.614421f, 0.138924f, 0.614421f, 0.197074f, 
		0.614421f, 0.208529f, 0.614421f, 0.208738f, 
		0.614421f, 0.269666f, 0.614421f, 0.271126f, 
		0.614421f, 0.331084f, 0.614421f, 0.331117f, 
		0.614421f, 0.342443f, 0.614421f, 0.342465f, 
		0.614421f, 0.400781f, 0.614421f, 0.401104f, 
		0.614421f, 0.460084f, 0.614421f, 0.460104f, 
		0.614421f, 0.480792f, 0.614421f, 0.499732f, 
		0.614421f, 0.499804f, 0.614519f, 0.145730f, 
		0.614522f, 0.145685f, 0.614522f, 0.146149f, 
		0.614582f, 0.144954f, 0.614590f, 0.146017f, 
		0.614651f, 0.161640f, 0.614734f, 0.426996f, 
		0.614858f, 0.0214125f, 0.614937f, 0.186970f, 
		0.614964f, 0.361819f, 0.615239f, 0.670031f, 
		0.615258f, 0.295908f, 0.615439f, 0.0990112f, 
		0.615613f, 0.641869f, 0.615617f, 0.434233f, 
		0.615879f, 0.428887f, 0.615886f, 0.286550f, 
		0.615886f, 0.286561f, 0.615886f, 0.394747f, 
		0.615886f, 0.394764f, 0.615886f, 0.473004f, 
		0.615886f, 0.654305f, 0.615886f, 0.655186f, 
		0.615951f, 0.205300f, 0.616098f, 0.577477f, 
		0.616110f, 0.732339f, 0.616112f, 0.00348177f, 
		0.616225f, 0.552606f, 0.616336f, 0.496804f, 
		0.616401f, 0.182246f, 0.616449f, 0.140614f, 
		0.616610f, 0.148397f, 0.617802f, 0.0887365f, 
		0.617879f, 0.423525f, 0.617903f, 0.187828f, 
		0.617989f, 0.150179f, 0.618132f, 0.000000f, 
		0.618142f, 0.459382f, 0.618176f, 0.459481f, 
		0.618379f, 0.166541f, 0.618400f, 0.466897f, 
		0.618407f, 0.215968f, 0.618561f, 0.168634f, 
		0.618587f, 0.431703f, 0.618780f, 0.459366f, 
		0.619091f, 0.0381881f, 0.619096f, 0.154780f, 
		0.619372f, 0.456441f, 0.619516f, 0.165029f, 
		0.619616f, 0.983377f, 0.619617f, 0.550777f, 
		0.620267f, 0.204033f, 0.620918f, 0.246032f, 
		0.620925f, 0.246016f, 0.621200f, 0.0473506f, 
		0.623198f, 0.318390f, 0.623224f, 0.318390f, 
		0.623678f, 0.000000f, 0.624900f, 0.00404146f, 
		0.624949f, 0.00420450f, 0.626196f, 0.000000f, 
		0.626196f, 0.0168697f, 0.626196f, 0.0353264f, 
		0.626196f, 0.0437733f, 0.626196f, 0.107283f, 
		0.626196f, 0.139369f, 0.626196f, 0.168699f, 
		0.626196f, 0.168716f, 0.626196f, 0.213685f, 
		0.626196f, 0.275541f, 0.626196f, 0.290918f, 
		0.626196f, 0.297438f, 0.626196f, 0.334252f, 
		0.626196f, 0.334275f, 0.626196f, 0.348644f, 
		0.626196f, 0.393631f, 0.626196f, 0.444241f, 
		0.626196f, 0.473588f, 0.626196f, 0.476563f, 
		0.626196f, 0.483604f, 0.626196f, 0.506096f, 
		0.626196f, 0.573577f, 0.626196f, 0.605099f, 
		0.626196f, 0.617409f, 0.626196f, 0.658869f, 
		0.626196f, 0.692854f, 0.626196f, 0.745112f, 
		0.626196f, 0.768872f, 0.626196f, 0.788888f, 
		0.626196f, 0.862339f, 0.626196f, 0.876002f, 
		0.626196f, 0.899728f, 0.626196f, 0.924879f, 
		0.626196f, 0.967207f, 0.630088f, 0.574903f, 
		0.630611f, 0.554442f, 0.630614f, 0.0128606f, 
		0.631302f, 0.297474f, 0.631597f, 0.0481357f, 
		0.632395f, 0.939895f, 0.632872f, 0.424331f, 
		0.632908f, 0.424263f, 0.634725f, 0.449651f, 
		0.634858f, 0.848076f, 0.635234f, 0.569708f, 
		0.635236f, 0.569697f, 0.635330f, 0.175326f, 
		0.635742f, 0.308384f, 0.635939f, 0.176134f, 
		0.635995f, 0.176022f, 0.636165f, 0.893178f, 
		0.636196f, 0.671438f, 0.638187f, 0.00813859f, 
		0.638820f, 0.979878f, 0.641707f, 0.0733542f, 
		0.643302f, 0.000000f, 0.643302f, 0.998535f, 
		0.644331f, 0.744341f, 0.645168f, 0.375395f, 
		0.645176f, 0.375369f, 0.651005f, 0.204033f, 
		0.651053f, 0.690910f, 0.651303f, 0.00931005f, 
		0.651456f, 0.0263958f, 0.652275f, 0.297678f, 
		0.652512f, 0.0478426f, 0.652809f, 0.456229f, 
		0.653215f, 0.0262023f, 0.653454f, 0.687443f, 
		0.653486f, 0.601371f, 0.653562f, 0.998535f, 
		0.654227f, 0.199702f, 0.655130f, 0.733243f, 
		0.655387f, 0.675092f, 0.656394f, 0.292399f, 
		0.657971f, 0.455959f, 0.658598f, 0.0776717f, 
		0.658886f, 0.0786089f, 0.658999f, 0.441737f, 
		0.659130f, 0.0788226f, 0.659587f, 0.148323f, 
		0.659852f, 0.980403f, 0.659962f, 0.518179f, 
		0.660370f, 0.169499f, 0.660377f, 0.508262f, 
		0.660741f, 0.230741f, 0.661416f, 0.634343f, 
		0.662115f, 0.307878f, 0.662636f, 0.459492f, 
		0.662853f, 0.213308f, 0.663271f, 0.555584f, 
		0.663286f, 0.293666f, 0.663378f, 0.555253f, 
		0.663408f, 0.554151f, 0.663667f, 0.211258f, 
		0.663784f, 0.555779f, 0.664000f, 0.555477f, 
		0.664109f, 0.554939f, 0.664325f, 0.552899f, 
		0.664332f, 0.461333f, 0.664404f, 0.554577f, 
		0.664573f, 0.553400f, 0.664589f, 0.553404f, 
		0.664686f, 0.553153f, 0.664941f, 0.555206f, 
		0.666940f, 0.198235f, 0.667115f, 0.698489f, 
		0.668787f, 0.0859968f, 0.669147f, 0.00538262f, 
		0.669716f, 0.820727f, 0.669858f, 0.224360f, 
		0.669981f, 0.288276f, 0.670219f, 0.748205f, 
		0.670699f, 0.00420985f, 0.670699f, 0.997551f, 
		0.671206f, 0.332467f, 0.671233f, 0.821614f, 
		0.671284f, 0.344266f, 0.671426f, 0.563089f, 
		0.671536f, 0.445934f, 0.671652f, 0.376879f, 
		0.671689f, 0.375499f, 0.671874f, 0.130707f, 
		0.672180f, 0.0957857f, 0.672405f, 0.459800f, 
		0.672475f, 0.256788f, 0.672516f, 0.000000f, 
		0.672576f, 0.496425f, 0.672693f, 0.597713f, 
		0.672720f, 0.119432f, 0.672752f, 0.0476303f, 
		0.673183f, 0.372095f, 0.673318f, 0.0276359f, 
		0.673461f, 0.490799f, 0.673685f, 0.263333f, 
		0.673755f, 0.463901f, 0.673758f, 0.219879f, 
		0.673758f, 0.315268f, 0.673758f, 0.406335f, 
		0.673758f, 0.550301f, 0.673928f, 0.0149080f, 
		0.673928f, 0.376266f, 0.673928f, 0.716357f, 
		0.674106f, 0.298512f, 0.674155f, 0.316137f, 
		0.674237f, 0.315502f, 0.675048f, 0.130061f, 
		0.675223f, 0.00720544f, 0.675223f, 0.0967819f, 
		0.675223f, 0.0968216f, 0.675223f, 0.168212f, 
		0.675223f, 0.209875f, 0.675223f, 0.267445f, 
		0.675223f, 0.278639f, 0.675223f, 0.360639f, 
		0.675223f, 0.425839f, 0.675223f, 0.491650f, 
		0.675223f, 0.491672f, 0.675223f, 0.560258f, 
		0.675223f, 0.560291f, 0.675393f, 0.000000f, 
		0.675442f, 0.131506f, 0.675442f, 0.131517f, 
		0.675442f, 0.131543f, 0.675514f, 0.0195470f, 
		0.675614f, 0.297852f, 0.675724f, 0.297776f, 
		0.675778f, 0.512880f, 0.675784f, 0.512907f, 
		0.676171f, 0.513301f, 0.676269f, 0.000000f, 
		0.676269f, 0.0232220f, 0.676269f, 0.150941f, 
		0.676269f, 0.173966f, 0.676269f, 0.197385f, 
		0.676269f, 0.267050f, 0.676269f, 0.296741f, 
		0.676269f, 0.309305f, 0.676269f, 0.335608f, 
		0.676269f, 0.363908f, 0.676269f, 0.406381f, 
		0.676269f, 0.442892f, 0.676269f, 0.450846f, 
		0.676269f, 0.465965f, 0.676269f, 0.487108f, 
		0.676269f, 0.567003f, 0.676269f, 0.578875f, 
		0.676269f, 0.613584f, 0.676269f, 0.628384f, 
		0.676269f, 0.689091f, 0.676269f, 0.704520f, 
		0.676269f, 0.847167f, 0.676269f, 0.848392f, 
		0.676269f, 0.914218f, 0.676269f, 0.917794f, 
		0.676269f, 0.986132f, 0.676269f, 0.998535f, 
		0.676550f, 0.0129744f, 0.676629f, 0.303968f, 
		0.676633f, 0.304218f, 0.677184f, 0.490473f, 
		0.677720f, 0.466617f, 0.677844f, 0.140938f, 
		0.677849f, 0.140966f, 0.678836f, 0.00952556f, 
		0.678983f, 0.637686f, 0.680260f, 0.00353550f, 
		0.680505f, 0.293690f, 0.680847f, 0.198052f, 
		0.680921f, 0.0791913f, 0.681171f, 0.0793815f, 
		0.681179f, 0.0792083f, 0.681195f, 0.387525f, 
		0.681197f, 0.387507f, 0.681210f, 0.387507f, 
		0.681215f, 0.0793910f, 0.681240f, 0.0794131f, 
		0.681400f, 0.0792261f, 0.681415f, 0.0793399f, 
		0.681935f, 0.289103f, 0.682008f, 0.488071f, 
		0.682013f, 0.0791314f, 0.682199f, 0.0793790f, 
		0.682202f, 0.0580660f, 0.682405f, 0.325442f, 
		0.682475f, 0.662802f, 0.682576f, 0.661751f, 
		0.682663f, 0.000000f, 0.682708f, 0.0785595f, 
		0.682788f, 0.662283f, 0.682803f, 0.290989f, 
		0.682803f, 0.333521f, 0.682805f, 0.662272f, 
		0.682807f, 0.333518f, 0.684467f, 0.0159271f, 
		0.684470f, 0.187287f, 0.684944f, 0.728709f, 
		0.684951f, 0.728655f, 0.685426f, 0.0958842f, 
		0.685532f, 0.605135f, 0.685604f, 0.410937f, 
		0.685663f, 0.00953311f, 0.685783f, 0.678437f, 
		0.685933f, 0.00953406f, 0.686020f, 0.00952741f, 
		0.686024f, 0.000000f, 0.686026f, 0.193671f, 
		0.686040f, 0.00952090f, 0.686238f, 0.250961f, 
		0.686310f, 0.476078f, 0.686314f, 0.476064f, 
		0.686449f, 0.306666f, 0.686463f, 0.306679f, 
		0.686481f, 0.476632f, 0.686555f, 0.000000f, 
		0.686555f, 0.998535f, 0.686586f, 0.664797f, 
		0.686675f, 0.447880f, 0.686675f, 0.447896f, 
		0.686993f, 0.573519f, 0.688024f, 0.161899f, 
		0.688047f, 0.621172f, 0.688244f, 0.161593f, 
		0.688251f, 0.161728f, 0.688300f, 0.593059f, 
		0.688311f, 0.161817f, 0.688374f, 0.506953f, 
		0.688397f, 0.161398f, 0.688517f, 0.628332f, 
		0.688565f, 0.161323f, 0.688593f, 0.126902f, 
		0.688606f, 0.628918f, 0.688618f, 0.161300f, 
		0.688640f, 0.161291f, 0.689035f, 0.161084f, 
		0.689517f, 0.0122536f, 0.689522f, 0.0784804f, 
		0.689695f, 0.0785087f, 0.690065f, 0.751114f, 
		0.690095f, 0.750711f, 0.690359f, 0.503995f, 
		0.690508f, 0.503992f, 0.690522f, 0.442817f, 
		0.690532f, 0.442813f, 0.690682f, 0.751511f, 
		0.690768f, 0.325418f, 0.690904f, 0.324013f, 
		0.690925f, 0.323997f, 0.690942f, 0.360892f, 
		0.691122f, 0.253479f, 0.691123f, 0.444273f, 
		0.691146f, 0.384002f, 0.691768f, 0.325238f, 
		0.691871f, 0.168317f, 0.691933f, 0.356817f, 
		0.692150f, 0.168519f, 0.692279f, 0.360058f, 
		0.692376f, 0.252913f, 0.692450f, 0.639404f, 
		0.692617f, 0.393650f, 0.692621f, 0.393673f, 
		0.692771f, 0.567207f, 0.692897f, 0.355127f, 
		0.693032f, 0.488887f, 0.693246f, 0.445149f, 
		0.693252f, 0.655032f, 0.693406f, 0.249551f, 
		0.693432f, 0.568523f, 0.693448f, 0.658874f, 
		0.693503f, 0.445024f, 0.693747f, 0.000000f, 
		0.693841f, 0.404142f, 0.695035f, 0.324150f, 
		0.695295f, 0.403347f, 0.695479f, 0.403440f, 
		0.695521f, 0.246482f, 0.695521f, 0.241695f, 
		0.695684f, 0.246269f, 0.695699f, 0.246299f, 
		0.695804f, 0.246116f, 0.696059f, 0.584686f, 
		0.696152f, 0.245938f, 0.696211f, 0.403091f, 
		0.696253f, 0.241427f, 0.696321f, 0.000000f, 
		0.696321f, 0.522054f, 0.696495f, 0.246131f, 
		0.696691f, 0.245694f, 0.696820f, 0.245575f, 
		0.697000f, 0.240655f, 0.697246f, 0.0207446f, 
		0.698240f, 0.402817f, 0.698500f, 0.589320f, 
		0.698864f, 0.141511f, 0.699045f, 0.143857f, 
		0.699051f, 0.142301f, 0.699053f, 0.143179f, 
		0.699319f, 0.403032f, 0.700113f, 0.367980f, 
		0.700144f, 0.313168f, 0.700144f, 0.313188f, 
		0.700195f, 0.403553f, 0.701923f, 0.504093f, 
		0.702299f, 0.504012f, 0.702336f, 0.343793f, 
		0.702527f, 0.190833f, 0.702679f, 0.232064f, 
		0.702756f, 0.475525f, 0.702926f, 0.505871f, 
		0.702979f, 0.114082f, 0.703041f, 0.165254f, 
		0.703505f, 0.188046f, 0.703837f, 0.200359f, 
		0.704180f, 0.473136f, 0.704592f, 0.131139f, 
		0.704653f, 0.396985f, 0.704920f, 0.406052f, 
		0.705313f, 0.158277f, 0.705612f, 0.0688390f, 
		0.705996f, 0.000000f, 0.705996f, 0.0154285f, 
		0.705996f, 0.0638143f, 0.705996f, 0.0838913f, 
		0.705996f, 0.155951f, 0.705996f, 0.237013f, 
		0.705996f, 0.240074f, 0.705996f, 0.286423f, 
		0.705996f, 0.311965f, 0.705996f, 0.323082f, 
		0.705996f, 0.326117f, 0.705996f, 0.407095f, 
		0.705996f, 0.407592f, 0.705996f, 0.478792f, 
		0.705996f, 0.486099f, 0.705996f, 0.552439f, 
		0.705996f, 0.557986f, 0.705996f, 0.591452f, 
		0.706020f, 0.0824124f, 0.706202f, 0.161693f, 
		0.706202f, 0.164303f, 0.706242f, 0.318099f, 
		0.706581f, 0.200093f, 0.706955f, 0.299865f, 
		0.707217f, 0.544899f, 0.707262f, 0.345801f, 
		0.707420f, 0.432859f, 0.707662f, 0.339041f, 
		0.707775f, 0.127361f, 0.708362f, 0.200116f, 
		0.708397f, 0.215350f, 0.708494f, 0.440964f, 
		0.708610f, 0.448633f, 0.708613f, 0.250892f, 
		0.708666f, 0.0412207f, 0.709132f, 0.402324f, 
		0.709308f, 0.241198f, 0.709768f, 0.459290f, 
		0.710223f, 0.538932f, 0.710334f, 0.366607f, 
		0.710748f, 0.480516f, 0.711594f, 0.0746181f, 
		0.711594f, 0.133432f, 0.711594f, 0.165087f, 
		0.711594f, 0.262115f, 0.711594f, 0.298923f, 
		0.711594f, 0.300679f, 0.711594f, 0.300755f, 
		0.711594f, 0.390952f, 0.711594f, 0.409274f, 
		0.711594f, 0.418486f, 0.711594f, 0.419067f, 
		0.711594f, 0.465481f, 0.711594f, 0.511750f, 
		0.711594f, 0.552771f, 0.711594f, 0.576910f, 
		0.711594f, 0.586640f, 0.711594f, 0.604355f, 
		0.711594f, 0.604375f, 0.711594f, 0.667761f, 
		0.711594f, 0.719446f, 0.711594f, 0.720555f, 
		0.711594f, 0.720958f, 0.711594f, 0.809550f, 
		0.711594f, 0.839497f, 0.711594f, 0.848755f, 
		0.711594f, 0.875221f, 0.711594f, 0.911164f, 
		0.712106f, 0.502012f, 0.712169f, 0.997370f, 
		0.712187f, 0.000000f, 0.712352f, 0.000000f, 
		0.712352f, 0.118064f, 0.712352f, 0.118086f, 
		0.712352f, 0.130760f, 0.712352f, 0.202631f, 
		0.712352f, 0.202647f, 0.712352f, 0.255994f, 
		0.712352f, 0.274127f, 0.712352f, 0.274189f, 
		0.712352f, 0.387697f, 0.712352f, 0.487381f, 
		0.712352f, 0.487965f, 0.712352f, 0.511155f, 
		0.712352f, 0.528224f, 0.712352f, 0.544444f, 
		0.712352f, 0.558704f, 0.712352f, 0.676355f, 
		0.712352f, 0.676376f, 0.712352f, 0.676425f, 
		0.712352f, 0.693426f, 0.712352f, 0.694408f, 
		0.712352f, 0.694597f, 0.712352f, 0.694657f, 
		0.712352f, 0.747089f, 0.712352f, 0.747113f, 
		0.712352f, 0.747412f, 0.712352f, 0.772931f, 
		0.712352f, 0.772941f, 0.712352f, 0.846695f, 
		0.712352f, 0.938418f, 0.712352f, 0.998535f, 
		0.713669f, 0.616870f, 0.713787f, 0.998535f, 
		0.713788f, 0.000000f, 0.713788f, 0.998535f, 
		0.713850f, 0.155302f, 0.713957f, 0.000000f, 
		0.713957f, 0.998535f, 0.714170f, 0.609318f, 
		0.714171f, 0.609332f, 0.714173f, 0.00852040f, 
		0.714173f, 0.0110062f, 0.714173f, 0.0897179f, 
		0.714173f, 0.0947669f, 0.714173f, 0.196122f, 
		0.714173f, 0.202763f, 0.714173f, 0.257146f, 
		0.714173f, 0.281067f, 0.714173f, 0.287754f, 
		0.714173f, 0.350687f, 0.714173f, 0.363108f, 
		0.714173f, 0.417568f, 0.714173f, 0.421466f, 
		0.714173f, 0.463461f, 0.714173f, 0.505323f, 
		0.714176f, 0.609323f, 0.714237f, 0.0940835f, 
		0.714309f, 0.616966f, 0.714457f, 0.617021f, 
		0.714679f, 0.156538f, 0.714821f, 0.0865765f, 
		0.715154f, 0.608278f, 0.715168f, 0.608275f, 
		0.715212f, 0.186610f, 0.715638f, 0.158569f, 
		0.715638f, 0.365400f, 0.715644f, 0.558434f, 
		0.715774f, 0.456785f, 0.715777f, 0.456771f, 
		0.715848f, 0.400838f, 0.715985f, 0.0198665f, 
		0.716218f, 0.297790f, 0.716219f, 0.297810f, 
		0.716220f, 0.390765f, 0.716225f, 0.297810f, 
		0.716816f, 0.306827f, 0.716816f, 0.306840f, 
		0.717051f, 0.131224f, 0.717127f, 0.304040f, 
		0.717269f, 0.330151f, 0.717274f, 0.328097f, 
		0.717279f, 0.330138f, 0.717290f, 0.330138f, 
		0.717295f, 0.330159f, 0.717308f, 0.0438724f, 
		0.717806f, 0.390795f, 0.717851f, 0.261862f, 
		0.717909f, 0.205901f, 0.717916f, 0.201453f, 
		0.717945f, 0.548517f, 0.718189f, 0.316974f, 
		0.718854f, 0.475308f, 0.719386f, 0.000000f, 
		0.719386f, 0.0179845f, 0.719390f, 0.103912f, 
		0.719648f, 0.248858f, 0.719681f, 0.159124f, 
		0.719828f, 0.502723f, 0.719832f, 0.502712f, 
		0.719844f, 0.212316f, 0.719869f, 0.212285f, 
		0.719907f, 0.0568024f, 0.719913f, 0.939990f, 
		0.719944f, 0.195193f, 0.719951f, 0.177494f, 
		0.719952f, 0.177504f, 0.719970f, 0.940023f, 
		0.720116f, 0.940035f, 0.720252f, 0.205363f, 
		0.720260f, 0.389354f, 0.720461f, 0.0103116f, 
		0.720820f, 0.545940f, 0.721066f, 0.557990f, 
		0.721260f, 0.0179845f, 0.721372f, 0.396054f, 
		0.721391f, 0.487898f, 0.721417f, 0.195057f, 
		0.721510f, 0.0687505f, 0.721612f, 0.487672f, 
		0.721631f, 0.548745f, 0.721816f, 0.541191f, 
		0.721923f, 0.118440f, 0.722464f, 0.504330f, 
		0.722628f, 0.199396f, 0.722638f, 0.397364f, 
		0.723292f, 0.559159f, 0.723374f, 0.189992f, 
		0.723481f, 0.443267f, 0.723533f, 0.0221299f, 
		0.723580f, 0.265772f, 0.723912f, 0.585845f, 
		0.724113f, 0.852424f, 0.724187f, 0.191421f, 
		0.724420f, 0.395829f, 0.724645f, 0.0381500f, 
		0.724645f, 0.353209f, 0.724772f, 0.133258f, 
		0.724885f, 0.678358f, 0.724915f, 0.591285f, 
		0.725056f, 0.318390f, 0.725320f, 0.678376f, 
		0.725339f, 0.678369f, 0.725348f, 0.00627964f, 
		0.725349f, 0.678361f, 0.725350f, 0.00627657f, 
		0.725358f, 0.678362f, 0.725391f, 0.245441f, 
		0.725437f, 0.123339f, 0.725439f, 0.123325f, 
		0.725489f, 0.417604f, 0.725492f, 0.417615f, 
		0.725516f, 0.181175f, 0.725517f, 0.338678f, 
		0.725571f, 0.0693040f, 0.725765f, 0.830579f, 
		0.726332f, 0.322035f, 0.726882f, 0.357883f, 
		0.727186f, 0.130977f, 0.727462f, 0.0106698f, 
		0.727751f, 0.0106624f, 0.727782f, 0.0106707f, 
		0.728088f, 0.827801f, 0.729177f, 0.278276f, 
		0.729241f, 0.534044f, 0.729241f, 0.534032f, 
		0.729253f, 0.204240f, 0.729253f, 0.318390f, 
		0.729390f, 0.414906f, 0.729394f, 0.414878f, 
		0.729539f, 0.476117f, 0.729676f, 0.173342f, 
		0.729717f, 0.287558f, 0.730571f, 0.00852611f, 
		0.730800f, 0.594858f, 0.731484f, 0.510680f, 
		0.732082f, 0.161740f, 0.732152f, 0.161737f, 
		0.732346f, 0.505637f, 0.732349f, 0.505620f, 
		0.732529f, 0.0745208f, 0.733286f, 0.505562f, 
		0.733677f, 0.0745002f, 0.733883f, 0.0745057f, 
		0.736157f, 0.466233f, 0.737503f, 0.0328368f, 
		0.737514f, 0.0328352f, 0.738850f, 0.163343f, 
		0.739099f, 0.467202f, 0.740050f, 0.265542f, 
		0.740724f, 0.326691f, 0.741565f, 0.126570f, 
		0.742510f, 0.0760542f, 0.742526f, 0.0761527f, 
		0.742892f, 0.253453f, 0.743571f, 0.218554f, 
		0.744412f, 0.485097f, 0.744951f, 0.473374f, 
		0.745623f, 0.202911f, 0.746309f, 0.552515f, 
		0.746375f, 0.553119f, 0.746379f, 0.553139f, 
		0.747112f, 0.265579f, 0.747524f, 0.490725f, 
		0.748145f, 0.272667f, 0.748882f, 0.414545f, 
		0.749353f, 0.397158f, 0.749508f, 0.425857f, 
		0.749579f, 0.590774f, 0.749592f, 0.00553699f, 
		0.749592f, 0.00470812f, 0.749631f, 0.121723f, 
		0.749631f, 0.121707f, 0.749692f, 0.145765f, 
		0.749865f, 0.0540360f, 0.749865f, 0.0817129f, 
		0.749865f, 0.0821573f, 0.749865f, 0.0821674f, 
		0.749865f, 0.162109f, 0.749865f, 0.190924f, 
		0.749865f, 0.190945f, 0.749865f, 0.226695f, 
		0.749865f, 0.226718f, 0.749865f, 0.234592f, 
		0.749865f, 0.234608f, 0.749865f, 0.320507f, 
		0.749865f, 0.386799f, 0.749865f, 0.496047f, 
		0.749865f, 0.496082f, 0.749865f, 0.532500f, 
		0.749929f, 0.668238f, 0.749949f, 0.668243f, 
		0.749951f, 0.668259f, 0.750557f, 0.285384f, 
		0.750933f, 0.139715f, 0.751330f, 0.0305010f, 
		0.751330f, 0.0600086f, 0.751330f, 0.183545f, 
		0.751330f, 0.438344f, 0.751330f, 0.449984f, 
		0.751330f, 0.550120f, 0.751330f, 0.553806f, 
		0.751387f, 0.000000f, 0.751387f, 0.00326400f, 
		0.751387f, 0.0555810f, 0.751387f, 0.0948369f, 
		0.751387f, 0.154386f, 0.751387f, 0.154469f, 
		0.751387f, 0.155099f, 0.751387f, 0.198503f, 
		0.751387f, 0.277739f, 0.751387f, 0.332547f, 
		0.751387f, 0.345931f, 0.751387f, 0.349199f, 
		0.751387f, 0.354961f, 0.751387f, 0.396473f, 
		0.751387f, 0.420214f, 0.751387f, 0.422775f, 
		0.751387f, 0.494463f, 0.751387f, 0.521724f, 
		0.751387f, 0.559214f, 0.751387f, 0.578019f, 
		0.751387f, 0.600538f, 0.751387f, 0.603450f, 
		0.751438f, 0.139628f, 0.751585f, 0.325497f, 
		0.751612f, 0.534075f, 0.751847f, 0.406005f, 
		0.751944f, 0.386813f, 0.752145f, 0.168692f, 
		0.752149f, 0.0200737f, 0.752149f, 0.0201258f, 
		0.752149f, 0.0656115f, 0.752149f, 0.0738011f, 
		0.752149f, 0.174098f, 0.752149f, 0.178352f, 
		0.752149f, 0.217103f, 0.752149f, 0.236653f, 
		0.752149f, 0.274872f, 0.752149f, 0.387804f, 
		0.752149f, 0.427161f, 0.752149f, 0.427403f, 
		0.752149f, 0.458868f, 0.752149f, 0.464477f, 
		0.752149f, 0.517757f, 0.752149f, 0.544387f, 
		0.752149f, 0.545661f, 0.752149f, 0.592912f, 
		0.752149f, 0.595884f, 0.752191f, 0.611259f, 
		0.752781f, 0.0136682f, 0.752852f, 0.000770465f, 
		0.752852f, 0.124046f, 0.752852f, 0.124111f, 
		0.752852f, 0.148671f, 0.752852f, 0.254216f, 
		0.752852f, 0.254229f, 0.752852f, 0.353424f, 
		0.752852f, 0.488177f, 0.752852f, 0.488189f, 
		0.752852f, 0.578795f, 0.752852f, 0.699232f, 
		0.752852f, 0.699243f, 0.752852f, 0.798802f, 
		0.752879f, 0.654231f, 0.752970f, 0.236109f, 
		0.752975f, 0.236097f, 0.753258f, 0.148389f, 
		0.753270f, 0.630544f, 0.753356f, 0.352608f, 
		0.753406f, 0.336149f, 0.753497f, 0.321290f, 
		0.753666f, 0.260655f, 0.753678f, 0.260638f, 
		0.753841f, 0.293133f, 0.753887f, 0.357840f, 
		0.753897f, 0.391102f, 0.753958f, 0.595501f, 
		0.754023f, 0.509134f, 0.754027f, 0.509145f, 
		0.754141f, 0.211844f, 0.754495f, 0.186956f, 
		0.754573f, 0.0368934f, 0.754619f, 0.0369390f, 
		0.754709f, 0.595924f, 0.754819f, 0.150270f, 
		0.754907f, 0.253295f, 0.754921f, 0.253301f, 
		0.755165f, 0.300581f, 0.755776f, 0.112193f, 
		0.756096f, 0.405121f, 0.756260f, 0.231628f, 
		0.756491f, 0.342940f, 0.756588f, 0.00821996f, 
		0.756627f, 0.428792f, 0.756817f, 0.471915f, 
		0.756826f, 0.471874f, 0.756887f, 0.000000f, 
		0.756887f, 0.650243f, 0.756998f, 0.329146f, 
		0.757064f, 0.286720f, 0.757068f, 0.599082f, 
		0.757128f, 0.00804321f, 0.757157f, 0.107612f, 
		0.757158f, 0.107599f, 0.757556f, 0.507601f, 
		0.758217f, 0.505251f, 0.758257f, 0.483968f, 
		0.758371f, 0.494952f, 0.758418f, 0.00539809f, 
		0.758449f, 0.338455f, 0.758682f, 0.112202f, 
		0.758739f, 0.225734f, 0.758739f, 0.284315f, 
		0.758739f, 0.582960f, 0.759059f, 0.596312f, 
		0.759153f, 0.191997f, 0.759167f, 0.480008f, 
		0.759303f, 0.160594f, 0.759313f, 0.160576f, 
		0.759319f, 0.504285f, 0.759319f, 0.160564f, 
		0.759321f, 0.504283f, 0.759504f, 0.424106f, 
		0.759574f, 0.105560f, 0.759715f, 0.229284f, 
		0.759766f, 0.563622f, 0.759909f, 0.209433f, 
		0.760281f, 0.194519f, 0.760287f, 0.194533f, 
		0.760440f, 0.788929f, 0.760502f, 0.210759f, 
		0.760621f, 0.454558f, 0.760736f, 0.228767f, 
		0.760817f, 0.543822f, 0.760887f, 0.232332f, 
		0.760947f, 0.601367f, 0.761139f, 0.00120375f, 
		0.761648f, 0.338749f, 0.761755f, 0.218115f, 
		0.761895f, 0.00231120f, 0.761978f, 0.314064f, 
		0.761978f, 0.344792f, 0.762127f, 0.582960f, 
		0.762382f, 0.617565f, 0.762724f, 0.422749f, 
		0.762736f, 0.422732f, 0.763236f, 0.422049f, 
		0.763351f, 0.566367f, 0.763390f, 0.0211331f, 
		0.763795f, 0.0105666f, 0.763898f, 0.161205f, 
		0.764079f, 0.334892f, 0.764887f, 0.357171f, 
		0.765216f, 0.582960f, 0.765216f, 0.612201f, 
		0.765279f, 0.487884f, 0.765408f, 0.565586f, 
		0.766612f, 0.326559f, 0.767717f, 0.525477f, 
		0.767990f, 0.566437f, 0.768982f, 0.00894979f, 
		0.769175f, 0.192303f, 0.769177f, 0.192284f, 
		0.769271f, 0.654136f, 0.769698f, 0.491867f, 
		0.769810f, 0.0745782f, 0.770880f, 0.228288f, 
		0.770953f, 0.227964f, 0.770989f, 0.228620f, 
		0.771000f, 0.228646f, 0.771134f, 0.284611f, 
		0.771710f, 0.126988f, 0.771735f, 0.177072f, 
		0.772312f, 0.463163f, 0.772682f, 0.469070f, 
		0.772836f, 0.389823f, 0.772851f, 0.470224f, 
		0.773885f, 0.00203465f, 0.773885f, 0.00208905f, 
		0.773885f, 0.0513371f, 0.773885f, 0.107158f, 
		0.773885f, 0.124602f, 0.773885f, 0.163930f, 
		0.773885f, 0.181232f, 0.773885f, 0.239973f, 
		0.773885f, 0.240088f, 0.773885f, 0.304888f, 
		0.774089f, 0.305221f, 0.774336f, 0.667110f, 
		0.774857f, 0.107290f, 0.774897f, 0.0559080f, 
		0.775789f, 0.0380761f, 0.777236f, 0.536683f, 
		0.777909f, 0.198757f, 0.777919f, 0.553918f, 
		0.780459f, 0.0553434f, 0.780468f, 0.0484531f, 
		0.780514f, 0.0541611f, 0.782185f, 0.0518083f, 
		0.782814f, 0.810726f, 0.782897f, 0.399966f, 
		0.784048f, 0.398771f, 0.784048f, 0.289233f, 
		0.784053f, 0.398758f, 0.784323f, 0.408363f, 
		0.784707f, 0.316647f, 0.785672f, 0.811898f, 
		0.785674f, 0.0510966f, 0.785926f, 0.129732f, 
		0.786257f, 0.635400f, 0.786880f, 0.812305f, 
		0.788179f, 0.0370711f, 0.789278f, 0.368175f, 
		0.789978f, 0.397512f, 0.790007f, 0.680717f, 
		0.790344f, 0.408429f, 0.790344f, 0.408449f, 
		0.790345f, 0.408432f, 0.790445f, 0.401705f, 
		0.790915f, 0.134063f, 0.791198f, 0.476168f, 
		0.791257f, 0.384470f, 0.792366f, 0.850577f, 
		0.792586f, 0.850491f, 0.792611f, 0.850411f, 
		0.792913f, 0.397212f, 0.792914f, 0.397223f, 
		0.792922f, 0.397333f, 0.793963f, 0.509438f, 
		0.794079f, 0.135429f, 0.794255f, 0.395121f, 
		0.794538f, 0.170160f, 0.794556f, 0.0802200f, 
		0.794773f, 0.310294f, 0.795037f, 0.780409f, 
		0.795846f, 0.214728f, 0.795868f, 0.603715f, 
		0.795973f, 0.0499185f, 0.796374f, 0.355870f, 
		0.796458f, 0.411130f, 0.796698f, 0.368020f, 
		0.796717f, 0.368156f, 0.797785f, 0.292550f, 
		0.797805f, 0.641766f, 0.797947f, 0.227114f, 
		0.797967f, 0.227123f, 0.798002f, 0.0454612f, 
		0.798111f, 0.368173f, 0.798262f, 0.204694f, 
		0.799036f, 0.706273f, 0.799053f, 0.706133f, 
		0.799063f, 0.706202f, 0.799078f, 0.706168f, 
		0.799238f, 0.368318f, 0.799343f, 0.125261f, 
		0.799592f, 0.0404090f, 0.799894f, 0.0446454f, 
		0.800025f, 0.000000f, 0.800025f, 0.998535f, 
		0.800311f, 0.929684f, 0.800839f, 0.484518f, 
		0.801649f, 0.665696f, 0.801656f, 0.665707f, 
		0.801837f, 0.666001f, 0.801843f, 0.666019f, 
		0.802653f, 0.487098f, 0.803626f, 0.363324f, 
		0.804589f, 0.483152f, 0.804623f, 0.000000f, 
		0.804623f, 0.00433422f, 0.804623f, 0.0784506f, 
		0.804623f, 0.0956345f, 0.804623f, 0.0993513f, 
		0.804623f, 0.128708f, 0.804825f, 0.645435f, 
		0.805251f, 0.102465f, 0.805439f, 0.0981654f, 
		0.805528f, 0.840044f, 0.805883f, 0.00411773f, 
		0.805883f, 0.997113f, 0.806424f, 0.000000f, 
		0.806597f, 0.321365f, 0.806759f, 0.318365f, 
		0.808064f, 0.149359f, 0.808172f, 0.207248f, 
		0.808270f, 0.607141f, 0.808450f, 0.557991f, 
		0.808490f, 0.0859285f, 0.808952f, 0.00423980f, 
		0.808952f, 0.00443052f, 0.808952f, 0.0696043f, 
		0.808952f, 0.286142f, 0.808952f, 0.414690f, 
		0.808952f, 0.452363f, 0.808952f, 0.550939f, 
		0.808952f, 0.584516f, 0.808952f, 0.611550f, 
		0.808952f, 0.630358f, 0.808952f, 0.776942f, 
		0.808952f, 0.776982f, 0.808952f, 0.923907f, 
		0.808952f, 0.923920f, 0.808952f, 0.997002f, 
		0.811775f, 0.267150f, 0.812435f, 0.0298603f, 
		0.812443f, 0.0980720f, 0.813668f, 0.231149f, 
		0.814156f, 0.236500f, 0.814275f, 0.199716f, 
		0.814806f, 0.687443f, 0.814825f, 0.107014f, 
		0.814974f, 0.292667f, 0.815013f, 0.191192f, 
		0.815129f, 0.0894433f, 0.815996f, 0.0614113f, 
		0.816071f, 0.00259203f, 0.816362f, 0.0363119f, 
		0.816534f, 0.162568f, 0.816680f, 0.00280028f, 
		0.816930f, 0.147867f, 0.817015f, 0.266243f, 
		0.817068f, 0.304269f, 0.819410f, 0.199776f, 
		0.820578f, 0.424660f, 0.820595f, 0.424671f, 
		0.820632f, 0.424694f, 0.821244f, 0.0689004f, 
		0.821244f, 0.507513f, 0.821244f, 0.519957f, 
		0.821244f, 0.932269f, 0.821244f, 0.932388f, 
		0.821244f, 0.934959f, 0.821244f, 0.956145f, 
		0.821374f, 0.00440500f, 0.821374f, 0.0220240f, 
		0.821374f, 0.0601840f, 0.821374f, 0.0927481f, 
		0.821374f, 0.154167f, 0.821374f, 0.246390f, 
		0.821374f, 0.282082f, 0.821374f, 0.292916f, 
		0.822839f, 0.0885480f, 0.822865f, 0.541867f, 
		0.822951f, 0.362136f, 0.823134f, 0.465127f, 
		0.823577f, 0.590933f, 0.823743f, 0.112991f, 
		0.823999f, 0.0932568f, 0.824244f, 0.912477f, 
		0.824268f, 0.0956870f, 0.824329f, 0.423757f, 
		0.824624f, 0.122839f, 0.824746f, 0.0816282f, 
		0.824929f, 0.225683f, 0.825020f, 0.770467f, 
		0.825204f, 0.286960f, 0.825243f, 0.0957984f, 
		0.825637f, 0.121038f, 0.825653f, 0.619303f, 
		0.825931f, 0.152053f, 0.825975f, 0.620433f, 
		0.826190f, 0.439603f, 0.826457f, 0.429015f, 
		0.826565f, 0.109356f, 0.826843f, 0.0987957f, 
		0.827172f, 0.328346f, 0.827249f, 0.812353f, 
		0.827285f, 0.723281f, 0.827306f, 0.832900f, 
		0.827543f, 0.830872f, 0.827601f, 0.239495f, 
		0.827877f, 0.318305f, 0.827920f, 0.853585f, 
		0.828111f, 0.324675f, 0.828151f, 0.0959512f, 
		0.828344f, 0.171401f, 0.828534f, 0.186605f, 
		0.828538f, 0.694524f, 0.829194f, 0.277288f, 
		0.829388f, 0.197908f, 0.829424f, 0.695658f, 
		0.829546f, 0.106132f, 0.830030f, 0.120936f, 
		0.830166f, 0.000810096f, 0.830166f, 0.593643f, 
		0.830431f, 0.0141780f, 0.830946f, 0.550808f, 
		0.831170f, 0.482852f, 0.831347f, 0.610458f, 
		0.831406f, 0.0897650f, 0.831753f, 0.425557f, 
		0.831986f, 0.408815f, 0.832194f, 0.197566f, 
		0.832371f, 0.603715f, 0.832516f, 0.155108f, 
		0.832520f, 0.0609090f, 0.832860f, 0.0887743f, 
		0.833342f, 0.398540f, 0.833416f, 0.343356f, 
		0.833706f, 0.0893022f, 0.833762f, 0.214104f, 
		0.833780f, 0.0854010f, 0.833780f, 0.367352f, 
		0.833780f, 0.621246f, 0.834144f, 0.195808f, 
		0.834350f, 0.0980895f, 0.834350f, 0.499620f, 
		0.834521f, 0.120715f, 0.834545f, 0.117123f, 
		0.835245f, 0.0187225f, 0.835245f, 0.0873720f, 
		0.835245f, 0.104902f, 0.835245f, 0.104929f, 
		0.835245f, 0.105324f, 0.835245f, 0.124817f, 
		0.835245f, 0.139824f, 0.835245f, 0.139849f, 
		0.835245f, 0.139859f, 0.835245f, 0.139881f, 
		0.835245f, 0.186883f, 0.835245f, 0.186895f, 
		0.835245f, 0.186908f, 0.835245f, 0.186939f, 
		0.835245f, 0.230911f, 0.835245f, 0.249634f, 
		0.835245f, 0.312156f, 0.835245f, 0.312180f, 
		0.835245f, 0.312191f, 0.835245f, 0.312209f, 
		0.835245f, 0.339056f, 0.835245f, 0.339689f, 
		0.835245f, 0.339970f, 0.835245f, 0.341681f, 
		0.835245f, 0.374451f, 0.835245f, 0.389361f, 
		0.835245f, 0.389717f, 0.835245f, 0.389754f, 
		0.835245f, 0.389779f, 0.835245f, 0.411896f, 
		0.835245f, 0.461823f, 0.835245f, 0.496997f, 
		0.835245f, 0.497062f, 0.835245f, 0.517990f, 
		0.835245f, 0.586640f, 0.835245f, 0.604159f, 
		0.835245f, 0.604201f, 0.835245f, 0.624084f, 
		0.835245f, 0.639095f, 0.835245f, 0.639107f, 
		0.835245f, 0.639131f, 0.835245f, 0.639144f, 
		0.835245f, 0.639160f, 0.835245f, 0.669352f, 
		0.835245f, 0.672991f, 0.835245f, 0.673108f, 
		0.835245f, 0.686157f, 0.835245f, 0.686211f, 
		0.835245f, 0.730179f, 0.835245f, 0.781670f, 
		0.835245f, 0.784947f, 0.835245f, 0.811406f, 
		0.835245f, 0.811423f, 0.835245f, 0.811436f, 
		0.835245f, 0.811465f, 0.835245f, 0.811478f, 
		0.835245f, 0.873718f, 0.835245f, 0.889915f, 
		0.835245f, 0.939635f, 0.835245f, 0.939668f, 
		0.835245f, 0.961090f, 0.835245f, 0.985119f, 
		0.835245f, 0.985168f, 0.835245f, 0.985205f, 
		0.835245f, 0.998535f, 0.835815f, 0.0362185f, 
		0.836011f, 0.109493f, 0.836150f, 0.109600f, 
		0.838198f, 0.941633f, 0.838199f, 0.941644f, 
		0.838385f, 0.137274f, 0.838979f, 0.119906f, 
		0.839118f, 0.610073f, 0.839500f, 0.812418f, 
		0.839998f, 0.339823f, 0.840019f, 0.625724f, 
		0.840089f, 0.626301f, 0.840098f, 0.626321f, 
		0.840211f, 0.0607550f, 0.840772f, 0.812730f, 
		0.840776f, 0.512041f, 0.840839f, 0.384116f, 
		0.840841f, 0.626134f, 0.840858f, 0.620355f, 
		0.840931f, 0.430185f, 0.841110f, 0.610088f, 
		0.841316f, 0.939237f, 0.841382f, 0.192044f, 
		0.841475f, 0.170658f, 0.841482f, 0.0167943f, 
		0.841547f, 0.383144f, 0.841577f, 0.0167648f, 
		0.841577f, 0.998535f, 0.841578f, 0.0167646f, 
		0.841578f, 0.998535f, 0.841578f, 0.0167645f, 
		0.841578f, 0.998535f, 0.841581f, 0.0167637f, 
		0.841581f, 0.998535f, 0.841581f, 0.0167636f, 
		0.841581f, 0.998535f, 0.841807f, 0.992225f, 
		0.841830f, 0.120437f, 0.841857f, 0.647750f, 
		0.841896f, 0.992067f, 0.841919f, 0.121276f, 
		0.841924f, 0.0885620f, 0.842002f, 0.795355f, 
		0.842007f, 0.795378f, 0.842129f, 0.966368f, 
		0.842192f, 0.315250f, 0.842193f, 0.0165745f, 
		0.842193f, 0.998535f, 0.842212f, 0.382247f, 
		0.842303f, 0.00218813f, 0.842303f, 0.00220388f, 
		0.842323f, 0.433763f, 0.842422f, 0.00690955f, 
		0.842459f, 0.157408f, 0.842802f, 0.818640f, 
		0.842974f, 0.319551f, 0.842984f, 0.549480f, 
		0.843257f, 0.00708872f, 0.843277f, 1.88738e-015f, 
		0.843277f, 0.998535f, 0.843721f, 0.605662f, 
		0.843950f, 0.317664f, 0.844061f, 0.316912f, 
		0.844108f, 0.317991f, 0.844147f, 0.888986f, 
		0.844495f, 0.190623f, 0.844881f, 0.660659f, 
		0.844946f, 0.00912491f, 0.845105f, 0.664071f, 
		0.845110f, 0.189491f, 0.845129f, 0.166341f, 
		0.845130f, 0.190261f, 0.845131f, 0.664206f, 
		0.845133f, 0.166338f, 0.845145f, 0.166340f, 
		0.845189f, 0.888918f, 0.845332f, 0.835809f, 
		0.845352f, 0.983613f, 0.845353f, 0.163709f, 
		0.845427f, 0.0124068f, 0.845507f, 0.662711f, 
		0.845722f, 0.468238f, 0.845938f, 0.0307309f, 
		0.846119f, 0.175276f, 0.846208f, 0.148747f, 
		0.846228f, 0.000000f, 0.846304f, 0.286165f, 
		0.846427f, 0.286500f, 0.846492f, 0.0858355f, 
		0.846507f, 0.838685f, 0.846678f, 0.347928f, 
		0.846731f, 0.839220f, 0.846753f, 0.839220f, 
		0.846820f, 0.449141f, 0.846884f, 0.285136f, 
		0.846905f, 0.997341f, 0.846928f, 0.997889f, 
		0.847163f, 0.840228f, 0.847175f, 0.448752f, 
		0.847185f, 0.448741f, 0.847186f, 0.252326f, 
		0.847193f, 0.0300589f, 0.847209f, 0.840334f, 
		0.847216f, 0.145031f, 0.847559f, 0.452204f, 
		0.847677f, 0.998535f, 0.847751f, 0.000000f, 
		0.847788f, 0.000000f, 0.848259f, 0.00371403f, 
		0.848259f, 0.0847466f, 0.848262f, 0.998214f, 
		0.848266f, 0.483613f, 0.848291f, 0.484505f, 
		0.848304f, 0.485086f, 0.848377f, 0.487226f, 
		0.848737f, 0.784506f, 0.848744f, 0.486786f, 
		0.848744f, 0.486776f, 0.848985f, 0.507050f, 
		0.848991f, 0.507039f, 0.849210f, 0.501111f, 
		0.849287f, 0.783123f, 0.849389f, 0.782277f, 
		0.849406f, 0.141800f, 0.849450f, 0.280234f, 
		0.849484f, 0.00603201f, 0.849537f, 0.138939f, 
		0.849545f, 0.138925f, 0.849678f, 0.693716f, 
		0.849748f, 0.506449f, 0.849752f, 0.506433f, 
		0.849854f, 0.693827f, 0.849910f, 0.186728f, 
		0.850029f, 0.193458f, 0.850038f, 0.204989f, 
		0.850040f, 0.193460f, 0.850042f, 0.204987f, 
		0.850057f, 0.205001f, 0.850065f, 0.204989f, 
		0.850360f, 0.193162f, 0.850399f, 0.703956f, 
		0.850413f, 0.703958f, 0.850608f, 0.103777f, 
		0.850615f, 0.157377f, 0.850637f, 0.174654f, 
		0.850719f, 0.703381f, 0.850873f, 0.0183512f, 
		0.850996f, 0.203378f, 0.851062f, 0.0279533f, 
		0.851114f, 0.193942f, 0.851581f, 0.194144f, 
		0.851863f, 0.121628f, 0.852054f, 0.713302f, 
		0.852140f, 0.913808f, 0.852335f, 0.0108913f, 
		0.852566f, 0.00239281f, 0.852614f, 4.06453e-005f, 
		0.852666f, 4.42445e-005f, 0.852699f, 0.0107240f, 
		0.852869f, 0.149994f, 0.852923f, 0.0538275f, 
		0.853023f, 0.913965f, 0.853145f, 0.159441f, 
		0.853442f, 0.602820f, 0.853590f, 0.0534853f, 
		0.853749f, 0.0387523f, 0.854090f, 0.0810087f, 
		0.854102f, 0.118767f, 0.854208f, 0.620357f, 
		0.854564f, 0.126147f, 0.855034f, 0.918343f, 
		0.855053f, 0.109330f, 0.855436f, 0.972369f, 
		0.855608f, 0.158563f, 0.855646f, 0.126381f, 
		0.855791f, 0.106217f, 0.855855f, 0.917000f, 
		0.856001f, 0.121906f, 0.856003f, 0.501471f, 
		0.856004f, 0.501461f, 0.856005f, 0.501451f, 
		0.856580f, 0.973141f, 0.856900f, 0.0982175f, 
		0.856943f, 0.0516367f, 0.856956f, 0.0516548f, 
		0.856987f, 0.192813f, 0.857001f, 0.192826f, 
		0.857013f, 0.192833f, 0.857024f, 0.192811f, 
		0.857029f, 0.192832f, 0.857258f, 0.0782784f, 
		0.857437f, 0.691747f, 0.857450f, 0.691758f, 
		0.857460f, 0.691761f, 0.857477f, 0.691730f, 
		0.857860f, 0.719450f, 0.857899f, 0.0653078f, 
		0.858457f, 0.0732872f, 0.858646f, 0.543388f, 
		0.858694f, 0.00239094f, 0.858802f, 0.103735f, 
		0.858812f, 0.792405f, 0.858842f, 0.00239089f, 
		0.858972f, 0.000430870f, 0.858975f, 0.998127f, 
		0.859332f, 0.531282f, 0.859792f, 0.916662f, 
		0.860481f, 0.136522f, 0.861041f, 0.113048f, 
		0.862165f, 0.866887f, 0.862818f, 0.658514f, 
		0.863200f, 0.0740070f, 0.863885f, 0.0228428f, 
		0.864600f, 0.127854f, 0.864742f, 0.0742411f, 
		0.865349f, 0.541898f, 0.865886f, 0.0349285f, 
		0.866384f, 0.0255572f, 0.866854f, 0.0349100f, 
		0.867079f, 0.0308766f, 0.867160f, 0.000000f, 
		0.867161f, 0.201033f, 0.867174f, 0.201056f, 
		0.867587f, 0.0228442f, 0.867994f, 0.0235435f, 
		0.868063f, 0.0234458f, 0.868091f, 0.347336f, 
		0.868256f, 0.0307377f, 0.868380f, 0.877592f, 
		0.868699f, 0.0228449f, 0.869117f, 0.993270f, 
		0.869172f, 0.0255670f, 0.869392f, 0.0272306f, 
		0.870353f, 0.271221f, 0.870629f, 0.0343250f, 
		0.870629f, 0.124048f, 0.870629f, 0.283958f, 
		0.870629f, 0.373682f, 0.870629f, 0.533592f, 
		0.870629f, 0.623316f, 0.870629f, 0.783226f, 
		0.870629f, 0.932189f, 0.870786f, 0.272330f, 
		0.870788f, 0.272318f, 0.870790f, 0.272329f, 
		0.870975f, 0.0347661f, 0.871531f, 0.0347934f, 
		0.872873f, 0.814433f, 0.873233f, 0.0305055f, 
		0.873281f, 0.0606875f, 0.873327f, 0.560063f, 
		0.873426f, 0.814151f, 0.873667f, 0.0291565f, 
		0.873667f, 0.0306531f, 0.873667f, 0.0325490f, 
		0.873906f, 0.668596f, 0.874125f, 0.388721f, 
		0.874231f, 0.0610378f, 0.874413f, 0.366318f, 
		0.874689f, 0.366248f, 0.874830f, 0.365616f, 
		0.875000f, 0.000000f, 0.875000f, 0.000000f, 
		0.875000f, 0.125000f, 0.875000f, 0.125000f, 
		0.875306f, 0.0284635f, 0.875585f, 0.0287925f, 
		0.875772f, 0.148544f, 0.876331f, 0.591087f, 
		0.876408f, 0.697884f, 0.876429f, 0.697894f, 
		0.877262f, 0.698106f, 0.877267f, 0.785772f, 
		0.877292f, 0.698130f, 0.877567f, 0.598113f, 
		0.877831f, 0.672356f, 0.878183f, 0.600205f, 
		0.878289f, 0.457933f, 0.878936f, 0.0228498f, 
		0.879108f, 0.0236132f, 0.879164f, 0.767596f, 
		0.879317f, 0.768187f, 0.879327f, 0.768215f, 
		0.879507f, 0.968822f, 0.879781f, 0.0265987f, 
		0.879889f, 0.0349902f, 0.880139f, 0.243336f, 
		0.880249f, 0.241550f, 0.880529f, 0.0274670f, 
		0.880529f, 0.0752910f, 0.880529f, 0.122818f, 
		0.880529f, 0.172814f, 0.880529f, 0.299027f, 
		0.880529f, 0.372575f, 0.880529f, 0.426990f, 
		0.880529f, 0.474813f, 0.880529f, 0.522340f, 
		0.880529f, 0.599284f, 0.880529f, 0.650569f, 
		0.880529f, 0.698549f, 0.880529f, 0.745954f, 
		0.881095f, 0.0229321f, 0.881131f, 0.0348768f, 
		0.881232f, 0.0488302f, 0.881851f, 0.0726175f, 
		0.881994f, 0.000000f, 0.881994f, 0.00674294f, 
		0.881994f, 0.0431917f, 0.881994f, 0.0744905f, 
		0.881994f, 0.425510f, 0.881994f, 0.426778f, 
		0.881994f, 0.508538f, 0.881994f, 0.509593f, 
		0.881994f, 0.515868f, 0.881994f, 0.815723f, 
		0.881994f, 0.815764f, 0.881994f, 0.889752f, 
		0.882272f, 0.133909f, 0.882351f, 0.0918246f, 
		0.882476f, 0.579588f, 0.882549f, 0.579767f, 
		0.882678f, 0.327915f, 0.882762f, 0.000000f, 
		0.882858f, 0.154944f, 0.882874f, 0.103887f, 
		0.882885f, 0.918175f, 0.882888f, 0.918145f, 
		0.883134f, 0.724280f, 0.883234f, 0.0148708f, 
		0.883339f, 0.575032f, 0.883913f, 0.104650f, 
		0.883959f, 0.864724f, 0.883973f, 0.744299f, 
		0.884025f, 0.0888965f, 0.884115f, 0.138686f, 
		0.884259f, 0.291075f, 0.884353f, 0.170851f, 
		0.884400f, 0.424684f, 0.884447f, 0.0338315f, 
		0.884667f, 0.00623629f, 0.884678f, 0.00649436f, 
		0.884693f, 0.142914f, 0.884697f, 0.425738f, 
		0.884723f, 0.0963217f, 0.884764f, 0.840845f, 
		0.885011f, 0.0332592f, 0.885229f, 0.0679730f, 
		0.885296f, 0.106552f, 0.885319f, 0.541163f, 
		0.885347f, 0.178569f, 0.885352f, 0.178353f, 
		0.885360f, 0.564302f, 0.885436f, 0.541468f, 
		0.885507f, 0.0636497f, 0.885598f, 0.0873270f, 
		0.885766f, 0.115069f, 0.885784f, 0.195809f, 
		0.885795f, 0.354870f, 0.885904f, 0.00677142f, 
		0.885928f, 0.151965f, 0.886029f, 0.0322509f, 
		0.886030f, 0.590484f, 0.886030f, 0.0322668f, 
		0.886092f, 0.751459f, 0.886134f, 0.121740f, 
		0.886203f, 0.844583f, 0.886204f, 0.0528551f, 
		0.886205f, 0.844607f, 0.886205f, 0.0528668f, 
		0.886207f, 0.736667f, 0.886208f, 0.00367525f, 
		0.886212f, 0.545673f, 0.886282f, 0.735341f, 
		0.886379f, 0.422808f, 0.886382f, 0.422795f, 
		0.886388f, 0.422807f, 0.886452f, 0.754777f, 
		0.886456f, 0.0850090f, 0.886567f, 0.584494f, 
		0.886923f, 0.155760f, 0.886984f, 0.514825f, 
		0.887013f, 0.0643354f, 0.887026f, 0.156414f, 
		0.887063f, 0.656068f, 0.887084f, 0.655947f, 
		0.887185f, 0.0427057f, 0.887207f, 0.887964f, 
		0.887211f, 0.655954f, 0.887432f, 0.0360630f, 
		0.887470f, 0.348032f, 0.887488f, 0.333032f, 
		0.887582f, 0.0864156f, 0.888188f, 0.419669f, 
		0.888201f, 0.419669f, 0.888393f, 0.388693f, 
		0.888519f, 0.232862f, 0.888803f, 0.998535f, 
		0.888914f, 0.231842f, 0.888942f, 0.334671f, 
		0.889091f, 0.918853f, 0.889138f, 0.588929f, 
		0.889523f, 0.866517f, 0.889541f, 0.490519f, 
		0.889544f, 0.490497f, 0.890264f, 0.0964335f, 
		0.890535f, 0.104820f, 0.890570f, 0.659474f, 
		0.890603f, 0.271856f, 0.890660f, 0.0959353f, 
		0.890680f, 0.0735184f, 0.890698f, 0.337404f, 
		0.890698f, 0.697873f, 0.890733f, 0.101582f, 
		0.890793f, 0.210718f, 0.890883f, 0.671323f, 
		0.891045f, 0.0280093f, 0.891138f, 0.0478880f, 
		0.891167f, 0.302443f, 0.891180f, 0.210674f, 
		0.891194f, 0.298978f, 0.891269f, 0.000000f, 
		0.891292f, 0.0654103f, 0.891326f, 0.000000f, 
		0.891485f, 0.673298f, 0.891615f, 0.602107f, 
		0.891670f, 0.637106f, 0.891737f, 0.546369f, 
		0.891779f, 0.106415f, 0.891794f, 0.252545f, 
		0.892023f, 0.440843f, 0.892027f, 0.440767f, 
		0.892092f, 0.712474f, 0.892103f, 0.712491f, 
		0.892140f, 0.0159684f, 0.892177f, 0.566050f, 
		0.892215f, 0.598517f, 0.892241f, 0.637060f, 
		0.892282f, 0.000000f, 0.892391f, 0.221919f, 
		0.892442f, 0.652441f, 0.892563f, 0.106358f, 
		0.892573f, 0.0626289f, 0.892616f, 0.105647f, 
		0.892653f, 0.0501381f, 0.892754f, 0.562337f, 
		0.892775f, 0.652393f, 0.892928f, 0.669618f, 
		0.892982f, 0.0843793f, 0.892997f, 0.131820f, 
		0.893268f, 0.788348f, 0.893327f, 0.378409f, 
		0.893523f, 0.0494750f, 0.893523f, 0.0559295f, 
		0.893523f, 0.0559624f, 0.893523f, 0.288472f, 
		0.893544f, 0.359875f, 0.893552f, 0.788186f, 
		0.893581f, 0.710854f, 0.893588f, 0.710887f, 
		0.893780f, 0.0749639f, 0.893813f, 0.000000f, 
		0.893813f, 0.0688097f, 0.893859f, 0.675736f, 
		0.894010f, 0.368324f, 0.894131f, 0.437506f, 
		0.894283f, 0.166166f, 0.894409f, 0.974350f, 
		0.894466f, 0.385483f, 0.894661f, 0.346539f, 
		0.894861f, 0.423407f, 0.894864f, 0.516649f, 
		0.894865f, 0.516635f, 0.895271f, 0.236630f, 
		0.895285f, 0.0527839f, 0.895361f, 0.153246f, 
		0.895418f, 0.525274f, 0.895529f, 0.311193f, 
		0.895529f, 0.719623f, 0.895543f, 0.000000f, 
		0.895585f, 0.252844f, 0.895795f, 0.0688717f, 
		0.895932f, 0.161171f, 0.896019f, 0.296369f, 
		0.896129f, 0.0230689f, 0.896271f, 0.0531731f, 
		0.896345f, 0.0950401f, 0.896528f, 0.0609157f, 
		0.896956f, 0.278886f, 0.897206f, 0.438076f, 
		0.897251f, 0.768090f, 0.897312f, 0.164080f, 
		0.897323f, 0.00220508f, 0.897599f, 0.388656f, 
		0.897870f, 0.359424f, 0.897958f, 0.768183f, 
		0.898090f, 0.251021f, 0.898193f, 0.0477621f, 
		0.898211f, 0.665259f, 0.898626f, 0.150230f, 
		0.898973f, 0.767412f, 0.899070f, 0.00201110f, 
		0.899110f, 0.660779f, 0.899230f, 0.0498254f, 
		0.899757f, 0.608838f, 0.900252f, 0.799655f, 
		0.900295f, 0.542359f, 0.900299f, 0.542348f, 
		0.900509f, 0.801224f, 0.900734f, 0.447211f, 
		0.900761f, 0.431029f, 0.900768f, 0.431019f, 
		0.900796f, 0.159270f, 0.901016f, 0.800980f, 
		0.901234f, 0.336508f, 0.901331f, 0.255230f, 
		0.901765f, 0.253645f, 0.902009f, 0.481428f, 
		0.902017f, 0.360150f, 0.902137f, 0.480514f, 
		0.902263f, 0.978105f, 0.902462f, 0.000959577f, 
		0.902474f, 0.769648f, 0.902548f, 0.724708f, 
		0.902679f, 0.139547f, 0.903558f, 0.966285f, 
		0.903566f, 0.768579f, 0.903568f, 0.00146740f, 
		0.903790f, 0.972991f, 0.903955f, 0.261155f, 
		0.903955f, 0.354439f, 0.903955f, 0.687349f, 
		0.903955f, 0.687402f, 0.903955f, 0.703391f, 
		0.904208f, 0.973421f, 0.904445f, 0.473938f, 
		0.904448f, 0.473957f, 0.904844f, 0.473951f, 
		0.904939f, 0.795930f, 0.904947f, 0.147368f, 
		0.904958f, 0.00554895f, 0.904959f, 0.998535f, 
		0.904960f, 0.00553824f, 0.904967f, 0.00554850f, 
		0.904967f, 0.998535f, 0.905086f, 0.127665f, 
		0.905127f, 0.488240f, 0.905214f, 0.127457f, 
		0.905225f, 0.215891f, 0.905544f, 0.0307122f, 
		0.905967f, 0.664136f, 0.906138f, 0.543154f, 
		0.906157f, 0.543154f, 0.906250f, 0.0937500f, 
		0.906989f, 0.425539f, 0.907157f, 0.482888f, 
		0.907488f, 0.0194477f, 0.907544f, 0.0194234f, 
		0.907685f, 0.370966f, 0.907827f, 0.637956f, 
		0.908340f, 0.118607f, 0.908406f, 0.000000f, 
		0.908524f, 0.174131f, 0.909045f, 0.297649f, 
		0.909171f, 0.198727f, 0.909171f, 0.139868f, 
		0.909321f, 0.0452868f, 0.909371f, 0.139688f, 
		0.909679f, 0.479209f, 0.909986f, 0.671411f, 
		0.910172f, 0.247214f, 0.910583f, 0.993075f, 
		0.910865f, 0.218133f, 0.910920f, 0.00538427f, 
		0.910920f, 0.992990f, 0.911163f, 0.114183f, 
		0.911414f, 0.641754f, 0.911738f, 0.445434f, 
		0.912272f, 0.928840f, 0.912765f, 0.815769f, 
		0.912910f, 0.693110f, 0.913209f, 0.820043f, 
		0.913690f, 0.184232f, 0.913872f, 0.683971f, 
		0.913872f, 0.236901f, 0.913928f, 0.0704259f, 
		0.913959f, 0.819474f, 0.914111f, 0.516292f, 
		0.914123f, 0.171317f, 0.914146f, 0.302423f, 
		0.914378f, 0.752436f, 0.914401f, 0.328813f, 
		0.914900f, 0.849195f, 0.915219f, 0.300607f, 
		0.915729f, 0.925997f, 0.915736f, 0.925974f, 
		0.915860f, 0.926798f, 0.916124f, 0.524960f, 
		0.916271f, 0.849575f, 0.916432f, 0.146973f, 
		0.916764f, 0.0274921f, 0.917400f, 0.681541f, 
		0.918125f, 0.157726f, 0.918292f, 0.832619f, 
		0.918573f, 0.355045f, 0.919210f, 0.188035f, 
		0.919375f, 0.000000f, 0.919375f, 0.547582f, 
		0.919375f, 0.998535f, 0.920707f, 0.111447f, 
		0.922896f, 0.542774f, 0.924573f, 0.0446442f, 
		0.924802f, 0.551774f, 0.925244f, 0.217389f, 
		0.927162f, 0.124927f, 0.927976f, 0.000000f, 
		0.928187f, 0.953436f, 0.928321f, 0.631381f, 
		0.928361f, 0.359227f, 0.928761f, 0.154910f, 
		0.928899f, 0.358972f, 0.928975f, 0.358626f, 
		0.929366f, 0.0352497f, 0.929437f, 0.000000f, 
		0.929437f, 0.989187f, 0.929855f, 0.318397f, 
		0.929959f, 0.886826f, 0.930162f, 0.886492f, 
		0.930179f, 0.995443f, 0.930408f, 0.344779f, 
		0.930719f, 0.886546f, 0.930976f, 0.367734f, 
		0.930989f, 0.367730f, 0.931004f, 0.831069f, 
		0.931455f, 0.166663f, 0.931469f, 0.166675f, 
		0.932216f, 0.300117f, 0.932263f, 0.873881f, 
		0.934605f, 0.492741f, 0.935041f, 0.492830f, 
		0.936014f, 0.493355f, 0.936685f, 0.578621f, 
		0.937466f, 0.493102f, 0.937542f, 0.579754f, 
		0.937830f, 0.577741f, 0.940226f, 0.306945f, 
		0.941447f, 0.576456f, 0.942120f, 0.741217f, 
		0.942130f, 0.741230f, 0.943239f, 0.0717899f, 
		0.944119f, 0.301758f, 0.944407f, 0.534095f, 
		0.944743f, 0.534429f, 0.945244f, 0.496382f, 
		0.945969f, 0.0863438f, 0.945971f, 0.532215f, 
		0.945972f, 0.0863402f, 0.945980f, 0.357909f, 
		0.946155f, 0.235019f, 0.946192f, 0.432970f, 
		0.946374f, 0.430071f, 0.946767f, 0.530391f, 
		0.947479f, 0.656394f, 0.948080f, 0.240731f, 
		0.948111f, 0.0264817f, 0.948314f, 0.0182855f, 
		0.948559f, 0.0186801f, 0.949300f, 0.584802f, 
		0.949331f, 0.584616f, 0.949701f, 0.264073f, 
		0.949717f, 0.892361f, 0.949902f, 0.113761f, 
		0.950018f, 0.118506f, 0.950598f, 0.0513938f, 
		0.950686f, 0.0463958f, 0.950865f, 0.129411f, 
		0.951121f, 0.0575934f, 0.951459f, 0.367876f, 
		0.951484f, 0.000000f, 0.951484f, 0.0618990f, 
		0.951484f, 0.0618990f, 0.951484f, 0.0772618f, 
		0.951484f, 0.0986502f, 0.951484f, 0.0986647f, 
		0.951484f, 0.103165f, 0.951484f, 0.135791f, 
		0.951484f, 0.154747f, 0.951553f, 0.224808f, 
		0.951613f, 0.735093f, 0.951997f, 0.357718f, 
		0.952270f, 0.00516743f, 0.952417f, 0.665336f, 
		0.952854f, 0.262664f, 0.952949f, 0.00571900f, 
		0.952949f, 0.0285960f, 0.952949f, 0.120426f, 
		0.952949f, 0.132986f, 0.952949f, 0.231626f, 
		0.952949f, 0.348870f, 0.952949f, 0.366258f, 
		0.952949f, 0.380325f, 0.952949f, 0.380360f, 
		0.952949f, 0.395064f, 0.952949f, 0.400342f, 
		0.953212f, 0.492559f, 0.953224f, 0.492577f, 
		0.953248f, 0.213026f, 0.953334f, 0.193589f, 
		0.953421f, 0.0952481f, 0.953519f, 0.247429f, 
		0.953520f, 0.125607f, 0.953543f, 0.139597f, 
		0.953619f, 0.658080f, 0.953650f, 0.689455f, 
		0.953652f, 0.689442f, 0.953868f, 0.257006f, 
		0.954067f, 0.0768298f, 0.954067f, 0.0768410f, 
		0.954331f, 0.970471f, 0.954461f, 0.120540f, 
		0.954532f, 0.298968f, 0.954591f, 0.339341f, 
		0.954808f, 0.304997f, 0.954892f, 0.131495f, 
		0.955240f, 0.0490731f, 0.955457f, 0.318972f, 
		0.955687f, 0.554887f, 0.955693f, 0.554905f, 
		0.956418f, 0.600930f, 0.956704f, 0.460275f, 
		0.956747f, 0.000000f, 0.956747f, 0.998535f, 
		0.957041f, 0.682541f, 0.957406f, 0.804144f, 
		0.957409f, 0.804156f, 0.958225f, 0.806272f, 
		0.958454f, 0.881424f, 0.958557f, 0.696631f, 
		0.958566f, 0.696617f, 0.958762f, 0.141254f, 
		0.958790f, 0.141526f, 0.958791f, 0.141500f, 
		0.958991f, 0.0778757f, 0.959016f, 0.337592f, 
		0.959143f, 0.0774652f, 0.959336f, 0.730494f, 
		0.959359f, 0.287891f, 0.959377f, 0.287899f, 
		0.959427f, 0.940610f, 0.959621f, 0.000000f, 
		0.959663f, 0.983277f, 0.959742f, 0.0854369f, 
		0.959755f, 0.755815f, 0.959771f, 0.0855839f, 
		0.959891f, 0.794877f, 0.959903f, 0.807036f, 
		0.960162f, 0.000000f, 0.960162f, 0.983029f, 
		0.960258f, 0.781364f, 0.960321f, 0.873202f, 
		0.960370f, 0.475440f, 0.960446f, 0.0155666f, 
		0.960446f, 0.980307f, 0.960607f, 0.0108770f, 
		0.960630f, 0.0104651f, 0.960657f, 0.943093f, 
		0.960825f, 0.469079f, 0.961059f, 0.562697f, 
		0.961095f, 0.954969f, 0.961121f, 0.248754f, 
		0.961149f, 0.0438516f, 0.961321f, 0.0409577f, 
		0.961427f, 0.444499f, 0.961479f, 0.443718f, 
		0.961612f, 0.247595f, 0.961623f, 0.247553f, 
		0.961630f, 0.247363f, 0.961633f, 0.436342f, 
		0.961634f, 0.436331f, 0.961646f, 0.205045f, 
		0.961649f, 0.337959f, 0.961661f, 0.436410f, 
		0.962082f, 0.775401f, 0.962311f, 0.902053f, 
		0.962422f, 0.108004f, 0.962583f, 0.783732f, 
		0.962812f, 0.980173f, 0.962814f, 0.0160068f, 
		0.962824f, 0.608501f, 0.963058f, 0.751241f, 
		0.963254f, 0.0669713f, 0.963259f, 0.0667903f, 
		0.963518f, 0.750814f, 0.963619f, 0.750759f, 
		0.963641f, 0.750712f, 0.963658f, 0.191786f, 
		0.963711f, 0.717993f, 0.963760f, 0.278328f, 
		0.963768f, 0.245508f, 0.963825f, 0.843519f, 
		0.963825f, 0.843535f, 0.964024f, 0.434361f, 
		0.964025f, 0.434346f, 0.964059f, 0.428063f, 
		0.964292f, 0.722282f, 0.964304f, 0.0174162f, 
		0.964304f, 0.335894f, 0.964304f, 0.501531f, 
		0.964304f, 0.571073f, 0.964304f, 0.572159f, 
		0.964304f, 0.614837f, 0.964304f, 0.914847f, 
		0.964304f, 0.914877f, 0.964304f, 0.938808f, 
		0.964304f, 0.979300f, 0.964304f, 0.979311f, 
		0.964304f, 0.998535f, 0.965035f, 0.722820f, 
		0.965281f, 0.723493f, 0.965281f, 0.723421f, 
		0.965304f, 0.0811941f, 0.965905f, 0.284132f, 
		0.965909f, 0.0839627f, 0.966128f, 0.152744f, 
		0.966128f, 0.163396f, 0.966128f, 0.165621f, 
		0.966128f, 0.203644f, 0.966128f, 0.396966f, 
		0.966423f, 0.121927f, 0.966499f, 0.0181071f, 
		0.967096f, 0.264490f, 0.967252f, 0.225878f, 
		0.967374f, 0.118614f, 0.967530f, 0.122911f, 
		0.967860f, 0.0746908f, 0.967963f, 0.239936f, 
		0.968413f, 0.0716560f, 0.968504f, 0.326102f, 
		0.968517f, 0.326110f, 0.968533f, 0.240700f, 
		0.968738f, 0.198743f, 0.969203f, 0.317459f, 
		0.969293f, 0.317315f, 0.969293f, 0.122089f, 
		0.969386f, 0.368999f, 0.969537f, 0.0186996f, 
		0.969565f, 0.369440f, 0.969704f, 0.0857919f, 
		0.969758f, 0.240951f, 0.969764f, 0.281237f, 
		0.969777f, 0.0871946f, 0.969779f, 0.240958f, 
		0.969810f, 0.281200f, 0.970631f, 0.206210f, 
		0.970889f, 0.00175538f, 0.970889f, 0.399194f, 
		0.971041f, 0.171610f, 0.971092f, 0.146965f, 
		0.971100f, 0.280989f, 0.971108f, 0.171537f, 
		0.971130f, 0.0307490f, 0.971132f, 0.00158170f, 
		0.971132f, 0.399307f, 0.971157f, 0.280987f, 
		0.971644f, 0.366986f, 0.971994f, 0.367163f, 
		0.972125f, 0.496985f, 0.972162f, 0.0623345f, 
		0.972227f, 0.496968f, 0.972300f, 0.148194f, 
		0.972850f, 0.0624438f, 0.973343f, 0.000000f, 
		0.973343f, 0.0272103f, 0.973343f, 0.0324829f, 
		0.973343f, 0.144346f, 0.973343f, 0.169089f, 
		0.973343f, 0.201121f, 0.973343f, 0.216916f, 
		0.973343f, 0.310578f, 0.973882f, 0.0664280f, 
		0.974010f, 0.113115f, 0.974450f, 0.364568f, 
		0.974574f, 0.120850f, 0.974632f, 0.0353379f, 
		0.974767f, 0.199063f, 0.974965f, 0.335867f, 
		0.974967f, 0.335856f, 0.976182f, 0.0925592f, 
		0.976667f, 0.144974f, 0.980761f, 0.214217f, 
		0.980920f, 0.107242f, 0.980920f, 0.107253f, 
		0.980920f, 0.162037f, 0.980920f, 0.189614f, 
		0.980920f, 0.257527f, 0.980920f, 0.351902f, 
		0.980920f, 0.404072f, 0.980920f, 0.404085f, 
		0.981014f, 0.283958f, 0.981014f, 0.533592f, 
		0.981014f, 0.783226f, 0.982017f, 0.218063f, 
		0.982060f, 0.340853f, 0.982214f, 0.0418087f, 
		0.982381f, 0.219925f, 0.982400f, 0.308774f, 
		0.983679f, 0.186433f, 0.983845f, 0.471664f, 
		0.983855f, 0.201924f, 0.984843f, 0.524267f, 
		0.984865f, 0.585955f, 0.985208f, 0.00639545f, 
		0.985443f, 0.541495f, 0.985464f, 0.281109f, 
		0.985906f, 0.00438660f, 0.986197f, 0.138200f, 
		0.986521f, 0.429123f, 0.986986f, 0.191607f, 
		0.987213f, 0.355827f, 0.987625f, 0.360906f, 
		0.987625f, 0.509356f, 0.987925f, 0.000000f, 
		0.988005f, 0.252327f, 0.988396f, 0.877899f, 
		0.988690f, 0.726618f, 0.988867f, 0.0952236f, 
		0.988884f, 0.334350f, 0.989615f, 0.698176f, 
		0.989768f, 0.546333f, 0.989986f, 0.230329f, 
		0.990031f, 0.373370f, 0.990229f, 0.0821580f, 
		0.990235f, 0.0821739f, 0.990465f, 0.348742f, 
		0.990630f, 0.176686f, 0.990736f, 0.473656f, 
		0.990763f, 0.171733f, 0.990765f, 0.281653f, 
		0.990767f, 0.171735f, 0.991110f, 0.586686f, 
		0.991111f, 0.586669f, 0.991127f, 0.586665f, 
		0.991343f, 0.408547f, 0.991583f, 0.180718f, 
		0.991706f, 0.182346f, 0.992193f, 0.634232f, 
		0.992203f, 0.634234f, 0.992209f, 0.634271f, 
		0.992740f, 0.806614f, 0.992745f, 0.806632f, 
		0.992960f, 0.0856211f, 0.993042f, 0.288423f, 
		0.993043f, 0.288413f, 0.993321f, 0.0103819f, 
		0.993331f, 0.0108939f, 0.993444f, 0.877928f, 
		0.993522f, 0.877492f, 0.993542f, 0.879720f, 
		0.993761f, 0.0661266f, 0.993829f, 0.328572f, 
		0.994627f, 0.211471f, 0.994691f, 0.483525f, 
		0.994785f, 0.807398f, 0.994788f, 0.807430f, 
		0.994950f, 0.0109611f, 0.995153f, 0.286087f, 
		0.995165f, 0.482872f, 0.995371f, 0.440300f, 
		0.995517f, 0.516447f, 0.995519f, 0.516482f, 
		0.996327f, 0.175085f, 0.996346f, 0.224538f, 
		0.996593f, 0.102642f, 0.996621f, 0.102580f, 
		0.996669f, 0.428803f, 0.996673f, 0.428826f, 
		0.996715f, 0.0804680f, 0.996778f, 0.0804454f, 
		0.996885f, 0.224047f, 0.997210f, 0.380217f, 
		0.997425f, 0.731055f, 0.998535f, 0.0656591f, 
		0.998535f, 0.0927047f, 0.998535f, 0.155189f, 
		0.998535f, 0.203125f, 0.998535f, 0.257681f, 
		0.998535f, 0.282742f, 0.998535f, 0.431931f, 
		0.998535f, 0.431947f, 0.998535f, 0.696993f, 
		0.998535f, 0.697029f, 0.998535f, 0.697047f, 
		0.998535f, 0.729265f, 0.998535f, 0.729285f, 
		0.999554f, 0.000459266f, 0.999612f, 0.590554f, 
		0.999615f, 0.590519f, 0.999642f, 0.00755725f, 
		1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		1.00000f, 0.125000f, 1.00000f, 0.125000f, 
		1.00000f, 0.221211f, 1.00000f, 0.293689f, 
		1.00000f, 0.296701f, 1.00000f, 0.347358f, 
		1.00000f, 0.399015f, 1.00000f, 0.434198f, 
		1.00000f, 0.499328f, 1.00000f, 0.518206f, 
		1.00000f, 0.518229f, 1.00000f, 0.542747f, 
		1.00000f, 0.571694f
	};
	static const GLint Indices[] = {
		2107, 2037, 2000, 2107, 2130, 2037, 2107, 2226, 2130, 2107, 2246, 2226, 2142, 2242, 2270, 2270, 
		2279, 2268, 2259, 2201, 2113, 1995, 1978, 1974, 1986, 2036, 2142, 2279, 2259, 2268, 2083, 2113, 
		2208, 1995, 1988, 1978, 1978, 1975, 1974, 1974, 1975, 1986, 1986, 2008, 2036, 2036, 2136, 2142, 
		2142, 2136, 2242, 2242, 2235, 2270, 2259, 2208, 2201, 2208, 2259, 2263, 2263, 2279, 2271, 2271, 
		2270, 2235, 1988, 1995, 2083, 2083, 1995, 2113, 2279, 2270, 2271, 2113, 2201, 2208, 1978, 1988, 
		1975, 1975, 2008, 1986, 2036, 2008, 2136, 2136, 2235, 2242, 2279, 2263, 2259, 2083, 2046, 1988, 
		1988, 2009, 1975, 1975, 2014, 2008, 2008, 2114, 2136, 2136, 2114, 2235, 2235, 2236, 2271, 2271, 
		2239, 2263, 2263, 2211, 2208, 2208, 2120, 2083, 2120, 2208, 2211, 2211, 2263, 2239, 2239, 2271, 
		2236, 2236, 2235, 2204, 2204, 2235, 2114, 2114, 2008, 2014, 2014, 1975, 2009, 2009, 1988, 2046, 
		2120, 2046, 2083, 2038, 2046, 2128, 1999, 2046, 2038, 2226, 2236, 2186, 2246, 2236, 2226, 2246, 
		2239, 2236, 2219, 2239, 2246, 2120, 2128, 2046, 2046, 1999, 2009, 1999, 1994, 2009, 2009, 1994, 
		2014, 2014, 2043, 2114, 2114, 2186, 2204, 2239, 2219, 2211, 2211, 2128, 2120, 2226, 2186, 2130, 
		2130, 2043, 2037, 2037, 1994, 2000, 2000, 1999, 2038, 2128, 2107, 2038, 1999, 2000, 1994, 2043, 
		2014, 1994, 1994, 2037, 2043, 2186, 2114, 2043, 2043, 2130, 2186, 2236, 2204, 2186, 2128, 2211, 
		2219, 2219, 2107, 2128, 2000, 2038, 2107, 2107, 2219, 2246, 1995, 2116, 2113, 1974, 2116, 1995, 
		1986, 2116, 1974, 2142, 2116, 1986, 2268, 2116, 2142, 2113, 2116, 2268, 2113, 2268, 2259, 2142, 
		2270, 2268, 2175, 2055, 2168, 2055, 2059, 2168, 2161, 2068, 2159, 2180, 2161, 2170, 2161, 2162, 
		2170, 2161, 2149, 2162, 2161, 2180, 2184, 2146, 2149, 2161, 2166, 2184, 2182, 2166, 2182, 2175, 
		2118, 2162, 2149, 2143, 2147, 2146, 2159, 2157, 2154, 2149, 2146, 2147, 2161, 2184, 2166, 2146, 
		2161, 2159, 2166, 2175, 2168, 2143, 2146, 2148, 2159, 2154, 2146, 2086, 2069, 2084, 2051, 2053, 
		2069, 2068, 2069, 2086, 2068, 2086, 2085, 2065, 2051, 2069, 2068, 2085, 2078, 2093, 2085, 2086, 
		2069, 2118, 2084, 2069, 2053, 2060, 2065, 2069, 2068, 2051, 2065, 2059, 2068, 2078, 2075, 2075, 
		2071, 2068, 2059, 2055, 2051, 2180, 2053, 2184, 2060, 2053, 2180, 2161, 2166, 2068, 2168, 2065, 
		2166, 2068, 2166, 2065, 2065, 2168, 2059, 2068, 2071, 2159, 2157, 2159, 2071, 2157, 2071, 2154, 
		2071, 2075, 2154, 2075, 2078, 2154, 2154, 2078, 2146, 2148, 2078, 2085, 2148, 2146, 2078, 2085, 
		2143, 2148, 2093, 2143, 2085, 2147, 2093, 2086, 2143, 2093, 2147, 2147, 2086, 2149, 2086, 2084, 
		2149, 2084, 2118, 2149, 2069, 2162, 2118, 2069, 2170, 2162, 2180, 2170, 2060, 2170, 2069, 2060, 
		2182, 2051, 2175, 2055, 2175, 2051, 877, 814, 780, 877, 953, 814, 877, 1023, 953, 877, 
		1016, 1023, 907, 837, 809, 809, 776, 759, 786, 893, 993, 993, 1032, 1058, 1058, 1069, 
		1033, 893, 786, 771, 776, 809, 837, 756, 771, 786, 893, 1032, 993, 1069, 1041, 1033, 
		1033, 1041, 907, 919, 837, 907, 776, 762, 759, 759, 758, 756, 771, 829, 893, 893, 
		920, 1032, 1032, 1052, 1058, 1041, 919, 907, 1055, 1069, 1052, 1052, 1032, 1006, 829, 771, 
		774, 774, 756, 758, 762, 776, 801, 919, 801, 837, 1055, 1041, 1069, 837, 801, 776, 
		759, 762, 758, 756, 774, 771, 829, 920, 893, 920, 1006, 1032, 1055, 1031, 1041, 1031, 
		919, 1041, 1052, 1069, 1058, 919, 903, 801, 801, 805, 762, 762, 783, 758, 758, 783, 
		774, 774, 859, 829, 829, 859, 920, 920, 950, 1006, 1006, 1017, 1052, 1052, 1024, 1055, 
		1055, 1024, 1031, 1031, 987, 919, 987, 1031, 1024, 1024, 1052, 1017, 1017, 1006, 950, 950, 
		920, 859, 859, 774, 783, 783, 762, 805, 805, 801, 903, 987, 903, 919, 903, 830, 
		805, 830, 903, 974, 877, 830, 974, 1023, 1024, 1025, 1016, 1024, 1023, 1016, 974, 1024, 
		830, 784, 805, 805, 784, 783, 784, 779, 783, 783, 779, 859, 859, 847, 950, 950, 
		1025, 1017, 987, 974, 903, 1023, 1025, 953, 953, 847, 814, 814, 779, 780, 780, 784, 
		877, 830, 877, 784, 784, 780, 779, 779, 814, 847, 847, 859, 779, 847, 953, 978, 
		978, 950, 847, 1025, 950, 978, 978, 953, 1025, 1024, 1017, 1025, 974, 987, 1024, 877, 
		974, 1016, 809, 901, 907, 756, 901, 809, 786, 901, 756, 993, 901, 786, 1058, 901, 
		993, 1033, 901, 1058, 907, 901, 1033, 809, 759, 756, 964, 853, 960, 853, 964, 851, 
		943, 937, 947, 943, 947, 958, 932, 937, 943, 932, 928, 937, 949, 958, 964, 926, 
		927, 928, 930, 926, 928, 943, 946, 932, 963, 964, 958, 943, 958, 949, 928, 932, 
		930, 949, 964, 960, 946, 942, 932, 942, 941, 932, 833, 845, 839, 855, 845, 858, 
		839, 845, 855, 873, 858, 872, 855, 858, 873, 875, 872, 858, 868, 875, 858, 852, 
		853, 839, 845, 833, 832, 852, 839, 855, 851, 839, 853, 855, 873, 869, 869, 866, 
		855, 947, 832, 958, 958, 832, 833, 943, 852, 855, 852, 960, 853, 960, 852, 949, 
		949, 852, 943, 855, 946, 943, 866, 946, 855, 866, 942, 946, 869, 942, 866, 942, 
		873, 941, 869, 873, 942, 941, 873, 932, 872, 930, 873, 930, 932, 873, 872, 926, 
		930, 875, 926, 872, 868, 927, 875, 926, 875, 927, 858, 927, 868, 927, 858, 928, 
		928, 845, 937, 845, 928, 858, 947, 937, 832, 937, 845, 832, 963, 839, 964, 851, 
		964, 839, 846, 957, 850, 957, 846, 959, 862, 860, 945, 945, 860, 948, 876, 874, 
		856, 860, 856, 842, 854, 860, 842, 860, 876, 856, 879, 876, 860, 850, 854, 842, 
		881, 878, 876, 862, 863, 865, 840, 846, 850, 842, 856, 848, 874, 876, 878, 850, 
		842, 840, 879, 860, 862, 862, 865, 879, 865, 867, 879, 954, 935, 933, 962, 954, 
		955, 948, 954, 933, 955, 954, 948, 948, 933, 931, 948, 931, 938, 944, 945, 940, 
		929, 931, 933, 966, 962, 955, 948, 938, 945, 955, 965, 966, 965, 955, 957, 945, 
		938, 940, 957, 959, 965, 848, 962, 842, 842, 962, 966, 860, 854, 948, 955, 850, 
		957, 850, 955, 854, 854, 955, 948, 945, 863, 862, 945, 944, 863, 940, 863, 944, 
		865, 863, 940, 940, 938, 865, 867, 938, 879, 867, 865, 938, 931, 876, 938, 876, 
		879, 938, 931, 881, 876, 929, 881, 931, 929, 933, 881, 878, 881, 933, 935, 878, 
		933, 878, 935, 874, 874, 954, 856, 954, 874, 935, 856, 962, 848, 962, 856, 954, 
		840, 959, 846, 959, 840, 965, 909, 989, 1028, 909, 894, 989, 909, 799, 894, 909, 
		785, 799, 909, 793, 785, 1038, 1068, 1054, 1054, 1049, 975, 975, 880, 795, 795, 760, 
		755, 768, 819, 904, 904, 1046, 1038, 1038, 1046, 1068, 1068, 1049, 1054, 1068, 1059, 1049, 
		1049, 976, 975, 795, 770, 760, 760, 757, 755, 768, 778, 819, 770, 795, 834, 834, 
		880, 976, 976, 1049, 1040, 1059, 1068, 1037, 908, 1046, 904, 757, 768, 755, 904, 819, 
		908, 908, 1037, 1046, 1046, 1037, 1068, 1059, 1040, 1049, 880, 834, 795, 760, 770, 757, 
		757, 778, 768, 778, 908, 819, 976, 880, 975, 908, 982, 1037, 1037, 1019, 1059, 1059, 
		1007, 1040, 1040, 1007, 976, 976, 925, 834, 834, 818, 770, 770, 818, 757, 757, 782, 
		778, 887, 778, 798, 798, 778, 782, 782, 757, 818, 818, 834, 925, 925, 976, 1007, 
		1007, 1059, 1019, 1019, 1037, 982, 982, 908, 887, 778, 887, 908, 925, 822, 818, 1030, 
		982, 939, 799, 782, 822, 785, 782, 799, 793, 782, 785, 793, 789, 782, 887, 939, 
		982, 982, 1030, 1019, 1030, 1036, 1019, 1019, 1036, 1007, 1007, 984, 925, 798, 835, 887, 
		909, 835, 793, 799, 822, 894, 894, 984, 989, 989, 1036, 1028, 1028, 1030, 998, 998, 
		939, 909, 835, 909, 939, 939, 998, 1030, 1030, 1028, 1036, 984, 1007, 1036, 1036, 989, 
		984, 822, 925, 984, 984, 894, 822, 782, 818, 822, 789, 798, 782, 835, 798, 789, 
		789, 793, 835, 939, 887, 835, 1028, 998, 909, 1038, 902, 904, 1054, 902, 1038, 975, 
		902, 1054, 795, 902, 975, 755, 902, 795, 768, 902, 755, 904, 902, 768, 2064, 2176, 
		2067, 2176, 2064, 2181, 2074, 2169, 2163, 2163, 2077, 2074, 2074, 2073, 2057, 2082, 2073, 2074, 
		2090, 2087, 2073, 2090, 2073, 2082, 2070, 2074, 2057, 2067, 2070, 2057, 2094, 2092, 2090, 2077, 
		2076, 2080, 2056, 2064, 2067, 2057, 2073, 2066, 2087, 2090, 2092, 2082, 2074, 2077, 2067, 2057, 
		2056, 2077, 2080, 2082, 2169, 2174, 2171, 2169, 2171, 2156, 2188, 2185, 2174, 2188, 2174, 2169, 
		2169, 2156, 2151, 2169, 2151, 2150, 2172, 2188, 2169, 2160, 2163, 2158, 2145, 2150, 2151, 2169, 
		2150, 2163, 2172, 2187, 2188, 2187, 2172, 2176, 2163, 2150, 2158, 2176, 2181, 2187, 2150, 2155, 
		2158, 2066, 2185, 2057, 2057, 2185, 2188, 2169, 2070, 2172, 2172, 2067, 2176, 2067, 2172, 2070, 
		2070, 2169, 2074, 2077, 2163, 2076, 2163, 2160, 2076, 2076, 2160, 2080, 2080, 2160, 2158, 2158, 
		2155, 2080, 2082, 2080, 2155, 2150, 2090, 2115, 2082, 2155, 2115, 2150, 2145, 2090, 2145, 2094, 
		2090, 2092, 2094, 2151, 2094, 2145, 2151, 2156, 2087, 2151, 2092, 2151, 2087, 2087, 2171, 2073, 
		2156, 2171, 2087, 2073, 2185, 2066, 2185, 2073, 2174, 2174, 2073, 2171, 2056, 2181, 2064, 2181, 
		2056, 2187, 2082, 2115, 2090, 2115, 2155, 2150, 2126, 2207, 2245, 2126, 2108, 2207, 2126, 2019, 
		2108, 2126, 2001, 2019, 2126, 2011, 2001, 2255, 2280, 2267, 1976, 1973, 1989, 1989, 2039, 2119, 
		2119, 2260, 2255, 2255, 2260, 2280, 2280, 2276, 2267, 2267, 2229, 2230, 2230, 2099, 2110, 2110, 
		2099, 1998, 1998, 1987, 1976, 1989, 2016, 2039, 2016, 1989, 1977, 1987, 1998, 2099, 2229, 2267, 
		2276, 2276, 2280, 2254, 2124, 2260, 2119, 1977, 1989, 1973, 1973, 1976, 1977, 2119, 2039, 2124, 
		2124, 2254, 2260, 2260, 2254, 2280, 2230, 2229, 2099, 1987, 1977, 1976, 2016, 2124, 2039, 2124, 
		2215, 2254, 2254, 2241, 2276, 2276, 2223, 2229, 2229, 2102, 2099, 2099, 2102, 1987, 1987, 2004, 
		1977, 1977, 2020, 2016, 2109, 2016, 2020, 2020, 1977, 2004, 2004, 1987, 2102, 2102, 2229, 2223, 
		2223, 2276, 2241, 2241, 2254, 2215, 2215, 2124, 2109, 2016, 2109, 2124, 2215, 2248, 2241, 2139, 
		2215, 2109, 2248, 2215, 2139, 2019, 1992, 2044, 2001, 1992, 2019, 2011, 1992, 2001, 2011, 2030, 
		1992, 2139, 2109, 2030, 2248, 2251, 2241, 2241, 2199, 2223, 2223, 2199, 2102, 2102, 2044, 2004, 
		2004, 1992, 2020, 2020, 2030, 2109, 2126, 2030, 2011, 2019, 2044, 2108, 2108, 2199, 2207, 2207, 
		2251, 2245, 2245, 2248, 2222, 2222, 2139, 2126, 2139, 2222, 2248, 2248, 2245, 2251, 2199, 2241, 
		2251, 2251, 2207, 2199, 2044, 2102, 2199, 2199, 2108, 2044, 1992, 2004, 2044, 2030, 2020, 1992, 
		2030, 2126, 2139, 2245, 2222, 2126, 2255, 2117, 2119, 2267, 2117, 2255, 2230, 2117, 2267, 1998, 
		2117, 2230, 1976, 2117, 1998, 1989, 2117, 1976, 2119, 2117, 1989, 1998, 2230, 2110, 1423, 1283, 
		1263, 1165, 1263, 1283, 1079, 1165, 1124, 1079, 1084, 1165, 1222, 1238, 1084, 1222, 1084, 1095, 
		1324, 1238, 1222, 1498, 1446, 1506, 1517, 1498, 1506, 1460, 1423, 1263, 1238, 1324, 1446, 1506, 
		1446, 1439, 1124, 1165, 1283, 1517, 1460, 1498, 1460, 1489, 1423, 1095, 1137, 1222, 1446, 1324, 
		1439, 1084, 1079, 1095, 1489, 1460, 1517, 1473, 1489, 1517, 1414, 1489, 1473, 1414, 1423, 1489, 
		1302, 1423, 1414, 1302, 1283, 1423, 1302, 1146, 1283, 1146, 1124, 1283, 1146, 1079, 1124, 1114, 
		1095, 1079, 1114, 1137, 1095, 1195, 1137, 1114, 1195, 1222, 1137, 1222, 1195, 1324, 1341, 1439, 
		1324, 1444, 1506, 1439, 1506, 1444, 1473, 1517, 1506, 1473, 1444, 1439, 1341, 1341, 1324, 1195, 
		1146, 1114, 1079, 1507, 1491, 1503, 1454, 1414, 1503, 1454, 1503, 1491, 1344, 1302, 1414, 1344, 
		1414, 1454, 1346, 1344, 1454, 1203, 1302, 1344, 1203, 1344, 1346, 1098, 1146, 1302, 1098, 1302, 
		1203, 1183, 1203, 1346, 1093, 1098, 1203, 1098, 1114, 1146, 1087, 1114, 1098, 1087, 1098, 1085, 
		1116, 1087, 1085, 1206, 1195, 1114, 1206, 1114, 1087, 1116, 1206, 1087, 1266, 1206, 1116, 1206, 
		1341, 1195, 1266, 1341, 1206, 1427, 1341, 1266, 1427, 1468, 1341, 1468, 1444, 1341, 1468, 1473, 
		1444, 1481, 1468, 1427, 1481, 1503, 1468, 1503, 1481, 1507, 1503, 1473, 1468, 1085, 1098, 1093, 
		1346, 1454, 1491, 1414, 1473, 1503, 1203, 1183, 1093, 1435, 1491, 1507, 1289, 1346, 1382, 1289, 
		1183, 1346, 1133, 1093, 1176, 1159, 1261, 1116, 1261, 1427, 1266, 1412, 1427, 1261, 1435, 1507, 
		1412, 1491, 1382, 1346, 1183, 1176, 1093, 1093, 1133, 1085, 1085, 1159, 1116, 1116, 1261, 1266, 
		1427, 1412, 1481, 1382, 1491, 1435, 1289, 1176, 1183, 1159, 1085, 1133, 1481, 1412, 1507, 1435, 
		1398, 1382, 1382, 1398, 1289, 1289, 1259, 1176, 1176, 1155, 1133, 1133, 1151, 1159, 1159, 1151, 
		1261, 1261, 1379, 1412, 1430, 1412, 1379, 1379, 1261, 1262, 1262, 1261, 1151, 1151, 1133, 1155, 
		1155, 1176, 1259, 1259, 1289, 1398, 1398, 1435, 1430, 1412, 1430, 1435, 1430, 1492, 1398, 1398, 
		1392, 1259, 1259, 1127, 1155, 1155, 1088, 1151, 1151, 1143, 1262, 1262, 1270, 1379, 1379, 1492, 
		1430, 1492, 1379, 1440, 1440, 1379, 1270, 1270, 1262, 1143, 1143, 1151, 1088, 1088, 1155, 1127, 
		1127, 1259, 1218, 1218, 1259, 1392, 1392, 1398, 1492, 1480, 1492, 1504, 1480, 1392, 1492, 1153, 
		1127, 1218, 1143, 1088, 1091, 1461, 1440, 1347, 1504, 1492, 1461, 1270, 1347, 1440, 1440, 1461, 
		1492, 1347, 1270, 1197, 1197, 1143, 1125, 1091, 1088, 1099, 1099, 1127, 1153, 1153, 1218, 1301, 
		1301, 1392, 1417, 1417, 1392, 1480, 1392, 1301, 1218, 1127, 1099, 1088, 1091, 1125, 1143, 1143, 
		1197, 1270, 1343, 1480, 1504, 1343, 1417, 1480, 1301, 1417, 1343, 1099, 1153, 1230, 1219, 1125, 
		1091, 1219, 1197, 1125, 1347, 1197, 1219, 1365, 1464, 1347, 1461, 1464, 1504, 1389, 1464, 1365, 
		1365, 1347, 1219, 1219, 1091, 1178, 1230, 1301, 1343, 1504, 1389, 1343, 1301, 1230, 1153, 1230, 
		1178, 1099, 1099, 1178, 1091, 1464, 1461, 1347, 1464, 1389, 1504, 1353, 1343, 1389, 1234, 1230, 
		1343, 1234, 1343, 1353, 1132, 1230, 1156, 1132, 1178, 1230, 1189, 1219, 1178, 1340, 1320, 1219, 
		1340, 1219, 1189, 1428, 1365, 1320, 1428, 1320, 1340, 1441, 1389, 1365, 1219, 1320, 1365, 1189, 
		1178, 1132, 1389, 1441, 1353, 1234, 1156, 1230, 1365, 1428, 1441, 1210, 1353, 1325, 1210, 1234, 
		1353, 1210, 1156, 1234, 1210, 1132, 1156, 1167, 1132, 1210, 1167, 1189, 1132, 1290, 1189, 1208, 
		1290, 1340, 1189, 1290, 1428, 1340, 1406, 1441, 1428, 1406, 1428, 1366, 1325, 1353, 1377, 1406, 
		1377, 1441, 1441, 1377, 1353, 1189, 1167, 1208, 1290, 1366, 1428, 1377, 1406, 1390, 1334, 1377, 
		1390, 1191, 1208, 1167, 1366, 1390, 1406, 1390, 1366, 1306, 1306, 1208, 1191, 1190, 1210, 1334, 
		1377, 1334, 1325, 1325, 1334, 1210, 1210, 1190, 1167, 1190, 1191, 1167, 1208, 1306, 1290, 1290, 
		1306, 1366, 1508, 1484, 1334, 1426, 1334, 1484, 1334, 1426, 1274, 1334, 1274, 1190, 1190, 1274, 
		1102, 1119, 1191, 1102, 1306, 1119, 1280, 1191, 1119, 1306, 1421, 1306, 1280, 1306, 1421, 1390, 
		1390, 1421, 1508, 1421, 1280, 1321, 1321, 1280, 1172, 1172, 1119, 1110, 1508, 1515, 1484, 1334, 
		1390, 1508, 1191, 1190, 1102, 1102, 1082, 1119, 1119, 1172, 1280, 1488, 1484, 1515, 1332, 1337, 
		1294, 1287, 1294, 1337, 1294, 1265, 1332, 1227, 1265, 1294, 1287, 1267, 1227, 1337, 1312, 1267, 
		1287, 1337, 1267, 1265, 1227, 1233, 1233, 1227, 1213, 1213, 1267, 1246, 1246, 1267, 1312, 1312, 
		1337, 1349, 1337, 1332, 1349, 1294, 1287, 1227, 1267, 1213, 1227, 1446, 1288, 1238, 1498, 1288, 
		1446, 1238, 1288, 1084, 1084, 1288, 1165, 1460, 1288, 1498, 1288, 1460, 1263, 1263, 1165, 1288, 
		1142, 1274, 1264, 1102, 1142, 1105, 1274, 1142, 1102, 1375, 1426, 1462, 1488, 1426, 1484, 1426, 
		1488, 1462, 1426, 1375, 1274, 1482, 1508, 1432, 1482, 1515, 1508, 1421, 1432, 1508, 1321, 1432, 
		1421, 1081, 1102, 1105, 1082, 1102, 1081, 1119, 1082, 1110, 1213, 1082, 1081, 1349, 1515, 1482, 
		1515, 1349, 1488, 1233, 1105, 1265, 1265, 1375, 1332, 1462, 1332, 1375, 1375, 1264, 1274, 1172, 
		1312, 1321, 1321, 1312, 1432, 1265, 1142, 1264, 1264, 1375, 1265, 1142, 1265, 1105, 1233, 1213, 
		1105, 1349, 1482, 1312, 1312, 1172, 1246, 1246, 1172, 1110, 1246, 1110, 1213, 1332, 1462, 1349, 
		1349, 1462, 1488, 1312, 1482, 1432, 1082, 1213, 1110, 1105, 1213, 1081, 1888, 1833, 1840, 1792, 
		1840, 1833, 1715, 1756, 1731, 1731, 1756, 1793, 1754, 1906, 1644, 1570, 1534, 1549, 1906, 1956, 
		1963, 1947, 1963, 1962, 1722, 1830, 1857, 1543, 1570, 1592, 1541, 1549, 1534, 1541, 1534, 1543, 
		1597, 1549, 1541, 1723, 1878, 1754, 1946, 1906, 1878, 1962, 1956, 1946, 1941, 1857, 1830, 1830, 
		1722, 1682, 1570, 1543, 1534, 1549, 1597, 1644, 1644, 1723, 1754, 1906, 1946, 1956, 1857, 1941, 
		1947, 1592, 1682, 1722, 1570, 1682, 1592, 1723, 1644, 1597, 1962, 1963, 1956, 1963, 1947, 1941, 
		1754, 1878, 1906, 1962, 1932, 1947, 1947, 1881, 1857, 1857, 1724, 1722, 1722, 1724, 1592, 1592, 
		1599, 1543, 1543, 1575, 1541, 1541, 1632, 1597, 1597, 1632, 1723, 1723, 1747, 1878, 1878, 1904, 
		1946, 1946, 1904, 1962, 1904, 1878, 1747, 1747, 1723, 1632, 1632, 1541, 1575, 1575, 1543, 1599, 
		1599, 1592, 1724, 1724, 1857, 1881, 1881, 1947, 1932, 1904, 1932, 1962, 1881, 1932, 1961, 1925, 
		1881, 1961, 1822, 1724, 1881, 1822, 1881, 1925, 1649, 1724, 1822, 1649, 1599, 1724, 1542, 1599, 
		1649, 1542, 1575, 1599, 1594, 1575, 1542, 1542, 1539, 1594, 1594, 1632, 1575, 1777, 1747, 1632, 
		1777, 1632, 1594, 1777, 1904, 1747, 1898, 1950, 1777, 1950, 1904, 1777, 1961, 1932, 1904, 1961, 
		1904, 1950, 1961, 1950, 1954, 1954, 1950, 1898, 1676, 1594, 1562, 1564, 1649, 1667, 1667, 1649, 
		1828, 1961, 1960, 1925, 1925, 1828, 1822, 1822, 1828, 1649, 1649, 1564, 1542, 1539, 1562, 1594, 
		1594, 1676, 1777, 1891, 1925, 1960, 1891, 1828, 1925, 1748, 1828, 1891, 1748, 1667, 1828, 1550, 
		1542, 1564, 1562, 1550, 1593, 1761, 1777, 1676, 1898, 1777, 1761, 1914, 1960, 1954, 1542, 1550, 
		1539, 1539, 1550, 1562, 1914, 1954, 1890, 1647, 1562, 1593, 1593, 1550, 1636, 1891, 1960, 1914, 
		1748, 1636, 1667, 1667, 1636, 1564, 1564, 1636, 1550, 1562, 1647, 1676, 1676, 1647, 1761, 1761, 
		1890, 1898, 1898, 1890, 1954, 1960, 1961, 1954, 1879, 1827, 1914, 1767, 1748, 1827, 1767, 1636, 
		1748, 1637, 1636, 1656, 1637, 1593, 1636, 1637, 1647, 1593, 1709, 1647, 1637, 1709, 1761, 1647, 
		1786, 1761, 1709, 1867, 1890, 1786, 1879, 1914, 1867, 1879, 1867, 1853, 1761, 1786, 1890, 1890, 
		1867, 1914, 1853, 1786, 1709, 1767, 1827, 1879, 1827, 1891, 1914, 1748, 1891, 1827, 1767, 1656, 
		1636, 1786, 1853, 1867, 1937, 1767, 1879, 1829, 1767, 1937, 1767, 1829, 1654, 1577, 1656, 1767, 
		1577, 1767, 1654, 1637, 1656, 1577, 1591, 1637, 1577, 1591, 1709, 1637, 1661, 1709, 1591, 1812, 
		1709, 1661, 1916, 1853, 1812, 1937, 1879, 1853, 1937, 1853, 1916, 1709, 1812, 1853, 1937, 1902, 
		1829, 1829, 1745, 1654, 1654, 1621, 1577, 1577, 1578, 1591, 1591, 1622, 1661, 1661, 1744, 1812, 
		1812, 1901, 1916, 1922, 1937, 1901, 1901, 1812, 1744, 1744, 1661, 1622, 1622, 1591, 1578, 1578, 
		1577, 1621, 1621, 1654, 1745, 1745, 1829, 1902, 1902, 1937, 1922, 1916, 1901, 1937, 1902, 1820, 
		1745, 1745, 1680, 1621, 1621, 1680, 1578, 1578, 1646, 1622, 1622, 1720, 1744, 1744, 1794, 1901, 
		1872, 1922, 1858, 1858, 1901, 1794, 1794, 1744, 1720, 1720, 1622, 1646, 1646, 1578, 1680, 1680, 
		1745, 1820, 1820, 1902, 1872, 1922, 1872, 1902, 1901, 1858, 1922, 1905, 1781, 1872, 1840, 1781, 
		1905, 1781, 1666, 1680, 1609, 1666, 1612, 1609, 1680, 1666, 1609, 1646, 1680, 1583, 1609, 1558, 
		1683, 1646, 1609, 1683, 1609, 1583, 1683, 1720, 1646, 1823, 1720, 1683, 1823, 1794, 1720, 1900, 
		1858, 1794, 1900, 1794, 1823, 1905, 1872, 1858, 1905, 1858, 1900, 1939, 1905, 1900, 1840, 1905, 
		1952, 1952, 1905, 1939, 1953, 1900, 1928, 1928, 1900, 1823, 1717, 1683, 1628, 1628, 1683, 1583, 
		1558, 1609, 1612, 1612, 1666, 1721, 1721, 1781, 1840, 1781, 1820, 1872, 1680, 1820, 1781, 1781, 
		1721, 1666, 1683, 1717, 1823, 1900, 1953, 1939, 1823, 1860, 1928, 1553, 1585, 1627, 1929, 1953, 
		1910, 1623, 1553, 1627, 1833, 1888, 1929, 1860, 1910, 1928, 1928, 1910, 1953, 1566, 1689, 1628, 
		1628, 1689, 1717, 1717, 1689, 1834, 1792, 1627, 1617, 1888, 1952, 1929, 1792, 1833, 1627, 1553, 
		1623, 1566, 1910, 1860, 1834, 1832, 1929, 1887, 1832, 1833, 1929, 1695, 1833, 1832, 1755, 1689, 
		1652, 1846, 1834, 1755, 1846, 1910, 1834, 1887, 1910, 1846, 1833, 1695, 1627, 1627, 1695, 1623, 
		1566, 1652, 1689, 1689, 1755, 1834, 1910, 1887, 1929, 1652, 1566, 1623, 1779, 1695, 1832, 1802, 
		1755, 1712, 1824, 1887, 1802, 1887, 1824, 1832, 1695, 1713, 1623, 1623, 1690, 1652, 1755, 1802, 
		1846, 1846, 1802, 1887, 1779, 1832, 1824, 1713, 1695, 1779, 1690, 1623, 1713, 1712, 1652, 1690, 
		1755, 1652, 1712, 1824, 1793, 1756, 1824, 1756, 1779, 1756, 1713, 1779, 1713, 1756, 1715, 1690, 
		1715, 1731, 1802, 1731, 1793, 1713, 1715, 1690, 1712, 1731, 1802, 1802, 1793, 1824, 1712, 1690, 
		1731, 1941, 1758, 1963, 1830, 1758, 1941, 1682, 1758, 1830, 1570, 1758, 1682, 1549, 1758, 1570, 
		1644, 1758, 1549, 1906, 1758, 1644, 1963, 1758, 1906, 1823, 1717, 1834, 1566, 1628, 1583, 1558, 
		1612, 1585, 1553, 1558, 1585, 1566, 1558, 1553, 1566, 1583, 1558, 1721, 1840, 1792, 1721, 1617, 
		1612, 1721, 1792, 1617, 1888, 1840, 1952, 1627, 1585, 1612, 1617, 1627, 1612, 1860, 1823, 1834, 
		1939, 1953, 1929, 1939, 1929, 1952, 589, 493, 581, 589, 461, 493, 541, 461, 589, 589, 
		634, 541, 690, 589, 581, 634, 589, 690, 744, 730, 732, 614, 679, 730, 534, 390, 
		437, 651, 698, 534, 726, 698, 651, 744, 698, 726, 732, 698, 744, 732, 730, 679, 
		480, 398, 382, 480, 679, 614, 703, 730, 744, 703, 614, 730, 615, 614, 703, 454, 
		398, 512, 452, 390, 404, 452, 437, 390, 560, 534, 437, 661, 534, 560, 711, 726, 
		661, 711, 744, 726, 614, 512, 480, 480, 512, 398, 382, 404, 390, 651, 661, 726, 
		711, 661, 643, 643, 661, 560, 560, 437, 452, 404, 398, 454, 512, 614, 615, 703, 
		744, 711, 404, 382, 398, 661, 651, 534, 716, 703, 727, 615, 716, 631, 615, 631, 
		527, 404, 406, 392, 468, 452, 392, 452, 468, 594, 594, 713, 643, 643, 713, 711, 
		727, 711, 713, 615, 527, 512, 512, 406, 454, 703, 711, 727, 716, 615, 703, 406, 
		512, 527, 406, 404, 454, 452, 404, 392, 594, 560, 452, 594, 643, 560, 406, 407, 
		392, 392, 417, 468, 594, 603, 713, 603, 594, 468, 417, 392, 407, 407, 406, 527, 
		716, 586, 631, 631, 586, 527, 567, 586, 637, 528, 586, 567, 470, 501, 407, 607, 
		603, 501, 611, 658, 607, 727, 637, 716, 716, 637, 586, 586, 528, 527, 527, 528, 
		407, 417, 501, 468, 603, 607, 713, 713, 658, 727, 611, 607, 499, 499, 470, 497, 
		497, 528, 567, 567, 637, 648, 658, 611, 648, 637, 727, 658, 658, 648, 637, 528, 
		497, 470, 470, 407, 528, 501, 417, 407, 470, 499, 501, 603, 468, 501, 501, 499, 
		607, 658, 713, 607, 659, 648, 696, 659, 567, 648, 543, 567, 659, 596, 543, 659, 
		448, 497, 543, 486, 448, 543, 516, 499, 433, 556, 499, 516, 646, 611, 556, 497, 
		448, 499, 499, 556, 611, 611, 696, 648, 646, 556, 516, 516, 433, 458, 458, 448, 
		486, 486, 543, 596, 596, 659, 696, 543, 497, 567, 433, 499, 448, 448, 458, 433, 
		696, 611, 646, 597, 696, 627, 458, 486, 526, 495, 458, 526, 495, 511, 458, 516, 
		511, 573, 627, 646, 573, 696, 597, 596, 596, 526, 486, 458, 511, 516, 516, 573, 
		646, 646, 627, 696, 526, 596, 597, 633, 627, 669, 524, 597, 633, 597, 524, 526, 
		495, 524, 457, 526, 524, 495, 495, 457, 489, 588, 511, 489, 511, 588, 573, 669, 
		573, 588, 573, 669, 627, 627, 633, 597, 495, 489, 511, 633, 692, 641, 467, 524, 
		548, 606, 588, 490, 669, 692, 633, 633, 548, 524, 524, 467, 457, 457, 423, 489, 
		489, 490, 588, 588, 694, 669, 548, 633, 641, 423, 457, 467, 490, 489, 423, 694, 
		588, 606, 692, 669, 694, 620, 641, 706, 553, 641, 620, 471, 467, 553, 412, 467, 
		471, 412, 423, 467, 451, 423, 412, 539, 490, 451, 692, 706, 641, 641, 553, 548, 
		490, 539, 606, 706, 694, 684, 684, 606, 539, 706, 692, 694, 467, 548, 553, 451, 
		490, 423, 606, 684, 694, 677, 706, 699, 677, 620, 706, 522, 553, 620, 471, 553, 
		522, 439, 471, 522, 439, 412, 471, 440, 412, 439, 443, 412, 440, 578, 539, 443, 
		699, 684, 578, 699, 706, 684, 412, 443, 451, 539, 578, 684, 620, 677, 522, 539, 
		451, 443, 677, 699, 690, 464, 522, 575, 439, 522, 464, 427, 440, 439, 427, 439, 
		464, 520, 578, 440, 520, 653, 578, 580, 653, 520, 690, 699, 653, 677, 575, 522, 
		578, 653, 699, 520, 440, 427, 656, 677, 690, 677, 656, 575, 578, 443, 440, 464, 
		461, 427, 656, 581, 575, 575, 581, 464, 427, 461, 520, 520, 541, 580, 580, 634, 
		653, 653, 634, 690, 634, 580, 541, 541, 520, 461, 461, 464, 493, 493, 464, 581, 
		581, 656, 690, 679, 561, 732, 480, 561, 679, 382, 561, 480, 390, 561, 382, 534, 
		561, 390, 698, 561, 534, 732, 561, 698, 590, 492, 582, 590, 462, 492, 542, 462, 
		590, 590, 632, 542, 702, 590, 582, 632, 590, 702, 395, 402, 381, 535, 395, 436, 
		639, 697, 535, 725, 697, 639, 745, 697, 725, 733, 697, 745, 733, 745, 687, 687, 
		625, 472, 436, 395, 385, 381, 402, 397, 397, 402, 472, 745, 722, 687, 381, 385, 
		395, 705, 745, 714, 705, 722, 745, 640, 625, 722, 554, 500, 625, 444, 397, 500, 
		405, 381, 397, 405, 397, 444, 385, 381, 405, 435, 436, 385, 545, 535, 436, 639, 
		535, 545, 649, 725, 639, 714, 745, 725, 722, 625, 687, 625, 500, 472, 714, 725, 
		649, 649, 639, 545, 545, 436, 435, 435, 385, 405, 444, 500, 554, 554, 625, 640, 
		640, 722, 705, 397, 472, 500, 729, 719, 705, 705, 719, 640, 640, 719, 591, 554, 
		591, 481, 394, 444, 481, 444, 394, 405, 405, 409, 435, 394, 409, 405, 517, 435, 
		409, 435, 517, 545, 642, 545, 517, 729, 649, 642, 714, 729, 705, 640, 591, 554, 
		554, 481, 444, 545, 642, 649, 729, 714, 649, 719, 680, 591, 394, 420, 409, 517, 
		628, 642, 642, 628, 729, 717, 729, 628, 517, 409, 420, 680, 729, 717, 729, 680, 
		719, 481, 429, 394, 420, 394, 429, 429, 481, 591, 630, 680, 657, 565, 680, 630, 
		510, 565, 568, 510, 429, 565, 474, 429, 510, 474, 502, 429, 605, 628, 502, 610, 
		657, 605, 717, 657, 680, 591, 565, 429, 420, 502, 517, 628, 605, 717, 610, 605, 
		496, 496, 474, 510, 657, 610, 630, 630, 568, 565, 565, 591, 680, 502, 420, 429, 
		474, 496, 502, 628, 517, 502, 502, 496, 605, 657, 717, 605, 660, 630, 695, 660, 
		568, 630, 544, 568, 660, 593, 544, 660, 449, 510, 544, 488, 449, 544, 523, 529, 
		434, 650, 610, 529, 650, 529, 523, 510, 449, 496, 496, 529, 610, 610, 695, 630, 
		523, 434, 459, 459, 449, 488, 488, 544, 593, 593, 660, 695, 544, 510, 568, 434, 
		496, 449, 449, 459, 434, 529, 496, 434, 695, 610, 650, 540, 593, 617, 459, 488, 
		540, 509, 459, 540, 629, 650, 579, 695, 617, 593, 593, 540, 488, 459, 509, 523, 
		523, 579, 650, 617, 695, 629, 579, 523, 509, 629, 695, 650, 629, 681, 617, 617, 
		681, 584, 617, 584, 540, 473, 540, 584, 479, 509, 473, 509, 479, 579, 626, 579, 
		479, 579, 626, 629, 681, 629, 626, 540, 473, 509, 466, 473, 559, 478, 479, 422, 
		479, 478, 604, 681, 652, 584, 584, 559, 473, 473, 422, 479, 479, 604, 626, 626, 
		693, 681, 559, 584, 652, 422, 473, 466, 693, 626, 604, 550, 652, 704, 469, 466, 
		550, 413, 466, 469, 478, 422, 413, 681, 704, 652, 652, 550, 559, 466, 413, 422, 
		478, 532, 604, 704, 693, 686, 686, 604, 532, 704, 681, 693, 704, 674, 550, 466, 
		559, 550, 604, 686, 693, 685, 674, 704, 598, 550, 674, 525, 550, 598, 469, 550, 
		525, 441, 469, 525, 441, 415, 469, 549, 532, 453, 549, 600, 532, 675, 686, 600, 
		685, 704, 686, 685, 686, 675, 469, 415, 413, 413, 453, 478, 532, 600, 686, 675, 
		600, 549, 674, 685, 598, 453, 413, 415, 532, 478, 453, 673, 685, 702, 673, 598, 
		685, 537, 525, 598, 441, 525, 537, 442, 441, 537, 426, 415, 441, 426, 441, 442, 
		453, 415, 426, 505, 549, 453, 702, 675, 644, 549, 644, 675, 644, 549, 505, 505, 
		453, 426, 537, 598, 673, 702, 685, 675, 442, 462, 426, 673, 582, 537, 537, 492, 
		442, 426, 462, 505, 505, 542, 644, 644, 632, 702, 632, 644, 542, 542, 505, 462, 
		462, 442, 492, 492, 537, 582, 582, 673, 702, 687, 562, 733, 472, 562, 687, 402, 
		562, 472, 395, 562, 402, 535, 562, 395, 697, 562, 535, 733, 562, 697, 2509, 2403, 
		2490, 2509, 2372, 2403, 2454, 2372, 2509, 2509, 2553, 2454, 2599, 2509, 2490, 2553, 2509, 2599, 
		2646, 2650, 2655, 2381, 2390, 2525, 2310, 2390, 2381, 2306, 2310, 2293, 2448, 2306, 2349, 2558, 
		2605, 2448, 2643, 2605, 2558, 2655, 2605, 2643, 2650, 2605, 2655, 2650, 2646, 2594, 2594, 2525, 
		2390, 2349, 2306, 2296, 2293, 2310, 2303, 2303, 2310, 2381, 2293, 2296, 2306, 2610, 2646, 2655, 
		2610, 2525, 2646, 2493, 2525, 2610, 2377, 2381, 2525, 2377, 2303, 2381, 2296, 2303, 2318, 2358, 
		2349, 2296, 2470, 2448, 2349, 2569, 2448, 2470, 2622, 2643, 2569, 2622, 2655, 2643, 2646, 2525, 
		2594, 2558, 2569, 2643, 2622, 2569, 2552, 2552, 2569, 2470, 2470, 2349, 2358, 2358, 2296, 2318, 
		2318, 2303, 2377, 2377, 2525, 2493, 2610, 2655, 2622, 2296, 2293, 2303, 2569, 2558, 2448, 2628, 
		2610, 2644, 2543, 2610, 2628, 2610, 2543, 2493, 2360, 2493, 2543, 2493, 2360, 2377, 2301, 2377, 
		2360, 2358, 2318, 2301, 2382, 2358, 2301, 2358, 2382, 2470, 2583, 2470, 2382, 2552, 2470, 2583, 
		2552, 2583, 2622, 2644, 2622, 2583, 2377, 2301, 2318, 2610, 2622, 2644, 2543, 2458, 2360, 2360, 
		2335, 2301, 2382, 2521, 2583, 2583, 2614, 2644, 2614, 2583, 2521, 2521, 2382, 2393, 2393, 2382, 
		2301, 2335, 2360, 2458, 2406, 2489, 2468, 2378, 2335, 2406, 2644, 2548, 2628, 2628, 2548, 2543, 
		2543, 2489, 2458, 2458, 2406, 2335, 2335, 2378, 2301, 2301, 2437, 2393, 2393, 2437, 2521, 2521, 
		2564, 2614, 2614, 2564, 2644, 2556, 2564, 2483, 2483, 2437, 2411, 2411, 2378, 2394, 2394, 2406, 
		2468, 2468, 2548, 2556, 2548, 2644, 2564, 2564, 2556, 2548, 2489, 2543, 2548, 2548, 2468, 2489, 
		2406, 2458, 2489, 2406, 2394, 2378, 2437, 2301, 2378, 2378, 2411, 2437, 2437, 2483, 2498, 2498, 
		2521, 2437, 2564, 2521, 2498, 2498, 2483, 2564, 2566, 2556, 2601, 2566, 2468, 2556, 2465, 2468, 
		2566, 2507, 2465, 2566, 2368, 2394, 2468, 2368, 2468, 2465, 2396, 2411, 2344, 2585, 2483, 2520, 
		2601, 2556, 2585, 2394, 2344, 2411, 2483, 2585, 2556, 2601, 2585, 2520, 2368, 2465, 2507, 2507, 
		2566, 2601, 2344, 2394, 2368, 2483, 2411, 2396, 2520, 2483, 2396, 2444, 2368, 2495, 2444, 2397, 
		2368, 2368, 2397, 2344, 2456, 2396, 2397, 2544, 2520, 2500, 2601, 2495, 2507, 2507, 2495, 2368, 
		2344, 2397, 2396, 2396, 2456, 2520, 2495, 2601, 2544, 2500, 2520, 2456, 2544, 2601, 2520, 2550, 
		2544, 2587, 2495, 2550, 2444, 2421, 2444, 2550, 2357, 2397, 2421, 2367, 2397, 2357, 2450, 2456, 
		2367, 2530, 2456, 2450, 2456, 2530, 2500, 2587, 2500, 2530, 2544, 2550, 2495, 2444, 2421, 2397, 
		2397, 2367, 2456, 2500, 2587, 2544, 2450, 2367, 2357, 2339, 2421, 2479, 2587, 2590, 2550, 2550, 
		2479, 2421, 2421, 2339, 2357, 2357, 2365, 2450, 2530, 2450, 2365, 2479, 2550, 2590, 2365, 2357, 
		2339, 2591, 2587, 2530, 2590, 2587, 2591, 2551, 2590, 2624, 2590, 2551, 2479, 2479, 2419, 2339, 
		2365, 2418, 2530, 2624, 2591, 2503, 2418, 2365, 2325, 2385, 2419, 2551, 2590, 2591, 2624, 2419, 
		2479, 2551, 2325, 2339, 2419, 2419, 2385, 2325, 2365, 2339, 2325, 2503, 2530, 2418, 2591, 2530, 
		2503, 2555, 2551, 2624, 2431, 2551, 2555, 2431, 2385, 2551, 2352, 2385, 2431, 2352, 2325, 2385, 
		2353, 2325, 2352, 2355, 2325, 2353, 2464, 2418, 2355, 2523, 2503, 2418, 2523, 2418, 2464, 2603, 
		2503, 2523, 2325, 2355, 2418, 2503, 2603, 2624, 2555, 2624, 2603, 2574, 2611, 2599, 2415, 2574, 
		2539, 2415, 2431, 2574, 2352, 2431, 2415, 2354, 2352, 2415, 2338, 2353, 2352, 2338, 2352, 2354, 
		2463, 2464, 2353, 2463, 2523, 2464, 2611, 2523, 2463, 2611, 2603, 2523, 2603, 2574, 2555, 2555, 
		2574, 2431, 2599, 2611, 2553, 2553, 2611, 2463, 2463, 2353, 2338, 2539, 2574, 2599, 2574, 2603, 
		2611, 2464, 2355, 2353, 2354, 2372, 2338, 2539, 2490, 2415, 2415, 2403, 2354, 2338, 2372, 2463, 
		2553, 2463, 2454, 2454, 2463, 2372, 2372, 2354, 2403, 2403, 2415, 2490, 2490, 2539, 2599, 2594, 
		2471, 2650, 2390, 2471, 2594, 2310, 2471, 2390, 2306, 2471, 2310, 2448, 2471, 2306, 2605, 2471, 
		2448, 2650, 2471, 2605, 2508, 2402, 2516, 2508, 2371, 2402, 2455, 2371, 2508, 2508, 2532, 2455, 
		2589, 2508, 2516, 2508, 2589, 2532, 2621, 2651, 2656, 2309, 2387, 2442, 2449, 2300, 2348, 2561, 
		2606, 2449, 2642, 2606, 2561, 2656, 2606, 2642, 2651, 2606, 2656, 2621, 2442, 2387, 2387, 2309, 
		2292, 2442, 2621, 2538, 2554, 2538, 2635, 2467, 2442, 2538, 2363, 2442, 2467, 2351, 2309, 2363, 
		2314, 2292, 2309, 2314, 2309, 2351, 2326, 2300, 2314, 2326, 2348, 2300, 2392, 2348, 2326, 2487, 
		2449, 2348, 2557, 2561, 2487, 2557, 2642, 2561, 2619, 2656, 2642, 2656, 2635, 2621, 2442, 2363, 
		2309, 2292, 2314, 2300, 2623, 2656, 2619, 2619, 2642, 2557, 2487, 2348, 2392, 2351, 2363, 2467, 
		2467, 2538, 2554, 2554, 2635, 2623, 2656, 2623, 2635, 2538, 2621, 2635, 2487, 2561, 2449, 2326, 
		2314, 2351, 2631, 2623, 2640, 2623, 2631, 2554, 2501, 2554, 2631, 2399, 2467, 2501, 2351, 2399, 
		2307, 2351, 2307, 2326, 2308, 2326, 2307, 2392, 2308, 2391, 2392, 2391, 2492, 2487, 2492, 2557, 
		2630, 2557, 2492, 2640, 2623, 2630, 2554, 2501, 2467, 2467, 2399, 2351, 2557, 2630, 2619, 2619, 
		2630, 2623, 2392, 2326, 2308, 2492, 2487, 2392, 2631, 2592, 2501, 2399, 2370, 2307, 2307, 2329, 
		2308, 2308, 2329, 2391, 2492, 2506, 2630, 2596, 2630, 2506, 2506, 2492, 2391, 2329, 2307, 2317, 
		2317, 2307, 2370, 2370, 2399, 2501, 2640, 2592, 2631, 2630, 2596, 2640, 2540, 2592, 2568, 2474, 
		2592, 2540, 2420, 2474, 2475, 2420, 2370, 2474, 2374, 2370, 2420, 2515, 2506, 2414, 2526, 2568, 
		2515, 2640, 2568, 2592, 2501, 2474, 2370, 2317, 2374, 2329, 2329, 2414, 2391, 2506, 2515, 2596, 
		2596, 2568, 2640, 2526, 2515, 2410, 2410, 2374, 2420, 2568, 2526, 2540, 2540, 2475, 2474, 2474, 
		2501, 2592, 2374, 2317, 2370, 2414, 2329, 2374, 2374, 2410, 2414, 2506, 2391, 2414, 2414, 2410, 
		2515, 2568, 2596, 2515, 2565, 2540, 2600, 2565, 2600, 2572, 2565, 2475, 2540, 2459, 2475, 2565, 
		2504, 2459, 2565, 2369, 2420, 2459, 2600, 2526, 2519, 2420, 2369, 2410, 2410, 2519, 2526, 2526, 
		2600, 2540, 2572, 2600, 2519, 2413, 2340, 2375, 2375, 2340, 2369, 2369, 2459, 2504, 2504, 2565, 
		2572, 2459, 2420, 2475, 2340, 2410, 2369, 2413, 2410, 2340, 2519, 2410, 2413, 2514, 2572, 2535, 
		2514, 2440, 2504, 2440, 2369, 2504, 2398, 2369, 2440, 2457, 2375, 2398, 2457, 2413, 2375, 2535, 
		2519, 2457, 2572, 2519, 2535, 2572, 2514, 2504, 2369, 2398, 2375, 2413, 2457, 2519, 2535, 2586, 
		2514, 2514, 2586, 2505, 2514, 2505, 2424, 2514, 2424, 2440, 2440, 2424, 2398, 2398, 2424, 2362, 
		2398, 2362, 2457, 2441, 2457, 2362, 2541, 2457, 2441, 2457, 2541, 2535, 2586, 2535, 2541, 2567, 
		2586, 2608, 2505, 2430, 2424, 2345, 2424, 2430, 2405, 2362, 2345, 2491, 2541, 2405, 2608, 2541, 
		2491, 2541, 2608, 2586, 2586, 2567, 2505, 2424, 2345, 2362, 2362, 2405, 2441, 2430, 2505, 2567, 
		2541, 2441, 2405, 2615, 2567, 2608, 2529, 2567, 2615, 2395, 2430, 2529, 2361, 2430, 2395, 2422, 
		2405, 2342, 2567, 2529, 2430, 2430, 2361, 2345, 2345, 2342, 2405, 2405, 2422, 2491, 2491, 2580, 
		2608, 2615, 2608, 2580, 2422, 2342, 2324, 2324, 2345, 2361, 2342, 2345, 2324, 2588, 2615, 2607, 
		2588, 2529, 2615, 2432, 2395, 2529, 2350, 2395, 2432, 2350, 2324, 2395, 2343, 2324, 2350, 2462, 
		2422, 2343, 2462, 2513, 2422, 2607, 2580, 2513, 2324, 2343, 2422, 2491, 2513, 2580, 2580, 2607, 
		2615, 2607, 2513, 2462, 2529, 2588, 2432, 2324, 2361, 2395, 2513, 2491, 2422, 2373, 2432, 2481, 
		2350, 2432, 2373, 2337, 2343, 2350, 2337, 2350, 2373, 2384, 2343, 2337, 2617, 2607, 2537, 2588, 
		2481, 2432, 2343, 2384, 2462, 2462, 2537, 2607, 2537, 2462, 2384, 2588, 2607, 2617, 2617, 2577, 
		2588, 2588, 2577, 2481, 2537, 2589, 2617, 2373, 2371, 2337, 2577, 2617, 2589, 2577, 2516, 2481, 
		2481, 2516, 2373, 2337, 2371, 2384, 2384, 2455, 2537, 2537, 2532, 2589, 2532, 2537, 2455, 2455, 
		2384, 2371, 2371, 2373, 2402, 2402, 2373, 2516, 2589, 2516, 2577, 2621, 2472, 2651, 2387, 2472, 
		2621, 2292, 2472, 2387, 2300, 2472, 2292, 2449, 2472, 2300, 2606, 2472, 2449, 2651, 2472, 2606, 
		2923, 2780, 2877, 2923, 2765, 2780, 2923, 2872, 2765, 3010, 2988, 2951, 2673, 2702, 2771, 2887, 
		2953, 2991, 3002, 2991, 2953, 2887, 2771, 2781, 2781, 2771, 2702, 2680, 2672, 2759, 2991, 3002, 
		3010, 2714, 2759, 2788, 2714, 2680, 2759, 3010, 2964, 2988, 2865, 2788, 2759, 2672, 2688, 2673, 
		2673, 2688, 2702, 2781, 2889, 2887, 2887, 2889, 2953, 2967, 2953, 2889, 2688, 2680, 2714, 2788, 
		2865, 2881, 2881, 2951, 2964, 2964, 3010, 2980, 2988, 2964, 2951, 2951, 2881, 2865, 2680, 2688, 
		2672, 2722, 2702, 2688, 2722, 2807, 2781, 2781, 2702, 2722, 2781, 2807, 2889, 2953, 2967, 3002, 
		3002, 2967, 2980, 2980, 3010, 3002, 2839, 2934, 2879, 2839, 2881, 2934, 2839, 2879, 2800, 2750, 
		2881, 2839, 2834, 2916, 2713, 2916, 2834, 2823, 2920, 2994, 2916, 2994, 2966, 3008, 3008, 2980, 
		2994, 2980, 3008, 2964, 2964, 2934, 2881, 2788, 2685, 2714, 2714, 2671, 2688, 2722, 2713, 2807, 
		2807, 2916, 2889, 2889, 2916, 2967, 2967, 2994, 2980, 2983, 3008, 2966, 2966, 2994, 2920, 2920, 
		2916, 2823, 2823, 2713, 2732, 2732, 2713, 2694, 2689, 2685, 2723, 2723, 2750, 2800, 2879, 2934, 
		2955, 2955, 3008, 2983, 3008, 2955, 2996, 2934, 2964, 2996, 2996, 2955, 2934, 2750, 2788, 2881, 
		2839, 2800, 2750, 2750, 2723, 2685, 2685, 2788, 2750, 2671, 2714, 2685, 2685, 2689, 2671, 2689, 
		2694, 2671, 2671, 2694, 2713, 2713, 2722, 2671, 2713, 2823, 2834, 2994, 2967, 2916, 3008, 2996, 
		2964, 2688, 2671, 2722, 2807, 2713, 2916, 2956, 2966, 2939, 2939, 2920, 2895, 2895, 2823, 2805, 
		2805, 2732, 2724, 2724, 2694, 2717, 2717, 2800, 2830, 2830, 2879, 2930, 2930, 2983, 2956, 2983, 
		2930, 2955, 2955, 2930, 2879, 2879, 2830, 2800, 2800, 2717, 2723, 2723, 2717, 2689, 2689, 2717, 
		2694, 2694, 2724, 2732, 2732, 2805, 2823, 2823, 2895, 2920, 2920, 2939, 2966, 2966, 2956, 2983, 
		2830, 2803, 2717, 2717, 2706, 2724, 2724, 2747, 2805, 2805, 2824, 2895, 2747, 2724, 2706, 2706, 
		2717, 2728, 2728, 2717, 2803, 2956, 2952, 2930, 2930, 2866, 2830, 2747, 2824, 2805, 2824, 2929, 
		2895, 2895, 2929, 2939, 2939, 2952, 2956, 2952, 2939, 2929, 2803, 2830, 2866, 2866, 2930, 2952, 
		2866, 2975, 2867, 2803, 2867, 2767, 2866, 2867, 2803, 2803, 2767, 2728, 2728, 2767, 2676, 2699, 
		2676, 2767, 2824, 2700, 2789, 2824, 2789, 2911, 2929, 2911, 2995, 2963, 2995, 2911, 2728, 2676, 
		2706, 2706, 2676, 2747, 2824, 2911, 2929, 2929, 2995, 2952, 2975, 2952, 2995, 2866, 2952, 2975, 
		2700, 2747, 2676, 2824, 2747, 2700, 2865, 3010, 2951, 3010, 2865, 2759, 2673, 3010, 2759, 2672, 
		2673, 2759, 2771, 3010, 2673, 2771, 2887, 2991, 2771, 2991, 3010, 2975, 2995, 2990, 2761, 2789, 
		2700, 2975, 2918, 2867, 2767, 2734, 2699, 2699, 2681, 2676, 2676, 2690, 2700, 2911, 2969, 2963, 
		2963, 2969, 2995, 2969, 2911, 2855, 2681, 2699, 2734, 2734, 2767, 2837, 2918, 2975, 2974, 2761, 
		2700, 2690, 2867, 2837, 2767, 2789, 2855, 2911, 2974, 2975, 2990, 2990, 2995, 2969, 2690, 2676, 
		2681, 2837, 2867, 2918, 2855, 2789, 2761, 2943, 2990, 2970, 2923, 2943, 2970, 2893, 2974, 2943, 
		2893, 2918, 2974, 2877, 2893, 2943, 2893, 2837, 2918, 2776, 2837, 2893, 2877, 2776, 2893, 2780, 
		2776, 2877, 2695, 2734, 2776, 2695, 2776, 2780, 2695, 2681, 2734, 2720, 2690, 2681, 2720, 2681, 
		2695, 2791, 2761, 2690, 2791, 2690, 2720, 2765, 2791, 2720, 2872, 2791, 2765, 2872, 2919, 2791, 
		2970, 2919, 2872, 2970, 2969, 2919, 2923, 2970, 2872, 2765, 2695, 2780, 2877, 2943, 2923, 2855, 
		2919, 2969, 2837, 2776, 2734, 2990, 2943, 2974, 2695, 2765, 2720, 2791, 2855, 2761, 2855, 2791, 
		2919, 2970, 2990, 2969, 143, 85, 203, 276, 143, 203, 276, 187, 143, 274, 237, 145, 
		26, 56, 123, 123, 225, 281, 360, 281, 311, 311, 281, 225, 225, 123, 136, 136, 
		123, 56, 26, 17, 18, 237, 274, 348, 217, 237, 285, 58, 59, 141, 368, 326, 
		348, 348, 285, 237, 237, 141, 145, 145, 141, 59, 59, 58, 17, 18, 50, 26, 
		360, 328, 368, 328, 311, 259, 259, 225, 154, 154, 56, 50, 326, 368, 339, 326, 
		285, 348, 141, 237, 217, 58, 30, 18, 18, 17, 58, 18, 30, 50, 56, 26, 
		50, 56, 154, 136, 136, 154, 225, 225, 259, 311, 328, 360, 311, 339, 368, 328, 
		217, 285, 326, 356, 339, 366, 199, 291, 196, 25, 30, 16, 42, 16, 34, 42, 
		25, 16, 223, 102, 171, 223, 154, 102, 256, 344, 223, 328, 344, 366, 344, 324, 
		366, 339, 356, 326, 326, 291, 217, 217, 199, 141, 141, 27, 58, 58, 16, 30, 
		50, 102, 154, 259, 344, 328, 328, 366, 339, 340, 366, 324, 324, 344, 256, 256, 
		223, 171, 171, 102, 88, 88, 25, 42, 34, 27, 86, 86, 96, 196, 196, 291, 
		312, 312, 366, 340, 366, 312, 356, 291, 326, 356, 356, 312, 291, 199, 217, 291, 
		96, 141, 199, 199, 196, 96, 96, 86, 27, 27, 141, 96, 27, 34, 16, 102, 
		50, 25, 25, 88, 102, 223, 259, 154, 344, 259, 223, 27, 16, 58, 30, 25, 
		50, 316, 256, 224, 224, 171, 116, 116, 88, 64, 64, 34, 72, 72, 86, 131, 
		131, 196, 195, 195, 196, 290, 290, 340, 316, 340, 290, 312, 312, 290, 196, 196, 
		131, 86, 86, 72, 34, 34, 64, 42, 42, 64, 88, 88, 116, 171, 171, 224, 
		256, 256, 316, 324, 324, 316, 340, 116, 213, 224, 224, 272, 316, 306, 316, 272, 
		272, 224, 213, 290, 316, 306, 290, 250, 195, 195, 117, 131, 131, 117, 72, 72, 
		62, 64, 64, 106, 116, 116, 106, 213, 106, 64, 62, 62, 72, 117, 117, 195, 
		250, 250, 290, 306, 354, 299, 250, 65, 117, 181, 65, 21, 62, 54, 62, 21, 
		62, 54, 106, 125, 106, 54, 106, 125, 213, 226, 213, 125, 213, 226, 272, 319, 
		272, 226, 272, 319, 354, 250, 181, 117, 272, 354, 306, 250, 306, 354, 181, 250, 
		299, 62, 117, 65, 348, 274, 368, 123, 368, 274, 274, 17, 123, 274, 145, 17, 
		17, 145, 59, 17, 26, 123, 281, 368, 123, 360, 368, 281, 90, 125, 54, 354, 
		330, 299, 181, 91, 65, 65, 33, 21, 21, 36, 54, 319, 338, 354, 284, 226, 
		185, 33, 65, 91, 91, 181, 175, 255, 299, 330, 90, 54, 36, 299, 255, 181, 
		125, 185, 226, 226, 284, 319, 338, 319, 284, 330, 354, 347, 347, 354, 338, 36, 
		21, 28, 28, 21, 33, 175, 181, 255, 185, 125, 90, 305, 330, 347, 276, 305, 
		347, 249, 330, 305, 203, 249, 305, 203, 175, 249, 78, 91, 175, 203, 78, 175, 
		85, 47, 78, 47, 33, 78, 74, 36, 28, 74, 28, 47, 74, 47, 85, 74, 
		90, 36, 143, 187, 74, 187, 90, 74, 187, 185, 90, 254, 185, 187, 254, 338, 
		284, 276, 254, 187, 276, 338, 254, 276, 347, 338, 143, 74, 85, 85, 78, 203, 
		203, 305, 276, 91, 78, 33, 330, 249, 255, 175, 255, 249, 254, 284, 185, 33, 
		47, 28, 2948, 2792, 2922, 2864, 2783, 2792, 2948, 2864, 2792, 3013, 3007, 2971, 2971, 2892, 
		2787, 2711, 2811, 2871, 2892, 2971, 2942, 2736, 2787, 2833, 2736, 2698, 2787, 2950, 2961, 2903, 
		3013, 3003, 3007, 2892, 2833, 2787, 2675, 2705, 2711, 2811, 2903, 2871, 2871, 2903, 2961, 2961, 
		2950, 3011, 3011, 2997, 3013, 2950, 2903, 2831, 2705, 2675, 2736, 2833, 2892, 2942, 2942, 3007, 
		3003, 2942, 2971, 3007, 2698, 2736, 2675, 2749, 2711, 2705, 2749, 2831, 2811, 2811, 2711, 2749, 
		2811, 2831, 2903, 2997, 3011, 2950, 3003, 3013, 2997, 3003, 3001, 2942, 2942, 2891, 2833, 2891, 
		2942, 3001, 3001, 3003, 3012, 2998, 3001, 3012, 2819, 2891, 2998, 2819, 2998, 2913, 2819, 2913, 
		2825, 2757, 2682, 2718, 2682, 2704, 2683, 2683, 2705, 2682, 2894, 2756, 2844, 2936, 3005, 2894, 
		3005, 2989, 3012, 3001, 2998, 2891, 2833, 2819, 2736, 2736, 2682, 2705, 2749, 2756, 2831, 2950, 
		3005, 2997, 2997, 3012, 3003, 3004, 3012, 2989, 2989, 3005, 2936, 2936, 2894, 2844, 2844, 2756, 
		2768, 2768, 2756, 2719, 2757, 2819, 2825, 2913, 2998, 2979, 2979, 3012, 3004, 3012, 2979, 2998, 
		2819, 2833, 2891, 2819, 2757, 2718, 2682, 2736, 2718, 2757, 2704, 2682, 2704, 2719, 2683, 2683, 
		2719, 2756, 2756, 2749, 2683, 2894, 2831, 2756, 2894, 2950, 2831, 3005, 2950, 2894, 2819, 2718, 
		2736, 2705, 2683, 2749, 2997, 3005, 3012, 2977, 3004, 2965, 2965, 2936, 2908, 2908, 2844, 2816, 
		2816, 2768, 2731, 2731, 2704, 2763, 2763, 2757, 2817, 2817, 2825, 2900, 2900, 2979, 2958, 2958, 
		3004, 2977, 3004, 2958, 2979, 2979, 2900, 2913, 2913, 2900, 2825, 2825, 2817, 2757, 2757, 2763, 
		2704, 2704, 2731, 2719, 2719, 2731, 2768, 2768, 2816, 2844, 2844, 2908, 2936, 2936, 2965, 2989, 
		2989, 2965, 3004, 2763, 2748, 2731, 2816, 2899, 2908, 2958, 2957, 2900, 2900, 2878, 2817, 2817, 
		2804, 2763, 2748, 2744, 2731, 2731, 2799, 2816, 2816, 2799, 2899, 2908, 2899, 2965, 2972, 2965, 
		2899, 2799, 2731, 2744, 2748, 2763, 2804, 2804, 2817, 2878, 2878, 2900, 2957, 2957, 2977, 2972, 
		2977, 2957, 2958, 2965, 2972, 2977, 3009, 2968, 2957, 2878, 2968, 2851, 2878, 2851, 2804, 2738, 
		2804, 2851, 2804, 2738, 2692, 2799, 2727, 2801, 2799, 2801, 2873, 2799, 2873, 2899, 2973, 2899, 
		2873, 2899, 2973, 3009, 2972, 3009, 2957, 2804, 2692, 2748, 2748, 2692, 2744, 2744, 2692, 2799, 
		2878, 2957, 2968, 2727, 2799, 2692, 3009, 2972, 2899, 3013, 2971, 2698, 2698, 2971, 2787, 2675, 
		2711, 2698, 2871, 3013, 2698, 2698, 2711, 2871, 3011, 3013, 2961, 2871, 2961, 3013, 2786, 2801, 
		2727, 3009, 2999, 2968, 2851, 2770, 2738, 2738, 2709, 2692, 2692, 2710, 2727, 2873, 2884, 2973, 
		2973, 3000, 3009, 2976, 2973, 2884, 2709, 2738, 2770, 2770, 2851, 2852, 2935, 2968, 2999, 2786, 
		2727, 2710, 2968, 2935, 2851, 2801, 2884, 2873, 3000, 2973, 2976, 2999, 3009, 3006, 3006, 3009, 
		3000, 2710, 2692, 2697, 2697, 2692, 2709, 2852, 2851, 2935, 2884, 2801, 2786, 2999, 3006, 2948, 
		2922, 2999, 2948, 2922, 2935, 2999, 2802, 2852, 2935, 2922, 2802, 2935, 2792, 2802, 2922, 2802, 
		2709, 2770, 2792, 2709, 2802, 2733, 2709, 2792, 2733, 2697, 2709, 2733, 2710, 2697, 2733, 2786, 
		2710, 2864, 2828, 2733, 2828, 2786, 2733, 2864, 2928, 2828, 2928, 3000, 2976, 2948, 2928, 2864, 
		2948, 3000, 2928, 2948, 3006, 3000, 2864, 2733, 2783, 2884, 2928, 2976, 2852, 2802, 2770, 2792, 
		2783, 2733, 2828, 2884, 2786, 2884, 2828, 2928, 99, 183, 278, 278, 142, 99, 359, 313, 
		251, 251, 229, 105, 24, 20, 19, 51, 139, 194, 361, 283, 314, 314, 283, 194, 
		24, 105, 57, 57, 105, 130, 130, 105, 229, 229, 251, 313, 369, 325, 359, 20, 
		41, 19, 19, 41, 51, 139, 244, 194, 194, 244, 314, 361, 331, 369, 341, 369, 
		331, 331, 314, 244, 31, 20, 76, 76, 130, 144, 144, 229, 231, 231, 313, 325, 
		325, 369, 341, 313, 359, 325, 313, 231, 229, 229, 144, 130, 130, 76, 57, 57, 
		76, 20, 20, 24, 57, 20, 31, 41, 73, 51, 41, 73, 155, 139, 139, 51, 
		73, 139, 155, 244, 331, 361, 314, 367, 355, 341, 186, 287, 197, 186, 231, 287, 
		83, 144, 231, 83, 231, 186, 22, 76, 83, 76, 22, 15, 15, 49, 41, 232, 
		138, 169, 232, 155, 138, 307, 345, 232, 345, 367, 331, 345, 307, 367, 367, 341, 
		331, 325, 287, 231, 76, 15, 31, 73, 49, 155, 244, 345, 331, 342, 367, 307, 
		307, 232, 169, 169, 138, 61, 39, 22, 87, 87, 83, 197, 197, 287, 315, 315, 
		367, 342, 367, 315, 355, 287, 325, 355, 355, 315, 287, 186, 197, 83, 76, 144, 
		83, 83, 87, 22, 22, 39, 15, 41, 31, 15, 39, 61, 15, 15, 61, 49, 
		138, 155, 49, 49, 61, 138, 232, 244, 155, 345, 244, 232, 341, 355, 325, 41, 
		49, 73, 169, 247, 307, 317, 342, 301, 301, 307, 247, 170, 169, 101, 101, 61, 
		53, 53, 39, 109, 109, 197, 214, 214, 315, 294, 294, 342, 317, 342, 294, 315, 
		315, 214, 197, 197, 109, 87, 87, 109, 39, 39, 53, 61, 61, 101, 169, 169, 
		170, 247, 307, 301, 342, 294, 233, 214, 214, 161, 109, 109, 97, 53, 170, 221, 
		247, 301, 247, 221, 67, 53, 97, 97, 109, 161, 161, 214, 233, 317, 310, 294, 
		294, 310, 233, 53, 114, 101, 101, 114, 170, 221, 293, 301, 301, 310, 317, 310, 
		301, 293, 221, 170, 114, 114, 53, 67, 303, 310, 353, 310, 303, 233, 233, 303, 
		180, 68, 97, 180, 67, 23, 114, 55, 114, 23, 293, 292, 346, 293, 346, 353, 
		233, 180, 161, 97, 68, 67, 114, 128, 221, 293, 353, 310, 97, 161, 180, 23, 
		67, 68, 128, 114, 55, 209, 221, 128, 292, 221, 209, 293, 221, 292, 369, 359, 
		251, 105, 369, 251, 19, 51, 24, 105, 24, 51, 51, 369, 105, 51, 194, 283, 
		283, 369, 51, 361, 369, 283, 75, 128, 55, 349, 353, 346, 353, 332, 303, 180, 
		92, 68, 68, 38, 23, 23, 29, 55, 209, 261, 292, 292, 333, 346, 261, 209, 
		178, 38, 68, 92, 92, 180, 182, 253, 303, 332, 75, 55, 29, 303, 253, 180, 
		75, 178, 128, 128, 178, 209, 292, 261, 333, 332, 353, 349, 349, 346, 333, 29, 
		23, 38, 182, 180, 253, 253, 332, 182, 302, 349, 329, 246, 332, 302, 183, 246, 
		302, 124, 182, 246, 183, 124, 246, 124, 38, 92, 99, 38, 124, 52, 38, 99, 
		52, 29, 38, 52, 75, 29, 137, 52, 142, 137, 75, 52, 257, 178, 137, 142, 
		257, 137, 278, 257, 142, 257, 333, 261, 329, 333, 257, 278, 329, 257, 349, 333, 
		329, 99, 124, 183, 183, 302, 278, 182, 124, 92, 349, 302, 332, 332, 246, 182, 
		75, 137, 178, 329, 278, 302, 99, 142, 52, 257, 261, 178, 108, 288, 358, 201, 
		108, 358, 201, 66, 108, 242, 153, 66, 201, 242, 66, 201, 358, 242, 66, 37, 
		108, 358, 350, 242, 271, 275, 308, 239, 275, 271, 164, 239, 271, 164, 200, 239, 
		104, 200, 164, 165, 104, 164, 104, 94, 132, 129, 132, 94, 132, 129, 207, 222, 
		207, 129, 297, 215, 207, 222, 297, 207, 297, 275, 215, 308, 297, 222, 297, 308, 
		275, 275, 239, 200, 200, 104, 132, 132, 207, 215, 222, 129, 150, 165, 271, 243, 
		243, 271, 258, 308, 258, 271, 271, 165, 164, 165, 150, 104, 104, 150, 94, 94, 
		150, 129, 222, 258, 308, 296, 258, 266, 296, 266, 321, 227, 243, 258, 227, 258, 
		296, 166, 165, 243, 227, 166, 243, 166, 227, 211, 120, 165, 166, 77, 120, 166, 
		120, 150, 165, 173, 150, 120, 173, 222, 150, 245, 222, 173, 321, 222, 245, 321, 
		266, 222, 266, 258, 222, 184, 173, 100, 100, 120, 77, 77, 166, 110, 110, 166, 
		211, 211, 227, 296, 120, 100, 173, 173, 184, 245, 362, 296, 321, 279, 296, 362, 
		44, 77, 110, 362, 321, 335, 252, 184, 151, 163, 211, 279, 211, 296, 279, 211, 
		163, 110, 77, 44, 100, 100, 151, 184, 184, 252, 335, 335, 245, 184, 321, 245, 
		335, 320, 279, 362, 69, 44, 81, 69, 63, 44, 163, 81, 110, 110, 81, 44, 
		336, 335, 304, 304, 252, 189, 189, 151, 103, 103, 63, 69, 69, 81, 127, 127, 
		163, 206, 206, 279, 320, 320, 362, 336, 279, 206, 163, 163, 127, 81, 63, 100, 
		44, 151, 100, 63, 63, 103, 151, 151, 189, 252, 252, 304, 335, 335, 336, 362, 
		364, 320, 336, 364, 358, 351, 351, 320, 364, 282, 320, 351, 351, 288, 282, 174, 
		206, 282, 174, 282, 288, 93, 127, 206, 93, 206, 174, 84, 93, 174, 40, 69, 
		93, 40, 93, 84, 40, 84, 37, 35, 69, 40, 40, 37, 35, 66, 89, 35, 
		66, 35, 37, 119, 89, 66, 153, 119, 66, 119, 189, 89, 242, 189, 119, 242, 
		119, 153, 242, 264, 189, 334, 304, 264, 334, 264, 242, 350, 334, 242, 364, 304, 
		334, 364, 334, 350, 364, 336, 304, 364, 350, 358, 69, 35, 103, 103, 89, 189, 
		189, 264, 304, 108, 174, 288, 288, 351, 358, 206, 320, 282, 174, 108, 84, 69, 
		127, 93, 84, 108, 37, 89, 103, 35, 268, 262, 300, 179, 220, 262, 216, 179, 
		262, 216, 262, 268, 200, 216, 268, 167, 216, 200, 179, 176, 220, 167, 179, 216, 
		115, 179, 167, 134, 176, 179, 115, 134, 179, 121, 134, 115, 121, 176, 134, 162, 
		235, 176, 162, 176, 121, 235, 220, 176, 241, 235, 162, 300, 235, 241, 262, 220, 
		235, 300, 262, 235, 275, 300, 215, 215, 162, 132, 132, 167, 200, 200, 268, 275, 
		300, 275, 268, 167, 132, 115, 115, 132, 121, 121, 132, 162, 162, 215, 241, 241, 
		215, 300, 1300, 1399, 1485, 1300, 1202, 1399, 1300, 1103, 1202, 1300, 1181, 1103, 1300, 1408, 
		1181, 1300, 1485, 1408, 1485, 1479, 1408, 1278, 1360, 1443, 1278, 1339, 1360, 1236, 1169, 1278, 
		1161, 1209, 1169, 1311, 1286, 1161, 1260, 1311, 1161, 1260, 1411, 1311, 1335, 1411, 1260, 1311, 
		1394, 1286, 1311, 1411, 1394, 1443, 1394, 1411, 1394, 1443, 1339, 1228, 1169, 1209, 1376, 1443, 
		1335, 1335, 1260, 1221, 1315, 1443, 1376, 1360, 1339, 1443, 1443, 1315, 1278, 1278, 1315, 1236, 
		1278, 1228, 1339, 1169, 1228, 1278, 1236, 1221, 1169, 1169, 1221, 1161, 1286, 1209, 1161, 1161, 
		1221, 1260, 1411, 1335, 1443, 1420, 1376, 1409, 1420, 1409, 1487, 1358, 1376, 1420, 1376, 1358, 
		1315, 1330, 1315, 1358, 1330, 1242, 1315, 1242, 1236, 1315, 1139, 1236, 1242, 1200, 1221, 1236, 
		1139, 1200, 1236, 1258, 1221, 1200, 1258, 1335, 1221, 1368, 1335, 1258, 1368, 1258, 1282, 1409, 
		1335, 1368, 1409, 1376, 1335, 1282, 1258, 1200, 1139, 1242, 1163, 1420, 1373, 1358, 1358, 1373, 
		1330, 1330, 1163, 1242, 1476, 1420, 1487, 1373, 1420, 1476, 1144, 1139, 1100, 1487, 1409, 1470, 
		1200, 1144, 1282, 1357, 1282, 1215, 1330, 1373, 1476, 1330, 1249, 1163, 1144, 1200, 1139, 1144, 
		1215, 1282, 1282, 1357, 1470, 1470, 1368, 1282, 1409, 1368, 1470, 1476, 1487, 1477, 1249, 1330, 
		1402, 1198, 1163, 1249, 1100, 1163, 1198, 1136, 1100, 1198, 1251, 1357, 1215, 1393, 1357, 1251, 
		1393, 1470, 1357, 1477, 1487, 1470, 1476, 1402, 1330, 1477, 1470, 1393, 1251, 1144, 1140, 1140, 
		1100, 1136, 1198, 1249, 1413, 1477, 1413, 1476, 1476, 1413, 1402, 1402, 1413, 1249, 1100, 1139, 
		1163, 1100, 1140, 1144, 1144, 1251, 1215, 1499, 1477, 1505, 1450, 1413, 1499, 1450, 1338, 1413, 
		1338, 1450, 1399, 1198, 1413, 1338, 1223, 1338, 1399, 1223, 1198, 1338, 1202, 1223, 1399, 1150, 
		1198, 1223, 1113, 1150, 1223, 1113, 1223, 1202, 1113, 1136, 1150, 1104, 1136, 1113, 1113, 1103, 
		1104, 1104, 1103, 1106, 1152, 1104, 1106, 1181, 1152, 1106, 1152, 1181, 1291, 1291, 1251, 1152, 
		1385, 1393, 1251, 1385, 1251, 1291, 1408, 1385, 1291, 1479, 1459, 1385, 1385, 1408, 1479, 1505, 
		1459, 1479, 1505, 1477, 1459, 1477, 1499, 1413, 1198, 1150, 1136, 1136, 1104, 1140, 1140, 1152, 
		1251, 1393, 1459, 1477, 1408, 1291, 1181, 1181, 1106, 1103, 1399, 1499, 1485, 1485, 1499, 1505, 
		1505, 1479, 1485, 1499, 1399, 1450, 1113, 1202, 1103, 1152, 1140, 1104, 1459, 1393, 1385, 1329, 
		1316, 1419, 1380, 1329, 1419, 1418, 1380, 1419, 1314, 1329, 1380, 1254, 1314, 1380, 1217, 1329, 
		1314, 1254, 1217, 1314, 1217, 1316, 1329, 1182, 1217, 1254, 1235, 1316, 1217, 1180, 1235, 1217, 
		1180, 1217, 1182, 1209, 1180, 1182, 1243, 1235, 1180, 1243, 1180, 1209, 1286, 1243, 1209, 1292, 
		1235, 1243, 1369, 1292, 1243, 1316, 1235, 1292, 1369, 1316, 1292, 1419, 1316, 1369, 1415, 1419, 
		1369, 1418, 1419, 1415, 1394, 1369, 1286, 1209, 1182, 1228, 1228, 1254, 1339, 1339, 1418, 1394, 
		1418, 1339, 1380, 1380, 1339, 1254, 1254, 1228, 1182, 1243, 1286, 1369, 1369, 1394, 1415, 1415, 
		1394, 1418, 1645, 1893, 1936, 1739, 1645, 1936, 1739, 1618, 1645, 1739, 1831, 1618, 1739, 1936, 
		1831, 1618, 1540, 1645, 1936, 1924, 1831, 1675, 1790, 1782, 1698, 1675, 1782, 1616, 1675, 1698, 
		1688, 1616, 1698, 1603, 1675, 1616, 1752, 1670, 1603, 1704, 1752, 1603, 1859, 1752, 1704, 1769, 
		1859, 1704, 1859, 1862, 1752, 1862, 1839, 1771, 1877, 1839, 1862, 1859, 1877, 1862, 1839, 1877, 
		1790, 1670, 1752, 1771, 1808, 1859, 1769, 1769, 1704, 1668, 1757, 1877, 1808, 1859, 1808, 1877, 
		1782, 1790, 1877, 1877, 1757, 1782, 1782, 1757, 1698, 1698, 1757, 1688, 1688, 1668, 1616, 1603, 
		1670, 1675, 1616, 1668, 1603, 1603, 1668, 1704, 1862, 1771, 1752, 1775, 1808, 1854, 1775, 1854, 
		1868, 1808, 1775, 1757, 1658, 1757, 1775, 1641, 1658, 1775, 1658, 1688, 1757, 1602, 1688, 1658, 
		1602, 1668, 1688, 1703, 1668, 1602, 1783, 1769, 1668, 1783, 1668, 1703, 1811, 1769, 1783, 1896, 
		1811, 1783, 1811, 1808, 1769, 1854, 1811, 1896, 1854, 1808, 1811, 1641, 1775, 1796, 1796, 1775, 
		1868, 1896, 1868, 1854, 1602, 1590, 1703, 1943, 1868, 1896, 1796, 1868, 1943, 1538, 1658, 1641, 
		1602, 1658, 1538, 1943, 1896, 1911, 1791, 1703, 1663, 1796, 1692, 1641, 1602, 1538, 1590, 1590, 
		1663, 1703, 1703, 1791, 1911, 1911, 1783, 1703, 1896, 1783, 1911, 1692, 1796, 1866, 1743, 1791, 
		1663, 1743, 1911, 1791, 1943, 1866, 1796, 1692, 1581, 1641, 1641, 1581, 1538, 1913, 1911, 1743, 
		1743, 1590, 1589, 1589, 1538, 1571, 1571, 1581, 1741, 1741, 1866, 1895, 1895, 1943, 1913, 1943, 
		1895, 1866, 1866, 1741, 1692, 1692, 1741, 1581, 1581, 1571, 1538, 1538, 1589, 1590, 1590, 1743, 
		1663, 1911, 1913, 1943, 1951, 1895, 1913, 1892, 1895, 1951, 1893, 1892, 1951, 1803, 1892, 1893, 
		1753, 1892, 1803, 1645, 1753, 1803, 1595, 1741, 1753, 1587, 1595, 1753, 1753, 1645, 1587, 1533, 
		1595, 1587, 1533, 1587, 1540, 1533, 1571, 1595, 1556, 1589, 1533, 1556, 1533, 1540, 1556, 1662, 
		1589, 1556, 1618, 1662, 1762, 1743, 1662, 1762, 1662, 1618, 1870, 1743, 1762, 1831, 1870, 1762, 
		1927, 1870, 1831, 1924, 1927, 1831, 1927, 1913, 1870, 1951, 1913, 1927, 1951, 1924, 1936, 1927, 
		1924, 1951, 1895, 1892, 1741, 1741, 1595, 1571, 1571, 1533, 1589, 1743, 1870, 1913, 1831, 1762, 
		1618, 1618, 1556, 1540, 1645, 1803, 1893, 1893, 1951, 1936, 1753, 1741, 1892, 1587, 1645, 1540, 
		1662, 1743, 1589, 1825, 1789, 1869, 1790, 1825, 1869, 1749, 1789, 1825, 1749, 1825, 1790, 1694, 
		1749, 1790, 1749, 1707, 1789, 1694, 1639, 1749, 1639, 1707, 1749, 1620, 1639, 1694, 1630, 1639, 
		1620, 1630, 1707, 1639, 1736, 1707, 1630, 1687, 1736, 1630, 1771, 1736, 1687, 1789, 1707, 1736, 
		1821, 1789, 1736, 1821, 1736, 1771, 1869, 1789, 1821, 1839, 1869, 1821, 1670, 1620, 1675, 1675, 
		1694, 1790, 1790, 1869, 1839, 1694, 1675, 1620, 1620, 1670, 1630, 1630, 1670, 1687, 1687, 1670, 
		1771, 1821, 1771, 1839, 918, 1022, 1063, 918, 900, 1022, 764, 804, 900, 918, 764, 900, 
		808, 764, 918, 918, 1063, 808, 1063, 1013, 808, 992, 1026, 1035, 917, 1026, 897, 992, 
		897, 1026, 803, 917, 897, 864, 803, 897, 803, 802, 824, 871, 824, 802, 961, 871, 
		802, 871, 936, 824, 970, 936, 871, 961, 970, 871, 1035, 936, 970, 961, 1035, 970, 
		1035, 1003, 936, 1026, 1003, 1035, 1003, 1026, 917, 917, 803, 824, 988, 1035, 977, 977, 
		961, 884, 884, 802, 864, 864, 992, 988, 1035, 988, 992, 992, 864, 897, 803, 864, 
		802, 802, 884, 961, 961, 977, 1035, 1020, 997, 1060, 983, 988, 997, 983, 997, 1020, 
		899, 988, 983, 899, 864, 988, 841, 899, 983, 816, 864, 899, 816, 899, 841, 838, 
		864, 816, 838, 884, 864, 838, 977, 884, 967, 977, 838, 905, 967, 838, 1029, 977, 
		967, 997, 977, 1029, 997, 988, 977, 1060, 997, 1029, 905, 838, 794, 794, 838, 775, 
		816, 775, 838, 1053, 1020, 1060, 995, 1020, 1053, 775, 816, 841, 1060, 1029, 1050, 981, 
		905, 849, 888, 841, 995, 995, 983, 1020, 841, 983, 995, 794, 849, 905, 905, 981, 
		1050, 1050, 967, 905, 1029, 967, 1050, 1053, 1060, 1051, 773, 775, 791, 892, 981, 849, 
		999, 981, 892, 999, 1050, 981, 1051, 1060, 1050, 888, 791, 841, 841, 791, 775, 1051, 
		1050, 999, 892, 794, 773, 788, 791, 828, 828, 888, 1014, 1051, 1014, 1053, 1053, 1014, 
		995, 995, 1014, 888, 888, 828, 791, 791, 788, 773, 794, 775, 773, 794, 892, 849, 
		1064, 1067, 1063, 1011, 1014, 1064, 1064, 1022, 1011, 857, 1014, 1011, 900, 1011, 1022, 1011, 
		900, 857, 804, 857, 900, 769, 788, 857, 769, 857, 804, 765, 788, 769, 769, 764, 
		765, 765, 764, 766, 796, 765, 766, 808, 796, 766, 870, 796, 808, 870, 892, 796, 
		980, 892, 870, 980, 999, 892, 1057, 1045, 980, 980, 1013, 1057, 1063, 1057, 1013, 1057, 
		1067, 1045, 1057, 1063, 1067, 1051, 1064, 1014, 1014, 857, 828, 788, 765, 773, 773, 796, 
		892, 999, 1045, 1051, 1013, 980, 808, 808, 766, 764, 1022, 1064, 1063, 1064, 1051, 1067, 
		788, 828, 857, 769, 804, 764, 796, 773, 765, 870, 808, 980, 1045, 999, 980, 1067, 
		1051, 1045, 1004, 996, 1027, 913, 951, 996, 922, 913, 996, 922, 996, 1004, 913, 896, 
		951, 843, 913, 922, 843, 825, 913, 825, 896, 913, 812, 825, 843, 813, 825, 812, 
		813, 896, 825, 889, 969, 896, 889, 896, 813, 969, 951, 896, 973, 969, 889, 1027, 
		969, 973, 996, 951, 969, 1027, 996, 969, 1003, 1027, 936, 936, 889, 824, 824, 843, 
		917, 917, 1004, 1003, 1027, 1003, 1004, 1004, 917, 922, 922, 917, 843, 843, 824, 812, 
		812, 824, 813, 813, 824, 889, 889, 936, 973, 973, 936, 1027, 430, 682, 742, 566, 
		430, 742, 566, 380, 430, 438, 380, 566, 566, 678, 438, 566, 742, 678, 715, 691, 
		672, 672, 691, 570, 585, 570, 691, 570, 585, 521, 547, 421, 521, 483, 421, 547, 
		416, 455, 421, 608, 455, 416, 608, 599, 455, 592, 608, 531, 608, 715, 599, 570, 
		521, 477, 477, 421, 494, 599, 715, 672, 638, 715, 592, 531, 416, 483, 547, 585, 
		638, 715, 638, 691, 691, 638, 585, 585, 547, 521, 421, 477, 521, 455, 494, 421, 
		421, 483, 416, 416, 531, 608, 599, 494, 455, 608, 592, 715, 707, 666, 731, 618, 
		638, 666, 618, 564, 638, 618, 666, 707, 564, 547, 638, 503, 564, 618, 460, 547, 
		564, 460, 483, 547, 460, 465, 483, 465, 460, 391, 465, 531, 483, 507, 531, 465, 
		592, 531, 507, 613, 592, 507, 666, 592, 613, 666, 638, 592, 731, 666, 721, 721, 
		666, 613, 538, 507, 428, 428, 465, 391, 391, 460, 408, 408, 564, 503, 564, 408, 
		460, 465, 428, 507, 507, 538, 613, 538, 428, 389, 389, 428, 391, 655, 618, 707, 
		618, 655, 503, 538, 645, 721, 721, 613, 538, 688, 655, 741, 546, 655, 688, 546, 
		503, 655, 401, 503, 546, 401, 408, 503, 389, 391, 401, 557, 504, 389, 741, 731, 
		721, 723, 741, 721, 723, 721, 557, 403, 401, 399, 399, 401, 419, 546, 688, 700, 
		700, 741, 723, 741, 707, 731, 655, 707, 741, 741, 700, 688, 546, 419, 401, 391, 
		408, 401, 401, 403, 389, 504, 538, 389, 389, 403, 557, 645, 538, 504, 504, 557, 
		645, 645, 557, 721, 740, 736, 742, 710, 700, 740, 682, 710, 740, 710, 682, 602, 
		602, 546, 700, 602, 700, 710, 530, 602, 682, 530, 475, 602, 430, 475, 530, 388, 
		419, 475, 388, 475, 430, 388, 399, 419, 384, 399, 388, 380, 384, 388, 384, 403, 
		399, 414, 384, 380, 414, 403, 384, 438, 414, 380, 498, 414, 438, 498, 557, 414, 
		616, 557, 498, 616, 670, 557, 734, 670, 616, 616, 678, 734, 734, 736, 670, 742, 
		734, 678, 742, 736, 734, 723, 740, 700, 546, 475, 419, 403, 414, 557, 557, 670, 
		723, 678, 616, 438, 380, 388, 430, 430, 530, 682, 682, 740, 742, 740, 723, 736, 
		475, 546, 602, 498, 438, 616, 736, 723, 670, 664, 619, 689, 664, 689, 672, 577, 
		619, 664, 570, 577, 664, 577, 515, 619, 482, 577, 570, 482, 515, 577, 447, 515, 
		482, 477, 447, 482, 450, 447, 477, 494, 450, 477, 558, 619, 515, 450, 515, 447, 
		450, 558, 515, 514, 450, 494, 514, 558, 450, 609, 558, 514, 609, 665, 558, 665, 
		619, 558, 689, 619, 665, 672, 665, 609, 672, 689, 665, 599, 609, 494, 570, 664, 
		672, 570, 477, 482, 514, 494, 609, 609, 599, 672, 2737, 2921, 2981, 2835, 2737, 2981, 
		2835, 2677, 2737, 2858, 2677, 2835, 2858, 2715, 2677, 2835, 2962, 2858, 2835, 2981, 2962, 2914, 
		2933, 2829, 2863, 2933, 2898, 2863, 2829, 2933, 2806, 2829, 2863, 2742, 2829, 2806, 2829, 2742, 
		2766, 2813, 2742, 2806, 2762, 2766, 2742, 2729, 2762, 2742, 2762, 2729, 2793, 2793, 2729, 2820, 
		2793, 2820, 2876, 2847, 2876, 2820, 2898, 2931, 2876, 2931, 2914, 2868, 2931, 2933, 2914, 2933, 
		2931, 2898, 2793, 2876, 2868, 2847, 2729, 2778, 2813, 2863, 2898, 2863, 2813, 2806, 2813, 2778, 
		2742, 2742, 2778, 2729, 2729, 2847, 2820, 2931, 2868, 2876, 2876, 2847, 2898, 2909, 2902, 2947, 
		2860, 2898, 2909, 2860, 2813, 2898, 2746, 2813, 2860, 2746, 2860, 2840, 2755, 2813, 2746, 2753, 
		2813, 2755, 2753, 2778, 2813, 2707, 2753, 2755, 2795, 2778, 2753, 2778, 2795, 2847, 2850, 2847, 
		2795, 2874, 2850, 2795, 2902, 2847, 2850, 2947, 2850, 2874, 2947, 2902, 2850, 2902, 2898, 2847, 
		2909, 2898, 2902, 2821, 2795, 2707, 2840, 2860, 2941, 2947, 2941, 2909, 2909, 2941, 2860, 2753, 
		2707, 2795, 2795, 2821, 2874, 2678, 2755, 2746, 2707, 2755, 2678, 2978, 2947, 2959, 2882, 2821, 
		2740, 2740, 2707, 2678, 2798, 2840, 2890, 2941, 2947, 2978, 2941, 2890, 2840, 2840, 2798, 2746, 
		2707, 2740, 2821, 2821, 2882, 2959, 2959, 2874, 2821, 2947, 2874, 2959, 2777, 2882, 2740, 2960, 
		2978, 2959, 2941, 2978, 2890, 2798, 2708, 2746, 2746, 2708, 2678, 2960, 2959, 2938, 2938, 2959, 
		2857, 2777, 2740, 2716, 2716, 2678, 2691, 2691, 2708, 2730, 2730, 2798, 2869, 2869, 2978, 2960, 
		2978, 2869, 2890, 2890, 2869, 2798, 2798, 2730, 2708, 2708, 2691, 2678, 2678, 2716, 2740, 2777, 
		2857, 2882, 2882, 2857, 2959, 2993, 2981, 2984, 2949, 2960, 2993, 2984, 2949, 2993, 2921, 2949, 
		2984, 2949, 2921, 2901, 2784, 2869, 2901, 2810, 2784, 2901, 2810, 2901, 2921, 2737, 2784, 2810, 
		2687, 2730, 2784, 2687, 2784, 2737, 2687, 2691, 2730, 2677, 2691, 2687, 2693, 2716, 2691, 2693, 
		2691, 2677, 2693, 2777, 2716, 2785, 2777, 2693, 2785, 2693, 2715, 2885, 2857, 2777, 2885, 2777, 
		2785, 2785, 2858, 2885, 2885, 2938, 2857, 2962, 2938, 2885, 2962, 2885, 2858, 2993, 2938, 2962, 
		2993, 2960, 2938, 2993, 2962, 2981, 2960, 2949, 2869, 2869, 2784, 2730, 2858, 2785, 2715, 2715, 
		2693, 2677, 2677, 2687, 2737, 2737, 2810, 2921, 2921, 2984, 2981, 2901, 2869, 2949, 2896, 2853, 
		2925, 2904, 2896, 2925, 2904, 2925, 2914, 2814, 2853, 2896, 2842, 2814, 2896, 2842, 2896, 2904, 
		2772, 2814, 2842, 2814, 2809, 2853, 2751, 2814, 2772, 2766, 2751, 2772, 2751, 2809, 2814, 2754, 
		2751, 2766, 2762, 2754, 2766, 2754, 2809, 2751, 2793, 2754, 2762, 2827, 2809, 2754, 2827, 2754, 
		2793, 2862, 2827, 2793, 2827, 2853, 2809, 2862, 2907, 2827, 2907, 2853, 2827, 2925, 2853, 2907, 
		2914, 2907, 2862, 2914, 2925, 2907, 2868, 2862, 2793, 2766, 2772, 2829, 2829, 2904, 2914, 2904, 
		2829, 2842, 2842, 2829, 2772, 2862, 2868, 2914, 2476, 2549, 2653, 2476, 2425, 2549, 2476, 2305, 
		2425, 2476, 2297, 2305, 2559, 2423, 2297, 2476, 2559, 2297, 2476, 2653, 2559, 2549, 2647, 2653, 
		2653, 2649, 2559, 2613, 2581, 2625, 2575, 2613, 2625, 2478, 2613, 2466, 2435, 2331, 2466, 2331, 
		2386, 2333, 2386, 2494, 2376, 2494, 2386, 2531, 2625, 2494, 2531, 2625, 2581, 2494, 2575, 2625, 
		2531, 2581, 2613, 2478, 2478, 2331, 2376, 2575, 2531, 2502, 2502, 2386, 2404, 2512, 2613, 2575, 
		2613, 2512, 2466, 2466, 2512, 2435, 2331, 2478, 2466, 2435, 2404, 2331, 2333, 2376, 2331, 2331, 
		2404, 2386, 2386, 2376, 2333, 2386, 2502, 2531, 2571, 2576, 2639, 2571, 2512, 2575, 2522, 2512, 
		2571, 2435, 2512, 2522, 2389, 2435, 2522, 2389, 2522, 2484, 2435, 2389, 2404, 2346, 2404, 2389, 
		2346, 2408, 2404, 2439, 2408, 2346, 2510, 2404, 2408, 2510, 2408, 2439, 2510, 2502, 2404, 2510, 
		2576, 2502, 2576, 2575, 2502, 2639, 2576, 2510, 2571, 2575, 2576, 2639, 2510, 2602, 2356, 2389, 
		2484, 2484, 2522, 2629, 2639, 2629, 2571, 2571, 2629, 2522, 2389, 2304, 2346, 2439, 2602, 2510, 
		2304, 2389, 2356, 2341, 2346, 2304, 2439, 2346, 2341, 2602, 2439, 2533, 2429, 2484, 2570, 2629, 
		2639, 2657, 2629, 2570, 2484, 2484, 2429, 2356, 2439, 2341, 2533, 2602, 2657, 2639, 2298, 2304, 
		2319, 2436, 2533, 2341, 2573, 2533, 2436, 2573, 2632, 2533, 2429, 2319, 2356, 2356, 2319, 2304, 
		2533, 2632, 2602, 2641, 2632, 2573, 2436, 2341, 2322, 2322, 2298, 2315, 2315, 2319, 2443, 2443, 
		2429, 2595, 2595, 2657, 2641, 2657, 2595, 2648, 2648, 2629, 2657, 2570, 2629, 2648, 2648, 2595, 
		2570, 2570, 2595, 2429, 2429, 2443, 2319, 2319, 2315, 2298, 2341, 2304, 2298, 2298, 2322, 2341, 
		2657, 2602, 2632, 2632, 2641, 2657, 2647, 2661, 2653, 2616, 2595, 2661, 2616, 2661, 2647, 2616, 
		2647, 2549, 2616, 2488, 2595, 2488, 2616, 2549, 2443, 2595, 2488, 2425, 2488, 2549, 2328, 2443, 
		2488, 2321, 2328, 2488, 2488, 2425, 2321, 2291, 2328, 2321, 2291, 2321, 2305, 2291, 2315, 2328, 
		2291, 2305, 2297, 2291, 2297, 2302, 2302, 2322, 2291, 2302, 2447, 2322, 2423, 2302, 2297, 2447, 
		2436, 2322, 2302, 2423, 2447, 2593, 2573, 2436, 2593, 2436, 2447, 2559, 2447, 2423, 2447, 2559, 
		2593, 2593, 2559, 2649, 2649, 2652, 2593, 2661, 2649, 2653, 2652, 2649, 2661, 2641, 2661, 2595, 
		2443, 2328, 2315, 2315, 2291, 2322, 2573, 2652, 2641, 2321, 2425, 2305, 2652, 2573, 2593, 2661, 
		2641, 2652, 2579, 2546, 2618, 2485, 2453, 2546, 2485, 2546, 2579, 2400, 2453, 2485, 2453, 2446, 
		2546, 2364, 2453, 2400, 2376, 2364, 2400, 2364, 2446, 2453, 2359, 2364, 2376, 2359, 2446, 2364, 
		2434, 2524, 2446, 2434, 2446, 2359, 2524, 2546, 2446, 2528, 2524, 2434, 2618, 2524, 2528, 2618, 
		2546, 2524, 2581, 2618, 2494, 2494, 2434, 2376, 2376, 2400, 2478, 2478, 2579, 2581, 2618, 2581, 
		2579, 2579, 2478, 2485, 2485, 2478, 2400, 2359, 2376, 2434, 2434, 2494, 2528, 2528, 2494, 2618, 
		2021, 2225, 2269, 2125, 2021, 2269, 2125, 1980, 2021, 2165, 1980, 2125, 2165, 2006, 1980, 2125, 
		2262, 2165, 2125, 2269, 2262, 2210, 2221, 2243, 2221, 2210, 2178, 2096, 2063, 2178, 2178, 2210, 
		2096, 2096, 2025, 2063, 2103, 2025, 2096, 2015, 2063, 2025, 2063, 2015, 2052, 2052, 2015, 2121, 
		2167, 2121, 2015, 2167, 2243, 2121, 2243, 2221, 2196, 2193, 2243, 2202, 2202, 2167, 2138, 2138, 
		2015, 2050, 2103, 2210, 2193, 2243, 2193, 2210, 2210, 2103, 2096, 2103, 2050, 2025, 2025, 2050, 
		2015, 2015, 2138, 2167, 2121, 2196, 2052, 2243, 2196, 2121, 2167, 2202, 2243, 2227, 2193, 2202, 
		2177, 2193, 2227, 2177, 2153, 2193, 2177, 2227, 2240, 2153, 2103, 2193, 2072, 2153, 2177, 2029, 
		2103, 2153, 2029, 2153, 2072, 2033, 2103, 2029, 2032, 2103, 2033, 2032, 2050, 2103, 2002, 2032, 
		2033, 2098, 2050, 2032, 2098, 2138, 2050, 2192, 2138, 2098, 2131, 2192, 2098, 2237, 2192, 2131, 
		2192, 2202, 2138, 2258, 2202, 2192, 2227, 2202, 2258, 2258, 2192, 2237, 2131, 2098, 2002, 2240, 
		2227, 2258, 2032, 2002, 2098, 1981, 2033, 2029, 2002, 2033, 1981, 2194, 2131, 2023, 2023, 2002, 
		1981, 2240, 2258, 2273, 2177, 2240, 2200, 2177, 2200, 2072, 2002, 2023, 2131, 2131, 2194, 2237, 
		2123, 2200, 2234, 2123, 2072, 2200, 2003, 2072, 2123, 2049, 2194, 2023, 2240, 2234, 2200, 2072, 
		2003, 2029, 2029, 2003, 1981, 2194, 2264, 2237, 2237, 2264, 2258, 2261, 2264, 2244, 2244, 2264, 
		2164, 2049, 2023, 2007, 2007, 1981, 1990, 1990, 2003, 2017, 2123, 2234, 2261, 2264, 2261, 2273, 
		2234, 2240, 2273, 2273, 2261, 2234, 2123, 2017, 2003, 2003, 1990, 1981, 1981, 2007, 2023, 2049, 
		2164, 2194, 2194, 2164, 2264, 2273, 2258, 2264, 2277, 2269, 2272, 2256, 2261, 2277, 2272, 2256, 
		2277, 2225, 2256, 2272, 2256, 2225, 2213, 2058, 2123, 2213, 2101, 2058, 2213, 2101, 2213, 2225, 
		2021, 2058, 2101, 1985, 2017, 2058, 1985, 2058, 2021, 1985, 1990, 2017, 1980, 1990, 1985, 1991, 
		2007, 1990, 1991, 1990, 1980, 1991, 2049, 2007, 2061, 2049, 1991, 2061, 1991, 2006, 2197, 2164, 
		2049, 2197, 2049, 2061, 2061, 2165, 2197, 2197, 2244, 2164, 2262, 2244, 2197, 2262, 2197, 2165, 
		2277, 2244, 2262, 2277, 2261, 2244, 2277, 2262, 2269, 2261, 2256, 2123, 2123, 2058, 2017, 2165, 
		2061, 2006, 2006, 1991, 1980, 1980, 1985, 2021, 2021, 2101, 2225, 2225, 2272, 2269, 2213, 2123, 
		2256, 2214, 2190, 2231, 2214, 2231, 2221, 2135, 2190, 2214, 2127, 2135, 2214, 2135, 2105, 2190, 
		2042, 2135, 2127, 2042, 2105, 2135, 2031, 2105, 2042, 2026, 2031, 2042, 2095, 2105, 2031, 2026, 
		2095, 2031, 2081, 2095, 2026, 2179, 2095, 2081, 2218, 2105, 2095, 2179, 2218, 2095, 2218, 2190, 
		2105, 2231, 2190, 2218, 2221, 2218, 2179, 2221, 2231, 2218, 2196, 2179, 2052, 2052, 2026, 2063, 
		2063, 2127, 2178, 2178, 2214, 2221, 2214, 2178, 2127, 2127, 2063, 2042, 2042, 2063, 2026, 2026, 
		2052, 2081, 2081, 2052, 2179, 2179, 2196, 2221, 431, 683, 743, 563, 431, 743, 563, 383, 
		431, 563, 445, 383, 563, 676, 445, 563, 743, 676, 712, 667, 662, 662, 667, 572, 
		551, 572, 667, 552, 551, 667, 432, 476, 551, 552, 432, 551, 485, 432, 552, 410, 
		476, 432, 410, 519, 476, 513, 519, 410, 601, 513, 410, 513, 622, 519, 601, 622, 
		513, 712, 622, 601, 622, 712, 662, 572, 551, 476, 636, 712, 621, 621, 601, 533, 
		533, 410, 485, 552, 667, 636, 712, 636, 667, 432, 485, 410, 410, 533, 601, 601, 
		621, 712, 595, 636, 671, 636, 595, 552, 487, 552, 595, 487, 595, 571, 487, 485, 
		552, 456, 485, 487, 393, 456, 487, 456, 533, 485, 508, 533, 456, 612, 533, 508, 
		647, 621, 533, 647, 533, 612, 647, 636, 621, 671, 636, 647, 739, 671, 647, 739, 
		647, 728, 728, 647, 612, 506, 508, 400, 400, 456, 393, 393, 487, 386, 386, 487, 
		418, 418, 487, 571, 571, 595, 720, 739, 720, 671, 671, 720, 595, 456, 400, 508, 
		508, 506, 612, 518, 571, 668, 720, 668, 571, 571, 518, 418, 506, 635, 728, 728, 
		612, 506, 708, 668, 739, 446, 418, 518, 386, 418, 446, 396, 386, 446, 386, 400, 
		393, 463, 506, 400, 623, 506, 463, 623, 635, 506, 623, 728, 635, 724, 728, 623, 
		463, 400, 396, 446, 518, 574, 668, 720, 739, 739, 724, 708, 708, 574, 668, 668, 
		574, 518, 386, 396, 400, 728, 724, 739, 738, 737, 743, 709, 737, 738, 709, 708, 
		737, 683, 709, 738, 709, 683, 569, 569, 574, 709, 411, 446, 574, 411, 574, 569, 
		431, 411, 569, 411, 396, 446, 379, 411, 431, 379, 396, 411, 387, 396, 379, 383, 
		387, 379, 425, 387, 383, 425, 463, 387, 445, 425, 383, 583, 623, 463, 583, 463, 
		425, 583, 425, 445, 718, 623, 583, 676, 718, 583, 735, 623, 718, 743, 718, 676, 
		743, 735, 718, 737, 724, 735, 743, 737, 735, 724, 737, 708, 708, 709, 574, 396, 
		387, 463, 623, 735, 724, 676, 583, 445, 383, 379, 431, 431, 569, 683, 683, 738, 
		743, 663, 654, 701, 576, 587, 654, 576, 654, 663, 572, 576, 663, 576, 536, 587, 
		484, 576, 572, 484, 536, 576, 424, 536, 484, 476, 424, 484, 491, 536, 424, 555, 
		536, 491, 624, 555, 491, 624, 536, 555, 624, 587, 536, 654, 587, 624, 701, 654, 
		624, 662, 701, 622, 622, 624, 519, 519, 424, 476, 572, 663, 662, 701, 662, 663, 
		572, 476, 484, 424, 519, 491, 491, 519, 624, 624, 622, 701, 140, 289, 357, 198, 
		140, 357, 82, 43, 140, 198, 82, 140, 198, 236, 82, 198, 343, 236, 198, 357, 
		343, 318, 265, 204, 204, 265, 158, 205, 158, 265, 147, 205, 190, 205, 95, 158, 
		147, 95, 205, 158, 95, 135, 107, 135, 95, 135, 107, 192, 172, 192, 107, 228, 
		172, 107, 273, 192, 172, 228, 273, 172, 318, 273, 228, 318, 277, 273, 277, 318, 
		204, 204, 158, 135, 192, 273, 277, 260, 228, 218, 218, 228, 152, 152, 107, 147, 
		205, 265, 260, 318, 260, 265, 95, 147, 107, 107, 152, 228, 228, 260, 318, 295, 
		260, 267, 295, 267, 322, 238, 205, 260, 238, 260, 295, 238, 190, 205, 148, 190, 
		238, 148, 238, 210, 148, 147, 190, 118, 147, 148, 118, 152, 147, 60, 118, 148, 
		157, 152, 118, 157, 218, 152, 230, 218, 157, 159, 230, 157, 322, 218, 230, 322, 
		267, 218, 267, 260, 218, 159, 157, 79, 79, 118, 60, 60, 148, 111, 111, 148, 
		210, 210, 238, 295, 118, 79, 157, 363, 295, 322, 280, 295, 363, 363, 322, 327, 
		160, 210, 280, 210, 295, 280, 210, 160, 111, 159, 248, 327, 327, 230, 159, 322, 
		230, 327, 323, 280, 363, 45, 60, 80, 98, 159, 79, 188, 159, 98, 188, 248, 
		159, 298, 363, 327, 160, 80, 111, 111, 80, 60, 60, 45, 79, 298, 248, 188, 
		98, 45, 70, 70, 80, 126, 126, 160, 234, 234, 280, 323, 363, 337, 323, 280, 
		234, 160, 160, 126, 80, 80, 70, 45, 45, 98, 79, 248, 298, 327, 298, 337, 
		363, 323, 337, 365, 309, 323, 365, 289, 309, 365, 309, 289, 208, 208, 234, 309, 
		149, 234, 208, 140, 149, 208, 71, 126, 149, 71, 149, 140, 43, 71, 140, 71, 
		46, 126, 46, 71, 43, 46, 43, 32, 48, 98, 32, 48, 32, 43, 113, 98, 
		48, 48, 82, 113, 168, 113, 82, 113, 168, 202, 263, 188, 202, 236, 202, 168, 
		202, 236, 263, 263, 236, 343, 352, 298, 263, 343, 352, 263, 365, 337, 352, 365, 
		343, 357, 352, 343, 365, 323, 309, 234, 234, 149, 126, 126, 46, 70, 98, 113, 
		188, 188, 263, 298, 298, 352, 337, 236, 168, 82, 82, 48, 43, 140, 208, 289, 
		289, 365, 357, 32, 70, 46, 98, 70, 32, 202, 188, 113, 269, 286, 277, 193, 
		219, 286, 212, 193, 286, 212, 286, 269, 193, 177, 219, 146, 193, 212, 146, 133, 
		193, 133, 177, 193, 112, 133, 146, 122, 133, 112, 122, 177, 133, 191, 177, 122, 
		191, 122, 156, 240, 191, 156, 191, 219, 177, 240, 270, 191, 270, 219, 191, 286, 
		219, 270, 277, 270, 240, 277, 286, 270, 277, 240, 192, 192, 156, 135, 135, 146, 
		204, 204, 269, 277, 269, 204, 212, 212, 204, 146, 146, 135, 112, 112, 135, 122, 
		122, 135, 156, 156, 192, 240, 1298, 1372, 1493, 1121, 1245, 1372, 1298, 1121, 1372, 1298, 
		1179, 1121, 1298, 1493, 1179, 1493, 1372, 1465, 1121, 1179, 1101, 1493, 1447, 1179, 1434, 1359, 
		1437, 1279, 1359, 1434, 1279, 1299, 1359, 1174, 1299, 1279, 1224, 1174, 1279, 1201, 1275, 1158, 
		1318, 1275, 1201, 1331, 1416, 1318, 1318, 1416, 1400, 1437, 1400, 1416, 1434, 1437, 1416, 1400, 
		1437, 1299, 1204, 1158, 1275, 1275, 1318, 1400, 1371, 1434, 1331, 1331, 1201, 1240, 1240, 1158, 
		1224, 1224, 1279, 1371, 1359, 1299, 1437, 1434, 1371, 1279, 1174, 1204, 1299, 1158, 1204, 1174, 
		1174, 1224, 1158, 1158, 1240, 1201, 1201, 1331, 1318, 1416, 1331, 1434, 1395, 1391, 1457, 1395, 
		1371, 1391, 1268, 1371, 1395, 1268, 1224, 1371, 1307, 1268, 1395, 1186, 1224, 1268, 1186, 1240, 
		1224, 1237, 1240, 1186, 1237, 1331, 1240, 1345, 1331, 1237, 1244, 1345, 1237, 1457, 1331, 1345, 
		1457, 1391, 1331, 1391, 1371, 1331, 1244, 1237, 1170, 1170, 1186, 1123, 1123, 1186, 1149, 1307, 
		1149, 1268, 1268, 1149, 1186, 1186, 1170, 1237, 1496, 1395, 1457, 1404, 1395, 1496, 1496, 1457, 
		1466, 1244, 1170, 1117, 1117, 1170, 1123, 1253, 1307, 1404, 1307, 1395, 1404, 1307, 1253, 1149, 
		1244, 1364, 1466, 1466, 1345, 1244, 1457, 1345, 1466, 1463, 1404, 1496, 1131, 1149, 1253, 1117, 
		1123, 1131, 1196, 1244, 1117, 1323, 1244, 1196, 1323, 1364, 1244, 1323, 1466, 1364, 1448, 1496, 
		1466, 1196, 1117, 1130, 1130, 1117, 1134, 1134, 1131, 1296, 1463, 1296, 1404, 1404, 1296, 1253, 
		1253, 1296, 1131, 1123, 1149, 1131, 1131, 1134, 1117, 1323, 1448, 1466, 1448, 1463, 1496, 1403, 
		1463, 1497, 1465, 1403, 1497, 1372, 1403, 1465, 1293, 1403, 1372, 1293, 1296, 1403, 1245, 1293, 
		1372, 1162, 1296, 1293, 1147, 1162, 1293, 1293, 1245, 1147, 1096, 1134, 1162, 1096, 1162, 1147, 
		1096, 1147, 1121, 1096, 1121, 1101, 1096, 1130, 1134, 1129, 1130, 1096, 1101, 1129, 1096, 1129, 
		1196, 1130, 1179, 1129, 1101, 1229, 1196, 1129, 1229, 1129, 1179, 1355, 1323, 1196, 1355, 1196, 
		1229, 1447, 1458, 1355, 1510, 1458, 1447, 1493, 1510, 1447, 1463, 1403, 1296, 1296, 1162, 1134, 
		1323, 1458, 1448, 1448, 1510, 1463, 1447, 1355, 1179, 1465, 1497, 1493, 1493, 1497, 1510, 1497, 
		1463, 1510, 1147, 1245, 1121, 1229, 1179, 1355, 1458, 1323, 1355, 1510, 1448, 1458, 1396, 1370, 
		1431, 1308, 1269, 1370, 1308, 1370, 1396, 1216, 1269, 1308, 1269, 1256, 1370, 1173, 1269, 1216, 
		1173, 1256, 1269, 1188, 1256, 1173, 1305, 1256, 1188, 1277, 1305, 1188, 1387, 1305, 1277, 1370, 
		1256, 1305, 1370, 1305, 1387, 1431, 1370, 1387, 1400, 1387, 1275, 1275, 1188, 1204, 1204, 1216, 
		1299, 1299, 1396, 1400, 1431, 1400, 1396, 1396, 1299, 1308, 1308, 1299, 1216, 1216, 1204, 1173, 
		1173, 1204, 1188, 1188, 1275, 1277, 1277, 1275, 1387, 1387, 1400, 1431, 2027, 2224, 2275, 2122, 
		2027, 2275, 2122, 1983, 2027, 2122, 2013, 1983, 2122, 2275, 2013, 2183, 2275, 2253, 2275, 2183, 
		2013, 2247, 2209, 2220, 2220, 2209, 2137, 2137, 2209, 2097, 2045, 2097, 2132, 2097, 2024, 2062, 
		2045, 2024, 2097, 2012, 2047, 2062, 2012, 2062, 2024, 2048, 2047, 2012, 2048, 2129, 2047, 2133, 
		2048, 2012, 2133, 2129, 2048, 2247, 2129, 2133, 2206, 2133, 2111, 2189, 2206, 2111, 2247, 2133, 
		2206, 2129, 2247, 2220, 2203, 2247, 2189, 2111, 2012, 2045, 2132, 2209, 2203, 2247, 2203, 2209, 
		2097, 2062, 2137, 2209, 2132, 2097, 2024, 2045, 2012, 2012, 2111, 2133, 2206, 2189, 2247, 2140, 
		2203, 2228, 2152, 2132, 2203, 2140, 2152, 2203, 2140, 2228, 2233, 2091, 2132, 2152, 2091, 2152, 
		2140, 2091, 2045, 2132, 2034, 2045, 2091, 2089, 2045, 2034, 2045, 2089, 2111, 2144, 2111, 2089, 
		2189, 2111, 2144, 2238, 2189, 2144, 2228, 2189, 2238, 2228, 2203, 2189, 2079, 2089, 2005, 2005, 
		2034, 1993, 1993, 2091, 2028, 2028, 2091, 2140, 2266, 2228, 2238, 2228, 2266, 2233, 2091, 1993, 
		2034, 2034, 2005, 2089, 2089, 2079, 2144, 2088, 2140, 2212, 2233, 2212, 2140, 2140, 2088, 2028, 
		1993, 1982, 2005, 2079, 2198, 2238, 2238, 2144, 2079, 2238, 2274, 2266, 1997, 1982, 2010, 2040, 
		2079, 2005, 2141, 2079, 2040, 2141, 2198, 2079, 2088, 2010, 2028, 2028, 2010, 1993, 2198, 2252, 
		2238, 2257, 2252, 2141, 2040, 2005, 1996, 1996, 1982, 1997, 1997, 2010, 2106, 2106, 2212, 2250, 
		2250, 2274, 2257, 2274, 2250, 2266, 2212, 2233, 2266, 2266, 2250, 2212, 2212, 2106, 2088, 2088, 
		2106, 2010, 1982, 1993, 2010, 1982, 1996, 2005, 2198, 2141, 2252, 2274, 2238, 2252, 2252, 2257, 
		2274, 2278, 2250, 2257, 2265, 2250, 2278, 2205, 2250, 2265, 2265, 2224, 2205, 2100, 2205, 2224, 
		2100, 2022, 2205, 2027, 2022, 2100, 1984, 2022, 2027, 1984, 1997, 2022, 1979, 1996, 1997, 1979, 
		1997, 1984, 1984, 1983, 1979, 1979, 2040, 1996, 2035, 2040, 1979, 1979, 2013, 2035, 2195, 2141, 
		2040, 2195, 2040, 2035, 2183, 2195, 2035, 2195, 2249, 2141, 2253, 2195, 2183, 2253, 2249, 2195, 
		2278, 2257, 2249, 2278, 2249, 2253, 2275, 2278, 2253, 2250, 2205, 2106, 2106, 2022, 1997, 2141, 
		2249, 2257, 2183, 2035, 2013, 2013, 1979, 1983, 1983, 1984, 2027, 2027, 2100, 2224, 2224, 2265, 
		2275, 2278, 2275, 2265, 2022, 2106, 2205, 2216, 2191, 2232, 2216, 2232, 2220, 2134, 2191, 2216, 
		2137, 2134, 2216, 2134, 2104, 2191, 2041, 2134, 2137, 2041, 2104, 2134, 2018, 2104, 2041, 2054, 
		2104, 2018, 2112, 2104, 2054, 2173, 2112, 2054, 2217, 2104, 2112, 2173, 2217, 2112, 2217, 2191, 
		2104, 2232, 2191, 2217, 2220, 2217, 2173, 2220, 2232, 2217, 2220, 2173, 2129, 2129, 2054, 2047, 
		2047, 2018, 2062, 2137, 2216, 2220, 2137, 2062, 2041, 2041, 2062, 2018, 2018, 2047, 2054, 2054, 
		2129, 2173, 1735, 1903, 1940, 1686, 1804, 1903, 1735, 1686, 1903, 1582, 1544, 1686, 1735, 1582, 
		1686, 1735, 1807, 1582, 1735, 1940, 1807, 1876, 1848, 1842, 1848, 1876, 1845, 1842, 1848, 1795, 
		1684, 1648, 1795, 1848, 1684, 1795, 1697, 1600, 1684, 1684, 1600, 1648, 1669, 1648, 1600, 1619, 
		1669, 1600, 1669, 1718, 1648, 1788, 1669, 1619, 1788, 1718, 1669, 1876, 1842, 1788, 1845, 1876, 
		1788, 1776, 1795, 1648, 1718, 1788, 1842, 1845, 1788, 1766, 1766, 1788, 1671, 1697, 1848, 1800, 
		1800, 1848, 1845, 1795, 1776, 1842, 1848, 1697, 1684, 1697, 1671, 1600, 1600, 1671, 1619, 1619, 
		1671, 1788, 1800, 1845, 1847, 1774, 1800, 1847, 1774, 1847, 1894, 1774, 1697, 1800, 1642, 1672, 
		1774, 1672, 1697, 1774, 1626, 1697, 1672, 1626, 1671, 1697, 1554, 1626, 1672, 1705, 1671, 1626, 
		1705, 1716, 1671, 1716, 1766, 1671, 1801, 1766, 1716, 1801, 1716, 1705, 1835, 1766, 1801, 1847, 
		1845, 1766, 1835, 1847, 1766, 1909, 1847, 1835, 1909, 1835, 1801, 1579, 1626, 1554, 1554, 1672, 
		1642, 1642, 1774, 1760, 1760, 1774, 1894, 1909, 1894, 1847, 1626, 1579, 1705, 1942, 1894, 1909, 
		1942, 1909, 1908, 1799, 1705, 1664, 1693, 1760, 1818, 1894, 1818, 1760, 1760, 1693, 1642, 1579, 
		1664, 1705, 1705, 1799, 1908, 1908, 1801, 1705, 1909, 1801, 1908, 1907, 1894, 1942, 1907, 1818, 
		1894, 1545, 1554, 1580, 1655, 1664, 1579, 1655, 1799, 1664, 1780, 1799, 1655, 1780, 1908, 1799, 
		1880, 1942, 1908, 1693, 1580, 1642, 1642, 1580, 1554, 1554, 1545, 1579, 1655, 1579, 1563, 1563, 
		1545, 1568, 1568, 1580, 1733, 1907, 1733, 1818, 1818, 1733, 1693, 1693, 1733, 1580, 1580, 1568, 
		1545, 1545, 1563, 1579, 1780, 1880, 1908, 1880, 1907, 1942, 1903, 1938, 1949, 1843, 1907, 1938, 
		1903, 1843, 1938, 1804, 1843, 1903, 1727, 1843, 1804, 1727, 1733, 1843, 1686, 1727, 1804, 1598, 
		1733, 1727, 1588, 1598, 1727, 1727, 1686, 1588, 1532, 1568, 1598, 1532, 1598, 1588, 1532, 1588, 
		1544, 1532, 1563, 1568, 1547, 1563, 1532, 1547, 1532, 1544, 1547, 1655, 1563, 1629, 1655, 1547, 
		1547, 1582, 1629, 1764, 1780, 1655, 1764, 1655, 1629, 1889, 1780, 1764, 1889, 1880, 1780, 1807, 
		1889, 1764, 1926, 1880, 1889, 1940, 1889, 1807, 1940, 1926, 1889, 1949, 1938, 1926, 1949, 1926, 
		1940, 1907, 1843, 1733, 1733, 1598, 1568, 1880, 1938, 1907, 1807, 1629, 1582, 1582, 1547, 1544, 
		1903, 1949, 1940, 1588, 1686, 1544, 1629, 1807, 1764, 1938, 1880, 1926, 1836, 1851, 1842, 1729, 
		1770, 1851, 1746, 1729, 1851, 1746, 1851, 1836, 1729, 1708, 1770, 1659, 1729, 1746, 1659, 1643, 
		1729, 1643, 1708, 1729, 1624, 1643, 1659, 1631, 1643, 1624, 1631, 1708, 1643, 1725, 1708, 1631, 
		1725, 1631, 1685, 1784, 1725, 1685, 1725, 1770, 1708, 1784, 1838, 1725, 1838, 1770, 1725, 1851, 
		1770, 1838, 1842, 1838, 1784, 1842, 1851, 1838, 1842, 1784, 1718, 1718, 1631, 1648, 1648, 1746, 
		1776, 1776, 1836, 1842, 1836, 1776, 1746, 1746, 1648, 1659, 1659, 1648, 1624, 1624, 1648, 1631, 
		1631, 1718, 1685, 1685, 1718, 1784, 823, 1042, 1062, 916, 823, 1062, 823, 990, 1042, 916, 
		815, 823, 916, 1012, 815, 916, 1062, 1012, 815, 763, 823, 1001, 1015, 1034, 1015, 906, 
		914, 800, 914, 906, 836, 800, 906, 898, 836, 906, 821, 831, 800, 836, 821, 800, 
		821, 891, 831, 821, 924, 891, 956, 924, 821, 924, 986, 891, 924, 1034, 986, 956, 
		1034, 924, 1001, 1034, 956, 1008, 1015, 914, 956, 821, 885, 898, 906, 991, 991, 1015, 
		1001, 1015, 1008, 1034, 1015, 991, 906, 800, 831, 914, 836, 885, 821, 1034, 1008, 986, 
		1021, 991, 1002, 1021, 1002, 1043, 971, 991, 1021, 971, 898, 991, 882, 898, 971, 882, 
		971, 921, 817, 898, 882, 898, 817, 836, 810, 836, 817, 810, 885, 836, 883, 885, 
		810, 883, 956, 885, 968, 956, 883, 886, 968, 883, 1043, 956, 968, 1043, 1002, 956, 
		1002, 1001, 956, 991, 1001, 1002, 886, 883, 797, 817, 882, 806, 806, 882, 921, 921, 
		971, 1021, 810, 797, 883, 1065, 1021, 1043, 1010, 1021, 1065, 767, 817, 806, 1065, 1043, 
		1048, 890, 921, 1010, 921, 1021, 1010, 921, 890, 806, 767, 810, 817, 797, 810, 767, 
		886, 985, 1048, 1048, 968, 886, 1043, 968, 1048, 1047, 1010, 1065, 777, 886, 797, 792, 
		886, 777, 934, 886, 792, 934, 985, 886, 934, 1048, 985, 1039, 1065, 1048, 890, 790, 
		806, 806, 790, 767, 767, 777, 797, 792, 777, 787, 787, 790, 915, 1047, 915, 1010, 
		1010, 915, 890, 890, 915, 790, 790, 787, 767, 767, 787, 777, 934, 1039, 1048, 1039, 
		1047, 1065, 1009, 1047, 1066, 1042, 1009, 1066, 990, 1009, 1042, 910, 1009, 990, 910, 915, 
		1009, 823, 910, 990, 820, 915, 910, 910, 823, 820, 781, 820, 823, 761, 787, 781, 
		761, 781, 763, 761, 792, 787, 761, 763, 772, 772, 792, 761, 827, 792, 772, 772, 
		815, 827, 979, 934, 827, 979, 827, 815, 1056, 1044, 979, 979, 1012, 1056, 1062, 1056, 
		1012, 1056, 1061, 1044, 1066, 1061, 1056, 1056, 1062, 1066, 1047, 1009, 915, 915, 820, 787, 
		792, 827, 934, 934, 1044, 1039, 1039, 1061, 1047, 1012, 979, 815, 815, 772, 763, 1042, 
		1066, 1062, 1066, 1047, 1061, 781, 787, 820, 781, 823, 763, 1044, 934, 979, 1061, 1039, 
		1044, 994, 952, 1018, 1000, 994, 1018, 1000, 1018, 1008, 912, 952, 994, 923, 912, 994, 
		923, 994, 1000, 912, 895, 952, 844, 912, 923, 844, 826, 912, 826, 895, 912, 811, 
		826, 844, 807, 826, 811, 861, 895, 826, 807, 861, 826, 911, 895, 861, 972, 911, 
		861, 911, 952, 895, 972, 1005, 911, 1005, 952, 911, 1018, 952, 1005, 1008, 1005, 972, 
		1008, 1018, 1005, 986, 972, 891, 891, 807, 831, 831, 844, 914, 914, 1000, 1008, 1000, 
		914, 923, 923, 914, 844, 844, 831, 811, 811, 831, 807, 807, 891, 861, 861, 891, 
		972, 972, 986, 1008, 3028, 3, 3026, 1, 3026, 3, 2, 3027, 3025, 3025, 0, 2, 
		3025, 3027, 3028, 3026, 3025, 3028, 2, 0, 3, 0, 1, 3, 3028, 5, 3, 5, 
		3028, 3024, 2, 3023, 3027, 3023, 2, 4, 3027, 3023, 3028, 3024, 3028, 3023, 3, 4, 
		2, 5, 4, 3, 3024, 3022, 5, 14, 5, 3022, 4, 6, 3023, 3014, 3023, 6, 
		3023, 3022, 3024, 3022, 3023, 3014, 5, 14, 4, 6, 4, 14, 2794, 2946, 2987, 2832, 
		2794, 2987, 2832, 2686, 2794, 2944, 2703, 2686, 2832, 2944, 2686, 2944, 2782, 2703, 2832, 2987, 
		2944, 2725, 2794, 2686, 2944, 2870, 2782, 2912, 2915, 2937, 2915, 2912, 2838, 2822, 2838, 2912, 
		2741, 2838, 2822, 2838, 2741, 2764, 2812, 2741, 2822, 2726, 2764, 2741, 2773, 2764, 2726, 2773, 
		2790, 2764, 2880, 2790, 2773, 2846, 2880, 2773, 2886, 2880, 2937, 2886, 2937, 2915, 2790, 2880, 
		2886, 2888, 2937, 2846, 2846, 2773, 2779, 2812, 2912, 2888, 2937, 2888, 2912, 2912, 2812, 2822, 
		2812, 2779, 2741, 2741, 2779, 2726, 2726, 2779, 2773, 2880, 2846, 2937, 2927, 2910, 2982, 2859, 
		2888, 2910, 2859, 2910, 2927, 2859, 2812, 2888, 2774, 2812, 2859, 2774, 2859, 2841, 2752, 2812, 
		2774, 2752, 2779, 2812, 2696, 2752, 2774, 2796, 2779, 2752, 2779, 2796, 2846, 2849, 2846, 2796, 
		2875, 2849, 2796, 2910, 2846, 2849, 2910, 2849, 2875, 2910, 2888, 2846, 2982, 2910, 2945, 2945, 
		2910, 2875, 2769, 2752, 2696, 2696, 2774, 2745, 2745, 2774, 2841, 2841, 2859, 2927, 2752, 2769, 
		2796, 2796, 2769, 2875, 2917, 2927, 2982, 2743, 2769, 2679, 2797, 2841, 2917, 2841, 2927, 2917, 
		2841, 2797, 2745, 2696, 2679, 2769, 2769, 2743, 2856, 2856, 2875, 2769, 2945, 2875, 2856, 2945, 
		2986, 2982, 2940, 2917, 2982, 2701, 2679, 2721, 2848, 2743, 2712, 2848, 2856, 2743, 2848, 2945, 
		2856, 2797, 2721, 2745, 2745, 2721, 2696, 2954, 2945, 2848, 2712, 2679, 2701, 2701, 2721, 2818, 
		2818, 2917, 2940, 2940, 2986, 2954, 2986, 2940, 2982, 2917, 2818, 2797, 2797, 2818, 2721, 2679, 
		2696, 2721, 2679, 2712, 2743, 2945, 2954, 2986, 2992, 2940, 2954, 2992, 2987, 2985, 2985, 2940, 
		2992, 2924, 2940, 2985, 2946, 2924, 2985, 2883, 2924, 2946, 2836, 2818, 2924, 2836, 2924, 2883, 
		2794, 2836, 2883, 2725, 2739, 2836, 2836, 2794, 2725, 2674, 2701, 2739, 2674, 2739, 2725, 2725, 
		2686, 2674, 2674, 2712, 2701, 2684, 2674, 2686, 2684, 2712, 2674, 2758, 2712, 2684, 2684, 2703, 
		2758, 2758, 2703, 2782, 2845, 2848, 2758, 2845, 2758, 2782, 2870, 2845, 2782, 2932, 2848, 2845, 
		2845, 2870, 2932, 2932, 2870, 2944, 2992, 2954, 2932, 2992, 2932, 2944, 2992, 2944, 2987, 2940, 
		2924, 2818, 2818, 2739, 2701, 2712, 2758, 2848, 2848, 2932, 2954, 2703, 2684, 2686, 2794, 2883, 
		2946, 2946, 2985, 2987, 2739, 2818, 2836, 2897, 2854, 2926, 2905, 2897, 2926, 2905, 2926, 2915, 
		2815, 2854, 2897, 2843, 2815, 2897, 2843, 2897, 2905, 2775, 2815, 2843, 2815, 2808, 2854, 2735, 
		2815, 2775, 2735, 2808, 2815, 2760, 2808, 2735, 2826, 2808, 2760, 2826, 2760, 2790, 2861, 2826, 
		2790, 2826, 2854, 2808, 2861, 2906, 2826, 2906, 2854, 2826, 2926, 2854, 2906, 2915, 2906, 2861, 
		2915, 2926, 2906, 2886, 2861, 2790, 2790, 2760, 2764, 2764, 2775, 2838, 2838, 2905, 2915, 2905, 
		2838, 2843, 2843, 2838, 2775, 2775, 2764, 2735, 2735, 2764, 2760, 2861, 2886, 2915, 2477, 2637, 
		2654, 2477, 2383, 2637, 2383, 2547, 2637, 2477, 2295, 2383, 2477, 2412, 2295, 2477, 2638, 2412, 
		2477, 2654, 2638, 2295, 2412, 2313, 2638, 2536, 2412, 2563, 2597, 2620, 2563, 2460, 2597, 2597, 
		2460, 2461, 2336, 2461, 2460, 2461, 2336, 2388, 2407, 2336, 2460, 2388, 2336, 2334, 2496, 2416, 
		2334, 2416, 2496, 2482, 2496, 2584, 2482, 2496, 2620, 2584, 2597, 2562, 2584, 2597, 2584, 2620, 
		2562, 2597, 2461, 2388, 2334, 2417, 2417, 2416, 2482, 2560, 2620, 2499, 2499, 2496, 2428, 2428, 
		2334, 2407, 2480, 2563, 2560, 2620, 2560, 2563, 2563, 2480, 2460, 2460, 2480, 2407, 2336, 2407, 
		2334, 2416, 2417, 2334, 2334, 2428, 2496, 2496, 2499, 2620, 2518, 2560, 2612, 2518, 2612, 2627, 
		2518, 2480, 2560, 2426, 2480, 2518, 2380, 2480, 2426, 2380, 2407, 2480, 2330, 2407, 2380, 2330, 
		2409, 2407, 2409, 2428, 2407, 2427, 2409, 2330, 2428, 2409, 2427, 2545, 2499, 2428, 2545, 2428, 
		2427, 2545, 2560, 2499, 2612, 2560, 2545, 2612, 2545, 2634, 2330, 2380, 2323, 2426, 2518, 2511, 
		2511, 2518, 2627, 2426, 2323, 2380, 2427, 2517, 2545, 2545, 2517, 2634, 2658, 2627, 2612, 2323, 
		2426, 2511, 2438, 2427, 2316, 2316, 2330, 2294, 2511, 2433, 2323, 2323, 2294, 2330, 2330, 2316, 
		2427, 2427, 2438, 2517, 2658, 2612, 2634, 2626, 2609, 2658, 2433, 2511, 2609, 2312, 2294, 2327, 
		2320, 2438, 2316, 2497, 2438, 2320, 2497, 2633, 2438, 2658, 2634, 2633, 2627, 2609, 2511, 2433, 
		2327, 2323, 2517, 2633, 2634, 2645, 2633, 2497, 2320, 2294, 2312, 2312, 2327, 2451, 2451, 2609, 
		2626, 2609, 2627, 2658, 2658, 2645, 2626, 2609, 2451, 2433, 2433, 2451, 2327, 2294, 2323, 2327, 
		2294, 2320, 2316, 2633, 2517, 2438, 2633, 2645, 2658, 2659, 2645, 2660, 2626, 2645, 2659, 2598, 
		2626, 2659, 2659, 2637, 2598, 2598, 2637, 2547, 2473, 2598, 2547, 2473, 2451, 2598, 2383, 2473, 
		2547, 2332, 2451, 2473, 2473, 2383, 2332, 2311, 2332, 2383, 2290, 2312, 2332, 2290, 2332, 2311, 
		2290, 2311, 2295, 2290, 2320, 2312, 2290, 2295, 2299, 2299, 2320, 2290, 2379, 2320, 2299, 2313, 
		2379, 2299, 2313, 2412, 2379, 2542, 2497, 2379, 2542, 2379, 2412, 2536, 2542, 2412, 2542, 2536, 
		2638, 2638, 2636, 2542, 2660, 2636, 2638, 2660, 2638, 2654, 2660, 2645, 2636, 2660, 2654, 2659, 
		2626, 2598, 2451, 2451, 2332, 2312, 2320, 2379, 2497, 2497, 2636, 2645, 2313, 2299, 2295, 2637, 
		2659, 2654, 2311, 2383, 2295, 2636, 2497, 2542, 2578, 2534, 2604, 2578, 2604, 2584, 2486, 2452, 
		2534, 2486, 2534, 2578, 2401, 2452, 2486, 2452, 2445, 2534, 2347, 2452, 2401, 2347, 2445, 2452, 
		2366, 2445, 2347, 2469, 2445, 2366, 2469, 2366, 2417, 2527, 2469, 2417, 2469, 2534, 2445, 2527, 
		2582, 2469, 2582, 2534, 2469, 2604, 2534, 2582, 2584, 2582, 2527, 2584, 2604, 2582, 2584, 2527, 
		2482, 2417, 2366, 2388, 2388, 2401, 2461, 2461, 2486, 2562, 2584, 2562, 2578, 2578, 2562, 2486, 
		2486, 2461, 2401, 2401, 2388, 2347, 2347, 2388, 2366, 2417, 2482, 2527, 1520, 1070, 1521, 1070, 
		1071, 1521, 1964, 1520, 1965, 1965, 1520, 1521, 2281, 1964, 2282, 2282, 1964, 1965, 2662, 2281, 
		2663, 2281, 2282, 2663, 3014, 2662, 3015, 3015, 2662, 2663, 1521, 1522, 1966, 1966, 1965, 1521, 
		1521, 1071, 1522, 1522, 1071, 1072, 1071, 747, 1072, 1072, 747, 748, 371, 372, 748, 748, 
		747, 371, 371, 7, 372, 372, 7, 8, 370, 6, 7, 371, 370, 7, 746, 370, 
		747, 370, 371, 747, 1070, 746, 747, 1071, 1070, 747, 1522, 1072, 1523, 1072, 1073, 1523, 
		1966, 1522, 1523, 1967, 1966, 1523, 2283, 1966, 2284, 1966, 1967, 2284, 2664, 2283, 2665, 2665, 
		2283, 2284, 2664, 2665, 3017, 3017, 3016, 2664, 3015, 2663, 3016, 2663, 2664, 3016, 2663, 2282, 
		2283, 2664, 2663, 2283, 2282, 1965, 2283, 1965, 1966, 2283, 1967, 1523, 1968, 1968, 1523, 1524, 
		1523, 1073, 1524, 1524, 1073, 1074, 749, 750, 1074, 1074, 1073, 749, 749, 373, 750, 373, 
		374, 750, 373, 9, 374, 9, 10, 374, 372, 8, 373, 8, 9, 373, 748, 372, 
		373, 749, 748, 373, 748, 749, 1073, 1073, 1072, 748, 1524, 1074, 1075, 1525, 1524, 1075, 
		1524, 1525, 1969, 1969, 1968, 1524, 2285, 1968, 2286, 2286, 1968, 1969, 2666, 2285, 2286, 2667, 
		2666, 2286, 3018, 2666, 2667, 3019, 3018, 2667, 3017, 2665, 2666, 3018, 3017, 2666, 2665, 2284, 
		2666, 2284, 2285, 2666, 2284, 1967, 1968, 2285, 2284, 1968, 1969, 1525, 1526, 1970, 1969, 1526, 
		1525, 1075, 1526, 1526, 1075, 1076, 751, 752, 1076, 1076, 1075, 751, 375, 376, 752, 752, 
		751, 375, 11, 12, 376, 376, 375, 11, 374, 10, 375, 375, 10, 11, 750, 374, 
		375, 751, 750, 375, 1074, 750, 1075, 750, 751, 1075, 1526, 1076, 1527, 1527, 1076, 1077, 
		1970, 1526, 1971, 1526, 1527, 1971, 1970, 1971, 2288, 2288, 2287, 1970, 2287, 2288, 2669, 2669, 
		2668, 2287, 3020, 2668, 3021, 3021, 2668, 2669, 2667, 2668, 3020, 3020, 3019, 2667, 2286, 2287, 
		2668, 2668, 2667, 2286, 2286, 1969, 2287, 2287, 1969, 1970, 1849, 1817, 1813, 1728, 1759, 1787, 
		1759, 1728, 1706, 1699, 1608, 1816, 1738, 1886, 1625, 1886, 1948, 1958, 1959, 1933, 1958, 1931, 
		1933, 1959, 1710, 1816, 1841, 1531, 1529, 1572, 1535, 1536, 1529, 1535, 1529, 1531, 1584, 1536, 
		1535, 1714, 1863, 1738, 1930, 1886, 1863, 1959, 1948, 1930, 1933, 1841, 1816, 1816, 1710, 1699, 
		1699, 1710, 1608, 1608, 1572, 1529, 1536, 1584, 1625, 1625, 1714, 1738, 1886, 1930, 1948, 1841, 
		1933, 1931, 1572, 1608, 1710, 1714, 1625, 1584, 1959, 1958, 1948, 1738, 1863, 1886, 1959, 1920, 
		1931, 1931, 1865, 1841, 1841, 1750, 1710, 1710, 1638, 1572, 1572, 1555, 1531, 1531, 1555, 1535, 
		1535, 1613, 1584, 1584, 1613, 1714, 1714, 1732, 1863, 1863, 1885, 1930, 1930, 1885, 1959, 1885, 
		1863, 1732, 1732, 1714, 1613, 1613, 1535, 1555, 1555, 1572, 1638, 1638, 1710, 1750, 1750, 1841, 
		1865, 1865, 1931, 1920, 1885, 1920, 1959, 1865, 1920, 1957, 1917, 1865, 1957, 1805, 1750, 1865, 
		1805, 1865, 1917, 1634, 1750, 1805, 1634, 1638, 1750, 1555, 1638, 1634, 1546, 1555, 1634, 1555, 
		1546, 1530, 1555, 1530, 1576, 1576, 1613, 1555, 1763, 1732, 1613, 1763, 1613, 1576, 1763, 1885, 
		1732, 1852, 1935, 1763, 1935, 1885, 1763, 1957, 1920, 1885, 1957, 1885, 1935, 1957, 1935, 1934, 
		1678, 1576, 1567, 1546, 1634, 1651, 1651, 1634, 1810, 1957, 1955, 1917, 1917, 1810, 1805, 1805, 
		1810, 1634, 1530, 1567, 1576, 1576, 1678, 1763, 1852, 1934, 1935, 1873, 1917, 1955, 1873, 1810, 
		1917, 1734, 1810, 1873, 1734, 1651, 1810, 1567, 1537, 1573, 1679, 1678, 1567, 1852, 1763, 1678, 
		1778, 1852, 1678, 1899, 1955, 1934, 1546, 1537, 1530, 1530, 1537, 1567, 1899, 1934, 1874, 1778, 
		1678, 1679, 1679, 1567, 1573, 1573, 1537, 1610, 1873, 1955, 1899, 1734, 1610, 1651, 1651, 1610, 
		1546, 1546, 1610, 1537, 1778, 1874, 1852, 1852, 1874, 1934, 1955, 1957, 1934, 1864, 1809, 1899, 
		1751, 1734, 1809, 1660, 1610, 1734, 1751, 1660, 1734, 1660, 1614, 1610, 1615, 1573, 1614, 1615, 
		1673, 1573, 1768, 1679, 1673, 1768, 1778, 1679, 1855, 1874, 1778, 1768, 1855, 1778, 1864, 1899, 
		1855, 1864, 1855, 1850, 1573, 1673, 1679, 1874, 1855, 1899, 1665, 1615, 1607, 1607, 1614, 1660, 
		1751, 1809, 1864, 1809, 1873, 1899, 1734, 1873, 1809, 1573, 1610, 1614, 1614, 1607, 1615, 1615, 
		1665, 1673, 1673, 1665, 1768, 1768, 1850, 1855, 1882, 1864, 1919, 1882, 1751, 1864, 1772, 1751, 
		1882, 1657, 1751, 1772, 1569, 1660, 1751, 1751, 1657, 1569, 1607, 1660, 1569, 1557, 1607, 1569, 
		1650, 1665, 1607, 1607, 1557, 1650, 1797, 1665, 1650, 1797, 1919, 1850, 1919, 1864, 1850, 1665, 
		1797, 1768, 1768, 1797, 1850, 1919, 1915, 1882, 1882, 1726, 1772, 1772, 1726, 1657, 1657, 1604, 
		1569, 1569, 1560, 1557, 1557, 1605, 1650, 1650, 1730, 1797, 1797, 1884, 1919, 1884, 1797, 1730, 
		1730, 1650, 1605, 1605, 1557, 1560, 1560, 1569, 1604, 1604, 1657, 1726, 1726, 1882, 1883, 1915, 
		1883, 1882, 1919, 1884, 1915, 1883, 1737, 1726, 1726, 1737, 1604, 1604, 1653, 1560, 1560, 1633, 
		1605, 1605, 1691, 1730, 1730, 1798, 1884, 1856, 1884, 1798, 1798, 1730, 1691, 1691, 1605, 1633, 
		1633, 1560, 1653, 1653, 1604, 1737, 1737, 1883, 1837, 1837, 1915, 1856, 1915, 1837, 1883, 1884, 
		1856, 1915, 1875, 1856, 1921, 1875, 1837, 1856, 1773, 1837, 1875, 1813, 1773, 1875, 1773, 1737, 
		1837, 1653, 1737, 1773, 1606, 1653, 1773, 1586, 1653, 1606, 1586, 1633, 1653, 1561, 1633, 1586, 
		1674, 1633, 1561, 1674, 1691, 1633, 1785, 1691, 1674, 1819, 1785, 1674, 1819, 1861, 1785, 1921, 
		1861, 1819, 1921, 1856, 1861, 1798, 1861, 1856, 1923, 1875, 1921, 1640, 1674, 1559, 1561, 1586, 
		1552, 1701, 1773, 1813, 1875, 1923, 1813, 1773, 1701, 1606, 1606, 1552, 1586, 1561, 1559, 1674, 
		1674, 1640, 1819, 1785, 1798, 1691, 1861, 1798, 1785, 1819, 1912, 1921, 1912, 1819, 1844, 1912, 
		1944, 1921, 1944, 1912, 1897, 1897, 1912, 1844, 1574, 1551, 1548, 1918, 1944, 1897, 1849, 1923, 
		1817, 1601, 1711, 1817, 1817, 1923, 1918, 1815, 1897, 1844, 1559, 1574, 1640, 1640, 1702, 1719, 
		1565, 1601, 1548, 1813, 1817, 1711, 1923, 1945, 1918, 1601, 1596, 1711, 1702, 1640, 1574, 1815, 
		1719, 1702, 1814, 1918, 1871, 1814, 1817, 1918, 1681, 1817, 1814, 1611, 1601, 1681, 1611, 1548, 
		1601, 1740, 1702, 1574, 1740, 1574, 1635, 1826, 1815, 1740, 1826, 1897, 1815, 1871, 1897, 1826, 
		1817, 1681, 1601, 1548, 1611, 1574, 1702, 1740, 1815, 1897, 1871, 1918, 1635, 1574, 1611, 1765, 
		1681, 1814, 1787, 1740, 1700, 1806, 1871, 1787, 1871, 1806, 1814, 1681, 1696, 1611, 1611, 1677, 
		1635, 1740, 1787, 1826, 1826, 1787, 1871, 1765, 1814, 1806, 1696, 1681, 1765, 1677, 1611, 1696, 
		1700, 1635, 1677, 1740, 1635, 1700, 1806, 1759, 1765, 1765, 1759, 1706, 1706, 1696, 1765, 1677, 
		1706, 1728, 1677, 1728, 1700, 1806, 1787, 1759, 1696, 1706, 1677, 1700, 1728, 1787, 1933, 1742, 
		1958, 1816, 1742, 1933, 1608, 1742, 1816, 1529, 1742, 1608, 1536, 1742, 1529, 1625, 1742, 1536, 
		1886, 1742, 1625, 1958, 1742, 1886, 1819, 1719, 1815, 1719, 1819, 1640, 1548, 1552, 1565, 1551, 
		1561, 1552, 1551, 1552, 1548, 1565, 1552, 1606, 1711, 1701, 1813, 1701, 1596, 1606, 1701, 1711, 
		1596, 1813, 1923, 1849, 1945, 1923, 1921, 1601, 1606, 1596, 1601, 1565, 1606, 1561, 1574, 1559, 
		1551, 1574, 1561, 1815, 1844, 1819, 1944, 1918, 1921, 1918, 1945, 1921, 752, 753, 1077, 1077, 
		1076, 752, 1436, 1350, 1276, 1220, 1276, 1350, 1128, 1109, 1220, 1083, 1109, 1128, 1083, 1080, 
		1109, 1322, 1252, 1126, 1322, 1126, 1115, 1509, 1456, 1514, 1519, 1509, 1514, 1471, 1436, 1276, 
		1276, 1220, 1109, 1109, 1080, 1126, 1252, 1322, 1456, 1519, 1471, 1509, 1471, 1500, 1436, 1115, 
		1126, 1080, 1115, 1212, 1322, 1456, 1455, 1514, 1456, 1322, 1455, 1500, 1471, 1519, 1478, 1500, 
		1519, 1424, 1500, 1478, 1424, 1436, 1500, 1310, 1436, 1424, 1310, 1350, 1436, 1350, 1310, 1220, 
		1310, 1157, 1220, 1157, 1128, 1220, 1157, 1083, 1128, 1083, 1122, 1080, 1122, 1115, 1080, 1207, 
		1115, 1122, 1207, 1212, 1115, 1212, 1207, 1322, 1356, 1455, 1322, 1453, 1514, 1455, 1514, 1453, 
		1478, 1519, 1514, 1478, 1453, 1455, 1356, 1356, 1322, 1207, 1157, 1122, 1083, 1513, 1501, 1511, 
		1467, 1424, 1511, 1467, 1511, 1501, 1361, 1310, 1424, 1361, 1424, 1467, 1362, 1361, 1467, 1211, 
		1310, 1361, 1211, 1361, 1362, 1107, 1157, 1310, 1107, 1310, 1211, 1138, 1211, 1362, 1138, 1107, 
		1211, 1107, 1122, 1157, 1092, 1122, 1107, 1092, 1107, 1089, 1097, 1092, 1089, 1214, 1207, 1122, 
		1214, 1122, 1092, 1185, 1214, 1092, 1185, 1092, 1097, 1214, 1356, 1207, 1185, 1384, 1214, 1384, 
		1356, 1214, 1384, 1475, 1356, 1475, 1453, 1356, 1483, 1475, 1384, 1475, 1478, 1453, 1483, 1511, 
		1475, 1511, 1483, 1513, 1511, 1478, 1475, 1089, 1107, 1138, 1362, 1467, 1501, 1424, 1478, 1511, 
		1445, 1501, 1513, 1422, 1501, 1445, 1342, 1205, 1362, 1141, 1089, 1205, 1141, 1097, 1089, 1192, 
		1097, 1141, 1445, 1513, 1425, 1501, 1422, 1362, 1362, 1205, 1138, 1097, 1192, 1185, 1185, 1313, 
		1384, 1384, 1425, 1483, 1342, 1362, 1422, 1089, 1138, 1205, 1313, 1185, 1192, 1425, 1384, 1313, 
		1483, 1425, 1513, 1422, 1383, 1342, 1342, 1271, 1205, 1205, 1164, 1141, 1141, 1166, 1192, 1192, 
		1272, 1313, 1313, 1381, 1425, 1449, 1425, 1381, 1381, 1313, 1272, 1272, 1192, 1166, 1166, 1141, 
		1164, 1164, 1205, 1271, 1271, 1342, 1383, 1383, 1422, 1449, 1445, 1449, 1422, 1425, 1449, 1445, 
		1449, 1405, 1383, 1383, 1405, 1271, 1271, 1135, 1164, 1164, 1094, 1166, 1166, 1154, 1272, 1272, 
		1284, 1381, 1381, 1452, 1449, 1502, 1449, 1452, 1452, 1381, 1284, 1284, 1272, 1154, 1154, 1166, 
		1094, 1094, 1164, 1135, 1135, 1271, 1232, 1232, 1271, 1405, 1405, 1449, 1502, 1486, 1502, 1512, 
		1486, 1405, 1502, 1148, 1135, 1232, 1090, 1094, 1135, 1111, 1094, 1090, 1154, 1094, 1111, 1472, 
		1452, 1363, 1512, 1502, 1472, 1284, 1363, 1452, 1452, 1472, 1502, 1363, 1284, 1194, 1194, 1154, 
		1111, 1148, 1232, 1273, 1273, 1405, 1429, 1429, 1405, 1486, 1405, 1273, 1232, 1135, 1148, 1090, 
		1154, 1194, 1284, 1388, 1486, 1512, 1388, 1429, 1486, 1326, 1429, 1388, 1326, 1273, 1429, 1255, 
		1273, 1326, 1148, 1273, 1255, 1193, 1148, 1255, 1090, 1148, 1193, 1171, 1090, 1193, 1171, 1111, 
		1090, 1194, 1111, 1171, 1225, 1194, 1171, 1374, 1474, 1363, 1472, 1474, 1512, 1401, 1474, 1374, 
		1374, 1363, 1225, 1512, 1401, 1388, 1194, 1225, 1363, 1474, 1472, 1363, 1474, 1401, 1512, 1451, 
		1388, 1401, 1351, 1388, 1451, 1351, 1326, 1388, 1248, 1326, 1351, 1248, 1255, 1326, 1175, 1193, 
		1255, 1175, 1255, 1168, 1225, 1175, 1145, 1247, 1225, 1145, 1354, 1328, 1225, 1354, 1225, 1247, 
		1438, 1374, 1328, 1438, 1328, 1354, 1451, 1401, 1374, 1193, 1175, 1171, 1225, 1328, 1374, 1248, 
		1168, 1255, 1225, 1171, 1175, 1374, 1438, 1451, 1410, 1378, 1451, 1378, 1351, 1451, 1378, 1248, 
		1351, 1241, 1168, 1248, 1177, 1168, 1241, 1177, 1145, 1168, 1247, 1145, 1199, 1309, 1247, 1199, 
		1309, 1354, 1247, 1309, 1438, 1354, 1410, 1451, 1438, 1241, 1248, 1378, 1145, 1175, 1168, 1177, 
		1199, 1145, 1309, 1410, 1438, 1378, 1410, 1407, 1336, 1378, 1407, 1336, 1241, 1378, 1231, 1241, 
		1336, 1177, 1241, 1231, 1199, 1177, 1184, 1407, 1410, 1317, 1317, 1199, 1184, 1231, 1184, 1177, 
		1199, 1317, 1309, 1309, 1317, 1410, 1516, 1494, 1336, 1397, 1336, 1494, 1295, 1336, 1397, 1112, 
		1231, 1295, 1160, 1112, 1295, 1303, 1184, 1120, 1184, 1303, 1317, 1303, 1442, 1317, 1336, 1295, 
		1231, 1231, 1112, 1184, 1317, 1442, 1407, 1516, 1518, 1494, 1336, 1407, 1516, 1120, 1184, 1112, 
		1112, 1086, 1120, 1120, 1187, 1303, 1516, 1407, 1442, 1495, 1494, 1518, 1333, 1352, 1304, 1297, 
		1304, 1352, 1304, 1250, 1333, 1239, 1250, 1304, 1297, 1281, 1239, 1352, 1327, 1281, 1297, 1352, 
		1281, 1250, 1239, 1226, 1226, 1281, 1257, 1257, 1281, 1327, 1327, 1352, 1367, 1352, 1333, 1367, 
		1304, 1297, 1239, 1281, 1226, 1239, 1109, 1319, 1276, 1126, 1319, 1109, 1252, 1319, 1126, 1509, 
		1319, 1456, 1471, 1319, 1509, 1319, 1471, 1276, 1252, 1456, 1319, 1112, 1160, 1108, 1285, 1160, 
		1295, 1386, 1397, 1469, 1295, 1397, 1285, 1495, 1469, 1494, 1386, 1285, 1397, 1469, 1397, 1494, 
		1490, 1516, 1442, 1490, 1518, 1516, 1433, 1490, 1442, 1348, 1433, 1303, 1118, 1187, 1120, 1303, 
		1433, 1442, 1348, 1303, 1187, 1086, 1112, 1108, 1118, 1120, 1086, 1367, 1518, 1490, 1518, 1367, 
		1495, 1250, 1285, 1333, 1469, 1333, 1386, 1187, 1327, 1348, 1348, 1327, 1433, 1086, 1108, 1226, 
		1160, 1250, 1108, 1250, 1226, 1108, 1367, 1490, 1327, 1327, 1187, 1257, 1257, 1187, 1118, 1257, 
		1118, 1226, 1250, 1160, 1285, 1285, 1386, 1333, 1333, 1469, 1367, 1367, 1469, 1495, 1327, 1490, 
		1433, 1086, 1226, 1118, 377, 13, 14, 378, 377, 14, 377, 378, 754, 754, 753, 377, 
		1527, 1077, 1528, 1077, 1078, 1528, 2669, 2288, 2670, 2670, 2288, 2289, 2288, 1971, 2289, 1971, 
		1972, 2289, 752, 376, 377, 753, 752, 377, 12, 13, 377, 377, 376, 12, 3021, 2669, 
		2670, 3022, 3021, 2670, 1077, 753, 754, 1078, 1077, 754, 1971, 1527, 1528, 1972, 1971, 1528
	};

	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glTexCoordPointer(2, GL_FLOAT, 0, TexCoordData);
	glEnableClientState(GL_NORMAL_ARRAY);
	glNormalPointer(GL_FLOAT, 0, NormalData);
	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, VertexData);

	// Material attributes
	chess_Material_Parameters(96.0000f, 0.400000f, 0.400000f, 0.400000f, 0.400000f, 0.400000f, 0.400000f);

	glDrawElements(GL_TRIANGLES, 17616, GL_UNSIGNED_INT, &Indices); // 17616

}	// End of polygons for object 'chess'
