/* fireplace_high.c
**
**    code for high quality fireplace
**
**    Updated Version foobillard++ started at 12/2010
**    Copyright (C) 2010 - 2013 Holger Schaekel (foobillardplus@go4more.de)
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License Version 2 as
**    published by the Free Software Foundation;
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "fireplace_high.h"
#include "png_loader.h"

static int fireplace_high_id = -1;

static GLuint fp2texbind = 0;
static GLuint fp3texbind = 0;

/***********************************************************************
 *        This is a general routine to make a new material active      *
 ***********************************************************************/

void fireplace_Material_Parameters(float shininess, float r_diffuseColor, float g_diffuseColor, float b_diffuseColor, float r_specularColor, float g_specularColor, float b_specularColor)
{
	GLfloat glfModelSpecular[4];

	// This causes the polygon's ambient & diffuse colors to be derived from the glColor() value.
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess);
	/* Set the specular shading color. */
	glfModelSpecular[0] = r_specularColor;
	glfModelSpecular[1] = g_specularColor;
	glfModelSpecular[2] = b_specularColor;
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, glfModelSpecular);
	glColor3f(r_diffuseColor, g_diffuseColor, b_diffuseColor);
}

/***********************************************************************
 *                          Make an glcallist                          *
 ***********************************************************************/

void init_fireplace_high(void) {

  if(fireplace_high_id != -1) {
    glDeleteLists(fireplace_high_id,1);
  }
  fprintf(stderr,"Initialize high-res fireplace graphics\n");
  if(fp2texbind) {
    glDeleteTextures(1,&fp3texbind);
  }
  if(fp3texbind) {
    glDeleteTextures(1,&fp3texbind);
  }
  create_png_texbind("art.png", &fp2texbind, 3, GL_RGB);
  create_png_texbind("fp.png", &fp3texbind, 3, GL_RGB);
  fireplace_high_id = glGenLists(1);
  glNewList(fireplace_high_id, GL_COMPILE);
    glEnable(GL_COLOR_MATERIAL);
    fireplace_high();
    glDisable(GL_COLOR_MATERIAL);
    glPushMatrix();
    glRotatef(180.0,180.0,0.0,0.0);
    glTranslatef(-0.98,-1.2,4.5);
    glBindTexture(GL_TEXTURE_2D,fp2texbind);
    static const GLfloat VertexData[] = {0.0,0.0,0.0,0.0,0.42,0.0,0.75,0.0,0.0,0.75,0.42,0.0};
    static const GLfloat TexData[] = {0.0,0.0,0.0,1.0,1.0,0.0,1.0,1.0};
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);
    glEnableClientState(GL_VERTEX_ARRAY);
    glTexCoordPointer(2,GL_FLOAT, 0, TexData);
    glVertexPointer(3, GL_FLOAT, 0, VertexData);
    glDrawArrays(GL_TRIANGLE_STRIP,0,4);
    glDisableClientState(GL_TEXTURE_COORD_ARRAY);
    glDisableClientState(GL_VERTEX_ARRAY);
    glPopMatrix();
  glEndList();
}

/***********************************************************************
 *                     display the fireplace                           *
 ***********************************************************************/

void display_fireplace_high(void) {
	 if(fireplace_high_id == -1) {
	 	init_fireplace_high();
	 } else {
	 	glCallList(fireplace_high_id);
	 }
}

/***********************************************************************
 *                       texture mapping                               *
 ***********************************************************************/

void fireplace_Texture_Map(GLuint texture_map) {
	 if(texture_map) {
	 	 glEnable(GL_TEXTURE_2D);
	   glBindTexture(GL_TEXTURE_2D,texture_map);
	 } else {
	   glDisable(GL_TEXTURE_2D);
	 }
}

/***********************************************************************
 *                       build the fireplace                           *
 *               Polygons for object (10418 polygons)                  *
 ***********************************************************************/

void fireplace_high(void) {
	static const GLfloat VertexData[] = {
		0.0336960f, -0.482614f, -4.53707f, 0.0336960f, -0.482614f, -4.53707f, 0.0336960f, -0.482614f, -4.53707f, 
		0.0336960f, -0.482614f, -4.53707f, 0.0336960f, -0.872695f, -4.53707f, 
		0.0336960f, -0.872695f, -4.53707f, 0.0336960f, -0.872695f, -4.53707f, 
		-1.24665f, -0.872695f, -4.53707f, -1.24665f, -0.872695f, -4.53707f, 
		-1.24665f, -0.872695f, -4.53707f, -1.24665f, -0.482614f, -4.53707f, 
		-1.24665f, -0.482614f, -4.53707f, -1.24665f, -0.482614f, -4.53707f, 
		-1.24665f, -0.482614f, -4.53707f, 0.0336960f, -0.482615f, -4.14108f, 
		0.0336960f, -0.482615f, -4.14108f, 0.0336960f, -0.482615f, -4.14108f, 
		0.0336960f, -0.872695f, -4.14108f, 0.0336960f, -0.872695f, -4.14108f, 
		0.0336960f, -0.872695f, -4.14108f, -1.24665f, -0.872695f, -4.14108f, 
		-1.24665f, -0.872695f, -4.14108f, -1.24665f, -0.872695f, -4.14108f, 
		-1.24665f, -0.482614f, -4.14108f, -1.24665f, -0.482614f, -4.14108f, 
		-1.24665f, -0.482614f, -4.14108f, 0.0336960f, -0.515907f, -4.53707f, 
		0.0336960f, -0.515907f, -4.53707f, 0.0336960f, -0.515907f, -4.53707f, 
		0.0336960f, -0.515907f, -4.53707f, -1.24665f, -0.515907f, -4.53707f, 
		-1.24665f, -0.515907f, -4.53707f, -1.24665f, -0.515907f, -4.53707f, 
		-1.24665f, -0.515907f, -4.53707f, 0.0336960f, -0.515907f, -4.14108f, 
		0.0336960f, -0.515907f, -4.14108f, 0.0336960f, -0.515907f, -4.14108f, 
		0.0336960f, -0.515907f, -4.14108f, -1.24665f, -0.515907f, -4.14108f, 
		-1.24665f, -0.515907f, -4.14108f, -1.24665f, -0.515907f, -4.14108f, 
		-1.24665f, -0.515907f, -4.14108f, -1.29792f, -0.518136f, -4.57879f, 
		-1.29792f, -0.518136f, -4.57879f, -1.29792f, -0.518136f, -4.57879f, 
		-1.29792f, -0.518136f, -4.09937f, -1.29792f, -0.518136f, -4.09937f, 
		-1.29792f, -0.518136f, -4.09937f, -1.29792f, -0.518136f, -4.09937f, 
		0.0849600f, -0.518136f, -4.57879f, 0.0849600f, -0.518136f, -4.57879f, 
		0.0849600f, -0.518136f, -4.57879f, 0.0849600f, -0.518136f, -4.09937f, 
		0.0849600f, -0.518136f, -4.09937f, 0.0849600f, -0.518136f, -4.09937f, 
		0.0849600f, -0.518136f, -4.09937f, -1.29792f, -0.480385f, -4.57879f, 
		-1.29792f, -0.480385f, -4.57879f, -1.29792f, -0.480385f, -4.57879f, 
		0.0849600f, -0.480385f, -4.57879f, 0.0849600f, -0.480385f, -4.57879f, 
		0.0849600f, -0.480385f, -4.57879f, -1.29792f, -0.480385f, -4.09937f, 
		-1.29792f, -0.480385f, -4.09937f, -1.29792f, -0.480385f, -4.09937f, 
		-1.29792f, -0.480385f, -4.09937f, 0.0849600f, -0.480385f, -4.09937f, 
		0.0849600f, -0.480385f, -4.09937f, 0.0849600f, -0.480385f, -4.09937f, 
		0.0849600f, -0.480385f, -4.09937f, -0.290159f, -0.872695f, -4.53707f, 
		-0.290159f, -0.872695f, -4.53707f, -0.922047f, -0.872695f, -4.53707f, 
		-0.922047f, -0.872695f, -4.53707f, -0.290159f, -0.482614f, -4.53707f, 
		-0.290159f, -0.482614f, -4.53707f, -0.290159f, -0.482614f, -4.53707f, 
		-0.922047f, -0.482614f, -4.53707f, -0.922047f, -0.482614f, -4.53707f, 
		-0.290159f, -0.872695f, -4.14108f, -0.290159f, -0.872695f, -4.14108f, 
		-0.922047f, -0.872695f, -4.14108f, -0.922047f, -0.872695f, -4.14108f, 
		-0.290159f, -0.482614f, -4.14108f, -0.290159f, -0.482614f, -4.14108f, 
		-0.290159f, -0.482614f, -4.14108f, -0.290159f, -0.482614f, -4.14108f, 
		-0.922047f, -0.482614f, -4.14108f, -0.922047f, -0.482614f, -4.14108f, 
		-0.290159f, -0.515907f, -4.53707f, -0.922047f, -0.515907f, -4.53707f, 
		-0.290159f, -0.515907f, -4.14108f, -0.290159f, -0.515907f, -4.14108f, 
		-0.922047f, -0.515907f, -4.14108f, -0.922047f, -0.515907f, -4.14108f, 
		-0.921873f, -0.518136f, -4.09937f, -0.921873f, -0.518136f, -4.09937f, 
		-0.289793f, -0.518136f, -4.09937f, -0.289793f, -0.518136f, -4.09937f, 
		-0.921873f, -0.480385f, -4.09937f, -0.921873f, -0.480385f, -4.09937f, 
		-0.289793f, -0.480385f, -4.09937f, -0.289793f, -0.480385f, -4.09937f, 
		0.0336960f, -0.753766f, -4.53707f, 0.0336960f, -0.753766f, -4.53707f, 
		0.0336960f, -0.634836f, -4.53707f, 0.0336960f, -0.634836f, -4.53707f, 
		-1.24665f, -0.753765f, -4.53707f, -1.24665f, -0.753765f, -4.53707f, 
		-1.24665f, -0.634836f, -4.53707f, -1.24665f, -0.634836f, -4.53707f, 
		0.0336960f, -0.753766f, -4.14108f, 0.0336960f, -0.753766f, -4.14108f, 
		0.0336960f, -0.634836f, -4.14108f, 0.0336960f, -0.634836f, -4.14108f, 
		-1.24665f, -0.753765f, -4.14108f, -1.24665f, -0.753765f, -4.14108f, 
		-1.24665f, -0.634836f, -4.14108f, -1.24665f, -0.634836f, -4.14108f, 
		-0.290159f, -0.753766f, -4.53707f, -0.290159f, -0.634836f, -4.53707f, 
		-0.922047f, -0.753766f, -4.53707f, -0.922047f, -0.634836f, -4.53707f, 
		-0.922047f, -0.753766f, -4.14108f, -0.922047f, -0.634836f, -4.14108f, 
		-0.290159f, -0.753766f, -4.14108f, -0.290159f, -0.634836f, -4.14108f, 
		-0.0289770f, -0.666022f, -4.15445f, -0.0289770f, -0.666022f, -4.15445f, 
		-0.0289770f, -0.666022f, -4.15445f, -0.0456520f, -0.857332f, -4.15445f, 
		-0.0456520f, -0.857332f, -4.15445f, -0.0456520f, -0.857332f, -4.15445f, 
		-0.280501f, -0.817339f, -4.15445f, -0.280501f, -0.817339f, -4.15445f, 
		-0.280501f, -0.817339f, -4.15445f, -0.211554f, -0.653685f, -4.15445f, 
		-0.211554f, -0.653685f, -4.15445f, -0.211554f, -0.653685f, -4.15445f, 
		-0.162801f, -0.860253f, -4.15445f, -0.162801f, -0.860253f, -4.15445f, 
		-0.162801f, -0.860253f, -4.15445f, -0.0143080f, -0.763889f, -4.15445f, 
		-0.0143080f, -0.763889f, -4.15445f, -0.0143080f, -0.763889f, -4.15445f, 
		-0.116880f, -0.621015f, -4.15445f, -0.116880f, -0.621015f, -4.15445f, 
		-0.116880f, -0.621015f, -4.15445f, -0.272164f, -0.721685f, -4.15445f, 
		-0.272164f, -0.721685f, -4.15445f, -0.272164f, -0.721685f, -4.15445f, 
		-0.128377f, -0.752919f, -4.15445f, -0.280501f, -0.817339f, -4.11497f, 
		-0.280501f, -0.817339f, -4.11497f, -0.280501f, -0.817339f, -4.11497f, 
		-0.272164f, -0.721685f, -4.12592f, -0.272164f, -0.721685f, -4.12592f, 
		-0.272164f, -0.721685f, -4.12592f, -0.272164f, -0.721685f, -4.12592f, 
		-0.211554f, -0.653685f, -4.11497f, -0.211554f, -0.653685f, -4.11497f, 
		-0.211554f, -0.653685f, -4.11497f, -0.116880f, -0.621015f, -4.11497f, 
		-0.116880f, -0.621015f, -4.11497f, -0.116880f, -0.621015f, -4.11497f, 
		-0.116880f, -0.621015f, -4.11497f, -0.0289770f, -0.666022f, -4.11497f, 
		-0.0289770f, -0.666022f, -4.11497f, -0.0289770f, -0.666022f, -4.11497f, 
		-0.0456520f, -0.857332f, -4.11497f, -0.0456520f, -0.857332f, -4.11497f, 
		-0.0456520f, -0.857332f, -4.11497f, -0.0143080f, -0.763889f, -4.11497f, 
		-0.0143080f, -0.763889f, -4.11497f, -0.0143080f, -0.763889f, -4.11497f, 
		-0.0143080f, -0.763889f, -4.11497f, -0.162801f, -0.860253f, -4.11497f, 
		-0.162801f, -0.860253f, -4.11497f, -0.162801f, -0.860253f, -4.11497f, 
		-0.162801f, -0.860253f, -4.11497f, -0.128377f, -0.752919f, -4.10963f, 
		-0.128377f, -0.752919f, -4.10963f, -0.128377f, -0.752919f, -4.10963f, 
		-0.128377f, -0.752919f, -4.10963f, -0.229020f, -0.581794f, -4.12165f, 
		-0.235899f, -0.627635f, -4.12165f, -0.235899f, -0.627635f, -4.12165f, 
		-0.235899f, -0.627635f, -4.12165f, -0.139518f, -0.613568f, -4.12165f, 
		-0.139518f, -0.613568f, -4.12165f, -0.139518f, -0.613568f, -4.12165f, 
		-0.194723f, -0.633250f, -4.12165f, -0.194723f, -0.633250f, -4.12165f, 
		-0.194723f, -0.633250f, -4.12165f, -0.171834f, -0.526758f, -4.12165f, 
		-0.171834f, -0.526758f, -4.12165f, -0.171834f, -0.526758f, -4.12165f, 
		-0.224019f, -0.524415f, -4.12165f, -0.224019f, -0.524415f, -4.12165f, 
		-0.224019f, -0.524415f, -4.12165f, -0.272651f, -0.523209f, -4.12165f, 
		-0.272651f, -0.523209f, -4.12165f, -0.272651f, -0.523209f, -4.12165f, 
		-0.288376f, -0.570815f, -4.12165f, -0.288376f, -0.570815f, -4.12165f, 
		-0.288376f, -0.570815f, -4.12165f, -0.293259f, -0.602381f, -4.12165f, 
		-0.293259f, -0.602381f, -4.12165f, -0.293259f, -0.602381f, -4.12165f, 
		-0.229020f, -0.581794f, -4.14154f, -0.288376f, -0.570815f, -4.14154f, 
		-0.288376f, -0.570815f, -4.14154f, -0.288376f, -0.570815f, -4.14154f, 
		-0.224019f, -0.524415f, -4.14154f, -0.224019f, -0.524415f, -4.14154f, 
		-0.224019f, -0.524415f, -4.14154f, -0.139518f, -0.613568f, -4.14154f, 
		-0.139518f, -0.613568f, -4.14154f, -0.139518f, -0.613568f, -4.14154f, 
		-0.235899f, -0.627635f, -4.14154f, -0.235899f, -0.627635f, -4.14154f, 
		-0.235899f, -0.627635f, -4.14154f, -0.272651f, -0.523209f, -4.14154f, 
		-0.272651f, -0.523209f, -4.14154f, -0.272651f, -0.523209f, -4.14154f, 
		-0.293259f, -0.602381f, -4.14154f, -0.293259f, -0.602381f, -4.14154f, 
		-0.293259f, -0.602381f, -4.14154f, -0.194723f, -0.633250f, -4.14154f, 
		-0.194723f, -0.633250f, -4.14154f, -0.194723f, -0.633250f, -4.14154f, 
		-0.171834f, -0.526758f, -4.14154f, -0.171834f, -0.526758f, -4.14154f, 
		-0.171834f, -0.526758f, -4.14154f, 0.00786500f, -0.524869f, -4.14479f, 
		0.00786500f, -0.524869f, -4.14479f, 0.00786500f, -0.524869f, -4.14479f, 
		-0.0321450f, -0.646775f, -4.14479f, -0.0321450f, -0.646775f, -4.14479f, 
		-0.0321450f, -0.646775f, -4.14479f, -0.128155f, -0.611176f, -4.14479f, 
		-0.128155f, -0.611176f, -4.14479f, -0.128155f, -0.611176f, -4.14479f, 
		-0.160148f, -0.524650f, -4.14479f, -0.160148f, -0.524650f, -4.14479f, 
		-0.160148f, -0.524650f, -4.14479f, -0.0663650f, -0.631859f, -4.14479f, 
		-0.0663650f, -0.631859f, -4.14479f, -0.0663650f, -0.631859f, -4.14479f, 
		0.00729900f, -0.606914f, -4.14479f, 0.00729900f, -0.606914f, -4.14479f, 
		0.00729900f, -0.606914f, -4.14479f, -0.0551280f, -0.527995f, -4.14479f, 
		-0.0551280f, -0.527995f, -4.14479f, -0.0551280f, -0.527995f, -4.14479f, 
		-0.148053f, -0.567177f, -4.14479f, -0.148053f, -0.567177f, -4.14479f, 
		-0.148053f, -0.567177f, -4.14479f, -0.0593400f, -0.581289f, -4.14479f, 
		-0.128155f, -0.611176f, -4.12168f, -0.128155f, -0.611176f, -4.12168f, 
		-0.128155f, -0.611176f, -4.12168f, -0.148053f, -0.567177f, -4.12168f, 
		-0.148053f, -0.567177f, -4.12168f, -0.148053f, -0.567177f, -4.12168f, 
		-0.160148f, -0.524650f, -4.12168f, -0.160148f, -0.524650f, -4.12168f, 
		-0.160148f, -0.524650f, -4.12168f, -0.0551280f, -0.527995f, -4.12168f, 
		-0.0551280f, -0.527995f, -4.12168f, -0.0551280f, -0.527995f, -4.12168f, 
		0.00786500f, -0.524868f, -4.12168f, 0.00786500f, -0.524868f, -4.12168f, 
		0.00786500f, -0.524868f, -4.12168f, -0.0321450f, -0.646775f, -4.12168f, 
		-0.0321450f, -0.646775f, -4.12168f, -0.0321450f, -0.646775f, -4.12168f, 
		0.00729900f, -0.606914f, -4.12168f, 0.00729900f, -0.606914f, -4.12168f, 
		0.00729900f, -0.606914f, -4.12168f, -0.0663650f, -0.631859f, -4.12168f, 
		-0.0663650f, -0.631859f, -4.12168f, -0.0663650f, -0.631859f, -4.12168f, 
		-0.0593400f, -0.581289f, -4.12168f, -0.392317f, -0.805920f, -4.12663f, 
		-0.392317f, -0.805920f, -4.12663f, -0.392317f, -0.805920f, -4.12663f, 
		-0.392317f, -0.805920f, -4.12663f, -0.392317f, -0.805920f, -4.12663f, 
		-0.356609f, -0.730533f, -4.12168f, -0.356609f, -0.730533f, -4.12168f, 
		-0.356609f, -0.730533f, -4.12168f, -0.356609f, -0.730533f, -4.12168f, 
		-0.460829f, -0.786492f, -4.12168f, -0.460829f, -0.786492f, -4.12168f, 
		-0.460829f, -0.786492f, -4.12168f, -0.460829f, -0.786492f, -4.12168f, 
		-0.424843f, -0.743172f, -4.12168f, -0.424843f, -0.743172f, -4.12168f, 
		-0.424843f, -0.743172f, -4.12168f, -0.456427f, -0.861476f, -4.12168f, 
		-0.456427f, -0.861476f, -4.12168f, -0.456427f, -0.861476f, -4.12168f, 
		-0.390230f, -0.852880f, -4.12168f, -0.390230f, -0.852880f, -4.12168f, 
		-0.390230f, -0.852880f, -4.12168f, -0.390230f, -0.852880f, -4.12168f, 
		-0.198918f, -0.860566f, -4.12168f, -0.198918f, -0.860566f, -4.12168f, 
		-0.198918f, -0.860566f, -4.12168f, -0.300365f, -0.820193f, -4.12168f, 
		-0.300365f, -0.820193f, -4.12168f, -0.300365f, -0.820193f, -4.12168f, 
		-0.300365f, -0.820193f, -4.12168f, -0.300365f, -0.820193f, -4.12168f, 
		-0.293083f, -0.771881f, -4.12168f, -0.293083f, -0.771881f, -4.12168f, 
		-0.293083f, -0.771881f, -4.12168f, -0.392317f, -0.805920f, -4.14479f, 
		-0.300365f, -0.820193f, -4.14479f, -0.300365f, -0.820193f, -4.14479f, 
		-0.300365f, -0.820193f, -4.14479f, -0.390230f, -0.852880f, -4.14479f, 
		-0.390230f, -0.852880f, -4.14479f, -0.390230f, -0.852880f, -4.14479f, 
		-0.460829f, -0.786492f, -4.14479f, -0.460829f, -0.786492f, -4.14479f, 
		-0.460829f, -0.786492f, -4.14479f, -0.356609f, -0.730533f, -4.14479f, 
		-0.356609f, -0.730533f, -4.14479f, -0.356609f, -0.730533f, -4.14479f, 
		-0.198918f, -0.860566f, -4.14479f, -0.198918f, -0.860566f, -4.14479f, 
		-0.198918f, -0.860566f, -4.14479f, -0.293083f, -0.771881f, -4.14479f, 
		-0.293083f, -0.771881f, -4.14479f, -0.293083f, -0.771881f, -4.14479f, 
		-0.424843f, -0.743172f, -4.14479f, -0.424843f, -0.743172f, -4.14479f, 
		-0.424843f, -0.743172f, -4.14479f, -0.456427f, -0.861476f, -4.14479f, 
		-0.456427f, -0.861476f, -4.14479f, -0.456427f, -0.861476f, -4.14479f, 
		0.0487640f, -0.606497f, -4.12545f, 0.0487640f, -0.606497f, -4.12545f, 
		0.0487640f, -0.606497f, -4.12545f, 0.0507020f, -0.864068f, -4.12545f, 
		0.0507020f, -0.864068f, -4.12545f, 0.0507020f, -0.864068f, -4.12545f, 
		-0.0329470f, -0.861881f, -4.12545f, -0.0329470f, -0.861881f, -4.12545f, 
		-0.0329470f, -0.861881f, -4.12545f, 0.0155830f, -0.605201f, -4.12545f, 
		0.0155830f, -0.605201f, -4.12545f, 0.0155830f, -0.605201f, -4.12545f, 
		0.0130470f, -0.864174f, -4.12545f, 0.0130470f, -0.864174f, -4.12545f, 
		0.0130470f, -0.864174f, -4.12545f, 0.0543400f, -0.702027f, -4.12545f, 
		0.0543400f, -0.702027f, -4.12545f, 0.0543400f, -0.702027f, -4.12545f, 
		0.0271420f, -0.604033f, -4.12545f, -0.0181210f, -0.656777f, -4.12545f, 
		-0.0181210f, -0.656777f, -4.12545f, -0.0181210f, -0.656777f, -4.12545f, 
		0.0195390f, -0.700528f, -4.12545f, 0.0195390f, -0.700528f, -4.21456f, 
		0.0195390f, -0.700528f, -4.21456f, 0.0195390f, -0.700528f, -4.21456f, 
		-0.0181210f, -0.656777f, -4.21456f, -0.0181210f, -0.656777f, -4.21456f, 
		-0.0181210f, -0.656777f, -4.21456f, 0.0271420f, -0.604033f, -4.21456f, 
		0.0271420f, -0.604033f, -4.21456f, 0.0466170f, -0.702027f, -4.20460f, 
		0.0466170f, -0.702027f, -4.20460f, 0.0466170f, -0.702027f, -4.20460f, 
		0.0466170f, -0.702027f, -4.20460f, 0.0130470f, -0.864174f, -4.21456f, 
		0.0130470f, -0.864174f, -4.21456f, 0.0130470f, -0.864174f, -4.21456f, 
		0.0130470f, -0.864174f, -4.21456f, 0.0155830f, -0.605201f, -4.21456f, 
		0.0155830f, -0.605201f, -4.21456f, 0.0155830f, -0.605201f, -4.21456f, 
		-0.0329470f, -0.861881f, -4.21456f, -0.0329470f, -0.861881f, -4.21456f, 
		-0.0329470f, -0.861881f, -4.21456f, 0.0504500f, -0.854257f, -4.22141f, 
		0.0504500f, -0.854257f, -4.22141f, 0.0504500f, -0.854257f, -4.22141f, 
		0.0487640f, -0.606497f, -4.21456f, 0.0487640f, -0.606497f, -4.21456f, 
		0.0487640f, -0.606497f, -4.21456f, 0.0487640f, -0.606497f, -4.21456f, 
		-0.00325200f, -0.774310f, -4.12545f, -0.00325200f, -0.774310f, -4.12545f, 
		-0.00325200f, -0.774310f, -4.12545f, -0.0181210f, -0.656777f, -4.17001f, 
		-0.0181210f, -0.656777f, -4.17001f, -0.00325200f, -0.774310f, -4.21456f, 
		-0.00325200f, -0.774310f, -4.21456f, -0.00325200f, -0.774310f, -4.21456f, 
		-0.0329470f, -0.861881f, -4.17001f, -0.0329470f, -0.861881f, -4.17001f, 
		-0.00325200f, -0.774310f, -4.17001f, -0.00325200f, -0.774310f, -4.17001f, 
		0.0513800f, -0.524028f, -4.21456f, 0.0513800f, -0.524028f, -4.21456f, 
		0.0513800f, -0.524028f, -4.21456f, 0.0172050f, -0.525426f, -4.21456f, 
		0.0172050f, -0.525426f, -4.21456f, 0.0172050f, -0.525426f, -4.21456f, 
		0.0271420f, -0.523832f, -4.21456f, 0.0271420f, -0.523832f, -4.21456f, 
		0.0271420f, -0.523832f, -4.21456f, 0.0271420f, -0.523832f, -4.12545f, 
		0.0271420f, -0.523832f, -4.12545f, 0.0271420f, -0.523832f, -4.12545f, 
		0.0172050f, -0.525426f, -4.12545f, 0.0172050f, -0.525426f, -4.12545f, 
		0.0172050f, -0.525426f, -4.12545f, 0.0513800f, -0.524028f, -4.12545f, 
		0.0513800f, -0.524028f, -4.12545f, 0.0513800f, -0.524028f, -4.12545f, 
		-0.390617f, -0.652858f, -4.11664f, -0.390617f, -0.652858f, -4.11664f, 
		-0.390617f, -0.652858f, -4.11664f, -0.390617f, -0.652858f, -4.11664f, 
		-0.390617f, -0.652858f, -4.11664f, -0.390617f, -0.652858f, -4.11664f, 
		-0.403125f, -0.728755f, -4.12165f, -0.403125f, -0.728755f, -4.12165f, 
		-0.403125f, -0.728755f, -4.12165f, -0.403125f, -0.728755f, -4.12165f, 
		-0.403125f, -0.728755f, -4.12165f, -0.258428f, -0.695964f, -4.12165f, 
		-0.258428f, -0.695964f, -4.12165f, -0.258428f, -0.695964f, -4.12165f, 
		-0.258428f, -0.695964f, -4.12165f, -0.283608f, -0.765138f, -4.12165f, 
		-0.283608f, -0.765138f, -4.12165f, -0.283608f, -0.765138f, -4.12165f, 
		-0.333430f, -0.597821f, -4.12165f, -0.333430f, -0.597821f, -4.12165f, 
		-0.333430f, -0.597821f, -4.12165f, -0.385616f, -0.595479f, -4.12165f, 
		-0.385616f, -0.595479f, -4.12165f, -0.385616f, -0.595479f, -4.12165f, 
		-0.385616f, -0.595479f, -4.12165f, -0.385616f, -0.595479f, -4.12165f, 
		-0.408036f, -0.586914f, -4.12165f, -0.408036f, -0.586914f, -4.12165f, 
		-0.408036f, -0.586914f, -4.12165f, -0.457244f, -0.629416f, -4.12165f, 
		-0.457244f, -0.629416f, -4.12165f, -0.457244f, -0.629416f, -4.12165f, 
		-0.457244f, -0.629416f, -4.12165f, -0.444924f, -0.682014f, -4.12165f, 
		-0.444924f, -0.682014f, -4.12165f, -0.444924f, -0.682014f, -4.12165f, 
		-0.390617f, -0.652858f, -4.14154f, -0.457244f, -0.629416f, -4.14154f, 
		-0.457244f, -0.629416f, -4.14154f, -0.457244f, -0.629416f, -4.14154f, 
		-0.385616f, -0.595479f, -4.14154f, -0.385616f, -0.595479f, -4.14154f, 
		-0.385616f, -0.595479f, -4.14154f, -0.258428f, -0.695964f, -4.14154f, 
		-0.258428f, -0.695964f, -4.14154f, -0.258428f, -0.695964f, -4.14154f, 
		-0.403125f, -0.728755f, -4.14154f, -0.403125f, -0.728755f, -4.14154f, 
		-0.403125f, -0.728755f, -4.14154f, -0.408036f, -0.586914f, -4.14154f, 
		-0.408036f, -0.586914f, -4.14154f, -0.408036f, -0.586914f, -4.14154f, 
		-0.444924f, -0.682014f, -4.14154f, -0.444924f, -0.682014f, -4.14154f, 
		-0.444924f, -0.682014f, -4.14154f, -0.283608f, -0.765138f, -4.14154f, 
		-0.283608f, -0.765138f, -4.14154f, -0.283608f, -0.765138f, -4.14154f, 
		-0.333430f, -0.597821f, -4.14154f, -0.333430f, -0.597821f, -4.14154f, 
		-0.333430f, -0.597821f, -4.14154f, -0.258428f, -0.695964f, -4.13159f, 
		-0.258428f, -0.695964f, -4.13159f, -0.311127f, -0.701124f, -4.12165f, 
		-0.311127f, -0.701124f, -4.12165f, -0.311127f, -0.701124f, -4.12165f, 
		-0.311127f, -0.701124f, -4.12165f, -0.311127f, -0.701124f, -4.12165f, 
		-0.283608f, -0.765138f, -4.13159f, -0.283608f, -0.765138f, -4.13159f, 
		-0.311127f, -0.701124f, -4.14154f, -0.311127f, -0.701124f, -4.14154f, 
		-0.311127f, -0.701124f, -4.14154f, -0.311127f, -0.701124f, -4.13159f, 
		-0.311127f, -0.701124f, -4.13159f, -0.223105f, -0.648026f, -4.12165f, 
		-0.223105f, -0.648026f, -4.12165f, -0.223105f, -0.648026f, -4.12165f, 
		-0.223105f, -0.648026f, -4.12165f, -0.223105f, -0.648026f, -4.12165f, 
		-0.333430f, -0.597821f, -4.13159f, -0.333430f, -0.597821f, -4.13159f, 
		-0.223105f, -0.648026f, -4.14154f, -0.223105f, -0.648026f, -4.14154f, 
		-0.223105f, -0.648026f, -4.14154f, -0.258428f, -0.695964f, -4.12662f, 
		-0.258428f, -0.695964f, -4.12662f, -0.258428f, -0.695964f, -4.13657f, 
		-0.258428f, -0.695964f, -4.13657f, -0.223105f, -0.648026f, -4.12662f, 
		-0.223105f, -0.648026f, -4.12662f, -0.223105f, -0.648026f, -4.13657f, 
		-0.223105f, -0.648026f, -4.13657f, -0.345140f, -0.723474f, -4.12165f, 
		-0.345140f, -0.723474f, -4.12165f, -0.345140f, -0.723474f, -4.12165f, 
		-0.403125f, -0.728755f, -4.13159f, -0.403125f, -0.728755f, -4.13159f, 
		-0.345140f, -0.723474f, -4.14154f, -0.345140f, -0.723474f, -4.14154f, 
		-0.345140f, -0.723474f, -4.14154f, -0.283608f, -0.765138f, -4.12662f, 
		-0.283608f, -0.765138f, -4.12662f, -0.283608f, -0.765138f, -4.13657f, 
		-0.283608f, -0.765138f, -4.13657f, -0.345140f, -0.723474f, -4.13657f, 
		-0.345140f, -0.723474f, -4.13657f, -0.345140f, -0.723474f, -4.12662f, 
		-0.345140f, -0.723474f, -4.12662f, -0.275377f, -0.709286f, -4.12165f, 
		-0.275377f, -0.709286f, -4.12165f, -0.275377f, -0.709286f, -4.12165f, 
		-0.275377f, -0.709286f, -4.14154f, -0.275377f, -0.709286f, -4.14154f, 
		-0.275377f, -0.709286f, -4.14154f, -0.275377f, -0.709286f, -4.13159f, 
		-0.275377f, -0.709286f, -4.13159f, -0.311127f, -0.701124f, -4.13657f, 
		-0.311127f, -0.701124f, -4.13657f, -0.311127f, -0.701124f, -4.12662f, 
		-0.311127f, -0.701124f, -4.12662f, -0.283608f, -0.765138f, -4.12414f, 
		-0.283608f, -0.765138f, -4.12414f, -0.283608f, -0.765138f, -4.12911f, 
		-0.283608f, -0.765138f, -4.12911f, -0.283608f, -0.765138f, -4.13408f, 
		-0.283608f, -0.765138f, -4.13408f, -0.283608f, -0.765138f, -4.13905f, 
		-0.283608f, -0.765138f, -4.13905f, -0.275377f, -0.709286f, -4.13408f, 
		-0.275377f, -0.709286f, -4.13408f, -0.275377f, -0.709286f, -4.13905f, 
		-0.275377f, -0.709286f, -4.13905f, -0.275377f, -0.709286f, -4.12414f, 
		-0.275377f, -0.709286f, -4.12414f, -0.275377f, -0.709286f, -4.12911f, 
		-0.275377f, -0.709286f, -4.12911f, -0.364885f, -0.556526f, -4.12321f, 
		-0.369284f, -0.585842f, -4.12321f, -0.369284f, -0.585842f, -4.12321f, 
		-0.369284f, -0.585842f, -4.12321f, -0.304871f, -0.597580f, -4.12321f, 
		-0.304871f, -0.597580f, -4.12321f, -0.304871f, -0.597580f, -4.12321f, 
		-0.342952f, -0.589433f, -4.12321f, -0.342952f, -0.589433f, -4.12321f, 
		-0.342952f, -0.589433f, -4.12321f, -0.282667f, -0.524569f, -4.12321f, 
		-0.282667f, -0.524569f, -4.12321f, -0.282667f, -0.524569f, -4.12321f, 
		-0.361687f, -0.519832f, -4.12321f, -0.361687f, -0.519832f, -4.12321f, 
		-0.361687f, -0.519832f, -4.12321f, -0.388024f, -0.521204f, -4.12321f, 
		-0.388024f, -0.521204f, -4.12321f, -0.388024f, -0.521204f, -4.12321f, 
		-0.404886f, -0.547837f, -4.12321f, -0.404886f, -0.547837f, -4.12321f, 
		-0.404886f, -0.547837f, -4.12321f, -0.399615f, -0.575172f, -4.12321f, 
		-0.399615f, -0.575172f, -4.12321f, -0.399615f, -0.575172f, -4.12321f, 
		-0.364885f, -0.556526f, -4.13998f, -0.404886f, -0.547837f, -4.13998f, 
		-0.404886f, -0.547837f, -4.13998f, -0.404886f, -0.547837f, -4.13998f, 
		-0.361687f, -0.519832f, -4.13998f, -0.361687f, -0.519832f, -4.13998f, 
		-0.361687f, -0.519832f, -4.13998f, -0.304871f, -0.597580f, -4.13998f, 
		-0.304871f, -0.597580f, -4.13998f, -0.304871f, -0.597580f, -4.13998f, 
		-0.369284f, -0.585842f, -4.13998f, -0.369284f, -0.585842f, -4.13998f, 
		-0.369284f, -0.585842f, -4.13998f, -0.388024f, -0.521204f, -4.13998f, 
		-0.388024f, -0.521204f, -4.13998f, -0.388024f, -0.521204f, -4.13998f, 
		-0.399615f, -0.575172f, -4.13998f, -0.399615f, -0.575172f, -4.13998f, 
		-0.399615f, -0.575172f, -4.13998f, -0.342952f, -0.589433f, -4.13998f, 
		-0.342952f, -0.589433f, -4.13998f, -0.342952f, -0.589433f, -4.13998f, 
		-0.282667f, -0.524569f, -4.13998f, -0.282667f, -0.524569f, -4.13998f, 
		-0.282667f, -0.524569f, -4.13998f, -0.582699f, -0.769337f, -4.11289f, 
		-0.582699f, -0.769337f, -4.11289f, -0.582699f, -0.769337f, -4.11289f, 
		-0.582699f, -0.769337f, -4.11289f, -0.580945f, -0.863901f, -4.11834f, 
		-0.580945f, -0.863901f, -4.11834f, -0.580945f, -0.863901f, -4.11834f, 
		-0.580945f, -0.863901f, -4.11834f, -0.481068f, -0.791023f, -4.11834f, 
		-0.481068f, -0.791023f, -4.11834f, -0.481068f, -0.791023f, -4.11834f, 
		-0.481068f, -0.791023f, -4.11834f, -0.472293f, -0.857749f, -4.11834f, 
		-0.472293f, -0.857749f, -4.11834f, -0.472293f, -0.857749f, -4.11834f, 
		-0.459993f, -0.689510f, -4.11834f, -0.459993f, -0.689510f, -4.11834f, 
		-0.459993f, -0.689510f, -4.11834f, -0.562514f, -0.678200f, -4.12705f, 
		-0.562514f, -0.678200f, -4.12705f, -0.562514f, -0.678200f, -4.12705f, 
		-0.562514f, -0.678200f, -4.12705f, -0.630685f, -0.668750f, -4.11834f, 
		-0.630685f, -0.668750f, -4.11834f, -0.630685f, -0.668750f, -4.11834f, 
		-0.674162f, -0.749469f, -4.11834f, -0.674162f, -0.749469f, -4.11834f, 
		-0.674162f, -0.749469f, -4.11834f, -0.674162f, -0.749469f, -4.11834f, 
		-0.666829f, -0.858552f, -4.11834f, -0.666829f, -0.858552f, -4.11834f, 
		-0.666829f, -0.858552f, -4.11834f, -0.582699f, -0.769337f, -4.14485f, 
		-0.674162f, -0.749469f, -4.14485f, -0.674162f, -0.749469f, -4.14485f, 
		-0.674162f, -0.749469f, -4.14485f, -0.562514f, -0.678200f, -4.14485f, 
		-0.562514f, -0.678200f, -4.14485f, -0.562514f, -0.678200f, -4.14485f, 
		-0.481068f, -0.791023f, -4.14485f, -0.481068f, -0.791023f, -4.14485f, 
		-0.481068f, -0.791023f, -4.14485f, -0.580945f, -0.863901f, -4.14485f, 
		-0.580945f, -0.863901f, -4.14485f, -0.580945f, -0.863901f, -4.14485f, 
		-0.630685f, -0.668750f, -4.14485f, -0.630685f, -0.668750f, -4.14485f, 
		-0.630685f, -0.668750f, -4.14485f, -0.666829f, -0.858552f, -4.14485f, 
		-0.666829f, -0.858552f, -4.14485f, -0.666829f, -0.858552f, -4.14485f, 
		-0.472293f, -0.857749f, -4.14485f, -0.472293f, -0.857749f, -4.14485f, 
		-0.472293f, -0.857749f, -4.14485f, -0.459993f, -0.689510f, -4.14485f, 
		-0.459993f, -0.689510f, -4.14485f, -0.459993f, -0.689510f, -4.14485f, 
		-0.409082f, -0.525206f, -4.13998f, -0.409082f, -0.525206f, -4.13998f, 
		-0.409082f, -0.525206f, -4.13998f, -0.484867f, -0.598210f, -4.13998f, 
		-0.484867f, -0.598210f, -4.13998f, -0.484867f, -0.598210f, -4.13998f, 
		-0.541531f, -0.583949f, -4.13998f, -0.541531f, -0.583949f, -4.13998f, 
		-0.541531f, -0.583949f, -4.13998f, -0.529940f, -0.529981f, -4.13998f, 
		-0.529940f, -0.529981f, -4.13998f, -0.529940f, -0.529981f, -4.13998f, 
		-0.511200f, -0.594619f, -4.13998f, -0.511200f, -0.594619f, -4.13998f, 
		-0.511200f, -0.594619f, -4.13998f, -0.446787f, -0.606358f, -4.13998f, 
		-0.446787f, -0.606358f, -4.13998f, -0.446787f, -0.606358f, -4.13998f, 
		-0.497076f, -0.522182f, -4.13998f, -0.497076f, -0.522182f, -4.13998f, 
		-0.497076f, -0.522182f, -4.13998f, -0.546801f, -0.556614f, -4.13998f, 
		-0.546801f, -0.556614f, -4.13998f, -0.546801f, -0.556614f, -4.13998f, 
		-0.506801f, -0.565303f, -4.13998f, -0.541531f, -0.583949f, -4.12321f, 
		-0.541531f, -0.583949f, -4.12321f, -0.541531f, -0.583949f, -4.12321f, 
		-0.546801f, -0.556614f, -4.12321f, -0.546801f, -0.556614f, -4.12321f, 
		-0.546801f, -0.556614f, -4.12321f, -0.529940f, -0.529981f, -4.12321f, 
		-0.529940f, -0.529981f, -4.12321f, -0.529940f, -0.529981f, -4.12321f, 
		-0.497076f, -0.522182f, -4.12321f, -0.497076f, -0.522182f, -4.12321f, 
		-0.497076f, -0.522182f, -4.12321f, -0.409082f, -0.525206f, -4.12321f, 
		-0.409082f, -0.525206f, -4.12321f, -0.409082f, -0.525206f, -4.12321f, 
		-0.484867f, -0.598210f, -4.12321f, -0.484867f, -0.598210f, -4.12321f, 
		-0.484867f, -0.598210f, -4.12321f, -0.446787f, -0.606358f, -4.12321f, 
		-0.446787f, -0.606358f, -4.12321f, -0.446787f, -0.606358f, -4.12321f, 
		-0.511200f, -0.594619f, -4.12321f, -0.511200f, -0.594619f, -4.12321f, 
		-0.511200f, -0.594619f, -4.12321f, -0.506801f, -0.565303f, -4.12321f, 
		-0.411823f, -0.578850f, -4.13998f, -0.411823f, -0.578850f, -4.13998f, 
		-0.411823f, -0.578850f, -4.13998f, -0.409082f, -0.525206f, -4.13159f, 
		-0.409082f, -0.525206f, -4.13159f, -0.446787f, -0.606358f, -4.13159f, 
		-0.446787f, -0.606358f, -4.13159f, -0.411823f, -0.578850f, -4.12321f, 
		-0.411823f, -0.578850f, -4.12321f, -0.411823f, -0.578850f, -4.12321f, 
		-0.411823f, -0.578850f, -4.13159f, -0.411823f, -0.578850f, -4.13159f, 
		-0.640731f, -0.602347f, -4.13043f, -0.640731f, -0.602347f, -4.13043f, 
		-0.640731f, -0.602347f, -4.13043f, -0.640731f, -0.602347f, -4.13043f, 
		-0.640731f, -0.602347f, -4.13043f, -0.647610f, -0.648188f, -4.12165f, 
		-0.647610f, -0.648188f, -4.12165f, -0.647610f, -0.648188f, -4.12165f, 
		-0.647610f, -0.648188f, -4.12165f, -0.465718f, -0.617799f, -4.12165f, 
		-0.465718f, -0.617799f, -4.12165f, -0.465718f, -0.617799f, -4.12165f, 
		-0.465718f, -0.617799f, -4.12165f, -0.461692f, -0.675011f, -4.12165f, 
		-0.461692f, -0.675011f, -4.12165f, -0.461692f, -0.675011f, -4.12165f, 
		-0.554361f, -0.526622f, -4.12165f, -0.554361f, -0.526622f, -4.12165f, 
		-0.554361f, -0.526622f, -4.12165f, -0.629796f, -0.525136f, -4.12165f, 
		-0.629796f, -0.525136f, -4.12165f, -0.629796f, -0.525136f, -4.12165f, 
		-0.629796f, -0.525136f, -4.12165f, -0.629796f, -0.525136f, -4.12165f, 
		-0.709819f, -0.523883f, -4.12165f, -0.709819f, -0.523883f, -4.12165f, 
		-0.709819f, -0.523883f, -4.12165f, -0.693030f, -0.587060f, -4.12165f, 
		-0.693030f, -0.587060f, -4.12165f, -0.693030f, -0.587060f, -4.12165f, 
		-0.693030f, -0.587060f, -4.12165f, -0.695038f, -0.631504f, -4.12165f, 
		-0.695038f, -0.631504f, -4.12165f, -0.695038f, -0.631504f, -4.12165f, 
		-0.640731f, -0.602347f, -4.14154f, -0.693030f, -0.587060f, -4.14154f, 
		-0.693030f, -0.587060f, -4.14154f, -0.693030f, -0.587060f, -4.14154f, 
		-0.629796f, -0.525136f, -4.14154f, -0.629796f, -0.525136f, -4.14154f, 
		-0.629796f, -0.525136f, -4.14154f, -0.629796f, -0.525136f, -4.14154f, 
		-0.465718f, -0.617799f, -4.14154f, -0.465718f, -0.617799f, -4.14154f, 
		-0.465718f, -0.617799f, -4.14154f, -0.647610f, -0.648188f, -4.14154f, 
		-0.647610f, -0.648188f, -4.14154f, -0.647610f, -0.648188f, -4.14154f, 
		-0.709819f, -0.523883f, -4.14154f, -0.709819f, -0.523883f, -4.14154f, 
		-0.709819f, -0.523883f, -4.14154f, -0.695038f, -0.631504f, -4.14154f, 
		-0.695038f, -0.631504f, -4.14154f, -0.695038f, -0.631504f, -4.14154f, 
		-0.461692f, -0.675011f, -4.14154f, -0.461692f, -0.675011f, -4.14154f, 
		-0.461692f, -0.675011f, -4.14154f, -0.554361f, -0.526622f, -4.14154f, 
		-0.554361f, -0.526622f, -4.14154f, -0.554361f, -0.526622f, -4.14154f, 
		-0.531198f, -0.598815f, -4.12165f, -0.531198f, -0.598815f, -4.12165f, 
		-0.531198f, -0.598815f, -4.12165f, -0.531198f, -0.598815f, -4.12165f, 
		-0.531198f, -0.598815f, -4.12165f, -0.465718f, -0.617799f, -4.13159f, 
		-0.465718f, -0.617799f, -4.13159f, -0.554361f, -0.526622f, -4.13159f, 
		-0.554361f, -0.526622f, -4.13159f, -0.531198f, -0.598815f, -4.14154f, 
		-0.531198f, -0.598815f, -4.14154f, -0.531198f, -0.598815f, -4.14154f, 
		-0.531198f, -0.598815f, -4.14154f, -0.531198f, -0.598815f, -4.13159f, 
		-0.531198f, -0.598815f, -4.13159f, -0.555628f, -0.570431f, -4.12165f, 
		-0.555628f, -0.570431f, -4.12165f, -0.555628f, -0.570431f, -4.12165f, 
		-0.554361f, -0.526622f, -4.12662f, -0.554361f, -0.526622f, -4.12662f, 
		-0.554361f, -0.526622f, -4.13657f, -0.554361f, -0.526622f, -4.13657f, 
		-0.555628f, -0.570431f, -4.14154f, -0.555628f, -0.570431f, -4.14154f, 
		-0.555628f, -0.570431f, -4.14154f, -0.555628f, -0.570431f, -4.14154f, 
		-0.531198f, -0.598815f, -4.13657f, -0.531198f, -0.598815f, -4.13657f, 
		-0.555628f, -0.570431f, -4.13159f, -0.555628f, -0.570431f, -4.13159f, 
		-0.531198f, -0.598815f, -4.12662f, -0.531198f, -0.598815f, -4.12662f, 
		-0.555628f, -0.570431f, -4.13657f, -0.555628f, -0.570431f, -4.13657f, 
		-0.555628f, -0.570431f, -4.12662f, -0.555628f, -0.570431f, -4.12662f, 
		-0.436242f, -0.726280f, -4.12494f, -0.436242f, -0.726280f, -4.12494f, 
		-0.461857f, -0.769833f, -4.12494f, -0.461857f, -0.769833f, -4.12494f, 
		-0.461857f, -0.769833f, -4.12494f, -0.419343f, -0.729133f, -4.12494f, 
		-0.419343f, -0.729133f, -4.12494f, -0.419343f, -0.729133f, -4.12494f, 
		-0.451312f, -0.764661f, -4.12494f, -0.451312f, -0.764661f, -4.12494f, 
		-0.451312f, -0.764661f, -4.12494f, -0.427182f, -0.713558f, -4.12494f, 
		-0.427182f, -0.713558f, -4.12494f, -0.427182f, -0.713558f, -4.12494f, 
		-0.442266f, -0.697907f, -4.12494f, -0.442266f, -0.697907f, -4.12494f, 
		-0.442266f, -0.697907f, -4.12494f, -0.442266f, -0.697907f, -4.12494f, 
		-0.453396f, -0.695113f, -4.12494f, -0.453396f, -0.695113f, -4.12494f, 
		-0.453396f, -0.695113f, -4.12494f, -0.456078f, -0.715905f, -4.12494f, 
		-0.456078f, -0.715905f, -4.12494f, -0.456078f, -0.715905f, -4.12494f, 
		-0.456078f, -0.715905f, -4.12494f, -0.463220f, -0.742326f, -4.12494f, 
		-0.463220f, -0.742326f, -4.12494f, -0.463220f, -0.742326f, -4.12494f, 
		-0.436242f, -0.726280f, -4.13825f, -0.456078f, -0.715905f, -4.13825f, 
		-0.456078f, -0.715905f, -4.13825f, -0.456078f, -0.715905f, -4.13825f, 
		-0.442266f, -0.697907f, -4.13825f, -0.442266f, -0.697907f, -4.13825f, 
		-0.442266f, -0.697907f, -4.13825f, -0.419343f, -0.729133f, -4.13825f, 
		-0.419343f, -0.729133f, -4.13825f, -0.419343f, -0.729133f, -4.13825f, 
		-0.461857f, -0.769833f, -4.13825f, -0.461857f, -0.769833f, -4.13825f, 
		-0.461857f, -0.769833f, -4.13825f, -0.453396f, -0.695113f, -4.13825f, 
		-0.453396f, -0.695113f, -4.13825f, -0.453396f, -0.695113f, -4.13825f, 
		-0.463220f, -0.742326f, -4.13825f, -0.463220f, -0.742326f, -4.13825f, 
		-0.463220f, -0.742326f, -4.13825f, -0.451312f, -0.764661f, -4.13825f, 
		-0.451312f, -0.764661f, -4.13825f, -0.451312f, -0.764661f, -4.13825f, 
		-0.427182f, -0.713558f, -4.13825f, -0.427182f, -0.713558f, -4.13825f, 
		-0.427182f, -0.713558f, -4.13825f, -0.637153f, -0.658283f, -4.13825f, 
		-0.637153f, -0.658283f, -4.13825f, -0.637153f, -0.658283f, -4.13825f, 
		-0.671215f, -0.725778f, -4.13825f, -0.671215f, -0.725778f, -4.13825f, 
		-0.671215f, -0.725778f, -4.13825f, -0.700502f, -0.714621f, -4.13825f, 
		-0.700502f, -0.714621f, -4.13825f, -0.700502f, -0.714621f, -4.13825f, 
		-0.693870f, -0.642818f, -4.13825f, -0.693870f, -0.642818f, -4.13825f, 
		-0.693870f, -0.642818f, -4.13825f, -0.681760f, -0.730951f, -4.13825f, 
		-0.681760f, -0.730951f, -4.13825f, -0.681760f, -0.730951f, -4.13825f, 
		-0.648467f, -0.685035f, -4.13825f, -0.648467f, -0.685035f, -4.13825f, 
		-0.648467f, -0.685035f, -4.13825f, -0.682740f, -0.645612f, -4.13825f, 
		-0.682740f, -0.645612f, -4.13825f, -0.682740f, -0.645612f, -4.13825f, 
		-0.700490f, -0.668174f, -4.13825f, -0.700490f, -0.668174f, -4.13825f, 
		-0.700490f, -0.668174f, -4.13825f, -0.674943f, -0.680691f, -4.13825f, 
		-0.700502f, -0.714621f, -4.12494f, -0.700502f, -0.714621f, -4.12494f, 
		-0.700502f, -0.714621f, -4.12494f, -0.700490f, -0.668174f, -4.12494f, 
		-0.700490f, -0.668174f, -4.12494f, -0.700490f, -0.668174f, -4.12494f, 
		-0.693870f, -0.642818f, -4.12494f, -0.693870f, -0.642818f, -4.12494f, 
		-0.693870f, -0.642818f, -4.12494f, -0.682740f, -0.645612f, -4.12494f, 
		-0.682740f, -0.645612f, -4.12494f, -0.682740f, -0.645612f, -4.12494f, 
		-0.637153f, -0.658283f, -4.12494f, -0.637153f, -0.658283f, -4.12494f, 
		-0.637153f, -0.658283f, -4.12494f, -0.671215f, -0.725778f, -4.12494f, 
		-0.671215f, -0.725778f, -4.12494f, -0.671215f, -0.725778f, -4.12494f, 
		-0.648467f, -0.685035f, -4.12494f, -0.648467f, -0.685035f, -4.12494f, 
		-0.648467f, -0.685035f, -4.12494f, -0.681760f, -0.730951f, -4.12494f, 
		-0.681760f, -0.730951f, -4.12494f, -0.681760f, -0.730951f, -4.12494f, 
		-0.674943f, -0.680691f, -4.12494f, -0.818948f, -0.799951f, -4.12571f, 
		-0.818948f, -0.799951f, -4.12571f, -0.818948f, -0.799951f, -4.12571f, 
		-0.818948f, -0.799951f, -4.12571f, -0.820119f, -0.860029f, -4.12165f, 
		-0.820119f, -0.860029f, -4.12165f, -0.820119f, -0.860029f, -4.12165f, 
		-0.820119f, -0.860029f, -4.12165f, -0.675970f, -0.862026f, -4.12165f, 
		-0.675970f, -0.862026f, -4.12165f, -0.675970f, -0.862026f, -4.12165f, 
		-0.675970f, -0.862026f, -4.12165f, -0.781549f, -0.864439f, -4.12165f, 
		-0.781549f, -0.864439f, -4.12165f, -0.781549f, -0.864439f, -4.12165f, 
		-0.692561f, -0.747163f, -4.12165f, -0.692561f, -0.747163f, -4.12165f, 
		-0.692561f, -0.747163f, -4.12165f, -0.755013f, -0.737359f, -4.11408f, 
		-0.755013f, -0.737359f, -4.11408f, -0.755013f, -0.737359f, -4.11408f, 
		-0.755013f, -0.737359f, -4.11408f, -0.855130f, -0.744719f, -4.12165f, 
		-0.855130f, -0.744719f, -4.12165f, -0.855130f, -0.744719f, -4.12165f, 
		-0.881496f, -0.786364f, -4.12165f, -0.881496f, -0.786364f, -4.12165f, 
		-0.881496f, -0.786364f, -4.12165f, -0.881496f, -0.786364f, -4.12165f, 
		-0.861840f, -0.854586f, -4.12165f, -0.861840f, -0.854586f, -4.12165f, 
		-0.861840f, -0.854586f, -4.12165f, -0.818948f, -0.799951f, -4.14154f, 
		-0.881496f, -0.786364f, -4.14154f, -0.881496f, -0.786364f, -4.14154f, 
		-0.881496f, -0.786364f, -4.14154f, -0.755013f, -0.737359f, -4.14154f, 
		-0.755013f, -0.737359f, -4.14154f, -0.755013f, -0.737359f, -4.14154f, 
		-0.675970f, -0.862026f, -4.14154f, -0.675970f, -0.862026f, -4.14154f, 
		-0.675970f, -0.862026f, -4.14154f, -0.820119f, -0.860029f, -4.14154f, 
		-0.820119f, -0.860029f, -4.14154f, -0.820119f, -0.860029f, -4.14154f, 
		-0.855130f, -0.744719f, -4.14154f, -0.855130f, -0.744719f, -4.14154f, 
		-0.855130f, -0.744719f, -4.14154f, -0.861840f, -0.854586f, -4.14154f, 
		-0.861840f, -0.854586f, -4.14154f, -0.861840f, -0.854586f, -4.14154f, 
		-0.781549f, -0.864439f, -4.14154f, -0.781549f, -0.864439f, -4.14154f, 
		-0.781549f, -0.864439f, -4.14154f, -0.692561f, -0.747163f, -4.14154f, 
		-0.692561f, -0.747163f, -4.14154f, -0.692561f, -0.747163f, -4.14154f, 
		-0.813567f, -0.686712f, -4.12548f, -0.813567f, -0.686712f, -4.12548f, 
		-0.813567f, -0.686712f, -4.12548f, -0.813567f, -0.686712f, -4.12548f, 
		-0.756182f, -0.722948f, -4.12165f, -0.756182f, -0.722948f, -4.12165f, 
		-0.756182f, -0.722948f, -4.12165f, -0.756182f, -0.722948f, -4.12165f, 
		-0.708115f, -0.699027f, -4.12165f, -0.708115f, -0.699027f, -4.12165f, 
		-0.708115f, -0.699027f, -4.12165f, -0.708115f, -0.699027f, -4.12165f, 
		-0.711253f, -0.732013f, -4.12165f, -0.711253f, -0.732013f, -4.12165f, 
		-0.711253f, -0.732013f, -4.12165f, -0.708065f, -0.606304f, -4.12165f, 
		-0.708065f, -0.606304f, -4.12165f, -0.708065f, -0.606304f, -4.12165f, 
		-0.767622f, -0.618537f, -4.12165f, -0.767622f, -0.618537f, -4.12165f, 
		-0.767622f, -0.618537f, -4.12165f, -0.767622f, -0.618537f, -4.12165f, 
		-0.849749f, -0.615470f, -4.12165f, -0.849749f, -0.615470f, -4.12165f, 
		-0.849749f, -0.615470f, -4.12165f, -0.876115f, -0.657115f, -4.12165f, 
		-0.876115f, -0.657115f, -4.12165f, -0.876115f, -0.657115f, -4.12165f, 
		-0.876115f, -0.657115f, -4.12165f, -0.858023f, -0.730408f, -4.12165f, 
		-0.858023f, -0.730408f, -4.12165f, -0.858023f, -0.730408f, -4.12165f, 
		-0.813567f, -0.670702f, -4.14154f, -0.876115f, -0.657115f, -4.14154f, 
		-0.876115f, -0.657115f, -4.14154f, -0.876115f, -0.657115f, -4.14154f, 
		-0.767622f, -0.618537f, -4.14154f, -0.767622f, -0.618537f, -4.14154f, 
		-0.767622f, -0.618537f, -4.14154f, -0.708115f, -0.699027f, -4.14154f, 
		-0.708115f, -0.699027f, -4.14154f, -0.708115f, -0.699027f, -4.14154f, 
		-0.756182f, -0.722948f, -4.14154f, -0.756182f, -0.722948f, -4.14154f, 
		-0.756182f, -0.722948f, -4.14154f, -0.849749f, -0.615470f, -4.14154f, 
		-0.849749f, -0.615470f, -4.14154f, -0.849749f, -0.615470f, -4.14154f, 
		-0.858023f, -0.730408f, -4.14154f, -0.858023f, -0.730408f, -4.14154f, 
		-0.858023f, -0.730408f, -4.14154f, -0.711253f, -0.732013f, -4.14154f, 
		-0.711253f, -0.732013f, -4.14154f, -0.711253f, -0.732013f, -4.14154f, 
		-0.708065f, -0.606304f, -4.14154f, -0.708065f, -0.606304f, -4.14154f, 
		-0.708065f, -0.606304f, -4.14154f, -0.785940f, -0.563283f, -4.12165f, 
		-0.809715f, -0.607235f, -4.12165f, -0.809715f, -0.607235f, -4.12165f, 
		-0.809715f, -0.607235f, -4.12165f, -0.707928f, -0.589505f, -4.12165f, 
		-0.707928f, -0.589505f, -4.12165f, -0.707928f, -0.589505f, -4.12165f, 
		-0.760397f, -0.602531f, -4.12165f, -0.760397f, -0.602531f, -4.12165f, 
		-0.760397f, -0.602531f, -4.12165f, -0.722436f, -0.527867f, -4.12165f, 
		-0.722436f, -0.527867f, -4.12165f, -0.722436f, -0.527867f, -4.12165f, 
		-0.771064f, -0.525105f, -4.12165f, -0.771064f, -0.525105f, -4.12165f, 
		-0.771064f, -0.525105f, -4.12165f, -0.835604f, -0.526367f, -4.12165f, 
		-0.835604f, -0.526367f, -4.12165f, -0.835604f, -0.526367f, -4.12165f, 
		-0.824995f, -0.560915f, -4.12165f, -0.824995f, -0.560915f, -4.12165f, 
		-0.824995f, -0.560915f, -4.12165f, -0.835852f, -0.602186f, -4.12165f, 
		-0.835852f, -0.602186f, -4.12165f, -0.835852f, -0.602186f, -4.12165f, 
		-0.774611f, -0.563283f, -4.13884f, -0.774611f, -0.563283f, -4.13884f, 
		-0.774611f, -0.563283f, -4.13884f, -0.774611f, -0.563283f, -4.13884f, 
		-0.824995f, -0.560915f, -4.14154f, -0.824995f, -0.560915f, -4.14154f, 
		-0.824995f, -0.560915f, -4.14154f, -0.824995f, -0.560915f, -4.14154f, 
		-0.771064f, -0.525105f, -4.14154f, -0.771064f, -0.525105f, -4.14154f, 
		-0.771064f, -0.525105f, -4.14154f, -0.771064f, -0.525105f, -4.14154f, 
		-0.707928f, -0.589505f, -4.14154f, -0.707928f, -0.589505f, -4.14154f, 
		-0.707928f, -0.589505f, -4.14154f, -0.707928f, -0.589505f, -4.14154f, 
		-0.809715f, -0.607235f, -4.14154f, -0.809715f, -0.607235f, -4.14154f, 
		-0.809715f, -0.607235f, -4.14154f, -0.809715f, -0.607235f, -4.14154f, 
		-0.835604f, -0.526367f, -4.14154f, -0.835604f, -0.526367f, -4.14154f, 
		-0.835604f, -0.526367f, -4.14154f, -0.835852f, -0.602186f, -4.14154f, 
		-0.835852f, -0.602186f, -4.14154f, -0.835852f, -0.602186f, -4.14154f, 
		-0.760397f, -0.602531f, -4.14154f, -0.760397f, -0.602531f, -4.14154f, 
		-0.760397f, -0.602531f, -4.14154f, -0.722436f, -0.527867f, -4.14154f, 
		-0.722436f, -0.527867f, -4.14154f, -0.722436f, -0.527867f, -4.14154f, 
		-0.948974f, -0.598810f, -4.12363f, -0.948974f, -0.598810f, -4.12363f, 
		-0.948974f, -0.598810f, -4.12363f, -0.948974f, -0.598810f, -4.12363f, 
		-0.948974f, -0.598810f, -4.12363f, -0.921170f, -0.665195f, -4.12165f, 
		-0.921170f, -0.665195f, -4.12165f, -0.921170f, -0.665195f, -4.12165f, 
		-0.921170f, -0.665195f, -4.12165f, -0.849661f, -0.601296f, -4.12165f, 
		-0.849661f, -0.601296f, -4.12165f, -0.849661f, -0.601296f, -4.12165f, 
		-0.849661f, -0.601296f, -4.12165f, -0.885323f, -0.643146f, -4.12165f, 
		-0.885323f, -0.643146f, -4.12165f, -0.885323f, -0.643146f, -4.12165f, 
		-0.863648f, -0.524407f, -4.12165f, -0.863648f, -0.524407f, -4.12165f, 
		-0.863648f, -0.524407f, -4.12165f, -0.948669f, -0.527978f, -4.12165f, 
		-0.948669f, -0.527978f, -4.12165f, -0.948669f, -0.527978f, -4.12165f, 
		-0.948669f, -0.527978f, -4.12165f, -0.948669f, -0.527978f, -4.12165f, 
		-1.02695f, -0.527127f, -4.12165f, -1.02695f, -0.527127f, -4.12165f, 
		-1.02695f, -0.527127f, -4.12165f, -1.03263f, -0.580762f, -4.12165f, 
		-1.03263f, -0.580762f, -4.12165f, -1.03263f, -0.580762f, -4.12165f, 
		-1.03263f, -0.580762f, -4.12165f, -0.963415f, -0.663786f, -4.12165f, 
		-0.963415f, -0.663786f, -4.12165f, -0.963415f, -0.663786f, -4.12165f, 
		-0.953671f, -0.585356f, -4.14154f, -1.03263f, -0.580762f, -4.14154f, 
		-1.03263f, -0.580762f, -4.14154f, -1.03263f, -0.580762f, -4.14154f, 
		-0.948669f, -0.527978f, -4.14154f, -0.948669f, -0.527978f, -4.14154f, 
		-0.948669f, -0.527978f, -4.14154f, -0.849661f, -0.601296f, -4.14154f, 
		-0.849661f, -0.601296f, -4.14154f, -0.849661f, -0.601296f, -4.14154f, 
		-0.921170f, -0.665195f, -4.14154f, -0.921170f, -0.665195f, -4.14154f, 
		-0.921170f, -0.665195f, -4.14154f, -1.02695f, -0.527127f, -4.14154f, 
		-1.02695f, -0.527127f, -4.14154f, -1.02695f, -0.527127f, -4.14154f, 
		-0.963415f, -0.663786f, -4.14154f, -0.963415f, -0.663786f, -4.14154f, 
		-0.963415f, -0.663786f, -4.14154f, -0.885323f, -0.643146f, -4.14154f, 
		-0.885323f, -0.643146f, -4.14154f, -0.885323f, -0.643146f, -4.14154f, 
		-0.863648f, -0.524407f, -4.14154f, -0.863648f, -0.524407f, -4.14154f, 
		-0.863648f, -0.524407f, -4.14154f, -0.838598f, -0.567078f, -4.12165f, 
		-0.838598f, -0.567078f, -4.12165f, -0.838598f, -0.567078f, -4.12165f, 
		-0.838598f, -0.567078f, -4.12165f, -0.838598f, -0.567078f, -4.12165f, 
		-0.849661f, -0.601296f, -4.13159f, -0.849661f, -0.601296f, -4.13159f, 
		-0.863648f, -0.524407f, -4.13159f, -0.863648f, -0.524407f, -4.13159f, 
		-0.838598f, -0.567078f, -4.14154f, -0.838598f, -0.567078f, -4.14154f, 
		-0.838598f, -0.567078f, -4.14154f, -0.838598f, -0.567078f, -4.13159f, 
		-0.838598f, -0.567078f, -4.13159f, -0.844556f, -0.541801f, -4.12165f, 
		-0.844556f, -0.541801f, -4.12165f, -0.844556f, -0.541801f, -4.12165f, 
		-0.863648f, -0.524407f, -4.13657f, -0.863648f, -0.524407f, -4.13657f, 
		-0.863648f, -0.524407f, -4.12662f, -0.863648f, -0.524407f, -4.12662f, 
		-0.844556f, -0.541801f, -4.14154f, -0.844556f, -0.541801f, -4.14154f, 
		-0.844556f, -0.541801f, -4.14154f, -0.838598f, -0.567078f, -4.13657f, 
		-0.838598f, -0.567078f, -4.13657f, -0.844556f, -0.541801f, -4.13159f, 
		-0.844556f, -0.541801f, -4.13159f, -0.838598f, -0.567078f, -4.12662f, 
		-0.838598f, -0.567078f, -4.12662f, -0.844556f, -0.541801f, -4.13657f, 
		-0.844556f, -0.541801f, -4.13657f, -0.844556f, -0.541801f, -4.12662f, 
		-0.844556f, -0.541801f, -4.12662f, -0.867317f, -0.723842f, -4.13825f, 
		-0.867317f, -0.723842f, -4.13825f, -0.867317f, -0.723842f, -4.13825f, 
		-0.895412f, -0.776659f, -4.13825f, -0.895412f, -0.776659f, -4.13825f, 
		-0.895412f, -0.776659f, -4.13825f, -0.907320f, -0.754325f, -4.13825f, 
		-0.907320f, -0.754325f, -4.13825f, -0.907320f, -0.754325f, -4.13825f, 
		-0.896404f, -0.660270f, -4.13825f, -0.896404f, -0.660270f, -4.13825f, 
		-0.896404f, -0.660270f, -4.13825f, -0.905957f, -0.781832f, -4.13825f, 
		-0.905957f, -0.781832f, -4.13825f, -0.905957f, -0.781832f, -4.13825f, 
		-0.863443f, -0.741132f, -4.13825f, -0.863443f, -0.741132f, -4.13825f, 
		-0.863443f, -0.741132f, -4.13825f, -0.885394f, -0.656993f, -4.13825f, 
		-0.885394f, -0.656993f, -4.13825f, -0.885394f, -0.656993f, -4.13825f, 
		-0.906745f, -0.720020f, -4.13825f, -0.906745f, -0.720020f, -4.13825f, 
		-0.906745f, -0.720020f, -4.13825f, -0.880341f, -0.738278f, -4.13825f, 
		-0.907320f, -0.754325f, -4.12494f, -0.907320f, -0.754325f, -4.12494f, 
		-0.907320f, -0.754325f, -4.12494f, -0.906745f, -0.720020f, -4.12494f, 
		-0.906745f, -0.720020f, -4.12494f, -0.906745f, -0.720020f, -4.12494f, 
		-0.896404f, -0.660270f, -4.12494f, -0.896404f, -0.660270f, -4.12494f, 
		-0.896404f, -0.660270f, -4.12494f, -0.885394f, -0.656993f, -4.12494f, 
		-0.885394f, -0.656993f, -4.12494f, -0.885394f, -0.656993f, -4.12494f, 
		-0.867317f, -0.723842f, -4.12494f, -0.867317f, -0.723842f, -4.12494f, 
		-0.867317f, -0.723842f, -4.12494f, -0.895412f, -0.776659f, -4.12494f, 
		-0.895412f, -0.776659f, -4.12494f, -0.895412f, -0.776659f, -4.12494f, 
		-0.863443f, -0.741132f, -4.12494f, -0.863443f, -0.741132f, -4.12494f, 
		-0.863443f, -0.741132f, -4.12494f, -0.905957f, -0.781832f, -4.12494f, 
		-0.905957f, -0.781832f, -4.12494f, -0.905957f, -0.781832f, -4.12494f, 
		-0.880341f, -0.738278f, -4.12494f, -1.06067f, -0.802354f, -4.12549f, 
		-1.06067f, -0.802354f, -4.12549f, -1.06067f, -0.802354f, -4.12549f, 
		-1.06067f, -0.802354f, -4.12549f, -1.06067f, -0.802354f, -4.12549f, 
		-1.02970f, -0.863834f, -4.12165f, -1.02970f, -0.863834f, -4.12165f, 
		-1.02970f, -0.863834f, -4.12165f, -1.02970f, -0.863834f, -4.12165f, 
		-0.896720f, -0.803501f, -4.12165f, -0.896720f, -0.803501f, -4.12165f, 
		-0.896720f, -0.803501f, -4.12165f, -0.896720f, -0.803501f, -4.12165f, 
		-0.878723f, -0.860326f, -4.12024f, -0.878723f, -0.860326f, -4.12024f, 
		-0.878723f, -0.860326f, -4.12024f, -0.919731f, -0.727769f, -4.12165f, 
		-0.919731f, -0.727769f, -4.12165f, -0.919731f, -0.727769f, -4.12165f, 
		-1.05566f, -0.744976f, -4.12165f, -1.05566f, -0.744976f, -4.12165f, 
		-1.05566f, -0.744976f, -4.12165f, -1.05566f, -0.744976f, -4.12165f, 
		-1.05566f, -0.744976f, -4.12165f, -1.09685f, -0.747122f, -4.12165f, 
		-1.09685f, -0.747122f, -4.12165f, -1.09685f, -0.747122f, -4.12165f, 
		-1.12321f, -0.788767f, -4.12165f, -1.12321f, -0.788767f, -4.12165f, 
		-1.12321f, -0.788767f, -4.12165f, -1.12321f, -0.788767f, -4.12165f, 
		-1.11125f, -0.858879f, -4.12165f, -1.11125f, -0.858879f, -4.12165f, 
		-1.11125f, -0.858879f, -4.12165f, -1.06067f, -0.802354f, -4.14154f, 
		-1.12321f, -0.788767f, -4.14154f, -1.12321f, -0.788767f, -4.14154f, 
		-1.12321f, -0.788767f, -4.14154f, -1.05566f, -0.744976f, -4.14154f, 
		-1.05566f, -0.744976f, -4.14154f, -1.05566f, -0.744976f, -4.14154f, 
		-0.896720f, -0.803501f, -4.14154f, -0.896720f, -0.803501f, -4.14154f, 
		-0.896720f, -0.803501f, -4.14154f, -1.02970f, -0.863834f, -4.14154f, 
		-1.02970f, -0.863834f, -4.14154f, -1.02970f, -0.863834f, -4.14154f, 
		-1.09685f, -0.747122f, -4.14154f, -1.09685f, -0.747122f, -4.14154f, 
		-1.09685f, -0.747122f, -4.14154f, -1.11125f, -0.858879f, -4.14154f, 
		-1.11125f, -0.858879f, -4.14154f, -1.11125f, -0.858879f, -4.14154f, 
		-0.878723f, -0.860326f, -4.14154f, -0.878723f, -0.860326f, -4.14154f, 
		-0.878723f, -0.860326f, -4.14154f, -0.919731f, -0.727769f, -4.14154f, 
		-0.919731f, -0.727769f, -4.14154f, -0.919731f, -0.727769f, -4.14154f, 
		-0.921563f, -0.786487f, -4.12165f, -0.921563f, -0.786487f, -4.12165f, 
		-0.921563f, -0.786487f, -4.12165f, -0.921563f, -0.786487f, -4.12165f, 
		-0.921563f, -0.786487f, -4.12165f, -0.896720f, -0.803501f, -4.13159f, 
		-0.896720f, -0.803501f, -4.13159f, -0.919731f, -0.727769f, -4.13159f, 
		-0.919731f, -0.727769f, -4.13159f, -0.921563f, -0.786487f, -4.14154f, 
		-0.921563f, -0.786487f, -4.14154f, -0.921563f, -0.786487f, -4.14154f, 
		-0.921563f, -0.786487f, -4.13159f, -0.921563f, -0.786487f, -4.13159f, 
		-0.300778f, -0.863891f, -4.12168f, -0.300778f, -0.863891f, -4.12168f, 
		-0.300778f, -0.863891f, -4.12168f, -0.300778f, -0.863891f, -4.12168f, 
		-0.300778f, -0.863891f, -4.12168f, -0.390230f, -0.852880f, -4.13323f, 
		-0.390230f, -0.852880f, -4.13323f, -0.198918f, -0.860566f, -4.13323f, 
		-0.198918f, -0.860566f, -4.13323f, -0.300778f, -0.863891f, -4.14479f, 
		-0.300778f, -0.863891f, -4.14479f, -0.300778f, -0.863891f, -4.14479f, 
		-0.300778f, -0.863891f, -4.13323f, -0.300778f, -0.863891f, -4.13323f, 
		-1.08477f, -0.669195f, -4.12165f, -1.08477f, -0.669195f, -4.12165f, 
		-1.09434f, -0.733168f, -4.12165f, -1.09434f, -0.733168f, -4.12165f, 
		-1.09434f, -0.733168f, -4.12165f, -0.974117f, -0.669038f, -4.12165f, 
		-0.974117f, -0.669038f, -4.12165f, -0.974117f, -0.669038f, -4.12165f, 
		-1.01648f, -0.729717f, -4.12165f, -1.01648f, -0.729717f, -4.12165f, 
		-1.01648f, -0.729717f, -4.12165f, -1.01952f, -0.613507f, -4.12165f, 
		-1.01952f, -0.613507f, -4.12165f, -1.01952f, -0.613507f, -4.12165f, 
		-1.03992f, -0.590629f, -4.12165f, -1.03992f, -0.590629f, -4.12165f, 
		-1.03992f, -0.590629f, -4.12165f, -1.03992f, -0.590629f, -4.12165f, 
		-1.03992f, -0.590629f, -4.12165f, -1.10500f, -0.583906f, -4.11829f, 
		-1.10500f, -0.583906f, -4.11829f, -1.10500f, -0.583906f, -4.11829f, 
		-1.10500f, -0.583906f, -4.11829f, -1.14731f, -0.655608f, -4.12165f, 
		-1.14731f, -0.655608f, -4.12165f, -1.14731f, -0.655608f, -4.12165f, 
		-1.14731f, -0.655608f, -4.12165f, -1.16947f, -0.719855f, -4.12165f, 
		-1.16947f, -0.719855f, -4.12165f, -1.16947f, -0.719855f, -4.12165f, 
		-1.08477f, -0.669195f, -4.14154f, -1.14731f, -0.655608f, -4.14154f, 
		-1.14731f, -0.655608f, -4.14154f, -1.14731f, -0.655608f, -4.14154f, 
		-1.03992f, -0.590629f, -4.14154f, -1.03992f, -0.590629f, -4.14154f, 
		-1.03992f, -0.590629f, -4.14154f, -0.974117f, -0.669038f, -4.14154f, 
		-0.974117f, -0.669038f, -4.14154f, -0.974117f, -0.669038f, -4.14154f, 
		-1.09434f, -0.733168f, -4.14154f, -1.09434f, -0.733168f, -4.14154f, 
		-1.09434f, -0.733168f, -4.14154f, -1.10500f, -0.583906f, -4.14154f, 
		-1.10500f, -0.583906f, -4.14154f, -1.10500f, -0.583906f, -4.14154f, 
		-1.16947f, -0.719855f, -4.14154f, -1.16947f, -0.719855f, -4.14154f, 
		-1.16947f, -0.719855f, -4.14154f, -1.01648f, -0.729717f, -4.14154f, 
		-1.01648f, -0.729717f, -4.14154f, -1.01648f, -0.729717f, -4.14154f, 
		-1.01952f, -0.613507f, -4.14154f, -1.01952f, -0.613507f, -4.14154f, 
		-1.01952f, -0.613507f, -4.14154f, -1.08248f, -0.530199f, -4.14154f, 
		-1.08248f, -0.530199f, -4.14154f, -1.08248f, -0.530199f, -4.14154f, 
		-1.04130f, -0.528052f, -4.14154f, -1.04130f, -0.528052f, -4.14154f, 
		-1.04130f, -0.528052f, -4.14154f, -1.08248f, -0.530199f, -4.12165f, 
		-1.08248f, -0.530199f, -4.12165f, -1.08248f, -0.530199f, -4.12165f, 
		-1.04130f, -0.528052f, -4.12165f, -1.04130f, -0.528052f, -4.12165f, 
		-1.04130f, -0.528052f, -4.12165f, -0.952268f, -0.700102f, -4.12165f, 
		-0.971743f, -0.724186f, -4.12165f, -0.971743f, -0.724186f, -4.12165f, 
		-0.971743f, -0.724186f, -4.12165f, -0.914963f, -0.713254f, -4.12165f, 
		-0.914963f, -0.713254f, -4.12165f, -0.914963f, -0.713254f, -4.12165f, 
		-0.936673f, -0.723499f, -4.12165f, -0.936673f, -0.723499f, -4.12165f, 
		-0.936673f, -0.723499f, -4.12165f, -0.911152f, -0.673780f, -4.12165f, 
		-0.911152f, -0.673780f, -4.12165f, -0.911152f, -0.673780f, -4.12165f, 
		-0.942592f, -0.675955f, -4.12165f, -0.942592f, -0.675955f, -4.12165f, 
		-0.942592f, -0.675955f, -4.12165f, -0.968721f, -0.674987f, -4.12165f, 
		-0.968721f, -0.674987f, -4.12165f, -0.968721f, -0.674987f, -4.12165f, 
		-0.980709f, -0.693924f, -4.12165f, -0.980709f, -0.693924f, -4.12165f, 
		-0.980709f, -0.693924f, -4.12165f, -1.00475f, -0.729639f, -4.12165f, 
		-1.00475f, -0.729639f, -4.12165f, -1.00475f, -0.729639f, -4.12165f, 
		-0.952268f, -0.700102f, -4.14154f, -0.952268f, -0.700102f, -4.14154f, 
		-0.980709f, -0.693924f, -4.14154f, -0.980709f, -0.693924f, -4.14154f, 
		-0.980709f, -0.693924f, -4.14154f, -0.980709f, -0.693924f, -4.14154f, 
		-0.942592f, -0.675955f, -4.14154f, -0.942592f, -0.675955f, -4.14154f, 
		-0.942592f, -0.675955f, -4.14154f, -0.914963f, -0.713254f, -4.14154f, 
		-0.914963f, -0.713254f, -4.14154f, -0.914963f, -0.713254f, -4.14154f, 
		-0.971743f, -0.724186f, -4.14154f, -0.971743f, -0.724186f, -4.14154f, 
		-0.971743f, -0.724186f, -4.14154f, -0.971743f, -0.724186f, -4.14154f, 
		-0.968721f, -0.674987f, -4.14154f, -0.968721f, -0.674987f, -4.14154f, 
		-0.968721f, -0.674987f, -4.14154f, -0.977332f, -0.712762f, -4.13409f, 
		-0.977332f, -0.712762f, -4.13409f, -0.977332f, -0.712762f, -4.13409f, 
		-0.936673f, -0.723499f, -4.14154f, -0.936673f, -0.723499f, -4.14154f, 
		-0.936673f, -0.723499f, -4.14154f, -0.911152f, -0.673780f, -4.14154f, 
		-0.911152f, -0.673780f, -4.14154f, -0.911152f, -0.673780f, -4.14154f, 
		-1.27315f, -0.524028f, -4.12545f, -1.27315f, -0.524028f, -4.12545f, 
		-1.27315f, -0.524028f, -4.12545f, -1.24472f, -0.525426f, -4.12545f, 
		-1.24472f, -0.525426f, -4.12545f, -1.24472f, -0.525426f, -4.12545f, 
		-1.25465f, -0.523832f, -4.12545f, -1.25465f, -0.523832f, -4.12545f, 
		-1.25465f, -0.523832f, -4.12545f, -1.25465f, -0.523832f, -4.21456f, 
		-1.25465f, -0.523832f, -4.21456f, -1.25465f, -0.523832f, -4.21456f, 
		-1.25465f, -0.523832f, -4.21456f, -1.24472f, -0.525426f, -4.21456f, 
		-1.24472f, -0.525426f, -4.21456f, -1.24472f, -0.525426f, -4.21456f, 
		-1.27315f, -0.524028f, -4.21456f, -1.27315f, -0.524028f, -4.21456f, 
		-1.27315f, -0.524028f, -4.21456f, -1.13537f, -0.789171f, -4.17001f, 
		-1.13537f, -0.789171f, -4.17001f, -1.12675f, -0.863415f, -4.17001f, 
		-1.12675f, -0.863415f, -4.17001f, -1.12675f, -0.863415f, -4.17001f, 
		-1.12675f, -0.863415f, -4.17001f, -1.13537f, -0.789171f, -4.21456f, 
		-1.13537f, -0.789171f, -4.21456f, -1.13537f, -0.789171f, -4.21456f, 
		-1.13537f, -0.789171f, -4.21456f, -1.13537f, -0.789171f, -4.21456f, 
		-1.22490f, -0.667203f, -4.17001f, -1.22490f, -0.667203f, -4.17001f, 
		-1.13537f, -0.789171f, -4.12545f, -1.13537f, -0.789171f, -4.12545f, 
		-1.13537f, -0.789171f, -4.12545f, -1.13537f, -0.789171f, -4.12545f, 
		-1.13537f, -0.789171f, -4.12545f, -1.26884f, -0.606497f, -4.20560f, 
		-1.26884f, -0.606497f, -4.20560f, -1.26884f, -0.606497f, -4.20560f, 
		-1.26884f, -0.606497f, -4.20560f, -1.25693f, -0.864068f, -4.21456f, 
		-1.25693f, -0.864068f, -4.21456f, -1.25693f, -0.864068f, -4.21456f, 
		-1.12675f, -0.863415f, -4.21456f, -1.12675f, -0.863415f, -4.21456f, 
		-1.12675f, -0.863415f, -4.21456f, -1.20277f, -0.594775f, -4.21456f, 
		-1.20277f, -0.594775f, -4.21456f, -1.20277f, -0.594775f, -4.21456f, 
		-1.20277f, -0.594775f, -4.21456f, -1.24056f, -0.864173f, -4.21456f, 
		-1.24056f, -0.864173f, -4.21456f, -1.24056f, -0.864173f, -4.21456f, 
		-1.24056f, -0.864173f, -4.21456f, -1.24056f, -0.864173f, -4.21456f, 
		-1.24056f, -0.864173f, -4.21456f, -1.26431f, -0.751171f, -4.23469f, 
		-1.26431f, -0.751171f, -4.23469f, -1.26431f, -0.751171f, -4.23469f, 
		-1.26431f, -0.751171f, -4.23469f, -1.25595f, -0.604033f, -4.20560f, 
		-1.25595f, -0.604033f, -4.20560f, -1.25595f, -0.604033f, -4.20560f, 
		-1.25595f, -0.604033f, -4.20560f, -1.22490f, -0.667203f, -4.21456f, 
		-1.22490f, -0.667203f, -4.21456f, -1.22490f, -0.667203f, -4.21456f, 
		-1.22490f, -0.667203f, -4.21456f, -1.25386f, -0.749672f, -4.23469f, 
		-1.25386f, -0.749672f, -4.23469f, -1.25386f, -0.749672f, -4.23469f, 
		-1.25386f, -0.749672f, -4.23469f, -1.25386f, -0.749672f, -4.23469f, 
		-1.24705f, -0.700528f, -4.12980f, -1.24705f, -0.700528f, -4.12980f, 
		-1.24705f, -0.700528f, -4.12980f, -1.24705f, -0.700528f, -4.12980f, 
		-1.24705f, -0.700528f, -4.12980f, -1.22490f, -0.667203f, -4.12545f, 
		-1.22490f, -0.667203f, -4.12545f, -1.22490f, -0.667203f, -4.12545f, 
		-1.22490f, -0.667203f, -4.12545f, -1.26417f, -0.604033f, -4.12545f, 
		-1.26417f, -0.604033f, -4.12545f, -1.26417f, -0.604033f, -4.12545f, 
		-1.27611f, -0.702027f, -4.12545f, -1.27611f, -0.702027f, -4.12545f, 
		-1.27611f, -0.702027f, -4.12545f, -1.27611f, -0.702027f, -4.12545f, 
		-1.24056f, -0.864174f, -4.12545f, -1.24056f, -0.864174f, -4.12545f, 
		-1.24056f, -0.864174f, -4.12545f, -1.24056f, -0.864174f, -4.12545f, 
		-1.24056f, -0.864174f, -4.12545f, -1.24056f, -0.864174f, -4.12545f, 
		-1.20277f, -0.594775f, -4.12545f, -1.20277f, -0.594775f, -4.12545f, 
		-1.20277f, -0.594775f, -4.12545f, -1.20277f, -0.594775f, -4.12545f, 
		-1.12675f, -0.863415f, -4.12545f, -1.12675f, -0.863415f, -4.12545f, 
		-1.12675f, -0.863415f, -4.12545f, -1.25693f, -0.864068f, -4.12545f, 
		-1.25693f, -0.864068f, -4.12545f, -1.25693f, -0.864068f, -4.12545f, 
		-1.26451f, -0.606497f, -4.12545f, -1.26451f, -0.606497f, -4.12545f, 
		-1.26451f, -0.606497f, -4.12545f, -1.26451f, -0.606497f, -4.12545f, 
		-1.09434f, -0.733168f, -4.13159f, -1.09434f, -0.733168f, -4.13159f, 
		-1.13284f, -0.770171f, -4.12165f, -1.13284f, -0.770171f, -4.12165f, 
		-1.13284f, -0.770171f, -4.12165f, -1.16947f, -0.719855f, -4.13159f, 
		-1.16947f, -0.719855f, -4.13159f, -1.13284f, -0.770171f, -4.14154f, 
		-1.13284f, -0.770171f, -4.14154f, -1.13284f, -0.770171f, -4.14154f, 
		-1.13284f, -0.770171f, -4.13159f, -1.13284f, -0.770171f, -4.13159f, 
		-1.14645f, -0.636449f, -4.14154f, -1.14645f, -0.636449f, -4.14154f, 
		-1.14645f, -0.636449f, -4.14154f, -1.16360f, -0.680162f, -4.14154f, 
		-1.16360f, -0.680162f, -4.14154f, -1.16360f, -0.680162f, -4.14154f, 
		-1.19044f, -0.702095f, -4.14154f, -1.19044f, -0.702095f, -4.14154f, 
		-1.19044f, -0.702095f, -4.14154f, -1.20936f, -0.640114f, -4.14154f, 
		-1.20936f, -0.640114f, -4.14154f, -1.20936f, -0.640114f, -4.14154f, 
		-1.17652f, -0.710507f, -4.14154f, -1.17652f, -0.710507f, -4.14154f, 
		-1.17652f, -0.710507f, -4.14154f, -1.15331f, -0.652847f, -4.14154f, 
		-1.15331f, -0.652847f, -4.14154f, -1.15331f, -0.652847f, -4.14154f, 
		-1.18790f, -0.635590f, -4.14154f, -1.18790f, -0.635590f, -4.14154f, 
		-1.18790f, -0.635590f, -4.14154f, -1.21761f, -0.664498f, -4.14154f, 
		-1.21761f, -0.664498f, -4.14154f, -1.21761f, -0.664498f, -4.14154f, 
		-1.18570f, -0.651206f, -4.14154f, -1.19044f, -0.702095f, -4.12165f, 
		-1.19044f, -0.702095f, -4.12165f, -1.19044f, -0.702095f, -4.12165f, 
		-1.21761f, -0.664498f, -4.12165f, -1.21761f, -0.664498f, -4.12165f, 
		-1.21761f, -0.664498f, -4.12165f, -1.20936f, -0.640114f, -4.12165f, 
		-1.20936f, -0.640114f, -4.12165f, -1.20936f, -0.640114f, -4.12165f, 
		-1.18790f, -0.635590f, -4.12165f, -1.18790f, -0.635590f, -4.12165f, 
		-1.18790f, -0.635590f, -4.12165f, -1.14645f, -0.636449f, -4.12165f, 
		-1.14645f, -0.636449f, -4.12165f, -1.14645f, -0.636449f, -4.12165f, 
		-1.16360f, -0.680162f, -4.12165f, -1.16360f, -0.680162f, -4.12165f, 
		-1.16360f, -0.680162f, -4.12165f, -1.15331f, -0.652847f, -4.12165f, 
		-1.15331f, -0.652847f, -4.12165f, -1.15331f, -0.652847f, -4.12165f, 
		-1.17652f, -0.710507f, -4.12165f, -1.17652f, -0.710507f, -4.12165f, 
		-1.17652f, -0.710507f, -4.12165f, -1.18570f, -0.651206f, -4.12165f, 
		-1.16197f, -0.564761f, -4.12165f, -1.16518f, -0.625100f, -4.12165f, 
		-1.16518f, -0.625100f, -4.12165f, -1.16518f, -0.625100f, -4.12165f, 
		-1.16518f, -0.625100f, -4.12165f, -1.11707f, -0.581792f, -4.12165f, 
		-1.11707f, -0.581792f, -4.12165f, -1.11707f, -0.581792f, -4.12165f, 
		-1.14311f, -0.628110f, -4.12165f, -1.14311f, -0.628110f, -4.12165f, 
		-1.14311f, -0.628110f, -4.12165f, -1.09679f, -0.527063f, -4.12165f, 
		-1.09679f, -0.527063f, -4.12165f, -1.09679f, -0.527063f, -4.12165f, 
		-1.15882f, -0.530278f, -4.12165f, -1.15882f, -0.530278f, -4.12165f, 
		-1.15882f, -0.530278f, -4.12165f, -1.18515f, -0.526213f, -4.12165f, 
		-1.18515f, -0.526213f, -4.12165f, -1.18515f, -0.526213f, -4.12165f, 
		-1.22836f, -0.529534f, -4.12165f, -1.22836f, -0.529534f, -4.12165f, 
		-1.22836f, -0.529534f, -4.12165f, -1.19415f, -0.626589f, -4.12165f, 
		-1.19415f, -0.626589f, -4.12165f, -1.19415f, -0.626589f, -4.12165f, 
		-1.16504f, -0.564761f, -4.14154f, -1.22836f, -0.529534f, -4.14154f, 
		-1.22836f, -0.529534f, -4.14154f, -1.22836f, -0.529534f, -4.14154f, 
		-1.15882f, -0.530278f, -4.14154f, -1.15882f, -0.530278f, -4.14154f, 
		-1.15882f, -0.530278f, -4.14154f, -1.11707f, -0.581792f, -4.14154f, 
		-1.11707f, -0.581792f, -4.14154f, -1.11707f, -0.581792f, -4.14154f, 
		-1.16518f, -0.625100f, -4.14154f, -1.16518f, -0.625100f, -4.14154f, 
		-1.16518f, -0.625100f, -4.14154f, -1.18515f, -0.526213f, -4.14154f, 
		-1.18515f, -0.526213f, -4.14154f, -1.18515f, -0.526213f, -4.14154f, 
		-1.19415f, -0.626589f, -4.14154f, -1.19415f, -0.626589f, -4.14154f, 
		-1.19415f, -0.626589f, -4.14154f, -1.14311f, -0.628110f, -4.14154f, 
		-1.14311f, -0.628110f, -4.14154f, -1.14311f, -0.628110f, -4.14154f, 
		-1.09679f, -0.527063f, -4.14154f, -1.09679f, -0.527063f, -4.14154f, 
		-1.09679f, -0.527063f, -4.14154f, -1.19415f, -0.626589f, -4.13159f, 
		-1.19415f, -0.626589f, -4.13159f, -1.19211f, -0.596131f, -4.12165f, 
		-1.19211f, -0.596131f, -4.12165f, -1.19211f, -0.596131f, -4.12165f, 
		-1.19211f, -0.596131f, -4.12165f, -1.22836f, -0.529534f, -4.13159f, 
		-1.22836f, -0.529534f, -4.13159f, -1.19211f, -0.596131f, -4.14154f, 
		-1.19211f, -0.596131f, -4.14154f, -1.19211f, -0.596131f, -4.14154f, 
		-1.19211f, -0.596131f, -4.13159f, -1.19211f, -0.596131f, -4.13159f, 
		-1.24439f, -0.861908f, -4.39980f, -1.24439f, -0.744471f, -4.38423f, 
		-1.24439f, -0.744471f, -4.38423f, -1.24439f, -0.742128f, -4.33205f, 
		-1.24439f, -0.742128f, -4.33205f, -1.24439f, -0.744275f, -4.29086f, 
		-1.24439f, -0.744275f, -4.29086f, -1.24439f, -0.765687f, -4.24666f, 
		-1.25914f, -0.799507f, -4.32705f, -1.25914f, -0.799507f, -4.32705f, 
		-1.25914f, -0.799507f, -4.32705f, -1.25914f, -0.799507f, -4.32705f, 
		-1.26780f, -0.765687f, -4.24666f, -1.26780f, -0.765687f, -4.24666f, 
		-1.26780f, -0.765687f, -4.24666f, -1.26427f, -0.742128f, -4.33205f, 
		-1.26427f, -0.742128f, -4.33205f, -1.26427f, -0.742128f, -4.33205f, 
		-1.26427f, -0.742128f, -4.33205f, -1.26427f, -0.861908f, -4.39980f, 
		-1.26427f, -0.861908f, -4.39980f, -1.26427f, -0.861908f, -4.39980f, 
		-1.26427f, -0.855839f, -4.30376f, -1.26427f, -0.855839f, -4.30376f, 
		-1.26427f, -0.744275f, -4.29086f, -1.26427f, -0.744275f, -4.29086f, 
		-1.26427f, -0.744275f, -4.29086f, -1.26427f, -0.853393f, -4.23635f, 
		-1.26427f, -0.865950f, -4.35136f, -1.26427f, -0.744471f, -4.38423f, 
		-1.26427f, -0.744471f, -4.38423f, -1.26427f, -0.744471f, -4.38423f, 
		-1.24431f, -0.660620f, -4.33926f, -1.24431f, -0.724445f, -4.32738f, 
		-1.24431f, -0.724445f, -4.32738f, -1.24431f, -0.724445f, -4.32738f, 
		-1.24431f, -0.692393f, -4.42876f, -1.24431f, -0.692393f, -4.42876f, 
		-1.24431f, -0.692393f, -4.42876f, -1.24431f, -0.727715f, -4.38224f, 
		-1.24431f, -0.727715f, -4.38224f, -1.24431f, -0.727715f, -4.38224f, 
		-1.24431f, -0.529272f, -4.41814f, -1.24431f, -0.529272f, -4.41814f, 
		-1.24431f, -0.529272f, -4.41814f, -1.24431f, -0.526930f, -4.26972f, 
		-1.24431f, -0.526930f, -4.26972f, -1.24431f, -0.526930f, -4.26972f, 
		-1.24431f, -0.529076f, -4.22854f, -1.24431f, -0.529076f, -4.22854f, 
		-1.24431f, -0.529076f, -4.22854f, -1.24431f, -0.669827f, -4.23048f, 
		-1.24431f, -0.669827f, -4.23048f, -1.24431f, -0.669827f, -4.23048f, 
		-1.24431f, -0.741483f, -4.24785f, -1.24431f, -0.741483f, -4.24785f, 
		-1.24431f, -0.741483f, -4.24785f, -1.27268f, -0.660620f, -4.33926f, 
		-1.27268f, -0.660620f, -4.33926f, -1.27268f, -0.660620f, -4.33926f, 
		-1.27268f, -0.660620f, -4.33926f, -1.26420f, -0.669827f, -4.23048f, 
		-1.26420f, -0.669827f, -4.23048f, -1.26420f, -0.669827f, -4.23048f, 
		-1.26420f, -0.669827f, -4.23048f, -1.26420f, -0.526930f, -4.26972f, 
		-1.26420f, -0.526930f, -4.26972f, -1.26420f, -0.526930f, -4.26972f, 
		-1.26420f, -0.526930f, -4.26972f, -1.26420f, -0.692393f, -4.42876f, 
		-1.26420f, -0.692393f, -4.42876f, -1.26420f, -0.692393f, -4.42876f, 
		-1.26420f, -0.692393f, -4.42876f, -1.26420f, -0.724445f, -4.32738f, 
		-1.26420f, -0.724445f, -4.32738f, -1.26420f, -0.724445f, -4.32738f, 
		-1.26420f, -0.724445f, -4.32738f, -1.26420f, -0.529076f, -4.22854f, 
		-1.26420f, -0.529076f, -4.22854f, -1.26420f, -0.529076f, -4.22854f, 
		-1.26420f, -0.741483f, -4.24785f, -1.26420f, -0.741483f, -4.24785f, 
		-1.26420f, -0.741483f, -4.24785f, -1.26420f, -0.727715f, -4.38224f, 
		-1.26420f, -0.727715f, -4.38224f, -1.26420f, -0.727715f, -4.38224f, 
		-1.26420f, -0.529272f, -4.41814f, -1.26420f, -0.529272f, -4.41814f, 
		-1.26420f, -0.529272f, -4.41814f, -1.24329f, -0.820598f, -4.45609f, 
		-1.24329f, -0.863496f, -4.42654f, -1.24329f, -0.863496f, -4.42654f, 
		-1.24329f, -0.863496f, -4.42654f, -1.24329f, -0.861743f, -4.52581f, 
		-1.24329f, -0.861743f, -4.52581f, -1.24329f, -0.861743f, -4.52581f, 
		-1.24329f, -0.867363f, -4.47809f, -1.24329f, -0.867363f, -4.47809f, 
		-1.24329f, -0.867363f, -4.47809f, -1.24329f, -0.732153f, -4.51516f, 
		-1.24329f, -0.732153f, -4.51516f, -1.24329f, -0.732153f, -4.51516f, 
		-1.24329f, -0.708433f, -4.44147f, -1.24329f, -0.708433f, -4.44147f, 
		-1.24329f, -0.708433f, -4.44147f, -1.24329f, -0.747433f, -4.39881f, 
		-1.24329f, -0.747433f, -4.39881f, -1.24329f, -0.747433f, -4.39881f, 
		-1.24329f, -0.792542f, -4.40061f, -1.24329f, -0.792542f, -4.40061f, 
		-1.24329f, -0.792542f, -4.40061f, -1.24329f, -0.842941f, -4.40790f, 
		-1.24329f, -0.842941f, -4.40790f, -1.24329f, -0.842941f, -4.40790f, 
		-1.26986f, -0.820598f, -4.45609f, -1.26986f, -0.820598f, -4.45609f, 
		-1.26986f, -0.820598f, -4.45609f, -1.26986f, -0.820598f, -4.45609f, 
		-1.26522f, -0.792542f, -4.40061f, -1.26522f, -0.792542f, -4.40061f, 
		-1.26522f, -0.792542f, -4.40061f, -1.26522f, -0.792542f, -4.40061f, 
		-1.25928f, -0.708433f, -4.44147f, -1.25928f, -0.708433f, -4.44147f, 
		-1.25928f, -0.708433f, -4.44147f, -1.25928f, -0.708433f, -4.44147f, 
		-1.26522f, -0.861743f, -4.52581f, -1.26522f, -0.861743f, -4.52581f, 
		-1.26522f, -0.861743f, -4.52581f, -1.26522f, -0.861743f, -4.52581f, 
		-1.26522f, -0.863496f, -4.42654f, -1.26522f, -0.863496f, -4.42654f, 
		-1.26522f, -0.863496f, -4.42654f, -1.26522f, -0.863496f, -4.42654f, 
		-1.26522f, -0.747433f, -4.39881f, -1.26522f, -0.747433f, -4.39881f, 
		-1.26522f, -0.747433f, -4.39881f, -1.26522f, -0.842941f, -4.40790f, 
		-1.26522f, -0.842941f, -4.40790f, -1.26522f, -0.842941f, -4.40790f, 
		-1.26522f, -0.867363f, -4.47809f, -1.26522f, -0.867363f, -4.47809f, 
		-1.26522f, -0.867363f, -4.47809f, -1.26522f, -0.732153f, -4.51516f, 
		-1.26522f, -0.732153f, -4.51516f, -1.26522f, -0.732153f, -4.51516f, 
		-1.24759f, -0.587366f, -4.47261f, -1.24759f, -0.597319f, -4.43176f, 
		-1.24759f, -0.597319f, -4.43176f, -1.24759f, -0.597319f, -4.43176f, 
		-1.24759f, -0.720814f, -4.52046f, -1.24759f, -0.720814f, -4.52046f, 
		-1.24759f, -0.720814f, -4.52046f, -1.24759f, -0.695220f, -4.44030f, 
		-1.24759f, -0.695220f, -4.44030f, -1.24759f, -0.695220f, -4.44030f, 
		-1.24759f, -0.617504f, -4.52957f, -1.24759f, -0.617504f, -4.52957f, 
		-1.24759f, -0.617504f, -4.52957f, -1.24759f, -0.562594f, -4.51925f, 
		-1.24759f, -0.562594f, -4.51925f, -1.24759f, -0.562594f, -4.51925f, 
		-1.24759f, -0.527239f, -4.52697f, -1.24759f, -0.527239f, -4.52697f, 
		-1.24759f, -0.527239f, -4.52697f, -1.24759f, -0.525841f, -4.46277f, 
		-1.24759f, -0.525841f, -4.46277f, -1.24759f, -0.525841f, -4.46277f, 
		-1.24759f, -0.527278f, -4.42722f, -1.24759f, -0.527278f, -4.42722f, 
		-1.24759f, -0.527278f, -4.42722f, -1.26092f, -0.587366f, -4.47261f, 
		-1.26092f, -0.525841f, -4.46277f, -1.26092f, -0.525841f, -4.46277f, 
		-1.26092f, -0.525841f, -4.46277f, -1.26092f, -0.562594f, -4.51925f, 
		-1.26092f, -0.562594f, -4.51925f, -1.26092f, -0.562594f, -4.51925f, 
		-1.26092f, -0.720814f, -4.52046f, -1.26092f, -0.720814f, -4.52046f, 
		-1.26092f, -0.720814f, -4.52046f, -1.26092f, -0.597319f, -4.43176f, 
		-1.26092f, -0.597319f, -4.43176f, -1.26092f, -0.597319f, -4.43176f, 
		-1.26092f, -0.527239f, -4.52697f, -1.26092f, -0.527239f, -4.52697f, 
		-1.26092f, -0.527239f, -4.52697f, -1.26092f, -0.527278f, -4.42722f, 
		-1.26092f, -0.527278f, -4.42722f, -1.26092f, -0.527278f, -4.42722f, 
		-1.26092f, -0.695220f, -4.44030f, -1.26092f, -0.695220f, -4.44030f, 
		-1.26092f, -0.695220f, -4.44030f, -1.26092f, -0.617504f, -4.52957f, 
		-1.26092f, -0.617504f, -4.52957f, -1.26092f, -0.617504f, -4.52957f, 
		0.0371590f, -0.617504f, -4.52957f, 0.0371590f, -0.617504f, -4.52957f, 
		0.0371590f, -0.617504f, -4.52957f, 0.0371590f, -0.695220f, -4.44030f, 
		0.0371590f, -0.695220f, -4.44030f, 0.0371590f, -0.695220f, -4.44030f, 
		0.0371590f, -0.527278f, -4.42722f, 0.0371590f, -0.527278f, -4.42722f, 
		0.0371590f, -0.527278f, -4.42722f, 0.0371590f, -0.527238f, -4.52697f, 
		0.0371590f, -0.527238f, -4.52697f, 0.0371590f, -0.527238f, -4.52697f, 
		0.0371590f, -0.597319f, -4.43176f, 0.0371590f, -0.597319f, -4.43176f, 
		0.0371590f, -0.597319f, -4.43176f, 0.0371590f, -0.720814f, -4.52046f, 
		0.0371590f, -0.720814f, -4.52046f, 0.0371590f, -0.720814f, -4.52046f, 
		0.0371590f, -0.562594f, -4.51925f, 0.0371590f, -0.562594f, -4.51925f, 
		0.0371590f, -0.562594f, -4.51925f, 0.0371590f, -0.525841f, -4.46277f, 
		0.0371590f, -0.525841f, -4.46277f, 0.0371590f, -0.525841f, -4.46277f, 
		0.0371590f, -0.587366f, -4.47261f, 0.0504900f, -0.527278f, -4.42722f, 
		0.0504900f, -0.527278f, -4.42722f, 0.0504900f, -0.527278f, -4.42722f, 
		0.0504900f, -0.525841f, -4.46277f, 0.0504900f, -0.525841f, -4.46277f, 
		0.0504900f, -0.525841f, -4.46277f, 0.0504900f, -0.527238f, -4.52697f, 
		0.0504900f, -0.527238f, -4.52697f, 0.0504900f, -0.527238f, -4.52697f, 
		0.0504900f, -0.562594f, -4.51925f, 0.0504900f, -0.562594f, -4.51925f, 
		0.0504900f, -0.562594f, -4.51925f, 0.0504900f, -0.617504f, -4.52957f, 
		0.0504900f, -0.617504f, -4.52957f, 0.0504900f, -0.617504f, -4.52957f, 
		0.0504900f, -0.695220f, -4.44030f, 0.0504900f, -0.695220f, -4.44030f, 
		0.0504900f, -0.695220f, -4.44030f, 0.0504900f, -0.720814f, -4.52046f, 
		0.0504900f, -0.720814f, -4.52046f, 0.0504900f, -0.720814f, -4.52046f, 
		0.0504900f, -0.597319f, -4.43176f, 0.0504900f, -0.597319f, -4.43176f, 
		0.0504900f, -0.597319f, -4.43176f, 0.0504900f, -0.587366f, -4.47261f, 
		0.0328630f, -0.732153f, -4.51516f, 0.0328630f, -0.732153f, -4.51516f, 
		0.0328630f, -0.732153f, -4.51516f, 0.0328630f, -0.867363f, -4.47809f, 
		0.0328630f, -0.867363f, -4.47809f, 0.0328630f, -0.867363f, -4.47809f, 
		0.0328630f, -0.842941f, -4.39615f, 0.0328630f, -0.842941f, -4.39615f, 
		0.0328630f, -0.842941f, -4.39615f, 0.0328630f, -0.747433f, -4.40132f, 
		0.0328630f, -0.747433f, -4.40132f, 0.0328630f, -0.747433f, -4.40132f, 
		0.0328630f, -0.863496f, -4.42654f, 0.0328630f, -0.863496f, -4.42654f, 
		0.0328630f, -0.863496f, -4.42654f, 0.0328630f, -0.863496f, -4.42654f, 
		0.0328630f, -0.861743f, -4.52581f, 0.0328630f, -0.861743f, -4.52581f, 
		0.0328630f, -0.861743f, -4.52581f, 0.0328630f, -0.861743f, -4.52581f, 
		0.0328630f, -0.708433f, -4.44147f, 0.0328630f, -0.708433f, -4.44147f, 
		0.0328630f, -0.708433f, -4.44147f, 0.0328630f, -0.708433f, -4.44147f, 
		0.0328630f, -0.792542f, -4.39446f, 0.0328630f, -0.792542f, -4.39446f, 
		0.0328630f, -0.792542f, -4.39446f, 0.0328630f, -0.792542f, -4.39446f, 
		0.0255680f, -0.776354f, -4.43394f, 0.0255680f, -0.776354f, -4.43394f, 
		0.0255680f, -0.776354f, -4.43394f, 0.0255680f, -0.776354f, -4.43394f, 
		0.0547860f, -0.842941f, -4.38890f, 0.0547860f, -0.842941f, -4.38890f, 
		0.0547860f, -0.842941f, -4.38890f, 0.0547860f, -0.792542f, -4.39446f, 
		0.0547860f, -0.792542f, -4.39446f, 0.0547860f, -0.792542f, -4.39446f, 
		0.0547860f, -0.792542f, -4.39446f, 0.0547860f, -0.747433f, -4.40132f, 
		0.0547860f, -0.747433f, -4.40132f, 0.0547860f, -0.747433f, -4.40132f, 
		0.0547860f, -0.708433f, -4.44147f, 0.0547860f, -0.708433f, -4.44147f, 
		0.0547860f, -0.708433f, -4.44147f, 0.0547860f, -0.708433f, -4.44147f, 
		0.0547860f, -0.732153f, -4.51516f, 0.0547860f, -0.732153f, -4.51516f, 
		0.0547860f, -0.732153f, -4.51516f, 0.0547860f, -0.867363f, -4.47809f, 
		0.0547860f, -0.867363f, -4.47809f, 0.0547860f, -0.867363f, -4.47809f, 
		0.0547860f, -0.861743f, -4.52581f, 0.0547860f, -0.861743f, -4.52581f, 
		0.0547860f, -0.861743f, -4.52581f, 0.0547860f, -0.861743f, -4.52581f, 
		0.0547860f, -0.863496f, -4.42654f, 0.0547860f, -0.863496f, -4.42654f, 
		0.0547860f, -0.863496f, -4.42654f, 0.0547860f, -0.863496f, -4.42654f, 
		0.0555170f, -0.776354f, -4.43394f, 0.0555170f, -0.776354f, -4.43394f, 
		0.0555170f, -0.776354f, -4.43394f, 0.0555170f, -0.776354f, -4.43394f, 
		0.0345120f, -0.534236f, -4.41742f, 0.0345120f, -0.534236f, -4.41742f, 
		0.0345120f, -0.534236f, -4.41742f, 0.0338800f, -0.727715f, -4.38224f, 
		0.0338800f, -0.727715f, -4.38224f, 0.0338800f, -0.727715f, -4.38224f, 
		0.0338800f, -0.752323f, -4.22768f, 0.0338800f, -0.752323f, -4.22768f, 
		0.0338800f, -0.752323f, -4.22768f, 0.0338800f, -0.529076f, -4.22854f, 
		0.0338800f, -0.529076f, -4.22854f, 0.0338800f, -0.529076f, -4.22854f, 
		0.0338800f, -0.724445f, -4.32738f, 0.0338800f, -0.724445f, -4.32738f, 
		0.0338800f, -0.724445f, -4.32738f, 0.0338800f, -0.692393f, -4.42876f, 
		0.0338800f, -0.692393f, -4.42876f, 0.0338800f, -0.692393f, -4.42876f, 
		0.0338800f, -0.692393f, -4.42876f, 0.0338800f, -0.526929f, -4.26972f, 
		0.0338800f, -0.526929f, -4.26972f, 0.0338800f, -0.526929f, -4.26972f, 
		0.0338800f, -0.526929f, -4.26972f, 0.0338800f, -0.665885f, -4.23798f, 
		0.0338800f, -0.665885f, -4.23798f, 0.0338800f, -0.665885f, -4.23798f, 
		0.0338800f, -0.660620f, -4.33926f, 0.0338800f, -0.660620f, -4.33926f, 
		0.0537690f, -0.752323f, -4.22768f, 0.0537690f, -0.752323f, -4.22768f, 
		0.0537690f, -0.752323f, -4.22768f, 0.0537690f, -0.665885f, -4.23798f, 
		0.0537690f, -0.665885f, -4.23798f, 0.0537690f, -0.665885f, -4.23798f, 
		0.0537690f, -0.665885f, -4.23798f, 0.0537690f, -0.529076f, -4.22854f, 
		0.0537690f, -0.529076f, -4.22854f, 0.0537690f, -0.529076f, -4.22854f, 
		0.0537690f, -0.526929f, -4.26972f, 0.0537690f, -0.526929f, -4.26972f, 
		0.0537690f, -0.526929f, -4.26972f, 0.0537690f, -0.526929f, -4.26972f, 
		0.0544010f, -0.534236f, -4.41742f, 0.0544010f, -0.534236f, -4.41742f, 
		0.0544010f, -0.534236f, -4.41742f, 0.0537690f, -0.727715f, -4.38224f, 
		0.0537690f, -0.727715f, -4.38224f, 0.0537690f, -0.727715f, -4.38224f, 
		0.0537690f, -0.692393f, -4.42876f, 0.0537690f, -0.692393f, -4.42876f, 
		0.0537690f, -0.692393f, -4.42876f, 0.0537690f, -0.692393f, -4.42876f, 
		0.0537690f, -0.724445f, -4.32738f, 0.0537690f, -0.724445f, -4.32738f, 
		0.0537690f, -0.724445f, -4.32738f, 0.0537690f, -0.724445f, -4.32738f, 
		0.0602060f, -0.660620f, -4.33926f, 0.0602060f, -0.660620f, -4.33926f, 
		0.0602060f, -0.660620f, -4.33926f, 0.0602060f, -0.660620f, -4.33926f, 
		0.0362050f, -0.472484f, -4.15639f, 0.0362050f, -0.472484f, -4.15639f, 
		0.0362050f, -0.472484f, -4.15639f, 0.0362050f, -0.472484f, -4.15639f, 
		0.100460f, -0.475954f, -4.15386f, 0.100460f, -0.475954f, -4.15386f, 
		0.100460f, -0.475954f, -4.15386f, 0.100460f, -0.475954f, -4.15386f, 
		0.0588580f, -0.475954f, -4.22745f, 0.0588580f, -0.475954f, -4.22745f, 
		0.0588580f, -0.475954f, -4.22745f, 0.0588580f, -0.475954f, -4.22745f, 
		0.0966290f, -0.475954f, -4.21069f, 0.0966290f, -0.475954f, -4.21069f, 
		0.0966290f, -0.475954f, -4.21069f, -0.0161900f, -0.475954f, -4.21358f, 
		-0.0161900f, -0.475954f, -4.21358f, -0.0161900f, -0.475954f, -4.21358f, 
		-0.0184200f, -0.475954f, -4.16140f, -0.0184200f, -0.475954f, -4.16140f, 
		-0.0184200f, -0.475954f, -4.16140f, -0.0184200f, -0.475954f, -4.16140f, 
		-0.0304810f, -0.475954f, -4.08441f, -0.0304810f, -0.475954f, -4.08441f, 
		-0.0304810f, -0.475954f, -4.08441f, 0.0232700f, -0.475954f, -4.08083f, 
		0.0232700f, -0.475954f, -4.08083f, 0.0232700f, -0.475954f, -4.08083f, 
		0.0232700f, -0.475954f, -4.08083f, 0.0891450f, -0.475954f, -4.08782f, 
		0.0891450f, -0.475954f, -4.08782f, 0.0891450f, -0.475954f, -4.08782f, 
		0.0362050f, -0.508169f, -4.15639f, 0.0362050f, -0.508169f, -4.15639f, 
		0.0362050f, -0.508169f, -4.15639f, 0.0362050f, -0.508169f, -4.15639f, 
		0.0232700f, -0.527154f, -4.08083f, 0.0232700f, -0.527154f, -4.08083f, 
		0.0232700f, -0.527154f, -4.08083f, 0.0232700f, -0.527154f, -4.08083f, 
		-0.0184200f, -0.508169f, -4.16140f, -0.0184200f, -0.508169f, -4.16140f, 
		-0.0184200f, -0.508169f, -4.16140f, -0.0184200f, -0.508169f, -4.16140f, 
		0.0588580f, -0.508169f, -4.22745f, 0.0588580f, -0.508169f, -4.22745f, 
		0.0588580f, -0.508169f, -4.22745f, 0.0588580f, -0.508169f, -4.22745f, 
		0.0998790f, -0.529205f, -4.15281f, 0.0998790f, -0.529205f, -4.15281f, 
		0.0998790f, -0.529205f, -4.15281f, 0.0998790f, -0.529205f, -4.15281f, 
		-0.0304810f, -0.524560f, -4.08441f, -0.0304810f, -0.524560f, -4.08441f, 
		-0.0304810f, -0.524560f, -4.08441f, 0.0814850f, -0.527618f, -4.09073f, 
		0.0814850f, -0.527618f, -4.09073f, 0.0814850f, -0.527618f, -4.09073f, 
		0.0966290f, -0.522577f, -4.21069f, 0.0966290f, -0.522577f, -4.21069f, 
		0.0966290f, -0.522577f, -4.21069f, -0.0161900f, -0.508169f, -4.21358f, 
		-0.0161900f, -0.508169f, -4.21358f, -0.0161900f, -0.508169f, -4.21358f, 
		-0.0936260f, -0.482493f, -4.14269f, -0.0936260f, -0.482493f, -4.14269f, 
		-0.0936260f, -0.482493f, -4.14269f, -0.0936260f, -0.482493f, -4.14269f, 
		-0.0315850f, -0.478156f, -4.13367f, -0.0315850f, -0.478156f, -4.13367f, 
		-0.0315850f, -0.478156f, -4.13367f, -0.0315850f, -0.478156f, -4.13367f, 
		-0.0347020f, -0.478156f, -4.26728f, -0.0347020f, -0.478156f, -4.26728f, 
		-0.0347020f, -0.478156f, -4.26728f, -0.0347020f, -0.478156f, -4.26728f, 
		-0.0266710f, -0.478156f, -4.17753f, -0.0266710f, -0.478156f, -4.17753f, 
		-0.0266710f, -0.478156f, -4.17753f, -0.152355f, -0.478156f, -4.30609f, 
		-0.152355f, -0.478156f, -4.30609f, -0.152355f, -0.478156f, -4.30609f, 
		-0.207588f, -0.478156f, -4.14769f, -0.207588f, -0.478156f, -4.14769f, 
		-0.207588f, -0.478156f, -4.14769f, -0.207588f, -0.478156f, -4.14769f, 
		-0.206624f, -0.478156f, -4.08709f, -0.206624f, -0.478156f, -4.08709f, 
		-0.206624f, -0.478156f, -4.08709f, -0.106561f, -0.478156f, -4.08014f, 
		-0.106561f, -0.478156f, -4.08014f, -0.106561f, -0.478156f, -4.08014f, 
		-0.106561f, -0.478156f, -4.08014f, -0.0418030f, -0.478156f, -4.08553f, 
		-0.0418030f, -0.478156f, -4.08553f, -0.0418030f, -0.478156f, -4.08553f, 
		-0.0936260f, -0.520072f, -4.14269f, -0.0936260f, -0.520072f, -4.14269f, 
		-0.0936260f, -0.520072f, -4.14269f, -0.106561f, -0.527876f, -4.08014f, 
		-0.106561f, -0.527876f, -4.08014f, -0.106561f, -0.527876f, -4.08014f, 
		-0.106561f, -0.527876f, -4.08014f, -0.207588f, -0.520072f, -4.14769f, 
		-0.207588f, -0.520072f, -4.14769f, -0.207588f, -0.520072f, -4.14769f, 
		-0.207588f, -0.520072f, -4.14769f, -0.0347020f, -0.520072f, -4.26728f, 
		-0.0347020f, -0.520072f, -4.26728f, -0.0347020f, -0.520072f, -4.26728f, 
		-0.0315850f, -0.520072f, -4.13367f, -0.0315850f, -0.520072f, -4.13367f, 
		-0.0315850f, -0.520072f, -4.13367f, -0.0315850f, -0.520072f, -4.13367f, 
		-0.206624f, -0.524476f, -4.08709f, -0.206624f, -0.524476f, -4.08709f, 
		-0.206624f, -0.524476f, -4.08709f, -0.0418030f, -0.528463f, -4.08553f, 
		-0.0418030f, -0.528463f, -4.08553f, -0.0418030f, -0.528463f, -4.08553f, 
		-0.0266710f, -0.520072f, -4.17753f, -0.0266710f, -0.520072f, -4.17753f, 
		-0.0266710f, -0.520072f, -4.17753f, -0.152355f, -0.520072f, -4.30609f, 
		-0.152355f, -0.520072f, -4.30609f, -0.152355f, -0.520072f, -4.30609f, 
		0.0301090f, -0.477311f, -4.31512f, 0.0301090f, -0.477311f, -4.31512f, 
		0.0301090f, -0.477311f, -4.31512f, 0.0301090f, -0.477311f, -4.31512f, 
		0.0381400f, -0.471326f, -4.23691f, 0.0381400f, -0.471326f, -4.23691f, 
		0.0381400f, -0.471326f, -4.23691f, 0.0381400f, -0.471326f, -4.23691f, 
		0.100901f, -0.471326f, -4.30780f, 0.100901f, -0.471326f, -4.30780f, 
		0.100901f, -0.471326f, -4.30780f, 0.100901f, -0.471326f, -4.30780f, 
		0.0924750f, -0.471326f, -4.22657f, 0.0924750f, -0.471326f, -4.22657f, 
		0.0924750f, -0.471326f, -4.22657f, 0.0965190f, -0.471326f, -4.50143f, 
		0.0965190f, -0.471326f, -4.50143f, 0.0965190f, -0.471326f, -4.50143f, 
		0.0231210f, -0.471326f, -4.49727f, 0.0231210f, -0.471326f, -4.49727f, 
		0.0231210f, -0.471326f, -4.49727f, 0.0231210f, -0.471326f, -4.49727f, 
		-0.0236800f, -0.471326f, -4.49676f, -0.0236800f, -0.471326f, -4.49676f, 
		-0.0236800f, -0.471326f, -4.49676f, -0.0380000f, -0.471326f, -4.31089f, 
		-0.0380000f, -0.471326f, -4.31089f, -0.0380000f, -0.471326f, -4.31089f, 
		-0.0380000f, -0.471326f, -4.31089f, -0.0171400f, -0.471326f, -4.22406f, 
		-0.0171400f, -0.471326f, -4.22406f, -0.0171400f, -0.471326f, -4.22406f, 
		0.0301090f, -0.513242f, -4.31512f, 0.0301090f, -0.513242f, -4.31512f, 
		0.0301090f, -0.513242f, -4.31512f, -0.0380000f, -0.513242f, -4.31089f, 
		-0.0380000f, -0.513242f, -4.31089f, -0.0380000f, -0.513242f, -4.31089f, 
		0.0231210f, -0.513242f, -4.49727f, 0.0231210f, -0.513242f, -4.49727f, 
		0.0231210f, -0.513242f, -4.49727f, 0.0231210f, -0.513242f, -4.49727f, 
		0.100901f, -0.521775f, -4.30780f, 0.100901f, -0.521775f, -4.30780f, 
		0.100901f, -0.521775f, -4.30780f, 0.100901f, -0.521775f, -4.30780f, 
		0.0381390f, -0.513242f, -4.23691f, 0.0381390f, -0.513242f, -4.23691f, 
		0.0381390f, -0.513242f, -4.23691f, 0.0381390f, -0.513242f, -4.23691f, 
		-0.0236800f, -0.513242f, -4.49676f, -0.0236800f, -0.513242f, -4.49676f, 
		-0.0236800f, -0.513242f, -4.49676f, -0.0171400f, -0.513242f, -4.22406f, 
		-0.0171400f, -0.513242f, -4.22406f, -0.0171400f, -0.513242f, -4.22406f, 
		0.0924750f, -0.532014f, -4.22657f, 0.0924750f, -0.532014f, -4.22657f, 
		0.0924750f, -0.532014f, -4.22657f, 0.0965190f, -0.527463f, -4.50143f, 
		0.0965190f, -0.527463f, -4.50143f, 0.0965190f, -0.527463f, -4.50143f, 
		-0.173996f, -0.473928f, -4.36142f, -0.173996f, -0.473928f, -4.36142f, 
		-0.173996f, -0.473928f, -4.36142f, -0.173996f, -0.473928f, -4.36142f, 
		-0.150236f, -0.471326f, -4.31772f, -0.150236f, -0.471326f, -4.31772f, 
		-0.150236f, -0.471326f, -4.31772f, -0.150236f, -0.471326f, -4.31772f, 
		-0.0504440f, -0.471326f, -4.34561f, -0.0504440f, -0.471326f, -4.34561f, 
		-0.0504440f, -0.471326f, -4.34561f, -0.0504440f, -0.471326f, -4.34561f, 
		-0.0496220f, -0.471326f, -4.28398f, -0.0496220f, -0.471326f, -4.28398f, 
		-0.0496220f, -0.471326f, -4.28398f, -0.0410060f, -0.474796f, -4.41909f, 
		-0.0410060f, -0.474796f, -4.41909f, -0.0410060f, -0.474796f, -4.41909f, 
		-0.0410060f, -0.474796f, -4.41909f, -0.177358f, -0.471326f, -4.41477f, 
		-0.177358f, -0.471326f, -4.41477f, -0.177358f, -0.471326f, -4.41477f, 
		-0.177358f, -0.471326f, -4.41477f, -0.177358f, -0.471326f, -4.41477f, 
		-0.221974f, -0.471326f, -4.41915f, -0.221974f, -0.471326f, -4.41915f, 
		-0.221974f, -0.471326f, -4.41915f, -0.237783f, -0.471326f, -4.36470f, 
		-0.237783f, -0.471326f, -4.36470f, -0.237783f, -0.471326f, -4.36470f, 
		-0.237783f, -0.471326f, -4.36470f, -0.223451f, -0.471326f, -4.32573f, 
		-0.223451f, -0.471326f, -4.32573f, -0.223451f, -0.471326f, -4.32573f, 
		-0.173996f, -0.513242f, -4.36142f, -0.237783f, -0.513242f, -4.36470f, 
		-0.237783f, -0.513242f, -4.36470f, -0.237783f, -0.513242f, -4.36470f, 
		-0.177358f, -0.513242f, -4.41477f, -0.177358f, -0.513242f, -4.41477f, 
		-0.177358f, -0.513242f, -4.41477f, -0.0504440f, -0.513242f, -4.34561f, 
		-0.0504440f, -0.513242f, -4.34561f, -0.0504440f, -0.513242f, -4.34561f, 
		-0.150236f, -0.513242f, -4.31772f, -0.150236f, -0.513242f, -4.31772f, 
		-0.150236f, -0.513242f, -4.31772f, -0.221974f, -0.513242f, -4.41915f, 
		-0.221974f, -0.513242f, -4.41915f, -0.221974f, -0.513242f, -4.41915f, 
		-0.223451f, -0.513242f, -4.32573f, -0.223451f, -0.513242f, -4.32573f, 
		-0.223451f, -0.513242f, -4.32573f, -0.0496220f, -0.513242f, -4.28398f, 
		-0.0496220f, -0.513242f, -4.28398f, -0.0496220f, -0.513242f, -4.28398f, 
		-0.0410060f, -0.513242f, -4.41909f, -0.0410060f, -0.513242f, -4.41909f, 
		-0.0410060f, -0.513242f, -4.41909f, -0.274822f, -0.471326f, -4.14822f, 
		-0.216723f, -0.471326f, -4.14227f, -0.216723f, -0.471326f, -4.14227f, 
		-0.216723f, -0.471326f, -4.14227f, -0.256608f, -0.471326f, -4.25012f, 
		-0.256608f, -0.471326f, -4.25012f, -0.256608f, -0.471326f, -4.25012f, 
		-0.205442f, -0.471326f, -4.18863f, -0.205442f, -0.471326f, -4.18863f, 
		-0.205442f, -0.471326f, -4.18863f, -0.336872f, -0.471326f, -4.20138f, 
		-0.336872f, -0.471326f, -4.20138f, -0.336872f, -0.471326f, -4.20138f, 
		-0.335347f, -0.471326f, -4.15831f, -0.335347f, -0.471326f, -4.15831f, 
		-0.335347f, -0.471326f, -4.15831f, -0.320877f, -0.471326f, -4.09286f, 
		-0.320877f, -0.471326f, -4.09286f, -0.320877f, -0.471326f, -4.09286f, 
		-0.287757f, -0.471326f, -4.08567f, -0.287757f, -0.471326f, -4.08567f, 
		-0.287757f, -0.471326f, -4.08567f, -0.219307f, -0.471326f, -4.08836f, 
		-0.219307f, -0.471326f, -4.08836f, -0.219307f, -0.471326f, -4.08836f, 
		-0.274822f, -0.513242f, -4.14822f, -0.274822f, -0.513242f, -4.14822f, 
		-0.274822f, -0.513242f, -4.14822f, -0.287757f, -0.521699f, -4.08567f, 
		-0.287757f, -0.521699f, -4.08567f, -0.287757f, -0.521699f, -4.08567f, 
		-0.287757f, -0.521699f, -4.08567f, -0.287757f, -0.521699f, -4.08567f, 
		-0.335347f, -0.513242f, -4.15831f, -0.335347f, -0.513242f, -4.15831f, 
		-0.335347f, -0.513242f, -4.15831f, -0.256608f, -0.513242f, -4.25012f, 
		-0.256608f, -0.513242f, -4.25012f, -0.256608f, -0.513242f, -4.25012f, 
		-0.216723f, -0.513242f, -4.14227f, -0.216723f, -0.513242f, -4.14227f, 
		-0.216723f, -0.513242f, -4.14227f, -0.216723f, -0.513242f, -4.14227f, 
		-0.320877f, -0.522208f, -4.09286f, -0.320877f, -0.522208f, -4.09286f, 
		-0.320877f, -0.522208f, -4.09286f, -0.219307f, -0.524179f, -4.08836f, 
		-0.219307f, -0.524179f, -4.08836f, -0.219307f, -0.524179f, -4.08836f, 
		-0.205442f, -0.513242f, -4.18863f, -0.205442f, -0.513242f, -4.18863f, 
		-0.205442f, -0.513242f, -4.18863f, -0.336872f, -0.513242f, -4.20138f, 
		-0.336872f, -0.513242f, -4.20138f, -0.336872f, -0.513242f, -4.20138f, 
		-0.166732f, -0.513242f, -4.30773f, -0.166732f, -0.513242f, -4.30773f, 
		-0.166732f, -0.513242f, -4.30773f, -0.219155f, -0.513242f, -4.31569f, 
		-0.219155f, -0.513242f, -4.31569f, -0.219155f, -0.513242f, -4.31569f, 
		-0.166732f, -0.471326f, -4.30773f, -0.166732f, -0.471326f, -4.30773f, 
		-0.166732f, -0.471326f, -4.30773f, -0.219155f, -0.471326f, -4.31569f, 
		-0.219155f, -0.471326f, -4.31569f, -0.219155f, -0.471326f, -4.31569f, 
		-0.307451f, -0.471326f, -4.32403f, -0.233321f, -0.471326f, -4.31480f, 
		-0.233321f, -0.471326f, -4.31480f, -0.233321f, -0.471326f, -4.31480f, 
		-0.235666f, -0.471326f, -4.42000f, -0.235666f, -0.471326f, -4.42000f, 
		-0.235666f, -0.471326f, -4.42000f, -0.249295f, -0.471326f, -4.36318f, 
		-0.249295f, -0.471326f, -4.36318f, -0.249295f, -0.471326f, -4.36318f, 
		-0.349596f, -0.471326f, -4.41789f, -0.349596f, -0.471326f, -4.41789f, 
		-0.349596f, -0.471326f, -4.41789f, -0.362075f, -0.471326f, -4.32903f, 
		-0.362075f, -0.471326f, -4.32903f, -0.362075f, -0.471326f, -4.32903f, 
		-0.360032f, -0.471326f, -4.28784f, -0.360032f, -0.471326f, -4.28784f, 
		-0.360032f, -0.471326f, -4.28784f, -0.320386f, -0.471326f, -4.26148f, 
		-0.320386f, -0.471326f, -4.26148f, -0.320386f, -0.471326f, -4.26148f, 
		-0.263276f, -0.471326f, -4.26644f, -0.263276f, -0.471326f, -4.26644f, 
		-0.263276f, -0.471326f, -4.26644f, -0.307451f, -0.513242f, -4.32403f, 
		-0.320386f, -0.513242f, -4.26148f, -0.320386f, -0.513242f, -4.26148f, 
		-0.320386f, -0.513242f, -4.26148f, -0.362075f, -0.513242f, -4.32903f, 
		-0.362075f, -0.513242f, -4.32903f, -0.362075f, -0.513242f, -4.32903f, 
		-0.235666f, -0.513242f, -4.42000f, -0.235666f, -0.513242f, -4.42000f, 
		-0.235666f, -0.513242f, -4.42000f, -0.233321f, -0.513242f, -4.31480f, 
		-0.233321f, -0.513242f, -4.31480f, -0.233321f, -0.513242f, -4.31480f, 
		-0.360032f, -0.513242f, -4.28784f, -0.360032f, -0.513242f, -4.28784f, 
		-0.360032f, -0.513242f, -4.28784f, -0.263276f, -0.513242f, -4.26644f, 
		-0.263276f, -0.513242f, -4.26644f, -0.263276f, -0.513242f, -4.26644f, 
		-0.249295f, -0.513242f, -4.36318f, -0.249295f, -0.513242f, -4.36318f, 
		-0.249295f, -0.513242f, -4.36318f, -0.349596f, -0.513242f, -4.41789f, 
		-0.349596f, -0.513242f, -4.41789f, -0.349596f, -0.513242f, -4.41789f, 
		-0.391050f, -0.471326f, -4.14104f, -0.347411f, -0.471326f, -4.13416f, 
		-0.347411f, -0.471326f, -4.13416f, -0.347411f, -0.471326f, -4.13416f, 
		-0.378637f, -0.471326f, -4.19701f, -0.378637f, -0.471326f, -4.19701f, 
		-0.378637f, -0.471326f, -4.19701f, -0.342065f, -0.471326f, -4.17534f, 
		-0.342065f, -0.471326f, -4.17534f, -0.342065f, -0.471326f, -4.17534f, 
		-0.443445f, -0.471326f, -4.19823f, -0.443445f, -0.471326f, -4.19823f, 
		-0.443445f, -0.471326f, -4.19823f, -0.445675f, -0.471326f, -4.14604f, 
		-0.445675f, -0.471326f, -4.14604f, -0.445675f, -0.471326f, -4.14604f, 
		-0.440794f, -0.471326f, -4.09422f, -0.440794f, -0.471326f, -4.09422f, 
		-0.440794f, -0.471326f, -4.09422f, -0.395828f, -0.471326f, -4.08559f, 
		-0.395828f, -0.471326f, -4.08559f, -0.395828f, -0.471326f, -4.08559f, 
		-0.328534f, -0.471326f, -4.09028f, -0.328534f, -0.471326f, -4.09028f, 
		-0.328534f, -0.471326f, -4.09028f, -0.391050f, -0.513242f, -4.14104f, 
		-0.391050f, -0.513242f, -4.14104f, -0.391050f, -0.513242f, -4.14104f, 
		-0.395828f, -0.519865f, -4.08559f, -0.395828f, -0.519865f, -4.08559f, 
		-0.395828f, -0.519865f, -4.08559f, -0.395828f, -0.519865f, -4.08559f, 
		-0.445675f, -0.513242f, -4.14604f, -0.445675f, -0.513242f, -4.14604f, 
		-0.445675f, -0.513242f, -4.14604f, -0.445675f, -0.513242f, -4.14604f, 
		-0.378637f, -0.513242f, -4.19701f, -0.378637f, -0.513242f, -4.19701f, 
		-0.378637f, -0.513242f, -4.19701f, -0.347411f, -0.513242f, -4.13416f, 
		-0.347411f, -0.513242f, -4.13416f, -0.347411f, -0.513242f, -4.13416f, 
		-0.347411f, -0.513242f, -4.13416f, -0.440794f, -0.518314f, -4.09422f, 
		-0.440794f, -0.518314f, -4.09422f, -0.440794f, -0.518314f, -4.09422f, 
		-0.328534f, -0.522168f, -4.09028f, -0.328534f, -0.522168f, -4.09028f, 
		-0.328534f, -0.522168f, -4.09028f, -0.342065f, -0.513242f, -4.17534f, 
		-0.342065f, -0.513242f, -4.17534f, -0.342065f, -0.513242f, -4.17534f, 
		-0.443445f, -0.513242f, -4.19823f, -0.443445f, -0.513242f, -4.19823f, 
		-0.443445f, -0.513242f, -4.19823f, -0.337767f, -0.471326f, -4.13511f, 
		-0.337767f, -0.471326f, -4.13511f, -0.337767f, -0.471326f, -4.13511f, 
		-0.335347f, -0.492284f, -4.15831f, -0.335347f, -0.492284f, -4.15831f, 
		-0.320877f, -0.492284f, -4.09286f, -0.320877f, -0.492284f, -4.09286f, 
		-0.337767f, -0.513242f, -4.13511f, -0.337767f, -0.513242f, -4.13511f, 
		-0.337767f, -0.513242f, -4.13511f, -0.337767f, -0.513242f, -4.13511f, 
		-0.337767f, -0.513242f, -4.13511f, -0.337767f, -0.492284f, -4.13511f, 
		-0.337767f, -0.492284f, -4.13511f, -0.388555f, -0.474388f, -4.25298f, 
		-0.365389f, -0.474388f, -4.27761f, -0.365389f, -0.474388f, -4.27761f, 
		-0.365389f, -0.474388f, -4.27761f, -0.445584f, -0.474388f, -4.27849f, 
		-0.445584f, -0.474388f, -4.27849f, -0.445584f, -0.474388f, -4.27849f, 
		-0.408069f, -0.474388f, -4.28737f, -0.408069f, -0.474388f, -4.28737f, 
		-0.408069f, -0.474388f, -4.28737f, -0.440085f, -0.474388f, -4.21431f, 
		-0.440085f, -0.474388f, -4.21431f, -0.440085f, -0.474388f, -4.21431f, 
		-0.395264f, -0.474388f, -4.20917f, -0.395264f, -0.474388f, -4.20917f, 
		-0.395264f, -0.474388f, -4.20917f, -0.353340f, -0.474388f, -4.20019f, 
		-0.353340f, -0.474388f, -4.20019f, -0.353340f, -0.474388f, -4.20019f, 
		-0.311069f, -0.474388f, -4.23158f, -0.311069f, -0.474388f, -4.23158f, 
		-0.311069f, -0.474388f, -4.23158f, -0.273687f, -0.474388f, -4.25388f, 
		-0.273687f, -0.474388f, -4.25388f, -0.273687f, -0.474388f, -4.25388f, 
		-0.388555f, -0.510180f, -4.25298f, -0.311069f, -0.510180f, -4.23158f, 
		-0.311069f, -0.510180f, -4.23158f, -0.311069f, -0.510180f, -4.23158f, 
		-0.395264f, -0.510180f, -4.20917f, -0.395264f, -0.510180f, -4.20917f, 
		-0.395264f, -0.510180f, -4.20917f, -0.445584f, -0.510180f, -4.27849f, 
		-0.445584f, -0.510180f, -4.27849f, -0.445584f, -0.510180f, -4.27849f, 
		-0.365389f, -0.510180f, -4.27761f, -0.365389f, -0.510180f, -4.27761f, 
		-0.365389f, -0.510180f, -4.27761f, -0.353340f, -0.510180f, -4.20019f, 
		-0.353340f, -0.510180f, -4.20019f, -0.353340f, -0.510180f, -4.20019f, 
		-0.273687f, -0.510180f, -4.25388f, -0.273687f, -0.510180f, -4.25388f, 
		-0.273687f, -0.510180f, -4.25388f, -0.408069f, -0.510180f, -4.28737f, 
		-0.408069f, -0.510180f, -4.28737f, -0.408069f, -0.510180f, -4.28737f, 
		-0.440085f, -0.510180f, -4.21431f, -0.440085f, -0.510180f, -4.21431f, 
		-0.440085f, -0.510180f, -4.21431f, -0.365389f, -0.492284f, -4.27761f, 
		-0.365389f, -0.492284f, -4.27761f, -0.326472f, -0.474388f, -4.25412f, 
		-0.326472f, -0.474388f, -4.25412f, -0.326472f, -0.474388f, -4.25412f, 
		-0.273687f, -0.492284f, -4.25388f, -0.273687f, -0.492284f, -4.25388f, 
		-0.326472f, -0.510180f, -4.25412f, -0.326472f, -0.510180f, -4.25412f, 
		-0.326472f, -0.510180f, -4.25412f, -0.326472f, -0.492284f, -4.25412f, 
		-0.326472f, -0.492284f, -4.25412f, -0.630073f, -0.461486f, -4.31458f, 
		-0.630073f, -0.461486f, -4.31458f, -0.630073f, -0.461486f, -4.31458f, 
		-0.630073f, -0.461486f, -4.31458f, -0.462837f, -0.472259f, -4.29355f, 
		-0.462837f, -0.472259f, -4.29355f, -0.462837f, -0.472259f, -4.29355f, 
		-0.462837f, -0.472259f, -4.29355f, -0.370558f, -0.472259f, -4.41258f, 
		-0.370558f, -0.472259f, -4.41258f, -0.370558f, -0.472259f, -4.41258f, 
		-0.370558f, -0.472259f, -4.41258f, -0.377295f, -0.472259f, -4.29982f, 
		-0.377295f, -0.472259f, -4.29982f, -0.377295f, -0.472259f, -4.29982f, 
		-0.638123f, -0.472259f, -4.41234f, -0.638123f, -0.472259f, -4.41234f, 
		-0.638123f, -0.472259f, -4.41234f, -0.684697f, -0.461486f, -4.31958f, 
		-0.684697f, -0.461486f, -4.31958f, -0.684697f, -0.461486f, -4.31958f, 
		-0.684697f, -0.461486f, -4.31958f, -0.651519f, -0.472259f, -4.26519f, 
		-0.651519f, -0.472259f, -4.26519f, -0.651519f, -0.472259f, -4.26519f, 
		-0.574133f, -0.472259f, -4.23788f, -0.574133f, -0.472259f, -4.23788f, 
		-0.574133f, -0.472259f, -4.23788f, -0.574133f, -0.472259f, -4.23788f, 
		-0.454189f, -0.472259f, -4.22442f, -0.454189f, -0.472259f, -4.22442f, 
		-0.454189f, -0.472259f, -4.22442f, -0.630073f, -0.499628f, -4.31458f, 
		-0.574133f, -0.499628f, -4.23788f, -0.574133f, -0.499628f, -4.23788f, 
		-0.574133f, -0.499628f, -4.23788f, -0.684697f, -0.499628f, -4.31958f, 
		-0.684697f, -0.499628f, -4.31958f, -0.684697f, -0.499628f, -4.31958f, 
		-0.370558f, -0.499628f, -4.41258f, -0.370558f, -0.499628f, -4.41258f, 
		-0.370558f, -0.499628f, -4.41258f, -0.462837f, -0.499628f, -4.29355f, 
		-0.462837f, -0.499628f, -4.29355f, -0.462837f, -0.499628f, -4.29355f, 
		-0.651519f, -0.499628f, -4.26519f, -0.651519f, -0.499628f, -4.26519f, 
		-0.651519f, -0.499628f, -4.26519f, -0.454189f, -0.499628f, -4.22442f, 
		-0.454189f, -0.499628f, -4.22442f, -0.454189f, -0.499628f, -4.22442f, 
		-0.377295f, -0.499628f, -4.29982f, -0.377295f, -0.499628f, -4.29982f, 
		-0.377295f, -0.499628f, -4.29982f, -0.638123f, -0.499628f, -4.41234f, 
		-0.638123f, -0.499628f, -4.41234f, -0.638123f, -0.499628f, -4.41234f, 
		-0.0410060f, -0.513242f, -4.50023f, -0.0410060f, -0.513242f, -4.50023f, 
		-0.0410060f, -0.513242f, -4.50023f, -0.177358f, -0.513242f, -4.49591f, 
		-0.177358f, -0.513242f, -4.49591f, -0.177358f, -0.513242f, -4.49591f, 
		-0.177358f, -0.471326f, -4.49591f, -0.177358f, -0.471326f, -4.49591f, 
		-0.177358f, -0.471326f, -4.49591f, -0.0410060f, -0.471326f, -4.50023f, 
		-0.0410060f, -0.471326f, -4.50023f, -0.0410060f, -0.471326f, -4.50023f, 
		-0.271832f, -0.472259f, -4.45300f, -0.258641f, -0.472259f, -4.50523f, 
		-0.258641f, -0.472259f, -4.50523f, -0.258641f, -0.472259f, -4.50523f, 
		-0.327473f, -0.472259f, -4.46667f, -0.327473f, -0.472259f, -4.46667f, 
		-0.327473f, -0.472259f, -4.46667f, -0.312515f, -0.472259f, -4.50309f, 
		-0.312515f, -0.472259f, -4.50309f, -0.312515f, -0.472259f, -4.50309f, 
		-0.325505f, -0.472259f, -4.42736f, -0.325505f, -0.472259f, -4.42736f, 
		-0.325505f, -0.472259f, -4.42736f, -0.267147f, -0.472259f, -4.43255f, 
		-0.267147f, -0.472259f, -4.43255f, -0.267147f, -0.472259f, -4.43255f, 
		-0.188100f, -0.472259f, -4.42601f, -0.188100f, -0.472259f, -4.42601f, 
		-0.188100f, -0.472259f, -4.42601f, -0.191849f, -0.472259f, -4.45028f, 
		-0.191849f, -0.472259f, -4.45028f, -0.191849f, -0.472259f, -4.45028f, 
		-0.193002f, -0.472259f, -4.50061f, -0.193002f, -0.472259f, -4.50061f, 
		-0.193002f, -0.472259f, -4.50061f, -0.271832f, -0.499628f, -4.45300f, 
		-0.191849f, -0.499628f, -4.45028f, -0.191849f, -0.499628f, -4.45028f, 
		-0.191849f, -0.499628f, -4.45028f, -0.267147f, -0.499628f, -4.43255f, 
		-0.267147f, -0.499628f, -4.43255f, -0.267147f, -0.499628f, -4.43255f, 
		-0.327473f, -0.499628f, -4.46667f, -0.327473f, -0.499628f, -4.46667f, 
		-0.327473f, -0.499628f, -4.46667f, -0.258641f, -0.499628f, -4.50523f, 
		-0.258641f, -0.499628f, -4.50523f, -0.258641f, -0.499628f, -4.50523f, 
		-0.188100f, -0.499628f, -4.42601f, -0.188100f, -0.499628f, -4.42601f, 
		-0.188100f, -0.499628f, -4.42601f, -0.193001f, -0.499628f, -4.50061f, 
		-0.193001f, -0.499628f, -4.50061f, -0.193001f, -0.499628f, -4.50061f, 
		-0.312515f, -0.499628f, -4.50309f, -0.312515f, -0.499628f, -4.50309f, 
		-0.312515f, -0.499628f, -4.50309f, -0.325505f, -0.499628f, -4.42736f, 
		-0.325505f, -0.499628f, -4.42736f, -0.325505f, -0.499628f, -4.42736f, 
		-0.628447f, -0.499628f, -4.41927f, -0.628447f, -0.499628f, -4.41927f, 
		-0.628447f, -0.499628f, -4.41927f, -0.627864f, -0.499628f, -4.50309f, 
		-0.627864f, -0.499628f, -4.50309f, -0.627864f, -0.499628f, -4.50309f, 
		-0.326719f, -0.499628f, -4.50385f, -0.326719f, -0.499628f, -4.50385f, 
		-0.326719f, -0.499628f, -4.50385f, -0.361197f, -0.499628f, -4.42224f, 
		-0.361197f, -0.499628f, -4.42224f, -0.361197f, -0.499628f, -4.42224f, 
		-0.411240f, -0.499628f, -4.50523f, -0.411240f, -0.499628f, -4.50523f, 
		-0.411240f, -0.499628f, -4.50523f, -0.641220f, -0.499628f, -4.46792f, 
		-0.641220f, -0.499628f, -4.46792f, -0.641220f, -0.499628f, -4.46792f, 
		-0.418667f, -0.499628f, -4.42230f, -0.418667f, -0.499628f, -4.42230f, 
		-0.418667f, -0.499628f, -4.42230f, -0.337434f, -0.499628f, -4.43140f, 
		-0.337434f, -0.499628f, -4.43140f, -0.337434f, -0.499628f, -4.43140f, 
		-0.424430f, -0.499628f, -4.45300f, -0.326719f, -0.472259f, -4.50385f, 
		-0.326719f, -0.472259f, -4.50385f, -0.326719f, -0.472259f, -4.50385f, 
		-0.337434f, -0.472259f, -4.43140f, -0.337434f, -0.472259f, -4.43140f, 
		-0.337434f, -0.472259f, -4.43140f, -0.361197f, -0.472259f, -4.42224f, 
		-0.361197f, -0.472259f, -4.42224f, -0.361197f, -0.472259f, -4.42224f, 
		-0.418667f, -0.472259f, -4.42230f, -0.418667f, -0.472259f, -4.42230f, 
		-0.418667f, -0.472259f, -4.42230f, -0.418667f, -0.472259f, -4.42230f, 
		-0.628447f, -0.472259f, -4.41927f, -0.628447f, -0.472259f, -4.41927f, 
		-0.628447f, -0.472259f, -4.41927f, -0.627864f, -0.472259f, -4.50309f, 
		-0.627864f, -0.472259f, -4.50309f, -0.627864f, -0.472259f, -4.50309f, 
		-0.641220f, -0.467471f, -4.46792f, -0.641220f, -0.467471f, -4.46792f, 
		-0.641220f, -0.467471f, -4.46792f, -0.641220f, -0.467471f, -4.46792f, 
		-0.411240f, -0.472259f, -4.50523f, -0.411240f, -0.472259f, -4.50523f, 
		-0.411240f, -0.472259f, -4.50523f, -0.411240f, -0.472259f, -4.50523f, 
		-0.424430f, -0.472259f, -4.45300f, -0.424430f, -0.472259f, -4.45300f, 
		-0.424430f, -0.472259f, -4.45300f, -0.520746f, -0.472259f, -4.17345f, 
		-0.520068f, -0.472259f, -4.21762f, -0.520068f, -0.472259f, -4.21762f, 
		-0.520068f, -0.472259f, -4.21762f, -0.613612f, -0.472259f, -4.19082f, 
		-0.613612f, -0.472259f, -4.19082f, -0.613612f, -0.472259f, -4.19082f, 
		-0.589638f, -0.472259f, -4.22630f, -0.589638f, -0.472259f, -4.22630f, 
		-0.589638f, -0.472259f, -4.22630f, -0.611782f, -0.472259f, -4.08968f, 
		-0.611782f, -0.472259f, -4.08968f, -0.611782f, -0.472259f, -4.08968f, 
		-0.508233f, -0.472259f, -4.09730f, -0.508233f, -0.472259f, -4.09730f, 
		-0.508233f, -0.472259f, -4.09730f, -0.452673f, -0.472259f, -4.09317f, 
		-0.452673f, -0.472259f, -4.09317f, -0.452673f, -0.472259f, -4.09317f, 
		-0.457002f, -0.472259f, -4.16943f, -0.457002f, -0.472259f, -4.16943f, 
		-0.457002f, -0.472259f, -4.16943f, -0.457046f, -0.472259f, -4.21175f, 
		-0.457046f, -0.472259f, -4.21175f, -0.457046f, -0.472259f, -4.21175f, 
		-0.520746f, -0.499628f, -4.17345f, -0.520746f, -0.499628f, -4.17345f, 
		-0.520746f, -0.499628f, -4.17345f, -0.457001f, -0.499628f, -4.16943f, 
		-0.457001f, -0.499628f, -4.16943f, -0.457001f, -0.499628f, -4.16943f, 
		-0.457001f, -0.499628f, -4.16943f, -0.508233f, -0.512573f, -4.09730f, 
		-0.508233f, -0.512573f, -4.09730f, -0.508233f, -0.512573f, -4.09730f, 
		-0.508233f, -0.512573f, -4.09730f, -0.508233f, -0.512573f, -4.09730f, 
		-0.613612f, -0.499628f, -4.19082f, -0.613612f, -0.499628f, -4.19082f, 
		-0.613612f, -0.499628f, -4.19082f, -0.520068f, -0.499628f, -4.21762f, 
		-0.520068f, -0.499628f, -4.21762f, -0.520068f, -0.499628f, -4.21762f, 
		-0.452673f, -0.511435f, -4.09317f, -0.452673f, -0.511435f, -4.09317f, 
		-0.452673f, -0.511435f, -4.09317f, -0.457046f, -0.499628f, -4.21175f, 
		-0.457046f, -0.499628f, -4.21175f, -0.457046f, -0.499628f, -4.21175f, 
		-0.589638f, -0.499628f, -4.22630f, -0.589638f, -0.499628f, -4.22630f, 
		-0.589638f, -0.499628f, -4.22630f, -0.611782f, -0.512910f, -4.08968f, 
		-0.611782f, -0.512910f, -4.08968f, -0.611782f, -0.512910f, -4.08968f, 
		-0.620667f, -0.472259f, -4.14573f, -0.620667f, -0.472259f, -4.14573f, 
		-0.620667f, -0.472259f, -4.14573f, -0.613612f, -0.481356f, -4.19082f, 
		-0.613612f, -0.481356f, -4.19082f, -0.611782f, -0.481356f, -4.08968f, 
		-0.611782f, -0.481356f, -4.08968f, -0.620667f, -0.499628f, -4.14573f, 
		-0.620667f, -0.499628f, -4.14573f, -0.620667f, -0.499628f, -4.14573f, 
		-0.620667f, -0.499628f, -4.14573f, -0.620667f, -0.499628f, -4.14573f, 
		-0.620667f, -0.481356f, -4.14573f, -0.620667f, -0.481356f, -4.14573f, 
		-0.759494f, -0.475098f, -4.39751f, -0.759494f, -0.475098f, -4.39751f, 
		-0.759494f, -0.475098f, -4.39751f, -0.759494f, -0.475098f, -4.39751f, 
		-0.699446f, -0.472383f, -4.32928f, -0.699446f, -0.472383f, -4.32928f, 
		-0.699446f, -0.472383f, -4.32928f, -0.699446f, -0.472383f, -4.32928f, 
		-0.652198f, -0.472383f, -4.50343f, -0.652198f, -0.472383f, -4.50343f, 
		-0.652198f, -0.472383f, -4.50343f, -0.652198f, -0.472383f, -4.50343f, 
		-0.647015f, -0.472383f, -4.42040f, -0.647015f, -0.472383f, -4.42040f, 
		-0.647015f, -0.472383f, -4.42040f, -0.894644f, -0.472383f, -4.50107f, 
		-0.894644f, -0.472383f, -4.50107f, -0.894644f, -0.472383f, -4.50107f, 
		-0.879039f, -0.472383f, -4.41322f, -0.879039f, -0.472383f, -4.41322f, 
		-0.879039f, -0.472383f, -4.41322f, -0.879039f, -0.472383f, -4.41322f, 
		-0.883780f, -0.472383f, -4.33680f, -0.883780f, -0.472383f, -4.33680f, 
		-0.883780f, -0.472383f, -4.33680f, -0.772429f, -0.476908f, -4.33497f, 
		-0.772429f, -0.476908f, -4.33497f, -0.772429f, -0.476908f, -4.33497f, 
		-0.772429f, -0.476908f, -4.33497f, -0.734591f, -0.466952f, -4.29897f, 
		-0.734591f, -0.466952f, -4.29897f, -0.734591f, -0.466952f, -4.29897f, 
		-0.759494f, -0.499628f, -4.39751f, -0.772429f, -0.499628f, -4.33497f, 
		-0.772429f, -0.499628f, -4.33497f, -0.772429f, -0.499628f, -4.33497f, 
		-0.879039f, -0.499628f, -4.41322f, -0.879039f, -0.499628f, -4.41322f, 
		-0.879039f, -0.499628f, -4.41322f, -0.652198f, -0.499628f, -4.50342f, 
		-0.652198f, -0.499628f, -4.50342f, -0.652198f, -0.499628f, -4.50342f, 
		-0.699446f, -0.499628f, -4.32928f, -0.699446f, -0.499628f, -4.32928f, 
		-0.699446f, -0.499628f, -4.32928f, -0.883780f, -0.499628f, -4.33680f, 
		-0.883780f, -0.499628f, -4.33680f, -0.883780f, -0.499628f, -4.33680f, 
		-0.734591f, -0.499628f, -4.29897f, -0.734591f, -0.499628f, -4.29897f, 
		-0.734591f, -0.499628f, -4.29897f, -0.647015f, -0.499628f, -4.42040f, 
		-0.647015f, -0.499628f, -4.42040f, -0.647015f, -0.499628f, -4.42040f, 
		-0.894644f, -0.499628f, -4.50107f, -0.894644f, -0.499628f, -4.50107f, 
		-0.894644f, -0.499628f, -4.50107f, -0.700350f, -0.472383f, -4.21305f, 
		-0.695711f, -0.472383f, -4.29540f, -0.695711f, -0.472383f, -4.29540f, 
		-0.695711f, -0.472383f, -4.29540f, -0.787754f, -0.472383f, -4.24891f, 
		-0.787754f, -0.472383f, -4.24891f, -0.787754f, -0.472383f, -4.24891f, 
		-0.730045f, -0.472383f, -4.27980f, -0.730045f, -0.472383f, -4.27980f, 
		-0.730045f, -0.472383f, -4.27980f, -0.760744f, -0.472383f, -4.09587f, 
		-0.760744f, -0.472383f, -4.09587f, -0.760744f, -0.472383f, -4.09587f, 
		-0.708805f, -0.472383f, -4.09034f, -0.708805f, -0.472383f, -4.09034f, 
		-0.708805f, -0.472383f, -4.09034f, -0.621183f, -0.472383f, -4.09138f, 
		-0.621183f, -0.472383f, -4.09138f, -0.621183f, -0.472383f, -4.09138f, 
		-0.608780f, -0.472383f, -4.21860f, -0.608780f, -0.472383f, -4.21860f, 
		-0.608780f, -0.472383f, -4.21860f, -0.651692f, -0.472383f, -4.25738f, 
		-0.651692f, -0.472383f, -4.25738f, -0.651692f, -0.472383f, -4.25738f, 
		-0.700350f, -0.499628f, -4.21305f, -0.700350f, -0.499628f, -4.21305f, 
		-0.700350f, -0.499628f, -4.21305f, -0.608780f, -0.499628f, -4.21860f, 
		-0.608780f, -0.499628f, -4.21860f, -0.608780f, -0.499628f, -4.21860f, 
		-0.708805f, -0.513927f, -4.09034f, -0.708805f, -0.513927f, -4.09034f, 
		-0.708805f, -0.513927f, -4.09034f, -0.708805f, -0.513927f, -4.09034f, 
		-0.708805f, -0.513927f, -4.09034f, -0.787754f, -0.499628f, -4.24891f, 
		-0.787754f, -0.499628f, -4.24891f, -0.787754f, -0.499628f, -4.24891f, 
		-0.787754f, -0.499628f, -4.24891f, -0.695711f, -0.499628f, -4.29540f, 
		-0.695711f, -0.499628f, -4.29540f, -0.695711f, -0.499628f, -4.29540f, 
		-0.621183f, -0.510164f, -4.09138f, -0.621183f, -0.510164f, -4.09138f, 
		-0.621183f, -0.510164f, -4.09138f, -0.651692f, -0.499628f, -4.25738f, 
		-0.651692f, -0.499628f, -4.25738f, -0.651692f, -0.499628f, -4.25738f, 
		-0.730045f, -0.499628f, -4.27980f, -0.730045f, -0.499628f, -4.27980f, 
		-0.730045f, -0.499628f, -4.27980f, -0.760744f, -0.505649f, -4.09587f, 
		-0.760744f, -0.505649f, -4.09587f, -0.760744f, -0.505649f, -4.09587f, 
		-0.634941f, -0.472383f, -4.16066f, -0.634941f, -0.472383f, -4.16066f, 
		-0.634941f, -0.472383f, -4.16066f, -0.621183f, -0.481356f, -4.09138f, 
		-0.621183f, -0.481356f, -4.09138f, -0.608780f, -0.481356f, -4.21860f, 
		-0.608780f, -0.481356f, -4.21860f, -0.634941f, -0.499628f, -4.16066f, 
		-0.634941f, -0.499628f, -4.16066f, -0.634941f, -0.499628f, -4.16066f, 
		-0.634941f, -0.499628f, -4.16066f, -0.634941f, -0.499628f, -4.16066f, 
		-0.634941f, -0.481356f, -4.16066f, -0.634941f, -0.481356f, -4.16066f, 
		-0.830127f, -0.473013f, -4.29012f, -0.827540f, -0.473013f, -4.32720f, 
		-0.827540f, -0.473013f, -4.32720f, -0.827540f, -0.473013f, -4.32720f, 
		-0.895168f, -0.473013f, -4.30280f, -0.895168f, -0.473013f, -4.30280f, 
		-0.895168f, -0.473013f, -4.30280f, -0.880116f, -0.473013f, -4.33036f, 
		-0.880116f, -0.473013f, -4.33036f, -0.880116f, -0.473013f, -4.33036f, 
		-0.864995f, -0.473013f, -4.24837f, -0.864995f, -0.473013f, -4.24837f, 
		-0.864995f, -0.473013f, -4.24837f, -0.828509f, -0.473013f, -4.25168f, 
		-0.828509f, -0.473013f, -4.25168f, -0.828509f, -0.473013f, -4.25168f, 
		-0.800071f, -0.473013f, -4.25695f, -0.800071f, -0.473013f, -4.25695f, 
		-0.800071f, -0.473013f, -4.25695f, -0.742285f, -0.473013f, -4.28743f, 
		-0.742285f, -0.473013f, -4.28743f, -0.742285f, -0.473013f, -4.28743f, 
		-0.777608f, -0.473013f, -4.32246f, -0.777608f, -0.473013f, -4.32246f, 
		-0.777608f, -0.473013f, -4.32246f, -0.830127f, -0.494172f, -4.29012f, 
		-0.742285f, -0.494172f, -4.28743f, -0.742285f, -0.494172f, -4.28743f, 
		-0.742285f, -0.494172f, -4.28743f, -0.828509f, -0.494172f, -4.25168f, 
		-0.828509f, -0.494172f, -4.25168f, -0.828509f, -0.494172f, -4.25168f, 
		-0.895168f, -0.494172f, -4.30280f, -0.895168f, -0.494172f, -4.30280f, 
		-0.895168f, -0.494172f, -4.30280f, -0.827539f, -0.494172f, -4.32720f, 
		-0.827539f, -0.494172f, -4.32720f, -0.827539f, -0.494172f, -4.32720f, 
		-0.800071f, -0.494172f, -4.25695f, -0.800071f, -0.494172f, -4.25695f, 
		-0.800071f, -0.494172f, -4.25695f, -0.777608f, -0.494172f, -4.32246f, 
		-0.777608f, -0.494172f, -4.32246f, -0.777608f, -0.494172f, -4.32246f, 
		-0.880116f, -0.494172f, -4.33036f, -0.880116f, -0.494172f, -4.33036f, 
		-0.880116f, -0.494172f, -4.33036f, -0.864995f, -0.494172f, -4.24837f, 
		-0.864995f, -0.494172f, -4.24837f, -0.864995f, -0.494172f, -4.24837f, 
		-0.837092f, -0.472383f, -4.14470f, -0.782124f, -0.472383f, -4.13513f, 
		-0.782124f, -0.472383f, -4.13513f, -0.782124f, -0.472383f, -4.13513f, 
		-0.802528f, -0.472383f, -4.24446f, -0.802528f, -0.472383f, -4.24446f, 
		-0.802528f, -0.472383f, -4.24446f, -0.788106f, -0.472383f, -4.17900f, 
		-0.788106f, -0.472383f, -4.17900f, -0.788106f, -0.472383f, -4.17900f, 
		-0.879237f, -0.472383f, -4.23588f, -0.879237f, -0.472383f, -4.23588f, 
		-0.879237f, -0.472383f, -4.23588f, -0.891716f, -0.472383f, -4.14970f, 
		-0.891716f, -0.472383f, -4.14970f, -0.891716f, -0.472383f, -4.14970f, 
		-0.891291f, -0.472383f, -4.09504f, -0.891291f, -0.472383f, -4.09504f, 
		-0.891291f, -0.472383f, -4.09504f, -0.847330f, -0.472383f, -4.08701f, 
		-0.847330f, -0.472383f, -4.08701f, -0.847330f, -0.472383f, -4.08701f, 
		-0.774811f, -0.472383f, -4.09256f, -0.774811f, -0.472383f, -4.09256f, 
		-0.774811f, -0.472383f, -4.09256f, -0.837092f, -0.499628f, -4.14470f, 
		-0.837092f, -0.499628f, -4.14470f, -0.837092f, -0.499628f, -4.14470f, 
		-0.847330f, -0.513175f, -4.08701f, -0.847330f, -0.513175f, -4.08701f, 
		-0.847330f, -0.513175f, -4.08701f, -0.847330f, -0.513175f, -4.08701f, 
		-0.891716f, -0.499628f, -4.14970f, -0.891716f, -0.499628f, -4.14970f, 
		-0.891716f, -0.499628f, -4.14970f, -0.891716f, -0.499628f, -4.14970f, 
		-0.802528f, -0.499628f, -4.24446f, -0.802528f, -0.499628f, -4.24446f, 
		-0.802528f, -0.499628f, -4.24446f, -0.782124f, -0.499628f, -4.13513f, 
		-0.782124f, -0.499628f, -4.13513f, -0.782124f, -0.499628f, -4.13513f, 
		-0.782124f, -0.499628f, -4.13513f, -0.891291f, -0.508659f, -4.09504f, 
		-0.891291f, -0.508659f, -4.09504f, -0.891291f, -0.508659f, -4.09504f, 
		-0.774811f, -0.515432f, -4.09256f, -0.774811f, -0.515432f, -4.09256f, 
		-0.774811f, -0.515432f, -4.09256f, -0.788106f, -0.499628f, -4.17900f, 
		-0.788106f, -0.499628f, -4.17900f, -0.788106f, -0.499628f, -4.17900f, 
		-0.879237f, -0.499628f, -4.23588f, -0.879237f, -0.499628f, -4.23588f, 
		-0.879237f, -0.499628f, -4.23588f, -0.952338f, -0.464237f, -4.41042f, 
		-0.952338f, -0.464237f, -4.41042f, -0.952338f, -0.464237f, -4.41042f, 
		-0.952338f, -0.464237f, -4.41042f, -0.893638f, -0.472383f, -4.33962f, 
		-0.893638f, -0.472383f, -4.33962f, -0.893638f, -0.472383f, -4.33962f, 
		-0.893638f, -0.472383f, -4.33962f, -0.908999f, -0.472383f, -4.50272f, 
		-0.908999f, -0.472383f, -4.50272f, -0.908999f, -0.472383f, -4.50272f, 
		-0.908999f, -0.472383f, -4.50272f, -0.894778f, -0.476003f, -4.41818f, 
		-0.894778f, -0.476003f, -4.41818f, -0.894778f, -0.476003f, -4.41818f, 
		-1.00244f, -0.472383f, -4.50201f, -1.00244f, -0.472383f, -4.50201f, 
		-1.00244f, -0.472383f, -4.50201f, -1.04968f, -0.472383f, -4.44236f, 
		-1.04968f, -0.472383f, -4.44236f, -1.04968f, -0.472383f, -4.44236f, 
		-1.04968f, -0.472383f, -4.44236f, -1.05361f, -0.472383f, -4.37857f, 
		-1.05361f, -0.472383f, -4.37857f, -1.05361f, -0.472383f, -4.37857f, 
		-0.973673f, -0.472383f, -4.29752f, -0.973673f, -0.472383f, -4.29752f, 
		-0.973673f, -0.472383f, -4.29752f, -0.973673f, -0.472383f, -4.29752f, 
		-0.906398f, -0.472383f, -4.30412f, -0.906398f, -0.472383f, -4.30412f, 
		-0.906398f, -0.472383f, -4.30412f, -0.952338f, -0.499628f, -4.41042f, 
		-0.973673f, -0.499628f, -4.29752f, -0.973673f, -0.499628f, -4.29752f, 
		-0.973673f, -0.499628f, -4.29752f, -1.04968f, -0.499628f, -4.44236f, 
		-1.04968f, -0.499628f, -4.44236f, -1.04968f, -0.499628f, -4.44236f, 
		-0.908999f, -0.499628f, -4.50272f, -0.908999f, -0.499628f, -4.50272f, 
		-0.908999f, -0.499628f, -4.50272f, -0.893638f, -0.499628f, -4.33962f, 
		-0.893638f, -0.499628f, -4.33962f, -0.893638f, -0.499628f, -4.33962f, 
		-1.05361f, -0.499628f, -4.37857f, -1.05361f, -0.499628f, -4.37857f, 
		-1.05361f, -0.499628f, -4.37857f, -0.906398f, -0.499628f, -4.30412f, 
		-0.906398f, -0.499628f, -4.30412f, -0.906398f, -0.499628f, -4.30412f, 
		-0.894778f, -0.499628f, -4.41818f, -0.894778f, -0.499628f, -4.41818f, 
		-0.894778f, -0.499628f, -4.41818f, -1.00244f, -0.499628f, -4.50201f, 
		-1.00244f, -0.499628f, -4.50201f, -1.00244f, -0.499628f, -4.50201f, 
		-0.979874f, -0.472383f, -4.23687f, -0.899633f, -0.472383f, -4.23124f, 
		-0.899633f, -0.472383f, -4.23124f, -0.899633f, -0.472383f, -4.23124f, 
		-0.901858f, -0.472383f, -4.29039f, -0.901858f, -0.472383f, -4.29039f, 
		-0.901858f, -0.472383f, -4.29039f, -0.882500f, -0.472383f, -4.25504f, 
		-0.882500f, -0.472383f, -4.25504f, -0.882500f, -0.472383f, -4.25504f, 
		-0.983880f, -0.472383f, -4.28972f, -0.983880f, -0.472383f, -4.28972f, 
		-0.983880f, -0.472383f, -4.28972f, -1.03450f, -0.472383f, -4.24187f, 
		-1.03450f, -0.472383f, -4.24187f, -1.03450f, -0.472383f, -4.24187f, 
		-1.05293f, -0.472383f, -4.20317f, -1.05293f, -0.472383f, -4.20317f, 
		-1.05293f, -0.472383f, -4.20317f, -0.962132f, -0.472383f, -4.08515f, 
		-0.962132f, -0.472383f, -4.08515f, -0.962132f, -0.472383f, -4.08515f, 
		-0.898456f, -0.472383f, -4.09386f, -0.898456f, -0.472383f, -4.09386f, 
		-0.898456f, -0.472383f, -4.09386f, -0.979874f, -0.499628f, -4.23687f, 
		-0.979874f, -0.499628f, -4.23687f, -0.979874f, -0.499628f, -4.23687f, 
		-0.979874f, -0.499628f, -4.23687f, -0.962132f, -0.507693f, -4.08515f, 
		-0.962132f, -0.507693f, -4.08515f, -0.962132f, -0.507693f, -4.08515f, 
		-0.962132f, -0.507693f, -4.08515f, -1.03450f, -0.499628f, -4.24187f, 
		-1.03450f, -0.499628f, -4.24187f, -1.03450f, -0.499628f, -4.24187f, 
		-1.03450f, -0.499628f, -4.24187f, -1.03450f, -0.499628f, -4.24187f, 
		-0.901858f, -0.499628f, -4.29039f, -0.901858f, -0.499628f, -4.29039f, 
		-0.901858f, -0.499628f, -4.29039f, -0.899633f, -0.499628f, -4.23124f, 
		-0.899633f, -0.499628f, -4.23124f, -0.899633f, -0.499628f, -4.23124f, 
		-0.899633f, -0.499628f, -4.23124f, -1.05293f, -0.499628f, -4.20317f, 
		-1.05293f, -0.499628f, -4.20317f, -1.05293f, -0.499628f, -4.20317f, 
		-0.898456f, -0.499628f, -4.09386f, -0.898456f, -0.499628f, -4.09386f, 
		-0.898456f, -0.499628f, -4.09386f, -0.882500f, -0.499628f, -4.25504f, 
		-0.882500f, -0.499628f, -4.25504f, -0.882500f, -0.499628f, -4.25504f, 
		-0.983880f, -0.499628f, -4.28972f, -0.983880f, -0.499628f, -4.28972f, 
		-0.983880f, -0.499628f, -4.28972f, -1.02953f, -0.472383f, -4.09207f, 
		-1.02953f, -0.472383f, -4.09207f, -1.02953f, -0.472383f, -4.09207f, 
		-1.05293f, -0.481356f, -4.20317f, -1.05293f, -0.481356f, -4.20317f, 
		-0.962132f, -0.481356f, -4.08515f, -0.962132f, -0.481356f, -4.08515f, 
		-1.02953f, -0.508934f, -4.09207f, -1.02953f, -0.508934f, -4.09207f, 
		-1.02953f, -0.508934f, -4.09207f, -1.02953f, -0.508934f, -4.09207f, 
		-1.02953f, -0.508934f, -4.09207f, -1.02953f, -0.481356f, -4.09207f, 
		-1.02953f, -0.481356f, -4.09207f, -1.11375f, -0.478718f, -4.40289f, 
		-1.11375f, -0.478718f, -4.40289f, -1.11375f, -0.478718f, -4.40289f, 
		-1.11375f, -0.478718f, -4.40289f, -1.06344f, -0.472383f, -4.37438f, 
		-1.06344f, -0.472383f, -4.37438f, -1.06344f, -0.472383f, -4.37438f, 
		-1.06344f, -0.472383f, -4.37438f, -1.01714f, -0.472383f, -4.50469f, 
		-1.01714f, -0.472383f, -4.50469f, -1.01714f, -0.472383f, -4.50469f, 
		-1.01714f, -0.472383f, -4.50469f, -1.06226f, -0.472383f, -4.43946f, 
		-1.06226f, -0.472383f, -4.43946f, -1.06226f, -0.472383f, -4.43946f, 
		-1.18242f, -0.472383f, -4.50361f, -1.18242f, -0.472383f, -4.50361f, 
		-1.18242f, -0.472383f, -4.50361f, -1.16860f, -0.472383f, -4.40237f, 
		-1.16860f, -0.472383f, -4.40237f, -1.16860f, -0.472383f, -4.40237f, 
		-1.16860f, -0.472383f, -4.40237f, -1.16207f, -0.472383f, -4.34174f, 
		-1.16207f, -0.472383f, -4.34174f, -1.16207f, -0.472383f, -4.34174f, 
		-1.12033f, -0.472383f, -4.33936f, -1.12033f, -0.472383f, -4.33936f, 
		-1.12033f, -0.472383f, -4.33936f, -1.12033f, -0.472383f, -4.33936f, 
		-1.03768f, -0.467857f, -4.34529f, -1.03768f, -0.467857f, -4.34529f, 
		-1.03768f, -0.467857f, -4.34529f, -1.11375f, -0.499628f, -4.40289f, 
		-1.12033f, -0.499628f, -4.33936f, -1.12033f, -0.499628f, -4.33936f, 
		-1.12033f, -0.499628f, -4.33936f, -1.16860f, -0.499628f, -4.40237f, 
		-1.16860f, -0.499628f, -4.40237f, -1.16860f, -0.499628f, -4.40237f, 
		-1.01714f, -0.499628f, -4.50469f, -1.01714f, -0.499628f, -4.50469f, 
		-1.01714f, -0.499628f, -4.50469f, -1.06344f, -0.499628f, -4.37438f, 
		-1.06344f, -0.499628f, -4.37438f, -1.06344f, -0.499628f, -4.37438f, 
		-1.16207f, -0.499628f, -4.34174f, -1.16207f, -0.499628f, -4.34174f, 
		-1.16207f, -0.499628f, -4.34174f, -1.03768f, -0.499628f, -4.34529f, 
		-1.03768f, -0.499628f, -4.34529f, -1.03768f, -0.499628f, -4.34529f, 
		-1.06226f, -0.499628f, -4.43946f, -1.06226f, -0.499628f, -4.43946f, 
		-1.06226f, -0.499628f, -4.43946f, -1.18242f, -0.499628f, -4.50361f, 
		-1.18242f, -0.499628f, -4.50361f, -1.18242f, -0.499628f, -4.50361f, 
		-1.10872f, -0.472383f, -4.14098f, -1.10201f, -0.472383f, -4.20642f, 
		-1.10201f, -0.472383f, -4.20642f, -1.10201f, -0.472383f, -4.20642f, 
		-1.19185f, -0.472383f, -4.18742f, -1.19185f, -0.472383f, -4.18742f, 
		-1.19185f, -0.472383f, -4.18742f, -1.14723f, -0.472383f, -4.20474f, 
		-1.14723f, -0.472383f, -4.20474f, -1.14723f, -0.472383f, -4.20474f, 
		-1.16368f, -0.472383f, -4.09088f, -1.16368f, -0.472383f, -4.09088f, 
		-1.16368f, -0.472383f, -4.09088f, -1.11114f, -0.472383f, -4.09646f, 
		-1.11114f, -0.472383f, -4.09646f, -1.11114f, -0.472383f, -4.09646f, 
		-1.04014f, -0.472383f, -4.09128f, -1.04014f, -0.472383f, -4.09128f, 
		-1.04014f, -0.472383f, -4.09128f, -1.04575f, -0.472383f, -4.13030f, 
		-1.04575f, -0.472383f, -4.13030f, -1.04575f, -0.472383f, -4.13030f, 
		-1.05920f, -0.472383f, -4.20210f, -1.05920f, -0.472383f, -4.20210f, 
		-1.05920f, -0.472383f, -4.20210f, -1.10872f, -0.499628f, -4.14098f, 
		-1.10872f, -0.499628f, -4.14098f, -1.10872f, -0.499628f, -4.14098f, 
		-1.04575f, -0.499628f, -4.13030f, -1.04575f, -0.499628f, -4.13030f, 
		-1.04575f, -0.499628f, -4.13030f, -1.04575f, -0.499628f, -4.13030f, 
		-1.11114f, -0.508680f, -4.09646f, -1.11114f, -0.508680f, -4.09646f, 
		-1.11114f, -0.508680f, -4.09646f, -1.11114f, -0.508680f, -4.09646f, 
		-1.19185f, -0.499628f, -4.18742f, -1.19185f, -0.499628f, -4.18742f, 
		-1.19185f, -0.499628f, -4.18742f, -1.19185f, -0.499628f, -4.18742f, 
		-1.10201f, -0.499628f, -4.20642f, -1.10201f, -0.499628f, -4.20642f, 
		-1.10201f, -0.499628f, -4.20642f, -1.04014f, -0.499628f, -4.09128f, 
		-1.04014f, -0.499628f, -4.09128f, -1.04014f, -0.499628f, -4.09128f, 
		-1.05920f, -0.499628f, -4.20210f, -1.05920f, -0.499628f, -4.20210f, 
		-1.05920f, -0.499628f, -4.20210f, -1.14723f, -0.499628f, -4.20474f, 
		-1.14723f, -0.499628f, -4.20474f, -1.14723f, -0.499628f, -4.20474f, 
		-1.16368f, -0.509948f, -4.09088f, -1.16368f, -0.509948f, -4.09088f, 
		-1.16368f, -0.509948f, -4.09088f, -1.23624f, -0.472383f, -4.13344f, 
		-1.18267f, -0.472383f, -4.12585f, -1.18267f, -0.472383f, -4.12585f, 
		-1.18267f, -0.472383f, -4.12585f, -1.22664f, -0.472383f, -4.19512f, 
		-1.22664f, -0.472383f, -4.19512f, -1.22664f, -0.472383f, -4.19512f, 
		-1.19470f, -0.472383f, -4.18072f, -1.19470f, -0.472383f, -4.18072f, 
		-1.19470f, -0.472383f, -4.18072f, -1.30743f, -0.472383f, -4.18779f, 
		-1.30743f, -0.472383f, -4.18779f, -1.30743f, -0.472383f, -4.18779f, 
		-1.30966f, -0.472383f, -4.13560f, -1.30966f, -0.472383f, -4.13560f, 
		-1.30966f, -0.472383f, -4.13560f, -1.30868f, -0.472383f, -4.08733f, 
		-1.30868f, -0.472383f, -4.08733f, -1.30868f, -0.472383f, -4.08733f, 
		-1.26088f, -0.472383f, -4.08118f, -1.26088f, -0.472383f, -4.08118f, 
		-1.26088f, -0.472383f, -4.08118f, -1.17301f, -0.472383f, -4.09048f, 
		-1.17301f, -0.472383f, -4.09048f, -1.17301f, -0.472383f, -4.09048f, 
		-1.23624f, -0.499628f, -4.13344f, -1.23624f, -0.499628f, -4.13344f, 
		-1.23624f, -0.499628f, -4.13344f, -1.26088f, -0.507476f, -4.08118f, 
		-1.26088f, -0.507476f, -4.08118f, -1.26088f, -0.507476f, -4.08118f, 
		-1.26088f, -0.507476f, -4.08118f, -1.30966f, -0.499628f, -4.13560f, 
		-1.30966f, -0.499628f, -4.13560f, -1.30966f, -0.499628f, -4.13560f, 
		-1.30966f, -0.499628f, -4.13560f, -1.22664f, -0.499628f, -4.19512f, 
		-1.22664f, -0.499628f, -4.19512f, -1.22664f, -0.499628f, -4.19512f, 
		-1.18267f, -0.499628f, -4.12585f, -1.18267f, -0.499628f, -4.12585f, 
		-1.18267f, -0.499628f, -4.12585f, -1.18267f, -0.499628f, -4.12585f, 
		-1.30868f, -0.499628f, -4.08733f, -1.30868f, -0.499628f, -4.08733f, 
		-1.30868f, -0.499628f, -4.08733f, -1.17301f, -0.507720f, -4.09048f, 
		-1.17301f, -0.507720f, -4.09048f, -1.17301f, -0.507720f, -4.09048f, 
		-1.19470f, -0.499628f, -4.18072f, -1.19470f, -0.499628f, -4.18072f, 
		-1.19470f, -0.499628f, -4.18072f, -1.30743f, -0.499628f, -4.18779f, 
		-1.30743f, -0.499628f, -4.18779f, -1.30743f, -0.499628f, -4.18779f, 
		-1.10695f, -0.463332f, -4.27128f, -1.10695f, -0.463332f, -4.27128f, 
		-1.10695f, -0.463332f, -4.27128f, -1.10695f, -0.463332f, -4.27128f, 
		-1.06155f, -0.472383f, -4.21231f, -1.06155f, -0.472383f, -4.21231f, 
		-1.06155f, -0.472383f, -4.21231f, -1.06155f, -0.472383f, -4.21231f, 
		-0.992613f, -0.478718f, -4.29951f, -0.992613f, -0.478718f, -4.29951f, 
		-0.992613f, -0.478718f, -4.29951f, -0.992613f, -0.478718f, -4.29951f, 
		-1.04130f, -0.472383f, -4.24652f, -1.04130f, -0.472383f, -4.24652f, 
		-1.04130f, -0.472383f, -4.24652f, -1.02942f, -0.472383f, -4.33852f, 
		-1.02942f, -0.472383f, -4.33852f, -1.02942f, -0.472383f, -4.33852f, 
		-1.12163f, -0.472383f, -4.33160f, -1.12163f, -0.472383f, -4.33160f, 
		-1.12163f, -0.472383f, -4.33160f, -1.12163f, -0.472383f, -4.33160f, 
		-1.15949f, -0.472383f, -4.33136f, -1.15949f, -0.472383f, -4.33136f, 
		-1.15949f, -0.472383f, -4.33136f, -1.17027f, -0.472383f, -4.26290f, 
		-1.17027f, -0.472383f, -4.26290f, -1.17027f, -0.472383f, -4.26290f, 
		-1.17027f, -0.472383f, -4.26290f, -1.14500f, -0.472383f, -4.21495f, 
		-1.14500f, -0.472383f, -4.21495f, -1.14500f, -0.472383f, -4.21495f, 
		-1.10695f, -0.499628f, -4.27128f, -1.17027f, -0.499628f, -4.26290f, 
		-1.17027f, -0.499628f, -4.26290f, -1.17027f, -0.499628f, -4.26290f, 
		-1.12163f, -0.499628f, -4.33160f, -1.12163f, -0.499628f, -4.33160f, 
		-1.12163f, -0.499628f, -4.33160f, -0.992613f, -0.499628f, -4.29951f, 
		-0.992613f, -0.499628f, -4.29951f, -0.992613f, -0.499628f, -4.29951f, 
		-1.06155f, -0.499628f, -4.21231f, -1.06155f, -0.499628f, -4.21231f, 
		-1.06155f, -0.499628f, -4.21231f, -1.15949f, -0.499628f, -4.33136f, 
		-1.15949f, -0.499628f, -4.33136f, -1.15949f, -0.499628f, -4.33136f, 
		-1.14500f, -0.499628f, -4.21495f, -1.14500f, -0.499628f, -4.21495f, 
		-1.14500f, -0.499628f, -4.21495f, -1.04130f, -0.499628f, -4.24652f, 
		-1.04130f, -0.499628f, -4.24652f, -1.04130f, -0.499628f, -4.24652f, 
		-1.02942f, -0.499628f, -4.33852f, -1.02942f, -0.499628f, -4.33852f, 
		-1.02942f, -0.499628f, -4.33852f, -1.25688f, -0.475098f, -4.24528f, 
		-1.25688f, -0.475098f, -4.24528f, -1.25688f, -0.475098f, -4.24528f, 
		-1.25688f, -0.475098f, -4.24528f, -1.25688f, -0.475098f, -4.24528f, 
		-1.22550f, -0.472383f, -4.19913f, -1.22550f, -0.472383f, -4.19913f, 
		-1.22550f, -0.472383f, -4.19913f, -1.22550f, -0.472383f, -4.19913f, 
		-1.15232f, -0.472383f, -4.21150f, -1.15232f, -0.472383f, -4.21150f, 
		-1.15232f, -0.472383f, -4.21150f, -1.15232f, -0.472383f, -4.21150f, 
		-1.19625f, -0.472383f, -4.19248f, -1.19625f, -0.472383f, -4.19248f, 
		-1.19625f, -0.472383f, -4.19248f, -1.17340f, -0.472383f, -4.30451f, 
		-1.17340f, -0.472383f, -4.30451f, -1.17340f, -0.472383f, -4.30451f, 
		-1.25846f, -0.472383f, -4.30011f, -1.25846f, -0.472383f, -4.30011f, 
		-1.25846f, -0.472383f, -4.30011f, -1.25846f, -0.472383f, -4.30011f, 
		-1.25846f, -0.472383f, -4.30011f, -1.30896f, -0.472383f, -4.29408f, 
		-1.30896f, -0.472383f, -4.29408f, -1.30896f, -0.472383f, -4.29408f, 
		-1.31255f, -0.472383f, -4.25249f, -1.31255f, -0.472383f, -4.25249f, 
		-1.31255f, -0.472383f, -4.25249f, -1.31255f, -0.472383f, -4.25249f, 
		-1.30777f, -0.472383f, -4.19887f, -1.30777f, -0.472383f, -4.19887f, 
		-1.30777f, -0.472383f, -4.19887f, -1.25688f, -0.499628f, -4.24528f, 
		-1.31255f, -0.499628f, -4.25249f, -1.31255f, -0.499628f, -4.25249f, 
		-1.31255f, -0.499628f, -4.25249f, -1.25846f, -0.499628f, -4.30011f, 
		-1.25846f, -0.499628f, -4.30011f, -1.25846f, -0.499628f, -4.30011f, 
		-1.15232f, -0.499628f, -4.21150f, -1.15232f, -0.499628f, -4.21150f, 
		-1.15232f, -0.499628f, -4.21150f, -1.22550f, -0.499628f, -4.19913f, 
		-1.22550f, -0.499628f, -4.19913f, -1.22550f, -0.499628f, -4.19913f, 
		-1.30896f, -0.499628f, -4.29408f, -1.30896f, -0.499628f, -4.29408f, 
		-1.30896f, -0.499628f, -4.29408f, -1.30777f, -0.499628f, -4.19887f, 
		-1.30777f, -0.499628f, -4.19887f, -1.30777f, -0.499628f, -4.19887f, 
		-1.19625f, -0.499628f, -4.19248f, -1.19625f, -0.499628f, -4.19248f, 
		-1.19625f, -0.499628f, -4.19248f, -1.17340f, -0.499628f, -4.30451f, 
		-1.17340f, -0.499628f, -4.30451f, -1.17340f, -0.499628f, -4.30451f, 
		-1.17936f, -0.472383f, -4.25783f, -1.17936f, -0.472383f, -4.25783f, 
		-1.17936f, -0.472383f, -4.25783f, -1.17936f, -0.472383f, -4.25783f, 
		-1.17936f, -0.472383f, -4.25783f, -1.15232f, -0.481356f, -4.21150f, 
		-1.15232f, -0.481356f, -4.21150f, -1.17340f, -0.481356f, -4.30451f, 
		-1.17340f, -0.481356f, -4.30451f, -1.17936f, -0.499628f, -4.25783f, 
		-1.17936f, -0.499628f, -4.25783f, -1.17936f, -0.499628f, -4.25783f, 
		-1.17936f, -0.481356f, -4.25783f, -1.17936f, -0.481356f, -4.25783f, 
		-1.25792f, -0.464056f, -4.37420f, -1.25792f, -0.464056f, -4.37420f, 
		-1.25792f, -0.464056f, -4.37420f, -1.25792f, -0.464056f, -4.37420f, 
		-1.17491f, -0.478628f, -4.36696f, -1.17491f, -0.478628f, -4.36696f, 
		-1.17491f, -0.478628f, -4.36696f, -1.17491f, -0.478628f, -4.36696f, 
		-1.22519f, -0.472383f, -4.51891f, -1.22519f, -0.472383f, -4.51891f, 
		-1.22519f, -0.472383f, -4.51891f, -1.22519f, -0.472383f, -4.51891f, 
		-1.19243f, -0.472383f, -4.49455f, -1.19243f, -0.472383f, -4.49455f, 
		-1.19243f, -0.472383f, -4.49455f, -1.30721f, -0.472383f, -4.52444f, 
		-1.30721f, -0.472383f, -4.52444f, -1.30721f, -0.472383f, -4.52444f, 
		-1.31254f, -0.472383f, -4.37920f, -1.31254f, -0.472383f, -4.37920f, 
		-1.31254f, -0.472383f, -4.37920f, -1.31254f, -0.472383f, -4.37920f, 
		-1.30872f, -0.472383f, -4.30361f, -1.30872f, -0.472383f, -4.30361f, 
		-1.30872f, -0.472383f, -4.30361f, -1.25702f, -0.472383f, -4.30881f, 
		-1.25702f, -0.472383f, -4.30881f, -1.25702f, -0.472383f, -4.30881f, 
		-1.25702f, -0.472383f, -4.30881f, -1.16951f, -0.472383f, -4.31315f, 
		-1.16951f, -0.472383f, -4.31315f, -1.16951f, -0.472383f, -4.31315f, 
		-1.25792f, -0.499628f, -4.37420f, -1.25702f, -0.499628f, -4.30881f, 
		-1.25702f, -0.499628f, -4.30881f, -1.25702f, -0.499628f, -4.30881f, 
		-1.31254f, -0.499628f, -4.37920f, -1.31254f, -0.499628f, -4.37920f, 
		-1.31254f, -0.499628f, -4.37920f, -1.22519f, -0.499628f, -4.51891f, 
		-1.22519f, -0.499628f, -4.51891f, -1.22519f, -0.499628f, -4.51891f, 
		-1.17491f, -0.499628f, -4.36696f, -1.17491f, -0.499628f, -4.36696f, 
		-1.17491f, -0.499628f, -4.36696f, -1.30872f, -0.499628f, -4.30361f, 
		-1.30872f, -0.499628f, -4.30361f, -1.30872f, -0.499628f, -4.30361f, 
		-1.16951f, -0.499628f, -4.31315f, -1.16951f, -0.499628f, -4.31315f, 
		-1.16951f, -0.499628f, -4.31315f, -1.19243f, -0.499628f, -4.49455f, 
		-1.19243f, -0.499628f, -4.49455f, -1.19243f, -0.499628f, -4.49455f, 
		-1.30721f, -0.499628f, -4.52444f, -1.30721f, -0.499628f, -4.52444f, 
		-1.30721f, -0.499628f, -4.52444f, 0.0538560f, -0.786403f, -4.28735f, 
		0.0538560f, -0.786403f, -4.28735f, 0.0538560f, -0.786403f, -4.28735f, 
		0.0538560f, -0.786403f, -4.28735f, 0.0496820f, -0.859076f, -4.27995f, 
		0.0496820f, -0.859076f, -4.27995f, 0.0496820f, -0.859076f, -4.27995f, 
		0.0496820f, -0.859076f, -4.27995f, 0.0545440f, -0.850561f, -4.38056f, 
		0.0545440f, -0.850561f, -4.38056f, 0.0545440f, -0.850561f, -4.38056f, 
		0.0545440f, -0.850561f, -4.38056f, 0.0496820f, -0.861239f, -4.33150f, 
		0.0496820f, -0.861239f, -4.33150f, 0.0496820f, -0.861239f, -4.33150f, 
		0.0454910f, -0.746653f, -4.38324f, 0.0454910f, -0.746653f, -4.38324f, 
		0.0454910f, -0.746653f, -4.38324f, 0.0496820f, -0.748408f, -4.29488f, 
		0.0496820f, -0.748408f, -4.29488f, 0.0496820f, -0.748408f, -4.29488f, 
		0.0496820f, -0.748408f, -4.29488f, 0.0456760f, -0.767415f, -4.22631f, 
		0.0456760f, -0.767415f, -4.22631f, 0.0456760f, -0.767415f, -4.22631f, 
		0.0438170f, -0.794261f, -4.22399f, 0.0438170f, -0.794261f, -4.22399f, 
		0.0438170f, -0.794261f, -4.22399f, 0.0438170f, -0.794261f, -4.22399f, 
		0.0506490f, -0.857037f, -4.23329f, 0.0506490f, -0.857037f, -4.23329f, 
		0.0506490f, -0.857037f, -4.23329f, 0.0333370f, -0.786403f, -4.28735f, 
		0.0333370f, -0.786403f, -4.28735f, 0.0333370f, -0.786403f, -4.28735f, 
		0.0333370f, -0.786403f, -4.28735f, 0.0315540f, -0.794261f, -4.22399f, 
		0.0315540f, -0.794261f, -4.22399f, 0.0315540f, -0.794261f, -4.22399f, 
		0.0315540f, -0.794261f, -4.22399f, 0.0374180f, -0.748408f, -4.29488f, 
		0.0374180f, -0.748408f, -4.29488f, 0.0374180f, -0.748408f, -4.29488f, 
		0.0374180f, -0.748408f, -4.29488f, 0.0422800f, -0.850561f, -4.38056f, 
		0.0422800f, -0.850561f, -4.38056f, 0.0422800f, -0.850561f, -4.38056f, 
		0.0422800f, -0.850561f, -4.38056f, 0.0374180f, -0.859076f, -4.27995f, 
		0.0374180f, -0.859076f, -4.27995f, 0.0374180f, -0.859076f, -4.27995f, 
		0.0374180f, -0.859076f, -4.27995f, 0.0334120f, -0.767415f, -4.22631f, 
		0.0334120f, -0.767415f, -4.22631f, 0.0334120f, -0.767415f, -4.22631f, 
		0.0383860f, -0.857037f, -4.23116f, 0.0383860f, -0.857037f, -4.23116f, 
		0.0383860f, -0.857037f, -4.23116f, 0.0374180f, -0.861239f, -4.33150f, 
		0.0374180f, -0.861239f, -4.33150f, 0.0374180f, -0.861239f, -4.33150f, 
		0.0332280f, -0.746653f, -4.38324f, 0.0332280f, -0.746653f, -4.38324f, 
		0.0332280f, -0.746653f, -4.38324f, -0.280854f, -0.518136f, -4.09937f, 
		-0.280854f, -0.480385f, -4.09937f, -0.921873f, -0.480385f, -4.09937f, 
		-0.921873f, -0.480385f, -4.09937f, -0.280854f, -0.480385f, -4.09937f, 
		-0.280854f, -0.480385f, -4.09937f, -0.0273630f, 0.283510f, -4.87927f, 
		-0.0273630f, 0.283510f, -4.87927f, -0.0273630f, 0.283510f, -4.87927f, 
		-0.0273630f, -0.448231f, -4.87927f, -0.0273630f, -0.448231f, -4.87927f, 
		-0.0273630f, -0.448231f, -4.87927f, -1.17803f, -0.448231f, -4.87927f, 
		-1.17803f, -0.448231f, -4.87927f, -1.17803f, -0.448231f, -4.87927f, 
		-1.17803f, 0.283510f, -4.87927f, -1.17803f, 0.283510f, -4.87927f, 
		-1.17803f, 0.283510f, -4.87927f, -0.0273630f, 0.328685f, -4.50923f, 
		-0.0273630f, 0.328685f, -4.50923f, -0.0273630f, 0.328685f, -4.50923f, 
		-0.0273630f, -0.474419f, -4.50923f, -0.0273630f, -0.474419f, -4.50923f, 
		-0.0273630f, -0.474419f, -4.50923f, -1.17803f, -0.474419f, -4.50923f, 
		-1.17803f, -0.474419f, -4.50923f, -1.17803f, -0.474419f, -4.50923f, 
		-1.17803f, 0.328685f, -4.50923f, -1.17803f, 0.328685f, -4.50923f, 
		-1.17803f, 0.328685f, -4.50923f, -0.259096f, -0.448231f, -4.87927f, 
		-0.259096f, -0.448231f, -4.87927f, -0.971228f, -0.448231f, -4.87927f, 
		-0.971228f, -0.448231f, -4.87927f, -0.259096f, 0.283510f, -4.87927f, 
		-0.259096f, 0.283510f, -4.87927f, -0.971228f, 0.283510f, -4.87927f, 
		-0.971228f, 0.283510f, -4.87927f, -0.259096f, -0.474419f, -4.50923f, 
		-0.259096f, -0.474419f, -4.50923f, -0.971228f, -0.474419f, -4.50923f, 
		-0.971228f, -0.474419f, -4.50923f, -0.259096f, 0.328685f, -4.50923f, 
		-0.259096f, 0.328685f, -4.50923f, -0.971228f, 0.328685f, -4.50923f, 
		-0.971228f, 0.328685f, -4.50923f, -0.0273630f, 0.0980770f, -4.87927f, 
		-0.0273630f, 0.0980770f, -4.87927f, -0.0273630f, -0.417326f, -4.87927f, 
		-0.0273630f, -0.417326f, -4.87927f, -1.17803f, -0.417326f, -4.87927f, 
		-1.17803f, -0.417326f, -4.87927f, -1.17803f, 0.0980770f, -4.87927f, 
		-1.17803f, 0.0980770f, -4.87927f, -0.0273630f, 0.0980770f, -4.50923f, 
		-0.0273630f, 0.0980770f, -4.50923f, -0.0273630f, -0.443514f, -4.50923f, 
		-0.0273630f, -0.443514f, -4.50923f, -1.17803f, -0.443514f, -4.50923f, 
		-1.17803f, -0.443514f, -4.50923f, -1.17803f, 0.0980770f, -4.50923f, 
		-1.17803f, 0.0980770f, -4.50923f, -0.259096f, 0.0980770f, -4.87927f, 
		-0.259096f, 0.0980770f, -4.87927f, -0.259096f, 0.0980770f, -4.87927f, 
		-0.259096f, -0.417326f, -4.87927f, -0.259096f, -0.417326f, -4.87927f, 
		-0.259096f, -0.417326f, -4.87927f, -0.971228f, 0.0980770f, -4.87927f, 
		-0.971228f, 0.0980770f, -4.87927f, -0.971228f, 0.0980770f, -4.87927f, 
		-0.971228f, -0.417326f, -4.87927f, -0.971228f, -0.417326f, -4.87927f, 
		-0.971228f, -0.417326f, -4.87927f, -0.259096f, -0.443514f, -4.50923f, 
		-0.259096f, -0.443514f, -4.50923f, -0.259096f, -0.443514f, -4.50923f, 
		-0.259096f, 0.0980770f, -4.50923f, -0.259096f, 0.0980770f, -4.50923f, 
		-0.259096f, 0.0980770f, -4.50923f, -0.971228f, -0.443514f, -4.50923f, 
		-0.971228f, -0.443514f, -4.50923f, -0.971228f, -0.443514f, -4.50923f, 
		-0.971228f, 0.0980770f, -4.50923f, -0.971228f, 0.0980770f, -4.50923f, 
		-0.971228f, 0.0980770f, -4.50923f, -1.08759f, -0.448231f, -4.87927f, 
		-1.08759f, -0.448231f, -4.87927f, -1.06760f, -0.448231f, -4.87927f, 
		-1.06760f, -0.448231f, -4.87927f, -1.08759f, 0.283510f, -4.87927f, 
		-1.08759f, 0.283510f, -4.87927f, -1.06760f, 0.283510f, -4.87927f, 
		-1.06760f, 0.283510f, -4.87927f, -1.08759f, -0.474419f, -4.50923f, 
		-1.08759f, -0.474419f, -4.50923f, -1.06760f, -0.474419f, -4.50923f, 
		-1.06760f, -0.474419f, -4.50923f, -1.08759f, 0.328685f, -4.50923f, 
		-1.08759f, 0.328685f, -4.50923f, -1.06760f, 0.328685f, -4.50923f, 
		-1.06760f, 0.328685f, -4.50923f, -1.08759f, -0.417326f, -4.87927f, 
		-1.06760f, -0.417326f, -4.87927f, -1.08759f, 0.0980770f, -4.87927f, 
		-1.06760f, 0.0980770f, -4.87927f, -1.08759f, 0.0980770f, -4.50923f, 
		-1.06760f, 0.0980770f, -4.50923f, -1.08759f, -0.443514f, -4.50923f, 
		-1.06760f, -0.443514f, -4.50923f, -0.132514f, -0.448231f, -4.87927f, 
		-0.132514f, -0.448231f, -4.87927f, -0.154414f, -0.448231f, -4.87927f, 
		-0.154414f, -0.448231f, -4.87927f, -0.132514f, 0.283510f, -4.87927f, 
		-0.132514f, 0.283510f, -4.87927f, -0.154414f, 0.283510f, -4.87927f, 
		-0.154414f, 0.283510f, -4.87927f, -0.132514f, -0.474419f, -4.50923f, 
		-0.132514f, -0.474419f, -4.50923f, -0.154415f, -0.474419f, -4.50923f, 
		-0.154415f, -0.474419f, -4.50923f, -0.132514f, 0.328685f, -4.50923f, 
		-0.132514f, 0.328685f, -4.50923f, -0.154414f, 0.328685f, -4.50923f, 
		-0.154414f, 0.328685f, -4.50923f, -0.132514f, -0.417326f, -4.87927f, 
		-0.154414f, -0.417326f, -4.87927f, -0.132514f, 0.0980770f, -4.87927f, 
		-0.154414f, 0.0980770f, -4.87927f, -0.132514f, 0.0980770f, -4.50923f, 
		-0.154414f, 0.0980770f, -4.50923f, -0.132514f, -0.443514f, -4.50923f, 
		-0.154414f, -0.443514f, -4.50923f, -1.05375f, -0.291978f, -4.49550f, 
		-1.05375f, -0.291978f, -4.49550f, -1.05375f, -0.291978f, -4.49550f, 
		-1.05202f, -0.472163f, -4.49550f, -1.05202f, -0.472163f, -4.49550f, 
		-1.05202f, -0.472163f, -4.49550f, -1.19518f, -0.471821f, -4.49550f, 
		-1.19518f, -0.471821f, -4.49550f, -1.19518f, -0.471821f, -4.49550f, 
		-1.19412f, -0.232883f, -4.49550f, -1.19412f, -0.232883f, -4.49550f, 
		-1.19412f, -0.232883f, -4.49550f, -1.11178f, -0.473248f, -4.49550f, 
		-1.11178f, -0.473248f, -4.49550f, -1.11178f, -0.473248f, -4.49550f, 
		-1.11178f, -0.473248f, -4.49550f, -1.05841f, -0.381804f, -4.49550f, 
		-1.05841f, -0.381804f, -4.49550f, -1.05841f, -0.381804f, -4.49550f, 
		-1.05841f, -0.381804f, -4.49550f, -1.10969f, -0.282765f, -4.49550f, 
		-1.10969f, -0.282765f, -4.49550f, -1.10969f, -0.282765f, -4.49550f, 
		-1.10969f, -0.282765f, -4.49550f, -1.19587f, -0.381804f, -4.50242f, 
		-1.19587f, -0.381804f, -4.50242f, -1.19587f, -0.381804f, -4.50242f, 
		-1.19587f, -0.381804f, -4.50242f, -1.11178f, -0.381804f, -4.48932f, 
		-1.11178f, -0.381804f, -4.48932f, -1.11178f, -0.381804f, -4.48932f, 
		-1.11178f, -0.381804f, -4.48932f, -1.11178f, -0.381804f, -4.53044f, 
		-1.19587f, -0.381804f, -4.53044f, -1.19587f, -0.381804f, -4.53044f, 
		-1.19587f, -0.381804f, -4.53044f, -1.10969f, -0.282765f, -4.53044f, 
		-1.10969f, -0.282765f, -4.53044f, -1.10969f, -0.282765f, -4.53044f, 
		-1.05841f, -0.381804f, -4.53044f, -1.05841f, -0.381804f, -4.53044f, 
		-1.05841f, -0.381804f, -4.53044f, -1.11178f, -0.473248f, -4.53044f, 
		-1.11178f, -0.473248f, -4.53044f, -1.11178f, -0.473248f, -4.53044f, 
		-1.19412f, -0.232883f, -4.53044f, -1.19412f, -0.232883f, -4.53044f, 
		-1.19412f, -0.232883f, -4.53044f, -1.19518f, -0.471821f, -4.53044f, 
		-1.19518f, -0.471821f, -4.53044f, -1.19518f, -0.471821f, -4.53044f, 
		-1.05202f, -0.472163f, -4.53044f, -1.05202f, -0.472163f, -4.53044f, 
		-1.05202f, -0.472163f, -4.53044f, -1.05375f, -0.291978f, -4.53044f, 
		-1.05375f, -0.291978f, -4.53044f, -1.05375f, -0.291978f, -4.53044f, 
		-1.04937f, -0.470395f, -4.52246f, -1.04937f, -0.470395f, -4.50570f, 
		-0.994760f, -0.470305f, -4.52246f, -0.994760f, -0.470305f, -4.52246f, 
		-0.970184f, -0.470864f, -4.52246f, -0.994761f, -0.470305f, -4.50570f, 
		-0.994761f, -0.470305f, -4.50570f, -0.970184f, -0.470864f, -4.50570f, 
		-0.970793f, -0.385441f, -4.49549f, -0.970793f, -0.385441f, -4.49549f, 
		-0.970793f, -0.385441f, -4.49549f, -0.969750f, -0.470671f, -4.49549f, 
		-0.969750f, -0.470671f, -4.49549f, -0.969750f, -0.470671f, -4.49549f, 
		-1.04924f, -0.470632f, -4.49549f, -1.04924f, -0.470632f, -4.49549f, 
		-1.04924f, -0.470632f, -4.49549f, -1.05053f, -0.380800f, -4.49549f, 
		-1.05053f, -0.380800f, -4.49549f, -1.05053f, -0.380800f, -4.49549f, 
		-1.00799f, -0.470103f, -4.49549f, -1.00799f, -0.470103f, -4.49549f, 
		-1.00799f, -0.470103f, -4.49549f, -0.968462f, -0.423406f, -4.49549f, 
		-0.968462f, -0.423406f, -4.49549f, -0.968462f, -0.423406f, -4.49549f, 
		-1.00596f, -0.373699f, -4.49549f, -1.00596f, -0.373699f, -4.49549f, 
		-1.00596f, -0.373699f, -4.49549f, -1.04777f, -0.425446f, -4.49549f, 
		-1.04777f, -0.425446f, -4.49549f, -1.04777f, -0.425446f, -4.49549f, 
		-1.00731f, -0.429117f, -4.49549f, -1.00731f, -0.429117f, -4.52148f, 
		-1.04777f, -0.425446f, -4.52148f, -1.04777f, -0.425446f, -4.52148f, 
		-1.04777f, -0.425446f, -4.52148f, -1.00596f, -0.373699f, -4.52148f, 
		-1.00596f, -0.373699f, -4.52148f, -1.00596f, -0.373699f, -4.52148f, 
		-0.968462f, -0.423406f, -4.52148f, -0.968462f, -0.423406f, -4.52148f, 
		-0.968462f, -0.423406f, -4.52148f, -1.00799f, -0.470103f, -4.52148f, 
		-1.00799f, -0.470103f, -4.52148f, -1.00799f, -0.470103f, -4.52148f, 
		-1.05053f, -0.380800f, -4.52148f, -1.05053f, -0.380800f, -4.52148f, 
		-1.05053f, -0.380800f, -4.52148f, -1.04924f, -0.470632f, -4.52148f, 
		-1.04924f, -0.470632f, -4.52148f, -1.04924f, -0.470632f, -4.52148f, 
		-0.969750f, -0.470671f, -4.52148f, -0.969750f, -0.470671f, -4.52148f, 
		-0.969750f, -0.470671f, -4.52148f, -0.970793f, -0.385441f, -4.52148f, 
		-0.970793f, -0.385441f, -4.52148f, -0.970793f, -0.385441f, -4.52148f, 
		-1.05104f, -0.372817f, -4.51318f, -1.05104f, -0.372817f, -4.50239f, 
		-1.00631f, -0.369060f, -4.51318f, -1.00631f, -0.369060f, -4.51318f, 
		-0.969705f, -0.378921f, -4.52057f, -1.00631f, -0.369060f, -4.50239f, 
		-1.00631f, -0.369060f, -4.50239f, -0.969705f, -0.378921f, -4.50239f, 
		-0.968934f, -0.291962f, -4.49582f, -0.968934f, -0.291962f, -4.49582f, 
		-0.968934f, -0.291962f, -4.49582f, -0.969708f, -0.378892f, -4.49582f, 
		-0.969708f, -0.378892f, -4.49582f, -0.969708f, -0.378892f, -4.49582f, 
		-1.05106f, -0.372817f, -4.49582f, -1.05106f, -0.372817f, -4.49582f, 
		-1.05106f, -0.372817f, -4.49582f, -1.04499f, -0.293177f, -4.49582f, 
		-1.04499f, -0.293177f, -4.49582f, -1.04499f, -0.293177f, -4.49582f, 
		-1.00628f, -0.369167f, -4.49582f, -1.00628f, -0.369167f, -4.49582f, 
		-1.00628f, -0.369167f, -4.49582f, -0.968697f, -0.326312f, -4.49582f, 
		-0.968697f, -0.326312f, -4.49582f, -0.968697f, -0.326312f, -4.49582f, 
		-1.00538f, -0.288004f, -4.49582f, -1.00538f, -0.288004f, -4.49582f, 
		-1.00538f, -0.288004f, -4.49582f, -1.04740f, -0.327238f, -4.49582f, 
		-1.04740f, -0.327238f, -4.49582f, -1.04740f, -0.327238f, -4.49582f, 
		-1.00621f, -0.327238f, -4.49582f, -1.00621f, -0.327238f, -4.51255f, 
		-1.00621f, -0.327238f, -4.51255f, -1.00621f, -0.327238f, -4.51255f, 
		-1.04740f, -0.327238f, -4.51255f, -1.04740f, -0.327238f, -4.51255f, 
		-1.04740f, -0.327238f, -4.51255f, -1.00538f, -0.288004f, -4.51255f, 
		-1.00538f, -0.288004f, -4.51255f, -1.00538f, -0.288004f, -4.51255f, 
		-1.00538f, -0.288004f, -4.51255f, -0.968697f, -0.326312f, -4.51994f, 
		-0.968697f, -0.326312f, -4.51994f, -0.968697f, -0.326312f, -4.51994f, 
		-0.968697f, -0.326312f, -4.51994f, -1.00628f, -0.369167f, -4.51255f, 
		-1.00628f, -0.369167f, -4.51255f, -1.00628f, -0.369167f, -4.51255f, 
		-1.00628f, -0.369167f, -4.51255f, -1.04499f, -0.293177f, -4.51255f, 
		-1.04499f, -0.293177f, -4.51255f, -1.04499f, -0.293177f, -4.51255f, 
		-1.05106f, -0.372817f, -4.51255f, -1.05106f, -0.372817f, -4.51255f, 
		-1.05106f, -0.372817f, -4.51255f, -0.969708f, -0.378892f, -4.51994f, 
		-0.969708f, -0.378892f, -4.51994f, -0.969708f, -0.378892f, -4.51994f, 
		-0.968934f, -0.291962f, -4.51994f, -0.968934f, -0.291962f, -4.51994f, 
		-0.968934f, -0.291962f, -4.51994f, -1.19491f, -0.224465f, -4.51318f, 
		-1.19491f, -0.224465f, -4.50239f, -1.10471f, -0.271912f, -4.51318f, 
		-1.10471f, -0.271912f, -4.51318f, -1.04354f, -0.282699f, -4.51318f, 
		-1.04354f, -0.282699f, -4.51318f, -1.10471f, -0.271912f, -4.50239f, 
		-1.10471f, -0.271912f, -4.50239f, -1.04354f, -0.282699f, -4.50239f, 
		-1.04354f, -0.282699f, -4.50239f, -1.02839f, -0.166258f, -4.49582f, 
		-1.02839f, -0.166258f, -4.49582f, -1.02839f, -0.166258f, -4.49582f, 
		-1.02839f, -0.166258f, -4.49582f, -1.04354f, -0.282670f, -4.49582f, 
		-1.04354f, -0.282670f, -4.49582f, -1.04354f, -0.282670f, -4.49582f, 
		-1.04354f, -0.282670f, -4.49582f, -1.19493f, -0.224465f, -4.49582f, 
		-1.19493f, -0.224465f, -4.49582f, -1.19493f, -0.224465f, -4.49582f, 
		-1.18478f, -0.157263f, -4.49582f, -1.18478f, -0.157263f, -4.49582f, 
		-1.18478f, -0.157263f, -4.49582f, -1.10485f, -0.272019f, -4.49582f, 
		-1.10485f, -0.272019f, -4.49582f, -1.10485f, -0.272019f, -4.49582f, 
		-1.10485f, -0.272019f, -4.49582f, -1.03974f, -0.205126f, -4.48976f, 
		-1.03974f, -0.205126f, -4.48976f, -1.03974f, -0.205126f, -4.48976f, 
		-1.03974f, -0.205126f, -4.48976f, -1.09897f, -0.171521f, -4.49582f, 
		-1.09897f, -0.171521f, -4.49582f, -1.09897f, -0.171521f, -4.49582f, 
		-1.09897f, -0.171521f, -4.49582f, -1.19493f, -0.188239f, -4.49582f, 
		-1.19493f, -0.188239f, -4.49582f, -1.19493f, -0.188239f, -4.49582f, 
		-1.19493f, -0.188239f, -4.49582f, -1.09889f, -0.199966f, -4.49878f, 
		-1.09889f, -0.199966f, -4.49878f, -1.09889f, -0.199966f, -4.49878f, 
		-1.09889f, -0.199966f, -4.49878f, -1.09889f, -0.199966f, -4.51255f, 
		-1.09889f, -0.199966f, -4.51255f, -1.09889f, -0.199966f, -4.51255f, 
		-1.09889f, -0.199966f, -4.51255f, -1.19493f, -0.188239f, -4.52930f, 
		-1.19493f, -0.188239f, -4.52930f, -1.19493f, -0.188239f, -4.52930f, 
		-1.19493f, -0.188239f, -4.52930f, -1.09897f, -0.171521f, -4.52420f, 
		-1.09897f, -0.171521f, -4.52420f, -1.09897f, -0.171521f, -4.52420f, 
		-1.09897f, -0.171521f, -4.52420f, -1.03974f, -0.205126f, -4.51255f, 
		-1.03974f, -0.205126f, -4.51255f, -1.03974f, -0.205126f, -4.51255f, 
		-1.03974f, -0.205126f, -4.51255f, -1.10485f, -0.272019f, -4.51255f, 
		-1.10485f, -0.272019f, -4.51255f, -1.10485f, -0.272019f, -4.51255f, 
		-1.10485f, -0.272019f, -4.51255f, -1.18478f, -0.157263f, -4.52930f, 
		-1.18478f, -0.157263f, -4.52930f, -1.18478f, -0.157263f, -4.52930f, 
		-1.19493f, -0.224465f, -4.52930f, -1.19493f, -0.224465f, -4.52930f, 
		-1.19493f, -0.224465f, -4.52930f, -1.04354f, -0.282670f, -4.51255f, 
		-1.04354f, -0.282670f, -4.51255f, -1.04354f, -0.282670f, -4.51255f, 
		-1.04354f, -0.282670f, -4.51255f, -1.02839f, -0.166258f, -4.52420f, 
		-1.02839f, -0.166258f, -4.52420f, -1.02839f, -0.166258f, -4.52420f, 
		-1.02839f, -0.166258f, -4.52420f, -0.965087f, -0.166798f, -4.52420f, 
		-0.965087f, -0.166798f, -4.52420f, -0.965087f, -0.166798f, -4.52420f, 
		-0.967752f, -0.284288f, -4.52420f, -0.967752f, -0.284288f, -4.52420f, 
		-0.967752f, -0.284288f, -4.52420f, -0.967589f, -0.205126f, -4.52420f, 
		-0.967589f, -0.205126f, -4.52420f, -0.967589f, -0.205126f, -4.52420f, 
		-0.967589f, -0.205126f, -4.52420f, -0.967589f, -0.205126f, -4.49582f, 
		-0.967589f, -0.205126f, -4.49582f, -0.967589f, -0.205126f, -4.49582f, 
		-0.967589f, -0.205126f, -4.49582f, -0.967752f, -0.284288f, -4.49582f, 
		-0.967752f, -0.284288f, -4.49582f, -0.967752f, -0.284288f, -4.49582f, 
		-0.965087f, -0.166798f, -4.49582f, -0.965087f, -0.166798f, -4.49582f, 
		-0.965087f, -0.166798f, -4.49582f, -0.967749f, -0.284317f, -4.50239f, 
		-0.967748f, -0.284317f, -4.52483f, -0.113011f, -0.401053f, -4.49586f, 
		-0.113011f, -0.401053f, -4.49586f, -0.113011f, -0.401053f, -4.49586f, 
		-0.109491f, -0.441899f, -4.49586f, -0.109491f, -0.441899f, -4.49586f, 
		-0.109491f, -0.441899f, -4.49586f, -0.174728f, -0.464784f, -4.49586f, 
		-0.174728f, -0.464784f, -4.49586f, -0.174728f, -0.464784f, -4.49586f, 
		-0.167836f, -0.378138f, -4.49586f, -0.167836f, -0.378138f, -4.49586f, 
		-0.167836f, -0.378138f, -4.49586f, -0.136498f, -0.464814f, -4.49586f, 
		-0.136498f, -0.464814f, -4.49586f, -0.136498f, -0.464814f, -4.49586f, 
		-0.104094f, -0.421355f, -4.49586f, -0.104094f, -0.421355f, -4.49586f, 
		-0.104094f, -0.421355f, -4.49586f, -0.123009f, -0.379232f, -4.49586f, 
		-0.123009f, -0.379232f, -4.49586f, -0.123009f, -0.379232f, -4.49586f, 
		-0.159573f, -0.413380f, -4.49586f, -0.159573f, -0.413380f, -4.49586f, 
		-0.159573f, -0.413380f, -4.49586f, -0.130250f, -0.421355f, -4.49586f, 
		-0.149314f, -0.464814f, -4.49586f, -0.149314f, -0.464814f, -4.49586f, 
		-0.149314f, -0.464814f, -4.49586f, -0.143301f, -0.378433f, -4.49586f, 
		-0.143301f, -0.378433f, -4.49586f, -0.143301f, -0.378433f, -4.49586f, 
		-0.143066f, -0.421355f, -4.49586f, -0.143066f, -0.421355f, -4.53761f, 
		-0.143301f, -0.378433f, -4.53761f, -0.143301f, -0.378433f, -4.53761f, 
		-0.143301f, -0.378433f, -4.53761f, -0.149314f, -0.464814f, -4.53761f, 
		-0.149314f, -0.464814f, -4.53761f, -0.149314f, -0.464814f, -4.53761f, 
		-0.130250f, -0.421355f, -4.53761f, -0.159573f, -0.413380f, -4.53761f, 
		-0.159573f, -0.413380f, -4.53761f, -0.159573f, -0.413380f, -4.53761f, 
		-0.123009f, -0.379232f, -4.53761f, -0.123009f, -0.379232f, -4.53761f, 
		-0.123009f, -0.379232f, -4.53761f, -0.104094f, -0.421355f, -4.53761f, 
		-0.104094f, -0.421355f, -4.53761f, -0.104094f, -0.421355f, -4.53761f, 
		-0.136498f, -0.464814f, -4.53761f, -0.136498f, -0.464814f, -4.53761f, 
		-0.136498f, -0.464814f, -4.53761f, -0.167836f, -0.378138f, -4.53761f, 
		-0.167836f, -0.378138f, -4.53761f, -0.167836f, -0.378138f, -4.53761f, 
		-0.174728f, -0.464784f, -4.53761f, -0.174728f, -0.464784f, -4.53761f, 
		-0.174728f, -0.464784f, -4.53761f, -0.109491f, -0.441899f, -4.53761f, 
		-0.109491f, -0.441899f, -4.53761f, -0.109491f, -0.441899f, -4.53761f, 
		-0.113011f, -0.401053f, -4.53761f, -0.113011f, -0.401053f, -4.53761f, 
		-0.113011f, -0.401053f, -4.53761f, -1.07437f, -0.0503850f, -4.53761f, 
		-1.07437f, -0.0503850f, -4.53761f, -1.07437f, -0.0503850f, -4.53761f, 
		-1.07067f, -0.157949f, -4.53761f, -1.07067f, -0.157949f, -4.53761f, 
		-1.07067f, -0.157949f, -4.53761f, -1.18772f, -0.147867f, -4.53761f, 
		-1.18772f, -0.147867f, -4.53761f, -1.18772f, -0.147867f, -4.53761f, 
		-1.18564f, -0.0549580f, -4.53761f, -1.18564f, -0.0549580f, -4.53761f, 
		-1.18564f, -0.0549580f, -4.53761f, -1.13402f, -0.156489f, -4.53761f, 
		-1.13402f, -0.156489f, -4.53761f, -1.13402f, -0.156489f, -4.53761f, 
		-1.07212f, -0.0922440f, -4.53761f, -1.07212f, -0.0922440f, -4.53761f, 
		-1.07212f, -0.0922440f, -4.53761f, -1.13871f, -0.0371700f, -4.53761f, 
		-1.13871f, -0.0371700f, -4.53761f, -1.13871f, -0.0371700f, -4.53761f, 
		-1.19184f, -0.0922440f, -4.53761f, -1.19184f, -0.0922440f, -4.53761f, 
		-1.19184f, -0.0922440f, -4.53761f, -1.13871f, -0.0922440f, -4.53761f, 
		-1.16214f, -0.153253f, -4.53761f, -1.16214f, -0.153253f, -4.53761f, 
		-1.16214f, -0.153253f, -4.53761f, -1.16522f, -0.0450760f, -4.53761f, 
		-1.16522f, -0.0450760f, -4.53761f, -1.16522f, -0.0450760f, -4.53761f, 
		-1.16474f, -0.0922440f, -4.53761f, -1.16474f, -0.0922440f, -4.49994f, 
		-1.16474f, -0.0922440f, -4.49994f, -1.16474f, -0.0922440f, -4.49994f, 
		-1.16474f, -0.0922440f, -4.49994f, -1.16522f, -0.0450760f, -4.49586f, 
		-1.16522f, -0.0450760f, -4.49586f, -1.16522f, -0.0450760f, -4.49586f, 
		-1.16522f, -0.0450760f, -4.49586f, -1.16214f, -0.153253f, -4.49586f, 
		-1.16214f, -0.153253f, -4.49586f, -1.16214f, -0.153253f, -4.49586f, 
		-1.16214f, -0.153253f, -4.49586f, -1.13871f, -0.0922440f, -4.49128f, 
		-1.13871f, -0.0922440f, -4.49128f, -1.13871f, -0.0922440f, -4.49128f, 
		-1.13871f, -0.0922440f, -4.49128f, -1.19184f, -0.0922440f, -4.49586f, 
		-1.19184f, -0.0922440f, -4.49586f, -1.19184f, -0.0922440f, -4.49586f, 
		-1.19184f, -0.0922440f, -4.49586f, -1.13871f, -0.0371700f, -4.49586f, 
		-1.13871f, -0.0371700f, -4.49586f, -1.13871f, -0.0371700f, -4.49586f, 
		-1.13871f, -0.0371700f, -4.49586f, -1.07212f, -0.0922440f, -4.49920f, 
		-1.07212f, -0.0922440f, -4.49920f, -1.07212f, -0.0922440f, -4.49920f, 
		-1.07212f, -0.0922440f, -4.49920f, -1.07212f, -0.0922440f, -4.49920f, 
		-1.13402f, -0.156489f, -4.49586f, -1.13402f, -0.156489f, -4.49586f, 
		-1.13402f, -0.156489f, -4.49586f, -1.13402f, -0.156489f, -4.49586f, 
		-1.18564f, -0.0549580f, -4.49586f, -1.18564f, -0.0549580f, -4.49586f, 
		-1.18564f, -0.0549580f, -4.49586f, -1.18772f, -0.147867f, -4.49586f, 
		-1.18772f, -0.147867f, -4.49586f, -1.18772f, -0.147867f, -4.49586f, 
		-1.07067f, -0.157949f, -4.49586f, -1.07067f, -0.157949f, -4.49586f, 
		-1.07067f, -0.157949f, -4.49586f, -1.07067f, -0.157949f, -4.49586f, 
		-1.07437f, -0.0503850f, -4.49586f, -1.07437f, -0.0503850f, -4.49586f, 
		-1.07437f, -0.0503850f, -4.49586f, -0.965089f, -0.157949f, -4.49586f, 
		-0.965089f, -0.157949f, -4.49586f, -0.965089f, -0.157949f, -4.49586f, 
		-0.966540f, -0.0922440f, -4.49586f, -0.966540f, -0.0922440f, -4.49586f, 
		-0.966540f, -0.0922440f, -4.49586f, -0.966540f, -0.0922440f, -4.53761f, 
		-0.966540f, -0.0922440f, -4.53761f, -0.966540f, -0.0922440f, -4.53761f, 
		-0.965089f, -0.157949f, -4.53761f, -0.965089f, -0.157949f, -4.53761f, 
		-0.965089f, -0.157949f, -4.53761f, -0.966266f, 0.0902550f, -4.53761f, 
		-0.966266f, 0.0902550f, -4.53761f, -0.966266f, 0.0902550f, -4.53761f, 
		-0.968066f, -0.0821020f, -4.53761f, -0.968066f, -0.0821020f, -4.53761f, 
		-0.968066f, -0.0821020f, -4.53761f, -1.06966f, -0.0409680f, -4.53761f, 
		-1.06966f, -0.0409680f, -4.53761f, -1.06966f, -0.0409680f, -4.53761f, 
		-1.08113f, 0.0894040f, -4.53761f, -1.08113f, 0.0894040f, -4.53761f, 
		-1.08113f, 0.0894040f, -4.53761f, -1.00451f, -0.0760230f, -4.53761f, 
		-1.00451f, -0.0760230f, -4.53761f, -1.00451f, -0.0760230f, -4.53761f, 
		-0.964909f, 0.0130360f, -4.53761f, -0.964909f, 0.0130360f, -4.53761f, 
		-0.964909f, 0.0130360f, -4.53761f, -1.01565f, 0.0842390f, -4.53761f, 
		-1.01565f, 0.0842390f, -4.53761f, -1.01565f, 0.0842390f, -4.53761f, 
		-1.08314f, -0.0285280f, -4.53761f, -1.08314f, -0.0285280f, -4.53761f, 
		-1.08314f, -0.0285280f, -4.53761f, -1.01804f, 0.0130360f, -4.53761f, 
		-1.06229f, -0.0846540f, -4.53761f, -1.06229f, -0.0846540f, -4.53761f, 
		-1.06229f, -0.0846540f, -4.53761f, -1.04096f, 0.0912220f, -4.53761f, 
		-1.04096f, 0.0912220f, -4.53761f, -1.04096f, 0.0912220f, -4.53761f, 
		-1.04407f, 0.0130360f, -4.53761f, -1.04407f, 0.0130360f, -4.49586f, 
		-1.04407f, 0.0130360f, -4.49586f, -1.04407f, 0.0130360f, -4.49586f, 
		-1.04096f, 0.0912220f, -4.49586f, -1.04096f, 0.0912220f, -4.49586f, 
		-1.04096f, 0.0912220f, -4.49586f, -1.04096f, 0.0912220f, -4.49586f, 
		-1.06229f, -0.0846540f, -4.49586f, -1.06229f, -0.0846540f, -4.49586f, 
		-1.06229f, -0.0846540f, -4.49586f, -1.06229f, -0.0846540f, -4.49586f, 
		-1.01804f, 0.0130360f, -4.48968f, -1.01804f, 0.0130360f, -4.48968f, 
		-1.01804f, 0.0130360f, -4.48968f, -1.01804f, 0.0130360f, -4.48968f, 
		-1.08314f, -0.0285280f, -4.49586f, -1.08314f, -0.0285280f, -4.49586f, 
		-1.08314f, -0.0285280f, -4.49586f, -1.01565f, 0.0842390f, -4.49586f, 
		-1.01565f, 0.0842390f, -4.49586f, -1.01565f, 0.0842390f, -4.49586f, 
		-1.01565f, 0.0842390f, -4.49586f, -0.964909f, 0.0130360f, -4.49586f, 
		-0.964909f, 0.0130360f, -4.49586f, -0.964909f, 0.0130360f, -4.49586f, 
		-0.964909f, 0.0130360f, -4.49586f, -1.00451f, -0.0760230f, -4.49586f, 
		-1.00451f, -0.0760230f, -4.49586f, -1.00451f, -0.0760230f, -4.49586f, 
		-1.00451f, -0.0760230f, -4.49586f, -1.08113f, 0.0894040f, -4.49586f, 
		-1.08113f, 0.0894040f, -4.49586f, -1.08113f, 0.0894040f, -4.49586f, 
		-1.06966f, -0.0409680f, -4.49586f, -1.06966f, -0.0409680f, -4.49586f, 
		-1.06966f, -0.0409680f, -4.49586f, -0.968066f, -0.0821020f, -4.49586f, 
		-0.968066f, -0.0821020f, -4.49586f, -0.968066f, -0.0821020f, -4.49586f, 
		-0.966266f, 0.0902550f, -4.49586f, -0.966266f, 0.0902550f, -4.49586f, 
		-0.966266f, 0.0902550f, -4.49586f, -1.09029f, 0.0912140f, -4.53761f, 
		-1.09029f, 0.0912140f, -4.53761f, -1.09029f, 0.0912140f, -4.53761f, 
		-1.09143f, -0.0361390f, -4.53761f, -1.09143f, -0.0361390f, -4.53761f, 
		-1.09143f, -0.0361390f, -4.53761f, -1.18738f, -0.0425870f, -4.53761f, 
		-1.18738f, -0.0425870f, -4.53761f, -1.18738f, -0.0425870f, -4.53761f, 
		-1.18718f, 0.0947660f, -4.53761f, -1.18718f, 0.0947660f, -4.53761f, 
		-1.18718f, 0.0947660f, -4.53761f, -1.14387f, -0.0285530f, -4.53761f, 
		-1.14387f, -0.0285530f, -4.53761f, -1.14387f, -0.0285530f, -4.53761f, 
		-1.09073f, 0.0265210f, -4.53761f, -1.09073f, 0.0265210f, -4.53761f, 
		-1.09073f, 0.0265210f, -4.53761f, -1.14115f, 0.0923840f, -4.53761f, 
		-1.14115f, 0.0923840f, -4.53761f, -1.14115f, 0.0923840f, -4.53761f, 
		-1.18659f, 0.0269900f, -4.53761f, -1.18659f, 0.0269900f, -4.53761f, 
		-1.18659f, 0.0269900f, -4.53761f, -1.14387f, 0.0265210f, -4.53761f, 
		-1.16648f, -0.0335190f, -4.53761f, -1.16648f, -0.0335190f, -4.53761f, 
		-1.16648f, -0.0335190f, -4.53761f, -1.17038f, 0.0901070f, -4.53761f, 
		-1.17038f, 0.0901070f, -4.53761f, -1.17038f, 0.0901070f, -4.53761f, 
		-1.16990f, 0.0265210f, -4.53761f, -1.16990f, 0.0265210f, -4.49586f, 
		-1.16990f, 0.0265210f, -4.49586f, -1.16990f, 0.0265210f, -4.49586f, 
		-1.17038f, 0.0901070f, -4.49586f, -1.17038f, 0.0901070f, -4.49586f, 
		-1.17038f, 0.0901070f, -4.49586f, -1.17038f, 0.0901070f, -4.49586f, 
		-1.16648f, -0.0335190f, -4.49586f, -1.16648f, -0.0335190f, -4.49586f, 
		-1.16648f, -0.0335190f, -4.49586f, -1.16648f, -0.0335190f, -4.49586f, 
		-1.14387f, 0.0265210f, -4.50216f, -1.14387f, 0.0265210f, -4.50216f, 
		-1.14387f, 0.0265210f, -4.50216f, -1.14387f, 0.0265210f, -4.50216f, 
		-1.18659f, 0.0269900f, -4.49586f, -1.18659f, 0.0269900f, -4.49586f, 
		-1.18659f, 0.0269900f, -4.49586f, -1.14115f, 0.0923840f, -4.49586f, 
		-1.14115f, 0.0923840f, -4.49586f, -1.14115f, 0.0923840f, -4.49586f, 
		-1.14115f, 0.0923840f, -4.49586f, -1.09073f, 0.0265210f, -4.49116f, 
		-1.09073f, 0.0265210f, -4.49116f, -1.09073f, 0.0265210f, -4.49116f, 
		-1.09073f, 0.0265210f, -4.49116f, -1.14387f, -0.0285530f, -4.49586f, 
		-1.14387f, -0.0285530f, -4.49586f, -1.14387f, -0.0285530f, -4.49586f, 
		-1.14387f, -0.0285530f, -4.49586f, -1.18718f, 0.0947660f, -4.49586f, 
		-1.18718f, 0.0947660f, -4.49586f, -1.18718f, 0.0947660f, -4.49586f, 
		-1.18738f, -0.0425870f, -4.49586f, -1.18738f, -0.0425870f, -4.49586f, 
		-1.18738f, -0.0425870f, -4.49586f, -1.09143f, -0.0361390f, -4.49586f, 
		-1.09143f, -0.0361390f, -4.49586f, -1.09143f, -0.0361390f, -4.49586f, 
		-1.09029f, 0.0912140f, -4.49586f, -1.09029f, 0.0912140f, -4.49586f, 
		-1.09029f, 0.0912140f, -4.49586f, -1.09875f, 0.212773f, -4.53761f, 
		-1.09875f, 0.212773f, -4.53761f, -1.09875f, 0.212773f, -4.53761f, 
		-1.09042f, 0.100840f, -4.53761f, -1.09042f, 0.100840f, -4.53761f, 
		-1.09042f, 0.100840f, -4.53761f, -1.18700f, 0.103029f, -4.53761f, 
		-1.18700f, 0.103029f, -4.53761f, -1.18700f, 0.103029f, -4.53761f, 
		-1.18070f, 0.208820f, -4.53761f, -1.18070f, 0.208820f, -4.53761f, 
		-1.18070f, 0.208820f, -4.53761f, -1.13613f, 0.100959f, -4.53761f, 
		-1.13613f, 0.100959f, -4.53761f, -1.13613f, 0.100959f, -4.53761f, 
		-1.08063f, 0.171534f, -4.53761f, -1.08063f, 0.171534f, -4.53761f, 
		-1.08063f, 0.171534f, -4.53761f, -1.13064f, 0.210425f, -4.53761f, 
		-1.13064f, 0.210425f, -4.53761f, -1.13064f, 0.210425f, -4.53761f, 
		-1.18690f, 0.171534f, -4.53761f, -1.18690f, 0.171534f, -4.53761f, 
		-1.18690f, 0.171534f, -4.53761f, -1.13376f, 0.171534f, -4.53761f, 
		-1.16373f, 0.0989200f, -4.53761f, -1.16373f, 0.0989200f, -4.53761f, 
		-1.16373f, 0.0989200f, -4.53761f, -1.15819f, 0.203598f, -4.53761f, 
		-1.15819f, 0.203598f, -4.53761f, -1.15819f, 0.203598f, -4.53761f, 
		-1.15980f, 0.171534f, -4.53761f, -1.15980f, 0.171534f, -4.49586f, 
		-1.15980f, 0.171534f, -4.49586f, -1.15980f, 0.171534f, -4.49586f, 
		-1.15819f, 0.203598f, -4.49586f, -1.15819f, 0.203598f, -4.49586f, 
		-1.15819f, 0.203598f, -4.49586f, -1.15819f, 0.203598f, -4.49586f, 
		-1.16373f, 0.0989200f, -4.49586f, -1.16373f, 0.0989200f, -4.49586f, 
		-1.16373f, 0.0989200f, -4.49586f, -1.16373f, 0.0989200f, -4.49586f, 
		-1.13376f, 0.171534f, -4.48868f, -1.13376f, 0.171534f, -4.48868f, 
		-1.13376f, 0.171534f, -4.48868f, -1.13376f, 0.171534f, -4.48868f, 
		-1.18690f, 0.171534f, -4.49586f, -1.18690f, 0.171534f, -4.49586f, 
		-1.18690f, 0.171534f, -4.49586f, -1.13064f, 0.210425f, -4.49586f, 
		-1.13064f, 0.210425f, -4.49586f, -1.13064f, 0.210425f, -4.49586f, 
		-1.13064f, 0.210425f, -4.49586f, -1.08063f, 0.171534f, -4.49586f, 
		-1.08063f, 0.171534f, -4.49586f, -1.08063f, 0.171534f, -4.49586f, 
		-1.08063f, 0.171534f, -4.49586f, -1.13613f, 0.100959f, -4.49586f, 
		-1.13613f, 0.100959f, -4.49586f, -1.13613f, 0.100959f, -4.49586f, 
		-1.13613f, 0.100959f, -4.49586f, -1.18070f, 0.208820f, -4.49586f, 
		-1.18070f, 0.208820f, -4.49586f, -1.18070f, 0.208820f, -4.49586f, 
		-1.18700f, 0.103029f, -4.49586f, -1.18700f, 0.103029f, -4.49586f, 
		-1.18700f, 0.103029f, -4.49586f, -1.09042f, 0.100840f, -4.49586f, 
		-1.09042f, 0.100840f, -4.49586f, -1.09042f, 0.100840f, -4.49586f, 
		-1.09875f, 0.212773f, -4.49586f, -1.09875f, 0.212773f, -4.49586f, 
		-1.09875f, 0.212773f, -4.49586f, -1.08538f, 0.322207f, -4.53761f, 
		-1.08538f, 0.322207f, -4.53761f, -1.08538f, 0.322207f, -4.53761f, 
		-1.08547f, 0.221410f, -4.53761f, -1.08547f, 0.221410f, -4.53761f, 
		-1.08547f, 0.221410f, -4.53761f, -1.18407f, 0.227902f, -4.53761f, 
		-1.18407f, 0.227902f, -4.53761f, -1.18407f, 0.227902f, -4.53761f, 
		-1.18407f, 0.323903f, -4.53761f, -1.18407f, 0.323903f, -4.53761f, 
		-1.18407f, 0.323903f, -4.53761f, -1.13714f, 0.216043f, -4.53761f, 
		-1.13714f, 0.216043f, -4.53761f, -1.13714f, 0.216043f, -4.53761f, 
		-1.08401f, 0.271117f, -4.53761f, -1.13714f, 0.326191f, -4.53761f, 
		-1.13714f, 0.326191f, -4.53761f, -1.13714f, 0.326191f, -4.53761f, 
		-1.19027f, 0.271117f, -4.53761f, -1.19027f, 0.271117f, -4.53761f, 
		-1.19027f, 0.271117f, -4.53761f, -1.13714f, 0.271117f, -4.53761f, 
		-1.16317f, 0.216043f, -4.53761f, -1.16317f, 0.216043f, -4.53761f, 
		-1.16317f, 0.216043f, -4.53761f, -1.16365f, 0.323996f, -4.53761f, 
		-1.16365f, 0.323996f, -4.53761f, -1.16365f, 0.323996f, -4.53761f, 
		-1.16317f, 0.271117f, -4.53761f, -1.16317f, 0.271117f, -4.49586f, 
		-1.16365f, 0.323996f, -4.49586f, -1.16365f, 0.323996f, -4.49586f, 
		-1.16365f, 0.323996f, -4.49586f, -1.16317f, 0.216043f, -4.49586f, 
		-1.16317f, 0.216043f, -4.49586f, -1.16317f, 0.216043f, -4.49586f, 
		-1.13714f, 0.271117f, -4.49586f, -1.13714f, 0.271117f, -4.49586f, 
		-1.13714f, 0.271117f, -4.49586f, -1.19027f, 0.271117f, -4.49586f, 
		-1.19027f, 0.271117f, -4.49586f, -1.19027f, 0.271117f, -4.49586f, 
		-1.13714f, 0.326191f, -4.49586f, -1.13714f, 0.326191f, -4.49586f, 
		-1.13714f, 0.326191f, -4.49586f, -1.13714f, 0.326191f, -4.49586f, 
		-1.08401f, 0.271117f, -4.48992f, -1.08401f, 0.271117f, -4.48992f, 
		-1.08401f, 0.271117f, -4.48992f, -1.08401f, 0.271117f, -4.48992f, 
		-1.08401f, 0.271117f, -4.48992f, -1.13714f, 0.216043f, -4.49586f, 
		-1.13714f, 0.216043f, -4.49586f, -1.13714f, 0.216043f, -4.49586f, 
		-1.13714f, 0.216043f, -4.49586f, -1.18407f, 0.323903f, -4.49586f, 
		-1.18407f, 0.323903f, -4.49586f, -1.18407f, 0.323903f, -4.49586f, 
		-1.18407f, 0.227902f, -4.49586f, -1.18407f, 0.227902f, -4.49586f, 
		-1.18407f, 0.227902f, -4.49586f, -1.08547f, 0.221410f, -4.49586f, 
		-1.08547f, 0.221410f, -4.49586f, -1.08547f, 0.221410f, -4.49586f, 
		-1.08547f, 0.221410f, -4.49586f, -1.08538f, 0.322207f, -4.49586f, 
		-1.08538f, 0.322207f, -4.49586f, -1.08538f, 0.322207f, -4.49586f, 
		-1.08538f, 0.322207f, -4.49586f, -0.973378f, 0.322207f, -4.49586f, 
		-0.973378f, 0.322207f, -4.49586f, -0.973378f, 0.322207f, -4.49586f, 
		-0.967223f, 0.0979860f, -4.49586f, -0.967223f, 0.0979860f, -4.49586f, 
		-0.967223f, 0.0979860f, -4.49586f, -0.972007f, 0.271117f, -4.49586f, 
		-0.972007f, 0.271117f, -4.49586f, -0.972007f, 0.271117f, -4.49586f, 
		-0.972007f, 0.271117f, -4.49586f, -0.972007f, 0.271117f, -4.53761f, 
		-0.972007f, 0.271117f, -4.53761f, -0.972007f, 0.271117f, -4.53761f, 
		-0.967223f, 0.0979860f, -4.53761f, -0.967223f, 0.0979860f, -4.53761f, 
		-0.967223f, 0.0979860f, -4.53761f, -0.973378f, 0.322207f, -4.53761f, 
		-0.973378f, 0.322207f, -4.53761f, -0.973378f, 0.322207f, -4.53761f, 
		-1.04667f, 0.271117f, -4.49586f, -1.04667f, 0.271117f, -4.49586f, 
		-1.04667f, 0.271117f, -4.49586f, -1.04667f, 0.271117f, -4.49586f, 
		-1.04667f, 0.271117f, -4.49586f, -1.00934f, 0.271117f, -4.49104f, 
		-1.00934f, 0.271117f, -4.49104f, -1.00934f, 0.271117f, -4.49104f, 
		-1.00934f, 0.271117f, -4.49104f, -1.04804f, 0.322207f, -4.49586f, 
		-1.04804f, 0.322207f, -4.49586f, -1.04804f, 0.322207f, -4.49586f, 
		-1.01071f, 0.322207f, -4.49586f, -1.01071f, 0.322207f, -4.49586f, 
		-1.01071f, 0.322207f, -4.49586f, -1.08156f, 0.0984460f, -4.49586f, 
		-1.08156f, 0.0984460f, -4.49586f, -1.08156f, 0.0984460f, -4.49586f, 
		-1.08156f, 0.0984460f, -4.49586f, -1.01184f, 0.0936700f, -4.49586f, 
		-1.01184f, 0.0936700f, -4.49586f, -1.01184f, 0.0936700f, -4.49586f, 
		-1.01184f, 0.0936700f, -4.49586f, -1.04804f, 0.322207f, -4.53761f, 
		-1.04804f, 0.322207f, -4.53761f, -1.01071f, 0.322207f, -4.53761f, 
		-1.01071f, 0.322207f, -4.53761f, -1.08156f, 0.0984460f, -4.53761f, 
		-1.08156f, 0.0984460f, -4.53761f, -1.08156f, 0.0984460f, -4.53761f, 
		-1.01184f, 0.0936700f, -4.53761f, -1.01184f, 0.0936700f, -4.53761f, 
		-1.01184f, 0.0936700f, -4.53761f, -1.04667f, 0.271117f, -4.53761f, 
		-1.00934f, 0.271117f, -4.53761f, -1.08547f, 0.221410f, -4.51674f, 
		-1.08547f, 0.221410f, -4.51674f, -1.07336f, 0.171795f, -4.49586f, 
		-1.07336f, 0.171795f, -4.49586f, -1.07336f, 0.171795f, -4.49586f, 
		-1.07336f, 0.171795f, -4.49586f, -1.07336f, 0.171795f, -4.49586f, 
		-1.07336f, 0.171795f, -4.53761f, -1.07336f, 0.171795f, -4.53761f, 
		-1.07336f, 0.171795f, -4.53761f, -1.08156f, 0.0984460f, -4.51674f, 
		-1.08156f, 0.0984460f, -4.51674f, -1.07336f, 0.171795f, -4.51674f, 
		-1.07336f, 0.171795f, -4.51674f, -0.866398f, 0.190613f, -4.53761f, 
		-0.866398f, 0.190613f, -4.53761f, -0.866398f, 0.190613f, -4.53761f, 
		-0.859768f, 0.0930760f, -4.53761f, -0.859768f, 0.0930760f, -4.53761f, 
		-0.859768f, 0.0930760f, -4.53761f, -0.960846f, 0.0950550f, -4.53761f, 
		-0.960846f, 0.0950550f, -4.53761f, -0.960846f, 0.0950550f, -4.53761f, 
		-0.962556f, 0.198682f, -4.53761f, -0.962556f, 0.198682f, -4.53761f, 
		-0.962556f, 0.198682f, -4.53761f, -0.901415f, 0.0942990f, -4.53761f, 
		-0.901415f, 0.0942990f, -4.53761f, -0.901415f, 0.0942990f, -4.53761f, 
		-0.864416f, 0.148295f, -4.53761f, -0.864416f, 0.148295f, -4.53761f, 
		-0.864416f, 0.148295f, -4.53761f, -0.901415f, 0.204448f, -4.53761f, 
		-0.901415f, 0.204448f, -4.53761f, -0.901415f, 0.204448f, -4.53761f, 
		-0.962579f, 0.149990f, -4.53761f, -0.962579f, 0.149990f, -4.53761f, 
		-0.962579f, 0.149990f, -4.53761f, -0.901415f, 0.149374f, -4.53761f, 
		-0.927449f, 0.0942990f, -4.53761f, -0.927449f, 0.0942990f, -4.53761f, 
		-0.927449f, 0.0942990f, -4.53761f, -0.917517f, 0.211646f, -4.53761f, 
		-0.917517f, 0.211646f, -4.53761f, -0.917517f, 0.211646f, -4.53761f, 
		-0.927449f, 0.149374f, -4.53761f, -0.927449f, 0.149374f, -4.49586f, 
		-0.927449f, 0.149374f, -4.49586f, -0.927449f, 0.149374f, -4.49586f, 
		-0.917517f, 0.211646f, -4.49586f, -0.917517f, 0.211646f, -4.49586f, 
		-0.917517f, 0.211646f, -4.49586f, -0.917517f, 0.211646f, -4.49586f, 
		-0.927449f, 0.0942990f, -4.49586f, -0.927449f, 0.0942990f, -4.49586f, 
		-0.927449f, 0.0942990f, -4.49586f, -0.927449f, 0.0942990f, -4.49586f, 
		-0.901415f, 0.149374f, -4.49376f, -0.901415f, 0.149374f, -4.49376f, 
		-0.901415f, 0.149374f, -4.49376f, -0.901415f, 0.149374f, -4.49376f, 
		-0.962579f, 0.149990f, -4.49586f, -0.962579f, 0.149990f, -4.49586f, 
		-0.962579f, 0.149990f, -4.49586f, -0.901415f, 0.204448f, -4.49586f, 
		-0.901415f, 0.204448f, -4.49586f, -0.901415f, 0.204448f, -4.49586f, 
		-0.901415f, 0.204448f, -4.49586f, -0.864416f, 0.148295f, -4.49586f, 
		-0.864416f, 0.148295f, -4.49586f, -0.864416f, 0.148295f, -4.49586f, 
		-0.864416f, 0.148295f, -4.49586f, -0.901415f, 0.0942990f, -4.49586f, 
		-0.901415f, 0.0942990f, -4.49586f, -0.901415f, 0.0942990f, -4.49586f, 
		-0.901415f, 0.0942990f, -4.49586f, -0.962556f, 0.198682f, -4.49586f, 
		-0.962556f, 0.198682f, -4.49586f, -0.962556f, 0.198682f, -4.49586f, 
		-0.960846f, 0.0950550f, -4.49586f, -0.960846f, 0.0950550f, -4.49586f, 
		-0.960846f, 0.0950550f, -4.49586f, -0.859768f, 0.0930760f, -4.49586f, 
		-0.859768f, 0.0930760f, -4.49586f, -0.859768f, 0.0930760f, -4.49586f, 
		-0.866398f, 0.190613f, -4.49586f, -0.866398f, 0.190613f, -4.49586f, 
		-0.866398f, 0.190613f, -4.49586f, -0.963253f, 0.226433f, -4.49586f, 
		-0.963253f, 0.226433f, -4.49586f, -0.963253f, 0.226433f, -4.49586f, 
		-0.930351f, 0.237839f, -4.49586f, -0.930351f, 0.237839f, -4.49586f, 
		-0.930351f, 0.237839f, -4.49586f, -0.930351f, 0.237839f, -4.53761f, 
		-0.930351f, 0.237839f, -4.53761f, -0.930351f, 0.237839f, -4.53761f, 
		-0.963253f, 0.226433f, -4.53761f, -0.963253f, 0.226433f, -4.53761f, 
		-0.963253f, 0.226433f, -4.53761f, -0.861047f, 0.323557f, -4.53761f, 
		-0.861047f, 0.323557f, -4.53761f, -0.861047f, 0.323557f, -4.53761f, 
		-0.863157f, 0.198518f, -4.53761f, -0.863157f, 0.198518f, -4.53761f, 
		-0.863157f, 0.198518f, -4.53761f, -0.962844f, 0.235910f, -4.53761f, 
		-0.962844f, 0.235910f, -4.53761f, -0.962844f, 0.235910f, -4.53761f, 
		-0.961133f, 0.326343f, -4.53761f, -0.961133f, 0.326343f, -4.53761f, 
		-0.961133f, 0.326343f, -4.53761f, -0.909066f, 0.215893f, -4.53761f, 
		-0.909066f, 0.215893f, -4.53761f, -0.909066f, 0.215893f, -4.53761f, 
		-0.854909f, 0.300762f, -4.53761f, -0.854909f, 0.300762f, -4.53761f, 
		-0.854909f, 0.300762f, -4.53761f, -0.908382f, 0.324623f, -4.53761f, 
		-0.908382f, 0.324623f, -4.53761f, -0.908382f, 0.324623f, -4.53761f, 
		-0.961171f, 0.300762f, -4.53761f, -0.961171f, 0.300762f, -4.53761f, 
		-0.961171f, 0.300762f, -4.53761f, -0.908040f, 0.300762f, -4.53761f, 
		-0.927573f, 0.245687f, -4.53761f, -0.927573f, 0.245687f, -4.53761f, 
		-0.927573f, 0.245687f, -4.53761f, -0.934551f, 0.325585f, -4.53761f, 
		-0.934551f, 0.325585f, -4.53761f, -0.934551f, 0.325585f, -4.53761f, 
		-0.934074f, 0.300762f, -4.53761f, -0.934074f, 0.300762f, -4.49586f, 
		-0.934074f, 0.300762f, -4.49586f, -0.934074f, 0.300762f, -4.49586f, 
		-0.934551f, 0.325585f, -4.49586f, -0.934551f, 0.325585f, -4.49586f, 
		-0.934551f, 0.325585f, -4.49586f, -0.934551f, 0.325585f, -4.49586f, 
		-0.927573f, 0.245687f, -4.49586f, -0.927573f, 0.245687f, -4.49586f, 
		-0.927573f, 0.245687f, -4.49586f, -0.927573f, 0.245687f, -4.49586f, 
		-0.908040f, 0.300762f, -4.49202f, -0.908040f, 0.300762f, -4.49202f, 
		-0.908040f, 0.300762f, -4.49202f, -0.908040f, 0.300762f, -4.49202f, 
		-0.961171f, 0.300762f, -4.49586f, -0.961171f, 0.300762f, -4.49586f, 
		-0.961171f, 0.300762f, -4.49586f, -0.908382f, 0.324623f, -4.49586f, 
		-0.908382f, 0.324623f, -4.49586f, -0.908382f, 0.324623f, -4.49586f, 
		-0.908382f, 0.324623f, -4.49586f, -0.854909f, 0.300762f, -4.49586f, 
		-0.854909f, 0.300762f, -4.49586f, -0.854909f, 0.300762f, -4.49586f, 
		-0.854909f, 0.300762f, -4.49586f, -0.909066f, 0.215893f, -4.49586f, 
		-0.909066f, 0.215893f, -4.49586f, -0.909066f, 0.215893f, -4.49586f, 
		-0.909066f, 0.215893f, -4.49586f, -0.961133f, 0.326343f, -4.49586f, 
		-0.961133f, 0.326343f, -4.49586f, -0.961133f, 0.326343f, -4.49586f, 
		-0.962844f, 0.235910f, -4.49586f, -0.962844f, 0.235910f, -4.49586f, 
		-0.962844f, 0.235910f, -4.49586f, -0.863157f, 0.198518f, -4.49586f, 
		-0.863157f, 0.198518f, -4.49586f, -0.863157f, 0.198518f, -4.49586f, 
		-0.861047f, 0.323557f, -4.49586f, -0.861047f, 0.323557f, -4.49586f, 
		-0.861047f, 0.323557f, -4.49586f, -0.638834f, 0.182672f, -4.53761f, 
		-0.638834f, 0.182672f, -4.53761f, -0.638834f, 0.182672f, -4.53761f, 
		-0.635324f, 0.0902650f, -4.53761f, -0.635324f, 0.0902650f, -4.53761f, 
		-0.635324f, 0.0902650f, -4.53761f, -0.851416f, 0.0944960f, -4.53761f, 
		-0.851416f, 0.0944960f, -4.53761f, -0.851416f, 0.0944960f, -4.53761f, 
		-0.861687f, 0.188651f, -4.53761f, -0.861687f, 0.188651f, -4.53761f, 
		-0.861687f, 0.188651f, -4.53761f, -0.794906f, 0.0910760f, -4.53761f, 
		-0.794906f, 0.0910760f, -4.53761f, -0.794906f, 0.0910760f, -4.53761f, 
		-0.647934f, 0.140348f, -4.53761f, -0.647934f, 0.140348f, -4.53761f, 
		-0.647934f, 0.140348f, -4.53761f, -0.794906f, 0.196507f, -4.53761f, 
		-0.794906f, 0.196507f, -4.53761f, -0.794906f, 0.196507f, -4.53761f, 
		-0.857276f, 0.148527f, -4.53761f, -0.857276f, 0.148527f, -4.53761f, 
		-0.857276f, 0.148527f, -4.53761f, -0.794906f, 0.141433f, -4.53761f, 
		-0.820941f, 0.0910760f, -4.53761f, -0.820941f, 0.0910760f, -4.53761f, 
		-0.820941f, 0.0910760f, -4.53761f, -0.821759f, 0.192858f, -4.53761f, 
		-0.821759f, 0.192858f, -4.53761f, -0.821759f, 0.192858f, -4.53761f, 
		-0.820941f, 0.141433f, -4.53761f, -0.820941f, 0.141433f, -4.49264f, 
		-0.820941f, 0.141433f, -4.49264f, -0.820941f, 0.141433f, -4.49264f, 
		-0.820941f, 0.141433f, -4.49264f, -0.821759f, 0.192858f, -4.49586f, 
		-0.821759f, 0.192858f, -4.49586f, -0.821759f, 0.192858f, -4.49586f, 
		-0.821759f, 0.192858f, -4.49586f, -0.820941f, 0.0910760f, -4.49586f, 
		-0.820941f, 0.0910760f, -4.49586f, -0.820941f, 0.0910760f, -4.49586f, 
		-0.820941f, 0.0910760f, -4.49586f, -0.794906f, 0.141433f, -4.49264f, 
		-0.794906f, 0.141433f, -4.49264f, -0.794906f, 0.141433f, -4.49264f, 
		-0.794906f, 0.141433f, -4.49264f, -0.857276f, 0.148527f, -4.49586f, 
		-0.857276f, 0.148527f, -4.49586f, -0.857276f, 0.148527f, -4.49586f, 
		-0.857276f, 0.148527f, -4.49586f, -0.794906f, 0.196507f, -4.49586f, 
		-0.794906f, 0.196507f, -4.49586f, -0.794906f, 0.196507f, -4.49586f, 
		-0.794906f, 0.196507f, -4.49586f, -0.647934f, 0.140348f, -4.49586f, 
		-0.647934f, 0.140348f, -4.49586f, -0.647934f, 0.140348f, -4.49586f, 
		-0.647934f, 0.140348f, -4.49586f, -0.794906f, 0.0910760f, -4.49586f, 
		-0.794906f, 0.0910760f, -4.49586f, -0.794906f, 0.0910760f, -4.49586f, 
		-0.794906f, 0.0910760f, -4.49586f, -0.861687f, 0.188651f, -4.49586f, 
		-0.861687f, 0.188651f, -4.49586f, -0.861687f, 0.188651f, -4.49586f, 
		-0.851416f, 0.0944960f, -4.49586f, -0.851416f, 0.0944960f, -4.49586f, 
		-0.851416f, 0.0944960f, -4.49586f, -0.635324f, 0.0902650f, -4.49586f, 
		-0.635324f, 0.0902650f, -4.49586f, -0.635324f, 0.0902650f, -4.49586f, 
		-0.638834f, 0.182672f, -4.49586f, -0.638834f, 0.182672f, -4.49586f, 
		-0.638834f, 0.182672f, -4.49586f, -0.717273f, 0.318909f, -4.53761f, 
		-0.717273f, 0.318909f, -4.53761f, -0.717273f, 0.318909f, -4.53761f, 
		-0.712531f, 0.200742f, -4.53761f, -0.712531f, 0.200742f, -4.53761f, 
		-0.712531f, 0.200742f, -4.53761f, -0.855098f, 0.197122f, -4.53761f, 
		-0.855098f, 0.197122f, -4.53761f, -0.855098f, 0.197122f, -4.53761f, 
		-0.852345f, 0.323903f, -4.53761f, -0.852345f, 0.323903f, -4.53761f, 
		-0.852345f, 0.323903f, -4.53761f, -0.754100f, 0.204771f, -4.53761f, 
		-0.754100f, 0.204771f, -4.53761f, -0.754100f, 0.204771f, -4.53761f, 
		-0.715332f, 0.261707f, -4.53761f, -0.715332f, 0.261707f, -4.53761f, 
		-0.715332f, 0.261707f, -4.53761f, -0.746572f, 0.320950f, -4.53761f, 
		-0.746572f, 0.320950f, -4.53761f, -0.746572f, 0.320950f, -4.53761f, 
		-0.852398f, 0.247786f, -4.53761f, -0.852398f, 0.247786f, -4.53761f, 
		-0.852398f, 0.247786f, -4.53761f, -0.754100f, 0.259845f, -4.53761f, 
		-0.780134f, 0.204771f, -4.53761f, -0.780134f, 0.204771f, -4.53761f, 
		-0.780134f, 0.204771f, -4.53761f, -0.779926f, 0.321911f, -4.53761f, 
		-0.779926f, 0.321911f, -4.53761f, -0.779926f, 0.321911f, -4.53761f, 
		-0.780134f, 0.259845f, -4.53761f, -0.780134f, 0.259845f, -4.50080f, 
		-0.780134f, 0.259845f, -4.50080f, -0.780134f, 0.259845f, -4.50080f, 
		-0.780134f, 0.259845f, -4.50080f, -0.780134f, 0.259845f, -4.50080f, 
		-0.779926f, 0.321911f, -4.49586f, -0.779926f, 0.321911f, -4.49586f, 
		-0.779926f, 0.321911f, -4.49586f, -0.779926f, 0.321911f, -4.49586f, 
		-0.779926f, 0.321911f, -4.49586f, -0.780134f, 0.204771f, -4.49586f, 
		-0.780134f, 0.204771f, -4.49586f, -0.780134f, 0.204771f, -4.49586f, 
		-0.780134f, 0.204771f, -4.49586f, -0.754100f, 0.259845f, -4.49252f, 
		-0.754100f, 0.259845f, -4.49252f, -0.754100f, 0.259845f, -4.49252f, 
		-0.754100f, 0.259845f, -4.49252f, -0.852398f, 0.247786f, -4.49586f, 
		-0.852398f, 0.247786f, -4.49586f, -0.852398f, 0.247786f, -4.49586f, 
		-0.852398f, 0.247786f, -4.49586f, -0.746572f, 0.320950f, -4.49586f, 
		-0.746572f, 0.320950f, -4.49586f, -0.746572f, 0.320950f, -4.49586f, 
		-0.746572f, 0.320950f, -4.49586f, -0.715332f, 0.261707f, -4.49586f, 
		-0.715332f, 0.261707f, -4.49586f, -0.715332f, 0.261707f, -4.49586f, 
		-0.715332f, 0.261707f, -4.49586f, -0.754100f, 0.204771f, -4.49586f, 
		-0.754100f, 0.204771f, -4.49586f, -0.754100f, 0.204771f, -4.49586f, 
		-0.754100f, 0.204771f, -4.49586f, -0.852345f, 0.323903f, -4.49586f, 
		-0.852345f, 0.323903f, -4.49586f, -0.852345f, 0.323903f, -4.49586f, 
		-0.855098f, 0.197122f, -4.49586f, -0.855098f, 0.197122f, -4.49586f, 
		-0.855098f, 0.197122f, -4.49586f, -0.712531f, 0.200742f, -4.49586f, 
		-0.712531f, 0.200742f, -4.49586f, -0.712531f, 0.200742f, -4.49586f, 
		-0.717273f, 0.318909f, -4.49586f, -0.717273f, 0.318909f, -4.49586f, 
		-0.717273f, 0.318909f, -4.49586f, -0.848615f, 0.297287f, -4.53761f, 
		-0.848615f, 0.297287f, -4.53761f, -0.848615f, 0.297287f, -4.53761f, 
		-0.852398f, 0.247786f, -4.51674f, -0.852398f, 0.247786f, -4.51674f, 
		-0.852345f, 0.323903f, -4.51674f, -0.852345f, 0.323903f, -4.51674f, 
		-0.848615f, 0.297287f, -4.49586f, -0.848615f, 0.297287f, -4.49586f, 
		-0.848615f, 0.297287f, -4.49586f, -0.848615f, 0.297287f, -4.49586f, 
		-0.848615f, 0.297287f, -4.49586f, -0.848615f, 0.297287f, -4.51674f, 
		-0.848615f, 0.297287f, -4.51674f, -0.589323f, 0.320395f, -4.53761f, 
		-0.589323f, 0.320395f, -4.53761f, -0.589323f, 0.320395f, -4.53761f, 
		-0.572538f, 0.195331f, -4.53761f, -0.572538f, 0.195331f, -4.53761f, 
		-0.572538f, 0.195331f, -4.53761f, -0.700369f, 0.199098f, -4.53761f, 
		-0.700369f, 0.199098f, -4.53761f, -0.700369f, 0.199098f, -4.53761f, 
		-0.708966f, 0.320878f, -4.53761f, -0.708966f, 0.320878f, -4.53761f, 
		-0.708966f, 0.320878f, -4.53761f, -0.634881f, 0.190522f, -4.53761f, 
		-0.634881f, 0.190522f, -4.53761f, -0.634881f, 0.190522f, -4.53761f, 
		-0.573962f, 0.269881f, -4.53761f, -0.573962f, 0.269881f, -4.53761f, 
		-0.573962f, 0.269881f, -4.53761f, -0.633976f, 0.315681f, -4.53761f, 
		-0.633976f, 0.315681f, -4.53761f, -0.633976f, 0.315681f, -4.53761f, 
		-0.702493f, 0.262014f, -4.53761f, -0.702493f, 0.262014f, -4.53761f, 
		-0.702493f, 0.262014f, -4.53761f, -0.633976f, 0.260607f, -4.53761f, 
		-0.660010f, 0.197558f, -4.53761f, -0.660010f, 0.197558f, -4.53761f, 
		-0.660010f, 0.197558f, -4.53761f, -0.661527f, 0.319104f, -4.53761f, 
		-0.661527f, 0.319104f, -4.53761f, -0.661527f, 0.319104f, -4.53761f, 
		-0.660010f, 0.260607f, -4.53761f, -0.660010f, 0.260607f, -4.49944f, 
		-0.660010f, 0.260607f, -4.49944f, -0.660010f, 0.260607f, -4.49944f, 
		-0.660010f, 0.260607f, -4.49944f, -0.661527f, 0.319104f, -4.49586f, 
		-0.661527f, 0.319104f, -4.49586f, -0.661527f, 0.319104f, -4.49586f, 
		-0.661527f, 0.319104f, -4.49586f, -0.660010f, 0.197558f, -4.49586f, 
		-0.660010f, 0.197558f, -4.49586f, -0.660010f, 0.197558f, -4.49586f, 
		-0.660010f, 0.197558f, -4.49586f, -0.633976f, 0.260607f, -4.49586f, 
		-0.633976f, 0.260607f, -4.49586f, -0.633976f, 0.260607f, -4.49586f, 
		-0.633976f, 0.260607f, -4.49586f, -0.702493f, 0.262014f, -4.49586f, 
		-0.702493f, 0.262014f, -4.49586f, -0.702493f, 0.262014f, -4.49586f, 
		-0.702493f, 0.262014f, -4.49586f, -0.633976f, 0.315681f, -4.49586f, 
		-0.633976f, 0.315681f, -4.49586f, -0.633976f, 0.315681f, -4.49586f, 
		-0.633976f, 0.315681f, -4.49586f, -0.573962f, 0.269881f, -4.48918f, 
		-0.573962f, 0.269881f, -4.48918f, -0.573962f, 0.269881f, -4.48918f, 
		-0.573962f, 0.269881f, -4.48918f, -0.634881f, 0.190522f, -4.49586f, 
		-0.634881f, 0.190522f, -4.49586f, -0.634881f, 0.190522f, -4.49586f, 
		-0.634881f, 0.190522f, -4.49586f, -0.708966f, 0.320878f, -4.49586f, 
		-0.708966f, 0.320878f, -4.49586f, -0.708966f, 0.320878f, -4.49586f, 
		-0.700369f, 0.199098f, -4.49586f, -0.700369f, 0.199098f, -4.49586f, 
		-0.700369f, 0.199098f, -4.49586f, -0.572538f, 0.195331f, -4.49586f, 
		-0.572538f, 0.195331f, -4.49586f, -0.572538f, 0.195331f, -4.49586f, 
		-0.589323f, 0.320395f, -4.49586f, -0.589323f, 0.320395f, -4.49586f, 
		-0.589323f, 0.320395f, -4.49586f, -0.534912f, 0.173813f, -4.53761f, 
		-0.534912f, 0.173813f, -4.53761f, -0.534912f, 0.173813f, -4.53761f, 
		-0.527762f, 0.0908410f, -4.53761f, -0.527762f, 0.0908410f, -4.53761f, 
		-0.527762f, 0.0908410f, -4.53761f, -0.624104f, 0.0912350f, -4.53761f, 
		-0.624104f, 0.0912350f, -4.53761f, -0.624104f, 0.0912350f, -4.53761f, 
		-0.628176f, 0.180649f, -4.53761f, -0.628176f, 0.180649f, -4.53761f, 
		-0.628176f, 0.180649f, -4.53761f, -0.569929f, 0.0878200f, -4.53761f, 
		-0.569929f, 0.0878200f, -4.53761f, -0.569929f, 0.0878200f, -4.53761f, 
		-0.530826f, 0.137265f, -4.53761f, -0.530826f, 0.137265f, -4.53761f, 
		-0.530826f, 0.137265f, -4.53761f, -0.569929f, 0.187648f, -4.53761f, 
		-0.569929f, 0.187648f, -4.53761f, -0.569929f, 0.187648f, -4.53761f, 
		-0.635278f, 0.138203f, -4.53761f, -0.635278f, 0.138203f, -4.53761f, 
		-0.635278f, 0.138203f, -4.53761f, -0.569929f, 0.132574f, -4.53761f, 
		-0.595963f, 0.0878200f, -4.53761f, -0.595963f, 0.0878200f, -4.53761f, 
		-0.595963f, 0.0878200f, -4.53761f, -0.596440f, 0.179743f, -4.53761f, 
		-0.596440f, 0.179743f, -4.53761f, -0.596440f, 0.179743f, -4.53761f, 
		-0.595963f, 0.132574f, -4.53761f, -0.595963f, 0.132574f, -4.49846f, 
		-0.595963f, 0.132574f, -4.49846f, -0.595963f, 0.132574f, -4.49846f, 
		-0.595963f, 0.132574f, -4.49846f, -0.596440f, 0.179743f, -4.49586f, 
		-0.596440f, 0.179743f, -4.49586f, -0.596440f, 0.179743f, -4.49586f, 
		-0.596440f, 0.179743f, -4.49586f, -0.595963f, 0.0878200f, -4.49586f, 
		-0.595963f, 0.0878200f, -4.49586f, -0.595963f, 0.0878200f, -4.49586f, 
		-0.595963f, 0.0878200f, -4.49586f, -0.569929f, 0.132574f, -4.49190f, 
		-0.569929f, 0.132574f, -4.49190f, -0.569929f, 0.132574f, -4.49190f, 
		-0.569929f, 0.132574f, -4.49190f, -0.635278f, 0.138203f, -4.49586f, 
		-0.635278f, 0.138203f, -4.49586f, -0.635278f, 0.138203f, -4.49586f, 
		-0.635278f, 0.138203f, -4.49586f, -0.569929f, 0.187648f, -4.49586f, 
		-0.569929f, 0.187648f, -4.49586f, -0.569929f, 0.187648f, -4.49586f, 
		-0.569929f, 0.187648f, -4.49586f, -0.530826f, 0.137265f, -4.49586f, 
		-0.530826f, 0.137265f, -4.49586f, -0.530826f, 0.137265f, -4.49586f, 
		-0.530826f, 0.137265f, -4.49586f, -0.569929f, 0.0878200f, -4.49586f, 
		-0.569929f, 0.0878200f, -4.49586f, -0.569929f, 0.0878200f, -4.49586f, 
		-0.569929f, 0.0878200f, -4.49586f, -0.628176f, 0.180649f, -4.49586f, 
		-0.628176f, 0.180649f, -4.49586f, -0.628176f, 0.180649f, -4.49586f, 
		-0.624104f, 0.0912350f, -4.49586f, -0.624104f, 0.0912350f, -4.49586f, 
		-0.624104f, 0.0912350f, -4.49586f, -0.527762f, 0.0908410f, -4.49586f, 
		-0.527762f, 0.0908410f, -4.49586f, -0.527762f, 0.0908410f, -4.49586f, 
		-0.534912f, 0.173813f, -4.49586f, -0.534912f, 0.173813f, -4.49586f, 
		-0.534912f, 0.173813f, -4.49586f, -0.465299f, 0.317896f, -4.53761f, 
		-0.465299f, 0.317896f, -4.53761f, -0.465299f, 0.317896f, -4.53761f, 
		-0.465722f, 0.182733f, -4.53761f, -0.465722f, 0.182733f, -4.53761f, 
		-0.465722f, 0.182733f, -4.53761f, -0.563167f, 0.194385f, -4.53761f, 
		-0.563167f, 0.194385f, -4.53761f, -0.563167f, 0.194385f, -4.53761f, 
		-0.577648f, 0.320388f, -4.53761f, -0.577648f, 0.320388f, -4.53761f, 
		-0.577648f, 0.320388f, -4.53761f, -0.500319f, 0.182946f, -4.53761f, 
		-0.457022f, 0.258709f, -4.53761f, -0.457022f, 0.258709f, -4.53761f, 
		-0.457022f, 0.258709f, -4.53761f, -0.503110f, 0.319413f, -4.53761f, 
		-0.503110f, 0.319413f, -4.53761f, -0.503110f, 0.319413f, -4.53761f, 
		-0.563029f, 0.268091f, -4.53761f, -0.563029f, 0.268091f, -4.53761f, 
		-0.563029f, 0.268091f, -4.53761f, -0.505825f, 0.258709f, -4.53761f, 
		-0.529144f, 0.182527f, -4.53761f, -0.529144f, 0.182527f, -4.53761f, 
		-0.529144f, 0.182527f, -4.53761f, -0.531431f, 0.319481f, -4.53761f, 
		-0.531431f, 0.319481f, -4.53761f, -0.531431f, 0.319481f, -4.53761f, 
		-0.531859f, 0.258709f, -4.53761f, -0.531859f, 0.258709f, -4.49586f, 
		-0.531859f, 0.258709f, -4.49586f, -0.531859f, 0.258709f, -4.49586f, 
		-0.531431f, 0.319481f, -4.49586f, -0.531431f, 0.319481f, -4.49586f, 
		-0.531431f, 0.319481f, -4.49586f, -0.531431f, 0.319481f, -4.49586f, 
		-0.529144f, 0.182527f, -4.49586f, -0.529144f, 0.182527f, -4.49586f, 
		-0.529144f, 0.182527f, -4.49586f, -0.529144f, 0.182527f, -4.49586f, 
		-0.505825f, 0.258709f, -4.50142f, -0.505825f, 0.258709f, -4.50142f, 
		-0.505825f, 0.258709f, -4.50142f, -0.505825f, 0.258709f, -4.50142f, 
		-0.563029f, 0.268091f, -4.49586f, -0.563029f, 0.268091f, -4.49586f, 
		-0.563029f, 0.268091f, -4.49586f, -0.503110f, 0.319413f, -4.49586f, 
		-0.503110f, 0.319413f, -4.49586f, -0.503110f, 0.319413f, -4.49586f, 
		-0.503110f, 0.319413f, -4.49586f, -0.457022f, 0.258709f, -4.49586f, 
		-0.457022f, 0.258709f, -4.49586f, -0.457022f, 0.258709f, -4.49586f, 
		-0.457022f, 0.258709f, -4.49586f, -0.500319f, 0.182946f, -4.49586f, 
		-0.500319f, 0.182946f, -4.49586f, -0.500319f, 0.182946f, -4.49586f, 
		-0.500319f, 0.182946f, -4.49586f, -0.577648f, 0.320388f, -4.49586f, 
		-0.577648f, 0.320388f, -4.49586f, -0.577648f, 0.320388f, -4.49586f, 
		-0.563167f, 0.194385f, -4.49586f, -0.563167f, 0.194385f, -4.49586f, 
		-0.563167f, 0.194385f, -4.49586f, -0.465722f, 0.182733f, -4.49264f, 
		-0.465722f, 0.182733f, -4.49264f, -0.465722f, 0.182733f, -4.49264f, 
		-0.465722f, 0.182733f, -4.49264f, -0.465299f, 0.317896f, -4.49586f, 
		-0.465299f, 0.317896f, -4.49586f, -0.465299f, 0.317896f, -4.49586f, 
		-0.457562f, 0.0934510f, -4.49586f, -0.457562f, 0.0934510f, -4.49586f, 
		-0.457562f, 0.0934510f, -4.49586f, -0.491372f, 0.0912170f, -4.49586f, 
		-0.491372f, 0.0912170f, -4.49586f, -0.491372f, 0.0912170f, -4.49586f, 
		-0.491372f, 0.0912170f, -4.49586f, -0.520197f, 0.0907970f, -4.49586f, 
		-0.520197f, 0.0907970f, -4.49586f, -0.520197f, 0.0907970f, -4.49586f, 
		-0.520197f, 0.0907970f, -4.53761f, -0.520197f, 0.0907970f, -4.53761f, 
		-0.520197f, 0.0907970f, -4.53761f, -0.491372f, 0.0912170f, -4.53761f, 
		-0.491372f, 0.0912170f, -4.53761f, -0.491372f, 0.0912170f, -4.53761f, 
		-0.457562f, 0.0934510f, -4.53761f, -0.457562f, 0.0934510f, -4.53761f, 
		-0.457562f, 0.0934510f, -4.53761f, -0.529144f, 0.182527f, -4.51674f, 
		-0.529144f, 0.182527f, -4.51674f, -0.522408f, 0.136662f, -4.49586f, 
		-0.522408f, 0.136662f, -4.49586f, -0.522408f, 0.136662f, -4.49586f, 
		-0.522408f, 0.136662f, -4.53761f, -0.522408f, 0.136662f, -4.53761f, 
		-0.522408f, 0.136662f, -4.53761f, -0.520197f, 0.0907970f, -4.51674f, 
		-0.520197f, 0.0907970f, -4.51674f, -0.522408f, 0.136662f, -4.51674f, 
		-0.522408f, 0.136662f, -4.51674f, -0.359134f, 0.205064f, -4.53761f, 
		-0.359134f, 0.205064f, -4.53761f, -0.359134f, 0.205064f, -4.53761f, 
		-0.359679f, 0.0968310f, -4.53761f, -0.359679f, 0.0968310f, -4.53761f, 
		-0.359679f, 0.0968310f, -4.53761f, -0.450062f, 0.0926940f, -4.53761f, 
		-0.450062f, 0.0926940f, -4.53761f, -0.450062f, 0.0926940f, -4.53761f, 
		-0.455300f, 0.318710f, -4.53761f, -0.455300f, 0.318710f, -4.53761f, 
		-0.455300f, 0.318710f, -4.53761f, -0.393552f, 0.0926220f, -4.53761f, 
		-0.393552f, 0.0926220f, -4.53761f, -0.393552f, 0.0926220f, -4.53761f, 
		-0.341020f, 0.163825f, -4.53761f, -0.341020f, 0.163825f, -4.53761f, 
		-0.341020f, 0.163825f, -4.53761f, -0.394151f, 0.313248f, -4.53761f, 
		-0.394151f, 0.313248f, -4.53761f, -0.394151f, 0.313248f, -4.53761f, 
		-0.448323f, 0.260006f, -4.53761f, -0.448323f, 0.260006f, -4.53761f, 
		-0.448323f, 0.260006f, -4.53761f, -0.394151f, 0.163825f, -4.53761f, 
		-0.419587f, 0.0926220f, -4.53761f, -0.419587f, 0.0926220f, -4.53761f, 
		-0.419587f, 0.0926220f, -4.53761f, -0.417120f, 0.321658f, -4.53761f, 
		-0.417120f, 0.321658f, -4.53761f, -0.417120f, 0.321658f, -4.53761f, 
		-0.420185f, 0.163825f, -4.53761f, -0.420185f, 0.163825f, -4.49809f, 
		-0.420185f, 0.163825f, -4.49809f, -0.420185f, 0.163825f, -4.49809f, 
		-0.420185f, 0.163825f, -4.49809f, -0.420185f, 0.163825f, -4.49809f, 
		-0.417120f, 0.321658f, -4.49586f, -0.417120f, 0.321658f, -4.49586f, 
		-0.417120f, 0.321658f, -4.49586f, -0.417120f, 0.321658f, -4.49586f, 
		-0.419587f, 0.0926220f, -4.49586f, -0.419587f, 0.0926220f, -4.49586f, 
		-0.419587f, 0.0926220f, -4.49586f, -0.419587f, 0.0926220f, -4.49586f, 
		-0.419587f, 0.0926220f, -4.49586f, -0.394151f, 0.163825f, -4.50068f, 
		-0.394151f, 0.163825f, -4.50068f, -0.394151f, 0.163825f, -4.50068f, 
		-0.394151f, 0.163825f, -4.50068f, -0.448323f, 0.260006f, -4.49586f, 
		-0.448323f, 0.260006f, -4.49586f, -0.448323f, 0.260006f, -4.49586f, 
		-0.448323f, 0.260006f, -4.49586f, -0.394151f, 0.313248f, -4.49586f, 
		-0.394151f, 0.313248f, -4.49586f, -0.394151f, 0.313248f, -4.49586f, 
		-0.394151f, 0.313248f, -4.49586f, -0.341020f, 0.163825f, -4.49586f, 
		-0.341020f, 0.163825f, -4.49586f, -0.341020f, 0.163825f, -4.49586f, 
		-0.341020f, 0.163825f, -4.49586f, -0.393552f, 0.0926220f, -4.49586f, 
		-0.393552f, 0.0926220f, -4.49586f, -0.393552f, 0.0926220f, -4.49586f, 
		-0.393552f, 0.0926220f, -4.49586f, -0.455300f, 0.318710f, -4.49586f, 
		-0.455300f, 0.318710f, -4.49586f, -0.455300f, 0.318710f, -4.49586f, 
		-0.450062f, 0.0926940f, -4.49586f, -0.450062f, 0.0926940f, -4.49586f, 
		-0.450062f, 0.0926940f, -4.49586f, -0.359679f, 0.0968310f, -4.49586f, 
		-0.359679f, 0.0968310f, -4.49586f, -0.359679f, 0.0968310f, -4.49586f, 
		-0.359134f, 0.205064f, -4.49586f, -0.359134f, 0.205064f, -4.49586f, 
		-0.359134f, 0.205064f, -4.49586f, -0.455476f, 0.182863f, -4.53761f, 
		-0.455476f, 0.182863f, -4.53761f, -0.455476f, 0.182863f, -4.53761f, 
		-0.448323f, 0.260006f, -4.51674f, -0.448323f, 0.260006f, -4.51674f, 
		-0.450062f, 0.0926940f, -4.51674f, -0.450062f, 0.0926940f, -4.51674f, 
		-0.455476f, 0.182863f, -4.49586f, -0.455476f, 0.182863f, -4.49586f, 
		-0.455476f, 0.182863f, -4.49586f, -0.455476f, 0.182863f, -4.49586f, 
		-0.455476f, 0.182863f, -4.49586f, -0.455476f, 0.182863f, -4.51674f, 
		-0.455476f, 0.182863f, -4.51674f, -0.261951f, 0.320757f, -4.53761f, 
		-0.261951f, 0.320757f, -4.53761f, -0.261951f, 0.320757f, -4.53761f, 
		-0.269424f, 0.242667f, -4.53761f, -0.269424f, 0.242667f, -4.53761f, 
		-0.269424f, 0.242667f, -4.53761f, -0.357927f, 0.240565f, -4.53761f, 
		-0.357927f, 0.240565f, -4.53761f, -0.357927f, 0.240565f, -4.53761f, 
		-0.380635f, 0.321516f, -4.53761f, -0.380635f, 0.321516f, -4.53761f, 
		-0.380635f, 0.321516f, -4.53761f, -0.304410f, 0.235530f, -4.53761f, 
		-0.304410f, 0.235530f, -4.53761f, -0.304410f, 0.235530f, -4.53761f, 
		-0.254688f, 0.272533f, -4.53761f, -0.254688f, 0.272533f, -4.53761f, 
		-0.254688f, 0.272533f, -4.53761f, -0.302615f, 0.327067f, -4.53761f, 
		-0.302615f, 0.327067f, -4.53761f, -0.302615f, 0.327067f, -4.53761f, 
		-0.371879f, 0.278519f, -4.53761f, -0.371879f, 0.278519f, -4.53761f, 
		-0.371879f, 0.278519f, -4.53761f, -0.302615f, 0.271993f, -4.53761f, 
		-0.330444f, 0.235530f, -4.53761f, -0.330444f, 0.235530f, -4.53761f, 
		-0.330444f, 0.235530f, -4.53761f, -0.333061f, 0.323648f, -4.53761f, 
		-0.333061f, 0.323648f, -4.53761f, -0.333061f, 0.323648f, -4.53761f, 
		-0.328649f, 0.271993f, -4.53761f, -0.328649f, 0.271993f, -4.49586f, 
		-0.328649f, 0.271993f, -4.49586f, -0.328649f, 0.271993f, -4.49586f, 
		-0.333061f, 0.323648f, -4.49586f, -0.333061f, 0.323648f, -4.49586f, 
		-0.333061f, 0.323648f, -4.49586f, -0.333061f, 0.323648f, -4.49586f, 
		-0.330444f, 0.235530f, -4.49586f, -0.330444f, 0.235530f, -4.49586f, 
		-0.330444f, 0.235530f, -4.49586f, -0.330444f, 0.235530f, -4.49586f, 
		-0.301926f, 0.273562f, -4.49730f, -0.301926f, 0.273562f, -4.49730f, 
		-0.301926f, 0.273562f, -4.49730f, -0.301926f, 0.273562f, -4.49730f, 
		-0.371879f, 0.278519f, -4.49586f, -0.371879f, 0.278519f, -4.49586f, 
		-0.371879f, 0.278519f, -4.49586f, -0.302615f, 0.327067f, -4.49586f, 
		-0.302615f, 0.327067f, -4.49586f, -0.302615f, 0.327067f, -4.49586f, 
		-0.302615f, 0.327067f, -4.49586f, -0.254688f, 0.272533f, -4.49586f, 
		-0.254688f, 0.272533f, -4.49586f, -0.254688f, 0.272533f, -4.49586f, 
		-0.254688f, 0.272533f, -4.49586f, -0.304410f, 0.235530f, -4.49586f, 
		-0.304410f, 0.235530f, -4.49586f, -0.304410f, 0.235530f, -4.49586f, 
		-0.304410f, 0.235530f, -4.49586f, -0.380635f, 0.321516f, -4.49586f, 
		-0.380635f, 0.321516f, -4.49586f, -0.380635f, 0.321516f, -4.49586f, 
		-0.357927f, 0.240565f, -4.49586f, -0.357927f, 0.240565f, -4.49586f, 
		-0.357927f, 0.240565f, -4.49586f, -0.269424f, 0.242667f, -4.49586f, 
		-0.269424f, 0.242667f, -4.49586f, -0.269424f, 0.242667f, -4.49586f, 
		-0.261951f, 0.320757f, -4.49586f, -0.261951f, 0.320757f, -4.49586f, 
		-0.261951f, 0.320757f, -4.49586f, -0.265056f, 0.235125f, -4.53761f, 
		-0.265056f, 0.235125f, -4.53761f, -0.265056f, 0.235125f, -4.53761f, 
		-0.267228f, 0.195025f, -4.53761f, -0.267228f, 0.195025f, -4.53761f, 
		-0.267228f, 0.195025f, -4.53761f, -0.343405f, 0.183098f, -4.53761f, 
		-0.343405f, 0.183098f, -4.53761f, -0.343405f, 0.183098f, -4.53761f, 
		-0.355190f, 0.229536f, -4.53761f, -0.355190f, 0.229536f, -4.53761f, 
		-0.355190f, 0.229536f, -4.53761f, -0.316032f, 0.171183f, -4.53761f, 
		-0.316032f, 0.171183f, -4.53761f, -0.316032f, 0.171183f, -4.53761f, 
		-0.263875f, 0.215721f, -4.53761f, -0.263875f, 0.215721f, -4.53761f, 
		-0.263875f, 0.215721f, -4.53761f, -0.316550f, 0.228500f, -4.53761f, 
		-0.316550f, 0.228500f, -4.53761f, -0.316550f, 0.228500f, -4.53761f, 
		-0.316550f, 0.228500f, -4.53761f, -0.349721f, 0.206761f, -4.53761f, 
		-0.349721f, 0.206761f, -4.53761f, -0.349721f, 0.206761f, -4.53761f, 
		-0.349721f, 0.206761f, -4.53761f, -0.316550f, 0.203060f, -4.53761f, 
		-0.316550f, 0.203060f, -4.53761f, -0.333750f, 0.170915f, -4.53761f, 
		-0.333750f, 0.170915f, -4.53761f, -0.333750f, 0.170915f, -4.53761f, 
		-0.333750f, 0.170915f, -4.53761f, -0.328796f, 0.224848f, -4.53761f, 
		-0.328796f, 0.224848f, -4.53761f, -0.328796f, 0.224848f, -4.53761f, 
		-0.328796f, 0.224848f, -4.53761f, -0.328576f, 0.203060f, -4.53761f, 
		-0.328576f, 0.203060f, -4.53761f, -0.328576f, 0.203060f, -4.53761f, 
		-0.328576f, 0.203060f, -4.49586f, -0.328576f, 0.203060f, -4.49586f, 
		-0.328796f, 0.224848f, -4.49586f, -0.328796f, 0.224848f, -4.49586f, 
		-0.328796f, 0.224848f, -4.49586f, -0.333750f, 0.170915f, -4.49586f, 
		-0.333750f, 0.170915f, -4.49586f, -0.333750f, 0.170915f, -4.49586f, 
		-0.333750f, 0.170915f, -4.49586f, -0.316550f, 0.203060f, -4.49586f, 
		-0.349721f, 0.206761f, -4.49586f, -0.349721f, 0.206761f, -4.49586f, 
		-0.349721f, 0.206761f, -4.49586f, -0.349721f, 0.206761f, -4.49586f, 
		-0.316550f, 0.228500f, -4.49586f, -0.316550f, 0.228500f, -4.49586f, 
		-0.316550f, 0.228500f, -4.49586f, -0.263875f, 0.215721f, -4.49586f, 
		-0.263875f, 0.215721f, -4.49586f, -0.263875f, 0.215721f, -4.49586f, 
		-0.316032f, 0.171183f, -4.49586f, -0.316032f, 0.171183f, -4.49586f, 
		-0.316032f, 0.171183f, -4.49586f, -0.355190f, 0.229536f, -4.49586f, 
		-0.355190f, 0.229536f, -4.49586f, -0.355190f, 0.229536f, -4.49586f, 
		-0.343405f, 0.183098f, -4.49586f, -0.343405f, 0.183098f, -4.49586f, 
		-0.343405f, 0.183098f, -4.49586f, -0.267228f, 0.195025f, -4.49586f, 
		-0.267228f, 0.195025f, -4.49586f, -0.267228f, 0.195025f, -4.49586f, 
		-0.265056f, 0.235125f, -4.49586f, -0.265056f, 0.235125f, -4.49586f, 
		-0.265056f, 0.235125f, -4.49586f, -0.261791f, 0.187940f, -4.53761f, 
		-0.261791f, 0.187940f, -4.53761f, -0.261791f, 0.187940f, -4.53761f, 
		-0.261864f, 0.0928900f, -4.53761f, -0.261864f, 0.0928900f, -4.53761f, 
		-0.261864f, 0.0928900f, -4.53761f, -0.353879f, 0.0952460f, -4.53761f, 
		-0.353879f, 0.0952460f, -4.53761f, -0.353879f, 0.0952460f, -4.53761f, 
		-0.333349f, 0.163010f, -4.53761f, -0.333349f, 0.163010f, -4.53761f, 
		-0.333349f, 0.163010f, -4.53761f, -0.300710f, 0.0949400f, -4.53761f, 
		-0.300710f, 0.0949400f, -4.53761f, -0.300710f, 0.0949400f, -4.53761f, 
		-0.261837f, 0.133460f, -4.53761f, -0.261837f, 0.133460f, -4.53761f, 
		-0.261837f, 0.133460f, -4.53761f, -0.299341f, 0.169499f, -4.53761f, 
		-0.299341f, 0.169499f, -4.53761f, -0.299341f, 0.169499f, -4.53761f, 
		-0.341635f, 0.130623f, -4.53761f, -0.341635f, 0.130623f, -4.53761f, 
		-0.341635f, 0.130623f, -4.53761f, -0.301052f, 0.131332f, -4.53761f, 
		-0.315398f, 0.0949400f, -4.53761f, -0.315398f, 0.0949400f, -4.53761f, 
		-0.315398f, 0.0949400f, -4.53761f, -0.315325f, 0.161491f, -4.53761f, 
		-0.315325f, 0.161491f, -4.53761f, -0.315325f, 0.161491f, -4.53761f, 
		-0.315740f, 0.131332f, -4.53761f, -0.315740f, 0.131332f, -4.49586f, 
		-0.315740f, 0.131332f, -4.49586f, -0.315740f, 0.131332f, -4.49586f, 
		-0.315325f, 0.161491f, -4.49586f, -0.315325f, 0.161491f, -4.49586f, 
		-0.315325f, 0.161491f, -4.49586f, -0.315325f, 0.161491f, -4.49586f, 
		-0.315398f, 0.0949400f, -4.49586f, -0.315398f, 0.0949400f, -4.49586f, 
		-0.315398f, 0.0949400f, -4.49586f, -0.315398f, 0.0949400f, -4.49586f, 
		-0.301470f, 0.128718f, -4.49381f, -0.301470f, 0.128718f, -4.49381f, 
		-0.301470f, 0.128718f, -4.49381f, -0.301470f, 0.128718f, -4.49381f, 
		-0.341635f, 0.130623f, -4.49586f, -0.341635f, 0.130623f, -4.49586f, 
		-0.341635f, 0.130623f, -4.49586f, -0.299341f, 0.169499f, -4.49586f, 
		-0.299341f, 0.169499f, -4.49586f, -0.299341f, 0.169499f, -4.49586f, 
		-0.299341f, 0.169499f, -4.49586f, -0.261837f, 0.133461f, -4.49586f, 
		-0.261837f, 0.133461f, -4.49586f, -0.261837f, 0.133461f, -4.49586f, 
		-0.261837f, 0.133461f, -4.49586f, -0.300710f, 0.0949400f, -4.49586f, 
		-0.300710f, 0.0949400f, -4.49586f, -0.300710f, 0.0949400f, -4.49586f, 
		-0.300710f, 0.0949400f, -4.49586f, -0.333349f, 0.163010f, -4.49586f, 
		-0.333349f, 0.163010f, -4.49586f, -0.333349f, 0.163010f, -4.49586f, 
		-0.353879f, 0.0952460f, -4.49586f, -0.353879f, 0.0952460f, -4.49586f, 
		-0.353879f, 0.0952460f, -4.49586f, -0.261864f, 0.0928900f, -4.49586f, 
		-0.261864f, 0.0928900f, -4.49586f, -0.261864f, 0.0928900f, -4.49586f, 
		-0.261791f, 0.187940f, -4.49586f, -0.261791f, 0.187940f, -4.49586f, 
		-0.261791f, 0.187940f, -4.49586f, -0.0216020f, 0.322145f, -4.53761f, 
		-0.0216020f, 0.322145f, -4.53761f, -0.0216020f, 0.322145f, -4.53761f, 
		-0.0227790f, 0.228642f, -4.53761f, -0.0227790f, 0.228642f, -4.53761f, 
		-0.0227790f, 0.228642f, -4.53761f, -0.254258f, 0.242782f, -4.53761f, 
		-0.254258f, 0.242782f, -4.53761f, -0.254258f, 0.242782f, -4.53761f, 
		-0.250185f, 0.323753f, -4.53761f, -0.250185f, 0.323753f, -4.53761f, 
		-0.250185f, 0.323753f, -4.53761f, -0.0774360f, 0.216919f, -4.53761f, 
		-0.0774360f, 0.216919f, -4.53761f, -0.0774360f, 0.216919f, -4.53761f, 
		-0.0175390f, 0.271993f, -4.53761f, -0.0175390f, 0.271993f, -4.53761f, 
		-0.0175390f, 0.271993f, -4.53761f, -0.0774360f, 0.327067f, -4.53761f, 
		-0.0774360f, 0.327067f, -4.53761f, -0.0774360f, 0.327067f, -4.53761f, 
		-0.246879f, 0.284121f, -4.53761f, -0.246879f, 0.284121f, -4.53761f, 
		-0.246879f, 0.284121f, -4.53761f, -0.0774360f, 0.271993f, -4.53761f, 
		-0.103470f, 0.216919f, -4.53761f, -0.103470f, 0.216919f, -4.53761f, 
		-0.103470f, 0.216919f, -4.53761f, -0.105757f, 0.323852f, -4.53761f, 
		-0.105757f, 0.323852f, -4.53761f, -0.105757f, 0.323852f, -4.53761f, 
		-0.103470f, 0.271993f, -4.53761f, -0.110466f, 0.271993f, -4.49066f, 
		-0.110466f, 0.271993f, -4.49066f, -0.110466f, 0.271993f, -4.49066f, 
		-0.110466f, 0.271993f, -4.49066f, -0.105757f, 0.323852f, -4.49586f, 
		-0.105757f, 0.323852f, -4.49586f, -0.105757f, 0.323852f, -4.49586f, 
		-0.105757f, 0.323852f, -4.49586f, -0.103470f, 0.216919f, -4.49586f, 
		-0.103470f, 0.216919f, -4.49586f, -0.103470f, 0.216919f, -4.49586f, 
		-0.103470f, 0.216919f, -4.49586f, -0.0774360f, 0.271993f, -4.49796f, 
		-0.0774360f, 0.271993f, -4.49796f, -0.0774360f, 0.271993f, -4.49796f, 
		-0.0774360f, 0.271993f, -4.49796f, -0.246879f, 0.284121f, -4.49586f, 
		-0.246879f, 0.284121f, -4.49586f, -0.246879f, 0.284121f, -4.49586f, 
		-0.246879f, 0.284121f, -4.49586f, -0.0774360f, 0.327067f, -4.49586f, 
		-0.0774360f, 0.327067f, -4.49586f, -0.0774360f, 0.327067f, -4.49586f, 
		-0.0774360f, 0.327067f, -4.49586f, -0.0175390f, 0.271993f, -4.49054f, 
		-0.0175390f, 0.271993f, -4.49054f, -0.0175390f, 0.271993f, -4.49054f, 
		-0.0175390f, 0.271993f, -4.49054f, -0.0774360f, 0.216919f, -4.49586f, 
		-0.0774360f, 0.216919f, -4.49586f, -0.0774360f, 0.216919f, -4.49586f, 
		-0.0774360f, 0.216919f, -4.49586f, -0.250185f, 0.323753f, -4.49586f, 
		-0.250185f, 0.323753f, -4.49586f, -0.250185f, 0.323753f, -4.49586f, 
		-0.254258f, 0.242782f, -4.49586f, -0.254258f, 0.242782f, -4.49586f, 
		-0.254258f, 0.242782f, -4.49586f, -0.0227790f, 0.228642f, -4.49586f, 
		-0.0227790f, 0.228642f, -4.49586f, -0.0227790f, 0.228642f, -4.49586f, 
		-0.0216020f, 0.322145f, -4.49586f, -0.0216020f, 0.322145f, -4.49586f, 
		-0.0216020f, 0.322145f, -4.49586f, -0.163191f, 0.216875f, -4.53761f, 
		-0.163191f, 0.216875f, -4.53761f, -0.163191f, 0.216875f, -4.53761f, 
		-0.139145f, 0.104654f, -4.53761f, -0.139145f, 0.104654f, -4.53761f, 
		-0.139145f, 0.104654f, -4.53761f, -0.254611f, 0.0964870f, -4.53761f, 
		-0.254611f, 0.0964870f, -4.53761f, -0.254611f, 0.0964870f, -4.53761f, 
		-0.255143f, 0.231544f, -4.53761f, -0.255143f, 0.231544f, -4.53761f, 
		-0.255143f, 0.231544f, -4.53761f, -0.189576f, 0.100536f, -4.53761f, 
		-0.189576f, 0.100536f, -4.53761f, -0.189576f, 0.100536f, -4.53761f, 
		-0.141954f, 0.163768f, -4.53761f, -0.141954f, 0.163768f, -4.53761f, 
		-0.141954f, 0.163768f, -4.53761f, -0.195085f, 0.218842f, -4.53761f, 
		-0.195085f, 0.218842f, -4.53761f, -0.195085f, 0.218842f, -4.53761f, 
		-0.248216f, 0.163768f, -4.53761f, -0.248216f, 0.163768f, -4.53761f, 
		-0.248216f, 0.163768f, -4.53761f, -0.195085f, 0.163768f, -4.53761f, 
		-0.215611f, 0.100536f, -4.53761f, -0.215611f, 0.100536f, -4.53761f, 
		-0.215611f, 0.100536f, -4.53761f, -0.222049f, 0.227823f, -4.53761f, 
		-0.222049f, 0.227823f, -4.53761f, -0.222049f, 0.227823f, -4.53761f, 
		-0.221120f, 0.163768f, -4.53761f, -0.221120f, 0.163768f, -4.49586f, 
		-0.222049f, 0.227823f, -4.49586f, -0.222049f, 0.227823f, -4.49586f, 
		-0.222049f, 0.227823f, -4.49586f, -0.215611f, 0.100536f, -4.49586f, 
		-0.215611f, 0.100536f, -4.49586f, -0.215611f, 0.100536f, -4.49586f, 
		-0.195085f, 0.163768f, -4.49586f, -0.248216f, 0.163768f, -4.49586f, 
		-0.248216f, 0.163768f, -4.49586f, -0.248216f, 0.163768f, -4.49586f, 
		-0.195085f, 0.218842f, -4.49586f, -0.195085f, 0.218842f, -4.49586f, 
		-0.195085f, 0.218842f, -4.49586f, -0.141954f, 0.163768f, -4.49586f, 
		-0.141954f, 0.163768f, -4.49586f, -0.141954f, 0.163768f, -4.49586f, 
		-0.189576f, 0.100536f, -4.49586f, -0.189576f, 0.100536f, -4.49586f, 
		-0.189576f, 0.100536f, -4.49586f, -0.255143f, 0.231544f, -4.49586f, 
		-0.255143f, 0.231544f, -4.49586f, -0.255143f, 0.231544f, -4.49586f, 
		-0.254611f, 0.0964870f, -4.49586f, -0.254611f, 0.0964870f, -4.49586f, 
		-0.254611f, 0.0964870f, -4.49586f, -0.139145f, 0.104654f, -4.49586f, 
		-0.139145f, 0.104654f, -4.49586f, -0.139145f, 0.104654f, -4.49586f, 
		-0.163191f, 0.216875f, -4.49586f, -0.163191f, 0.216875f, -4.49586f, 
		-0.163191f, 0.216875f, -4.49586f, -0.0230480f, 0.218323f, -4.53761f, 
		-0.0230480f, 0.218323f, -4.53761f, -0.0230480f, 0.218323f, -4.53761f, 
		-0.0249310f, 0.109849f, -4.53761f, -0.0249310f, 0.109849f, -4.53761f, 
		-0.0249310f, 0.109849f, -4.53761f, -0.132510f, 0.103401f, -4.53761f, 
		-0.132510f, 0.103401f, -4.53761f, -0.132510f, 0.103401f, -4.53761f, 
		-0.146197f, 0.212987f, -4.53761f, -0.146197f, 0.212987f, -4.53761f, 
		-0.146197f, 0.212987f, -4.53761f, -0.0749680f, 0.0993450f, -4.53761f, 
		-0.0749680f, 0.0993450f, -4.53761f, -0.0749680f, 0.0993450f, -4.53761f, 
		-0.0218370f, 0.154419f, -4.53761f, -0.0218370f, 0.154419f, -4.53761f, 
		-0.0218370f, 0.154419f, -4.53761f, -0.0749680f, 0.209494f, -4.53761f, 
		-0.0749680f, 0.209494f, -4.53761f, -0.0749680f, 0.209494f, -4.53761f, 
		-0.128099f, 0.154419f, -4.53761f, -0.128099f, 0.154419f, -4.53761f, 
		-0.128099f, 0.154419f, -4.53761f, -0.0749680f, 0.154419f, -4.53761f, 
		-0.101002f, 0.0993450f, -4.53761f, -0.101002f, 0.0993450f, -4.53761f, 
		-0.101002f, 0.0993450f, -4.53761f, -0.108665f, 0.208327f, -4.53761f, 
		-0.108665f, 0.208327f, -4.53761f, -0.108665f, 0.208327f, -4.53761f, 
		-0.101002f, 0.154419f, -4.53761f, -0.0988090f, 0.156511f, -4.49838f, 
		-0.0988090f, 0.156511f, -4.49838f, -0.0988090f, 0.156511f, -4.49838f, 
		-0.0988090f, 0.156511f, -4.49838f, -0.108665f, 0.208327f, -4.49586f, 
		-0.108665f, 0.208327f, -4.49586f, -0.108665f, 0.208327f, -4.49586f, 
		-0.108665f, 0.208327f, -4.49586f, -0.101002f, 0.0993450f, -4.49586f, 
		-0.101002f, 0.0993450f, -4.49586f, -0.101002f, 0.0993450f, -4.49586f, 
		-0.101002f, 0.0993450f, -4.49586f, -0.0749680f, 0.154419f, -4.49264f, 
		-0.0749680f, 0.154419f, -4.49264f, -0.0749680f, 0.154419f, -4.49264f, 
		-0.0749680f, 0.154419f, -4.49264f, -0.128099f, 0.154419f, -4.49586f, 
		-0.128099f, 0.154419f, -4.49586f, -0.128099f, 0.154419f, -4.49586f, 
		-0.128099f, 0.154419f, -4.49586f, -0.0749680f, 0.209494f, -4.49586f, 
		-0.0749680f, 0.209494f, -4.49586f, -0.0749680f, 0.209494f, -4.49586f, 
		-0.0749680f, 0.209494f, -4.49586f, -0.0218370f, 0.154419f, -4.49586f, 
		-0.0218370f, 0.154419f, -4.49586f, -0.0218370f, 0.154419f, -4.49586f, 
		-0.0218370f, 0.154419f, -4.49586f, -0.0749680f, 0.0993450f, -4.49586f, 
		-0.0749680f, 0.0993450f, -4.49586f, -0.0749680f, 0.0993450f, -4.49586f, 
		-0.0749680f, 0.0993450f, -4.49586f, -0.146197f, 0.212987f, -4.49586f, 
		-0.146197f, 0.212987f, -4.49586f, -0.146197f, 0.212987f, -4.49586f, 
		-0.132510f, 0.103401f, -4.49586f, -0.132510f, 0.103401f, -4.49586f, 
		-0.132510f, 0.103401f, -4.49586f, -0.0249310f, 0.109849f, -4.49586f, 
		-0.0249310f, 0.109849f, -4.49586f, -0.0249310f, 0.109849f, -4.49586f, 
		-0.0230480f, 0.218323f, -4.49586f, -0.0230480f, 0.218323f, -4.49586f, 
		-0.0230480f, 0.218323f, -4.49586f, -0.175374f, 0.0933940f, -4.53761f, 
		-0.175374f, 0.0933940f, -4.53761f, -0.175374f, 0.0933940f, -4.53761f, 
		-0.170192f, -0.0107890f, -4.53761f, -0.170192f, -0.0107890f, -4.53761f, 
		-0.170192f, -0.0107890f, -4.53761f, -0.259293f, -0.0122710f, -4.53761f, 
		-0.259293f, -0.0122710f, -4.53761f, -0.259293f, -0.0122710f, -4.53761f, 
		-0.263228f, 0.0845460f, -4.53761f, -0.263228f, 0.0845460f, -4.53761f, 
		-0.263228f, 0.0845460f, -4.53761f, -0.212359f, -0.0241300f, -4.53761f, 
		-0.212359f, -0.0241300f, -4.53761f, -0.212359f, -0.0241300f, -4.53761f, 
		-0.174968f, 0.0329840f, -4.53761f, -0.174968f, 0.0329840f, -4.53761f, 
		-0.174968f, 0.0329840f, -4.53761f, -0.210391f, 0.0913210f, -4.53761f, 
		-0.210391f, 0.0913210f, -4.53761f, -0.210391f, 0.0913210f, -4.53761f, 
		-0.265490f, 0.0309440f, -4.53761f, -0.265490f, 0.0309440f, -4.53761f, 
		-0.265490f, 0.0309440f, -4.53761f, -0.212359f, 0.0309440f, -4.53761f, 
		-0.238393f, -0.0241300f, -4.53761f, -0.238393f, -0.0241300f, -4.53761f, 
		-0.238393f, -0.0241300f, -4.53761f, -0.241231f, 0.0927970f, -4.53761f, 
		-0.241231f, 0.0927970f, -4.53761f, -0.241231f, 0.0927970f, -4.53761f, 
		-0.238393f, 0.0309440f, -4.53761f, -0.238393f, 0.0309440f, -4.49586f, 
		-0.238393f, 0.0309440f, -4.49586f, -0.238393f, 0.0309440f, -4.49586f, 
		-0.241231f, 0.0927970f, -4.49586f, -0.241231f, 0.0927970f, -4.49586f, 
		-0.241231f, 0.0927970f, -4.49586f, -0.241231f, 0.0927970f, -4.49586f, 
		-0.238393f, -0.0241300f, -4.49586f, -0.238393f, -0.0241300f, -4.49586f, 
		-0.238393f, -0.0241300f, -4.49586f, -0.238393f, -0.0241300f, -4.49586f, 
		-0.212359f, 0.0309440f, -4.50205f, -0.212359f, 0.0309440f, -4.50205f, 
		-0.212359f, 0.0309440f, -4.50205f, -0.212359f, 0.0309440f, -4.50205f, 
		-0.212359f, 0.0309440f, -4.50205f, -0.265490f, 0.0309440f, -4.49586f, 
		-0.265490f, 0.0309440f, -4.49586f, -0.265490f, 0.0309440f, -4.49586f, 
		-0.210391f, 0.0913210f, -4.49586f, -0.210391f, 0.0913210f, -4.49586f, 
		-0.210391f, 0.0913210f, -4.49586f, -0.210391f, 0.0913210f, -4.49586f, 
		-0.174968f, 0.0329840f, -4.49586f, -0.174968f, 0.0329840f, -4.49586f, 
		-0.174968f, 0.0329840f, -4.49586f, -0.174968f, 0.0329840f, -4.49586f, 
		-0.174968f, 0.0329840f, -4.49586f, -0.212359f, -0.0241300f, -4.49586f, 
		-0.212359f, -0.0241300f, -4.49586f, -0.212359f, -0.0241300f, -4.49586f, 
		-0.212359f, -0.0241300f, -4.49586f, -0.263228f, 0.0845460f, -4.49586f, 
		-0.263228f, 0.0845460f, -4.49586f, -0.263228f, 0.0845460f, -4.49586f, 
		-0.259293f, -0.0122710f, -4.49586f, -0.259293f, -0.0122710f, -4.49586f, 
		-0.259293f, -0.0122710f, -4.49586f, -0.170192f, -0.0107890f, -4.49586f, 
		-0.170192f, -0.0107890f, -4.49586f, -0.170192f, -0.0107890f, -4.49586f, 
		-0.175374f, 0.0933940f, -4.49586f, -0.175374f, 0.0933940f, -4.49586f, 
		-0.175374f, 0.0933940f, -4.49586f, -0.189701f, -0.0223540f, -4.53761f, 
		-0.189701f, -0.0223540f, -4.53761f, -0.189701f, -0.0223540f, -4.53761f, 
		-0.170192f, -0.0107890f, -4.51674f, -0.170192f, -0.0107890f, -4.51674f, 
		-0.212359f, -0.0241300f, -4.51674f, -0.212359f, -0.0241300f, -4.51674f, 
		-0.189701f, -0.0223540f, -4.49586f, -0.189701f, -0.0223540f, -4.49586f, 
		-0.189701f, -0.0223540f, -4.49586f, -0.189701f, -0.0223540f, -4.49586f, 
		-0.189701f, -0.0223540f, -4.49586f, -0.189701f, -0.0223540f, -4.51674f, 
		-0.189701f, -0.0223540f, -4.51674f, -0.0236570f, 0.0988540f, -4.53761f, 
		-0.0236570f, 0.0988540f, -4.53761f, -0.0236570f, 0.0988540f, -4.53761f, 
		-0.0259510f, -0.0130780f, -4.53761f, -0.0259510f, -0.0130780f, -4.53761f, 
		-0.0259510f, -0.0130780f, -4.53761f, -0.159518f, -0.0104820f, -4.53761f, 
		-0.159518f, -0.0104820f, -4.53761f, -0.159518f, -0.0104820f, -4.53761f, 
		-0.165420f, 0.0924540f, -4.53761f, -0.165420f, 0.0924540f, -4.53761f, 
		-0.165420f, 0.0924540f, -4.53761f, -0.0956630f, -0.0211170f, -4.53761f, 
		-0.0956630f, -0.0211170f, -4.53761f, -0.0956630f, -0.0211170f, -4.53761f, 
		-0.0201030f, 0.0355890f, -4.53761f, -0.0201030f, 0.0355890f, -4.53761f, 
		-0.0201030f, 0.0355890f, -4.53761f, -0.0956630f, 0.0890320f, -4.53761f, 
		-0.0956630f, 0.0890320f, -4.53761f, -0.0956630f, 0.0890320f, -4.53761f, 
		-0.165321f, 0.0311020f, -4.53761f, -0.165321f, 0.0311020f, -4.53761f, 
		-0.165321f, 0.0311020f, -4.53761f, -0.0956630f, 0.0339580f, -4.53761f, 
		-0.121697f, -0.0211170f, -4.53761f, -0.121697f, -0.0211170f, -4.53761f, 
		-0.121697f, -0.0211170f, -4.53761f, -0.129651f, 0.0966260f, -4.53761f, 
		-0.129651f, 0.0966260f, -4.53761f, -0.129651f, 0.0966260f, -4.53761f, 
		-0.121697f, 0.0339580f, -4.53761f, -0.121697f, 0.0339580f, -4.49586f, 
		-0.121697f, 0.0339580f, -4.49586f, -0.121697f, 0.0339580f, -4.49586f, 
		-0.129651f, 0.0966260f, -4.49586f, -0.129651f, 0.0966260f, -4.49586f, 
		-0.129651f, 0.0966260f, -4.49586f, -0.129651f, 0.0966260f, -4.49586f, 
		-0.121697f, -0.0211170f, -4.49586f, -0.121697f, -0.0211170f, -4.49586f, 
		-0.121697f, -0.0211170f, -4.49586f, -0.121697f, -0.0211170f, -4.49586f, 
		-0.0956630f, 0.0339580f, -4.49994f, -0.0956630f, 0.0339580f, -4.49994f, 
		-0.0956630f, 0.0339580f, -4.49994f, -0.0956630f, 0.0339580f, -4.49994f, 
		-0.165321f, 0.0311020f, -4.49586f, -0.165321f, 0.0311020f, -4.49586f, 
		-0.165321f, 0.0311020f, -4.49586f, -0.0956630f, 0.0890320f, -4.49586f, 
		-0.0956630f, 0.0890320f, -4.49586f, -0.0956630f, 0.0890320f, -4.49586f, 
		-0.0956630f, 0.0890320f, -4.49586f, -0.0201030f, 0.0355890f, -4.49586f, 
		-0.0201030f, 0.0355890f, -4.49586f, -0.0201030f, 0.0355890f, -4.49586f, 
		-0.0201030f, 0.0355890f, -4.49586f, -0.0956630f, -0.0211170f, -4.49586f, 
		-0.0956630f, -0.0211170f, -4.49586f, -0.0956630f, -0.0211170f, -4.49586f, 
		-0.0956630f, -0.0211170f, -4.49586f, -0.165420f, 0.0924540f, -4.49586f, 
		-0.165420f, 0.0924540f, -4.49586f, -0.165420f, 0.0924540f, -4.49586f, 
		-0.159518f, -0.0104820f, -4.49586f, -0.159518f, -0.0104820f, -4.49586f, 
		-0.159518f, -0.0104820f, -4.49586f, -0.0259510f, -0.0130780f, -4.49586f, 
		-0.0259510f, -0.0130780f, -4.49586f, -0.0259510f, -0.0130780f, -4.49586f, 
		-0.0236570f, 0.0988540f, -4.49586f, -0.0236570f, 0.0988540f, -4.49586f, 
		-0.0236570f, 0.0988540f, -4.49586f, -0.0208990f, -0.0204800f, -4.53761f, 
		-0.0208990f, -0.0204800f, -4.53761f, -0.0208990f, -0.0204800f, -4.53761f, 
		-0.0201170f, -0.128409f, -4.53761f, -0.0201170f, -0.128409f, -4.53761f, 
		-0.0201170f, -0.128409f, -4.53761f, -0.267166f, -0.137475f, -4.53761f, 
		-0.267166f, -0.137475f, -4.53761f, -0.267166f, -0.137475f, -4.53761f, 
		-0.262567f, -0.0251230f, -4.53761f, -0.262567f, -0.0251230f, -4.53761f, 
		-0.262567f, -0.0251230f, -4.53761f, -0.220232f, -0.149334f, -4.53761f, 
		-0.220232f, -0.149334f, -4.53761f, -0.220232f, -0.149334f, -4.53761f, 
		-0.0246360f, -0.0844150f, -4.53761f, -0.0246360f, -0.0844150f, -4.53761f, 
		-0.0246360f, -0.0844150f, -4.53761f, -0.165173f, -0.0255380f, -4.53761f, 
		-0.165173f, -0.0255380f, -4.53761f, -0.165173f, -0.0255380f, -4.53761f, 
		-0.265583f, -0.0942600f, -4.53761f, -0.265583f, -0.0942600f, -4.53761f, 
		-0.265583f, -0.0942600f, -4.53761f, -0.220232f, -0.0942600f, -4.53761f, 
		-0.246266f, -0.149334f, -4.53761f, -0.246266f, -0.149334f, -4.53761f, 
		-0.246266f, -0.149334f, -4.53761f, -0.218615f, -0.0322030f, -4.53761f, 
		-0.218615f, -0.0322030f, -4.53761f, -0.218615f, -0.0322030f, -4.53761f, 
		-0.246266f, -0.0942600f, -4.53761f, -0.246266f, -0.0942600f, -4.49586f, 
		-0.246266f, -0.0942600f, -4.49586f, -0.246266f, -0.0942600f, -4.49586f, 
		-0.218615f, -0.0322030f, -4.49586f, -0.218615f, -0.0322030f, -4.49586f, 
		-0.218615f, -0.0322030f, -4.49586f, -0.218615f, -0.0322030f, -4.49586f, 
		-0.246266f, -0.149334f, -4.49586f, -0.246266f, -0.149334f, -4.49586f, 
		-0.246266f, -0.149334f, -4.49586f, -0.246266f, -0.149334f, -4.49586f, 
		-0.220232f, -0.0942600f, -4.49956f, -0.220232f, -0.0942600f, -4.49956f, 
		-0.220232f, -0.0942600f, -4.49956f, -0.220232f, -0.0942600f, -4.49956f, 
		-0.220232f, -0.0942600f, -4.49956f, -0.220232f, -0.0942600f, -4.49956f, 
		-0.265583f, -0.0942600f, -4.49586f, -0.265583f, -0.0942600f, -4.49586f, 
		-0.265583f, -0.0942600f, -4.49586f, -0.165173f, -0.0255380f, -4.49586f, 
		-0.165173f, -0.0255380f, -4.49586f, -0.165173f, -0.0255380f, -4.49586f, 
		-0.165173f, -0.0255380f, -4.49586f, -0.0246360f, -0.0844150f, -4.49586f, 
		-0.0246360f, -0.0844150f, -4.49586f, -0.0246360f, -0.0844150f, -4.49586f, 
		-0.0246360f, -0.0844150f, -4.49586f, -0.0246360f, -0.0844150f, -4.49586f, 
		-0.220232f, -0.149334f, -4.49586f, -0.220232f, -0.149334f, -4.49586f, 
		-0.220232f, -0.149334f, -4.49586f, -0.220232f, -0.149334f, -4.49586f, 
		-0.262567f, -0.0251230f, -4.49586f, -0.262567f, -0.0251230f, -4.49586f, 
		-0.262567f, -0.0251230f, -4.49586f, -0.267166f, -0.137475f, -4.49586f, 
		-0.267166f, -0.137475f, -4.49586f, -0.267166f, -0.137475f, -4.49586f, 
		-0.0201170f, -0.128409f, -4.49586f, -0.0201170f, -0.128409f, -4.49586f, 
		-0.0201170f, -0.128409f, -4.49586f, -0.0208990f, -0.0204800f, -4.49586f, 
		-0.0208990f, -0.0204800f, -4.49586f, -0.0208990f, -0.0204800f, -4.49586f, 
		-0.0934880f, -0.0328590f, -4.53761f, -0.0934880f, -0.0328590f, -4.53761f, 
		-0.0934880f, -0.0328590f, -4.53761f, -0.0208990f, -0.0204800f, -4.51674f, 
		-0.0208990f, -0.0204800f, -4.51674f, -0.165173f, -0.0255380f, -4.51674f, 
		-0.165173f, -0.0255380f, -4.51674f, -0.0934880f, -0.0328590f, -4.49586f, 
		-0.0934880f, -0.0328590f, -4.49586f, -0.0934880f, -0.0328590f, -4.49586f, 
		-0.0934880f, -0.0328590f, -4.49586f, -0.0934880f, -0.0328590f, -4.49586f, 
		-0.0934880f, -0.0328590f, -4.51674f, -0.0934880f, -0.0328590f, -4.51674f, 
		-0.120414f, -0.132854f, -4.53761f, -0.120414f, -0.132854f, -4.53761f, 
		-0.120414f, -0.132854f, -4.53761f, -0.0201170f, -0.128409f, -4.51674f, 
		-0.0201170f, -0.128409f, -4.51674f, -0.220232f, -0.149334f, -4.51674f, 
		-0.220232f, -0.149334f, -4.51674f, -0.120414f, -0.132854f, -4.49586f, 
		-0.120414f, -0.132854f, -4.49586f, -0.120414f, -0.132854f, -4.49586f, 
		-0.120414f, -0.132854f, -4.49586f, -0.120414f, -0.132854f, -4.49586f, 
		-0.120414f, -0.132854f, -4.51674f, -0.120414f, -0.132854f, -4.51674f, 
		-0.0210390f, -0.136981f, -4.53761f, -0.0210390f, -0.136981f, -4.53761f, 
		-0.0210390f, -0.136981f, -4.53761f, -0.0212930f, -0.238833f, -4.53761f, 
		-0.0212930f, -0.238833f, -4.53761f, -0.0212930f, -0.238833f, -4.53761f, 
		-0.178969f, -0.241395f, -4.53761f, -0.178969f, -0.241395f, -4.53761f, 
		-0.178969f, -0.241395f, -4.53761f, -0.187296f, -0.153880f, -4.53761f, 
		-0.187296f, -0.153880f, -4.53761f, -0.187296f, -0.153880f, -4.53761f, 
		-0.0737500f, -0.252175f, -4.53761f, -0.0737500f, -0.252175f, -4.53761f, 
		-0.0737500f, -0.252175f, -4.53761f, -0.0206190f, -0.197100f, -4.53761f, 
		-0.0206190f, -0.197100f, -4.53761f, -0.0206190f, -0.197100f, -4.53761f, 
		-0.0737500f, -0.142026f, -4.53761f, -0.0737500f, -0.142026f, -4.53761f, 
		-0.0737500f, -0.142026f, -4.53761f, -0.177881f, -0.197100f, -4.53761f, 
		-0.177881f, -0.197100f, -4.53761f, -0.177881f, -0.197100f, -4.53761f, 
		-0.0737500f, -0.197100f, -4.53761f, -0.0997840f, -0.252175f, -4.53761f, 
		-0.0997840f, -0.252175f, -4.53761f, -0.0997840f, -0.252175f, -4.53761f, 
		-0.0997400f, -0.141301f, -4.53761f, -0.0997400f, -0.141301f, -4.53761f, 
		-0.0997400f, -0.141301f, -4.53761f, -0.0997840f, -0.197100f, -4.53761f, 
		-0.0997840f, -0.197100f, -4.49005f, -0.0997840f, -0.197100f, -4.49005f, 
		-0.0997840f, -0.197100f, -4.49005f, -0.0997840f, -0.197100f, -4.49005f, 
		-0.0997400f, -0.141301f, -4.49586f, -0.0997400f, -0.141301f, -4.49586f, 
		-0.0997400f, -0.141301f, -4.49586f, -0.0997400f, -0.141301f, -4.49586f, 
		-0.0997840f, -0.252175f, -4.49586f, -0.0997840f, -0.252175f, -4.49586f, 
		-0.0997840f, -0.252175f, -4.49586f, -0.0997840f, -0.252175f, -4.49586f, 
		-0.0737500f, -0.197100f, -4.49586f, -0.0737500f, -0.197100f, -4.49586f, 
		-0.0737500f, -0.197100f, -4.49586f, -0.0737500f, -0.197100f, -4.49586f, 
		-0.177881f, -0.197100f, -4.49586f, -0.177881f, -0.197100f, -4.49586f, 
		-0.177881f, -0.197100f, -4.49586f, -0.177881f, -0.197100f, -4.49586f, 
		-0.0737500f, -0.142026f, -4.49586f, -0.0737500f, -0.142026f, -4.49586f, 
		-0.0737500f, -0.142026f, -4.49586f, -0.0737500f, -0.142026f, -4.49586f, 
		-0.0206190f, -0.197100f, -4.49113f, -0.0206190f, -0.197100f, -4.49113f, 
		-0.0206190f, -0.197100f, -4.49113f, -0.0206190f, -0.197100f, -4.49113f, 
		-0.0737500f, -0.252175f, -4.49586f, -0.0737500f, -0.252175f, -4.49586f, 
		-0.0737500f, -0.252175f, -4.49586f, -0.0737500f, -0.252175f, -4.49586f, 
		-0.187296f, -0.153880f, -4.49586f, -0.187296f, -0.153880f, -4.49586f, 
		-0.187296f, -0.153880f, -4.49586f, -0.178969f, -0.241395f, -4.49586f, 
		-0.178969f, -0.241395f, -4.49586f, -0.178969f, -0.241395f, -4.49586f, 
		-0.0212930f, -0.238833f, -4.49586f, -0.0212930f, -0.238833f, -4.49586f, 
		-0.0212930f, -0.238833f, -4.49586f, -0.0210390f, -0.136981f, -4.49586f, 
		-0.0210390f, -0.136981f, -4.49586f, -0.0210390f, -0.136981f, -4.49586f, 
		-0.194892f, -0.154842f, -4.53761f, -0.194892f, -0.154842f, -4.53761f, 
		-0.194892f, -0.154842f, -4.53761f, -0.186112f, -0.246221f, -4.53761f, 
		-0.186112f, -0.246221f, -4.53761f, -0.186112f, -0.246221f, -4.53761f, 
		-0.266594f, -0.255822f, -4.53761f, -0.266594f, -0.255822f, -4.53761f, 
		-0.266594f, -0.255822f, -4.53761f, -0.267381f, -0.154518f, -4.53761f, 
		-0.267381f, -0.154518f, -4.53761f, -0.267381f, -0.154518f, -4.53761f, 
		-0.239728f, -0.264417f, -4.53761f, -0.239728f, -0.264417f, -4.53761f, 
		-0.239728f, -0.264417f, -4.53761f, -0.186597f, -0.209343f, -4.53761f, 
		-0.186597f, -0.209343f, -4.53761f, -0.186597f, -0.209343f, -4.53761f, 
		-0.239728f, -0.154269f, -4.53761f, -0.239728f, -0.154269f, -4.53761f, 
		-0.239728f, -0.154269f, -4.53761f, -0.268855f, -0.206080f, -4.53761f, 
		-0.268855f, -0.206080f, -4.53761f, -0.268855f, -0.206080f, -4.53761f, 
		-0.239728f, -0.209343f, -4.53761f, -0.252777f, -0.264417f, -4.53761f, 
		-0.252777f, -0.264417f, -4.53761f, -0.252777f, -0.264417f, -4.53761f, 
		-0.253253f, -0.162175f, -4.53761f, -0.253253f, -0.162175f, -4.53761f, 
		-0.253253f, -0.162175f, -4.53761f, -0.252777f, -0.209343f, -4.53761f, 
		-0.252777f, -0.209343f, -4.49586f, -0.252777f, -0.209343f, -4.49586f, 
		-0.252777f, -0.209343f, -4.49586f, -0.253253f, -0.162175f, -4.49586f, 
		-0.253253f, -0.162175f, -4.49586f, -0.253253f, -0.162175f, -4.49586f, 
		-0.253253f, -0.162175f, -4.49586f, -0.252777f, -0.264417f, -4.49586f, 
		-0.252777f, -0.264417f, -4.49586f, -0.252777f, -0.264417f, -4.49586f, 
		-0.252777f, -0.264417f, -4.49586f, -0.240925f, -0.212071f, -4.49336f, 
		-0.240925f, -0.212071f, -4.49336f, -0.240925f, -0.212071f, -4.49336f, 
		-0.240925f, -0.212071f, -4.49336f, -0.268855f, -0.206080f, -4.49586f, 
		-0.268855f, -0.206080f, -4.49586f, -0.268855f, -0.206080f, -4.49586f, 
		-0.239728f, -0.154269f, -4.49586f, -0.239728f, -0.154269f, -4.49586f, 
		-0.239728f, -0.154269f, -4.49586f, -0.239728f, -0.154269f, -4.49586f, 
		-0.186597f, -0.209343f, -4.49231f, -0.186597f, -0.209343f, -4.49231f, 
		-0.186597f, -0.209343f, -4.49231f, -0.186597f, -0.209343f, -4.49231f, 
		-0.239728f, -0.264417f, -4.49586f, -0.239728f, -0.264417f, -4.49586f, 
		-0.239728f, -0.264417f, -4.49586f, -0.239728f, -0.264417f, -4.49586f, 
		-0.267381f, -0.154518f, -4.49586f, -0.267381f, -0.154518f, -4.49586f, 
		-0.267381f, -0.154518f, -4.49586f, -0.266594f, -0.255822f, -4.49586f, 
		-0.266594f, -0.255822f, -4.49586f, -0.266594f, -0.255822f, -4.49586f, 
		-0.186112f, -0.246221f, -4.49586f, -0.186112f, -0.246221f, -4.49586f, 
		-0.186112f, -0.246221f, -4.49586f, -0.194892f, -0.154842f, -4.49586f, 
		-0.194892f, -0.154842f, -4.49586f, -0.194892f, -0.154842f, -4.49586f, 
		-0.183755f, -0.253738f, -4.53761f, -0.183755f, -0.253738f, -4.53761f, 
		-0.183755f, -0.253738f, -4.53761f, -0.178196f, -0.369068f, -4.53761f, 
		-0.178196f, -0.369068f, -4.53761f, -0.178196f, -0.369068f, -4.53761f, 
		-0.267298f, -0.370551f, -4.53761f, -0.267298f, -0.370551f, -4.53761f, 
		-0.267298f, -0.370551f, -4.53761f, -0.266778f, -0.267932f, -4.53761f, 
		-0.266778f, -0.267932f, -4.53761f, -0.266778f, -0.267932f, -4.53761f, 
		-0.220364f, -0.382410f, -4.53761f, -0.220364f, -0.382410f, -4.53761f, 
		-0.220364f, -0.382410f, -4.53761f, -0.167233f, -0.327335f, -4.53761f, 
		-0.167233f, -0.327335f, -4.53761f, -0.167233f, -0.327335f, -4.53761f, 
		-0.220364f, -0.272261f, -4.53761f, -0.220364f, -0.272261f, -4.53761f, 
		-0.220364f, -0.272261f, -4.53761f, -0.264648f, -0.326256f, -4.53761f, 
		-0.264648f, -0.326256f, -4.53761f, -0.264648f, -0.326256f, -4.53761f, 
		-0.220364f, -0.327335f, -4.53761f, -0.246398f, -0.382410f, -4.53761f, 
		-0.246398f, -0.382410f, -4.53761f, -0.246398f, -0.382410f, -4.53761f, 
		-0.246354f, -0.275851f, -4.53761f, -0.246354f, -0.275851f, -4.53761f, 
		-0.246354f, -0.275851f, -4.53761f, -0.246398f, -0.327335f, -4.53761f, 
		-0.246398f, -0.327335f, -4.49586f, -0.246398f, -0.327335f, -4.49586f, 
		-0.246398f, -0.327335f, -4.49586f, -0.246354f, -0.275851f, -4.49586f, 
		-0.246354f, -0.275851f, -4.49586f, -0.246354f, -0.275851f, -4.49586f, 
		-0.246354f, -0.275851f, -4.49586f, -0.246398f, -0.382410f, -4.49586f, 
		-0.246398f, -0.382410f, -4.49586f, -0.246398f, -0.382410f, -4.49586f, 
		-0.246398f, -0.382410f, -4.49586f, -0.220364f, -0.327335f, -4.49414f, 
		-0.220364f, -0.327335f, -4.49414f, -0.220364f, -0.327335f, -4.49414f, 
		-0.220364f, -0.327335f, -4.49414f, -0.264648f, -0.326256f, -4.49586f, 
		-0.264648f, -0.326256f, -4.49586f, -0.264648f, -0.326256f, -4.49586f, 
		-0.220364f, -0.272261f, -4.49586f, -0.220364f, -0.272261f, -4.49586f, 
		-0.220364f, -0.272261f, -4.49586f, -0.220364f, -0.272261f, -4.49586f, 
		-0.167233f, -0.327335f, -4.49586f, -0.167233f, -0.327335f, -4.49586f, 
		-0.167233f, -0.327335f, -4.49586f, -0.167233f, -0.327335f, -4.49586f, 
		-0.167233f, -0.327335f, -4.49586f, -0.220364f, -0.382410f, -4.49586f, 
		-0.220364f, -0.382410f, -4.49586f, -0.220364f, -0.382410f, -4.49586f, 
		-0.220364f, -0.382410f, -4.49586f, -0.266778f, -0.267932f, -4.49586f, 
		-0.266778f, -0.267932f, -4.49586f, -0.266778f, -0.267932f, -4.49586f, 
		-0.267298f, -0.370551f, -4.49586f, -0.267298f, -0.370551f, -4.49586f, 
		-0.267298f, -0.370551f, -4.49586f, -0.178196f, -0.369068f, -4.49586f, 
		-0.178196f, -0.369068f, -4.49586f, -0.178196f, -0.369068f, -4.49586f, 
		-0.178196f, -0.369068f, -4.49586f, -0.183755f, -0.253738f, -4.49586f, 
		-0.183755f, -0.253738f, -4.49586f, -0.183755f, -0.253738f, -4.49586f, 
		-0.0214850f, -0.374811f, -4.49586f, -0.0214850f, -0.374811f, -4.49586f, 
		-0.0214850f, -0.374811f, -4.49586f, -0.0247680f, -0.315849f, -4.49586f, 
		-0.0247680f, -0.315849f, -4.49586f, -0.0247680f, -0.315849f, -4.49586f, 
		-0.0247680f, -0.315849f, -4.53761f, -0.0247680f, -0.315849f, -4.53761f, 
		-0.0247680f, -0.315849f, -4.53761f, -0.0214850f, -0.374811f, -4.53761f, 
		-0.0214850f, -0.374811f, -4.53761f, -0.0214850f, -0.374811f, -4.53761f, 
		-0.0152120f, -0.340818f, -4.49586f, -0.0152120f, -0.340818f, -4.49586f, 
		-0.0152120f, -0.340818f, -4.49586f, -0.0214850f, -0.374811f, -4.51674f, 
		-0.0214850f, -0.374811f, -4.51674f, -0.0152120f, -0.340818f, -4.53761f, 
		-0.0152120f, -0.340818f, -4.53761f, -0.0152120f, -0.340818f, -4.53761f, 
		-0.0247680f, -0.315849f, -4.51674f, -0.0247680f, -0.315849f, -4.51674f, 
		-0.0152120f, -0.340818f, -4.51674f, -0.0152120f, -0.340818f, -4.51674f, 
		-0.0218170f, -0.251115f, -4.53761f, -0.0218170f, -0.251115f, -4.53761f, 
		-0.0218170f, -0.251115f, -4.53761f, -0.0254660f, -0.308094f, -4.53761f, 
		-0.0254660f, -0.308094f, -4.53761f, -0.0254660f, -0.308094f, -4.53761f, 
		-0.162698f, -0.317780f, -4.53761f, -0.162698f, -0.317780f, -4.53761f, 
		-0.162698f, -0.317780f, -4.53761f, -0.178044f, -0.249750f, -4.53761f, 
		-0.178044f, -0.249750f, -4.53761f, -0.178044f, -0.249750f, -4.53761f, 
		-0.116154f, -0.315725f, -4.53761f, -0.116154f, -0.315725f, -4.53761f, 
		-0.116154f, -0.315725f, -4.53761f, -0.0158720f, -0.284789f, -4.53761f, 
		-0.0158720f, -0.284789f, -4.53761f, -0.0158720f, -0.284789f, -4.53761f, 
		-0.116154f, -0.260668f, -4.53761f, -0.116154f, -0.260668f, -4.53761f, 
		-0.116154f, -0.260668f, -4.53761f, -0.116154f, -0.260668f, -4.53761f, 
		-0.170789f, -0.277039f, -4.53761f, -0.170789f, -0.277039f, -4.53761f, 
		-0.170789f, -0.277039f, -4.53761f, -0.116154f, -0.289275f, -4.53761f, 
		-0.116154f, -0.289275f, -4.53761f, -0.128657f, -0.315725f, -4.53761f, 
		-0.128657f, -0.315725f, -4.53761f, -0.128657f, -0.315725f, -4.53761f, 
		-0.129279f, -0.256833f, -4.53761f, -0.129279f, -0.256833f, -4.53761f, 
		-0.129279f, -0.256833f, -4.53761f, -0.129279f, -0.256833f, -4.53761f, 
		-0.128657f, -0.289275f, -4.53761f, -0.128657f, -0.289275f, -4.53761f, 
		-0.128657f, -0.289275f, -4.49586f, -0.129279f, -0.256833f, -4.49586f, 
		-0.129279f, -0.256833f, -4.49586f, -0.129279f, -0.256833f, -4.49586f, 
		-0.128657f, -0.315725f, -4.49586f, -0.128657f, -0.315725f, -4.49586f, 
		-0.128657f, -0.315725f, -4.49586f, -0.116154f, -0.289275f, -4.49586f, 
		-0.170789f, -0.277039f, -4.49586f, -0.170789f, -0.277039f, -4.49586f, 
		-0.170789f, -0.277039f, -4.49586f, -0.116154f, -0.260668f, -4.49586f, 
		-0.116154f, -0.260668f, -4.49586f, -0.116154f, -0.260668f, -4.49586f, 
		-0.0158720f, -0.284789f, -4.49586f, -0.0158720f, -0.284789f, -4.49586f, 
		-0.0158720f, -0.284789f, -4.49586f, -0.116154f, -0.315725f, -4.49586f, 
		-0.116154f, -0.315725f, -4.49586f, -0.116154f, -0.315725f, -4.49586f, 
		-0.178044f, -0.249750f, -4.49586f, -0.178044f, -0.249750f, -4.49586f, 
		-0.178044f, -0.249750f, -4.49586f, -0.162698f, -0.317780f, -4.49586f, 
		-0.162698f, -0.317780f, -4.49586f, -0.162698f, -0.317780f, -4.49586f, 
		-0.0254660f, -0.308094f, -4.49586f, -0.0254660f, -0.308094f, -4.49586f, 
		-0.0254660f, -0.308094f, -4.49586f, -0.0218170f, -0.251115f, -4.49586f, 
		-0.0218170f, -0.251115f, -4.49586f, -0.0218170f, -0.251115f, -4.49586f, 
		-0.176122f, -0.377082f, -4.53761f, -0.176122f, -0.377082f, -4.53761f, 
		-0.176122f, -0.377082f, -4.53761f, -0.182054f, -0.463185f, -4.53761f, 
		-0.182054f, -0.463185f, -4.53761f, -0.182054f, -0.463185f, -4.53761f, 
		-0.263770f, -0.462771f, -4.53761f, -0.263770f, -0.462771f, -4.53761f, 
		-0.263770f, -0.462771f, -4.53761f, -0.266131f, -0.383319f, -4.53761f, 
		-0.266131f, -0.383319f, -4.53761f, -0.266131f, -0.383319f, -4.53761f, 
		-0.211773f, -0.462313f, -4.53761f, -0.211773f, -0.462313f, -4.53761f, 
		-0.211773f, -0.462313f, -4.53761f, -0.166229f, -0.412656f, -4.53761f, 
		-0.166229f, -0.412656f, -4.53761f, -0.166229f, -0.412656f, -4.53761f, 
		-0.218856f, -0.388289f, -4.53761f, -0.218856f, -0.388289f, -4.53761f, 
		-0.218856f, -0.388289f, -4.53761f, -0.218856f, -0.388289f, -4.53761f, 
		-0.268335f, -0.408577f, -4.53761f, -0.268335f, -0.408577f, -4.53761f, 
		-0.268335f, -0.408577f, -4.53761f, -0.218856f, -0.418367f, -4.53761f, 
		-0.218856f, -0.418367f, -4.53761f, -0.230713f, -0.465169f, -4.53761f, 
		-0.230713f, -0.465169f, -4.53761f, -0.230713f, -0.465169f, -4.53761f, 
		-0.233335f, -0.392606f, -4.53761f, -0.233335f, -0.392606f, -4.53761f, 
		-0.233335f, -0.392606f, -4.53761f, -0.233335f, -0.392606f, -4.53761f, 
		-0.233074f, -0.418367f, -4.53761f, -0.233074f, -0.418367f, -4.53761f, 
		-0.233074f, -0.418367f, -4.49425f, -0.233074f, -0.418367f, -4.49425f, 
		-0.233074f, -0.418367f, -4.49425f, -0.233074f, -0.418367f, -4.49425f, 
		-0.233335f, -0.392606f, -4.49586f, -0.233335f, -0.392606f, -4.49586f, 
		-0.233335f, -0.392606f, -4.49586f, -0.233335f, -0.392606f, -4.49586f, 
		-0.230713f, -0.465169f, -4.49586f, -0.230713f, -0.465169f, -4.49586f, 
		-0.230713f, -0.465169f, -4.49586f, -0.230713f, -0.465169f, -4.49586f, 
		-0.218856f, -0.418367f, -4.49425f, -0.218856f, -0.418367f, -4.49425f, 
		-0.218856f, -0.418367f, -4.49425f, -0.218856f, -0.418367f, -4.49425f, 
		-0.268335f, -0.408577f, -4.49586f, -0.268335f, -0.408577f, -4.49586f, 
		-0.268335f, -0.408577f, -4.49586f, -0.268335f, -0.408577f, -4.49586f, 
		-0.218856f, -0.388289f, -4.49586f, -0.218856f, -0.388289f, -4.49586f, 
		-0.218856f, -0.388289f, -4.49586f, -0.218856f, -0.388289f, -4.49586f, 
		-0.166229f, -0.412656f, -4.49586f, -0.166229f, -0.412656f, -4.49586f, 
		-0.166229f, -0.412656f, -4.49586f, -0.166229f, -0.412656f, -4.49586f, 
		-0.211773f, -0.462313f, -4.49586f, -0.211773f, -0.462313f, -4.49586f, 
		-0.211773f, -0.462313f, -4.49586f, -0.211773f, -0.462313f, -4.49586f, 
		-0.266131f, -0.383319f, -4.49586f, -0.266131f, -0.383319f, -4.49586f, 
		-0.266131f, -0.383319f, -4.49586f, -0.263770f, -0.462771f, -4.49586f, 
		-0.263770f, -0.462771f, -4.49586f, -0.263770f, -0.462771f, -4.49586f, 
		-0.182054f, -0.463185f, -4.49586f, -0.182054f, -0.463185f, -4.49586f, 
		-0.182054f, -0.463185f, -4.49586f, -0.176122f, -0.377082f, -4.49586f, 
		-0.176122f, -0.377082f, -4.49586f, -0.176122f, -0.377082f, -4.49586f, 
		-0.0228800f, -0.401522f, -4.53761f, -0.0228800f, -0.401522f, -4.53761f, 
		-0.0228800f, -0.401522f, -4.53761f, -0.0227820f, -0.445561f, -4.53761f, 
		-0.0227820f, -0.445561f, -4.53761f, -0.0227820f, -0.445561f, -4.53761f, 
		-0.126342f, -0.465253f, -4.53761f, -0.126342f, -0.465253f, -4.53761f, 
		-0.126342f, -0.465253f, -4.53761f, -0.114251f, -0.378071f, -4.53761f, 
		-0.114251f, -0.378071f, -4.53761f, -0.114251f, -0.378071f, -4.53761f, 
		-0.0237830f, -0.465992f, -4.53761f, -0.0237830f, -0.465992f, -4.53761f, 
		-0.0237830f, -0.465992f, -4.53761f, -0.0221750f, -0.426080f, -4.53761f, 
		-0.0221750f, -0.426080f, -4.53761f, -0.0221750f, -0.426080f, -4.53761f, 
		-0.0229550f, -0.379701f, -4.53761f, -0.0229550f, -0.379701f, -4.53761f, 
		-0.0229550f, -0.379701f, -4.53761f, -0.0966820f, -0.422457f, -4.53761f, 
		-0.0966820f, -0.422457f, -4.53761f, -0.0966820f, -0.422457f, -4.53761f, 
		-0.0966820f, -0.422457f, -4.53761f, -0.0637280f, -0.421824f, -4.53761f, 
		-0.0827930f, -0.465283f, -4.53761f, -0.0827930f, -0.465283f, -4.53761f, 
		-0.0827930f, -0.465283f, -4.53761f, -0.0827930f, -0.465283f, -4.53761f, 
		-0.0767790f, -0.378902f, -4.53761f, -0.0767790f, -0.378902f, -4.53761f, 
		-0.0767790f, -0.378902f, -4.53761f, -0.0765440f, -0.421824f, -4.53761f, 
		-0.0765440f, -0.421824f, -4.53761f, -0.0765440f, -0.421824f, -4.49586f, 
		-0.0765440f, -0.421824f, -4.49586f, -0.0765440f, -0.421824f, -4.49586f, 
		-0.0765440f, -0.421824f, -4.49586f, -0.0767790f, -0.378902f, -4.49586f, 
		-0.0767790f, -0.378902f, -4.49586f, -0.0767790f, -0.378902f, -4.49586f, 
		-0.0767790f, -0.378902f, -4.49586f, -0.0827930f, -0.465283f, -4.49586f, 
		-0.0827930f, -0.465283f, -4.49586f, -0.0827930f, -0.465283f, -4.49586f, 
		-0.0827930f, -0.465283f, -4.49586f, -0.0827930f, -0.465283f, -4.49586f, 
		-0.0637280f, -0.421824f, -4.50005f, -0.0637280f, -0.421824f, -4.50005f, 
		-0.0637280f, -0.421824f, -4.50005f, -0.0637280f, -0.421824f, -4.50005f, 
		-0.0966820f, -0.422457f, -4.49586f, -0.0966820f, -0.422457f, -4.49586f, 
		-0.0966820f, -0.422457f, -4.49586f, -0.0966820f, -0.422457f, -4.49586f, 
		-0.0229550f, -0.379701f, -4.49586f, -0.0229550f, -0.379701f, -4.49586f, 
		-0.0229550f, -0.379701f, -4.49586f, -0.0229550f, -0.379701f, -4.49586f, 
		-0.0221750f, -0.426080f, -4.49586f, -0.0221750f, -0.426080f, -4.49586f, 
		-0.0221750f, -0.426080f, -4.49586f, -0.0221750f, -0.426080f, -4.49586f, 
		-0.0237830f, -0.465992f, -4.49586f, -0.0237830f, -0.465992f, -4.49586f, 
		-0.0237830f, -0.465992f, -4.49586f, -0.0237830f, -0.465992f, -4.49586f, 
		-0.114251f, -0.378071f, -4.49586f, -0.114251f, -0.378071f, -4.49586f, 
		-0.114251f, -0.378071f, -4.49586f, -0.126342f, -0.465253f, -4.49586f, 
		-0.126342f, -0.465253f, -4.49586f, -0.126342f, -0.465253f, -4.49586f, 
		-0.0227820f, -0.445561f, -4.49586f, -0.0227820f, -0.445561f, -4.49586f, 
		-0.0227820f, -0.445561f, -4.49586f, -0.0228800f, -0.401522f, -4.49586f, 
		-0.0228800f, -0.401522f, -4.49586f, -0.0228800f, -0.401522f, -4.49586f, 
		-0.107406f, -0.448112f, -4.53761f, -0.107406f, -0.448112f, -4.53761f, 
		-0.107406f, -0.448112f, -4.53761f, -0.107406f, -0.448112f, -4.53761f, 
		-0.107406f, -0.448112f, -4.53761f, -0.0966820f, -0.422457f, -4.51674f, 
		-0.0966820f, -0.422457f, -4.51674f, -0.126342f, -0.465253f, -4.51674f, 
		-0.126342f, -0.465253f, -4.51674f, -0.107406f, -0.448112f, -4.49586f, 
		-0.107406f, -0.448112f, -4.49586f, -0.107406f, -0.448112f, -4.49586f, 
		-0.107406f, -0.448112f, -4.49586f, -0.107406f, -0.448112f, -4.49586f, 
		-0.107406f, -0.448112f, -4.51674f, -0.107406f, -0.448112f, -4.51674f, 
		-1.35324f, 1.46790f, -4.70429f, -1.35324f, 1.46790f, -4.70429f, 
		-1.35324f, 1.46762f, -4.70429f, -1.35324f, 1.46762f, -4.70429f, 
		-1.35324f, 1.46733f, -4.70429f, -1.35324f, 1.46733f, -4.70429f, 
		-1.35324f, 1.46705f, -4.70429f, -1.35324f, 1.46705f, -4.70429f, 
		-1.35323f, 1.46677f, -4.70429f, -1.35323f, 1.46677f, -4.70429f, 
		-1.35323f, 1.46649f, -4.70429f, -1.35323f, 1.46649f, -4.70429f, 
		-1.35323f, 1.46620f, -4.70429f, -1.35323f, 1.46620f, -4.70429f, 
		-1.35323f, 1.46592f, -4.70429f, -1.35323f, 1.46592f, -4.70429f, 
		-1.35323f, 1.46564f, -4.70429f, -1.35323f, 1.46564f, -4.70429f, 
		-1.35322f, 1.46535f, -4.70429f, -1.35322f, 1.46535f, -4.70429f, 
		-1.35322f, 1.46507f, -4.70429f, -1.35322f, 1.46507f, -4.70429f, 
		-1.35177f, 1.44763f, -4.70429f, -1.35177f, 1.44763f, -4.70429f, 
		-1.33745f, 1.45396f, -4.70432f, -1.33745f, 1.45396f, -4.70432f, 
		-1.33744f, 1.46597f, -4.70432f, -1.33744f, 1.46597f, -4.70432f, 
		-1.33741f, 1.47742f, -4.70432f, -1.33741f, 1.47742f, -4.70432f, 
		-1.33735f, 1.48838f, -4.70432f, -1.33735f, 1.48838f, -4.70432f, 
		-1.33729f, 1.49895f, -4.70432f, -1.33729f, 1.49895f, -4.70432f, 
		-1.33721f, 1.50919f, -4.70432f, -1.33721f, 1.50919f, -4.70432f, 
		-1.33712f, 1.51919f, -4.70432f, -1.33712f, 1.51919f, -4.70432f, 
		-1.33703f, 1.52904f, -4.70432f, -1.33703f, 1.52904f, -4.70432f, 
		-1.33693f, 1.53880f, -4.70432f, -1.33693f, 1.53880f, -4.70432f, 
		-1.33683f, 1.54857f, -4.70432f, -1.33683f, 1.54857f, -4.70432f, 
		-1.33673f, 1.55841f, -4.70432f, -1.33673f, 1.55841f, -4.70432f, 
		-1.33665f, 1.56841f, -4.70432f, -1.33665f, 1.56841f, -4.70432f, 
		-1.46537f, 1.57794f, -4.70404f, -1.46537f, 1.57794f, -4.70404f, 
		-1.46537f, 1.57705f, -4.70404f, -1.46537f, 1.57705f, -4.70404f, 
		-1.46536f, 1.57616f, -4.70404f, -1.46536f, 1.57616f, -4.70404f, 
		-1.46536f, 1.57526f, -4.70404f, -1.46536f, 1.57526f, -4.70404f, 
		-1.46536f, 1.57437f, -4.70404f, -1.46536f, 1.57437f, -4.70404f, 
		-1.46535f, 1.57348f, -4.70404f, -1.46535f, 1.57348f, -4.70404f, 
		-1.46535f, 1.57258f, -4.70404f, -1.46535f, 1.57258f, -4.70404f, 
		-1.46534f, 1.57169f, -4.70404f, -1.46534f, 1.57169f, -4.70404f, 
		-1.46534f, 1.57080f, -4.70404f, -1.46534f, 1.57080f, -4.70404f, 
		-1.46533f, 1.56990f, -4.70404f, -1.46533f, 1.56990f, -4.70404f, 
		-1.46533f, 1.56901f, -4.70404f, -1.46533f, 1.56901f, -4.70404f, 
		-1.46281f, 1.56713f, -4.70405f, -1.46281f, 1.56713f, -4.70405f, 
		-1.45858f, 1.56677f, -4.70406f, -1.45858f, 1.56677f, -4.70406f, 
		-1.45303f, 1.56687f, -4.70407f, -1.45303f, 1.56687f, -4.70407f, 
		-1.44656f, 1.56730f, -4.70408f, -1.44656f, 1.56730f, -4.70408f, 
		-1.43956f, 1.56791f, -4.70410f, -1.43956f, 1.56791f, -4.70410f, 
		-1.43243f, 1.56854f, -4.70412f, -1.43243f, 1.56854f, -4.70412f, 
		-1.42556f, 1.56904f, -4.70413f, -1.42556f, 1.56904f, -4.70413f, 
		-1.41936f, 1.56928f, -4.70414f, -1.41936f, 1.56928f, -4.70414f, 
		-1.41421f, 1.56909f, -4.70415f, -1.41421f, 1.56909f, -4.70415f, 
		-1.41051f, 1.56833f, -4.70416f, -1.41051f, 1.56833f, -4.70416f, 
		-1.40867f, 1.56685f, -4.70417f, -1.40867f, 1.56685f, -4.70417f, 
		-1.40907f, 1.56450f, -4.70416f, -1.40907f, 1.56450f, -4.70416f, 
		-1.40783f, 1.56446f, -4.70417f, -1.40783f, 1.56446f, -4.70417f, 
		-1.40654f, 1.56439f, -4.70417f, -1.40654f, 1.56439f, -4.70417f, 
		-1.40525f, 1.56429f, -4.70417f, -1.40525f, 1.56429f, -4.70417f, 
		-1.40400f, 1.56412f, -4.70418f, -1.40400f, 1.56412f, -4.70418f, 
		-1.40283f, 1.56387f, -4.70418f, -1.40283f, 1.56387f, -4.70418f, 
		-1.40178f, 1.56349f, -4.70418f, -1.40178f, 1.56349f, -4.70418f, 
		-1.40089f, 1.56298f, -4.70418f, -1.40089f, 1.56298f, -4.70418f, 
		-1.40021f, 1.56230f, -4.70419f, -1.40021f, 1.56230f, -4.70419f, 
		-1.39977f, 1.56143f, -4.70419f, -1.39977f, 1.56143f, -4.70419f, 
		-1.39962f, 1.56034f, -4.70419f, -1.39962f, 1.56034f, -4.70419f, 
		-1.39980f, 1.55902f, -4.70419f, -1.39980f, 1.55902f, -4.70419f, 
		-1.40036f, 1.55742f, -4.70418f, -1.40036f, 1.55742f, -4.70418f, 
		-1.39219f, 1.54925f, -4.70420f, -1.39219f, 1.54925f, -4.70420f, 
		-1.39620f, 1.54436f, -4.70419f, -1.39620f, 1.54436f, -4.70419f, 
		-1.39861f, 1.53920f, -4.70419f, -1.39861f, 1.53920f, -4.70419f, 
		-1.39958f, 1.53390f, -4.70419f, -1.39958f, 1.53390f, -4.70419f, 
		-1.39926f, 1.52864f, -4.70419f, -1.39926f, 1.52864f, -4.70419f, 
		-1.39780f, 1.52357f, -4.70419f, -1.39780f, 1.52357f, -4.70419f, 
		-1.39534f, 1.51885f, -4.70420f, -1.39534f, 1.51885f, -4.70420f, 
		-1.39203f, 1.51465f, -4.70420f, -1.39203f, 1.51465f, -4.70420f, 
		-1.38803f, 1.51111f, -4.70421f, -1.38803f, 1.51111f, -4.70421f, 
		-1.38348f, 1.50841f, -4.70422f, -1.38348f, 1.50841f, -4.70422f, 
		-1.37854f, 1.50670f, -4.70423f, -1.37854f, 1.50670f, -4.70423f, 
		-1.37335f, 1.50615f, -4.70424f, -1.37335f, 1.50615f, -4.70424f, 
		-1.37256f, 1.49153f, -4.70424f, -1.37256f, 1.49153f, -4.70424f, 
		-1.37255f, 1.48648f, -4.70424f, -1.37255f, 1.48648f, -4.70424f, 
		-1.36761f, 1.48643f, -4.70425f, -1.36761f, 1.48643f, -4.70425f, 
		-1.36635f, 1.48700f, -4.70426f, -1.36635f, 1.48700f, -4.70426f, 
		-1.36505f, 1.48723f, -4.70426f, -1.36505f, 1.48723f, -4.70426f, 
		-1.36377f, 1.48716f, -4.70426f, -1.36377f, 1.48716f, -4.70426f, 
		-1.36252f, 1.48682f, -4.70427f, -1.36252f, 1.48682f, -4.70427f, 
		-1.36137f, 1.48626f, -4.70427f, -1.36137f, 1.48626f, -4.70427f, 
		-1.36036f, 1.48551f, -4.70427f, -1.36036f, 1.48551f, -4.70427f, 
		-1.35952f, 1.48462f, -4.70427f, -1.35952f, 1.48462f, -4.70427f, 
		-1.35890f, 1.48362f, -4.70427f, -1.35890f, 1.48362f, -4.70427f, 
		-1.35855f, 1.48256f, -4.70427f, -1.35855f, 1.48256f, -4.70427f, 
		-1.35850f, 1.48147f, -4.70427f, -1.35850f, 1.48147f, -4.70427f, 
		-1.35880f, 1.48039f, -4.70427f, -1.35880f, 1.48039f, -4.70427f, 
		-1.35949f, 1.47937f, -4.70427f, -1.35949f, 1.47937f, -4.70427f, 
		-1.35993f, 1.47870f, -4.70427f, -1.35993f, 1.47870f, -4.70427f, 
		-1.36018f, 1.47789f, -4.70427f, -1.36018f, 1.47789f, -4.70427f, 
		-1.36025f, 1.47696f, -4.70427f, -1.36025f, 1.47696f, -4.70427f, 
		-1.36014f, 1.47595f, -4.70427f, -1.36014f, 1.47595f, -4.70427f, 
		-1.35986f, 1.47488f, -4.70427f, -1.35986f, 1.47488f, -4.70427f, 
		-1.35940f, 1.47379f, -4.70427f, -1.35940f, 1.47379f, -4.70427f, 
		-1.35877f, 1.47269f, -4.70427f, -1.35877f, 1.47269f, -4.70427f, 
		-1.35798f, 1.47162f, -4.70428f, -1.35798f, 1.47162f, -4.70428f, 
		-1.35702f, 1.47060f, -4.70428f, -1.35702f, 1.47060f, -4.70428f, 
		-1.35591f, 1.46967f, -4.70428f, -1.35591f, 1.46967f, -4.70428f, 
		-1.35465f, 1.46886f, -4.70428f, -1.35465f, 1.46886f, -4.70428f, 
		-1.35260f, 1.46649f, -4.47937f, -1.35260f, 1.46649f, -4.47937f, 
		-1.35260f, 1.46649f, -4.47937f, -1.35260f, 1.46649f, -4.47937f, 
		-1.35260f, 1.46620f, -4.47937f, -1.35260f, 1.46620f, -4.47937f, 
		-1.35260f, 1.46620f, -4.47937f, -1.35260f, 1.46620f, -4.47937f, 
		-1.35259f, 1.46592f, -4.47937f, -1.35259f, 1.46592f, -4.47937f, 
		-1.35259f, 1.46592f, -4.47937f, -1.35259f, 1.46592f, -4.47937f, 
		-1.35259f, 1.46535f, -4.47937f, -1.35259f, 1.46535f, -4.47937f, 
		-1.35259f, 1.46535f, -4.47937f, -1.35259f, 1.46535f, -4.47937f, 
		-1.33646f, 1.45396f, -4.49214f, -1.33646f, 1.45396f, -4.49214f, 
		-1.33646f, 1.45396f, -4.49214f, -1.33646f, 1.45396f, -4.49214f, 
		-1.33622f, 1.50919f, -4.49234f, -1.33622f, 1.50919f, -4.49234f, 
		-1.33622f, 1.50919f, -4.49234f, -1.33622f, 1.50919f, -4.49234f, 
		-1.33613f, 1.51919f, -4.49241f, -1.33613f, 1.51919f, -4.49241f, 
		-1.33613f, 1.51919f, -4.49241f, -1.33613f, 1.51919f, -4.49241f, 
		-1.33603f, 1.52904f, -4.49249f, -1.33603f, 1.52904f, -4.49249f, 
		-1.33603f, 1.52904f, -4.49249f, -1.33603f, 1.52904f, -4.49249f, 
		-1.33583f, 1.54857f, -4.49264f, -1.33583f, 1.54857f, -4.49264f, 
		-1.33583f, 1.54857f, -4.49264f, -1.33583f, 1.54857f, -4.49264f, 
		-1.46726f, 1.57884f, -4.38858f, -1.46726f, 1.57884f, -4.38858f, 
		-1.46726f, 1.57884f, -4.38858f, -1.46726f, 1.57884f, -4.38858f, 
		-1.46725f, 1.57705f, -4.38859f, -1.46725f, 1.57705f, -4.38859f, 
		-1.46725f, 1.57705f, -4.38859f, -1.46725f, 1.57705f, -4.38859f, 
		-1.46725f, 1.57616f, -4.38859f, -1.46725f, 1.57616f, -4.38859f, 
		-1.46725f, 1.57616f, -4.38859f, -1.46725f, 1.57616f, -4.38859f, 
		-1.46724f, 1.57526f, -4.38860f, -1.46724f, 1.57526f, -4.38860f, 
		-1.46724f, 1.57526f, -4.38860f, -1.46724f, 1.57526f, -4.38860f, 
		-1.46723f, 1.57348f, -4.38861f, -1.46723f, 1.57348f, -4.38861f, 
		-1.46723f, 1.57348f, -4.38861f, -1.46723f, 1.57348f, -4.38861f, 
		-1.46723f, 1.57258f, -4.38861f, -1.46723f, 1.57258f, -4.38861f, 
		-1.46723f, 1.57258f, -4.38861f, -1.46723f, 1.57258f, -4.38861f, 
		-1.46722f, 1.57169f, -4.38861f, -1.46722f, 1.57169f, -4.38861f, 
		-1.46722f, 1.57169f, -4.38861f, -1.46722f, 1.57169f, -4.38861f, 
		-1.46721f, 1.56812f, -4.38863f, -1.46721f, 1.56812f, -4.38863f, 
		-1.46721f, 1.56812f, -4.38863f, -1.46721f, 1.56812f, -4.38863f, 
		-1.46464f, 1.56713f, -4.39066f, -1.46464f, 1.56713f, -4.39066f, 
		-1.46464f, 1.56713f, -4.39066f, -1.46464f, 1.56713f, -4.39066f, 
		-1.46031f, 1.56677f, -4.39408f, -1.46031f, 1.56677f, -4.39408f, 
		-1.46031f, 1.56677f, -4.39408f, -1.46031f, 1.56677f, -4.39408f, 
		-1.45464f, 1.56687f, -4.39858f, -1.45464f, 1.56687f, -4.39858f, 
		-1.45464f, 1.56687f, -4.39858f, -1.45464f, 1.56687f, -4.39858f, 
		-1.44802f, 1.56730f, -4.40382f, -1.44802f, 1.56730f, -4.40382f, 
		-1.44802f, 1.56730f, -4.40382f, -1.44802f, 1.56730f, -4.40382f, 
		-1.44086f, 1.56791f, -4.40948f, -1.44086f, 1.56791f, -4.40948f, 
		-1.44086f, 1.56791f, -4.40948f, -1.44086f, 1.56791f, -4.40948f, 
		-1.43357f, 1.56854f, -4.41526f, -1.43357f, 1.56854f, -4.41526f, 
		-1.43357f, 1.56854f, -4.41526f, -1.43357f, 1.56854f, -4.41526f, 
		-1.42655f, 1.56904f, -4.42081f, -1.42655f, 1.56904f, -4.42081f, 
		-1.42655f, 1.56904f, -4.42081f, -1.42655f, 1.56904f, -4.42081f, 
		-1.42021f, 1.56928f, -4.42584f, -1.42021f, 1.56928f, -4.42584f, 
		-1.42021f, 1.56928f, -4.42584f, -1.42021f, 1.56928f, -4.42584f, 
		-1.41494f, 1.56909f, -4.43001f, -1.41494f, 1.56909f, -4.43001f, 
		-1.41494f, 1.56909f, -4.43001f, -1.41494f, 1.56909f, -4.43001f, 
		-1.41116f, 1.56833f, -4.43300f, -1.41116f, 1.56833f, -4.43300f, 
		-1.41116f, 1.56833f, -4.43300f, -1.41116f, 1.56833f, -4.43300f, 
		-1.40928f, 1.56685f, -4.43449f, -1.40928f, 1.56685f, -4.43449f, 
		-1.40928f, 1.56685f, -4.43449f, -1.40928f, 1.56685f, -4.43449f, 
		-1.40842f, 1.56446f, -4.43517f, -1.40842f, 1.56446f, -4.43517f, 
		-1.40842f, 1.56446f, -4.43517f, -1.40842f, 1.56446f, -4.43517f, 
		-1.40711f, 1.56439f, -4.43621f, -1.40711f, 1.56439f, -4.43621f, 
		-1.40711f, 1.56439f, -4.43621f, -1.40711f, 1.56439f, -4.43621f, 
		-1.40579f, 1.56429f, -4.43725f, -1.40579f, 1.56429f, -4.43725f, 
		-1.40579f, 1.56429f, -4.43725f, -1.40579f, 1.56429f, -4.43725f, 
		-1.40451f, 1.56412f, -4.43827f, -1.40451f, 1.56412f, -4.43827f, 
		-1.40451f, 1.56412f, -4.43827f, -1.40451f, 1.56412f, -4.43827f, 
		-1.40331f, 1.56387f, -4.43922f, -1.40331f, 1.56387f, -4.43922f, 
		-1.40331f, 1.56387f, -4.43922f, -1.40331f, 1.56387f, -4.43922f, 
		-1.40132f, 1.56298f, -4.44079f, -1.40132f, 1.56298f, -4.44079f, 
		-1.40132f, 1.56298f, -4.44079f, -1.40132f, 1.56298f, -4.44079f, 
		-1.40063f, 1.56230f, -4.44134f, -1.40063f, 1.56230f, -4.44134f, 
		-1.40063f, 1.56230f, -4.44134f, -1.40063f, 1.56230f, -4.44134f, 
		-1.40003f, 1.56034f, -4.44181f, -1.40003f, 1.56034f, -4.44181f, 
		-1.40003f, 1.56034f, -4.44181f, -1.40003f, 1.56034f, -4.44181f, 
		-1.40022f, 1.55902f, -4.44167f, -1.40022f, 1.55902f, -4.44167f, 
		-1.40022f, 1.55902f, -4.44167f, -1.40022f, 1.55902f, -4.44167f, 
		-1.40078f, 1.55742f, -4.44122f, -1.40078f, 1.55742f, -4.44122f, 
		-1.40078f, 1.55742f, -4.44122f, -1.40078f, 1.55742f, -4.44122f, 
		-1.40070f, 1.54923f, -4.44128f, -1.40070f, 1.54923f, -4.44128f, 
		-1.40070f, 1.54923f, -4.44128f, -1.40070f, 1.54923f, -4.44128f, 
		-1.39243f, 1.54925f, -4.44783f, -1.39243f, 1.54925f, -4.44783f, 
		-1.39243f, 1.54925f, -4.44783f, -1.39243f, 1.54925f, -4.44783f, 
		-1.39999f, 1.53390f, -4.44184f, -1.39999f, 1.53390f, -4.44184f, 
		-1.39999f, 1.53390f, -4.44184f, -1.39999f, 1.53390f, -4.44184f, 
		-1.39966f, 1.52864f, -4.44210f, -1.39966f, 1.52864f, -4.44210f, 
		-1.39966f, 1.52864f, -4.44210f, -1.39966f, 1.52864f, -4.44210f, 
		-1.39816f, 1.52357f, -4.44329f, -1.39816f, 1.52357f, -4.44329f, 
		-1.39816f, 1.52357f, -4.44329f, -1.39816f, 1.52357f, -4.44329f, 
		-1.37848f, 1.50670f, -4.45888f, -1.37848f, 1.50670f, -4.45888f, 
		-1.37848f, 1.50670f, -4.45888f, -1.37848f, 1.50670f, -4.45888f, 
		-1.37317f, 1.50615f, -4.46308f, -1.37317f, 1.50615f, -4.46308f, 
		-1.37317f, 1.50615f, -4.46308f, -1.37317f, 1.50615f, -4.46308f, 
		-1.36777f, 1.50690f, -4.46736f, -1.36777f, 1.50690f, -4.46736f, 
		-1.36777f, 1.50690f, -4.46736f, -1.36777f, 1.50690f, -4.46736f, 
		-1.36784f, 1.49154f, -4.46730f, -1.36784f, 1.49154f, -4.46730f, 
		-1.36784f, 1.49154f, -4.46730f, -1.36784f, 1.49154f, -4.46730f, 
		-1.36730f, 1.48644f, -4.46772f, -1.36730f, 1.48644f, -4.46772f, 
		-1.36730f, 1.48644f, -4.46772f, -1.36730f, 1.48644f, -4.46772f, 
		-1.36601f, 1.48700f, -4.46875f, -1.36601f, 1.48700f, -4.46875f, 
		-1.36601f, 1.48700f, -4.46875f, -1.36601f, 1.48700f, -4.46875f, 
		-1.36469f, 1.48723f, -4.46980f, -1.36469f, 1.48723f, -4.46980f, 
		-1.36469f, 1.48723f, -4.46980f, -1.36469f, 1.48723f, -4.46980f, 
		-1.36337f, 1.48716f, -4.47084f, -1.36337f, 1.48716f, -4.47084f, 
		-1.36337f, 1.48716f, -4.47084f, -1.36337f, 1.48716f, -4.47084f, 
		-1.36210f, 1.48682f, -4.47184f, -1.36210f, 1.48682f, -4.47184f, 
		-1.36210f, 1.48682f, -4.47184f, -1.36210f, 1.48682f, -4.47184f, 
		-1.36092f, 1.48626f, -4.47277f, -1.36092f, 1.48626f, -4.47277f, 
		-1.36092f, 1.48626f, -4.47277f, -1.36092f, 1.48626f, -4.47277f, 
		-1.35989f, 1.48551f, -4.47360f, -1.35989f, 1.48551f, -4.47360f, 
		-1.35989f, 1.48551f, -4.47360f, -1.35989f, 1.48551f, -4.47360f, 
		-1.35799f, 1.48147f, -4.47510f, -1.35799f, 1.48147f, -4.47510f, 
		-1.35799f, 1.48147f, -4.47510f, -1.35799f, 1.48147f, -4.47510f, 
		-1.35829f, 1.48039f, -4.47486f, -1.35829f, 1.48039f, -4.47486f, 
		-1.35829f, 1.48039f, -4.47486f, -1.35829f, 1.48039f, -4.47486f, 
		-1.35900f, 1.47937f, -4.47430f, -1.35900f, 1.47937f, -4.47430f, 
		-1.35900f, 1.47937f, -4.47430f, -1.35900f, 1.47937f, -4.47430f, 
		-1.35945f, 1.47870f, -4.47394f, -1.35945f, 1.47870f, -4.47394f, 
		-1.35945f, 1.47870f, -4.47394f, -1.35945f, 1.47870f, -4.47394f, 
		-1.35890f, 1.47379f, -4.47438f, -1.35890f, 1.47379f, -4.47438f, 
		-1.35890f, 1.47379f, -4.47438f, -1.35890f, 1.47379f, -4.47438f, 
		-1.35745f, 1.47162f, -4.47553f, -1.35745f, 1.47162f, -4.47553f, 
		-1.35745f, 1.47162f, -4.47553f, -1.35745f, 1.47162f, -4.47553f, 
		-1.35534f, 1.46967f, -4.47719f, -1.35534f, 1.46967f, -4.47719f, 
		-1.35534f, 1.46967f, -4.47719f, -1.35534f, 1.46967f, -4.47719f, 
		-1.35405f, 1.46886f, -4.47822f, -1.35405f, 1.46886f, -4.47822f, 
		-1.35405f, 1.46886f, -4.47822f, -1.35405f, 1.46886f, -4.47822f, 
		0.143045f, 1.46818f, -4.47915f, 0.143045f, 1.46818f, -4.47915f, 
		0.143045f, 1.46818f, -4.47915f, 0.143045f, 1.46818f, -4.47915f, 
		0.143043f, 1.46790f, -4.47915f, 0.143043f, 1.46790f, -4.47915f, 
		0.143043f, 1.46790f, -4.47915f, 0.143043f, 1.46790f, -4.47915f, 
		0.143037f, 1.46705f, -4.47915f, 0.143037f, 1.46705f, -4.47915f, 
		0.143037f, 1.46705f, -4.47915f, 0.143037f, 1.46705f, -4.47915f, 
		0.143030f, 1.46592f, -4.47916f, 0.143030f, 1.46592f, -4.47916f, 
		0.143030f, 1.46592f, -4.47916f, 0.143030f, 1.46592f, -4.47916f, 
		0.143028f, 1.46564f, -4.47916f, 0.143028f, 1.46564f, -4.47916f, 
		0.143028f, 1.46564f, -4.47916f, 0.143028f, 1.46564f, -4.47916f, 
		0.143026f, 1.46535f, -4.47916f, 0.143026f, 1.46535f, -4.47916f, 
		0.143026f, 1.46535f, -4.47916f, 0.143026f, 1.46535f, -4.47916f, 
		0.126847f, 1.47742f, -4.49197f, 0.126847f, 1.47742f, -4.49197f, 
		0.126847f, 1.47742f, -4.49197f, 0.126847f, 1.47742f, -4.49197f, 
		0.126726f, 1.49895f, -4.49206f, 0.126726f, 1.49895f, -4.49206f, 
		0.126726f, 1.49895f, -4.49206f, 0.126726f, 1.49895f, -4.49206f, 
		0.126457f, 1.52904f, -4.49228f, 0.126457f, 1.52904f, -4.49228f, 
		0.126457f, 1.52904f, -4.49228f, 0.126457f, 1.52904f, -4.49228f, 
		0.126357f, 1.53880f, -4.49236f, 0.126357f, 1.53880f, -4.49236f, 
		0.126357f, 1.53880f, -4.49236f, 0.126357f, 1.53880f, -4.49236f, 
		0.126159f, 1.55841f, -4.49251f, 0.126159f, 1.55841f, -4.49251f, 
		0.126159f, 1.55841f, -4.49251f, 0.126159f, 1.55841f, -4.49251f, 
		0.126069f, 1.56841f, -4.49259f, 0.126069f, 1.56841f, -4.49259f, 
		0.126069f, 1.56841f, -4.49259f, 0.126069f, 1.56841f, -4.49259f, 
		0.257739f, 1.57884f, -4.38834f, 0.257739f, 1.57884f, -4.38834f, 
		0.257739f, 1.57884f, -4.38834f, 0.257739f, 1.57884f, -4.38834f, 
		0.257735f, 1.57794f, -4.38834f, 0.257735f, 1.57794f, -4.38834f, 
		0.257735f, 1.57794f, -4.38834f, 0.257735f, 1.57794f, -4.38834f, 
		0.257717f, 1.57437f, -4.38836f, 0.257717f, 1.57437f, -4.38836f, 
		0.257717f, 1.57437f, -4.38836f, 0.257717f, 1.57437f, -4.38836f, 
		0.257690f, 1.56901f, -4.38838f, 0.257690f, 1.56901f, -4.38838f, 
		0.257690f, 1.56901f, -4.38838f, 0.257690f, 1.56901f, -4.38838f, 
		0.257686f, 1.56812f, -4.38838f, 0.257686f, 1.56812f, -4.38838f, 
		0.257686f, 1.56812f, -4.38838f, 0.257686f, 1.56812f, -4.38838f, 
		0.255114f, 1.56713f, -4.39042f, 0.255114f, 1.56713f, -4.39042f, 
		0.255114f, 1.56713f, -4.39042f, 0.255114f, 1.56713f, -4.39042f, 
		0.250787f, 1.56677f, -4.39384f, 0.250787f, 1.56677f, -4.39384f, 
		0.250787f, 1.56677f, -4.39384f, 0.250787f, 1.56677f, -4.39384f, 
		0.245111f, 1.56687f, -4.39834f, 0.245111f, 1.56687f, -4.39834f, 
		0.245111f, 1.56687f, -4.39834f, 0.245111f, 1.56687f, -4.39834f, 
		0.238491f, 1.56730f, -4.40358f, 0.238491f, 1.56730f, -4.40358f, 
		0.238491f, 1.56730f, -4.40358f, 0.238491f, 1.56730f, -4.40358f, 
		0.231331f, 1.56791f, -4.40925f, 0.231331f, 1.56791f, -4.40925f, 
		0.231331f, 1.56791f, -4.40925f, 0.231331f, 1.56791f, -4.40925f, 
		0.224037f, 1.56854f, -4.41502f, 0.224037f, 1.56854f, -4.41502f, 
		0.224037f, 1.56854f, -4.41502f, 0.224037f, 1.56854f, -4.41502f, 
		0.217014f, 1.56904f, -4.42058f, 0.217014f, 1.56904f, -4.42058f, 
		0.217014f, 1.56904f, -4.42058f, 0.217014f, 1.56904f, -4.42058f, 
		0.210667f, 1.56928f, -4.42561f, 0.210667f, 1.56928f, -4.42561f, 
		0.210667f, 1.56928f, -4.42561f, 0.210667f, 1.56928f, -4.42561f, 
		0.205401f, 1.56909f, -4.42978f, 0.205401f, 1.56909f, -4.42978f, 
		0.205401f, 1.56909f, -4.42978f, 0.205401f, 1.56909f, -4.42978f, 
		0.198876f, 1.56446f, -4.43494f, 0.198876f, 1.56446f, -4.43494f, 
		0.198876f, 1.56446f, -4.43494f, 0.198876f, 1.56446f, -4.43494f, 
		0.197562f, 1.56439f, -4.43598f, 0.197562f, 1.56439f, -4.43598f, 
		0.197562f, 1.56439f, -4.43598f, 0.197562f, 1.56439f, -4.43598f, 
		0.196243f, 1.56429f, -4.43703f, 0.196243f, 1.56429f, -4.43703f, 
		0.196243f, 1.56429f, -4.43703f, 0.196243f, 1.56429f, -4.43703f, 
		0.194962f, 1.56412f, -4.43804f, 0.194962f, 1.56412f, -4.43804f, 
		0.194962f, 1.56412f, -4.43804f, 0.194962f, 1.56412f, -4.43804f, 
		0.193762f, 1.56387f, -4.43899f, 0.193762f, 1.56387f, -4.43899f, 
		0.193762f, 1.56387f, -4.43899f, 0.193762f, 1.56387f, -4.43899f, 
		0.191079f, 1.56230f, -4.44111f, 0.191079f, 1.56230f, -4.44111f, 
		0.191079f, 1.56230f, -4.44111f, 0.191079f, 1.56230f, -4.44111f, 
		0.190633f, 1.56143f, -4.44147f, 0.190633f, 1.56143f, -4.44147f, 
		0.190633f, 1.56143f, -4.44147f, 0.190633f, 1.56143f, -4.44147f, 
		0.190668f, 1.55902f, -4.44144f, 0.190668f, 1.55902f, -4.44144f, 
		0.190668f, 1.55902f, -4.44144f, 0.190668f, 1.55902f, -4.44144f, 
		0.191236f, 1.55742f, -4.44099f, 0.191236f, 1.55742f, -4.44099f, 
		0.191236f, 1.55742f, -4.44099f, 0.191236f, 1.55742f, -4.44099f, 
		0.186979f, 1.54436f, -4.44436f, 0.186979f, 1.54436f, -4.44436f, 
		0.186979f, 1.54436f, -4.44436f, 0.186979f, 1.54436f, -4.44436f, 
		0.173978f, 1.50841f, -4.45466f, 0.173978f, 1.50841f, -4.45466f, 
		0.173978f, 1.50841f, -4.45466f, 0.173978f, 1.50841f, -4.45466f, 
		0.168922f, 1.50670f, -4.45866f, 0.168922f, 1.50670f, -4.45866f, 
		0.168922f, 1.50670f, -4.45866f, 0.168922f, 1.50670f, -4.45866f, 
		0.163614f, 1.50615f, -4.46286f, 0.163614f, 1.50615f, -4.46286f, 
		0.163614f, 1.50615f, -4.46286f, 0.163614f, 1.50615f, -4.46286f, 
		0.158207f, 1.50690f, -4.46714f, 0.158207f, 1.50690f, -4.46714f, 
		0.158207f, 1.50690f, -4.46714f, 0.158207f, 1.50690f, -4.46714f, 
		0.158279f, 1.49154f, -4.46708f, 0.158279f, 1.49154f, -4.46708f, 
		0.158279f, 1.49154f, -4.46708f, 0.158279f, 1.49154f, -4.46708f, 
		0.162801f, 1.49153f, -4.46350f, 0.162801f, 1.49153f, -4.46350f, 
		0.162801f, 1.49153f, -4.46350f, 0.162801f, 1.49153f, -4.46350f, 
		0.162798f, 1.48648f, -4.46351f, 0.162798f, 1.48648f, -4.46351f, 
		0.162798f, 1.48648f, -4.46351f, 0.162798f, 1.48648f, -4.46351f, 
		0.157743f, 1.48644f, -4.46751f, 0.157743f, 1.48644f, -4.46751f, 
		0.157743f, 1.48644f, -4.46751f, 0.157743f, 1.48644f, -4.46751f, 
		0.156453f, 1.48700f, -4.46853f, 0.156453f, 1.48700f, -4.46853f, 
		0.156453f, 1.48700f, -4.46853f, 0.156453f, 1.48700f, -4.46853f, 
		0.155127f, 1.48723f, -4.46958f, 0.155127f, 1.48723f, -4.46958f, 
		0.155127f, 1.48723f, -4.46958f, 0.155127f, 1.48723f, -4.46958f, 
		0.153808f, 1.48716f, -4.47062f, 0.153808f, 1.48716f, -4.47062f, 
		0.153808f, 1.48716f, -4.47062f, 0.153808f, 1.48716f, -4.47062f, 
		0.152538f, 1.48682f, -4.47163f, 0.152538f, 1.48682f, -4.47163f, 
		0.152538f, 1.48682f, -4.47163f, 0.152538f, 1.48682f, -4.47163f, 
		0.150325f, 1.48551f, -4.47338f, 0.150325f, 1.48551f, -4.47338f, 
		0.150325f, 1.48551f, -4.47338f, 0.150325f, 1.48551f, -4.47338f, 
		0.148423f, 1.48147f, -4.47489f, 0.148423f, 1.48147f, -4.47489f, 
		0.148423f, 1.48147f, -4.47489f, 0.148423f, 1.48147f, -4.47489f, 
		0.148729f, 1.48039f, -4.47465f, 0.148729f, 1.48039f, -4.47465f, 
		0.148729f, 1.48039f, -4.47465f, 0.148729f, 1.48039f, -4.47465f, 
		0.149886f, 1.47870f, -4.47373f, 0.149886f, 1.47870f, -4.47373f, 
		0.149886f, 1.47870f, -4.47373f, 0.149886f, 1.47870f, -4.47373f, 
		0.150145f, 1.47789f, -4.47352f, 0.150145f, 1.47789f, -4.47352f, 
		0.150145f, 1.47789f, -4.47352f, 0.150145f, 1.47789f, -4.47352f, 
		0.150216f, 1.47696f, -4.47347f, 0.150216f, 1.47696f, -4.47347f, 
		0.150216f, 1.47696f, -4.47347f, 0.150216f, 1.47696f, -4.47347f, 
		0.148697f, 1.47269f, -4.47467f, 0.148697f, 1.47269f, -4.47467f, 
		0.148697f, 1.47269f, -4.47467f, 0.148697f, 1.47269f, -4.47467f, 
		0.147886f, 1.47162f, -4.47531f, 0.147886f, 1.47162f, -4.47531f, 
		0.147886f, 1.47162f, -4.47531f, 0.147886f, 1.47162f, -4.47531f, 
		0.144552f, 1.46790f, -4.70436f, 0.144552f, 1.46790f, -4.70436f, 
		0.144550f, 1.46762f, -4.70436f, 0.144550f, 1.46762f, -4.70436f, 
		0.144548f, 1.46733f, -4.70436f, 0.144548f, 1.46733f, -4.70436f, 
		0.144546f, 1.46705f, -4.70436f, 0.144546f, 1.46705f, -4.70436f, 
		0.144544f, 1.46677f, -4.70436f, 0.144544f, 1.46677f, -4.70436f, 
		0.144543f, 1.46649f, -4.70436f, 0.144543f, 1.46649f, -4.70436f, 
		0.144541f, 1.46620f, -4.70436f, 0.144541f, 1.46620f, -4.70436f, 
		0.144539f, 1.46592f, -4.70436f, 0.144539f, 1.46592f, -4.70436f, 
		0.144537f, 1.46564f, -4.70436f, 0.144537f, 1.46564f, -4.70436f, 
		0.144535f, 1.46535f, -4.70436f, 0.144535f, 1.46535f, -4.70436f, 
		0.144533f, 1.46507f, -4.70436f, 0.144533f, 1.46507f, -4.70436f, 
		0.154105f, 1.46366f, -4.70432f, 0.154105f, 1.46366f, -4.70432f, 
		0.159199f, 1.45580f, -4.70431f, 0.159199f, 1.45580f, -4.70431f, 
		0.128294f, 1.45396f, -4.70441f, 0.128294f, 1.45396f, -4.70441f, 
		0.128283f, 1.46597f, -4.70441f, 0.128283f, 1.46597f, -4.70441f, 
		0.128249f, 1.47742f, -4.70441f, 0.128249f, 1.47742f, -4.70441f, 
		0.128197f, 1.48838f, -4.70441f, 0.128197f, 1.48838f, -4.70441f, 
		0.128128f, 1.49895f, -4.70441f, 0.128128f, 1.49895f, -4.70441f, 
		0.128046f, 1.50919f, -4.70441f, 0.128046f, 1.50919f, -4.70441f, 
		0.127955f, 1.51919f, -4.70441f, 0.127955f, 1.51919f, -4.70441f, 
		0.127857f, 1.52904f, -4.70441f, 0.127857f, 1.52904f, -4.70441f, 
		0.127756f, 1.53880f, -4.70441f, 0.127756f, 1.53880f, -4.70441f, 
		0.127655f, 1.54857f, -4.70441f, 0.127655f, 1.54857f, -4.70441f, 
		0.127558f, 1.55841f, -4.70441f, 0.127558f, 1.55841f, -4.70441f, 
		0.127466f, 1.56841f, -4.70441f, 0.127466f, 1.56841f, -4.70441f, 
		0.259994f, 1.57794f, -4.70396f, 0.259994f, 1.57794f, -4.70396f, 
		0.259990f, 1.57705f, -4.70396f, 0.259990f, 1.57705f, -4.70396f, 
		0.259985f, 1.57616f, -4.70396f, 0.259985f, 1.57616f, -4.70396f, 
		0.259981f, 1.57526f, -4.70396f, 0.259981f, 1.57526f, -4.70396f, 
		0.259976f, 1.57437f, -4.70396f, 0.259976f, 1.57437f, -4.70396f, 
		0.259972f, 1.57348f, -4.70396f, 0.259972f, 1.57348f, -4.70396f, 
		0.259967f, 1.57258f, -4.70396f, 0.259967f, 1.57258f, -4.70396f, 
		0.259963f, 1.57169f, -4.70396f, 0.259963f, 1.57169f, -4.70396f, 
		0.259958f, 1.57080f, -4.70396f, 0.259958f, 1.57080f, -4.70396f, 
		0.259954f, 1.56990f, -4.70396f, 0.259954f, 1.56990f, -4.70396f, 
		0.259950f, 1.56901f, -4.70396f, 0.259950f, 1.56901f, -4.70396f, 
		0.257356f, 1.56713f, -4.70397f, 0.257356f, 1.56713f, -4.70397f, 
		0.253002f, 1.56677f, -4.70398f, 0.253002f, 1.56677f, -4.70398f, 
		0.247288f, 1.56687f, -4.70400f, 0.247288f, 1.56687f, -4.70400f, 
		0.240624f, 1.56730f, -4.70403f, 0.240624f, 1.56730f, -4.70403f, 
		0.233418f, 1.56791f, -4.70405f, 0.233418f, 1.56791f, -4.70405f, 
		0.226076f, 1.56854f, -4.70408f, 0.226076f, 1.56854f, -4.70408f, 
		0.219007f, 1.56904f, -4.70410f, 0.219007f, 1.56904f, -4.70410f, 
		0.212618f, 1.56928f, -4.70412f, 0.212618f, 1.56928f, -4.70412f, 
		0.207318f, 1.56909f, -4.70414f, 0.207318f, 1.56909f, -4.70414f, 
		0.203514f, 1.56833f, -4.70415f, 0.203514f, 1.56833f, -4.70415f, 
		0.201615f, 1.56685f, -4.70416f, 0.201615f, 1.56685f, -4.70416f, 
		0.200751f, 1.56446f, -4.70416f, 0.200751f, 1.56446f, -4.70416f, 
		0.199427f, 1.56439f, -4.70417f, 0.199427f, 1.56439f, -4.70417f, 
		0.198100f, 1.56429f, -4.70417f, 0.198100f, 1.56429f, -4.70417f, 
		0.196811f, 1.56412f, -4.70418f, 0.196811f, 1.56412f, -4.70418f, 
		0.195603f, 1.56387f, -4.70418f, 0.195603f, 1.56387f, -4.70418f, 
		0.194521f, 1.56349f, -4.70418f, 0.194521f, 1.56349f, -4.70418f, 
		0.193606f, 1.56298f, -4.70419f, 0.193606f, 1.56298f, -4.70419f, 
		0.192903f, 1.56230f, -4.70419f, 0.192903f, 1.56230f, -4.70419f, 
		0.192453f, 1.56143f, -4.70419f, 0.192453f, 1.56143f, -4.70419f, 
		0.192301f, 1.56034f, -4.70419f, 0.192301f, 1.56034f, -4.70419f, 
		0.192489f, 1.55902f, -4.70419f, 0.192489f, 1.55902f, -4.70419f, 
		0.193060f, 1.55742f, -4.70419f, 0.193060f, 1.55742f, -4.70419f, 
		0.184649f, 1.54925f, -4.70422f, 0.184649f, 1.54925f, -4.70422f, 
		0.188775f, 1.54436f, -4.70420f, 0.188775f, 1.54436f, -4.70420f, 
		0.191262f, 1.53920f, -4.70420f, 0.191262f, 1.53920f, -4.70420f, 
		0.192263f, 1.53390f, -4.70419f, 0.192263f, 1.53390f, -4.70419f, 
		0.191932f, 1.52864f, -4.70419f, 0.191932f, 1.52864f, -4.70419f, 
		0.190423f, 1.52357f, -4.70420f, 0.190423f, 1.52357f, -4.70420f, 
		0.187891f, 1.51885f, -4.70421f, 0.187891f, 1.51885f, -4.70421f, 
		0.184488f, 1.51465f, -4.70422f, 0.184488f, 1.51465f, -4.70422f, 
		0.180370f, 1.51111f, -4.70423f, 0.180370f, 1.51111f, -4.70423f, 
		0.175689f, 1.50841f, -4.70425f, 0.175689f, 1.50841f, -4.70425f, 
		0.170601f, 1.50670f, -4.70427f, 0.170601f, 1.50670f, -4.70427f, 
		0.165258f, 1.50615f, -4.70429f, 0.165258f, 1.50615f, -4.70429f, 
		0.159887f, 1.49154f, -4.70430f, 0.159887f, 1.49154f, -4.70430f, 
		0.164436f, 1.48648f, -4.70429f, 0.164436f, 1.48648f, -4.70429f, 
		0.159348f, 1.48644f, -4.70431f, 0.159348f, 1.48644f, -4.70431f, 
		0.158050f, 1.48700f, -4.70431f, 0.158050f, 1.48700f, -4.70431f, 
		0.156715f, 1.48723f, -4.70431f, 0.156715f, 1.48723f, -4.70431f, 
		0.155387f, 1.48716f, -4.70432f, 0.155387f, 1.48716f, -4.70432f, 
		0.154109f, 1.48682f, -4.70432f, 0.154109f, 1.48682f, -4.70432f, 
		0.152926f, 1.48626f, -4.70433f, 0.152926f, 1.48626f, -4.70433f, 
		0.151882f, 1.48551f, -4.70433f, 0.151882f, 1.48551f, -4.70433f, 
		0.151020f, 1.48462f, -4.70433f, 0.151020f, 1.48462f, -4.70433f, 
		0.150384f, 1.48362f, -4.70434f, 0.150384f, 1.48362f, -4.70434f, 
		0.150018f, 1.48256f, -4.70434f, 0.150018f, 1.48256f, -4.70434f, 
		0.149967f, 1.48147f, -4.70434f, 0.149967f, 1.48147f, -4.70434f, 
		0.150275f, 1.48039f, -4.70434f, 0.150275f, 1.48039f, -4.70434f, 
		0.150984f, 1.47937f, -4.70433f, 0.150984f, 1.47937f, -4.70433f, 
		0.151439f, 1.47870f, -4.70433f, 0.151439f, 1.47870f, -4.70433f, 
		0.151701f, 1.47789f, -4.70433f, 0.151701f, 1.47789f, -4.70433f, 
		0.151772f, 1.47696f, -4.70433f, 0.151772f, 1.47696f, -4.70433f, 
		0.151658f, 1.47595f, -4.70433f, 0.151658f, 1.47595f, -4.70433f, 
		0.151362f, 1.47488f, -4.70433f, 0.151362f, 1.47488f, -4.70433f, 
		0.150889f, 1.47379f, -4.70433f, 0.150889f, 1.47379f, -4.70433f, 
		0.150243f, 1.47269f, -4.70434f, 0.150243f, 1.47269f, -4.70434f, 
		0.149427f, 1.47162f, -4.70434f, 0.149427f, 1.47162f, -4.70434f, 
		0.148446f, 1.47060f, -4.70434f, 0.148446f, 1.47060f, -4.70434f, 
		0.147304f, 1.46967f, -4.70435f, 0.147304f, 1.46967f, -4.70435f, 
		0.146005f, 1.46886f, -4.70435f, 0.146005f, 1.46886f, -4.70435f, 
		-1.35324f, 1.46818f, -4.70429f, -1.35324f, 1.46818f, -4.70429f, 
		0.144553f, 1.46818f, -4.70436f, 0.144553f, 1.46818f, -4.70436f, 
		0.143041f, 1.46762f, -4.47915f, 0.143041f, 1.46762f, -4.47915f, 
		0.143041f, 1.46762f, -4.47915f, 0.143041f, 1.46762f, -4.47915f, 
		0.143039f, 1.46733f, -4.47915f, 0.143039f, 1.46733f, -4.47915f, 
		0.143039f, 1.46733f, -4.47915f, 0.143039f, 1.46733f, -4.47915f, 
		0.143036f, 1.46677f, -4.47915f, 0.143036f, 1.46677f, -4.47915f, 
		0.143036f, 1.46677f, -4.47915f, 0.143036f, 1.46677f, -4.47915f, 
		0.143034f, 1.46649f, -4.47915f, 0.143034f, 1.46649f, -4.47915f, 
		0.143034f, 1.46649f, -4.47915f, 0.143034f, 1.46649f, -4.47915f, 
		0.143032f, 1.46620f, -4.47916f, 0.143032f, 1.46620f, -4.47916f, 
		0.143032f, 1.46620f, -4.47916f, 0.143032f, 1.46620f, -4.47916f, 
		0.143025f, 1.46507f, -4.47916f, 0.143025f, 1.46507f, -4.47916f, 
		0.143025f, 1.46507f, -4.47916f, 0.143025f, 1.46507f, -4.47916f, 
		0.143023f, 1.46479f, -4.47916f, 0.143023f, 1.46479f, -4.47916f, 
		0.143023f, 1.46479f, -4.47916f, 0.143023f, 1.46479f, -4.47916f, 
		-1.35259f, 1.46479f, -4.47937f, -1.35259f, 1.46479f, -4.47937f, 
		-1.35259f, 1.46479f, -4.47937f, -1.35259f, 1.46479f, -4.47937f, 
		-1.35259f, 1.46507f, -4.47937f, -1.35259f, 1.46507f, -4.47937f, 
		-1.35259f, 1.46507f, -4.47937f, -1.35259f, 1.46507f, -4.47937f, 
		-1.35259f, 1.46564f, -4.47937f, -1.35259f, 1.46564f, -4.47937f, 
		-1.35259f, 1.46564f, -4.47937f, -1.35259f, 1.46564f, -4.47937f, 
		-1.35260f, 1.46677f, -4.47936f, -1.35260f, 1.46677f, -4.47936f, 
		-1.35260f, 1.46677f, -4.47936f, -1.35260f, 1.46677f, -4.47936f, 
		-1.35260f, 1.46705f, -4.47936f, -1.35260f, 1.46705f, -4.47936f, 
		-1.35260f, 1.46705f, -4.47936f, -1.35260f, 1.46705f, -4.47936f, 
		-1.35260f, 1.46733f, -4.47936f, -1.35260f, 1.46733f, -4.47936f, 
		-1.35260f, 1.46733f, -4.47936f, -1.35260f, 1.46733f, -4.47936f, 
		-1.35261f, 1.46762f, -4.47936f, -1.35261f, 1.46762f, -4.47936f, 
		-1.35261f, 1.46762f, -4.47936f, -1.35261f, 1.46762f, -4.47936f, 
		-1.35261f, 1.46790f, -4.47936f, -1.35261f, 1.46790f, -4.47936f, 
		-1.35261f, 1.46790f, -4.47936f, -1.35261f, 1.46790f, -4.47936f, 
		-1.35322f, 1.46479f, -4.70429f, -1.35322f, 1.46479f, -4.70429f, 
		0.144531f, 1.46479f, -4.70436f, 0.144531f, 1.46479f, -4.70436f, 
		-1.36252f, 1.46366f, -4.70427f, -1.36252f, 1.46366f, -4.70427f, 
		-1.36210f, 1.46366f, -4.47185f, -1.36210f, 1.46366f, -4.47185f, 
		-1.36210f, 1.46366f, -4.47185f, -1.36210f, 1.46366f, -4.47185f, 
		0.152534f, 1.46366f, -4.47163f, 0.152534f, 1.46366f, -4.47163f, 
		0.152534f, 1.46366f, -4.47163f, 0.152534f, 1.46366f, -4.47163f, 
		0.141536f, 1.44763f, -4.48034f, 0.141536f, 1.44763f, -4.48034f, 
		0.141536f, 1.44763f, -4.48034f, 0.141536f, 1.44763f, -4.48034f, 
		0.126891f, 1.45396f, -4.49193f, 0.126891f, 1.45396f, -4.49193f, 
		0.126891f, 1.45396f, -4.49193f, 0.126891f, 1.45396f, -4.49193f, 
		0.126880f, 1.46597f, -4.49194f, 0.126880f, 1.46597f, -4.49194f, 
		0.126880f, 1.46597f, -4.49194f, 0.126880f, 1.46597f, -4.49194f, 
		0.126794f, 1.48838f, -4.49201f, 0.126794f, 1.48838f, -4.49201f, 
		0.126794f, 1.48838f, -4.49201f, 0.126794f, 1.48838f, -4.49201f, 
		0.126645f, 1.50919f, -4.49213f, 0.126645f, 1.50919f, -4.49213f, 
		0.126645f, 1.50919f, -4.49213f, 0.126645f, 1.50919f, -4.49213f, 
		0.126554f, 1.51919f, -4.49220f, 0.126554f, 1.51919f, -4.49220f, 
		0.126554f, 1.51919f, -4.49220f, 0.126554f, 1.51919f, -4.49220f, 
		0.126257f, 1.54857f, -4.49244f, 0.126257f, 1.54857f, -4.49244f, 
		0.126257f, 1.54857f, -4.49244f, 0.126257f, 1.54857f, -4.49244f, 
		0.125988f, 1.57866f, -4.49265f, 0.125988f, 1.57866f, -4.49265f, 
		0.125988f, 1.57866f, -4.49265f, 0.125988f, 1.57866f, -4.49265f, 
		-1.33556f, 1.57866f, -4.49286f, -1.33556f, 1.57866f, -4.49286f, 
		-1.33556f, 1.57866f, -4.49286f, -1.33556f, 1.57866f, -4.49286f, 
		-1.33564f, 1.56841f, -4.49279f, -1.33564f, 1.56841f, -4.49279f, 
		-1.33564f, 1.56841f, -4.49279f, -1.33564f, 1.56841f, -4.49279f, 
		-1.33573f, 1.55841f, -4.49272f, -1.33573f, 1.55841f, -4.49272f, 
		-1.33573f, 1.55841f, -4.49272f, -1.33573f, 1.55841f, -4.49272f, 
		-1.33593f, 1.53880f, -4.49257f, -1.33593f, 1.53880f, -4.49257f, 
		-1.33593f, 1.53880f, -4.49257f, -1.33593f, 1.53880f, -4.49257f, 
		-1.33630f, 1.49895f, -4.49227f, -1.33630f, 1.49895f, -4.49227f, 
		-1.33630f, 1.49895f, -4.49227f, -1.33630f, 1.49895f, -4.49227f, 
		-1.33637f, 1.48838f, -4.49222f, -1.33637f, 1.48838f, -4.49222f, 
		-1.33637f, 1.48838f, -4.49222f, -1.33637f, 1.48838f, -4.49222f, 
		-1.33642f, 1.47742f, -4.49218f, -1.33642f, 1.47742f, -4.49218f, 
		-1.33642f, 1.47742f, -4.49218f, -1.33642f, 1.47742f, -4.49218f, 
		-1.33645f, 1.46597f, -4.49215f, -1.33645f, 1.46597f, -4.49215f, 
		-1.33645f, 1.46597f, -4.49215f, -1.33645f, 1.46597f, -4.49215f, 
		-1.35110f, 1.44763f, -4.48055f, -1.35110f, 1.44763f, -4.48055f, 
		-1.35110f, 1.44763f, -4.48055f, -1.35110f, 1.44763f, -4.48055f, 
		0.157595f, 1.45580f, -4.46763f, 0.157595f, 1.45580f, -4.46763f, 
		0.157595f, 1.45580f, -4.46763f, 0.157595f, 1.45580f, -4.46763f, 
		-1.33657f, 1.57866f, -4.70432f, -1.33657f, 1.57866f, -4.70432f, 
		0.127385f, 1.57866f, -4.70441f, 0.127385f, 1.57866f, -4.70441f, 
		0.143034f, 1.44763f, -4.70436f, 0.143034f, 1.44763f, -4.70436f, 
		-1.36747f, 1.45580f, -4.70425f, -1.36747f, 1.45580f, -4.70425f, 
		-1.36715f, 1.45580f, -4.46784f, -1.36715f, 1.45580f, -4.46784f, 
		-1.36715f, 1.45580f, -4.46784f, -1.36715f, 1.45580f, -4.46784f, 
		-1.46538f, 1.57884f, -4.70404f, -1.46538f, 1.57884f, -4.70404f, 
		0.259999f, 1.57884f, -4.70396f, 0.259999f, 1.57884f, -4.70396f, 
		0.257730f, 1.57705f, -4.38835f, 0.257730f, 1.57705f, -4.38835f, 
		0.257730f, 1.57705f, -4.38835f, 0.257730f, 1.57705f, -4.38835f, 
		0.257726f, 1.57616f, -4.38835f, 0.257726f, 1.57616f, -4.38835f, 
		0.257726f, 1.57616f, -4.38835f, 0.257726f, 1.57616f, -4.38835f, 
		0.257721f, 1.57526f, -4.38835f, 0.257721f, 1.57526f, -4.38835f, 
		0.257721f, 1.57526f, -4.38835f, 0.257721f, 1.57526f, -4.38835f, 
		0.257713f, 1.57348f, -4.38836f, 0.257713f, 1.57348f, -4.38836f, 
		0.257713f, 1.57348f, -4.38836f, 0.257713f, 1.57348f, -4.38836f, 
		0.257708f, 1.57258f, -4.38836f, 0.257708f, 1.57258f, -4.38836f, 
		0.257708f, 1.57258f, -4.38836f, 0.257708f, 1.57258f, -4.38836f, 
		0.257703f, 1.57169f, -4.38837f, 0.257703f, 1.57169f, -4.38837f, 
		0.257703f, 1.57169f, -4.38837f, 0.257703f, 1.57169f, -4.38837f, 
		0.257699f, 1.57080f, -4.38837f, 0.257699f, 1.57080f, -4.38837f, 
		0.257699f, 1.57080f, -4.38837f, 0.257699f, 1.57080f, -4.38837f, 
		0.257695f, 1.56990f, -4.38837f, 0.257695f, 1.56990f, -4.38837f, 
		0.257695f, 1.56990f, -4.38837f, 0.257695f, 1.56990f, -4.38837f, 
		0.259945f, 1.56812f, -4.70396f, 0.259945f, 1.56812f, -4.70396f, 
		-1.46726f, 1.57794f, -4.38859f, -1.46726f, 1.57794f, -4.38859f, 
		-1.46726f, 1.57794f, -4.38859f, -1.46726f, 1.57794f, -4.38859f, 
		-1.46724f, 1.57437f, -4.38860f, -1.46724f, 1.57437f, -4.38860f, 
		-1.46724f, 1.57437f, -4.38860f, -1.46724f, 1.57437f, -4.38860f, 
		-1.46722f, 1.57080f, -4.38862f, -1.46722f, 1.57080f, -4.38862f, 
		-1.46722f, 1.57080f, -4.38862f, -1.46722f, 1.57080f, -4.38862f, 
		-1.46722f, 1.56990f, -4.38862f, -1.46722f, 1.56990f, -4.38862f, 
		-1.46722f, 1.56990f, -4.38862f, -1.46722f, 1.56990f, -4.38862f, 
		-1.46721f, 1.56901f, -4.38862f, -1.46721f, 1.56901f, -4.38862f, 
		-1.46721f, 1.56901f, -4.38862f, -1.46721f, 1.56901f, -4.38862f, 
		-1.46532f, 1.56812f, -4.70404f, -1.46532f, 1.56812f, -4.70404f, 
		0.201622f, 1.56833f, -4.43277f, 0.201622f, 1.56833f, -4.43277f, 
		0.201622f, 1.56833f, -4.43277f, 0.201622f, 1.56833f, -4.43277f, 
		0.199735f, 1.56685f, -4.43426f, 0.199735f, 1.56685f, -4.43426f, 
		0.199735f, 1.56685f, -4.43426f, 0.199735f, 1.56685f, -4.43426f, 
		0.200144f, 1.56450f, -4.43394f, 0.200144f, 1.56450f, -4.43394f, 
		0.200144f, 1.56450f, -4.43394f, 0.200144f, 1.56450f, -4.43394f, 
		-1.40969f, 1.56450f, -4.43417f, -1.40969f, 1.56450f, -4.43417f, 
		-1.40969f, 1.56450f, -4.43417f, -1.40969f, 1.56450f, -4.43417f, 
		0.202027f, 1.56450f, -4.70416f, 0.202027f, 1.56450f, -4.70416f, 
		-1.40028f, 1.54923f, -4.70418f, -1.40028f, 1.54923f, -4.70418f, 
		-1.40018f, 1.56143f, -4.44169f, -1.40018f, 1.56143f, -4.44169f, 
		-1.40018f, 1.56143f, -4.44169f, -1.40018f, 1.56143f, -4.44169f, 
		-1.40223f, 1.56349f, -4.44007f, -1.40223f, 1.56349f, -4.44007f, 
		-1.40223f, 1.56349f, -4.44007f, -1.40223f, 1.56349f, -4.44007f, 
		0.191157f, 1.54923f, -4.44105f, 0.191157f, 1.54923f, -4.44105f, 
		0.191157f, 1.54923f, -4.44105f, 0.191157f, 1.54923f, -4.44105f, 
		0.190482f, 1.56034f, -4.44159f, 0.190482f, 1.56034f, -4.44159f, 
		0.190482f, 1.56034f, -4.44159f, 0.190482f, 1.56034f, -4.44159f, 
		0.191778f, 1.56298f, -4.44056f, 0.191778f, 1.56298f, -4.44056f, 
		0.191778f, 1.56298f, -4.44056f, 0.191778f, 1.56298f, -4.44056f, 
		0.192687f, 1.56349f, -4.43984f, 0.192687f, 1.56349f, -4.43984f, 
		0.192687f, 1.56349f, -4.43984f, 0.192687f, 1.56349f, -4.43984f, 
		0.192981f, 1.54923f, -4.70419f, 0.192981f, 1.54923f, -4.70419f, 
		0.182879f, 1.54925f, -4.44761f, 0.182879f, 1.54925f, -4.44761f, 
		0.182879f, 1.54925f, -4.44761f, 0.182879f, 1.54925f, -4.44761f, 
		0.189449f, 1.53920f, -4.44241f, 0.189449f, 1.53920f, -4.44241f, 
		0.189449f, 1.53920f, -4.44241f, 0.189449f, 1.53920f, -4.44241f, 
		0.190444f, 1.53390f, -4.44162f, 0.190444f, 1.53390f, -4.44162f, 
		0.190444f, 1.53390f, -4.44162f, 0.190444f, 1.53390f, -4.44162f, 
		0.190115f, 1.52864f, -4.44188f, 0.190115f, 1.52864f, -4.44188f, 
		0.190115f, 1.52864f, -4.44188f, 0.190115f, 1.52864f, -4.44188f, 
		0.188616f, 1.52357f, -4.44307f, 0.188616f, 1.52357f, -4.44307f, 
		0.188616f, 1.52357f, -4.44307f, 0.188616f, 1.52357f, -4.44307f, 
		0.186100f, 1.51885f, -4.44506f, 0.186100f, 1.51885f, -4.44506f, 
		0.186100f, 1.51885f, -4.44506f, 0.186100f, 1.51885f, -4.44506f, 
		0.182720f, 1.51465f, -4.44773f, 0.182720f, 1.51465f, -4.44773f, 
		0.182720f, 1.51465f, -4.44773f, 0.182720f, 1.51465f, -4.44773f, 
		0.178628f, 1.51111f, -4.45097f, 0.178628f, 1.51111f, -4.45097f, 
		0.178628f, 1.51111f, -4.45097f, 0.178628f, 1.51111f, -4.45097f, 
		-1.39653f, 1.54436f, -4.44459f, -1.39653f, 1.54436f, -4.44459f, 
		-1.39653f, 1.54436f, -4.44459f, -1.39653f, 1.54436f, -4.44459f, 
		-1.39900f, 1.53920f, -4.44263f, -1.39900f, 1.53920f, -4.44263f, 
		-1.39900f, 1.53920f, -4.44263f, -1.39900f, 1.53920f, -4.44263f, 
		-1.39565f, 1.51885f, -4.44528f, -1.39565f, 1.51885f, -4.44528f, 
		-1.39565f, 1.51885f, -4.44528f, -1.39565f, 1.51885f, -4.44528f, 
		-1.39227f, 1.51465f, -4.44796f, -1.39227f, 1.51465f, -4.44796f, 
		-1.39227f, 1.51465f, -4.44796f, -1.39227f, 1.51465f, -4.44796f, 
		-1.38818f, 1.51111f, -4.45120f, -1.38818f, 1.51111f, -4.45120f, 
		-1.38818f, 1.51111f, -4.45120f, -1.38818f, 1.51111f, -4.45120f, 
		-1.38353f, 1.50841f, -4.45488f, -1.38353f, 1.50841f, -4.45488f, 
		-1.38353f, 1.50841f, -4.45488f, -1.38353f, 1.50841f, -4.45488f, 
		-1.36807f, 1.50690f, -4.70425f, -1.36807f, 1.50690f, -4.70425f, 
		0.159815f, 1.50690f, -4.70430f, 0.159815f, 1.50690f, -4.70430f, 
		-1.36814f, 1.49154f, -4.70425f, -1.36814f, 1.49154f, -4.70425f, 
		-1.37236f, 1.49153f, -4.46372f, -1.37236f, 1.49153f, -4.46372f, 
		-1.37236f, 1.49153f, -4.46372f, -1.37236f, 1.49153f, -4.46372f, 
		0.164439f, 1.49153f, -4.70429f, 0.164439f, 1.49153f, -4.70429f, 
		-1.37235f, 1.48648f, -4.46372f, -1.37235f, 1.48648f, -4.46372f, 
		-1.37235f, 1.48648f, -4.46372f, -1.37235f, 1.48648f, -4.46372f, 
		-1.35261f, 1.46818f, -4.47936f, -1.35261f, 1.46818f, -4.47936f, 
		-1.35261f, 1.46818f, -4.47936f, -1.35261f, 1.46818f, -4.47936f, 
		-1.35648f, 1.47060f, -4.47630f, -1.35648f, 1.47060f, -4.47630f, 
		-1.35648f, 1.47060f, -4.47630f, -1.35648f, 1.47060f, -4.47630f, 
		-1.35826f, 1.47269f, -4.47488f, -1.35826f, 1.47269f, -4.47488f, 
		-1.35826f, 1.47269f, -4.47488f, -1.35826f, 1.47269f, -4.47488f, 
		-1.35937f, 1.47488f, -4.47400f, -1.35937f, 1.47488f, -4.47400f, 
		-1.35937f, 1.47488f, -4.47400f, -1.35937f, 1.47488f, -4.47400f, 
		-1.35967f, 1.47595f, -4.47377f, -1.35967f, 1.47595f, -4.47377f, 
		-1.35967f, 1.47595f, -4.47377f, -1.35967f, 1.47595f, -4.47377f, 
		-1.35978f, 1.47696f, -4.47368f, -1.35978f, 1.47696f, -4.47368f, 
		-1.35978f, 1.47696f, -4.47368f, -1.35978f, 1.47696f, -4.47368f, 
		-1.35971f, 1.47789f, -4.47374f, -1.35971f, 1.47789f, -4.47374f, 
		-1.35971f, 1.47789f, -4.47374f, -1.35971f, 1.47789f, -4.47374f, 
		-1.35804f, 1.48256f, -4.47506f, -1.35804f, 1.48256f, -4.47506f, 
		-1.35804f, 1.48256f, -4.47506f, -1.35804f, 1.48256f, -4.47506f, 
		-1.35840f, 1.48362f, -4.47477f, -1.35840f, 1.48362f, -4.47477f, 
		-1.35840f, 1.48362f, -4.47477f, -1.35840f, 1.48362f, -4.47477f, 
		-1.35903f, 1.48462f, -4.47427f, -1.35903f, 1.48462f, -4.47427f, 
		-1.35903f, 1.48462f, -4.47427f, -1.35903f, 1.48462f, -4.47427f, 
		0.144487f, 1.46886f, -4.47800f, 0.144487f, 1.46886f, -4.47800f, 
		0.144487f, 1.46886f, -4.47800f, 0.144487f, 1.46886f, -4.47800f, 
		0.145777f, 1.46967f, -4.47698f, 0.145777f, 1.46967f, -4.47698f, 
		0.145777f, 1.46967f, -4.47698f, 0.145777f, 1.46967f, -4.47698f, 
		0.146912f, 1.47060f, -4.47608f, 0.146912f, 1.47060f, -4.47608f, 
		0.146912f, 1.47060f, -4.47608f, 0.146912f, 1.47060f, -4.47608f, 
		0.149339f, 1.47379f, -4.47416f, 0.149339f, 1.47379f, -4.47416f, 
		0.149339f, 1.47379f, -4.47416f, 0.149339f, 1.47379f, -4.47416f, 
		0.149809f, 1.47488f, -4.47379f, 0.149809f, 1.47488f, -4.47379f, 
		0.149809f, 1.47488f, -4.47379f, 0.149809f, 1.47488f, -4.47379f, 
		0.150103f, 1.47595f, -4.47356f, 0.150103f, 1.47595f, -4.47356f, 
		0.150103f, 1.47595f, -4.47356f, 0.150103f, 1.47595f, -4.47356f, 
		0.149434f, 1.47937f, -4.47409f, 0.149434f, 1.47937f, -4.47409f, 
		0.149434f, 1.47937f, -4.47409f, 0.149434f, 1.47937f, -4.47409f, 
		0.148474f, 1.48256f, -4.47485f, 0.148474f, 1.48256f, -4.47485f, 
		0.148474f, 1.48256f, -4.47485f, 0.148474f, 1.48256f, -4.47485f, 
		0.148837f, 1.48362f, -4.47456f, 0.148837f, 1.48362f, -4.47456f, 
		0.148837f, 1.48362f, -4.47456f, 0.148837f, 1.48362f, -4.47456f, 
		0.149469f, 1.48462f, -4.47406f, 0.149469f, 1.48462f, -4.47406f, 
		0.149469f, 1.48462f, -4.47406f, 0.149469f, 1.48462f, -4.47406f, 
		0.151363f, 1.48626f, -4.47256f, 0.151363f, 1.48626f, -4.47256f, 
		0.151363f, 1.48626f, -4.47256f, 0.151363f, 1.48626f, -4.47256f, 
		-0.0327060f, 1.32546f, -4.50405f, 0.0215860f, 1.39369f, -4.50405f, 
		0.0216600f, 1.39379f, -4.49860f, 0.0206780f, 1.39255f, -4.49865f, 
		0.0195790f, 1.39117f, -4.49881f, 0.0184020f, 1.38969f, -4.49906f, 
		0.0171870f, 1.38817f, -4.49935f, 0.0159720f, 1.38664f, -4.49963f, 
		0.0147960f, 1.38516f, -4.49988f, 0.0136970f, 1.38378f, -4.50004f, 
		0.0127150f, 1.38254f, -4.50009f, 0.0118870f, 1.38150f, -4.49997f, 
		0.0112530f, 1.38071f, -4.49966f, 0.0108520f, 1.38020f, -4.49910f, 
		0.0107230f, 1.38004f, -4.49826f, 0.0107010f, 1.38001f, -4.49725f, 
		0.0105950f, 1.37988f, -4.49650f, 0.0104090f, 1.37965f, -4.49595f, 
		0.0101460f, 1.37932f, -4.49559f, 0.00981100f, 1.37890f, -4.49537f, 
		0.00940700f, 1.37839f, -4.49526f, 0.00893700f, 1.37780f, -4.49522f, 
		0.00840700f, 1.37713f, -4.49521f, 0.00782000f, 1.37639f, -4.49521f, 
		0.00717900f, 1.37559f, -4.49516f, 0.00648800f, 1.37472f, -4.49505f, 
		0.00575200f, 1.37379f, -4.49483f, 0.00497300f, 1.37282f, -4.49450f, 
		0.00415500f, 1.37179f, -4.49413f, 0.00330100f, 1.37071f, -4.49371f, 
		0.00241500f, 1.36960f, -4.49327f, 0.00149900f, 1.36845f, -4.49283f, 
		0.000559000f, 1.36727f, -4.49239f, -0.000403000f, 1.36606f, -4.49197f, 
		-0.00138300f, 1.36483f, -4.49160f, -0.00237800f, 1.36357f, -4.49128f, 
		-0.00338400f, 1.36231f, -4.49104f, -0.00439800f, 1.36104f, -4.49088f, 
		-0.00541500f, 1.35976f, -4.49083f, -0.00643300f, 1.35848f, -4.49089f, 
		-0.00744700f, 1.35720f, -4.49106f, -0.00845500f, 1.35594f, -4.49131f, 
		-0.00945200f, 1.35468f, -4.49164f, -0.0104360f, 1.35345f, -4.49203f, 
		-0.0114020f, 1.35223f, -4.49245f, -0.0123470f, 1.35105f, -4.49290f, 
		-0.0132670f, 1.34989f, -4.49336f, -0.0141600f, 1.34877f, -4.49380f, 
		-0.0150210f, 1.34768f, -4.49423f, -0.0158460f, 1.34665f, -4.49462f, 
		-0.0166330f, 1.34566f, -4.49494f, -0.0173780f, 1.34472f, -4.49517f, 
		-0.0180770f, 1.34384f, -4.49529f, -0.0187260f, 1.34303f, -4.49534f, 
		-0.0193220f, 1.34228f, -4.49535f, -0.0198610f, 1.34160f, -4.49536f, 
		-0.0203410f, 1.34100f, -4.49541f, -0.0207570f, 1.34047f, -4.49552f, 
		-0.0211060f, 1.34004f, -4.49574f, -0.0213840f, 1.33969f, -4.49611f, 
		-0.0215880f, 1.33943f, -4.49664f, -0.0217140f, 1.33927f, -4.49740f, 
		-0.0217590f, 1.33922f, -4.49840f, -0.0219060f, 1.33903f, -4.49921f, 
		-0.0223170f, 1.33851f, -4.49975f, -0.0229540f, 1.33771f, -4.50005f, 
		-0.0237800f, 1.33668f, -4.50015f, -0.0247560f, 1.33545f, -4.50009f, 
		-0.0258450f, 1.33408f, -4.49992f, -0.0270090f, 1.33262f, -4.49967f, 
		-0.0282110f, 1.33111f, -4.49938f, -0.0294130f, 1.32959f, -4.49909f, 
		-0.0305780f, 1.32813f, -4.49884f, -0.0316670f, 1.32676f, -4.49867f, 
		-0.0326430f, 1.32554f, -4.49861f, -0.0326480f, 1.32553f, -4.49899f, 
		-0.0326530f, 1.32552f, -4.49941f, -0.0326590f, 1.32552f, -4.49986f, 
		-0.0326640f, 1.32551f, -4.50034f, -0.0326690f, 1.32550f, -4.50083f, 
		-0.0326740f, 1.32550f, -4.50133f, -0.0326800f, 1.32549f, -4.50183f, 
		-0.0326850f, 1.32548f, -4.50233f, -0.0326900f, 1.32548f, -4.50280f, 
		-0.0326960f, 1.32547f, -4.50325f, -0.0327010f, 1.32546f, -4.50367f, 
		-0.0331320f, 1.22408f, -4.50405f, 0.0208740f, 1.22392f, -4.50405f, 
		0.0209470f, 1.22392f, -4.49860f, 0.0199700f, 1.22393f, -4.49865f, 
		0.0188770f, 1.22393f, -4.49881f, 0.0177070f, 1.22393f, -4.49906f, 
		0.0164980f, 1.22394f, -4.49935f, 0.0152900f, 1.22394f, -4.49963f, 
		0.0141190f, 1.22394f, -4.49988f, 0.0130260f, 1.22395f, -4.50004f, 
		0.0120490f, 1.22395f, -4.50009f, 0.0112260f, 1.22395f, -4.49997f, 
		0.0105960f, 1.22395f, -4.49966f, 0.0101970f, 1.22396f, -4.49910f, 
		0.0100680f, 1.22396f, -4.49826f, 0.0100460f, 1.22396f, -4.49725f, 
		0.00994100f, 1.22396f, -4.49650f, 0.00975600f, 1.22396f, -4.49595f, 
		0.00949400f, 1.22396f, -4.49559f, 0.00916100f, 1.22396f, -4.49537f, 
		0.00875900f, 1.22396f, -4.49526f, 0.00829200f, 1.22396f, -4.49522f, 
		0.00776400f, 1.22396f, -4.49521f, 0.00718000f, 1.22396f, -4.49521f, 
		0.00654200f, 1.22397f, -4.49516f, 0.00585600f, 1.22397f, -4.49505f, 
		0.00512300f, 1.22397f, -4.49483f, 0.00434900f, 1.22397f, -4.49450f, 
		0.00353500f, 1.22397f, -4.49413f, 0.00268500f, 1.22398f, -4.49371f, 
		0.00180400f, 1.22398f, -4.49327f, 0.000893000f, 1.22398f, -4.49283f, 
		-4.20000e-005f, 1.22398f, -4.49239f, -0.000999000f, 1.22399f, -4.49197f, 
		-0.00197400f, 1.22399f, -4.49160f, -0.00296400f, 1.22399f, -4.49128f, 
		-0.00396500f, 1.22400f, -4.49104f, -0.00497300f, 1.22400f, -4.49088f, 
		-0.00598500f, 1.22400f, -4.49083f, -0.00699700f, 1.22400f, -4.49089f, 
		-0.00800600f, 1.22401f, -4.49106f, -0.00900800f, 1.22401f, -4.49131f, 
		-0.0100000f, 1.22401f, -4.49164f, -0.0109790f, 1.22402f, -4.49203f, 
		-0.0119400f, 1.22402f, -4.49245f, -0.0128800f, 1.22402f, -4.49290f, 
		-0.0137960f, 1.22402f, -4.49336f, -0.0146830f, 1.22403f, -4.49380f, 
		-0.0155400f, 1.22403f, -4.49423f, -0.0163610f, 1.22403f, -4.49462f, 
		-0.0171440f, 1.22403f, -4.49494f, -0.0178840f, 1.22404f, -4.49517f, 
		-0.0185790f, 1.22404f, -4.49529f, -0.0192250f, 1.22404f, -4.49534f, 
		-0.0198180f, 1.22404f, -4.49535f, -0.0203550f, 1.22404f, -4.49536f, 
		-0.0208320f, 1.22405f, -4.49541f, -0.0212450f, 1.22405f, -4.49552f, 
		-0.0215920f, 1.22405f, -4.49574f, -0.0218690f, 1.22405f, -4.49611f, 
		-0.0220720f, 1.22405f, -4.49664f, -0.0221980f, 1.22405f, -4.49740f, 
		-0.0222430f, 1.22405f, -4.49840f, -0.0223890f, 1.22405f, -4.49921f, 
		-0.0227980f, 1.22405f, -4.49975f, -0.0234310f, 1.22405f, -4.50005f, 
		-0.0242520f, 1.22405f, -4.50015f, -0.0252230f, 1.22406f, -4.50009f, 
		-0.0263060f, 1.22406f, -4.49992f, -0.0274650f, 1.22406f, -4.49967f, 
		-0.0286600f, 1.22407f, -4.49938f, -0.0298560f, 1.22407f, -4.49909f, 
		-0.0310140f, 1.22407f, -4.49884f, -0.0320980f, 1.22408f, -4.49867f, 
		-0.0330680f, 1.22408f, -4.49861f, -0.0330740f, 1.22408f, -4.49899f, 
		-0.0330790f, 1.22408f, -4.49941f, -0.0330840f, 1.22408f, -4.49986f, 
		-0.0330900f, 1.22408f, -4.50034f, -0.0330950f, 1.22408f, -4.50083f, 
		-0.0331000f, 1.22408f, -4.50133f, -0.0331050f, 1.22408f, -4.50183f, 
		-0.0331110f, 1.22408f, -4.50233f, -0.0331160f, 1.22408f, -4.50280f, 
		-0.0331210f, 1.22408f, -4.50325f, -0.0331260f, 1.22408f, -4.50367f, 
		-0.0331000f, 1.17181f, -4.50405f, 0.0209050f, 1.17188f, -4.50405f, 
		0.0209790f, 1.17188f, -4.49860f, 0.0200010f, 1.17188f, -4.49865f, 
		0.0189080f, 1.17187f, -4.49881f, 0.0177380f, 1.17187f, -4.49906f, 
		0.0165300f, 1.17187f, -4.49935f, 0.0153210f, 1.17187f, -4.49963f, 
		0.0141510f, 1.17187f, -4.49988f, 0.0130580f, 1.17187f, -4.50004f, 
		0.0120800f, 1.17186f, -4.50009f, 0.0112570f, 1.17186f, -4.49997f, 
		0.0106270f, 1.17186f, -4.49966f, 0.0102280f, 1.17186f, -4.49910f, 
		0.0100990f, 1.17186f, -4.49826f, 0.0100780f, 1.17186f, -4.49725f, 
		0.00997200f, 1.17186f, -4.49650f, 0.00978700f, 1.17186f, -4.49595f, 
		0.00952600f, 1.17186f, -4.49559f, 0.00919200f, 1.17186f, -4.49537f, 
		0.00879000f, 1.17186f, -4.49526f, 0.00832300f, 1.17186f, -4.49522f, 
		0.00779600f, 1.17186f, -4.49521f, 0.00721100f, 1.17186f, -4.49521f, 
		0.00657400f, 1.17186f, -4.49516f, 0.00588700f, 1.17186f, -4.49505f, 
		0.00515500f, 1.17186f, -4.49483f, 0.00438000f, 1.17185f, -4.49450f, 
		0.00356600f, 1.17185f, -4.49413f, 0.00271700f, 1.17185f, -4.49371f, 
		0.00183500f, 1.17185f, -4.49327f, 0.000925000f, 1.17185f, -4.49283f, 
		-1.10000e-005f, 1.17185f, -4.49239f, -0.000968000f, 1.17185f, -4.49197f, 
		-0.00194300f, 1.17185f, -4.49160f, -0.00293300f, 1.17185f, -4.49128f, 
		-0.00393300f, 1.17184f, -4.49104f, -0.00494100f, 1.17184f, -4.49088f, 
		-0.00595300f, 1.17184f, -4.49083f, -0.00696500f, 1.17184f, -4.49089f, 
		-0.00797500f, 1.17184f, -4.49106f, -0.00897700f, 1.17184f, -4.49131f, 
		-0.00996900f, 1.17184f, -4.49164f, -0.0109470f, 1.17184f, -4.49203f, 
		-0.0119080f, 1.17183f, -4.49245f, -0.0128480f, 1.17183f, -4.49290f, 
		-0.0137640f, 1.17183f, -4.49336f, -0.0146520f, 1.17183f, -4.49380f, 
		-0.0155080f, 1.17183f, -4.49423f, -0.0163300f, 1.17183f, -4.49462f, 
		-0.0171120f, 1.17183f, -4.49494f, -0.0178530f, 1.17183f, -4.49517f, 
		-0.0185480f, 1.17183f, -4.49529f, -0.0191940f, 1.17183f, -4.49534f, 
		-0.0197870f, 1.17183f, -4.49535f, -0.0203230f, 1.17183f, -4.49536f, 
		-0.0208000f, 1.17182f, -4.49541f, -0.0212140f, 1.17182f, -4.49552f, 
		-0.0215610f, 1.17182f, -4.49574f, -0.0218380f, 1.17182f, -4.49611f, 
		-0.0220410f, 1.17182f, -4.49664f, -0.0221660f, 1.17182f, -4.49740f, 
		-0.0222110f, 1.17182f, -4.49840f, -0.0223580f, 1.17182f, -4.49921f, 
		-0.0227660f, 1.17182f, -4.49975f, -0.0234000f, 1.17182f, -4.50005f, 
		-0.0242210f, 1.17182f, -4.50015f, -0.0251920f, 1.17182f, -4.50009f, 
		-0.0262750f, 1.17182f, -4.49992f, -0.0274330f, 1.17182f, -4.49967f, 
		-0.0286290f, 1.17181f, -4.49938f, -0.0298250f, 1.17181f, -4.49909f, 
		-0.0309830f, 1.17181f, -4.49884f, -0.0320660f, 1.17181f, -4.49867f, 
		-0.0330370f, 1.17181f, -4.49861f, -0.0330420f, 1.17181f, -4.49899f, 
		-0.0330480f, 1.17181f, -4.49941f, -0.0330530f, 1.17181f, -4.49986f, 
		-0.0330580f, 1.17181f, -4.50034f, -0.0330630f, 1.17181f, -4.50083f, 
		-0.0330690f, 1.17181f, -4.50133f, -0.0330740f, 1.17181f, -4.50183f, 
		-0.0330790f, 1.17181f, -4.50233f, -0.0330850f, 1.17181f, -4.50280f, 
		-0.0330900f, 1.17181f, -4.50325f, -0.0330950f, 1.17181f, -4.50367f, 
		-0.0330490f, 1.11914f, -4.50405f, 0.0209560f, 1.11924f, -4.50405f, 
		0.0210290f, 1.11924f, -4.49860f, 0.0200520f, 1.11923f, -4.49865f, 
		0.0189590f, 1.11923f, -4.49881f, 0.0177890f, 1.11923f, -4.49906f, 
		0.0165800f, 1.11923f, -4.49935f, 0.0153710f, 1.11923f, -4.49963f, 
		0.0142010f, 1.11922f, -4.49988f, 0.0131080f, 1.11922f, -4.50004f, 
		0.0121310f, 1.11922f, -4.50009f, 0.0113080f, 1.11922f, -4.49997f, 
		0.0106780f, 1.11922f, -4.49966f, 0.0102790f, 1.11922f, -4.49910f, 
		0.0101500f, 1.11922f, -4.49826f, 0.0101280f, 1.11922f, -4.49725f, 
		0.0100230f, 1.11922f, -4.49650f, 0.00983800f, 1.11922f, -4.49595f, 
		0.00957600f, 1.11922f, -4.49559f, 0.00924300f, 1.11922f, -4.49537f, 
		0.00884100f, 1.11922f, -4.49526f, 0.00837400f, 1.11921f, -4.49522f, 
		0.00784600f, 1.11921f, -4.49521f, 0.00726200f, 1.11921f, -4.49521f, 
		0.00662400f, 1.11921f, -4.49516f, 0.00593800f, 1.11921f, -4.49505f, 
		0.00520500f, 1.11921f, -4.49483f, 0.00443100f, 1.11921f, -4.49450f, 
		0.00361700f, 1.11921f, -4.49413f, 0.00276700f, 1.11920f, -4.49371f, 
		0.00188600f, 1.11920f, -4.49327f, 0.000975000f, 1.11920f, -4.49283f, 
		4.00000e-005f, 1.11920f, -4.49239f, -0.000917000f, 1.11920f, -4.49197f, 
		-0.00189200f, 1.11920f, -4.49160f, -0.00288200f, 1.11919f, -4.49128f, 
		-0.00388300f, 1.11919f, -4.49104f, -0.00489100f, 1.11919f, -4.49088f, 
		-0.00590300f, 1.11919f, -4.49083f, -0.00691500f, 1.11919f, -4.49089f, 
		-0.00792400f, 1.11919f, -4.49106f, -0.00892600f, 1.11918f, -4.49131f, 
		-0.00991800f, 1.11918f, -4.49164f, -0.0108970f, 1.11918f, -4.49203f, 
		-0.0118580f, 1.11918f, -4.49245f, -0.0127980f, 1.11918f, -4.49290f, 
		-0.0137140f, 1.11918f, -4.49336f, -0.0146010f, 1.11917f, -4.49380f, 
		-0.0154580f, 1.11917f, -4.49423f, -0.0162790f, 1.11917f, -4.49462f, 
		-0.0170620f, 1.11917f, -4.49494f, -0.0178020f, 1.11917f, -4.49517f, 
		-0.0184970f, 1.11917f, -4.49529f, -0.0191430f, 1.11917f, -4.49534f, 
		-0.0197360f, 1.11917f, -4.49535f, -0.0202730f, 1.11916f, -4.49536f, 
		-0.0207500f, 1.11916f, -4.49541f, -0.0211630f, 1.11916f, -4.49552f, 
		-0.0215100f, 1.11916f, -4.49574f, -0.0217870f, 1.11916f, -4.49611f, 
		-0.0219900f, 1.11916f, -4.49664f, -0.0221160f, 1.11916f, -4.49740f, 
		-0.0221600f, 1.11916f, -4.49840f, -0.0223070f, 1.11916f, -4.49921f, 
		-0.0227160f, 1.11916f, -4.49975f, -0.0233490f, 1.11916f, -4.50005f, 
		-0.0241700f, 1.11916f, -4.50015f, -0.0251410f, 1.11916f, -4.50009f, 
		-0.0262240f, 1.11916f, -4.49992f, -0.0273830f, 1.11915f, -4.49967f, 
		-0.0285780f, 1.11915f, -4.49938f, -0.0297740f, 1.11915f, -4.49909f, 
		-0.0309320f, 1.11915f, -4.49884f, -0.0320160f, 1.11915f, -4.49867f, 
		-0.0329860f, 1.11914f, -4.49861f, -0.0329920f, 1.11914f, -4.49899f, 
		-0.0329970f, 1.11914f, -4.49941f, -0.0330020f, 1.11914f, -4.49986f, 
		-0.0330070f, 1.11914f, -4.50034f, -0.0330130f, 1.11914f, -4.50083f, 
		-0.0330180f, 1.11914f, -4.50133f, -0.0330230f, 1.11914f, -4.50183f, 
		-0.0330280f, 1.11914f, -4.50233f, -0.0330340f, 1.11914f, -4.50280f, 
		-0.0330390f, 1.11914f, -4.50325f, -0.0330440f, 1.11914f, -4.50367f, 
		-0.0329860f, 1.06615f, -4.50405f, 0.0210190f, 1.06626f, -4.50405f, 
		0.0210930f, 1.06626f, -4.49860f, 0.0201160f, 1.06626f, -4.49865f, 
		0.0190230f, 1.06626f, -4.49881f, 0.0178530f, 1.06625f, -4.49906f, 
		0.0166440f, 1.06625f, -4.49935f, 0.0154350f, 1.06625f, -4.49963f, 
		0.0142650f, 1.06625f, -4.49988f, 0.0131720f, 1.06624f, -4.50004f, 
		0.0121950f, 1.06624f, -4.50009f, 0.0113720f, 1.06624f, -4.49997f, 
		0.0107410f, 1.06624f, -4.49966f, 0.0103420f, 1.06624f, -4.49910f, 
		0.0102130f, 1.06624f, -4.49826f, 0.0101920f, 1.06624f, -4.49725f, 
		0.0100870f, 1.06624f, -4.49650f, 0.00990100f, 1.06624f, -4.49595f, 
		0.00964000f, 1.06624f, -4.49559f, 0.00930600f, 1.06624f, -4.49537f, 
		0.00890400f, 1.06624f, -4.49526f, 0.00843800f, 1.06623f, -4.49522f, 
		0.00791000f, 1.06623f, -4.49521f, 0.00732600f, 1.06623f, -4.49521f, 
		0.00668800f, 1.06623f, -4.49516f, 0.00600100f, 1.06623f, -4.49505f, 
		0.00526900f, 1.06623f, -4.49483f, 0.00449400f, 1.06623f, -4.49450f, 
		0.00368100f, 1.06623f, -4.49413f, 0.00283100f, 1.06622f, -4.49371f, 
		0.00194900f, 1.06622f, -4.49327f, 0.00103900f, 1.06622f, -4.49283f, 
		0.000103000f, 1.06622f, -4.49239f, -0.000854000f, 1.06622f, -4.49197f, 
		-0.00182900f, 1.06621f, -4.49160f, -0.00281800f, 1.06621f, -4.49128f, 
		-0.00381900f, 1.06621f, -4.49104f, -0.00482700f, 1.06621f, -4.49088f, 
		-0.00583900f, 1.06621f, -4.49083f, -0.00685100f, 1.06620f, -4.49089f, 
		-0.00786000f, 1.06620f, -4.49106f, -0.00886300f, 1.06620f, -4.49131f, 
		-0.00985500f, 1.06620f, -4.49164f, -0.0108330f, 1.06620f, -4.49203f, 
		-0.0117940f, 1.06619f, -4.49245f, -0.0127340f, 1.06619f, -4.49290f, 
		-0.0136500f, 1.06619f, -4.49336f, -0.0145380f, 1.06619f, -4.49380f, 
		-0.0153940f, 1.06619f, -4.49423f, -0.0162150f, 1.06619f, -4.49462f, 
		-0.0169980f, 1.06618f, -4.49494f, -0.0177390f, 1.06618f, -4.49517f, 
		-0.0184340f, 1.06618f, -4.49529f, -0.0190790f, 1.06618f, -4.49534f, 
		-0.0196720f, 1.06618f, -4.49535f, -0.0202090f, 1.06618f, -4.49536f, 
		-0.0206860f, 1.06618f, -4.49541f, -0.0211000f, 1.06618f, -4.49552f, 
		-0.0214470f, 1.06617f, -4.49574f, -0.0217230f, 1.06617f, -4.49611f, 
		-0.0219260f, 1.06617f, -4.49664f, -0.0220520f, 1.06617f, -4.49740f, 
		-0.0220970f, 1.06617f, -4.49840f, -0.0222430f, 1.06617f, -4.49921f, 
		-0.0226520f, 1.06617f, -4.49975f, -0.0232860f, 1.06617f, -4.50005f, 
		-0.0241070f, 1.06617f, -4.50015f, -0.0250770f, 1.06617f, -4.50009f, 
		-0.0261610f, 1.06617f, -4.49992f, -0.0273190f, 1.06616f, -4.49967f, 
		-0.0285150f, 1.06616f, -4.49938f, -0.0297100f, 1.06616f, -4.49909f, 
		-0.0308690f, 1.06616f, -4.49884f, -0.0319520f, 1.06615f, -4.49867f, 
		-0.0329230f, 1.06615f, -4.49861f, -0.0329280f, 1.06615f, -4.49899f, 
		-0.0329330f, 1.06615f, -4.49941f, -0.0329390f, 1.06615f, -4.49986f, 
		-0.0329440f, 1.06615f, -4.50034f, -0.0329490f, 1.06615f, -4.50083f, 
		-0.0329540f, 1.06615f, -4.50133f, -0.0329600f, 1.06615f, -4.50183f, 
		-0.0329650f, 1.06615f, -4.50232f, -0.0329700f, 1.06615f, -4.50280f, 
		-0.0329750f, 1.06615f, -4.50325f, -0.0329810f, 1.06615f, -4.50367f, 
		-0.0329160f, 1.01300f, -4.50405f, 0.0210890f, 1.01311f, -4.50405f, 
		0.0211630f, 1.01312f, -4.49860f, 0.0201860f, 1.01311f, -4.49865f, 
		0.0190930f, 1.01311f, -4.49881f, 0.0179230f, 1.01311f, -4.49906f, 
		0.0167140f, 1.01311f, -4.49935f, 0.0155050f, 1.01310f, -4.49963f, 
		0.0143350f, 1.01310f, -4.49988f, 0.0132420f, 1.01310f, -4.50004f, 
		0.0122650f, 1.01310f, -4.50009f, 0.0114420f, 1.01309f, -4.49997f, 
		0.0108110f, 1.01309f, -4.49966f, 0.0104130f, 1.01309f, -4.49910f, 
		0.0102830f, 1.01309f, -4.49826f, 0.0102620f, 1.01309f, -4.49725f, 
		0.0101570f, 1.01309f, -4.49650f, 0.00997100f, 1.01309f, -4.49595f, 
		0.00971000f, 1.01309f, -4.49559f, 0.00937600f, 1.01309f, -4.49537f, 
		0.00897400f, 1.01309f, -4.49526f, 0.00850800f, 1.01309f, -4.49522f, 
		0.00798000f, 1.01309f, -4.49521f, 0.00739600f, 1.01309f, -4.49521f, 
		0.00675800f, 1.01308f, -4.49516f, 0.00607100f, 1.01308f, -4.49505f, 
		0.00533900f, 1.01308f, -4.49483f, 0.00456400f, 1.01308f, -4.49450f, 
		0.00375100f, 1.01308f, -4.49413f, 0.00290100f, 1.01308f, -4.49371f, 
		0.00201900f, 1.01307f, -4.49327f, 0.00110900f, 1.01307f, -4.49283f, 
		0.000174000f, 1.01307f, -4.49239f, -0.000784000f, 1.01307f, -4.49197f, 
		-0.00175900f, 1.01307f, -4.49160f, -0.00274800f, 1.01306f, -4.49128f, 
		-0.00374900f, 1.01306f, -4.49104f, -0.00475700f, 1.01306f, -4.49088f, 
		-0.00576900f, 1.01306f, -4.49083f, -0.00678100f, 1.01306f, -4.49089f, 
		-0.00779000f, 1.01305f, -4.49106f, -0.00879300f, 1.01305f, -4.49131f, 
		-0.00978500f, 1.01305f, -4.49164f, -0.0107630f, 1.01305f, -4.49203f, 
		-0.0117240f, 1.01305f, -4.49245f, -0.0126640f, 1.01304f, -4.49290f, 
		-0.0135800f, 1.01304f, -4.49336f, -0.0144680f, 1.01304f, -4.49380f, 
		-0.0153240f, 1.01304f, -4.49423f, -0.0161450f, 1.01304f, -4.49462f, 
		-0.0169280f, 1.01304f, -4.49494f, -0.0176690f, 1.01303f, -4.49517f, 
		-0.0183630f, 1.01303f, -4.49529f, -0.0190090f, 1.01303f, -4.49534f, 
		-0.0196020f, 1.01303f, -4.49535f, -0.0201390f, 1.01303f, -4.49536f, 
		-0.0206160f, 1.01303f, -4.49541f, -0.0210300f, 1.01303f, -4.49552f, 
		-0.0213770f, 1.01303f, -4.49574f, -0.0216530f, 1.01303f, -4.49611f, 
		-0.0218560f, 1.01302f, -4.49664f, -0.0219820f, 1.01302f, -4.49740f, 
		-0.0220270f, 1.01302f, -4.49840f, -0.0221730f, 1.01302f, -4.49921f, 
		-0.0225820f, 1.01302f, -4.49975f, -0.0232150f, 1.01302f, -4.50005f, 
		-0.0240360f, 1.01302f, -4.50015f, -0.0250070f, 1.01302f, -4.50009f, 
		-0.0260910f, 1.01302f, -4.49992f, -0.0272490f, 1.01301f, -4.49967f, 
		-0.0284450f, 1.01301f, -4.49938f, -0.0296400f, 1.01301f, -4.49909f, 
		-0.0307980f, 1.01301f, -4.49884f, -0.0318820f, 1.01300f, -4.49867f, 
		-0.0328530f, 1.01300f, -4.49861f, -0.0328580f, 1.01300f, -4.49899f, 
		-0.0328630f, 1.01300f, -4.49941f, -0.0328680f, 1.01300f, -4.49986f, 
		-0.0328740f, 1.01300f, -4.50034f, -0.0328790f, 1.01300f, -4.50083f, 
		-0.0328840f, 1.01300f, -4.50133f, -0.0328890f, 1.01300f, -4.50183f, 
		-0.0328950f, 1.01300f, -4.50232f, -0.0329000f, 1.01300f, -4.50280f, 
		-0.0329050f, 1.01300f, -4.50325f, -0.0329110f, 1.01300f, -4.50367f, 
		-0.0328460f, 0.959855f, -4.50405f, 0.0211600f, 0.959964f, -4.50405f, 
		0.0212330f, 0.959964f, -4.49860f, 0.0202560f, 0.959962f, -4.49865f, 
		0.0191630f, 0.959960f, -4.49881f, 0.0179930f, 0.959957f, -4.49906f, 
		0.0167840f, 0.959955f, -4.49935f, 0.0155750f, 0.959952f, -4.49963f, 
		0.0144050f, 0.959950f, -4.49988f, 0.0133120f, 0.959948f, -4.50004f, 
		0.0123350f, 0.959946f, -4.50009f, 0.0115120f, 0.959944f, -4.49997f, 
		0.0108810f, 0.959943f, -4.49966f, 0.0104820f, 0.959942f, -4.49910f, 
		0.0103540f, 0.959942f, -4.49826f, 0.0103320f, 0.959942f, -4.49725f, 
		0.0102270f, 0.959942f, -4.49650f, 0.0100410f, 0.959941f, -4.49595f, 
		0.00978000f, 0.959941f, -4.49559f, 0.00944600f, 0.959940f, -4.49537f, 
		0.00904400f, 0.959939f, -4.49526f, 0.00857800f, 0.959938f, -4.49522f, 
		0.00805000f, 0.959937f, -4.49521f, 0.00746600f, 0.959936f, -4.49521f, 
		0.00682800f, 0.959935f, -4.49516f, 0.00614100f, 0.959934f, -4.49505f, 
		0.00540900f, 0.959932f, -4.49483f, 0.00463400f, 0.959930f, -4.49450f, 
		0.00382100f, 0.959929f, -4.49413f, 0.00297100f, 0.959927f, -4.49371f, 
		0.00208900f, 0.959925f, -4.49327f, 0.00117900f, 0.959924f, -4.49283f, 
		0.000244000f, 0.959922f, -4.49239f, -0.000714000f, 0.959920f, -4.49197f, 
		-0.00168900f, 0.959918f, -4.49160f, -0.00267800f, 0.959916f, -4.49128f, 
		-0.00367900f, 0.959914f, -4.49104f, -0.00468700f, 0.959912f, -4.49088f, 
		-0.00569900f, 0.959910f, -4.49083f, -0.00671100f, 0.959908f, -4.49089f, 
		-0.00772000f, 0.959906f, -4.49106f, -0.00872200f, 0.959904f, -4.49131f, 
		-0.00971500f, 0.959902f, -4.49164f, -0.0106930f, 0.959900f, -4.49203f, 
		-0.0116540f, 0.959898f, -4.49245f, -0.0125940f, 0.959896f, -4.49290f, 
		-0.0135100f, 0.959894f, -4.49336f, -0.0143980f, 0.959892f, -4.49380f, 
		-0.0152540f, 0.959891f, -4.49423f, -0.0160750f, 0.959889f, -4.49462f, 
		-0.0168580f, 0.959887f, -4.49494f, -0.0175990f, 0.959886f, -4.49517f, 
		-0.0182930f, 0.959884f, -4.49529f, -0.0189390f, 0.959883f, -4.49534f, 
		-0.0195320f, 0.959882f, -4.49535f, -0.0200690f, 0.959881f, -4.49536f, 
		-0.0205460f, 0.959880f, -4.49541f, -0.0209600f, 0.959879f, -4.49552f, 
		-0.0213070f, 0.959878f, -4.49574f, -0.0215830f, 0.959878f, -4.49611f, 
		-0.0217860f, 0.959877f, -4.49664f, -0.0219120f, 0.959877f, -4.49740f, 
		-0.0219570f, 0.959877f, -4.49840f, -0.0221030f, 0.959877f, -4.49921f, 
		-0.0225120f, 0.959876f, -4.49975f, -0.0231450f, 0.959875f, -4.50005f, 
		-0.0239660f, 0.959873f, -4.50015f, -0.0249370f, 0.959871f, -4.50009f, 
		-0.0260210f, 0.959869f, -4.49992f, -0.0271790f, 0.959867f, -4.49967f, 
		-0.0283740f, 0.959864f, -4.49938f, -0.0295700f, 0.959862f, -4.49909f, 
		-0.0307280f, 0.959859f, -4.49884f, -0.0318120f, 0.959857f, -4.49867f, 
		-0.0327830f, 0.959855f, -4.49861f, -0.0327880f, 0.959855f, -4.49899f, 
		-0.0327930f, 0.959855f, -4.49941f, -0.0327980f, 0.959855f, -4.49986f, 
		-0.0328040f, 0.959855f, -4.50034f, -0.0328090f, 0.959855f, -4.50083f, 
		-0.0328140f, 0.959855f, -4.50133f, -0.0328190f, 0.959855f, -4.50183f, 
		-0.0328250f, 0.959855f, -4.50232f, -0.0328300f, 0.959855f, -4.50280f, 
		-0.0328350f, 0.959855f, -4.50325f, -0.0328400f, 0.959855f, -4.50367f, 
		-0.0327820f, 0.906880f, -4.50405f, 0.0212230f, 0.906973f, -4.50405f, 
		0.0212970f, 0.906973f, -4.49860f, 0.0203190f, 0.906972f, -4.49865f, 
		0.0192260f, 0.906970f, -4.49881f, 0.0180560f, 0.906968f, -4.49906f, 
		0.0168480f, 0.906966f, -4.49935f, 0.0156390f, 0.906964f, -4.49963f, 
		0.0144690f, 0.906962f, -4.49988f, 0.0133760f, 0.906960f, -4.50004f, 
		0.0123980f, 0.906958f, -4.50009f, 0.0115750f, 0.906956f, -4.49997f, 
		0.0109450f, 0.906955f, -4.49966f, 0.0105460f, 0.906955f, -4.49910f, 
		0.0104170f, 0.906955f, -4.49826f, 0.0103960f, 0.906954f, -4.49725f, 
		0.0102900f, 0.906954f, -4.49650f, 0.0101050f, 0.906954f, -4.49595f, 
		0.00984400f, 0.906954f, -4.49559f, 0.00951000f, 0.906953f, -4.49537f, 
		0.00910800f, 0.906952f, -4.49526f, 0.00864100f, 0.906951f, -4.49522f, 
		0.00811400f, 0.906951f, -4.49521f, 0.00752900f, 0.906950f, -4.49521f, 
		0.00689200f, 0.906948f, -4.49516f, 0.00620500f, 0.906947f, -4.49505f, 
		0.00547300f, 0.906946f, -4.49483f, 0.00469800f, 0.906945f, -4.49450f, 
		0.00388400f, 0.906943f, -4.49413f, 0.00303500f, 0.906942f, -4.49371f, 
		0.00215300f, 0.906940f, -4.49327f, 0.00124300f, 0.906939f, -4.49283f, 
		0.000307000f, 0.906937f, -4.49239f, -0.000650000f, 0.906935f, -4.49197f, 
		-0.00162500f, 0.906934f, -4.49160f, -0.00261500f, 0.906932f, -4.49128f, 
		-0.00361500f, 0.906930f, -4.49104f, -0.00462300f, 0.906929f, -4.49088f, 
		-0.00563500f, 0.906927f, -4.49083f, -0.00664700f, 0.906925f, -4.49089f, 
		-0.00765600f, 0.906923f, -4.49106f, -0.00865900f, 0.906922f, -4.49131f, 
		-0.00965100f, 0.906920f, -4.49164f, -0.0106290f, 0.906918f, -4.49203f, 
		-0.0115900f, 0.906917f, -4.49245f, -0.0125300f, 0.906915f, -4.49290f, 
		-0.0134460f, 0.906913f, -4.49336f, -0.0143340f, 0.906912f, -4.49380f, 
		-0.0151900f, 0.906910f, -4.49423f, -0.0160120f, 0.906909f, -4.49462f, 
		-0.0167940f, 0.906908f, -4.49494f, -0.0175350f, 0.906906f, -4.49517f, 
		-0.0182300f, 0.906905f, -4.49529f, -0.0188760f, 0.906904f, -4.49534f, 
		-0.0194680f, 0.906903f, -4.49535f, -0.0200050f, 0.906902f, -4.49536f, 
		-0.0204820f, 0.906901f, -4.49541f, -0.0208960f, 0.906901f, -4.49552f, 
		-0.0212430f, 0.906900f, -4.49574f, -0.0215200f, 0.906899f, -4.49611f, 
		-0.0217230f, 0.906899f, -4.49664f, -0.0218480f, 0.906899f, -4.49740f, 
		-0.0218930f, 0.906899f, -4.49840f, -0.0220390f, 0.906898f, -4.49921f, 
		-0.0224480f, 0.906898f, -4.49975f, -0.0230820f, 0.906897f, -4.50005f, 
		-0.0239030f, 0.906895f, -4.50015f, -0.0248740f, 0.906894f, -4.50009f, 
		-0.0259570f, 0.906892f, -4.49992f, -0.0271150f, 0.906890f, -4.49967f, 
		-0.0283110f, 0.906888f, -4.49938f, -0.0295070f, 0.906886f, -4.49909f, 
		-0.0306650f, 0.906884f, -4.49884f, -0.0317480f, 0.906882f, -4.49867f, 
		-0.0327190f, 0.906880f, -4.49861f, -0.0327240f, 0.906880f, -4.49899f, 
		-0.0327300f, 0.906880f, -4.49941f, -0.0327350f, 0.906880f, -4.49986f, 
		-0.0327400f, 0.906880f, -4.50034f, -0.0327450f, 0.906880f, -4.50083f, 
		-0.0327510f, 0.906880f, -4.50133f, -0.0327560f, 0.906880f, -4.50183f, 
		-0.0327610f, 0.906880f, -4.50232f, -0.0327660f, 0.906880f, -4.50280f, 
		-0.0327720f, 0.906880f, -4.50325f, -0.0327770f, 0.906880f, -4.50367f, 
		-0.0327310f, 0.854241f, -4.50405f, 0.0212740f, 0.854308f, -4.50405f, 
		0.0213470f, 0.854308f, -4.49860f, 0.0203700f, 0.854307f, -4.49865f, 
		0.0192770f, 0.854306f, -4.49881f, 0.0181070f, 0.854304f, -4.49906f, 
		0.0168980f, 0.854303f, -4.49935f, 0.0156900f, 0.854301f, -4.49963f, 
		0.0145190f, 0.854300f, -4.49988f, 0.0134260f, 0.854298f, -4.50004f, 
		0.0124490f, 0.854297f, -4.50009f, 0.0116260f, 0.854296f, -4.49997f, 
		0.0109960f, 0.854295f, -4.49966f, 0.0105970f, 0.854295f, -4.49910f, 
		0.0104680f, 0.854295f, -4.49826f, 0.0104460f, 0.854295f, -4.49725f, 
		0.0103410f, 0.854294f, -4.49650f, 0.0101560f, 0.854294f, -4.49595f, 
		0.00989400f, 0.854294f, -4.49559f, 0.00956100f, 0.854293f, -4.49537f, 
		0.00915900f, 0.854293f, -4.49526f, 0.00869200f, 0.854292f, -4.49522f, 
		0.00816400f, 0.854292f, -4.49521f, 0.00758000f, 0.854291f, -4.49521f, 
		0.00694200f, 0.854290f, -4.49516f, 0.00625600f, 0.854289f, -4.49505f, 
		0.00552300f, 0.854288f, -4.49483f, 0.00474900f, 0.854287f, -4.49450f, 
		0.00393500f, 0.854286f, -4.49413f, 0.00308500f, 0.854285f, -4.49371f, 
		0.00220400f, 0.854284f, -4.49327f, 0.00129300f, 0.854283f, -4.49283f, 
		0.000358000f, 0.854282f, -4.49239f, -0.000599000f, 0.854281f, -4.49197f, 
		-0.00157400f, 0.854280f, -4.49160f, -0.00256400f, 0.854278f, -4.49128f, 
		-0.00356400f, 0.854277f, -4.49104f, -0.00457300f, 0.854276f, -4.49088f, 
		-0.00558400f, 0.854275f, -4.49083f, -0.00659700f, 0.854273f, -4.49089f, 
		-0.00760600f, 0.854272f, -4.49106f, -0.00860800f, 0.854271f, -4.49131f, 
		-0.00960000f, 0.854270f, -4.49164f, -0.0105790f, 0.854268f, -4.49203f, 
		-0.0115400f, 0.854267f, -4.49245f, -0.0124800f, 0.854266f, -4.49290f, 
		-0.0133950f, 0.854265f, -4.49336f, -0.0142830f, 0.854264f, -4.49380f, 
		-0.0151400f, 0.854263f, -4.49423f, -0.0159610f, 0.854262f, -4.49462f, 
		-0.0167440f, 0.854261f, -4.49494f, -0.0174840f, 0.854260f, -4.49517f, 
		-0.0181790f, 0.854259f, -4.49529f, -0.0188250f, 0.854258f, -4.49534f, 
		-0.0194180f, 0.854257f, -4.49535f, -0.0199540f, 0.854257f, -4.49536f, 
		-0.0204310f, 0.854256f, -4.49541f, -0.0208450f, 0.854255f, -4.49552f, 
		-0.0211920f, 0.854255f, -4.49574f, -0.0214690f, 0.854255f, -4.49611f, 
		-0.0216720f, 0.854254f, -4.49664f, -0.0217980f, 0.854254f, -4.49740f, 
		-0.0218420f, 0.854254f, -4.49840f, -0.0219890f, 0.854254f, -4.49921f, 
		-0.0223980f, 0.854254f, -4.49975f, -0.0230310f, 0.854253f, -4.50005f, 
		-0.0238520f, 0.854252f, -4.50015f, -0.0248230f, 0.854251f, -4.50009f, 
		-0.0259060f, 0.854249f, -4.49992f, -0.0270650f, 0.854248f, -4.49967f, 
		-0.0282600f, 0.854246f, -4.49938f, -0.0294560f, 0.854245f, -4.49909f, 
		-0.0306140f, 0.854243f, -4.49884f, -0.0316970f, 0.854242f, -4.49867f, 
		-0.0326680f, 0.854241f, -4.49861f, -0.0326740f, 0.854241f, -4.49899f, 
		-0.0326790f, 0.854241f, -4.49941f, -0.0326840f, 0.854241f, -4.49986f, 
		-0.0326890f, 0.854241f, -4.50034f, -0.0326950f, 0.854241f, -4.50083f, 
		-0.0327000f, 0.854241f, -4.50133f, -0.0327050f, 0.854241f, -4.50183f, 
		-0.0327100f, 0.854241f, -4.50232f, -0.0327160f, 0.854241f, -4.50280f, 
		-0.0327210f, 0.854241f, -4.50325f, -0.0327260f, 0.854241f, -4.50367f, 
		-0.0327000f, 0.802103f, -4.50405f, 0.0213050f, 0.802133f, -4.50405f, 
		0.0213790f, 0.802133f, -4.49860f, 0.0204010f, 0.802133f, -4.49865f, 
		0.0193080f, 0.802132f, -4.49881f, 0.0181380f, 0.802131f, -4.49906f, 
		0.0169300f, 0.802131f, -4.49935f, 0.0157210f, 0.802130f, -4.49963f, 
		0.0145510f, 0.802129f, -4.49988f, 0.0134580f, 0.802129f, -4.50004f, 
		0.0124800f, 0.802128f, -4.50009f, 0.0116570f, 0.802128f, -4.49997f, 
		0.0110270f, 0.802127f, -4.49966f, 0.0106280f, 0.802127f, -4.49910f, 
		0.0104990f, 0.802127f, -4.49826f, 0.0104780f, 0.802127f, -4.49725f, 
		0.0103720f, 0.802127f, -4.49650f, 0.0101870f, 0.802127f, -4.49595f, 
		0.00992600f, 0.802127f, -4.49559f, 0.00959200f, 0.802127f, -4.49537f, 
		0.00919000f, 0.802126f, -4.49526f, 0.00872300f, 0.802126f, -4.49522f, 
		0.00819600f, 0.802126f, -4.49521f, 0.00761100f, 0.802126f, -4.49521f, 
		0.00697400f, 0.802125f, -4.49516f, 0.00628700f, 0.802125f, -4.49505f, 
		0.00555500f, 0.802124f, -4.49483f, 0.00478000f, 0.802124f, -4.49450f, 
		0.00396600f, 0.802123f, -4.49413f, 0.00311700f, 0.802123f, -4.49371f, 
		0.00223500f, 0.802122f, -4.49327f, 0.00132500f, 0.802122f, -4.49283f, 
		0.000389000f, 0.802121f, -4.49239f, -0.000568000f, 0.802121f, -4.49197f, 
		-0.00154300f, 0.802120f, -4.49160f, -0.00253300f, 0.802120f, -4.49128f, 
		-0.00353300f, 0.802119f, -4.49104f, -0.00454100f, 0.802119f, -4.49088f, 
		-0.00555300f, 0.802118f, -4.49083f, -0.00656500f, 0.802118f, -4.49089f, 
		-0.00757400f, 0.802117f, -4.49106f, -0.00857700f, 0.802116f, -4.49131f, 
		-0.00956900f, 0.802116f, -4.49164f, -0.0105470f, 0.802115f, -4.49203f, 
		-0.0115080f, 0.802115f, -4.49245f, -0.0124480f, 0.802114f, -4.49290f, 
		-0.0133640f, 0.802114f, -4.49336f, -0.0142520f, 0.802113f, -4.49380f, 
		-0.0151080f, 0.802113f, -4.49423f, -0.0159300f, 0.802112f, -4.49462f, 
		-0.0167120f, 0.802112f, -4.49494f, -0.0174530f, 0.802111f, -4.49517f, 
		-0.0181480f, 0.802111f, -4.49529f, -0.0187930f, 0.802111f, -4.49534f, 
		-0.0193860f, 0.802110f, -4.49535f, -0.0199230f, 0.802110f, -4.49536f, 
		-0.0204000f, 0.802110f, -4.49541f, -0.0208140f, 0.802109f, -4.49552f, 
		-0.0211610f, 0.802109f, -4.49574f, -0.0214380f, 0.802109f, -4.49611f, 
		-0.0216400f, 0.802109f, -4.49664f, -0.0217660f, 0.802109f, -4.49740f, 
		-0.0218110f, 0.802109f, -4.49840f, -0.0219580f, 0.802109f, -4.49921f, 
		-0.0223660f, 0.802109f, -4.49975f, -0.0230000f, 0.802108f, -4.50005f, 
		-0.0238210f, 0.802108f, -4.50015f, -0.0247920f, 0.802107f, -4.50009f, 
		-0.0258750f, 0.802107f, -4.49992f, -0.0270330f, 0.802106f, -4.49967f, 
		-0.0282290f, 0.802105f, -4.49938f, -0.0294250f, 0.802105f, -4.49909f, 
		-0.0305830f, 0.802104f, -4.49884f, -0.0316660f, 0.802103f, -4.49867f, 
		-0.0326370f, 0.802103f, -4.49861f, -0.0326420f, 0.802103f, -4.49899f, 
		-0.0326470f, 0.802103f, -4.49941f, -0.0326530f, 0.802103f, -4.49986f, 
		-0.0326580f, 0.802103f, -4.50034f, -0.0326630f, 0.802103f, -4.50083f, 
		-0.0326690f, 0.802103f, -4.50133f, -0.0326740f, 0.802103f, -4.50183f, 
		-0.0326790f, 0.802103f, -4.50232f, -0.0326840f, 0.802103f, -4.50280f, 
		-0.0326900f, 0.802103f, -4.50325f, -0.0326950f, 0.802103f, -4.50367f, 
		-0.0326950f, 0.750632f, -4.50405f, 0.0213110f, 0.750614f, -4.50405f, 
		0.0213840f, 0.750614f, -4.49860f, 0.0204070f, 0.750614f, -4.49865f, 
		0.0193140f, 0.750614f, -4.49881f, 0.0181440f, 0.750615f, -4.49906f, 
		0.0169350f, 0.750615f, -4.49935f, 0.0157260f, 0.750616f, -4.49963f, 
		0.0145560f, 0.750616f, -4.49988f, 0.0134630f, 0.750616f, -4.50004f, 
		0.0124860f, 0.750617f, -4.50009f, 0.0116630f, 0.750617f, -4.49997f, 
		0.0110330f, 0.750617f, -4.49966f, 0.0106340f, 0.750617f, -4.49910f, 
		0.0105050f, 0.750617f, -4.49826f, 0.0104830f, 0.750617f, -4.49725f, 
		0.0103780f, 0.750617f, -4.49650f, 0.0101930f, 0.750618f, -4.49595f, 
		0.00993100f, 0.750618f, -4.49559f, 0.00959800f, 0.750618f, -4.49537f, 
		0.00919600f, 0.750618f, -4.49526f, 0.00872900f, 0.750618f, -4.49522f, 
		0.00820100f, 0.750618f, -4.49521f, 0.00761700f, 0.750618f, -4.49521f, 
		0.00697900f, 0.750619f, -4.49516f, 0.00629200f, 0.750619f, -4.49505f, 
		0.00556000f, 0.750619f, -4.49483f, 0.00478600f, 0.750619f, -4.49450f, 
		0.00397200f, 0.750620f, -4.49413f, 0.00312200f, 0.750620f, -4.49371f, 
		0.00224100f, 0.750620f, -4.49327f, 0.00133000f, 0.750620f, -4.49283f, 
		0.000395000f, 0.750621f, -4.49239f, -0.000562000f, 0.750621f, -4.49197f, 
		-0.00153800f, 0.750621f, -4.49160f, -0.00252700f, 0.750622f, -4.49128f, 
		-0.00352800f, 0.750622f, -4.49104f, -0.00453600f, 0.750622f, -4.49088f, 
		-0.00554800f, 0.750623f, -4.49083f, -0.00656000f, 0.750623f, -4.49089f, 
		-0.00756900f, 0.750623f, -4.49106f, -0.00857100f, 0.750624f, -4.49131f, 
		-0.00956300f, 0.750624f, -4.49164f, -0.0105420f, 0.750624f, -4.49203f, 
		-0.0115030f, 0.750625f, -4.49245f, -0.0124430f, 0.750625f, -4.49290f, 
		-0.0133590f, 0.750625f, -4.49336f, -0.0142460f, 0.750626f, -4.49380f, 
		-0.0151030f, 0.750626f, -4.49423f, -0.0159240f, 0.750626f, -4.49462f, 
		-0.0167070f, 0.750627f, -4.49494f, -0.0174470f, 0.750627f, -4.49517f, 
		-0.0181420f, 0.750627f, -4.49529f, -0.0187880f, 0.750627f, -4.49534f, 
		-0.0193810f, 0.750627f, -4.49535f, -0.0199180f, 0.750628f, -4.49536f, 
		-0.0203950f, 0.750628f, -4.49541f, -0.0208080f, 0.750628f, -4.49552f, 
		-0.0211550f, 0.750628f, -4.49574f, -0.0214320f, 0.750628f, -4.49611f, 
		-0.0216350f, 0.750628f, -4.49664f, -0.0217610f, 0.750628f, -4.49740f, 
		-0.0218060f, 0.750628f, -4.49840f, -0.0219520f, 0.750628f, -4.49921f, 
		-0.0223610f, 0.750628f, -4.49975f, -0.0229940f, 0.750629f, -4.50005f, 
		-0.0238150f, 0.750629f, -4.50015f, -0.0247860f, 0.750629f, -4.50009f, 
		-0.0258690f, 0.750630f, -4.49992f, -0.0270280f, 0.750630f, -4.49967f, 
		-0.0282230f, 0.750630f, -4.49938f, -0.0294190f, 0.750631f, -4.49909f, 
		-0.0305770f, 0.750631f, -4.49884f, -0.0316610f, 0.750632f, -4.49867f, 
		-0.0326310f, 0.750632f, -4.49861f, -0.0326370f, 0.750632f, -4.49899f, 
		-0.0326420f, 0.750632f, -4.49941f, -0.0326470f, 0.750632f, -4.49986f, 
		-0.0326530f, 0.750632f, -4.50034f, -0.0326580f, 0.750632f, -4.50083f, 
		-0.0326630f, 0.750632f, -4.50133f, -0.0326680f, 0.750632f, -4.50183f, 
		-0.0326740f, 0.750632f, -4.50232f, -0.0326790f, 0.750632f, -4.50280f, 
		-0.0326840f, 0.750632f, -4.50325f, -0.0326890f, 0.750632f, -4.50367f, 
		-0.0327210f, 0.699994f, -4.50405f, 0.0212840f, 0.699914f, -4.50405f, 
		0.0213570f, 0.699914f, -4.49860f, 0.0203800f, 0.699916f, -4.49865f, 
		0.0192870f, 0.699917f, -4.49881f, 0.0181170f, 0.699919f, -4.49906f, 
		0.0169080f, 0.699921f, -4.49935f, 0.0157000f, 0.699923f, -4.49963f, 
		0.0145290f, 0.699924f, -4.49988f, 0.0134360f, 0.699926f, -4.50004f, 
		0.0124590f, 0.699927f, -4.50009f, 0.0116360f, 0.699929f, -4.49997f, 
		0.0110060f, 0.699929f, -4.49966f, 0.0106070f, 0.699930f, -4.49910f, 
		0.0104780f, 0.699930f, -4.49826f, 0.0104560f, 0.699930f, -4.49725f, 
		0.0103510f, 0.699930f, -4.49650f, 0.0101660f, 0.699931f, -4.49595f, 
		0.00990400f, 0.699931f, -4.49559f, 0.00957100f, 0.699932f, -4.49537f, 
		0.00916900f, 0.699932f, -4.49526f, 0.00870200f, 0.699933f, -4.49522f, 
		0.00817400f, 0.699934f, -4.49521f, 0.00759000f, 0.699934f, -4.49521f, 
		0.00695200f, 0.699935f, -4.49516f, 0.00626600f, 0.699936f, -4.49505f, 
		0.00553300f, 0.699938f, -4.49483f, 0.00475900f, 0.699939f, -4.49450f, 
		0.00394500f, 0.699940f, -4.49413f, 0.00309600f, 0.699941f, -4.49371f, 
		0.00221400f, 0.699942f, -4.49327f, 0.00130300f, 0.699944f, -4.49283f, 
		0.000368000f, 0.699945f, -4.49239f, -0.000589000f, 0.699947f, -4.49197f, 
		-0.00156400f, 0.699948f, -4.49160f, -0.00255400f, 0.699949f, -4.49128f, 
		-0.00355400f, 0.699951f, -4.49104f, -0.00456200f, 0.699952f, -4.49088f, 
		-0.00557400f, 0.699954f, -4.49083f, -0.00658700f, 0.699955f, -4.49089f, 
		-0.00759600f, 0.699957f, -4.49106f, -0.00859800f, 0.699958f, -4.49131f, 
		-0.00959000f, 0.699960f, -4.49164f, -0.0105690f, 0.699961f, -4.49203f, 
		-0.0115300f, 0.699963f, -4.49245f, -0.0124700f, 0.699964f, -4.49290f, 
		-0.0133850f, 0.699965f, -4.49336f, -0.0142730f, 0.699967f, -4.49380f, 
		-0.0151300f, 0.699968f, -4.49423f, -0.0159510f, 0.699969f, -4.49462f, 
		-0.0167340f, 0.699970f, -4.49494f, -0.0174740f, 0.699971f, -4.49517f, 
		-0.0181690f, 0.699973f, -4.49529f, -0.0188150f, 0.699973f, -4.49534f, 
		-0.0194080f, 0.699974f, -4.49535f, -0.0199440f, 0.699975f, -4.49536f, 
		-0.0204210f, 0.699976f, -4.49541f, -0.0208350f, 0.699976f, -4.49552f, 
		-0.0211820f, 0.699977f, -4.49574f, -0.0214590f, 0.699977f, -4.49611f, 
		-0.0216620f, 0.699978f, -4.49664f, -0.0217870f, 0.699978f, -4.49740f, 
		-0.0218320f, 0.699978f, -4.49840f, -0.0219790f, 0.699978f, -4.49921f, 
		-0.0223880f, 0.699979f, -4.49975f, -0.0230210f, 0.699980f, -4.50005f, 
		-0.0238420f, 0.699981f, -4.50015f, -0.0248130f, 0.699982f, -4.50009f, 
		-0.0258960f, 0.699984f, -4.49992f, -0.0270540f, 0.699986f, -4.49967f, 
		-0.0282500f, 0.699987f, -4.49938f, -0.0294460f, 0.699989f, -4.49909f, 
		-0.0306040f, 0.699991f, -4.49884f, -0.0316870f, 0.699992f, -4.49867f, 
		-0.0326580f, 0.699994f, -4.49861f, -0.0326640f, 0.699994f, -4.49899f, 
		-0.0326690f, 0.699994f, -4.49941f, -0.0326740f, 0.699994f, -4.49986f, 
		-0.0326790f, 0.699994f, -4.50034f, -0.0326850f, 0.699994f, -4.50083f, 
		-0.0326900f, 0.699994f, -4.50133f, -0.0326950f, 0.699994f, -4.50183f, 
		-0.0327000f, 0.699994f, -4.50232f, -0.0327060f, 0.699994f, -4.50280f, 
		-0.0327110f, 0.699994f, -4.50325f, -0.0327160f, 0.699994f, -4.50367f, 
		-0.0327870f, 0.650355f, -4.50405f, 0.0212180f, 0.650200f, -4.50405f, 
		0.0212920f, 0.650199f, -4.49860f, 0.0203150f, 0.650202f, -4.49865f, 
		0.0192220f, 0.650205f, -4.49881f, 0.0180510f, 0.650209f, -4.49906f, 
		0.0168430f, 0.650212f, -4.49935f, 0.0156340f, 0.650216f, -4.49963f, 
		0.0144640f, 0.650219f, -4.49988f, 0.0133710f, 0.650222f, -4.50004f, 
		0.0123940f, 0.650225f, -4.50009f, 0.0115710f, 0.650227f, -4.49997f, 
		0.0109400f, 0.650229f, -4.49966f, 0.0105410f, 0.650230f, -4.49910f, 
		0.0104120f, 0.650231f, -4.49826f, 0.0103910f, 0.650231f, -4.49725f, 
		0.0102850f, 0.650231f, -4.49650f, 0.0101000f, 0.650231f, -4.49595f, 
		0.00983900f, 0.650232f, -4.49559f, 0.00950500f, 0.650233f, -4.49537f, 
		0.00910300f, 0.650234f, -4.49526f, 0.00863600f, 0.650236f, -4.49522f, 
		0.00810900f, 0.650237f, -4.49521f, 0.00752400f, 0.650239f, -4.49521f, 
		0.00688700f, 0.650241f, -4.49516f, 0.00620000f, 0.650243f, -4.49505f, 
		0.00546800f, 0.650245f, -4.49483f, 0.00469300f, 0.650247f, -4.49450f, 
		0.00387900f, 0.650249f, -4.49413f, 0.00303000f, 0.650252f, -4.49371f, 
		0.00214800f, 0.650254f, -4.49327f, 0.00123800f, 0.650257f, -4.49283f, 
		0.000302000f, 0.650260f, -4.49239f, -0.000655000f, 0.650262f, -4.49197f, 
		-0.00163000f, 0.650265f, -4.49160f, -0.00261900f, 0.650268f, -4.49128f, 
		-0.00362000f, 0.650271f, -4.49104f, -0.00462800f, 0.650274f, -4.49088f, 
		-0.00564000f, 0.650277f, -4.49083f, -0.00665200f, 0.650280f, -4.49089f, 
		-0.00766100f, 0.650283f, -4.49106f, -0.00866400f, 0.650285f, -4.49131f, 
		-0.00965600f, 0.650288f, -4.49164f, -0.0106340f, 0.650291f, -4.49203f, 
		-0.0115950f, 0.650294f, -4.49245f, -0.0125350f, 0.650296f, -4.49290f, 
		-0.0134510f, 0.650299f, -4.49336f, -0.0143390f, 0.650302f, -4.49380f, 
		-0.0151950f, 0.650304f, -4.49423f, -0.0160160f, 0.650306f, -4.49462f, 
		-0.0167990f, 0.650309f, -4.49494f, -0.0175400f, 0.650311f, -4.49517f, 
		-0.0182350f, 0.650313f, -4.49529f, -0.0188800f, 0.650315f, -4.49534f, 
		-0.0194730f, 0.650316f, -4.49535f, -0.0200100f, 0.650318f, -4.49536f, 
		-0.0204870f, 0.650319f, -4.49541f, -0.0209010f, 0.650320f, -4.49552f, 
		-0.0212480f, 0.650321f, -4.49574f, -0.0215240f, 0.650322f, -4.49611f, 
		-0.0217270f, 0.650323f, -4.49664f, -0.0218530f, 0.650323f, -4.49740f, 
		-0.0218980f, 0.650323f, -4.49840f, -0.0220440f, 0.650324f, -4.49921f, 
		-0.0224530f, 0.650325f, -4.49975f, -0.0230870f, 0.650327f, -4.50005f, 
		-0.0239080f, 0.650329f, -4.50015f, -0.0248780f, 0.650332f, -4.50009f, 
		-0.0259620f, 0.650335f, -4.49992f, -0.0271200f, 0.650338f, -4.49967f, 
		-0.0283160f, 0.650342f, -4.49938f, -0.0295110f, 0.650345f, -4.49909f, 
		-0.0306700f, 0.650349f, -4.49884f, -0.0317530f, 0.650352f, -4.49867f, 
		-0.0327240f, 0.650354f, -4.49861f, -0.0327290f, 0.650354f, -4.49899f, 
		-0.0327340f, 0.650354f, -4.49941f, -0.0327400f, 0.650355f, -4.49986f, 
		-0.0327450f, 0.650355f, -4.50034f, -0.0327500f, 0.650355f, -4.50083f, 
		-0.0327550f, 0.650355f, -4.50133f, -0.0327610f, 0.650355f, -4.50183f, 
		-0.0327660f, 0.650355f, -4.50232f, -0.0327710f, 0.650355f, -4.50280f, 
		-0.0327760f, 0.650355f, -4.50325f, -0.0327820f, 0.650355f, -4.50367f, 
		-0.0328180f, 0.636800f, -4.50405f, 0.0210320f, 0.568633f, -4.50405f, 
		0.0211060f, 0.568540f, -4.49860f, 0.0201310f, 0.569774f, -4.49865f, 
		0.0190410f, 0.571153f, -4.49881f, 0.0178740f, 0.572630f, -4.49906f, 
		0.0166690f, 0.574156f, -4.49935f, 0.0154640f, 0.575682f, -4.49963f, 
		0.0142970f, 0.577159f, -4.49988f, 0.0132070f, 0.578538f, -4.50004f, 
		0.0122330f, 0.579772f, -4.50009f, 0.0114120f, 0.580811f, -4.49997f, 
		0.0107840f, 0.581606f, -4.49966f, 0.0103860f, 0.582110f, -4.49910f, 
		0.0102570f, 0.582273f, -4.49826f, 0.0102360f, 0.582300f, -4.49725f, 
		0.0101310f, 0.582433f, -4.49650f, 0.00994600f, 0.582667f, -4.49595f, 
		0.00968500f, 0.582996f, -4.49559f, 0.00935300f, 0.583418f, -4.49537f, 
		0.00895200f, 0.583925f, -4.49526f, 0.00848600f, 0.584514f, -4.49522f, 
		0.00796000f, 0.585180f, -4.49521f, 0.00737800f, 0.585918f, -4.49521f, 
		0.00674200f, 0.586722f, -4.49516f, 0.00605700f, 0.587589f, -4.49505f, 
		0.00532700f, 0.588514f, -4.49483f, 0.00455500f, 0.589491f, -4.49450f, 
		0.00374300f, 0.590519f, -4.49413f, 0.00289600f, 0.591591f, -4.49371f, 
		0.00201700f, 0.592704f, -4.49327f, 0.00110900f, 0.593853f, -4.49283f, 
		0.000176000f, 0.595034f, -4.49239f, -0.000778000f, 0.596242f, -4.49197f, 
		-0.00175000f, 0.597473f, -4.49160f, -0.00273700f, 0.598722f, -4.49128f, 
		-0.00373500f, 0.599985f, -4.49104f, -0.00474000f, 0.601257f, -4.49088f, 
		-0.00574900f, 0.602534f, -4.49083f, -0.00675800f, 0.603812f, -4.49089f, 
		-0.00776400f, 0.605086f, -4.49106f, -0.00876400f, 0.606351f, -4.49131f, 
		-0.00975300f, 0.607603f, -4.49164f, -0.0107290f, 0.608838f, -4.49203f, 
		-0.0116870f, 0.610051f, -4.49245f, -0.0126240f, 0.611238f, -4.49290f, 
		-0.0135370f, 0.612394f, -4.49336f, -0.0144230f, 0.613514f, -4.49380f, 
		-0.0152770f, 0.614595f, -4.49423f, -0.0160960f, 0.615632f, -4.49462f, 
		-0.0168760f, 0.616620f, -4.49494f, -0.0176140f, 0.617555f, -4.49517f, 
		-0.0183070f, 0.618432f, -4.49529f, -0.0189510f, 0.619247f, -4.49534f, 
		-0.0195420f, 0.619995f, -4.49535f, -0.0200780f, 0.620673f, -4.49536f, 
		-0.0205530f, 0.621275f, -4.49541f, -0.0209660f, 0.621797f, -4.49552f, 
		-0.0213120f, 0.622235f, -4.49574f, -0.0215880f, 0.622584f, -4.49611f, 
		-0.0217900f, 0.622840f, -4.49664f, -0.0219150f, 0.622999f, -4.49740f, 
		-0.0219600f, 0.623056f, -4.49840f, -0.0221060f, 0.623241f, -4.49921f, 
		-0.0225140f, 0.623756f, -4.49975f, -0.0231450f, 0.624556f, -4.50005f, 
		-0.0239640f, 0.625592f, -4.50015f, -0.0249320f, 0.626818f, -4.50009f, 
		-0.0260120f, 0.628185f, -4.49992f, -0.0271670f, 0.629647f, -4.49967f, 
		-0.0283590f, 0.631157f, -4.49938f, -0.0295520f, 0.632666f, -4.49909f, 
		-0.0307070f, 0.634128f, -4.49884f, -0.0317870f, 0.635495f, -4.49867f, 
		-0.0327550f, 0.636721f, -4.49861f, -0.0327600f, 0.636727f, -4.49899f, 
		-0.0327650f, 0.636734f, -4.49941f, -0.0327710f, 0.636741f, -4.49986f, 
		-0.0327760f, 0.636747f, -4.50034f, -0.0327810f, 0.636754f, -4.50083f, 
		-0.0327860f, 0.636760f, -4.50133f, -0.0327920f, 0.636767f, -4.50183f, 
		-0.0327970f, 0.636774f, -4.50232f, -0.0328020f, 0.636780f, -4.50280f, 
		-0.0328070f, 0.636787f, -4.50325f, -0.0328130f, 0.636794f, -4.50367f, 
		-1.17765f, 0.636286f, -4.50405f, -1.23164f, 0.568071f, -4.50405f, 
		-1.23171f, 0.567978f, -4.49860f, -1.23073f, 0.569212f, -4.49865f, 
		-1.22964f, 0.570593f, -4.49881f, -1.22847f, 0.572071f, -4.49906f, 
		-1.22726f, 0.573598f, -4.49935f, -1.22606f, 0.575124f, -4.49963f, 
		-1.22488f, 0.576602f, -4.49988f, -1.22379f, 0.577983f, -4.50004f, 
		-1.22282f, 0.579217f, -4.50009f, -1.22199f, 0.580257f, -4.49997f, 
		-1.22136f, 0.581053f, -4.49966f, -1.22096f, 0.581557f, -4.49910f, 
		-1.22083f, 0.581720f, -4.49826f, -1.22081f, 0.581747f, -4.49725f, 
		-1.22071f, 0.581880f, -4.49650f, -1.22052f, 0.582114f, -4.49595f, 
		-1.22026f, 0.582444f, -4.49559f, -1.21993f, 0.582866f, -4.49537f, 
		-1.21953f, 0.583374f, -4.49526f, -1.21906f, 0.583963f, -4.49522f, 
		-1.21853f, 0.584630f, -4.49521f, -1.21795f, 0.585368f, -4.49521f, 
		-1.21731f, 0.586173f, -4.49516f, -1.21662f, 0.587041f, -4.49505f, 
		-1.21589f, 0.587966f, -4.49483f, -1.21512f, 0.588944f, -4.49450f, 
		-1.21430f, 0.589972f, -4.49413f, -1.21345f, 0.591045f, -4.49371f, 
		-1.21257f, 0.592159f, -4.49327f, -1.21166f, 0.593309f, -4.49283f, 
		-1.21073f, 0.594490f, -4.49239f, -1.20977f, 0.595699f, -4.49197f, 
		-1.20880f, 0.596931f, -4.49160f, -1.20781f, 0.598181f, -4.49128f, 
		-1.20681f, 0.599445f, -4.49104f, -1.20580f, 0.600718f, -4.49088f, 
		-1.20479f, 0.601996f, -4.49083f, -1.20378f, 0.603275f, -4.49089f, 
		-1.20277f, 0.604549f, -4.49106f, -1.20177f, 0.605816f, -4.49131f, 
		-1.20077f, 0.607069f, -4.49164f, -1.19980f, 0.608305f, -4.49203f, 
		-1.19884f, 0.609518f, -4.49245f, -1.19790f, 0.610706f, -4.49290f, 
		-1.19698f, 0.611863f, -4.49336f, -1.19609f, 0.612984f, -4.49380f, 
		-1.19524f, 0.614066f, -4.49423f, -1.19442f, 0.615103f, -4.49462f, 
		-1.19363f, 0.616092f, -4.49494f, -1.19289f, 0.617027f, -4.49517f, 
		-1.19220f, 0.617905f, -4.49529f, -1.19155f, 0.618721f, -4.49534f, 
		-1.19096f, 0.619470f, -4.49535f, -1.19042f, 0.620147f, -4.49536f, 
		-1.18995f, 0.620750f, -4.49541f, -1.18953f, 0.621273f, -4.49552f, 
		-1.18919f, 0.621711f, -4.49574f, -1.18891f, 0.622060f, -4.49611f, 
		-1.18871f, 0.622317f, -4.49664f, -1.18858f, 0.622476f, -4.49740f, 
		-1.18854f, 0.622532f, -4.49840f, -1.18839f, 0.622717f, -4.49921f, 
		-1.18798f, 0.623233f, -4.49975f, -1.18735f, 0.624034f, -4.50005f, 
		-1.18653f, 0.625071f, -4.50015f, -1.18556f, 0.626297f, -4.50009f, 
		-1.18447f, 0.627665f, -4.49992f, -1.18332f, 0.629128f, -4.49967f, 
		-1.18212f, 0.630639f, -4.49938f, -1.18093f, 0.632149f, -4.49909f, 
		-1.17977f, 0.633612f, -4.49884f, -1.17868f, 0.634980f, -4.49867f, 
		-1.17771f, 0.636207f, -4.49861f, -1.17771f, 0.636213f, -4.49899f, 
		-1.17770f, 0.636220f, -4.49941f, -1.17770f, 0.636227f, -4.49986f, 
		-1.17769f, 0.636233f, -4.50034f, -1.17769f, 0.636240f, -4.50083f, 
		-1.17768f, 0.636247f, -4.50133f, -1.17768f, 0.636253f, -4.50183f, 
		-1.17767f, 0.636260f, -4.50232f, -1.17767f, 0.636267f, -4.50280f, 
		-1.17766f, 0.636273f, -4.50325f, -1.17766f, 0.636280f, -4.50367f, 
		-1.17785f, 1.32424f, -4.50405f, -1.23187f, 1.39222f, -4.50405f, 
		-1.23195f, 1.39231f, -4.49860f, -1.23097f, 1.39108f, -4.49865f, 
		-1.22987f, 1.38970f, -4.49881f, -1.22870f, 1.38823f, -4.49906f, 
		-1.22749f, 1.38671f, -4.49935f, -1.22628f, 1.38519f, -4.49963f, 
		-1.22511f, 1.38372f, -4.49988f, -1.22402f, 1.38234f, -4.50004f, 
		-1.22304f, 1.38111f, -4.50009f, -1.22222f, 1.38007f, -4.49997f, 
		-1.22159f, 1.37928f, -4.49966f, -1.22119f, 1.37878f, -4.49910f, 
		-1.22106f, 1.37862f, -4.49826f, -1.22104f, 1.37859f, -4.49725f, 
		-1.22093f, 1.37846f, -4.49650f, -1.22075f, 1.37822f, -4.49595f, 
		-1.22049f, 1.37789f, -4.49559f, -1.22015f, 1.37748f, -4.49537f, 
		-1.21975f, 1.37697f, -4.49526f, -1.21929f, 1.37638f, -4.49522f, 
		-1.21876f, 1.37572f, -4.49521f, -1.21817f, 1.37498f, -4.49521f, 
		-1.21754f, 1.37418f, -4.49516f, -1.21685f, 1.37331f, -4.49505f, 
		-1.21611f, 1.37239f, -4.49483f, -1.21534f, 1.37142f, -4.49450f, 
		-1.21453f, 1.37039f, -4.49413f, -1.21368f, 1.36932f, -4.49371f, 
		-1.21279f, 1.36821f, -4.49327f, -1.21188f, 1.36707f, -4.49283f, 
		-1.21095f, 1.36589f, -4.49239f, -1.20999f, 1.36469f, -4.49197f, 
		-1.20902f, 1.36346f, -4.49160f, -1.20802f, 1.36221f, -4.49128f, 
		-1.20702f, 1.36095f, -4.49104f, -1.20601f, 1.35968f, -4.49088f, 
		-1.20500f, 1.35841f, -4.49083f, -1.20399f, 1.35714f, -4.49089f, 
		-1.20298f, 1.35587f, -4.49106f, -1.20198f, 1.35460f, -4.49131f, 
		-1.20099f, 1.35336f, -4.49164f, -1.20001f, 1.35213f, -4.49203f, 
		-1.19905f, 1.35091f, -4.49245f, -1.19810f, 1.34973f, -4.49290f, 
		-1.19719f, 1.34858f, -4.49336f, -1.19630f, 1.34746f, -4.49380f, 
		-1.19544f, 1.34638f, -4.49423f, -1.19462f, 1.34535f, -4.49462f, 
		-1.19384f, 1.34436f, -4.49494f, -1.19310f, 1.34343f, -4.49517f, 
		-1.19240f, 1.34256f, -4.49529f, -1.19176f, 1.34175f, -4.49534f, 
		-1.19116f, 1.34100f, -4.49535f, -1.19063f, 1.34032f, -4.49536f, 
		-1.19015f, 1.33972f, -4.49541f, -1.18974f, 1.33920f, -4.49552f, 
		-1.18939f, 1.33877f, -4.49574f, -1.18911f, 1.33842f, -4.49611f, 
		-1.18891f, 1.33816f, -4.49664f, -1.18878f, 1.33800f, -4.49740f, 
		-1.18874f, 1.33795f, -4.49840f, -1.18859f, 1.33776f, -4.49921f, 
		-1.18818f, 1.33725f, -4.49975f, -1.18755f, 1.33645f, -4.50005f, 
		-1.18673f, 1.33542f, -4.50015f, -1.18576f, 1.33419f, -4.50009f, 
		-1.18467f, 1.33283f, -4.49992f, -1.18351f, 1.33137f, -4.49967f, 
		-1.18232f, 1.32987f, -4.49938f, -1.18112f, 1.32836f, -4.49909f, 
		-1.17997f, 1.32691f, -4.49884f, -1.17888f, 1.32554f, -4.49867f, 
		-1.17791f, 1.32432f, -4.49861f, -1.17790f, 1.32431f, -4.49899f, 
		-1.17790f, 1.32431f, -4.49941f, -1.17789f, 1.32430f, -4.49986f, 
		-1.17789f, 1.32429f, -4.50034f, -1.17788f, 1.32429f, -4.50083f, 
		-1.17788f, 1.32428f, -4.50133f, -1.17787f, 1.32427f, -4.50183f, 
		-1.17787f, 1.32427f, -4.50233f, -1.17786f, 1.32426f, -4.50280f, 
		-1.17786f, 1.32425f, -4.50325f, -1.17785f, 1.32425f, -4.50367f, 
		-1.10571f, 1.32452f, -4.50405f, -1.10586f, 1.39271f, -4.50405f, 
		-1.10586f, 1.39281f, -4.49860f, -1.10586f, 1.39157f, -4.49865f, 
		-1.10585f, 1.39019f, -4.49881f, -1.10585f, 1.38872f, -4.49906f, 
		-1.10585f, 1.38719f, -4.49935f, -1.10584f, 1.38566f, -4.49963f, 
		-1.10584f, 1.38419f, -4.49988f, -1.10584f, 1.38281f, -4.50004f, 
		-1.10583f, 1.38157f, -4.50009f, -1.10583f, 1.38053f, -4.49997f, 
		-1.10583f, 1.37974f, -4.49966f, -1.10583f, 1.37923f, -4.49910f, 
		-1.10583f, 1.37907f, -4.49826f, -1.10583f, 1.37904f, -4.49725f, 
		-1.10583f, 1.37891f, -4.49650f, -1.10583f, 1.37868f, -4.49595f, 
		-1.10583f, 1.37835f, -4.49559f, -1.10583f, 1.37793f, -4.49537f, 
		-1.10583f, 1.37742f, -4.49526f, -1.10582f, 1.37683f, -4.49522f, 
		-1.10582f, 1.37616f, -4.49521f, -1.10582f, 1.37542f, -4.49521f, 
		-1.10582f, 1.37462f, -4.49516f, -1.10582f, 1.37375f, -4.49505f, 
		-1.10582f, 1.37283f, -4.49483f, -1.10581f, 1.37185f, -4.49450f, 
		-1.10581f, 1.37082f, -4.49413f, -1.10581f, 1.36975f, -4.49371f, 
		-1.10581f, 1.36864f, -4.49327f, -1.10580f, 1.36749f, -4.49283f, 
		-1.10580f, 1.36630f, -4.49239f, -1.10580f, 1.36510f, -4.49197f, 
		-1.10580f, 1.36387f, -4.49160f, -1.10579f, 1.36262f, -4.49128f, 
		-1.10579f, 1.36135f, -4.49104f, -1.10579f, 1.36008f, -4.49088f, 
		-1.10579f, 1.35880f, -4.49083f, -1.10578f, 1.35752f, -4.49089f, 
		-1.10578f, 1.35625f, -4.49106f, -1.10578f, 1.35498f, -4.49131f, 
		-1.10577f, 1.35373f, -4.49164f, -1.10577f, 1.35250f, -4.49203f, 
		-1.10577f, 1.35128f, -4.49245f, -1.10577f, 1.35010f, -4.49290f, 
		-1.10576f, 1.34894f, -4.49336f, -1.10576f, 1.34782f, -4.49380f, 
		-1.10576f, 1.34674f, -4.49423f, -1.10576f, 1.34570f, -4.49462f, 
		-1.10575f, 1.34471f, -4.49494f, -1.10575f, 1.34378f, -4.49517f, 
		-1.10575f, 1.34290f, -4.49529f, -1.10575f, 1.34208f, -4.49534f, 
		-1.10575f, 1.34134f, -4.49535f, -1.10575f, 1.34066f, -4.49536f, 
		-1.10574f, 1.34005f, -4.49541f, -1.10574f, 1.33953f, -4.49552f, 
		-1.10574f, 1.33909f, -4.49574f, -1.10574f, 1.33874f, -4.49611f, 
		-1.10574f, 1.33849f, -4.49664f, -1.10574f, 1.33833f, -4.49740f, 
		-1.10574f, 1.33827f, -4.49840f, -1.10574f, 1.33809f, -4.49921f, 
		-1.10574f, 1.33757f, -4.49975f, -1.10574f, 1.33677f, -4.50005f, 
		-1.10574f, 1.33573f, -4.50015f, -1.10573f, 1.33451f, -4.50009f, 
		-1.10573f, 1.33314f, -4.49992f, -1.10573f, 1.33168f, -4.49967f, 
		-1.10572f, 1.33017f, -4.49938f, -1.10572f, 1.32866f, -4.49909f, 
		-1.10572f, 1.32720f, -4.49884f, -1.10571f, 1.32583f, -4.49867f, 
		-1.10571f, 1.32460f, -4.49861f, -1.10571f, 1.32460f, -4.49899f, 
		-1.10571f, 1.32459f, -4.49941f, -1.10571f, 1.32458f, -4.49986f, 
		-1.10571f, 1.32458f, -4.50034f, -1.10571f, 1.32457f, -4.50083f, 
		-1.10571f, 1.32456f, -4.50133f, -1.10571f, 1.32456f, -4.50183f, 
		-1.10571f, 1.32455f, -4.50233f, -1.10571f, 1.32454f, -4.50280f, 
		-1.10571f, 1.32454f, -4.50325f, -1.10571f, 1.32453f, -4.50367f, 
		-1.00582f, 1.32482f, -4.50405f, -1.00592f, 1.39301f, -4.50405f, 
		-1.00592f, 1.39310f, -4.49860f, -1.00592f, 1.39187f, -4.49865f, 
		-1.00592f, 1.39049f, -4.49881f, -1.00592f, 1.38901f, -4.49906f, 
		-1.00592f, 1.38749f, -4.49935f, -1.00591f, 1.38596f, -4.49963f, 
		-1.00591f, 1.38448f, -4.49988f, -1.00591f, 1.38310f, -4.50004f, 
		-1.00591f, 1.38187f, -4.50009f, -1.00590f, 1.38083f, -4.49997f, 
		-1.00590f, 1.38003f, -4.49966f, -1.00590f, 1.37953f, -4.49910f, 
		-1.00590f, 1.37937f, -4.49826f, -1.00590f, 1.37934f, -4.49725f, 
		-1.00590f, 1.37921f, -4.49650f, -1.00590f, 1.37897f, -4.49595f, 
		-1.00590f, 1.37864f, -4.49559f, -1.00590f, 1.37822f, -4.49537f, 
		-1.00590f, 1.37771f, -4.49526f, -1.00590f, 1.37712f, -4.49522f, 
		-1.00590f, 1.37646f, -4.49521f, -1.00590f, 1.37572f, -4.49521f, 
		-1.00590f, 1.37492f, -4.49516f, -1.00589f, 1.37405f, -4.49505f, 
		-1.00589f, 1.37312f, -4.49483f, -1.00589f, 1.37215f, -4.49450f, 
		-1.00589f, 1.37112f, -4.49413f, -1.00589f, 1.37004f, -4.49371f, 
		-1.00589f, 1.36893f, -4.49327f, -1.00588f, 1.36778f, -4.49283f, 
		-1.00588f, 1.36660f, -4.49239f, -1.00588f, 1.36539f, -4.49197f, 
		-1.00588f, 1.36416f, -4.49160f, -1.00588f, 1.36291f, -4.49128f, 
		-1.00587f, 1.36165f, -4.49104f, -1.00587f, 1.36038f, -4.49088f, 
		-1.00587f, 1.35910f, -4.49083f, -1.00587f, 1.35782f, -4.49089f, 
		-1.00586f, 1.35654f, -4.49106f, -1.00586f, 1.35528f, -4.49131f, 
		-1.00586f, 1.35403f, -4.49164f, -1.00586f, 1.35279f, -4.49203f, 
		-1.00586f, 1.35158f, -4.49245f, -1.00586f, 1.35039f, -4.49290f, 
		-1.00585f, 1.34924f, -4.49336f, -1.00585f, 1.34811f, -4.49380f, 
		-1.00585f, 1.34703f, -4.49423f, -1.00585f, 1.34599f, -4.49462f, 
		-1.00585f, 1.34501f, -4.49494f, -1.00585f, 1.34407f, -4.49517f, 
		-1.00584f, 1.34319f, -4.49529f, -1.00584f, 1.34238f, -4.49534f, 
		-1.00584f, 1.34163f, -4.49535f, -1.00584f, 1.34095f, -4.49536f, 
		-1.00584f, 1.34035f, -4.49541f, -1.00584f, 1.33983f, -4.49552f, 
		-1.00584f, 1.33939f, -4.49574f, -1.00584f, 1.33904f, -4.49611f, 
		-1.00584f, 1.33878f, -4.49664f, -1.00584f, 1.33862f, -4.49740f, 
		-1.00584f, 1.33857f, -4.49840f, -1.00584f, 1.33838f, -4.49921f, 
		-1.00584f, 1.33787f, -4.49975f, -1.00583f, 1.33707f, -4.50005f, 
		-1.00583f, 1.33603f, -4.50015f, -1.00583f, 1.33481f, -4.50009f, 
		-1.00583f, 1.33344f, -4.49992f, -1.00583f, 1.33197f, -4.49967f, 
		-1.00582f, 1.33046f, -4.49938f, -1.00582f, 1.32896f, -4.49909f, 
		-1.00582f, 1.32749f, -4.49884f, -1.00582f, 1.32613f, -4.49867f, 
		-1.00582f, 1.32490f, -4.49861f, -1.00582f, 1.32489f, -4.49899f, 
		-1.00582f, 1.32489f, -4.49941f, -1.00582f, 1.32488f, -4.49986f, 
		-1.00582f, 1.32487f, -4.50034f, -1.00582f, 1.32487f, -4.50083f, 
		-1.00582f, 1.32486f, -4.50133f, -1.00582f, 1.32485f, -4.50183f, 
		-1.00582f, 1.32485f, -4.50233f, -1.00582f, 1.32484f, -4.50280f, 
		-1.00582f, 1.32483f, -4.50325f, -1.00582f, 1.32483f, -4.50367f, 
		-0.905846f, 1.32503f, -4.50405f, -0.905922f, 1.39322f, -4.50405f, 
		-0.905922f, 1.39332f, -4.49860f, -0.905921f, 1.39208f, -4.49865f, 
		-0.905919f, 1.39070f, -4.49881f, -0.905917f, 1.38922f, -4.49906f, 
		-0.905916f, 1.38770f, -4.49935f, -0.905914f, 1.38617f, -4.49963f, 
		-0.905912f, 1.38469f, -4.49988f, -0.905911f, 1.38331f, -4.50004f, 
		-0.905909f, 1.38208f, -4.50009f, -0.905908f, 1.38104f, -4.49997f, 
		-0.905907f, 1.38024f, -4.49966f, -0.905907f, 1.37974f, -4.49910f, 
		-0.905907f, 1.37958f, -4.49826f, -0.905907f, 1.37955f, -4.49725f, 
		-0.905906f, 1.37942f, -4.49650f, -0.905906f, 1.37918f, -4.49595f, 
		-0.905906f, 1.37885f, -4.49559f, -0.905905f, 1.37843f, -4.49537f, 
		-0.905905f, 1.37793f, -4.49526f, -0.905904f, 1.37734f, -4.49522f, 
		-0.905903f, 1.37667f, -4.49521f, -0.905903f, 1.37593f, -4.49521f, 
		-0.905902f, 1.37513f, -4.49516f, -0.905901f, 1.37426f, -4.49505f, 
		-0.905900f, 1.37334f, -4.49483f, -0.905899f, 1.37236f, -4.49450f, 
		-0.905897f, 1.37133f, -4.49413f, -0.905896f, 1.37026f, -4.49371f, 
		-0.905895f, 1.36914f, -4.49327f, -0.905894f, 1.36799f, -4.49283f, 
		-0.905892f, 1.36681f, -4.49239f, -0.905891f, 1.36560f, -4.49197f, 
		-0.905890f, 1.36437f, -4.49160f, -0.905888f, 1.36312f, -4.49128f, 
		-0.905887f, 1.36186f, -4.49104f, -0.905885f, 1.36059f, -4.49088f, 
		-0.905884f, 1.35931f, -4.49083f, -0.905883f, 1.35803f, -4.49089f, 
		-0.905881f, 1.35676f, -4.49106f, -0.905880f, 1.35549f, -4.49131f, 
		-0.905878f, 1.35424f, -4.49164f, -0.905877f, 1.35300f, -4.49203f, 
		-0.905876f, 1.35179f, -4.49245f, -0.905874f, 1.35060f, -4.49290f, 
		-0.905873f, 1.34945f, -4.49336f, -0.905872f, 1.34833f, -4.49380f, 
		-0.905871f, 1.34724f, -4.49423f, -0.905869f, 1.34621f, -4.49462f, 
		-0.905868f, 1.34522f, -4.49494f, -0.905867f, 1.34428f, -4.49517f, 
		-0.905866f, 1.34341f, -4.49529f, -0.905865f, 1.34259f, -4.49534f, 
		-0.905865f, 1.34184f, -4.49535f, -0.905864f, 1.34116f, -4.49536f, 
		-0.905863f, 1.34056f, -4.49541f, -0.905863f, 1.34004f, -4.49552f, 
		-0.905862f, 1.33960f, -4.49574f, -0.905862f, 1.33925f, -4.49611f, 
		-0.905861f, 1.33900f, -4.49664f, -0.905861f, 1.33884f, -4.49740f, 
		-0.905861f, 1.33878f, -4.49840f, -0.905861f, 1.33860f, -4.49921f, 
		-0.905860f, 1.33808f, -4.49975f, -0.905859f, 1.33728f, -4.50005f, 
		-0.905858f, 1.33624f, -4.50015f, -0.905857f, 1.33502f, -4.50009f, 
		-0.905855f, 1.33365f, -4.49992f, -0.905854f, 1.33219f, -4.49967f, 
		-0.905852f, 1.33068f, -4.49938f, -0.905850f, 1.32917f, -4.49909f, 
		-0.905849f, 1.32771f, -4.49884f, -0.905847f, 1.32634f, -4.49867f, 
		-0.905846f, 1.32511f, -4.49861f, -0.905846f, 1.32510f, -4.49899f, 
		-0.905846f, 1.32510f, -4.49941f, -0.905846f, 1.32509f, -4.49986f, 
		-0.905846f, 1.32509f, -4.50034f, -0.905846f, 1.32508f, -4.50083f, 
		-0.905846f, 1.32507f, -4.50133f, -0.905846f, 1.32507f, -4.50183f, 
		-0.905846f, 1.32506f, -4.50233f, -0.905846f, 1.32505f, -4.50280f, 
		-0.905846f, 1.32504f, -4.50325f, -0.905846f, 1.32504f, -4.50367f, 
		-0.805816f, 1.32517f, -4.50405f, -0.805865f, 1.39337f, -4.50405f, 
		-0.805865f, 1.39346f, -4.49860f, -0.805864f, 1.39223f, -4.49865f, 
		-0.805863f, 1.39084f, -4.49881f, -0.805862f, 1.38937f, -4.49906f, 
		-0.805861f, 1.38784f, -4.49935f, -0.805860f, 1.38631f, -4.49963f, 
		-0.805859f, 1.38484f, -4.49988f, -0.805858f, 1.38346f, -4.50004f, 
		-0.805857f, 1.38222f, -4.50009f, -0.805856f, 1.38118f, -4.49997f, 
		-0.805855f, 1.38039f, -4.49966f, -0.805855f, 1.37988f, -4.49910f, 
		-0.805855f, 1.37972f, -4.49826f, -0.805855f, 1.37969f, -4.49725f, 
		-0.805855f, 1.37956f, -4.49650f, -0.805855f, 1.37933f, -4.49595f, 
		-0.805854f, 1.37900f, -4.49559f, -0.805854f, 1.37858f, -4.49537f, 
		-0.805854f, 1.37807f, -4.49526f, -0.805853f, 1.37748f, -4.49522f, 
		-0.805853f, 1.37681f, -4.49521f, -0.805852f, 1.37608f, -4.49521f, 
		-0.805852f, 1.37527f, -4.49516f, -0.805851f, 1.37440f, -4.49505f, 
		-0.805851f, 1.37348f, -4.49483f, -0.805850f, 1.37250f, -4.49450f, 
		-0.805849f, 1.37147f, -4.49413f, -0.805848f, 1.37040f, -4.49371f, 
		-0.805847f, 1.36929f, -4.49327f, -0.805847f, 1.36814f, -4.49283f, 
		-0.805846f, 1.36696f, -4.49239f, -0.805845f, 1.36575f, -4.49197f, 
		-0.805844f, 1.36452f, -4.49160f, -0.805843f, 1.36327f, -4.49128f, 
		-0.805842f, 1.36200f, -4.49104f, -0.805841f, 1.36073f, -4.49088f, 
		-0.805840f, 1.35945f, -4.49083f, -0.805839f, 1.35817f, -4.49089f, 
		-0.805839f, 1.35690f, -4.49106f, -0.805838f, 1.35563f, -4.49131f, 
		-0.805837f, 1.35438f, -4.49164f, -0.805836f, 1.35315f, -4.49203f, 
		-0.805835f, 1.35193f, -4.49245f, -0.805834f, 1.35075f, -4.49290f, 
		-0.805833f, 1.34959f, -4.49336f, -0.805833f, 1.34847f, -4.49380f, 
		-0.805832f, 1.34739f, -4.49423f, -0.805831f, 1.34635f, -4.49462f, 
		-0.805830f, 1.34536f, -4.49494f, -0.805830f, 1.34443f, -4.49517f, 
		-0.805829f, 1.34355f, -4.49529f, -0.805828f, 1.34273f, -4.49534f, 
		-0.805828f, 1.34198f, -4.49535f, -0.805827f, 1.34131f, -4.49536f, 
		-0.805827f, 1.34071f, -4.49541f, -0.805827f, 1.34018f, -4.49552f, 
		-0.805826f, 1.33975f, -4.49574f, -0.805826f, 1.33940f, -4.49611f, 
		-0.805826f, 1.33914f, -4.49664f, -0.805826f, 1.33898f, -4.49740f, 
		-0.805826f, 1.33892f, -4.49840f, -0.805825f, 1.33874f, -4.49921f, 
		-0.805825f, 1.33822f, -4.49975f, -0.805825f, 1.33742f, -4.50005f, 
		-0.805824f, 1.33639f, -4.50015f, -0.805823f, 1.33516f, -4.50009f, 
		-0.805822f, 1.33379f, -4.49992f, -0.805821f, 1.33233f, -4.49967f, 
		-0.805820f, 1.33082f, -4.49938f, -0.805819f, 1.32931f, -4.49909f, 
		-0.805818f, 1.32785f, -4.49884f, -0.805817f, 1.32648f, -4.49867f, 
		-0.805816f, 1.32525f, -4.49861f, -0.805816f, 1.32525f, -4.49899f, 
		-0.805816f, 1.32524f, -4.49941f, -0.805816f, 1.32523f, -4.49986f, 
		-0.805816f, 1.32523f, -4.50034f, -0.805816f, 1.32522f, -4.50083f, 
		-0.805816f, 1.32521f, -4.50133f, -0.805816f, 1.32521f, -4.50183f, 
		-0.805816f, 1.32520f, -4.50233f, -0.805816f, 1.32519f, -4.50280f, 
		-0.805816f, 1.32519f, -4.50325f, -0.805816f, 1.32518f, -4.50367f, 
		-0.705736f, 1.32526f, -4.50405f, -0.705764f, 1.39345f, -4.50405f, 
		-0.705764f, 1.39355f, -4.49860f, -0.705764f, 1.39231f, -4.49865f, 
		-0.705763f, 1.39093f, -4.49881f, -0.705763f, 1.38945f, -4.49906f, 
		-0.705762f, 1.38793f, -4.49935f, -0.705761f, 1.38640f, -4.49963f, 
		-0.705761f, 1.38492f, -4.49988f, -0.705760f, 1.38354f, -4.50004f, 
		-0.705760f, 1.38231f, -4.50009f, -0.705759f, 1.38127f, -4.49997f, 
		-0.705759f, 1.38048f, -4.49966f, -0.705759f, 1.37997f, -4.49910f, 
		-0.705759f, 1.37981f, -4.49826f, -0.705759f, 1.37978f, -4.49725f, 
		-0.705759f, 1.37965f, -4.49650f, -0.705759f, 1.37941f, -4.49595f, 
		-0.705758f, 1.37908f, -4.49559f, -0.705758f, 1.37866f, -4.49537f, 
		-0.705758f, 1.37815f, -4.49526f, -0.705758f, 1.37757f, -4.49522f, 
		-0.705757f, 1.37690f, -4.49521f, -0.705757f, 1.37616f, -4.49521f, 
		-0.705757f, 1.37536f, -4.49516f, -0.705756f, 1.37449f, -4.49505f, 
		-0.705756f, 1.37356f, -4.49483f, -0.705756f, 1.37259f, -4.49450f, 
		-0.705755f, 1.37156f, -4.49413f, -0.705755f, 1.37049f, -4.49371f, 
		-0.705754f, 1.36937f, -4.49327f, -0.705754f, 1.36822f, -4.49283f, 
		-0.705753f, 1.36704f, -4.49239f, -0.705753f, 1.36583f, -4.49197f, 
		-0.705752f, 1.36460f, -4.49160f, -0.705752f, 1.36335f, -4.49128f, 
		-0.705751f, 1.36209f, -4.49104f, -0.705751f, 1.36082f, -4.49088f, 
		-0.705750f, 1.35954f, -4.49083f, -0.705750f, 1.35826f, -4.49089f, 
		-0.705749f, 1.35699f, -4.49106f, -0.705749f, 1.35572f, -4.49131f, 
		-0.705748f, 1.35447f, -4.49164f, -0.705748f, 1.35323f, -4.49203f, 
		-0.705747f, 1.35202f, -4.49245f, -0.705747f, 1.35083f, -4.49290f, 
		-0.705746f, 1.34968f, -4.49336f, -0.705746f, 1.34855f, -4.49380f, 
		-0.705745f, 1.34747f, -4.49423f, -0.705745f, 1.34644f, -4.49462f, 
		-0.705744f, 1.34545f, -4.49494f, -0.705744f, 1.34451f, -4.49517f, 
		-0.705744f, 1.34364f, -4.49529f, -0.705743f, 1.34282f, -4.49534f, 
		-0.705743f, 1.34207f, -4.49535f, -0.705743f, 1.34139f, -4.49536f, 
		-0.705743f, 1.34079f, -4.49541f, -0.705742f, 1.34027f, -4.49552f, 
		-0.705742f, 1.33983f, -4.49574f, -0.705742f, 1.33948f, -4.49611f, 
		-0.705742f, 1.33923f, -4.49664f, -0.705742f, 1.33907f, -4.49740f, 
		-0.705742f, 1.33901f, -4.49840f, -0.705742f, 1.33883f, -4.49921f, 
		-0.705741f, 1.33831f, -4.49975f, -0.705741f, 1.33751f, -4.50005f, 
		-0.705741f, 1.33647f, -4.50015f, -0.705740f, 1.33525f, -4.50009f, 
		-0.705740f, 1.33388f, -4.49992f, -0.705739f, 1.33242f, -4.49967f, 
		-0.705738f, 1.33091f, -4.49938f, -0.705738f, 1.32940f, -4.49909f, 
		-0.705737f, 1.32793f, -4.49884f, -0.705737f, 1.32657f, -4.49867f, 
		-0.705736f, 1.32534f, -4.49861f, -0.705736f, 1.32533f, -4.49899f, 
		-0.705736f, 1.32533f, -4.49941f, -0.705736f, 1.32532f, -4.49986f, 
		-0.705736f, 1.32531f, -4.50034f, -0.705736f, 1.32531f, -4.50083f, 
		-0.705736f, 1.32530f, -4.50133f, -0.705736f, 1.32529f, -4.50183f, 
		-0.705736f, 1.32529f, -4.50233f, -0.705736f, 1.32528f, -4.50280f, 
		-0.705736f, 1.32527f, -4.50325f, -0.705736f, 1.32527f, -4.50367f, 
		-0.605619f, 1.32531f, -4.50405f, -0.605632f, 1.39350f, -4.50405f, 
		-0.605632f, 1.39359f, -4.49860f, -0.605632f, 1.39236f, -4.49865f, 
		-0.605631f, 1.39098f, -4.49881f, -0.605631f, 1.38950f, -4.49906f, 
		-0.605631f, 1.38797f, -4.49935f, -0.605631f, 1.38645f, -4.49963f, 
		-0.605630f, 1.38497f, -4.49988f, -0.605630f, 1.38359f, -4.50004f, 
		-0.605630f, 1.38235f, -4.50009f, -0.605630f, 1.38132f, -4.49997f, 
		-0.605629f, 1.38052f, -4.49966f, -0.605629f, 1.38002f, -4.49910f, 
		-0.605629f, 1.37985f, -4.49826f, -0.605629f, 1.37983f, -4.49725f, 
		-0.605629f, 1.37969f, -4.49650f, -0.605629f, 1.37946f, -4.49595f, 
		-0.605629f, 1.37913f, -4.49559f, -0.605629f, 1.37871f, -4.49537f, 
		-0.605629f, 1.37820f, -4.49526f, -0.605629f, 1.37761f, -4.49522f, 
		-0.605629f, 1.37695f, -4.49521f, -0.605629f, 1.37621f, -4.49521f, 
		-0.605628f, 1.37540f, -4.49516f, -0.605628f, 1.37453f, -4.49505f, 
		-0.605628f, 1.37361f, -4.49483f, -0.605628f, 1.37263f, -4.49450f, 
		-0.605628f, 1.37160f, -4.49413f, -0.605627f, 1.37053f, -4.49371f, 
		-0.605627f, 1.36942f, -4.49327f, -0.605627f, 1.36827f, -4.49283f, 
		-0.605627f, 1.36709f, -4.49239f, -0.605627f, 1.36588f, -4.49197f, 
		-0.605626f, 1.36465f, -4.49160f, -0.605626f, 1.36340f, -4.49128f, 
		-0.605626f, 1.36214f, -4.49104f, -0.605626f, 1.36086f, -4.49088f, 
		-0.605625f, 1.35958f, -4.49083f, -0.605625f, 1.35831f, -4.49089f, 
		-0.605625f, 1.35703f, -4.49106f, -0.605624f, 1.35577f, -4.49131f, 
		-0.605624f, 1.35451f, -4.49164f, -0.605624f, 1.35328f, -4.49203f, 
		-0.605624f, 1.35206f, -4.49245f, -0.605624f, 1.35088f, -4.49290f, 
		-0.605623f, 1.34972f, -4.49336f, -0.605623f, 1.34860f, -4.49380f, 
		-0.605623f, 1.34752f, -4.49423f, -0.605623f, 1.34648f, -4.49462f, 
		-0.605623f, 1.34549f, -4.49494f, -0.605622f, 1.34456f, -4.49517f, 
		-0.605622f, 1.34368f, -4.49529f, -0.605622f, 1.34287f, -4.49534f, 
		-0.605622f, 1.34212f, -4.49535f, -0.605622f, 1.34144f, -4.49536f, 
		-0.605622f, 1.34084f, -4.49541f, -0.605622f, 1.34031f, -4.49552f, 
		-0.605621f, 1.33988f, -4.49574f, -0.605621f, 1.33953f, -4.49611f, 
		-0.605621f, 1.33927f, -4.49664f, -0.605621f, 1.33911f, -4.49740f, 
		-0.605621f, 1.33906f, -4.49840f, -0.605621f, 1.33887f, -4.49921f, 
		-0.605621f, 1.33835f, -4.49975f, -0.605621f, 1.33756f, -4.50005f, 
		-0.605621f, 1.33652f, -4.50015f, -0.605621f, 1.33529f, -4.50009f, 
		-0.605620f, 1.33392f, -4.49992f, -0.605620f, 1.33246f, -4.49967f, 
		-0.605620f, 1.33095f, -4.49938f, -0.605619f, 1.32944f, -4.49909f, 
		-0.605619f, 1.32798f, -4.49884f, -0.605619f, 1.32661f, -4.49867f, 
		-0.605619f, 1.32539f, -4.49861f, -0.605619f, 1.32538f, -4.49899f, 
		-0.605619f, 1.32537f, -4.49941f, -0.605619f, 1.32537f, -4.49986f, 
		-0.605619f, 1.32536f, -4.50034f, -0.605619f, 1.32535f, -4.50083f, 
		-0.605619f, 1.32535f, -4.50133f, -0.605619f, 1.32534f, -4.50183f, 
		-0.605619f, 1.32533f, -4.50233f, -0.605619f, 1.32533f, -4.50280f, 
		-0.605619f, 1.32532f, -4.50325f, -0.605619f, 1.32531f, -4.50367f, 
		-0.505475f, 1.32532f, -4.50405f, -0.505479f, 1.39351f, -4.50405f, 
		-0.505479f, 1.39361f, -4.49860f, -0.505479f, 1.39237f, -4.49865f, 
		-0.505479f, 1.39099f, -4.49881f, -0.505479f, 1.38952f, -4.49906f, 
		-0.505479f, 1.38799f, -4.49935f, -0.505479f, 1.38646f, -4.49963f, 
		-0.505479f, 1.38499f, -4.49988f, -0.505479f, 1.38361f, -4.50004f, 
		-0.505479f, 1.38237f, -4.50009f, -0.505478f, 1.38133f, -4.49997f, 
		-0.505478f, 1.38054f, -4.49966f, -0.505478f, 1.38003f, -4.49910f, 
		-0.505478f, 1.37987f, -4.49826f, -0.505478f, 1.37984f, -4.49725f, 
		-0.505478f, 1.37971f, -4.49650f, -0.505478f, 1.37948f, -4.49595f, 
		-0.505478f, 1.37915f, -4.49559f, -0.505478f, 1.37873f, -4.49537f, 
		-0.505478f, 1.37822f, -4.49526f, -0.505478f, 1.37763f, -4.49522f, 
		-0.505478f, 1.37696f, -4.49521f, -0.505478f, 1.37622f, -4.49521f, 
		-0.505478f, 1.37542f, -4.49516f, -0.505478f, 1.37455f, -4.49505f, 
		-0.505478f, 1.37363f, -4.49483f, -0.505478f, 1.37265f, -4.49450f, 
		-0.505478f, 1.37162f, -4.49413f, -0.505478f, 1.37055f, -4.49371f, 
		-0.505478f, 1.36944f, -4.49327f, -0.505478f, 1.36829f, -4.49283f, 
		-0.505477f, 1.36711f, -4.49239f, -0.505477f, 1.36590f, -4.49197f, 
		-0.505477f, 1.36467f, -4.49160f, -0.505477f, 1.36342f, -4.49128f, 
		-0.505477f, 1.36215f, -4.49104f, -0.505477f, 1.36088f, -4.49088f, 
		-0.505477f, 1.35960f, -4.49083f, -0.505477f, 1.35832f, -4.49089f, 
		-0.505477f, 1.35705f, -4.49106f, -0.505477f, 1.35578f, -4.49131f, 
		-0.505477f, 1.35453f, -4.49164f, -0.505477f, 1.35330f, -4.49203f, 
		-0.505476f, 1.35208f, -4.49245f, -0.505476f, 1.35090f, -4.49290f, 
		-0.505476f, 1.34974f, -4.49336f, -0.505476f, 1.34862f, -4.49380f, 
		-0.505476f, 1.34754f, -4.49423f, -0.505476f, 1.34650f, -4.49462f, 
		-0.505476f, 1.34551f, -4.49494f, -0.505476f, 1.34458f, -4.49517f, 
		-0.505476f, 1.34370f, -4.49529f, -0.505476f, 1.34288f, -4.49534f, 
		-0.505476f, 1.34213f, -4.49535f, -0.505476f, 1.34146f, -4.49536f, 
		-0.505476f, 1.34086f, -4.49541f, -0.505476f, 1.34033f, -4.49552f, 
		-0.505476f, 1.33989f, -4.49574f, -0.505476f, 1.33955f, -4.49611f, 
		-0.505476f, 1.33929f, -4.49664f, -0.505476f, 1.33913f, -4.49740f, 
		-0.505476f, 1.33907f, -4.49840f, -0.505476f, 1.33889f, -4.49921f, 
		-0.505476f, 1.33837f, -4.49975f, -0.505476f, 1.33757f, -4.50005f, 
		-0.505475f, 1.33654f, -4.50015f, -0.505475f, 1.33531f, -4.50009f, 
		-0.505475f, 1.33394f, -4.49992f, -0.505475f, 1.33248f, -4.49967f, 
		-0.505475f, 1.33097f, -4.49938f, -0.505475f, 1.32946f, -4.49909f, 
		-0.505475f, 1.32800f, -4.49884f, -0.505475f, 1.32663f, -4.49867f, 
		-0.505475f, 1.32540f, -4.49861f, -0.505475f, 1.32540f, -4.49899f, 
		-0.505475f, 1.32539f, -4.49941f, -0.505475f, 1.32538f, -4.49986f, 
		-0.505475f, 1.32538f, -4.50034f, -0.505475f, 1.32537f, -4.50083f, 
		-0.505475f, 1.32536f, -4.50133f, -0.505475f, 1.32536f, -4.50183f, 
		-0.505475f, 1.32535f, -4.50233f, -0.505475f, 1.32534f, -4.50280f, 
		-0.505475f, 1.32534f, -4.50325f, -0.505475f, 1.32533f, -4.50367f, 
		-0.405316f, 1.32533f, -4.50405f, -0.405318f, 1.39352f, -4.50405f, 
		-0.405318f, 1.39361f, -4.49860f, -0.405318f, 1.39238f, -4.49865f, 
		-0.405318f, 1.39100f, -4.49881f, -0.405318f, 1.38952f, -4.49906f, 
		-0.405318f, 1.38799f, -4.49935f, -0.405318f, 1.38647f, -4.49963f, 
		-0.405318f, 1.38499f, -4.49988f, -0.405318f, 1.38361f, -4.50004f, 
		-0.405318f, 1.38238f, -4.50009f, -0.405317f, 1.38134f, -4.49997f, 
		-0.405317f, 1.38054f, -4.49966f, -0.405317f, 1.38004f, -4.49910f, 
		-0.405317f, 1.37987f, -4.49826f, -0.405317f, 1.37985f, -4.49725f, 
		-0.405317f, 1.37971f, -4.49650f, -0.405317f, 1.37948f, -4.49595f, 
		-0.405317f, 1.37915f, -4.49559f, -0.405317f, 1.37873f, -4.49537f, 
		-0.405317f, 1.37822f, -4.49526f, -0.405317f, 1.37763f, -4.49522f, 
		-0.405317f, 1.37697f, -4.49521f, -0.405317f, 1.37623f, -4.49521f, 
		-0.405317f, 1.37542f, -4.49516f, -0.405317f, 1.37456f, -4.49505f, 
		-0.405317f, 1.37363f, -4.49483f, -0.405317f, 1.37265f, -4.49450f, 
		-0.405317f, 1.37162f, -4.49413f, -0.405317f, 1.37055f, -4.49371f, 
		-0.405317f, 1.36944f, -4.49327f, -0.405317f, 1.36829f, -4.49283f, 
		-0.405317f, 1.36711f, -4.49239f, -0.405317f, 1.36590f, -4.49197f, 
		-0.405317f, 1.36467f, -4.49160f, -0.405317f, 1.36342f, -4.49128f, 
		-0.405317f, 1.36216f, -4.49104f, -0.405317f, 1.36088f, -4.49088f, 
		-0.405317f, 1.35960f, -4.49083f, -0.405317f, 1.35833f, -4.49089f, 
		-0.405317f, 1.35705f, -4.49106f, -0.405317f, 1.35579f, -4.49131f, 
		-0.405317f, 1.35453f, -4.49164f, -0.405317f, 1.35330f, -4.49203f, 
		-0.405317f, 1.35209f, -4.49245f, -0.405317f, 1.35090f, -4.49290f, 
		-0.405317f, 1.34974f, -4.49336f, -0.405317f, 1.34862f, -4.49380f, 
		-0.405317f, 1.34754f, -4.49423f, -0.405317f, 1.34650f, -4.49462f, 
		-0.405317f, 1.34552f, -4.49494f, -0.405317f, 1.34458f, -4.49517f, 
		-0.405317f, 1.34370f, -4.49529f, -0.405317f, 1.34289f, -4.49534f, 
		-0.405317f, 1.34214f, -4.49535f, -0.405317f, 1.34146f, -4.49536f, 
		-0.405317f, 1.34086f, -4.49541f, -0.405317f, 1.34034f, -4.49552f, 
		-0.405317f, 1.33990f, -4.49574f, -0.405317f, 1.33955f, -4.49611f, 
		-0.405317f, 1.33929f, -4.49664f, -0.405317f, 1.33913f, -4.49740f, 
		-0.405317f, 1.33908f, -4.49840f, -0.405317f, 1.33889f, -4.49921f, 
		-0.405317f, 1.33838f, -4.49975f, -0.405317f, 1.33758f, -4.50005f, 
		-0.405317f, 1.33654f, -4.50015f, -0.405316f, 1.33531f, -4.50009f, 
		-0.405316f, 1.33395f, -4.49992f, -0.405316f, 1.33248f, -4.49967f, 
		-0.405316f, 1.33097f, -4.49938f, -0.405316f, 1.32946f, -4.49909f, 
		-0.405316f, 1.32800f, -4.49884f, -0.405316f, 1.32663f, -4.49867f, 
		-0.405316f, 1.32541f, -4.49861f, -0.405316f, 1.32540f, -4.49899f, 
		-0.405316f, 1.32539f, -4.49941f, -0.405316f, 1.32539f, -4.49986f, 
		-0.405316f, 1.32538f, -4.50034f, -0.405316f, 1.32537f, -4.50083f, 
		-0.405316f, 1.32537f, -4.50133f, -0.405316f, 1.32536f, -4.50183f, 
		-0.405316f, 1.32535f, -4.50233f, -0.405316f, 1.32535f, -4.50280f, 
		-0.405316f, 1.32534f, -4.50325f, -0.405316f, 1.32533f, -4.50367f, 
		-0.305155f, 1.32533f, -4.50405f, -0.305159f, 1.39352f, -4.50405f, 
		-0.305159f, 1.39362f, -4.49860f, -0.305159f, 1.39238f, -4.49865f, 
		-0.305159f, 1.39100f, -4.49881f, -0.305159f, 1.38952f, -4.49906f, 
		-0.305159f, 1.38800f, -4.49935f, -0.305159f, 1.38647f, -4.49963f, 
		-0.305159f, 1.38499f, -4.49988f, -0.305159f, 1.38361f, -4.50004f, 
		-0.305158f, 1.38238f, -4.50009f, -0.305158f, 1.38134f, -4.49997f, 
		-0.305158f, 1.38054f, -4.49966f, -0.305158f, 1.38004f, -4.49910f, 
		-0.305158f, 1.37988f, -4.49826f, -0.305158f, 1.37985f, -4.49725f, 
		-0.305158f, 1.37972f, -4.49650f, -0.305158f, 1.37948f, -4.49595f, 
		-0.305158f, 1.37915f, -4.49559f, -0.305158f, 1.37873f, -4.49537f, 
		-0.305158f, 1.37822f, -4.49526f, -0.305158f, 1.37764f, -4.49522f, 
		-0.305158f, 1.37697f, -4.49521f, -0.305158f, 1.37623f, -4.49521f, 
		-0.305158f, 1.37543f, -4.49516f, -0.305158f, 1.37456f, -4.49505f, 
		-0.305158f, 1.37363f, -4.49483f, -0.305158f, 1.37266f, -4.49450f, 
		-0.305158f, 1.37163f, -4.49413f, -0.305158f, 1.37056f, -4.49371f, 
		-0.305158f, 1.36944f, -4.49327f, -0.305158f, 1.36829f, -4.49283f, 
		-0.305157f, 1.36711f, -4.49239f, -0.305157f, 1.36590f, -4.49197f, 
		-0.305157f, 1.36467f, -4.49160f, -0.305157f, 1.36342f, -4.49128f, 
		-0.305157f, 1.36216f, -4.49104f, -0.305157f, 1.36089f, -4.49088f, 
		-0.305157f, 1.35961f, -4.49083f, -0.305157f, 1.35833f, -4.49089f, 
		-0.305157f, 1.35706f, -4.49106f, -0.305157f, 1.35579f, -4.49131f, 
		-0.305157f, 1.35454f, -4.49164f, -0.305157f, 1.35330f, -4.49203f, 
		-0.305156f, 1.35209f, -4.49245f, -0.305156f, 1.35090f, -4.49290f, 
		-0.305156f, 1.34975f, -4.49336f, -0.305156f, 1.34862f, -4.49380f, 
		-0.305156f, 1.34754f, -4.49423f, -0.305156f, 1.34651f, -4.49462f, 
		-0.305156f, 1.34552f, -4.49494f, -0.305156f, 1.34458f, -4.49517f, 
		-0.305156f, 1.34371f, -4.49529f, -0.305156f, 1.34289f, -4.49534f, 
		-0.305156f, 1.34214f, -4.49535f, -0.305156f, 1.34146f, -4.49536f, 
		-0.305156f, 1.34086f, -4.49541f, -0.305156f, 1.34034f, -4.49552f, 
		-0.305156f, 1.33990f, -4.49574f, -0.305156f, 1.33955f, -4.49611f, 
		-0.305156f, 1.33930f, -4.49664f, -0.305156f, 1.33914f, -4.49740f, 
		-0.305156f, 1.33908f, -4.49840f, -0.305156f, 1.33889f, -4.49921f, 
		-0.305156f, 1.33838f, -4.49975f, -0.305156f, 1.33758f, -4.50005f, 
		-0.305155f, 1.33654f, -4.50015f, -0.305155f, 1.33532f, -4.50009f, 
		-0.305155f, 1.33395f, -4.49992f, -0.305155f, 1.33249f, -4.49967f, 
		-0.305155f, 1.33098f, -4.49938f, -0.305155f, 1.32947f, -4.49909f, 
		-0.305155f, 1.32800f, -4.49884f, -0.305155f, 1.32664f, -4.49867f, 
		-0.305155f, 1.32541f, -4.49861f, -0.305155f, 1.32540f, -4.49899f, 
		-0.305155f, 1.32540f, -4.49941f, -0.305155f, 1.32539f, -4.49986f, 
		-0.305155f, 1.32538f, -4.50034f, -0.305155f, 1.32538f, -4.50083f, 
		-0.305155f, 1.32537f, -4.50133f, -0.305155f, 1.32536f, -4.50183f, 
		-0.305155f, 1.32536f, -4.50233f, -0.305155f, 1.32535f, -4.50280f, 
		-0.305155f, 1.32534f, -4.50325f, -0.305155f, 1.32534f, -4.50367f, 
		-0.205002f, 1.32535f, -4.50405f, -0.205015f, 1.39354f, -4.50405f, 
		-0.205015f, 1.39363f, -4.49860f, -0.205015f, 1.39240f, -4.49865f, 
		-0.205015f, 1.39102f, -4.49881f, -0.205014f, 1.38954f, -4.49906f, 
		-0.205014f, 1.38802f, -4.49935f, -0.205014f, 1.38649f, -4.49963f, 
		-0.205013f, 1.38501f, -4.49988f, -0.205013f, 1.38363f, -4.50004f, 
		-0.205013f, 1.38240f, -4.50009f, -0.205013f, 1.38136f, -4.49997f, 
		-0.205013f, 1.38056f, -4.49966f, -0.205013f, 1.38006f, -4.49910f, 
		-0.205013f, 1.37989f, -4.49826f, -0.205013f, 1.37987f, -4.49725f, 
		-0.205012f, 1.37973f, -4.49650f, -0.205012f, 1.37950f, -4.49595f, 
		-0.205012f, 1.37917f, -4.49559f, -0.205012f, 1.37875f, -4.49537f, 
		-0.205012f, 1.37824f, -4.49526f, -0.205012f, 1.37765f, -4.49522f, 
		-0.205012f, 1.37699f, -4.49521f, -0.205012f, 1.37625f, -4.49521f, 
		-0.205012f, 1.37544f, -4.49516f, -0.205011f, 1.37458f, -4.49505f, 
		-0.205011f, 1.37365f, -4.49483f, -0.205011f, 1.37267f, -4.49450f, 
		-0.205011f, 1.37165f, -4.49413f, -0.205011f, 1.37057f, -4.49371f, 
		-0.205010f, 1.36946f, -4.49327f, -0.205010f, 1.36831f, -4.49283f, 
		-0.205010f, 1.36713f, -4.49239f, -0.205010f, 1.36592f, -4.49197f, 
		-0.205009f, 1.36469f, -4.49160f, -0.205009f, 1.36344f, -4.49128f, 
		-0.205009f, 1.36218f, -4.49104f, -0.205009f, 1.36090f, -4.49088f, 
		-0.205008f, 1.35963f, -4.49083f, -0.205008f, 1.35835f, -4.49089f, 
		-0.205008f, 1.35707f, -4.49106f, -0.205008f, 1.35581f, -4.49131f, 
		-0.205008f, 1.35456f, -4.49164f, -0.205007f, 1.35332f, -4.49203f, 
		-0.205007f, 1.35211f, -4.49245f, -0.205007f, 1.35092f, -4.49290f, 
		-0.205007f, 1.34976f, -4.49336f, -0.205006f, 1.34864f, -4.49380f, 
		-0.205006f, 1.34756f, -4.49423f, -0.205006f, 1.34652f, -4.49462f, 
		-0.205006f, 1.34554f, -4.49494f, -0.205006f, 1.34460f, -4.49517f, 
		-0.205005f, 1.34372f, -4.49529f, -0.205005f, 1.34291f, -4.49534f, 
		-0.205005f, 1.34216f, -4.49535f, -0.205005f, 1.34148f, -4.49536f, 
		-0.205005f, 1.34088f, -4.49541f, -0.205005f, 1.34036f, -4.49552f, 
		-0.205005f, 1.33992f, -4.49574f, -0.205005f, 1.33957f, -4.49611f, 
		-0.205004f, 1.33931f, -4.49664f, -0.205004f, 1.33915f, -4.49740f, 
		-0.205004f, 1.33910f, -4.49840f, -0.205004f, 1.33891f, -4.49921f, 
		-0.205004f, 1.33840f, -4.49975f, -0.205004f, 1.33760f, -4.50005f, 
		-0.205004f, 1.33656f, -4.50015f, -0.205004f, 1.33533f, -4.50009f, 
		-0.205003f, 1.33397f, -4.49992f, -0.205003f, 1.33250f, -4.49967f, 
		-0.205003f, 1.33099f, -4.49938f, -0.205003f, 1.32948f, -4.49909f, 
		-0.205002f, 1.32802f, -4.49884f, -0.205002f, 1.32665f, -4.49867f, 
		-0.205002f, 1.32543f, -4.49861f, -0.205002f, 1.32542f, -4.49899f, 
		-0.205002f, 1.32542f, -4.49941f, -0.205002f, 1.32541f, -4.49986f, 
		-0.205002f, 1.32540f, -4.50034f, -0.205002f, 1.32539f, -4.50083f, 
		-0.205002f, 1.32539f, -4.50133f, -0.205002f, 1.32538f, -4.50183f, 
		-0.205002f, 1.32537f, -4.50233f, -0.205002f, 1.32537f, -4.50280f, 
		-0.205002f, 1.32536f, -4.50325f, -0.205002f, 1.32536f, -4.50367f, 
		-0.104869f, 1.32539f, -4.50405f, -0.104897f, 1.39358f, -4.50405f, 
		-0.104897f, 1.39368f, -4.49860f, -0.104897f, 1.39244f, -4.49865f, 
		-0.104896f, 1.39106f, -4.49881f, -0.104896f, 1.38959f, -4.49906f, 
		-0.104895f, 1.38806f, -4.49935f, -0.104894f, 1.38653f, -4.49963f, 
		-0.104894f, 1.38506f, -4.49988f, -0.104893f, 1.38368f, -4.50004f, 
		-0.104893f, 1.38244f, -4.50009f, -0.104892f, 1.38140f, -4.49997f, 
		-0.104892f, 1.38061f, -4.49966f, -0.104892f, 1.38010f, -4.49910f, 
		-0.104892f, 1.37994f, -4.49826f, -0.104892f, 1.37991f, -4.49725f, 
		-0.104891f, 1.37978f, -4.49650f, -0.104891f, 1.37955f, -4.49595f, 
		-0.104891f, 1.37922f, -4.49559f, -0.104891f, 1.37880f, -4.49537f, 
		-0.104891f, 1.37829f, -4.49526f, -0.104891f, 1.37770f, -4.49522f, 
		-0.104890f, 1.37703f, -4.49521f, -0.104890f, 1.37629f, -4.49521f, 
		-0.104890f, 1.37549f, -4.49516f, -0.104889f, 1.37462f, -4.49505f, 
		-0.104889f, 1.37370f, -4.49483f, -0.104889f, 1.37272f, -4.49450f, 
		-0.104888f, 1.37169f, -4.49413f, -0.104888f, 1.37062f, -4.49371f, 
		-0.104887f, 1.36951f, -4.49327f, -0.104887f, 1.36836f, -4.49283f, 
		-0.104886f, 1.36717f, -4.49239f, -0.104886f, 1.36597f, -4.49197f, 
		-0.104885f, 1.36474f, -4.49160f, -0.104885f, 1.36348f, -4.49128f, 
		-0.104884f, 1.36222f, -4.49104f, -0.104884f, 1.36095f, -4.49088f, 
		-0.104883f, 1.35967f, -4.49083f, -0.104883f, 1.35839f, -4.49089f, 
		-0.104882f, 1.35712f, -4.49106f, -0.104882f, 1.35585f, -4.49131f, 
		-0.104881f, 1.35460f, -4.49164f, -0.104881f, 1.35336f, -4.49203f, 
		-0.104880f, 1.35215f, -4.49245f, -0.104880f, 1.35097f, -4.49290f, 
		-0.104879f, 1.34981f, -4.49336f, -0.104879f, 1.34869f, -4.49380f, 
		-0.104878f, 1.34761f, -4.49423f, -0.104878f, 1.34657f, -4.49462f, 
		-0.104877f, 1.34558f, -4.49494f, -0.104877f, 1.34465f, -4.49517f, 
		-0.104877f, 1.34377f, -4.49529f, -0.104876f, 1.34295f, -4.49534f, 
		-0.104876f, 1.34220f, -4.49535f, -0.104876f, 1.34153f, -4.49536f, 
		-0.104875f, 1.34092f, -4.49541f, -0.104875f, 1.34040f, -4.49552f, 
		-0.104875f, 1.33996f, -4.49574f, -0.104875f, 1.33961f, -4.49611f, 
		-0.104875f, 1.33936f, -4.49664f, -0.104875f, 1.33920f, -4.49740f, 
		-0.104875f, 1.33914f, -4.49840f, -0.104875f, 1.33896f, -4.49921f, 
		-0.104874f, 1.33844f, -4.49975f, -0.104874f, 1.33764f, -4.50005f, 
		-0.104874f, 1.33660f, -4.50015f, -0.104873f, 1.33538f, -4.50009f, 
		-0.104872f, 1.33401f, -4.49992f, -0.104872f, 1.33255f, -4.49967f, 
		-0.104871f, 1.33104f, -4.49938f, -0.104871f, 1.32953f, -4.49909f, 
		-0.104870f, 1.32807f, -4.49884f, -0.104870f, 1.32670f, -4.49867f, 
		-0.104869f, 1.32547f, -4.49861f, -0.104869f, 1.32547f, -4.49899f, 
		-0.104869f, 1.32546f, -4.49941f, -0.104869f, 1.32545f, -4.49986f, 
		-0.104869f, 1.32545f, -4.50034f, -0.104869f, 1.32544f, -4.50083f, 
		-0.104869f, 1.32543f, -4.50133f, -0.104869f, 1.32543f, -4.50183f, 
		-0.104869f, 1.32542f, -4.50233f, -0.104869f, 1.32541f, -4.50280f, 
		-0.104869f, 1.32541f, -4.50325f, -0.104869f, 1.32540f, -4.50367f, 
		0.143226f, -0.477779f, -4.68726f, 0.143226f, -0.477779f, -4.68726f, 
		0.143226f, -0.477779f, -4.50438f, 0.143226f, -0.477779f, -4.50438f, 
		-1.34887f, -0.477779f, -4.50438f, -1.34887f, -0.477779f, -4.50438f, 
		-1.34887f, -0.477779f, -4.68726f, -1.34887f, -0.477779f, -4.68726f, 
		0.143226f, 1.45049f, -4.68726f, 0.143226f, 1.45049f, -4.68726f, 
		0.143226f, 1.45049f, -4.68726f, 0.143225f, 1.45049f, -4.50438f, 
		0.143225f, 1.45049f, -4.50438f, 0.143225f, 1.45049f, -4.50438f, 
		-1.34887f, 1.45049f, -4.50438f, -1.34887f, 1.45049f, -4.50438f, 
		-1.34887f, 1.45049f, -4.50438f, -1.34887f, 1.45049f, -4.68726f, 
		-1.34887f, 1.45049f, -4.68726f, -1.34887f, 1.45049f, -4.68726f, 
		0.143226f, 0.331084f, -4.50438f, 0.143226f, 0.331084f, -4.50438f, 
		0.143226f, 0.331084f, -4.50438f, 0.143226f, 0.331084f, -4.68726f, 
		0.143226f, 0.331084f, -4.68726f, 0.143226f, 0.331084f, -4.68726f, 
		-1.34887f, 0.331084f, -4.50438f, -1.34887f, 0.331084f, -4.50438f, 
		-1.34887f, 0.331084f, -4.68726f, -1.34887f, 0.331084f, -4.68726f, 
		-0.00792300f, -0.477779f, -4.50438f, -0.00792300f, -0.477779f, -4.50438f, 
		-0.00792300f, -0.477779f, -4.50438f, -1.19772f, -0.477779f, -4.50438f, 
		-1.19772f, -0.477779f, -4.50438f, -1.19772f, -0.477779f, -4.50438f, 
		-0.00792300f, -0.477779f, -4.68726f, -1.19772f, -0.477779f, -4.68726f, 
		-0.00792400f, 1.45049f, -4.50438f, -0.00792400f, 1.45049f, -4.50438f, 
		-1.19772f, 1.45049f, -4.50438f, -1.19772f, 1.45049f, -4.50438f, 
		-0.00792300f, 1.45049f, -4.68726f, -0.00792300f, 1.45049f, -4.68726f, 
		-1.19772f, 1.45049f, -4.68726f, -1.19772f, 1.45049f, -4.68726f, 
		-0.00792400f, 0.331084f, -4.50438f, -0.00792400f, 0.331084f, -4.50438f, 
		-0.00792400f, 0.331084f, -4.50438f, -1.19772f, 0.331084f, -4.50438f, 
		-1.19772f, 0.331084f, -4.50438f, -1.19772f, 0.331084f, -4.50438f, 
		-0.00792300f, 0.331084f, -4.68726f, -1.19772f, 0.331084f, -4.68726f, 
		-1.19772f, -0.870082f, -4.68726f, -1.19772f, -0.870082f, -4.68726f, 
		-0.00792300f, -0.870082f, -4.68726f, -0.00792300f, -0.870082f, -4.68726f, 
		-1.19772f, -0.870082f, -4.50438f, -1.19772f, -0.870082f, -4.50438f, 
		-0.00792300f, -0.870082f, -4.50438f, -0.00792300f, -0.870082f, -4.50438f, 
		-1.34887f, -0.870082f, -4.68726f, -1.34887f, -0.870082f, -4.68726f, 
		-1.34887f, -0.870082f, -4.68726f, -1.34887f, -0.870082f, -4.50438f, 
		-1.34887f, -0.870082f, -4.50438f, -1.34887f, -0.870082f, -4.50438f, 
		0.143226f, -0.870082f, -4.50438f, 0.143226f, -0.870082f, -4.50438f, 
		0.143226f, -0.870082f, -4.50438f, 0.143226f, -0.870082f, -4.68726f, 
		0.143226f, -0.870082f, -4.68726f, 0.143226f, -0.870082f, -4.68726f, 
		-1.19772f, 0.331084f, -4.88297f, -1.19772f, 0.331084f, -4.88297f, 
		-1.19772f, 0.331084f, -4.88297f, -1.19772f, -0.477779f, -4.88297f, 
		-1.19772f, -0.477779f, -4.88297f, -1.19772f, -0.477779f, -4.88297f, 
		-0.00792400f, 0.331084f, -4.88297f, -0.00792400f, 0.331084f, -4.88297f, 
		-0.00792400f, 0.331084f, -4.88297f, -0.00792300f, -0.477779f, -4.88297f, 
		-0.00792300f, -0.477779f, -4.88297f, -0.00792300f, -0.477779f, -4.88297f, 
		-0.169619f, 1.25234f, -4.47466f, -0.163456f, 1.25857f, -4.48752f, 
		-0.218453f, 1.20297f, -4.50377f, -0.221357f, 1.20003f, -4.49813f, 
		-0.219950f, 1.20146f, -4.49799f, -0.218735f, 1.20268f, -4.49764f, 
		-0.217669f, 1.20376f, -4.49714f, -0.216708f, 1.20473f, -4.49653f, 
		-0.215809f, 1.20564f, -4.49586f, -0.214928f, 1.20653f, -4.49519f, 
		-0.214020f, 1.20745f, -4.49457f, -0.213043f, 1.20844f, -4.49403f, 
		-0.211953f, 1.20954f, -4.49364f, -0.210705f, 1.21080f, -4.49343f, 
		-0.209257f, 1.21227f, -4.49347f, -0.207564f, 1.21398f, -4.49380f, 
		-0.206589f, 1.21496f, -4.49216f, -0.205235f, 1.21633f, -4.49068f, 
		-0.203559f, 1.21803f, -4.48937f, -0.201621f, 1.21999f, -4.48823f, 
		-0.199477f, 1.22215f, -4.48727f, -0.197187f, 1.22447f, -4.48649f, 
		-0.194808f, 1.22687f, -4.48589f, -0.192399f, 1.22931f, -4.48549f, 
		-0.190017f, 1.23172f, -4.48527f, -0.187721f, 1.23404f, -4.48525f, 
		-0.185569f, 1.23621f, -4.48543f, -0.183619f, 1.23819f, -4.48582f, 
		-0.183200f, 1.23861f, -4.48585f, -0.182665f, 1.23915f, -4.48560f, 
		-0.182031f, 1.23979f, -4.48513f, -0.181315f, 1.24052f, -4.48447f, 
		-0.180534f, 1.24131f, -4.48365f, -0.179703f, 1.24215f, -4.48272f, 
		-0.178839f, 1.24302f, -4.48171f, -0.177959f, 1.24391f, -4.48067f, 
		-0.177079f, 1.24480f, -4.47962f, -0.176215f, 1.24567f, -4.47861f, 
		-0.175384f, 1.24651f, -4.47768f, -0.174603f, 1.24730f, -4.47687f, 
		-0.169965f, 0.727505f, -4.47466f, -0.163812f, 0.721267f, -4.48752f, 
		-0.218735f, 0.776943f, -4.50377f, -0.221635f, 0.779883f, -4.49813f, 
		-0.220229f, 0.778458f, -4.49799f, -0.219016f, 0.777228f, -4.49764f, 
		-0.217952f, 0.776149f, -4.49714f, -0.216992f, 0.775177f, -4.49653f, 
		-0.216094f, 0.774266f, -4.49586f, -0.215214f, 0.773374f, -4.49519f, 
		-0.214308f, 0.772455f, -4.49457f, -0.213332f, 0.771466f, -4.49403f, 
		-0.212243f, 0.770362f, -4.49364f, -0.210997f, 0.769099f, -4.49343f, 
		-0.209551f, 0.767633f, -4.49347f, -0.207861f, 0.765920f, -4.49380f, 
		-0.206887f, 0.764932f, -4.49216f, -0.205534f, 0.763561f, -4.49068f, 
		-0.203861f, 0.761865f, -4.48937f, -0.201925f, 0.759902f, -4.48823f, 
		-0.199784f, 0.757732f, -4.48727f, -0.197497f, 0.755414f, -4.48649f, 
		-0.195121f, 0.753005f, -4.48589f, -0.192715f, 0.750566f, -4.48549f, 
		-0.190336f, 0.748155f, -4.48527f, -0.188044f, 0.745831f, -4.48525f, 
		-0.185895f, 0.743653f, -4.48543f, -0.183948f, 0.741679f, -4.48582f, 
		-0.183528f, 0.741254f, -4.48585f, -0.182994f, 0.740712f, -4.48560f, 
		-0.182361f, 0.740071f, -4.48513f, -0.181647f, 0.739346f, -4.48447f, 
		-0.180866f, 0.738555f, -4.48365f, -0.180036f, 0.737714f, -4.48272f, 
		-0.179174f, 0.736839f, -4.48171f, -0.178295f, 0.735948f, -4.48067f, 
		-0.177416f, 0.735057f, -4.47962f, -0.176553f, 0.734183f, -4.47861f, 
		-0.175723f, 0.733342f, -4.47768f, -0.174943f, 0.732551f, -4.47687f, 
		-1.04078f, 0.728679f, -4.47466f, -1.04694f, 0.722457f, -4.48752f, 
		-0.991991f, 0.777985f, -4.50377f, -0.989090f, 0.780917f, -4.49813f, 
		-0.990496f, 0.779496f, -4.49799f, -0.991710f, 0.778270f, -4.49764f, 
		-0.992775f, 0.777194f, -4.49714f, -0.993735f, 0.776224f, -4.49653f, 
		-0.994633f, 0.775316f, -4.49586f, -0.995514f, 0.774426f, -4.49519f, 
		-0.996421f, 0.773510f, -4.49457f, -0.997397f, 0.772523f, -4.49403f, 
		-0.998486f, 0.771422f, -4.49364f, -0.999732f, 0.770162f, -4.49343f, 
		-1.00118f, 0.768700f, -4.49347f, -1.00287f, 0.766991f, -4.49380f, 
		-1.00384f, 0.766007f, -4.49216f, -1.00520f, 0.764639f, -4.49068f, 
		-1.00687f, 0.762948f, -4.48937f, -1.00881f, 0.760990f, -4.48823f, 
		-1.01095f, 0.758826f, -4.48727f, -1.01324f, 0.756513f, -4.48649f, 
		-1.01561f, 0.754112f, -4.48589f, -1.01802f, 0.751679f, -4.48549f, 
		-1.02040f, 0.749274f, -4.48527f, -1.02269f, 0.746956f, -4.48525f, 
		-1.02485f, 0.744784f, -4.48543f, -1.02679f, 0.742815f, -4.48582f, 
		-1.02721f, 0.742391f, -4.48585f, -1.02775f, 0.741851f, -4.48560f, 
		-1.02838f, 0.741211f, -4.48513f, -1.02910f, 0.740489f, -4.48447f, 
		-1.02988f, 0.739700f, -4.48365f, -1.03071f, 0.738861f, -4.48272f, 
		-1.03157f, 0.737989f, -4.48171f, -1.03245f, 0.737100f, -4.48067f, 
		-1.03333f, 0.736211f, -4.47962f, -1.03419f, 0.735339f, -4.47861f, 
		-1.03502f, 0.734500f, -4.47768f, -1.03580f, 0.733711f, -4.47687f, 
		-1.04092f, 1.25234f, -4.47466f, -1.04708f, 1.25857f, -4.48752f, 
		-0.992104f, 1.20297f, -4.50377f, -0.989201f, 1.20003f, -4.49813f, 
		-0.990608f, 1.20146f, -4.49799f, -0.991822f, 1.20268f, -4.49764f, 
		-0.992887f, 1.20376f, -4.49714f, -0.993848f, 1.20473f, -4.49653f, 
		-0.994747f, 1.20564f, -4.49586f, -0.995628f, 1.20653f, -4.49519f, 
		-0.996535f, 1.20745f, -4.49457f, -0.997512f, 1.20844f, -4.49403f, 
		-0.998602f, 1.20954f, -4.49364f, -0.999849f, 1.21080f, -4.49343f, 
		-1.00130f, 1.21227f, -4.49347f, -1.00299f, 1.21398f, -4.49380f, 
		-1.00396f, 1.21496f, -4.49216f, -1.00532f, 1.21633f, -4.49068f, 
		-1.00699f, 1.21803f, -4.48937f, -1.00893f, 1.21999f, -4.48823f, 
		-1.01107f, 1.22215f, -4.48727f, -1.01336f, 1.22447f, -4.48649f, 
		-1.01574f, 1.22687f, -4.48589f, -1.01815f, 1.22931f, -4.48549f, 
		-1.02053f, 1.23172f, -4.48527f, -1.02282f, 1.23404f, -4.48525f, 
		-1.02497f, 1.23621f, -4.48543f, -1.02692f, 1.23819f, -4.48582f, 
		-1.02734f, 1.23861f, -4.48585f, -1.02788f, 1.23915f, -4.48560f, 
		-1.02851f, 1.23979f, -4.48513f, -1.02923f, 1.24052f, -4.48447f, 
		-1.03001f, 1.24131f, -4.48365f, -1.03084f, 1.24215f, -4.48272f, 
		-1.03170f, 1.24302f, -4.48171f, -1.03258f, 1.24391f, -4.48067f, 
		-1.03346f, 1.24480f, -4.47962f, -1.03433f, 1.24567f, -4.47861f, 
		-1.03516f, 1.24651f, -4.47768f, -1.03594f, 1.24730f, -4.47687f, 
		-0.944010f, 1.25234f, -4.47466f, -0.944010f, 1.25857f, -4.48752f, 
		-0.944010f, 1.20297f, -4.50377f, -0.944010f, 1.20003f, -4.49813f, 
		-0.944010f, 1.20146f, -4.49799f, -0.944010f, 1.20268f, -4.49764f, 
		-0.944010f, 1.20376f, -4.49714f, -0.944010f, 1.20473f, -4.49653f, 
		-0.944010f, 1.20564f, -4.49586f, -0.944010f, 1.20653f, -4.49519f, 
		-0.944010f, 1.20745f, -4.49457f, -0.944010f, 1.20844f, -4.49403f, 
		-0.944010f, 1.20954f, -4.49364f, -0.944010f, 1.21080f, -4.49343f, 
		-0.944010f, 1.21227f, -4.49347f, -0.944010f, 1.21398f, -4.49380f, 
		-0.944010f, 1.21496f, -4.49216f, -0.944010f, 1.21633f, -4.49068f, 
		-0.944010f, 1.21803f, -4.48937f, -0.944010f, 1.21999f, -4.48823f, 
		-0.944010f, 1.22215f, -4.48727f, -0.944010f, 1.22447f, -4.48649f, 
		-0.944010f, 1.22687f, -4.48589f, -0.944010f, 1.22931f, -4.48549f, 
		-0.944010f, 1.23172f, -4.48527f, -0.944010f, 1.23404f, -4.48525f, 
		-0.944010f, 1.23621f, -4.48543f, -0.944010f, 1.23819f, -4.48582f, 
		-0.944010f, 1.23861f, -4.48585f, -0.944010f, 1.23915f, -4.48560f, 
		-0.944010f, 1.23979f, -4.48513f, -0.944010f, 1.24052f, -4.48447f, 
		-0.944010f, 1.24131f, -4.48365f, -0.944010f, 1.24215f, -4.48272f, 
		-0.944010f, 1.24302f, -4.48171f, -0.944010f, 1.24391f, -4.48067f, 
		-0.944010f, 1.24480f, -4.47962f, -0.944010f, 1.24567f, -4.47861f, 
		-0.944010f, 1.24651f, -4.47768f, -0.944010f, 1.24730f, -4.47687f, 
		-0.865296f, 1.25234f, -4.47466f, -0.865296f, 1.25857f, -4.48752f, 
		-0.865296f, 1.20297f, -4.50377f, -0.865296f, 1.20003f, -4.49813f, 
		-0.865296f, 1.20146f, -4.49799f, -0.865296f, 1.20268f, -4.49764f, 
		-0.865296f, 1.20376f, -4.49714f, -0.865296f, 1.20473f, -4.49653f, 
		-0.865296f, 1.20564f, -4.49586f, -0.865296f, 1.20653f, -4.49519f, 
		-0.865296f, 1.20745f, -4.49457f, -0.865296f, 1.20844f, -4.49403f, 
		-0.865296f, 1.20954f, -4.49364f, -0.865296f, 1.21080f, -4.49343f, 
		-0.865296f, 1.21227f, -4.49347f, -0.865296f, 1.21398f, -4.49380f, 
		-0.865296f, 1.21496f, -4.49216f, -0.865296f, 1.21633f, -4.49068f, 
		-0.865296f, 1.21803f, -4.48937f, -0.865296f, 1.21999f, -4.48823f, 
		-0.865296f, 1.22215f, -4.48727f, -0.865296f, 1.22447f, -4.48649f, 
		-0.865296f, 1.22687f, -4.48589f, -0.865296f, 1.22931f, -4.48549f, 
		-0.865296f, 1.23172f, -4.48527f, -0.865296f, 1.23404f, -4.48525f, 
		-0.865296f, 1.23621f, -4.48543f, -0.865296f, 1.23819f, -4.48582f, 
		-0.865296f, 1.23861f, -4.48585f, -0.865296f, 1.23915f, -4.48560f, 
		-0.865296f, 1.23979f, -4.48513f, -0.865296f, 1.24052f, -4.48447f, 
		-0.865296f, 1.24131f, -4.48365f, -0.865296f, 1.24215f, -4.48272f, 
		-0.865296f, 1.24302f, -4.48171f, -0.865296f, 1.24391f, -4.48067f, 
		-0.865296f, 1.24480f, -4.47962f, -0.865296f, 1.24567f, -4.47861f, 
		-0.865296f, 1.24651f, -4.47768f, -0.865296f, 1.24730f, -4.47687f, 
		-0.782365f, 1.25234f, -4.47466f, -0.782365f, 1.25857f, -4.48752f, 
		-0.782365f, 1.20297f, -4.50377f, -0.782365f, 1.20003f, -4.49813f, 
		-0.782365f, 1.20146f, -4.49799f, -0.782365f, 1.20268f, -4.49764f, 
		-0.782365f, 1.20376f, -4.49714f, -0.782365f, 1.20473f, -4.49653f, 
		-0.782365f, 1.20564f, -4.49586f, -0.782365f, 1.20653f, -4.49519f, 
		-0.782365f, 1.20745f, -4.49457f, -0.782365f, 1.20844f, -4.49403f, 
		-0.782365f, 1.20954f, -4.49364f, -0.782365f, 1.21080f, -4.49343f, 
		-0.782365f, 1.21227f, -4.49347f, -0.782365f, 1.21398f, -4.49380f, 
		-0.782365f, 1.21496f, -4.49216f, -0.782365f, 1.21633f, -4.49068f, 
		-0.782365f, 1.21803f, -4.48937f, -0.782365f, 1.21999f, -4.48823f, 
		-0.782365f, 1.22215f, -4.48727f, -0.782365f, 1.22447f, -4.48649f, 
		-0.782365f, 1.22687f, -4.48589f, -0.782365f, 1.22931f, -4.48549f, 
		-0.782365f, 1.23172f, -4.48527f, -0.782365f, 1.23404f, -4.48525f, 
		-0.782365f, 1.23621f, -4.48543f, -0.782365f, 1.23819f, -4.48582f, 
		-0.782365f, 1.23861f, -4.48585f, -0.782365f, 1.23915f, -4.48560f, 
		-0.782365f, 1.23979f, -4.48513f, -0.782365f, 1.24052f, -4.48447f, 
		-0.782365f, 1.24131f, -4.48365f, -0.782365f, 1.24215f, -4.48272f, 
		-0.782365f, 1.24302f, -4.48171f, -0.782365f, 1.24391f, -4.48067f, 
		-0.782365f, 1.24480f, -4.47962f, -0.782365f, 1.24567f, -4.47861f, 
		-0.782365f, 1.24651f, -4.47768f, -0.782365f, 1.24730f, -4.47687f, 
		-0.697325f, 1.25234f, -4.47466f, -0.697325f, 1.25857f, -4.48752f, 
		-0.697325f, 1.20297f, -4.50377f, -0.697325f, 1.20003f, -4.49813f, 
		-0.697325f, 1.20146f, -4.49799f, -0.697325f, 1.20268f, -4.49764f, 
		-0.697325f, 1.20376f, -4.49714f, -0.697325f, 1.20473f, -4.49653f, 
		-0.697325f, 1.20564f, -4.49586f, -0.697325f, 1.20653f, -4.49519f, 
		-0.697325f, 1.20745f, -4.49457f, -0.697325f, 1.20844f, -4.49403f, 
		-0.697325f, 1.20954f, -4.49364f, -0.697325f, 1.21080f, -4.49343f, 
		-0.697325f, 1.21227f, -4.49347f, -0.697325f, 1.21398f, -4.49380f, 
		-0.697325f, 1.21496f, -4.49216f, -0.697325f, 1.21633f, -4.49068f, 
		-0.697325f, 1.21803f, -4.48937f, -0.697325f, 1.21999f, -4.48823f, 
		-0.697325f, 1.22215f, -4.48727f, -0.697325f, 1.22447f, -4.48649f, 
		-0.697325f, 1.22687f, -4.48589f, -0.697325f, 1.22931f, -4.48549f, 
		-0.697325f, 1.23172f, -4.48527f, -0.697325f, 1.23404f, -4.48525f, 
		-0.697325f, 1.23621f, -4.48543f, -0.697325f, 1.23819f, -4.48582f, 
		-0.697325f, 1.23861f, -4.48585f, -0.697325f, 1.23915f, -4.48560f, 
		-0.697325f, 1.23979f, -4.48513f, -0.697325f, 1.24052f, -4.48447f, 
		-0.697325f, 1.24131f, -4.48365f, -0.697325f, 1.24215f, -4.48272f, 
		-0.697325f, 1.24302f, -4.48171f, -0.697325f, 1.24391f, -4.48067f, 
		-0.697325f, 1.24480f, -4.47962f, -0.697325f, 1.24567f, -4.47861f, 
		-0.697325f, 1.24651f, -4.47768f, -0.697325f, 1.24730f, -4.47687f, 
		-0.612285f, 1.25234f, -4.47466f, -0.612285f, 1.25857f, -4.48752f, 
		-0.612285f, 1.20297f, -4.50377f, -0.612285f, 1.20003f, -4.49813f, 
		-0.612285f, 1.20146f, -4.49799f, -0.612285f, 1.20268f, -4.49764f, 
		-0.612285f, 1.20376f, -4.49714f, -0.612285f, 1.20473f, -4.49653f, 
		-0.612285f, 1.20564f, -4.49586f, -0.612285f, 1.20653f, -4.49519f, 
		-0.612285f, 1.20745f, -4.49457f, -0.612285f, 1.20844f, -4.49403f, 
		-0.612285f, 1.20954f, -4.49364f, -0.612285f, 1.21080f, -4.49343f, 
		-0.612285f, 1.21227f, -4.49347f, -0.612285f, 1.21398f, -4.49380f, 
		-0.612285f, 1.21496f, -4.49216f, -0.612285f, 1.21633f, -4.49068f, 
		-0.612285f, 1.21803f, -4.48937f, -0.612285f, 1.21999f, -4.48823f, 
		-0.612285f, 1.22215f, -4.48727f, -0.612285f, 1.22447f, -4.48649f, 
		-0.612285f, 1.22687f, -4.48589f, -0.612285f, 1.22931f, -4.48549f, 
		-0.612285f, 1.23172f, -4.48527f, -0.612285f, 1.23404f, -4.48525f, 
		-0.612285f, 1.23621f, -4.48543f, -0.612285f, 1.23819f, -4.48582f, 
		-0.612285f, 1.23861f, -4.48585f, -0.612285f, 1.23915f, -4.48560f, 
		-0.612285f, 1.23979f, -4.48513f, -0.612285f, 1.24052f, -4.48447f, 
		-0.612285f, 1.24131f, -4.48365f, -0.612285f, 1.24215f, -4.48272f, 
		-0.612285f, 1.24302f, -4.48171f, -0.612285f, 1.24391f, -4.48067f, 
		-0.612285f, 1.24480f, -4.47962f, -0.612285f, 1.24567f, -4.47861f, 
		-0.612285f, 1.24651f, -4.47768f, -0.612285f, 1.24730f, -4.47687f, 
		-0.529354f, 1.25234f, -4.47466f, -0.529354f, 1.25857f, -4.48752f, 
		-0.529354f, 1.20297f, -4.50377f, -0.529354f, 1.20003f, -4.49813f, 
		-0.529354f, 1.20146f, -4.49799f, -0.529354f, 1.20268f, -4.49764f, 
		-0.529354f, 1.20376f, -4.49714f, -0.529354f, 1.20473f, -4.49653f, 
		-0.529354f, 1.20564f, -4.49586f, -0.529354f, 1.20653f, -4.49519f, 
		-0.529354f, 1.20745f, -4.49457f, -0.529354f, 1.20844f, -4.49403f, 
		-0.529354f, 1.20954f, -4.49364f, -0.529354f, 1.21080f, -4.49343f, 
		-0.529354f, 1.21227f, -4.49347f, -0.529354f, 1.21398f, -4.49380f, 
		-0.529354f, 1.21496f, -4.49216f, -0.529354f, 1.21633f, -4.49068f, 
		-0.529354f, 1.21803f, -4.48937f, -0.529354f, 1.21999f, -4.48823f, 
		-0.529354f, 1.22215f, -4.48727f, -0.529354f, 1.22447f, -4.48649f, 
		-0.529354f, 1.22687f, -4.48589f, -0.529354f, 1.22931f, -4.48549f, 
		-0.529354f, 1.23172f, -4.48527f, -0.529354f, 1.23404f, -4.48525f, 
		-0.529354f, 1.23621f, -4.48543f, -0.529354f, 1.23819f, -4.48582f, 
		-0.529354f, 1.23861f, -4.48585f, -0.529354f, 1.23915f, -4.48560f, 
		-0.529354f, 1.23979f, -4.48513f, -0.529354f, 1.24052f, -4.48447f, 
		-0.529354f, 1.24131f, -4.48365f, -0.529354f, 1.24215f, -4.48272f, 
		-0.529354f, 1.24302f, -4.48171f, -0.529354f, 1.24391f, -4.48067f, 
		-0.529354f, 1.24480f, -4.47962f, -0.529354f, 1.24567f, -4.47861f, 
		-0.529354f, 1.24651f, -4.47768f, -0.529354f, 1.24730f, -4.47687f, 
		-0.450641f, 1.25234f, -4.47466f, -0.450641f, 1.25857f, -4.48752f, 
		-0.450641f, 1.20297f, -4.50377f, -0.450641f, 1.20003f, -4.49813f, 
		-0.450641f, 1.20146f, -4.49799f, -0.450641f, 1.20268f, -4.49764f, 
		-0.450641f, 1.20376f, -4.49714f, -0.450641f, 1.20473f, -4.49653f, 
		-0.450641f, 1.20564f, -4.49586f, -0.450641f, 1.20653f, -4.49519f, 
		-0.450641f, 1.20745f, -4.49457f, -0.450641f, 1.20844f, -4.49403f, 
		-0.450641f, 1.20954f, -4.49364f, -0.450641f, 1.21080f, -4.49343f, 
		-0.450641f, 1.21227f, -4.49347f, -0.450641f, 1.21398f, -4.49380f, 
		-0.450641f, 1.21496f, -4.49216f, -0.450641f, 1.21633f, -4.49068f, 
		-0.450641f, 1.21803f, -4.48937f, -0.450641f, 1.21999f, -4.48823f, 
		-0.450641f, 1.22215f, -4.48727f, -0.450641f, 1.22447f, -4.48649f, 
		-0.450641f, 1.22687f, -4.48589f, -0.450641f, 1.22931f, -4.48549f, 
		-0.450641f, 1.23172f, -4.48527f, -0.450641f, 1.23404f, -4.48525f, 
		-0.450641f, 1.23621f, -4.48543f, -0.450641f, 1.23819f, -4.48582f, 
		-0.450641f, 1.23861f, -4.48585f, -0.450641f, 1.23915f, -4.48560f, 
		-0.450641f, 1.23979f, -4.48513f, -0.450641f, 1.24052f, -4.48447f, 
		-0.450641f, 1.24131f, -4.48365f, -0.450641f, 1.24215f, -4.48272f, 
		-0.450641f, 1.24302f, -4.48171f, -0.450641f, 1.24391f, -4.48067f, 
		-0.450641f, 1.24480f, -4.47962f, -0.450641f, 1.24567f, -4.47861f, 
		-0.450641f, 1.24651f, -4.47768f, -0.450641f, 1.24730f, -4.47687f, 
		-0.378254f, 1.25234f, -4.47466f, -0.378254f, 1.25857f, -4.48752f, 
		-0.378254f, 1.20297f, -4.50377f, -0.378254f, 1.20003f, -4.49813f, 
		-0.378254f, 1.20146f, -4.49799f, -0.378254f, 1.20268f, -4.49764f, 
		-0.378254f, 1.20376f, -4.49714f, -0.378254f, 1.20473f, -4.49653f, 
		-0.378254f, 1.20564f, -4.49586f, -0.378254f, 1.20653f, -4.49519f, 
		-0.378254f, 1.20745f, -4.49457f, -0.378254f, 1.20844f, -4.49403f, 
		-0.378254f, 1.20954f, -4.49364f, -0.378254f, 1.21080f, -4.49343f, 
		-0.378254f, 1.21227f, -4.49347f, -0.378254f, 1.21398f, -4.49380f, 
		-0.378254f, 1.21496f, -4.49216f, -0.378254f, 1.21633f, -4.49068f, 
		-0.378254f, 1.21803f, -4.48937f, -0.378254f, 1.21999f, -4.48823f, 
		-0.378254f, 1.22215f, -4.48727f, -0.378254f, 1.22447f, -4.48649f, 
		-0.378254f, 1.22687f, -4.48589f, -0.378254f, 1.22931f, -4.48549f, 
		-0.378254f, 1.23172f, -4.48527f, -0.378254f, 1.23404f, -4.48525f, 
		-0.378254f, 1.23621f, -4.48543f, -0.378254f, 1.23819f, -4.48582f, 
		-0.378254f, 1.23861f, -4.48585f, -0.378254f, 1.23915f, -4.48560f, 
		-0.378254f, 1.23979f, -4.48513f, -0.378254f, 1.24052f, -4.48447f, 
		-0.378254f, 1.24131f, -4.48365f, -0.378254f, 1.24215f, -4.48272f, 
		-0.378254f, 1.24302f, -4.48171f, -0.378254f, 1.24391f, -4.48067f, 
		-0.378254f, 1.24480f, -4.47962f, -0.378254f, 1.24567f, -4.47861f, 
		-0.378254f, 1.24651f, -4.47768f, -0.378254f, 1.24730f, -4.47687f, 
		-0.314303f, 1.25234f, -4.47466f, -0.314303f, 1.25857f, -4.48752f, 
		-0.314303f, 1.20297f, -4.50377f, -0.314303f, 1.20003f, -4.49813f, 
		-0.314303f, 1.20146f, -4.49799f, -0.314303f, 1.20268f, -4.49764f, 
		-0.314303f, 1.20376f, -4.49714f, -0.314303f, 1.20473f, -4.49653f, 
		-0.314303f, 1.20564f, -4.49586f, -0.314303f, 1.20653f, -4.49519f, 
		-0.314303f, 1.20745f, -4.49457f, -0.314303f, 1.20844f, -4.49403f, 
		-0.314303f, 1.20954f, -4.49364f, -0.314303f, 1.21080f, -4.49343f, 
		-0.314303f, 1.21227f, -4.49347f, -0.314303f, 1.21398f, -4.49380f, 
		-0.314303f, 1.21496f, -4.49216f, -0.314303f, 1.21633f, -4.49068f, 
		-0.314303f, 1.21803f, -4.48937f, -0.314303f, 1.21999f, -4.48823f, 
		-0.314303f, 1.22215f, -4.48727f, -0.314303f, 1.22447f, -4.48649f, 
		-0.314303f, 1.22687f, -4.48589f, -0.314303f, 1.22931f, -4.48549f, 
		-0.314303f, 1.23172f, -4.48527f, -0.314303f, 1.23404f, -4.48525f, 
		-0.314303f, 1.23621f, -4.48543f, -0.314303f, 1.23819f, -4.48582f, 
		-0.314303f, 1.23861f, -4.48585f, -0.314303f, 1.23915f, -4.48560f, 
		-0.314303f, 1.23979f, -4.48513f, -0.314303f, 1.24052f, -4.48447f, 
		-0.314303f, 1.24131f, -4.48365f, -0.314303f, 1.24215f, -4.48272f, 
		-0.314303f, 1.24302f, -4.48171f, -0.314303f, 1.24391f, -4.48067f, 
		-0.314303f, 1.24480f, -4.47962f, -0.314303f, 1.24567f, -4.47861f, 
		-0.314303f, 1.24651f, -4.47768f, -0.314303f, 1.24730f, -4.47687f, 
		-0.260896f, 1.25234f, -4.47466f, -0.260896f, 1.25857f, -4.48752f, 
		-0.260896f, 1.20297f, -4.50377f, -0.260896f, 1.20003f, -4.49813f, 
		-0.260896f, 1.20146f, -4.49799f, -0.260896f, 1.20268f, -4.49764f, 
		-0.260896f, 1.20376f, -4.49714f, -0.260896f, 1.20473f, -4.49653f, 
		-0.260896f, 1.20564f, -4.49586f, -0.260896f, 1.20653f, -4.49519f, 
		-0.260896f, 1.20745f, -4.49457f, -0.260896f, 1.20844f, -4.49403f, 
		-0.260896f, 1.20954f, -4.49364f, -0.260896f, 1.21080f, -4.49343f, 
		-0.260896f, 1.21227f, -4.49347f, -0.260896f, 1.21398f, -4.49380f, 
		-0.260896f, 1.21496f, -4.49216f, -0.260896f, 1.21633f, -4.49068f, 
		-0.260896f, 1.21803f, -4.48937f, -0.260896f, 1.21999f, -4.48823f, 
		-0.260896f, 1.22215f, -4.48727f, -0.260896f, 1.22447f, -4.48649f, 
		-0.260896f, 1.22687f, -4.48589f, -0.260896f, 1.22931f, -4.48549f, 
		-0.260896f, 1.23172f, -4.48527f, -0.260896f, 1.23404f, -4.48525f, 
		-0.260896f, 1.23621f, -4.48543f, -0.260896f, 1.23819f, -4.48582f, 
		-0.260896f, 1.23861f, -4.48585f, -0.260896f, 1.23915f, -4.48560f, 
		-0.260896f, 1.23979f, -4.48513f, -0.260896f, 1.24052f, -4.48447f, 
		-0.260896f, 1.24131f, -4.48365f, -0.260896f, 1.24215f, -4.48272f, 
		-0.260896f, 1.24302f, -4.48171f, -0.260896f, 1.24391f, -4.48067f, 
		-0.260896f, 1.24480f, -4.47962f, -0.260896f, 1.24567f, -4.47861f, 
		-0.260896f, 1.24651f, -4.47768f, -0.260896f, 1.24730f, -4.47687f, 
		-0.220142f, 1.25234f, -4.47466f, -0.220142f, 1.25857f, -4.48752f, 
		-0.220142f, 1.20297f, -4.50377f, -0.220142f, 1.20003f, -4.49813f, 
		-0.220142f, 1.20146f, -4.49799f, -0.220142f, 1.20268f, -4.49764f, 
		-0.220142f, 1.20376f, -4.49714f, -0.220142f, 1.20473f, -4.49653f, 
		-0.220142f, 1.20564f, -4.49586f, -0.220142f, 1.20653f, -4.49519f, 
		-0.220142f, 1.20745f, -4.49457f, -0.220142f, 1.20844f, -4.49403f, 
		-0.220142f, 1.20954f, -4.49364f, -0.220142f, 1.21080f, -4.49343f, 
		-0.220142f, 1.21227f, -4.49347f, -0.220142f, 1.21398f, -4.49380f, 
		-0.220142f, 1.21496f, -4.49216f, -0.220142f, 1.21633f, -4.49068f, 
		-0.220142f, 1.21803f, -4.48937f, -0.220142f, 1.21999f, -4.48823f, 
		-0.220142f, 1.22215f, -4.48727f, -0.220142f, 1.22447f, -4.48649f, 
		-0.220142f, 1.22687f, -4.48589f, -0.220142f, 1.22931f, -4.48549f, 
		-0.220142f, 1.23172f, -4.48527f, -0.220142f, 1.23404f, -4.48525f, 
		-0.220142f, 1.23621f, -4.48543f, -0.220142f, 1.23819f, -4.48582f, 
		-0.220142f, 1.23861f, -4.48585f, -0.220142f, 1.23915f, -4.48560f, 
		-0.220142f, 1.23979f, -4.48513f, -0.220142f, 1.24052f, -4.48447f, 
		-0.220142f, 1.24131f, -4.48365f, -0.220142f, 1.24215f, -4.48272f, 
		-0.220142f, 1.24302f, -4.48171f, -0.220142f, 1.24391f, -4.48067f, 
		-0.220142f, 1.24480f, -4.47962f, -0.220142f, 1.24567f, -4.47861f, 
		-0.220142f, 1.24651f, -4.47768f, -0.220142f, 1.24730f, -4.47687f
	};
	static const GLfloat NormalData[] = {
		0.000000f, 0.000000f, -1.00000f, 1.51839e-006f, 1.00000f, 1.24179e-006f, -0.0434494f, 0.999056f, 1.12238e-006f, 
		-0.631185f, 0.000000f, -0.775632f, 0.000000f, 0.000000f, -1.00000f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 1.00000f, 0.000000f, 0.0434390f, 0.999056f, 0.000000f, 
		0.631178f, 0.000000f, -0.775638f, 1.40576e-006f, 0.998575f, -0.0533686f, 
		1.51839e-006f, 1.00000f, 1.24179e-006f, -0.0434494f, 0.999056f, 1.12238e-006f, 
		0.000000f, 0.000000f, 1.00000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.998576f, -0.0533560f, 0.000000f, 1.00000f, 0.000000f, 
		0.0434390f, 0.999056f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.631185f, 0.000000f, -0.775632f, 
		-0.0434404f, -0.999056f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.631178f, 0.000000f, -0.775638f, 
		0.0434396f, -0.999056f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.998576f, -0.0533567f, 
		-0.0434404f, -0.999056f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.998576f, -0.0533567f, 
		0.0434396f, -0.999056f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 
		0.631178f, 0.000000f, -0.775638f, 0.0434396f, -0.999056f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -0.998576f, -0.0533567f, 
		-1.00000f, 0.000000f, 0.000000f, 0.0434396f, -0.999056f, 0.000000f, 
		1.00000f, 0.000000f, 0.000000f, -0.631185f, 0.000000f, -0.775632f, 
		-0.0434404f, -0.999056f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -0.998576f, -0.0533567f, 1.00000f, 0.000000f, 0.000000f, 
		-0.0434404f, -0.999056f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 
		0.0434390f, 0.999056f, 0.000000f, 0.631178f, 0.000000f, -0.775638f, 
		1.00000f, 0.000000f, 0.000000f, -0.0434494f, 0.999056f, 1.12238e-006f, 
		-0.631185f, 0.000000f, -0.775632f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.998576f, -0.0533560f, -1.00000f, 0.000000f, 0.000000f, 
		0.0434390f, 0.999056f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		1.40576e-006f, 0.998575f, -0.0533686f, 1.00000f, 0.000000f, 0.000000f, 
		-0.0434494f, 0.999056f, 1.12238e-006f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 1.00000f, 0.000000f, 1.51839e-006f, 1.00000f, 1.24179e-006f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.998576f, -0.0533560f, 1.40576e-006f, 0.998575f, -0.0533686f, 
		0.000000f, 1.00000f, 0.000000f, 1.51839e-006f, 1.00000f, 1.24179e-006f, 
		0.000000f, 0.998576f, -0.0533560f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -0.998576f, -0.0533567f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -0.998576f, -0.0533567f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -0.998576f, -0.0533567f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -0.998576f, -0.0533567f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.998576f, -0.0533560f, 
		0.000000f, 0.000000f, 1.00000f, 1.40576e-006f, 0.998575f, -0.0533686f, 
		0.000000f, 0.000000f, -1.00000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.988953f, -0.148231f, 0.000000f, -0.455744f, -0.890111f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0249262f, 0.999689f, 0.000000f, 
		-0.948084f, 0.318020f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.342546f, 0.939501f, 0.000000f, 0.996223f, -0.0868289f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.326203f, -0.945300f, 0.000000f, 
		0.746506f, -0.665378f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0249262f, 0.999689f, 0.000000f, 0.342546f, 0.939501f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.988953f, -0.148231f, 0.000000f, 
		-0.948084f, 0.318020f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.455744f, -0.890111f, 0.000000f, 0.326203f, -0.945300f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.746506f, -0.665378f, 0.000000f, 
		0.996223f, -0.0868289f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0513161f, -0.0383740f, -0.997945f, 
		0.342546f, 0.939501f, 0.000000f, 0.996223f, -0.0868289f, 0.000000f, 
		0.0513161f, -0.0383740f, -0.997945f, 0.0681641f, 0.00339400f, -0.997668f, 
		0.746506f, -0.665378f, 0.000000f, 0.996223f, -0.0868289f, 0.000000f, 
		0.0681641f, 0.00339400f, -0.997668f, 0.326203f, -0.945300f, 0.000000f, 
		0.746506f, -0.665378f, 0.000000f, -0.0330125f, -0.0237003f, -0.999174f, 
		0.0681641f, 0.00339400f, -0.997668f, -0.455744f, -0.890111f, 0.000000f, 
		0.326203f, -0.945300f, 0.000000f, -0.0330125f, -0.0237003f, -0.999174f, 
		-0.988953f, -0.148231f, 0.000000f, -0.455744f, -0.890111f, 0.000000f, 
		-0.0219234f, 0.0337831f, -0.999189f, -0.0249262f, 0.999689f, 0.000000f, 
		-0.948084f, 0.318020f, 0.000000f, -0.0219234f, 0.0337831f, -0.999189f, 
		-0.0330125f, -0.0237003f, -0.999174f, -0.988953f, -0.148231f, 0.000000f, 
		-0.948084f, 0.318020f, 0.000000f, -0.0219234f, 0.0337831f, -0.999189f, 
		0.0513161f, -0.0383740f, -0.997945f, -0.0249262f, 0.999689f, 0.000000f, 
		0.342546f, 0.939501f, 0.000000f, -0.0219234f, 0.0337831f, -0.999189f, 
		0.0513161f, -0.0383740f, -0.997945f, -0.0330125f, -0.0237003f, -0.999174f, 
		0.0681641f, 0.00339400f, -0.997668f, 0.000000f, 0.000000f, -1.00000f, 
		0.402947f, 0.915223f, 0.000000f, 0.135115f, 0.990830f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.335821f, 0.941926f, 0.000000f, 
		-0.937170f, -0.348872f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.335821f, 0.941926f, 0.000000f, 0.135115f, 0.990830f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0448528f, -0.998994f, 0.000000f, 
		-0.937170f, -0.348872f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0247917f, -0.999693f, 0.000000f, -0.0448528f, -0.998994f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.949539f, -0.313648f, 0.000000f, 
		-0.0247917f, -0.999693f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.988246f, -0.152873f, 0.000000f, 0.949539f, -0.313648f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.988246f, -0.152873f, 0.000000f, 
		0.402947f, 0.915223f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.988246f, -0.152873f, 0.000000f, 0.949539f, -0.313648f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0247917f, -0.999693f, 0.000000f, 
		-0.0448528f, -0.998994f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.335821f, 0.941926f, 0.000000f, -0.937170f, -0.348872f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.402947f, 0.915223f, 0.000000f, 
		0.135115f, 0.990830f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.949539f, -0.313648f, 0.000000f, -0.0247917f, -0.999693f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.988246f, -0.152873f, 0.000000f, 
		0.402947f, 0.915223f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.335821f, 0.941926f, 0.000000f, 0.135115f, 0.990830f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0448528f, -0.998994f, 0.000000f, 
		-0.937170f, -0.348872f, 0.000000f, -0.999976f, 0.00689845f, -1.51232e-007f, 
		0.0495710f, -0.998771f, 2.18956e-005f, 0.000000f, 0.000000f, 1.00000f, 
		0.399576f, 0.916700f, 0.000000f, -0.710815f, 0.703379f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.317420f, 0.948285f, 0.000000f, 
		0.911157f, 0.412059f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0318351f, -0.999493f, 0.000000f, 0.961855f, 0.273559f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.399576f, 0.916700f, 0.000000f, 
		0.317420f, 0.948285f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.999976f, 0.00689845f, -1.51232e-007f, -0.710815f, 0.703379f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0495710f, -0.998771f, 2.18956e-005f, 
		-0.0318351f, -0.999493f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.961855f, 0.273559f, 0.000000f, 0.911157f, 0.412059f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.317420f, 0.948285f, 0.000000f, 
		0.911157f, 0.412059f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.961855f, 0.273559f, 0.000000f, 0.911157f, 0.412059f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0318351f, -0.999493f, 0.000000f, 
		0.961855f, 0.273559f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0495710f, -0.998771f, 2.18956e-005f, -0.0318351f, -0.999493f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.999976f, 0.00689845f, -1.51232e-007f, 
		0.0495710f, -0.998771f, 2.18956e-005f, 0.000000f, 0.000000f, -1.00000f, 
		0.399576f, 0.916700f, 0.000000f, -0.710815f, 0.703379f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.999976f, 0.00689845f, -1.51232e-007f, 
		-0.710815f, 0.703379f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.399576f, 0.916700f, 0.000000f, 0.317420f, 0.948285f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0129729f, -0.105390f, -0.994346f, 
		0.0536766f, -0.000507310f, -0.998558f, -0.0401133f, -0.0426577f, -0.998284f, 
		0.0410016f, 0.0257204f, -0.998828f, -0.0330540f, 0.0615610f, -0.997556f, 
		-0.545509f, -0.838105f, 0.000000f, 0.182132f, -0.983274f, 0.000000f, 
		0.0410016f, 0.0257204f, -0.998828f, -0.0330540f, 0.0615610f, -0.997556f, 
		0.769216f, -0.638989f, 0.000000f, 0.998281f, 0.0586047f, 0.000000f, 
		-0.0401133f, -0.0426577f, -0.998284f, -0.0330540f, 0.0615610f, -0.997556f, 
		0.769216f, -0.638989f, 0.000000f, 0.182132f, -0.983274f, 0.000000f, 
		-0.0330540f, 0.0615610f, -0.997556f, -0.128774f, 0.991674f, 0.000000f, 
		0.998281f, 0.0586047f, 0.000000f, -0.0401133f, -0.0426577f, -0.998284f, 
		0.122172f, 0.992509f, 0.000000f, -0.128774f, 0.991674f, 0.000000f, 
		-0.0129729f, -0.105390f, -0.994346f, -0.0401133f, -0.0426577f, -0.998284f, 
		-0.369765f, -0.929125f, 0.000000f, -0.0326253f, 0.999468f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.369765f, -0.929125f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0536766f, -0.000507310f, -0.998558f, 
		-0.988830f, 0.149045f, 0.000000f, 0.0410016f, 0.0257204f, -0.998828f, 
		-0.988830f, 0.149045f, 0.000000f, -0.545509f, -0.838105f, 0.000000f, 
		0.0410016f, 0.0257204f, -0.998828f, 0.000000f, 0.000000f, 1.00000f, 
		-0.369765f, -0.929125f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.988830f, 0.149045f, 0.000000f, 0.122172f, 0.992509f, 0.000000f, 
		-0.128774f, 0.991674f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.769216f, -0.638989f, 0.000000f, 
		0.998281f, 0.0586047f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.545509f, -0.838105f, 0.000000f, 0.182132f, -0.983274f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.369765f, -0.929125f, 0.000000f, 
		-0.0326253f, 0.999468f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.988830f, 0.149045f, 0.000000f, -0.545509f, -0.838105f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.769216f, -0.638989f, 0.000000f, 
		0.182132f, -0.983274f, 0.000000f, -0.128774f, 0.991674f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.998281f, 0.0586047f, 0.000000f, 
		0.999497f, -0.0317051f, 0.000000f, 0.998828f, 0.0155363f, -0.0458464f, 
		0.000000f, 0.000000f, 1.00000f, 0.127456f, -0.990444f, -0.0526816f, 
		0.998968f, 0.00304371f, -0.0453272f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0497923f, -0.998760f, 0.000000f, -0.947033f, 0.321135f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.999793f, 0.0203280f, 0.000000f, 
		-0.837109f, 0.547036f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0497923f, -0.998760f, 0.000000f, 0.127456f, -0.990444f, -0.0526816f, 
		0.000000f, 0.000000f, 1.00000f, 0.998828f, 0.0155363f, -0.0458464f, 
		0.998968f, 0.00304371f, -0.0453272f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, -0.837109f, 0.547036f, 0.000000f, 
		-0.992092f, -0.125509f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.195252f, -0.0606848f, -0.978874f, 0.0412962f, 0.0527362f, -0.997754f, 
		-0.837109f, 0.547036f, 0.000000f, -0.992092f, -0.125509f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.195252f, -0.0606848f, -0.978874f, 0.195252f, -0.0606848f, -0.978874f, 
		0.0412962f, 0.0527362f, -0.997754f, 0.998828f, 0.0155363f, -0.0458464f, 
		0.998968f, 0.00304371f, -0.0453272f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0497923f, -0.998760f, 0.000000f, 0.0412962f, 0.0527362f, -0.997754f, 
		0.127456f, -0.990444f, -0.0526816f, -0.999793f, 0.0203280f, 0.000000f, 
		-0.837109f, 0.547036f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0497923f, -0.998760f, 0.000000f, 
		-0.947033f, 0.321135f, 0.000000f, 0.0412962f, 0.0527362f, -0.997754f, 
		0.127456f, -0.990444f, -0.0526816f, 0.998968f, 0.00304371f, -0.0453272f, 
		0.999497f, -0.0317051f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.195252f, -0.0606848f, -0.978874f, 0.998828f, 0.0155363f, -0.0458464f, 
		-0.947033f, 0.321135f, 0.000000f, -0.992092f, -0.125509f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.837109f, 0.547036f, 0.000000f, 
		-0.992092f, -0.125509f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.947033f, 0.321135f, 0.000000f, -0.992092f, -0.125509f, 0.000000f, 
		-0.0497923f, -0.998760f, 0.000000f, -0.947033f, 0.321135f, 0.000000f, 
		-0.947033f, 0.321135f, 0.000000f, -0.992092f, -0.125509f, 0.000000f, 
		0.00808539f, 0.999967f, 0.000000f, 0.999497f, -0.0317051f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.158381f, 0.987378f, 0.000000f, 
		-0.999793f, 0.0203280f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.158381f, 0.987378f, 0.000000f, 0.00808539f, 0.999967f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.158381f, 0.987378f, 0.000000f, 
		0.00808539f, 0.999967f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.158381f, 0.987378f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.999793f, 0.0203280f, 0.000000f, 0.00808539f, 0.999967f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.999497f, -0.0317051f, 0.000000f, 
		-0.0305105f, 0.0224816f, -0.999282f, -0.0273274f, -0.0845150f, -0.996047f, 
		-0.00870994f, 0.0889539f, -0.995998f, -0.0207864f, 0.0692089f, -0.997386f, 
		0.0318767f, -0.0672796f, -0.997225f, 0.0710834f, 0.0387256f, -0.996718f, 
		-0.0906994f, 0.995878f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.745415f, 0.666601f, 0.000000f, -0.0207864f, 0.0692089f, -0.997386f, 
		0.0710834f, 0.0387256f, -0.996718f, -0.0974492f, 0.995241f, 0.000000f, 
		-0.805054f, 0.593202f, 0.000000f, -0.0305105f, 0.0224816f, -0.999282f, 
		-0.00870994f, 0.0889539f, -0.995998f, -0.989315f, 0.145797f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.414194f, -0.910188f, 0.000000f, -0.0448325f, -0.998995f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0448325f, -0.998995f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0273274f, -0.0845150f, -0.996047f, 
		-0.356871f, -0.934154f, 0.000000f, 0.0318767f, -0.0672796f, -0.997225f, 
		0.653656f, -0.756791f, 0.000000f, -0.356871f, -0.934154f, 0.000000f, 
		0.0318767f, -0.0672796f, -0.997225f, 0.973648f, 0.228057f, 0.000000f, 
		0.653656f, -0.756791f, 0.000000f, 0.0318767f, -0.0672796f, -0.997225f, 
		0.0710834f, 0.0387256f, -0.996718f, 0.745415f, 0.666601f, 0.000000f, 
		0.973648f, 0.228057f, 0.000000f, 0.0710834f, 0.0387256f, -0.996718f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.973648f, 0.228057f, 0.000000f, 0.653656f, -0.756791f, 0.000000f, 
		-0.0448325f, -0.998995f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.356871f, -0.934154f, 0.000000f, -0.0974492f, 0.995241f, 0.000000f, 
		-0.805054f, 0.593202f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0906994f, 0.995878f, 0.000000f, 0.745415f, 0.666601f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.653656f, -0.756791f, 0.000000f, -0.356871f, -0.934154f, 0.000000f, 
		0.745415f, 0.666601f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.973648f, 0.228057f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.989315f, 0.145797f, 0.000000f, 0.560673f, 0.828038f, 0.000000f, 
		-0.414194f, -0.910188f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0448325f, -0.998995f, 0.000000f, -0.0974492f, 0.995241f, 0.000000f, 
		-0.805054f, 0.593202f, 0.000000f, -0.222579f, -0.974915f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0974492f, 0.995241f, 0.000000f, 
		-0.00870994f, 0.0889539f, -0.995998f, -0.0207864f, 0.0692089f, -0.997386f, 
		-0.989315f, 0.145797f, 0.000000f, 0.560673f, 0.828038f, 0.000000f, 
		-0.222579f, -0.974915f, 0.000000f, -0.0974492f, 0.995241f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.0974492f, 0.995241f, 0.000000f, -0.414194f, -0.910188f, 0.000000f, 
		-0.805054f, 0.593202f, 0.000000f, -0.0305105f, 0.0224816f, -0.999282f, 
		0.000000f, 0.000000f, -1.00000f, -0.0273274f, -0.0845150f, -0.996047f, 
		-0.414194f, -0.910188f, 0.000000f, -0.0448325f, -0.998995f, 0.000000f, 
		-0.414194f, -0.910188f, 0.000000f, -0.805054f, 0.593202f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0974492f, 0.995241f, 0.000000f, 
		-0.805054f, 0.593202f, 0.000000f, -0.0974492f, 0.995241f, 0.000000f, 
		-0.805054f, 0.593202f, 0.000000f, -0.414194f, -0.910188f, 0.000000f, 
		-0.805054f, 0.593202f, 0.000000f, -0.414194f, -0.910188f, 0.000000f, 
		-0.805054f, 0.593202f, 0.000000f, -0.0906994f, 0.995878f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0906994f, 0.995878f, 0.000000f, 0.745415f, 0.666601f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0906994f, 0.995878f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, -0.989315f, 0.145797f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, -0.989315f, 0.145797f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, -0.0906994f, 0.995878f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, -0.0906994f, 0.995878f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.989315f, 0.145797f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.989315f, 0.145797f, 0.000000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.989315f, 0.145797f, 0.000000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.0974492f, 0.995241f, 0.000000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.0974492f, 0.995241f, 0.000000f, -0.989315f, 0.145797f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, -0.989315f, 0.145797f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, -0.989315f, 0.145797f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, -0.989315f, 0.145797f, 0.000000f, 
		0.560673f, 0.828038f, 0.000000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.989315f, 0.145797f, 0.000000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.989315f, 0.145797f, 0.000000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.989315f, 0.145797f, 0.000000f, -0.222579f, -0.974915f, 0.000000f, 
		-0.989315f, 0.145797f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.331851f, 0.943332f, 0.000000f, 0.135123f, 0.990829f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.209205f, 0.977872f, 0.000000f, 
		-0.956735f, 0.290960f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.209205f, 0.977872f, 0.000000f, 0.135123f, 0.990829f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0598389f, -0.998208f, 0.000000f, 
		-0.956735f, 0.290960f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0520227f, -0.998646f, 0.000000f, -0.0598389f, -0.998208f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.844899f, -0.534926f, 0.000000f, 
		0.0520227f, -0.998646f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.981911f, 0.189342f, 0.000000f, 0.844899f, -0.534926f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.981911f, 0.189342f, 0.000000f, 
		0.331851f, 0.943332f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.981911f, 0.189342f, 0.000000f, 0.844899f, -0.534926f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0520227f, -0.998646f, 0.000000f, 
		-0.0598389f, -0.998208f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.209205f, 0.977872f, 0.000000f, -0.956735f, 0.290960f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.331851f, 0.943332f, 0.000000f, 
		0.135123f, 0.990829f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.844899f, -0.534926f, 0.000000f, 0.0520227f, -0.998646f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.981911f, 0.189342f, 0.000000f, 
		0.331851f, 0.943332f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.209205f, 0.977872f, 0.000000f, 0.135123f, 0.990829f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0598389f, -0.998208f, 0.000000f, 
		-0.956735f, 0.290960f, 0.000000f, -0.0331952f, -0.0698299f, -0.997006f, 
		0.00395154f, -0.0741257f, -0.997241f, 0.0347051f, 0.0282709f, -0.998998f, 
		-0.0235048f, 0.0322126f, -0.999205f, 0.0621617f, 0.998066f, 0.000000f, 
		-0.0565309f, 0.998401f, 0.000000f, 0.0347051f, 0.0282709f, -0.998998f, 
		-0.0235048f, 0.0322126f, -0.999205f, -0.991463f, -0.130385f, 0.000000f, 
		-0.979122f, 0.203274f, 0.000000f, 0.00395154f, -0.0741257f, -0.997241f, 
		-0.0235048f, 0.0322126f, -0.999205f, -0.991463f, -0.130385f, 0.000000f, 
		-0.0565309f, 0.998401f, 0.000000f, -0.0235048f, 0.0322126f, -0.999205f, 
		-0.109653f, -0.993970f, 0.000000f, -0.979122f, 0.203274f, 0.000000f, 
		0.00395154f, -0.0741257f, -0.997241f, -0.137309f, -0.990528f, 0.000000f, 
		-0.109653f, -0.993970f, 0.000000f, -0.0331952f, -0.0698299f, -0.997006f, 
		0.00395154f, -0.0741257f, -0.997241f, 0.880412f, -0.474209f, 0.000000f, 
		-0.137309f, -0.990528f, 0.000000f, -0.0331952f, -0.0698299f, -0.997006f, 
		0.997748f, 0.0670725f, 0.000000f, 0.880412f, -0.474209f, 0.000000f, 
		-0.0331952f, -0.0698299f, -0.997006f, 0.0347051f, 0.0282709f, -0.998998f, 
		0.997748f, 0.0670725f, 0.000000f, 0.0621617f, 0.998066f, 0.000000f, 
		0.0347051f, 0.0282709f, -0.998998f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.997748f, 0.0670725f, 0.000000f, 
		0.880412f, -0.474209f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.137309f, -0.990528f, 0.000000f, -0.109653f, -0.993970f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.991463f, -0.130385f, 0.000000f, 
		-0.979122f, 0.203274f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0621617f, 0.998066f, 0.000000f, -0.0565309f, 0.998401f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.880412f, -0.474209f, 0.000000f, 
		-0.137309f, -0.990528f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.997748f, 0.0670725f, 0.000000f, 0.0621617f, 0.998066f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.991463f, -0.130385f, 0.000000f, 
		-0.0565309f, 0.998401f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.109653f, -0.993970f, 0.000000f, -0.979122f, 0.203274f, 0.000000f, 
		-0.998697f, 0.0510298f, 0.000000f, -0.0343462f, -0.999410f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.209235f, 0.977865f, 0.000000f, 
		0.135118f, 0.990829f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.331849f, 0.943333f, 0.000000f, 0.981918f, 0.189305f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.230899f, -0.972978f, 0.000000f, 
		0.844913f, -0.534903f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.135118f, 0.990829f, 0.000000f, 0.331849f, 0.943333f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.618326f, 0.785922f, 0.000000f, 
		0.209235f, 0.977865f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0343462f, -0.999410f, 0.000000f, 0.230899f, -0.972978f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.844913f, -0.534903f, 0.000000f, 
		0.981918f, 0.189305f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.331849f, 0.943333f, 0.000000f, 0.981918f, 0.189305f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.844913f, -0.534903f, 0.000000f, 
		0.981918f, 0.189305f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.230899f, -0.972978f, 0.000000f, 0.844913f, -0.534903f, 0.000000f, 
		-0.0343462f, -0.999410f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.230899f, -0.972978f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.998697f, 0.0510298f, 0.000000f, -0.0343462f, -0.999410f, 0.000000f, 
		0.209235f, 0.977865f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.135118f, 0.990829f, 0.000000f, -0.618326f, 0.785922f, 0.000000f, 
		0.209235f, 0.977865f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.135118f, 0.990829f, 0.000000f, 
		0.331849f, 0.943333f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.998697f, 0.0510298f, 0.000000f, -0.618326f, 0.785922f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.998697f, 0.0510298f, 0.000000f, 
		-0.0343462f, -0.999410f, 0.000000f, -0.618326f, 0.785922f, 0.000000f, 
		0.209235f, 0.977865f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.998697f, 0.0510298f, 0.000000f, -0.618326f, 0.785922f, 0.000000f, 
		-0.998697f, 0.0510298f, 0.000000f, -0.618326f, 0.785922f, 0.000000f, 
		0.0698622f, 0.240971f, -0.968015f, 0.0762539f, 0.102044f, -0.991853f, 
		-0.0586639f, 0.0599050f, -0.996479f, -0.114445f, -0.0850360f, -0.989783f, 
		0.0142538f, -0.0853157f, -0.996252f, 0.331842f, 0.943335f, 0.000000f, 
		0.142795f, 0.989752f, 0.000000f, -0.114445f, -0.0850360f, -0.989783f, 
		0.0142538f, -0.0853157f, -0.996252f, -0.278453f, -0.960450f, 0.000000f, 
		-0.997533f, -0.0701962f, 0.000000f, 0.0698622f, 0.240971f, -0.968015f, 
		0.0142538f, -0.0853157f, -0.996252f, -0.997533f, -0.0701962f, 0.000000f, 
		0.142795f, 0.989752f, 0.000000f, 0.0142538f, -0.0853157f, -0.996252f, 
		-0.0196953f, -0.999806f, 0.000000f, -0.999582f, 0.0289093f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0196953f, -0.999806f, 0.000000f, 0.0762539f, 0.102044f, -0.991853f, 
		-0.0156562f, -0.999877f, 0.000000f, -0.0586639f, 0.0599050f, -0.996479f, 
		0.966456f, 0.256832f, 0.000000f, -0.0156562f, -0.999877f, 0.000000f, 
		-0.0586639f, 0.0599050f, -0.996479f, 0.998981f, -0.0451349f, 0.000000f, 
		0.966456f, 0.256832f, 0.000000f, -0.0586639f, 0.0599050f, -0.996479f, 
		-0.114445f, -0.0850360f, -0.989783f, 0.998981f, -0.0451349f, 0.000000f, 
		0.331842f, 0.943335f, 0.000000f, -0.114445f, -0.0850360f, -0.989783f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.998981f, -0.0451349f, 0.000000f, 0.966456f, 0.256832f, 0.000000f, 
		7.46079e-014f, 0.000000f, 1.00000f, -0.0196953f, -0.999806f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0156562f, -0.999877f, 0.000000f, 
		-0.278453f, -0.960450f, 0.000000f, -0.997533f, -0.0701962f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.331842f, 0.943335f, 0.000000f, 0.142795f, 0.989752f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.966456f, 0.256832f, 0.000000f, 
		-0.0156562f, -0.999877f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.998981f, -0.0451349f, 0.000000f, 0.331842f, 0.943335f, 0.000000f, 
		-0.997533f, -0.0701962f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.142795f, 0.989752f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0196953f, -0.999806f, 0.000000f, -0.999582f, 0.0289093f, 0.000000f, 
		-0.757925f, -0.652342f, 0.000000f, -0.278453f, -0.960450f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0698622f, 0.240971f, -0.968015f, 
		0.0762539f, 0.102044f, -0.991853f, -0.278453f, -0.960450f, 0.000000f, 
		-0.997533f, -0.0701962f, 0.000000f, -0.999582f, 0.0289093f, 0.000000f, 
		-0.0196953f, -0.999806f, 0.000000f, 7.46079e-014f, 0.000000f, 1.00000f, 
		-0.757925f, -0.652342f, 0.000000f, -0.278453f, -0.960450f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.757925f, -0.652342f, 0.000000f, 
		-0.278453f, -0.960450f, 0.000000f, -0.999582f, 0.0289093f, 0.000000f, 
		-0.757925f, -0.652342f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0196953f, -0.999806f, 0.000000f, -0.999582f, 0.0289093f, 0.000000f, 
		-0.0196953f, -0.999806f, 0.000000f, -0.999582f, 0.0289093f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 7.46079e-014f, 0.000000f, 1.00000f, 
		-0.999582f, 0.0289093f, 0.000000f, -0.757925f, -0.652342f, 0.000000f, 
		-0.757925f, -0.652342f, 0.000000f, -0.278453f, -0.960450f, 0.000000f, 
		-0.999582f, 0.0289093f, 0.000000f, -0.757925f, -0.652342f, 0.000000f, 
		-0.757925f, -0.652342f, 0.000000f, -0.278453f, -0.960450f, 0.000000f, 
		-0.999582f, 0.0289093f, 0.000000f, -0.757925f, -0.652342f, 0.000000f, 
		-0.999582f, 0.0289093f, 0.000000f, -0.757925f, -0.652342f, 0.000000f, 
		5.03951e-014f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.998775f, 0.0494906f, 0.000000f, -0.440357f, 0.897823f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.743359f, 0.668893f, 0.000000f, 
		-0.893243f, -0.449575f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.743359f, 0.668893f, 0.000000f, -0.440357f, 0.897823f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.720030f, -0.693943f, 0.000000f, 
		-0.893243f, -0.449575f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.243476f, -0.969907f, 0.000000f, -0.720030f, -0.693943f, 0.000000f, 
		5.03951e-014f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.991783f, -0.127932f, 0.000000f, -0.243476f, -0.969907f, 0.000000f, 
		5.03951e-014f, 0.000000f, -1.00000f, 0.965352f, -0.260950f, 0.000000f, 
		0.991783f, -0.127932f, 0.000000f, 5.03951e-014f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.965352f, -0.260950f, 0.000000f, 
		0.998775f, 0.0494906f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.965352f, -0.260950f, 0.000000f, 0.991783f, -0.127932f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.243476f, -0.969907f, 0.000000f, 
		-0.720030f, -0.693943f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.743359f, 0.668893f, 0.000000f, -0.893243f, -0.449575f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.998775f, 0.0494906f, 0.000000f, 
		-0.440357f, 0.897823f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.991783f, -0.127932f, 0.000000f, -0.243476f, -0.969907f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.965352f, -0.260950f, 0.000000f, 
		0.998775f, 0.0494906f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.743359f, 0.668893f, 0.000000f, -0.440357f, 0.897823f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.720030f, -0.693943f, 0.000000f, 
		-0.893243f, -0.449575f, 0.000000f, -0.921019f, 0.389518f, 0.000000f, 
		-0.267800f, -0.963475f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.440425f, 0.897789f, 0.000000f, -0.873127f, 0.487492f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.656926f, 0.753955f, 0.000000f, 
		1.00000f, -0.000257940f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.243480f, -0.969906f, 0.000000f, 0.967567f, -0.252614f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.440425f, 0.897789f, 0.000000f, 
		0.656926f, 0.753955f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.921019f, 0.389518f, 0.000000f, -0.873127f, 0.487492f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.267800f, -0.963475f, 0.000000f, 
		-0.243480f, -0.969906f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.967567f, -0.252614f, 0.000000f, 1.00000f, -0.000257940f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.656926f, 0.753955f, 0.000000f, 
		1.00000f, -0.000257940f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.967567f, -0.252614f, 0.000000f, 1.00000f, -0.000257940f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.243480f, -0.969906f, 0.000000f, 
		0.967567f, -0.252614f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.267800f, -0.963475f, 0.000000f, -0.243480f, -0.969906f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.921019f, 0.389518f, 0.000000f, 
		-0.267800f, -0.963475f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.440425f, 0.897789f, 0.000000f, -0.873127f, 0.487492f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.921019f, 0.389518f, 0.000000f, 
		-0.873127f, 0.487492f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.440425f, 0.897789f, 0.000000f, 0.656926f, 0.753955f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0248943f, 0.0896056f, -0.995666f, 
		0.00536551f, 0.0640195f, -0.997934f, -0.0459062f, -0.0382486f, -0.998213f, 
		-0.000878780f, -0.0634330f, -0.997986f, 0.129365f, 0.991597f, 0.000000f, 
		0.113598f, 0.993527f, 0.000000f, -0.0459062f, -0.0382486f, -0.998213f, 
		-0.000878780f, -0.0634330f, -0.997986f, -0.0228493f, 0.999739f, 0.000000f, 
		-0.989729f, -0.142958f, 0.000000f, 0.00536551f, 0.0640195f, -0.997934f, 
		-0.000878780f, -0.0634330f, -0.997986f, -0.0228493f, 0.999739f, 0.000000f, 
		0.113598f, 0.993527f, 0.000000f, -0.000878780f, -0.0634330f, -0.997986f, 
		-0.155085f, -0.987901f, 0.000000f, -0.989729f, -0.142958f, 0.000000f, 
		0.00536551f, 0.0640195f, -0.997934f, 0.0733165f, -0.997309f, 0.000000f, 
		-0.155085f, -0.987901f, 0.000000f, 0.0248943f, 0.0896056f, -0.995666f, 
		0.00536551f, 0.0640195f, -0.997934f, 0.844903f, -0.534919f, 0.000000f, 
		0.0733165f, -0.997309f, 0.000000f, 0.0248943f, 0.0896056f, -0.995666f, 
		0.960911f, 0.276856f, 0.000000f, 0.844903f, -0.534919f, 0.000000f, 
		0.0248943f, 0.0896056f, -0.995666f, -0.0459062f, -0.0382486f, -0.998213f, 
		0.960911f, 0.276856f, 0.000000f, 0.129365f, 0.991597f, 0.000000f, 
		-0.0459062f, -0.0382486f, -0.998213f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.960911f, 0.276856f, 0.000000f, 
		0.844903f, -0.534919f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0733165f, -0.997309f, 0.000000f, -0.155085f, -0.987901f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0228493f, 0.999739f, 0.000000f, 
		-0.989729f, -0.142958f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.129365f, 0.991597f, 0.000000f, 0.113598f, 0.993527f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.844903f, -0.534919f, 0.000000f, 
		0.0733165f, -0.997309f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.960911f, 0.276856f, 0.000000f, 0.129365f, 0.991597f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0228493f, 0.999739f, 0.000000f, 
		0.113598f, 0.993527f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.155085f, -0.987901f, 0.000000f, -0.989729f, -0.142958f, 0.000000f, 
		-0.0161870f, 0.0455228f, -0.998832f, 0.0232296f, 0.0171739f, -0.999583f, 
		-0.0308351f, -0.0561747f, -0.997945f, 0.0198069f, -0.0398001f, -0.999011f, 
		-0.0730557f, 0.997328f, 0.000000f, 0.197777f, 0.980247f, 0.000000f, 
		-0.0308351f, -0.0561747f, -0.997945f, 0.0198069f, -0.0398001f, -0.999011f, 
		-0.995506f, 0.0947039f, 0.000000f, -1.00000f, 0.000539330f, 0.000000f, 
		0.0232296f, 0.0171739f, -0.999583f, 0.0198069f, -0.0398001f, -0.999011f, 
		-0.995506f, 0.0947039f, 0.000000f, 0.197777f, 0.980247f, 0.000000f, 
		0.0198069f, -0.0398001f, -0.999011f, 0.201200f, -0.979550f, 0.000000f, 
		-1.00000f, 0.000539330f, 0.000000f, 0.0232296f, 0.0171739f, -0.999583f, 
		-0.0373188f, -0.999303f, 0.000000f, 0.201200f, -0.979550f, 0.000000f, 
		-0.0161870f, 0.0455228f, -0.998832f, 0.0232296f, 0.0171739f, -0.999583f, 
		0.844903f, -0.534919f, 0.000000f, -0.0373188f, -0.999303f, 0.000000f, 
		-0.0161870f, 0.0455228f, -0.998832f, 0.970859f, 0.239652f, 0.000000f, 
		0.844903f, -0.534919f, 0.000000f, -0.0161870f, 0.0455228f, -0.998832f, 
		-0.0308351f, -0.0561747f, -0.997945f, 0.970859f, 0.239652f, 0.000000f, 
		-0.0730557f, 0.997328f, 0.000000f, -0.0308351f, -0.0561747f, -0.997945f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.970859f, 0.239652f, 0.000000f, 0.844903f, -0.534919f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0373188f, -0.999303f, 0.000000f, 
		0.201200f, -0.979550f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.995506f, 0.0947039f, 0.000000f, -1.00000f, 0.000539330f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0730557f, 0.997328f, 0.000000f, 
		0.197777f, 0.980247f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.844903f, -0.534919f, 0.000000f, -0.0373188f, -0.999303f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.970859f, 0.239652f, 0.000000f, 
		-0.0730557f, 0.997328f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.995506f, 0.0947039f, 0.000000f, 0.197777f, 0.980247f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.201200f, -0.979550f, 0.000000f, 
		-1.00000f, 0.000539330f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.189667f, 0.981848f, 0.000000f, -0.0949501f, 0.995482f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.240947f, 0.970538f, 0.000000f, 
		-0.973400f, -0.229113f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.240947f, 0.970538f, 0.000000f, -0.0949501f, 0.995482f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0567076f, -0.998391f, 0.000000f, 
		-0.973400f, -0.229113f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0195502f, -0.999809f, 0.000000f, -0.0567076f, -0.998391f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.955943f, 0.293552f, 0.000000f, 
		0.0195502f, -0.999809f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.967096f, -0.254411f, 0.000000f, 0.955943f, 0.293552f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.967096f, -0.254411f, 0.000000f, 
		0.189667f, 0.981848f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0112391f, -0.0645230f, 0.997853f, -0.0363954f, -0.0120061f, 0.999265f, 
		0.0310187f, 0.0304099f, 0.999056f, -0.0231203f, 0.0348199f, 0.999126f, 
		-0.0363954f, -0.0120061f, 0.999265f, -0.0231203f, 0.0348199f, 0.999126f, 
		0.967096f, -0.254411f, 0.000000f, 0.955943f, 0.293552f, 0.000000f, 
		0.0310187f, 0.0304099f, 0.999056f, -0.0231203f, 0.0348199f, 0.999126f, 
		0.0195502f, -0.999809f, 0.000000f, -0.0567076f, -0.998391f, 0.000000f, 
		0.0112391f, -0.0645230f, 0.997853f, 0.0310187f, 0.0304099f, 0.999056f, 
		-0.240947f, 0.970538f, 0.000000f, -0.973400f, -0.229113f, 0.000000f, 
		0.0112391f, -0.0645230f, 0.997853f, -0.0363954f, -0.0120061f, 0.999265f, 
		0.189667f, 0.981848f, 0.000000f, -0.0949501f, 0.995482f, 0.000000f, 
		-0.0231203f, 0.0348199f, 0.999126f, 0.955943f, 0.293552f, 0.000000f, 
		0.0195502f, -0.999809f, 0.000000f, -0.0363954f, -0.0120061f, 0.999265f, 
		0.967096f, -0.254411f, 0.000000f, 0.189667f, 0.981848f, 0.000000f, 
		0.0112391f, -0.0645230f, 0.997853f, -0.240947f, 0.970538f, 0.000000f, 
		-0.0949501f, 0.995482f, 0.000000f, 0.0310187f, 0.0304099f, 0.999056f, 
		-0.0567076f, -0.998391f, 0.000000f, -0.973400f, -0.229113f, 0.000000f, 
		0.0198328f, -0.00641211f, -0.999783f, 0.00994040f, 0.0279834f, -0.999559f, 
		-0.0103422f, 0.0164503f, -0.999811f, -0.0198073f, -0.0261469f, -0.999462f, 
		0.0175279f, -0.0196154f, -0.999654f, 0.0333344f, 0.999444f, 0.000000f, 
		-0.523913f, 0.851772f, 0.000000f, -0.0198073f, -0.0261469f, -0.999462f, 
		0.0175279f, -0.0196154f, -0.999654f, -0.951506f, 0.307630f, 0.000000f, 
		-0.761135f, 0.648593f, 0.000000f, 0.0198328f, -0.00641211f, -0.999783f, 
		0.0175279f, -0.0196154f, -0.999654f, -0.761135f, 0.648593f, 0.000000f, 
		-0.523913f, 0.851772f, 0.000000f, 0.0175279f, -0.0196154f, -0.999654f, 
		0.0419641f, -0.999119f, 0.000000f, -0.673469f, -0.739216f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0419641f, -0.999119f, 0.000000f, 0.00994040f, 0.0279834f, -0.999559f, 
		-0.0108701f, -0.999941f, 0.000000f, -0.0103422f, 0.0164503f, -0.999811f, 
		0.994445f, -0.105257f, 0.000000f, -0.0108701f, -0.999941f, 0.000000f, 
		-0.0103422f, 0.0164503f, -0.999811f, 0.768106f, 0.640323f, 0.000000f, 
		0.994445f, -0.105257f, 0.000000f, -0.0103422f, 0.0164503f, -0.999811f, 
		-0.0198073f, -0.0261469f, -0.999462f, 0.768106f, 0.640323f, 0.000000f, 
		0.0333344f, 0.999444f, 0.000000f, -0.0198073f, -0.0261469f, -0.999462f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.768106f, 0.640323f, 0.000000f, 0.994445f, -0.105257f, 0.000000f, 
		0.0419641f, -0.999119f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0108701f, -0.999941f, 0.000000f, -0.951506f, 0.307630f, 0.000000f, 
		-0.761135f, 0.648593f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0333344f, 0.999444f, 0.000000f, 
		-0.523913f, 0.851772f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.994445f, -0.105257f, 0.000000f, -0.0108701f, -0.999941f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.768106f, 0.640323f, 0.000000f, 
		0.0333344f, 0.999444f, 0.000000f, -0.761135f, 0.648593f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.523913f, 0.851772f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0419641f, -0.999119f, 0.000000f, 
		-0.673469f, -0.739216f, 0.000000f, -0.973328f, -0.229420f, 0.000000f, 
		-0.951506f, 0.307630f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0198328f, -0.00641211f, -0.999783f, 0.00994040f, 0.0279834f, -0.999559f, 
		-0.951506f, 0.307630f, 0.000000f, -0.761135f, 0.648593f, 0.000000f, 
		-0.673469f, -0.739216f, 0.000000f, 0.0419641f, -0.999119f, 0.000000f, 
		-0.973328f, -0.229420f, 0.000000f, -0.951506f, 0.307630f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.973328f, -0.229420f, 0.000000f, 
		-0.951506f, 0.307630f, 0.000000f, -0.673469f, -0.739216f, 0.000000f, 
		-0.973328f, -0.229420f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0419641f, -0.999119f, 0.000000f, -0.673469f, -0.739216f, 0.000000f, 
		0.0419641f, -0.999119f, 0.000000f, -0.673469f, -0.739216f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.673469f, -0.739216f, 0.000000f, 
		-0.973328f, -0.229420f, 0.000000f, -0.973328f, -0.229420f, 0.000000f, 
		-0.951506f, 0.307630f, 0.000000f, -0.673469f, -0.739216f, 0.000000f, 
		-0.973328f, -0.229420f, 0.000000f, -0.973328f, -0.229420f, 0.000000f, 
		-0.951506f, 0.307630f, 0.000000f, -0.673469f, -0.739216f, 0.000000f, 
		-0.973328f, -0.229420f, 0.000000f, -0.673469f, -0.739216f, 0.000000f, 
		-0.973328f, -0.229420f, 0.000000f, -0.975806f, -0.218639f, 0.000000f, 
		-0.965328f, -0.261039f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.440423f, 0.897790f, 0.000000f, -0.743349f, 0.668904f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.998775f, 0.0494917f, 0.000000f, 
		0.999860f, -0.0167592f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.285270f, -0.958447f, 0.000000f, 0.985352f, -0.170536f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.440423f, 0.897790f, 0.000000f, 
		0.998775f, 0.0494917f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.975806f, -0.218639f, 0.000000f, -0.743349f, 0.668904f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.965328f, -0.261039f, 0.000000f, 
		0.285270f, -0.958447f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.985352f, -0.170536f, 0.000000f, 0.999860f, -0.0167592f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.998775f, 0.0494917f, 0.000000f, 
		0.999860f, -0.0167592f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.985352f, -0.170536f, 0.000000f, 0.999860f, -0.0167592f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.285270f, -0.958447f, 0.000000f, 
		0.985352f, -0.170536f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.965328f, -0.261039f, 0.000000f, 0.285270f, -0.958447f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.975806f, -0.218639f, 0.000000f, 
		-0.965328f, -0.261039f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.440423f, 0.897790f, 0.000000f, -0.743349f, 0.668904f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.975806f, -0.218639f, 0.000000f, 
		-0.743349f, 0.668904f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.440423f, 0.897790f, 0.000000f, 0.998775f, 0.0494917f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0236316f, 0.0345057f, -0.999125f, 
		0.0201154f, 0.0649826f, -0.997684f, -0.0315671f, 0.0486934f, -0.998315f, 
		-0.0316793f, -0.0394630f, -0.998719f, 0.0169104f, -0.0372727f, -0.999162f, 
		0.0606498f, 0.998159f, 0.000000f, -0.0232290f, 0.999730f, 0.000000f, 
		-0.0316793f, -0.0394630f, -0.998719f, 0.0169104f, -0.0372727f, -0.999162f, 
		-0.953331f, -0.301928f, 0.000000f, -0.565049f, -0.825057f, 0.000000f, 
		0.0236316f, 0.0345057f, -0.999125f, 0.0169104f, -0.0372727f, -0.999162f, 
		-0.953331f, -0.301928f, 0.000000f, -0.0232290f, 0.999730f, 0.000000f, 
		0.0169104f, -0.0372727f, -0.999162f, 0.125582f, -0.992083f, 0.000000f, 
		-0.999514f, 0.0311850f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.125582f, -0.992083f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0201154f, 0.0649826f, -0.997684f, 0.0520383f, -0.998645f, 0.000000f, 
		-0.0315671f, 0.0486934f, -0.998315f, 0.844903f, -0.534919f, 0.000000f, 
		0.0520383f, -0.998645f, 0.000000f, -0.0315671f, 0.0486934f, -0.998315f, 
		0.985754f, 0.168196f, 0.000000f, 0.844903f, -0.534919f, 0.000000f, 
		-0.0315671f, 0.0486934f, -0.998315f, -0.0316793f, -0.0394630f, -0.998719f, 
		0.985754f, 0.168196f, 0.000000f, 0.0606498f, 0.998159f, 0.000000f, 
		-0.0316793f, -0.0394630f, -0.998719f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.985754f, 0.168196f, 0.000000f, 
		0.844903f, -0.534919f, 0.000000f, 0.125582f, -0.992083f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0520383f, -0.998645f, 0.000000f, 
		-0.953331f, -0.301928f, 0.000000f, -0.565049f, -0.825057f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0606498f, 0.998159f, 0.000000f, -0.0232290f, 0.999730f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.844903f, -0.534919f, 0.000000f, 
		0.0520383f, -0.998645f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.985754f, 0.168196f, 0.000000f, 0.0606498f, 0.998159f, 0.000000f, 
		-0.953331f, -0.301928f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0232290f, 0.999730f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.125582f, -0.992083f, 0.000000f, -0.999514f, 0.0311850f, 0.000000f, 
		-0.999514f, 0.0311850f, 0.000000f, -0.565049f, -0.825057f, 0.000000f, 
		0.0236316f, 0.0345057f, -0.999125f, 0.000000f, 0.000000f, -1.00000f, 
		0.0201154f, 0.0649826f, -0.997684f, -0.953331f, -0.301928f, 0.000000f, 
		-0.565049f, -0.825057f, 0.000000f, 0.125582f, -0.992083f, 0.000000f, 
		-0.999514f, 0.0311850f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.999514f, 0.0311850f, 0.000000f, -0.565049f, -0.825057f, 0.000000f, 
		-0.999514f, 0.0311850f, 0.000000f, -0.565049f, -0.825057f, 0.000000f, 
		-0.0326253f, 0.999468f, 0.000000f, 0.122172f, 0.992509f, 0.000000f, 
		-0.0129729f, -0.105390f, -0.994346f, 0.000000f, 0.000000f, -1.00000f, 
		0.0536766f, -0.000507310f, -0.998558f, 0.122172f, 0.992509f, 0.000000f, 
		-0.128774f, 0.991674f, 0.000000f, -0.369765f, -0.929125f, 0.000000f, 
		-0.0326253f, 0.999468f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0326253f, 0.999468f, 0.000000f, 0.122172f, 0.992509f, 0.000000f, 
		-0.0326253f, 0.999468f, 0.000000f, 0.122172f, 0.992509f, 0.000000f, 
		-0.0208445f, 0.0344495f, -0.999189f, 0.000000f, 0.000000f, -1.00000f, 
		-0.692997f, 0.720941f, 0.000000f, -0.0442807f, 0.999019f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.819919f, 0.572480f, 0.000000f, 
		-0.774206f, -0.632934f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0442807f, 0.999019f, 0.000000f, -0.819919f, 0.572480f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.746226f, -0.665693f, 0.000000f, 
		-0.774206f, -0.632934f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0326097f, -0.0229665f, -0.999204f, -0.999758f, -0.0219993f, 0.000000f, 
		-0.746226f, -0.665693f, 0.000000f, -0.0208445f, 0.0344495f, -0.999189f, 
		0.000000f, 0.000000f, -1.00000f, -0.0326097f, -0.0229665f, -0.999204f, 
		0.922233f, -0.386635f, 0.000000f, 0.861218f, -0.508236f, 0.000000f, 
		-0.0208445f, 0.0344495f, -0.999189f, 0.945360f, -0.326029f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.861218f, -0.508236f, 0.000000f, 
		-0.0208445f, 0.0344495f, -0.999189f, 0.945360f, -0.326029f, 0.000000f, 
		0.808426f, 0.588598f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.945360f, -0.326029f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.861218f, -0.508236f, 0.000000f, 
		-0.999758f, -0.0219993f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.746226f, -0.665693f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.819919f, 0.572480f, 0.000000f, -0.774206f, -0.632934f, 0.000000f, 
		-0.692997f, 0.720941f, 0.000000f, -0.0442807f, 0.999019f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.922233f, -0.386635f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.861218f, -0.508236f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.945360f, -0.326029f, 0.000000f, 
		0.808426f, 0.588598f, 0.000000f, -0.0442807f, 0.999019f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.819919f, 0.572480f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.746226f, -0.665693f, 0.000000f, 
		-0.774206f, -0.632934f, 0.000000f, 0.0520629f, -0.998644f, 0.000000f, 
		0.922233f, -0.386635f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0520629f, -0.998644f, 0.000000f, -0.999758f, -0.0219993f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0520629f, -0.998644f, 0.000000f, 
		-0.0326097f, -0.0229665f, -0.999204f, 0.922233f, -0.386635f, 0.000000f, 
		0.0520629f, -0.998644f, 0.000000f, -0.0326097f, -0.0229665f, -0.999204f, 
		-0.999758f, -0.0219993f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.233972f, 0.766304f, 0.598361f, -0.0195857f, 0.999808f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.426771f, 0.904360f, 0.000000f, 
		-0.995372f, 0.0960979f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.426771f, 0.904360f, 0.000000f, -0.0195857f, 0.999808f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0690136f, -0.997616f, 0.000000f, 
		-0.995372f, 0.0960979f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0370209f, -0.999314f, 0.000000f, 0.0690136f, -0.997616f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.844928f, -0.534881f, 0.000000f, 
		-0.0370209f, -0.999314f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.797986f, -0.226032f, 0.558684f, 0.844928f, -0.534881f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.797986f, -0.226032f, 0.558684f, 
		0.233972f, 0.766304f, 0.598361f, 0.000000f, 0.000000f, -1.00000f, 
		0.249484f, 0.0739173f, 0.965554f, 0.000000f, 0.000000f, 1.00000f, 
		0.249484f, 0.0739173f, 0.965554f, 0.000000f, 0.000000f, 1.00000f, 
		0.797986f, -0.226032f, 0.558684f, 0.844928f, -0.534881f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0370209f, -0.999314f, 0.000000f, 
		0.0690136f, -0.997616f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.426771f, 0.904360f, 0.000000f, -0.995372f, 0.0960979f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.249484f, 0.0739173f, 0.965554f, 
		0.233972f, 0.766304f, 0.598361f, -0.0195857f, 0.999808f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.844928f, -0.534881f, 0.000000f, 
		-0.0370209f, -0.999314f, 0.000000f, 0.249484f, 0.0739173f, 0.965554f, 
		0.797986f, -0.226032f, 0.558684f, 0.233972f, 0.766304f, 0.598361f, 
		0.000000f, 0.000000f, 1.00000f, -0.426771f, 0.904360f, 0.000000f, 
		-0.0195857f, 0.999808f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0690136f, -0.997616f, 0.000000f, -0.995372f, 0.0960979f, 0.000000f, 
		0.996714f, 0.0768762f, -0.0255051f, 0.000000f, 0.000000f, -1.00000f, 
		0.0105935f, -0.999944f, 0.000000f, -0.855655f, -0.517546f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.158382f, -0.987378f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0105935f, -0.999944f, 0.000000f, 
		-0.158382f, -0.987378f, 0.000000f, 0.128775f, 0.0941776f, 0.987192f, 
		-0.00927020f, 0.109386f, 0.993956f, 0.0105935f, -0.999944f, 0.000000f, 
		-0.158382f, -0.987378f, 0.000000f, 0.128775f, 0.0941776f, 0.987192f, 
		-0.855655f, -0.517546f, 0.000000f, -0.158382f, -0.987378f, 0.000000f, 
		-0.00927020f, 0.109386f, 0.993956f, 0.996714f, 0.0768762f, -0.0255051f, 
		0.0105935f, -0.999944f, 0.000000f, -0.806141f, -0.591724f, 0.000000f, 
		-0.993321f, -0.115381f, 0.000000f, -0.993321f, -0.115381f, 0.000000f, 
		-0.00666440f, 0.999978f, 1.13711e-005f, -0.00666885f, 0.999978f, 0.000000f, 
		-0.00665995f, 0.999978f, 0.000000f, -0.806141f, -0.591724f, 0.000000f, 
		-0.993321f, -0.115381f, 0.000000f, -0.113528f, 0.159218f, 0.980694f, 
		0.000000f, 0.000000f, 1.00000f, -0.216645f, -0.159022f, 0.963212f, 
		-0.806141f, -0.591724f, 0.000000f, -0.956362f, 0.292185f, 0.000000f, 
		0.0183978f, -0.0258018f, -0.999498f, 0.0925754f, 0.0679523f, -0.993384f, 
		0.000000f, 0.000000f, -1.00000f, -0.806141f, -0.591724f, 0.000000f, 
		-0.993321f, -0.115381f, 0.000000f, 0.998200f, -0.0352565f, 0.0485119f, 
		0.0332252f, -0.195687f, 0.980103f, -0.00927020f, 0.109386f, 0.993956f, 
		0.996714f, 0.0768762f, -0.0255051f, 0.994519f, 0.0986207f, 0.0347258f, 
		0.00644527f, 0.999979f, 5.68556e-006f, -0.00901707f, 0.173526f, 0.984788f, 
		-0.993321f, -0.115381f, 0.000000f, -0.00665995f, 0.999978f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0144357f, -0.133536f, 0.990939f, 
		-0.956362f, 0.292185f, 0.000000f, 0.128775f, 0.0941776f, 0.987192f, 
		-0.855655f, -0.517546f, 0.000000f, 0.00644527f, 0.999979f, 5.68556e-006f, 
		-0.00901707f, 0.173526f, 0.984788f, -0.00666440f, 0.999978f, 1.13711e-005f, 
		-0.00665995f, 0.999978f, 0.000000f, -0.113528f, 0.159218f, 0.980694f, 
		0.000000f, 0.000000f, 1.00000f, 0.994519f, 0.0986207f, 0.0347258f, 
		0.998200f, -0.0352565f, 0.0485119f, -0.00901707f, 0.173526f, 0.984788f, 
		0.0332252f, -0.195687f, 0.980103f, 0.0332252f, -0.195687f, 0.980103f, 
		0.0144357f, -0.133536f, 0.990939f, 0.128775f, 0.0941776f, 0.987192f, 
		-0.00927020f, 0.109386f, 0.993956f, 0.0144357f, -0.133536f, 0.990939f, 
		-0.806141f, -0.591724f, 0.000000f, -0.956362f, 0.292185f, 0.000000f, 
		-0.216645f, -0.159022f, 0.963212f, -0.00901707f, 0.173526f, 0.984788f, 
		0.0332252f, -0.195687f, 0.980103f, 0.0144357f, -0.133536f, 0.990939f, 
		-0.113528f, 0.159218f, 0.980694f, -0.216645f, -0.159022f, 0.963212f, 
		-0.0945270f, -0.0207264f, -0.995306f, -0.148521f, 0.0180979f, -0.988744f, 
		0.0394390f, 0.0245188f, -0.998921f, 0.0183978f, -0.0258018f, -0.999498f, 
		0.0925754f, 0.0679523f, -0.993384f, 0.0394390f, 0.0245188f, -0.998921f, 
		0.0925754f, 0.0679523f, -0.993384f, -0.806141f, -0.591724f, 0.000000f, 
		-0.956362f, 0.292185f, 0.000000f, -0.148521f, 0.0180979f, -0.988744f, 
		0.0394390f, 0.0245188f, -0.998921f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0945270f, -0.0207264f, -0.995306f, -0.148521f, 0.0180979f, -0.988744f, 
		0.994519f, 0.0986207f, 0.0347258f, 0.998200f, -0.0352565f, 0.0485119f, 
		-0.0945270f, -0.0207264f, -0.995306f, 0.00644527f, 0.999979f, 5.68556e-006f, 
		0.0183978f, -0.0258018f, -0.999498f, 0.000000f, 0.000000f, -1.00000f, 
		-0.00666440f, 0.999978f, 1.13711e-005f, -0.00666885f, 0.999978f, 0.000000f, 
		0.0394390f, 0.0245188f, -0.998921f, -0.956362f, 0.292185f, 0.000000f, 
		-0.855655f, -0.517546f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.993321f, -0.115381f, 0.000000f, 
		-0.00666885f, 0.999978f, 0.000000f, -0.0945270f, -0.0207264f, -0.995306f, 
		0.994519f, 0.0986207f, 0.0347258f, 0.00644527f, 0.999979f, 5.68556e-006f, 
		-0.148521f, 0.0180979f, -0.988744f, 0.998200f, -0.0352565f, 0.0485119f, 
		0.996714f, 0.0768762f, -0.0255051f, 0.000000f, 0.000000f, -1.00000f, 
		-0.692997f, 0.720941f, 0.000000f, -0.0442807f, 0.999019f, 0.000000f, 
		-0.692997f, 0.720941f, 0.000000f, 0.808426f, 0.588598f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.945360f, -0.326029f, 0.000000f, 
		0.808426f, 0.588598f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.692997f, 0.720941f, 0.000000f, 0.808426f, 0.588598f, 0.000000f, 
		-0.692997f, 0.720941f, 0.000000f, 0.808426f, 0.588598f, 0.000000f, 
		-0.922507f, 0.385980f, 0.000000f, -0.0207174f, -0.999785f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.920043f, 0.391818f, 0.000000f, 
		-0.935823f, 0.352471f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.517370f, 0.855762f, 0.000000f, 0.810540f, 0.585683f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.206314f, -0.978486f, 0.000000f, 
		0.947311f, -0.320316f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.920043f, 0.391818f, 0.000000f, 0.517370f, 0.855762f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.922507f, 0.385980f, 0.000000f, 
		-0.935823f, 0.352471f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0207174f, -0.999785f, 0.000000f, 0.206314f, -0.978486f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.947311f, -0.320316f, 0.000000f, 
		0.810540f, 0.585683f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.517370f, 0.855762f, 0.000000f, 0.810540f, 0.585683f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.947311f, -0.320316f, 0.000000f, 
		0.810540f, 0.585683f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.206314f, -0.978486f, 0.000000f, 0.947311f, -0.320316f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0207174f, -0.999785f, 0.000000f, 
		0.206314f, -0.978486f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.922507f, 0.385980f, 0.000000f, -0.0207174f, -0.999785f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.920043f, 0.391818f, 0.000000f, 
		-0.935823f, 0.352471f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.922507f, 0.385980f, 0.000000f, -0.935823f, 0.352471f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.920043f, 0.391818f, 0.000000f, 
		0.517370f, 0.855762f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0513297f, 0.998682f, 0.000000f, 
		-2.64785e-015f, 0.000000f, -1.00000f, 0.135126f, 0.990828f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.871639f, 0.490149f, 0.000000f, 
		-0.937727f, 0.347374f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.871639f, 0.490149f, 0.000000f, 0.135126f, 0.990828f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0517664f, -0.998659f, 0.000000f, 
		-0.937727f, 0.347374f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.152569f, -0.988293f, 0.000000f, 0.0517664f, -0.998659f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0766188f, -0.997060f, 0.000000f, 
		-0.152569f, -0.988293f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.878271f, 0.478164f, 0.000000f, 0.0766188f, -0.997060f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.997749f, -0.0670581f, 0.000000f, 
		-0.0513297f, 0.998682f, 0.000000f, -2.64785e-015f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.878271f, 0.478164f, 0.000000f, 
		0.0766188f, -0.997060f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, -0.152569f, -0.988293f, 0.000000f, 
		0.0517664f, -0.998659f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.871639f, 0.490149f, 0.000000f, -0.937727f, 0.347374f, 0.000000f, 
		-0.0513297f, 0.998682f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.135126f, 0.990828f, 0.000000f, 0.0766188f, -0.997060f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.152569f, -0.988293f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.997749f, -0.0670581f, 0.000000f, 
		-0.0513297f, 0.998682f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.871639f, 0.490149f, 0.000000f, 0.135126f, 0.990828f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0517664f, -0.998659f, 0.000000f, 
		-0.937727f, 0.347374f, 0.000000f, 0.997749f, -0.0670581f, 0.000000f, 
		-0.0513297f, 0.998682f, 0.000000f, 0.997749f, -0.0670581f, 0.000000f, 
		0.878271f, 0.478164f, 0.000000f, -2.64785e-015f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.878271f, 0.478164f, 0.000000f, 
		0.0766188f, -0.997060f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.997749f, -0.0670581f, 0.000000f, 0.878271f, 0.478164f, 0.000000f, 
		0.997749f, -0.0670581f, 0.000000f, 0.878271f, 0.478164f, 0.000000f, 
		0.000000f, -0.131397f, 0.991330f, 0.000000f, -0.998994f, 0.0448519f, 
		0.000000f, -0.131397f, 0.991330f, 0.000000f, -0.998644f, -0.0520615f, 
		0.000000f, -0.998994f, 0.0448519f, 0.000000f, -0.899964f, -0.435965f, 
		0.000000f, -0.998644f, -0.0520615f, 0.000000f, -0.899964f, -0.435965f, 
		0.996878f, -0.0788051f, 0.00497990f, 0.998320f, 0.00237989f, 0.0578957f, 
		0.997780f, 0.0327890f, -0.0579683f, 0.996853f, 0.0555906f, 0.0565054f, 
		0.998320f, 0.00237989f, 0.0578957f, 0.996853f, 0.0555906f, 0.0565054f, 
		0.000000f, -0.899964f, -0.435965f, 0.997780f, 0.0327890f, -0.0579683f, 
		0.996853f, 0.0555906f, 0.0565054f, 0.000000f, -0.998644f, -0.0520615f, 
		0.000000f, -0.998994f, 0.0448519f, 0.996878f, -0.0788051f, 0.00497990f, 
		0.997780f, 0.0327890f, -0.0579683f, 0.000000f, -0.131397f, 0.991330f, 
		0.996878f, -0.0788051f, 0.00497990f, 0.998320f, 0.00237989f, 0.0578957f, 
		0.996853f, 0.0555906f, 0.0565054f, 0.000000f, -0.899964f, -0.435965f, 
		0.000000f, -0.998644f, -0.0520615f, 0.998320f, 0.00237989f, 0.0578957f, 
		0.996878f, -0.0788051f, 0.00497990f, 0.997780f, 0.0327890f, -0.0579683f, 
		0.000000f, -0.998994f, 0.0448519f, 0.000000f, -0.131397f, 0.991330f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.977814f, 0.209477f, 
		0.000000f, 0.998228f, -0.0595057f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.796437f, 0.604721f, 0.000000f, -0.0649421f, 0.997889f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.796437f, 0.604721f, 
		0.000000f, 0.998228f, -0.0595057f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -0.999876f, 0.0157777f, 0.000000f, -0.0649421f, 0.997889f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.998645f, -0.0520384f, 
		0.000000f, -0.999876f, 0.0157777f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.0137735f, -0.999905f, 0.000000f, -0.998645f, -0.0520384f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.235637f, -0.971841f, 
		0.000000f, 0.0137735f, -0.999905f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.235637f, -0.971841f, 0.000000f, 0.977814f, 0.209477f, 
		-1.00000f, 0.000000f, 0.000000f, 0.993978f, 0.104480f, 0.0330333f, 
		0.997307f, 0.0638930f, -0.0360116f, 0.998360f, -0.0396730f, 0.0412759f, 
		0.998211f, -0.0158332f, -0.0576524f, 0.997307f, 0.0638930f, -0.0360116f, 
		0.998211f, -0.0158332f, -0.0576524f, 0.000000f, 0.235637f, -0.971841f, 
		0.000000f, 0.0137735f, -0.999905f, 0.998360f, -0.0396730f, 0.0412759f, 
		0.998211f, -0.0158332f, -0.0576524f, 0.000000f, -0.998645f, -0.0520384f, 
		0.000000f, -0.999876f, 0.0157777f, 0.993978f, 0.104480f, 0.0330333f, 
		0.998360f, -0.0396730f, 0.0412759f, 0.000000f, 0.796437f, 0.604721f, 
		0.000000f, -0.0649421f, 0.997889f, 0.993978f, 0.104480f, 0.0330333f, 
		0.997307f, 0.0638930f, -0.0360116f, 0.000000f, 0.977814f, 0.209477f, 
		0.000000f, 0.998228f, -0.0595057f, 0.998211f, -0.0158332f, -0.0576524f, 
		0.000000f, 0.0137735f, -0.999905f, 0.000000f, -0.998645f, -0.0520384f, 
		0.997307f, 0.0638930f, -0.0360116f, 0.000000f, 0.235637f, -0.971841f, 
		0.000000f, 0.977814f, 0.209477f, 0.993978f, 0.104480f, 0.0330333f, 
		0.000000f, 0.796437f, 0.604721f, 0.000000f, 0.998228f, -0.0595057f, 
		0.998360f, -0.0396730f, 0.0412759f, 0.000000f, -0.999876f, 0.0157777f, 
		0.000000f, -0.0649421f, 0.997889f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.671635f, -0.740882f, 0.000000f, 0.997198f, -0.0748053f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.993138f, 0.116949f, 
		0.000000f, -0.0819074f, 0.996640f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.993138f, 0.116949f, 0.000000f, 0.997198f, -0.0748053f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.951904f, 0.306396f, 
		0.000000f, -0.0819074f, 0.996640f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -0.738075f, -0.674719f, 0.000000f, -0.951904f, 0.306396f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.0399573f, -0.999201f, 
		0.000000f, -0.738075f, -0.674719f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.143218f, -0.989691f, 0.000000f, 0.0399573f, -0.999201f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.143218f, -0.989691f, 
		0.000000f, 0.671635f, -0.740882f, -1.00000f, 0.000000f, 0.000000f, 
		0.995186f, 0.0979910f, 0.00173037f, 0.996174f, 0.0299930f, -0.0820811f, 
		0.998928f, -0.0448859f, 0.0113089f, 0.997692f, -0.0676790f, 0.00557749f, 
		0.996174f, 0.0299930f, -0.0820811f, 0.997692f, -0.0676790f, 0.00557749f, 
		0.000000f, 0.143218f, -0.989691f, 0.000000f, 0.0399573f, -0.999201f, 
		0.998928f, -0.0448859f, 0.0113089f, 0.997692f, -0.0676790f, 0.00557749f, 
		0.000000f, -0.738075f, -0.674719f, 0.000000f, -0.951904f, 0.306396f, 
		0.995186f, 0.0979910f, 0.00173037f, 0.998928f, -0.0448859f, 0.0113089f, 
		0.000000f, 0.993138f, 0.116949f, 0.000000f, -0.0819074f, 0.996640f, 
		0.995186f, 0.0979910f, 0.00173037f, 0.996174f, 0.0299930f, -0.0820811f, 
		0.000000f, 0.671635f, -0.740882f, 0.000000f, 0.997198f, -0.0748053f, 
		0.997692f, -0.0676790f, 0.00557749f, 0.000000f, 0.0399573f, -0.999201f, 
		0.000000f, -0.738075f, -0.674719f, 0.996174f, 0.0299930f, -0.0820811f, 
		0.000000f, 0.143218f, -0.989691f, 0.000000f, 0.671635f, -0.740882f, 
		0.995186f, 0.0979910f, 0.00173037f, 0.000000f, 0.993138f, 0.116949f, 
		0.000000f, 0.997198f, -0.0748053f, 0.998928f, -0.0448859f, 0.0113089f, 
		0.000000f, -0.951904f, 0.306396f, 0.000000f, -0.0819074f, 0.996640f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.0646694f, -0.997907f, 
		0.000000f, 0.0868544f, -0.996221f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.952621f, -0.304160f, 0.000000f, 0.0879177f, 0.996128f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.952621f, -0.304160f, 
		0.000000f, 0.0868544f, -0.996221f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -0.184705f, 0.982794f, 0.000000f, 0.0879177f, 0.996128f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.213091f, 0.977032f, 
		0.000000f, -0.184705f, 0.982794f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -0.999763f, 0.0217713f, 0.000000f, 0.213091f, 0.977032f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.999184f, -0.0403956f, 
		0.000000f, -0.999763f, 0.0217713f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -0.999184f, -0.0403956f, 0.000000f, 0.0646694f, -0.997907f, 
		-1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.999184f, -0.0403956f, 
		0.000000f, -0.999763f, 0.0217713f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.213091f, 0.977032f, 0.000000f, -0.184705f, 0.982794f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.952621f, -0.304160f, 
		0.000000f, 0.0879177f, 0.996128f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.0646694f, -0.997907f, 0.000000f, 0.0868544f, -0.996221f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.999763f, 0.0217713f, 
		0.000000f, 0.213091f, 0.977032f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -0.999184f, -0.0403956f, 0.000000f, 0.0646694f, -0.997907f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.952621f, -0.304160f, 
		0.000000f, 0.0868544f, -0.996221f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -0.184705f, 0.982794f, 0.000000f, 0.0879177f, 0.996128f, 
		0.000000f, 0.0879177f, 0.996128f, 0.000000f, -0.184705f, 0.982794f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.0868544f, -0.996221f, 
		0.000000f, 0.952621f, -0.304160f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.0646694f, -0.997907f, 0.000000f, -0.999184f, -0.0403956f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.213085f, 0.977034f, 
		0.000000f, -0.999763f, 0.0217555f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.0868544f, -0.996221f, 0.000000f, 0.0646694f, -0.997907f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.0879177f, 0.996128f, 
		0.000000f, 0.952621f, -0.304160f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -0.184705f, 0.982794f, 0.000000f, 0.213085f, 0.977034f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.999763f, 0.0217555f, 
		0.000000f, -0.999184f, -0.0403956f, 1.00000f, 0.000000f, 0.000000f, 
		1.00000f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.0646694f, -0.997907f, 0.000000f, -0.999184f, -0.0403956f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.999763f, 0.0217555f, 
		0.000000f, -0.999184f, -0.0403956f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.213085f, 0.977034f, 0.000000f, -0.999763f, 0.0217555f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.184705f, 0.982794f, 
		0.000000f, 0.213085f, 0.977034f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.0879177f, 0.996128f, 0.000000f, -0.184705f, 0.982794f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.0868544f, -0.996221f, 
		0.000000f, 0.952621f, -0.304160f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.0879177f, 0.996128f, 0.000000f, 0.952621f, -0.304160f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.0868544f, -0.996221f, 
		0.000000f, 0.0646694f, -0.997907f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -0.0819074f, 0.996640f, 0.000000f, -0.951904f, 0.306396f, 
		0.996903f, -0.0379087f, 0.0689066f, 0.000000f, 0.997198f, -0.0748053f, 
		0.000000f, 0.993138f, 0.116949f, 0.996856f, 0.0792262f, 0.00139902f, 
		0.0852391f, 0.852712f, -0.515379f, 0.163057f, -0.0378520f, -0.985890f, 
		0.993118f, 0.0482430f, -0.106723f, 0.000000f, -0.717331f, -0.696733f, 
		0.000000f, -0.150179f, -0.988659f, 0.985644f, -0.0823676f, -0.147385f, 
		0.000000f, 0.997198f, -0.0748053f, 0.0852391f, 0.852712f, -0.515379f, 
		0.993118f, 0.0482430f, -0.106723f, 0.996856f, 0.0792262f, 0.00139902f, 
		0.000000f, -0.0819074f, 0.996640f, 0.000000f, 0.993138f, 0.116949f, 
		0.996903f, -0.0379087f, 0.0689066f, 0.996856f, 0.0792262f, 0.00139902f, 
		0.000000f, -0.951904f, 0.306396f, 0.000000f, -0.717331f, -0.696733f, 
		0.985644f, -0.0823676f, -0.147385f, 0.996903f, -0.0379087f, 0.0689066f, 
		0.000000f, -0.150179f, -0.988659f, 0.163057f, -0.0378520f, -0.985890f, 
		0.985644f, -0.0823676f, -0.147385f, 0.993118f, 0.0482430f, -0.106723f, 
		0.985644f, -0.0823676f, -0.147385f, 0.996903f, -0.0379087f, 0.0689066f, 
		0.993118f, 0.0482430f, -0.106723f, 0.996856f, 0.0792262f, 0.00139902f, 
		-0.999943f, 0.00439765f, -0.00972849f, 0.0852391f, 0.852712f, -0.515379f, 
		0.163057f, -0.0378520f, -0.985890f, -0.999943f, 0.00439765f, -0.00972849f, 
		-0.999853f, -0.00837267f, -0.0149817f, 0.000000f, -0.150179f, -0.988659f, 
		0.163057f, -0.0378520f, -0.985890f, -0.999853f, -0.00837267f, -0.0149817f, 
		0.000000f, -0.717331f, -0.696733f, 0.000000f, -0.150179f, -0.988659f, 
		-0.999969f, -0.00381034f, 0.00692605f, -0.999853f, -0.00837267f, -0.0149817f, 
		0.000000f, -0.951904f, 0.306396f, 0.000000f, -0.717331f, -0.696733f, 
		-0.999969f, -0.00381034f, 0.00692605f, 0.000000f, -0.0819074f, 0.996640f, 
		0.000000f, -0.951904f, 0.306396f, -0.999968f, 0.00796369f, 0.000140627f, 
		0.000000f, 0.997198f, -0.0748053f, 0.000000f, 0.993138f, 0.116949f, 
		-0.999968f, 0.00796369f, 0.000140627f, -0.999969f, -0.00381034f, 0.00692605f, 
		0.000000f, -0.0819074f, 0.996640f, 0.000000f, 0.993138f, 0.116949f, 
		-0.999968f, 0.00796369f, 0.000140627f, -0.999943f, 0.00439765f, -0.00972849f, 
		0.000000f, 0.997198f, -0.0748053f, 0.0852391f, 0.852712f, -0.515379f, 
		-0.999968f, 0.00796369f, 0.000140627f, -0.999943f, 0.00439765f, -0.00972849f, 
		-0.999969f, -0.00381034f, 0.00692605f, -0.999853f, -0.00837267f, -0.0149817f, 
		0.000000f, -0.0715122f, 0.997440f, 0.000000f, -0.998778f, 0.0494121f, 
		0.999990f, -0.00304272f, 0.00316568f, 0.000000f, 0.998228f, -0.0595057f, 
		0.000000f, 0.796437f, 0.604721f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.963060f, 0.269287f, 0.000000f, -0.118336f, -0.992974f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.998644f, -0.0520615f, 
		0.000000f, 0.0688684f, -0.997626f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.998228f, -0.0595057f, 0.000000f, 0.963060f, 0.269287f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.0715122f, 0.997440f, 
		0.000000f, 0.796437f, 0.604721f, 0.999990f, -0.00304272f, 0.00316568f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, -0.998778f, 0.0494121f, 
		0.000000f, -0.998644f, -0.0520615f, 1.00000f, 0.000000f, 0.000000f, 
		0.999990f, -0.00304272f, 0.00316568f, 0.000000f, 0.0688684f, -0.997626f, 
		0.000000f, -0.118336f, -0.992974f, 1.00000f, 0.000000f, 0.000000f, 
		0.999990f, -0.00304272f, 0.00316568f, 1.00000f, 0.000000f, 0.000000f, 
		-0.998911f, 0.0390199f, -0.0255594f, 0.000000f, 0.963060f, 0.269287f, 
		0.000000f, -0.118336f, -0.992974f, -0.998911f, 0.0390199f, -0.0255594f, 
		-0.998902f, -0.0104335f, -0.0456792f, 0.000000f, 0.0688684f, -0.997626f, 
		0.000000f, -0.118336f, -0.992974f, -0.998902f, -0.0104335f, -0.0456792f, 
		0.000000f, -0.998644f, -0.0520615f, 0.000000f, 0.0688684f, -0.997626f, 
		-0.999188f, -0.0279254f, 0.0290539f, -0.998902f, -0.0104335f, -0.0456792f, 
		0.000000f, -0.998778f, 0.0494121f, 0.000000f, -0.998644f, -0.0520615f, 
		-0.999188f, -0.0279254f, 0.0290539f, 0.000000f, -0.0715122f, 0.997440f, 
		0.000000f, -0.998778f, 0.0494121f, -0.996518f, 0.0795016f, 0.0251360f, 
		0.000000f, 0.998228f, -0.0595057f, 0.000000f, 0.796437f, 0.604721f, 
		-0.996518f, 0.0795016f, 0.0251360f, -0.999188f, -0.0279254f, 0.0290539f, 
		0.000000f, -0.0715122f, 0.997440f, 0.000000f, 0.796437f, 0.604721f, 
		-0.996518f, 0.0795016f, 0.0251360f, -0.998911f, 0.0390199f, -0.0255594f, 
		0.000000f, 0.998228f, -0.0595057f, 0.000000f, 0.963060f, 0.269287f, 
		-0.996518f, 0.0795016f, 0.0251360f, -0.998911f, 0.0390199f, -0.0255594f, 
		-0.999188f, -0.0279254f, 0.0290539f, -0.998902f, -0.0104335f, -0.0456792f, 
		0.0333624f, -0.999294f, -0.0172632f, 0.0290582f, -0.999000f, 0.0339942f, 
		-0.0276441f, -0.999191f, -0.0292194f, -0.0380465f, -0.999045f, 0.0215063f, 
		-0.970788f, 0.0802688f, -0.226112f, -0.998057f, 0.00645555f, 0.0619757f, 
		-0.0276441f, -0.999191f, -0.0292194f, -0.0380465f, -0.999045f, 0.0215063f, 
		-0.405578f, 0.000000f, 0.914060f, 0.181752f, 0.000000f, 0.983344f, 
		0.0290582f, -0.999000f, 0.0339942f, -0.0380465f, -0.999045f, 0.0215063f, 
		-0.405578f, 0.000000f, 0.914060f, -0.998057f, 0.00645555f, 0.0619757f, 
		-0.0380465f, -0.999045f, 0.0215063f, 0.999088f, 0.000000f, 0.0426928f, 
		0.181752f, 0.000000f, 0.983344f, 0.0290582f, -0.999000f, 0.0339942f, 
		0.987950f, 0.000000f, 0.154771f, 0.999088f, 0.000000f, 0.0426928f, 
		0.0333624f, -0.999294f, -0.0172632f, 0.0290582f, -0.999000f, 0.0339942f, 
		0.0664491f, 0.000000f, -0.997790f, 0.987950f, 0.000000f, 0.154771f, 
		0.0333624f, -0.999294f, -0.0172632f, -0.134668f, 0.0380319f, -0.990161f, 
		0.0664491f, 0.000000f, -0.997790f, 0.0333624f, -0.999294f, -0.0172632f, 
		-0.0276441f, -0.999191f, -0.0292194f, -0.134668f, 0.0380319f, -0.990161f, 
		-0.970788f, 0.0802688f, -0.226112f, -0.0276441f, -0.999191f, -0.0292194f, 
		0.311221f, 0.945533f, 0.0954349f, 0.179581f, 0.970064f, 0.163485f, 
		0.000000f, 1.00000f, 0.000000f, 0.00536114f, 0.973944f, 0.226724f, 
		0.179581f, 0.970064f, 0.163485f, 0.00536114f, 0.973944f, 0.226724f, 
		-0.134668f, 0.0380319f, -0.990161f, 0.0664491f, 0.000000f, -0.997790f, 
		0.000000f, 1.00000f, 0.000000f, 0.00536114f, 0.973944f, 0.226724f, 
		0.987950f, 0.000000f, 0.154771f, 0.999088f, 0.000000f, 0.0426928f, 
		0.311221f, 0.945533f, 0.0954349f, 0.000000f, 1.00000f, 0.000000f, 
		-0.405578f, 0.000000f, 0.914060f, 0.181752f, 0.000000f, 0.983344f, 
		0.311221f, 0.945533f, 0.0954349f, 0.179581f, 0.970064f, 0.163485f, 
		-0.970788f, 0.0802688f, -0.226112f, -0.998057f, 0.00645555f, 0.0619757f, 
		0.00536114f, 0.973944f, 0.226724f, 0.0664491f, 0.000000f, -0.997790f, 
		0.987950f, 0.000000f, 0.154771f, 0.179581f, 0.970064f, 0.163485f, 
		-0.134668f, 0.0380319f, -0.990161f, -0.970788f, 0.0802688f, -0.226112f, 
		0.311221f, 0.945533f, 0.0954349f, -0.405578f, 0.000000f, 0.914060f, 
		-0.998057f, 0.00645555f, 0.0619757f, 0.000000f, 1.00000f, 0.000000f, 
		0.999088f, 0.000000f, 0.0426928f, 0.181752f, 0.000000f, 0.983344f, 
		-0.0220925f, -0.999210f, 0.0330416f, -0.0146998f, -0.999666f, -0.0212504f, 
		0.0328290f, -0.998402f, 0.0459882f, 0.0638676f, -0.997957f, -0.00148986f, 
		-0.978204f, -2.14724e-006f, -0.207644f, -0.993782f, 0.000000f, -0.111342f, 
		0.0328290f, -0.998402f, 0.0459882f, 0.0638676f, -0.997957f, -0.00148986f, 
		-0.996021f, 0.000000f, 0.0891161f, -0.313221f, 0.000000f, 0.949680f, 
		-0.0146998f, -0.999666f, -0.0212504f, 0.0638676f, -0.997957f, -0.00148986f, 
		-0.996021f, 0.000000f, 0.0891161f, -0.993782f, 0.000000f, -0.111342f, 
		0.0638676f, -0.997957f, -0.00148986f, 0.944240f, 0.000000f, 0.329257f, 
		-0.313221f, 0.000000f, 0.949680f, -0.0146998f, -0.999666f, -0.0212504f, 
		0.999874f, 0.000000f, -0.0159048f, 0.944240f, 0.000000f, 0.329257f, 
		-0.0220925f, -0.999210f, 0.0330416f, -0.0146998f, -0.999666f, -0.0212504f, 
		0.0692505f, 0.000000f, -0.997599f, 0.999874f, 0.000000f, -0.0159048f, 
		-0.0220925f, -0.999210f, 0.0330416f, -0.0828759f, -9.50137e-006f, -0.996560f, 
		0.0692505f, 0.000000f, -0.997599f, -0.0220925f, -0.999210f, 0.0330416f, 
		0.0328290f, -0.998402f, 0.0459882f, -0.0828759f, -9.50137e-006f, -0.996560f, 
		-0.978204f, -2.14724e-006f, -0.207644f, 0.0328290f, -0.998402f, 0.0459882f, 
		0.000420650f, 0.989452f, 0.144861f, 0.000000f, 1.00000f, 0.000000f, 
		0.0102449f, 0.994972f, 0.0996279f, 0.000420650f, 0.989452f, 0.144861f, 
		0.0102449f, 0.994972f, 0.0996279f, -0.0828759f, -9.50137e-006f, -0.996560f, 
		0.0692505f, 0.000000f, -0.997599f, 0.000000f, 1.00000f, 0.000000f, 
		0.0102449f, 0.994972f, 0.0996279f, 0.999874f, 0.000000f, -0.0159048f, 
		0.944240f, 0.000000f, 0.329257f, 0.000000f, 1.00000f, 0.000000f, 
		-0.996021f, 0.000000f, 0.0891161f, -0.313221f, 0.000000f, 0.949680f, 
		0.000000f, 1.00000f, 0.000000f, 0.000420650f, 0.989452f, 0.144861f, 
		-0.978204f, -2.14724e-006f, -0.207644f, -0.993782f, 0.000000f, -0.111342f, 
		0.0102449f, 0.994972f, 0.0996279f, 0.0692505f, 0.000000f, -0.997599f, 
		0.999874f, 0.000000f, -0.0159048f, 0.000420650f, 0.989452f, 0.144861f, 
		-0.0828759f, -9.50137e-006f, -0.996560f, -0.978204f, -2.14724e-006f, -0.207644f, 
		0.000000f, 1.00000f, 0.000000f, -0.996021f, 0.000000f, 0.0891161f, 
		-0.993782f, 0.000000f, -0.111342f, 0.000000f, 1.00000f, 0.000000f, 
		0.944240f, 0.000000f, 0.329257f, -0.313221f, 0.000000f, 0.949680f, 
		-0.0527180f, -0.998460f, -0.0172880f, 0.0418417f, -0.998977f, -0.0171766f, 
		-0.0423780f, -0.998149f, 0.0436146f, 0.0424515f, -0.998391f, 0.0375818f, 
		-0.226367f, 2.69587e-006f, -0.974042f, 0.186856f, -1.81818e-006f, -0.982387f, 
		-0.0423780f, -0.998149f, 0.0436146f, 0.0424515f, -0.998391f, 0.0375818f, 
		-0.994663f, 0.000000f, -0.103179f, -0.999744f, 0.000000f, 0.0226250f, 
		0.0418417f, -0.998977f, -0.0171766f, 0.0424515f, -0.998391f, 0.0375818f, 
		-0.994663f, 0.000000f, -0.103179f, 0.186856f, -1.81818e-006f, -0.982387f, 
		0.0424515f, -0.998391f, 0.0375818f, 0.0565855f, 0.000000f, 0.998398f, 
		-0.999744f, 0.000000f, 0.0226250f, 0.0418417f, -0.998977f, -0.0171766f, 
		0.0109623f, 0.000000f, 0.999940f, 0.0565855f, 0.000000f, 0.998398f, 
		-0.0527180f, -0.998460f, -0.0172880f, 0.0418417f, -0.998977f, -0.0171766f, 
		0.997045f, 0.000000f, 0.0768160f, 0.0109623f, 0.000000f, 0.999940f, 
		-0.0527180f, -0.998460f, -0.0172880f, 0.972333f, 0.000000f, -0.233598f, 
		0.997045f, 0.000000f, 0.0768160f, -0.0527180f, -0.998460f, -0.0172880f, 
		-0.0423780f, -0.998149f, 0.0436146f, 0.972333f, 0.000000f, -0.233598f, 
		-0.226367f, 2.69587e-006f, -0.974042f, -0.0423780f, -0.998149f, 0.0436146f, 
		0.204247f, 0.976875f, 0.0632398f, 0.156267f, 0.987519f, -0.0196759f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.972333f, 0.000000f, -0.233598f, 0.997045f, 0.000000f, 0.0768160f, 
		0.156267f, 0.987519f, -0.0196759f, 0.000000f, 1.00000f, 0.000000f, 
		0.0109623f, 0.000000f, 0.999940f, 0.0565855f, 0.000000f, 0.998398f, 
		0.204247f, 0.976875f, 0.0632398f, 0.156267f, 0.987519f, -0.0196759f, 
		-0.994663f, 0.000000f, -0.103179f, -0.999744f, 0.000000f, 0.0226250f, 
		0.204247f, 0.976875f, 0.0632398f, 0.000000f, 1.00000f, 0.000000f, 
		-0.226367f, 2.69587e-006f, -0.974042f, 0.186856f, -1.81818e-006f, -0.982387f, 
		0.000000f, 1.00000f, 0.000000f, 0.997045f, 0.000000f, 0.0768160f, 
		0.0109623f, 0.000000f, 0.999940f, 0.000000f, 1.00000f, 0.000000f, 
		0.972333f, 0.000000f, -0.233598f, -0.226367f, 2.69587e-006f, -0.974042f, 
		0.204247f, 0.976875f, 0.0632398f, -0.994663f, 0.000000f, -0.103179f, 
		0.186856f, -1.81818e-006f, -0.982387f, 0.156267f, 0.987519f, -0.0196759f, 
		0.0565855f, 0.000000f, 0.998398f, -0.999744f, 0.000000f, 0.0226250f, 
		-0.0221043f, -0.999400f, -0.0266766f, -0.00363458f, -0.999971f, 0.00666950f, 
		-0.0224138f, -0.998876f, 0.0417647f, 0.00647923f, -0.999710f, 0.0231833f, 
		0.108862f, 0.000000f, -0.994057f, 0.317900f, 0.000000f, -0.948124f, 
		-0.0224138f, -0.998876f, 0.0417647f, 0.00647923f, -0.999710f, 0.0231833f, 
		-0.999911f, 0.000000f, 0.0133376f, -0.991853f, 0.000000f, -0.127387f, 
		-0.00363458f, -0.999971f, 0.00666950f, 0.00647923f, -0.999710f, 0.0231833f, 
		-0.999911f, 0.000000f, 0.0133376f, 0.317900f, 0.000000f, -0.948124f, 
		0.00647923f, -0.999710f, 0.0231833f, -0.0133982f, -0.999682f, -0.0213763f, 
		-1.00000f, 0.000000f, 0.000000f, -0.991853f, 0.000000f, -0.127387f, 
		-0.00363458f, -0.999971f, 0.00666950f, -0.0133982f, -0.999682f, -0.0213763f, 
		1.00000f, 0.000000f, 0.000000f, -0.0977591f, 0.000000f, 0.995210f, 
		-0.0221043f, -0.999400f, -0.0266766f, -0.00363458f, -0.999971f, 0.00666950f, 
		0.960343f, 0.000000f, 0.278821f, -0.0977591f, 0.000000f, 0.995210f, 
		-0.0221043f, -0.999400f, -0.0266766f, 0.938529f, 0.000000f, -0.345201f, 
		0.960343f, 0.000000f, 0.278821f, -0.0221043f, -0.999400f, -0.0266766f, 
		-0.0224138f, -0.998876f, 0.0417647f, 0.938529f, 0.000000f, -0.345201f, 
		0.108862f, 0.000000f, -0.994057f, -0.0224138f, -0.998876f, 0.0417647f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.938529f, 0.000000f, -0.345201f, 0.960343f, 0.000000f, 0.278821f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0977591f, 0.000000f, 0.995210f, 0.000000f, 1.00000f, 0.000000f, 
		-0.999911f, 0.000000f, 0.0133376f, -0.991853f, 0.000000f, -0.127387f, 
		0.000000f, 1.00000f, 0.000000f, 0.108862f, 0.000000f, -0.994057f, 
		0.317900f, 0.000000f, -0.948124f, 0.000000f, 1.00000f, 0.000000f, 
		0.960343f, 0.000000f, 0.278821f, -0.0977591f, 0.000000f, 0.995210f, 
		0.000000f, 1.00000f, 0.000000f, 0.938529f, 0.000000f, -0.345201f, 
		0.108862f, 0.000000f, -0.994057f, 0.000000f, 1.00000f, 0.000000f, 
		-0.999911f, 0.000000f, 0.0133376f, 0.317900f, 0.000000f, -0.948124f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.991853f, 0.000000f, -0.127387f, 0.000000f, -1.00000f, 0.000000f, 
		-0.998853f, 0.000000f, -0.0478742f, -0.971648f, 0.000000f, -0.236431f, 
		0.000000f, -1.00000f, 0.000000f, 0.868330f, 0.000000f, 0.495987f, 
		0.519016f, 0.000000f, 0.854765f, 0.000000f, -1.00000f, 0.000000f, 
		-0.951028f, 0.000000f, -0.309104f, -0.971648f, 0.000000f, -0.236431f, 
		0.000000f, -1.00000f, 0.000000f, 0.999374f, 0.000000f, -0.0353881f, 
		0.519016f, 0.000000f, 0.854765f, 0.000000f, -1.00000f, 0.000000f, 
		0.994606f, 0.000000f, 0.103729f, 0.999374f, 0.000000f, -0.0353881f, 
		0.000000f, -1.00000f, 0.000000f, 0.212262f, 0.000000f, -0.977213f, 
		0.928540f, 0.000000f, -0.371233f, 0.000000f, -1.00000f, 0.000000f, 
		0.212262f, 0.000000f, -0.977213f, -0.0392522f, 0.000000f, -0.999229f, 
		0.000000f, -1.00000f, 0.000000f, -0.0392522f, 0.000000f, -0.999229f, 
		-0.998853f, 0.000000f, -0.0478742f, 0.000000f, -1.00000f, 0.000000f, 
		0.0291206f, 0.989745f, 0.139846f, 0.0150456f, 0.985978f, 0.166198f, 
		0.000000f, 1.00000f, 0.000000f, -0.0653265f, 0.970498f, 0.232090f, 
		0.0291206f, 0.989745f, 0.139846f, 0.212262f, 0.000000f, -0.977213f, 
		0.0150456f, 0.985978f, 0.166198f, -0.0392522f, 0.000000f, -0.999229f, 
		0.994606f, 0.000000f, 0.103729f, 0.999374f, 0.000000f, -0.0353881f, 
		0.000000f, 1.00000f, 0.000000f, 0.868330f, 0.000000f, 0.495987f, 
		0.000000f, 1.00000f, 0.000000f, 0.519016f, 0.000000f, 0.854765f, 
		0.000000f, 1.00000f, 0.000000f, 0.0150456f, 0.985978f, 0.166198f, 
		-0.998853f, 0.000000f, -0.0478742f, -0.971648f, 0.000000f, -0.236431f, 
		-0.0653265f, 0.970498f, 0.232090f, 0.212262f, 0.000000f, -0.977213f, 
		0.928540f, 0.000000f, -0.371233f, 0.0150456f, 0.985978f, 0.166198f, 
		-0.0392522f, 0.000000f, -0.999229f, -0.998853f, 0.000000f, -0.0478742f, 
		-0.951028f, 0.000000f, -0.309104f, 0.000000f, 1.00000f, 0.000000f, 
		-0.971648f, 0.000000f, -0.236431f, 0.999374f, 0.000000f, -0.0353881f, 
		0.000000f, 1.00000f, 0.000000f, 0.519016f, 0.000000f, 0.854765f, 
		-0.150013f, 0.000000f, 0.988684f, -0.951028f, 0.000000f, -0.309104f, 
		0.000000f, 1.00000f, 0.000000f, -0.150013f, 0.000000f, 0.988684f, 
		0.868330f, 0.000000f, 0.495987f, 0.000000f, 1.00000f, 0.000000f, 
		-0.150013f, 0.000000f, 0.988684f, 0.000000f, -1.00000f, 0.000000f, 
		-0.951028f, 0.000000f, -0.309104f, -0.150013f, 0.000000f, 0.988684f, 
		0.868330f, 0.000000f, 0.495987f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, -0.850154f, 0.000000f, -0.526534f, 
		-0.949570f, 0.000000f, 0.313555f, 0.000000f, -1.00000f, 0.000000f, 
		-0.972422f, 0.000000f, -0.233230f, 0.0184919f, 0.000000f, 0.999829f, 
		0.000000f, -1.00000f, 0.000000f, -0.972422f, 0.000000f, -0.233230f, 
		-0.949570f, 0.000000f, 0.313555f, 0.000000f, -1.00000f, 0.000000f, 
		0.990284f, 0.000000f, 0.139058f, 0.0184919f, 0.000000f, 0.999829f, 
		0.000000f, -1.00000f, 0.000000f, 0.998772f, 0.000000f, -0.0495471f, 
		0.990284f, 0.000000f, 0.139058f, 0.000000f, -1.00000f, 0.000000f, 
		0.553763f, 0.000000f, -0.832674f, 0.998772f, 0.000000f, -0.0495471f, 
		0.000000f, -1.00000f, 0.000000f, -0.0864923f, 0.000000f, -0.996253f, 
		0.553763f, 0.000000f, -0.832674f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0864923f, 0.000000f, -0.996253f, -0.850154f, 0.000000f, -0.526534f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, -0.0864923f, 0.000000f, -0.996253f, 
		0.553763f, 0.000000f, -0.832674f, 0.000000f, 1.00000f, 0.000000f, 
		0.998772f, 0.000000f, -0.0495471f, 0.990284f, 0.000000f, 0.139058f, 
		0.000000f, 1.00000f, 0.000000f, -0.972422f, 0.000000f, -0.233230f, 
		0.0184919f, 0.000000f, 0.999829f, 0.000000f, 1.00000f, 0.000000f, 
		-0.850154f, 0.000000f, -0.526534f, -0.949570f, 0.000000f, 0.313555f, 
		0.000000f, 1.00000f, 0.000000f, 0.553763f, 0.000000f, -0.832674f, 
		0.998772f, 0.000000f, -0.0495471f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0864923f, 0.000000f, -0.996253f, -0.850154f, 0.000000f, -0.526534f, 
		0.000000f, 1.00000f, 0.000000f, -0.972422f, 0.000000f, -0.233230f, 
		-0.949570f, 0.000000f, 0.313555f, 0.000000f, 1.00000f, 0.000000f, 
		0.990284f, 0.000000f, 0.139058f, 0.0184919f, 0.000000f, 0.999829f, 
		0.000000f, -1.00000f, 0.000000f, -0.918610f, 0.000000f, 0.395165f, 
		-0.991677f, 0.000000f, -0.128751f, 0.000000f, -1.00000f, 0.000000f, 
		-0.509843f, 0.000000f, 0.860267f, -0.0187294f, 0.000000f, 0.999825f, 
		0.000000f, -1.00000f, 0.000000f, -0.509843f, 0.000000f, 0.860267f, 
		-0.991677f, 0.000000f, -0.128751f, 0.000000f, -1.00000f, 0.000000f, 
		0.999088f, 0.000000f, 0.0426934f, -0.0187294f, 0.000000f, 0.999825f, 
		0.000000f, -1.00000f, 0.000000f, 0.995594f, 0.000000f, -0.0937698f, 
		0.999088f, 0.000000f, 0.0426934f, 0.000000f, -1.00000f, 0.000000f, 
		0.188529f, 0.000000f, -0.982068f, 0.995594f, 0.000000f, -0.0937698f, 
		0.000000f, -1.00000f, 0.000000f, -0.0695843f, 0.000000f, -0.997576f, 
		0.188529f, 0.000000f, -0.982068f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0695843f, 0.000000f, -0.997576f, -0.918610f, 0.000000f, 0.395165f, 
		0.000000f, -1.00000f, 0.000000f, 0.0175171f, 0.988196f, 0.152193f, 
		0.000000f, 1.00000f, 0.000000f, 0.000646912f, 0.994110f, 0.108372f, 
		0.0175171f, 0.988196f, 0.152193f, 0.000646912f, 0.994110f, 0.108372f, 
		-0.0695843f, 0.000000f, -0.997576f, 0.188529f, 0.000000f, -0.982068f, 
		0.000000f, 1.00000f, 0.000000f, 0.000646912f, 0.994110f, 0.108372f, 
		0.995594f, 0.000000f, -0.0937698f, 0.999088f, 0.000000f, 0.0426934f, 
		0.000000f, 1.00000f, 0.000000f, -0.509843f, 0.000000f, 0.860267f, 
		-0.0187294f, 0.000000f, 0.999825f, 0.000000f, 1.00000f, 0.000000f, 
		0.0175171f, 0.988196f, 0.152193f, -0.918610f, 0.000000f, 0.395165f, 
		-0.991677f, 0.000000f, -0.128751f, 0.000646912f, 0.994110f, 0.108372f, 
		0.188529f, 0.000000f, -0.982068f, 0.995594f, 0.000000f, -0.0937698f, 
		0.0175171f, 0.988196f, 0.152193f, -0.0695843f, 0.000000f, -0.997576f, 
		-0.918610f, 0.000000f, 0.395165f, 0.000000f, 1.00000f, 0.000000f, 
		-0.509843f, 0.000000f, 0.860267f, -0.991677f, 0.000000f, -0.128751f, 
		0.000000f, 1.00000f, 0.000000f, 0.999088f, 0.000000f, 0.0426934f, 
		-0.0187294f, 0.000000f, 0.999825f, 0.928540f, 0.000000f, -0.371233f, 
		0.994606f, 0.000000f, 0.103729f, 0.000000f, -1.00000f, 0.000000f, 
		0.994606f, 0.000000f, 0.103729f, 0.999374f, 0.000000f, -0.0353881f, 
		0.212262f, 0.000000f, -0.977213f, 0.928540f, 0.000000f, -0.371233f, 
		-0.0653265f, 0.970498f, 0.232090f, 0.000000f, 1.00000f, 0.000000f, 
		0.0291206f, 0.989745f, 0.139846f, 0.928540f, 0.000000f, -0.371233f, 
		0.994606f, 0.000000f, 0.103729f, 0.928540f, 0.000000f, -0.371233f, 
		0.994606f, 0.000000f, 0.103729f, 0.000000f, -1.00000f, 0.000000f, 
		-0.516724f, 0.000000f, 0.856152f, -0.223056f, 0.000000f, 0.974806f, 
		0.000000f, -1.00000f, 0.000000f, 0.230391f, 0.000000f, 0.973098f, 
		0.996349f, 0.000000f, -0.0853721f, 0.000000f, -1.00000f, 0.000000f, 
		-0.223056f, 0.000000f, 0.974806f, 0.230391f, 0.000000f, 0.973098f, 
		0.000000f, -1.00000f, 0.000000f, 0.113928f, 0.000000f, -0.993489f, 
		0.996349f, 0.000000f, -0.0853721f, 0.000000f, -1.00000f, 0.000000f, 
		0.209474f, 0.000000f, -0.977814f, 0.113928f, 0.000000f, -0.993489f, 
		0.000000f, -1.00000f, 0.000000f, -0.596124f, 0.000000f, -0.802893f, 
		0.209474f, 0.000000f, -0.977814f, 0.000000f, -1.00000f, 0.000000f, 
		-0.512380f, 0.000000f, -0.858759f, -0.596124f, 0.000000f, -0.802893f, 
		0.000000f, -1.00000f, 0.000000f, -0.512380f, 0.000000f, -0.858759f, 
		-0.00448964f, 0.000000f, 0.999990f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, -0.512380f, 0.000000f, -0.858759f, 
		0.000000f, 1.00000f, 0.000000f, -0.596124f, 0.000000f, -0.802893f, 
		0.000000f, 1.00000f, 0.000000f, 0.209474f, 0.000000f, -0.977814f, 
		0.113928f, 0.000000f, -0.993489f, 0.000000f, 1.00000f, 0.000000f, 
		0.230391f, 0.000000f, 0.973098f, 0.996349f, 0.000000f, -0.0853721f, 
		-0.516724f, 0.000000f, 0.856152f, -0.223056f, 0.000000f, 0.974806f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.596124f, 0.000000f, -0.802893f, 0.209474f, 0.000000f, -0.977814f, 
		0.000000f, 1.00000f, 0.000000f, -0.512380f, 0.000000f, -0.858759f, 
		-0.00448964f, 0.000000f, 0.999990f, -0.223056f, 0.000000f, 0.974806f, 
		0.000000f, 1.00000f, 0.000000f, 0.230391f, 0.000000f, 0.973098f, 
		0.000000f, 1.00000f, 0.000000f, 0.113928f, 0.000000f, -0.993489f, 
		0.996349f, 0.000000f, -0.0853721f, -0.516724f, 0.000000f, 0.856152f, 
		-0.223056f, 0.000000f, 0.974806f, -0.516724f, 0.000000f, 0.856152f, 
		-0.00448964f, 0.000000f, 0.999990f, 0.000000f, -1.00000f, 0.000000f, 
		-0.512380f, 0.000000f, -0.858759f, -0.00448964f, 0.000000f, 0.999990f, 
		0.000000f, 1.00000f, 0.000000f, -0.516724f, 0.000000f, 0.856152f, 
		-0.00448964f, 0.000000f, 0.999990f, -0.516724f, 0.000000f, 0.856152f, 
		-0.00448964f, 0.000000f, 0.999990f, 0.0472923f, -0.980014f, -0.193224f, 
		-0.00162132f, -0.993967f, 0.109670f, -0.0301809f, -0.997722f, -0.0603392f, 
		-0.0407181f, -0.998672f, -0.0315680f, -0.992266f, 0.000000f, 0.124134f, 
		-0.0730672f, 0.000000f, -0.997327f, -0.0301809f, -0.997722f, -0.0603392f, 
		-0.0407181f, -0.998672f, -0.0315680f, -0.998220f, 0.000000f, -0.0596404f, 
		0.000889285f, 0.000000f, 1.00000f, -0.00162132f, -0.993967f, 0.109670f, 
		-0.0407181f, -0.998672f, -0.0315680f, -0.998220f, 0.000000f, -0.0596404f, 
		-0.0730672f, 0.000000f, -0.997327f, -0.0407181f, -0.998672f, -0.0315680f, 
		0.893671f, 0.000000f, 0.448723f, 0.000889285f, 0.000000f, 1.00000f, 
		-0.00162132f, -0.993967f, 0.109670f, 0.853711f, 0.000000f, -0.520747f, 
		0.893671f, 0.000000f, 0.448723f, 0.0472923f, -0.980014f, -0.193224f, 
		-0.00162132f, -0.993967f, 0.109670f, 0.332779f, 0.000000f, -0.943005f, 
		0.853711f, 0.000000f, -0.520747f, 0.0472923f, -0.980014f, -0.193224f, 
		0.111513f, 0.000000f, -0.993763f, 0.332779f, 0.000000f, -0.943005f, 
		0.0472923f, -0.980014f, -0.193224f, -0.0301809f, -0.997722f, -0.0603392f, 
		0.111513f, 0.000000f, -0.993763f, -0.992266f, 0.000000f, 0.124134f, 
		-0.0301809f, -0.997722f, -0.0603392f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, 0.111513f, 0.000000f, -0.993763f, 
		0.332779f, 0.000000f, -0.943005f, 0.000000f, 1.00000f, 0.000000f, 
		0.853711f, 0.000000f, -0.520747f, 0.893671f, 0.000000f, 0.448723f, 
		0.000000f, 1.00000f, 0.000000f, -0.998220f, 0.000000f, -0.0596404f, 
		0.000889285f, 0.000000f, 1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.992266f, 0.000000f, 0.124134f, -0.0730672f, 0.000000f, -0.997327f, 
		0.000000f, 1.00000f, 0.000000f, 0.332779f, 0.000000f, -0.943005f, 
		0.853711f, 0.000000f, -0.520747f, 0.000000f, 1.00000f, 0.000000f, 
		0.111513f, 0.000000f, -0.993763f, -0.992266f, 0.000000f, 0.124134f, 
		0.000000f, 1.00000f, 0.000000f, -0.998220f, 0.000000f, -0.0596404f, 
		-0.0730672f, 0.000000f, -0.997327f, 0.000000f, 1.00000f, 0.000000f, 
		0.893671f, 0.000000f, 0.448723f, 0.000889285f, 0.000000f, 1.00000f, 
		0.0316958f, 0.000000f, 0.999498f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, 0.0316958f, 0.000000f, 0.999498f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.0316958f, 0.000000f, 0.999498f, -0.0133982f, -0.999682f, -0.0213763f, 
		1.00000f, 0.000000f, 0.000000f, 0.0316958f, 0.000000f, 0.999498f, 
		-0.0133982f, -0.999682f, -0.0213763f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, -0.0701758f, -1.27995e-006f, 0.997535f, 
		0.0397448f, 0.000000f, 0.999210f, 0.000000f, -1.00000f, 0.000000f, 
		0.925018f, 0.000000f, 0.379924f, 0.998749f, 0.000000f, -0.0500065f, 
		0.000000f, -1.00000f, 0.000000f, 0.925018f, 0.000000f, 0.379924f, 
		0.0397448f, 0.000000f, 0.999210f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0885017f, 0.000000f, -0.996076f, 0.998749f, 0.000000f, -0.0500065f, 
		0.000000f, -1.00000f, 0.000000f, 0.0823800f, 0.000000f, -0.996601f, 
		-0.0885017f, 0.000000f, -0.996076f, 0.000000f, -1.00000f, 0.000000f, 
		-0.988274f, 0.000000f, 0.152689f, 0.0823800f, 0.000000f, -0.996601f, 
		0.000000f, -1.00000f, 0.000000f, -0.999738f, -1.82344e-005f, 0.0228912f, 
		-0.988274f, 0.000000f, 0.152689f, 0.000000f, -1.00000f, 0.000000f, 
		-0.999738f, -1.82344e-005f, 0.0228912f, -0.0701758f, -1.27995e-006f, 0.997535f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, -0.999738f, -1.82344e-005f, 0.0228912f, 
		-0.988274f, 0.000000f, 0.152689f, 0.000000f, 1.00000f, 0.000000f, 
		0.0823800f, 0.000000f, -0.996601f, -0.0885017f, 0.000000f, -0.996076f, 
		0.000000f, 1.00000f, 0.000000f, 0.925018f, 0.000000f, 0.379924f, 
		0.998749f, 0.000000f, -0.0500065f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0701758f, -1.27995e-006f, 0.997535f, 0.0397448f, 0.000000f, 0.999210f, 
		0.000000f, 1.00000f, 0.000000f, -0.988274f, 0.000000f, 0.152689f, 
		0.0823800f, 0.000000f, -0.996601f, 0.000000f, 1.00000f, 0.000000f, 
		-0.999738f, -1.82344e-005f, 0.0228912f, -0.0701758f, -1.27995e-006f, 0.997535f, 
		0.000000f, 1.00000f, 0.000000f, 0.925018f, 0.000000f, 0.379924f, 
		0.0397448f, 0.000000f, 0.999210f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0885017f, 0.000000f, -0.996076f, 0.998749f, 0.000000f, -0.0500065f, 
		0.967220f, 0.000000f, -0.253941f, -0.0144323f, 0.000000f, -0.999896f, 
		0.000000f, 1.00000f, 0.000000f, 0.00989180f, 0.000000f, 0.999951f, 
		0.934849f, 0.000000f, 0.355046f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0163360f, 0.000000f, 0.999867f, -0.989240f, 0.000000f, -0.146302f, 
		0.000000f, 1.00000f, 0.000000f, 0.00106203f, 0.000000f, -0.999999f, 
		-0.359710f, 0.000000f, -0.933064f, 0.000000f, 1.00000f, 0.000000f, 
		0.00989180f, 0.000000f, 0.999951f, -0.0163360f, 0.000000f, 0.999867f, 
		0.000000f, 1.00000f, 0.000000f, 0.967220f, 0.000000f, -0.253941f, 
		0.934849f, 0.000000f, 0.355046f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0144323f, 0.000000f, -0.999896f, 0.00106203f, 0.000000f, -0.999999f, 
		0.000000f, 1.00000f, 0.000000f, -0.359710f, 0.000000f, -0.933064f, 
		-0.989240f, 0.000000f, -0.146302f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0163360f, 0.000000f, 0.999867f, -0.989240f, 0.000000f, -0.146302f, 
		0.000000f, -1.00000f, 0.000000f, -0.359710f, 0.000000f, -0.933064f, 
		-0.989240f, 0.000000f, -0.146302f, 0.000000f, -1.00000f, 0.000000f, 
		0.00106203f, 0.000000f, -0.999999f, -0.359710f, 0.000000f, -0.933064f, 
		-0.00958821f, -0.998271f, -0.0579945f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0144323f, 0.000000f, -0.999896f, 0.00106203f, 0.000000f, -0.999999f, 
		-0.00958821f, -0.998271f, -0.0579945f, 0.967220f, 0.000000f, -0.253941f, 
		-0.0144323f, 0.000000f, -0.999896f, -0.0125327f, -0.998625f, 0.0509028f, 
		0.00989180f, 0.000000f, 0.999951f, 0.934849f, 0.000000f, 0.355046f, 
		-0.0125327f, -0.998625f, 0.0509028f, -0.00958821f, -0.998271f, -0.0579945f, 
		0.967220f, 0.000000f, -0.253941f, 0.934849f, 0.000000f, 0.355046f, 
		-0.0125327f, -0.998625f, 0.0509028f, 0.000000f, -1.00000f, 0.000000f, 
		0.00989180f, 0.000000f, 0.999951f, -0.0163360f, 0.000000f, 0.999867f, 
		-0.0125327f, -0.998625f, 0.0509028f, -0.00958821f, -0.998271f, -0.0579945f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0927087f, 0.000000f, 0.995693f, -0.123764f, 0.000000f, 0.992312f, 
		0.000000f, -1.00000f, 0.000000f, 0.828571f, 0.000000f, 0.559884f, 
		0.987979f, 0.000000f, 0.154591f, 0.000000f, -1.00000f, 0.000000f, 
		0.828571f, 0.000000f, 0.559884f, -0.123764f, 0.000000f, 0.992312f, 
		0.000000f, -1.00000f, 0.000000f, -0.0734753f, 0.000000f, -0.997297f, 
		0.987669f, 0.000000f, -0.156555f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0734753f, 0.000000f, -0.997297f, 0.0742892f, 0.000000f, -0.997237f, 
		0.000000f, -1.00000f, 0.000000f, -0.998393f, -1.52025e-005f, 0.0566662f, 
		0.0742892f, 0.000000f, -0.997237f, 0.000000f, -1.00000f, 0.000000f, 
		-0.999999f, -1.85114e-005f, 0.00105131f, -0.998393f, -1.52025e-005f, 0.0566662f, 
		0.000000f, -1.00000f, 0.000000f, -0.999999f, -1.85114e-005f, 0.00105131f, 
		-0.0927087f, 0.000000f, 0.995693f, 0.000000f, -1.00000f, 0.000000f, 
		0.0444750f, 0.986060f, 0.160334f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0205197f, 0.986498f, 0.162485f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0205197f, 0.986498f, 0.162485f, -0.999999f, -1.85114e-005f, 0.00105131f, 
		-0.998393f, -1.52025e-005f, 0.0566662f, 0.0136662f, 0.973449f, 0.228496f, 
		0.0444750f, 0.986060f, 0.160334f, -0.0734753f, 0.000000f, -0.997297f, 
		-0.0205197f, 0.986498f, 0.162485f, 0.0742892f, 0.000000f, -0.997237f, 
		0.828571f, 0.000000f, 0.559884f, 0.987979f, 0.000000f, 0.154591f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0927087f, 0.000000f, 0.995693f, -0.123764f, 0.000000f, 0.992312f, 
		-0.0205197f, 0.986498f, 0.162485f, -0.998393f, -1.52025e-005f, 0.0566662f, 
		0.0742892f, 0.000000f, -0.997237f, 0.000000f, 1.00000f, 0.000000f, 
		-0.999999f, -1.85114e-005f, 0.00105131f, -0.0927087f, 0.000000f, 0.995693f, 
		0.828571f, 0.000000f, 0.559884f, 0.000000f, 1.00000f, 0.000000f, 
		-0.123764f, 0.000000f, 0.992312f, 0.0136662f, 0.973449f, 0.228496f, 
		-0.0734753f, 0.000000f, -0.997297f, 0.987669f, 0.000000f, -0.156555f, 
		0.987669f, 0.000000f, -0.156555f, 0.987979f, 0.000000f, 0.154591f, 
		0.000000f, -1.00000f, 0.000000f, 0.828571f, 0.000000f, 0.559884f, 
		0.987979f, 0.000000f, 0.154591f, -0.0734753f, 0.000000f, -0.997297f, 
		0.987669f, 0.000000f, -0.156555f, 0.0136662f, 0.973449f, 0.228496f, 
		0.000000f, 1.00000f, 0.000000f, 0.0444750f, 0.986060f, 0.160334f, 
		0.987669f, 0.000000f, -0.156555f, 0.987979f, 0.000000f, 0.154591f, 
		0.987669f, 0.000000f, -0.156555f, 0.987979f, 0.000000f, 0.154591f, 
		-0.0300585f, -0.999406f, -0.0168405f, -0.00686258f, -0.999828f, -0.0172567f, 
		0.0564556f, -0.996081f, 0.0680772f, 0.0255393f, -0.999650f, 0.00692919f, 
		-0.653044f, 0.000000f, -0.757320f, -0.866742f, 0.000000f, -0.498756f, 
		0.0564556f, -0.996081f, 0.0680772f, 0.0255393f, -0.999650f, 0.00692919f, 
		-0.998057f, 1.09042e-006f, 0.0623033f, 0.00970755f, 1.75010e-005f, 0.999953f, 
		-0.00686258f, -0.999828f, -0.0172567f, 0.0255393f, -0.999650f, 0.00692919f, 
		-0.998057f, 1.09042e-006f, 0.0623033f, -0.866742f, 0.000000f, -0.498756f, 
		0.0255393f, -0.999650f, 0.00692919f, 0.984589f, 0.000000f, -0.174885f, 
		0.00970755f, 1.75010e-005f, 0.999953f, -0.00686258f, -0.999828f, -0.0172567f, 
		0.998081f, 0.000000f, 0.0619231f, 0.984589f, 0.000000f, -0.174885f, 
		-0.0300585f, -0.999406f, -0.0168405f, -0.00686258f, -0.999828f, -0.0172567f, 
		0.0164760f, 0.000000f, -0.999864f, 0.998081f, 0.000000f, 0.0619231f, 
		-0.0300585f, -0.999406f, -0.0168405f, 0.689194f, 0.000000f, -0.724577f, 
		0.0164760f, 0.000000f, -0.999864f, -0.0300585f, -0.999406f, -0.0168405f, 
		0.0564556f, -0.996081f, 0.0680772f, 0.689194f, 0.000000f, -0.724577f, 
		-0.653044f, 0.000000f, -0.757320f, 0.0564556f, -0.996081f, 0.0680772f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.689194f, 0.000000f, -0.724577f, 0.0164760f, 0.000000f, -0.999864f, 
		0.000000f, 1.00000f, 0.000000f, 0.998081f, 0.000000f, 0.0619231f, 
		0.984589f, 0.000000f, -0.174885f, 0.000000f, 1.00000f, 0.000000f, 
		-0.998057f, 1.09042e-006f, 0.0623033f, 0.00970755f, 1.75010e-005f, 0.999953f, 
		0.000000f, 1.00000f, 0.000000f, -0.653044f, 0.000000f, -0.757320f, 
		-0.866742f, 0.000000f, -0.498756f, 0.000000f, 1.00000f, 0.000000f, 
		0.0164760f, 0.000000f, -0.999864f, 0.998081f, 0.000000f, 0.0619231f, 
		0.000000f, 1.00000f, 0.000000f, 0.689194f, 0.000000f, -0.724577f, 
		-0.653044f, 0.000000f, -0.757320f, 0.000000f, 1.00000f, 0.000000f, 
		-0.998057f, 1.09042e-006f, 0.0623033f, -0.866742f, 0.000000f, -0.498756f, 
		0.000000f, 1.00000f, 0.000000f, 0.984589f, 0.000000f, -0.174885f, 
		0.00970755f, 1.75010e-005f, 0.999953f, 0.000000f, -1.00000f, 0.000000f, 
		-0.653647f, 0.000000f, 0.756800f, 0.413605f, 0.000000f, 0.910457f, 
		0.000000f, -1.00000f, 0.000000f, 0.471952f, 0.000000f, 0.881624f, 
		0.984779f, 0.000000f, -0.173809f, 0.000000f, -1.00000f, 0.000000f, 
		0.471952f, 0.000000f, 0.881624f, 0.413605f, 0.000000f, 0.910457f, 
		0.000000f, -1.00000f, 0.000000f, 0.105961f, 0.000000f, -0.994370f, 
		0.984779f, 0.000000f, -0.173809f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0119334f, 0.000000f, -0.999929f, 0.105961f, 0.000000f, -0.994370f, 
		0.000000f, -1.00000f, 0.000000f, -0.980841f, 0.000000f, 0.194809f, 
		-0.0119334f, 0.000000f, -0.999929f, 0.000000f, -1.00000f, 0.000000f, 
		-0.670523f, 0.000000f, 0.741889f, -0.911406f, 0.000000f, -0.411509f, 
		0.000000f, -1.00000f, 0.000000f, -0.670523f, 0.000000f, 0.741889f, 
		-0.653647f, 0.000000f, 0.756800f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0875831f, 0.990138f, 0.109345f, 0.000000f, 1.00000f, 0.000000f, 
		0.0381553f, 0.996754f, 0.0708852f, -0.670523f, 0.000000f, 0.741889f, 
		-0.911406f, 0.000000f, -0.411509f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0404828f, 0.986593f, 0.158102f, -0.0875831f, 0.990138f, 0.109345f, 
		-0.0119334f, 0.000000f, -0.999929f, 0.0381553f, 0.996754f, 0.0708852f, 
		0.105961f, 0.000000f, -0.994370f, 0.000000f, 1.00000f, 0.000000f, 
		0.0381553f, 0.996754f, 0.0708852f, 0.471952f, 0.000000f, 0.881624f, 
		0.984779f, 0.000000f, -0.173809f, 0.000000f, 1.00000f, 0.000000f, 
		-0.653647f, 0.000000f, 0.756800f, 0.413605f, 0.000000f, 0.910457f, 
		-0.0404828f, 0.986593f, 0.158102f, -0.980841f, 0.000000f, 0.194809f, 
		-0.0119334f, 0.000000f, -0.999929f, -0.670523f, 0.000000f, 0.741889f, 
		0.000000f, 1.00000f, 0.000000f, -0.653647f, 0.000000f, 0.756800f, 
		0.000000f, 1.00000f, 0.000000f, 0.471952f, 0.000000f, 0.881624f, 
		0.413605f, 0.000000f, 0.910457f, 0.0381553f, 0.996754f, 0.0708852f, 
		0.105961f, 0.000000f, -0.994370f, 0.984779f, 0.000000f, -0.173809f, 
		-0.911406f, 0.000000f, -0.411509f, -0.980841f, 0.000000f, 0.194809f, 
		0.000000f, -1.00000f, 0.000000f, -0.980841f, 0.000000f, 0.194809f, 
		-0.0119334f, 0.000000f, -0.999929f, -0.670523f, 0.000000f, 0.741889f, 
		-0.911406f, 0.000000f, -0.411509f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0404828f, 0.986593f, 0.158102f, -0.0875831f, 0.990138f, 0.109345f, 
		-0.911406f, 0.000000f, -0.411509f, -0.980841f, 0.000000f, 0.194809f, 
		-0.911406f, 0.000000f, -0.411509f, -0.980841f, 0.000000f, 0.194809f, 
		0.000000f, -1.00000f, 0.000000f, -0.0945475f, -2.13071e-006f, 0.995520f, 
		-0.0599766f, -1.35163e-006f, 0.998200f, 0.000000f, -1.00000f, 0.000000f, 
		0.877607f, 0.000000f, 0.479380f, 0.874630f, 0.000000f, -0.484791f, 
		0.000000f, -1.00000f, 0.000000f, 0.877607f, 0.000000f, 0.479380f, 
		-0.0599766f, -1.35163e-006f, 0.998200f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0905478f, 0.000000f, -0.995892f, 0.874630f, 0.000000f, -0.484791f, 
		0.000000f, -1.00000f, 0.000000f, -0.181942f, 0.000000f, -0.983309f, 
		-0.0905478f, 0.000000f, -0.995892f, 0.000000f, -1.00000f, 0.000000f, 
		-0.466637f, 0.000000f, -0.884449f, -0.181942f, 0.000000f, -0.983309f, 
		0.000000f, -1.00000f, 0.000000f, -0.704092f, 0.000000f, 0.710109f, 
		-0.466637f, 0.000000f, -0.884449f, 0.000000f, -1.00000f, 0.000000f, 
		-0.704092f, 0.000000f, 0.710109f, -0.0945475f, -2.13071e-006f, 0.995520f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, -0.704092f, 0.000000f, 0.710109f, 
		-0.466637f, 0.000000f, -0.884449f, 0.000000f, 1.00000f, 0.000000f, 
		-0.181942f, 0.000000f, -0.983309f, -0.0905478f, 0.000000f, -0.995892f, 
		0.000000f, 1.00000f, 0.000000f, 0.877607f, 0.000000f, 0.479380f, 
		0.874630f, 0.000000f, -0.484791f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0945475f, -2.13071e-006f, 0.995520f, -0.0599766f, -1.35163e-006f, 0.998200f, 
		0.000000f, 1.00000f, 0.000000f, -0.466637f, 0.000000f, -0.884449f, 
		-0.181942f, 0.000000f, -0.983309f, 0.000000f, 1.00000f, 0.000000f, 
		-0.704092f, 0.000000f, 0.710109f, -0.0945475f, -2.13071e-006f, 0.995520f, 
		0.000000f, 1.00000f, 0.000000f, 0.877607f, 0.000000f, 0.479380f, 
		-0.0599766f, -1.35163e-006f, 0.998200f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0905478f, 0.000000f, -0.995892f, 0.874630f, 0.000000f, -0.484791f, 
		0.000000f, -1.00000f, 0.000000f, -0.985565f, 2.29685e-006f, 0.169297f, 
		-0.990832f, 0.000000f, 0.135097f, 0.000000f, -1.00000f, 0.000000f, 
		-0.976576f, 0.000000f, 0.215174f, 0.111167f, 0.000000f, 0.993802f, 
		0.000000f, -1.00000f, 0.000000f, -0.976576f, 0.000000f, 0.215174f, 
		-0.990832f, 0.000000f, 0.135097f, 0.000000f, -1.00000f, 0.000000f, 
		0.989676f, 0.000000f, 0.143321f, 0.111167f, 0.000000f, 0.993802f, 
		0.000000f, -1.00000f, 0.000000f, 0.999970f, 0.000000f, -0.00777349f, 
		0.989676f, 0.000000f, 0.143321f, 0.000000f, -1.00000f, 0.000000f, 
		0.179563f, 0.000000f, -0.983746f, 0.999970f, 0.000000f, -0.00777349f, 
		0.000000f, -1.00000f, 0.000000f, -0.0762228f, -1.13417e-005f, -0.997091f, 
		0.179563f, 0.000000f, -0.983746f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0762228f, -1.13417e-005f, -0.997091f, -0.985565f, 2.29685e-006f, 0.169297f, 
		0.000000f, -1.00000f, 0.000000f, 0.00809569f, 0.959629f, 0.281152f, 
		0.000000f, 1.00000f, 0.000000f, 0.0186572f, 0.979916f, 0.198535f, 
		0.00809569f, 0.959629f, 0.281152f, 0.0186572f, 0.979916f, 0.198535f, 
		-0.0762228f, -1.13417e-005f, -0.997091f, 0.179563f, 0.000000f, -0.983746f, 
		0.000000f, 1.00000f, 0.000000f, 0.0186572f, 0.979916f, 0.198535f, 
		0.999970f, 0.000000f, -0.00777349f, 0.989676f, 0.000000f, 0.143321f, 
		0.000000f, 1.00000f, 0.000000f, -0.976576f, 0.000000f, 0.215174f, 
		0.111167f, 0.000000f, 0.993802f, 0.000000f, 1.00000f, 0.000000f, 
		0.00809569f, 0.959629f, 0.281152f, -0.985565f, 2.29685e-006f, 0.169297f, 
		-0.990832f, 0.000000f, 0.135097f, 0.0186572f, 0.979916f, 0.198535f, 
		0.179563f, 0.000000f, -0.983746f, 0.999970f, 0.000000f, -0.00777349f, 
		0.00809569f, 0.959629f, 0.281152f, -0.0762228f, -1.13417e-005f, -0.997091f, 
		-0.985565f, 2.29685e-006f, 0.169297f, 0.000000f, 1.00000f, 0.000000f, 
		-0.976576f, 0.000000f, 0.215174f, -0.990832f, 0.000000f, 0.135097f, 
		0.000000f, 1.00000f, 0.000000f, 0.989676f, 0.000000f, 0.143321f, 
		0.111167f, 0.000000f, 0.993802f, 0.0688319f, -0.996974f, -0.0361212f, 
		0.0308145f, -0.996942f, 0.0718153f, -0.0327611f, -0.997521f, -0.0622826f, 
		-0.197827f, -0.980060f, 0.0186314f, -0.941059f, 0.000000f, -0.338241f, 
		-0.999895f, 0.000000f, 0.0145109f, -0.0327611f, -0.997521f, -0.0622826f, 
		-0.197827f, -0.980060f, 0.0186314f, -0.986148f, 0.000000f, 0.165869f, 
		0.00767975f, 1.75013e-005f, 0.999970f, 0.0308145f, -0.996942f, 0.0718153f, 
		-0.197827f, -0.980060f, 0.0186314f, -0.986148f, 0.000000f, 0.165869f, 
		-0.999895f, 0.000000f, 0.0145109f, -0.197827f, -0.980060f, 0.0186314f, 
		0.783927f, 1.08660e-005f, 0.620853f, 0.00767975f, 1.75013e-005f, 0.999970f, 
		0.0308145f, -0.996942f, 0.0718153f, 0.998108f, 0.000000f, 0.0614897f, 
		0.783927f, 1.08660e-005f, 0.620853f, 0.0688319f, -0.996974f, -0.0361212f, 
		0.0308145f, -0.996942f, 0.0718153f, 0.711962f, 0.000000f, -0.702218f, 
		0.998108f, 0.000000f, 0.0614897f, 0.0688319f, -0.996974f, -0.0361212f, 
		-0.0976067f, 0.000000f, -0.995225f, 0.711962f, 0.000000f, -0.702218f, 
		0.0688319f, -0.996974f, -0.0361212f, -0.0327611f, -0.997521f, -0.0622826f, 
		-0.0976067f, 0.000000f, -0.995225f, -0.941059f, 0.000000f, -0.338241f, 
		-0.0327611f, -0.997521f, -0.0622826f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, -0.0976067f, 0.000000f, -0.995225f, 
		0.711962f, 0.000000f, -0.702218f, 0.000000f, 1.00000f, 0.000000f, 
		0.998108f, 0.000000f, 0.0614897f, 0.783927f, 1.08660e-005f, 0.620853f, 
		0.000000f, 1.00000f, 0.000000f, -0.986148f, 0.000000f, 0.165869f, 
		0.00767975f, 1.75013e-005f, 0.999970f, 0.000000f, 1.00000f, 0.000000f, 
		-0.941059f, 0.000000f, -0.338241f, -0.999895f, 0.000000f, 0.0145109f, 
		0.000000f, 1.00000f, 0.000000f, 0.711962f, 0.000000f, -0.702218f, 
		0.998108f, 0.000000f, 0.0614897f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0976067f, 0.000000f, -0.995225f, -0.941059f, 0.000000f, -0.338241f, 
		0.000000f, 1.00000f, 0.000000f, -0.986148f, 0.000000f, 0.165869f, 
		-0.999895f, 0.000000f, 0.0145109f, 0.000000f, 1.00000f, 0.000000f, 
		0.783927f, 1.08660e-005f, 0.620853f, 0.00767975f, 1.75013e-005f, 0.999970f, 
		0.000000f, -1.00000f, 0.000000f, -0.999963f, 0.000000f, 0.00856752f, 
		-0.811654f, 0.000000f, -0.584139f, 0.000000f, -1.00000f, 0.000000f, 
		-0.877121f, 0.000000f, 0.480270f, 0.00826074f, 0.000000f, 0.999966f, 
		0.000000f, -1.00000f, 0.000000f, -0.877121f, 0.000000f, 0.480270f, 
		-0.811654f, 0.000000f, -0.584139f, 0.000000f, -1.00000f, 0.000000f, 
		0.686905f, 0.000000f, 0.726747f, 0.00826074f, 0.000000f, 0.999966f, 
		0.000000f, -1.00000f, 0.000000f, 0.902875f, 0.000000f, 0.429904f, 
		0.686905f, 0.000000f, 0.726747f, 0.000000f, -1.00000f, 0.000000f, 
		0.978530f, 0.000000f, -0.206104f, 0.902875f, 0.000000f, 0.429904f, 
		0.000000f, -1.00000f, 0.000000f, -0.135530f, 0.000000f, -0.990773f, 
		0.102231f, 0.000000f, -0.994761f, 0.000000f, -1.00000f, 0.000000f, 
		-0.135530f, 0.000000f, -0.990773f, -0.999963f, 0.000000f, 0.00856752f, 
		0.000000f, -1.00000f, 0.000000f, -0.0241229f, 0.998146f, 0.0558778f, 
		-0.00569386f, 0.998048f, 0.0621909f, -0.0552542f, 0.997977f, 0.0314563f, 
		0.000000f, 1.00000f, 0.000000f, -0.0241229f, 0.998146f, 0.0558778f, 
		-0.135530f, 0.000000f, -0.990773f, 0.102231f, 0.000000f, -0.994761f, 
		-0.0552542f, 0.997977f, 0.0314563f, 0.120870f, 0.990999f, 0.0575522f, 
		-0.00569386f, 0.998048f, 0.0621909f, 0.902875f, 0.000000f, 0.429904f, 
		0.000000f, 1.00000f, 0.000000f, 0.686905f, 0.000000f, 0.726747f, 
		0.000000f, 1.00000f, 0.000000f, -0.877121f, 0.000000f, 0.480270f, 
		0.00826074f, 0.000000f, 0.999966f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0552542f, 0.997977f, 0.0314563f, -0.999963f, 0.000000f, 0.00856752f, 
		-0.811654f, 0.000000f, -0.584139f, 0.120870f, 0.990999f, 0.0575522f, 
		0.978530f, 0.000000f, -0.206104f, 0.902875f, 0.000000f, 0.429904f, 
		-0.135530f, 0.000000f, -0.990773f, -0.0552542f, 0.997977f, 0.0314563f, 
		-0.999963f, 0.000000f, 0.00856752f, 0.000000f, 1.00000f, 0.000000f, 
		-0.877121f, 0.000000f, 0.480270f, -0.811654f, 0.000000f, -0.584139f, 
		0.000000f, 1.00000f, 0.000000f, 0.686905f, 0.000000f, 0.726747f, 
		0.00826074f, 0.000000f, 0.999966f, 0.102231f, 0.000000f, -0.994761f, 
		0.978530f, 0.000000f, -0.206104f, 0.000000f, -1.00000f, 0.000000f, 
		0.978530f, 0.000000f, -0.206104f, 0.902875f, 0.000000f, 0.429904f, 
		-0.135530f, 0.000000f, -0.990773f, 0.102231f, 0.000000f, -0.994761f, 
		-0.0241229f, 0.998146f, 0.0558778f, 0.120870f, 0.990999f, 0.0575522f, 
		-0.00569386f, 0.998048f, 0.0621909f, 0.102231f, 0.000000f, -0.994761f, 
		0.978530f, 0.000000f, -0.206104f, 0.102231f, 0.000000f, -0.994761f, 
		0.978530f, 0.000000f, -0.206104f, -0.0663359f, -0.996502f, 0.0508178f, 
		-0.0290527f, -0.998652f, -0.0430068f, 0.0635478f, -0.992625f, 0.103232f, 
		0.162103f, -0.985092f, 0.0575970f, -0.748752f, 0.000000f, 0.662850f, 
		-0.999837f, 0.000000f, -0.0180824f, 0.0635478f, -0.992625f, 0.103232f, 
		0.162103f, -0.985092f, 0.0575970f, -0.822413f, 0.000000f, -0.568891f, 
		0.00657179f, 0.000000f, 0.999978f, -0.0290527f, -0.998652f, -0.0430068f, 
		0.162103f, -0.985092f, 0.0575970f, -0.822413f, 0.000000f, -0.568891f, 
		-0.999837f, 0.000000f, -0.0180824f, 0.162103f, -0.985092f, 0.0575970f, 
		0.990811f, 0.000000f, -0.135252f, 0.00657179f, 0.000000f, 0.999978f, 
		-0.0290527f, -0.998652f, -0.0430068f, 0.994251f, 0.000000f, -0.107079f, 
		0.990811f, 0.000000f, -0.135252f, -0.0663359f, -0.996502f, 0.0508178f, 
		-0.0290527f, -0.998652f, -0.0430068f, 0.0569447f, 0.000000f, -0.998377f, 
		0.994251f, 0.000000f, -0.107079f, -0.0663359f, -0.996502f, 0.0508178f, 
		-0.0715122f, 0.000000f, -0.997440f, 0.0569447f, 0.000000f, -0.998377f, 
		-0.0663359f, -0.996502f, 0.0508178f, 0.0635478f, -0.992625f, 0.103232f, 
		-0.0715122f, 0.000000f, -0.997440f, -0.748752f, 0.000000f, 0.662850f, 
		0.0635478f, -0.992625f, 0.103232f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, -0.0715122f, 0.000000f, -0.997440f, 
		0.0569447f, 0.000000f, -0.998377f, 0.000000f, 1.00000f, 0.000000f, 
		0.994251f, 0.000000f, -0.107079f, 0.990811f, 0.000000f, -0.135252f, 
		0.000000f, 1.00000f, 0.000000f, -0.822413f, 0.000000f, -0.568891f, 
		0.00657179f, 0.000000f, 0.999978f, 0.000000f, 1.00000f, 0.000000f, 
		-0.748752f, 0.000000f, 0.662850f, -0.999837f, 0.000000f, -0.0180824f, 
		0.000000f, 1.00000f, 0.000000f, 0.0569447f, 0.000000f, -0.998377f, 
		0.994251f, 0.000000f, -0.107079f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0715122f, 0.000000f, -0.997440f, -0.748752f, 0.000000f, 0.662850f, 
		0.000000f, 1.00000f, 0.000000f, -0.822413f, 0.000000f, -0.568891f, 
		-0.999837f, 0.000000f, -0.0180824f, 0.000000f, 1.00000f, 0.000000f, 
		0.990811f, 0.000000f, -0.135252f, 0.00657179f, 0.000000f, 0.999978f, 
		0.000000f, -1.00000f, 0.000000f, -0.100343f, 0.000000f, 0.994953f, 
		0.0370640f, 0.000000f, 0.999313f, 0.000000f, -1.00000f, 0.000000f, 
		0.361755f, 0.000000f, 0.932273f, 0.959963f, 0.000000f, -0.280128f, 
		0.000000f, -1.00000f, 0.000000f, 0.361755f, 0.000000f, 0.932273f, 
		0.0370640f, 0.000000f, 0.999313f, 0.000000f, -1.00000f, 0.000000f, 
		-0.105521f, 0.000000f, -0.994417f, 0.959963f, 0.000000f, -0.280128f, 
		0.000000f, -1.00000f, 0.000000f, 0.0727751f, 0.000000f, -0.997348f, 
		-0.105521f, 0.000000f, -0.994417f, 0.000000f, -1.00000f, 0.000000f, 
		-0.989822f, 0.000000f, 0.142312f, 0.0727751f, 0.000000f, -0.997348f, 
		0.000000f, -1.00000f, 0.000000f, -0.982900f, 0.000000f, 0.184142f, 
		-0.989822f, 0.000000f, 0.142312f, 0.000000f, -1.00000f, 0.000000f, 
		-0.982900f, 0.000000f, 0.184142f, -0.100343f, 0.000000f, 0.994953f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0530191f, 0.987958f, 0.145353f, -0.0800020f, 0.990663f, 0.110390f, 
		0.000000f, 1.00000f, 0.000000f, -0.0800020f, 0.990663f, 0.110390f, 
		-0.982900f, 0.000000f, 0.184142f, -0.989822f, 0.000000f, 0.142312f, 
		-0.0530191f, 0.987958f, 0.145353f, -0.0800020f, 0.990663f, 0.110390f, 
		0.0727751f, 0.000000f, -0.997348f, -0.105521f, 0.000000f, -0.994417f, 
		0.000000f, 1.00000f, 0.000000f, -0.0530191f, 0.987958f, 0.145353f, 
		0.361755f, 0.000000f, 0.932273f, 0.959963f, 0.000000f, -0.280128f, 
		0.000000f, 1.00000f, 0.000000f, -0.100343f, 0.000000f, 0.994953f, 
		0.0370640f, 0.000000f, 0.999313f, -0.0800020f, 0.990663f, 0.110390f, 
		-0.989822f, 0.000000f, 0.142312f, 0.0727751f, 0.000000f, -0.997348f, 
		0.000000f, 1.00000f, 0.000000f, -0.982900f, 0.000000f, 0.184142f, 
		-0.100343f, 0.000000f, 0.994953f, 0.000000f, 1.00000f, 0.000000f, 
		0.361755f, 0.000000f, 0.932273f, 0.0370640f, 0.000000f, 0.999313f, 
		-0.0530191f, 0.987958f, 0.145353f, -0.105521f, 0.000000f, -0.994417f, 
		0.959963f, 0.000000f, -0.280128f, 0.000000f, -1.00000f, 0.000000f, 
		-0.964708f, 0.000000f, 0.263323f, -0.976803f, 0.000000f, 0.214140f, 
		0.000000f, -1.00000f, 0.000000f, -0.411087f, 0.000000f, 0.911596f, 
		0.0904074f, 0.000000f, 0.995905f, 0.000000f, -1.00000f, 0.000000f, 
		-0.411087f, 0.000000f, 0.911596f, -0.976803f, 0.000000f, 0.214140f, 
		0.000000f, -1.00000f, 0.000000f, 0.999088f, 0.000000f, 0.0426922f, 
		0.0904074f, 0.000000f, 0.995905f, 0.000000f, -1.00000f, 0.000000f, 
		0.999794f, 0.000000f, -0.0202736f, 0.999088f, 0.000000f, 0.0426922f, 
		0.000000f, -1.00000f, 0.000000f, 0.127555f, 0.000000f, -0.991831f, 
		0.999794f, 0.000000f, -0.0202736f, 0.000000f, -1.00000f, 0.000000f, 
		-0.105312f, 0.000000f, -0.994439f, 0.127555f, 0.000000f, -0.991831f, 
		0.000000f, -1.00000f, 0.000000f, -0.105312f, 0.000000f, -0.994439f, 
		-0.964708f, 0.000000f, 0.263323f, 0.000000f, -1.00000f, 0.000000f, 
		0.00387774f, 0.983731f, 0.179607f, 0.000000f, 1.00000f, 0.000000f, 
		0.0580996f, 0.994129f, 0.0912751f, 0.00387774f, 0.983731f, 0.179607f, 
		0.0580996f, 0.994129f, 0.0912751f, -0.105312f, 0.000000f, -0.994439f, 
		0.127555f, 0.000000f, -0.991831f, 0.000000f, 1.00000f, 0.000000f, 
		0.0580996f, 0.994129f, 0.0912751f, 0.999794f, 0.000000f, -0.0202736f, 
		0.999088f, 0.000000f, 0.0426922f, 0.000000f, 1.00000f, 0.000000f, 
		-0.411087f, 0.000000f, 0.911596f, 0.0904074f, 0.000000f, 0.995905f, 
		0.000000f, 1.00000f, 0.000000f, 0.00387774f, 0.983731f, 0.179607f, 
		-0.964708f, 0.000000f, 0.263323f, -0.976803f, 0.000000f, 0.214140f, 
		0.0580996f, 0.994129f, 0.0912751f, 0.127555f, 0.000000f, -0.991831f, 
		0.999794f, 0.000000f, -0.0202736f, 0.00387774f, 0.983731f, 0.179607f, 
		-0.105312f, 0.000000f, -0.994439f, -0.964708f, 0.000000f, 0.263323f, 
		0.000000f, 1.00000f, 0.000000f, -0.411087f, 0.000000f, 0.911596f, 
		-0.976803f, 0.000000f, 0.214140f, 0.000000f, 1.00000f, 0.000000f, 
		0.999088f, 0.000000f, 0.0426922f, 0.0904074f, 0.000000f, 0.995905f, 
		0.0945612f, -0.993266f, 0.0669371f, -0.0639283f, -0.996127f, 0.0603728f, 
		0.0563700f, -0.991032f, -0.121152f, -0.126247f, -0.991610f, -0.0277598f, 
		0.0316305f, 0.000000f, -0.999500f, -0.860598f, 0.000000f, -0.509286f, 
		0.0563700f, -0.991032f, -0.121152f, -0.126247f, -0.991610f, -0.0277598f, 
		-0.736348f, 0.000000f, -0.676603f, -0.727435f, 0.000000f, 0.686177f, 
		-0.0639283f, -0.996127f, 0.0603728f, -0.126247f, -0.991610f, -0.0277598f, 
		-0.736348f, 0.000000f, -0.676603f, -0.860598f, 0.000000f, -0.509286f, 
		-0.126247f, -0.991610f, -0.0277598f, 0.0748482f, 0.000000f, 0.997195f, 
		-0.727435f, 0.000000f, 0.686177f, -0.0639283f, -0.996127f, 0.0603728f, 
		0.00634798f, 0.000000f, 0.999980f, 0.0748482f, 0.000000f, 0.997195f, 
		0.0945612f, -0.993266f, 0.0669371f, -0.0639283f, -0.996127f, 0.0603728f, 
		0.987840f, 0.000000f, 0.155472f, 0.00634798f, 0.000000f, 0.999980f, 
		0.0945612f, -0.993266f, 0.0669371f, 0.884714f, 0.000000f, -0.466134f, 
		0.987840f, 0.000000f, 0.155472f, 0.0945612f, -0.993266f, 0.0669371f, 
		0.0563700f, -0.991032f, -0.121152f, 0.884714f, 0.000000f, -0.466134f, 
		0.0316305f, 0.000000f, -0.999500f, 0.0563700f, -0.991032f, -0.121152f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.884714f, 0.000000f, -0.466134f, 0.987840f, 0.000000f, 0.155472f, 
		0.000000f, 1.00000f, 0.000000f, 0.00634798f, 0.000000f, 0.999980f, 
		0.0748482f, 0.000000f, 0.997195f, 0.000000f, 1.00000f, 0.000000f, 
		-0.736348f, 0.000000f, -0.676603f, -0.727435f, 0.000000f, 0.686177f, 
		0.000000f, 1.00000f, 0.000000f, 0.0316305f, 0.000000f, -0.999500f, 
		-0.860598f, 0.000000f, -0.509286f, 0.000000f, 1.00000f, 0.000000f, 
		0.987840f, 0.000000f, 0.155472f, 0.00634798f, 0.000000f, 0.999980f, 
		0.000000f, 1.00000f, 0.000000f, 0.884714f, 0.000000f, -0.466134f, 
		0.0316305f, 0.000000f, -0.999500f, 0.000000f, 1.00000f, 0.000000f, 
		-0.736348f, 0.000000f, -0.676603f, -0.860598f, 0.000000f, -0.509286f, 
		0.000000f, 1.00000f, 0.000000f, 0.0748482f, 0.000000f, 0.997195f, 
		-0.727435f, 0.000000f, 0.686177f, 0.0319780f, -0.999314f, -0.0186595f, 
		0.0268375f, -0.998378f, -0.0502130f, -0.0252347f, -0.999270f, -0.0286653f, 
		-0.0214277f, -0.999159f, 0.0349560f, 0.00727004f, -0.999048f, 0.0430253f, 
		-0.00320525f, 0.000000f, -0.999995f, 0.221859f, 0.000000f, -0.975079f, 
		-0.0214277f, -0.999159f, 0.0349560f, 0.00727004f, -0.999048f, 0.0430253f, 
		-0.397353f, 0.000000f, -0.917666f, -0.863713f, 0.000000f, 0.503984f, 
		0.0319780f, -0.999314f, -0.0186595f, 0.00727004f, -0.999048f, 0.0430253f, 
		-0.397353f, 0.000000f, -0.917666f, 0.221859f, 0.000000f, -0.975079f, 
		0.00727004f, -0.999048f, 0.0430253f, 0.0516609f, 0.000000f, 0.998665f, 
		-0.991964f, 0.000000f, -0.126521f, 0.000000f, -1.00000f, 0.000000f, 
		0.0516609f, 0.000000f, 0.998665f, 0.000000f, -1.00000f, 0.000000f, 
		0.0268375f, -0.998378f, -0.0502130f, 0.118584f, 0.000000f, 0.992944f, 
		-0.0252347f, -0.999270f, -0.0286653f, 0.996284f, 0.000000f, 0.0861301f, 
		0.118584f, 0.000000f, 0.992944f, -0.0252347f, -0.999270f, -0.0286653f, 
		0.996052f, 0.000000f, -0.0887705f, 0.996284f, 0.000000f, 0.0861301f, 
		-0.0252347f, -0.999270f, -0.0286653f, -0.0214277f, -0.999159f, 0.0349560f, 
		0.996052f, 0.000000f, -0.0887705f, -0.00320525f, 0.000000f, -0.999995f, 
		-0.0214277f, -0.999159f, 0.0349560f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, 0.996052f, 0.000000f, -0.0887705f, 
		0.996284f, 0.000000f, 0.0861301f, 0.0516609f, 0.000000f, 0.998665f, 
		0.000000f, 1.00000f, 0.000000f, 0.118584f, 0.000000f, 0.992944f, 
		-0.397353f, 0.000000f, -0.917666f, -0.863713f, 0.000000f, 0.503984f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.00320525f, 0.000000f, -0.999995f, 0.221859f, 0.000000f, -0.975079f, 
		0.000000f, 1.00000f, 0.000000f, 0.996284f, 0.000000f, 0.0861301f, 
		0.118584f, 0.000000f, 0.992944f, 0.000000f, 1.00000f, 0.000000f, 
		0.996052f, 0.000000f, -0.0887705f, -0.00320525f, 0.000000f, -0.999995f, 
		-0.397353f, 0.000000f, -0.917666f, 0.000000f, 1.00000f, 0.000000f, 
		0.221859f, 0.000000f, -0.975079f, 0.000000f, 1.00000f, 0.000000f, 
		0.0516609f, 0.000000f, 0.998665f, -0.991964f, 0.000000f, -0.126521f, 
		-0.991964f, 0.000000f, -0.126521f, -0.863713f, 0.000000f, 0.503984f, 
		0.0319780f, -0.999314f, -0.0186595f, 0.000000f, -1.00000f, 0.000000f, 
		0.0268375f, -0.998378f, -0.0502130f, -0.397353f, 0.000000f, -0.917666f, 
		-0.863713f, 0.000000f, 0.503984f, 0.0516609f, 0.000000f, 0.998665f, 
		-0.991964f, 0.000000f, -0.126521f, 0.000000f, 1.00000f, 0.000000f, 
		-0.991964f, 0.000000f, -0.126521f, -0.863713f, 0.000000f, 0.503984f, 
		-0.991964f, 0.000000f, -0.126521f, -0.863713f, 0.000000f, 0.503984f, 
		0.0778112f, -0.995077f, -0.0613792f, 0.0580015f, -0.997658f, 0.0362649f, 
		-0.0849202f, -0.996304f, -0.0129167f, -0.125051f, -0.992150f, 0.000603564f, 
		-0.995006f, 0.000000f, 0.0998119f, -0.990698f, 0.000000f, 0.136080f, 
		-0.0849202f, -0.996304f, -0.0129167f, -0.125051f, -0.992150f, 0.000603564f, 
		-0.596668f, 0.000000f, 0.802488f, -0.0672197f, 0.000000f, 0.997738f, 
		0.0580015f, -0.997658f, 0.0362649f, -0.125051f, -0.992150f, 0.000603564f, 
		-0.596668f, 0.000000f, 0.802488f, -0.990698f, 0.000000f, 0.136080f, 
		-0.125051f, -0.992150f, 0.000603564f, 0.999327f, 0.000000f, 0.0366806f, 
		-0.0672197f, 0.000000f, 0.997738f, 0.0580015f, -0.997658f, 0.0362649f, 
		0.998728f, 0.000000f, -0.0504200f, 0.999327f, 0.000000f, 0.0366806f, 
		0.0778112f, -0.995077f, -0.0613792f, 0.0580015f, -0.997658f, 0.0362649f, 
		-0.100108f, 0.000000f, -0.994977f, 0.998728f, 0.000000f, -0.0504200f, 
		0.0778112f, -0.995077f, -0.0613792f, -0.0495185f, 0.000000f, -0.998773f, 
		-0.100108f, 0.000000f, -0.994977f, 0.0778112f, -0.995077f, -0.0613792f, 
		-0.0849202f, -0.996304f, -0.0129167f, -0.0495185f, 0.000000f, -0.998773f, 
		-0.995006f, 0.000000f, 0.0998119f, -0.0849202f, -0.996304f, -0.0129167f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0495185f, 0.000000f, -0.998773f, -0.100108f, 0.000000f, -0.994977f, 
		0.000000f, 1.00000f, 0.000000f, 0.998728f, 0.000000f, -0.0504200f, 
		0.999327f, 0.000000f, 0.0366806f, 0.000000f, 1.00000f, 0.000000f, 
		-0.596668f, 0.000000f, 0.802488f, -0.0672197f, 0.000000f, 0.997738f, 
		0.000000f, 1.00000f, 0.000000f, -0.995006f, 0.000000f, 0.0998119f, 
		-0.990698f, 0.000000f, 0.136080f, 0.000000f, 1.00000f, 0.000000f, 
		-0.100108f, 0.000000f, -0.994977f, 0.998728f, 0.000000f, -0.0504200f, 
		0.000000f, 1.00000f, 0.000000f, -0.0495185f, 0.000000f, -0.998773f, 
		-0.995006f, 0.000000f, 0.0998119f, 0.000000f, 1.00000f, 0.000000f, 
		-0.596668f, 0.000000f, 0.802488f, -0.990698f, 0.000000f, 0.136080f, 
		0.000000f, 1.00000f, 0.000000f, 0.999327f, 0.000000f, 0.0366806f, 
		-0.0672197f, 0.000000f, 0.997738f, -0.991784f, -0.0530904f, -0.116391f, 
		-0.994772f, -0.0891395f, 0.0498249f, -0.996369f, -0.0183852f, -0.0831310f, 
		-0.995941f, 0.0799488f, -0.0413599f, -0.00369818f, 0.999085f, -0.0426126f, 
		0.000000f, 0.999121f, -0.0419223f, -0.996369f, -0.0183852f, -0.0831310f, 
		-0.995941f, 0.0799488f, -0.0413599f, 0.000000f, 0.977130f, 0.212644f, 
		0.000000f, 0.0257772f, 0.999668f, -0.994772f, -0.0891395f, 0.0498249f, 
		-0.995941f, 0.0799488f, -0.0413599f, 0.000000f, 0.977130f, 0.212644f, 
		0.000000f, 0.999121f, -0.0419223f, -0.995941f, 0.0799488f, -0.0413599f, 
		0.000000f, -0.999803f, -0.0198569f, 0.000000f, 0.0257772f, 0.999668f, 
		-0.994772f, -0.0891395f, 0.0498249f, 0.000000f, -0.963666f, -0.267111f, 
		0.000000f, -0.999803f, -0.0198569f, -0.991784f, -0.0530904f, -0.116391f, 
		-0.994772f, -0.0891395f, 0.0498249f, 0.000000f, -0.0860911f, -0.996287f, 
		0.000000f, -0.963666f, -0.267111f, -0.991784f, -0.0530904f, -0.116391f, 
		-0.0858350f, 0.120449f, -0.989002f, 0.000000f, -0.0860911f, -0.996287f, 
		-0.991784f, -0.0530904f, -0.116391f, -0.996369f, -0.0183852f, -0.0831310f, 
		-0.0858350f, 0.120449f, -0.989002f, -0.00369818f, 0.999085f, -0.0426126f, 
		-0.996369f, -0.0183852f, -0.0831310f, 0.998425f, 0.0247489f, 0.0503402f, 
		0.996704f, 0.0803226f, 0.0114109f, 0.999257f, 0.0359968f, 0.0137853f, 
		0.995847f, -0.0872747f, 0.0259246f, 0.996704f, 0.0803226f, 0.0114109f, 
		0.995847f, -0.0872747f, 0.0259246f, -0.0858350f, 0.120449f, -0.989002f, 
		0.000000f, -0.0860911f, -0.996287f, 0.999257f, 0.0359968f, 0.0137853f, 
		0.995847f, -0.0872747f, 0.0259246f, 0.000000f, -0.963666f, -0.267111f, 
		0.000000f, -0.999803f, -0.0198569f, 0.998425f, 0.0247489f, 0.0503402f, 
		0.999257f, 0.0359968f, 0.0137853f, 0.000000f, 0.977130f, 0.212644f, 
		0.000000f, 0.0257772f, 0.999668f, 0.998425f, 0.0247489f, 0.0503402f, 
		0.996704f, 0.0803226f, 0.0114109f, -0.00369818f, 0.999085f, -0.0426126f, 
		0.000000f, 0.999121f, -0.0419223f, 0.995847f, -0.0872747f, 0.0259246f, 
		0.000000f, -0.0860911f, -0.996287f, 0.000000f, -0.963666f, -0.267111f, 
		0.996704f, 0.0803226f, 0.0114109f, -0.0858350f, 0.120449f, -0.989002f, 
		-0.00369818f, 0.999085f, -0.0426126f, 0.998425f, 0.0247489f, 0.0503402f, 
		0.000000f, 0.977130f, 0.212644f, 0.000000f, 0.999121f, -0.0419223f, 
		0.999257f, 0.0359968f, 0.0137853f, 0.000000f, -0.999803f, -0.0198569f, 
		0.000000f, 0.0257772f, 0.999668f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.998576f, -0.0533560f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.998576f, -0.0533560f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -0.997505f, -0.0705940f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.992630f, -0.121182f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -0.997505f, -0.0705940f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.992630f, -0.121182f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, -1.00000f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-1.00000f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.997505f, 0.0705940f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.997505f, 0.0705940f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.997505f, 0.0705940f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.997505f, 0.0705940f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -0.997505f, -0.0705940f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.992630f, -0.121182f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.998658f, -0.0517980f, 0.000000f, 
		0.162502f, 0.986708f, 0.000000f, 0.0590033f, 0.0305516f, 0.997790f, 
		0.0181529f, -0.999835f, 0.000000f, 0.997512f, 0.0704983f, 0.000000f, 
		0.0548406f, -0.0320099f, 0.997982f, -0.0171077f, -0.999854f, 0.000000f, 
		-0.999971f, -0.00764230f, 0.000000f, -0.0779618f, 0.00376242f, 0.996949f, 
		0.508679f, 0.860956f, 0.000000f, -0.999931f, 0.0117775f, 0.000000f, 
		-0.0780392f, -0.00175892f, 0.996949f, 0.0181529f, -0.999835f, 0.000000f, 
		-0.0171077f, -0.999854f, 0.000000f, -0.0779618f, 0.00376242f, 0.996949f, 
		0.0548406f, -0.0320099f, 0.997982f, 0.997512f, 0.0704983f, 0.000000f, 
		0.998658f, -0.0517980f, 0.000000f, 0.0590033f, 0.0305516f, 0.997790f, 
		0.0548406f, -0.0320099f, 0.997982f, 0.508679f, 0.860956f, 0.000000f, 
		0.162502f, 0.986708f, 0.000000f, -0.0780392f, -0.00175892f, 0.996949f, 
		0.0590033f, 0.0305516f, 0.997790f, -0.999971f, -0.00764230f, 0.000000f, 
		-0.999931f, 0.0117775f, 0.000000f, -0.0780392f, -0.00175892f, 0.996949f, 
		-0.0779618f, 0.00376242f, 0.996949f, -0.0780392f, -0.00175892f, 0.996949f, 
		0.0590033f, 0.0305516f, 0.997790f, -0.0779618f, 0.00376242f, 0.996949f, 
		0.0548406f, -0.0320099f, 0.997982f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.999971f, -0.00764230f, 0.000000f, 
		-0.999931f, 0.0117775f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.508679f, 0.860956f, 0.000000f, 0.162502f, 0.986708f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.997512f, 0.0704983f, 0.000000f, 
		0.998658f, -0.0517980f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0181529f, -0.999835f, 0.000000f, -0.0171077f, -0.999854f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.508679f, 0.860956f, 0.000000f, 
		-0.999931f, 0.0117775f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0171077f, -0.999854f, 0.000000f, -0.999971f, -0.00764230f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0181529f, -0.999835f, 0.000000f, 
		0.997512f, 0.0704983f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.998658f, -0.0517980f, 0.000000f, 0.162502f, 0.986708f, 0.000000f, 
		0.00164819f, -0.999999f, 1.02578e-007f, 0.00164819f, -0.999999f, 1.02578e-007f, 
		0.00164819f, -0.999999f, 1.02578e-007f, -0.0227396f, -0.999741f, -6.87401e-007f, 
		-0.0227396f, -0.999741f, -6.87401e-007f, 0.00164819f, -0.999999f, 1.02578e-007f, 
		-0.0227396f, -0.999741f, -6.87401e-007f, -0.0227396f, -0.999741f, -6.87401e-007f, 
		0.998120f, 0.0612837f, 0.000000f, 0.316672f, 0.948535f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0148504f, -0.999890f, 0.000000f, 
		0.999629f, -0.0272404f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0128255f, -0.999918f, 0.000000f, -0.999474f, 0.0324274f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.157335f, 0.987545f, 0.000000f, 
		-0.998088f, -0.0618119f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0148504f, -0.999890f, 0.000000f, 0.0128255f, -0.999918f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.999629f, -0.0272404f, 0.000000f, 
		0.998120f, 0.0612837f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.157335f, 0.987545f, 0.000000f, 0.316672f, 0.948535f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.999474f, 0.0324274f, 0.000000f, 
		-0.998088f, -0.0618119f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.999474f, 0.0324274f, 0.000000f, 
		-0.998088f, -0.0618119f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.157335f, 0.987545f, 0.000000f, 0.316672f, 0.948535f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.999629f, -0.0272404f, 0.000000f, 
		0.998120f, 0.0612837f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0148504f, -0.999890f, 0.000000f, 0.0128255f, -0.999918f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.157335f, 0.987545f, 0.000000f, 
		-0.998088f, -0.0618119f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0128255f, -0.999918f, 0.000000f, -0.999474f, 0.0324274f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0148504f, -0.999890f, 0.000000f, 
		0.999629f, -0.0272404f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.998120f, 0.0612837f, 0.000000f, 0.316672f, 0.948535f, 0.000000f, 
		0.0836852f, -0.996492f, 0.000000f, 0.0836852f, -0.996492f, 0.000000f, 
		0.0836852f, -0.996492f, 0.000000f, -0.260142f, -0.965570f, 0.000000f, 
		-0.260142f, -0.965570f, 0.000000f, 0.0836852f, -0.996492f, 0.000000f, 
		-0.260142f, -0.965570f, 0.000000f, -0.260142f, -0.965570f, 0.000000f, 
		0.999976f, 0.00689905f, 0.000000f, 0.107973f, 0.994154f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.257010f, -0.966409f, 0.000000f, 
		0.999815f, -0.0192246f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0812242f, -0.996696f, 0.000000f, -0.996786f, 0.0801064f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.129505f, 0.991579f, 0.000000f, 
		-0.997492f, 0.0707820f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.257010f, -0.966409f, 0.000000f, 0.0812242f, -0.996696f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.999815f, -0.0192246f, 0.000000f, 
		0.999976f, 0.00689905f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.129505f, 0.991579f, 0.000000f, 0.107973f, 0.994154f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.996786f, 0.0801064f, 0.000000f, 
		-0.997492f, 0.0707820f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, -0.196080f, 0.00157749f, -0.980587f, 
		0.000000f, 0.000000f, -1.00000f, -0.195568f, 0.00223690f, -0.980688f, 
		0.000000f, 0.000000f, -1.00000f, -0.996786f, 0.0801064f, 0.000000f, 
		-0.997492f, 0.0707820f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.196080f, 0.00157749f, -0.980587f, -0.129505f, 0.991579f, 0.000000f, 
		0.107973f, 0.994154f, 0.000000f, -0.196080f, 0.00157749f, -0.980587f, 
		-0.195568f, 0.00223690f, -0.980688f, 0.999815f, -0.0192246f, 0.000000f, 
		0.999976f, 0.00689905f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.195568f, 0.00223690f, -0.980688f, -0.257010f, -0.966409f, 0.000000f, 
		0.0812242f, -0.996696f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.129505f, 0.991579f, 0.000000f, -0.997492f, 0.0707820f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0812242f, -0.996696f, 0.000000f, 
		-0.996786f, 0.0801064f, 0.000000f, -0.195568f, 0.00223690f, -0.980688f, 
		-0.257010f, -0.966409f, 0.000000f, 0.999815f, -0.0192246f, 0.000000f, 
		-0.196080f, 0.00157749f, -0.980587f, 0.999976f, 0.00689905f, 0.000000f, 
		0.107973f, 0.994154f, 0.000000f, -0.465525f, -0.885035f, 0.000000f, 
		-0.465525f, -0.885035f, 0.000000f, -0.465525f, -0.885035f, 0.000000f, 
		-0.173673f, -0.984803f, 0.000000f, -0.0213435f, -0.999772f, -6.50977e-007f, 
		-0.173673f, -0.984803f, 0.000000f, -0.465525f, -0.885035f, 0.000000f, 
		-0.173673f, -0.984803f, 0.000000f, -0.0213435f, -0.999772f, -6.50977e-007f, 
		-0.173673f, -0.984803f, 0.000000f, 0.0448723f, 0.0701912f, 0.996524f, 
		0.00853017f, 0.999964f, 0.000000f, -0.0743602f, 0.997231f, 0.000000f, 
		-0.0692947f, 0.0574913f, 0.995938f, 0.0404710f, -0.0396407f, 0.998394f, 
		-0.0213436f, -0.999772f, 0.000000f, -0.171179f, -0.985240f, 0.000000f, 
		-0.0767130f, -0.0156643f, 0.996930f, -0.466821f, -0.884352f, 0.000000f, 
		-1.00000f, 0.000000f, 0.000000f, 0.0241691f, 0.0259885f, 0.999370f, 
		0.163912f, 0.986475f, 0.000000f, -0.950248f, 0.311494f, 0.000000f, 
		0.00892955f, -0.0512565f, 0.998646f, -0.171179f, -0.985240f, 0.000000f, 
		-0.466821f, -0.884352f, 0.000000f, 0.0241691f, 0.0259885f, 0.999370f, 
		-0.0767130f, -0.0156643f, 0.996930f, 0.0404710f, -0.0396407f, 0.998394f, 
		0.0448723f, 0.0701912f, 0.996524f, -0.0692947f, 0.0574913f, 0.995938f, 
		-0.0767130f, -0.0156643f, 0.996930f, 0.163912f, 0.986475f, 0.000000f, 
		-0.0743602f, 0.997231f, 0.000000f, 0.00892955f, -0.0512565f, 0.998646f, 
		-0.0692947f, 0.0574913f, 0.995938f, -1.00000f, 0.000000f, 0.000000f, 
		-0.950248f, 0.311494f, 0.000000f, 0.00892955f, -0.0512565f, 0.998646f, 
		0.0241691f, 0.0259885f, 0.999370f, 0.00892955f, -0.0512565f, 0.998646f, 
		-0.0692947f, 0.0574913f, 0.995938f, 0.0241691f, 0.0259885f, 0.999370f, 
		-0.0767130f, -0.0156643f, 0.996930f, 0.0877414f, -0.205980f, -0.974615f, 
		0.000259697f, -0.327167f, -0.944966f, 0.174247f, -0.00957823f, -0.984655f, 
		0.000000f, 0.000000f, -1.00000f, 0.0877414f, -0.205980f, -0.974615f, 
		0.174247f, -0.00957823f, -0.984655f, -1.00000f, 0.000000f, 0.000000f, 
		-0.950248f, 0.311494f, 0.000000f, 0.0877414f, -0.205980f, -0.974615f, 
		0.000259697f, -0.327167f, -0.944966f, 0.163912f, 0.986475f, 0.000000f, 
		-0.0743602f, 0.997231f, 0.000000f, -0.0854612f, -0.133682f, -0.987333f, 
		-0.155551f, 0.00393875f, -0.987820f, 0.000259697f, -0.327167f, -0.944966f, 
		0.000000f, 0.000000f, -1.00000f, 0.174247f, -0.00957823f, -0.984655f, 
		0.000000f, 0.000000f, -1.00000f, -0.171179f, -0.985240f, 0.000000f, 
		-0.466821f, -0.884352f, 0.000000f, 0.0877414f, -0.205980f, -0.974615f, 
		0.163912f, 0.986475f, 0.000000f, -0.950248f, 0.311494f, 0.000000f, 
		0.174247f, -0.00957823f, -0.984655f, -0.466821f, -0.884352f, 0.000000f, 
		-1.00000f, 0.000000f, 0.000000f, -0.0213436f, -0.999772f, 0.000000f, 
		-0.155551f, 0.00393875f, -0.987820f, 0.000000f, 0.000000f, -1.00000f, 
		-0.171179f, -0.985240f, 0.000000f, 0.00853017f, 0.999964f, 0.000000f, 
		-0.0854612f, -0.133682f, -0.987333f, 0.000259697f, -0.327167f, -0.944966f, 
		-0.0743602f, 0.997231f, 0.000000f, 0.997876f, -0.0651406f, 0.000000f, 
		0.00853017f, 0.999964f, 0.000000f, -0.0854612f, -0.133682f, -0.987333f, 
		0.999998f, -0.00205855f, 0.000000f, -0.0213436f, -0.999772f, 0.000000f, 
		-0.155551f, 0.00393875f, -0.987820f, 0.999998f, -0.00205855f, 0.000000f, 
		0.997876f, -0.0651406f, 0.000000f, -0.0854612f, -0.133682f, -0.987333f, 
		-0.155551f, 0.00393875f, -0.987820f, 0.999998f, -0.00205855f, 0.000000f, 
		0.997876f, -0.0651406f, 0.000000f, 0.0404710f, -0.0396407f, 0.998394f, 
		0.0448723f, 0.0701912f, 0.996524f, 0.999998f, -0.00205855f, 0.000000f, 
		0.0404710f, -0.0396407f, 0.998394f, -0.0213436f, -0.999772f, 0.000000f, 
		0.997876f, -0.0651406f, 0.000000f, 0.0448723f, 0.0701912f, 0.996524f, 
		0.00853017f, 0.999964f, 0.000000f, -0.0213435f, -0.999772f, -6.50977e-007f, 
		-0.0213435f, -0.999772f, -6.50977e-007f, 0.915579f, 0.402139f, 0.000000f, 
		0.909117f, 0.416541f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.646977f, -0.762510f, 0.000000f, 0.967182f, -0.254083f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.959183f, 0.282788f, 0.000000f, 
		-0.00118088f, -0.999999f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.973597f, -0.228274f, 0.000000f, 0.0120221f, 0.999928f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.646977f, -0.762510f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.915579f, 0.402139f, 0.000000f, 0.967182f, -0.254083f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.909117f, 0.416541f, 0.000000f, 
		0.0393447f, 0.999226f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.973597f, -0.228274f, 0.000000f, -0.959183f, 0.282788f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -1.00000f, 0.000000f, -0.00118088f, -0.999999f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0393447f, 0.999226f, 0.000000f, 
		0.0120221f, 0.999928f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0393447f, 0.999226f, 0.000000f, 
		0.0120221f, 0.999928f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, -0.00118088f, -0.999999f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.973597f, -0.228274f, 0.000000f, -0.959183f, 0.282788f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.909117f, 0.416541f, 0.000000f, 
		0.0393447f, 0.999226f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.915579f, 0.402139f, 0.000000f, 0.967182f, -0.254083f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.646977f, -0.762510f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.973597f, -0.228274f, 0.000000f, 0.0120221f, 0.999928f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.959183f, 0.282788f, 0.000000f, 
		-0.00118088f, -0.999999f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.646977f, -0.762510f, 0.000000f, 0.967182f, -0.254083f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.915579f, 0.402139f, 0.000000f, 
		0.909117f, 0.416541f, 0.000000f, 0.201187f, 0.979553f, 0.000000f, 
		0.998566f, 0.0535316f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, -0.0230394f, -0.999735f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.206007f, -0.978550f, 0.000000f, 
		-0.997275f, -0.0737783f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.435557f, 0.900161f, 0.000000f, -0.986468f, 0.163952f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.114344f, -0.993441f, 0.000000f, 
		-0.0230394f, -0.999735f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 1.00000f, 0.000000f, 0.998566f, 0.0535316f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.285779f, 0.958295f, 0.000000f, 
		0.201187f, 0.979553f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.997275f, -0.0737783f, 0.000000f, -0.986468f, 0.163952f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.206007f, -0.978550f, 0.000000f, -0.114344f, -0.993441f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.435557f, 0.900161f, 0.000000f, 
		-0.285779f, 0.958295f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0811955f, 0.0395257f, 0.995914f, 
		-0.158715f, -0.0131699f, 0.987237f, 0.0967030f, -0.0545759f, 0.993816f, 
		-0.163252f, 0.00406050f, 0.986576f, 0.0967030f, -0.0545759f, 0.993816f, 
		-0.163252f, 0.00406050f, 0.986576f, -0.435557f, 0.900161f, 0.000000f, 
		-0.285779f, 0.958295f, 0.000000f, 0.0811955f, 0.0395257f, 0.995914f, 
		-0.158715f, -0.0131699f, 0.987237f, -0.206007f, -0.978550f, 0.000000f, 
		-0.114344f, -0.993441f, 0.000000f, 0.0607796f, -0.00665408f, 0.998129f, 
		0.0618188f, 0.0141954f, 0.997986f, -0.158715f, -0.0131699f, 0.987237f, 
		-0.163252f, 0.00406050f, 0.986576f, 0.0811955f, 0.0395257f, 0.995914f, 
		0.0967030f, -0.0545759f, 0.993816f, -0.997275f, -0.0737783f, 0.000000f, 
		-0.986468f, 0.163952f, 0.000000f, 0.0618188f, 0.0141954f, 0.997986f, 
		-0.163252f, 0.00406050f, 0.986576f, -0.285779f, 0.958295f, 0.000000f, 
		0.201187f, 0.979553f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0158157f, 0.0250654f, 0.999561f, 0.0607796f, -0.00665408f, 0.998129f, 
		0.0618188f, 0.0141954f, 0.997986f, 0.998566f, 0.0535316f, 0.000000f, 
		0.0607796f, -0.00665408f, 0.998129f, -0.158715f, -0.0131699f, 0.987237f, 
		-0.114344f, -0.993441f, 0.000000f, -0.0230394f, -0.999735f, 0.000000f, 
		0.0967030f, -0.0545759f, 0.993816f, -0.435557f, 0.900161f, 0.000000f, 
		-0.986468f, 0.163952f, 0.000000f, 0.0811955f, 0.0395257f, 0.995914f, 
		-0.206007f, -0.978550f, 0.000000f, -0.997275f, -0.0737783f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, -0.0158157f, 0.0250654f, 0.999561f, 
		0.0607796f, -0.00665408f, 0.998129f, -0.0230394f, -0.999735f, 0.000000f, 
		0.0618188f, 0.0141954f, 0.997986f, 0.201187f, 0.979553f, 0.000000f, 
		0.998566f, 0.0535316f, 0.000000f, 0.999756f, 0.0220775f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, -0.0158157f, 0.0250654f, 0.999561f, 
		0.999756f, 0.0220775f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0158157f, 0.0250654f, 0.999561f, 0.999756f, 0.0220775f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.999756f, 0.0220775f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, -0.120937f, 0.992660f, 0.000000f, 
		0.999846f, 0.0175702f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.999450f, -0.0331647f, 0.000000f, -0.164535f, -0.986371f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.986066f, -0.166353f, 0.000000f, 
		-0.678136f, -0.734937f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0452080f, 0.998978f, 0.000000f, -0.999855f, 0.0170159f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.147740f, -0.989026f, 0.000000f, 
		-0.164535f, -0.986371f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.999450f, -0.0331647f, 0.000000f, 0.999846f, 0.0175702f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.265923f, 0.963994f, 0.000000f, 
		-0.120937f, 0.992660f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.678136f, -0.734937f, 0.000000f, -0.999855f, 0.0170159f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.986066f, -0.166353f, 0.000000f, 0.147740f, -0.989026f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0452080f, 0.998978f, 0.000000f, 
		0.265923f, 0.963994f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0703093f, -0.0312354f, 0.997036f, 
		0.000000f, 0.000000f, 1.00000f, -0.113318f, 0.0452426f, 0.992528f, 
		0.000000f, 0.000000f, 1.00000f, -0.113318f, 0.0452426f, 0.992528f, 
		-0.0452080f, 0.998978f, 0.000000f, 0.265923f, 0.963994f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0703093f, -0.0312354f, 0.997036f, 
		-0.986066f, -0.166353f, 0.000000f, 0.147740f, -0.989026f, 0.000000f, 
		0.0668013f, -0.0297031f, 0.997324f, 0.0577280f, 0.0411351f, 0.997485f, 
		-0.0703093f, -0.0312354f, 0.997036f, -0.113318f, 0.0452426f, 0.992528f, 
		0.000000f, 0.000000f, 1.00000f, -0.678136f, -0.734937f, 0.000000f, 
		-0.999855f, 0.0170159f, 0.000000f, 0.0577280f, 0.0411351f, 0.997485f, 
		-0.113318f, 0.0452426f, 0.992528f, 0.265923f, 0.963994f, 0.000000f, 
		-0.120937f, 0.992660f, 0.000000f, 0.0668013f, -0.0297031f, 0.997324f, 
		0.0577280f, 0.0411351f, 0.997485f, 0.999450f, -0.0331647f, 0.000000f, 
		0.999846f, 0.0175702f, 0.000000f, 0.0668013f, -0.0297031f, 0.997324f, 
		-0.0703093f, -0.0312354f, 0.997036f, 0.147740f, -0.989026f, 0.000000f, 
		-0.164535f, -0.986371f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0452080f, 0.998978f, 0.000000f, -0.999855f, 0.0170159f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.986066f, -0.166353f, 0.000000f, 
		-0.678136f, -0.734937f, 0.000000f, 0.0668013f, -0.0297031f, 0.997324f, 
		0.999450f, -0.0331647f, 0.000000f, -0.164535f, -0.986371f, 0.000000f, 
		0.0577280f, 0.0411351f, 0.997485f, -0.120937f, 0.992660f, 0.000000f, 
		0.999846f, 0.0175702f, 0.000000f, 0.0230005f, 0.999735f, 0.000000f, 
		0.999977f, -0.00678648f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.999938f, -0.0111554f, 0.000000f, -0.143189f, -0.989695f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.398026f, -0.917374f, 0.000000f, 
		-0.999936f, 0.0113536f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.267191f, 0.963644f, 0.000000f, -0.999962f, -0.00871840f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.214505f, -0.976723f, 0.000000f, 
		-0.143189f, -0.989695f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.999938f, -0.0111554f, 0.000000f, 0.999977f, -0.00678648f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0776749f, 0.996979f, 0.000000f, 
		0.0230005f, 0.999735f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.999936f, 0.0113536f, 0.000000f, -0.999962f, -0.00871840f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.398026f, -0.917374f, 0.000000f, 0.214505f, -0.976723f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.267191f, 0.963644f, 0.000000f, 
		-0.0776749f, 0.996979f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.122425f, 0.0578715f, 0.990789f, 
		0.000000f, 0.000000f, 1.00000f, 0.115191f, -0.0502822f, 0.992070f, 
		0.000000f, 0.000000f, 1.00000f, 0.115191f, -0.0502822f, 0.992070f, 
		0.267191f, 0.963644f, 0.000000f, -0.0776749f, 0.996979f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.122425f, 0.0578715f, 0.990789f, 
		0.398026f, -0.917374f, 0.000000f, 0.214505f, -0.976723f, 0.000000f, 
		-0.102645f, 0.0141245f, 0.994618f, -0.105317f, -0.00963986f, 0.994392f, 
		0.122425f, 0.0578715f, 0.990789f, 0.115191f, -0.0502822f, 0.992070f, 
		0.000000f, 0.000000f, 1.00000f, -0.999936f, 0.0113536f, 0.000000f, 
		-0.999962f, -0.00871840f, 0.000000f, -0.105317f, -0.00963986f, 0.994392f, 
		0.115191f, -0.0502822f, 0.992070f, -0.0776749f, 0.996979f, 0.000000f, 
		0.0230005f, 0.999735f, 0.000000f, -0.102645f, 0.0141245f, 0.994618f, 
		-0.105317f, -0.00963986f, 0.994392f, 0.999938f, -0.0111554f, 0.000000f, 
		0.999977f, -0.00678648f, 0.000000f, -0.102645f, 0.0141245f, 0.994618f, 
		0.122425f, 0.0578715f, 0.990789f, 0.214505f, -0.976723f, 0.000000f, 
		-0.143189f, -0.989695f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.267191f, 0.963644f, 0.000000f, -0.999962f, -0.00871840f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.398026f, -0.917374f, 0.000000f, 
		-0.999936f, 0.0113536f, 0.000000f, -0.102645f, 0.0141245f, 0.994618f, 
		0.999938f, -0.0111554f, 0.000000f, -0.143189f, -0.989695f, 0.000000f, 
		-0.105317f, -0.00963986f, 0.994392f, 0.0230005f, 0.999735f, 0.000000f, 
		0.999977f, -0.00678648f, 0.000000f, -0.0734175f, 0.997301f, 0.000000f, 
		0.915570f, 0.402158f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.990560f, -0.137079f, 0.000000f, -0.00260343f, -0.999997f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.173954f, -0.984754f, 0.000000f, 
		-0.999999f, 0.00144607f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.226032f, 0.974120f, 0.000000f, -0.986468f, 0.163952f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0736550f, -0.997284f, 0.000000f, 
		-0.00260343f, -0.999997f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.990560f, -0.137079f, 0.000000f, 0.915570f, 0.402158f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.240522f, 0.970644f, 0.000000f, 
		-0.0734175f, 0.997301f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.999999f, 0.00144607f, 0.000000f, -0.986468f, 0.163952f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.173954f, -0.984754f, 0.000000f, 0.0736550f, -0.997284f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.226032f, 0.974120f, 0.000000f, 
		-0.240522f, 0.970644f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.130921f, -0.0439146f, 0.990420f, 
		0.000000f, 0.000000f, 1.00000f, -0.145690f, 0.109221f, 0.983283f, 
		0.000000f, 0.000000f, 1.00000f, -0.145690f, 0.109221f, 0.983283f, 
		0.226032f, 0.974120f, 0.000000f, -0.240522f, 0.970644f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.130921f, -0.0439146f, 0.990420f, 
		-0.173954f, -0.984754f, 0.000000f, 0.0736550f, -0.997284f, 0.000000f, 
		0.0722783f, -0.0568313f, 0.995764f, 0.0808518f, 0.103965f, 0.991289f, 
		-0.130921f, -0.0439146f, 0.990420f, -0.145690f, 0.109221f, 0.983283f, 
		0.000000f, 0.000000f, 1.00000f, -0.999999f, 0.00144607f, 0.000000f, 
		-0.986468f, 0.163952f, 0.000000f, 0.0808518f, 0.103965f, 0.991289f, 
		-0.145690f, 0.109221f, 0.983283f, -0.240522f, 0.970644f, 0.000000f, 
		-0.0734175f, 0.997301f, 0.000000f, 0.0722783f, -0.0568313f, 0.995764f, 
		0.0808518f, 0.103965f, 0.991289f, 0.990560f, -0.137079f, 0.000000f, 
		0.915570f, 0.402158f, 0.000000f, 0.0722783f, -0.0568313f, 0.995764f, 
		-0.130921f, -0.0439146f, 0.990420f, 0.0736550f, -0.997284f, 0.000000f, 
		-0.00260343f, -0.999997f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.226032f, 0.974120f, 0.000000f, -0.986468f, 0.163952f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.173954f, -0.984754f, 0.000000f, 
		-0.999999f, 0.00144607f, 0.000000f, 0.0722783f, -0.0568313f, 0.995764f, 
		0.990560f, -0.137079f, 0.000000f, -0.00260343f, -0.999997f, 0.000000f, 
		0.0808518f, 0.103965f, 0.991289f, -0.0734175f, 0.997301f, 0.000000f, 
		0.915570f, 0.402158f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.0767422f, 0.997051f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.971508f, -0.237008f, 0.000000f, 0.103313f, -0.994649f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.493506f, -0.869743f, 0.000000f, 
		-0.989874f, -0.141947f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.00455406f, 0.999990f, 0.000000f, -0.993179f, 0.116597f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.103313f, -0.994649f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0825166f, 0.996590f, 0.000000f, 
		0.0767422f, 0.997051f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.989874f, -0.141947f, 0.000000f, -0.993179f, 0.116597f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.493506f, -0.869743f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.00455406f, 0.999990f, 0.000000f, 
		-0.0825166f, 0.996590f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, -0.00455406f, 0.999990f, 0.000000f, 
		-0.0825166f, 0.996590f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.493506f, -0.869743f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0536604f, -0.0557806f, 0.997000f, -0.0543760f, 0.0550902f, 0.997000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.989874f, -0.141947f, 0.000000f, -0.993179f, 0.116597f, 0.000000f, 
		-0.0543760f, 0.0550902f, 0.997000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0825166f, 0.996590f, 0.000000f, 0.0767422f, 0.997051f, 0.000000f, 
		-0.398740f, -0.0972764f, 0.911890f, 0.157016f, -0.0421919f, 0.986694f, 
		0.0791730f, 0.0599771f, 0.995055f, -0.0536604f, -0.0557806f, 0.997000f, 
		-0.0543760f, 0.0550902f, 0.997000f, 0.103313f, -0.994649f, 0.000000f, 
		-0.0536604f, -0.0557806f, 0.997000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.00455406f, 0.999990f, 0.000000f, -0.993179f, 0.116597f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.493506f, -0.869743f, 0.000000f, 
		-0.989874f, -0.141947f, 0.000000f, -0.971508f, -0.237008f, 0.000000f, 
		-0.398740f, -0.0972764f, 0.911890f, 0.103313f, -0.994649f, 0.000000f, 
		-0.0536604f, -0.0557806f, 0.997000f, 0.000000f, 1.00000f, 0.000000f, 
		0.0791730f, 0.0599771f, 0.995055f, -0.0543760f, 0.0550902f, 0.997000f, 
		0.0767422f, 0.997051f, 0.000000f, 0.000000f, 1.00000f, 0.000000f, 
		0.0643544f, 0.0487526f, 0.996736f, 0.999640f, 0.0268258f, 0.000000f, 
		0.0962805f, -0.995354f, 0.000000f, 0.0594182f, -0.0133388f, 0.998144f, 
		0.999618f, 0.0276216f, 0.000000f, 0.0594182f, -0.0133388f, 0.998144f, 
		0.0643544f, 0.0487526f, 0.996736f, 0.999618f, 0.0276216f, 0.000000f, 
		0.999640f, 0.0268258f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.999618f, 0.0276216f, 0.000000f, 0.999640f, 0.0268258f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0962805f, -0.995354f, 0.000000f, 
		0.999618f, 0.0276216f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 1.00000f, 0.000000f, 0.999640f, 0.0268258f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.157016f, -0.0421919f, 0.986694f, 
		-0.0453839f, -0.00890865f, 0.998930f, -0.0643640f, 0.0453069f, 0.996897f, 
		0.0791730f, 0.0599771f, 0.995055f, 0.0594182f, -0.0133388f, 0.998144f, 
		-0.0453839f, -0.00890865f, 0.998930f, 0.0643544f, 0.0487526f, 0.996736f, 
		-0.0643640f, 0.0453069f, 0.996897f, 0.000000f, 1.00000f, 0.000000f, 
		-0.0643640f, 0.0453069f, 0.996897f, 0.0791730f, 0.0599771f, 0.995055f, 
		0.000000f, 1.00000f, 0.000000f, 0.0643544f, 0.0487526f, 0.996736f, 
		-0.0643640f, 0.0453069f, 0.996897f, -0.0683492f, -0.997661f, 0.000000f, 
		-0.993821f, 0.110996f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0453839f, -0.00890865f, 0.998930f, -0.0683492f, -0.997661f, 0.000000f, 
		0.0962805f, -0.995354f, 0.000000f, 0.0594182f, -0.0133388f, 0.998144f, 
		-0.0453839f, -0.00890865f, 0.998930f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 1.00000f, 0.000000f, -0.0683492f, -0.997661f, 0.000000f, 
		-0.993821f, 0.110996f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0683492f, -0.997661f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0962805f, -0.995354f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.971508f, -0.237008f, 0.000000f, 
		0.103313f, -0.994649f, 0.000000f, -0.971508f, -0.237008f, 0.000000f, 
		-0.993821f, 0.110996f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.398740f, -0.0972764f, 0.911890f, 0.157016f, -0.0421919f, 0.986694f, 
		0.000000f, 0.000000f, -1.00000f, -0.971508f, -0.237008f, 0.000000f, 
		-0.993821f, 0.110996f, 0.000000f, -0.0683492f, -0.997661f, 0.000000f, 
		-0.993821f, 0.110996f, 0.000000f, -0.971508f, -0.237008f, 0.000000f, 
		-0.993821f, 0.110996f, 0.000000f, 0.367454f, 0.930042f, 0.000000f, 
		0.998905f, 0.0467840f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.996476f, 0.0838778f, 0.000000f, -0.0293533f, -0.999569f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0226308f, -0.999744f, 0.000000f, 
		-0.999503f, -0.0315308f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.999685f, -0.0251089f, 0.000000f, -1.00000f, 0.000472509f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0293533f, -0.999569f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.996476f, 0.0838778f, 0.000000f, 0.998905f, 0.0467840f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.408105f, 0.912935f, 0.000000f, 
		0.367454f, 0.930042f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.999503f, -0.0315308f, 0.000000f, -1.00000f, 0.000472509f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0226308f, -0.999744f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.897998f, 0.440000f, 0.000000f, 
		0.408105f, 0.912935f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0403099f, -0.0190545f, 0.999005f, 
		0.000000f, 0.000000f, 1.00000f, -0.0460755f, 0.0217803f, 0.998700f, 
		0.897998f, 0.440000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0460755f, 0.0217803f, 0.998700f, 0.408105f, 0.912935f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0403099f, -0.0190545f, 0.999005f, 
		-0.0226308f, -0.999744f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.0261755f, -0.0179359f, 0.999496f, 0.0337555f, 0.0222414f, 0.999183f, 
		-0.0403099f, -0.0190545f, 0.999005f, -0.0460755f, 0.0217803f, 0.998700f, 
		0.000000f, 0.000000f, 1.00000f, -0.999503f, -0.0315308f, 0.000000f, 
		-1.00000f, 0.000472509f, 0.000000f, 0.0337555f, 0.0222414f, 0.999183f, 
		-0.0460755f, 0.0217803f, 0.998700f, 0.408105f, 0.912935f, 0.000000f, 
		0.367454f, 0.930042f, 0.000000f, 0.0261755f, -0.0179359f, 0.999496f, 
		0.0337555f, 0.0222414f, 0.999183f, 0.996476f, 0.0838778f, 0.000000f, 
		0.998905f, 0.0467840f, 0.000000f, 0.0261755f, -0.0179359f, 0.999496f, 
		-0.0403099f, -0.0190545f, 0.999005f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0293533f, -0.999569f, 0.000000f, -0.999685f, -0.0251089f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -1.00000f, 0.000472509f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0226308f, -0.999744f, 0.000000f, 
		-0.999503f, -0.0315308f, 0.000000f, 0.0261755f, -0.0179359f, 0.999496f, 
		0.996476f, 0.0838778f, 0.000000f, -0.0293533f, -0.999569f, 0.000000f, 
		0.0337555f, 0.0222414f, 0.999183f, 0.367454f, 0.930042f, 0.000000f, 
		0.998905f, 0.0467840f, 0.000000f, -0.327543f, 0.944836f, 0.000000f, 
		-0.999685f, -0.0251089f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.327543f, 0.944836f, 0.000000f, 0.897998f, 0.440000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.327543f, 0.944836f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.897998f, 0.440000f, 0.000000f, 
		-0.327543f, 0.944836f, 0.000000f, -0.999685f, -0.0251089f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0225146f, 0.999747f, 0.000000f, 
		0.965606f, 0.260010f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.996762f, -0.0804083f, 0.000000f, -0.353964f, -0.935259f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.267124f, -0.963662f, 0.000000f, 
		-0.999667f, 0.0257893f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0285037f, 0.999594f, 0.000000f, -0.999999f, 0.00148423f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.849459f, -0.527655f, 0.000000f, 
		-0.353964f, -0.935259f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.996762f, -0.0804083f, 0.000000f, 0.965606f, 0.260010f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0367370f, 0.999325f, 0.000000f, 
		0.0225146f, 0.999747f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.999667f, 0.0257893f, 0.000000f, -0.999999f, 0.00148423f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.267124f, -0.963662f, 0.000000f, -0.849459f, -0.527655f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0285037f, 0.999594f, 0.000000f, 
		0.0367370f, 0.999325f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.106710f, -0.0314437f, 0.993793f, 
		0.000000f, 0.000000f, 1.00000f, -0.0717255f, 0.0772294f, 0.994430f, 
		0.000000f, 0.000000f, 1.00000f, -0.0717255f, 0.0772294f, 0.994430f, 
		0.0285037f, 0.999594f, 0.000000f, 0.0367370f, 0.999325f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.106710f, -0.0314437f, 0.993793f, 
		0.267124f, -0.963662f, 0.000000f, -0.849459f, -0.527655f, 0.000000f, 
		0.0348386f, -0.0222314f, 0.999146f, 0.0389731f, 0.0873396f, 0.995416f, 
		-0.106710f, -0.0314437f, 0.993793f, -0.0717255f, 0.0772294f, 0.994430f, 
		0.000000f, 0.000000f, 1.00000f, -0.999667f, 0.0257893f, 0.000000f, 
		-0.999999f, 0.00148423f, 0.000000f, 0.0389731f, 0.0873396f, 0.995416f, 
		-0.0717255f, 0.0772294f, 0.994430f, 0.0367370f, 0.999325f, 0.000000f, 
		0.0225146f, 0.999747f, 0.000000f, 0.0348386f, -0.0222314f, 0.999146f, 
		0.0389731f, 0.0873396f, 0.995416f, 0.996762f, -0.0804083f, 0.000000f, 
		0.965606f, 0.260010f, 0.000000f, 0.0348386f, -0.0222314f, 0.999146f, 
		-0.106710f, -0.0314437f, 0.993793f, -0.849459f, -0.527655f, 0.000000f, 
		-0.353964f, -0.935259f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0285037f, 0.999594f, 0.000000f, -0.999999f, 0.00148423f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.267124f, -0.963662f, 0.000000f, 
		-0.999667f, 0.0257893f, 0.000000f, 0.0348386f, -0.0222314f, 0.999146f, 
		0.996762f, -0.0804083f, 0.000000f, -0.353964f, -0.935259f, 0.000000f, 
		0.0389731f, 0.0873396f, 0.995416f, 0.0225146f, 0.999747f, 0.000000f, 
		0.965606f, 0.260010f, 0.000000f, 0.0882988f, 0.996094f, 0.000000f, 
		0.977657f, -0.210205f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.969734f, 0.244162f, 0.000000f, -0.00508198f, -0.999987f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.111523f, -0.993762f, 0.000000f, 
		-0.994170f, -0.107825f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.104785f, 0.994495f, 0.000000f, -0.994012f, -0.109275f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.00508198f, -0.999987f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.969734f, 0.244162f, 0.000000f, 0.977657f, -0.210205f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.134651f, 0.990893f, 0.000000f, 
		0.0882988f, 0.996094f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.994170f, -0.107825f, 0.000000f, -0.994012f, -0.109275f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.111523f, -0.993762f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.104785f, 0.994495f, 0.000000f, 
		-0.134651f, 0.990893f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0534336f, -0.0337942f, 0.997999f, 
		0.000000f, -0.0638335f, 0.997961f, -0.0409361f, 0.0327971f, 0.998623f, 
		-0.00416363f, 0.0603467f, 0.998169f, -0.0409361f, 0.0327971f, 0.998623f, 
		-0.00416363f, 0.0603467f, 0.998169f, -0.104785f, 0.994495f, 0.000000f, 
		-0.134651f, 0.990893f, 0.000000f, -0.0534336f, -0.0337942f, 0.997999f, 
		0.000000f, -0.0638335f, 0.997961f, -0.111523f, -0.993762f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.0103115f, -0.0307578f, 0.999474f, 
		0.0121939f, 0.0319123f, 0.999416f, 0.000000f, -0.0638335f, 0.997961f, 
		-0.00416363f, 0.0603467f, 0.998169f, -0.0534336f, -0.0337942f, 0.997999f, 
		-0.0409361f, 0.0327971f, 0.998623f, -0.994170f, -0.107825f, 0.000000f, 
		-0.994012f, -0.109275f, 0.000000f, 0.0121939f, 0.0319123f, 0.999416f, 
		-0.00416363f, 0.0603467f, 0.998169f, -0.134651f, 0.990893f, 0.000000f, 
		0.0882988f, 0.996094f, 0.000000f, 0.0103115f, -0.0307578f, 0.999474f, 
		0.0121939f, 0.0319123f, 0.999416f, 0.969734f, 0.244162f, 0.000000f, 
		0.977657f, -0.210205f, 0.000000f, 0.0103115f, -0.0307578f, 0.999474f, 
		0.000000f, -0.0638335f, 0.997961f, 0.000000f, -1.00000f, 0.000000f, 
		-0.00508198f, -0.999987f, 0.000000f, -0.0409361f, 0.0327971f, 0.998623f, 
		-0.104785f, 0.994495f, 0.000000f, -0.994012f, -0.109275f, 0.000000f, 
		-0.0534336f, -0.0337942f, 0.997999f, -0.111523f, -0.993762f, 0.000000f, 
		-0.994170f, -0.107825f, 0.000000f, 0.0103115f, -0.0307578f, 0.999474f, 
		0.969734f, 0.244162f, 0.000000f, -0.00508198f, -0.999987f, 0.000000f, 
		0.0121939f, 0.0319123f, 0.999416f, 0.0882988f, 0.996094f, 0.000000f, 
		0.977657f, -0.210205f, 0.000000f, 0.0694930f, 0.997582f, 0.000000f, 
		0.999425f, 0.0339133f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.998946f, 0.0458960f, 0.000000f, -0.0964708f, -0.995336f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.998583f, 0.0532174f, 0.000000f, 
		0.101509f, -0.994835f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0274960f, 0.999622f, 0.000000f, -0.990323f, -0.138785f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0964708f, -0.995336f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.998946f, 0.0458960f, 0.000000f, 0.999425f, 0.0339133f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0288004f, 0.999585f, 0.000000f, 
		0.0694930f, 0.997582f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.998583f, 0.0532174f, 0.000000f, -0.997093f, 0.0762003f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.101509f, -0.994835f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0274960f, 0.999622f, 0.000000f, 
		0.0288004f, 0.999585f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0690909f, -0.00528010f, 0.997596f, 
		0.0284710f, -0.0794201f, 0.996435f, 0.0273594f, 0.0459631f, 0.998568f, 
		-0.157074f, 0.0143422f, 0.987483f, -0.138187f, -0.00418446f, 0.990397f, 
		0.000000f, 0.000000f, 1.00000f, 0.0284710f, -0.0794201f, 0.996435f, 
		0.0274960f, 0.999622f, 0.000000f, -0.138187f, -0.00418446f, 0.990397f, 
		0.0288004f, 0.999585f, 0.000000f, 0.0273594f, 0.0459631f, 0.998568f, 
		-0.157074f, 0.0143422f, 0.987483f, 0.101509f, -0.994835f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.0407899f, -0.0277741f, 0.998782f, 
		0.0490793f, 0.0258805f, 0.998460f, -0.157074f, 0.0143422f, 0.987483f, 
		-0.138187f, -0.00418446f, 0.990397f, 0.0690909f, -0.00528010f, 0.997596f, 
		-0.998583f, 0.0532174f, 0.000000f, -0.997093f, 0.0762003f, 0.000000f, 
		0.0273594f, 0.0459631f, 0.998568f, 0.0490793f, 0.0258805f, 0.998460f, 
		-0.138187f, -0.00418446f, 0.990397f, 0.0288004f, 0.999585f, 0.000000f, 
		0.0694930f, 0.997582f, 0.000000f, 0.0407899f, -0.0277741f, 0.998782f, 
		0.0490793f, 0.0258805f, 0.998460f, 0.998946f, 0.0458960f, 0.000000f, 
		0.999425f, 0.0339133f, 0.000000f, 0.0407899f, -0.0277741f, 0.998782f, 
		-0.157074f, 0.0143422f, 0.987483f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0964708f, -0.995336f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0274960f, 0.999622f, 0.000000f, -0.990323f, -0.138785f, 0.000000f, 
		-0.998583f, 0.0532174f, 0.000000f, 0.0273594f, 0.0459631f, 0.998568f, 
		0.101509f, -0.994835f, 0.000000f, 0.0407899f, -0.0277741f, 0.998782f, 
		0.998946f, 0.0458960f, 0.000000f, -0.0964708f, -0.995336f, 0.000000f, 
		0.0490793f, 0.0258805f, 0.998460f, 0.0694930f, 0.997582f, 0.000000f, 
		0.999425f, 0.0339133f, 0.000000f, -0.997093f, 0.0762003f, 0.000000f, 
		-0.990323f, -0.138785f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.998583f, 0.0532174f, 0.000000f, -0.997093f, 0.0762003f, 0.000000f, 
		0.0274960f, 0.999622f, 0.000000f, -0.990323f, -0.138785f, 0.000000f, 
		0.0690909f, -0.00528010f, 0.997596f, 0.000000f, 0.000000f, 1.00000f, 
		0.0284710f, -0.0794201f, 0.996435f, -0.997093f, 0.0762003f, 0.000000f, 
		-0.990323f, -0.138785f, 0.000000f, -0.997093f, 0.0762003f, 0.000000f, 
		-0.990323f, -0.138785f, 0.000000f, -0.104986f, 0.994474f, 0.000000f, 
		0.956741f, 0.290940f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.999818f, 0.0190972f, 0.000000f, 0.0769094f, -0.997038f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0381299f, -0.999273f, 0.000000f, 
		-0.999431f, -0.0337403f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0373695f, 0.999301f, 0.000000f, -0.994008f, -0.109307f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.269626f, -0.962965f, 0.000000f, 
		0.0769094f, -0.997038f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.999818f, 0.0190972f, 0.000000f, 0.956741f, 0.290940f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.123294f, 0.992370f, 0.000000f, 
		-0.104986f, 0.994474f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.999431f, -0.0337403f, 0.000000f, -0.994008f, -0.109307f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0381299f, -0.999273f, 0.000000f, -0.269626f, -0.962965f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0373695f, 0.999301f, 0.000000f, 
		0.123294f, 0.992370f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0442032f, 0.0291344f, 0.998598f, 
		-0.0660626f, 0.0272784f, 0.997443f, 0.0387937f, -0.0278372f, 0.998859f, 
		-0.0687033f, -0.0323580f, 0.997112f, 0.0387937f, -0.0278372f, 0.998859f, 
		-0.0687033f, -0.0323580f, 0.997112f, 0.0373695f, 0.999301f, 0.000000f, 
		0.123294f, 0.992370f, 0.000000f, 0.0442032f, 0.0291344f, 0.998598f, 
		-0.0660626f, 0.0272784f, 0.997443f, -0.0381299f, -0.999273f, 0.000000f, 
		-0.269626f, -0.962965f, 0.000000f, -0.0491529f, -0.0462629f, 0.997719f, 
		-0.0706321f, 0.0527520f, 0.996107f, -0.0660626f, 0.0272784f, 0.997443f, 
		-0.0687033f, -0.0323580f, 0.997112f, 0.0442032f, 0.0291344f, 0.998598f, 
		0.0387937f, -0.0278372f, 0.998859f, -0.999431f, -0.0337403f, 0.000000f, 
		-0.994008f, -0.109307f, 0.000000f, -0.0706321f, 0.0527520f, 0.996107f, 
		-0.0687033f, -0.0323580f, 0.997112f, 0.123294f, 0.992370f, 0.000000f, 
		-0.104986f, 0.994474f, 0.000000f, -0.0491529f, -0.0462629f, 0.997719f, 
		-0.0706321f, 0.0527520f, 0.996107f, 0.999818f, 0.0190972f, 0.000000f, 
		0.956741f, 0.290940f, 0.000000f, -0.0491529f, -0.0462629f, 0.997719f, 
		-0.0660626f, 0.0272784f, 0.997443f, -0.269626f, -0.962965f, 0.000000f, 
		0.0769094f, -0.997038f, 0.000000f, 0.0387937f, -0.0278372f, 0.998859f, 
		0.0373695f, 0.999301f, 0.000000f, -0.994008f, -0.109307f, 0.000000f, 
		0.0442032f, 0.0291344f, 0.998598f, -0.0381299f, -0.999273f, 0.000000f, 
		-0.999431f, -0.0337403f, 0.000000f, -0.0491529f, -0.0462629f, 0.997719f, 
		0.999818f, 0.0190972f, 0.000000f, 0.0769094f, -0.997038f, 0.000000f, 
		-0.0706321f, 0.0527520f, 0.996107f, -0.104986f, 0.994474f, 0.000000f, 
		0.956741f, 0.290940f, 0.000000f, 0.367454f, 0.930042f, 0.000000f, 
		0.993809f, 0.111106f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.997829f, 0.0658566f, 0.000000f, 0.0714606f, -0.997443f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.120469f, -0.992717f, 0.000000f, 
		-0.972848f, -0.231446f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0285361f, 0.999593f, 0.000000f, -0.986289f, 0.165025f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.0714606f, -0.997443f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.997829f, 0.0658566f, 0.000000f, 0.993809f, 0.111106f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.285745f, 0.958306f, 0.000000f, 
		0.367454f, 0.930042f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.972848f, -0.231446f, 0.000000f, -0.986289f, 0.165025f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.120469f, -0.992717f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0285361f, 0.999593f, 0.000000f, 
		-0.285745f, 0.958306f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0430021f, 0.0335555f, 0.998511f, 
		-0.125029f, -0.0150725f, 0.992039f, 0.0336749f, -0.0314844f, 0.998937f, 
		-0.125783f, 0.0126075f, 0.991978f, 0.0336749f, -0.0314844f, 0.998937f, 
		-0.125783f, 0.0126075f, 0.991978f, 0.0285361f, 0.999593f, 0.000000f, 
		-0.285745f, 0.958306f, 0.000000f, 0.0430021f, 0.0335555f, 0.998511f, 
		-0.125029f, -0.0150725f, 0.992039f, -0.120469f, -0.992717f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.0525758f, -0.0415790f, 0.997751f, 
		0.0589355f, 0.0457408f, 0.997213f, -0.125029f, -0.0150725f, 0.992039f, 
		-0.125783f, 0.0126075f, 0.991978f, 0.0430021f, 0.0335555f, 0.998511f, 
		0.0336749f, -0.0314844f, 0.998937f, -0.972848f, -0.231446f, 0.000000f, 
		-0.986289f, 0.165025f, 0.000000f, 0.0589355f, 0.0457408f, 0.997213f, 
		-0.125783f, 0.0126075f, 0.991978f, -0.285745f, 0.958306f, 0.000000f, 
		0.367454f, 0.930042f, 0.000000f, 0.0525758f, -0.0415790f, 0.997751f, 
		0.0589355f, 0.0457408f, 0.997213f, 0.997829f, 0.0658566f, 0.000000f, 
		0.993809f, 0.111106f, 0.000000f, 0.0525758f, -0.0415790f, 0.997751f, 
		-0.125029f, -0.0150725f, 0.992039f, 0.000000f, -1.00000f, 0.000000f, 
		0.0714606f, -0.997443f, 0.000000f, 0.0336749f, -0.0314844f, 0.998937f, 
		0.0285361f, 0.999593f, 0.000000f, -0.986289f, 0.165025f, 0.000000f, 
		0.0430021f, 0.0335555f, 0.998511f, -0.120469f, -0.992717f, 0.000000f, 
		-0.972848f, -0.231446f, 0.000000f, 0.0525758f, -0.0415790f, 0.997751f, 
		0.997829f, 0.0658566f, 0.000000f, 0.0714606f, -0.997443f, 0.000000f, 
		0.0589355f, 0.0457408f, 0.997213f, 0.367454f, 0.930042f, 0.000000f, 
		0.993809f, 0.111106f, 0.000000f, 0.0400883f, 0.999196f, 0.000000f, 
		0.990363f, 0.138497f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.995849f, 0.0910164f, 0.000000f, 0.993508f, -0.113766f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.329113f, -0.944291f, 0.000000f, 
		-0.999998f, 0.00187209f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0196211f, 0.999807f, 0.000000f, -0.963079f, -0.269217f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.993508f, -0.113766f, 0.000000f, 0.990363f, 0.138497f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.00240030f, 0.999997f, 0.000000f, 
		0.0400883f, 0.999196f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.999998f, 0.00187209f, 0.000000f, -0.963079f, -0.269217f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.989387f, -0.145307f, 0.000000f, -0.329113f, -0.944291f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0196211f, 0.999807f, 0.000000f, 
		0.00240030f, 0.999997f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.100446f, 0.0418153f, 0.994063f, 
		0.000000f, 0.000000f, 1.00000f, 0.101598f, -0.0481160f, 0.993661f, 
		0.000000f, 0.000000f, 1.00000f, 0.101598f, -0.0481160f, 0.993661f, 
		0.0196211f, 0.999807f, 0.000000f, 0.00240030f, 0.999997f, 0.000000f, 
		-0.989387f, -0.145307f, 0.000000f, -0.329113f, -0.944291f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.100446f, 0.0418153f, 0.994063f, 
		-0.104383f, 0.0596525f, 0.992747f, -0.0648522f, -0.0492374f, 0.996679f, 
		0.100446f, 0.0418153f, 0.994063f, 0.101598f, -0.0481160f, 0.993661f, 
		0.000000f, 0.000000f, 1.00000f, -0.999998f, 0.00187209f, 0.000000f, 
		-0.963079f, -0.269217f, 0.000000f, -0.0648522f, -0.0492374f, 0.996679f, 
		0.101598f, -0.0481160f, 0.993661f, 0.00240030f, 0.999997f, 0.000000f, 
		0.0400883f, 0.999196f, 0.000000f, -0.104383f, 0.0596525f, 0.992747f, 
		-0.0648522f, -0.0492374f, 0.996679f, 0.993508f, -0.113766f, 0.000000f, 
		0.990363f, 0.138497f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0463696f, -0.0221535f, 0.998679f, -0.104383f, 0.0596525f, 0.992747f, 
		0.100446f, 0.0418153f, 0.994063f, 0.000000f, 0.000000f, 1.00000f, 
		0.0196211f, 0.999807f, 0.000000f, -0.963079f, -0.269217f, 0.000000f, 
		-0.329113f, -0.944291f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.999998f, 0.00187209f, 0.000000f, 0.995849f, 0.0910164f, 0.000000f, 
		-0.0463696f, -0.0221535f, 0.998679f, -0.104383f, 0.0596525f, 0.992747f, 
		0.993508f, -0.113766f, 0.000000f, -0.0648522f, -0.0492374f, 0.996679f, 
		0.0400883f, 0.999196f, 0.000000f, 0.990363f, 0.138497f, 0.000000f, 
		0.0659315f, -0.997824f, 0.000000f, 0.995849f, 0.0910164f, 0.000000f, 
		-0.0463696f, -0.0221535f, 0.998679f, 0.0145690f, -0.999894f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0659315f, -0.997824f, 0.000000f, 
		-0.0463696f, -0.0221535f, 0.998679f, 0.0145690f, -0.999894f, 0.000000f, 
		-0.998840f, -0.0481515f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0145690f, -0.999894f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.998840f, -0.0481515f, 0.000000f, 0.0145690f, -0.999894f, 0.000000f, 
		0.0659315f, -0.997824f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0659315f, -0.997824f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.995849f, 0.0910164f, 0.000000f, -0.989387f, -0.145307f, 0.000000f, 
		-0.329113f, -0.944291f, 0.000000f, -0.998840f, -0.0481515f, 0.000000f, 
		-0.989387f, -0.145307f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.998840f, -0.0481515f, 0.000000f, 
		-0.989387f, -0.145307f, 0.000000f, 0.0145690f, -0.999894f, 0.000000f, 
		-0.998840f, -0.0481515f, 0.000000f, -0.998840f, -0.0481515f, 0.000000f, 
		-0.989387f, -0.145307f, 0.000000f, 0.951403f, 0.307950f, 0.000000f, 
		0.915570f, 0.402159f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.963334f, -0.268306f, 0.000000f, 0.123310f, -0.992368f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.00236266f, -0.999997f, 0.000000f, 
		-0.998202f, -0.0599346f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.993011f, -0.118020f, 0.000000f, -0.0769837f, 0.997032f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.123310f, -0.992368f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.963334f, -0.268306f, 0.000000f, 0.915570f, 0.402159f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.343822f, 0.939035f, 0.000000f, 
		0.951403f, 0.307950f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.995729f, 0.0923275f, 0.000000f, -0.993011f, -0.118020f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.00236266f, -0.999997f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0769837f, 0.997032f, 0.000000f, 
		0.343822f, 0.939035f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0598561f, -0.00555007f, 0.998192f, 
		0.0798656f, 0.0317627f, 0.996299f, 0.0497862f, 0.0497522f, 0.997520f, 
		0.0195721f, -0.00990575f, 0.999759f, 0.0489428f, -0.0233764f, 0.998528f, 
		0.0195721f, -0.00990575f, 0.999759f, 0.0489428f, -0.0233764f, 0.998528f, 
		-0.0769837f, 0.997032f, 0.000000f, 0.343822f, 0.939035f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0798656f, 0.0317627f, 0.996299f, 
		-0.00236266f, -0.999997f, 0.000000f, 0.0497862f, 0.0497522f, 0.997520f, 
		0.000000f, -1.00000f, 0.000000f, -0.0573141f, 0.0422851f, 0.997460f, 
		-0.0965259f, -0.0343221f, 0.994739f, 0.0497862f, 0.0497522f, 0.997520f, 
		0.0489428f, -0.0233764f, 0.998528f, 0.0598561f, -0.00555007f, 0.998192f, 
		-0.995729f, 0.0923275f, 0.000000f, -0.993011f, -0.118020f, 0.000000f, 
		0.0195721f, -0.00990575f, 0.999759f, -0.0965259f, -0.0343221f, 0.994739f, 
		0.0489428f, -0.0233764f, 0.998528f, 0.343822f, 0.939035f, 0.000000f, 
		0.951403f, 0.307950f, 0.000000f, -0.0573141f, 0.0422851f, 0.997460f, 
		-0.0965259f, -0.0343221f, 0.994739f, 0.963334f, -0.268306f, 0.000000f, 
		0.915570f, 0.402159f, 0.000000f, -0.0573141f, 0.0422851f, 0.997460f, 
		0.0497862f, 0.0497522f, 0.997520f, 0.000000f, -1.00000f, 0.000000f, 
		0.123310f, -0.992368f, 0.000000f, -0.993011f, -0.118020f, 0.000000f, 
		0.0195721f, -0.00990575f, 0.999759f, -0.0769837f, 0.997032f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.00236266f, -0.999997f, 0.000000f, 
		-0.998202f, -0.0599346f, 0.000000f, -0.0573141f, 0.0422851f, 0.997460f, 
		0.963334f, -0.268306f, 0.000000f, 0.123310f, -0.992368f, 0.000000f, 
		-0.0965259f, -0.0343221f, 0.994739f, 0.951403f, 0.307950f, 0.000000f, 
		0.915570f, 0.402159f, 0.000000f, -0.998202f, -0.0599346f, 0.000000f, 
		-0.995729f, 0.0923275f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.995729f, 0.0923275f, 0.000000f, -0.993011f, -0.118020f, 0.000000f, 
		-0.00236266f, -0.999997f, 0.000000f, -0.998202f, -0.0599346f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0598561f, -0.00555007f, 0.998192f, 
		0.0798656f, 0.0317627f, 0.996299f, -0.998202f, -0.0599346f, 0.000000f, 
		-0.995729f, 0.0923275f, 0.000000f, -0.998202f, -0.0599346f, 0.000000f, 
		-0.995729f, 0.0923275f, 0.000000f, 0.153339f, 0.988174f, 0.000000f, 
		0.988848f, 0.148930f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.896781f, -0.442475f, 0.000000f, 0.199879f, -0.979821f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.180205f, -0.983629f, 0.000000f, 
		-0.938592f, -0.345029f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0447694f, 0.998997f, 0.000000f, -0.979888f, -0.199546f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.199879f, -0.979821f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.896781f, -0.442475f, 0.000000f, 0.988848f, 0.148930f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.111595f, 0.993754f, 0.000000f, 
		0.153339f, 0.988174f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.938592f, -0.345029f, 0.000000f, -0.979888f, -0.199546f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.180205f, -0.983629f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0447694f, 0.998997f, 0.000000f, 
		-0.111595f, 0.993754f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0267529f, 0.0177841f, 0.999484f, 
		0.000000f, 0.000000f, 1.00000f, 0.0262618f, -0.0124142f, 0.999578f, 
		0.000000f, 0.000000f, 1.00000f, 0.0262618f, -0.0124142f, 0.999578f, 
		-0.0447694f, 0.998997f, 0.000000f, -0.111595f, 0.993754f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0267529f, 0.0177841f, 0.999484f, 
		-0.180205f, -0.983629f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0194454f, 0.0261294f, 0.999469f, -0.0176748f, -0.0155334f, 0.999723f, 
		0.0267529f, 0.0177841f, 0.999484f, 0.0262618f, -0.0124142f, 0.999578f, 
		0.000000f, 0.000000f, 1.00000f, -0.938592f, -0.345029f, 0.000000f, 
		-0.979888f, -0.199546f, 0.000000f, -0.0176748f, -0.0155334f, 0.999723f, 
		0.0262618f, -0.0124142f, 0.999578f, -0.111595f, 0.993754f, 0.000000f, 
		0.153339f, 0.988174f, 0.000000f, -0.0194454f, 0.0261294f, 0.999469f, 
		-0.0176748f, -0.0155334f, 0.999723f, 0.896781f, -0.442475f, 0.000000f, 
		0.988848f, 0.148930f, 0.000000f, -0.0194454f, 0.0261294f, 0.999469f, 
		0.0267529f, 0.0177841f, 0.999484f, 0.000000f, -1.00000f, 0.000000f, 
		0.199879f, -0.979821f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0447694f, 0.998997f, 0.000000f, -0.979888f, -0.199546f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.180205f, -0.983629f, 0.000000f, 
		-0.938592f, -0.345029f, 0.000000f, -0.0194454f, 0.0261294f, 0.999469f, 
		0.896781f, -0.442475f, 0.000000f, 0.199879f, -0.979821f, 0.000000f, 
		-0.0176748f, -0.0155334f, 0.999723f, 0.153339f, 0.988174f, 0.000000f, 
		0.988848f, 0.148930f, 0.000000f, -0.127604f, 0.991825f, 0.000000f, 
		0.998153f, 0.0607516f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.987129f, -0.159927f, 0.000000f, 0.438947f, -0.898513f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.783729f, -0.621103f, 0.000000f, 
		-0.966175f, -0.257887f, 0.000000f, -2.73798e-014f, 0.000000f, -1.00000f, 
		0.174879f, 0.984590f, 0.000000f, -0.972358f, -0.233494f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0151248f, -0.999886f, 0.000000f, 
		0.438947f, -0.898513f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.987129f, -0.159927f, 0.000000f, 0.998153f, 0.0607516f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.285782f, 0.958295f, 0.000000f, 
		-0.127604f, 0.991825f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-2.43563e-014f, 0.000000f, -1.00000f, -0.966175f, -0.257887f, 0.000000f, 
		-0.972358f, -0.233494f, 0.000000f, -2.73798e-014f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-2.43563e-014f, 0.000000f, -1.00000f, -0.783729f, -0.621103f, 0.000000f, 
		0.0151248f, -0.999886f, 0.000000f, -2.73798e-014f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.174879f, 0.984590f, 0.000000f, 
		-0.285782f, 0.958295f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-2.43563e-014f, 0.000000f, -1.00000f, -2.73798e-014f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -2.43563e-014f, 0.000000f, -1.00000f, 
		4.38077e-014f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.174879f, 0.984590f, 0.000000f, 
		-0.285782f, 0.958295f, 0.000000f, 4.38077e-014f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, -0.783729f, -0.621103f, 0.000000f, 
		0.0151248f, -0.999886f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		4.38077e-014f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.966175f, -0.257887f, 0.000000f, -0.972358f, -0.233494f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.285782f, 0.958295f, 0.000000f, 
		-0.127604f, 0.991825f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.987129f, -0.159927f, 0.000000f, 0.998153f, 0.0607516f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0151248f, -0.999886f, 0.000000f, 
		0.438947f, -0.898513f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.174879f, 0.984590f, 0.000000f, -0.972358f, -0.233494f, 0.000000f, 
		4.38077e-014f, 0.000000f, 1.00000f, -0.783729f, -0.621103f, 0.000000f, 
		-0.966175f, -0.257887f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.987129f, -0.159927f, 0.000000f, 0.438947f, -0.898513f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.127604f, 0.991825f, 0.000000f, 
		0.998153f, 0.0607516f, 0.000000f, -0.440815f, 0.897598f, 0.000000f, 
		1.00000f, -0.000844625f, 1.00991e-008f, 0.000000f, 0.000000f, -1.00000f, 
		1.00000f, -0.000665530f, 7.95768e-009f, -0.0526991f, -0.998610f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.00795180f, -0.999968f, 0.000000f, 
		-0.945001f, 0.327066f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0839785f, 0.996468f, 0.000000f, -0.968796f, 0.247860f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0526991f, -0.998610f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		1.00000f, -0.000665530f, 7.95768e-009f, 1.00000f, -0.000844625f, 1.00991e-008f, 
		0.000000f, 0.000000f, -1.00000f, -0.447929f, 0.894069f, 0.000000f, 
		-0.440815f, 0.897598f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.945001f, 0.327066f, 0.000000f, -0.968796f, 0.247860f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.00795180f, -0.999968f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0839785f, 0.996468f, 0.000000f, 
		-0.447929f, 0.894069f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0734856f, -0.0303498f, 0.996834f, 
		0.000000f, 0.000000f, 1.00000f, -0.0733314f, 0.0315079f, 0.996810f, 
		0.000000f, 0.000000f, 1.00000f, -0.0733314f, 0.0315079f, 0.996810f, 
		0.0839785f, 0.996468f, 0.000000f, -0.447929f, 0.894069f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.0734856f, -0.0303498f, 0.996834f, 
		-0.00795180f, -0.999968f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.0271067f, -0.0273544f, 0.999258f, 0.0202772f, 0.0211021f, 0.999572f, 
		-0.0734856f, -0.0303498f, 0.996834f, -0.0733314f, 0.0315079f, 0.996810f, 
		0.000000f, 0.000000f, 1.00000f, -0.945001f, 0.327066f, 0.000000f, 
		-0.968796f, 0.247860f, 0.000000f, 0.0202772f, 0.0211021f, 0.999572f, 
		-0.0733314f, 0.0315079f, 0.996810f, -0.447929f, 0.894069f, 0.000000f, 
		-0.440815f, 0.897598f, 0.000000f, 0.0271067f, -0.0273544f, 0.999258f, 
		0.0202772f, 0.0211021f, 0.999572f, 1.00000f, -0.000665530f, 7.95768e-009f, 
		1.00000f, -0.000844625f, 1.00991e-008f, 0.0271067f, -0.0273544f, 0.999258f, 
		-0.0734856f, -0.0303498f, 0.996834f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0526991f, -0.998610f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0839785f, 0.996468f, 0.000000f, -0.968796f, 0.247860f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.00795180f, -0.999968f, 0.000000f, 
		-0.945001f, 0.327066f, 0.000000f, 0.0271067f, -0.0273544f, 0.999258f, 
		1.00000f, -0.000665530f, 7.95768e-009f, -0.0526991f, -0.998610f, 0.000000f, 
		0.0202772f, 0.0211021f, 0.999572f, -0.440815f, 0.897598f, 0.000000f, 
		1.00000f, -0.000844625f, 1.00991e-008f, 0.0878137f, 0.996137f, 0.000000f, 
		0.996734f, 0.0807492f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.992774f, -0.120000f, 0.000000f, 0.209714f, -0.977763f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.169050f, -0.985607f, 0.000000f, 
		-0.984440f, 0.175722f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.000685485f, 1.00000f, 0.000000f, -0.996539f, -0.0831291f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.209714f, -0.977763f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.992774f, -0.120000f, 0.000000f, 0.996734f, 0.0807492f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.112795f, 0.993618f, 0.000000f, 
		0.0878137f, 0.996137f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.984440f, 0.175722f, 0.000000f, -0.996539f, -0.0831291f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.169050f, -0.985607f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.000685485f, 1.00000f, 0.000000f, 
		-0.112795f, 0.993618f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0251867f, -0.0537484f, 0.998237f, 
		0.122651f, -0.0201435f, 0.992245f, -0.0160453f, 0.0569920f, 0.998246f, 
		0.116913f, 0.0236428f, 0.992861f, -0.0160453f, 0.0569920f, 0.998246f, 
		0.116913f, 0.0236428f, 0.992861f, -0.000685485f, 1.00000f, 0.000000f, 
		-0.112795f, 0.993618f, 0.000000f, -0.0251867f, -0.0537484f, 0.998237f, 
		0.122651f, -0.0201435f, 0.992245f, -0.169050f, -0.985607f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, -0.0616252f, -0.0293686f, 0.997667f, 
		-0.0627754f, 0.0281143f, 0.997632f, 0.122651f, -0.0201435f, 0.992245f, 
		0.116913f, 0.0236428f, 0.992861f, -0.0251867f, -0.0537484f, 0.998237f, 
		-0.0160453f, 0.0569920f, 0.998246f, -0.984440f, 0.175722f, 0.000000f, 
		-0.996539f, -0.0831291f, 0.000000f, -0.0627754f, 0.0281143f, 0.997632f, 
		0.116913f, 0.0236428f, 0.992861f, -0.112795f, 0.993618f, 0.000000f, 
		0.0878137f, 0.996137f, 0.000000f, -0.0616252f, -0.0293686f, 0.997667f, 
		-0.0627754f, 0.0281143f, 0.997632f, 0.992774f, -0.120000f, 0.000000f, 
		0.996734f, 0.0807492f, 0.000000f, -0.0616252f, -0.0293686f, 0.997667f, 
		0.122651f, -0.0201435f, 0.992245f, 0.000000f, -1.00000f, 0.000000f, 
		0.209714f, -0.977763f, 0.000000f, -0.0160453f, 0.0569920f, 0.998246f, 
		-0.000685485f, 1.00000f, 0.000000f, -0.996539f, -0.0831291f, 0.000000f, 
		-0.0251867f, -0.0537484f, 0.998237f, -0.169050f, -0.985607f, 0.000000f, 
		-0.984440f, 0.175722f, 0.000000f, -0.0616252f, -0.0293686f, 0.997667f, 
		0.992774f, -0.120000f, 0.000000f, 0.209714f, -0.977763f, 0.000000f, 
		-0.0627754f, 0.0281143f, 0.997632f, 0.0878137f, 0.996137f, 0.000000f, 
		0.996734f, 0.0807492f, 0.000000f, 0.0615560f, 0.998104f, 0.000000f, 
		0.928512f, 0.371303f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.998873f, 0.0474649f, 0.000000f, 0.0813852f, -0.996683f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.103266f, -0.994654f, 0.000000f, 
		-0.995513f, 0.0946224f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.111733f, 0.993738f, 0.000000f, -0.994818f, -0.101674f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.0813852f, -0.996683f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.998873f, 0.0474649f, 0.000000f, 0.928512f, 0.371303f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.316006f, 0.948757f, 0.000000f, 
		0.0615560f, 0.998104f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.995513f, 0.0946224f, 0.000000f, -0.994818f, -0.101674f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.103266f, -0.994654f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.111733f, 0.993738f, 0.000000f, 
		0.316006f, 0.948757f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.111733f, 0.993738f, 0.000000f, 
		0.316006f, 0.948757f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.103266f, -0.994654f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.995513f, 0.0946224f, 0.000000f, -0.994818f, -0.101674f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.316006f, 0.948757f, 0.000000f, 
		0.0615560f, 0.998104f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.998873f, 0.0474649f, 0.000000f, 0.928512f, 0.371303f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.0813852f, -0.996683f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.111733f, 0.993738f, 0.000000f, -0.994818f, -0.101674f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.103266f, -0.994654f, 0.000000f, 
		-0.995513f, 0.0946224f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.998873f, 0.0474649f, 0.000000f, 0.0813852f, -0.996683f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0615560f, 0.998104f, 0.000000f, 
		0.928512f, 0.371303f, 0.000000f, -0.167644f, 0.985848f, 0.000000f, 
		0.999820f, 0.0189469f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.997599f, -0.0692522f, 0.000000f, 0.205447f, -0.978668f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.127676f, -0.991816f, 0.000000f, 
		-0.996283f, 0.0861385f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.123215f, 0.992380f, 0.000000f, -0.955425f, -0.295234f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.205447f, -0.978668f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.997599f, -0.0692522f, 0.000000f, 0.999820f, 0.0189469f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0346114f, 0.999401f, 0.000000f, 
		-0.167644f, 0.985848f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.996283f, 0.0861385f, 0.000000f, -0.955425f, -0.295234f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.127676f, -0.991816f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.123215f, 0.992380f, 0.000000f, 
		-0.0346114f, 0.999401f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0420891f, 0.0207083f, 0.998899f, 
		-0.114537f, -0.00395764f, 0.993411f, 0.0371830f, -0.0134046f, 0.999219f, 
		-0.0993447f, -0.00264390f, 0.995050f, 0.0371830f, -0.0134046f, 0.999219f, 
		-0.0993447f, -0.00264390f, 0.995050f, 0.123215f, 0.992380f, 0.000000f, 
		-0.0346114f, 0.999401f, 0.000000f, 0.0420891f, 0.0207083f, 0.998899f, 
		-0.114537f, -0.00395764f, 0.993411f, -0.127676f, -0.991816f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.0345819f, -0.0333619f, 0.998845f, 
		0.0283401f, 0.0273398f, 0.999224f, -0.114537f, -0.00395764f, 0.993411f, 
		-0.0993447f, -0.00264390f, 0.995050f, 0.0420891f, 0.0207083f, 0.998899f, 
		0.0371830f, -0.0134046f, 0.999219f, -0.996283f, 0.0861385f, 0.000000f, 
		-0.955425f, -0.295234f, 0.000000f, 0.0283401f, 0.0273398f, 0.999224f, 
		-0.0993447f, -0.00264390f, 0.995050f, -0.0346114f, 0.999401f, 0.000000f, 
		-0.167644f, 0.985848f, 0.000000f, 0.0345819f, -0.0333619f, 0.998845f, 
		0.0283401f, 0.0273398f, 0.999224f, 0.997599f, -0.0692522f, 0.000000f, 
		0.999820f, 0.0189469f, 0.000000f, 0.0345819f, -0.0333619f, 0.998845f, 
		-0.114537f, -0.00395764f, 0.993411f, 0.000000f, -1.00000f, 0.000000f, 
		0.205447f, -0.978668f, 0.000000f, 0.0371830f, -0.0134046f, 0.999219f, 
		0.123215f, 0.992380f, 0.000000f, -0.955425f, -0.295234f, 0.000000f, 
		0.0420891f, 0.0207083f, 0.998899f, -0.127676f, -0.991816f, 0.000000f, 
		-0.996283f, 0.0861385f, 0.000000f, 0.0345819f, -0.0333619f, 0.998845f, 
		0.997599f, -0.0692522f, 0.000000f, 0.205447f, -0.978668f, 0.000000f, 
		0.0283401f, 0.0273398f, 0.999224f, -0.167644f, 0.985848f, 0.000000f, 
		0.999820f, 0.0189469f, 0.000000f, -0.0590963f, 0.998252f, 0.000000f, 
		0.999977f, 0.00672054f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.994100f, 0.108465f, 0.000000f, 0.509936f, -0.860212f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.493506f, -0.869742f, 0.000000f, 
		-0.989874f, -0.141947f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.351203f, 0.936299f, 0.000000f, -0.999111f, 0.0421623f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.0781433f, -0.996942f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.994100f, 0.108465f, 0.000000f, 0.999977f, 0.00672054f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0478054f, 0.998857f, 0.000000f, 
		-0.0590963f, 0.998252f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.989874f, -0.141947f, 0.000000f, -0.999111f, 0.0421623f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, -0.493506f, -0.869742f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.351203f, 0.936299f, 0.000000f, 
		0.0478054f, 0.998857f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.117722f, 0.0556484f, 0.991486f, 
		0.000000f, 0.000000f, 1.00000f, 0.106662f, -0.0494684f, 0.993064f, 
		0.000000f, 0.000000f, 1.00000f, 0.106662f, -0.0494684f, 0.993064f, 
		-0.351203f, 0.936299f, 0.000000f, 0.0478054f, 0.998857f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.117722f, 0.0556484f, 0.991486f, -0.493506f, -0.869742f, 0.000000f, 
		-0.00874343f, 0.111548f, 0.993721f, -0.165303f, 0.0440098f, 0.985260f, 
		-0.0821512f, -0.0498833f, 0.995371f, 0.117722f, 0.0556484f, 0.991486f, 
		0.106662f, -0.0494684f, 0.993064f, 0.000000f, 0.000000f, 1.00000f, 
		-0.989874f, -0.141947f, 0.000000f, -0.999111f, 0.0421623f, 0.000000f, 
		-0.0821512f, -0.0498833f, 0.995371f, 0.106662f, -0.0494684f, 0.993064f, 
		0.0478054f, 0.998857f, 0.000000f, -0.0590963f, 0.998252f, 0.000000f, 
		-8.19464e-014f, 0.000000f, 1.00000f, -0.165303f, 0.0440098f, 0.985260f, 
		0.994100f, 0.108465f, 0.000000f, -0.0821512f, -0.0498833f, 0.995371f, 
		0.999977f, 0.00672054f, 0.000000f, -0.00874343f, 0.111548f, 0.993721f, 
		0.000000f, -1.00000f, 0.000000f, 0.0781433f, -0.996942f, 0.000000f, 
		0.117722f, 0.0556484f, 0.991486f, 0.000000f, 0.000000f, 1.00000f, 
		-0.351203f, 0.936299f, 0.000000f, -0.999111f, 0.0421623f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.493506f, -0.869742f, 0.000000f, 
		-0.989874f, -0.141947f, 0.000000f, -8.19464e-014f, 0.000000f, 1.00000f, 
		0.994100f, 0.108465f, 0.000000f, 0.509936f, -0.860212f, 0.000000f, 
		-0.0821512f, -0.0498833f, 0.995371f, -0.0590963f, 0.998252f, 0.000000f, 
		0.999977f, 0.00672054f, 0.000000f, 0.509936f, -0.860212f, 0.000000f, 
		0.0781433f, -0.996942f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.994100f, 0.108465f, 0.000000f, 0.509936f, -0.860212f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.0781433f, -0.996942f, 0.000000f, 
		-8.19464e-014f, 0.000000f, 1.00000f, -0.00874343f, 0.111548f, 0.993721f, 
		-0.165303f, 0.0440098f, 0.985260f, 0.509936f, -0.860212f, 0.000000f, 
		0.0781433f, -0.996942f, 0.000000f, 0.509936f, -0.860212f, 0.000000f, 
		0.0781433f, -0.996942f, 0.000000f, -0.135154f, 0.990825f, 0.000000f, 
		0.998426f, 0.0560880f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.992858f, -0.119305f, 0.000000f, 0.114558f, -0.993417f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.270695f, -0.962665f, 0.000000f, 
		-0.990403f, -0.138210f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.115852f, 0.993267f, 0.000000f, -0.999999f, -0.00161345f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.114558f, -0.993417f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.992858f, -0.119305f, 0.000000f, 0.998426f, 0.0560880f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.218055f, 0.975936f, 0.000000f, 
		-0.135154f, 0.990825f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.990403f, -0.138210f, 0.000000f, -0.999999f, -0.00161345f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.270695f, -0.962665f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.115852f, 0.993267f, 0.000000f, 
		0.218055f, 0.975936f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0780901f, 0.0369133f, 0.996263f, 
		0.000000f, 0.000000f, 1.00000f, 0.0639978f, -0.0302524f, 0.997491f, 
		0.000000f, 0.000000f, 1.00000f, 0.0639978f, -0.0302524f, 0.997491f, 
		-0.115852f, 0.993267f, 0.000000f, 0.218055f, 0.975936f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0780901f, 0.0369133f, 0.996263f, 
		-0.270695f, -0.962665f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0307876f, 0.0410241f, 0.998684f, -0.0248991f, -0.0352035f, 0.999070f, 
		0.0780901f, 0.0369133f, 0.996263f, 0.0639978f, -0.0302524f, 0.997491f, 
		0.000000f, 0.000000f, 1.00000f, -0.990403f, -0.138210f, 0.000000f, 
		-0.999999f, -0.00161345f, 0.000000f, -0.0248991f, -0.0352035f, 0.999070f, 
		0.0639978f, -0.0302524f, 0.997491f, 0.218055f, 0.975936f, 0.000000f, 
		-0.135154f, 0.990825f, 0.000000f, -0.0307876f, 0.0410241f, 0.998684f, 
		-0.0248991f, -0.0352035f, 0.999070f, 0.992858f, -0.119305f, 0.000000f, 
		0.998426f, 0.0560880f, 0.000000f, -0.0307876f, 0.0410241f, 0.998684f, 
		0.0780901f, 0.0369133f, 0.996263f, 0.000000f, -1.00000f, 0.000000f, 
		0.114558f, -0.993417f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.115852f, 0.993267f, 0.000000f, -0.999999f, -0.00161345f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.270695f, -0.962665f, 0.000000f, 
		-0.990403f, -0.138210f, 0.000000f, -0.0307876f, 0.0410241f, 0.998684f, 
		0.992858f, -0.119305f, 0.000000f, 0.114558f, -0.993417f, 0.000000f, 
		-0.0248991f, -0.0352035f, 0.999070f, -0.135154f, 0.990825f, 0.000000f, 
		0.998426f, 0.0560880f, 0.000000f, -0.168109f, 0.985768f, 0.000000f, 
		0.998296f, -0.0583504f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.994766f, 0.102181f, 0.000000f, 0.0442749f, -0.999019f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.493506f, -0.869742f, 0.000000f, 
		-0.999330f, 0.0366058f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.159035f, 0.987273f, 0.000000f, -0.999050f, 0.0435820f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		0.162895f, -0.986643f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.994766f, 0.102181f, 0.000000f, 0.998296f, -0.0583504f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.123756f, 0.992313f, 0.000000f, 
		0.101599f, 0.994825f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.999330f, 0.0366058f, 0.000000f, -0.999050f, 0.0435820f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, -0.493506f, -0.869742f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.123756f, 0.992313f, 0.000000f, 
		0.159035f, 0.987273f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.0708654f, 0.0334988f, 0.996923f, 
		0.000000f, 0.000000f, 1.00000f, 0.0515204f, -0.0607949f, 0.996820f, 
		-0.123756f, 0.992313f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0515204f, -0.0607949f, 0.996820f, 0.159035f, 0.987273f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0708654f, 0.0334988f, 0.996923f, -0.493506f, -0.869742f, 0.000000f, 
		-0.0110698f, 0.0670490f, 0.997688f, -0.0209914f, 0.0415061f, 0.998918f, 
		-0.00507798f, -0.0497220f, 0.998750f, -0.0177231f, -0.0236689f, 0.999563f, 
		0.0708654f, 0.0334988f, 0.996923f, 0.0515204f, -0.0607949f, 0.996820f, 
		0.000000f, 0.000000f, 1.00000f, -0.999330f, 0.0366058f, 0.000000f, 
		-0.999050f, 0.0435820f, 0.000000f, -0.00507798f, -0.0497220f, 0.998750f, 
		-0.123756f, 0.992313f, 0.000000f, 0.101599f, 0.994825f, 0.000000f, 
		0.0515204f, -0.0607949f, 0.996820f, -0.0209914f, 0.0415061f, 0.998918f, 
		0.994766f, 0.102181f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0177231f, -0.0236689f, 0.999563f, 0.998296f, -0.0583504f, 0.000000f, 
		-0.0110698f, 0.0670490f, 0.997688f, 0.000000f, -1.00000f, 0.000000f, 
		0.162895f, -0.986643f, 0.000000f, 0.0708654f, 0.0334988f, 0.996923f, 
		0.000000f, 0.000000f, 1.00000f, 0.159035f, 0.987273f, 0.000000f, 
		-0.999050f, 0.0435820f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.493506f, -0.869742f, 0.000000f, -0.999330f, 0.0366058f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.994766f, 0.102181f, 0.000000f, 
		0.0442749f, -0.999019f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.168109f, 0.985768f, 0.000000f, 0.998296f, -0.0583504f, 0.000000f, 
		0.101599f, 0.994825f, 0.000000f, -0.168109f, 0.985768f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.168109f, 0.985768f, 0.000000f, 
		0.998296f, -0.0583504f, 0.000000f, -0.123756f, 0.992313f, 0.000000f, 
		0.101599f, 0.994825f, 0.000000f, -0.00507798f, -0.0497220f, 0.998750f, 
		0.000000f, 0.000000f, 1.00000f, -0.0177231f, -0.0236689f, 0.999563f, 
		0.101599f, 0.994825f, 0.000000f, -0.168109f, 0.985768f, 0.000000f, 
		0.101599f, 0.994825f, 0.000000f, -0.168109f, 0.985768f, 0.000000f, 
		0.0442749f, -0.999019f, 0.000000f, 0.162895f, -0.986643f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.994766f, 0.102181f, 0.000000f, 
		0.0442749f, -0.999019f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		0.162895f, -0.986643f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0110698f, 0.0670490f, 0.997688f, -0.0209914f, 0.0415061f, 0.998918f, 
		0.0442749f, -0.999019f, 0.000000f, 0.162895f, -0.986643f, 0.000000f, 
		0.0442749f, -0.999019f, 0.000000f, 0.162895f, -0.986643f, 0.000000f, 
		-0.0952754f, 0.995451f, 0.000000f, 0.999976f, 0.00698598f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.999870f, -0.0161482f, 0.000000f, 
		0.246494f, -0.969144f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.134893f, -0.990860f, 0.000000f, -0.999698f, 0.0245550f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.142208f, 0.989837f, 0.000000f, 
		-0.977085f, -0.212847f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.246494f, -0.969144f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.999870f, -0.0161482f, 0.000000f, 
		0.999976f, 0.00698598f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0278845f, 0.999611f, 0.000000f, -0.0952754f, 0.995451f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.999698f, 0.0245550f, 0.000000f, 
		-0.977085f, -0.212847f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.134893f, -0.990860f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.142208f, 0.989837f, 0.000000f, 0.0278845f, 0.999611f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0408125f, -0.0578725f, 0.997489f, 0.110740f, -0.0523471f, 0.992470f, 
		-0.0391562f, 0.0548344f, 0.997727f, 0.111550f, 0.0519578f, 0.992400f, 
		-0.0391562f, 0.0548344f, 0.997727f, 0.111550f, 0.0519578f, 0.992400f, 
		-0.142208f, 0.989837f, 0.000000f, 0.0278845f, 0.999611f, 0.000000f, 
		-0.0408125f, -0.0578725f, 0.997489f, 0.110740f, -0.0523471f, 0.992470f, 
		-0.134893f, -0.990860f, 0.000000f, 0.000000f, -1.00000f, 0.000000f, 
		-0.0385922f, -0.0485091f, 0.998077f, -0.0465605f, 0.0408232f, 0.998081f, 
		0.110740f, -0.0523471f, 0.992470f, 0.111550f, 0.0519578f, 0.992400f, 
		-0.0408125f, -0.0578725f, 0.997489f, -0.0391562f, 0.0548344f, 0.997727f, 
		-0.999698f, 0.0245550f, 0.000000f, -0.977085f, -0.212847f, 0.000000f, 
		-0.0465605f, 0.0408232f, 0.998081f, 0.111550f, 0.0519578f, 0.992400f, 
		0.0278845f, 0.999611f, 0.000000f, -0.0952754f, 0.995451f, 0.000000f, 
		-0.0385922f, -0.0485091f, 0.998077f, -0.0465605f, 0.0408232f, 0.998081f, 
		0.999870f, -0.0161482f, 0.000000f, 0.999976f, 0.00698598f, 0.000000f, 
		-0.0385922f, -0.0485091f, 0.998077f, 0.110740f, -0.0523471f, 0.992470f, 
		0.000000f, -1.00000f, 0.000000f, 0.246494f, -0.969144f, 0.000000f, 
		-0.0391562f, 0.0548344f, 0.997727f, -0.142208f, 0.989837f, 0.000000f, 
		-0.977085f, -0.212847f, 0.000000f, -0.0408125f, -0.0578725f, 0.997489f, 
		-0.134893f, -0.990860f, 0.000000f, -0.999698f, 0.0245550f, 0.000000f, 
		-0.0385922f, -0.0485091f, 0.998077f, 0.999870f, -0.0161482f, 0.000000f, 
		0.246494f, -0.969144f, 0.000000f, -0.0465605f, 0.0408232f, 0.998081f, 
		-0.0952754f, 0.995451f, 0.000000f, 0.999976f, 0.00698598f, 0.000000f, 
		0.0127791f, 0.999918f, 0.000000f, 0.988615f, 0.150466f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.999914f, 0.0131504f, 0.000000f, 
		0.321373f, -0.946953f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.528202f, -0.849118f, 0.000000f, -0.998969f, -0.0454079f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.476492f, 0.879179f, 0.000000f, 
		-0.999592f, 0.0285751f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.321373f, -0.946953f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.999914f, 0.0131504f, 0.000000f, 
		0.988615f, 0.150466f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.504653f, 0.863322f, 0.000000f, 0.0127791f, 0.999918f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.998969f, -0.0454079f, 0.000000f, 
		-0.999592f, 0.0285751f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.528202f, -0.849118f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.476492f, 0.879179f, 0.000000f, -0.504653f, 0.863322f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.102618f, -0.0243139f, 0.994424f, 0.000000f, 0.000000f, 1.00000f, 
		-0.103057f, 0.0244179f, 0.994376f, 0.000000f, 0.000000f, 1.00000f, 
		-0.103057f, 0.0244179f, 0.994376f, 0.476492f, 0.879179f, 0.000000f, 
		-0.504653f, 0.863322f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.102618f, -0.0243139f, 0.994424f, -0.528202f, -0.849118f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.00343578f, -0.0676091f, 0.997706f, 
		-0.0116877f, 0.0530717f, 0.998522f, -0.102618f, -0.0243139f, 0.994424f, 
		-0.103057f, 0.0244179f, 0.994376f, 0.000000f, 0.000000f, 1.00000f, 
		-0.998969f, -0.0454079f, 0.000000f, -0.999592f, 0.0285751f, 0.000000f, 
		-0.0116877f, 0.0530717f, 0.998522f, -0.103057f, 0.0244179f, 0.994376f, 
		-0.504653f, 0.863322f, 0.000000f, 0.0127791f, 0.999918f, 0.000000f, 
		0.00343578f, -0.0676091f, 0.997706f, -0.0116877f, 0.0530717f, 0.998522f, 
		0.999914f, 0.0131504f, 0.000000f, 0.988615f, 0.150466f, 0.000000f, 
		0.00343578f, -0.0676091f, 0.997706f, -0.102618f, -0.0243139f, 0.994424f, 
		0.000000f, -1.00000f, 0.000000f, 0.321373f, -0.946953f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.476492f, 0.879179f, 0.000000f, 
		-0.999592f, 0.0285751f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.528202f, -0.849118f, 0.000000f, -0.998969f, -0.0454079f, 0.000000f, 
		0.00343578f, -0.0676091f, 0.997706f, 0.999914f, 0.0131504f, 0.000000f, 
		0.321373f, -0.946953f, 0.000000f, -0.0116877f, 0.0530717f, 0.998522f, 
		0.0127791f, 0.999918f, 0.000000f, 0.988615f, 0.150466f, 0.000000f, 
		-0.451469f, 0.892287f, 0.000000f, 0.975716f, 0.219041f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0366225f, -0.999329f, 0.000000f, 
		0.301661f, -0.953415f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.493506f, -0.869743f, 0.000000f, -0.998215f, 0.0597199f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.361508f, 0.932369f, 0.000000f, 
		-0.999334f, -0.0364958f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.301661f, -0.953415f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0803625f, 0.996766f, 0.000000f, 
		0.975716f, 0.219041f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.136832f, 0.990594f, 0.000000f, -0.451469f, 0.892287f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.998215f, 0.0597199f, 0.000000f, 
		-0.999334f, -0.0364958f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.493506f, -0.869743f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.361508f, 0.932369f, 0.000000f, -0.136832f, 0.990594f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0330473f, -0.0156215f, 0.999332f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0341890f, 0.0161615f, 0.999285f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0341890f, 0.0161615f, 0.999285f, 0.361508f, 0.932369f, 0.000000f, 
		-0.136832f, 0.990594f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.0330473f, -0.0156215f, 0.999332f, -0.493506f, -0.869743f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.0208805f, -0.0201434f, 0.999579f, 
		0.0159970f, 0.0154327f, 0.999753f, -0.0330473f, -0.0156215f, 0.999332f, 
		-0.0341890f, 0.0161615f, 0.999285f, 0.000000f, 0.000000f, 1.00000f, 
		-0.998215f, 0.0597199f, 0.000000f, -0.999334f, -0.0364958f, 0.000000f, 
		0.0159970f, 0.0154327f, 0.999753f, -0.0341890f, 0.0161615f, 0.999285f, 
		-0.136832f, 0.990594f, 0.000000f, -0.451469f, 0.892287f, 0.000000f, 
		-0.0803625f, 0.996766f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0208805f, -0.0201434f, 0.999579f, 0.0159970f, 0.0154327f, 0.999753f, 
		0.975716f, 0.219041f, 0.000000f, 0.0208805f, -0.0201434f, 0.999579f, 
		-0.0330473f, -0.0156215f, 0.999332f, 0.000000f, -1.00000f, 0.000000f, 
		0.301661f, -0.953415f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.361508f, 0.932369f, 0.000000f, -0.999334f, -0.0364958f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -0.493506f, -0.869743f, 0.000000f, 
		-0.998215f, 0.0597199f, 0.000000f, -0.0366225f, -0.999329f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0208805f, -0.0201434f, 0.999579f, 
		0.301661f, -0.953415f, 0.000000f, 0.0159970f, 0.0154327f, 0.999753f, 
		-0.451469f, 0.892287f, 0.000000f, 0.975716f, 0.219041f, 0.000000f, 
		0.983396f, -0.181474f, 0.000000f, -0.0366225f, -0.999329f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.933939f, 0.357432f, 0.000000f, 
		-0.0803625f, 0.996766f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.933939f, 0.357432f, 0.000000f, -0.0803625f, 0.996766f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.983396f, -0.181474f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.0366225f, -0.999329f, 0.000000f, 
		0.933939f, 0.357432f, 0.000000f, 0.983396f, -0.181474f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.983396f, -0.181474f, 0.000000f, 
		-0.0366225f, -0.999329f, 0.000000f, 0.933939f, 0.357432f, 0.000000f, 
		0.983396f, -0.181474f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.933939f, 0.357432f, 0.000000f, -0.0803625f, 0.996766f, 0.000000f, 
		0.933939f, 0.357432f, 0.000000f, 0.983396f, -0.181474f, 0.000000f, 
		-0.100750f, 0.994912f, 0.000000f, 0.984771f, 0.173857f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.924708f, -0.380676f, 0.000000f, 
		0.0838494f, -0.996478f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0602584f, -0.998183f, 0.000000f, -0.980845f, -0.194792f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.143739f, 0.989616f, 0.000000f, 
		-0.966429f, -0.256933f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.0838494f, -0.996478f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.924708f, -0.380676f, 0.000000f, 
		0.984771f, 0.173857f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.280465f, 0.959864f, 0.000000f, -0.100750f, 0.994912f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -1.19234e-014f, 0.000000f, -1.00000f, 
		-0.980845f, -0.194792f, 0.000000f, -0.966429f, -0.256933f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-1.19234e-014f, 0.000000f, -1.00000f, 0.0602584f, -0.998183f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.143739f, 0.989616f, 0.000000f, 0.280465f, 0.959864f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -1.19234e-014f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -1.19234e-014f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		0.143739f, 0.989616f, 0.000000f, 0.280465f, 0.959864f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.0602584f, -0.998183f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, -0.980845f, -0.194792f, 0.000000f, 
		-0.966429f, -0.256933f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.280465f, 0.959864f, 0.000000f, -0.100750f, 0.994912f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.924708f, -0.380676f, 0.000000f, 
		0.984771f, 0.173857f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.0838494f, -0.996478f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.143739f, 0.989616f, 0.000000f, 
		-0.966429f, -0.256933f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0602584f, -0.998183f, 0.000000f, -0.980845f, -0.194792f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.924708f, -0.380676f, 0.000000f, 
		0.0838494f, -0.996478f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.100750f, 0.994912f, 0.000000f, 0.984771f, 0.173857f, 0.000000f, 
		-0.253672f, 0.967290f, 0.000000f, 0.963439f, 0.267929f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.954293f, -0.298872f, 0.000000f, 
		-0.0293294f, -0.999570f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0723516f, -0.997379f, 0.000000f, -0.996471f, -0.0839372f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.272461f, 0.962167f, 0.000000f, 
		-0.996215f, 0.0869292f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.149107f, -0.988821f, 0.000000f, -0.0293294f, -0.999570f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.954293f, -0.298872f, 0.000000f, 
		0.963439f, 0.267929f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.285725f, 0.958312f, 0.000000f, -0.253672f, 0.967290f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 1.16158e-014f, 0.000000f, -1.00000f, 
		-0.996471f, -0.0839372f, 0.000000f, -0.996215f, 0.0869292f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		1.16158e-014f, 0.000000f, -1.00000f, -0.0723516f, -0.997379f, 0.000000f, 
		0.149107f, -0.988821f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.272461f, 0.962167f, 0.000000f, -0.285725f, 0.958312f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 1.16158e-014f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 1.16158e-014f, 0.000000f, -1.00000f, 
		-0.0268388f, -0.0178423f, 0.999481f, 0.00304029f, -0.0352974f, 0.999372f, 
		-0.0147086f, 0.0322334f, 0.999372f, -0.00869134f, 0.0577753f, 0.998292f, 
		-0.0147086f, 0.0322334f, 0.999372f, -0.00869134f, 0.0577753f, 0.998292f, 
		0.272461f, 0.962167f, 0.000000f, -0.285725f, 0.958312f, 0.000000f, 
		-0.0268388f, -0.0178423f, 0.999481f, 0.00304029f, -0.0352974f, 0.999372f, 
		-0.0723516f, -0.997379f, 0.000000f, 0.149107f, -0.988821f, 0.000000f, 
		0.0207465f, -0.0190281f, 0.999604f, 0.0122537f, 0.0264652f, 0.999575f, 
		0.00304029f, -0.0352974f, 0.999372f, -0.00869134f, 0.0577753f, 0.998292f, 
		-0.0268388f, -0.0178423f, 0.999481f, -0.0147086f, 0.0322334f, 0.999372f, 
		-0.996471f, -0.0839372f, 0.000000f, -0.996215f, 0.0869292f, 0.000000f, 
		0.0122537f, 0.0264652f, 0.999575f, -0.00869134f, 0.0577753f, 0.998292f, 
		-0.285725f, 0.958312f, 0.000000f, -0.253672f, 0.967290f, 0.000000f, 
		0.0207465f, -0.0190281f, 0.999604f, 0.0122537f, 0.0264652f, 0.999575f, 
		0.954293f, -0.298872f, 0.000000f, 0.963439f, 0.267929f, 0.000000f, 
		0.0207465f, -0.0190281f, 0.999604f, 0.00304029f, -0.0352974f, 0.999372f, 
		0.149107f, -0.988821f, 0.000000f, -0.0293294f, -0.999570f, 0.000000f, 
		-0.0147086f, 0.0322334f, 0.999372f, 0.272461f, 0.962167f, 0.000000f, 
		-0.996215f, 0.0869292f, 0.000000f, -0.0268388f, -0.0178423f, 0.999481f, 
		-0.0723516f, -0.997379f, 0.000000f, -0.996471f, -0.0839372f, 0.000000f, 
		0.0207465f, -0.0190281f, 0.999604f, 0.954293f, -0.298872f, 0.000000f, 
		-0.0293294f, -0.999570f, 0.000000f, 0.0122537f, 0.0264652f, 0.999575f, 
		-0.253672f, 0.967290f, 0.000000f, 0.963439f, 0.267929f, 0.000000f, 
		0.999994f, 0.00343709f, 0.000000f, 0.999588f, 0.0286958f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.999515f, -0.0311435f, 0.000000f, 
		0.998802f, -0.0489355f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.000689130f, -1.00000f, 0.000000f, -0.671094f, 0.741372f, 0.000000f, 
		-6.03862e-015f, 0.000000f, -1.00000f, -0.929810f, -0.368040f, 0.000000f, 
		0.0221705f, 0.999754f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.0120140f, -0.999928f, 0.000000f, 0.998802f, -0.0489355f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.999515f, -0.0311435f, 0.000000f, 
		0.999588f, 0.0286958f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0148430f, 0.999890f, 0.000000f, 0.999994f, 0.00343709f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -0.922637f, 0.385670f, 0.000000f, 
		-0.929810f, -0.368040f, 0.000000f, 7.30661e-014f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		-0.000689130f, -1.00000f, 0.000000f, -6.03862e-015f, 0.000000f, -1.00000f, 
		-0.0120140f, -0.999928f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.0221705f, 0.999754f, 0.000000f, 0.0148430f, 0.999890f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 7.30661e-014f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -4.10997e-014f, 0.000000f, 1.00000f, 
		0.0588095f, 0.0702511f, 0.995794f, 0.000000f, 0.000000f, 1.00000f, 
		0.0616491f, -0.0784302f, 0.995012f, 0.000000f, 0.000000f, 1.00000f, 
		0.0616491f, -0.0784302f, 0.995012f, 0.0221705f, 0.999754f, 0.000000f, 
		0.0148430f, 0.999890f, 0.000000f, -2.49336e-014f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, 1.00000f, -0.000689130f, -1.00000f, 0.000000f, 
		0.0588095f, 0.0702511f, 0.995794f, -0.0120140f, -0.999928f, 0.000000f, 
		-0.0995415f, 0.00401039f, 0.995025f, -0.101248f, -0.00170278f, 0.994860f, 
		0.0588095f, 0.0702511f, 0.995794f, 0.0616491f, -0.0784302f, 0.995012f, 
		-4.10997e-014f, 0.000000f, 1.00000f, -0.922637f, 0.385670f, 0.000000f, 
		-0.929810f, -0.368040f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.101248f, -0.00170278f, 0.994860f, 0.0616491f, -0.0784302f, 0.995012f, 
		0.0148430f, 0.999890f, 0.000000f, 0.999994f, 0.00343709f, 0.000000f, 
		-0.0995415f, 0.00401039f, 0.995025f, -0.101248f, -0.00170278f, 0.994860f, 
		0.999515f, -0.0311435f, 0.000000f, 0.999588f, 0.0286958f, 0.000000f, 
		-0.0995415f, 0.00401039f, 0.995025f, 0.0588095f, 0.0702511f, 0.995794f, 
		-0.0120140f, -0.999928f, 0.000000f, 0.998802f, -0.0489355f, 0.000000f, 
		-0.929810f, -0.368040f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.0221705f, 0.999754f, 0.000000f, -2.49336e-014f, 0.000000f, 1.00000f, 
		-0.000689130f, -1.00000f, 0.000000f, -0.671094f, 0.741372f, 0.000000f, 
		-0.0995415f, 0.00401039f, 0.995025f, 0.999515f, -0.0311435f, 0.000000f, 
		0.998802f, -0.0489355f, 0.000000f, -0.101248f, -0.00170278f, 0.994860f, 
		0.999994f, 0.00343709f, 0.000000f, 0.999588f, 0.0286958f, 0.000000f, 
		-0.671094f, 0.741372f, 0.000000f, -0.922637f, 0.385670f, 0.000000f, 
		7.30661e-014f, 0.000000f, -1.00000f, -6.03862e-015f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, -1.00000f, -0.922637f, 0.385670f, 0.000000f, 
		-0.929810f, -0.368040f, 0.000000f, -0.000689130f, -1.00000f, 0.000000f, 
		-0.671094f, 0.741372f, 0.000000f, -2.49336e-014f, 0.000000f, 1.00000f, 
		-4.10997e-014f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 1.00000f, 
		-0.671094f, 0.741372f, 0.000000f, -0.922637f, 0.385670f, 0.000000f, 
		-0.671094f, 0.741372f, 0.000000f, -0.922637f, 0.385670f, 0.000000f, 
		-0.999972f, -0.00695957f, 0.00280969f, -0.999970f, -0.00716543f, 0.00280994f, 
		-0.999990f, -0.00358515f, 0.00280976f, -0.999972f, -0.00695957f, 0.00280969f, 
		-0.999970f, -0.00716543f, 0.00280998f, -0.999990f, -0.00358515f, 0.00280976f, 
		-0.999972f, -0.00695957f, 0.00280974f, -0.999970f, -0.00716543f, 0.00280998f, 
		-0.999970f, -0.00716543f, 0.00280949f, -0.999972f, -0.00695957f, 0.00280974f, 
		-0.999982f, -0.00527713f, 0.00281193f, -0.999970f, -0.00716543f, 0.00280949f, 
		-0.999970f, -0.00718967f, 0.00281430f, -0.999982f, -0.00527713f, 0.00281193f, 
		-0.999982f, -0.00527476f, 0.00281197f, -0.999970f, -0.00718967f, 0.00281430f, 
		-0.999972f, -0.00695483f, 0.00280984f, -0.999982f, -0.00527476f, 0.00281197f, 
		-0.999970f, -0.00716543f, 0.00281011f, -0.999972f, -0.00695483f, 0.00280984f, 
		-0.999983f, -0.00506415f, 0.00281228f, -0.999970f, -0.00716543f, 0.00281011f, 
		0.400247f, -0.916406f, -0.00151673f, -0.456983f, -0.889475f, 0.000971267f, 
		0.999989f, -0.000875229f, -0.00464929f, 0.400247f, -0.916406f, -0.00151673f, 
		0.999985f, -0.00288521f, -0.00465217f, 0.999989f, -0.000875229f, -0.00464929f, 
		0.999978f, -0.00475435f, -0.00465737f, 0.999985f, -0.00288521f, -0.00465217f, 
		0.999969f, -0.00640436f, -0.00466062f, 0.999978f, -0.00475435f, -0.00465737f, 
		0.999958f, -0.00786931f, -0.00467171f, 0.999969f, -0.00640436f, -0.00466062f, 
		0.999949f, -0.00896539f, -0.00468273f, 0.999958f, -0.00786931f, -0.00467171f, 
		0.999942f, -0.00971172f, -0.00469363f, 0.999949f, -0.00896539f, -0.00468273f, 
		0.999937f, -0.0102135f, -0.00470459f, 0.999942f, -0.00971172f, -0.00469363f, 
		0.999937f, -0.0102136f, -0.00471593f, 0.999937f, -0.0102135f, -0.00470459f, 
		0.999942f, -0.00971221f, -0.00473208f, 0.999937f, -0.0102136f, -0.00471593f, 
		0.999949f, -0.00896538f, -0.00474306f, 0.999942f, -0.00971221f, -0.00473208f, 
		0.999958f, -0.00782872f, -0.00475166f, 0.999949f, -0.00896538f, -0.00474306f, 
		-0.999967f, -0.00559698f, -0.00596865f, -0.999972f, -0.00445440f, -0.00596881f, 
		-0.999972f, -0.00445757f, -0.00596894f, -0.999967f, -0.00559698f, -0.00596865f, 
		-0.999970f, -0.00499630f, -0.00596748f, -0.999972f, -0.00445757f, -0.00596894f, 
		-0.999969f, -0.00505378f, -0.00596735f, -0.999970f, -0.00499630f, -0.00596748f, 
		-0.999969f, -0.00505826f, -0.00596743f, -0.999969f, -0.00505378f, -0.00596735f, 
		-0.999970f, -0.00499630f, -0.00596769f, -0.999969f, -0.00505826f, -0.00596743f, 
		-0.999972f, -0.00445916f, -0.00596928f, -0.999970f, -0.00499630f, -0.00596769f, 
		-0.999969f, -0.00505605f, -0.00596763f, -0.999972f, -0.00445916f, -0.00596928f, 
		-0.999970f, -0.00499630f, -0.00596788f, -0.999969f, -0.00505605f, -0.00596763f, 
		-0.999970f, -0.00499311f, -0.00596794f, -0.999970f, -0.00499630f, -0.00596788f, 
		-0.999972f, -0.00452432f, -0.00596633f, -0.999970f, -0.00499311f, -0.00596794f, 
		-0.0852200f, -0.996362f, -0.000486271f, -0.362250f, -0.932079f, -0.00213607f, 
		0.0190936f, -0.999818f, 0.000103528f, -0.0852200f, -0.996362f, -0.000486271f, 
		0.0656839f, -0.997840f, 0.000332576f, 0.0190936f, -0.999818f, 0.000103528f, 
		0.0851827f, -0.996365f, 0.000395935f, 0.0656839f, -0.997840f, 0.000332576f, 
		0.0871768f, -0.996193f, 0.000365909f, 0.0851827f, -0.996365f, 0.000395935f, 
		0.0727962f, -0.997347f, 0.000271635f, 0.0871768f, -0.996193f, 0.000365909f, 
		0.0371472f, -0.999310f, 0.000121766f, 0.0727962f, -0.997347f, 0.000271635f, 
		-0.0361290f, -0.999347f, -0.000103717f, 0.0371472f, -0.999310f, 0.000121766f, 
		-0.199287f, -0.979941f, -0.000507278f, -0.0361290f, -0.999347f, -0.000103717f, 
		-0.621246f, -0.783614f, -0.00145203f, -0.199287f, -0.979941f, -0.000507278f, 
		-0.985447f, 0.169968f, -0.00224969f, -0.621246f, -0.783614f, -0.00145203f, 
		-0.0382359f, -0.999269f, -8.60458e-005f, -0.985447f, 0.169968f, -0.00224969f, 
		-0.0484947f, -0.998823f, -0.000104411f, -0.0382359f, -0.999269f, -8.60458e-005f, 
		-0.0788063f, -0.996890f, -0.000161779f, -0.0484947f, -0.998823f, -0.000104411f, 
		-0.130889f, -0.991397f, -0.000255470f, -0.0788063f, -0.996890f, -0.000161779f, 
		-0.212691f, -0.977119f, -0.000395078f, -0.130889f, -0.991397f, -0.000255470f, 
		-0.331170f, -0.943571f, -0.000586575f, -0.212691f, -0.977119f, -0.000395078f, 
		-0.496257f, -0.868176f, -0.000841103f, -0.331170f, -0.943571f, -0.000586575f, 
		-0.701692f, -0.712479f, -0.00114400f, -0.496257f, -0.868176f, -0.000841103f, 
		-0.891862f, -0.452305f, -0.00141404f, -0.701692f, -0.712479f, -0.00114400f, 
		-0.990685f, -0.136163f, -0.00154941f, -0.891862f, -0.452305f, -0.00141404f, 
		-0.990493f, 0.137551f, -0.00154903f, -0.990685f, -0.136163f, -0.00154941f, 
		-0.943428f, 0.331574f, -0.00150093f, -0.990493f, 0.137551f, -0.00154903f, 
		-0.999954f, -0.00945916f, -0.00161078f, -0.943428f, 0.331574f, -0.00150093f, 
		-0.769574f, 0.638557f, -0.000854680f, 0.00158843f, -0.999999f, 2.03440e-006f, 
		-0.904204f, 0.427098f, -0.00124405f, -0.769574f, 0.638557f, -0.000854680f, 
		-0.983224f, 0.182398f, -0.00149024f, -0.904204f, 0.427098f, -0.00124405f, 
		-0.998099f, -0.0616124f, -0.00153804f, -0.983224f, 0.182398f, -0.00149024f, 
		-0.959890f, -0.280373f, -0.00140797f, -0.998099f, -0.0616124f, -0.00153804f, 
		-0.884639f, -0.466276f, -0.00115558f, -0.959890f, -0.280373f, -0.00140797f, 
		-0.782925f, -0.622115f, -0.000835744f, -0.884639f, -0.466276f, -0.00115558f, 
		-0.657902f, -0.753104f, -0.000499898f, -0.782925f, -0.622115f, -0.000835744f, 
		-0.506589f, -0.862188f, -0.000196669f, -0.657902f, -0.753104f, -0.000499898f, 
		-0.323722f, -0.946152f, 1.17013e-005f, -0.506589f, -0.862188f, -0.000196669f, 
		-0.105902f, -0.994377f, 5.32985e-005f, -0.323722f, -0.946152f, 1.17013e-005f, 
		0.139048f, -0.990286f, -0.000139871f, -0.105902f, -0.994377f, 5.32985e-005f, 
		-0.999999f, -0.000803828f, 0.000827206f, -0.00247833f, 0.999997f, 2.57959e-006f, 
		-0.00969107f, -0.999953f, 1.25895e-005f, -0.999999f, -0.000803828f, 0.000827206f, 
		0.408497f, -0.912759f, -0.000558714f, -0.00969107f, -0.999953f, 1.25895e-005f, 
		0.171215f, -0.985234f, -0.000256793f, 0.408497f, -0.912759f, -0.000558714f, 
		-0.0574384f, -0.998349f, 9.36597e-005f, 0.171215f, -0.985234f, -0.000256793f, 
		-0.260543f, -0.965462f, 0.000458644f, -0.0574384f, -0.998349f, 9.36597e-005f, 
		-0.435162f, -0.900352f, 0.000819871f, -0.260543f, -0.965462f, 0.000458644f, 
		-0.588276f, -0.808659f, 0.00117369f, -0.435162f, -0.900352f, 0.000819871f, 
		-0.725114f, -0.688627f, 0.00151595f, -0.588276f, -0.808659f, 0.00117369f, 
		-0.847032f, -0.531539f, 0.00183601f, -0.725114f, -0.688627f, 0.00151595f, 
		-0.947251f, -0.320485f, 0.00210205f, -0.847032f, -0.531539f, 0.00183601f, 
		-0.998965f, -0.0454238f, 0.00223787f, -0.947251f, -0.320485f, 0.00210205f, 
		-0.962852f, 0.270023f, 0.00214351f, -0.998965f, -0.0454238f, 0.00223787f, 
		-0.826096f, 0.563526f, 0.00179642f, -0.962852f, 0.270023f, 0.00214351f, 
		-0.830998f, 0.556272f, 0.00176024f, -0.826096f, 0.563526f, 0.00179642f, 
		-0.953495f, 0.301402f, 0.00198421f, -0.830998f, 0.556272f, 0.00176024f, 
		-0.997102f, 0.0760538f, 0.00205651f, -0.953495f, 0.301402f, 0.00198421f, 
		-0.993900f, -0.110266f, 0.00205211f, -0.997102f, 0.0760538f, 0.00205651f, 
		-0.965020f, -0.262169f, 0.00201260f, -0.993900f, -0.110266f, 0.00205211f, 
		-0.920701f, -0.390264f, 0.00195679f, -0.965020f, -0.262169f, 0.00201260f, 
		-0.865675f, -0.500604f, 0.00188852f, -0.920701f, -0.390264f, 0.00195679f, 
		-0.800273f, -0.599633f, 0.00180602f, -0.865675f, -0.500604f, 0.00188852f, 
		-0.724598f, -0.689170f, 0.00170231f, -0.800273f, -0.599633f, 0.00180602f, 
		-0.637946f, -0.770080f, 0.00156873f, -0.724598f, -0.689170f, 0.00170231f, 
		-0.538346f, -0.842723f, 0.00139243f, -0.637946f, -0.770080f, 0.00156873f, 
		-0.538346f, -0.842723f, 0.00139243f, -0.426949f, -0.904275f, 0.00116646f, 
		-0.000141711f, -0.00758193f, 0.999971f, -0.000141555f, -0.00336983f, 0.999994f, 
		-0.999982f, -0.00527713f, 0.00281193f, -0.999970f, -0.00716543f, 0.00280949f, 
		-0.000141874f, -0.00338122f, 0.999994f, -0.000141711f, -0.00758193f, 0.999971f, 
		-0.999970f, -0.00718967f, 0.00281430f, -0.999982f, -0.00527713f, 0.00281193f, 
		-0.000142193f, -0.00505443f, 0.999987f, -0.000141874f, -0.00338122f, 0.999994f, 
		-0.999982f, -0.00527476f, 0.00281197f, -0.999970f, -0.00718967f, 0.00281430f, 
		-0.000141875f, -0.00337008f, 0.999994f, -0.000142193f, -0.00505470f, 0.999987f, 
		-0.999970f, -0.00716543f, 0.00281011f, -0.999972f, -0.00695483f, 0.00280984f, 
		0.000141910f, -0.000695031f, -1.00000f, 6.82096e-005f, -0.877589f, -0.479413f, 
		0.999989f, -0.000875229f, -0.00464929f, 0.400247f, -0.916406f, -0.00151673f, 
		0.000141801f, -0.00719752f, -0.999974f, 0.000141948f, -0.00630679f, -0.999980f, 
		0.999949f, -0.00896539f, -0.00468273f, 0.999958f, -0.00786931f, -0.00467171f, 
		0.000141653f, -0.00782276f, -0.999969f, 0.000141801f, -0.00719752f, -0.999974f, 
		0.999942f, -0.00971172f, -0.00469363f, 0.999949f, -0.00896539f, -0.00468273f, 
		0.000141509f, -0.00810649f, -0.999967f, 0.000141653f, -0.00782276f, -0.999969f, 
		0.999937f, -0.0102135f, -0.00470459f, 0.999942f, -0.00971172f, -0.00469363f, 
		0.000142200f, -0.00784697f, -0.999969f, 0.000141854f, -0.00810739f, -0.999967f, 
		0.999942f, -0.00971221f, -0.00473208f, 0.999937f, -0.0102136f, -0.00471593f, 
		-0.000141807f, -0.00373381f, 0.999993f, 2.42873e-007f, 0.999999f, -0.00171568f, 
		-0.999972f, -0.00445440f, -0.00596881f, 0.00137463f, 0.999999f, 2.28795e-006f, 
		-0.000141670f, -0.00400477f, 0.999992f, -0.000141669f, -0.00400477f, 0.999992f, 
		-0.999972f, -0.00445757f, -0.00596894f, -0.999967f, -0.00559698f, -0.00596865f, 
		-0.000141809f, -0.00373779f, 0.999993f, -0.000141670f, -0.00400477f, 0.999992f, 
		-0.999970f, -0.00499630f, -0.00596748f, -0.999972f, -0.00445757f, -0.00596894f, 
		-0.000141671f, -0.00399997f, 0.999992f, -0.000141809f, -0.00373779f, 0.999993f, 
		-0.999969f, -0.00505378f, -0.00596735f, -0.999970f, -0.00499630f, -0.00596748f, 
		-0.000142088f, -0.00320375f, 0.999995f, -0.000141948f, -0.00453881f, 0.999990f, 
		-0.999970f, -0.00499630f, -0.00596769f, -0.999969f, -0.00505826f, -0.00596743f, 
		-0.000141950f, -0.00453866f, 0.999990f, -0.000142088f, -0.00320375f, 0.999995f, 
		-0.999972f, -0.00445916f, -0.00596928f, -0.999970f, -0.00499630f, -0.00596769f, 
		-0.000141673f, -0.00400272f, 0.999992f, -0.000141950f, -0.00453866f, 0.999990f, 
		-0.999969f, -0.00505605f, -0.00596763f, -0.999972f, -0.00445916f, -0.00596928f, 
		-6.18583e-005f, -0.899965f, 0.435962f, -0.000141676f, -0.00400478f, 0.999992f, 
		-0.362250f, -0.932079f, -0.00213607f, -0.999972f, -0.00452432f, -0.00596633f, 
		-1.49935e-005f, -0.994369f, 0.105971f, -6.18583e-005f, -0.899965f, 0.435962f, 
		-0.0852200f, -0.996362f, -0.000486271f, -0.362250f, -0.932079f, -0.00213607f, 
		3.37612e-006f, -0.999717f, -0.0237927f, -1.49935e-005f, -0.994369f, 0.105971f, 
		0.0190936f, -0.999818f, 0.000103528f, -0.0852200f, -0.996362f, -0.000486271f, 
		1.16526e-005f, -0.996651f, -0.0817697f, 3.37612e-006f, -0.999717f, -0.0237927f, 
		0.0656839f, -0.997840f, 0.000332576f, 0.0190936f, -0.999818f, 0.000103528f, 
		1.50610e-005f, -0.994368f, -0.105979f, 1.16526e-005f, -0.996651f, -0.0817697f, 
		0.0851827f, -0.996365f, 0.000395935f, 0.0656839f, -0.997840f, 0.000332576f, 
		1.53778e-005f, -0.994100f, -0.108469f, 1.50610e-005f, -0.994368f, -0.105979f, 
		0.0871768f, -0.996193f, 0.000365909f, 0.0851827f, -0.996365f, 0.000395935f, 
		1.28592e-005f, -0.995882f, -0.0906571f, 1.53778e-005f, -0.994100f, -0.108469f, 
		0.0727962f, -0.997347f, 0.000271635f, 0.0871768f, -0.996193f, 0.000365909f, 
		6.56218e-006f, -0.998927f, -0.0463129f, 1.28592e-005f, -0.995882f, -0.0906571f, 
		0.0371472f, -0.999310f, 0.000121766f, 0.0727962f, -0.997347f, 0.000271635f, 
		-6.38295e-006f, -0.998985f, 0.0450526f, 6.56218e-006f, -0.998927f, -0.0463129f, 
		-0.0361290f, -0.999347f, -0.000103717f, 0.0371472f, -0.999310f, 0.000121766f, 
		-3.49293e-005f, -0.969287f, 0.245933f, -6.38295e-006f, -0.998985f, 0.0450526f, 
		-0.199287f, -0.979941f, -0.000507278f, -0.0361290f, -0.999347f, -0.000103717f, 
		-0.000100135f, -0.710897f, 0.703296f, -3.49293e-005f, -0.969287f, 0.245933f, 
		-0.621246f, -0.783614f, -0.00145203f, -0.199287f, -0.979941f, -0.000507278f, 
		-0.000140726f, 0.137009f, 0.990570f, -0.000100135f, -0.710897f, 0.703296f, 
		-0.985447f, 0.169968f, -0.00224969f, -0.621246f, -0.783614f, -0.00145203f, 
		-8.58932e-006f, -0.998171f, 0.0604571f, -6.76286e-006f, -0.998863f, 0.0476778f, 
		-0.0484947f, -0.998823f, -0.000104411f, -0.0382359f, -0.999269f, -8.60458e-005f, 
		-1.39367e-005f, -0.995162f, 0.0982427f, -8.58932e-006f, -0.998171f, 0.0604571f, 
		-0.0788063f, -0.996890f, -0.000161779f, -0.0484947f, -0.998823f, -0.000104411f, 
		-2.30385e-005f, -0.986712f, 0.162480f, -1.39367e-005f, -0.995162f, 0.0982427f, 
		-0.130889f, -0.991397f, -0.000255470f, -0.0788063f, -0.996890f, -0.000161779f, 
		-3.72204e-005f, -0.965043f, 0.262092f, -2.30385e-005f, -0.986712f, 0.162480f, 
		-0.212691f, -0.977119f, -0.000395078f, -0.130889f, -0.991397f, -0.000255470f, 
		-5.70828e-005f, -0.915910f, 0.401384f, -3.72204e-005f, -0.965043f, 0.262092f, 
		-0.331170f, -0.943571f, -0.000586575f, -0.212691f, -0.977119f, -0.000395078f, 
		-0.000110115f, -0.630976f, 0.775802f, -8.25190e-005f, -0.814089f, 0.580740f, 
		-0.701692f, -0.712479f, -0.00114400f, -0.496257f, -0.868176f, -0.000841103f, 
		-0.000131170f, -0.376506f, 0.926414f, -0.000110115f, -0.630976f, 0.775802f, 
		-0.891862f, -0.452305f, -0.00141404f, -0.701692f, -0.712479f, -0.00114400f, 
		-0.000140925f, 0.110275f, 0.993901f, -0.000140795f, -0.109235f, 0.994016f, 
		-0.990493f, 0.137551f, -0.00154903f, -0.990685f, -0.136163f, -0.00154941f, 
		-0.000136405f, 0.271337f, 0.962484f, -0.000140925f, 0.110275f, 0.993901f, 
		-0.943428f, 0.331574f, -0.00150093f, -0.990493f, 0.137551f, -0.00154903f, 
		-0.000141675f, -0.00763058f, 0.999971f, -0.000136405f, 0.271337f, 0.962484f, 
		-0.999954f, -0.00945916f, -0.00161078f, -0.943428f, 0.331574f, -0.00150093f, 
		2.80615e-007f, -0.999998f, -0.00198282f, -0.000141675f, -0.00763058f, 0.999971f, 
		0.00158843f, -0.999999f, 2.03440e-006f, -0.999954f, -0.00945916f, -0.00161078f, 
		-0.000117798f, 0.553545f, 0.832819f, 2.80615e-007f, -0.999998f, -0.00198282f, 
		-0.769574f, 0.638557f, -0.000854680f, 0.00158843f, -0.999999f, 2.03440e-006f, 
		-0.000141969f, -0.0493271f, 0.998783f, -0.000140210f, 0.147080f, 0.989125f, 
		-0.998099f, -0.0616124f, -0.00153804f, -0.983224f, 0.182398f, -0.00149024f, 
		-0.000138266f, -0.227972f, 0.973668f, -0.000141969f, -0.0493271f, 0.998783f, 
		-0.959890f, -0.280373f, -0.00140797f, -0.998099f, -0.0616124f, -0.00153804f, 
		-0.000130875f, -0.388994f, 0.921240f, -0.000138266f, -0.227972f, 0.973668f, 
		-0.884639f, -0.466276f, -0.00115558f, -0.959890f, -0.280373f, -0.00140797f, 
		-1.86771e-005f, -0.991265f, 0.131882f, -5.56366e-005f, -0.919571f, 0.392924f, 
		-0.105902f, -0.994377f, 5.32985e-005f, -0.323722f, -0.946152f, 1.17013e-005f, 
		2.45368e-005f, -0.984955f, -0.172809f, -1.86771e-005f, -0.991265f, 0.131882f, 
		0.139048f, -0.990286f, -0.000139871f, -0.105902f, -0.994377f, 5.32985e-005f, 
		-0.000142171f, 0.00372576f, 0.999993f, 2.45368e-005f, -0.984955f, -0.172809f, 
		-0.999988f, 0.00462848f, 0.00126190f, 0.139048f, -0.990286f, -0.000139871f, 
		-4.38940e-007f, 0.999995f, 0.00309668f, -0.000142171f, 0.00372576f, 0.999993f, 
		-0.00247833f, 0.999997f, 2.57959e-006f, -0.999988f, 0.00462848f, 0.00126190f, 
		6.91256e-005f, -0.873053f, -0.487625f, -1.69445e-006f, -0.999928f, 0.0119763f, 
		0.408497f, -0.912759f, -0.000558714f, -0.00969107f, -0.999953f, 1.25895e-005f, 
		3.01389e-005f, -0.977217f, -0.212241f, 6.91256e-005f, -0.873053f, -0.487625f, 
		0.171215f, -0.985234f, -0.000256793f, 0.408497f, -0.912759f, -0.000558714f, 
		-1.01994e-005f, -0.997426f, 0.0717000f, 3.01389e-005f, -0.977217f, -0.212241f, 
		-0.0574384f, -0.998349f, 9.36597e-005f, 0.171215f, -0.985234f, -0.000256793f, 
		-4.54450e-005f, -0.947542f, 0.319632f, -1.01994e-005f, -0.997426f, 0.0717000f, 
		-0.260543f, -0.965462f, 0.000458644f, -0.0574384f, -0.998349f, 9.36597e-005f, 
		-7.33169e-005f, -0.855911f, 0.517122f, -4.54450e-005f, -0.947542f, 0.319632f, 
		-0.435162f, -0.900352f, 0.000819871f, -0.260543f, -0.965462f, 0.000458644f, 
		-9.52723e-005f, -0.740105f, 0.672491f, -7.33169e-005f, -0.855911f, 0.517122f, 
		-0.588276f, -0.808659f, 0.00117369f, -0.435162f, -0.900352f, 0.000819871f, 
		-0.000112928f, -0.605145f, 0.796115f, -9.52723e-005f, -0.740105f, 0.672491f, 
		-0.725114f, -0.688627f, 0.00151595f, -0.588276f, -0.808659f, 0.00117369f, 
		-0.000138345f, 0.218807f, 0.975768f, -0.000142025f, -0.0367567f, 0.999324f, 
		-0.962852f, 0.270023f, 0.00214351f, -0.998965f, -0.0454238f, 0.00223787f, 
		-0.000124187f, 0.479626f, 0.877473f, -0.000138345f, 0.218807f, 0.975768f, 
		-0.826096f, 0.563526f, 0.00179642f, -0.962852f, 0.270023f, 0.00214351f, 
		-0.000124978f, 0.471681f, 0.881769f, -0.000124187f, 0.479626f, 0.877473f, 
		-0.830998f, 0.556272f, 0.00176024f, -0.826096f, 0.563526f, 0.00179642f, 
		-0.000137510f, 0.244812f, 0.969570f, -0.000124978f, 0.471681f, 0.881769f, 
		-0.953495f, 0.301402f, 0.00198421f, -0.830998f, 0.556272f, 0.00176024f, 
		-0.000129039f, -0.419945f, 0.907550f, -0.000134249f, -0.321005f, 0.947078f, 
		-0.865675f, -0.500604f, 0.00188852f, -0.920701f, -0.390264f, 0.00195679f, 
		-0.000112757f, -0.605524f, 0.795827f, -0.000121902f, -0.514074f, 0.857746f, 
		-0.724598f, -0.689170f, 0.00170231f, -0.800273f, -0.599633f, 0.00180602f, 
		-8.83932e-005f, -0.781358f, 0.624083f, -0.000101843f, -0.694595f, 0.719401f, 
		-0.538346f, -0.842723f, 0.00139243f, -0.637946f, -0.770080f, 0.00156873f, 
		-8.83932e-005f, -0.781358f, 0.624083f, -7.20400e-005f, -0.861198f, 0.508269f, 
		-0.538346f, -0.842723f, 0.00139243f, -0.426949f, -0.904275f, 0.00116646f, 
		0.999964f, -0.00530279f, 0.00669801f, 0.421317f, -0.906909f, 0.00282337f, 
		-0.000141872f, -0.00336983f, 0.999994f, -7.20400e-005f, -0.861198f, 0.508269f, 
		0.999952f, -0.00709288f, 0.00670015f, 0.999964f, -0.00530279f, 0.00669801f, 
		-0.000142190f, -0.00505467f, 0.999987f, -0.000141872f, -0.00336983f, 0.999994f, 
		0.999963f, -0.00534605f, 0.00669814f, 0.999953f, -0.00706656f, 0.00670020f, 
		-0.000141711f, -0.00758215f, 0.999971f, -0.000141873f, -0.00336983f, 0.999994f, 
		0.999953f, -0.00706656f, 0.00670041f, 0.999952f, -0.00709045f, 0.00670038f, 
		-0.000142193f, -0.00505443f, 0.999987f, -0.000141874f, -0.00338122f, 0.999994f, 
		0.999952f, -0.00710417f, 0.00670049f, 0.999953f, -0.00706656f, 0.00670041f, 
		-0.000142193f, -0.00505470f, 0.999987f, -0.000142193f, -0.00505443f, 0.999987f, 
		0.999963f, -0.00532912f, 0.00669839f, 0.999952f, -0.00710417f, 0.00670049f, 
		-0.000141875f, -0.00337008f, 0.999994f, -0.000142193f, -0.00505470f, 0.999987f, 
		-0.999967f, -0.00480083f, -0.00660226f, -0.999974f, -0.00293408f, -0.00660121f, 
		0.000141432f, -0.00382684f, -0.999993f, 0.000141425f, -0.00229128f, -0.999997f, 
		-0.999946f, -0.00797568f, -0.00660073f, -0.999957f, -0.00649993f, -0.00660367f, 
		0.000141948f, -0.00630679f, -0.999980f, 0.000141769f, -0.00505540f, -0.999987f, 
		-0.999925f, -0.0103189f, -0.00659796f, -0.999929f, -0.00992959f, -0.00660029f, 
		0.000141509f, -0.00810649f, -0.999967f, 0.000141653f, -0.00782276f, -0.999969f, 
		-0.999925f, -0.0103202f, -0.00659569f, -0.999925f, -0.0103189f, -0.00659796f, 
		0.000141854f, -0.00810739f, -0.999967f, 0.000141509f, -0.00810649f, -0.999967f, 
		-0.999937f, -0.00911963f, -0.00659815f, -0.999929f, -0.00993033f, -0.00659813f, 
		0.000141893f, -0.00714948f, -0.999974f, 0.000142200f, -0.00784697f, -0.999969f, 
		-0.999947f, -0.00792633f, -0.00659560f, -0.999937f, -0.00911963f, -0.00659815f, 
		0.000141584f, -0.00623730f, -0.999981f, 0.000141893f, -0.00714948f, -0.999974f, 
		0.999962f, -0.00504527f, 0.00715866f, -0.00134997f, 0.999999f, -9.36099e-006f, 
		-0.000141807f, -0.00373381f, 0.999993f, 2.42873e-007f, 0.999999f, -0.00171568f, 
		0.999962f, -0.00505639f, 0.00715874f, 0.999962f, -0.00504527f, 0.00715866f, 
		-0.000141669f, -0.00400477f, 0.999992f, -0.000141807f, -0.00373381f, 0.999993f, 
		0.999964f, -0.00450385f, 0.00715752f, 0.999962f, -0.00504650f, 0.00715898f, 
		-0.000141948f, -0.00453881f, 0.999990f, -0.000141671f, -0.00399997f, 0.999992f, 
		0.999962f, -0.00506734f, 0.00715960f, 0.999962f, -0.00503970f, 0.00715951f, 
		-0.000141676f, -0.00400478f, 0.999992f, -0.000141399f, -0.00453874f, 0.999990f, 
		0.356039f, -0.934468f, 0.00254723f, 0.999962f, -0.00506734f, 0.00715960f, 
		-6.18583e-005f, -0.899965f, 0.435962f, -0.000141676f, -0.00400478f, 0.999992f, 
		0.0835652f, -0.996502f, 0.000597171f, 0.356039f, -0.934468f, 0.00254723f, 
		-1.49935e-005f, -0.994369f, 0.105971f, -6.18583e-005f, -0.899965f, 0.435962f, 
		-0.0187201f, -0.999825f, -0.000133514f, 0.0835652f, -0.996502f, 0.000597171f, 
		3.37612e-006f, -0.999717f, -0.0237927f, -1.49935e-005f, -0.994369f, 0.105971f, 
		-0.0644216f, -0.997923f, -0.000458093f, -0.0187201f, -0.999825f, -0.000133514f, 
		1.16526e-005f, -0.996651f, -0.0817697f, 3.37612e-006f, -0.999717f, -0.0237927f, 
		-0.0835632f, -0.996502f, -0.000592415f, -0.0644216f, -0.997923f, -0.000458093f, 
		1.50610e-005f, -0.994368f, -0.105979f, 1.16526e-005f, -0.996651f, -0.0817697f, 
		-0.0855369f, -0.996335f, -0.000604471f, -0.0835632f, -0.996502f, -0.000592415f, 
		1.53778e-005f, -0.994100f, -0.108469f, 1.50610e-005f, -0.994368f, -0.105979f, 
		-0.0714370f, -0.997445f, -0.000503053f, -0.0855369f, -0.996335f, -0.000604471f, 
		1.28592e-005f, -0.995882f, -0.0906571f, 1.53778e-005f, -0.994100f, -0.108469f, 
		-0.0364533f, -0.999335f, -0.000255806f, -0.0714370f, -0.997445f, -0.000503053f, 
		6.56218e-006f, -0.998927f, -0.0463129f, 1.28592e-005f, -0.995882f, -0.0906571f, 
		0.0354638f, -0.999371f, 0.000248108f, -0.0364533f, -0.999335f, -0.000255806f, 
		-6.38295e-006f, -0.998985f, 0.0450526f, 6.56218e-006f, -0.998927f, -0.0463129f, 
		0.195771f, -0.980649f, 0.00136636f, 0.0354638f, -0.999371f, 0.000248108f, 
		-3.49293e-005f, -0.969287f, 0.245933f, -6.38295e-006f, -0.998985f, 0.0450526f, 
		0.0476245f, -0.998865f, 0.000331437f, 0.0375445f, -0.999295f, 0.000261554f, 
		-8.58932e-006f, -0.998171f, 0.0604571f, -6.76286e-006f, -0.998863f, 0.0476778f, 
		0.0774045f, -0.997000f, 0.000538172f, 0.0476245f, -0.998865f, 0.000331437f, 
		-1.39367e-005f, -0.995162f, 0.0982427f, -8.58932e-006f, -0.998171f, 0.0604571f, 
		0.128538f, -0.991704f, 0.000893272f, 0.0774045f, -0.997000f, 0.000538172f, 
		-2.30385e-005f, -0.986712f, 0.162480f, -1.39367e-005f, -0.995162f, 0.0982427f, 
		0.208955f, -0.977924f, 0.00145118f, 0.128538f, -0.991704f, 0.000893272f, 
		-3.72204e-005f, -0.965043f, 0.262092f, -2.30385e-005f, -0.986712f, 0.162480f, 
		0.326056f, -0.945348f, 0.00226286f, 0.208955f, -0.977924f, 0.00145118f, 
		-5.70828e-005f, -0.915910f, 0.401384f, -3.72204e-005f, -0.965043f, 0.262092f, 
		0.888517f, -0.458803f, 0.00615779f, 0.695326f, -0.718679f, 0.00482119f, 
		-0.000131170f, -0.376506f, 0.926414f, -0.000110115f, -0.630976f, 0.775802f, 
		0.990352f, -0.138407f, 0.00686028f, 0.888517f, -0.458803f, 0.00615779f, 
		-0.000140795f, -0.109235f, 0.994016f, -0.000131170f, -0.376506f, 0.926414f, 
		0.941456f, 0.337071f, 0.00652459f, 0.990155f, 0.139806f, 0.00686044f, 
		-0.000136405f, 0.271337f, 0.962484f, -0.000140925f, 0.110275f, 0.993901f, 
		0.999929f, -0.00967642f, 0.00693048f, 0.941456f, 0.337071f, 0.00652459f, 
		-0.000141675f, -0.00763058f, 0.999971f, -0.000136405f, 0.271337f, 0.962484f, 
		0.901187f, 0.433386f, 0.00623506f, 0.763959f, 0.645244f, 0.00527501f, 
		-0.000132164f, 0.353902f, 0.935282f, -0.000117798f, 0.553545f, 0.832819f, 
		0.318709f, -0.947850f, 0.00218177f, 0.499993f, -0.866023f, 0.00343336f, 
		-5.56366e-005f, -0.919571f, 0.392924f, -8.38853e-005f, -0.806205f, 0.591636f, 
		0.104110f, -0.994566f, 0.000710331f, 0.318709f, -0.947850f, 0.00218177f, 
		-1.86771e-005f, -0.991265f, 0.131882f, -5.56366e-005f, -0.919571f, 0.392924f, 
		-0.136767f, -0.990603f, -0.000929335f, 0.104110f, -0.994566f, 0.000710331f, 
		2.45368e-005f, -0.984955f, -0.172809f, -1.86771e-005f, -0.991265f, 0.131882f, 
		0.999966f, 0.00470075f, 0.00677913f, -0.136767f, -0.990603f, -0.000929335f, 
		-0.000142171f, 0.00372576f, 0.999993f, 2.45368e-005f, -0.984955f, -0.172809f, 
		0.00243701f, 0.999997f, 1.65491e-005f, 0.999966f, 0.00470075f, 0.00677913f, 
		-4.38940e-007f, 0.999995f, 0.00309668f, -0.000142171f, 0.00372576f, 0.999993f, 
		0.999977f, -0.000596040f, 0.00680264f, 0.00243701f, 0.999997f, 1.65491e-005f, 
		-0.000141328f, -0.000661765f, 1.00000f, -4.38940e-007f, 0.999995f, 0.00309668f, 
		0.00942353f, -0.999956f, 6.39904e-005f, 0.999977f, -0.000596040f, 0.00680264f, 
		-1.69445e-006f, -0.999928f, 0.0119763f, -0.000141328f, -0.000661765f, 1.00000f, 
		-0.402177f, -0.915558f, -0.00272499f, 0.00942353f, -0.999956f, 6.39904e-005f, 
		6.91256e-005f, -0.873053f, -0.487625f, -1.69445e-006f, -0.999928f, 0.0119763f, 
		-0.168497f, -0.985701f, -0.00114059f, -0.402177f, -0.915558f, -0.00272499f, 
		3.01389e-005f, -0.977217f, -0.212241f, 6.91256e-005f, -0.873053f, -0.487625f, 
		0.0565025f, -0.998402f, 0.000382007f, -0.168497f, -0.985701f, -0.00114059f, 
		-1.01994e-005f, -0.997426f, 0.0717000f, 3.01389e-005f, -0.977217f, -0.212241f, 
		0.256441f, -0.966558f, 0.00173201f, 0.0565025f, -0.998402f, 0.000382007f, 
		-4.54450e-005f, -0.947542f, 0.319632f, -1.01994e-005f, -0.997426f, 0.0717000f, 
		0.429396f, -0.903112f, 0.00289739f, 0.256441f, -0.966558f, 0.00173201f, 
		-7.33169e-005f, -0.855911f, 0.517122f, -4.54450e-005f, -0.947542f, 0.319632f, 
		0.719390f, -0.694589f, 0.00484769f, 0.581959f, -0.813209f, 0.00392402f, 
		-0.000112928f, -0.605145f, 0.796115f, -9.52723e-005f, -0.740105f, 0.672491f, 
		0.961411f, 0.275038f, 0.00647029f, 0.998877f, -0.0469032f, 0.00672101f, 
		-0.000138345f, 0.218807f, 0.975768f, -0.000142025f, -0.0367567f, 0.999324f, 
		0.821666f, 0.569942f, 0.00553096f, 0.961411f, 0.275038f, 0.00647029f, 
		-0.000124187f, 0.479626f, 0.877473f, -0.000138345f, 0.218807f, 0.975768f, 
		0.951948f, 0.306193f, 0.00641429f, 0.827037f, 0.562119f, 0.00556863f, 
		-0.000137510f, 0.244812f, 0.969570f, -0.000124978f, 0.471681f, 0.881769f, 
		0.997035f, 0.0766570f, 0.00672078f, 0.951948f, 0.306193f, 0.00641429f, 
		-0.000141525f, 0.0616743f, 0.998096f, -0.000137510f, 0.244812f, 0.969570f, 
		0.993700f, -0.111870f, 0.00669660f, 0.997035f, 0.0766570f, 0.00672078f, 
		-0.000141548f, -0.0892649f, 0.996008f, -0.000141525f, 0.0616743f, 0.998096f, 
		0.795529f, -0.605891f, 0.00535390f, 0.861984f, -0.506902f, 0.00580354f, 
		-0.000121902f, -0.514074f, 0.857746f, -0.000129039f, -0.419945f, 0.907550f, 
		0.719011f, -0.694982f, 0.00483498f, 0.795529f, -0.605891f, 0.00535390f, 
		-0.000112757f, -0.605524f, 0.795827f, -0.000121902f, -0.514074f, 0.857746f, 
		0.999952f, -0.00709288f, 0.00670015f, 0.999964f, -0.00530279f, 0.00669801f, 
		0.999952f, -0.00707785f, 0.00670016f, 0.999952f, -0.00709288f, 0.00670015f, 
		0.999953f, -0.00706656f, 0.00670020f, 0.999952f, -0.00707785f, 0.00670016f, 
		0.999963f, -0.00534605f, 0.00669814f, 0.999953f, -0.00706656f, 0.00670020f, 
		0.999964f, -0.00530279f, 0.00669822f, 0.999963f, -0.00534605f, 0.00669814f, 
		0.999952f, -0.00710417f, 0.00670037f, 0.999964f, -0.00530279f, 0.00669822f, 
		0.999952f, -0.00709045f, 0.00670038f, 0.999952f, -0.00710417f, 0.00670037f, 
		0.999953f, -0.00706656f, 0.00670041f, 0.999952f, -0.00709045f, 0.00670038f, 
		0.999952f, -0.00710417f, 0.00670049f, 0.999953f, -0.00706656f, 0.00670041f, 
		0.999963f, -0.00532912f, 0.00669839f, 0.999952f, -0.00710417f, 0.00670049f, 
		0.999952f, -0.00708347f, 0.00669611f, 0.999963f, -0.00532912f, 0.00669839f, 
		0.839428f, 0.543441f, 0.00567822f, 0.117079f, 0.993122f, 0.000787285f, 
		0.451033f, -0.892502f, 0.00303691f, 0.839428f, 0.543441f, 0.00567822f, 
		-0.999978f, -0.000919052f, -0.00660304f, -0.394952f, -0.918698f, -0.00262488f, 
		-0.999974f, -0.00293408f, -0.00660121f, -0.999978f, -0.000919052f, -0.00660304f, 
		-0.999967f, -0.00480083f, -0.00660226f, -0.999974f, -0.00293408f, -0.00660121f, 
		-0.999957f, -0.00649993f, -0.00660367f, -0.999967f, -0.00480083f, -0.00660226f, 
		-0.999946f, -0.00797568f, -0.00660073f, -0.999957f, -0.00649993f, -0.00660367f, 
		-0.999937f, -0.00912093f, -0.00660043f, -0.999946f, -0.00797568f, -0.00660073f, 
		-0.999929f, -0.00992959f, -0.00660029f, -0.999937f, -0.00912093f, -0.00660043f, 
		-0.999925f, -0.0103189f, -0.00659796f, -0.999929f, -0.00992959f, -0.00660029f, 
		-0.999925f, -0.0103202f, -0.00659569f, -0.999925f, -0.0103189f, -0.00659796f, 
		-0.999929f, -0.00993033f, -0.00659813f, -0.999925f, -0.0103202f, -0.00659569f, 
		-0.999937f, -0.00911963f, -0.00659815f, -0.999929f, -0.00993033f, -0.00659813f, 
		-0.999947f, -0.00792633f, -0.00659560f, -0.999937f, -0.00911963f, -0.00659815f, 
		0.999962f, -0.00505639f, 0.00715874f, 0.999962f, -0.00504527f, 0.00715866f, 
		0.999962f, -0.00505065f, 0.00715882f, 0.999962f, -0.00505639f, 0.00715874f, 
		0.999962f, -0.00505448f, 0.00715890f, 0.999962f, -0.00505065f, 0.00715882f, 
		0.999962f, -0.00504650f, 0.00715898f, 0.999962f, -0.00505448f, 0.00715890f, 
		0.999964f, -0.00450385f, 0.00715752f, 0.999962f, -0.00504650f, 0.00715898f, 
		0.999959f, -0.00560128f, 0.00715756f, 0.999964f, -0.00450385f, 0.00715752f, 
		0.999962f, -0.00505639f, 0.00715922f, 0.999959f, -0.00560128f, 0.00715756f, 
		0.999962f, -0.00505178f, 0.00715932f, 0.999962f, -0.00505639f, 0.00715922f, 
		0.999964f, -0.00449762f, 0.00715785f, 0.999962f, -0.00505178f, 0.00715932f, 
		0.999962f, -0.00503970f, 0.00715951f, 0.999964f, -0.00449762f, 0.00715785f, 
		0.999962f, -0.00506734f, 0.00715960f, 0.999962f, -0.00503970f, 0.00715951f, 
		0.0835652f, -0.996502f, 0.000597171f, 0.356039f, -0.934468f, 0.00254723f, 
		-0.0187201f, -0.999825f, -0.000133514f, 0.0835652f, -0.996502f, 0.000597171f, 
		-0.0644216f, -0.997923f, -0.000458093f, -0.0187201f, -0.999825f, -0.000133514f, 
		-0.0835632f, -0.996502f, -0.000592415f, -0.0644216f, -0.997923f, -0.000458093f, 
		-0.0855369f, -0.996335f, -0.000604471f, -0.0835632f, -0.996502f, -0.000592415f, 
		-0.0714370f, -0.997445f, -0.000503053f, -0.0855369f, -0.996335f, -0.000604471f, 
		-0.0364533f, -0.999335f, -0.000255806f, -0.0714370f, -0.997445f, -0.000503053f, 
		0.0354638f, -0.999371f, 0.000248108f, -0.0364533f, -0.999335f, -0.000255806f, 
		0.195771f, -0.980649f, 0.00136636f, 0.0354638f, -0.999371f, 0.000248108f, 
		0.614340f, -0.789030f, 0.00428111f, 0.195771f, -0.980649f, 0.00136636f, 
		0.984931f, 0.172812f, 0.00686202f, 0.614340f, -0.789030f, 0.00428111f, 
		0.0476245f, -0.998865f, 0.000331437f, 0.0375445f, -0.999295f, 0.000261554f, 
		0.0774045f, -0.997000f, 0.000538172f, 0.0476245f, -0.998865f, 0.000331437f, 
		0.128538f, -0.991704f, 0.000893272f, 0.0774045f, -0.997000f, 0.000538172f, 
		0.208955f, -0.977924f, 0.00145118f, 0.128538f, -0.991704f, 0.000893272f, 
		0.326056f, -0.945348f, 0.00226286f, 0.208955f, -0.977924f, 0.00145118f, 
		0.489208f, -0.872160f, 0.00339316f, 0.326056f, -0.945348f, 0.00226286f, 
		0.695326f, -0.718679f, 0.00482119f, 0.489208f, -0.872160f, 0.00339316f, 
		0.888517f, -0.458803f, 0.00615779f, 0.695326f, -0.718679f, 0.00482119f, 
		0.990352f, -0.138407f, 0.00686028f, 0.888517f, -0.458803f, 0.00615779f, 
		0.990155f, 0.139806f, 0.00686044f, 0.990352f, -0.138407f, 0.00686028f, 
		0.941456f, 0.337071f, 0.00652459f, 0.990155f, 0.139806f, 0.00686044f, 
		0.999929f, -0.00967642f, 0.00693048f, 0.941456f, 0.337071f, 0.00652459f, 
		0.763959f, 0.645244f, 0.00527501f, -0.00156030f, -0.999999f, -1.07894e-005f, 
		0.901187f, 0.433386f, 0.00623506f, 0.763959f, 0.645244f, 0.00527501f, 
		0.982588f, 0.185671f, 0.00680594f, 0.901187f, 0.433386f, 0.00623506f, 
		0.998005f, -0.0627600f, 0.00691336f, 0.982588f, 0.185671f, 0.00680594f, 
		0.958457f, -0.285159f, 0.00663569f, 0.998005f, -0.0627600f, 0.00691336f, 
		0.881157f, -0.472785f, 0.00609362f, 0.958457f, -0.285159f, 0.00663569f, 
		0.777458f, -0.628911f, 0.00536615f, 0.881157f, -0.472785f, 0.00609362f, 
		0.651298f, -0.758809f, 0.00448472f, 0.777458f, -0.628911f, 0.00536615f, 
		0.499993f, -0.866023f, 0.00343336f, 0.651298f, -0.758809f, 0.00448472f, 
		0.318709f, -0.947850f, 0.00218177f, 0.499993f, -0.866023f, 0.00343336f, 
		0.104110f, -0.994566f, 0.000710331f, 0.318709f, -0.947850f, 0.00218177f, 
		-0.136767f, -0.990603f, -0.000929335f, 0.104110f, -0.994566f, 0.000710331f, 
		0.00243701f, 0.999997f, 1.65491e-005f, 0.999966f, 0.00470075f, 0.00677913f, 
		0.00942353f, -0.999956f, 6.39904e-005f, 0.999977f, -0.000596040f, 0.00680264f, 
		-0.402177f, -0.915558f, -0.00272499f, 0.00942353f, -0.999956f, 6.39904e-005f, 
		-0.168497f, -0.985701f, -0.00114059f, -0.402177f, -0.915558f, -0.00272499f, 
		0.0565025f, -0.998402f, 0.000382007f, -0.168497f, -0.985701f, -0.00114059f, 
		0.256441f, -0.966558f, 0.00173201f, 0.0565025f, -0.998402f, 0.000382007f, 
		0.429396f, -0.903112f, 0.00289739f, 0.256441f, -0.966558f, 0.00173201f, 
		0.581959f, -0.813209f, 0.00392402f, 0.429396f, -0.903112f, 0.00289739f, 
		0.719390f, -0.694589f, 0.00484769f, 0.581959f, -0.813209f, 0.00392402f, 
		0.843158f, -0.537635f, 0.00567786f, 0.719390f, -0.694589f, 0.00484769f, 
		0.945560f, -0.325385f, 0.00636391f, 0.843158f, -0.537635f, 0.00567786f, 
		0.998877f, -0.0469032f, 0.00672101f, 0.945560f, -0.325385f, 0.00636391f, 
		0.961411f, 0.275038f, 0.00647029f, 0.998877f, -0.0469032f, 0.00672101f, 
		0.821666f, 0.569942f, 0.00553096f, 0.961411f, 0.275038f, 0.00647029f, 
		0.827037f, 0.562119f, 0.00556863f, 0.821666f, 0.569942f, 0.00553096f, 
		0.951948f, 0.306193f, 0.00641429f, 0.827037f, 0.562119f, 0.00556863f, 
		0.997035f, 0.0766570f, 0.00672078f, 0.951948f, 0.306193f, 0.00641429f, 
		0.993700f, -0.111870f, 0.00669660f, 0.997035f, 0.0766570f, 0.00672078f, 
		0.963832f, -0.266433f, 0.00649357f, 0.993700f, -0.111870f, 0.00669660f, 
		0.918468f, -0.395448f, 0.00618605f, 0.963832f, -0.266433f, 0.00649357f, 
		0.861984f, -0.506902f, 0.00580354f, 0.918468f, -0.395448f, 0.00618605f, 
		0.795529f, -0.605891f, 0.00535390f, 0.861984f, -0.506902f, 0.00580354f, 
		0.719011f, -0.694982f, 0.00483498f, 0.795529f, -0.605891f, 0.00535390f, 
		0.631594f, -0.775288f, 0.00424323f, 0.719011f, -0.694982f, 0.00483498f, 
		0.532232f, -0.846591f, 0.00357199f, 0.631594f, -0.775288f, 0.00424323f, 
		0.532232f, -0.846591f, 0.00357199f, 0.421317f, -0.906909f, 0.00282337f, 
		-0.999970f, -0.00716543f, 0.00280994f, -0.426949f, -0.904275f, 0.00116646f, 
		0.999964f, -0.00530279f, 0.00669801f, 0.421317f, -0.906909f, 0.00282337f, 
		0.999952f, -0.00707785f, 0.00670016f, 0.999952f, -0.00709288f, 0.00670015f, 
		-0.000142191f, -0.00505446f, 0.999987f, -0.000142190f, -0.00505467f, 0.999987f, 
		0.999953f, -0.00706656f, 0.00670020f, 0.999952f, -0.00707785f, 0.00670016f, 
		-0.000141873f, -0.00336983f, 0.999994f, -0.000142191f, -0.00505446f, 0.999987f, 
		0.999964f, -0.00530279f, 0.00669822f, 0.999963f, -0.00534605f, 0.00669814f, 
		-0.000141555f, -0.00336983f, 0.999994f, -0.000141711f, -0.00758215f, 0.999971f, 
		0.999952f, -0.00710417f, 0.00670037f, 0.999964f, -0.00530279f, 0.00669822f, 
		-0.000141711f, -0.00758193f, 0.999971f, -0.000141555f, -0.00336983f, 0.999994f, 
		0.999952f, -0.00709045f, 0.00670038f, 0.999952f, -0.00710417f, 0.00670037f, 
		-0.000141874f, -0.00338122f, 0.999994f, -0.000141711f, -0.00758193f, 0.999971f, 
		0.999952f, -0.00708347f, 0.00669611f, 0.999963f, -0.00532912f, 0.00669839f, 
		-0.000141713f, -0.00758190f, 0.999971f, -0.000141875f, -0.00337008f, 0.999994f, 
		0.117079f, 0.993122f, 0.000787285f, 0.999952f, -0.00708347f, 0.00669611f, 
		-2.10521e-005f, 0.988963f, 0.148161f, -0.000141713f, -0.00758190f, 0.999971f, 
		-2.10521e-005f, 0.988963f, 0.148161f, -0.000141713f, -0.00758190f, 0.999971f, 
		-0.118990f, 0.992895f, 0.000275023f, -0.999983f, -0.00506415f, 0.00281228f, 
		-0.000141713f, -0.00758190f, 0.999971f, -0.000141875f, -0.00337008f, 0.999994f, 
		-0.999983f, -0.00506415f, 0.00281228f, -0.999970f, -0.00716543f, 0.00281011f, 
		-0.000142193f, -0.00505470f, 0.999987f, -0.000142193f, -0.00505443f, 0.999987f, 
		-0.999972f, -0.00695483f, 0.00280984f, -0.999982f, -0.00527476f, 0.00281197f, 
		-0.000141555f, -0.00336983f, 0.999994f, -0.000141711f, -0.00758215f, 0.999971f, 
		-0.999970f, -0.00716543f, 0.00280949f, -0.999972f, -0.00695957f, 0.00280974f, 
		-0.000141711f, -0.00758215f, 0.999971f, -0.000141873f, -0.00336983f, 0.999994f, 
		-0.999972f, -0.00695957f, 0.00280974f, -0.999970f, -0.00716543f, 0.00280998f, 
		-0.000141873f, -0.00336983f, 0.999994f, -0.000142191f, -0.00505446f, 0.999987f, 
		-0.999970f, -0.00716543f, 0.00280998f, -0.999990f, -0.00358515f, 0.00280976f, 
		-0.000142191f, -0.00505446f, 0.999987f, -0.000142190f, -0.00505467f, 0.999987f, 
		-0.999990f, -0.00358515f, 0.00280976f, -0.999972f, -0.00695957f, 0.00280969f, 
		-0.000142190f, -0.00505467f, 0.999987f, -0.000141872f, -0.00336983f, 0.999994f, 
		-0.999972f, -0.00695957f, 0.00280969f, -0.999970f, -0.00716543f, 0.00280994f, 
		-0.118990f, 0.992895f, 0.000275023f, -0.999983f, -0.00506415f, 0.00281228f, 
		0.117079f, 0.993122f, 0.000787285f, 0.999952f, -0.00708347f, 0.00669611f, 
		-0.843595f, 0.536978f, 0.00132626f, -0.118990f, 0.992895f, 0.000275023f, 
		-0.000126653f, 0.453901f, 0.891052f, -2.10521e-005f, 0.988963f, 0.148161f, 
		-0.843595f, 0.536978f, 0.00132626f, -0.118990f, 0.992895f, 0.000275023f, 
		0.839428f, 0.543441f, 0.00567822f, 0.117079f, 0.993122f, 0.000787285f, 
		-0.000126653f, 0.453901f, 0.891052f, -2.10521e-005f, 0.988963f, 0.148161f, 
		-0.394952f, -0.918698f, -0.00262488f, 0.451033f, -0.892502f, 0.00303691f, 
		6.82096e-005f, -0.877589f, -0.479413f, -7.66865e-005f, -0.841418f, 0.540385f, 
		-0.999978f, -0.000919052f, -0.00660304f, -0.394952f, -0.918698f, -0.00262488f, 
		0.000141910f, -0.000695031f, -1.00000f, 6.82096e-005f, -0.877589f, -0.479413f, 
		-0.999974f, -0.00293408f, -0.00660121f, -0.999978f, -0.000919052f, -0.00660304f, 
		0.000141425f, -0.00229128f, -0.999997f, 0.000141910f, -0.000695031f, -1.00000f, 
		-0.999957f, -0.00649993f, -0.00660367f, -0.999967f, -0.00480083f, -0.00660226f, 
		0.000141769f, -0.00505540f, -0.999987f, 0.000141432f, -0.00382684f, -0.999993f, 
		-0.999937f, -0.00912093f, -0.00660043f, -0.999946f, -0.00797568f, -0.00660073f, 
		0.000141801f, -0.00719752f, -0.999974f, 0.000141948f, -0.00630679f, -0.999980f, 
		-0.999929f, -0.00992959f, -0.00660029f, -0.999937f, -0.00912093f, -0.00660043f, 
		0.000141653f, -0.00782276f, -0.999969f, 0.000141801f, -0.00719752f, -0.999974f, 
		-0.999929f, -0.00993033f, -0.00659813f, -0.999925f, -0.0103202f, -0.00659569f, 
		0.000142200f, -0.00784697f, -0.999969f, 0.000141854f, -0.00810739f, -0.999967f, 
		-0.00134997f, 0.999999f, -9.36099e-006f, -0.999947f, -0.00792633f, -0.00659560f, 
		2.42873e-007f, 0.999999f, -0.00171568f, 0.000141584f, -0.00623730f, -0.999981f, 
		2.42873e-007f, 0.999999f, -0.00171568f, 0.000141584f, -0.00623730f, -0.999981f, 
		0.00137463f, 0.999999f, 2.28795e-006f, 0.999958f, -0.00782872f, -0.00475166f, 
		0.000141584f, -0.00623730f, -0.999981f, 0.000141893f, -0.00714948f, -0.999974f, 
		0.999958f, -0.00782872f, -0.00475166f, 0.999949f, -0.00896538f, -0.00474306f, 
		0.000141893f, -0.00714948f, -0.999974f, 0.000142200f, -0.00784697f, -0.999969f, 
		0.999949f, -0.00896538f, -0.00474306f, 0.999942f, -0.00971221f, -0.00473208f, 
		0.000141854f, -0.00810739f, -0.999967f, 0.000141509f, -0.00810649f, -0.999967f, 
		0.999937f, -0.0102136f, -0.00471593f, 0.999937f, -0.0102135f, -0.00470459f, 
		0.000141948f, -0.00630679f, -0.999980f, 0.000141769f, -0.00505540f, -0.999987f, 
		0.999958f, -0.00786931f, -0.00467171f, 0.999969f, -0.00640436f, -0.00466062f, 
		0.000141769f, -0.00505540f, -0.999987f, 0.000141432f, -0.00382684f, -0.999993f, 
		0.999969f, -0.00640436f, -0.00466062f, 0.999978f, -0.00475435f, -0.00465737f, 
		0.000141432f, -0.00382684f, -0.999993f, 0.000141425f, -0.00229128f, -0.999997f, 
		0.999978f, -0.00475435f, -0.00465737f, 0.999985f, -0.00288521f, -0.00465217f, 
		0.000141425f, -0.00229128f, -0.999997f, 0.000141910f, -0.000695031f, -1.00000f, 
		0.999985f, -0.00288521f, -0.00465217f, 0.999989f, -0.000875229f, -0.00464929f, 
		6.82096e-005f, -0.877589f, -0.479413f, -7.66865e-005f, -0.841418f, 0.540385f, 
		0.400247f, -0.916406f, -0.00151673f, -0.456983f, -0.889475f, 0.000971267f, 
		0.451033f, -0.892502f, 0.00303691f, 0.839428f, 0.543441f, 0.00567822f, 
		-7.66865e-005f, -0.841418f, 0.540385f, -0.000126653f, 0.453901f, 0.891052f, 
		0.00137463f, 0.999999f, 2.28795e-006f, 0.999958f, -0.00782872f, -0.00475166f, 
		-0.00134997f, 0.999999f, -9.36099e-006f, -0.999947f, -0.00792633f, -0.00659560f, 
		-0.394952f, -0.918698f, -0.00262488f, 0.451033f, -0.892502f, 0.00303691f, 
		-0.456983f, -0.889475f, 0.000971267f, -0.843595f, 0.536978f, 0.00132626f, 
		-7.66865e-005f, -0.841418f, 0.540385f, -0.000126653f, 0.453901f, 0.891052f, 
		-0.456983f, -0.889475f, 0.000971267f, -0.843595f, 0.536978f, 0.00132626f, 
		-0.999972f, -0.00445440f, -0.00596881f, 0.00137463f, 0.999999f, 2.28795e-006f, 
		0.999962f, -0.00504527f, 0.00715866f, -0.00134997f, 0.999999f, -9.36099e-006f, 
		0.999962f, -0.00505065f, 0.00715882f, 0.999962f, -0.00505639f, 0.00715874f, 
		-0.000141670f, -0.00400477f, 0.999992f, -0.000141669f, -0.00400477f, 0.999992f, 
		0.999962f, -0.00505448f, 0.00715890f, 0.999962f, -0.00505065f, 0.00715882f, 
		-0.000141809f, -0.00373779f, 0.999993f, -0.000141670f, -0.00400477f, 0.999992f, 
		0.999962f, -0.00504650f, 0.00715898f, 0.999962f, -0.00505448f, 0.00715890f, 
		-0.000141671f, -0.00399997f, 0.999992f, -0.000141809f, -0.00373779f, 0.999993f, 
		0.999959f, -0.00560128f, 0.00715756f, 0.999964f, -0.00450385f, 0.00715752f, 
		-0.000142088f, -0.00320375f, 0.999995f, -0.000141948f, -0.00453881f, 0.999990f, 
		0.999962f, -0.00505639f, 0.00715922f, 0.999959f, -0.00560128f, 0.00715756f, 
		-0.000141950f, -0.00453866f, 0.999990f, -0.000142088f, -0.00320375f, 0.999995f, 
		0.999962f, -0.00505178f, 0.00715932f, 0.999962f, -0.00505639f, 0.00715922f, 
		-0.000141673f, -0.00400272f, 0.999992f, -0.000141950f, -0.00453866f, 0.999990f, 
		0.999964f, -0.00449762f, 0.00715785f, 0.999962f, -0.00505178f, 0.00715932f, 
		-0.000141536f, -0.00320211f, 0.999995f, -0.000141673f, -0.00400272f, 0.999992f, 
		0.999962f, -0.00503970f, 0.00715951f, 0.999964f, -0.00449762f, 0.00715785f, 
		-0.000141399f, -0.00453874f, 0.999990f, -0.000141536f, -0.00320211f, 0.999995f, 
		0.356039f, -0.934468f, 0.00254723f, 0.999962f, -0.00506734f, 0.00715960f, 
		-0.000141669f, -0.00400477f, 0.999992f, -0.000141807f, -0.00373381f, 0.999993f, 
		-0.999967f, -0.00559698f, -0.00596865f, -0.999972f, -0.00445440f, -0.00596881f, 
		-0.000141948f, -0.00453881f, 0.999990f, -0.000141671f, -0.00399997f, 0.999992f, 
		-0.999969f, -0.00505826f, -0.00596743f, -0.999969f, -0.00505378f, -0.00596735f, 
		-0.000141536f, -0.00320211f, 0.999995f, -0.000141673f, -0.00400272f, 0.999992f, 
		-0.999970f, -0.00499630f, -0.00596788f, -0.999969f, -0.00505605f, -0.00596763f, 
		-0.000141399f, -0.00453874f, 0.999990f, -0.000141536f, -0.00320211f, 0.999995f, 
		-0.999970f, -0.00499311f, -0.00596794f, -0.999970f, -0.00499630f, -0.00596788f, 
		-0.000141676f, -0.00400478f, 0.999992f, -0.000141399f, -0.00453874f, 0.999990f, 
		-0.999972f, -0.00452432f, -0.00596633f, -0.999970f, -0.00499311f, -0.00596794f, 
		-0.362250f, -0.932079f, -0.00213607f, -0.999972f, -0.00452432f, -0.00596633f, 
		0.614340f, -0.789030f, 0.00428111f, 0.195771f, -0.980649f, 0.00136636f, 
		-0.000100135f, -0.710897f, 0.703296f, -3.49293e-005f, -0.969287f, 0.245933f, 
		0.984931f, 0.172812f, 0.00686202f, 0.614340f, -0.789030f, 0.00428111f, 
		-0.000140726f, 0.137009f, 0.990570f, -0.000100135f, -0.710897f, 0.703296f, 
		0.0375445f, -0.999295f, 0.000261554f, 0.984931f, 0.172812f, 0.00686202f, 
		-6.76286e-006f, -0.998863f, 0.0476778f, -0.000140726f, 0.137009f, 0.990570f, 
		-6.76286e-006f, -0.998863f, 0.0476778f, -0.000140726f, 0.137009f, 0.990570f, 
		-0.0382359f, -0.999269f, -8.60458e-005f, -0.985447f, 0.169968f, -0.00224969f, 
		0.0375445f, -0.999295f, 0.000261554f, 0.984931f, 0.172812f, 0.00686202f, 
		0.00158843f, -0.999999f, 2.03440e-006f, -0.999954f, -0.00945916f, -0.00161078f, 
		-0.000140795f, -0.109235f, 0.994016f, -0.000131170f, -0.376506f, 0.926414f, 
		-0.990685f, -0.136163f, -0.00154941f, -0.891862f, -0.452305f, -0.00141404f, 
		-8.25190e-005f, -0.814089f, 0.580740f, -5.70828e-005f, -0.915910f, 0.401384f, 
		-0.496257f, -0.868176f, -0.000841103f, -0.331170f, -0.943571f, -0.000586575f, 
		-0.00156030f, -0.999999f, -1.07894e-005f, 0.999929f, -0.00967642f, 0.00693048f, 
		2.80615e-007f, -0.999998f, -0.00198282f, -0.000141675f, -0.00763058f, 0.999971f, 
		0.990155f, 0.139806f, 0.00686044f, 0.990352f, -0.138407f, 0.00686028f, 
		-0.000140925f, 0.110275f, 0.993901f, -0.000140795f, -0.109235f, 0.994016f, 
		0.695326f, -0.718679f, 0.00482119f, 0.489208f, -0.872160f, 0.00339316f, 
		-0.000110115f, -0.630976f, 0.775802f, -8.25190e-005f, -0.814089f, 0.580740f, 
		0.489208f, -0.872160f, 0.00339316f, 0.326056f, -0.945348f, 0.00226286f, 
		-8.25190e-005f, -0.814089f, 0.580740f, -5.70828e-005f, -0.915910f, 0.401384f, 
		-0.00156030f, -0.999999f, -1.07894e-005f, 0.999929f, -0.00967642f, 0.00693048f, 
		0.763959f, 0.645244f, 0.00527501f, -0.00156030f, -0.999999f, -1.07894e-005f, 
		-0.000117798f, 0.553545f, 0.832819f, 2.80615e-007f, -0.999998f, -0.00198282f, 
		0.982588f, 0.185671f, 0.00680594f, 0.901187f, 0.433386f, 0.00623506f, 
		-0.000140210f, 0.147080f, 0.989125f, -0.000132164f, 0.353902f, 0.935282f, 
		0.998005f, -0.0627600f, 0.00691336f, 0.982588f, 0.185671f, 0.00680594f, 
		-0.000141969f, -0.0493271f, 0.998783f, -0.000140210f, 0.147080f, 0.989125f, 
		0.958457f, -0.285159f, 0.00663569f, 0.998005f, -0.0627600f, 0.00691336f, 
		-0.000138266f, -0.227972f, 0.973668f, -0.000141969f, -0.0493271f, 0.998783f, 
		0.881157f, -0.472785f, 0.00609362f, 0.958457f, -0.285159f, 0.00663569f, 
		-0.000130875f, -0.388994f, 0.921240f, -0.000138266f, -0.227972f, 0.973668f, 
		0.777458f, -0.628911f, 0.00536615f, 0.881157f, -0.472785f, 0.00609362f, 
		-0.000119783f, -0.536978f, 0.843596f, -0.000130875f, -0.388994f, 0.921240f, 
		0.651298f, -0.758809f, 0.00448472f, 0.777458f, -0.628911f, 0.00536615f, 
		-0.000104480f, -0.675843f, 0.737046f, -0.000119783f, -0.536978f, 0.843596f, 
		0.499993f, -0.866023f, 0.00343336f, 0.651298f, -0.758809f, 0.00448472f, 
		-8.38853e-005f, -0.806205f, 0.591636f, -0.000104480f, -0.675843f, 0.737046f, 
		-0.000132164f, 0.353902f, 0.935282f, -0.000117798f, 0.553545f, 0.832819f, 
		-0.904204f, 0.427098f, -0.00124405f, -0.769574f, 0.638557f, -0.000854680f, 
		-0.000140210f, 0.147080f, 0.989125f, -0.000132164f, 0.353902f, 0.935282f, 
		-0.983224f, 0.182398f, -0.00149024f, -0.904204f, 0.427098f, -0.00124405f, 
		-0.000119783f, -0.536978f, 0.843596f, -0.000130875f, -0.388994f, 0.921240f, 
		-0.782925f, -0.622115f, -0.000835744f, -0.884639f, -0.466276f, -0.00115558f, 
		-0.000104480f, -0.675843f, 0.737046f, -0.000119783f, -0.536978f, 0.843596f, 
		-0.657902f, -0.753104f, -0.000499898f, -0.782925f, -0.622115f, -0.000835744f, 
		-8.38853e-005f, -0.806205f, 0.591636f, -0.000104480f, -0.675843f, 0.737046f, 
		-0.506589f, -0.862188f, -0.000196669f, -0.657902f, -0.753104f, -0.000499898f, 
		-5.56366e-005f, -0.919571f, 0.392924f, -8.38853e-005f, -0.806205f, 0.591636f, 
		-0.323722f, -0.946152f, 1.17013e-005f, -0.506589f, -0.862188f, -0.000196669f, 
		-0.999988f, 0.00462848f, 0.00126190f, 0.139048f, -0.990286f, -0.000139871f, 
		0.999966f, 0.00470075f, 0.00677913f, -0.136767f, -0.990603f, -0.000929335f, 
		-0.00247833f, 0.999997f, 2.57959e-006f, -0.999988f, 0.00462848f, 0.00126190f, 
		-0.000141328f, -0.000661765f, 1.00000f, -4.38940e-007f, 0.999995f, 0.00309668f, 
		-0.999999f, -0.000803828f, 0.000827206f, -0.00247833f, 0.999997f, 2.57959e-006f, 
		0.999977f, -0.000596040f, 0.00680264f, 0.00243701f, 0.999997f, 1.65491e-005f, 
		-1.69445e-006f, -0.999928f, 0.0119763f, -0.000141328f, -0.000661765f, 1.00000f, 
		-0.00969107f, -0.999953f, 1.25895e-005f, -0.999999f, -0.000803828f, 0.000827206f, 
		-0.000141872f, -0.00336983f, 0.999994f, -7.20400e-005f, -0.861198f, 0.508269f, 
		-0.999970f, -0.00716543f, 0.00280994f, -0.426949f, -0.904275f, 0.00116646f, 
		-0.000101843f, -0.694595f, 0.719401f, -0.000112757f, -0.605524f, 0.795827f, 
		-0.637946f, -0.770080f, 0.00156873f, -0.724598f, -0.689170f, 0.00170231f, 
		-0.000121902f, -0.514074f, 0.857746f, -0.000129039f, -0.419945f, 0.907550f, 
		-0.800273f, -0.599633f, 0.00180602f, -0.865675f, -0.500604f, 0.00188852f, 
		-0.000134249f, -0.321005f, 0.947078f, -0.000138759f, -0.212294f, 0.977206f, 
		-0.920701f, -0.390264f, 0.00195679f, -0.965020f, -0.262169f, 0.00201260f, 
		-0.000138759f, -0.212294f, 0.977206f, -0.000141548f, -0.0892649f, 0.996008f, 
		-0.965020f, -0.262169f, 0.00201260f, -0.993900f, -0.110266f, 0.00205211f, 
		-0.000141548f, -0.0892649f, 0.996008f, -0.000141525f, 0.0616743f, 0.998096f, 
		-0.993900f, -0.110266f, 0.00205211f, -0.997102f, 0.0760538f, 0.00205651f, 
		-0.000141525f, 0.0616743f, 0.998096f, -0.000137510f, 0.244812f, 0.969570f, 
		-0.997102f, 0.0760538f, 0.00205651f, -0.953495f, 0.301402f, 0.00198421f, 
		-0.000142025f, -0.0367567f, 0.999324f, -0.000136839f, -0.261329f, 0.965250f, 
		-0.998965f, -0.0454238f, 0.00223787f, -0.947251f, -0.320485f, 0.00210205f, 
		-0.000136839f, -0.261329f, 0.965250f, -0.000126676f, -0.447769f, 0.894149f, 
		-0.947251f, -0.320485f, 0.00210205f, -0.847032f, -0.531539f, 0.00183601f, 
		-0.000126676f, -0.447769f, 0.894149f, -0.000112928f, -0.605145f, 0.796115f, 
		-0.847032f, -0.531539f, 0.00183601f, -0.725114f, -0.688627f, 0.00151595f, 
		0.532232f, -0.846591f, 0.00357199f, 0.421317f, -0.906909f, 0.00282337f, 
		-8.83932e-005f, -0.781358f, 0.624083f, -7.20400e-005f, -0.861198f, 0.508269f, 
		0.532232f, -0.846591f, 0.00357199f, 0.631594f, -0.775288f, 0.00424323f, 
		-8.83932e-005f, -0.781358f, 0.624083f, -0.000101843f, -0.694595f, 0.719401f, 
		0.631594f, -0.775288f, 0.00424323f, 0.719011f, -0.694982f, 0.00483498f, 
		-0.000101843f, -0.694595f, 0.719401f, -0.000112757f, -0.605524f, 0.795827f, 
		0.861984f, -0.506902f, 0.00580354f, 0.918468f, -0.395448f, 0.00618605f, 
		-0.000129039f, -0.419945f, 0.907550f, -0.000134249f, -0.321005f, 0.947078f, 
		0.918468f, -0.395448f, 0.00618605f, 0.963832f, -0.266433f, 0.00649357f, 
		-0.000134249f, -0.321005f, 0.947078f, -0.000138759f, -0.212294f, 0.977206f, 
		0.963832f, -0.266433f, 0.00649357f, 0.993700f, -0.111870f, 0.00669660f, 
		-0.000138759f, -0.212294f, 0.977206f, -0.000141548f, -0.0892649f, 0.996008f, 
		0.827037f, 0.562119f, 0.00556863f, 0.821666f, 0.569942f, 0.00553096f, 
		-0.000124978f, 0.471681f, 0.881769f, -0.000124187f, 0.479626f, 0.877473f, 
		0.998877f, -0.0469032f, 0.00672101f, 0.945560f, -0.325385f, 0.00636391f, 
		-0.000142025f, -0.0367567f, 0.999324f, -0.000136839f, -0.261329f, 0.965250f, 
		0.945560f, -0.325385f, 0.00636391f, 0.843158f, -0.537635f, 0.00567786f, 
		-0.000136839f, -0.261329f, 0.965250f, -0.000126676f, -0.447769f, 0.894149f, 
		0.843158f, -0.537635f, 0.00567786f, 0.719390f, -0.694589f, 0.00484769f, 
		-0.000126676f, -0.447769f, 0.894149f, -0.000112928f, -0.605145f, 0.796115f, 
		0.581959f, -0.813209f, 0.00392402f, 0.429396f, -0.903112f, 0.00289739f, 
		-9.52723e-005f, -0.740105f, 0.672491f, -7.33169e-005f, -0.855911f, 0.517122f, 
		-0.412736f, -0.411342f, -0.812679f, 0.404088f, 0.402722f, -0.821296f, 
		0.398832f, 0.401557f, 0.824430f, -0.0494167f, -0.0389546f, 0.998018f, 
		-0.0896984f, -0.0710016f, 0.993435f, -0.110130f, -0.0876189f, 0.990048f, 
		-0.116355f, -0.0926063f, 0.988881f, -0.110353f, -0.0876959f, 0.990016f, 
		-0.0897374f, -0.0711728f, 0.993419f, -0.0492473f, -0.0389322f, 0.998028f, 
		0.0233929f, 0.0186236f, 0.999553f, 0.151408f, 0.123277f, 0.980754f, 
		0.360341f, 0.316258f, 0.877574f, 0.609729f, 0.581264f, 0.538853f, 
		0.702704f, 0.697936f, 0.138172f, 0.703515f, 0.699163f, 0.127426f, 
		0.667752f, 0.653887f, 0.355723f, 0.562985f, 0.529001f, 0.634985f, 
		0.389957f, 0.343039f, 0.854551f, 0.215431f, 0.177798f, 0.960197f, 
		0.0901447f, 0.0718100f, 0.993336f, 0.0245899f, 0.0193972f, 0.999509f, 
		0.00598050f, 0.00472504f, 0.999971f, 0.0198489f, 0.0156559f, 0.999680f, 
		0.0578744f, 0.0458235f, 0.997272f, 0.114717f, 0.0916384f, 0.989163f, 
		0.172628f, 0.139341f, 0.975081f, 0.207797f, 0.168996f, 0.963463f, 
		0.223730f, 0.182872f, 0.957341f, 0.231331f, 0.189505f, 0.954240f, 
		0.231322f, 0.189391f, 0.954265f, 0.225471f, 0.184416f, 0.956637f, 
		0.213217f, 0.173748f, 0.961431f, 0.194565f, 0.157655f, 0.968137f, 
		0.169622f, 0.136649f, 0.975989f, 0.137774f, 0.110279f, 0.984305f, 
		0.0983672f, 0.0782804f, 0.992067f, 0.0510720f, 0.0404783f, 0.997874f, 
		-0.00273003f, -0.00213029f, 0.999994f, -0.0565121f, -0.0446941f, 0.997401f, 
		-0.103652f, -0.0824016f, 0.991194f, -0.142816f, -0.114274f, 0.983130f, 
		-0.173992f, -0.140257f, 0.974708f, -0.198633f, -0.161170f, 0.966731f, 
		-0.216945f, -0.176845f, 0.960032f, -0.228859f, -0.187209f, 0.955289f, 
		-0.234394f, -0.192137f, 0.952965f, -0.233764f, -0.191796f, 0.953189f, 
		-0.226523f, -0.185270f, 0.956223f, -0.210099f, -0.170927f, 0.962623f, 
		-0.174743f, -0.141096f, 0.974452f, -0.118239f, -0.0943510f, 0.988492f, 
		-0.0616109f, -0.0487140f, 0.996911f, -0.0233543f, -0.0183326f, 0.999559f, 
		-0.00952892f, -0.00747714f, 0.999927f, -0.0280288f, -0.0221438f, 0.999362f, 
		-0.0906019f, -0.0721611f, 0.993269f, -0.209749f, -0.172717f, 0.962379f, 
		-0.378813f, -0.331534f, 0.864052f, -0.548817f, -0.512791f, 0.660186f, 
		-0.657740f, -0.641750f, 0.394380f, -0.699891f, -0.694600f, 0.166385f, 
		-0.698854f, -0.693061f, 0.176830f, -0.596022f, -0.565964f, 0.569599f, 
		-0.345594f, -0.301567f, 0.888607f, -0.141462f, -0.114692f, 0.983277f, 
		-0.0168980f, -0.0134251f, 0.999767f, 0.0534697f, 0.0423110f, 0.997673f, 
		0.0926986f, 0.0736319f, 0.992968f, 0.113231f, 0.0901157f, 0.989474f, 
		0.119351f, 0.0950326f, 0.988293f, 0.113175f, 0.0901082f, 0.989481f, 
		0.0930046f, 0.0738757f, 0.992921f, 0.0535286f, 0.0423139f, 0.997669f, 
		-0.387658f, -0.391294f, 0.834632f, -0.708145f, -0.705758f, 0.0208964f, 
		-0.708165f, -0.705780f, 0.0194074f, -0.708171f, -0.705797f, 0.0185488f, 
		-0.708191f, -0.705814f, 0.0170751f, -0.708200f, -0.705814f, 0.0167073f, 
		-0.708194f, -0.705814f, 0.0169539f, -0.708189f, -0.705816f, 0.0170949f, 
		-0.708188f, -0.705806f, 0.0175147f, -0.708179f, -0.705796f, 0.0182964f, 
		-0.708167f, -0.705786f, 0.0191294f, -0.708139f, -0.705749f, 0.0213962f, 
		-0.712226f, 0.00127966f, -0.701949f, 0.702326f, -0.00126078f, -0.711855f, 
		0.695312f, -0.00124666f, 0.718707f, -0.0983716f, 0.000178490f, 0.995150f, 
		-0.178287f, 0.000321371f, 0.983979f, -0.218256f, 0.000392169f, 0.975892f, 
		-0.230305f, 0.000413029f, 0.973118f, -0.218656f, 0.000392090f, 0.975802f, 
		-0.178487f, 0.000319975f, 0.983942f, -0.0984151f, 0.000176348f, 0.995145f, 
		0.0469969f, -8.47579e-005f, 0.998895f, 0.298204f, -0.000536916f, 0.954502f, 
		0.650474f, -0.00117000f, 0.759528f, 0.926453f, -0.00166673f, 0.376406f, 
		0.996222f, -0.00179114f, 0.0868186f, 0.996789f, -0.00178988f, 0.0800532f, 
		0.972790f, -0.00174940f, 0.231680f, 0.888184f, -0.00159701f, 0.459486f, 
		0.691917f, -0.00124296f, 0.721976f, 0.415625f, -0.000748199f, 0.909536f, 
		0.179513f, -0.000319154f, 0.983755f, 0.0490645f, -8.14891e-005f, 0.998796f, 
		0.0115285f, -1.83248e-005f, 0.999934f, 0.0395691f, -7.13709e-005f, 0.999217f, 
		0.115399f, -0.000207618f, 0.993319f, 0.227267f, -0.000408504f, 0.973832f, 
		0.337393f, -0.000605894f, 0.941364f, 0.401566f, -0.000721783f, 0.915830f, 
		0.430005f, -0.000772959f, 0.902826f, 0.443489f, -0.000794354f, 0.896280f, 
		0.443464f, -0.000791377f, 0.896292f, 0.432958f, -0.000774129f, 0.901414f, 
		0.411116f, -0.000738658f, 0.911583f, 0.377580f, -0.000679784f, 0.925977f, 
		0.331610f, -0.000597370f, 0.943416f, 0.271532f, -0.000488876f, 0.962429f, 
		0.195460f, -0.000351073f, 0.980712f, 0.102138f, -0.000183155f, 0.994770f, 
		-0.00547977f, 9.63480e-006f, 0.999985f, -0.112828f, 0.000202409f, 0.993614f, 
		-0.205587f, 0.000369651f, 0.978639f, -0.281018f, 0.000505527f, 0.959702f, 
		-0.339709f, 0.000610403f, 0.940531f, -0.385000f, 0.000690336f, 0.922916f, 
		-0.417888f, 0.000748377f, 0.908498f, -0.438966f, 0.000786449f, 0.898503f, 
		-0.448707f, 0.000805287f, 0.893679f, -0.447522f, 0.000805521f, 0.894272f, 
		-0.434927f, 0.000784275f, 0.900465f, -0.405920f, 0.000731135f, 0.913908f, 
		-0.341352f, 0.000613590f, 0.939935f, -0.234056f, 0.000420519f, 0.972223f, 
		-0.122935f, 0.000220875f, 0.992415f, -0.0466732f, 8.36443e-005f, 0.998910f, 
		-0.0190132f, 3.41413e-005f, 0.999819f, -0.0562143f, 0.000100700f, 0.998419f, 
		-0.180464f, 0.000323755f, 0.983581f, -0.405835f, 0.000729423f, 0.913946f, 
		-0.676681f, 0.00121723f, 0.736275f, -0.874860f, 0.00157465f, 0.484374f, 
		-0.965709f, 0.00173689f, 0.259621f, -0.994499f, 0.00178595f, 0.104728f, 
		-0.993767f, 0.00178585f, 0.111462f, -0.915176f, 0.00164637f, 0.403050f, 
		-0.629025f, 0.00113136f, 0.777384f, -0.279055f, 0.000502074f, 0.960275f, 
		-0.0339318f, 6.10789e-005f, 0.999424f, 0.106785f, -0.000192201f, 0.994282f, 
		0.184343f, -0.000331331f, 0.982862f, 0.224272f, -0.000402920f, 0.974526f, 
		0.236086f, -0.000424729f, 0.971732f, 0.224226f, -0.000403797f, 0.974537f, 
		0.184900f, -0.000332497f, 0.982757f, 0.106848f, -0.000191723f, 0.994275f, 
		-0.681539f, 0.00122467f, 0.731781f, -0.999907f, 0.00179742f, 0.0135176f, 
		-0.999925f, 0.00179921f, 0.0120710f, -0.999931f, 0.00179779f, 0.0115679f, 
		-0.999940f, 0.00179498f, 0.0108142f, -0.999945f, 0.00179655f, 0.0103091f, 
		-0.999944f, 0.00179977f, 0.0104658f, -0.999940f, 0.00179916f, 0.0107890f, 
		-0.999937f, 0.00179863f, 0.0110879f, -0.999934f, 0.00180038f, 0.0113061f, 
		-0.999929f, 0.00180063f, 0.0117576f, -0.999911f, 0.00179841f, 0.0132409f, 
		-0.712005f, -0.000559314f, -0.702174f, 0.702321f, 0.000549429f, -0.711861f, 
		0.695494f, 0.000543956f, 0.718531f, -0.0981228f, -7.69157e-005f, 0.995174f, 
		-0.178276f, -0.000139545f, 0.983980f, -0.218322f, -0.000170747f, 0.975877f, 
		-0.230282f, -0.000179474f, 0.973124f, -0.218516f, -0.000169806f, 0.975833f, 
		-0.178431f, -0.000139027f, 0.983953f, -0.0983345f, -7.69040e-005f, 0.995153f, 
		0.0471052f, 3.67877e-005f, 0.998890f, 0.298485f, 0.000233365f, 0.954414f, 
		0.650626f, 0.000508766f, 0.759398f, 0.926403f, 0.000724358f, 0.376532f, 
		0.996227f, 0.000778972f, 0.0867866f, 0.996792f, 0.000779438f, 0.0800270f, 
		0.972792f, 0.000760523f, 0.231680f, 0.888251f, 0.000694528f, 0.459359f, 
		0.691950f, 0.000541334f, 0.721945f, 0.415632f, 0.000325235f, 0.909533f, 
		0.180248f, 0.000144603f, 0.983621f, 0.0490326f, 4.53867e-005f, 0.998797f, 
		0.0107424f, 1.19543e-005f, 0.999942f, 0.0394908f, 3.10534e-005f, 0.999220f, 
		0.115370f, 9.03882e-005f, 0.993323f, 0.227344f, 0.000177883f, 0.973815f, 
		0.337425f, 0.000263825f, 0.941352f, 0.401459f, 0.000313905f, 0.915877f, 
		0.429932f, 0.000336184f, 0.902861f, 0.443651f, 0.000348925f, 0.896199f, 
		0.443581f, 0.000350899f, 0.896234f, 0.432795f, 0.000340412f, 0.901492f, 
		0.410923f, 0.000321277f, 0.911670f, 0.377522f, 0.000295117f, 0.926001f, 
		0.331591f, 0.000259220f, 0.943423f, 0.271502f, 0.000212326f, 0.962438f, 
		0.195519f, 0.000152873f, 0.980700f, 0.102242f, 7.98897e-005f, 0.994760f, 
		-0.00545127f, -4.22040e-006f, 0.999985f, -0.112868f, -8.81021e-005f, 0.993610f, 
		-0.205628f, -0.000160612f, 0.978630f, -0.280949f, -0.000219534f, 0.959723f, 
		-0.339704f, -0.000265444f, 0.940532f, -0.385071f, -0.000300869f, 0.922887f, 
		-0.417832f, -0.000326458f, 0.908524f, -0.438824f, -0.000342799f, 0.898573f, 
		-0.448623f, -0.000350442f, 0.893721f, -0.447390f, -0.000349550f, 0.894339f, 
		-0.434948f, -0.000339807f, 0.900456f, -0.406228f, -0.000317284f, 0.913772f, 
		-0.341485f, -0.000266674f, 0.939887f, -0.234102f, -0.000182761f, 0.972212f, 
		-0.122986f, -9.59171e-005f, 0.992408f, -0.0466225f, -3.62988e-005f, 0.998913f, 
		-0.0191128f, -1.48241e-005f, 0.999817f, -0.0564614f, -4.38580e-005f, 0.998405f, 
		-0.180638f, -0.000140841f, 0.983550f, -0.405915f, -0.000316889f, 0.913911f, 
		-0.676619f, -0.000528344f, 0.736333f, -0.874806f, -0.000683131f, 0.484474f, 
		-0.965722f, -0.000754123f, 0.259577f, -0.994517f, -0.000779076f, 0.104575f, 
		-0.993750f, -0.000780930f, 0.111629f, -0.915112f, -0.000717235f, 0.403198f, 
		-0.629014f, -0.000491465f, 0.777394f, -0.279009f, -0.000218014f, 0.960289f, 
		-0.0340159f, -2.65077e-005f, 0.999421f, 0.106865f, 8.34362e-005f, 0.994274f, 
		0.184473f, 0.000143950f, 0.982838f, 0.224278f, 0.000175089f, 0.974525f, 
		0.235994f, 0.000184281f, 0.971755f, 0.224177f, 0.000175079f, 0.974549f, 
		0.184934f, 0.000144403f, 0.982751f, 0.106849f, 8.33817e-005f, 0.994275f, 
		-0.681552f, -0.000532245f, 0.731770f, -0.999904f, -0.000780660f, 0.0138322f, 
		-0.999926f, -0.000780601f, 0.0121072f, -0.999939f, -0.000783115f, 0.0110462f, 
		-0.999941f, -0.000785392f, 0.0108205f, -0.999941f, -0.000782841f, 0.0108242f, 
		-0.999945f, -0.000780510f, 0.0104797f, -0.999947f, -0.000782969f, 0.0102993f, 
		-0.999935f, -0.000785328f, 0.0113756f, -0.999933f, -0.000782867f, 0.0115699f, 
		-0.999934f, -0.000780466f, 0.0114917f, -0.999916f, -0.000782982f, 0.0129278f, 
		-0.711771f, -0.000767781f, -0.702411f, 0.702321f, 0.000757806f, -0.711860f, 
		0.695467f, 0.000750117f, 0.718558f, -0.0982921f, -0.000106925f, 0.995158f, 
		-0.178441f, -0.000194182f, 0.983951f, -0.218322f, -0.000237033f, 0.975877f, 
		-0.230204f, -0.000248830f, 0.973142f, -0.218467f, -0.000235678f, 0.975844f, 
		-0.178355f, -0.000192485f, 0.983966f, -0.0982957f, -0.000106208f, 0.995157f, 
		0.0470444f, 5.13106e-005f, 0.998893f, 0.298380f, 0.000323679f, 0.954447f, 
		0.650641f, 0.000702954f, 0.759385f, 0.926442f, 0.000999404f, 0.376437f, 
		0.996226f, 0.00107491f, 0.0867855f, 0.996805f, 0.00107784f, 0.0798624f, 
		0.972780f, 0.00105399f, 0.231729f, 0.888121f, 0.000960587f, 0.459608f, 
		0.691988f, 0.000746915f, 0.721909f, 0.415688f, 0.000448741f, 0.909507f, 
		0.180730f, 0.000195354f, 0.983533f, 0.0491848f, 5.34573e-005f, 0.998790f, 
		0.0103628f, 1.15279e-005f, 0.999946f, 0.0395721f, 4.30246e-005f, 0.999217f, 
		0.115543f, 0.000124867f, 0.993303f, 0.227523f, 0.000247798f, 0.973773f, 
		0.337258f, 0.000368349f, 0.941412f, 0.401261f, 0.000436213f, 0.915964f, 
		0.429857f, 0.000466000f, 0.902897f, 0.443607f, 0.000479786f, 0.896221f, 
		0.443504f, 0.000478636f, 0.896272f, 0.432672f, 0.000466904f, 0.901552f, 
		0.410918f, 0.000443429f, 0.911672f, 0.377524f, 0.000407351f, 0.926000f, 
		0.331706f, 0.000358564f, 0.943383f, 0.271598f, 0.000294363f, 0.962411f, 
		0.195490f, 0.000211532f, 0.980706f, 0.102243f, 0.000110267f, 0.994759f, 
		-0.00534998f, -5.82648e-006f, 0.999986f, -0.112825f, -0.000122028f, 0.993615f, 
		-0.205664f, -0.000222690f, 0.978623f, -0.280994f, -0.000303641f, 0.959709f, 
		-0.339781f, -0.000366464f, 0.940504f, -0.385187f, -0.000415343f, 0.922838f, 
		-0.417842f, -0.000450685f, 0.908520f, -0.438753f, -0.000473268f, 0.898608f, 
		-0.448510f, -0.000483865f, 0.893778f, -0.447340f, -0.000482649f, 0.894364f, 
		-0.435046f, -0.000470251f, 0.900408f, -0.406174f, -0.000440046f, 0.913796f, 
		-0.341354f, -0.000369098f, 0.939935f, -0.234180f, -0.000252372f, 0.972193f, 
		-0.123045f, -0.000132652f, 0.992401f, -0.0465793f, -5.04119e-005f, 0.998915f, 
		-0.0191345f, -2.06019e-005f, 0.999817f, -0.0565042f, -6.06025e-005f, 0.998402f, 
		-0.180719f, -0.000194491f, 0.983535f, -0.405941f, -0.000437631f, 0.913899f, 
		-0.676714f, -0.000731870f, 0.736245f, -0.874883f, -0.000950069f, 0.484333f, 
		-0.965674f, -0.00104839f, 0.259754f, -0.994510f, -0.00107508f, 0.104633f, 
		-0.993764f, -0.00107429f, 0.111502f, -0.915079f, -0.000991389f, 0.403274f, 
		-0.628959f, -0.000680472f, 0.777438f, -0.279089f, -0.000301092f, 0.960265f, 
		-0.0340228f, -3.64683e-005f, 0.999421f, 0.106890f, 0.000115742f, 0.994271f, 
		0.184326f, 0.000199188f, 0.982865f, 0.224181f, 0.000241847f, 0.974548f, 
		0.236017f, 0.000255138f, 0.971749f, 0.224157f, 0.000242924f, 0.974553f, 
		0.184885f, 0.000199965f, 0.982760f, 0.106825f, 0.000115187f, 0.994278f, 
		-0.681554f, -0.000735331f, 0.731767f, -0.999908f, -0.00108092f, 0.0135354f, 
		-0.999926f, -0.00108324f, 0.0120857f, -0.999938f, -0.00108091f, 0.0110616f, 
		-0.999941f, -0.00107839f, 0.0108138f, -0.999941f, -0.00108069f, 0.0108279f, 
		-0.999945f, -0.00108319f, 0.0104791f, -0.999946f, -0.00108102f, 0.0103007f, 
		-0.999938f, -0.00108092f, 0.0111235f, -0.999933f, -0.00108553f, 0.0115679f, 
		-0.999930f, -0.00108563f, 0.0117941f, -0.999916f, -0.00108095f, 0.0128969f, 
		-0.711775f, -0.000895060f, -0.702407f, 0.702302f, 0.000880254f, -0.711878f, 
		0.695494f, 0.000874486f, 0.718532f, -0.0983142f, -0.000124166f, 0.995155f, 
		-0.178505f, -0.000225246f, 0.983939f, -0.218303f, -0.000275563f, 0.975881f, 
		-0.230148f, -0.000290520f, 0.973156f, -0.218473f, -0.000275796f, 0.975843f, 
		-0.178395f, -0.000225250f, 0.983959f, -0.0983755f, -0.000124164f, 0.995149f, 
		0.0470075f, 5.93871e-005f, 0.998895f, 0.298156f, 0.000375474f, 0.954517f, 
		0.650598f, 0.000818210f, 0.759422f, 0.926456f, 0.00116513f, 0.376402f, 
		0.996223f, 0.00125320f, 0.0868205f, 0.996827f, 0.00125624f, 0.0795850f, 
		0.972720f, 0.00122574f, 0.231977f, 0.888030f, 0.00111715f, 0.459785f, 
		0.692089f, 0.000870795f, 0.721811f, 0.415566f, 0.000522280f, 0.909563f, 
		0.180603f, 0.000226921f, 0.983556f, 0.0491150f, 6.21282e-005f, 0.998793f, 
		0.0103601f, 1.34320e-005f, 0.999946f, 0.0396683f, 5.01170e-005f, 0.999213f, 
		0.115617f, 0.000145496f, 0.993294f, 0.227841f, 0.000288913f, 0.973698f, 
		0.337307f, 0.000428756f, 0.941395f, 0.401109f, 0.000506813f, 0.916030f, 
		0.429948f, 0.000542014f, 0.902853f, 0.443565f, 0.000559045f, 0.896242f, 
		0.443550f, 0.000558004f, 0.896250f, 0.432743f, 0.000545404f, 0.901517f, 
		0.410942f, 0.000517899f, 0.911661f, 0.377507f, 0.000473999f, 0.926007f, 
		0.331805f, 0.000416431f, 0.943348f, 0.271754f, 0.000342299f, 0.962367f, 
		0.195476f, 0.000246860f, 0.980709f, 0.102226f, 0.000129046f, 0.994761f, 
		-0.00534247f, -6.81885e-006f, 0.999986f, -0.112776f, -0.000142381f, 0.993620f, 
		-0.205544f, -0.000258843f, 0.978648f, -0.280919f, -0.000352524f, 0.959731f, 
		-0.339823f, -0.000426581f, 0.940489f, -0.385253f, -0.000485274f, 0.922811f, 
		-0.417843f, -0.000527454f, 0.908519f, -0.438791f, -0.000553876f, 0.898589f, 
		-0.448514f, -0.000565134f, 0.893775f, -0.447387f, -0.000562727f, 0.894340f, 
		-0.435170f, -0.000548246f, 0.900348f, -0.406150f, -0.000512758f, 0.913806f, 
		-0.341314f, -0.000430071f, 0.939949f, -0.234164f, -0.000294228f, 0.972197f, 
		-0.123047f, -0.000154688f, 0.992401f, -0.0465690f, -5.87021e-005f, 0.998915f, 
		-0.0190441f, -2.39476e-005f, 0.999819f, -0.0564041f, -7.08705e-005f, 0.998408f, 
		-0.180683f, -0.000226888f, 0.983541f, -0.406115f, -0.000508804f, 0.913822f, 
		-0.677122f, -0.000850154f, 0.735870f, -0.875070f, -0.00110287f, 0.483994f, 
		-0.965628f, -0.00121909f, 0.259927f, -0.994478f, -0.00125325f, 0.104937f, 
		-0.993783f, -0.00124991f, 0.111330f, -0.915138f, -0.00115290f, 0.403138f, 
		-0.628861f, -0.000794000f, 0.777518f, -0.279017f, -0.000352382f, 0.960286f, 
		-0.0338626f, -4.28309e-005f, 0.999426f, 0.106845f, 0.000134463f, 0.994276f, 
		0.184263f, 0.000231806f, 0.982877f, 0.224124f, 0.000281992f, 0.974561f, 
		0.236047f, 0.000296862f, 0.971742f, 0.224257f, 0.000282537f, 0.974530f, 
		0.184893f, 0.000233418f, 0.982759f, 0.106799f, 0.000134672f, 0.994281f, 
		-0.681844f, -0.000857470f, 0.731497f, -0.999916f, -0.00126008f, 0.0129063f, 
		-0.999926f, -0.00126242f, 0.0120662f, -0.999932f, -0.00125967f, 0.0115996f, 
		-0.999941f, -0.00125728f, 0.0108211f, -0.999946f, -0.00125986f, 0.0103255f, 
		-0.999944f, -0.00126240f, 0.0104806f, -0.999941f, -0.00126014f, 0.0108095f, 
		-0.999940f, -0.00125756f, 0.0108503f, -0.999938f, -0.00125978f, 0.0110363f, 
		-0.999922f, -0.00125990f, 0.0123922f, -0.999908f, -0.00125527f, 0.0134979f, 
		-0.712017f, -0.000947623f, -0.702161f, 0.702299f, 0.000921943f, -0.711881f, 
		0.695453f, 0.000919257f, 0.718571f, -0.0982946f, -0.000129523f, 0.995157f, 
		-0.178463f, -0.000234966f, 0.983947f, -0.218297f, -0.000287454f, 0.975882f, 
		-0.230104f, -0.000303059f, 0.973166f, -0.218422f, -0.000287697f, 0.975854f, 
		-0.178376f, -0.000234970f, 0.983962f, -0.0983426f, -0.000129523f, 0.995153f, 
		0.0471206f, 6.19485e-005f, 0.998889f, 0.298280f, 0.000392661f, 0.954478f, 
		0.650745f, 0.000856762f, 0.759296f, 0.926500f, 0.00122247f, 0.376292f, 
		0.996224f, 0.00131677f, 0.0868142f, 0.996827f, 0.00131522f, 0.0795845f, 
		0.972659f, 0.00128116f, 0.232235f, 0.888034f, 0.00116989f, 0.459776f, 
		0.692158f, 0.000911793f, 0.721745f, 0.415593f, 0.000547316f, 0.909550f, 
		0.180833f, 0.000238290f, 0.983514f, 0.0492033f, 6.50605e-005f, 0.998789f, 
		0.0104084f, 1.40118e-005f, 0.999946f, 0.0396497f, 5.22807e-005f, 0.999214f, 
		0.115562f, 0.000152146f, 0.993300f, 0.228050f, 0.000300460f, 0.973649f, 
		0.337468f, 0.000444498f, 0.941337f, 0.401137f, 0.000528322f, 0.916018f, 
		0.430104f, 0.000566492f, 0.902779f, 0.443572f, 0.000584212f, 0.896239f, 
		0.443673f, 0.000584254f, 0.896189f, 0.432945f, 0.000571149f, 0.901420f, 
		0.410909f, 0.000543146f, 0.911676f, 0.377417f, 0.000498048f, 0.926043f, 
		0.331814f, 0.000436991f, 0.943345f, 0.271754f, 0.000357892f, 0.962367f, 
		0.195480f, 0.000257529f, 0.980708f, 0.102308f, 0.000137021f, 0.994753f, 
		-0.00541740f, -2.62753e-006f, 0.999985f, -0.112897f, -0.000146449f, 0.993607f, 
		-0.205454f, -0.000271235f, 0.978667f, -0.280795f, -0.000371207f, 0.959768f, 
		-0.339805f, -0.000448221f, 0.940496f, -0.385254f, -0.000507216f, 0.922810f, 
		-0.417842f, -0.000550261f, 0.908520f, -0.438790f, -0.000577828f, 0.898589f, 
		-0.448545f, -0.000590594f, 0.893760f, -0.447501f, -0.000589235f, 0.894283f, 
		-0.435268f, -0.000573106f, 0.900301f, -0.406218f, -0.000534920f, 0.913776f, 
		-0.341218f, -0.000449353f, 0.939984f, -0.234108f, -0.000308540f, 0.972211f, 
		-0.123057f, -0.000162443f, 0.992400f, -0.0466459f, -6.13973e-005f, 0.998911f, 
		-0.0191993f, -2.49838e-005f, 0.999816f, -0.0561943f, -7.39393e-005f, 0.998420f, 
		-0.180095f, -0.000237297f, 0.983649f, -0.405730f, -0.000534131f, 0.913993f, 
		-0.677114f, -0.000890342f, 0.735878f, -0.875104f, -0.00115063f, 0.483933f, 
		-0.965638f, -0.00127121f, 0.259889f, -0.994465f, -0.00130994f, 0.105060f, 
		-0.993787f, -0.00130882f, 0.111293f, -0.915194f, -0.00120533f, 0.403012f, 
		-0.628879f, -0.000829524f, 0.777502f, -0.278926f, -0.000369364f, 0.960313f, 
		-0.0337243f, -4.51522e-005f, 0.999431f, 0.106879f, 0.000140770f, 0.994272f, 
		0.184410f, 0.000242747f, 0.982849f, 0.224224f, 0.000295885f, 0.974537f, 
		0.236009f, 0.000311993f, 0.971751f, 0.224211f, 0.000296441f, 0.974540f, 
		0.184894f, 0.000244407f, 0.982758f, 0.106803f, 0.000140982f, 0.994280f, 
		-0.682096f, -0.000898079f, 0.731262f, -0.999920f, -0.00131688f, 0.0125724f, 
		-0.999930f, -0.00131943f, 0.0117901f, -0.999929f, -0.00132170f, 0.0118491f, 
		-0.999938f, -0.00131919f, 0.0110914f, -0.999948f, -0.00131673f, 0.0100711f, 
		-0.999947f, -0.00131923f, 0.0102302f, -0.999938f, -0.00132184f, 0.0110698f, 
		-0.999938f, -0.00131939f, 0.0110959f, -0.999941f, -0.00131673f, 0.0107699f, 
		-0.999922f, -0.00131911f, 0.0123891f, -0.999903f, -0.00132170f, 0.0138373f, 
		-0.712250f, -0.000902310f, -0.701925f, 0.702317f, 0.000883406f, -0.711864f, 
		0.695425f, 0.000877965f, 0.718598f, -0.0983057f, -0.000123321f, 0.995156f, 
		-0.178405f, -0.000223532f, 0.983957f, -0.218237f, -0.000274039f, 0.975896f, 
		-0.230050f, -0.000289973f, 0.973179f, -0.218356f, -0.000275763f, 0.975869f, 
		-0.178289f, -0.000225224f, 0.983978f, -0.0982503f, -0.000124035f, 0.995162f, 
		0.0472067f, 5.88302e-005f, 0.998885f, 0.298421f, 0.000374713f, 0.954434f, 
		0.650669f, 0.000818133f, 0.759361f, 0.926538f, 0.00116527f, 0.376199f, 
		0.996238f, 0.00125540f, 0.0866540f, 0.996804f, 0.00125606f, 0.0798703f, 
		0.972666f, 0.00122349f, 0.232207f, 0.888166f, 0.00111912f, 0.459522f, 
		0.692194f, 0.000873881f, 0.721711f, 0.415487f, 0.000524643f, 0.909599f, 
		0.180860f, 0.000228168f, 0.983509f, 0.0494193f, 6.21017e-005f, 0.998778f, 
		0.0105814f, 1.33799e-005f, 0.999944f, 0.0395272f, 4.99387e-005f, 0.999218f, 
		0.115433f, 0.000145695f, 0.993315f, 0.228145f, 0.000287993f, 0.973627f, 
		0.337543f, 0.000426055f, 0.941310f, 0.401140f, 0.000505350f, 0.916017f, 
		0.430191f, 0.000540952f, 0.902738f, 0.443654f, 0.000559009f, 0.896198f, 
		0.443638f, 0.000560046f, 0.896206f, 0.432927f, 0.000545521f, 0.901429f, 
		0.410839f, 0.000516858f, 0.911708f, 0.377332f, 0.000475589f, 0.926078f, 
		0.331684f, 0.000418133f, 0.943390f, 0.271724f, 0.000341775f, 0.962375f, 
		0.195612f, 0.000246326f, 0.980681f, 0.102595f, 0.000131724f, 0.994723f, 
		-0.00538460f, -2.33248e-006f, 0.999986f, -0.113131f, -0.000140576f, 0.993580f, 
		-0.205442f, -0.000259479f, 0.978669f, -0.280746f, -0.000354554f, 0.959782f, 
		-0.339768f, -0.000428900f, 0.940509f, -0.385155f, -0.000486227f, 0.922852f, 
		-0.417799f, -0.000527481f, 0.908539f, -0.438778f, -0.000553905f, 0.898595f, 
		-0.448518f, -0.000566149f, 0.893773f, -0.447560f, -0.000564822f, 0.894254f, 
		-0.435219f, -0.000548308f, 0.900324f, -0.406105f, -0.000510886f, 0.913826f, 
		-0.341222f, -0.000429918f, 0.939983f, -0.234112f, -0.000294976f, 0.972210f, 
		-0.122953f, -0.000154398f, 0.992413f, -0.0465829f, -5.82850e-005f, 0.998914f, 
		-0.0191663f, -2.39093e-005f, 0.999816f, -0.0559412f, -7.08814e-005f, 0.998434f, 
		-0.179866f, -0.000227488f, 0.983691f, -0.405560f, -0.000512089f, 0.914068f, 
		-0.676662f, -0.000851069f, 0.736293f, -0.874953f, -0.00109623f, 0.484207f, 
		-0.965725f, -0.00121173f, 0.259563f, -0.994484f, -0.00125323f, 0.104879f, 
		-0.993785f, -0.00125473f, 0.111307f, -0.915176f, -0.00115561f, 0.403052f, 
		-0.628870f, -0.000793202f, 0.777510f, -0.279063f, -0.000350915f, 0.960273f, 
		-0.0338871f, -4.25355e-005f, 0.999426f, 0.106898f, 0.000134193f, 0.994270f, 
		0.184568f, 0.000234674f, 0.982820f, 0.224374f, 0.000287529f, 0.974503f, 
		0.236015f, 0.000299512f, 0.971749f, 0.224221f, 0.000281580f, 0.974538f, 
		0.184935f, 0.000232119f, 0.982751f, 0.106777f, 0.000134428f, 0.994283f, 
		-0.682109f, -0.000860963f, 0.731250f, -0.999916f, -0.00125992f, 0.0128686f, 
		-0.999929f, -0.00125548f, 0.0118102f, -0.999932f, -0.00125567f, 0.0115737f, 
		-0.999938f, -0.00126007f, 0.0110917f, -0.999946f, -0.00125999f, 0.0103216f, 
		-0.999947f, -0.00125547f, 0.0102316f, -0.999941f, -0.00125556f, 0.0108209f, 
		-0.999938f, -0.00126030f, 0.0110965f, -0.999938f, -0.00126023f, 0.0110479f, 
		-0.999926f, -0.00125773f, 0.0120688f, -0.999907f, -0.00125995f, 0.0135734f, 
		-0.712015f, -0.000771629f, -0.702163f, 0.702320f, 0.000757528f, -0.711861f, 
		0.695410f, 0.000750078f, 0.718613f, -0.0983177f, -0.000106063f, 0.995155f, 
		-0.178384f, -0.000192438f, 0.983961f, -0.218260f, -0.000235475f, 0.975891f, 
		-0.230086f, -0.000248820f, 0.973170f, -0.218313f, -0.000236660f, 0.975879f, 
		-0.178223f, -0.000192908f, 0.983990f, -0.0982626f, -0.000106065f, 0.995161f, 
		0.0471546f, 5.07502e-005f, 0.998888f, 0.298465f, 0.000322921f, 0.954421f, 
		0.650572f, 0.000706826f, 0.759444f, 0.926467f, 0.00100578f, 0.376376f, 
		0.996238f, 0.00107706f, 0.0866532f, 0.996792f, 0.00107518f, 0.0800225f, 
		0.972735f, 0.00105145f, 0.231917f, 0.888278f, 0.000962322f, 0.459305f, 
		0.692194f, 0.000749868f, 0.721711f, 0.415622f, 0.000451050f, 0.909538f, 
		0.180680f, 0.000196599f, 0.983542f, 0.0493111f, 5.34281e-005f, 0.998783f, 
		0.0105799f, 1.14750e-005f, 0.999944f, 0.0395473f, 4.28428e-005f, 0.999218f, 
		0.115601f, 0.000125053f, 0.993296f, 0.228223f, 0.000247134f, 0.973609f, 
		0.337561f, 0.000365648f, 0.941304f, 0.401066f, 0.000434492f, 0.916049f, 
		0.430156f, 0.000464901f, 0.902754f, 0.443833f, 0.000479687f, 0.896110f, 
		0.443648f, 0.000480640f, 0.896201f, 0.432778f, 0.000467945f, 0.901501f, 
		0.410931f, 0.000444272f, 0.911666f, 0.377506f, 0.000409900f, 0.926007f, 
		0.331663f, 0.000360248f, 0.943398f, 0.271819f, 0.000294404f, 0.962348f, 
		0.195702f, 0.000211928f, 0.980663f, 0.102731f, 0.000111245f, 0.994709f, 
		-0.00531188f, -5.83832e-006f, 0.999986f, -0.113216f, -0.000122308f, 0.993570f, 
		-0.205463f, -0.000221724f, 0.978665f, -0.280743f, -0.000303756f, 0.959783f, 
		-0.339629f, -0.000368120f, 0.940559f, -0.384979f, -0.000416329f, 0.922925f, 
		-0.417695f, -0.000450751f, 0.908587f, -0.438727f, -0.000474442f, 0.898620f, 
		-0.448499f, -0.000487041f, 0.893783f, -0.447455f, -0.000485803f, 0.894306f, 
		-0.434976f, -0.000470378f, 0.900442f, -0.406037f, -0.000438222f, 0.913857f, 
		-0.341447f, -0.000368944f, 0.939901f, -0.234025f, -0.000253505f, 0.972231f, 
		-0.122702f, -0.000132935f, 0.992444f, -0.0463299f, -5.01489e-005f, 0.998926f, 
		-0.0188710f, -2.05234e-005f, 0.999822f, -0.0559234f, -6.10629e-005f, 0.998435f, 
		-0.180036f, -0.000196094f, 0.983660f, -0.405689f, -0.000441431f, 0.914011f, 
		-0.676273f, -0.000734059f, 0.736651f, -0.874749f, -0.000945549f, 0.484575f, 
		-0.965798f, -0.00104186f, 0.259292f, -0.994515f, -0.00107527f, 0.104586f, 
		-0.993780f, -0.00107706f, 0.111353f, -0.915126f, -0.000989928f, 0.403166f, 
		-0.628845f, -0.000678606f, 0.777530f, -0.279099f, -0.000301165f, 0.960262f, 
		-0.0339790f, -3.66210e-005f, 0.999423f, 0.106930f, 0.000115631f, 0.994267f, 
		0.184746f, 0.000202269f, 0.982786f, 0.224412f, 0.000246836f, 0.974494f, 
		0.235873f, 0.000256531f, 0.971784f, 0.224242f, 0.000241943f, 0.974533f, 
		0.185031f, 0.000199949f, 0.982733f, 0.106911f, 0.000115874f, 0.994269f, 
		-0.681814f, -0.000738482f, 0.731525f, -0.999908f, -0.00108103f, 0.0134963f, 
		-0.999926f, -0.00107894f, 0.0121071f, -0.999938f, -0.00108135f, 0.0110488f, 
		-0.999941f, -0.00108350f, 0.0108207f, -0.999941f, -0.00108125f, 0.0108250f, 
		-0.999944f, -0.00107919f, 0.0104841f, -0.999946f, -0.00108138f, 0.0103130f, 
		-0.999941f, -0.00108365f, 0.0108480f, -0.999932f, -0.00108150f, 0.0115884f, 
		-0.999927f, -0.00107899f, 0.0120495f, -0.999916f, -0.00108123f, 0.0129441f, 
		-0.711784f, -0.000556645f, -0.702398f, 0.702320f, 0.000548720f, -0.711861f, 
		0.695375f, 0.000543351f, 0.718647f, -0.0983894f, -7.68233e-005f, 0.995148f, 
		-0.178401f, -0.000139384f, 0.983958f, -0.218296f, -0.000170565f, 0.975883f, 
		-0.230194f, -0.000179864f, 0.973145f, -0.218424f, -0.000170683f, 0.975854f, 
		-0.178354f, -0.000139369f, 0.983966f, -0.0982971f, -7.68354e-005f, 0.995157f, 
		0.0471966f, 3.67588e-005f, 0.998886f, 0.298566f, 0.000233193f, 0.954389f, 
		0.650673f, 0.000508373f, 0.759358f, 0.926421f, 0.000723828f, 0.376488f, 
		0.996226f, 0.000778435f, 0.0867890f, 0.996794f, 0.000779179f, 0.0800045f, 
		0.972768f, 0.000761154f, 0.231780f, 0.888204f, 0.000694845f, 0.459449f, 
		0.692195f, 0.000540811f, 0.721710f, 0.416122f, 0.000324924f, 0.909309f, 
		0.180980f, 0.000141290f, 0.983487f, 0.0492647f, 3.85269e-005f, 0.998786f, 
		0.0104608f, 8.31256e-006f, 0.999945f, 0.0396376f, 3.10354e-005f, 0.999214f, 
		0.115721f, 9.03341e-005f, 0.993282f, 0.228168f, 0.000178235f, 0.973622f, 
		0.337549f, 0.000263739f, 0.941308f, 0.401102f, 0.000313363f, 0.916033f, 
		0.430133f, 0.000336002f, 0.902766f, 0.443926f, 0.000346767f, 0.896063f, 
		0.443756f, 0.000346651f, 0.896147f, 0.432848f, 0.000338178f, 0.901467f, 
		0.411134f, 0.000321166f, 0.911575f, 0.377749f, 0.000295028f, 0.925908f, 
		0.331774f, 0.000259162f, 0.943359f, 0.271795f, 0.000212322f, 0.962355f, 
		0.195661f, 0.000152863f, 0.980672f, 0.102722f, 8.02288e-005f, 0.994710f, 
		-0.00529322f, -4.19898e-006f, 0.999986f, -0.113132f, -8.84987e-005f, 0.993580f, 
		-0.205388f, -0.000160635f, 0.978681f, -0.280793f, -0.000219541f, 0.959768f, 
		-0.339610f, -0.000265517f, 0.940566f, -0.384972f, -0.000300968f, 0.922928f, 
		-0.417726f, -0.000326577f, 0.908573f, -0.438772f, -0.000343014f, 0.898598f, 
		-0.448569f, -0.000350568f, 0.893748f, -0.447380f, -0.000349594f, 0.894344f, 
		-0.434930f, -0.000339973f, 0.900464f, -0.406036f, -0.000317478f, 0.913857f, 
		-0.341402f, -0.000266828f, 0.939917f, -0.233921f, -0.000182871f, 0.972256f, 
		-0.122656f, -9.61659e-005f, 0.992449f, -0.0463536f, -3.65582e-005f, 0.998925f, 
		-0.0188732f, -1.48844e-005f, 0.999822f, -0.0560980f, -4.38871e-005f, 0.998425f, 
		-0.180150f, -0.000140824f, 0.983639f, -0.405645f, -0.000317014f, 0.914031f, 
		-0.676076f, -0.000528413f, 0.736831f, -0.874728f, -0.000685871f, 0.484614f, 
		-0.965807f, -0.000759466f, 0.259261f, -0.994510f, -0.000779811f, 0.104637f, 
		-0.993763f, -0.000774545f, 0.111509f, -0.915103f, -0.000710883f, 0.403219f, 
		-0.629048f, -0.000489707f, 0.777366f, -0.279141f, -0.000218182f, 0.960250f, 
		-0.0340135f, -2.65283e-005f, 0.999421f, 0.106906f, 8.35146e-005f, 0.994269f, 
		0.184836f, 0.000144393f, 0.982769f, 0.224336f, 0.000175278f, 0.974512f, 
		0.235683f, 0.000184189f, 0.971830f, 0.224191f, 0.000175276f, 0.974545f, 
		0.185008f, 0.000144598f, 0.982737f, 0.106968f, 8.34961e-005f, 0.994262f, 
		-0.681527f, -0.000532763f, 0.731793f, -0.999908f, -0.000783918f, 0.0135305f, 
		-0.999927f, -0.000786386f, 0.0120859f, -0.999938f, -0.000784038f, 0.0110644f, 
		-0.999941f, -0.000781568f, 0.0108153f, -0.999938f, -0.000781550f, 0.0110772f, 
		-0.999945f, -0.000781687f, 0.0104802f, -0.999949f, -0.000781627f, 0.0100581f, 
		-0.999941f, -0.000781642f, 0.0108553f, -0.999929f, -0.000781860f, 0.0118514f, 
		-0.999927f, -0.000781824f, 0.0120517f, -0.999920f, -0.000781863f, 0.0126154f, 
		-0.712016f, -0.000249782f, -0.702163f, 0.702320f, 0.000249487f, -0.711861f, 
		0.695423f, 0.000247027f, 0.718601f, -0.0983429f, -3.49365e-005f, 0.995153f, 
		-0.178373f, -6.33904e-005f, 0.983963f, -0.218269f, -7.75602e-005f, 0.975889f, 
		-0.230198f, -8.12167e-005f, 0.973144f, -0.218443f, -7.65442e-005f, 0.975850f, 
		-0.178451f, -6.28614e-005f, 0.983949f, -0.0983506f, -3.49293e-005f, 0.995152f, 
		0.0471345f, 1.67199e-005f, 0.998889f, 0.298497f, 0.000106052f, 0.954411f, 
		0.650682f, 0.000231188f, 0.759350f, 0.926430f, 0.000329173f, 0.376468f, 
		0.996227f, 0.000353993f, 0.0867807f, 0.996797f, 0.000354520f, 0.0799765f, 
		0.972755f, 0.000346738f, 0.231836f, 0.888184f, 0.000316359f, 0.459488f, 
		0.692192f, 0.000245902f, 0.721713f, 0.416104f, 0.000147742f, 0.909317f, 
		0.181060f, 6.42545e-005f, 0.983472f, 0.0492846f, 1.75216e-005f, 0.998785f, 
		0.0105821f, 3.77971e-006f, 0.999944f, 0.0397696f, 1.41118e-005f, 0.999209f, 
		0.115565f, 4.06751e-005f, 0.993300f, 0.228059f, 7.99402e-005f, 0.973647f, 
		0.337592f, 0.000119220f, 0.941292f, 0.401119f, 0.000142505f, 0.916026f, 
		0.430064f, 0.000152803f, 0.902798f, 0.443837f, 0.000157680f, 0.896107f, 
		0.443728f, 0.000157623f, 0.896161f, 0.432874f, 0.000153764f, 0.901455f, 
		0.411127f, 0.000146048f, 0.911578f, 0.377691f, 0.000133308f, 0.925932f, 
		0.331702f, 0.000116261f, 0.943384f, 0.271708f, 9.52541e-005f, 0.962380f, 
		0.195623f, 6.85689e-005f, 0.980679f, 0.102615f, 3.59844e-005f, 0.994721f, 
		-0.00542910f, -1.88469e-006f, 0.999985f, -0.113154f, -4.00836e-005f, 0.993577f, 
		-0.205414f, -7.30381e-005f, 0.978675f, -0.280878f, -9.98411e-005f, 0.959744f, 
		-0.339706f, -0.000120746f, 0.940532f, -0.385116f, -0.000136836f, 0.922868f, 
		-0.417852f, -0.000148462f, 0.908515f, -0.438760f, -0.000154862f, 0.898604f, 
		-0.448599f, -0.000157250f, 0.893733f, -0.447478f, -0.000157898f, 0.894295f, 
		-0.435004f, -0.000154588f, 0.900428f, -0.406033f, -0.000144368f, 0.913859f, 
		-0.341259f, -0.000121345f, 0.939969f, -0.233922f, -8.31667e-005f, 0.972255f, 
		-0.122851f, -4.36625e-005f, 0.992425f, -0.0464974f, -1.65275e-005f, 0.998918f, 
		-0.0189061f, -6.69923e-006f, 0.999821f, -0.0561870f, -1.94603e-005f, 0.998420f, 
		-0.180262f, -6.29574e-005f, 0.983619f, -0.405676f, -0.000143554f, 0.914017f, 
		-0.676042f, -0.000240363f, 0.736863f, -0.874786f, -0.000310962f, 0.484509f, 
		-0.965813f, -0.000343252f, 0.259240f, -0.994479f, -0.000351080f, 0.104932f, 
		-0.993750f, -0.000348458f, 0.111624f, -0.915155f, -0.000322824f, 0.403101f, 
		-0.629147f, -0.000223620f, 0.777286f, -0.279155f, -9.92169e-005f, 0.960246f, 
		-0.0340423f, -1.20654e-005f, 0.999420f, 0.106899f, 3.79879e-005f, 0.994270f, 
		0.184796f, 6.56701e-005f, 0.982777f, 0.224266f, 7.97075e-005f, 0.974528f, 
		0.235599f, 8.37705e-005f, 0.971850f, 0.224110f, 7.97271e-005f, 0.974564f, 
		0.184888f, 6.53875e-005f, 0.982760f, 0.106784f, 3.74578e-005f, 0.994282f, 
		-0.681583f, -0.000242506f, 0.731741f, -0.999912f, -0.000355418f, 0.0132352f, 
		-0.999927f, -0.000355473f, 0.0120678f, -0.999933f, -0.000353117f, 0.0116046f, 
		-0.999941f, -0.000350597f, 0.0108301f, -0.999941f, -0.000352969f, 0.0108253f, 
		-0.999945f, -0.000355441f, 0.0104735f, -0.999947f, -0.000353063f, 0.0103110f, 
		-0.999941f, -0.000350648f, 0.0108477f, -0.999933f, -0.000353082f, 0.0115853f, 
		-0.999927f, -0.000355558f, 0.0120490f, -0.999916f, -0.000353197f, 0.0129464f, 
		-0.712249f, 0.000148301f, -0.701926f, 0.702336f, -0.000149534f, -0.711846f, 
		0.695399f, -0.000148051f, 0.718624f, -0.0983718f, 2.05735e-005f, 0.995150f, 
		-0.178382f, 3.71198e-005f, 0.983961f, -0.218196f, 4.59694e-005f, 0.975905f, 
		-0.230179f, 4.89959e-005f, 0.973148f, -0.218470f, 4.64955e-005f, 0.975844f, 
		-0.178436f, 3.83322e-005f, 0.983952f, -0.0984928f, 2.13051e-005f, 0.995138f, 
		0.0469564f, -9.67439e-006f, 0.998897f, 0.298474f, -6.20971e-005f, 0.954418f, 
		0.650663f, -0.000135391f, 0.759367f, 0.926413f, -0.000192804f, 0.376508f, 
		0.996216f, -0.000209758f, 0.0869083f, 0.996801f, -0.000212306f, 0.0799203f, 
		0.972774f, -0.000204953f, 0.231756f, 0.888062f, -0.000186792f, 0.459723f, 
		0.692127f, -0.000147368f, 0.721776f, 0.416080f, -8.79745e-005f, 0.909328f, 
		0.180884f, -3.76298e-005f, 0.983504f, 0.0492499f, -1.02817e-005f, 0.998787f, 
		0.0106874f, -2.26572e-006f, 0.999943f, 0.0398266f, -8.45250e-006f, 0.999207f, 
		0.115659f, -2.46075e-005f, 0.993289f, 0.228236f, -4.85512e-005f, 0.973606f, 
		0.337719f, -7.18893e-005f, 0.941247f, 0.401125f, -8.44229e-005f, 0.916023f, 
		0.430000f, -8.94812e-005f, 0.902829f, 0.443717f, -9.23353e-005f, 0.896167f, 
		0.443600f, -9.33592e-005f, 0.896225f, 0.432846f, -9.21666e-005f, 0.901468f, 
		0.411122f, -8.66013e-005f, 0.911580f, 0.377571f, -7.85605e-005f, 0.925981f, 
		0.331568f, -6.90128e-005f, 0.943431f, 0.271624f, -5.65456e-005f, 0.962403f, 
		0.195562f, -4.06949e-005f, 0.980691f, 0.102549f, -2.13594e-005f, 0.994728f, 
		-0.00549788f, 1.27525e-006f, 0.999985f, -0.113184f, 2.45159e-005f, 0.993574f, 
		-0.205561f, 4.41962e-005f, 0.978644f, -0.280982f, 5.90952e-005f, 0.959713f, 
		-0.339697f, 7.15895e-005f, 0.940535f, -0.385092f, 8.29972e-005f, 0.922878f, 
		-0.417859f, 9.10456e-005f, 0.908512f, -0.438790f, 9.45261e-005f, 0.898590f, 
		-0.448584f, 9.44715e-005f, 0.893740f, -0.447337f, 9.42101e-005f, 0.894365f, 
		-0.434892f, 9.47548e-005f, 0.900483f, -0.406147f, 9.08470e-005f, 0.913808f, 
		-0.341392f, 7.49763e-005f, 0.939921f, -0.233978f, 4.94633e-005f, 0.972242f, 
		-0.122885f, 2.57490e-005f, 0.992421f, -0.0465407f, 9.94836e-006f, 0.998916f, 
		-0.0188949f, 4.09082e-006f, 0.999821f, -0.0561533f, 1.17307e-005f, 0.998422f, 
		-0.180351f, 3.75297e-005f, 0.983602f, -0.405787f, 8.44848e-005f, 0.913968f, 
		-0.676048f, 0.000140805f, 0.736858f, -0.874676f, 0.000184402f, 0.484708f, 
		-0.965808f, 0.000205692f, 0.259259f, -0.994484f, 0.000209380f, 0.104886f, 
		-0.993753f, 0.000206846f, 0.111600f, -0.915157f, 0.000192478f, 0.403097f, 
		-0.629133f, 0.000134038f, 0.777298f, -0.279283f, 5.92104e-005f, 0.960209f, 
		-0.0340439f, 7.06826e-006f, 0.999420f, 0.106897f, -2.22529e-005f, 0.994270f, 
		0.184692f, -3.84658e-005f, 0.982797f, 0.224163f, -4.66881e-005f, 0.974552f, 
		0.235605f, -4.90709e-005f, 0.971849f, 0.224206f, -4.67015e-005f, 0.974542f, 
		0.184954f, -3.85161e-005f, 0.982747f, 0.106692f, -2.22383e-005f, 0.994292f, 
		-0.681396f, 0.000145435f, 0.731915f, -0.999908f, 0.000215609f, 0.0135678f, 
		-0.999930f, 0.000215630f, 0.0117906f, -0.999933f, 0.000210664f, 0.0115872f, 
		-0.999938f, 0.000210557f, 0.0110945f, -0.999944f, 0.000213092f, 0.0105767f, 
		-0.999948f, 0.000210711f, 0.0102204f, -0.999944f, 0.000208264f, 0.0105661f, 
		-0.999938f, 0.000210738f, 0.0111056f, -0.999936f, 0.000213220f, 0.0113099f, 
		-0.999931f, 0.000210801f, 0.0117729f, -0.999912f, 0.000208265f, 0.0132783f, 
		-0.712017f, 0.000659655f, -0.702162f, 0.702335f, -0.000649701f, -0.711847f, 
		0.695378f, -0.000643449f, 0.718644f, -0.0983758f, 9.04785e-005f, 0.995149f, 
		-0.178367f, 0.000164632f, 0.983964f, -0.218183f, 0.000201914f, 0.975908f, 
		-0.230140f, 0.000212383f, 0.973157f, -0.218461f, 0.000201018f, 0.975846f, 
		-0.178383f, 0.000166362f, 0.983961f, -0.0985396f, 9.52836e-005f, 0.995133f, 
		0.0468651f, -4.07186e-005f, 0.998901f, 0.298385f, -0.000275704f, 0.954446f, 
		0.650567f, -0.000604077f, 0.759449f, 0.926406f, -0.000861834f, 0.376525f, 
		0.996216f, -0.000924228f, 0.0869106f, 0.996802f, -0.000922326f, 0.0799116f, 
		0.972766f, -0.000902558f, 0.231788f, 0.888007f, -0.000824235f, 0.459829f, 
		0.692209f, -0.000640323f, 0.721696f, 0.416159f, -0.000385526f, 0.909292f, 
		0.180851f, -0.000168239f, 0.983511f, 0.0493234f, -4.58481e-005f, 0.998783f, 
		0.0106778f, -9.84392e-006f, 0.999943f, 0.0398475f, -3.67465e-005f, 0.999206f, 
		0.115738f, -0.000106565f, 0.993280f, 0.228366f, -0.000209933f, 0.973575f, 
		0.337739f, -0.000311628f, 0.941240f, 0.401143f, -0.000372190f, 0.916015f, 
		0.430061f, -0.000399101f, 0.902800f, 0.443718f, -0.000410762f, 0.896166f, 
		0.443561f, -0.000410488f, 0.896244f, 0.432829f, -0.000400517f, 0.901476f, 
		0.411112f, -0.000381415f, 0.911585f, 0.377585f, -0.000350450f, 0.925975f, 
		0.331659f, -0.000306278f, 0.943399f, 0.271646f, -0.000250171f, 0.962397f, 
		0.195594f, -0.000180084f, 0.980685f, 0.102603f, -9.45522e-005f, 0.994722f, 
		-0.00548719f, 4.95616e-006f, 0.999985f, -0.113181f, 0.000104253f, 0.993574f, 
		-0.205585f, 0.000189864f, 0.978639f, -0.281013f, 0.000260848f, 0.959704f, 
		-0.339735f, 0.000315266f, 0.940521f, -0.385060f, 0.000355438f, 0.922891f, 
		-0.417832f, 0.000384700f, 0.908524f, -0.438911f, 0.000404093f, 0.898531f, 
		-0.448624f, 0.000414223f, 0.893720f, -0.447256f, 0.000414174f, 0.894406f, 
		-0.434690f, 0.000403522f, 0.900580f, -0.406252f, 0.000378360f, 0.913761f, 
		-0.341724f, 0.000317604f, 0.939800f, -0.233972f, 0.000217107f, 0.972243f, 
		-0.122722f, 0.000114164f, 0.992441f, -0.0466133f, 4.30035e-005f, 0.998913f, 
		-0.0192406f, 1.74796e-005f, 0.999815f, -0.0561248f, 5.17248e-005f, 0.998424f, 
		-0.180295f, 0.000166662f, 0.983613f, -0.405838f, 0.000377005f, 0.913945f, 
		-0.676177f, 0.000627707f, 0.736739f, -0.874697f, 0.000807786f, 0.484670f, 
		-0.965796f, 0.000889491f, 0.259302f, -0.994503f, 0.000916038f, 0.104706f, 
		-0.993754f, 0.000915385f, 0.111589f, -0.915079f, 0.000842856f, 0.403274f, 
		-0.629044f, 0.000580423f, 0.777370f, -0.279312f, 0.000258839f, 0.960200f, 
		-0.0340842f, 3.17375e-005f, 0.999419f, 0.106788f, -9.89441e-005f, 0.994282f, 
		0.184722f, -0.000171108f, 0.982791f, 0.224195f, -0.000207704f, 0.974544f, 
		0.235629f, -0.000218261f, 0.971843f, 0.224242f, -0.000207696f, 0.974533f, 
		0.185028f, -0.000171314f, 0.982733f, 0.106756f, -9.89511e-005f, 0.994285f, 
		-0.681399f, 0.000631254f, 0.731912f, -0.999908f, 0.000923758f, 0.0135677f, 
		-0.999930f, 0.000923696f, 0.0117886f, -0.999935f, 0.000926378f, 0.0113241f, 
		-0.999938f, 0.000923973f, 0.0110871f, -0.999944f, 0.000921465f, 0.0105817f, 
		-0.999947f, 0.000923900f, 0.0102205f, -0.999944f, 0.000926386f, 0.0105618f, 
		-0.999938f, 0.000923862f, 0.0111136f, -0.999936f, 0.000921382f, 0.0113016f, 
		-0.999930f, 0.000923908f, 0.0117956f, -0.999912f, 0.000926392f, 0.0132417f, 
		-0.711786f, 0.00128682f, -0.702395f, 0.702298f, -0.00126294f, -0.711882f, 
		0.695479f, -0.00125058f, 0.718545f, -0.0982229f, 0.000176744f, 0.995164f, 
		-0.178356f, 0.000321046f, 0.983966f, -0.218191f, 0.000393177f, 0.975906f, 
		-0.230016f, 0.000414612f, 0.973187f, -0.218426f, 0.000393368f, 0.975853f, 
		-0.178167f, 0.000322668f, 0.984000f, -0.0984643f, 0.000181600f, 0.995141f, 
		0.0466728f, -8.14366e-005f, 0.998910f, 0.298254f, -0.000536801f, 0.954486f, 
		0.650447f, -0.00117147f, 0.759551f, 0.926379f, -0.00166946f, 0.376590f, 
		0.996231f, -0.00179433f, 0.0867201f, 0.996803f, -0.00179257f, 0.0798746f, 
		0.972693f, -0.00175051f, 0.232091f, 0.888099f, -0.00160007f, 0.459650f, 
		0.692345f, -0.00124633f, 0.721565f, 0.415999f, -0.000748855f, 0.909365f, 
		0.180717f, -0.000325906f, 0.983535f, 0.0492147f, -8.89199e-005f, 0.998788f, 
		0.0105503f, -1.91561e-005f, 0.999944f, 0.0397463f, -7.13948e-005f, 0.999210f, 
		0.115581f, -0.000207958f, 0.993298f, 0.228192f, -0.000410703f, 0.973616f, 
		0.337653f, -0.000607257f, 0.941271f, 0.401107f, -0.000721591f, 0.916031f, 
		0.430119f, -0.000775305f, 0.902772f, 0.443760f, -0.000800744f, 0.896145f, 
		0.443602f, -0.000799357f, 0.896223f, 0.432746f, -0.000779190f, 0.901515f, 
		0.410961f, -0.000740798f, 0.911653f, 0.377568f, -0.000680739f, 0.925982f, 
		0.331789f, -0.000597386f, 0.943353f, 0.271701f, -0.000489396f, 0.962382f, 
		0.195704f, -0.000350834f, 0.980663f, 0.102694f, -0.000180710f, 0.994713f, 
		-0.00551502f, 1.22866e-005f, 0.999985f, -0.113140f, 0.000203380f, 0.993579f, 
		-0.205525f, 0.000369177f, 0.978652f, -0.281021f, 0.000505547f, 0.959701f, 
		-0.339842f, 0.000611781f, 0.940482f, -0.385068f, 0.000692951f, 0.922888f, 
		-0.417742f, 0.000750938f, 0.908565f, -0.438853f, 0.000788063f, 0.898558f, 
		-0.448583f, 0.000806912f, 0.893741f, -0.447360f, 0.000806624f, 0.894354f, 
		-0.434621f, 0.000784419f, 0.900613f, -0.406169f, 0.000732857f, 0.913798f, 
		-0.341866f, 0.000615130f, 0.939748f, -0.233983f, 0.000419969f, 0.972241f, 
		-0.122746f, 0.000220397f, 0.992438f, -0.0464684f, 8.34848e-005f, 0.998920f, 
		-0.0191971f, 3.41143e-005f, 0.999816f, -0.0562037f, 0.000101393f, 0.998419f, 
		-0.180063f, 0.000324919f, 0.983655f, -0.405524f, 0.000731522f, 0.914084f, 
		-0.676275f, 0.00122129f, 0.736648f, -0.874837f, 0.00157960f, 0.484415f, 
		-0.965783f, 0.00174063f, 0.259345f, -0.994493f, 0.00179017f, 0.104789f, 
		-0.993761f, 0.00178899f, 0.111516f, -0.915081f, 0.00164766f, 0.403266f, 
		-0.628861f, 0.00113166f, 0.777517f, -0.279133f, 0.000501222f, 0.960252f, 
		-0.0340865f, 6.06373e-005f, 0.999419f, 0.106706f, -0.000192142f, 0.994291f, 
		0.184785f, -0.000332027f, 0.982779f, 0.224312f, -0.000402469f, 0.974517f, 
		0.235618f, -0.000423220f, 0.971846f, 0.224131f, -0.000404533f, 0.974559f, 
		0.184960f, -0.000334498f, 0.982746f, 0.106765f, -0.000192981f, 0.994284f, 
		-0.681892f, 0.00122455f, 0.731452f, -0.999915f, 0.00179414f, 0.0129126f, 
		-0.999922f, 0.00179488f, 0.0123515f, -0.999931f, 0.00180109f, 0.0116282f, 
		-0.999942f, 0.00180188f, 0.0105825f, -0.999945f, 0.00179750f, 0.0103373f, 
		-0.999941f, 0.00179798f, 0.0107287f, -0.999940f, 0.00180314f, 0.0108150f, 
		-0.999942f, 0.00180349f, 0.0106030f, -0.999937f, 0.00179904f, 0.0110519f, 
		-0.999922f, 0.00179981f, 0.0124005f, -0.999907f, 0.00180527f, 0.0135078f, 
		-0.412227f, 0.412968f, -0.812112f, 0.404083f, -0.404803f, -0.820275f, 
		0.399209f, -0.403846f, 0.823129f, -0.0491980f, 0.0392503f, 0.998018f, 
		-0.0897986f, 0.0717636f, 0.993371f, -0.110196f, 0.0883206f, 0.989978f, 
		-0.116296f, 0.0933280f, 0.988820f, -0.110360f, 0.0884135f, 0.989951f, 
		-0.0896197f, 0.0715921f, 0.993400f, -0.0493068f, 0.0392733f, 0.998011f, 
		0.0232464f, -0.0185720f, 0.999557f, 0.151700f, -0.124258f, 0.980585f, 
		0.360447f, -0.318303f, 0.876790f, 0.608647f, -0.583504f, 0.537654f, 
		0.700947f, -0.699821f, 0.137565f, 0.701759f, -0.701058f, 0.126694f, 
		0.666185f, -0.655827f, 0.355090f, 0.562399f, -0.531593f, 0.633337f, 
		0.390372f, -0.345288f, 0.853456f, 0.215680f, -0.178885f, 0.959939f, 
		0.0908748f, -0.0730510f, 0.993179f, 0.0245402f, -0.0196327f, 0.999506f, 
		0.00523016f, -0.00422349f, 0.999977f, 0.0198111f, -0.0157939f, 0.999679f, 
		0.0579059f, -0.0461778f, 0.997253f, 0.115276f, -0.0926093f, 0.989007f, 
		0.172978f, -0.140484f, 0.974855f, 0.207688f, -0.170088f, 0.963294f, 
		0.223982f, -0.184243f, 0.957020f, 0.231748f, -0.191111f, 0.953818f, 
		0.231665f, -0.191033f, 0.953854f, 0.225473f, -0.185638f, 0.956400f, 
		0.213171f, -0.174902f, 0.961232f, 0.194667f, -0.158854f, 0.967921f, 
		0.169832f, -0.137704f, 0.975805f, 0.137950f, -0.111167f, 0.984181f, 
		0.0986528f, -0.0791000f, 0.991973f, 0.0515169f, -0.0409975f, 0.997830f, 
		-0.00274178f, 0.00232812f, 0.999994f, -0.0567027f, 0.0452438f, 0.997365f, 
		-0.103676f, 0.0830470f, 0.991138f, -0.142917f, 0.115167f, 0.983011f, 
		-0.174226f, 0.141371f, 0.974505f, -0.198816f, 0.162467f, 0.966477f, 
		-0.216950f, 0.178208f, 0.959778f, -0.228918f, 0.188570f, 0.955007f, 
		-0.234462f, 0.193558f, 0.952661f, -0.233772f, 0.192974f, 0.952949f, 
		-0.226543f, 0.186525f, 0.955974f, -0.210497f, 0.172566f, 0.962243f, 
		-0.175246f, 0.142413f, 0.974170f, -0.118351f, 0.0951189f, 0.988406f, 
		-0.0616359f, 0.0491137f, 0.996890f, -0.0231768f, 0.0184813f, 0.999561f, 
		-0.00946225f, 0.00753890f, 0.999927f, -0.0281724f, 0.0223328f, 0.999354f, 
		-0.0905718f, 0.0727379f, 0.993230f, -0.209738f, 0.173963f, 0.962157f, 
		-0.378633f, 0.333577f, 0.863344f, -0.548224f, 0.515191f, 0.658809f, 
		-0.656491f, 0.643786f, 0.393140f, -0.698158f, 0.696457f, 0.165902f, 
		-0.697131f, 0.694971f, 0.176135f, -0.595114f, 0.568380f, 0.568141f, 
		-0.345584f, 0.303585f, 0.887924f, -0.141611f, 0.115564f, 0.983154f, 
		-0.0170405f, 0.0135398f, 0.999763f, 0.0534720f, -0.0426703f, 0.997657f, 
		0.0930712f, -0.0743848f, 0.992877f, 0.113380f, -0.0908128f, 0.989393f, 
		0.119209f, -0.0956373f, 0.988252f, 0.113280f, -0.0908475f, 0.989401f, 
		0.0931569f, -0.0744742f, 0.992862f, 0.0535058f, -0.0426547f, 0.997656f, 
		-0.388230f, 0.393635f, 0.833264f, -0.706333f, 0.707586f, 0.0203853f, 
		-0.706333f, 0.707589f, 0.0202939f, -0.706351f, 0.707624f, 0.0183300f, 
		-0.706373f, 0.707641f, 0.0167466f, -0.706375f, 0.707640f, 0.0167530f, 
		-0.706365f, 0.707645f, 0.0169389f, -0.706362f, 0.707637f, 0.0174018f, 
		-0.706369f, 0.707635f, 0.0171761f, -0.706363f, 0.707632f, 0.0175572f, 
		-0.706331f, 0.707602f, 0.0199050f, -0.706311f, 0.707583f, 0.0212403f, 
		0.412247f, 0.412540f, -0.812319f, -0.403915f, -0.404190f, -0.820660f, 
		-0.398737f, -0.403298f, 0.823626f, 0.0493114f, 0.0391518f, 0.998016f, 
		0.0896384f, 0.0715848f, 0.993398f, 0.110161f, 0.0881030f, 0.990001f, 
		0.116361f, 0.0930997f, 0.988834f, 0.110337f, 0.0881960f, 0.989973f, 
		0.0897153f, 0.0714150f, 0.993404f, 0.0492540f, 0.0391758f, 0.998018f, 
		-0.0233540f, -0.0185249f, 0.999556f, -0.151603f, -0.123965f, 0.980637f, 
		-0.360400f, -0.317699f, 0.877029f, -0.608811f, -0.582909f, 0.538114f, 
		-0.701329f, -0.699416f, 0.137676f, -0.702101f, -0.700651f, 0.127048f, 
		-0.666493f, -0.655316f, 0.355454f, -0.562678f, -0.531005f, 0.633583f, 
		-0.390137f, -0.344656f, 0.853818f, -0.215324f, -0.178461f, 0.960098f, 
		-0.0904954f, -0.0728705f, 0.993227f, -0.0245632f, -0.0195826f, 0.999506f, 
		-0.00562201f, -0.00421273f, 0.999975f, -0.0199097f, -0.0157543f, 0.999678f, 
		-0.0579948f, -0.0460630f, 0.997254f, -0.115071f, -0.0923784f, 0.989052f, 
		-0.172727f, -0.140147f, 0.974948f, -0.207620f, -0.169694f, 0.963378f, 
		-0.223809f, -0.183817f, 0.957142f, -0.231557f, -0.190671f, 0.953953f, 
		-0.231459f, -0.190592f, 0.953992f, -0.225508f, -0.185216f, 0.956473f, 
		-0.213209f, -0.174502f, 0.961297f, -0.194609f, -0.158481f, 0.967993f, 
		-0.169767f, -0.137376f, 0.975862f, -0.137970f, -0.110897f, 0.984208f, 
		-0.0986431f, -0.0789078f, 0.991989f, -0.0512956f, -0.0408986f, 0.997846f, 
		0.00278739f, 0.00232050f, 0.999993f, 0.0566835f, 0.0451311f, 0.997372f, 
		0.103685f, 0.0828429f, 0.991154f, 0.142777f, 0.114887f, 0.983064f, 
		0.173992f, 0.141031f, 0.974596f, 0.198691f, 0.162084f, 0.966566f, 
		0.216984f, 0.177800f, 0.959846f, 0.228788f, 0.188137f, 0.955123f, 
		0.234258f, 0.193114f, 0.952801f, 0.233802f, 0.192539f, 0.953029f, 
		0.226459f, 0.186096f, 0.956078f, 0.210135f, 0.172152f, 0.962396f, 
		0.174862f, 0.142065f, 0.974290f, 0.118203f, 0.0948858f, 0.988446f, 
		0.0615988f, 0.0489925f, 0.996898f, 0.0232081f, 0.0184350f, 0.999561f, 
		0.00945368f, 0.00751994f, 0.999927f, 0.0280765f, 0.0222767f, 0.999358f, 
		0.0905928f, 0.0725595f, 0.993241f, 0.209772f, 0.173569f, 0.962221f, 
		0.378714f, 0.332974f, 0.863542f, 0.548279f, 0.514500f, 0.659303f, 
		0.656609f, 0.643220f, 0.393870f, 0.698493f, 0.696040f, 0.166240f, 
		0.697514f, 0.694560f, 0.176241f, 0.595257f, 0.567775f, 0.568595f, 
		0.345462f, 0.302989f, 0.888174f, 0.141540f, 0.115289f, 0.983196f, 
		0.0169876f, 0.0135067f, 0.999764f, -0.0535318f, -0.0425641f, 0.997659f, 
		-0.0929135f, -0.0742003f, 0.992906f, -0.113229f, -0.0905907f, 0.989430f, 
		-0.119219f, -0.0954048f, 0.988274f, -0.113296f, -0.0906240f, 0.989420f, 
		-0.0930943f, -0.0742889f, 0.992882f, -0.0535527f, -0.0425477f, 0.997658f, 
		0.387655f, 0.392913f, 0.833872f, 0.706710f, 0.707196f, 0.0208634f, 
		0.706735f, 0.707208f, 0.0195375f, 0.706747f, 0.707239f, 0.0179187f, 
		0.706749f, 0.707249f, 0.0174568f, 0.706757f, 0.707249f, 0.0171139f, 
		0.706761f, 0.707258f, 0.0165944f, 0.706752f, 0.707248f, 0.0173933f, 
		0.706753f, 0.707243f, 0.0175385f, 0.706753f, 0.707242f, 0.0175798f, 
		0.706730f, 0.707215f, 0.0194940f, 0.706699f, 0.707192f, 0.0213291f, 
		0.413782f, -0.412033f, -0.811796f, -0.405447f, 0.403716f, -0.820138f, 
		-0.400305f, 0.402544f, 0.823234f, 0.0494816f, -0.0391445f, 0.998008f, 
		0.0899492f, -0.0713513f, 0.993387f, 0.110544f, -0.0880456f, 0.989964f, 
		0.116764f, -0.0930499f, 0.988791f, 0.110719f, -0.0881259f, 0.989937f, 
		0.0900272f, -0.0715212f, 0.993368f, 0.0494260f, -0.0391208f, 0.998011f, 
		-0.0234349f, 0.0187127f, 0.999550f, -0.152131f, 0.123803f, 0.980576f, 
		-0.361641f, 0.317307f, 0.876660f, -0.610614f, 0.581929f, 0.537130f, 
		-0.703063f, 0.697743f, 0.137319f, -0.703836f, 0.698878f, 0.127216f, 
		-0.668235f, 0.653937f, 0.354723f, -0.564414f, 0.530057f, 0.632832f, 
		-0.391413f, 0.344265f, 0.853392f, -0.216090f, 0.178493f, 0.959920f, 
		-0.0908091f, 0.0721653f, 0.993250f, -0.0246474f, 0.0194939f, 0.999506f, 
		-0.00564312f, 0.00474948f, 0.999973f, -0.0199797f, 0.0157315f, 0.999677f, 
		-0.0581973f, 0.0460444f, 0.997243f, -0.115468f, 0.0920991f, 0.989032f, 
		-0.173326f, 0.139974f, 0.974867f, -0.208345f, 0.169800f, 0.963203f, 
		-0.224580f, 0.183669f, 0.956990f, -0.232345f, 0.190291f, 0.953837f, 
		-0.232248f, 0.190251f, 0.953869f, -0.226292f, 0.185220f, 0.956287f, 
		-0.213951f, 0.174518f, 0.961129f, -0.195280f, 0.158366f, 0.967877f, 
		-0.170354f, 0.137301f, 0.975770f, -0.138448f, 0.110817f, 0.984150f, 
		-0.0989844f, 0.0786528f, 0.991976f, -0.0514727f, 0.0406718f, 0.997846f, 
		0.00279560f, -0.00213711f, 0.999994f, 0.0568789f, -0.0449070f, 0.997371f, 
		0.104044f, -0.0827944f, 0.991121f, 0.143272f, -0.114796f, 0.983003f, 
		0.174596f, -0.140928f, 0.974503f, 0.199376f, -0.161919f, 0.966453f, 
		0.217729f, -0.177629f, 0.959709f, 0.229576f, -0.188033f, 0.954955f, 
		0.235062f, -0.192902f, 0.952646f, 0.234620f, -0.192669f, 0.952802f, 
		0.227249f, -0.186171f, 0.955876f, 0.210847f, -0.171625f, 0.962335f, 
		0.175458f, -0.141697f, 0.974236f, 0.118614f, -0.0948297f, 0.988402f, 
		0.0618139f, -0.0489692f, 0.996886f, 0.0232894f, -0.0184273f, 0.999559f, 
		0.00948742f, -0.00751328f, 0.999927f, 0.0281734f, -0.0222607f, 0.999355f, 
		0.0909071f, -0.0724662f, 0.993219f, 0.210510f, -0.173468f, 0.962078f, 
		0.380010f, -0.332764f, 0.863053f, 0.549915f, -0.513609f, 0.658634f, 
		0.658416f, -0.641852f, 0.393082f, 0.700234f, -0.694404f, 0.165756f, 
		0.699251f, -0.692871f, 0.176005f, 0.596996f, -0.566546f, 0.567997f, 
		0.346619f, -0.302550f, 0.887873f, 0.142040f, -0.115265f, 0.983127f, 
		0.0170460f, -0.0134927f, 0.999764f, -0.0537190f, 0.0425316f, 0.997650f, 
		-0.0932337f, 0.0739768f, 0.992892f, -0.113621f, 0.0905250f, 0.989392f, 
		-0.119634f, 0.0955089f, 0.988213f, -0.113690f, 0.0905508f, 0.989381f, 
		-0.0934167f, 0.0742101f, 0.992858f, -0.0537388f, 0.0425094f, 0.997650f, 
		0.389181f, -0.392488f, 0.833361f, 0.708459f, -0.705447f, 0.0207627f, 
		0.708488f, -0.705464f, 0.0191033f, 0.708498f, -0.705487f, 0.0178221f, 
		0.708497f, -0.705490f, 0.0177591f, 0.708508f, -0.705498f, 0.0170043f, 
		0.708513f, -0.705506f, 0.0164638f, 0.708503f, -0.705496f, 0.0172914f, 
		0.708504f, -0.705499f, 0.0171224f, 0.708503f, -0.705490f, 0.0175559f, 
		0.708477f, -0.705453f, 0.0199124f, 0.708449f, -0.705438f, 0.0213668f, 
		0.00245669f, -0.712951f, -0.701209f, -0.00241973f, 0.701055f, -0.713103f, 
		-0.00241474f, 0.699841f, 0.714294f, 0.000269434f, -0.0781479f, 0.996942f, 
		0.000489609f, -0.141812f, 0.989893f, 0.000602707f, -0.174417f, 0.984672f, 
		0.000635170f, -0.184132f, 0.982901f, 0.000601346f, -0.174574f, 0.984644f, 
		0.000489596f, -0.142152f, 0.989845f, 0.000268967f, -0.0781007f, 0.996945f, 
		-0.000128909f, 0.0373968f, 0.999300f, -0.000836686f, 0.242576f, 0.970132f, 
		-0.00197147f, 0.571206f, 0.820805f, -0.00308736f, 0.895072f, 0.445910f, 
		-0.00342618f, 0.994039f, 0.108967f, -0.00342966f, 0.994899f, 0.100822f, 
		-0.00330374f, 0.957977f, 0.286826f, -0.00289575f, 0.840099f, 0.542425f, 
		-0.00210491f, 0.610512f, 0.792005f, -0.00118517f, 0.343358f, 0.939204f, 
		-0.000494241f, 0.143305f, 0.989678f, -0.000134478f, 0.0389863f, 0.999240f, 
		-3.32947e-005f, 0.00950051f, 0.999955f, -0.000109754f, 0.0314652f, 0.999505f, 
		-0.000317506f, 0.0918457f, 0.995773f, -0.000628066f, 0.182218f, 0.983258f, 
		-0.000941554f, 0.273325f, 0.961921f, -0.00113120f, 0.328080f, 0.944649f, 
		-0.00121737f, 0.352979f, 0.935631f, -0.00125833f, 0.364699f, 0.931125f, 
		-0.00125802f, 0.364603f, 0.931162f, -0.00122789f, 0.355739f, 0.934585f, 
		-0.00116167f, 0.336595f, 0.941649f, -0.00105945f, 0.307295f, 0.951614f, 
		-0.000925525f, 0.268355f, 0.963320f, -0.000753025f, 0.218295f, 0.975883f, 
		-0.000538922f, 0.156099f, 0.987741f, -0.000279974f, 0.0811811f, 0.996699f, 
		1.35746e-005f, -0.00427524f, 0.999991f, 0.000307145f, -0.0895893f, 0.995979f, 
		0.000565429f, -0.164181f, 0.986430f, 0.000779888f, -0.225922f, 0.974145f, 
		0.000949678f, -0.275122f, 0.961409f, 0.00108256f, -0.313792f, 0.949491f, 
		0.00118008f, -0.342196f, 0.939628f, 0.00124302f, -0.360712f, 0.932677f, 
		0.00127387f, -0.369336f, 0.929295f, 0.00127207f, -0.368857f, 0.929485f, 
		0.00123149f, -0.357366f, 0.933963f, 0.00114145f, -0.331431f, 0.943479f, 
		0.000952551f, -0.276563f, 0.960995f, 0.000646570f, -0.187517f, 0.982261f, 
		0.000336763f, -0.0976380f, 0.995222f, 0.000126981f, -0.0368430f, 0.999321f, 
		5.19589e-005f, -0.0150319f, 0.999887f, 0.000153114f, -0.0445028f, 0.999009f, 
		0.000496412f, -0.143959f, 0.989584f, 0.00115439f, -0.334285f, 0.942471f, 
		0.00204821f, -0.593873f, 0.804556f, 0.00283442f, -0.822391f, 0.568915f, 
		0.00326569f, -0.947445f, 0.319902f, 0.00341713f, -0.991327f, 0.131373f, 
		0.00341546f, -0.990151f, 0.139961f, 0.00303670f, -0.879850f, 0.475241f, 
		0.00189516f, -0.548985f, 0.835830f, 0.000781954f, -0.226367f, 0.974042f, 
		9.32985e-005f, -0.0269567f, 0.999637f, -0.000292364f, 0.0848715f, 0.996392f, 
		-0.000505034f, 0.146965f, 0.989142f, -0.000617197f, 0.179250f, 0.983803f, 
		-0.000652124f, 0.188892f, 0.981998f, -0.000617896f, 0.179294f, 0.983795f, 
		-0.000507639f, 0.147433f, 0.989072f, -0.000293344f, 0.0848325f, 0.996395f, 
		0.00236259f, -0.685445f, 0.728120f, 0.00344816f, -0.999862f, 0.0162225f, 
		0.00344863f, -0.999873f, 0.0155547f, 0.00344842f, -0.999893f, 0.0142190f, 
		0.00344724f, -0.999898f, 0.0138836f, 0.00344801f, -0.999906f, 0.0132958f, 
		0.00344920f, -0.999910f, 0.0129649f, 0.00344933f, -0.999902f, 0.0135479f, 
		0.00344828f, -0.999901f, 0.0136786f, 0.00344677f, -0.999896f, 0.0140129f, 
		0.00344818f, -0.999869f, 0.0158226f, 0.00344813f, -0.999854f, 0.0167411f, 
		0.00181247f, -0.713200f, -0.700958f, -0.00178095f, 0.701045f, -0.713115f, 
		-0.00177965f, 0.699856f, 0.714282f, 0.000198062f, -0.0781510f, 0.996942f, 
		0.000360080f, -0.141807f, 0.989894f, 0.000442768f, -0.174406f, 0.984674f, 
		0.000467640f, -0.184123f, 0.982903f, 0.000442912f, -0.174561f, 0.984646f, 
		0.000360015f, -0.142148f, 0.989845f, 0.000196786f, -0.0781034f, 0.996945f, 
		-9.55788e-005f, 0.0374043f, 0.999300f, -0.000616611f, 0.242599f, 0.970127f, 
		-0.00145222f, 0.571193f, 0.820815f, -0.00227498f, 0.895036f, 0.445989f, 
		-0.00252633f, 0.994039f, 0.108996f, -0.00252862f, 0.994909f, 0.100744f, 
		-0.00243532f, 0.957973f, 0.286849f, -0.00213376f, 0.840078f, 0.542461f, 
		-0.00155091f, 0.610559f, 0.791969f, -0.000873842f, 0.343366f, 0.939201f, 
		-0.000365507f, 0.143300f, 0.989679f, -0.000100326f, 0.0389949f, 0.999239f, 
		-2.49739e-005f, 0.00949941f, 0.999955f, -8.09270e-005f, 0.0314697f, 0.999505f, 
		-0.000234077f, 0.0918444f, 0.995773f, -0.000462082f, 0.182211f, 0.983259f, 
		-0.000693183f, 0.273335f, 0.961919f, -0.000833596f, 0.328061f, 0.944656f, 
		-0.000897524f, 0.353003f, 0.935622f, -0.000928499f, 0.364721f, 0.931117f, 
		-0.000927711f, 0.364588f, 0.931168f, -0.000904112f, 0.355753f, 0.934580f, 
		-0.000855074f, 0.336589f, 0.941651f, -0.000781503f, 0.307288f, 0.951616f, 
		-0.000683390f, 0.268351f, 0.963321f, -0.000556623f, 0.218293f, 0.975883f, 
		-0.000397982f, 0.156100f, 0.987741f, -0.000206019f, 0.0811827f, 0.996699f, 
		1.15253e-005f, -0.00427479f, 0.999991f, 0.000228013f, -0.0895878f, 0.995979f, 
		0.000417134f, -0.164181f, 0.986430f, 0.000574669f, -0.225951f, 0.974139f, 
		0.000699784f, -0.275115f, 0.961411f, 0.000799573f, -0.313789f, 0.949493f, 
		0.000870944f, -0.342214f, 0.939622f, 0.000916596f, -0.360725f, 0.932672f, 
		0.000938254f, -0.369375f, 0.929280f, 0.000936735f, -0.368801f, 0.929508f, 
		0.000908071f, -0.357271f, 0.934000f, 0.000841468f, -0.331488f, 0.943459f, 
		0.000703082f, -0.276644f, 0.960972f, 0.000475981f, -0.187508f, 0.982263f, 
		0.000246784f, -0.0976272f, 0.995223f, 9.27500e-005f, -0.0368380f, 0.999321f, 
		3.80536e-005f, -0.0150324f, 0.999887f, 0.000114452f, -0.0444873f, 0.999010f, 
		0.000366381f, -0.144026f, 0.989574f, 0.000847792f, -0.334289f, 0.942470f, 
		0.00150702f, -0.593836f, 0.804585f, 0.00208888f, -0.822385f, 0.568928f, 
		0.00240753f, -0.947390f, 0.320073f, 0.00251926f, -0.991332f, 0.131354f, 
		0.00251640f, -0.990170f, 0.139848f, 0.00223679f, -0.879862f, 0.475224f, 
		0.00139548f, -0.549017f, 0.835810f, 0.000575058f, -0.226339f, 0.974048f, 
		6.96538e-005f, -0.0269490f, 0.999637f, -0.000214023f, 0.0848727f, 0.996392f, 
		-0.000372370f, 0.146977f, 0.989140f, -0.000456294f, 0.179259f, 0.983802f, 
		-0.000481482f, 0.188870f, 0.982002f, -0.000454190f, 0.179296f, 0.983795f, 
		-0.000373971f, 0.147456f, 0.989069f, -0.000217330f, 0.0848336f, 0.996395f, 
		0.00174193f, -0.685395f, 0.728170f, 0.00254229f, -0.999864f, 0.0162992f, 
		0.00254022f, -0.999872f, 0.0158221f, 0.00253899f, -0.999892f, 0.0144846f, 
		0.00254103f, -0.999904f, 0.0136312f, 0.00254060f, -0.999908f, 0.0133114f, 
		0.00253841f, -0.999912f, 0.0130404f, 0.00254024f, -0.999908f, 0.0133401f, 
		0.00254199f, -0.999901f, 0.0138729f, 0.00254163f, -0.999900f, 0.0139454f, 
		0.00254169f, -0.999876f, 0.0155636f, 0.00254097f, -0.999850f, 0.0171081f, 
		0.00126598f, -0.713174f, -0.700986f, -0.00124340f, 0.701046f, -0.713115f, 
		-0.00124252f, 0.699857f, 0.714282f, 0.000137811f, -0.0781367f, 0.996943f, 
		0.000250270f, -0.141809f, 0.989894f, 0.000308599f, -0.174422f, 0.984671f, 
		0.000326479f, -0.184119f, 0.982904f, 0.000309373f, -0.174557f, 0.984647f, 
		0.000251192f, -0.142145f, 0.989846f, 0.000137809f, -0.0781016f, 0.996945f, 
		-6.54425e-005f, 0.0374059f, 0.999300f, -0.000429760f, 0.242592f, 0.970128f, 
		-0.00101443f, 0.571210f, 0.820803f, -0.00158951f, 0.895047f, 0.445969f, 
		-0.00176449f, 0.994040f, 0.109000f, -0.00176568f, 0.994910f, 0.100749f, 
		-0.00170026f, 0.957973f, 0.286852f, -0.00149051f, 0.840078f, 0.542463f, 
		-0.00108447f, 0.610548f, 0.791979f, -0.000611073f, 0.343367f, 0.939201f, 
		-0.000255487f, 0.143306f, 0.989678f, -7.00221e-005f, 0.0389938f, 0.999239f, 
		-1.69594e-005f, 0.00949950f, 0.999955f, -5.62915e-005f, 0.0314703f, 0.999505f, 
		-0.000163520f, 0.0918495f, 0.995773f, -0.000322903f, 0.182216f, 0.983258f, 
		-0.000484347f, 0.273336f, 0.961918f, -0.000582864f, 0.328073f, 0.944652f, 
		-0.000627851f, 0.353016f, 0.935617f, -0.000648570f, 0.364719f, 0.931117f, 
		-0.000647538f, 0.364590f, 0.931168f, -0.000630950f, 0.355755f, 0.934579f, 
		-0.000597377f, 0.336588f, 0.941652f, -0.000545691f, 0.307295f, 0.951614f, 
		-0.000475530f, 0.268359f, 0.963319f, -0.000388032f, 0.218298f, 0.975882f, 
		-0.000278025f, 0.156101f, 0.987741f, -0.000143683f, 0.0811824f, 0.996699f, 
		7.86009e-006f, -0.00427384f, 0.999991f, 0.000159690f, -0.0895893f, 0.995979f, 
		0.000291891f, -0.164183f, 0.986430f, 0.000401903f, -0.225948f, 0.974139f, 
		0.000490431f, -0.275115f, 0.961411f, 0.000559137f, -0.313792f, 0.949492f, 
		0.000608570f, -0.342212f, 0.939622f, 0.000640353f, -0.360694f, 0.932684f, 
		0.000654372f, -0.369343f, 0.929293f, 0.000654561f, -0.368836f, 0.929494f, 
		0.000634999f, -0.357281f, 0.933997f, 0.000588643f, -0.331502f, 0.943454f, 
		0.000492054f, -0.276684f, 0.960961f, 0.000333416f, -0.187501f, 0.982264f, 
		0.000172460f, -0.0976266f, 0.995223f, 6.46819e-005f, -0.0368383f, 0.999321f, 
		2.72101e-005f, -0.0150297f, 0.999887f, 8.03707e-005f, -0.0444865f, 0.999010f, 
		0.000256019f, -0.144080f, 0.989566f, 0.000592381f, -0.334343f, 0.942451f, 
		0.00105333f, -0.593841f, 0.804582f, 0.00145940f, -0.822397f, 0.568913f, 
		0.00168144f, -0.947382f, 0.320100f, 0.00175938f, -0.991328f, 0.131402f, 
		0.00175721f, -0.990172f, 0.139842f, 0.00156195f, -0.879875f, 0.475203f, 
		0.000975008f, -0.549033f, 0.835800f, 0.000401451f, -0.226343f, 0.974048f, 
		4.79142e-005f, -0.0269526f, 0.999637f, -0.000150249f, 0.0848789f, 0.996391f, 
		-0.000260599f, 0.146989f, 0.989138f, -0.000318311f, 0.179261f, 0.983802f, 
		-0.000335242f, 0.188853f, 0.982005f, -0.000316936f, 0.179294f, 0.983796f, 
		-0.000260855f, 0.147473f, 0.989066f, -0.000150596f, 0.0848357f, 0.996395f, 
		0.00121455f, -0.685107f, 0.728442f, 0.00177302f, -0.999864f, 0.0163689f, 
		0.00177450f, -0.999873f, 0.0158181f, 0.00177484f, -0.999892f, 0.0145633f, 
		0.00177403f, -0.999908f, 0.0134196f, 0.00177416f, -0.999906f, 0.0135905f, 
		0.00177365f, -0.999911f, 0.0132422f, 0.00177288f, -0.999913f, 0.0130712f, 
		0.00177397f, -0.999906f, 0.0136325f, 0.00177373f, -0.999897f, 0.0142704f, 
		0.00177241f, -0.999877f, 0.0155548f, 0.00177320f, -0.999859f, 0.0167183f, 
		0.000818799f, -0.713418f, -0.700738f, -0.000804736f, 0.701047f, -0.713115f, 
		-0.000802290f, 0.699857f, 0.714282f, 8.98384e-005f, -0.0781128f, 0.996945f, 
		0.000161278f, -0.141815f, 0.989893f, 0.000200026f, -0.174455f, 0.984665f, 
		0.000211673f, -0.184122f, 0.982903f, 0.000199795f, -0.174558f, 0.984647f, 
		0.000162661f, -0.142146f, 0.989846f, 9.04390e-005f, -0.0781011f, 0.996945f, 
		-4.19667e-005f, 0.0374033f, 0.999300f, -0.000278116f, 0.242601f, 0.970126f, 
		-0.000656548f, 0.571216f, 0.820800f, -0.00102779f, 0.894975f, 0.446115f, 
		-0.00114004f, 0.994038f, 0.109033f, -0.00114186f, 0.994926f, 0.100603f, 
		-0.00110025f, 0.957976f, 0.286847f, -0.000964955f, 0.840059f, 0.542494f, 
		-0.000702382f, 0.610541f, 0.791984f, -0.000395247f, 0.343373f, 0.939199f, 
		-0.000164359f, 0.143303f, 0.989679f, -4.39823e-005f, 0.0389961f, 0.999239f, 
		-1.02604e-005f, 0.00949985f, 0.999955f, -3.56514e-005f, 0.0314699f, 0.999505f, 
		-0.000104873f, 0.0918288f, 0.995775f, -0.000208467f, 0.182222f, 0.983257f, 
		-0.000312775f, 0.273352f, 0.961914f, -0.000377004f, 0.328034f, 0.944666f, 
		-0.000405486f, 0.352987f, 0.935628f, -0.000417570f, 0.364717f, 0.931118f, 
		-0.000417296f, 0.364627f, 0.931154f, -0.000406434f, 0.355764f, 0.934576f, 
		-0.000385344f, 0.336579f, 0.941655f, -0.000351728f, 0.307321f, 0.951606f, 
		-0.000305447f, 0.268335f, 0.963326f, -0.000249575f, 0.218287f, 0.975884f, 
		-0.000179428f, 0.156120f, 0.987738f, -9.36065e-005f, 0.0811794f, 0.996700f, 
		4.20357e-006f, -0.00427772f, 0.999991f, 0.000102397f, -0.0896007f, 0.995978f, 
		0.000188674f, -0.164172f, 0.986432f, 0.000259117f, -0.225924f, 0.974145f, 
		0.000315165f, -0.275111f, 0.961412f, 0.000360248f, -0.313825f, 0.949481f, 
		0.000394306f, -0.342253f, 0.939608f, 0.000415533f, -0.360626f, 0.932710f, 
		0.000423938f, -0.369272f, 0.929321f, 0.000422927f, -0.368885f, 0.929475f, 
		0.000409152f, -0.357363f, 0.933965f, 0.000380706f, -0.331541f, 0.943441f, 
		0.000318768f, -0.276687f, 0.960960f, 0.000216126f, -0.187481f, 0.982268f, 
		0.000111836f, -0.0976133f, 0.995224f, 4.12701e-005f, -0.0368436f, 0.999321f, 
		1.65103e-005f, -0.0150250f, 0.999887f, 5.14071e-005f, -0.0445143f, 0.999009f, 
		0.000165742f, -0.144120f, 0.989560f, 0.000383828f, -0.334338f, 0.942453f, 
		0.000681937f, -0.593698f, 0.804687f, 0.000943729f, -0.822420f, 0.568880f, 
		0.00108656f, -0.947397f, 0.320060f, 0.00113678f, -0.991322f, 0.131453f, 
		0.00113657f, -0.990187f, 0.139746f, 0.00101157f, -0.879872f, 0.475210f, 
		0.000631229f, -0.549034f, 0.835800f, 0.000260374f, -0.226339f, 0.974048f, 
		3.18706e-005f, -0.0269506f, 0.999637f, -9.64600e-005f, 0.0848690f, 0.996392f, 
		-0.000167102f, 0.146991f, 0.989138f, -0.000204548f, 0.179273f, 0.983799f, 
		-0.000216226f, 0.188851f, 0.982006f, -0.000205214f, 0.179292f, 0.983796f, 
		-0.000168413f, 0.147473f, 0.989066f, -9.55535e-005f, 0.0848361f, 0.996395f, 
		0.000787306f, -0.684651f, 0.728871f, 0.00114693f, -0.999865f, 0.0163917f, 
		0.00114824f, -0.999883f, 0.0152329f, 0.00114794f, -0.999889f, 0.0148571f, 
		0.00114637f, -0.999908f, 0.0135135f, 0.00114791f, -0.999910f, 0.0133849f, 
		0.00114828f, -0.999906f, 0.0136975f, 0.00114734f, -0.999914f, 0.0130656f, 
		0.00114715f, -0.999909f, 0.0134357f, 0.00114559f, -0.999888f, 0.0148929f, 
		0.00114560f, -0.999884f, 0.0152086f, 0.00114677f, -0.999865f, 0.0163861f, 
		0.000471496f, -0.713642f, -0.700510f, -0.000461332f, 0.701044f, -0.713118f, 
		-0.000459135f, 0.699861f, 0.714279f, 5.33877e-005f, -0.0781134f, 0.996944f, 
		9.38371e-005f, -0.141815f, 0.989893f, 0.000114941f, -0.174456f, 0.984665f, 
		0.000121120f, -0.184126f, 0.982903f, 0.000114129f, -0.174562f, 0.984646f, 
		9.26983e-005f, -0.142148f, 0.989845f, 5.11305e-005f, -0.0781005f, 0.996946f, 
		-2.44574e-005f, 0.0374027f, 0.999300f, -0.000160042f, 0.242606f, 0.970125f, 
		-0.000376775f, 0.571221f, 0.820796f, -0.000589637f, 0.894903f, 0.446261f, 
		-0.000655268f, 0.994033f, 0.109074f, -0.000655918f, 0.994941f, 0.100463f, 
		-0.000631492f, 0.957969f, 0.286872f, -0.000553755f, 0.840071f, 0.542476f, 
		-0.000402588f, 0.610580f, 0.791955f, -0.000226988f, 0.343364f, 0.939202f, 
		-9.44322e-005f, 0.143312f, 0.989678f, -2.56018e-005f, 0.0389967f, 0.999239f, 
		-7.19550e-006f, 0.00949982f, 0.999955f, -2.11612e-005f, 0.0314717f, 0.999505f, 
		-6.07198e-005f, 0.0918102f, 0.995777f, -0.000120611f, 0.182228f, 0.983256f, 
		-0.000180592f, 0.273385f, 0.961905f, -0.000217250f, 0.328002f, 0.944677f, 
		-0.000234046f, 0.352954f, 0.935641f, -0.000241254f, 0.364722f, 0.931116f, 
		-0.000240720f, 0.364655f, 0.931143f, -0.000234384f, 0.355757f, 0.934579f, 
		-0.000222232f, 0.336575f, 0.941657f, -0.000201495f, 0.307350f, 0.951596f, 
		-0.000174754f, 0.268305f, 0.963334f, -0.000144137f, 0.218281f, 0.975886f, 
		-0.000104066f, 0.156138f, 0.987735f, -5.39457e-005f, 0.0811736f, 0.996700f, 
		3.60197e-006f, -0.00428223f, 0.999991f, 5.93880e-005f, -0.0896124f, 0.995977f, 
		0.000108231f, -0.164186f, 0.986429f, 0.000149104f, -0.225902f, 0.974150f, 
		0.000181111f, -0.275087f, 0.961419f, 0.000206892f, -0.313851f, 0.949472f, 
		0.000226004f, -0.342278f, 0.939599f, 0.000238945f, -0.360625f, 0.932711f, 
		0.000245464f, -0.369273f, 0.929321f, 0.000244184f, -0.368854f, 0.929487f, 
		0.000234921f, -0.357362f, 0.933966f, 0.000217840f, -0.331570f, 0.943430f, 
		0.000182172f, -0.276685f, 0.960961f, 0.000124607f, -0.187464f, 0.982271f, 
		6.50892e-005f, -0.0976026f, 0.995225f, 2.36439e-005f, -0.0368499f, 0.999321f, 
		9.18005e-006f, -0.0150253f, 0.999887f, 2.96137e-005f, -0.0445150f, 0.999009f, 
		9.44288e-005f, -0.144124f, 0.989560f, 0.000219104f, -0.334342f, 0.942452f, 
		0.000391293f, -0.593568f, 0.804784f, 0.000542573f, -0.822452f, 0.568834f, 
		0.000625862f, -0.947480f, 0.319814f, 0.000655981f, -0.991325f, 0.131431f, 
		0.000654154f, -0.990186f, 0.139754f, 0.000580327f, -0.879883f, 0.475191f, 
		0.000361675f, -0.549050f, 0.835789f, 0.000148711f, -0.226346f, 0.974047f, 
		1.77001e-005f, -0.0269501f, 0.999637f, -5.60848e-005f, 0.0848578f, 0.996393f, 
		-9.50768e-005f, 0.146991f, 0.989138f, -0.000116546f, 0.179285f, 0.983797f, 
		-0.000124766f, 0.188851f, 0.982006f, -0.000117348f, 0.179293f, 0.983796f, 
		-9.55855e-005f, 0.147475f, 0.989066f, -5.47140e-005f, 0.0848361f, 0.996395f, 
		0.000452323f, -0.684388f, 0.729118f, 0.000659500f, -0.999865f, 0.0163970f, 
		0.000659496f, -0.999889f, 0.0148967f, 0.000660460f, -0.999889f, 0.0148600f, 
		0.000661418f, -0.999909f, 0.0134788f, 0.000660476f, -0.999910f, 0.0133749f, 
		0.000660511f, -0.999906f, 0.0137117f, 0.000661818f, -0.999914f, 0.0130742f, 
		0.000660352f, -0.999906f, 0.0137009f, 0.000660382f, -0.999889f, 0.0148554f, 
		0.000661956f, -0.999889f, 0.0149018f, 0.000660634f, -0.999860f, 0.0166982f, 
		0.000223586f, -0.713346f, -0.700812f, -0.000216080f, 0.701042f, -0.713120f, 
		-0.000215857f, 0.699864f, 0.714276f, 2.50553e-005f, -0.0781354f, 0.996943f, 
		4.50714e-005f, -0.141822f, 0.989892f, 5.56751e-005f, -0.174423f, 0.984671f, 
		5.77669e-005f, -0.184111f, 0.982905f, 5.38246e-005f, -0.174577f, 0.984644f, 
		4.35544e-005f, -0.142162f, 0.989843f, 2.33771e-005f, -0.0780979f, 0.996946f, 
		-1.24850e-005f, 0.0374068f, 0.999300f, -7.59257e-005f, 0.242598f, 0.970127f, 
		-0.000178325f, 0.571298f, 0.820743f, -0.000280764f, 0.894951f, 0.446165f, 
		-0.000312771f, 0.994031f, 0.109099f, -0.000312833f, 0.994941f, 0.100459f, 
		-0.000301640f, 0.957981f, 0.286832f, -0.000264549f, 0.840097f, 0.542437f, 
		-0.000192019f, 0.610506f, 0.792011f, -0.000108857f, 0.343295f, 0.939228f, 
		-4.64877e-005f, 0.143353f, 0.989672f, -1.35946e-005f, 0.0389789f, 0.999240f, 
		-3.66047e-006f, 0.00949936f, 0.999955f, -1.03287e-005f, 0.0314724f, 0.999505f, 
		-2.87899e-005f, 0.0918330f, 0.995774f, -5.70968e-005f, 0.182219f, 0.983258f, 
		-8.60128e-005f, 0.273361f, 0.961911f, -0.000102668f, 0.328038f, 0.944665f, 
		-0.000111133f, 0.352989f, 0.935627f, -0.000115393f, 0.364733f, 0.931112f, 
		-0.000115376f, 0.364621f, 0.931156f, -0.000111619f, 0.355746f, 0.934583f, 
		-0.000105553f, 0.336606f, 0.941646f, -9.54042e-005f, 0.307321f, 0.951606f, 
		-8.22824e-005f, 0.268296f, 0.963337f, -6.82178e-005f, 0.218290f, 0.975884f, 
		-5.05262e-005f, 0.156133f, 0.987736f, -2.66130e-005f, 0.0811846f, 0.996699f, 
		1.85050e-006f, -0.00428247f, 0.999991f, 2.77048e-005f, -0.0896122f, 0.995977f, 
		5.13258e-005f, -0.164207f, 0.986426f, 7.12085e-005f, -0.225898f, 0.974151f, 
		8.65216e-005f, -0.275065f, 0.961426f, 9.77826e-005f, -0.313817f, 0.949483f, 
		0.000106367f, -0.342237f, 0.939614f, 0.000112756f, -0.360691f, 0.932686f, 
		0.000116131f, -0.369347f, 0.929291f, 0.000116584f, -0.368821f, 0.929500f, 
		0.000112699f, -0.357326f, 0.933980f, 0.000103030f, -0.331527f, 0.943446f, 
		8.54438e-005f, -0.276636f, 0.960975f, 5.95972e-005f, -0.187481f, 0.982268f, 
		3.07649e-005f, -0.0976141f, 0.995224f, 1.10376e-005f, -0.0368439f, 0.999321f, 
		4.49965e-006f, -0.0150306f, 0.999887f, 1.42972e-005f, -0.0445041f, 0.999009f, 
		4.57831e-005f, -0.144056f, 0.989569f, 0.000104400f, -0.334299f, 0.942467f, 
		0.000185850f, -0.593717f, 0.804674f, 0.000258577f, -0.822546f, 0.568699f, 
		0.000297930f, -0.947540f, 0.319636f, 0.000310462f, -0.991318f, 0.131488f, 
		0.000307905f, -0.990154f, 0.139983f, 0.000272299f, -0.879900f, 0.475159f, 
		0.000169801f, -0.549064f, 0.835780f, 6.93537e-005f, -0.226365f, 0.974043f, 
		6.90991e-006f, -0.0269655f, 0.999636f, -2.81123e-005f, 0.0848577f, 0.996393f, 
		-4.61864e-005f, 0.146974f, 0.989140f, -5.56913e-005f, 0.179286f, 0.983797f, 
		-5.97229e-005f, 0.188869f, 0.982002f, -5.54267e-005f, 0.179281f, 0.983798f, 
		-4.45468e-005f, 0.147462f, 0.989068f, -2.68284e-005f, 0.0848354f, 0.996395f, 
		0.000212567f, -0.684645f, 0.728877f, 0.000312217f, -0.999866f, 0.0163659f, 
		0.000312267f, -0.999888f, 0.0149730f, 0.000313417f, -0.999897f, 0.0143697f, 
		0.000313156f, -0.999907f, 0.0136610f, 0.000311768f, -0.999908f, 0.0135751f, 
		0.000313000f, -0.999913f, 0.0132151f, 0.000313073f, -0.999911f, 0.0133069f, 
		0.000311839f, -0.999902f, 0.0139786f, 0.000313258f, -0.999898f, 0.0142697f, 
		0.000313473f, -0.999884f, 0.0152198f, 0.000312180f, -0.999856f, 0.0169544f, 
		7.53644e-005f, -0.713092f, -0.701070f, -7.29779e-005f, 0.701046f, -0.713116f, 
		-7.27169e-005f, 0.699860f, 0.714280f, 8.36388e-006f, -0.0781461f, 0.996942f, 
		1.55104e-005f, -0.141834f, 0.989890f, 2.06729e-005f, -0.174410f, 0.984673f, 
		2.03364e-005f, -0.184096f, 0.982908f, 1.81487e-005f, -0.174585f, 0.984642f, 
		1.49564e-005f, -0.142172f, 0.989842f, 7.71385e-006f, -0.0780952f, 0.996946f, 
		-4.15810e-006f, 0.0374111f, 0.999300f, -2.52807e-005f, 0.242601f, 0.970126f, 
		-6.02800e-005f, 0.571381f, 0.820685f, -9.43287e-005f, 0.895005f, 0.446056f, 
		-0.000104371f, 0.994034f, 0.109070f, -0.000104401f, 0.994944f, 0.100430f, 
		-0.000100705f, 0.957992f, 0.286796f, -8.84057e-005f, 0.840099f, 0.542433f, 
		-6.53980e-005f, 0.610401f, 0.792092f, -3.74046e-005f, 0.343225f, 0.939253f, 
		-1.52920e-005f, 0.143384f, 0.989667f, -4.72763e-006f, 0.0389630f, 0.999241f, 
		-1.43141e-006f, 0.00949934f, 0.999955f, -3.46167e-006f, 0.0314705f, 0.999505f, 
		-8.94743e-006f, 0.0918485f, 0.995773f, -1.85217e-005f, 0.182202f, 0.983261f, 
		-2.96325e-005f, 0.273328f, 0.961921f, -3.47788e-005f, 0.328070f, 0.944653f, 
		-3.64312e-005f, 0.353023f, 0.935615f, -3.81988e-005f, 0.364735f, 0.931111f, 
		-3.86387e-005f, 0.364583f, 0.931171f, -3.62121e-005f, 0.355745f, 0.934583f, 
		-3.29014e-005f, 0.336643f, 0.941632f, -3.04379e-005f, 0.307289f, 0.951616f, 
		-2.68552e-005f, 0.268291f, 0.963338f, -2.28591e-005f, 0.218295f, 0.975883f, 
		-1.73758e-005f, 0.156127f, 0.987737f, -8.72792e-006f, 0.0811988f, 0.996698f, 
		6.32203e-007f, -0.00428324f, 0.999991f, 9.42183e-006f, -0.0896118f, 0.995977f, 
		1.62377e-005f, -0.164184f, 0.986430f, 2.24722e-005f, -0.225899f, 0.974151f, 
		2.86361e-005f, -0.275082f, 0.961421f, 3.18818e-005f, -0.313786f, 0.949494f, 
		3.49406e-005f, -0.342212f, 0.939623f, 3.75477e-005f, -0.360724f, 0.932673f, 
		3.84958e-005f, -0.369384f, 0.929277f, 3.89974e-005f, -0.368829f, 0.929497f, 
		3.84524e-005f, -0.357324f, 0.933981f, 3.51046e-005f, -0.331483f, 0.943461f, 
		2.91438e-005f, -0.276600f, 0.960985f, 2.05798e-005f, -0.187500f, 0.982265f, 
		1.07297e-005f, -0.0976242f, 0.995223f, 4.32036e-006f, -0.0368397f, 0.999321f, 
		1.82500e-006f, -0.0150305f, 0.999887f, 5.21168e-006f, -0.0445170f, 0.999009f, 
		1.61159e-005f, -0.144017f, 0.989575f, 3.57954e-005f, -0.334259f, 0.942481f, 
		6.28281e-005f, -0.593842f, 0.804582f, 8.64653e-005f, -0.822612f, 0.568604f, 
		9.81236e-005f, -0.947479f, 0.319818f, 0.000101532f, -0.991296f, 0.131654f, 
		0.000102403f, -0.990154f, 0.139984f, 9.18612e-005f, -0.879901f, 0.475158f, 
		5.75452e-005f, -0.549053f, 0.835788f, 2.42512e-005f, -0.226369f, 0.974042f, 
		3.75210e-006f, -0.0269798f, 0.999636f, -8.22546e-006f, 0.0848595f, 0.996393f, 
		-1.58485e-005f, 0.146962f, 0.989142f, -1.90452e-005f, 0.179284f, 0.983797f, 
		-2.01909e-005f, 0.188882f, 0.982000f, -1.82407e-005f, 0.179266f, 0.983801f, 
		-1.41874e-005f, 0.147445f, 0.989070f, -1.05475e-005f, 0.0848342f, 0.996395f, 
		6.92867e-005f, -0.684894f, 0.728643f, 0.000104675f, -0.999866f, 0.0163919f, 
		0.000104724f, -0.999887f, 0.0150509f, 0.000103564f, -0.999897f, 0.0143475f, 
		0.000102355f, -0.999903f, 0.0139140f, 0.000103526f, -0.999912f, 0.0132954f, 
		0.000104734f, -0.999916f, 0.0129216f, 0.000104741f, -0.999909f, 0.0135018f, 
		0.000104740f, -0.999902f, 0.0139711f, 0.000104732f, -0.999902f, 0.0140033f, 
		0.000104700f, -0.999879f, 0.0155372f, 0.000104716f, -0.999856f, 0.0169455f, 
		2.39563e-005f, -0.713125f, -0.701037f, -2.54873e-005f, 0.701047f, -0.713115f, 
		-2.37379e-005f, 0.699858f, 0.714281f, 3.72911e-006f, -0.0781465f, 0.996942f, 
		6.00001e-006f, -0.141836f, 0.989890f, 7.49974e-006f, -0.174413f, 0.984673f, 
		6.27008e-006f, -0.184097f, 0.982908f, 5.63566e-006f, -0.174586f, 0.984642f, 
		4.98528e-006f, -0.142171f, 0.989842f, 3.22035e-006f, -0.0780983f, 0.996946f, 
		5.18537e-008f, 0.0373953f, 0.999301f, -7.76230e-006f, 0.242582f, 0.970131f, 
		-1.96186e-005f, 0.571395f, 0.820675f, -3.14093e-005f, 0.895022f, 0.446022f, 
		-3.49804e-005f, 0.994037f, 0.109043f, -3.46976e-005f, 0.994942f, 0.100449f, 
		-3.36557e-005f, 0.957987f, 0.286811f, -3.00827e-005f, 0.840089f, 0.542449f, 
		-2.28612e-005f, 0.610374f, 0.792113f, -1.25371e-005f, 0.343220f, 0.939255f, 
		-4.36842e-006f, 0.143380f, 0.989668f, -2.08659e-006f, 0.0389655f, 0.999241f, 
		-1.43134e-006f, 0.00949908f, 0.999955f, -1.52580e-006f, 0.0314708f, 0.999505f, 
		-2.54658e-006f, 0.0918470f, 0.995773f, -5.84295e-006f, 0.182196f, 0.983262f, 
		-1.00504e-005f, 0.273325f, 0.961922f, -1.20027e-005f, 0.328073f, 0.944652f, 
		-1.21417e-005f, 0.353026f, 0.935614f, -1.22841e-005f, 0.364739f, 0.931110f, 
		-1.29534e-005f, 0.364582f, 0.931171f, -1.11817e-005f, 0.355740f, 0.934585f, 
		-9.52780e-006f, 0.336640f, 0.941633f, -9.74426e-006f, 0.307292f, 0.951615f, 
		-9.07544e-006f, 0.268298f, 0.963336f, -8.25415e-006f, 0.218296f, 0.975883f, 
		-5.97912e-006f, 0.156124f, 0.987737f, -1.41430e-006f, 0.0811988f, 0.996698f, 
		1.85355e-006f, -0.00428371f, 0.999991f, 4.05153e-006f, -0.0896030f, 0.995978f, 
		5.27891e-006f, -0.164173f, 0.986432f, 7.77308e-006f, -0.225920f, 0.974146f, 
		9.88968e-006f, -0.275105f, 0.961414f, 1.01040e-005f, -0.313788f, 0.949493f, 
		1.04939e-005f, -0.342211f, 0.939623f, 1.08448e-005f, -0.360725f, 0.932672f, 
		1.17461e-005f, -0.369387f, 0.929276f, 1.26744e-005f, -0.368826f, 0.929499f, 
		1.30049e-005f, -0.357324f, 0.933980f, 1.26689e-005f, -0.331490f, 0.943459f, 
		1.10681e-005f, -0.276605f, 0.960984f, 7.13376e-006f, -0.187500f, 0.982265f, 
		4.50173e-006f, -0.0976337f, 0.995222f, 2.15896e-006f, -0.0368475f, 0.999321f, 
		1.06975e-007f, -0.0150256f, 0.999887f, 1.73009e-006f, -0.0445281f, 0.999008f, 
		5.26199e-006f, -0.144026f, 0.989574f, 1.16756e-005f, -0.334253f, 0.942483f, 
		2.15780e-005f, -0.593857f, 0.804571f, 2.95590e-005f, -0.822630f, 0.568577f, 
		3.30408e-005f, -0.947422f, 0.319986f, 3.43692e-005f, -0.991287f, 0.131718f, 
		3.43977e-005f, -0.990167f, 0.139888f, 3.03627e-005f, -0.879891f, 0.475175f, 
		1.89411e-005f, -0.549057f, 0.835785f, 8.72511e-006f, -0.226364f, 0.974043f, 
		2.02282e-006f, -0.0269787f, 0.999636f, -2.42246e-006f, 0.0848597f, 0.996393f, 
		-5.78000e-006f, 0.146967f, 0.989141f, -6.61979e-006f, 0.179271f, 0.983800f, 
		-6.20240e-006f, 0.188881f, 0.982000f, -5.88060e-006f, 0.179282f, 0.983798f, 
		-4.40139e-006f, 0.147445f, 0.989070f, -3.47245e-006f, 0.0848342f, 0.996395f, 
		2.30560e-005f, -0.684854f, 0.728680f, 3.51021e-005f, -0.999865f, 0.0164354f, 
		3.51174e-005f, -0.999887f, 0.0150290f, 3.51204e-005f, -0.999894f, 0.0145872f, 
		3.50968e-005f, -0.999903f, 0.0139118f, 3.51045e-005f, -0.999915f, 0.0130311f, 
		3.51166e-005f, -0.999917f, 0.0128982f, 3.49625e-005f, -0.999909f, 0.0135277f, 
		3.48103e-005f, -0.999902f, 0.0139637f, 3.47990e-005f, -0.999902f, 0.0139982f, 
		3.47818e-005f, -0.999879f, 0.0155245f, 3.47883e-005f, -0.999857f, 0.0169392f, 
		7.40671e-005f, -0.713169f, -0.700992f, -7.42876e-005f, 0.701047f, -0.713115f, 
		-7.44589e-005f, 0.699859f, 0.714281f, 8.24016e-006f, -0.0781471f, 0.996942f, 
		1.57742e-005f, -0.141838f, 0.989890f, 1.87368e-005f, -0.174413f, 0.984673f, 
		1.93334e-005f, -0.184099f, 0.982908f, 1.78790e-005f, -0.174588f, 0.984642f, 
		1.43494e-005f, -0.142172f, 0.989842f, 8.48816e-006f, -0.0781029f, 0.996945f, 
		-3.32810e-006f, 0.0373751f, 0.999301f, -2.47260e-005f, 0.242560f, 0.970136f, 
		-5.90351e-005f, 0.571429f, 0.820651f, -9.39334e-005f, 0.895039f, 0.445989f, 
		-0.000104273f, 0.994036f, 0.109053f, -0.000104270f, 0.994939f, 0.100480f, 
		-0.000100775f, 0.957981f, 0.286831f, -8.85107e-005f, 0.840081f, 0.542461f, 
		-6.45673e-005f, 0.610356f, 0.792127f, -3.58246e-005f, 0.343229f, 0.939252f, 
		-1.48089e-005f, 0.143387f, 0.989667f, -4.99541e-006f, 0.0389672f, 0.999241f, 
		-1.20556e-006f, 0.00949870f, 0.999955f, -3.45219e-006f, 0.0314724f, 0.999505f, 
		-9.16068e-006f, 0.0918299f, 0.995775f, -1.77026e-005f, 0.182211f, 0.983259f, 
		-2.80591e-005f, 0.273354f, 0.961913f, -3.47354e-005f, 0.328069f, 0.944654f, 
		-3.78220e-005f, 0.353018f, 0.935617f, -3.82243e-005f, 0.364731f, 0.931113f, 
		-3.86204e-005f, 0.364587f, 0.931169f, -3.68395e-005f, 0.355709f, 0.934597f, 
		-3.26747e-005f, 0.336630f, 0.941637f, -3.14301e-005f, 0.307321f, 0.951606f, 
		-2.88589e-005f, 0.268305f, 0.963334f, -2.31887e-005f, 0.218298f, 0.975882f, 
		-1.69148e-005f, 0.156121f, 0.987738f, -8.72765e-006f, 0.0811966f, 0.996698f, 
		-5.55929e-008f, -0.00428288f, 0.999991f, 9.32428e-006f, -0.0895911f, 0.995979f, 
		1.77320e-005f, -0.164179f, 0.986431f, 2.39240e-005f, -0.225936f, 0.974142f, 
		2.79772e-005f, -0.275108f, 0.961413f, 3.28919e-005f, -0.313793f, 0.949492f, 
		3.60370e-005f, -0.342205f, 0.939625f, 3.51633e-005f, -0.360689f, 0.932686f, 
		3.64768e-005f, -0.369351f, 0.929290f, 3.75778e-005f, -0.368855f, 0.929487f, 
		3.70815e-005f, -0.357362f, 0.933966f, 3.56142e-005f, -0.331494f, 0.943457f, 
		3.01403e-005f, -0.276607f, 0.960983f, 1.96585e-005f, -0.187504f, 0.982264f, 
		1.04601e-005f, -0.0976446f, 0.995221f, 4.00931e-006f, -0.0368514f, 0.999321f, 
		4.06855e-007f, -0.0150230f, 0.999887f, 4.31553e-006f, -0.0445271f, 0.999008f, 
		1.53330e-005f, -0.144017f, 0.989575f, 3.52308e-005f, -0.334257f, 0.942482f, 
		6.29248e-005f, -0.593901f, 0.804538f, 8.65332e-005f, -0.822664f, 0.568528f, 
		9.93309e-005f, -0.947423f, 0.319983f, 0.000103885f, -0.991286f, 0.131728f, 
		0.000103843f, -0.990165f, 0.139902f, 9.20043e-005f, -0.879891f, 0.475176f, 
		5.77620e-005f, -0.549074f, 0.835773f, 2.49048e-005f, -0.226366f, 0.974042f, 
		3.15958e-006f, -0.0269754f, 0.999636f, -9.42632e-006f, 0.0848584f, 0.996393f, 
		-1.66846e-005f, 0.146966f, 0.989141f, -1.96964e-005f, 0.179257f, 0.983802f, 
		-1.99002e-005f, 0.188881f, 0.982000f, -1.88362e-005f, 0.179295f, 0.983795f, 
		-1.53151e-005f, 0.147440f, 0.989071f, -9.29234e-006f, 0.0848331f, 0.996395f, 
		7.12822e-005f, -0.684887f, 0.728649f, 0.000104746f, -0.999866f, 0.0163492f, 
		0.000104744f, -0.999888f, 0.0149506f, 0.000104756f, -0.999894f, 0.0145664f, 
		0.000104727f, -0.999903f, 0.0139452f, 0.000104735f, -0.999915f, 0.0130642f, 
		0.000103548f, -0.999913f, 0.0131798f, 0.000102357f, -0.999908f, 0.0135683f, 
		0.000103708f, -0.999906f, 0.0136734f, 0.000103844f, -0.999898f, 0.0142605f, 
		0.000102652f, -0.999880f, 0.0154933f, 0.000103843f, -0.999861f, 0.0166428f, 
		0.000223171f, -0.713397f, -0.700760f, -0.000219670f, 0.701048f, -0.713114f, 
		-0.000219477f, 0.699857f, 0.714283f, 2.45390e-005f, -0.0781485f, 0.996942f, 
		4.36749e-005f, -0.141823f, 0.989892f, 5.45021e-005f, -0.174411f, 0.984673f, 
		5.85368e-005f, -0.184109f, 0.982906f, 5.56885e-005f, -0.174572f, 0.984644f, 
		4.44136e-005f, -0.142159f, 0.989844f, 2.37850e-005f, -0.0781035f, 0.996945f, 
		-1.20834e-005f, 0.0373882f, 0.999301f, -7.60148e-005f, 0.242580f, 0.970131f, 
		-0.000178683f, 0.571339f, 0.820714f, -0.000278444f, 0.894978f, 0.446111f, 
		-0.000307778f, 0.994036f, 0.109050f, -0.000308236f, 0.994942f, 0.100454f, 
		-0.000297306f, 0.957971f, 0.286866f, -0.000259896f, 0.840063f, 0.542489f, 
		-0.000188974f, 0.610473f, 0.792037f, -0.000107315f, 0.343313f, 0.939221f, 
		-4.47428e-005f, 0.143352f, 0.989672f, -1.27795e-005f, 0.0389802f, 0.999240f, 
		-3.43455e-006f, 0.00949889f, 0.999955f, -1.05357e-005f, 0.0314732f, 0.999505f, 
		-2.92214e-005f, 0.0918135f, 0.995776f, -5.68430e-005f, 0.182231f, 0.983256f, 
		-8.65210e-005f, 0.273391f, 0.961903f, -0.000104133f, 0.328035f, 0.944665f, 
		-0.000111376f, 0.353015f, 0.935618f, -0.000113527f, 0.364721f, 0.931117f, 
		-0.000113783f, 0.364585f, 0.931170f, -0.000112666f, 0.355717f, 0.934594f, 
		-0.000104707f, 0.336599f, 0.941648f, -9.41254e-005f, 0.307348f, 0.951597f, 
		-8.21895e-005f, 0.268308f, 0.963333f, -6.80300e-005f, 0.218291f, 0.975884f, 
		-4.97239e-005f, 0.156127f, 0.987737f, -2.51036e-005f, 0.0811859f, 0.996699f, 
		1.16220e-006f, -0.00428115f, 0.999991f, 2.81105e-005f, -0.0895992f, 0.995978f, 
		5.16617e-005f, -0.164192f, 0.986428f, 7.10093e-005f, -0.225942f, 0.974141f, 
		8.58592e-005f, -0.275083f, 0.961421f, 9.92529e-005f, -0.313799f, 0.949490f, 
		0.000109274f, -0.342236f, 0.939614f, 0.000112962f, -0.360654f, 0.932700f, 
		0.000116118f, -0.369317f, 0.929304f, 0.000115679f, -0.368849f, 0.929489f, 
		0.000111088f, -0.357356f, 0.933968f, 0.000103835f, -0.331533f, 0.943443f, 
		8.75478e-005f, -0.276648f, 0.960971f, 5.96257e-005f, -0.187488f, 0.982267f, 
		3.11617e-005f, -0.0976277f, 0.995223f, 1.19933e-005f, -0.0368501f, 0.999321f, 
		4.79231e-006f, -0.0150251f, 0.999887f, 1.43713e-005f, -0.0445162f, 0.999009f, 
		4.50634e-005f, -0.144062f, 0.989569f, 0.000104617f, -0.334316f, 0.942461f, 
		0.000185834f, -0.593763f, 0.804640f, 0.000255509f, -0.822572f, 0.568660f, 
		0.000294520f, -0.947487f, 0.319793f, 0.000310641f, -0.991311f, 0.131535f, 
		0.000311740f, -0.990165f, 0.139902f, 0.000276483f, -0.879877f, 0.475202f, 
		0.000172636f, -0.549061f, 0.835782f, 7.23269e-005f, -0.226358f, 0.974044f, 
		9.84331e-006f, -0.0269615f, 0.999636f, -2.57052e-005f, 0.0848591f, 0.996393f, 
		-4.59755e-005f, 0.146980f, 0.989139f, -5.58114e-005f, 0.179271f, 0.983800f, 
		-5.84637e-005f, 0.188867f, 0.982003f, -5.49489e-005f, 0.179292f, 0.983796f, 
		-4.46003e-005f, 0.147452f, 0.989069f, -2.68421e-005f, 0.0848332f, 0.996395f, 
		0.000214134f, -0.684880f, 0.728656f, 0.000314202f, -0.999866f, 0.0163668f, 
		0.000313092f, -0.999885f, 0.0151904f, 0.000311871f, -0.999894f, 0.0145574f, 
		0.000313102f, -0.999906f, 0.0137158f, 0.000313235f, -0.999911f, 0.0133653f, 
		0.000312074f, -0.999910f, 0.0134441f, 0.000313455f, -0.999912f, 0.0132929f, 
		0.000313433f, -0.999906f, 0.0136803f, 0.000312192f, -0.999894f, 0.0145230f, 
		0.000313470f, -0.999884f, 0.0152099f, 0.000313198f, -0.999861f, 0.0166787f, 
		0.000472868f, -0.713607f, -0.700546f, -0.000461237f, 0.701050f, -0.713112f, 
		-0.000460361f, 0.699854f, 0.714285f, 5.09144e-005f, -0.0781496f, 0.996942f, 
		9.22563e-005f, -0.141810f, 0.989894f, 0.000115009f, -0.174416f, 0.984672f, 
		0.000121625f, -0.184131f, 0.982902f, 0.000115531f, -0.174563f, 0.984646f, 
		9.38403e-005f, -0.142148f, 0.989845f, 5.08510e-005f, -0.0781034f, 0.996945f, 
		-2.52876e-005f, 0.0374008f, 0.999300f, -0.000159687f, 0.242629f, 0.970119f, 
		-0.000377005f, 0.571263f, 0.820767f, -0.000591757f, 0.894933f, 0.446199f, 
		-0.000657486f, 0.994038f, 0.109035f, -0.000658285f, 0.994944f, 0.100429f, 
		-0.000634681f, 0.957988f, 0.286808f, -0.000555984f, 0.839977f, 0.542621f, 
		-0.000402812f, 0.610476f, 0.792035f, -0.000226936f, 0.343433f, 0.939177f, 
		-9.49641e-005f, 0.143306f, 0.989679f, -2.69667e-005f, 0.0389845f, 0.999240f, 
		-7.52148e-006f, 0.00949952f, 0.999955f, -2.13963e-005f, 0.0314697f, 0.999505f, 
		-6.17055e-005f, 0.0918391f, 0.995774f, -0.000121079f, 0.182218f, 0.983258f, 
		-0.000181063f, 0.273374f, 0.961908f, -0.000217917f, 0.328009f, 0.944675f, 
		-0.000233475f, 0.353004f, 0.935622f, -0.000240056f, 0.364752f, 0.931105f, 
		-0.000240225f, 0.364573f, 0.931175f, -0.000235886f, 0.355745f, 0.934583f, 
		-0.000223029f, 0.336594f, 0.941650f, -0.000201375f, 0.307335f, 0.951601f, 
		-0.000175662f, 0.268323f, 0.963329f, -0.000144591f, 0.218282f, 0.975886f, 
		-0.000103020f, 0.156127f, 0.987737f, -5.25151e-005f, 0.0811850f, 0.996699f, 
		3.71597e-006f, -0.00428103f, 0.999991f, 6.01206e-005f, -0.0896082f, 0.995977f, 
		0.000108555f, -0.164202f, 0.986427f, 0.000149071f, -0.225941f, 0.974141f, 
		0.000182290f, -0.275074f, 0.961423f, 0.000208528f, -0.313785f, 0.949494f, 
		0.000226049f, -0.342227f, 0.939617f, 0.000237757f, -0.360676f, 0.932691f, 
		0.000243648f, -0.369373f, 0.929281f, 0.000243994f, -0.368825f, 0.929499f, 
		0.000237052f, -0.357288f, 0.933994f, 0.000219683f, -0.331545f, 0.943439f, 
		0.000182983f, -0.276662f, 0.960967f, 0.000124014f, -0.187469f, 0.982271f, 
		6.53430e-005f, -0.0976143f, 0.995224f, 2.49506e-005f, -0.0368460f, 0.999321f, 
		9.78819e-006f, -0.0150300f, 0.999887f, 2.99022e-005f, -0.0444976f, 0.999009f, 
		9.45683e-005f, -0.144060f, 0.989569f, 0.000219792f, -0.334364f, 0.942444f, 
		0.000393154f, -0.593658f, 0.804718f, 0.000545368f, -0.822504f, 0.568760f, 
		0.000628033f, -0.947556f, 0.319590f, 0.000655651f, -0.991320f, 0.131472f, 
		0.000652889f, -0.990151f, 0.140005f, 0.000579803f, -0.879896f, 0.475166f, 
		0.000361308f, -0.549073f, 0.835774f, 0.000148670f, -0.226333f, 0.974050f, 
		1.80975e-005f, -0.0269576f, 0.999637f, -5.67728e-005f, 0.0848562f, 0.996393f, 
		-9.74943e-005f, 0.146995f, 0.989137f, -0.000118663f, 0.179289f, 0.983796f, 
		-0.000124963f, 0.188856f, 0.982005f, -0.000118042f, 0.179285f, 0.983797f, 
		-9.71417e-005f, 0.147470f, 0.989067f, -5.50598e-005f, 0.0848458f, 0.996394f, 
		0.000452904f, -0.684896f, 0.728641f, 0.000659842f, -0.999866f, 0.0163662f, 
		0.000660374f, -0.999881f, 0.0154188f, 0.000660416f, -0.999895f, 0.0144468f, 
		0.000659794f, -0.999910f, 0.0133635f, 0.000660140f, -0.999908f, 0.0135714f, 
		0.000660248f, -0.999909f, 0.0134403f, 0.000659937f, -0.999915f, 0.0130521f, 
		0.000660560f, -0.999903f, 0.0139405f, 0.000660651f, -0.999894f, 0.0145197f, 
		0.000660245f, -0.999888f, 0.0149626f, 0.000660729f, -0.999855f, 0.0169925f, 
		0.000000f, 0.000000f, -1.00000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		1.00000f, 4.45941e-007f, 2.72949e-006f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 1.00000f, 0.000000f, 1.00000f, 4.45941e-007f, 2.72949e-006f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 1.00000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 1.00000f, 4.45941e-007f, 2.72949e-006f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		1.00000f, 4.45941e-007f, 2.72949e-006f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 1.00000f, 0.000000f, -1.00000f, -1.23660e-006f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		1.00000f, 1.17903e-006f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 1.00000f, 0.000000f, 
		0.000000f, -1.00000f, 0.000000f, -1.00000f, -1.23660e-006f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		1.00000f, 1.17903e-006f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, -1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		-1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, -1.00000f, 0.000000f, 1.00000f, 0.000000f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		1.00000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.00000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		1.00000f, 1.17903e-006f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 1.00000f, 0.000000f, 1.00000f, 1.17903e-006f, 0.000000f, 
		0.000000f, 0.000000f, 1.00000f, 0.000000f, -1.00000f, 0.000000f, 
		-1.00000f, -1.23660e-006f, 0.000000f, 0.000000f, 0.000000f, 1.00000f, 
		0.000000f, 1.00000f, 0.000000f, -1.00000f, -1.23660e-006f, 0.000000f, 
		-0.178165f, -0.178742f, -0.967630f, -0.600219f, -0.597293f, 0.531956f, 
		0.204373f, 0.204526f, 0.957288f, 0.633145f, 0.503588f, 0.587815f, 
		0.190659f, 0.0872955f, -0.977767f, 0.181616f, 0.179542f, -0.966840f, 
		0.256078f, 0.253661f, -0.932781f, 0.308003f, 0.305297f, -0.901070f, 
		0.331198f, 0.328405f, -0.884567f, 0.323094f, 0.320502f, -0.890443f, 
		0.283086f, 0.280611f, -0.917126f, 0.214909f, 0.212698f, -0.953191f, 
		0.127503f, 0.126077f, -0.983792f, 0.0334376f, 0.0330605f, -0.998894f, 
		-0.0549437f, -0.0543235f, -0.997011f, 0.213315f, 0.212980f, -0.953486f, 
		0.487236f, 0.484943f, -0.726244f, 0.386795f, 0.384173f, -0.838332f, 
		0.306523f, 0.303880f, -0.902054f, 0.242382f, 0.240015f, -0.940023f, 
		0.189858f, 0.187835f, -0.963676f, 0.144760f, 0.143118f, -0.979062f, 
		0.103915f, 0.102728f, -0.989267f, 0.0647658f, 0.0640113f, -0.995845f, 
		0.0246861f, 0.0244087f, -0.999397f, -0.0190729f, -0.0188243f, -0.999641f, 
		-0.0703338f, -0.0694871f, -0.995100f, -0.0642115f, -0.0634586f, -0.995917f, 
		0.0919784f, 0.0909486f, -0.991599f, 0.272464f, 0.270089f, -0.923480f, 
		0.358226f, 0.355644f, -0.863245f, 0.403497f, 0.400788f, -0.822532f, 
		0.429307f, 0.426792f, -0.795955f, 0.444272f, 0.441649f, -0.779467f, 
		0.452056f, 0.449487f, -0.770459f, 0.454624f, 0.452150f, -0.767384f, 
		0.452167f, 0.449676f, -0.770283f, 0.444184f, 0.441586f, -0.779553f, 
		0.429224f, 0.426463f, -0.796176f, 0.314124f, 0.311649f, -0.896773f, 
		-0.177924f, 0.178978f, -0.967631f, -0.599419f, 0.598094f, 0.531959f, 
		0.204086f, -0.204784f, 0.957294f, 0.561563f, -0.560487f, -0.608688f, 
		0.0948606f, -0.0938472f, -0.991057f, 0.181309f, -0.179798f, -0.966850f, 
		0.255713f, -0.253945f, -0.932804f, 0.307598f, -0.305766f, -0.901050f, 
		0.330766f, -0.328905f, -0.884543f, 0.322650f, -0.320842f, -0.890482f, 
		0.282702f, -0.280914f, -0.917152f, 0.214630f, -0.213023f, -0.953182f, 
		0.127343f, -0.126267f, -0.983789f, 0.0333965f, -0.0330888f, -0.998894f, 
		-0.0548736f, 0.0543980f, -0.997010f, 0.213026f, -0.213261f, -0.953488f, 
		0.486579f, -0.485554f, -0.726277f, 0.386275f, -0.384680f, -0.838339f, 
		0.306116f, -0.304285f, -0.902055f, 0.242058f, -0.240309f, -0.940032f, 
		0.189606f, -0.188103f, -0.963674f, 0.144567f, -0.143322f, -0.979060f, 
		0.103776f, -0.102865f, -0.989267f, 0.0646807f, -0.0640986f, -0.995845f, 
		0.0246557f, -0.0244419f, -0.999397f, -0.0190461f, 0.0188489f, -0.999641f, 
		-0.0702384f, 0.0695913f, -0.995100f, -0.0641245f, 0.0635368f, -0.995917f, 
		0.0918560f, -0.0910980f, -0.991597f, 0.272092f, -0.270376f, -0.923506f, 
		0.357749f, -0.356113f, -0.863249f, 0.402969f, -0.401416f, -0.822485f, 
		0.428736f, -0.427381f, -0.795946f, 0.443691f, -0.442321f, -0.779417f, 
		0.451444f, -0.450045f, -0.770492f, 0.453997f, -0.452643f, -0.767464f, 
		0.451564f, -0.450280f, -0.770285f, 0.443614f, -0.442323f, -0.779459f, 
		0.428676f, -0.427185f, -0.796084f, 0.313705f, -0.312067f, -0.896774f, 
		0.178406f, 0.178894f, -0.967558f, 0.600534f, 0.597357f, 0.531529f, 
		-0.204621f, -0.204683f, 0.957202f, -0.562561f, -0.559898f, -0.608309f, 
		-0.0949524f, -0.0938061f, -0.991052f, -0.181626f, -0.179709f, -0.966808f, 
		-0.256223f, -0.253797f, -0.932704f, -0.308268f, -0.305571f, -0.900887f, 
		-0.331536f, -0.328688f, -0.884335f, -0.323448f, -0.320638f, -0.890265f, 
		-0.283365f, -0.280749f, -0.916997f, -0.215198f, -0.212913f, -0.953078f, 
		-0.127852f, -0.126215f, -0.983729f, -0.0335608f, -0.0330758f, -0.998889f, 
		0.0550536f, 0.0543760f, -0.997002f, -0.213532f, -0.213153f, -0.953399f, 
		-0.487592f, -0.485091f, -0.725907f, -0.387152f, -0.384391f, -0.838067f, 
		-0.306885f, -0.304098f, -0.901857f, -0.242712f, -0.240183f, -0.939895f, 
		-0.190086f, -0.188012f, -0.963597f, -0.144940f, -0.143257f, -0.979015f, 
		-0.104084f, -0.102821f, -0.989239f, -0.0648811f, -0.0640725f, -0.995834f, 
		-0.0247406f, -0.0244321f, -0.999395f, 0.0190560f, 0.0188413f, -0.999641f, 
		0.0704172f, 0.0695627f, -0.995089f, 0.0644598f, 0.0635109f, -0.995897f, 
		-0.0918638f, -0.0910589f, -0.991599f, -0.272784f, -0.270229f, -0.923344f, 
		-0.358638f, -0.355866f, -0.862982f, -0.403837f, -0.401099f, -0.822214f, 
		-0.429837f, -0.427052f, -0.795529f, -0.444699f, -0.441947f, -0.779055f, 
		-0.452328f, -0.449635f, -0.770213f, -0.455021f, -0.452251f, -0.767088f, 
		-0.452566f, -0.449890f, -0.769924f, -0.444630f, -0.441951f, -0.779091f, 
		-0.429575f, -0.426826f, -0.795792f, -0.314340f, -0.311852f, -0.896626f, 
		0.178175f, -0.178813f, -0.967615f, 0.600133f, -0.597441f, 0.531888f, 
		-0.204365f, 0.204609f, 0.957272f, -0.562004f, 0.560229f, -0.608519f, 
		-0.0948273f, 0.0939113f, -0.991054f, -0.181394f, 0.179586f, -0.966874f, 
		-0.255913f, 0.253693f, -0.932818f, -0.307904f, 0.305393f, -0.901072f, 
		-0.331154f, 0.328506f, -0.884546f, -0.323084f, 0.320601f, -0.890411f, 
		-0.283035f, 0.280702f, -0.917114f, -0.214929f, 0.212770f, -0.953171f, 
		-0.127686f, 0.126126f, -0.983762f, -0.0335168f, 0.0330741f, -0.998891f, 
		0.0549811f, -0.0543466f, -0.997007f, -0.213264f, 0.213064f, -0.953479f, 
		-0.487160f, 0.485088f, -0.726199f, -0.386745f, 0.384301f, -0.838297f, 
		-0.306528f, 0.303992f, -0.902014f, -0.242417f, 0.240109f, -0.939990f, 
		-0.189845f, 0.187910f, -0.963664f, -0.144753f, 0.143174f, -0.979055f, 
		-0.103947f, 0.102769f, -0.989259f, -0.0647957f, 0.0640375f, -0.995842f, 
		-0.0247088f, 0.0244193f, -0.999396f, 0.0190300f, -0.0188318f, -0.999642f, 
		0.0703233f, -0.0695142f, -0.995099f, 0.0643739f, -0.0634821f, -0.995905f, 
		-0.0917428f, 0.0909945f, -0.991616f, -0.272465f, 0.270205f, -0.923446f, 
		-0.358240f, 0.355764f, -0.863189f, -0.403409f, 0.400930f, -0.822506f, 
		-0.429407f, 0.426962f, -0.795809f, -0.444253f, 0.441797f, -0.779394f, 
		-0.451905f, 0.449635f, -0.770461f, -0.454608f, 0.452317f, -0.767294f, 
		-0.452132f, 0.449822f, -0.770219f, -0.444174f, 0.441725f, -0.779480f, 
		-0.429122f, 0.426590f, -0.796163f, -0.313977f, 0.311737f, -0.896793f, 
		3.78571e-007f, -0.346095f, -0.938200f, 6.86363e-007f, -0.914081f, 0.405531f, 
		5.12578e-007f, 0.392574f, 0.919720f, -1.41220e-006f, 0.879576f, -0.475759f, 
		2.38833e-007f, 0.186191f, -0.982514f, 4.56018e-007f, 0.348113f, -0.937452f, 
		1.09601e-007f, 0.477487f, -0.878639f, -1.57391e-007f, 0.560486f, -0.828164f, 
		-4.34237e-007f, 0.595556f, -0.803314f, 8.25262e-007f, 0.583723f, -0.811953f, 
		-8.95464e-008f, 0.521625f, -0.853175f, -1.42693e-006f, 0.407420f, -0.913241f, 
		-2.59667e-006f, 0.248337f, -0.968674f, -8.48784e-007f, 0.0660880f, -0.997814f, 
		1.04785e-006f, -0.108396f, -0.994108f, 1.00543e-006f, 0.407575f, -0.913172f, 
		3.96379e-007f, 0.799631f, -0.600491f, -2.07934e-007f, 0.674964f, -0.737850f, 
		-5.12918e-007f, 0.558309f, -0.829633f, -7.33231e-007f, 0.454588f, -0.890702f, 
		-4.17611e-007f, 0.363175f, -0.931721f, 1.91293e-007f, 0.280659f, -0.959807f, 
		6.31559e-007f, 0.203429f, -0.979090f, -1.03180e-006f, 0.127580f, -0.991828f, 
		-1.78191e-006f, 0.0488211f, -0.998808f, -1.06525e-006f, -0.0376599f, -0.999291f, 
		-1.56456e-006f, -0.138390f, -0.990378f, -1.38849e-006f, -0.126483f, -0.991969f, 
		-1.33130e-007f, 0.180481f, -0.983579f, 3.04105e-007f, 0.504662f, -0.863317f, 
		9.22463e-007f, 0.635305f, -0.772261f, 6.58717e-007f, 0.697152f, -0.716923f, 
		1.74160e-007f, 0.730580f, -0.682827f, 1.06940e-006f, 0.748905f, -0.662678f, 
		4.20268e-007f, 0.758428f, -0.651756f, 1.20852e-007f, 0.761635f, -0.648006f, 
		-1.12082e-007f, 0.758649f, -0.651500f, 5.50243e-008f, 0.748838f, -0.662753f, 
		-1.36102e-007f, 0.730091f, -0.683350f, -4.72592e-007f, 0.570244f, -0.821475f, 
		4.06103e-007f, -0.346094f, -0.938200f, 6.75580e-007f, -0.914081f, 0.405531f, 
		4.74810e-007f, 0.392574f, 0.919720f, -1.01318e-006f, 0.879576f, -0.475758f, 
		4.08072e-007f, 0.186167f, -0.982518f, 1.62191e-006f, 0.348131f, -0.937446f, 
		1.15977e-006f, 0.477524f, -0.878619f, -1.25957e-007f, 0.560493f, -0.828159f, 
		-3.26237e-007f, 0.595567f, -0.803305f, 6.36751e-007f, 0.583725f, -0.811952f, 
		-7.33436e-008f, 0.521627f, -0.853174f, -1.12812e-006f, 0.407426f, -0.913238f, 
		-2.07691e-006f, 0.248342f, -0.968672f, -6.73229e-007f, 0.0660909f, -0.997814f, 
		8.57498e-007f, -0.108396f, -0.994108f, 8.39813e-007f, 0.407571f, -0.913173f, 
		3.30987e-007f, 0.799633f, -0.600489f, -1.76904e-007f, 0.674971f, -0.737844f, 
		-4.47503e-007f, 0.558311f, -0.829632f, -6.44696e-007f, 0.454591f, -0.890700f, 
		-3.73615e-007f, 0.363177f, -0.931720f, 1.78677e-007f, 0.280659f, -0.959807f, 
		5.86504e-007f, 0.203429f, -0.979090f, -9.88010e-007f, 0.127579f, -0.991828f, 
		-1.70528e-006f, 0.0488206f, -0.998808f, -1.03954e-006f, -0.0376601f, -0.999291f, 
		-1.54793e-006f, -0.138391f, -0.990378f, -1.38334e-006f, -0.126483f, -0.991969f, 
		-1.32409e-007f, 0.180480f, -0.983579f, 3.05308e-007f, 0.504660f, -0.863318f, 
		9.32765e-007f, 0.635303f, -0.772263f, 6.64980e-007f, 0.697149f, -0.716927f, 
		1.78830e-007f, 0.730581f, -0.682826f, 1.09383e-006f, 0.748910f, -0.662672f, 
		4.29633e-007f, 0.758425f, -0.651760f, 1.26050e-007f, 0.761624f, -0.648020f, 
		-1.18075e-007f, 0.758647f, -0.651501f, 5.94670e-008f, 0.748845f, -0.662745f, 
		-1.44801e-007f, 0.730098f, -0.683342f, -4.92576e-007f, 0.570251f, -0.821470f, 
		3.90604e-007f, -0.346095f, -0.938200f, 6.49796e-007f, -0.914081f, 0.405532f, 
		4.56689e-007f, 0.392575f, 0.919720f, -9.74528e-007f, 0.879576f, -0.475758f, 
		3.92483e-007f, 0.186167f, -0.982518f, 1.56001e-006f, 0.348132f, -0.937445f, 
		1.11550e-006f, 0.477520f, -0.878621f, -1.21139e-007f, 0.560476f, -0.828171f, 
		-3.13751e-007f, 0.595568f, -0.803305f, 6.12460e-007f, 0.583734f, -0.811945f, 
		-7.05445e-008f, 0.521624f, -0.853176f, -1.08509e-006f, 0.407430f, -0.913236f, 
		-1.99770e-006f, 0.248349f, -0.968671f, -6.47575e-007f, 0.0660927f, -0.997813f, 
		8.24758e-007f, -0.108395f, -0.994108f, 8.07754e-007f, 0.407567f, -0.913175f, 
		3.18353e-007f, 0.799628f, -0.600496f, -1.70151e-007f, 0.674964f, -0.737851f, 
		-4.30426e-007f, 0.558308f, -0.829634f, -6.20094e-007f, 0.454593f, -0.890700f, 
		-3.59358e-007f, 0.363178f, -0.931720f, 1.71855e-007f, 0.280659f, -0.959808f, 
		5.64114e-007f, 0.203427f, -0.979090f, -9.50304e-007f, 0.127578f, -0.991829f, 
		-1.64020e-006f, 0.0488205f, -0.998808f, -9.99872e-007f, -0.0376601f, -0.999291f, 
		-1.48884e-006f, -0.138390f, -0.990378f, -1.33052e-006f, -0.126480f, -0.991969f, 
		-1.27341e-007f, 0.180481f, -0.983579f, 2.93654e-007f, 0.504656f, -0.863321f, 
		8.97160e-007f, 0.635298f, -0.772267f, 6.39598e-007f, 0.697141f, -0.716934f, 
		1.72009e-007f, 0.730576f, -0.682831f, 1.05209e-006f, 0.748910f, -0.662672f, 
		4.13235e-007f, 0.758428f, -0.651757f, 1.21241e-007f, 0.761630f, -0.648012f, 
		-1.13560e-007f, 0.758646f, -0.651503f, 5.71964e-008f, 0.748835f, -0.662756f, 
		-1.39291e-007f, 0.730098f, -0.683342f, -4.73788e-007f, 0.570257f, -0.821466f, 
		3.85699e-007f, -0.346094f, -0.938200f, 6.41638e-007f, -0.914081f, 0.405531f, 
		4.50955e-007f, 0.392574f, 0.919720f, -9.62292e-007f, 0.879576f, -0.475758f, 
		3.87564e-007f, 0.186168f, -0.982518f, 1.54045e-006f, 0.348137f, -0.937444f, 
		1.10151e-006f, 0.477525f, -0.878618f, -1.19616e-007f, 0.560478f, -0.828169f, 
		-3.09813e-007f, 0.595568f, -0.803305f, 6.04774e-007f, 0.583738f, -0.811942f, 
		-6.96498e-008f, 0.521625f, -0.853175f, -1.07147e-006f, 0.407430f, -0.913237f, 
		-1.97259e-006f, 0.248349f, -0.968671f, -6.39401e-007f, 0.0660900f, -0.997814f, 
		8.14404e-007f, -0.108395f, -0.994108f, 7.97609e-007f, 0.407566f, -0.913176f, 
		3.14356e-007f, 0.799624f, -0.600501f, -1.68013e-007f, 0.674959f, -0.737855f, 
		-4.25023e-007f, 0.558307f, -0.829634f, -6.12306e-007f, 0.454590f, -0.890701f, 
		-3.54840e-007f, 0.363173f, -0.931722f, 1.69697e-007f, 0.280657f, -0.959808f, 
		5.57034e-007f, 0.203428f, -0.979090f, -9.38381e-007f, 0.127580f, -0.991828f, 
		-1.61962e-006f, 0.0488210f, -0.998808f, -9.87312e-007f, -0.0376597f, -0.999291f, 
		-1.47013e-006f, -0.138388f, -0.990378f, -1.31385e-006f, -0.126483f, -0.991969f, 
		-1.25797e-007f, 0.180478f, -0.983579f, 2.89968e-007f, 0.504658f, -0.863320f, 
		8.85924e-007f, 0.635310f, -0.772257f, 6.31593e-007f, 0.697156f, -0.716920f, 
		1.69853e-007f, 0.730586f, -0.682820f, 1.03888e-006f, 0.748914f, -0.662667f, 
		4.08041e-007f, 0.758430f, -0.651755f, 1.19717e-007f, 0.761634f, -0.648007f, 
		-1.12135e-007f, 0.758648f, -0.651501f, 5.64845e-008f, 0.748842f, -0.662748f, 
		-1.37537e-007f, 0.730105f, -0.683335f, -4.67842e-007f, 0.570258f, -0.821465f, 
		3.90600e-007f, -0.346095f, -0.938200f, 6.49798e-007f, -0.914082f, 0.405530f, 
		4.56689e-007f, 0.392575f, 0.919720f, -9.74528e-007f, 0.879576f, -0.475758f, 
		3.92483e-007f, 0.186167f, -0.982518f, 1.56001e-006f, 0.348132f, -0.937445f, 
		1.11553e-006f, 0.477532f, -0.878614f, -1.21143e-007f, 0.560500f, -0.828154f, 
		-3.13778e-007f, 0.595580f, -0.803296f, 6.12461e-007f, 0.583734f, -0.811945f, 
		-7.05444e-008f, 0.521624f, -0.853175f, -1.08509e-006f, 0.407430f, -0.913236f, 
		-1.99764e-006f, 0.248345f, -0.968672f, -6.47516e-007f, 0.0660890f, -0.997814f, 
		8.24759e-007f, -0.108395f, -0.994108f, 8.07755e-007f, 0.407567f, -0.913175f, 
		3.18356e-007f, 0.799621f, -0.600505f, -1.70148e-007f, 0.674956f, -0.737858f, 
		-4.30426e-007f, 0.558307f, -0.829634f, -6.20089e-007f, 0.454588f, -0.890702f, 
		-3.59352e-007f, 0.363174f, -0.931722f, 1.71854e-007f, 0.280659f, -0.959808f, 
		5.64120e-007f, 0.203429f, -0.979090f, -9.50327e-007f, 0.127582f, -0.991828f, 
		-1.64023e-006f, 0.0488216f, -0.998807f, -9.99856e-007f, -0.0376590f, -0.999291f, 
		-1.48883e-006f, -0.138389f, -0.990378f, -1.33058e-006f, -0.126485f, -0.991969f, 
		-1.27400e-007f, 0.180477f, -0.983579f, 2.93654e-007f, 0.504656f, -0.863320f, 
		8.97200e-007f, 0.635314f, -0.772254f, 6.39638e-007f, 0.697155f, -0.716920f, 
		1.72023e-007f, 0.730588f, -0.682819f, 1.05210e-006f, 0.748922f, -0.662659f, 
		4.13234e-007f, 0.758428f, -0.651757f, 1.21241e-007f, 0.761631f, -0.648011f, 
		-1.13559e-007f, 0.758646f, -0.651503f, 5.72128e-008f, 0.748847f, -0.662743f, 
		-1.39275e-007f, 0.730110f, -0.683330f, -4.73789e-007f, 0.570255f, -0.821468f, 
		4.06101e-007f, -0.346095f, -0.938199f, 6.75585e-007f, -0.914082f, 0.405530f, 
		4.74813e-007f, 0.392574f, 0.919720f, -1.01318e-006f, 0.879576f, -0.475759f, 
		4.08065e-007f, 0.186164f, -0.982519f, 1.62190e-006f, 0.348125f, -0.937448f, 
		1.15978e-006f, 0.477527f, -0.878617f, -1.25926e-007f, 0.560491f, -0.828161f, 
		-3.26215e-007f, 0.595564f, -0.803308f, 6.36764e-007f, 0.583732f, -0.811946f, 
		-7.33432e-008f, 0.521632f, -0.853171f, -1.12814e-006f, 0.407428f, -0.913237f, 
		-2.07693e-006f, 0.248342f, -0.968672f, -6.73240e-007f, 0.0660908f, -0.997814f, 
		8.57494e-007f, -0.108394f, -0.994108f, 8.39804e-007f, 0.407566f, -0.913176f, 
		3.30990e-007f, 0.799618f, -0.600509f, -1.76899e-007f, 0.674953f, -0.737861f, 
		-4.47506e-007f, 0.558306f, -0.829635f, -6.44701e-007f, 0.454590f, -0.890701f, 
		-3.73619e-007f, 0.363179f, -0.931719f, 1.78672e-007f, 0.280660f, -0.959807f, 
		5.86504e-007f, 0.203428f, -0.979090f, -9.88044e-007f, 0.127581f, -0.991828f, 
		-1.70531e-006f, 0.0488215f, -0.998807f, -1.03954e-006f, -0.0376595f, -0.999291f, 
		-1.54794e-006f, -0.138391f, -0.990378f, -1.38337e-006f, -0.126484f, -0.991969f, 
		-1.32417e-007f, 0.180482f, -0.983578f, 3.05312e-007f, 0.504663f, -0.863317f, 
		9.32815e-007f, 0.635321f, -0.772248f, 6.65037e-007f, 0.697149f, -0.716926f, 
		1.78854e-007f, 0.730577f, -0.682830f, 1.09385e-006f, 0.748918f, -0.662663f, 
		4.29628e-007f, 0.758430f, -0.651754f, 1.26052e-007f, 0.761637f, -0.648004f, 
		-1.18063e-007f, 0.758648f, -0.651501f, 5.94808e-008f, 0.748844f, -0.662746f, 
		-1.44806e-007f, 0.730108f, -0.683332f, -4.92593e-007f, 0.570255f, -0.821468f, 
		4.34909e-007f, -0.346095f, -0.938199f, 7.23504e-007f, -0.914081f, 0.405531f, 
		5.08491e-007f, 0.392573f, 0.919721f, -1.08505e-006f, 0.879577f, -0.475757f, 
		4.37012e-007f, 0.186165f, -0.982518f, 1.73693e-006f, 0.348119f, -0.937450f, 
		1.24202e-006f, 0.477517f, -0.878622f, -1.34838e-007f, 0.560475f, -0.828171f, 
		-3.49329e-007f, 0.595548f, -0.803320f, 6.81921e-007f, 0.583726f, -0.811951f, 
		-7.85307e-008f, 0.521618f, -0.853179f, -1.20814e-006f, 0.407417f, -0.913242f, 
		-2.22428e-006f, 0.248344f, -0.968672f, -7.21029e-007f, 0.0660926f, -0.997813f, 
		9.18305e-007f, -0.108393f, -0.994108f, 8.99371e-007f, 0.407568f, -0.913175f, 
		3.54466e-007f, 0.799623f, -0.600503f, -1.89449e-007f, 0.674961f, -0.737854f, 
		-4.79256e-007f, 0.558314f, -0.829630f, -6.90437e-007f, 0.454595f, -0.890698f, 
		-4.00119e-007f, 0.363178f, -0.931720f, 1.91346e-007f, 0.280660f, -0.959807f, 
		6.28102e-007f, 0.203427f, -0.979090f, -1.05811e-006f, 0.127579f, -0.991828f, 
		-1.82625e-006f, 0.0488209f, -0.998808f, -1.11326e-006f, -0.0376595f, -0.999291f, 
		-1.65773e-006f, -0.138390f, -0.990378f, -1.48145e-006f, -0.126482f, -0.991969f, 
		-1.41769e-007f, 0.180490f, -0.983577f, 3.26978e-007f, 0.504677f, -0.863308f, 
		9.98980e-007f, 0.635329f, -0.772241f, 7.12209e-007f, 0.697149f, -0.716926f, 
		1.91528e-007f, 0.730568f, -0.682840f, 1.17141e-006f, 0.748904f, -0.662678f, 
		4.60090e-007f, 0.758431f, -0.651754f, 1.34990e-007f, 0.761641f, -0.647999f, 
		-1.26445e-007f, 0.758653f, -0.651495f, 6.36874e-008f, 0.748846f, -0.662744f, 
		-1.55072e-007f, 0.730100f, -0.683340f, -5.27520e-007f, 0.570251f, -0.821471f, 
		4.83004e-007f, -0.346095f, -0.938200f, 8.03512e-007f, -0.914081f, 0.405531f, 
		5.64723e-007f, 0.392574f, 0.919720f, -1.20507e-006f, 0.879576f, -0.475758f, 
		4.85337e-007f, 0.186169f, -0.982518f, 1.92903e-006f, 0.348125f, -0.937448f, 
		1.37936e-006f, 0.477514f, -0.878624f, -1.49790e-007f, 0.560477f, -0.828170f, 
		-3.87978e-007f, 0.595562f, -0.803310f, 7.57335e-007f, 0.583728f, -0.811950f, 
		-8.72137e-008f, 0.521612f, -0.853183f, -1.34175e-006f, 0.407418f, -0.913242f, 
		-2.47027e-006f, 0.248348f, -0.968671f, -8.00754e-007f, 0.0660925f, -0.997814f, 
		1.01987e-006f, -0.108393f, -0.994108f, 9.98838e-007f, 0.407576f, -0.913171f, 
		3.93667e-007f, 0.799632f, -0.600491f, -2.10401e-007f, 0.674966f, -0.737849f, 
		-5.32249e-007f, 0.558311f, -0.829632f, -7.66780e-007f, 0.454590f, -0.890701f, 
		-4.44362e-007f, 0.363175f, -0.931721f, 2.12509e-007f, 0.280659f, -0.959807f, 
		6.97563e-007f, 0.203428f, -0.979090f, -1.17512e-006f, 0.127579f, -0.991828f, 
		-2.02820e-006f, 0.0488207f, -0.998808f, -1.23638e-006f, -0.0376593f, -0.999291f, 
		-1.84104e-006f, -0.138390f, -0.990378f, -1.64527e-006f, -0.126481f, -0.991969f, 
		-1.57448e-007f, 0.180486f, -0.983577f, 3.63128e-007f, 0.504673f, -0.863311f, 
		1.10941e-006f, 0.635316f, -0.772252f, 7.90928e-007f, 0.697139f, -0.716936f, 
		2.12709e-007f, 0.730569f, -0.682838f, 1.30095e-006f, 0.748901f, -0.662682f, 
		5.10963e-007f, 0.758427f, -0.651758f, 1.49919e-007f, 0.761643f, -0.647997f, 
		-1.40427e-007f, 0.758654f, -0.651493f, 7.07295e-008f, 0.748846f, -0.662744f, 
		-1.72217e-007f, 0.730097f, -0.683344f, -5.85851e-007f, 0.570248f, -0.821473f, 
		5.63518e-007f, -0.346095f, -0.938200f, 9.37456e-007f, -0.914081f, 0.405531f, 
		6.58863e-007f, 0.392578f, 0.919719f, -1.40591e-006f, 0.879574f, -0.475762f, 
		5.66243e-007f, 0.186166f, -0.982518f, 2.25061e-006f, 0.348130f, -0.937446f, 
		1.60934e-006f, 0.477524f, -0.878619f, -1.74764e-007f, 0.560487f, -0.828163f, 
		-4.52674e-007f, 0.595565f, -0.803307f, 8.83585e-007f, 0.583732f, -0.811947f, 
		-1.01764e-007f, 0.521630f, -0.853172f, -1.56542e-006f, 0.407425f, -0.913239f, 
		-2.88200e-006f, 0.248343f, -0.968672f, -9.34180e-007f, 0.0660909f, -0.997814f, 
		1.18991e-006f, -0.108394f, -0.994108f, 1.16534e-006f, 0.407571f, -0.913173f, 
		4.59288e-007f, 0.799628f, -0.600496f, -2.45473e-007f, 0.674962f, -0.737853f, 
		-6.20966e-007f, 0.558305f, -0.829636f, -8.94598e-007f, 0.454590f, -0.890701f, 
		-5.18442e-007f, 0.363178f, -0.931720f, 2.47938e-007f, 0.280660f, -0.959807f, 
		8.13849e-007f, 0.203429f, -0.979090f, -1.37101e-006f, 0.127579f, -0.991828f, 
		-2.36632e-006f, 0.0488210f, -0.998808f, -1.44250e-006f, -0.0376598f, -0.999291f, 
		-2.14795e-006f, -0.138391f, -0.990378f, -1.91956e-006f, -0.126482f, -0.991969f, 
		-1.83735e-007f, 0.180474f, -0.983580f, 4.23642e-007f, 0.504660f, -0.863318f, 
		1.29437e-006f, 0.635317f, -0.772251f, 9.22790e-007f, 0.697146f, -0.716929f, 
		2.48168e-007f, 0.730576f, -0.682831f, 1.51783e-006f, 0.748909f, -0.662673f, 
		5.96152e-007f, 0.758427f, -0.651758f, 1.74910e-007f, 0.761636f, -0.648005f, 
		-1.63839e-007f, 0.758653f, -0.651496f, 8.25286e-008f, 0.748850f, -0.662739f, 
		-2.00924e-007f, 0.730106f, -0.683334f, -6.83520e-007f, 0.570253f, -0.821469f, 
		7.09484e-007f, -0.346096f, -0.938199f, 1.18028e-006f, -0.914081f, 0.405531f, 
		8.29527e-007f, 0.392577f, 0.919719f, -1.77005e-006f, 0.879574f, -0.475762f, 
		7.12887e-007f, 0.186161f, -0.982519f, 2.83356e-006f, 0.348131f, -0.937446f, 
		2.02620e-006f, 0.477524f, -0.878618f, -2.20049e-007f, 0.560482f, -0.828167f, 
		-5.69918e-007f, 0.595566f, -0.803307f, 1.11247e-006f, 0.583736f, -0.811944f, 
		-1.28128e-007f, 0.521634f, -0.853170f, -1.97091e-006f, 0.407427f, -0.913238f, 
		-3.62849e-006f, 0.248340f, -0.968673f, -1.17616e-006f, 0.0660901f, -0.997814f, 
		1.49810e-006f, -0.108395f, -0.994108f, 1.46717e-006f, 0.407560f, -0.913178f, 
		5.78245e-007f, 0.799619f, -0.600507f, -3.09057e-007f, 0.674959f, -0.737855f, 
		-7.81816e-007f, 0.558305f, -0.829636f, -1.12632e-006f, 0.454590f, -0.890701f, 
		-6.52728e-007f, 0.363177f, -0.931720f, 3.12157e-007f, 0.280659f, -0.959808f, 
		1.02465e-006f, 0.203428f, -0.979090f, -1.72615e-006f, 0.127579f, -0.991828f, 
		-2.97926e-006f, 0.0488210f, -0.998808f, -1.81613e-006f, -0.0376592f, -0.999291f, 
		-2.70430e-006f, -0.138389f, -0.990378f, -2.41679e-006f, -0.126483f, -0.991969f, 
		-2.31332e-007f, 0.180484f, -0.983578f, 5.33404e-007f, 0.504673f, -0.863311f, 
		1.62966e-006f, 0.635326f, -0.772244f, 1.16183e-006f, 0.697154f, -0.716921f, 
		3.12450e-007f, 0.730581f, -0.682826f, 1.91098e-006f, 0.748907f, -0.662675f, 
		7.50563e-007f, 0.758423f, -0.651762f, 2.20230e-007f, 0.761641f, -0.647999f, 
		-2.06257e-007f, 0.758655f, -0.651493f, 1.03905e-007f, 0.748844f, -0.662746f, 
		-2.52970e-007f, 0.730099f, -0.683341f, -8.60563e-007f, 0.570248f, -0.821473f, 
		5.11570e-007f, -0.346095f, -0.938199f, 1.25668e-006f, -0.914081f, 0.405531f, 
		8.91950e-006f, 0.392570f, 0.919722f, -8.43512e-005f, 0.887201f, 0.461382f, 
		7.51026e-006f, 0.271452f, -0.962452f, 6.54696e-005f, 0.348134f, -0.937445f, 
		2.13466e-005f, 0.477532f, -0.878614f, 3.72481e-007f, 0.560484f, -0.828165f, 
		-4.39570e-006f, 0.595572f, -0.803302f, 5.63666e-006f, 0.583745f, -0.811937f, 
		-2.30119e-007f, 0.521632f, -0.853170f, -7.37521e-006f, 0.407428f, -0.913237f, 
		-1.21140e-005f, 0.248344f, -0.968672f, -4.13774e-006f, 0.0660900f, -0.997814f, 
		4.13869e-006f, -0.108393f, -0.994108f, 3.52335e-006f, 0.407560f, -0.913178f, 
		1.38563e-006f, 0.799618f, -0.600509f, -6.66343e-007f, 0.674959f, -0.737855f, 
		-1.48368e-006f, 0.558309f, -0.829633f, -2.06520e-006f, 0.454589f, -0.890701f, 
		-1.11177e-006f, 0.363172f, -0.931722f, 4.51547e-007f, 0.280659f, -0.959808f, 
		1.52113e-006f, 0.203428f, -0.979090f, -2.32377e-006f, 0.127579f, -0.991828f, 
		-4.02339e-006f, 0.0488206f, -0.998808f, -2.32154e-006f, -0.0376594f, -0.999291f, 
		-3.33366e-006f, -0.138389f, -0.990378f, -2.92660e-006f, -0.126483f, -0.991969f, 
		-2.81209e-007f, 0.180471f, -0.983580f, 6.33796e-007f, 0.504653f, -0.863322f, 
		1.90359e-006f, 0.635309f, -0.772258f, 1.36233e-006f, 0.697142f, -0.716933f, 
		3.52236e-007f, 0.730580f, -0.682828f, 2.17391e-006f, 0.748907f, -0.662675f, 
		8.54798e-007f, 0.758411f, -0.651777f, 2.39909e-007f, 0.761632f, -0.648010f, 
		-2.19977e-007f, 0.758653f, -0.651495f, 1.04803e-007f, 0.748836f, -0.662756f, 
		-2.64468e-007f, 0.730096f, -0.683345f, -9.38969e-007f, 0.570253f, -0.821469f
	};
	static const GLint Indices[] = {
		8836, 8835, 8750, 8835, 8749, 8834, 8748, 8833, 8747, 8832, 8746, 8831, 8745, 8830, 8744, 8829, 
		8743, 8828, 8742, 8827, 8741, 8826, 8740, 8825, 8739, 8824, 8738, 8823, 8737, 8822, 8736, 8821, 
		8735, 8820, 8734, 8819, 8733, 8818, 8732, 8817, 8731, 8816, 8730, 8815, 8729, 8814, 8728, 8813, 
		8727, 8812, 8726, 8811, 8725, 8810, 8724, 8809, 8723, 8808, 8722, 8807, 8721, 8806, 8720, 8805, 
		8719, 8804, 8718, 8803, 8717, 8802, 8716, 8801, 8715, 8800, 8714, 8799, 8713, 8798, 8712, 8797, 
		8711, 8796, 8710, 8795, 8709, 8794, 8708, 8793, 8707, 8792, 8706, 8791, 8705, 8790, 8704, 8789, 
		8703, 8788, 8702, 8787, 8701, 8786, 8700, 8785, 8699, 8784, 8698, 8783, 8697, 8782, 8696, 8781, 
		8695, 8780, 8694, 8779, 8693, 8778, 8692, 8777, 8691, 8862, 8776, 8861, 10591, 10551, 10591, 10552, 
		10592, 10553, 10593, 10554, 10594, 10555, 10595, 10556, 10596, 10557, 10597, 10558, 10598, 10559, 10599, 10560, 
		10600, 10561, 10601, 10562, 10602, 10563, 10603, 10564, 10604, 10565, 10605, 10566, 10606, 10567, 10607, 10568, 
		10608, 10569, 10609, 10570, 10610, 10571, 10611, 10572, 10612, 10573, 10551, 10511, 10551, 10512, 10552, 10513, 
		10553, 10514, 10554, 10515, 10555, 10516, 10556, 10517, 10557, 10518, 10558, 10519, 10559, 10520, 10560, 10521, 
		10561, 10522, 10562, 10523, 10563, 10524, 10564, 10525, 10565, 10526, 10566, 10527, 10567, 10528, 10568, 10529, 
		10569, 10530, 10570, 10531, 10571, 10532, 10572, 10533, 10573, 10534, 10511, 10471, 10511, 10472, 10512, 10473, 
		10513, 10474, 10514, 10475, 10515, 10476, 10516, 10477, 10517, 10478, 10518, 10479, 10519, 10480, 10520, 10481, 
		10521, 10482, 10522, 10483, 10523, 10484, 10524, 10485, 10525, 10486, 10526, 10487, 10527, 10488, 10528, 10489, 
		10529, 10490, 10530, 10491, 10531, 10492, 10532, 10493, 10533, 10494, 10534, 10495, 10471, 10431, 10471, 10432, 
		10472, 10433, 10473, 10434, 10474, 10435, 10475, 10436, 10476, 10437, 10477, 10438, 10478, 10439, 10479, 10440, 
		10480, 10441, 10481, 10442, 10482, 10443, 10483, 10444, 10484, 10445, 10485, 10446, 10486, 10447, 10487, 10448, 
		10488, 10449, 10489, 10450, 10490, 10451, 10491, 10452, 10492, 10453, 10493, 10454, 10494, 10455, 10495, 10456, 
		10431, 10391, 10431, 10392, 10432, 10393, 10433, 10394, 10434, 10395, 10435, 10396, 10436, 10397, 10437, 10398, 
		10438, 10399, 10439, 10400, 10440, 10401, 10441, 10402, 10442, 10403, 10443, 10404, 10444, 10405, 10445, 10406, 
		10446, 10407, 10447, 10408, 10448, 10409, 10449, 10410, 10450, 10411, 10451, 10412, 10452, 10413, 10453, 10414, 
		10454, 10415, 10455, 10416, 10456, 10417, 10391, 10351, 10391, 10352, 10392, 10353, 10393, 10354, 10394, 10355, 
		10395, 10356, 10396, 10357, 10397, 10358, 10398, 10359, 10399, 10360, 10400, 10361, 10401, 10362, 10402, 10363, 
		10403, 10364, 10404, 10365, 10405, 10366, 10406, 10367, 10407, 10368, 10408, 10369, 10409, 10370, 10410, 10371, 
		10411, 10372, 10412, 10373, 10413, 10374, 10414, 10375, 10415, 10376, 10416, 10377, 10417, 10378, 10351, 10311, 
		10351, 10312, 10352, 10313, 10353, 10314, 10354, 10315, 10355, 10316, 10356, 10317, 10357, 10318, 10358, 10319, 
		10359, 10320, 10360, 10321, 10361, 10322, 10362, 10323, 10363, 10324, 10364, 10325, 10365, 10326, 10366, 10327, 
		10367, 10328, 10368, 10329, 10369, 10330, 10370, 10331, 10371, 10332, 10372, 10333, 10373, 10334, 10374, 10335, 
		10375, 10336, 10376, 10337, 10377, 10338, 10378, 10339, 10311, 10271, 10311, 10272, 10312, 10273, 10313, 10274, 
		10314, 10275, 10315, 10276, 10316, 10277, 10317, 10278, 10318, 10279, 10319, 10280, 10320, 10281, 10321, 10282, 
		10322, 10283, 10323, 10284, 10324, 10285, 10325, 10286, 10326, 10287, 10327, 10288, 10328, 10289, 10329, 10290, 
		10330, 10291, 10331, 10292, 10332, 10293, 10333, 10294, 10334, 10295, 10335, 10296, 10336, 10297, 10337, 10298, 
		10338, 10299, 10339, 10300, 10271, 10231, 10271, 10232, 10272, 10233, 10273, 10234, 10274, 10235, 10275, 10236, 
		10276, 10237, 10277, 10238, 10278, 10239, 10279, 10240, 10280, 10241, 10281, 10242, 10282, 10243, 10283, 10244, 
		10284, 10245, 10285, 10246, 10286, 10247, 10287, 10248, 10288, 10249, 10289, 10250, 10290, 10251, 10291, 10252, 
		10292, 10253, 10293, 10254, 10294, 10255, 10295, 10256, 10296, 10257, 10297, 10258, 10298, 10259, 10299, 10260, 
		10300, 10261, 10231, 10191, 10231, 10192, 10232, 10193, 10233, 10194, 10234, 10195, 10235, 10196, 10236, 10197, 
		10237, 10198, 10238, 10199, 10239, 10200, 10240, 10201, 10241, 10202, 10242, 10203, 10243, 10204, 10244, 10205, 
		10245, 10206, 10246, 10207, 10247, 10208, 10248, 10209, 10249, 10210, 10250, 10211, 10251, 10212, 10252, 10213, 
		10253, 10214, 10254, 10215, 10255, 10216, 10256, 10217, 10257, 10218, 10258, 10219, 10259, 10220, 10260, 10221, 
		10261, 10222, 10191, 10151, 10191, 10152, 10192, 10153, 10193, 10154, 10194, 10155, 10195, 10156, 10196, 10157, 
		10197, 10158, 10198, 10159, 10199, 10160, 10200, 10161, 10201, 10162, 10202, 10163, 10203, 10164, 10204, 10165, 
		10205, 10166, 10206, 10167, 10207, 10168, 10208, 10169, 10209, 10170, 10210, 10171, 10211, 10172, 10212, 10173, 
		10213, 10174, 10214, 10175, 10215, 10176, 10216, 10177, 10217, 10178, 10218, 10179, 10219, 10180, 10220, 10181, 
		10221, 10182, 10222, 10183, 10151, 10111, 10151, 10112, 10152, 10113, 10153, 10114, 10154, 10115, 10155, 10116, 
		10156, 10117, 10157, 10118, 10158, 10119, 10159, 10120, 10160, 10121, 10161, 10122, 10162, 10123, 10163, 10124, 
		10164, 10125, 10165, 10126, 10166, 10127, 10167, 10128, 10168, 10129, 10169, 10130, 10170, 10131, 10171, 10132, 
		10172, 10133, 10173, 10134, 10174, 10135, 10175, 10136, 10176, 10137, 10177, 10138, 10178, 10139, 10179, 10140, 
		10180, 10141, 10181, 10142, 10182, 10143, 10183, 10144, 10111, 10071, 10111, 10072, 10112, 10073, 10113, 10074, 
		10114, 10075, 10115, 10076, 10116, 10077, 10117, 10078, 10118, 10079, 10119, 10080, 10120, 10081, 10121, 10082, 
		10122, 10083, 10123, 10084, 10124, 10085, 10125, 10086, 10126, 10087, 10127, 10088, 10128, 10089, 10129, 10090, 
		10130, 10091, 10131, 10092, 10132, 10093, 10133, 10094, 10134, 10095, 10135, 10096, 10136, 10097, 10137, 10098, 
		10138, 10099, 10139, 10100, 10140, 10101, 10141, 10102, 10142, 10103, 10143, 10104, 10144, 10105, 10666, 10105, 
		10665, 10104, 10664, 10103, 10663, 10102, 10662, 10101, 10661, 10100, 10660, 10099, 10659, 10098, 10658, 10097, 
		10657, 10096, 10656, 10095, 10655, 10094, 10654, 10093, 10653, 10092, 10652, 10091, 10651, 10090, 10650, 10089, 
		10649, 10088, 10648, 10087, 10647, 10086, 10646, 10085, 10645, 10084, 10644, 10083, 10643, 10082, 10642, 10081, 
		10641, 10080, 10640, 10079, 10639, 10078, 10638, 10077, 10637, 10076, 10636, 10075, 10635, 10074, 10634, 10073, 
		10633, 10072, 10632, 10071, 10631, 10070, 10630, 10629, 10590, 10589, 10550, 10549, 10510, 10509, 10470, 10469, 
		10430, 10429, 10390, 10389, 10350, 10349, 10310, 10309, 10270, 10269, 10230, 10229, 10190, 10189, 10150, 10149, 
		10110, 10109, 10070, 10069, 10629, 10068, 10628, 10067, 10627, 10106, 10666, 10106, 10105, 10145, 10144, 10184, 
		10183, 10223, 10222, 10262, 10261, 10301, 10300, 10340, 10339, 10379, 10378, 10418, 10417, 10457, 10456, 10496, 
		10495, 10535, 10534, 10574, 10573, 10613, 10612, 10652, 10612, 10651, 10611, 10650, 10610, 10649, 10609, 10648, 
		10608, 10647, 10607, 10646, 10606, 10645, 10605, 10644, 10604, 10643, 10603, 10642, 10602, 10641, 10601, 10640, 
		10600, 10639, 10599, 10638, 10598, 10637, 10597, 10636, 10596, 10635, 10595, 10634, 10594, 10633, 10593, 10632, 
		10592, 10631, 10591, 10630, 10591, 10590, 10551, 10550, 10511, 10510, 10471, 10470, 10431, 10430, 10391, 10390, 
		10351, 10350, 10311, 10310, 10271, 10270, 10231, 10230, 10191, 10190, 10151, 10150, 10111, 10110, 10071, 10070, 
		10628, 10627, 10588, 10587, 10548, 10547, 10508, 10507, 10468, 10467, 10428, 10427, 10388, 10387, 10348, 10347, 
		10308, 10307, 10268, 10267, 10228, 10227, 10188, 10187, 10148, 10147, 10108, 10147, 10107, 10186, 10146, 10186, 
		10185, 10225, 10224, 10264, 10263, 10303, 10302, 10342, 10341, 10381, 10380, 10420, 10419, 10459, 10458, 10498, 
		10497, 10537, 10536, 10576, 10575, 10615, 10614, 10654, 10653, 10627, 10666, 10587, 10626, 10547, 10586, 10507, 
		10546, 10467, 10506, 10427, 10466, 10387, 10426, 10347, 10386, 10307, 10346, 10267, 10306, 10227, 10266, 10187, 
		10226, 10147, 10226, 10186, 10226, 10225, 10265, 10264, 10304, 10303, 10343, 10342, 10382, 10381, 10421, 10420, 
		10460, 10459, 10499, 10498, 10538, 10537, 10577, 10576, 10616, 10615, 10655, 10654, 10266, 10265, 10226, 10656, 
		10655, 10656, 10616, 10617, 10577, 10578, 10538, 10539, 10499, 10500, 10460, 10461, 10421, 10422, 10382, 10383, 
		10343, 10344, 10304, 10305, 10265, 10305, 10266, 10305, 10306, 10345, 10346, 10385, 10386, 10425, 10426, 10465, 
		10466, 10505, 10506, 10545, 10546, 10585, 10586, 10625, 10626, 10665, 10666, 10345, 10344, 10305, 10657, 10656, 
		10657, 10617, 10618, 10578, 10579, 10539, 10540, 10500, 10501, 10461, 10462, 10422, 10423, 10383, 10384, 10344, 
		10384, 10345, 10384, 10385, 10424, 10425, 10464, 10465, 10504, 10505, 10544, 10545, 10584, 10585, 10624, 10625, 
		10664, 10665, 10424, 10423, 10384, 10658, 10657, 10658, 10618, 10619, 10579, 10580, 10540, 10541, 10501, 10502, 
		10462, 10463, 10423, 10463, 10424, 10463, 10464, 10503, 10504, 10543, 10544, 10583, 10584, 10623, 10624, 10663, 
		10664, 10503, 10502, 10463, 10659, 10658, 10659, 10619, 10620, 10580, 10581, 10541, 10542, 10502, 10542, 10503, 
		10542, 10543, 10582, 10583, 10622, 10623, 10662, 10663, 10582, 10581, 10542, 10660, 10659, 10660, 10620, 10621, 
		10581, 10621, 10582, 10621, 10622, 10661, 10662, 10661, 10660, 10621, 9980, 7743, 9979, 7742, 9978, 7741, 
		9977, 7740, 9976, 7739, 9975, 7738, 9974, 7737, 9973, 7736, 9972, 7735, 9971, 7734, 9970, 7733, 
		9969, 7732, 9968, 7731, 9967, 7730, 9966, 7729, 9965, 7728, 9964, 7727, 9963, 7726, 9962, 7725, 
		9961, 7724, 9960, 7723, 9959, 7722, 9958, 7721, 9957, 7720, 9956, 7719, 9955, 7718, 9954, 7717, 
		9953, 7716, 9952, 7715, 9951, 7714, 9950, 7713, 9949, 7712, 9948, 7711, 9947, 7710, 9946, 7709, 
		9945, 7708, 9944, 7707, 9943, 7706, 9942, 7705, 9941, 7704, 9940, 7703, 9939, 7702, 9938, 7701, 
		9937, 7700, 9936, 7699, 9935, 7698, 9934, 7697, 9933, 7696, 9932, 7695, 9931, 7694, 9930, 7693, 
		9929, 7692, 9928, 7691, 9927, 7690, 9926, 7689, 9925, 7688, 9924, 7687, 9923, 7686, 9922, 7685, 
		9921, 7684, 9920, 7683, 9919, 7682, 9918, 7681, 9917, 7680, 9916, 7679, 9915, 7678, 9914, 7677, 
		9913, 7676, 9912, 7675, 9911, 7674, 9910, 7673, 9909, 7672, 9908, 7671, 9907, 7670, 9906, 7669, 
		9905, 7668, 9904, 7667, 9903, 7666, 9902, 7665, 9901, 7664, 9900, 7663, 9899, 7662, 9898, 7661, 
		9897, 7660, 9896, 7659, 9895, 7744, 9980, 7744, 7743, 7829, 7828, 7914, 7913, 7999, 7998, 8084, 
		8083, 8169, 8168, 8254, 8253, 8339, 8338, 8424, 8423, 8509, 8508, 8594, 8593, 8679, 8678, 8764, 
		8763, 8849, 8848, 8934, 8933, 9019, 9018, 9104, 9103, 9189, 9188, 9274, 9273, 9359, 9358, 9444, 
		9443, 9529, 9528, 9614, 9613, 9699, 9698, 9784, 9783, 9869, 9868, 9954, 9868, 9953, 9867, 9952, 
		9866, 9951, 9865, 9950, 9864, 9949, 9863, 9948, 9862, 9947, 9861, 9946, 9860, 9945, 9859, 9944, 
		9858, 9943, 9857, 9942, 9856, 9941, 9855, 9940, 9854, 9939, 9853, 9938, 9852, 9937, 9851, 9936, 
		9850, 9935, 9849, 9934, 9848, 9933, 9847, 9932, 9846, 9931, 9845, 9930, 9844, 9929, 9843, 9928, 
		9842, 9927, 9841, 9926, 9840, 9925, 9839, 9924, 9838, 9923, 9837, 9922, 9836, 9921, 9835, 9920, 
		9834, 9919, 9833, 9918, 9832, 9917, 9831, 9916, 9830, 9915, 9829, 9914, 9828, 9913, 9827, 9912, 
		9826, 9911, 9825, 9910, 9824, 9909, 9823, 9908, 9822, 9907, 9821, 9906, 9820, 9905, 9819, 9904, 
		9818, 9903, 9817, 9902, 9816, 9901, 9815, 9900, 9814, 9899, 9813, 9898, 9812, 9897, 9811, 9896, 
		9810, 9895, 9809, 9980, 9894, 9979, 9893, 9978, 9892, 9977, 9891, 9976, 9890, 9975, 9889, 9974, 
		9888, 9973, 9887, 9972, 9886, 9971, 9885, 9970, 9884, 9969, 9883, 9968, 9882, 9967, 9881, 9966, 
		9880, 9965, 9879, 9964, 9878, 9963, 9877, 9962, 9876, 9961, 9875, 9960, 9874, 9959, 9873, 9958, 
		9872, 9957, 9871, 9956, 9870, 9955, 9869, 9954, 7828, 7742, 7743, 9870, 9869, 9870, 9784, 9785, 
		9699, 9700, 9614, 9615, 9529, 9530, 9444, 9445, 9359, 9360, 9274, 9275, 9189, 9190, 9104, 9105, 
		9019, 9020, 8934, 8935, 8849, 8850, 8764, 8765, 8679, 8680, 8594, 8595, 8509, 8510, 8424, 8425, 
		8339, 8340, 8254, 8255, 8169, 8170, 8084, 8085, 7999, 8000, 7914, 7915, 7829, 7830, 7744, 7830, 
		7659, 7745, 7660, 7746, 7661, 7747, 7662, 7748, 7663, 7749, 7664, 7750, 7665, 7751, 7666, 7752, 
		7667, 7753, 7668, 7754, 7669, 7755, 7670, 7756, 7671, 7757, 7672, 7758, 7673, 7759, 7674, 7760, 
		7675, 7761, 7676, 7762, 7677, 7763, 7678, 7764, 7679, 7765, 7680, 7766, 7681, 7767, 7682, 7768, 
		7683, 7769, 7684, 7770, 7685, 7771, 7686, 7772, 7687, 7773, 7688, 7774, 7689, 7775, 7690, 7776, 
		7691, 7777, 7692, 7778, 7693, 7779, 7694, 7780, 7695, 7781, 7696, 7782, 7697, 7783, 7698, 7784, 
		7699, 7785, 7700, 7786, 7701, 7787, 7702, 7788, 7703, 7789, 7704, 7790, 7705, 7791, 7706, 7792, 
		7707, 7793, 7708, 7794, 7709, 7795, 7710, 7796, 7711, 7797, 7712, 7798, 7713, 7799, 7714, 7800, 
		7715, 7801, 7716, 7802, 7717, 7803, 7718, 7804, 7719, 7805, 7720, 7806, 7721, 7807, 7722, 7808, 
		7723, 7809, 7724, 7810, 7725, 7811, 7726, 7812, 7727, 7813, 7728, 7814, 7729, 7815, 7730, 7816, 
		7731, 7817, 7732, 7818, 7733, 7819, 7734, 7820, 7735, 7821, 7736, 7822, 7737, 7823, 7738, 7824, 
		7739, 7825, 7740, 7826, 7741, 7827, 7742, 7827, 7828, 7827, 7913, 7912, 7998, 7997, 8083, 8082, 
		8168, 8167, 8253, 8252, 8338, 8337, 8423, 8422, 8508, 8507, 8593, 8592, 8678, 8677, 8763, 8762, 
		8848, 8847, 8933, 8932, 9018, 9017, 9103, 9102, 9188, 9187, 9273, 9272, 9358, 9357, 9443, 9442, 
		9528, 9527, 9613, 9612, 9698, 9697, 9783, 9782, 9868, 9782, 9867, 9781, 9866, 9780, 9865, 9779, 
		9864, 9778, 9863, 9777, 9862, 9776, 9861, 9775, 9860, 9774, 9859, 9773, 9858, 9772, 9857, 9771, 
		9856, 9770, 9855, 9769, 9854, 9768, 9853, 9767, 9852, 9766, 9851, 9765, 9850, 9764, 9849, 9763, 
		9848, 9762, 9847, 9761, 9846, 9760, 9845, 9759, 9844, 9758, 9843, 9757, 9842, 9756, 9841, 9755, 
		9840, 9754, 9839, 9753, 9838, 9752, 9837, 9751, 9836, 9750, 9835, 9749, 9834, 9748, 9833, 9747, 
		9832, 9746, 9831, 9745, 9830, 9744, 9829, 9743, 9828, 9742, 9827, 9741, 9826, 9740, 9825, 9739, 
		9824, 9738, 9823, 9737, 9822, 9736, 9821, 9735, 9820, 9734, 9819, 9733, 9818, 9732, 9817, 9731, 
		9816, 9730, 9815, 9729, 9814, 9728, 9813, 9727, 9812, 9726, 9811, 9725, 9810, 9724, 9809, 9723, 
		9894, 9808, 9893, 9807, 9892, 9806, 9891, 9805, 9890, 9804, 9889, 9803, 9888, 9802, 9887, 9801, 
		9886, 9800, 9885, 9799, 9884, 9798, 9883, 9797, 9882, 9796, 9881, 9795, 9880, 9794, 9879, 9793, 
		9878, 9792, 9877, 9791, 9876, 9790, 9875, 9789, 9874, 9788, 9873, 9787, 9872, 9786, 9871, 9785, 
		9870, 7912, 7826, 7827, 9786, 9785, 9786, 9700, 9701, 9615, 9616, 9530, 9531, 9445, 9446, 9360, 
		9361, 9275, 9276, 9190, 9191, 9105, 9106, 9020, 9021, 8935, 8936, 8850, 8851, 8765, 8766, 8680, 
		8681, 8595, 8596, 8510, 8511, 8425, 8426, 8340, 8341, 8255, 8256, 8170, 8171, 8085, 8086, 8000, 
		8001, 7915, 7916, 7830, 7916, 7745, 7831, 7746, 7832, 7747, 7833, 7748, 7834, 7749, 7835, 7750, 
		7836, 7751, 7837, 7752, 7838, 7753, 7839, 7754, 7840, 7755, 7841, 7756, 7842, 7757, 7843, 7758, 
		7844, 7759, 7845, 7760, 7846, 7761, 7847, 7762, 7848, 7763, 7849, 7764, 7850, 7765, 7851, 7766, 
		7852, 7767, 7853, 7768, 7854, 7769, 7855, 7770, 7856, 7771, 7857, 7772, 7858, 7773, 7859, 7774, 
		7860, 7775, 7861, 7776, 7862, 7777, 7863, 7778, 7864, 7779, 7865, 7780, 7866, 7781, 7867, 7782, 
		7868, 7783, 7869, 7784, 7870, 7785, 7871, 7786, 7872, 7787, 7873, 7788, 7874, 7789, 7875, 7790, 
		7876, 7791, 7877, 7792, 7878, 7793, 7879, 7794, 7880, 7795, 7881, 7796, 7882, 7797, 7883, 7798, 
		7884, 7799, 7885, 7800, 7886, 7801, 7887, 7802, 7888, 7803, 7889, 7804, 7890, 7805, 7891, 7806, 
		7892, 7807, 7893, 7808, 7894, 7809, 7895, 7810, 7896, 7811, 7897, 7812, 7898, 7813, 7899, 7814, 
		7900, 7815, 7901, 7816, 7902, 7817, 7903, 7818, 7904, 7819, 7905, 7820, 7906, 7821, 7907, 7822, 
		7908, 7823, 7909, 7824, 7910, 7825, 7911, 7826, 7911, 7912, 7911, 7997, 7996, 8082, 8081, 8167, 
		8166, 8252, 8251, 8337, 8336, 8422, 8421, 8507, 8506, 8592, 8591, 8677, 8676, 8762, 8761, 8847, 
		8846, 8932, 8931, 9017, 9016, 9102, 9101, 9187, 9186, 9272, 9271, 9357, 9356, 9442, 9441, 9527, 
		9526, 9612, 9611, 9697, 9696, 9782, 9696, 9781, 9695, 9780, 9694, 9779, 9693, 9778, 9692, 9777, 
		9691, 9776, 9690, 9775, 9689, 9774, 9688, 9773, 9687, 9772, 9686, 9771, 9685, 9770, 9684, 9769, 
		9683, 9768, 9682, 9767, 9681, 9766, 9680, 9765, 9679, 9764, 9678, 9763, 9677, 9762, 9676, 9761, 
		9675, 9760, 9674, 9759, 9673, 9758, 9672, 9757, 9671, 9756, 9670, 9755, 9669, 9754, 9668, 9753, 
		9667, 9752, 9666, 9751, 9665, 9750, 9664, 9749, 9663, 9748, 9662, 9747, 9661, 9746, 9660, 9745, 
		9659, 9744, 9658, 9743, 9657, 9742, 9656, 9741, 9655, 9740, 9654, 9739, 9653, 9738, 9652, 9737, 
		9651, 9736, 9650, 9735, 9649, 9734, 9648, 9733, 9647, 9732, 9646, 9731, 9645, 9730, 9644, 9729, 
		9643, 9728, 9642, 9727, 9641, 9726, 9640, 9725, 9639, 9724, 9638, 9723, 9637, 9808, 9722, 9807, 
		9721, 9806, 9720, 9805, 9719, 9804, 9718, 9803, 9717, 9802, 9716, 9801, 9715, 9800, 9714, 9799, 
		9713, 9798, 9712, 9797, 9711, 9796, 9710, 9795, 9709, 9794, 9708, 9793, 9707, 9792, 9706, 9791, 
		9705, 9790, 9704, 9789, 9703, 9788, 9702, 9787, 9701, 9786, 7996, 7910, 7911, 9702, 9701, 9702, 
		9616, 9617, 9531, 9532, 9446, 9447, 9361, 9362, 9276, 9277, 9191, 9192, 9106, 9107, 9021, 9022, 
		8936, 8937, 8851, 8852, 8766, 8767, 8681, 8682, 8596, 8597, 8511, 8512, 8426, 8427, 8341, 8342, 
		8256, 8257, 8171, 8172, 8086, 8087, 8001, 8002, 7916, 8002, 7831, 7917, 7832, 7918, 7833, 7919, 
		7834, 7920, 7835, 7921, 7836, 7922, 7837, 7923, 7838, 7924, 7839, 7925, 7840, 7926, 7841, 7927, 
		7842, 7928, 7843, 7929, 7844, 7930, 7845, 7931, 7846, 7932, 7847, 7933, 7848, 7934, 7849, 7935, 
		7850, 7936, 7851, 7937, 7852, 7938, 7853, 7939, 7854, 7940, 7855, 7941, 7856, 7942, 7857, 7943, 
		7858, 7944, 7859, 7945, 7860, 7946, 7861, 7947, 7862, 7948, 7863, 7949, 7864, 7950, 7865, 7951, 
		7866, 7952, 7867, 7953, 7868, 7954, 7869, 7955, 7870, 7956, 7871, 7957, 7872, 7958, 7873, 7959, 
		7874, 7960, 7875, 7961, 7876, 7962, 7877, 7963, 7878, 7964, 7879, 7965, 7880, 7966, 7881, 7967, 
		7882, 7968, 7883, 7969, 7884, 7970, 7885, 7971, 7886, 7972, 7887, 7973, 7888, 7974, 7889, 7975, 
		7890, 7976, 7891, 7977, 7892, 7978, 7893, 7979, 7894, 7980, 7895, 7981, 7896, 7982, 7897, 7983, 
		7898, 7984, 7899, 7985, 7900, 7986, 7901, 7987, 7902, 7988, 7903, 7989, 7904, 7990, 7905, 7991, 
		7906, 7992, 7907, 7993, 7908, 7994, 7909, 7995, 7910, 7995, 7996, 7995, 8081, 8080, 8166, 8165, 
		8251, 8250, 8336, 8335, 8421, 8420, 8506, 8505, 8591, 8590, 8676, 8675, 8761, 8760, 8846, 8845, 
		8931, 8930, 9016, 9015, 9101, 9100, 9186, 9185, 9271, 9270, 9356, 9355, 9441, 9440, 9526, 9525, 
		9611, 9610, 9696, 9610, 9695, 9609, 9694, 9608, 9693, 9607, 9692, 9606, 9691, 9605, 9690, 9604, 
		9689, 9603, 9688, 9602, 9687, 9601, 9686, 9600, 9685, 9599, 9684, 9598, 9683, 9597, 9682, 9596, 
		9681, 9595, 9680, 9594, 9679, 9593, 9678, 9592, 9677, 9591, 9676, 9590, 9675, 9589, 9674, 9588, 
		9673, 9587, 9672, 9586, 9671, 9585, 9670, 9584, 9669, 9583, 9668, 9582, 9667, 9581, 9666, 9580, 
		9665, 9579, 9664, 9578, 9663, 9577, 9662, 9576, 9661, 9575, 9660, 9574, 9659, 9573, 9658, 9572, 
		9657, 9571, 9656, 9570, 9655, 9569, 9654, 9568, 9653, 9567, 9652, 9566, 9651, 9565, 9650, 9564, 
		9649, 9563, 9648, 9562, 9647, 9561, 9646, 9560, 9645, 9559, 9644, 9558, 9643, 9557, 9642, 9556, 
		9641, 9555, 9640, 9554, 9639, 9553, 9638, 9552, 9637, 9551, 9722, 9636, 9721, 9635, 9720, 9634, 
		9719, 9633, 9718, 9632, 9717, 9631, 9716, 9630, 9715, 9629, 9714, 9628, 9713, 9627, 9712, 9626, 
		9711, 9625, 9710, 9624, 9709, 9623, 9708, 9622, 9707, 9621, 9706, 9620, 9705, 9619, 9704, 9618, 
		9703, 9617, 9702, 8080, 7994, 7995, 9618, 9617, 9618, 9532, 9533, 9447, 9448, 9362, 9363, 9277, 
		9278, 9192, 9193, 9107, 9108, 9022, 9023, 8937, 8938, 8852, 8853, 8767, 8768, 8682, 8683, 8597, 
		8598, 8512, 8513, 8427, 8428, 8342, 8343, 8257, 8258, 8172, 8173, 8087, 8088, 8002, 8088, 7917, 
		8003, 7918, 8004, 7919, 8005, 7920, 8006, 7921, 8007, 7922, 8008, 7923, 8009, 7924, 8010, 7925, 
		8011, 7926, 8012, 7927, 8013, 7928, 8014, 7929, 8015, 7930, 8016, 7931, 8017, 7932, 8018, 7933, 
		8019, 7934, 8020, 7935, 8021, 7936, 8022, 7937, 8023, 7938, 8024, 7939, 8025, 7940, 8026, 7941, 
		8027, 7942, 8028, 7943, 8029, 7944, 8030, 7945, 8031, 7946, 8032, 7947, 8033, 7948, 8034, 7949, 
		8035, 7950, 8036, 7951, 8037, 7952, 8038, 7953, 8039, 7954, 8040, 7955, 8041, 7956, 8042, 7957, 
		8043, 7958, 8044, 7959, 8045, 7960, 8046, 7961, 8047, 7962, 8048, 7963, 8049, 7964, 8050, 7965, 
		8051, 7966, 8052, 7967, 8053, 7968, 8054, 7969, 8055, 7970, 8056, 7971, 8057, 7972, 8058, 7973, 
		8059, 7974, 8060, 7975, 8061, 7976, 8062, 7977, 8063, 7978, 8064, 7979, 8065, 7980, 8066, 7981, 
		8067, 7982, 8068, 7983, 8069, 7984, 8070, 7985, 8071, 7986, 8072, 7987, 8073, 7988, 8074, 7989, 
		8075, 7990, 8076, 7991, 8077, 7992, 8078, 7993, 8079, 7994, 8079, 8080, 8079, 8165, 8164, 8250, 
		8249, 8335, 8334, 8420, 8419, 8505, 8504, 8590, 8589, 8675, 8674, 8760, 8759, 8845, 8844, 8930, 
		8929, 9015, 9014, 9100, 9099, 9185, 9184, 9270, 9269, 9355, 9354, 9440, 9439, 9525, 9524, 9610, 
		9524, 9609, 9523, 9608, 9522, 9607, 9521, 9606, 9520, 9605, 9519, 9604, 9518, 9603, 9517, 9602, 
		9516, 9601, 9515, 9600, 9514, 9599, 9513, 9598, 9512, 9597, 9511, 9596, 9510, 9595, 9509, 9594, 
		9508, 9593, 9507, 9592, 9506, 9591, 9505, 9590, 9504, 9589, 9503, 9588, 9502, 9587, 9501, 9586, 
		9500, 9585, 9499, 9584, 9498, 9583, 9497, 9582, 9496, 9581, 9495, 9580, 9494, 9579, 9493, 9578, 
		9492, 9577, 9491, 9576, 9490, 9575, 9489, 9574, 9488, 9573, 9487, 9572, 9486, 9571, 9485, 9570, 
		9484, 9569, 9483, 9568, 9482, 9567, 9481, 9566, 9480, 9565, 9479, 9564, 9478, 9563, 9477, 9562, 
		9476, 9561, 9475, 9560, 9474, 9559, 9473, 9558, 9472, 9557, 9471, 9556, 9470, 9555, 9469, 9554, 
		9468, 9553, 9467, 9552, 9466, 9551, 9465, 9636, 9550, 9635, 9549, 9634, 9548, 9633, 9547, 9632, 
		9546, 9631, 9545, 9630, 9544, 9629, 9543, 9628, 9542, 9627, 9541, 9626, 9540, 9625, 9539, 9624, 
		9538, 9623, 9537, 9622, 9536, 9621, 9535, 9620, 9534, 9619, 9533, 9618, 8164, 8078, 8079, 9534, 
		9533, 9534, 9448, 9449, 9363, 9364, 9278, 9279, 9193, 9194, 9108, 9109, 9023, 9024, 8938, 8939, 
		8853, 8854, 8768, 8769, 8683, 8684, 8598, 8599, 8513, 8514, 8428, 8429, 8343, 8344, 8258, 8259, 
		8173, 8174, 8088, 8174, 8003, 8089, 8004, 8090, 8005, 8091, 8006, 8092, 8007, 8093, 8008, 8094, 
		8009, 8095, 8010, 8096, 8011, 8097, 8012, 8098, 8013, 8099, 8014, 8100, 8015, 8101, 8016, 8102, 
		8017, 8103, 8018, 8104, 8019, 8105, 8020, 8106, 8021, 8107, 8022, 8108, 8023, 8109, 8024, 8110, 
		8025, 8111, 8026, 8112, 8027, 8113, 8028, 8114, 8029, 8115, 8030, 8116, 8031, 8117, 8032, 8118, 
		8033, 8119, 8034, 8120, 8035, 8121, 8036, 8122, 8037, 8123, 8038, 8124, 8039, 8125, 8040, 8126, 
		8041, 8127, 8042, 8128, 8043, 8129, 8044, 8130, 8045, 8131, 8046, 8132, 8047, 8133, 8048, 8134, 
		8049, 8135, 8050, 8136, 8051, 8137, 8052, 8138, 8053, 8139, 8054, 8140, 8055, 8141, 8056, 8142, 
		8057, 8143, 8058, 8144, 8059, 8145, 8060, 8146, 8061, 8147, 8062, 8148, 8063, 8149, 8064, 8150, 
		8065, 8151, 8066, 8152, 8067, 8153, 8068, 8154, 8069, 8155, 8070, 8156, 8071, 8157, 8072, 8158, 
		8073, 8159, 8074, 8160, 8075, 8161, 8076, 8162, 8077, 8163, 8078, 8163, 8164, 8163, 8249, 8248, 
		8334, 8333, 8419, 8418, 8504, 8503, 8589, 8588, 8674, 8673, 8759, 8758, 8844, 8843, 8929, 8928, 
		9014, 9013, 9099, 9098, 9184, 9183, 9269, 9268, 9354, 9353, 9439, 9438, 9524, 9438, 9523, 9437, 
		9522, 9436, 9521, 9435, 9520, 9434, 9519, 9433, 9518, 9432, 9517, 9431, 9516, 9430, 9515, 9429, 
		9514, 9428, 9513, 9427, 9512, 9426, 9511, 9425, 9510, 9424, 9509, 9423, 9508, 9422, 9507, 9421, 
		9506, 9420, 9505, 9419, 9504, 9418, 9503, 9417, 9502, 9416, 9501, 9415, 9500, 9414, 9499, 9413, 
		9498, 9412, 9497, 9411, 9496, 9410, 9495, 9409, 9494, 9408, 9493, 9407, 9492, 9406, 9491, 9405, 
		9490, 9404, 9489, 9403, 9488, 9402, 9487, 9401, 9486, 9400, 9485, 9399, 9484, 9398, 9483, 9397, 
		9482, 9396, 9481, 9395, 9480, 9394, 9479, 9393, 9478, 9392, 9477, 9391, 9476, 9390, 9475, 9389, 
		9474, 9388, 9473, 9387, 9472, 9386, 9471, 9385, 9470, 9384, 9469, 9383, 9468, 9382, 9467, 9381, 
		9466, 9380, 9465, 9379, 9550, 9464, 9549, 9463, 9548, 9462, 9547, 9461, 9546, 9460, 9545, 9459, 
		9544, 9458, 9543, 9457, 9542, 9456, 9541, 9455, 9540, 9454, 9539, 9453, 9538, 9452, 9537, 9451, 
		9536, 9450, 9535, 9449, 9534, 8248, 8162, 8163, 9450, 9449, 9450, 9364, 9365, 9279, 9280, 9194, 
		9195, 9109, 9110, 9024, 9025, 8939, 8940, 8854, 8855, 8769, 8770, 8684, 8685, 8599, 8600, 8514, 
		8515, 8429, 8430, 8344, 8345, 8259, 8260, 8174, 8260, 8089, 8175, 8090, 8176, 8091, 8177, 8092, 
		8178, 8093, 8179, 8094, 8180, 8095, 8181, 8096, 8182, 8097, 8183, 8098, 8184, 8099, 8185, 8100, 
		8186, 8101, 8187, 8102, 8188, 8103, 8189, 8104, 8190, 8105, 8191, 8106, 8192, 8107, 8193, 8108, 
		8194, 8109, 8195, 8110, 8196, 8111, 8197, 8112, 8198, 8113, 8199, 8114, 8200, 8115, 8201, 8116, 
		8202, 8117, 8203, 8118, 8204, 8119, 8205, 8120, 8206, 8121, 8207, 8122, 8208, 8123, 8209, 8124, 
		8210, 8125, 8211, 8126, 8212, 8127, 8213, 8128, 8214, 8129, 8215, 8130, 8216, 8131, 8217, 8132, 
		8218, 8133, 8219, 8134, 8220, 8135, 8221, 8136, 8222, 8137, 8223, 8138, 8224, 8139, 8225, 8140, 
		8226, 8141, 8227, 8142, 8228, 8143, 8229, 8144, 8230, 8145, 8231, 8146, 8232, 8147, 8233, 8148, 
		8234, 8149, 8235, 8150, 8236, 8151, 8237, 8152, 8238, 8153, 8239, 8154, 8240, 8155, 8241, 8156, 
		8242, 8157, 8243, 8158, 8244, 8159, 8245, 8160, 8246, 8161, 8247, 8162, 8247, 8248, 8247, 8333, 
		8332, 8418, 8417, 8503, 8502, 8588, 8587, 8673, 8672, 8758, 8757, 8843, 8842, 8928, 8927, 9013, 
		9012, 9098, 9097, 9183, 9182, 9268, 9267, 9353, 9352, 9438, 9352, 9437, 9351, 9436, 9350, 9435, 
		9349, 9434, 9348, 9433, 9347, 9432, 9346, 9431, 9345, 9430, 9344, 9429, 9343, 9428, 9342, 9427, 
		9341, 9426, 9340, 9425, 9339, 9424, 9338, 9423, 9337, 9422, 9336, 9421, 9335, 9420, 9334, 9419, 
		9333, 9418, 9332, 9417, 9331, 9416, 9330, 9415, 9329, 9414, 9328, 9413, 9327, 9412, 9326, 9411, 
		9325, 9410, 9324, 9409, 9323, 9408, 9322, 9407, 9321, 9406, 9320, 9405, 9319, 9404, 9318, 9403, 
		9317, 9402, 9316, 9401, 9315, 9400, 9314, 9399, 9313, 9398, 9312, 9397, 9311, 9396, 9310, 9395, 
		9309, 9394, 9308, 9393, 9307, 9392, 9306, 9391, 9305, 9390, 9304, 9389, 9303, 9388, 9302, 9387, 
		9301, 9386, 9300, 9385, 9299, 9384, 9298, 9383, 9297, 9382, 9296, 9381, 9295, 9380, 9294, 9379, 
		9293, 9464, 9378, 9463, 9377, 9462, 9376, 9461, 9375, 9460, 9374, 9459, 9373, 9458, 9372, 9457, 
		9371, 9456, 9370, 9455, 9369, 9454, 9368, 9453, 9367, 9452, 9366, 9451, 9365, 9450, 8332, 8246, 
		8247, 9366, 9365, 9366, 9280, 9281, 9195, 9196, 9110, 9111, 9025, 9026, 8940, 8941, 8855, 8856, 
		8770, 8771, 8685, 8686, 8600, 8601, 8515, 8516, 8430, 8431, 8345, 8346, 8260, 8346, 8175, 8261, 
		8176, 8262, 8177, 8263, 8178, 8264, 8179, 8265, 8180, 8266, 8181, 8267, 8182, 8268, 8183, 8269, 
		8184, 8270, 8185, 8271, 8186, 8272, 8187, 8273, 8188, 8274, 8189, 8275, 8190, 8276, 8191, 8277, 
		8192, 8278, 8193, 8279, 8194, 8280, 8195, 8281, 8196, 8282, 8197, 8283, 8198, 8284, 8199, 8285, 
		8200, 8286, 8201, 8287, 8202, 8288, 8203, 8289, 8204, 8290, 8205, 8291, 8206, 8292, 8207, 8293, 
		8208, 8294, 8209, 8295, 8210, 8296, 8211, 8297, 8212, 8298, 8213, 8299, 8214, 8300, 8215, 8301, 
		8216, 8302, 8217, 8303, 8218, 8304, 8219, 8305, 8220, 8306, 8221, 8307, 8222, 8308, 8223, 8309, 
		8224, 8310, 8225, 8311, 8226, 8312, 8227, 8313, 8228, 8314, 8229, 8315, 8230, 8316, 8231, 8317, 
		8232, 8318, 8233, 8319, 8234, 8320, 8235, 8321, 8236, 8322, 8237, 8323, 8238, 8324, 8239, 8325, 
		8240, 8326, 8241, 8327, 8242, 8328, 8243, 8329, 8244, 8330, 8245, 8331, 8246, 8331, 8332, 8331, 
		8417, 8416, 8502, 8501, 8587, 8586, 8672, 8671, 8757, 8756, 8842, 8841, 8927, 8926, 9012, 9011, 
		9097, 9096, 9182, 9181, 9267, 9266, 9352, 9266, 9351, 9265, 9350, 9264, 9349, 9263, 9348, 9262, 
		9347, 9261, 9346, 9260, 9345, 9259, 9344, 9258, 9343, 9257, 9342, 9256, 9341, 9255, 9340, 9254, 
		9339, 9253, 9338, 9252, 9337, 9251, 9336, 9250, 9335, 9249, 9334, 9248, 9333, 9247, 9332, 9246, 
		9331, 9245, 9330, 9244, 9329, 9243, 9328, 9242, 9327, 9241, 9326, 9240, 9325, 9239, 9324, 9238, 
		9323, 9237, 9322, 9236, 9321, 9235, 9320, 9234, 9319, 9233, 9318, 9232, 9317, 9231, 9316, 9230, 
		9315, 9229, 9314, 9228, 9313, 9227, 9312, 9226, 9311, 9225, 9310, 9224, 9309, 9223, 9308, 9222, 
		9307, 9221, 9306, 9220, 9305, 9219, 9304, 9218, 9303, 9217, 9302, 9216, 9301, 9215, 9300, 9214, 
		9299, 9213, 9298, 9212, 9297, 9211, 9296, 9210, 9295, 9209, 9294, 9208, 9293, 9207, 9378, 9292, 
		9377, 9291, 9376, 9290, 9375, 9289, 9374, 9288, 9373, 9287, 9372, 9286, 9371, 9285, 9370, 9284, 
		9369, 9283, 9368, 9282, 9367, 9281, 9366, 8416, 8330, 8331, 9282, 9281, 9282, 9196, 9197, 9111, 
		9112, 9026, 9027, 8941, 8942, 8856, 8857, 8771, 8772, 8686, 8687, 8601, 8602, 8516, 8517, 8431, 
		8432, 8346, 8432, 8261, 8347, 8262, 8348, 8263, 8349, 8264, 8350, 8265, 8351, 8266, 8352, 8267, 
		8353, 8268, 8354, 8269, 8355, 8270, 8356, 8271, 8357, 8272, 8358, 8273, 8359, 8274, 8360, 8275, 
		8361, 8276, 8362, 8277, 8363, 8278, 8364, 8279, 8365, 8280, 8366, 8281, 8367, 8282, 8368, 8283, 
		8369, 8284, 8370, 8285, 8371, 8286, 8372, 8287, 8373, 8288, 8374, 8289, 8375, 8290, 8376, 8291, 
		8377, 8292, 8378, 8293, 8379, 8294, 8380, 8295, 8381, 8296, 8382, 8297, 8383, 8298, 8384, 8299, 
		8385, 8300, 8386, 8301, 8387, 8302, 8388, 8303, 8389, 8304, 8390, 8305, 8391, 8306, 8392, 8307, 
		8393, 8308, 8394, 8309, 8395, 8310, 8396, 8311, 8397, 8312, 8398, 8313, 8399, 8314, 8400, 8315, 
		8401, 8316, 8402, 8317, 8403, 8318, 8404, 8319, 8405, 8320, 8406, 8321, 8407, 8322, 8408, 8323, 
		8409, 8324, 8410, 8325, 8411, 8326, 8412, 8327, 8413, 8328, 8414, 8329, 8415, 8330, 8415, 8416, 
		8415, 8501, 8500, 8586, 8585, 8671, 8670, 8756, 8755, 8841, 8840, 8926, 8925, 9011, 9010, 9096, 
		9095, 9181, 9180, 9266, 9180, 9265, 9179, 9264, 9178, 9263, 9177, 9262, 9176, 9261, 9175, 9260, 
		9174, 9259, 9173, 9258, 9172, 9257, 9171, 9256, 9170, 9255, 9169, 9254, 9168, 9253, 9167, 9252, 
		9166, 9251, 9165, 9250, 9164, 9249, 9163, 9248, 9162, 9247, 9161, 9246, 9160, 9245, 9159, 9244, 
		9158, 9243, 9157, 9242, 9156, 9241, 9155, 9240, 9154, 9239, 9153, 9238, 9152, 9237, 9151, 9236, 
		9150, 9235, 9149, 9234, 9148, 9233, 9147, 9232, 9146, 9231, 9145, 9230, 9144, 9229, 9143, 9228, 
		9142, 9227, 9141, 9226, 9140, 9225, 9139, 9224, 9138, 9223, 9137, 9222, 9136, 9221, 9135, 9220, 
		9134, 9219, 9133, 9218, 9132, 9217, 9131, 9216, 9130, 9215, 9129, 9214, 9128, 9213, 9127, 9212, 
		9126, 9211, 9125, 9210, 9124, 9209, 9123, 9208, 9122, 9207, 9121, 9292, 9206, 9291, 9205, 9290, 
		9204, 9289, 9203, 9288, 9202, 9287, 9201, 9286, 9200, 9285, 9199, 9284, 9198, 9283, 9197, 9282, 
		8500, 8414, 8415, 9198, 9197, 9198, 9112, 9113, 9027, 9028, 8942, 8943, 8857, 8858, 8772, 8773, 
		8687, 8688, 8602, 8603, 8517, 8518, 8432, 8518, 8347, 8433, 8348, 8434, 8349, 8435, 8350, 8436, 
		8351, 8437, 8352, 8438, 8353, 8439, 8354, 8440, 8355, 8441, 8356, 8442, 8357, 8443, 8358, 8444, 
		8359, 8445, 8360, 8446, 8361, 8447, 8362, 8448, 8363, 8449, 8364, 8450, 8365, 8451, 8366, 8452, 
		8367, 8453, 8368, 8454, 8369, 8455, 8370, 8456, 8371, 8457, 8372, 8458, 8373, 8459, 8374, 8460, 
		8375, 8461, 8376, 8462, 8377, 8463, 8378, 8464, 8379, 8465, 8380, 8466, 8381, 8467, 8382, 8468, 
		8383, 8469, 8384, 8470, 8385, 8471, 8386, 8472, 8387, 8473, 8388, 8474, 8389, 8475, 8390, 8476, 
		8391, 8477, 8392, 8478, 8393, 8479, 8394, 8480, 8395, 8481, 8396, 8482, 8397, 8483, 8398, 8484, 
		8399, 8485, 8400, 8486, 8401, 8487, 8402, 8488, 8403, 8489, 8404, 8490, 8405, 8491, 8406, 8492, 
		8407, 8493, 8408, 8494, 8409, 8495, 8410, 8496, 8411, 8497, 8412, 8498, 8413, 8499, 8414, 8499, 
		8500, 8499, 8585, 8584, 8670, 8669, 8755, 8754, 8840, 8839, 8925, 8924, 9010, 9009, 9095, 9094, 
		9180, 9094, 9179, 9093, 9178, 9092, 9177, 9091, 9176, 9090, 9175, 9089, 9174, 9088, 9173, 9087, 
		9172, 9086, 9171, 9085, 9170, 9084, 9169, 9083, 9168, 9082, 9167, 9081, 9166, 9080, 9165, 9079, 
		9164, 9078, 9163, 9077, 9162, 9076, 9161, 9075, 9160, 9074, 9159, 9073, 9158, 9072, 9157, 9071, 
		9156, 9070, 9155, 9069, 9154, 9068, 9153, 9067, 9152, 9066, 9151, 9065, 9150, 9064, 9149, 9063, 
		9148, 9062, 9147, 9061, 9146, 9060, 9145, 9059, 9144, 9058, 9143, 9057, 9142, 9056, 9141, 9055, 
		9140, 9054, 9139, 9053, 9138, 9052, 9137, 9051, 9136, 9050, 9135, 9049, 9134, 9048, 9133, 9047, 
		9132, 9046, 9131, 9045, 9130, 9044, 9129, 9043, 9128, 9042, 9127, 9041, 9126, 9040, 9125, 9039, 
		9124, 9038, 9123, 9037, 9122, 9036, 9121, 9035, 9206, 9120, 9205, 9119, 9204, 9118, 9203, 9117, 
		9202, 9116, 9201, 9115, 9200, 9114, 9199, 9113, 9198, 8584, 8498, 8499, 7615, 7233, 7615, 7231, 
		7615, 7619, 7620, 7232, 7620, 7229, 7620, 7623, 7624, 7230, 7624, 7227, 7624, 7037, 7038, 7228, 
		7038, 7225, 7038, 7033, 7034, 7226, 7034, 7223, 7034, 7627, 7628, 7224, 7628, 7221, 7628, 7631, 
		7632, 7222, 7632, 7219, 7632, 7635, 7636, 7220, 7636, 7217, 7636, 7029, 7030, 7218, 7030, 7215, 
		7030, 7025, 7026, 7216, 7026, 7213, 7026, 7021, 7022, 7214, 7022, 7211, 7022, 7639, 7640, 7212, 
		7640, 7209, 7640, 7017, 7018, 7210, 7018, 7207, 7018, 7013, 7014, 7208, 7014, 7205, 7014, 7643, 
		7644, 7206, 7644, 7203, 7644, 7647, 7648, 7204, 7648, 7201, 7648, 7651, 7652, 7202, 7652, 7199, 
		7652, 7009, 7010, 7200, 7010, 7197, 7010, 7655, 7656, 7198, 7656, 7195, 7656, 7005, 7006, 7196, 
		7006, 7193, 7006, 7001, 7002, 7194, 7002, 7191, 7002, 6997, 6998, 7192, 6998, 7189, 6998, 6993, 
		6994, 7190, 6994, 7187, 6994, 6989, 6990, 7188, 6990, 7185, 6990, 6985, 6986, 7186, 6986, 7569, 
		6986, 6981, 6982, 7570, 6982, 7183, 6982, 6977, 6978, 7184, 6978, 7561, 6978, 6973, 6974, 7562, 
		6974, 7181, 6974, 6969, 6970, 7182, 6970, 7179, 6970, 6965, 6966, 7180, 6966, 7177, 6966, 6961, 
		6962, 7178, 6962, 7175, 6962, 7531, 7532, 7176, 7532, 7173, 7532, 7527, 7528, 7174, 7528, 7171, 
		7528, 7523, 7524, 7172, 7524, 7169, 7524, 7519, 7520, 7170, 7520, 7167, 7520, 7515, 7516, 7168, 
		7516, 7165, 7516, 7511, 7512, 7166, 7512, 7163, 7512, 7507, 7508, 7164, 7508, 7161, 7508, 6957, 
		6958, 7162, 6958, 7159, 6958, 7503, 7504, 7160, 7504, 7501, 7504, 7485, 7486, 7502, 7486, 7157, 
		7486, 6953, 6954, 7158, 6954, 7155, 6954, 6949, 6950, 7156, 6950, 7153, 6950, 7489, 7490, 7154, 
		7490, 7151, 7490, 6945, 6946, 7152, 6946, 7149, 6946, 6941, 6942, 7150, 6942, 7147, 6942, 7493, 
		7494, 7148, 7494, 7145, 7494, 7497, 7498, 7146, 7498, 7143, 7498, 6937, 6938, 7144, 6938, 7141, 
		6938, 6933, 6934, 7142, 6934, 7139, 6934, 6929, 6930, 7140, 6930, 7137, 6930, 6925, 6926, 7138, 
		6926, 7135, 6926, 6921, 6922, 7136, 6922, 7473, 6922, 7465, 7466, 7474, 7466, 7133, 7466, 7461, 
		7462, 7134, 7462, 7131, 7462, 7457, 7458, 7132, 7458, 7129, 7458, 6917, 6918, 7130, 6918, 7127, 
		6918, 6913, 6914, 7128, 6914, 7125, 6914, 6909, 6910, 7126, 6910, 7123, 6910, 6905, 6906, 7124, 
		6906, 7121, 6906, 6901, 6902, 7122, 6902, 7119, 6902, 6897, 6898, 7120, 6898, 7117, 6898, 6893, 
		6894, 7118, 6894, 7115, 6894, 6889, 6890, 7116, 6890, 7113, 6890, 6885, 6886, 7114, 6886, 7433, 
		6886, 6881, 6882, 7434, 6882, 7111, 6882, 6877, 6878, 7112, 6878, 7109, 6878, 7429, 7430, 7110, 
		7430, 7107, 7430, 7425, 7426, 7108, 7426, 7105, 7426, 7421, 7422, 7106, 7422, 7103, 7422, 7417, 
		7418, 7104, 7418, 7101, 7418, 7413, 7414, 7102, 7414, 7099, 7414, 6873, 6874, 7100, 6874, 7097, 
		6874, 7409, 7410, 7098, 7410, 7095, 7410, 7405, 7406, 7096, 7406, 7093, 7406, 7401, 7402, 7094, 
		7402, 7091, 7402, 6869, 6870, 7092, 6870, 7399, 6870, 6865, 6866, 7400, 6866, 7387, 6866, 7341, 
		7342, 7388, 7342, 7089, 7342, 6861, 6862, 7090, 6862, 7087, 6862, 6857, 6858, 7088, 6858, 7085, 
		6858, 7337, 7338, 7086, 7338, 7083, 7338, 6853, 6854, 7084, 6854, 7081, 6854, 6849, 6850, 7082, 
		6850, 7079, 6850, 7333, 7334, 7080, 7334, 7077, 7334, 7329, 7330, 7078, 7330, 7075, 7330, 6845, 
		6846, 7076, 6846, 7073, 6846, 7325, 7326, 7074, 7326, 7071, 7326, 6841, 6842, 7072, 6842, 7069, 
		6842, 7321, 7322, 7070, 7322, 7067, 7322, 7317, 7318, 7068, 7318, 7389, 7318, 7313, 7314, 7390, 
		7314, 7065, 7314, 7381, 7382, 7066, 7382, 7063, 7382, 7309, 7310, 7064, 7310, 7301, 7310, 7263, 
		7264, 7302, 7264, 7061, 7264, 7259, 7260, 7062, 7260, 7059, 7260, 6837, 6838, 7060, 6838, 7057, 
		6838, 6833, 6834, 7058, 6834, 7055, 6834, 6829, 6830, 7056, 6830, 7053, 6830, 7255, 7256, 7054, 
		7256, 7051, 7256, 7251, 7252, 7052, 7252, 7049, 7252, 7247, 7248, 7050, 7248, 7047, 7248, 6825, 
		6826, 7048, 6826, 7045, 6826, 7243, 7244, 7046, 7244, 7043, 7244, 7239, 7240, 7044, 7240, 7041, 
		7240, 6821, 6822, 7042, 6822, 7237, 6822, 6817, 6818, 7238, 6818, 7234, 6818, 7616, 6813, 7617, 
		6813, 7621, 6813, 6809, 6810, 7622, 6810, 7625, 6810, 7579, 7580, 7626, 7580, 7039, 7580, 6805, 
		6806, 7040, 6806, 7035, 6806, 7583, 7584, 7036, 7584, 7629, 7584, 6801, 6802, 7630, 6802, 7633, 
		6802, 7587, 7588, 7634, 7588, 7637, 7588, 7591, 7592, 7638, 7592, 7031, 7592, 7595, 7596, 7032, 
		7596, 7027, 7596, 7599, 7600, 7028, 7600, 7023, 7600, 6797, 6798, 7024, 6798, 7641, 6798, 6793, 
		6794, 7642, 6794, 7019, 6794, 6789, 6790, 7020, 6790, 7015, 6790, 6785, 6786, 7016, 6786, 7645, 
		6786, 7603, 7604, 7646, 7604, 7649, 7604, 7607, 7608, 7650, 7608, 7653, 7608, 7611, 7612, 7654, 
		7612, 7011, 7612, 6781, 6782, 7012, 6782, 7657, 6782, 6777, 6778, 7658, 6778, 7007, 6778, 6773, 
		6774, 7008, 6774, 7003, 6774, 6769, 6770, 7004, 6770, 6999, 6770, 6765, 6766, 7000, 6766, 6995, 
		6766, 6761, 6762, 6996, 6762, 6991, 6762, 6757, 6758, 6992, 6758, 6987, 6758, 7571, 7572, 6988, 
		7572, 6983, 7572, 7565, 7566, 6984, 7566, 6979, 7566, 6753, 6754, 6980, 6754, 6975, 6754, 6749, 
		6750, 6976, 6750, 6971, 6750, 6745, 6746, 6972, 6746, 6967, 6746, 6741, 6742, 6968, 6742, 6963, 
		6742, 7555, 7556, 6964, 7556, 7533, 7556, 7551, 7552, 7534, 7552, 7529, 7552, 7547, 7548, 7530, 
		7548, 7525, 7548, 7543, 7544, 7526, 7544, 7521, 7544, 6737, 6738, 7522, 6738, 7517, 6738, 6733, 
		6734, 7518, 6734, 7513, 6734, 6729, 6730, 7514, 6730, 7509, 6730, 7539, 7540, 7510, 7540, 6959, 
		7540, 7535, 7536, 6960, 7536, 7505, 7536, 6725, 6726, 7506, 6726, 7487, 6726, 6721, 6722, 7488, 
		6722, 6955, 6722, 6717, 6718, 6956, 6718, 6951, 6718, 6713, 6714, 6952, 6714, 7491, 6714, 6709, 
		6710, 7492, 6710, 6947, 6710, 7477, 7478, 6948, 7478, 6943, 7478, 6705, 6706, 6944, 6706, 7495, 
		6706, 6701, 6702, 7496, 6702, 7499, 6702, 7481, 7482, 7500, 7482, 6939, 7482, 6697, 6698, 6940, 
		6698, 6935, 6698, 6693, 6694, 6936, 6694, 6931, 6694, 6689, 6690, 6932, 6690, 6927, 6690, 6685, 
		6686, 6928, 6686, 6923, 6686, 6681, 6682, 6924, 6682, 7467, 6682, 7469, 7470, 7468, 7470, 7463, 
		7470, 6677, 6678, 7464, 6678, 7459, 6678, 6673, 6674, 7460, 6674, 6919, 6674, 6669, 6670, 6920, 
		6670, 6915, 6670, 6665, 6666, 6916, 6666, 6911, 6666, 6661, 6662, 6912, 6662, 6907, 6662, 6657, 
		6658, 6908, 6658, 6903, 6658, 6653, 6654, 6904, 6654, 6899, 6654, 6649, 6650, 6900, 6650, 6895, 
		6650, 6645, 6646, 6896, 6646, 6891, 6646, 6641, 6642, 6892, 6642, 6887, 6642, 6637, 6638, 6888, 
		6638, 6883, 6638, 6633, 6634, 6884, 6634, 6879, 6634, 7451, 7452, 6880, 7452, 7431, 7452, 7447, 
		7448, 7432, 7448, 7427, 7448, 7443, 7444, 7428, 7444, 7423, 7444, 6629, 6630, 7424, 6630, 7419, 
		6630, 6625, 6626, 7420, 6626, 7415, 6626, 6621, 6622, 7416, 6622, 6875, 6622, 7439, 7440, 6876, 
		7440, 7411, 7440, 6617, 6618, 7412, 6618, 7407, 6618, 6613, 6614, 7408, 6614, 7403, 6614, 6609, 
		6610, 7404, 6610, 6871, 6610, 7435, 7436, 6872, 7436, 6867, 7436, 6605, 6606, 6868, 6606, 7343, 
		6606, 7345, 7346, 7344, 7346, 6863, 7346, 7349, 7350, 6864, 7350, 6859, 7350, 7353, 7354, 6860, 
		7354, 7339, 7354, 6601, 6602, 7340, 6602, 6855, 6602, 7357, 7358, 6856, 7358, 6851, 7358, 6597, 
		6598, 6852, 6598, 7335, 6598, 6593, 6594, 7336, 6594, 7331, 6594, 6589, 6590, 7332, 6590, 6847, 
		6590, 7361, 7362, 6848, 7362, 7327, 7362, 7365, 7366, 7328, 7366, 6843, 7366, 7369, 7370, 6844, 
		7370, 7323, 7370, 7373, 7374, 7324, 7374, 7319, 7374, 6585, 6586, 7320, 6586, 7315, 6586, 7377, 
		7378, 7316, 7378, 7383, 7378, 7393, 7394, 7384, 7394, 7311, 7394, 7305, 7306, 7312, 7306, 7265, 
		7306, 7267, 7268, 7266, 7268, 7261, 7268, 7271, 7272, 7262, 7272, 6839, 7272, 6581, 6582, 6840, 
		6582, 6835, 6582, 7275, 7276, 6836, 7276, 6831, 7276, 6577, 6578, 6832, 6578, 7257, 6578, 6573, 
		6574, 7258, 6574, 7253, 6574, 6569, 6570, 7254, 6570, 7249, 6570, 7279, 7280, 7250, 7280, 6827, 
		7280, 7283, 7284, 6828, 7284, 7245, 7284, 7287, 7288, 7246, 7288, 7241, 7288, 7291, 7292, 7242, 
		7292, 6823, 7292, 7295, 7296, 6824, 7296, 6819, 7296, 7575, 7576, 6820, 7576, 7618, 7576, 6814, 
		6567, 6815, 6567, 6811, 6567, 6565, 6566, 6812, 6566, 7581, 6566, 6563, 6564, 7582, 6564, 6807, 
		6564, 6561, 6562, 6808, 6562, 7585, 6562, 6559, 6560, 7586, 6560, 6803, 6560, 6557, 6558, 6804, 
		6558, 7589, 6558, 6555, 6556, 7590, 6556, 7593, 6556, 6553, 6554, 7594, 6554, 7597, 6554, 6551, 
		6552, 7598, 6552, 7601, 6552, 6549, 6550, 7602, 6550, 6799, 6550, 6547, 6548, 6800, 6548, 6795, 
		6548, 6545, 6546, 6796, 6546, 6791, 6546, 6543, 6544, 6792, 6544, 6787, 6544, 6541, 6542, 6788, 
		6542, 7605, 6542, 6539, 6540, 7606, 6540, 7609, 6540, 6537, 6538, 7610, 6538, 7613, 6538, 6535, 
		6536, 7614, 6536, 6783, 6536, 6533, 6534, 6784, 6534, 6779, 6534, 6531, 6532, 6780, 6532, 6775, 
		6532, 6529, 6530, 6776, 6530, 6771, 6530, 6527, 6528, 6772, 6528, 6767, 6528, 6525, 6526, 6768, 
		6526, 6763, 6526, 6523, 6524, 6764, 6524, 6759, 6524, 6521, 6522, 6760, 6522, 7573, 6522, 6519, 
		6520, 7574, 6520, 7567, 6520, 6517, 6518, 7568, 6518, 6755, 6518, 7563, 7564, 6756, 7564, 6751, 
		7564, 7559, 7560, 6752, 7560, 6747, 7560, 6515, 6516, 6748, 6516, 6743, 6516, 6513, 6514, 6744, 
		6514, 7557, 6514, 6511, 6512, 7558, 6512, 7553, 6512, 6509, 6510, 7554, 6510, 7549, 6510, 6507, 
		6508, 7550, 6508, 7545, 6508, 6505, 6506, 7546, 6506, 6739, 6506, 6503, 6504, 6740, 6504, 6735, 
		6504, 6501, 6502, 6736, 6502, 6731, 6502, 6499, 6500, 6732, 6500, 7541, 6500, 6497, 6498, 7542, 
		6498, 7537, 6498, 6495, 6496, 7538, 6496, 6727, 6496, 6493, 6494, 6728, 6494, 6723, 6494, 7475, 
		7476, 6724, 7476, 6719, 7476, 6491, 6492, 6720, 6492, 6715, 6492, 6489, 6490, 6716, 6490, 6711, 
		6490, 6487, 6488, 6712, 6488, 7479, 6488, 6485, 6486, 7480, 6486, 6707, 6486, 6483, 6484, 6708, 
		6484, 6703, 6484, 6481, 6482, 6704, 6482, 7483, 6482, 6479, 6480, 7484, 6480, 6699, 6480, 6477, 
		6478, 6700, 6478, 6695, 6478, 6475, 6476, 6696, 6476, 6691, 6476, 6473, 6474, 6692, 6474, 6687, 
		6474, 6471, 6472, 6688, 6472, 6683, 6472, 6469, 6470, 6684, 6470, 7471, 6470, 6467, 6468, 7472, 
		6468, 6679, 6468, 6465, 6466, 6680, 6466, 6675, 6466, 6463, 6464, 6676, 6464, 6671, 6464, 6461, 
		6462, 6672, 6462, 6667, 6462, 6459, 6460, 6668, 6460, 6663, 6460, 6457, 6458, 6664, 6458, 6659, 
		6458, 6455, 6456, 6660, 6456, 6655, 6456, 6453, 6454, 6656, 6454, 6651, 6454, 6451, 6452, 6652, 
		6452, 6647, 6452, 6449, 6450, 6648, 6450, 6643, 6450, 6447, 6448, 6644, 6448, 6639, 6448, 6445, 
		6446, 6640, 6446, 6635, 6446, 7455, 7456, 6636, 7456, 7453, 7456, 6443, 6444, 7454, 6444, 7449, 
		6444, 6441, 6442, 7450, 6442, 7445, 6442, 6439, 6440, 7446, 6440, 6631, 6440, 6437, 6438, 6632, 
		6438, 6627, 6438, 6435, 6436, 6628, 6436, 6623, 6436, 6433, 6434, 6624, 6434, 7441, 6434, 6431, 
		6432, 7442, 6432, 6619, 6432, 6429, 6430, 6620, 6430, 6615, 6430, 6427, 6428, 6616, 6428, 6611, 
		6428, 6425, 6426, 6612, 6426, 7437, 6426, 6423, 6424, 7438, 6424, 6607, 6424, 7397, 7398, 6608, 
		7398, 7347, 7398, 7385, 7386, 7348, 7386, 7351, 7386, 6421, 6422, 7352, 6422, 7355, 6422, 6419, 
		6420, 7356, 6420, 6603, 6420, 6417, 6418, 6604, 6418, 7359, 6418, 6415, 6416, 7360, 6416, 6599, 
		6416, 6413, 6414, 6600, 6414, 6595, 6414, 6411, 6412, 6596, 6412, 6591, 6412, 6409, 6410, 6592, 
		6410, 7363, 6410, 6407, 6408, 7364, 6408, 7367, 6408, 6405, 6406, 7368, 6406, 7371, 6406, 6403, 
		6404, 7372, 6404, 7375, 6404, 6401, 6402, 7376, 6402, 6587, 6402, 6399, 6400, 6588, 6400, 7379, 
		6400, 6397, 6398, 7380, 6398, 7395, 6398, 7391, 7392, 7396, 7392, 7307, 7392, 7303, 7304, 7308, 
		7304, 7269, 7304, 7299, 7300, 7270, 7300, 7273, 7300, 6395, 6396, 7274, 6396, 6583, 6396, 6393, 
		6394, 6584, 6394, 7277, 6394, 6391, 6392, 7278, 6392, 6579, 6392, 6389, 6390, 6580, 6390, 6575, 
		6390, 6387, 6388, 6576, 6388, 6571, 6388, 6385, 6386, 6572, 6386, 7281, 6386, 6383, 6384, 7282, 
		6384, 7285, 6384, 6381, 6382, 7286, 6382, 7289, 6382, 6379, 6380, 7290, 6380, 7293, 6380, 6377, 
		7297, 6375, 7297, 6378, 7297, 7294, 6376, 7298, 6376, 7577, 6376, 7235, 7236, 7578, 7236, 6816, 
		7236, 6568, 9114, 9113, 9114, 9028, 9029, 8943, 8944, 8858, 8859, 8773, 8774, 8688, 8689, 8603, 
		8604, 8518, 8604, 8433, 8519, 8434, 8520, 8435, 8521, 8436, 8522, 8437, 8523, 8438, 8524, 8439, 
		8525, 8440, 8526, 8441, 8527, 8442, 8528, 8443, 8529, 8444, 8530, 8445, 8531, 8446, 8532, 8447, 
		8533, 8448, 8534, 8449, 8535, 8450, 8536, 8451, 8537, 8452, 8538, 8453, 8539, 8454, 8540, 8455, 
		8541, 8456, 8542, 8457, 8543, 8458, 8544, 8459, 8545, 8460, 8546, 8461, 8547, 8462, 8548, 8463, 
		8549, 8464, 8550, 8465, 8551, 8466, 8552, 8467, 8553, 8468, 8554, 8469, 8555, 8470, 8556, 8471, 
		8557, 8472, 8558, 8473, 8559, 8474, 8560, 8475, 8561, 8476, 8562, 8477, 8563, 8478, 8564, 8479, 
		8565, 8480, 8566, 8481, 8567, 8482, 8568, 8483, 8569, 8484, 8570, 8485, 8571, 8486, 8572, 8487, 
		8573, 8488, 8574, 8489, 8575, 8490, 8576, 8491, 8577, 8492, 8578, 8493, 8579, 8494, 8580, 8495, 
		8581, 8496, 8582, 8497, 8583, 8498, 8583, 8584, 8583, 8669, 8668, 8754, 8753, 8839, 8838, 8924, 
		8923, 9009, 9008, 9094, 9008, 9093, 9007, 9092, 9006, 9091, 9005, 9090, 9004, 9089, 9003, 9088, 
		9002, 9087, 9001, 9086, 9000, 9085, 8999, 9084, 8998, 9083, 8997, 9082, 8996, 9081, 8995, 9080, 
		8994, 9079, 8993, 9078, 8992, 9077, 8991, 9076, 8990, 9075, 8989, 9074, 8988, 9073, 8987, 9072, 
		8986, 9071, 8985, 9070, 8984, 9069, 8983, 9068, 8982, 9067, 8981, 9066, 8980, 9065, 8979, 9064, 
		8978, 9063, 8977, 9062, 8976, 9061, 8975, 9060, 8974, 9059, 8973, 9058, 8972, 9057, 8971, 9056, 
		8970, 9055, 8969, 9054, 8968, 9053, 8967, 9052, 8966, 9051, 8965, 9050, 8964, 9049, 8963, 9048, 
		8962, 9047, 8961, 9046, 8960, 9045, 8959, 9044, 8958, 9043, 8957, 9042, 8956, 9041, 8955, 9040, 
		8954, 9039, 8953, 9038, 8952, 9037, 8951, 9036, 8950, 9035, 8949, 9120, 9034, 9119, 9033, 9118, 
		9032, 9117, 9031, 9116, 9030, 9115, 9029, 9114, 8668, 8582, 8583, 9030, 9029, 9030, 8944, 8945, 
		8859, 8860, 8774, 8775, 8689, 8690, 8604, 8690, 8519, 8605, 8520, 8606, 8521, 8607, 8522, 8608, 
		8523, 8609, 8524, 8610, 8525, 8611, 8526, 8612, 8527, 8613, 8528, 8614, 8529, 8615, 8530, 8616, 
		8531, 8617, 8532, 8618, 8533, 8619, 8534, 8620, 8535, 8621, 8536, 8622, 8537, 8623, 8538, 8624, 
		8539, 8625, 8540, 8626, 8541, 8627, 8542, 8628, 8543, 8629, 8544, 8630, 8545, 8631, 8546, 8632, 
		8547, 8633, 8548, 8634, 8549, 8635, 8550, 8636, 8551, 8637, 8552, 8638, 8553, 8639, 8554, 8640, 
		8555, 8641, 8556, 8642, 8557, 8643, 8558, 8644, 8559, 8645, 8560, 8646, 8561, 8647, 8562, 8648, 
		8563, 8649, 8564, 8650, 8565, 8651, 8566, 8652, 8567, 8653, 8568, 8654, 8569, 8655, 8570, 8656, 
		8571, 8657, 8572, 8658, 8573, 8659, 8574, 8660, 8575, 8661, 8576, 8662, 8577, 8663, 8578, 8664, 
		8579, 8665, 8580, 8666, 8581, 8667, 8582, 8667, 8668, 8667, 8753, 8752, 8838, 8837, 8923, 8922, 
		9008, 8922, 9007, 8921, 9006, 8920, 9005, 8919, 9004, 8918, 9003, 8917, 9002, 8916, 9001, 8915, 
		9000, 8914, 8999, 8913, 8998, 8912, 8997, 8911, 8996, 8910, 8995, 8909, 8994, 8908, 8993, 8907, 
		8992, 8906, 8991, 8905, 8990, 8904, 8989, 8903, 8988, 8902, 8987, 8901, 8986, 8900, 8985, 8899, 
		8984, 8898, 8983, 8897, 8982, 8896, 8981, 8895, 8980, 8894, 8979, 8893, 8978, 8892, 8977, 8891, 
		8976, 8890, 8975, 8889, 8974, 8888, 8973, 8887, 8972, 8886, 8971, 8885, 8970, 8884, 8969, 8883, 
		8968, 8882, 8967, 8881, 8966, 8880, 8965, 8879, 8964, 8878, 8963, 8877, 8962, 8876, 8961, 8875, 
		8960, 8874, 8959, 8873, 8958, 8872, 8957, 8871, 8956, 8870, 8955, 8869, 8954, 8868, 8953, 8867, 
		8952, 8866, 8951, 8865, 8950, 8864, 8949, 8863, 9034, 8948, 9033, 8947, 9032, 8946, 9031, 8945, 
		9030, 8752, 8666, 8667, 8946, 8945, 8946, 8860, 8861, 8775, 8776, 8690, 8776, 8605, 8691, 8606, 
		8692, 8607, 8693, 8608, 8694, 8609, 8695, 8610, 8696, 8611, 8697, 8612, 8698, 8613, 8699, 8614, 
		8700, 8615, 8701, 8616, 8702, 8617, 8703, 8618, 8704, 8619, 8705, 8620, 8706, 8621, 8707, 8622, 
		8708, 8623, 8709, 8624, 8710, 8625, 8711, 8626, 8712, 8627, 8713, 8628, 8714, 8629, 8715, 8630, 
		8716, 8631, 8717, 8632, 8718, 8633, 8719, 8634, 8720, 8635, 8721, 8636, 8722, 8637, 8723, 8638, 
		8724, 8639, 8725, 8640, 8726, 8641, 8727, 8642, 8728, 8643, 8729, 8644, 8730, 8645, 8731, 8646, 
		8732, 8647, 8733, 8648, 8734, 8649, 8735, 8650, 8736, 8651, 8737, 8652, 8738, 8653, 8739, 8654, 
		8740, 8655, 8741, 8656, 8742, 8657, 8743, 8658, 8744, 8659, 8745, 8660, 8746, 8661, 8747, 8662, 
		8748, 8663, 8749, 8664, 8750, 8665, 8751, 8666, 8751, 8752, 8751, 8837, 8836, 8922, 8836, 8921, 
		8835, 8920, 8834, 8919, 8833, 8918, 8832, 8917, 8831, 8916, 8830, 8915, 8829, 8914, 8828, 8913, 
		8827, 8912, 8826, 8911, 8825, 8910, 8824, 8909, 8823, 8908, 8822, 8907, 8821, 8906, 8820, 8905, 
		8819, 8904, 8818, 8903, 8817, 8902, 8816, 8901, 8815, 8900, 8814, 8899, 8813, 8898, 8812, 8897, 
		8811, 8896, 8810, 8895, 8809, 8894, 8808, 8893, 8807, 8892, 8806, 8891, 8805, 8890, 8804, 8889, 
		8803, 8888, 8802, 8887, 8801, 8886, 8800, 8885, 8799, 8884, 8798, 8883, 8797, 8882, 8796, 8881, 
		8795, 8880, 8794, 8879, 8793, 8878, 8792, 8877, 8791, 8876, 8790, 8875, 8789, 8874, 8788, 8873, 
		8787, 8872, 8786, 8871, 8785, 8870, 8784, 8869, 8783, 8868, 8782, 8867, 8781, 8866, 8780, 8865, 
		8779, 8864, 8778, 8863, 8777, 8948, 8862, 8947, 8861, 8946, 8836, 8750, 8751, 10629, 10628, 10589, 
		10588, 10549, 10548, 10509, 10508, 10469, 10468, 10429, 10428, 10389, 10388, 10349, 10348, 10309, 10308, 10269, 
		10268, 10229, 10228, 10189, 10188, 10149, 10148, 10109, 10108, 10069, 10108, 10068, 10107, 10067, 10146, 10106, 
		10146, 10145, 10185, 10184, 10224, 10223, 10263, 10262, 10302, 10301, 10341, 10340, 10380, 10379, 10419, 10418, 
		10458, 10457, 10497, 10496, 10536, 10535, 10575, 10574, 10614, 10613, 10653, 10652, 963, 962, 963, 966, 
		963, 975, 962, 969, 962, 984, 962, 966, 978, 972, 978, 962, 978, 963, 972, 981, 
		972, 969, 972, 962, 990, 998, 990, 1001, 990, 994, 1015, 989, 1015, 993, 1015, 1018, 
		1008, 1004, 1008, 997, 1008, 988, 1011, 1007, 1011, 987, 1011, 1014, 1040, 1031, 1040, 992, 
		1040, 1000, 1030, 1037, 1030, 1017, 1030, 991, 1043, 1028, 1043, 996, 1043, 1003, 1027, 1039, 
		1027, 999, 1027, 995, 1025, 1042, 1025, 1002, 1025, 1006, 1034, 1024, 1034, 1005, 1034, 1010, 
		1022, 1033, 1022, 1009, 1022, 1013, 1036, 1021, 1036, 1012, 1036, 1016, 1020, 1019, 1020, 1023, 
		1020, 1032, 1019, 1026, 1019, 1041, 1019, 1023, 1035, 1029, 1035, 1019, 1035, 1020, 1029, 1038, 
		1029, 1026, 1029, 1019, 1044, 1050, 1044, 1053, 1044, 1047, 1065, 1044, 1065, 1047, 1065, 1068, 
		1059, 1056, 1059, 1050, 1059, 1044, 1062, 1059, 1062, 1044, 1062, 1065, 1097, 1088, 1097, 1046, 
		1097, 1052, 1087, 1094, 1087, 1067, 1087, 1045, 1100, 1084, 1100, 1049, 1100, 1055, 1083, 1096, 
		1083, 1051, 1083, 1048, 1080, 1099, 1080, 1054, 1080, 1058, 1091, 1079, 1091, 1057, 1091, 1061, 
		1076, 1090, 1076, 1060, 1076, 1064, 1093, 1075, 1093, 1063, 1093, 1066, 1074, 1072, 1074, 1078, 
		1074, 1089, 1071, 1082, 1071, 1098, 1071, 1077, 1092, 1086, 1092, 1070, 1092, 1073, 1085, 1095, 
		1085, 1081, 1085, 1069, 1105, 1113, 1105, 1116, 1105, 1109, 1131, 1104, 1131, 1108, 1131, 1134, 
		1127, 1124, 1127, 1103, 1127, 1130, 1156, 1147, 1156, 1107, 1156, 1115, 1146, 1153, 1146, 1133, 
		1146, 1106, 1150, 1141, 1150, 1123, 1150, 1126, 1138, 1149, 1138, 1125, 1138, 1129, 1152, 1137, 
		1152, 1128, 1152, 1132, 1136, 1135, 1136, 1140, 1136, 1148, 1151, 1145, 1151, 1135, 1151, 1136, 
		1145, 1155, 1145, 1144, 1145, 1135, 1164, 1102, 1164, 1122, 1163, 1112, 1163, 1101, 1166, 1154, 
		1166, 1114, 1111, 1166, 1111, 1114, 1166, 1143, 1166, 1154, 1168, 1121, 1168, 1139, 1171, 1140, 
		1171, 1135, 1144, 1171, 1144, 1135, 1119, 1176, 1119, 1120, 1176, 1162, 1176, 1120, 1185, 1142, 
		1185, 1165, 1173, 1185, 1173, 1165, 1185, 1170, 1185, 1142, 1183, 1169, 1183, 1184, 1183, 1191, 
		1159, 1182, 1159, 1190, 1159, 1178, 1191, 1184, 1191, 1172, 1191, 1187, 1178, 1190, 1178, 1186, 
		1178, 1167, 1189, 1165, 1189, 1110, 1161, 1189, 1161, 1110, 1189, 1173, 1189, 1165, 1187, 1172, 
		1187, 1188, 1187, 1193, 1167, 1186, 1167, 1192, 1167, 1180, 1193, 1188, 1193, 1160, 1193, 1175, 
		1180, 1192, 1180, 1174, 1180, 1118, 1158, 1177, 1158, 1139, 1177, 1168, 1177, 1139, 1168, 1179, 
		1168, 1121, 1179, 1117, 1179, 1121, 1171, 1181, 1171, 1140, 1181, 1157, 1181, 1140, 1208, 1199, 
		1208, 1211, 1208, 1218, 1202, 1208, 1202, 1218, 1202, 1217, 1218, 1211, 1218, 1196, 1218, 1214, 
		1217, 1218, 1217, 1214, 1217, 1205, 1201, 1216, 1201, 1224, 1201, 1221, 1215, 1204, 1215, 1227, 
		1215, 1223, 1203, 1213, 1203, 1230, 1203, 1226, 1212, 1195, 1212, 1233, 1212, 1229, 1210, 1198, 
		1210, 1236, 1210, 1239, 1194, 1209, 1194, 1238, 1194, 1232, 1207, 1200, 1207, 1220, 1207, 1242, 
		1197, 1206, 1197, 1241, 1197, 1235, 1225, 1228, 1225, 1243, 1225, 1222, 1228, 1231, 1228, 1237, 
		1228, 1243, 1222, 1243, 1222, 1240, 1222, 1219, 1243, 1237, 1243, 1234, 1243, 1240, 1248, 1256, 
		1248, 1259, 1248, 1252, 1274, 1247, 1274, 1251, 1274, 1277, 1270, 1267, 1270, 1246, 1270, 1273, 
		1299, 1290, 1299, 1250, 1299, 1258, 1289, 1296, 1289, 1276, 1289, 1249, 1293, 1284, 1293, 1266, 
		1293, 1269, 1281, 1292, 1281, 1268, 1281, 1272, 1295, 1280, 1295, 1271, 1295, 1275, 1279, 1278, 
		1279, 1283, 1279, 1291, 1294, 1288, 1294, 1278, 1294, 1279, 1288, 1298, 1288, 1287, 1288, 1278, 
		1307, 1245, 1307, 1265, 1262, 1306, 1262, 1264, 1305, 1255, 1305, 1244, 1314, 1286, 1314, 1309, 
		1314, 1316, 1302, 1313, 1302, 1315, 1302, 1311, 1316, 1309, 1316, 1254, 1316, 1304, 1311, 1315, 
		1311, 1303, 1311, 1261, 1308, 1297, 1308, 1257, 1253, 1308, 1253, 1257, 1308, 1285, 1308, 1297, 
		1310, 1263, 1310, 1282, 1301, 1310, 1301, 1282, 1310, 1260, 1310, 1263, 1312, 1283, 1312, 1278, 
		1287, 1312, 1287, 1278, 1312, 1300, 1312, 1283, 1321, 285, 1321, 312, 309, 1320, 309, 311, 
		1319, 305, 1319, 284, 1323, 340, 1323, 300, 304, 1323, 304, 300, 1323, 323, 1323, 340, 
		1328, 322, 1328, 1322, 1328, 1330, 333, 1327, 333, 1329, 333, 1325, 1330, 1322, 1330, 303, 
		1330, 1318, 1325, 1329, 1325, 1317, 1325, 308, 1324, 310, 1324, 319, 332, 1324, 332, 319, 
		1324, 307, 1324, 310, 1326, 320, 1326, 318, 324, 1326, 324, 318, 1326, 331, 1326, 320, 
		1332, 1338, 1332, 1341, 1332, 1335, 1349, 1344, 1349, 1338, 1349, 1332, 1353, 1348, 1353, 1331, 
		1353, 1357, 1385, 1370, 1385, 1337, 1385, 1343, 1369, 1382, 1369, 1340, 1369, 1336, 1367, 1384, 
		1367, 1342, 1367, 1347, 1364, 1376, 1364, 1352, 1364, 1356, 1363, 1361, 1363, 1366, 1363, 1375, 
		1361, 1368, 1361, 1383, 1361, 1366, 1373, 1381, 1373, 1368, 1373, 1361, 1375, 1366, 1375, 1391, 
		1375, 1388, 1351, 1374, 1351, 1387, 1351, 1394, 1365, 1346, 1365, 1397, 1365, 1390, 1345, 1350, 
		1345, 1393, 1345, 1396, 1386, 1389, 1386, 1395, 1386, 1392, 1398, 1404, 1398, 1407, 1398, 1401, 
		1419, 1398, 1419, 1401, 1419, 1422, 1413, 1410, 1413, 1404, 1413, 1398, 1416, 1413, 1416, 1398, 
		1416, 1419, 1447, 1438, 1447, 1400, 1447, 1406, 1421, 1399, 1444, 1399, 1437, 1450, 1434, 1450, 
		1403, 1450, 1409, 1433, 1446, 1433, 1405, 1433, 1402, 1431, 1449, 1431, 1408, 1431, 1412, 1441, 
		1430, 1441, 1411, 1441, 1415, 1428, 1440, 1428, 1414, 1428, 1418, 1443, 1427, 1443, 1417, 1443, 
		1420, 1426, 1424, 1426, 1429, 1426, 1439, 1424, 1432, 1424, 1448, 1424, 1429, 1442, 1436, 1442, 
		1423, 1442, 1425, 1435, 1445, 1435, 1432, 1435, 1424, 1456, 1459, 1456, 1463, 1456, 1466, 1458, 
		1453, 1458, 1469, 1458, 1462, 1550, 1536, 1550, 1457, 1550, 1455, 1536, 1560, 1536, 1452, 1536, 
		1457, 1501, 1549, 1501, 1454, 1501, 1465, 1559, 1491, 1559, 1468, 1559, 1451, 1490, 1515, 1490, 
		1461, 1490, 1467, 1514, 1500, 1514, 1464, 1514, 1460, 1480, 1519, 1480, 1524, 1497, 1479, 1497, 
		1507, 1478, 1523, 1478, 1506, 1475, 1496, 1475, 1505, 1553, 1474, 1553, 1546, 1473, 1504, 1473, 
		1545, 1482, 1533, 1482, 1548, 1518, 1482, 1518, 1499, 1482, 1548, 1482, 1499, 1472, 1471, 1472, 
		1477, 1472, 1495, 1470, 1481, 1470, 1517, 1470, 1476, 1552, 1487, 1552, 1471, 1552, 1472, 1486, 
		1532, 1486, 1481, 1486, 1470, 1485, 1551, 1485, 1544, 1531, 1484, 1531, 1529, 1483, 1543, 1483, 
		1528, 1513, 1522, 1513, 1516, 1513, 1498, 1489, 1511, 1489, 1521, 1489, 1512, 1510, 1494, 1510, 
		1503, 1510, 1520, 1556, 1542, 1556, 1502, 1556, 1493, 1558, 1540, 1558, 1509, 1558, 1488, 1539, 
		1555, 1539, 1492, 1539, 1508, 1530, 1527, 1530, 1535, 1530, 1547, 1526, 1538, 1526, 1557, 1526, 
		1534, 1541, 1554, 1541, 1537, 1541, 1525, 1565, 1355, 1565, 1332, 1335, 1565, 1335, 1332, 1565, 
		1360, 1565, 1355, 1562, 1339, 1562, 1380, 1372, 1562, 1372, 1380, 1562, 1334, 1562, 1339, 1570, 
		1379, 1570, 1567, 1570, 1572, 1371, 1569, 1371, 1571, 1371, 1561, 1572, 1567, 1572, 1359, 1572, 
		1564, 1561, 1571, 1561, 1563, 1561, 1333, 1566, 1362, 1566, 1354, 1358, 1566, 1358, 1354, 1566, 
		1378, 1566, 1362, 1568, 1361, 1568, 1363, 1377, 1568, 1377, 1363, 1568, 1373, 1568, 1361, 1587, 
		1578, 1587, 1590, 1587, 1597, 1581, 1587, 1581, 1597, 1581, 1596, 1597, 1590, 1597, 1575, 1597, 
		1593, 1596, 1597, 1596, 1593, 1596, 1584, 1580, 1595, 1580, 1603, 1580, 1600, 1594, 1583, 1594, 
		1606, 1594, 1602, 1582, 1592, 1582, 1609, 1582, 1605, 1591, 1574, 1591, 1612, 1591, 1608, 1589, 
		1577, 1589, 1615, 1589, 1618, 1573, 1588, 1573, 1617, 1573, 1611, 1586, 1579, 1586, 1599, 1586, 
		1621, 1576, 1585, 1576, 1620, 1576, 1614, 1604, 1607, 1604, 1622, 1604, 1601, 1607, 1610, 1607, 
		1616, 1607, 1622, 1601, 1622, 1601, 1619, 1601, 1598, 1622, 1616, 1622, 1613, 1622, 1619, 1623, 
		1630, 1623, 1633, 1623, 1627, 1639, 1636, 1639, 1630, 1639, 1623, 1642, 1639, 1642, 1623, 1642, 
		1645, 1670, 1661, 1670, 1626, 1670, 1632, 1673, 1658, 1673, 1629, 1673, 1635, 1657, 1669, 1657, 
		1631, 1657, 1628, 1655, 1672, 1655, 1634, 1655, 1638, 1664, 1654, 1664, 1637, 1664, 1641, 1652, 
		1649, 1652, 1653, 1652, 1663, 1649, 1656, 1649, 1671, 1649, 1653, 1660, 1668, 1660, 1656, 1660, 
		1649, 1679, 1623, 1679, 1627, 1648, 1678, 1648, 1625, 1679, 1645, 1679, 1623, 1675, 1624, 1675, 
		1659, 1667, 1675, 1667, 1659, 1675, 1647, 1675, 1624, 1681, 1662, 1681, 1640, 1644, 1681, 1644, 
		1640, 1681, 1651, 1681, 1662, 1684, 1650, 1684, 1680, 1684, 1686, 1666, 1683, 1666, 1685, 1666, 
		1674, 1686, 1680, 1686, 1643, 1686, 1677, 1674, 1685, 1674, 1676, 1674, 1646, 1682, 1660, 1682, 
		1649, 1652, 1682, 1652, 1649, 1682, 1665, 1682, 1660, 1718, 1708, 1718, 1687, 1718, 1689, 1705, 
		1717, 1705, 1688, 1705, 1691, 1713, 1704, 1713, 1690, 1713, 1693, 1701, 1712, 1701, 1692, 1701, 
		1694, 1700, 1698, 1700, 1703, 1700, 1711, 1697, 1707, 1697, 1716, 1697, 1702, 1714, 1710, 1714, 
		1696, 1714, 1699, 1709, 1715, 1709, 1706, 1709, 1695, 1719, 1725, 1719, 1728, 1719, 1722, 1740, 
		1719, 1740, 1722, 1740, 1743, 1734, 1731, 1734, 1725, 1734, 1719, 1737, 1734, 1737, 1719, 1737, 
		1740, 1772, 1763, 1772, 1721, 1772, 1727, 1762, 1769, 1762, 1742, 1762, 1720, 1775, 1759, 1775, 
		1724, 1775, 1730, 1758, 1771, 1758, 1726, 1758, 1723, 1755, 1774, 1755, 1729, 1755, 1733, 1766, 
		1754, 1766, 1732, 1766, 1736, 1751, 1765, 1751, 1735, 1751, 1739, 1768, 1750, 1768, 1738, 1768, 
		1741, 1749, 1747, 1749, 1753, 1749, 1764, 1746, 1757, 1746, 1773, 1746, 1752, 1767, 1761, 1767, 
		1745, 1767, 1748, 1760, 1770, 1760, 1756, 1760, 1744, 1776, 1782, 1776, 1785, 1776, 1779, 1797, 
		1776, 1797, 1779, 1797, 1800, 1791, 1788, 1791, 1782, 1791, 1776, 1794, 1791, 1794, 1776, 1794, 
		1797, 1829, 1820, 1829, 1778, 1829, 1784, 1819, 1826, 1819, 1799, 1819, 1777, 1832, 1816, 1832, 
		1781, 1832, 1787, 1815, 1828, 1815, 1783, 1815, 1780, 1812, 1831, 1812, 1786, 1812, 1790, 1823, 
		1811, 1823, 1789, 1823, 1793, 1808, 1822, 1808, 1792, 1808, 1796, 1825, 1807, 1825, 1795, 1825, 
		1798, 1806, 1804, 1806, 1810, 1806, 1821, 1803, 1814, 1803, 1830, 1803, 1809, 1824, 1818, 1824, 
		1802, 1824, 1805, 1817, 1827, 1817, 1813, 1817, 1801, 1833, 1839, 1833, 1842, 1833, 1836, 1854, 
		1833, 1854, 1836, 1854, 1857, 1848, 1845, 1848, 1839, 1848, 1833, 1851, 1848, 1851, 1833, 1851, 
		1854, 1879, 1870, 1879, 1835, 1879, 1841, 1869, 1876, 1869, 1856, 1869, 1834, 1882, 1867, 1882, 
		1838, 1882, 1844, 1866, 1878, 1866, 1840, 1866, 1837, 1864, 1881, 1864, 1843, 1864, 1847, 1873, 
		1863, 1873, 1846, 1873, 1850, 1861, 1872, 1861, 1849, 1861, 1853, 1875, 1860, 1875, 1852, 1875, 
		1855, 1859, 1858, 1859, 1862, 1859, 1871, 1858, 1865, 1858, 1880, 1858, 1862, 1874, 1868, 1874, 
		1858, 1874, 1859, 1868, 1877, 1868, 1865, 1868, 1858, 1897, 1888, 1897, 1900, 1897, 1907, 1891, 
		1897, 1891, 1907, 1891, 1906, 1907, 1900, 1907, 1885, 1907, 1903, 1906, 1907, 1906, 1903, 1906, 
		1894, 1890, 1905, 1890, 1913, 1890, 1910, 1904, 1893, 1904, 1916, 1904, 1912, 1892, 1902, 1892, 
		1919, 1892, 1915, 1901, 1884, 1901, 1922, 1901, 1918, 1899, 1887, 1899, 1925, 1899, 1928, 1883, 
		1898, 1883, 1927, 1883, 1921, 1896, 1889, 1896, 1909, 1896, 1931, 1886, 1895, 1886, 1930, 1886, 
		1924, 1914, 1917, 1914, 1932, 1914, 1911, 1917, 1920, 1917, 1926, 1917, 1932, 1911, 1932, 1911, 
		1929, 1911, 1908, 1932, 1926, 1932, 1923, 1932, 1929, 1948, 1938, 1948, 1952, 1948, 1964, 1941, 
		1947, 1941, 1963, 1941, 1960, 1962, 1951, 1962, 1935, 1962, 1956, 1959, 1961, 1959, 1955, 1959, 
		1944, 1940, 1958, 1940, 1971, 1940, 1967, 1957, 1943, 1957, 1974, 1957, 1970, 1942, 1954, 1942, 
		1978, 1942, 1973, 1953, 1934, 1953, 1981, 1953, 1977, 1950, 1937, 1950, 1984, 1950, 1988, 1933, 
		1949, 1933, 1987, 1933, 1980, 1946, 1939, 1946, 1966, 1946, 1992, 1936, 1945, 1936, 1991, 1936, 
		1983, 1972, 1976, 1972, 1996, 1972, 1969, 1975, 1979, 1975, 1986, 1975, 1995, 1968, 1994, 1968, 
		1990, 1968, 1965, 1993, 1985, 1993, 1982, 1993, 1989, 2011, 2002, 2011, 2015, 2011, 2024, 2005, 
		2011, 2005, 2024, 2005, 2022, 2023, 2014, 2023, 1999, 2023, 2019, 2022, 2024, 2022, 2018, 2022, 
		2008, 2004, 2021, 2004, 2031, 2004, 2027, 2020, 2007, 2020, 2034, 2020, 2030, 2006, 2017, 2006, 
		2038, 2006, 2033, 2016, 1998, 2016, 2041, 2016, 2037, 2013, 2001, 2013, 2044, 2013, 2048, 1997, 
		2012, 1997, 2047, 1997, 2040, 2010, 2003, 2010, 2026, 2010, 2052, 2000, 2009, 2000, 2051, 2000, 
		2043, 2032, 2036, 2032, 2056, 2032, 2029, 2035, 2039, 2035, 2046, 2035, 2055, 2028, 2054, 2028, 
		2050, 2028, 2025, 2053, 2045, 2053, 2042, 2053, 2049, 2060, 2068, 2060, 2071, 2060, 2064, 2085, 
		2059, 2085, 2063, 2085, 2088, 2078, 2074, 2078, 2067, 2078, 2058, 2081, 2077, 2081, 2057, 2081, 
		2084, 2117, 2108, 2117, 2062, 2117, 2070, 2107, 2114, 2107, 2087, 2107, 2061, 2120, 2104, 2120, 
		2066, 2120, 2073, 2103, 2116, 2103, 2069, 2103, 2065, 2100, 2119, 2100, 2072, 2100, 2076, 2111, 
		2099, 2111, 2075, 2111, 2080, 2096, 2110, 2096, 2079, 2096, 2083, 2113, 2095, 2113, 2082, 2113, 
		2086, 2094, 2092, 2094, 2098, 2094, 2109, 2091, 2102, 2091, 2118, 2091, 2097, 2112, 2106, 2112, 
		2090, 2112, 2093, 2105, 2115, 2105, 2101, 2105, 2089, 2124, 2132, 2124, 2135, 2124, 2128, 2149, 
		2123, 2149, 2127, 2149, 2152, 2142, 2138, 2142, 2131, 2142, 2122, 2145, 2141, 2145, 2121, 2145, 
		2148, 2179, 2170, 2179, 2126, 2179, 2134, 2169, 2176, 2169, 2151, 2169, 2125, 2182, 2166, 2182, 
		2130, 2182, 2137, 2165, 2178, 2165, 2133, 2165, 2129, 2163, 2181, 2163, 2136, 2163, 2140, 2173, 
		2162, 2173, 2139, 2173, 2144, 2159, 2172, 2159, 2143, 2159, 2147, 2175, 2158, 2175, 2146, 2175, 
		2150, 2157, 2155, 2157, 2161, 2157, 2171, 2154, 2164, 2154, 2180, 2154, 2160, 2174, 2168, 2174, 
		2153, 2174, 2156, 2167, 2177, 2167, 2164, 2167, 2154, 2186, 2194, 2186, 2197, 2186, 2190, 2211, 
		2185, 2211, 2189, 2211, 2214, 2204, 2200, 2204, 2193, 2204, 2184, 2207, 2203, 2207, 2183, 2207, 
		2210, 2241, 2232, 2241, 2188, 2241, 2196, 2231, 2238, 2231, 2213, 2231, 2187, 2244, 2228, 2244, 
		2192, 2244, 2199, 2227, 2240, 2227, 2195, 2227, 2191, 2224, 2243, 2224, 2198, 2224, 2202, 2235, 
		2223, 2235, 2201, 2235, 2206, 2220, 2234, 2220, 2205, 2220, 2209, 2237, 2219, 2237, 2208, 2237, 
		2212, 2218, 2217, 2218, 2222, 2218, 2233, 2216, 2226, 2216, 2242, 2216, 2221, 2236, 2230, 2236, 
		2217, 2236, 2218, 2229, 2239, 2229, 2225, 2229, 2215, 2248, 2256, 2248, 2259, 2248, 2252, 2275, 
		2247, 2275, 2251, 2275, 2278, 2268, 2263, 2268, 2255, 2268, 2246, 2271, 2267, 2271, 2245, 2271, 
		2274, 2300, 2291, 2300, 2250, 2300, 2258, 2290, 2297, 2290, 2277, 2290, 2249, 2303, 2288, 2303, 
		2254, 2303, 2262, 2287, 2299, 2287, 2257, 2287, 2253, 2294, 2285, 2294, 2266, 2294, 2270, 2282, 
		2293, 2282, 2269, 2282, 2273, 2296, 2281, 2296, 2272, 2296, 2276, 2280, 2279, 2280, 2284, 2280, 
		2292, 2279, 2286, 2279, 2302, 2279, 2284, 2295, 2289, 2295, 2279, 2295, 2280, 2289, 2298, 2289, 
		2286, 2289, 2279, 2304, 2310, 2304, 2313, 2304, 2307, 2325, 2304, 2325, 2307, 2325, 2328, 2319, 
		2316, 2319, 2310, 2319, 2304, 2355, 2346, 2355, 2306, 2355, 2312, 2345, 2352, 2345, 2327, 2345, 
		2305, 2358, 2342, 2358, 2309, 2358, 2315, 2351, 2336, 2351, 2324, 2351, 2326, 2331, 2341, 2331, 
		2357, 2331, 2339, 2350, 2344, 2350, 2330, 2350, 2335, 2343, 2354, 2343, 2341, 2343, 2331, 2341, 
		2354, 2341, 2361, 2341, 2364, 2353, 2311, 2353, 2367, 2353, 2360, 2313, 2310, 2313, 2370, 2313, 
		2366, 2308, 2340, 2308, 2363, 2308, 2369, 2362, 2359, 2362, 2365, 2362, 2368, 2377, 2380, 2371, 
		2380, 2374, 2392, 2371, 2392, 2374, 2392, 2395, 2386, 2383, 2386, 2377, 2386, 2371, 2389, 2386, 
		2389, 2371, 2389, 2392, 2417, 2408, 2417, 2373, 2417, 2379, 2407, 2414, 2407, 2394, 2407, 2372, 
		2420, 2405, 2420, 2376, 2420, 2382, 2404, 2416, 2404, 2378, 2404, 2375, 2402, 2419, 2402, 2381, 
		2402, 2385, 2411, 2401, 2411, 2384, 2411, 2388, 2399, 2410, 2399, 2387, 2399, 2391, 2413, 2398, 
		2413, 2390, 2413, 2393, 2397, 2396, 2397, 2400, 2397, 2409, 2396, 2403, 2396, 2418, 2396, 2400, 
		2412, 2406, 2412, 2396, 2412, 2397, 2403, 2396, 2415, 2396, 2406, 2421, 2427, 2421, 2430, 2421, 
		2424, 2442, 2421, 2442, 2424, 2442, 2445, 2436, 2433, 2436, 2427, 2436, 2421, 2439, 2436, 2439, 
		2421, 2439, 2442, 2472, 2463, 2472, 2423, 2472, 2429, 2462, 2469, 2462, 2444, 2462, 2422, 2475, 
		2459, 2475, 2426, 2475, 2432, 2458, 2471, 2458, 2428, 2458, 2425, 2456, 2474, 2456, 2431, 2456, 
		2435, 2466, 2455, 2466, 2434, 2466, 2438, 2452, 2465, 2452, 2437, 2452, 2441, 2468, 2451, 2468, 
		2440, 2468, 2443, 2450, 2448, 2450, 2454, 2450, 2464, 2447, 2457, 2447, 2473, 2447, 2453, 2467, 
		2461, 2467, 2446, 2467, 2449, 2460, 2470, 2460, 2457, 2460, 2447, 2478, 2304, 2478, 2325, 2322, 
		2478, 2322, 2325, 2478, 2319, 2478, 2304, 2480, 2356, 2480, 2314, 2318, 2480, 2318, 2314, 2480, 
		2338, 2480, 2356, 2487, 2337, 2487, 2479, 2487, 2489, 2349, 2486, 2349, 2488, 2349, 2482, 2489, 
		2479, 2489, 2317, 2489, 2477, 2482, 2488, 2482, 2476, 2482, 2321, 2481, 2323, 2481, 2334, 2348, 
		2481, 2348, 2334, 2481, 2320, 2481, 2323, 2485, 2333, 2485, 2329, 2339, 2484, 2339, 2331, 2483, 
		2347, 2483, 2332, 2490, 2496, 2490, 2499, 2490, 2493, 2505, 2502, 2505, 2496, 2505, 2490, 2508, 
		2505, 2508, 2490, 2508, 2511, 2539, 2524, 2539, 2495, 2539, 2501, 2523, 2536, 2523, 2498, 2523, 
		2494, 2521, 2538, 2521, 2500, 2521, 2504, 2530, 2520, 2530, 2503, 2530, 2507, 2518, 2529, 2518, 
		2506, 2518, 2510, 2517, 2515, 2517, 2519, 2517, 2528, 2515, 2522, 2515, 2537, 2515, 2519, 2527, 
		2535, 2527, 2522, 2527, 2515, 2544, 2511, 2544, 2490, 2493, 2544, 2493, 2490, 2544, 2514, 2544, 
		2511, 2541, 2497, 2541, 2534, 2526, 2541, 2526, 2534, 2541, 2492, 2541, 2497, 2549, 2533, 2549, 
		2546, 2549, 2551, 2525, 2548, 2525, 2550, 2525, 2540, 2551, 2546, 2551, 2513, 2551, 2543, 2540, 
		2550, 2540, 2542, 2540, 2491, 2545, 2516, 2545, 2509, 2512, 2545, 2512, 2509, 2545, 2532, 2545, 
		2516, 2547, 2515, 2547, 2517, 2531, 2547, 2531, 2517, 2547, 2527, 2547, 2515, 2555, 2563, 2555, 
		2566, 2555, 2559, 2580, 2554, 2580, 2558, 2580, 2583, 2573, 2569, 2573, 2562, 2573, 2553, 2576, 
		2572, 2576, 2552, 2576, 2579, 2605, 2596, 2605, 2557, 2605, 2565, 2595, 2602, 2595, 2582, 2595, 
		2556, 2608, 2593, 2608, 2561, 2608, 2568, 2592, 2604, 2592, 2564, 2592, 2560, 2590, 2607, 2590, 
		2567, 2590, 2571, 2599, 2589, 2599, 2570, 2599, 2575, 2587, 2598, 2587, 2574, 2587, 2578, 2601, 
		2586, 2601, 2577, 2601, 2581, 2585, 2584, 2585, 2588, 2585, 2597, 2584, 2591, 2584, 2606, 2584, 
		2588, 2600, 2594, 2600, 2584, 2600, 2585, 2594, 2603, 2594, 2591, 2594, 2584, 2284, 2302, 2284, 
		2611, 2284, 2614, 2265, 2283, 2265, 2613, 2265, 2617, 2301, 2261, 2301, 2620, 2301, 2610, 2260, 
		2264, 2260, 2616, 2260, 2619, 2612, 2609, 2612, 2618, 2612, 2615, 2621, 2627, 2621, 2630, 2621, 
		2624, 2642, 2621, 2642, 2624, 2642, 2645, 2636, 2633, 2636, 2627, 2636, 2621, 2639, 2636, 2639, 
		2621, 2639, 2642, 2667, 2658, 2667, 2623, 2667, 2629, 2657, 2664, 2657, 2644, 2657, 2622, 2670, 
		2655, 2670, 2626, 2670, 2632, 2654, 2666, 2654, 2628, 2654, 2625, 2652, 2669, 2652, 2631, 2652, 
		2635, 2661, 2651, 2661, 2634, 2661, 2638, 2649, 2660, 2649, 2637, 2649, 2641, 2663, 2648, 2663, 
		2640, 2663, 2643, 2647, 2646, 2647, 2650, 2647, 2659, 2646, 2653, 2646, 2668, 2646, 2650, 2662, 
		2656, 2662, 2646, 2662, 2647, 2656, 2665, 2656, 2653, 2656, 2646, 2685, 2676, 2685, 2688, 2685, 
		2695, 2679, 2685, 2679, 2695, 2679, 2694, 2695, 2688, 2695, 2673, 2695, 2691, 2694, 2695, 2694, 
		2691, 2694, 2682, 2678, 2693, 2678, 2701, 2678, 2698, 2692, 2681, 2692, 2704, 2692, 2700, 2680, 
		2690, 2680, 2708, 2680, 2703, 2689, 2672, 2689, 2711, 2689, 2707, 2687, 2675, 2687, 2714, 2687, 
		2718, 2671, 2686, 2671, 2717, 2671, 2710, 2684, 2677, 2684, 2697, 2684, 2722, 2674, 2683, 2674, 
		2721, 2674, 2713, 2702, 2706, 2702, 2725, 2702, 2699, 2705, 2709, 2705, 2716, 2705, 2724, 2699, 
		2725, 2699, 2720, 2699, 2696, 2723, 2715, 2723, 2712, 2723, 2719, 2726, 2732, 2726, 2735, 2726, 
		2729, 2747, 2726, 2747, 2729, 2747, 2750, 2744, 2741, 2744, 2726, 2744, 2747, 2777, 2768, 2777, 
		2728, 2777, 2734, 2767, 2774, 2767, 2749, 2767, 2727, 2771, 2762, 2771, 2740, 2771, 2743, 2757, 
		2770, 2757, 2742, 2757, 2746, 2773, 2756, 2773, 2745, 2773, 2748, 2755, 2753, 2755, 2761, 2755, 
		2769, 2772, 2766, 2772, 2752, 2772, 2754, 2766, 2776, 2766, 2765, 2766, 2752, 2783, 2726, 2783, 
		2741, 2738, 2783, 2738, 2741, 2783, 2732, 2783, 2726, 2792, 2764, 2792, 2785, 2792, 2794, 2780, 
		2791, 2780, 2793, 2780, 2787, 2794, 2785, 2794, 2731, 2794, 2782, 2787, 2793, 2787, 2781, 2787, 
		2737, 2784, 2775, 2784, 2733, 2730, 2784, 2730, 2733, 2784, 2763, 2784, 2775, 2786, 2739, 2786, 
		2760, 2779, 2786, 2779, 2760, 2786, 2736, 2786, 2739, 2790, 2759, 2790, 2751, 2765, 2789, 2765, 
		2752, 2788, 2778, 2788, 2758, 2798, 2806, 2798, 2809, 2798, 2802, 2823, 2797, 2823, 2801, 2823, 
		2826, 2816, 2812, 2816, 2805, 2816, 2796, 2819, 2815, 2819, 2795, 2819, 2822, 2848, 2839, 2848, 
		2800, 2848, 2808, 2838, 2845, 2838, 2825, 2838, 2799, 2851, 2836, 2851, 2804, 2851, 2811, 2835, 
		2847, 2835, 2807, 2835, 2803, 2833, 2850, 2833, 2810, 2833, 2814, 2842, 2832, 2842, 2813, 2842, 
		2818, 2830, 2841, 2830, 2817, 2830, 2821, 2844, 2829, 2844, 2820, 2844, 2824, 2828, 2827, 2828, 
		2831, 2828, 2840, 2827, 2834, 2827, 2849, 2827, 2831, 2843, 2837, 2843, 2827, 2843, 2828, 2837, 
		2846, 2837, 2834, 2837, 2827, 2852, 2858, 2852, 2861, 2852, 2855, 2873, 2852, 2873, 2855, 2873, 
		2876, 2867, 2864, 2867, 2858, 2867, 2852, 2903, 2894, 2903, 2854, 2903, 2860, 2893, 2900, 2893, 
		2875, 2893, 2853, 2906, 2891, 2906, 2857, 2906, 2863, 2890, 2902, 2890, 2859, 2890, 2856, 2887, 
		2905, 2887, 2862, 2887, 2866, 2879, 2889, 2879, 2904, 2879, 2886, 2899, 2892, 2899, 2878, 2899, 
		2882, 2892, 2901, 2892, 2888, 2892, 2878, 2909, 2867, 2909, 2852, 2873, 2909, 2873, 2852, 2909, 
		2870, 2909, 2867, 2911, 2885, 2911, 2865, 2869, 2911, 2869, 2865, 2911, 2897, 2911, 2885, 2918, 
		2896, 2918, 2910, 2918, 2920, 2881, 2917, 2881, 2919, 2881, 2913, 2920, 2910, 2920, 2868, 2920, 
		2908, 2913, 2919, 2913, 2907, 2913, 2872, 2912, 2874, 2912, 2898, 2880, 2912, 2880, 2898, 2912, 
		2871, 2912, 2874, 2916, 2877, 2916, 2884, 2895, 2915, 2895, 2883, 2914, 2882, 2914, 2878, 2921, 
		2927, 2921, 2930, 2921, 2924, 2942, 2921, 2942, 2924, 2942, 2945, 2936, 2933, 2936, 2927, 2936, 
		2921, 2939, 2936, 2939, 2921, 2939, 2942, 2967, 2958, 2967, 2923, 2967, 2929, 2957, 2964, 2957, 
		2944, 2957, 2922, 2970, 2955, 2970, 2926, 2970, 2932, 2954, 2966, 2954, 2928, 2954, 2925, 2952, 
		2969, 2952, 2931, 2952, 2935, 2961, 2951, 2961, 2934, 2961, 2938, 2949, 2960, 2949, 2937, 2949, 
		2941, 2963, 2948, 2963, 2940, 2963, 2943, 2947, 2946, 2947, 2950, 2947, 2959, 2946, 2953, 2946, 
		2968, 2946, 2950, 2962, 2956, 2962, 2946, 2962, 2947, 2956, 2965, 2956, 2953, 2956, 2946, 2971, 
		2977, 2971, 2980, 2971, 2974, 2992, 2971, 2992, 2974, 2992, 2995, 2986, 2983, 2986, 2977, 2986, 
		2971, 2989, 2986, 2989, 2971, 2989, 2992, 3022, 3013, 3022, 2973, 3022, 2979, 3012, 3019, 3012, 
		2994, 3012, 2972, 3025, 3009, 3025, 2976, 3025, 2982, 3008, 3021, 3008, 2978, 3008, 2975, 3006, 
		3024, 3006, 2981, 3006, 2985, 3016, 3005, 3016, 2984, 3016, 2988, 3002, 3015, 3002, 2987, 3002, 
		2991, 3018, 3001, 3018, 2990, 3018, 2993, 3000, 2998, 3000, 3004, 3000, 3014, 2997, 3007, 2997, 
		3023, 2997, 3003, 3017, 3011, 3017, 2996, 3017, 2999, 3010, 3020, 3010, 3007, 3010, 2997, 3029, 
		3037, 3029, 3040, 3029, 3033, 3054, 3028, 3054, 3032, 3054, 3057, 3047, 3043, 3047, 3036, 3047, 
		3027, 3050, 3046, 3050, 3026, 3050, 3053, 3079, 3070, 3079, 3031, 3079, 3039, 3069, 3076, 3069, 
		3056, 3069, 3030, 3082, 3067, 3082, 3035, 3082, 3042, 3066, 3078, 3066, 3038, 3066, 3034, 3064, 
		3081, 3064, 3041, 3064, 3045, 3073, 3063, 3073, 3044, 3073, 3049, 3061, 3072, 3061, 3048, 3061, 
		3052, 3075, 3060, 3075, 3051, 3075, 3055, 3059, 3058, 3059, 3062, 3059, 3071, 3058, 3065, 3058, 
		3080, 3058, 3062, 3074, 3068, 3074, 3058, 3074, 3059, 3068, 3077, 3068, 3065, 3068, 3058, 3083, 
		3089, 3083, 3092, 3083, 3086, 3104, 3083, 3104, 3086, 3104, 3107, 3098, 3095, 3098, 3089, 3098, 
		3083, 3136, 3127, 3136, 3085, 3136, 3091, 3126, 3133, 3126, 3106, 3126, 3084, 3139, 3123, 3139, 
		3088, 3139, 3094, 3122, 3135, 3122, 3090, 3122, 3087, 3120, 3138, 3120, 3093, 3120, 3097, 3111, 
		3121, 3111, 3137, 3111, 3119, 3132, 3125, 3132, 3110, 3132, 3115, 3124, 3134, 3124, 3121, 3124, 
		3111, 3142, 3098, 3142, 3083, 3104, 3142, 3104, 3083, 3142, 3101, 3142, 3098, 3144, 3118, 3144, 
		3096, 3100, 3144, 3100, 3096, 3144, 3130, 3144, 3118, 3151, 3129, 3151, 3143, 3151, 3153, 3114, 
		3150, 3114, 3152, 3114, 3146, 3153, 3143, 3153, 3099, 3153, 3141, 3146, 3152, 3146, 3140, 3146, 
		3103, 3145, 3105, 3145, 3131, 3113, 3145, 3113, 3131, 3145, 3102, 3145, 3105, 3149, 3109, 3149, 
		3117, 3128, 3148, 3128, 3116, 3147, 3112, 3147, 3108, 3165, 3168, 3157, 3168, 3161, 3182, 3156, 
		3182, 3160, 3182, 3185, 3175, 3171, 3175, 3164, 3175, 3155, 3178, 3174, 3178, 3154, 3178, 3181, 
		3207, 3198, 3207, 3159, 3207, 3167, 3197, 3204, 3197, 3184, 3197, 3158, 3210, 3195, 3210, 3163, 
		3210, 3170, 3194, 3206, 3194, 3166, 3194, 3162, 3192, 3209, 3192, 3169, 3192, 3173, 3201, 3191, 
		3201, 3172, 3201, 3177, 3189, 3200, 3189, 3176, 3189, 3180, 3203, 3188, 3203, 3179, 3203, 3183, 
		3187, 3186, 3187, 3190, 3187, 3199, 3186, 3193, 3186, 3208, 3186, 3190, 3202, 3196, 3202, 3186, 
		3202, 3187, 3193, 3186, 3205, 3186, 3196, 3211, 3217, 3211, 3220, 3211, 3214, 3232, 3211, 3232, 
		3214, 3232, 3235, 3226, 3223, 3226, 3217, 3226, 3211, 3229, 3226, 3229, 3211, 3229, 3232, 3262, 
		3253, 3262, 3213, 3262, 3219, 3252, 3259, 3252, 3234, 3252, 3212, 3265, 3250, 3265, 3216, 3265, 
		3222, 3249, 3261, 3249, 3218, 3249, 3215, 3246, 3264, 3246, 3221, 3246, 3225, 3256, 3245, 3256, 
		3224, 3256, 3228, 3242, 3255, 3242, 3227, 3242, 3231, 3258, 3241, 3258, 3230, 3258, 3233, 3240, 
		3238, 3240, 3244, 3240, 3254, 3237, 3248, 3237, 3263, 3237, 3243, 3257, 3251, 3257, 3236, 3257, 
		3239, 3251, 3260, 3251, 3247, 3251, 3236, 3266, 3272, 3266, 3275, 3266, 3269, 3287, 3266, 3287, 
		3269, 3287, 3290, 3281, 3278, 3281, 3272, 3281, 3266, 3284, 3281, 3284, 3266, 3284, 3287, 3317, 
		3308, 3317, 3268, 3317, 3274, 3307, 3314, 3307, 3289, 3307, 3267, 3320, 3304, 3320, 3271, 3320, 
		3277, 3303, 3316, 3303, 3273, 3303, 3270, 3301, 3319, 3301, 3276, 3301, 3280, 3311, 3300, 3311, 
		3279, 3311, 3283, 3297, 3310, 3297, 3282, 3297, 3286, 3313, 3296, 3313, 3285, 3313, 3288, 3295, 
		3293, 3295, 3299, 3295, 3309, 3292, 3302, 3292, 3318, 3292, 3298, 3312, 3306, 3312, 3291, 3312, 
		3294, 3305, 3315, 3305, 3302, 3305, 3292, 3332, 3335, 3324, 3335, 3328, 3349, 3323, 3349, 3327, 
		3349, 3352, 3342, 3338, 3342, 3331, 3342, 3322, 3345, 3341, 3345, 3321, 3345, 3348, 3374, 3365, 
		3374, 3326, 3374, 3334, 3364, 3371, 3364, 3351, 3364, 3325, 3377, 3362, 3377, 3330, 3377, 3337, 
		3361, 3373, 3361, 3333, 3361, 3329, 3359, 3376, 3359, 3336, 3359, 3340, 3368, 3358, 3368, 3339, 
		3368, 3344, 3356, 3367, 3356, 3343, 3356, 3347, 3370, 3355, 3370, 3346, 3370, 3350, 3354, 3353, 
		3354, 3357, 3354, 3366, 3353, 3360, 3353, 3375, 3353, 3357, 3369, 3363, 3369, 3353, 3369, 3354, 
		3360, 3353, 3372, 3353, 3363, 3382, 3390, 3382, 3393, 3382, 3386, 3408, 3381, 3408, 3385, 3408, 
		3411, 3404, 3401, 3404, 3380, 3404, 3407, 3433, 3424, 3433, 3384, 3433, 3392, 3423, 3430, 3423, 
		3410, 3423, 3383, 3427, 3418, 3427, 3400, 3427, 3403, 3415, 3426, 3415, 3402, 3415, 3406, 3429, 
		3414, 3429, 3405, 3429, 3409, 3413, 3412, 3413, 3417, 3413, 3425, 3428, 3422, 3428, 3412, 3428, 
		3413, 3422, 3432, 3422, 3421, 3422, 3412, 3441, 3379, 3441, 3399, 3396, 3440, 3396, 3398, 3439, 
		3389, 3439, 3378, 3448, 3420, 3448, 3443, 3448, 3450, 3436, 3447, 3436, 3449, 3436, 3445, 3450, 
		3443, 3450, 3388, 3450, 3438, 3445, 3449, 3445, 3437, 3445, 3395, 3442, 3431, 3442, 3391, 3387, 
		3442, 3387, 3391, 3442, 3419, 3442, 3431, 3444, 3397, 3444, 3416, 3435, 3444, 3435, 3416, 3444, 
		3394, 3444, 3397, 3446, 3417, 3446, 3412, 3421, 3446, 3421, 3412, 3446, 3434, 3446, 3417, 3454, 
		3462, 3454, 3465, 3454, 3458, 3479, 3453, 3479, 3457, 3479, 3482, 3472, 3468, 3472, 3461, 3472, 
		3452, 3475, 3471, 3475, 3451, 3475, 3478, 3504, 3495, 3504, 3456, 3504, 3464, 3494, 3501, 3494, 
		3481, 3494, 3455, 3507, 3492, 3507, 3460, 3507, 3467, 3491, 3503, 3491, 3463, 3491, 3459, 3489, 
		3506, 3489, 3466, 3489, 3470, 3498, 3488, 3498, 3469, 3498, 3474, 3486, 3497, 3486, 3473, 3486, 
		3477, 3500, 3485, 3500, 3476, 3500, 3480, 3484, 3483, 3484, 3487, 3484, 3496, 3483, 3490, 3483, 
		3505, 3483, 3487, 3499, 3493, 3499, 3483, 3499, 3484, 3493, 3502, 3493, 3490, 3493, 3483, 3511, 
		3519, 3511, 3522, 3511, 3515, 3536, 3510, 3536, 3514, 3536, 3539, 3529, 3525, 3529, 3518, 3529, 
		3509, 3532, 3528, 3532, 3508, 3532, 3535, 3568, 3559, 3568, 3513, 3568, 3521, 3558, 3565, 3558, 
		3538, 3558, 3512, 3571, 3555, 3571, 3517, 3571, 3524, 3554, 3567, 3554, 3520, 3554, 3516, 3551, 
		3570, 3551, 3523, 3551, 3527, 3562, 3550, 3562, 3526, 3562, 3531, 3547, 3561, 3547, 3530, 3547, 
		3534, 3564, 3546, 3564, 3533, 3564, 3537, 3545, 3543, 3545, 3549, 3545, 3560, 3542, 3553, 3542, 
		3569, 3542, 3548, 3563, 3557, 3563, 3541, 3563, 3544, 3556, 3566, 3556, 3552, 3556, 3540, 141, 
		132, 141, 144, 141, 151, 135, 141, 135, 151, 135, 150, 151, 144, 151, 129, 151, 
		147, 150, 151, 150, 147, 150, 138, 134, 149, 134, 158, 134, 154, 148, 137, 148, 
		161, 148, 157, 136, 146, 136, 165, 136, 160, 145, 128, 145, 168, 145, 164, 143, 
		131, 143, 171, 143, 175, 127, 142, 127, 174, 127, 167, 140, 133, 140, 153, 140, 
		179, 130, 139, 130, 178, 130, 170, 159, 163, 159, 183, 159, 156, 162, 166, 162, 
		173, 162, 182, 155, 181, 155, 177, 155, 152, 180, 172, 180, 169, 180, 176, 184, 
		190, 184, 193, 184, 187, 205, 184, 205, 187, 205, 208, 199, 196, 199, 190, 199, 
		184, 202, 199, 202, 184, 202, 205, 230, 221, 230, 186, 230, 192, 220, 227, 220, 
		207, 220, 185, 233, 218, 233, 189, 233, 195, 217, 229, 217, 191, 217, 188, 215, 
		232, 215, 194, 215, 198, 224, 214, 224, 197, 224, 201, 212, 223, 212, 200, 212, 
		204, 226, 211, 226, 203, 226, 206, 210, 209, 210, 213, 210, 222, 209, 216, 209, 
		231, 209, 213, 225, 219, 225, 209, 225, 210, 219, 228, 219, 216, 219, 209, 248, 
		239, 248, 251, 248, 258, 242, 248, 242, 258, 242, 257, 258, 251, 258, 236, 258, 
		254, 979, 964, 979, 955, 979, 959, 257, 258, 257, 254, 257, 245, 241, 256, 241, 
		264, 241, 261, 255, 244, 255, 267, 255, 263, 243, 253, 243, 270, 243, 266, 252, 
		235, 252, 273, 252, 269, 250, 238, 250, 276, 250, 279, 234, 249, 234, 278, 234, 
		272, 247, 240, 247, 260, 247, 282, 237, 246, 237, 281, 237, 275, 265, 268, 265, 
		283, 265, 262, 268, 271, 268, 277, 268, 283, 262, 283, 262, 280, 262, 259, 283, 
		277, 283, 274, 283, 280, 288, 296, 288, 299, 288, 292, 314, 287, 314, 291, 314, 
		317, 306, 302, 306, 295, 306, 286, 339, 330, 339, 290, 339, 298, 329, 336, 329, 
		316, 329, 289, 342, 327, 342, 294, 342, 301, 326, 338, 326, 297, 326, 293, 335, 
		321, 335, 313, 335, 315, 318, 325, 318, 341, 318, 324, 334, 328, 334, 318, 334, 
		320, 328, 337, 328, 325, 328, 318, 357, 348, 357, 360, 357, 365, 365, 360, 365, 
		345, 365, 361, 364, 365, 364, 361, 364, 354, 359, 347, 359, 390, 359, 377, 344, 
		358, 344, 376, 344, 394, 346, 356, 346, 381, 346, 389, 3721, 3711, 3721, 3725, 3721, 
		3737, 3714, 3720, 3714, 3736, 3714, 3733, 3735, 3724, 3735, 3708, 3735, 3729, 3732, 3734, 3732, 
		3728, 3732, 3717, 3731, 3716, 3731, 3753, 3731, 3741, 3713, 3730, 3713, 3740, 3713, 3756, 3727, 
		3707, 3727, 3762, 3727, 3744, 3715, 3726, 3715, 3743, 3715, 3752, 3706, 3723, 3706, 3747, 3706, 
		3761, 3722, 3710, 3722, 3759, 3722, 3746, 3719, 3712, 3719, 3755, 3719, 3750, 3709, 3718, 3709, 
		3749, 3709, 3758, 3745, 3757, 3745, 3748, 3745, 3738, 3738, 3748, 3738, 3754, 3738, 3739, 3760, 
		3745, 3760, 3738, 3760, 3742, 3742, 3738, 3742, 3739, 3742, 3751, 3785, 3776, 3785, 3788, 3785, 
		3795, 3779, 3785, 3779, 3795, 3779, 3794, 3795, 3788, 3795, 3773, 3795, 3791, 3794, 3795, 3794, 
		3791, 3794, 3782, 3793, 3781, 3793, 3811, 3793, 3799, 3778, 3792, 3778, 3798, 3778, 3814, 3790, 
		3772, 3790, 3820, 3790, 3802, 3780, 3789, 3780, 3801, 3780, 3810, 3771, 3787, 3771, 3805, 3771, 
		3819, 3786, 3775, 3786, 3817, 3786, 3804, 3784, 3777, 3784, 3813, 3784, 3808, 3774, 3783, 3774, 
		3807, 3774, 3816, 3803, 3815, 3803, 3806, 3803, 3796, 3796, 3806, 3796, 3812, 3796, 3797, 3818, 
		3803, 3818, 3796, 3818, 3800, 3800, 3796, 3800, 3797, 3800, 3809, 3843, 3834, 3843, 3846, 3843, 
		3853, 3837, 3843, 3837, 3853, 3837, 3852, 3853, 3846, 3853, 3831, 3853, 3849, 3852, 3853, 3852, 
		3849, 3852, 3840, 3851, 3839, 3851, 3874, 3851, 3859, 3836, 3850, 3836, 3858, 3836, 3877, 3848, 
		3830, 3848, 3883, 3848, 3863, 3838, 3847, 3838, 3862, 3838, 3873, 3829, 3845, 3829, 3867, 3829, 
		3882, 3844, 3833, 3844, 3880, 3844, 3866, 3842, 3835, 3842, 3876, 3842, 3871, 3832, 3841, 3832, 
		3870, 3832, 3879, 3865, 3878, 3865, 3869, 3865, 3856, 3855, 3868, 3855, 3875, 3855, 3857, 3881, 
		3864, 3881, 3854, 3881, 3861, 3860, 3855, 3860, 3857, 3860, 3872, 3911, 3901, 3911, 3915, 3911, 
		3927, 3904, 3910, 3904, 3926, 3904, 3923, 3925, 3914, 3925, 3897, 3925, 3919, 3922, 3924, 3922, 
		3918, 3922, 3907, 3921, 3906, 3921, 3950, 3921, 3935, 3903, 3920, 3903, 3934, 3903, 3953, 3917, 
		3896, 3917, 3961, 3917, 3939, 3905, 3916, 3905, 3938, 3905, 3949, 3909, 3902, 3909, 3952, 3909, 
		3947, 3900, 3908, 3900, 3946, 3900, 3957, 3943, 3956, 3943, 3945, 3943, 3931, 3930, 3944, 3930, 
		3951, 3930, 3933, 3960, 3942, 3960, 3929, 3960, 3937, 3936, 3928, 3936, 3932, 3936, 3948, 3955, 
		3941, 3955, 3971, 3955, 3967, 3899, 3954, 3899, 3966, 3899, 3978, 3940, 3959, 3940, 3964, 3940, 
		3970, 3958, 3895, 3958, 3981, 3958, 3963, 3894, 3913, 3894, 3975, 3894, 3980, 3912, 3898, 3912, 
		3977, 3912, 3974, 3979, 3973, 3979, 3969, 3979, 3962, 3972, 3976, 3972, 3965, 3972, 3968, 3998, 
		3989, 3998, 4001, 3998, 4008, 4008, 4001, 4008, 3986, 4008, 4004, 3992, 4011, 3992, 4015, 3992, 
		4007, 4011, 3998, 4011, 4008, 4011, 4015, 4007, 4015, 4007, 4014, 4007, 3995, 4015, 4008, 4015, 
		4004, 4015, 4014, 3994, 4013, 3994, 4019, 3994, 4038, 4012, 4003, 4012, 4029, 4012, 4018, 4010, 
		3991, 4010, 4041, 4010, 4022, 3997, 4009, 3997, 4021, 3997, 4035, 3990, 4006, 3990, 4026, 3990, 
		4040, 4005, 3993, 4005, 4037, 4005, 4025, 4002, 3985, 4002, 4047, 4002, 4028, 4000, 3988, 4000, 
		4044, 4000, 4032, 3984, 3999, 3984, 4031, 3984, 4046, 3987, 3996, 3987, 4034, 3987, 4043, 4030, 
		4042, 4030, 4033, 4030, 4023, 4045, 4030, 4045, 4023, 4045, 4027, 4016, 4020, 4016, 4039, 4016, 
		4024, 4023, 4033, 4023, 4020, 4023, 4016, 4017, 4016, 4017, 4024, 4017, 4036, 4027, 4023, 4027, 
		4016, 4027, 4017, 4068, 4072, 4068, 4079, 4068, 4078, 4078, 4079, 4078, 4071, 4078, 4059, 4072, 
		4062, 4072, 4075, 4072, 4079, 4079, 4075, 4079, 4056, 4079, 4071, 4050, 4065, 4050, 4072, 4050, 
		4068, 4065, 4053, 4065, 4062, 4065, 4072, 4122, 4112, 4122, 4061, 4122, 4052, 4125, 4108, 4125, 
		4064, 4125, 4049, 4103, 4124, 4103, 4048, 4103, 4067, 4099, 4115, 4099, 4058, 4099, 4070, 4118, 
		4098, 4118, 4069, 4118, 4055, 4111, 4091, 4111, 4074, 4111, 4060, 4090, 4117, 4090, 4054, 4090, 
		4073, 4087, 4102, 4087, 4066, 4087, 4077, 4114, 4086, 4114, 4076, 4114, 4057, 4083, 4095, 4083, 
		4101, 4083, 4085, 4097, 4082, 4097, 4084, 4097, 4113, 4089, 4110, 4089, 4094, 4089, 4081, 4116, 
		4088, 4116, 4080, 4116, 4096, 4093, 4107, 4093, 4123, 4093, 4100, 4109, 4121, 4109, 4106, 4109, 
		4092, 4105, 4120, 4105, 4128, 4105, 4131, 4119, 4051, 4119, 4137, 4119, 4127, 4053, 4065, 4053, 
		4134, 4053, 4136, 4063, 4104, 4063, 4130, 4063, 4133, 4129, 4126, 4129, 4135, 4129, 4132, 4158, 
		4162, 4158, 4169, 4158, 4168, 4168, 4169, 4168, 4161, 4168, 4149, 4162, 4152, 4162, 4165, 4162, 
		4169, 4146, 4161, 4165, 4161, 4169, 4140, 4155, 4140, 4162, 4140, 4158, 4155, 4143, 4155, 4152, 
		4155, 4162, 4208, 4199, 4208, 4151, 4208, 4142, 4211, 4195, 4211, 4154, 4211, 4139, 4194, 4207, 
		4194, 4141, 4194, 4153, 4191, 4210, 4191, 4138, 4191, 4157, 4187, 4202, 4187, 4148, 4187, 4160, 
		4205, 4186, 4205, 4159, 4205, 4145, 4198, 4180, 4198, 4164, 4198, 4150, 4179, 4204, 4179, 4144, 
		4179, 4163, 4176, 4190, 4176, 4156, 4176, 4167, 4201, 4175, 4201, 4166, 4201, 4147, 4172, 4184, 
		4172, 4189, 4172, 4174, 4185, 4171, 4185, 4173, 4185, 4200, 4178, 4197, 4178, 4183, 4178, 4170, 
		4185, 4203, 4171, 4203, 4177, 4182, 4193, 4182, 4209, 4182, 4188, 4196, 4206, 4196, 4192, 4196, 
		4181, 4232, 4236, 4232, 4243, 4232, 4242, 4242, 4243, 4242, 4235, 4242, 4223, 4236, 4226, 4236, 
		4239, 4236, 4243, 4243, 4239, 4243, 4220, 4243, 4235, 4214, 4229, 4214, 4236, 4214, 4232, 4229, 
		4217, 4229, 4226, 4229, 4236, 4282, 4273, 4282, 4225, 4282, 4216, 4285, 4269, 4285, 4228, 4285, 
		4213, 4268, 4281, 4268, 4215, 4268, 4227, 4265, 4284, 4265, 4212, 4265, 4231, 4261, 4276, 4261, 
		4222, 4261, 4234, 4279, 4260, 4279, 4233, 4279, 4219, 4272, 4254, 4272, 4238, 4272, 4224, 4253, 
		4278, 4253, 4218, 4253, 4237, 4250, 4264, 4250, 4230, 4250, 4241, 4275, 4249, 4275, 4240, 4275, 
		4221, 4246, 4258, 4246, 4263, 4246, 4248, 4259, 4245, 4259, 4247, 4259, 4274, 4252, 4271, 4252, 
		4257, 4252, 4244, 4277, 4251, 4277, 4245, 4277, 4259, 4256, 4267, 4256, 4283, 4256, 4262, 4270, 
		4280, 4270, 4266, 4270, 4255, 4306, 4310, 4306, 4317, 4306, 4316, 4316, 4317, 4316, 4309, 4316, 
		4297, 4310, 4300, 4310, 4313, 4310, 4317, 4317, 4313, 4317, 4294, 4317, 4309, 4288, 4303, 4288, 
		4310, 4288, 4306, 4303, 4291, 4303, 4300, 4303, 4310, 4356, 4347, 4356, 4299, 4356, 4290, 4359, 
		4343, 4359, 4302, 4359, 4287, 4342, 4355, 4342, 4289, 4342, 4301, 4339, 4358, 4339, 4286, 4339, 
		4305, 4335, 4350, 4335, 4296, 4335, 4308, 4353, 4334, 4353, 4307, 4353, 4293, 4346, 4328, 4346, 
		4312, 4346, 4298, 4327, 4352, 4327, 4292, 4327, 4311, 4324, 4338, 4324, 4304, 4324, 4315, 4349, 
		4323, 4349, 4314, 4349, 4295, 4320, 4332, 4320, 4337, 4320, 4322, 4333, 4319, 4333, 4321, 4333, 
		4348, 4326, 4345, 4326, 4331, 4326, 4318, 4351, 4325, 4351, 4319, 4351, 4333, 4330, 4341, 4330, 
		4357, 4330, 4336, 4344, 4354, 4344, 4340, 4344, 4329, 4378, 4382, 4378, 4389, 4378, 4388, 4388, 
		4389, 4388, 4381, 4388, 4371, 4382, 4374, 4382, 4385, 4382, 4389, 4389, 4385, 4389, 4368, 4389, 
		4381, 4362, 4375, 4362, 4382, 4362, 4378, 4375, 4365, 4375, 4374, 4375, 4382, 4406, 4429, 4406, 
		4361, 4406, 4377, 4402, 4418, 4402, 4370, 4402, 4380, 4421, 4401, 4421, 4379, 4421, 4367, 4415, 
		4396, 4415, 4384, 4415, 4373, 4395, 4420, 4395, 4366, 4395, 4383, 4393, 4405, 4393, 4376, 4393, 
		4387, 4417, 4392, 4417, 4386, 4417, 4369, 4390, 4399, 4390, 4404, 4390, 4391, 4400, 4390, 4400, 
		4391, 4400, 4416, 4394, 4414, 4394, 4399, 4394, 4390, 4419, 4394, 4419, 4390, 4419, 4400, 4398, 
		4411, 4398, 4428, 4398, 4403, 4413, 4425, 4413, 4410, 4413, 4397, 4432, 4439, 4432, 4442, 4432, 
		4448, 4438, 4435, 4438, 4445, 4438, 4441, 4409, 4453, 4409, 4460, 4409, 4427, 4452, 4457, 4452, 
		4463, 4452, 4459, 4456, 4437, 4456, 4431, 4456, 4462, 4467, 4471, 4467, 4455, 4467, 4451, 4470, 
		4434, 4470, 4436, 4470, 4454, 4426, 4458, 4426, 4473, 4426, 4360, 4458, 4461, 4458, 4475, 4458, 
		4473, 4461, 4430, 4461, 4447, 4461, 4475, 4481, 4444, 4481, 4433, 4481, 4469, 4482, 4483, 4482, 
		4480, 4482, 4478, 4483, 4440, 4483, 4443, 4483, 4480, 4362, 4472, 4362, 4482, 4362, 4375, 4472, 
		4474, 4472, 4483, 4472, 4482, 4474, 4446, 4474, 4440, 4474, 4483, 4485, 4412, 4485, 4372, 4364, 
		4485, 4364, 4372, 4485, 4424, 4485, 4412, 4490, 4450, 4490, 4408, 4423, 4489, 4423, 4407, 4488, 
		4466, 4488, 4449, 4493, 4477, 4493, 4495, 4493, 4497, 4363, 4492, 4363, 4496, 4363, 4484, 4497, 
		4495, 4497, 4465, 4497, 4487, 4484, 4496, 4484, 4486, 4484, 4422, 4494, 4479, 4494, 4468, 4464, 
		4494, 4464, 4468, 4494, 4476, 4494, 4479, 4491, 4375, 4491, 4482, 4478, 4491, 4478, 4482, 4491, 
		4365, 4491, 4375, 4518, 4522, 4518, 4529, 4518, 4528, 4528, 4529, 4528, 4521, 4528, 4509, 4522, 
		4512, 4522, 4525, 4522, 4529, 4529, 4525, 4529, 4506, 4529, 4521, 4500, 4515, 4500, 4522, 4500, 
		4518, 4515, 4503, 4515, 4512, 4515, 4522, 4568, 4559, 4568, 4511, 4568, 4502, 4571, 4555, 4571, 
		4514, 4571, 4499, 4554, 4567, 4554, 4501, 4554, 4513, 4551, 4570, 4551, 4498, 4551, 4517, 4547, 
		4562, 4547, 4508, 4547, 4520, 4565, 4546, 4565, 4519, 4565, 4505, 4558, 4540, 4558, 4524, 4558, 
		4510, 4539, 4564, 4539, 4504, 4539, 4523, 4536, 4550, 4536, 4516, 4536, 4527, 4532, 4544, 4532, 
		4549, 4532, 4535, 4545, 4531, 4545, 4534, 4545, 4561, 4538, 4557, 4538, 4543, 4538, 4530, 4563, 
		4537, 4563, 4531, 4563, 4545, 4542, 4553, 4542, 4569, 4542, 4548, 4556, 4566, 4556, 4552, 4556, 
		4541, 4561, 4534, 4561, 4577, 4561, 4574, 4533, 4526, 4533, 4580, 4533, 4576, 4528, 4509, 4528, 
		4583, 4528, 4579, 4507, 4560, 4507, 4573, 4507, 4582, 4572, 4575, 4572, 4578, 4572, 4581, 4604, 
		4608, 4604, 4615, 4604, 4614, 4614, 4615, 4614, 4607, 4614, 4595, 4608, 4598, 4608, 4611, 4608, 
		4615, 4615, 4611, 4615, 4592, 4615, 4607, 4586, 4601, 4586, 4608, 4586, 4604, 4601, 4589, 4601, 
		4598, 4601, 4608, 4654, 4645, 4654, 4597, 4654, 4588, 4657, 4641, 4657, 4600, 4657, 4585, 4640, 
		4653, 4640, 4587, 4640, 4599, 4637, 4656, 4637, 4584, 4637, 4603, 4633, 4648, 4633, 4594, 4633, 
		4606, 4651, 4632, 4651, 4605, 4651, 4591, 4644, 4626, 4644, 4610, 4644, 4596, 4625, 4650, 4625, 
		4590, 4625, 4609, 4622, 4636, 4622, 4602, 4622, 4613, 4647, 4621, 4647, 4612, 4647, 4593, 4618, 
		4630, 4618, 4635, 4618, 4620, 4631, 4617, 4631, 4619, 4631, 4646, 4624, 4643, 4624, 4629, 4624, 
		4616, 4649, 4623, 4649, 4617, 4649, 4631, 4628, 4639, 4628, 4655, 4628, 4634, 4642, 4652, 4642, 
		4638, 4642, 4627, 4678, 4682, 4678, 4689, 4678, 4688, 4688, 4689, 4688, 4681, 4688, 4669, 4682, 
		4672, 4682, 4685, 4682, 4689, 4689, 4685, 4689, 4666, 4689, 4681, 4660, 4675, 4660, 4682, 4660, 
		4678, 4675, 4663, 4675, 4672, 4675, 4682, 4730, 4721, 4730, 4671, 4730, 4662, 4733, 4717, 4733, 
		4674, 4733, 4659, 4716, 4729, 4716, 4661, 4716, 4673, 4713, 4732, 4713, 4658, 4713, 4677, 4709, 
		4724, 4709, 4668, 4709, 4680, 4727, 4708, 4727, 4679, 4727, 4665, 4720, 4701, 4720, 4684, 4720, 
		4670, 4700, 4726, 4700, 4664, 4700, 4683, 4697, 4712, 4697, 4676, 4697, 4687, 4723, 4696, 4723, 
		4686, 4723, 4667, 4693, 4705, 4693, 4711, 4693, 4695, 4707, 4692, 4707, 4694, 4707, 4722, 4699, 
		4719, 4699, 4704, 4699, 4691, 4725, 4698, 4725, 4690, 4725, 4706, 4703, 4715, 4703, 4731, 4703, 
		4710, 4718, 4728, 4718, 4714, 4718, 4702, 4754, 4758, 4754, 4765, 4754, 4764, 4758, 4748, 4758, 
		4761, 4758, 4765, 4765, 4761, 4765, 4742, 4765, 4757, 4736, 4751, 4736, 4758, 4736, 4754, 4751, 
		4739, 4751, 4748, 4751, 4758, 4808, 4799, 4808, 4747, 4808, 4738, 4811, 4795, 4811, 4750, 4811, 
		4735, 4794, 4807, 4794, 4737, 4794, 4749, 4791, 4810, 4791, 4734, 4791, 4753, 4798, 4779, 4798, 
		4760, 4798, 4746, 4778, 4805, 4778, 4741, 4778, 4759, 4775, 4790, 4775, 4752, 4775, 4763, 4770, 
		4783, 4770, 4789, 4770, 4774, 4777, 4797, 4777, 4782, 4777, 4769, 4804, 4776, 4804, 4768, 4804, 
		4787, 4781, 4793, 4781, 4809, 4781, 4788, 4796, 4806, 4796, 4792, 4796, 4780, 4814, 4764, 4814, 
		4765, 4757, 4814, 4757, 4765, 4814, 4745, 4814, 4764, 4823, 4802, 4823, 4818, 4823, 4825, 4786, 
		4822, 4786, 4824, 4786, 4816, 4825, 4818, 4825, 4744, 4825, 4813, 4816, 4824, 4816, 4812, 4816, 
		4756, 4815, 4740, 4815, 4803, 4785, 4815, 4785, 4803, 4815, 4755, 4815, 4740, 4817, 4773, 4817, 
		4762, 4743, 4817, 4743, 4762, 4817, 4801, 4817, 4773, 4821, 4767, 4821, 4772, 4800, 4820, 4800, 
		4771, 4819, 4784, 4819, 4766, 4846, 4850, 4846, 4857, 4846, 4856, 4856, 4857, 4856, 4849, 4856, 
		4837, 4850, 4840, 4850, 4853, 4850, 4857, 4857, 4853, 4857, 4834, 4857, 4849, 4828, 4843, 4828, 
		4850, 4828, 4846, 4843, 4831, 4843, 4840, 4843, 4850, 4898, 4889, 4898, 4839, 4898, 4830, 4901, 
		4885, 4901, 4842, 4901, 4827, 4884, 4897, 4884, 4829, 4884, 4841, 4881, 4900, 4881, 4826, 4881, 
		4845, 4877, 4892, 4877, 4836, 4877, 4848, 4895, 4876, 4895, 4847, 4895, 4833, 4888, 4869, 4888, 
		4852, 4888, 4838, 4868, 4894, 4868, 4832, 4868, 4851, 4865, 4880, 4865, 4844, 4865, 4855, 4891, 
		4864, 4891, 4854, 4891, 4835, 4861, 4873, 4861, 4879, 4861, 4863, 4875, 4860, 4875, 4862, 4875, 
		4890, 4867, 4887, 4867, 4872, 4867, 4859, 4893, 4866, 4893, 4858, 4893, 4874, 4871, 4883, 4871, 
		4899, 4871, 4878, 4886, 4896, 4886, 4882, 4886, 4870, 4922, 4926, 4922, 4933, 4922, 4932, 4932, 
		4933, 4932, 4925, 4932, 4913, 4926, 4916, 4926, 4929, 4926, 4933, 4933, 4929, 4933, 4910, 4933, 
		4925, 4904, 4919, 4904, 4926, 4904, 4922, 4919, 4907, 4919, 4916, 4919, 4926, 4974, 4965, 4974, 
		4915, 4974, 4906, 4977, 4961, 4977, 4918, 4977, 4903, 4960, 4973, 4960, 4905, 4960, 4917, 4957, 
		4976, 4957, 4902, 4957, 4921, 4953, 4968, 4953, 4912, 4953, 4924, 4971, 4952, 4971, 4923, 4971, 
		4909, 4964, 4945, 4964, 4928, 4964, 4914, 4944, 4970, 4944, 4908, 4944, 4927, 4941, 4956, 4941, 
		4920, 4941, 4931, 4967, 4940, 4967, 4930, 4967, 4911, 4937, 4949, 4937, 4955, 4937, 4939, 4951, 
		4936, 4951, 4938, 4951, 4966, 4943, 4963, 4943, 4948, 4943, 4935, 4969, 4942, 4969, 4934, 4969, 
		4950, 4947, 4959, 4947, 4975, 4947, 4954, 4962, 4972, 4962, 4958, 4962, 4946, 4996, 5000, 4996, 
		5007, 4996, 5006, 5006, 5007, 5006, 4999, 5006, 4989, 5000, 4990, 5000, 5003, 5000, 5007, 5007, 
		5003, 5007, 4986, 5007, 4999, 4980, 4993, 4980, 5000, 4980, 4996, 4993, 4983, 4993, 4990, 4993, 
		5000, 5050, 5033, 5050, 4992, 5050, 4979, 5032, 5047, 5032, 4982, 5032, 4991, 5029, 5049, 5029, 
		4978, 5029, 4995, 5025, 5040, 5025, 4988, 5025, 4998, 5043, 5024, 5043, 4997, 5043, 4985, 5014, 
		5028, 5014, 4994, 5014, 5005, 5039, 5013, 5039, 5004, 5039, 4987, 5010, 5022, 5010, 5027, 5010, 
		5012, 5023, 5009, 5023, 5011, 5023, 5038, 5018, 5037, 5018, 5021, 5018, 5008, 5042, 5017, 5042, 
		5009, 5042, 5023, 5020, 5031, 5020, 5048, 5020, 5026, 5036, 5046, 5036, 5030, 5036, 5019, 5045, 
		5035, 5045, 5057, 5045, 5053, 4981, 5044, 4981, 5052, 4981, 5069, 4990, 4983, 4990, 5068, 4990, 
		5066, 5051, 5056, 5051, 5065, 5051, 5067, 5071, 5041, 5071, 4984, 5002, 5071, 5002, 4984, 5071, 
		5016, 5071, 5041, 5074, 5055, 5074, 5034, 5017, 5074, 5017, 5034, 5074, 5060, 5074, 5055, 5070, 
		5001, 5070, 5077, 5070, 5081, 5015, 5070, 5015, 5081, 5015, 5073, 5080, 5076, 5080, 5063, 5080, 
		5079, 5072, 5080, 5072, 5079, 5072, 5059, 5075, 4990, 5075, 5066, 5062, 5075, 5062, 5066, 5075, 
		5003, 5075, 4990, 5078, 5064, 5078, 5054, 5058, 5078, 5058, 5054, 5078, 5061, 5078, 5064, 5102, 
		5106, 5102, 5113, 5102, 5112, 5112, 5113, 5112, 5105, 5112, 5093, 5106, 5096, 5106, 5109, 5106, 
		5113, 5106, 5102, 5099, 5102, 5084, 5099, 5087, 5099, 5096, 5099, 5106, 5156, 5147, 5156, 5095, 
		5156, 5086, 5159, 5143, 5159, 5098, 5159, 5083, 5142, 5155, 5142, 5085, 5142, 5097, 5139, 5158, 
		5139, 5082, 5139, 5101, 5146, 5127, 5146, 5108, 5146, 5094, 5122, 5138, 5122, 5100, 5122, 5111, 
		5150, 5121, 5150, 5110, 5150, 5092, 5118, 5131, 5118, 5137, 5118, 5120, 5135, 5117, 5135, 5119, 
		5135, 5149, 5126, 5145, 5126, 5130, 5126, 5116, 5141, 5157, 5129, 5157, 5136, 5144, 5154, 5144, 
		5140, 5144, 5128, 5162, 5113, 5162, 5109, 5090, 5162, 5090, 5109, 5162, 5105, 5162, 5113, 5164, 
		5148, 5164, 5091, 5104, 5164, 5104, 5091, 5164, 5134, 5164, 5148, 5171, 5133, 5171, 5163, 5171, 
		5173, 5153, 5170, 5153, 5172, 5153, 5166, 5173, 5163, 5173, 5103, 5173, 5161, 5166, 5172, 5166, 
		5160, 5166, 5089, 5165, 5107, 5165, 5125, 5152, 5165, 5152, 5125, 5165, 5088, 5165, 5107, 5169, 
		5124, 5169, 5115, 5132, 5168, 5132, 5114, 5167, 5151, 5167, 5123, 5194, 5198, 5194, 5205, 5194, 
		5204, 5204, 5205, 5204, 5197, 5204, 5185, 5198, 5188, 5198, 5201, 5198, 5205, 5205, 5201, 5205, 
		5182, 5205, 5197, 5176, 5191, 5176, 5198, 5176, 5194, 5191, 5179, 5191, 5188, 5191, 5198, 5244, 
		5235, 5244, 5187, 5244, 5178, 5247, 5231, 5247, 5190, 5247, 5175, 5230, 5243, 5230, 5177, 5230, 
		5189, 5227, 5246, 5227, 5174, 5227, 5193, 5223, 5238, 5223, 5184, 5223, 5196, 5241, 5222, 5241, 
		5195, 5241, 5181, 5234, 5216, 5234, 5200, 5234, 5186, 5215, 5240, 5215, 5180, 5215, 5199, 5212, 
		5226, 5212, 5192, 5212, 5203, 5237, 5211, 5237, 5202, 5237, 5183, 5208, 5220, 5208, 5225, 5208, 
		5210, 5221, 5207, 5221, 5209, 5221, 5236, 5214, 5233, 5214, 5219, 5214, 5206, 5239, 5213, 5239, 
		5207, 5239, 5221, 5218, 5229, 5218, 5245, 5218, 5224, 5232, 5242, 5232, 5228, 5232, 5217, 5269, 
		5275, 5269, 5286, 5269, 5283, 5282, 5285, 5282, 5273, 5282, 5259, 5274, 5262, 5274, 5279, 5274, 
		5285, 5284, 5278, 5284, 5256, 5284, 5272, 5250, 5265, 5250, 5274, 5250, 5268, 5265, 5253, 5265, 
		5262, 5265, 5274, 5318, 5309, 5318, 5261, 5318, 5252, 5321, 5306, 5321, 5264, 5321, 5249, 5305, 
		5317, 5305, 5251, 5305, 5263, 5303, 5320, 5303, 5248, 5303, 5267, 5300, 5312, 5300, 5258, 5300, 
		5271, 5315, 5299, 5315, 5270, 5315, 5255, 5308, 5295, 5308, 5277, 5308, 5260, 5294, 5314, 5294, 
		5254, 5294, 5276, 5291, 5302, 5291, 5266, 5291, 5281, 5311, 5290, 5311, 5280, 5311, 5257, 5288, 
		5296, 5288, 5301, 5288, 5289, 5298, 5288, 5298, 5289, 5298, 5310, 5293, 5307, 5293, 5296, 5293, 
		5288, 5313, 5292, 5313, 5287, 5313, 5297, 5296, 5304, 5296, 5319, 5296, 5301, 5307, 5316, 5307, 
		5304, 5307, 5296, 5342, 5346, 5342, 5353, 5342, 5352, 5352, 5353, 5352, 5345, 5352, 5333, 5346, 
		5336, 5346, 5349, 5346, 5353, 5353, 5349, 5353, 5330, 5353, 5345, 5324, 5339, 5324, 5346, 5324, 
		5342, 5339, 5327, 5339, 5336, 5339, 5346, 5392, 5383, 5392, 5335, 5392, 5326, 5395, 5379, 5395, 
		5338, 5395, 5323, 5378, 5391, 5378, 5325, 5378, 5337, 5375, 5394, 5375, 5322, 5375, 5341, 5371, 
		5386, 5371, 5332, 5371, 5344, 5389, 5370, 5389, 5343, 5389, 5329, 5382, 5364, 5382, 5348, 5382, 
		5334, 5363, 5388, 5363, 5328, 5363, 5347, 5360, 5374, 5360, 5340, 5360, 5351, 5385, 5359, 5385, 
		5350, 5385, 5331, 5356, 5368, 5356, 5373, 5356, 5358, 5369, 5355, 5369, 5357, 5369, 5384, 5362, 
		5381, 5362, 5367, 5362, 5354, 5387, 5361, 5387, 5355, 5387, 5369, 5366, 5377, 5366, 5393, 5366, 
		5372, 5380, 5390, 5380, 5376, 5380, 5365, 5416, 5420, 5416, 5427, 5416, 5426, 5426, 5427, 5426, 
		5419, 5426, 5407, 5420, 5410, 5420, 5423, 5420, 5427, 5427, 5423, 5427, 5404, 5427, 5419, 5398, 
		5413, 5398, 5420, 5398, 5416, 5413, 5401, 5413, 5410, 5413, 5420, 5468, 5459, 5468, 5409, 5468, 
		5400, 5471, 5455, 5471, 5412, 5471, 5397, 5454, 5467, 5454, 5399, 5454, 5411, 5451, 5470, 5451, 
		5396, 5451, 5415, 5447, 5462, 5447, 5406, 5447, 5418, 5465, 5446, 5465, 5417, 5465, 5403, 5458, 
		5439, 5458, 5422, 5458, 5408, 5438, 5464, 5438, 5402, 5438, 5421, 5435, 5450, 5435, 5414, 5435, 
		5425, 5461, 5434, 5461, 5424, 5461, 5405, 5431, 5443, 5431, 5449, 5431, 5433, 5445, 5430, 5445, 
		5432, 5445, 5460, 5437, 5457, 5437, 5442, 5437, 5429, 5463, 5436, 5463, 5428, 5463, 5444, 5441, 
		5453, 5441, 5469, 5441, 5448, 5456, 5466, 5456, 5452, 5456, 5440, 5492, 5496, 5492, 5503, 5492, 
		5502, 5502, 5503, 5502, 5495, 5502, 5483, 5496, 5486, 5496, 5499, 5496, 5503, 5503, 5499, 5503, 
		5480, 5503, 5495, 5474, 5489, 5474, 5496, 5474, 5492, 5489, 5477, 5489, 5486, 5489, 5496, 5532, 
		5523, 5532, 5485, 5532, 5476, 5535, 5520, 5535, 5488, 5535, 5473, 5519, 5531, 5519, 5475, 5519, 
		5487, 5517, 5534, 5517, 5472, 5517, 5491, 5514, 5526, 5514, 5482, 5514, 5494, 5529, 5513, 5529, 
		5493, 5529, 5479, 5522, 5510, 5522, 5498, 5522, 5484, 5509, 5528, 5509, 5478, 5509, 5497, 5507, 
		5516, 5507, 5490, 5507, 5501, 5525, 5506, 5525, 5500, 5525, 5481, 5504, 5511, 5504, 5515, 5504, 
		5505, 5512, 5504, 5512, 5505, 5512, 5524, 5508, 5521, 5508, 5511, 5508, 5504, 5527, 5508, 5527, 
		5504, 5527, 5512, 5511, 5518, 5511, 5533, 5511, 5515, 5521, 5530, 5521, 5518, 5521, 5511, 5556, 
		5560, 5556, 5567, 5556, 5566, 5566, 5567, 5566, 5559, 5566, 5547, 5560, 5550, 5560, 5563, 5560, 
		5567, 5567, 5563, 5567, 5544, 5567, 5559, 5538, 5553, 5538, 5560, 5538, 5556, 5553, 5541, 5553, 
		5550, 5553, 5560, 5608, 5599, 5608, 5549, 5608, 5540, 5611, 5595, 5611, 5552, 5611, 5537, 5594, 
		5607, 5594, 5539, 5594, 5551, 5591, 5610, 5591, 5536, 5591, 5555, 5587, 5602, 5587, 5546, 5587, 
		5558, 5605, 5586, 5605, 5557, 5605, 5543, 5598, 5579, 5598, 5562, 5598, 5548, 5578, 5604, 5578, 
		5542, 5578, 5561, 5575, 5590, 5575, 5554, 5575, 5565, 5601, 5574, 5601, 5564, 5601, 5545, 5571, 
		5583, 5571, 5589, 5571, 5573, 5585, 5570, 5585, 5572, 5585, 5600, 5577, 5597, 5577, 5582, 5577, 
		5569, 5603, 5576, 5603, 5568, 5603, 5584, 5581, 5593, 5581, 5609, 5581, 5588, 5596, 5606, 5596, 
		5592, 5596, 5580, 5632, 5636, 5632, 5643, 5632, 5642, 5642, 5643, 5642, 5635, 5642, 5623, 5636, 
		5626, 5636, 5639, 5636, 5643, 5643, 5639, 5643, 5620, 5643, 5635, 5614, 5629, 5614, 5636, 5614, 
		5632, 5687, 5671, 5687, 5628, 5687, 5613, 5666, 5686, 5666, 5612, 5666, 5631, 5662, 5678, 5662, 
		5622, 5662, 5634, 5681, 5661, 5681, 5633, 5681, 5619, 5654, 5680, 5654, 5618, 5654, 5638, 5650, 
		5665, 5650, 5630, 5650, 5641, 5677, 5649, 5677, 5640, 5677, 5621, 5646, 5659, 5646, 5664, 5646, 
		5648, 5660, 5645, 5660, 5647, 5660, 5676, 5653, 5675, 5653, 5658, 5653, 5644, 5679, 5652, 5679, 
		5645, 5679, 5660, 5657, 5670, 5657, 5685, 5657, 5663, 5690, 5636, 5690, 5629, 5617, 5690, 5617, 
		5629, 5690, 5626, 5690, 5636, 5699, 5674, 5699, 5694, 5699, 5701, 5684, 5698, 5684, 5700, 5684, 
		5692, 5701, 5694, 5701, 5625, 5701, 5689, 5692, 5700, 5692, 5688, 5692, 5616, 5691, 5627, 5691, 
		5669, 5683, 5691, 5683, 5669, 5691, 5615, 5691, 5627, 5693, 5651, 5693, 5637, 5624, 5693, 5624, 
		5637, 5693, 5673, 5693, 5651, 5697, 5668, 5697, 5656, 5672, 5696, 5672, 5655, 5695, 5682, 5695, 
		5667, 5722, 5726, 5722, 5733, 5722, 5732, 5732, 5733, 5732, 5725, 5732, 5713, 5726, 5716, 5726, 
		5729, 5726, 5733, 5733, 5729, 5733, 5710, 5733, 5725, 5704, 5719, 5704, 5726, 5704, 5722, 5719, 
		5707, 5719, 5716, 5719, 5726, 5772, 5763, 5772, 5715, 5772, 5706, 5775, 5759, 5775, 5718, 5775, 
		5703, 5758, 5771, 5758, 5705, 5758, 5717, 5755, 5774, 5755, 5702, 5755, 5721, 5751, 5766, 5751, 
		5712, 5751, 5724, 5769, 5750, 5769, 5723, 5769, 5709, 5762, 5744, 5762, 5728, 5762, 5714, 5743, 
		5768, 5743, 5708, 5743, 5727, 5740, 5754, 5740, 5720, 5740, 5731, 5765, 5739, 5765, 5730, 5765, 
		5711, 5736, 5748, 5736, 5753, 5736, 5738, 5749, 5735, 5749, 5737, 5749, 5764, 5742, 5761, 5742, 
		5747, 5742, 5734, 5767, 5741, 5767, 5735, 5767, 5749, 5746, 5757, 5746, 5773, 5746, 5752, 5760, 
		5770, 5760, 5756, 5760, 5745, 5796, 5800, 5796, 5807, 5796, 5806, 5806, 5807, 5806, 5799, 5806, 
		5787, 5800, 5790, 5800, 5803, 5800, 5807, 5807, 5803, 5807, 5784, 5807, 5799, 5827, 5843, 5827, 
		5786, 5827, 5798, 5846, 5826, 5846, 5797, 5846, 5783, 5818, 5845, 5818, 5782, 5818, 5802, 5842, 
		5814, 5842, 5805, 5842, 5785, 5810, 5824, 5810, 5831, 5810, 5813, 5825, 5809, 5825, 5812, 5825, 
		5841, 5817, 5840, 5817, 5823, 5817, 5808, 5844, 5816, 5844, 5809, 5844, 5825, 5855, 5793, 5855, 
		5800, 5796, 5855, 5796, 5800, 5855, 5778, 5855, 5793, 5857, 5836, 5857, 5792, 5777, 5857, 5777, 
		5792, 5857, 5852, 5857, 5836, 5864, 5851, 5864, 5856, 5864, 5866, 5830, 5863, 5830, 5865, 5830, 
		5859, 5866, 5856, 5866, 5776, 5866, 5854, 5859, 5865, 5859, 5853, 5859, 5795, 5858, 5804, 5858, 
		5811, 5829, 5858, 5829, 5811, 5858, 5794, 5858, 5804, 5862, 5822, 5862, 5835, 5850, 5861, 5850, 
		5834, 5860, 5828, 5860, 5821, 5869, 5800, 5869, 5793, 5781, 5869, 5781, 5793, 5869, 5790, 5869, 
		5800, 5878, 5839, 5878, 5873, 5878, 5880, 5849, 5877, 5849, 5879, 5849, 5871, 5880, 5873, 5880, 
		5789, 5880, 5868, 5871, 5879, 5871, 5867, 5871, 5780, 5870, 5791, 5870, 5833, 5848, 5870, 5848, 
		5833, 5870, 5779, 5870, 5791, 5872, 5815, 5872, 5801, 5788, 5872, 5788, 5801, 5872, 5838, 5872, 
		5815, 5876, 5832, 5876, 5820, 5837, 5875, 5837, 5819, 5874, 5847, 5874, 5834, 5901, 5905, 5901, 
		5912, 5901, 5911, 5911, 5912, 5911, 5904, 5911, 5892, 5905, 5895, 5905, 5908, 5905, 5912, 5912, 
		5908, 5912, 5889, 5912, 5904, 5883, 5898, 5883, 5905, 5883, 5901, 5898, 5886, 5898, 5895, 5898, 
		5905, 5953, 5944, 5953, 5894, 5953, 5885, 5956, 5940, 5956, 5897, 5956, 5882, 5939, 5952, 5939, 
		5884, 5939, 5896, 5936, 5955, 5936, 5881, 5936, 5900, 5932, 5947, 5932, 5891, 5932, 5903, 5950, 
		5931, 5950, 5902, 5950, 5888, 5943, 5924, 5943, 5907, 5943, 5893, 5923, 5949, 5923, 5887, 5923, 
		5906, 5920, 5935, 5920, 5899, 5920, 5910, 5946, 5919, 5946, 5909, 5946, 5890, 5916, 5928, 5916, 
		5934, 5916, 5918, 5930, 5915, 5930, 5917, 5930, 5945, 5922, 5942, 5922, 5927, 5922, 5914, 5948, 
		5921, 5948, 5913, 5948, 5929, 5926, 5938, 5926, 5954, 5926, 5933, 5941, 5951, 5941, 5937, 5941, 
		5925, 5977, 5981, 5977, 5988, 5977, 5987, 5987, 5988, 5987, 5980, 5987, 5968, 5981, 5971, 5981, 
		5984, 5981, 5988, 5988, 5984, 5988, 5965, 5988, 5980, 5959, 5974, 5959, 5981, 5959, 5977, 5974, 
		5962, 5974, 5971, 5974, 5981, 6027, 6018, 6027, 5970, 6027, 5961, 6030, 6014, 6030, 5973, 6030, 
		5958, 6013, 6026, 6013, 5960, 6013, 5972, 6010, 6029, 6010, 5957, 6010, 5976, 6006, 6021, 6006, 
		5967, 6006, 5979, 6024, 6005, 6024, 5978, 6024, 5964, 6017, 5999, 6017, 5983, 6017, 5969, 5998, 
		6023, 5998, 5963, 5998, 5982, 5995, 6009, 5995, 5975, 5995, 5986, 6020, 5994, 6020, 5985, 6020, 
		5966, 5991, 6003, 5991, 6008, 5991, 5993, 6004, 5990, 6004, 5992, 6004, 6019, 5997, 6016, 5997, 
		6002, 5997, 5989, 6022, 5996, 6022, 5990, 6022, 6004, 6001, 6012, 6001, 6028, 6001, 6007, 6015, 
		6025, 6015, 6011, 6015, 6000, 6051, 6055, 6051, 6062, 6051, 6061, 6061, 6062, 6061, 6054, 6061, 
		6042, 6055, 6045, 6055, 6058, 6055, 6062, 6062, 6058, 6062, 6039, 6062, 6054, 6033, 6048, 6033, 
		6055, 6033, 6051, 6048, 6036, 6048, 6045, 6048, 6055, 6103, 6093, 6103, 6044, 6103, 6035, 6106, 
		6089, 6106, 6047, 6106, 6032, 6084, 6105, 6084, 6031, 6084, 6050, 6080, 6096, 6080, 6041, 6080, 
		6053, 6099, 6079, 6099, 6052, 6099, 6038, 6092, 6073, 6092, 6057, 6092, 6043, 6072, 6098, 6072, 
		6037, 6072, 6056, 6069, 6083, 6069, 6049, 6069, 6060, 6095, 6068, 6095, 6059, 6095, 6040, 6065, 
		6077, 6065, 6082, 6065, 6067, 6078, 6064, 6078, 6066, 6078, 6094, 6071, 6091, 6071, 6076, 6071, 
		6063, 6097, 6070, 6097, 6064, 6097, 6078, 6075, 6088, 6075, 6104, 6075, 6081, 6090, 6102, 6090, 
		6087, 6090, 6074, 6121, 6086, 6121, 6101, 6109, 6121, 6109, 6101, 6121, 6112, 6121, 6086, 6123, 
		6100, 6123, 6034, 6118, 6123, 6118, 6034, 6123, 6108, 6123, 6100, 6126, 6036, 6126, 6048, 6115, 
		6126, 6115, 6048, 6126, 6117, 6126, 6036, 6128, 6046, 6128, 6085, 6111, 6128, 6111, 6085, 6128, 
		6114, 6128, 6046, 6120, 6107, 6120, 6122, 6120, 6130, 6110, 6119, 6110, 6129, 6110, 6127, 6130, 
		6122, 6130, 6116, 6130, 6125, 6127, 6129, 6127, 6124, 6127, 6113, 6152, 6157, 6152, 6166, 6152, 
		6164, 6163, 6165, 6163, 6155, 6163, 6142, 6156, 6145, 6156, 6160, 6156, 6165, 6165, 6160, 6165, 
		6139, 6165, 6155, 6133, 6148, 6133, 6156, 6133, 6151, 6148, 6136, 6148, 6145, 6148, 6156, 6195, 
		6186, 6195, 6144, 6195, 6135, 6198, 6183, 6198, 6147, 6198, 6132, 6182, 6194, 6182, 6134, 6182, 
		6146, 6180, 6197, 6180, 6131, 6180, 6150, 6177, 6189, 6177, 6141, 6177, 6154, 6192, 6176, 6192, 
		6153, 6192, 6138, 6185, 6173, 6185, 6159, 6185, 6143, 6172, 6191, 6172, 6137, 6172, 6158, 6170, 
		6179, 6170, 6149, 6170, 6162, 6188, 6169, 6188, 6161, 6188, 6140, 6167, 6174, 6167, 6178, 6167, 
		6168, 6175, 6167, 6175, 6168, 6175, 6187, 6171, 6184, 6171, 6174, 6171, 6167, 6190, 6171, 6190, 
		6167, 6190, 6175, 6174, 6181, 6174, 6196, 6174, 6178, 6184, 6193, 6184, 6181, 6184, 6174, 6220, 
		6225, 6220, 6234, 6220, 6232, 6231, 6233, 6231, 6223, 6231, 6210, 6224, 6213, 6224, 6228, 6224, 
		6233, 6233, 6228, 6233, 6207, 6233, 6223, 6201, 6216, 6201, 6224, 6201, 6219, 6216, 6204, 6216, 
		6213, 6216, 6224, 6275, 6266, 6275, 6212, 6275, 6203, 6278, 6262, 6278, 6215, 6278, 6200, 6261, 
		6274, 6261, 6202, 6261, 6214, 6258, 6277, 6258, 6199, 6258, 6218, 6254, 6269, 6254, 6209, 6254, 
		6222, 6272, 6253, 6272, 6221, 6272, 6206, 6265, 6246, 6265, 6227, 6265, 6211, 6245, 6271, 6245, 
		6205, 6245, 6226, 6242, 6257, 6242, 6217, 6242, 6230, 6268, 6241, 6268, 6229, 6268, 6208, 6238, 
		6250, 6238, 6256, 6238, 6240, 6252, 6237, 6252, 6239, 6252, 6267, 6244, 6264, 6244, 6249, 6244, 
		6236, 6270, 6243, 6270, 6235, 6270, 6251, 6248, 6260, 6248, 6276, 6248, 6255, 6263, 6273, 6263, 
		6259, 6263, 6247, 6299, 6304, 6299, 6313, 6299, 6311, 6311, 6313, 6311, 6303, 6311, 6290, 6304, 
		6293, 6304, 6308, 6304, 6313, 6304, 6299, 6296, 6299, 6281, 6296, 6284, 6296, 6293, 6296, 6304, 
		6355, 6346, 6355, 6292, 6355, 6283, 6358, 6342, 6358, 6295, 6358, 6280, 6341, 6354, 6341, 6282, 
		6341, 6294, 6338, 6357, 6338, 6279, 6338, 6298, 6345, 6326, 6345, 6307, 6345, 6291, 6321, 6337, 
		6321, 6297, 6321, 6310, 6349, 6320, 6349, 6309, 6349, 6289, 6317, 6330, 6317, 6336, 6317, 6319, 
		6334, 6316, 6334, 6318, 6334, 6348, 6325, 6344, 6325, 6329, 6325, 6315, 6340, 6356, 6328, 6356, 
		6335, 6343, 6353, 6343, 6339, 6343, 6327, 6363, 6313, 6363, 6308, 6287, 6362, 6287, 6306, 6361, 
		6302, 6361, 6312, 6365, 6347, 6365, 6288, 6301, 6365, 6301, 6288, 6365, 6333, 6365, 6347, 6372, 
		6332, 6372, 6364, 6372, 6374, 6352, 6371, 6352, 6373, 6352, 6367, 6374, 6364, 6374, 6300, 6374, 
		6360, 6367, 6373, 6367, 6359, 6367, 6286, 6366, 6305, 6366, 6324, 6351, 6366, 6351, 6324, 6366, 
		6285, 6366, 6305, 6370, 6323, 6370, 6316, 6331, 6369, 6331, 6314, 6368, 6350, 6368, 6322, 965, 
		976, 965, 952, 965, 956, 977, 967, 977, 948, 977, 953, 968, 985, 968, 945, 968, 
		949, 970, 982, 970, 942, 970, 938, 986, 971, 986, 939, 986, 946, 973, 980, 973, 
		960, 973, 934, 983, 974, 983, 935, 983, 943, 954, 950, 954, 930, 954, 957, 951, 
		947, 951, 940, 951, 931, 958, 932, 958, 936, 958, 961, 933, 941, 933, 944, 933, 
		937, 929, 923, 929, 920, 929, 926, 908, 929, 908, 926, 908, 905, 914, 917, 914, 
		923, 914, 929, 911, 914, 911, 929, 911, 908, 883, 892, 883, 927, 883, 921, 893, 
		886, 893, 906, 893, 928, 880, 895, 880, 924, 880, 918, 896, 884, 896, 922, 896, 
		925, 898, 881, 898, 919, 898, 915, 889, 899, 889, 916, 889, 912, 901, 890, 901, 
		913, 901, 909, 887, 902, 887, 910, 887, 907, 903, 904, 903, 900, 903, 891, 904, 
		897, 904, 882, 904, 900, 888, 894, 888, 904, 888, 903, 894, 885, 894, 897, 894, 
		904, 865, 874, 865, 862, 865, 855, 871, 865, 871, 855, 871, 856, 855, 862, 855, 
		877, 855, 859, 856, 855, 856, 859, 856, 868, 872, 857, 872, 848, 872, 852, 858, 
		869, 858, 845, 858, 849, 870, 860, 870, 841, 870, 846, 861, 878, 861, 838, 861, 
		842, 863, 875, 863, 835, 863, 832, 879, 864, 879, 833, 879, 839, 866, 873, 866, 
		853, 866, 829, 876, 867, 876, 830, 876, 836, 847, 843, 847, 827, 847, 850, 844, 
		840, 844, 834, 844, 828, 851, 828, 851, 831, 851, 854, 828, 834, 828, 837, 828, 
		831, 813, 788, 813, 771, 800, 814, 800, 769, 809, 747, 809, 751, 799, 809, 799, 
		751, 811, 799, 811, 770, 789, 811, 789, 770, 810, 825, 810, 806, 810, 748, 826, 
		821, 826, 791, 826, 807, 798, 819, 798, 825, 798, 810, 820, 804, 820, 821, 820, 
		826, 822, 805, 822, 796, 792, 822, 792, 740, 822, 796, 822, 740, 812, 823, 812, 
		819, 812, 798, 824, 817, 824, 804, 824, 820, 790, 815, 790, 823, 790, 812, 816, 
		801, 816, 817, 816, 824, 818, 802, 818, 773, 805, 818, 805, 796, 818, 773, 818, 
		796, 808, 793, 808, 750, 749, 808, 749, 750, 775, 803, 775, 765, 803, 771, 803, 
		765, 799, 751, 799, 770, 797, 774, 797, 785, 741, 797, 741, 744, 797, 785, 797, 
		744, 794, 742, 794, 731, 795, 732, 795, 752, 776, 786, 776, 775, 776, 765, 782, 
		776, 782, 765, 782, 766, 766, 765, 766, 771, 766, 779, 783, 767, 783, 758, 783, 
		762, 768, 780, 768, 755, 768, 759, 781, 772, 781, 753, 781, 756, 777, 784, 777, 
		763, 777, 736, 787, 778, 787, 737, 787, 745, 757, 754, 757, 733, 757, 760, 761, 
		734, 761, 738, 761, 764, 735, 743, 735, 746, 735, 739, 726, 714, 726, 718, 706, 
		726, 706, 704, 726, 718, 726, 704, 722, 729, 722, 727, 722, 707, 730, 724, 730, 
		712, 730, 728, 669, 719, 669, 729, 669, 722, 720, 684, 720, 724, 720, 730, 725, 
		685, 725, 672, 713, 725, 713, 709, 725, 672, 725, 709, 723, 708, 723, 703, 670, 
		723, 670, 687, 723, 703, 723, 687, 721, 671, 721, 689, 686, 721, 686, 693, 721, 
		689, 721, 693, 710, 715, 714, 715, 718, 697, 718, 697, 715, 697, 694, 700, 704, 
		700, 718, 700, 697, 673, 681, 673, 716, 673, 711, 682, 675, 682, 695, 682, 717, 
		678, 688, 678, 705, 678, 701, 690, 679, 690, 702, 690, 698, 676, 691, 676, 699, 
		676, 696, 692, 693, 692, 689, 692, 680, 677, 683, 677, 693, 677, 692, 683, 674, 
		693, 674, 686, 654, 663, 654, 651, 654, 644, 660, 654, 660, 644, 660, 645, 644, 
		651, 644, 666, 644, 648, 645, 644, 645, 648, 645, 657, 661, 646, 661, 637, 661, 
		641, 647, 658, 647, 634, 647, 638, 659, 649, 659, 630, 659, 635, 650, 667, 650, 
		627, 650, 631, 652, 664, 652, 624, 652, 620, 668, 653, 668, 621, 668, 628, 655, 
		662, 655, 642, 655, 616, 665, 656, 665, 617, 665, 625, 636, 632, 636, 612, 636, 
		639, 633, 629, 633, 622, 633, 613, 640, 614, 640, 618, 640, 643, 615, 623, 615, 
		626, 615, 619, 597, 606, 587, 606, 594, 603, 597, 603, 587, 603, 588, 587, 594, 
		587, 609, 587, 591, 588, 587, 588, 591, 588, 600, 604, 589, 604, 581, 604, 584, 
		590, 601, 590, 578, 590, 582, 602, 592, 602, 575, 602, 579, 593, 610, 593, 572, 
		593, 576, 595, 607, 595, 569, 595, 566, 611, 596, 611, 567, 611, 573, 598, 605, 
		598, 585, 598, 563, 608, 599, 608, 564, 608, 570, 580, 577, 580, 562, 580, 583, 
		577, 574, 577, 568, 577, 562, 583, 562, 583, 565, 583, 586, 571, 565, 568, 565, 
		562, 537, 497, 537, 523, 480, 537, 480, 523, 535, 546, 535, 440, 488, 558, 488, 
		534, 546, 535, 546, 559, 559, 526, 559, 546, 561, 548, 561, 526, 498, 540, 498, 
		560, 548, 561, 548, 541, 541, 493, 541, 548, 544, 558, 544, 488, 498, 560, 498, 
		544, 558, 544, 558, 560, 561, 526, 561, 559, 541, 550, 541, 493, 498, 554, 498, 
		540, 550, 541, 550, 555, 555, 528, 555, 550, 557, 552, 557, 528, 495, 538, 495, 
		556, 552, 557, 552, 539, 539, 481, 539, 552, 542, 554, 542, 498, 495, 556, 495, 
		542, 554, 542, 554, 556, 557, 528, 557, 555, 553, 482, 553, 525, 529, 553, 529, 
		525, 551, 529, 551, 531, 494, 551, 494, 531, 549, 494, 549, 533, 527, 549, 527, 
		533, 547, 527, 547, 519, 441, 547, 441, 519, 536, 442, 536, 520, 489, 536, 489, 
		520, 545, 490, 545, 510, 499, 545, 499, 510, 543, 499, 543, 512, 496, 543, 496, 
		512, 473, 523, 473, 497, 471, 530, 471, 524, 529, 525, 529, 531, 431, 518, 431, 
		532, 527, 533, 527, 519, 521, 530, 521, 471, 431, 532, 431, 521, 530, 521, 530, 
		532, 533, 494, 533, 531, 520, 432, 520, 489, 522, 472, 522, 477, 433, 522, 433, 
		458, 522, 477, 522, 458, 510, 486, 510, 499, 436, 510, 436, 490, 512, 468, 512, 
		496, 486, 512, 486, 499, 501, 511, 501, 437, 443, 514, 443, 500, 511, 501, 511, 
		515, 515, 487, 515, 511, 517, 513, 517, 487, 483, 507, 483, 516, 513, 517, 513, 
		508, 508, 469, 508, 513, 505, 514, 505, 443, 483, 516, 483, 505, 514, 505, 514, 
		516, 517, 487, 517, 515, 509, 484, 509, 466, 470, 509, 470, 461, 509, 466, 509, 
		461, 506, 444, 506, 446, 485, 506, 485, 465, 506, 446, 506, 465, 502, 438, 502, 
		425, 445, 503, 445, 447, 504, 426, 504, 448, 497, 470, 497, 461, 497, 461, 497, 
		473, 439, 491, 439, 427, 492, 434, 492, 428, 478, 473, 478, 461, 478, 462, 462, 
		461, 462, 466, 462, 474, 479, 463, 479, 454, 479, 459, 464, 475, 464, 451, 464, 
		455, 476, 467, 476, 449, 476, 452, 453, 450, 453, 429, 453, 456, 457, 430, 457, 
		435, 457, 460, 419, 416, 419, 413, 419, 410, 417, 422, 417, 407, 417, 414, 354, 
		361, 354, 418, 354, 420, 361, 345, 361, 423, 361, 418, 382, 352, 382, 421, 382, 
		411, 343, 391, 343, 408, 343, 424, 392, 372, 392, 415, 392, 409, 372, 384, 372, 
		412, 372, 415, 400, 371, 400, 366, 385, 400, 385, 378, 400, 366, 400, 378, 403, 
		386, 403, 379, 349, 403, 349, 355, 403, 379, 403, 355, 398, 362, 398, 353, 369, 
		398, 369, 383, 398, 353, 398, 383, 404, 405, 404, 401, 404, 387, 406, 399, 406, 
		370, 406, 402, 350, 395, 350, 405, 350, 404, 396, 363, 396, 399, 396, 406, 397, 
		351, 397, 357, 364, 397, 364, 365, 397, 357, 397, 365, 372, 366, 372, 371, 372, 
		384, 393, 374, 393, 367, 393, 373, 375, 388, 375, 380, 375, 368, 3892, 3888, 3892, 
		3983, 3892, 3982, 3890, 3885, 3890, 3884, 3890, 3886, 3893, 3891, 3893, 3887, 3893, 3889, 3826, 
		3822, 3826, 3821, 3826, 3823, 3828, 3827, 3828, 3824, 3828, 3825, 3768, 3764, 3768, 3763, 3768, 
		3765, 3770, 3769, 3770, 3766, 3770, 3767, 3690, 3593, 3690, 3628, 3690, 3704, 3692, 3690, 3692, 
		3704, 3692, 3705, 3610, 3692, 3610, 3705, 3610, 3648, 3704, 3628, 3704, 3626, 3704, 3702, 3705, 
		3704, 3705, 3702, 3705, 3703, 3648, 3705, 3648, 3703, 3648, 3651, 3702, 3626, 3702, 3590, 3702, 
		3694, 3703, 3702, 3703, 3694, 3703, 3696, 3651, 3703, 3651, 3696, 3651, 3614, 3701, 3636, 3701, 
		3606, 3701, 3688, 3700, 3701, 3700, 3688, 3700, 3686, 3686, 3578, 3686, 3618, 3686, 3700, 3700, 
		3618, 3700, 3620, 3700, 3698, 3701, 3700, 3701, 3698, 3701, 3699, 3636, 3701, 3636, 3699, 3636, 
		3639, 3698, 3620, 3698, 3581, 3698, 3682, 3699, 3698, 3699, 3682, 3699, 3684, 3639, 3699, 3639, 
		3684, 3639, 3602, 3689, 3607, 3689, 3615, 3689, 3697, 3687, 3689, 3687, 3697, 3687, 3695, 3579, 
		3687, 3579, 3695, 3579, 3591, 3693, 3611, 3693, 3603, 3693, 3685, 3691, 3693, 3691, 3685, 3691, 
		3683, 3668, 3612, 3668, 3654, 3668, 3681, 3666, 3668, 3666, 3681, 3666, 3680, 3596, 3666, 3596, 
		3680, 3596, 3630, 3681, 3654, 3681, 3657, 3681, 3679, 3680, 3681, 3680, 3679, 3680, 3678, 3630, 
		3680, 3630, 3678, 3630, 3632, 3679, 3657, 3679, 3616, 3679, 3672, 3678, 3679, 3678, 3672, 3678, 
		3670, 3632, 3678, 3632, 3670, 3632, 3599, 3664, 3608, 3664, 3642, 3664, 3677, 3662, 3664, 3662, 
		3677, 3662, 3676, 3587, 3662, 3587, 3676, 3587, 3624, 3677, 3642, 3677, 3645, 3677, 3675, 3676, 
		3677, 3676, 3675, 3676, 3674, 3624, 3676, 3624, 3674, 3624, 3622, 3675, 3645, 3675, 3604, 3675, 
		3660, 3674, 3675, 3674, 3660, 3674, 3658, 3622, 3674, 3622, 3658, 3622, 3584, 3663, 3588, 3663, 
		3600, 3663, 3671, 3665, 3663, 3665, 3671, 3665, 3673, 3609, 3665, 3609, 3673, 3609, 3617, 3667, 
		3597, 3667, 3585, 3667, 3659, 3669, 3667, 3669, 3659, 3669, 3661, 3613, 3669, 3613, 3661, 3613, 
		3605, 3616, 3657, 3616, 3651, 3616, 3614, 3642, 3608, 3642, 3606, 3642, 3636, 3604, 3645, 3604, 
		3639, 3604, 3602, 3633, 3601, 3633, 3589, 3633, 3625, 3631, 3633, 3631, 3625, 3631, 3623, 3598, 
		3631, 3598, 3623, 3598, 3586, 3629, 3595, 3629, 3583, 3629, 3621, 3627, 3629, 3627, 3621, 3627, 
		3619, 3619, 3580, 3619, 3592, 3619, 3627, 3607, 3609, 3607, 3617, 3607, 3615, 3611, 3613, 3611, 
		3605, 3611, 3603, 83, 87, 83, 3574, 83, 3576, 99, 3573, 99, 3577, 99, 3575, 99, 
		95, 99, 3572, 99, 3573, 113, 34, 113, 91, 113, 126, 111, 113, 111, 126, 111, 
		125, 17, 111, 17, 125, 17, 79, 126, 91, 126, 93, 126, 124, 125, 126, 125, 
		124, 125, 123, 79, 125, 79, 123, 79, 81, 124, 93, 124, 38, 124, 117, 123, 
		124, 123, 117, 123, 115, 81, 123, 81, 115, 81, 20, 109, 31, 109, 90, 109, 
		122, 107, 109, 107, 122, 107, 121, 7, 107, 7, 121, 7, 72, 122, 90, 122, 
		89, 122, 120, 121, 122, 121, 120, 121, 119, 72, 121, 72, 119, 72, 70, 120, 
		89, 120, 27, 120, 105, 119, 120, 119, 105, 119, 103, 70, 119, 70, 103, 70, 
		4, 118, 39, 118, 30, 118, 110, 116, 118, 116, 110, 116, 108, 21, 116, 21, 
		108, 21, 8, 112, 18, 112, 5, 112, 104, 114, 112, 114, 104, 114, 106, 35, 
		114, 35, 106, 35, 26, 97, 52, 97, 66, 97, 101, 45, 95, 45, 99, 45, 
		62, 87, 23, 87, 63, 87, 100, 14, 84, 14, 102, 14, 67, 92, 36, 92, 
		53, 92, 98, 94, 92, 94, 98, 94, 96, 40, 94, 40, 96, 40, 46, 90, 
		31, 90, 10, 90, 77, 89, 90, 89, 77, 89, 74, 74, 0, 74, 27, 74, 
		89, 78, 11, 78, 24, 78, 88, 75, 78, 75, 88, 75, 85, 1, 76, 1, 
		86, 1, 15, 82, 22, 82, 9, 82, 73, 80, 82, 80, 73, 80, 71, 19, 
		80, 19, 71, 19, 6, 68, 54, 68, 49, 68, 59, 47, 64, 47, 56, 47, 
		42, 2, 16, 2, 69, 2, 60, 25, 12, 25, 57, 25, 65, 28, 3, 28, 
		61, 28, 50, 13, 32, 13, 43, 13, 58, 37, 29, 37, 51, 37, 55, 3594, 
		3691, 3594, 3683, 3594, 3582, 33, 41, 33, 48, 33, 44, 3654, 3612, 3654, 3610, 3654, 
		3648, 3641, 3656, 3641, 3653, 3641, 3644, 3635, 3650, 3635, 3655, 3635, 3640, 3634, 3638, 3634, 
		3647, 3634, 3649, 3637, 3643, 3637, 3652, 3637, 3646, 3645, 3642, 3645, 3636, 3645, 3639, 10049, 
		10041, 10049, 10037, 10049, 10052, 9982, 9984, 9982, 10050, 9982, 10053, 9986, 9988, 9986, 10044, 9986, 
		10047, 9983, 10013, 9983, 10042, 9983, 10051, 10013, 10016, 10013, 10040, 10013, 10042, 10016, 9985, 10016, 
		10048, 10016, 10040, 10017, 9981, 10017, 10054, 10017, 10038, 10018, 10017, 10018, 10038, 10018, 10036, 9987, 
		10018, 9987, 10036, 9987, 10045, 10018, 9987, 10018, 10009, 10018, 10034, 9981, 10017, 9981, 10033, 9981, 
		10004, 10034, 10009, 10034, 9998, 10034, 10025, 10041, 10039, 10041, 10035, 10041, 10037, 10004, 10033, 10004, 
		10023, 10004, 9989, 10021, 9995, 10021, 10007, 10021, 10032, 10019, 10021, 10019, 10032, 10019, 10029, 9992, 
		10019, 9992, 10029, 9992, 10001, 10032, 10007, 10032, 9985, 10032, 10016, 10001, 10029, 10001, 10013, 10001, 
		9983, 10026, 9999, 10026, 9996, 10026, 10022, 10024, 10026, 10024, 10022, 10024, 10020, 9990, 10024, 9990, 
		10020, 9990, 9993, 10008, 9997, 10008, 10000, 10008, 10010, 9986, 10008, 9986, 10010, 9986, 9988, 10005, 
		9991, 10005, 9994, 10005, 10002, 9982, 10006, 9982, 10003, 9982, 9984, 10039, 10046, 10039, 10043, 10039, 
		10035, 10031, 10015, 10031, 10060, 10031, 10057, 10012, 10028, 10012, 10063, 10012, 10066, 10027, 10030, 10027, 
		10056, 10027, 10062, 10014, 10011, 10014, 10065, 10014, 10059, 10033, 10034, 10033, 10025, 10033, 10023, 10061, 
		10055, 10061, 10058, 10061, 10064
	};

	glEnableClientState(GL_NORMAL_ARRAY);
	glNormalPointer(GL_FLOAT, 0, NormalData);
	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, VertexData);


	// Material attributes for surface 'PAINTED_TRIM'
	fireplace_Material_Parameters(128.000f, 0.400000f, 0.400000f, 0.400000f, 0.400000f, 0.400000f, 0.400000f);

	fireplace_Texture_Map(0); // Disable last texture map output

	glDrawElements(GL_TRIANGLE_STRIP, 124, GL_UNSIGNED_INT, &Indices[0]);
	glDrawElements(GL_TRIANGLE_STRIP, 46, GL_UNSIGNED_INT, &Indices[124]);
	glDrawElements(GL_TRIANGLE_STRIP, 48, GL_UNSIGNED_INT, &Indices[170]);
	glDrawElements(GL_TRIANGLE_STRIP, 50, GL_UNSIGNED_INT, &Indices[218]);
	glDrawElements(GL_TRIANGLE_STRIP, 52, GL_UNSIGNED_INT, &Indices[268]);
	glDrawElements(GL_TRIANGLE_STRIP, 54, GL_UNSIGNED_INT, &Indices[320]);
	glDrawElements(GL_TRIANGLE_STRIP, 56, GL_UNSIGNED_INT, &Indices[374]);
	glDrawElements(GL_TRIANGLE_STRIP, 58, GL_UNSIGNED_INT, &Indices[430]);
	glDrawElements(GL_TRIANGLE_STRIP, 60, GL_UNSIGNED_INT, &Indices[488]);
	glDrawElements(GL_TRIANGLE_STRIP, 62, GL_UNSIGNED_INT, &Indices[548]);
	glDrawElements(GL_TRIANGLE_STRIP, 64, GL_UNSIGNED_INT, &Indices[610]);
	glDrawElements(GL_TRIANGLE_STRIP, 66, GL_UNSIGNED_INT, &Indices[674]);
	glDrawElements(GL_TRIANGLE_STRIP, 68, GL_UNSIGNED_INT, &Indices[740]);
	glDrawElements(GL_TRIANGLE_STRIP, 70, GL_UNSIGNED_INT, &Indices[808]);
	glDrawElements(GL_TRIANGLE_STRIP, 210, GL_UNSIGNED_INT, &Indices[878]);
	glDrawElements(GL_TRIANGLE_STRIP, 57, GL_UNSIGNED_INT, &Indices[1088]);
	glDrawElements(GL_TRIANGLE_STRIP, 51, GL_UNSIGNED_INT, &Indices[1145]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[1196]);
	glDrawElements(GL_TRIANGLE_STRIP, 44, GL_UNSIGNED_INT, &Indices[1199]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[1243]);
	glDrawElements(GL_TRIANGLE_STRIP, 36, GL_UNSIGNED_INT, &Indices[1246]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[1282]);
	glDrawElements(GL_TRIANGLE_STRIP, 28, GL_UNSIGNED_INT, &Indices[1285]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[1313]);
	glDrawElements(GL_TRIANGLE_STRIP, 20, GL_UNSIGNED_INT, &Indices[1316]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[1336]);
	glDrawElements(GL_TRIANGLE_STRIP, 12, GL_UNSIGNED_INT, &Indices[1339]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[1351]);
	glDrawElements(GL_TRIANGLE_STRIP, 398, GL_UNSIGNED_INT, &Indices[1354]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[1752]);
	glDrawElements(GL_TRIANGLE_STRIP, 438, GL_UNSIGNED_INT, &Indices[1755]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[2193]);
	glDrawElements(GL_TRIANGLE_STRIP, 422, GL_UNSIGNED_INT, &Indices[2196]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[2618]);
	glDrawElements(GL_TRIANGLE_STRIP, 406, GL_UNSIGNED_INT, &Indices[2621]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[3027]);
	glDrawElements(GL_TRIANGLE_STRIP, 390, GL_UNSIGNED_INT, &Indices[3030]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[3420]);
	glDrawElements(GL_TRIANGLE_STRIP, 374, GL_UNSIGNED_INT, &Indices[3423]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[3797]);
	glDrawElements(GL_TRIANGLE_STRIP, 358, GL_UNSIGNED_INT, &Indices[3800]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[4158]);
	glDrawElements(GL_TRIANGLE_STRIP, 342, GL_UNSIGNED_INT, &Indices[4161]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[4503]);
	glDrawElements(GL_TRIANGLE_STRIP, 326, GL_UNSIGNED_INT, &Indices[4506]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[4832]);
	glDrawElements(GL_TRIANGLE_STRIP, 310, GL_UNSIGNED_INT, &Indices[4835]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[5145]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5148]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5154]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5160]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5166]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5172]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5178]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5184]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5190]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5196]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5202]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5208]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5214]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5220]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5226]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5232]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5238]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5244]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5250]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5256]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5262]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5268]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5274]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5280]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5286]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5292]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5298]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5304]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5310]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5316]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5322]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5328]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5334]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5340]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5346]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5352]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5358]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5364]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5370]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5376]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5382]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5388]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5394]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5400]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5406]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5412]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5418]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5424]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5430]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5436]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5442]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5448]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5454]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5460]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5466]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5472]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5478]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5484]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5490]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5496]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5502]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5508]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5514]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5520]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5526]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5532]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5538]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5544]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5550]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5556]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5562]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5568]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5574]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5580]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5586]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5592]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5598]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5604]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5610]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5616]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5622]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5628]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5634]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5640]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5646]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5652]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5658]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5664]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5670]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5676]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5682]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5688]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5694]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5700]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5706]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5712]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5718]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5724]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5730]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5736]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5742]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5748]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5754]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5760]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5766]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5772]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5778]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5784]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5790]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5796]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5802]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5808]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5814]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5820]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5826]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5832]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5838]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5844]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5850]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5856]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5862]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5868]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5874]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5880]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5886]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5892]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5898]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5904]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5910]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5916]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5922]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5928]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5934]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5940]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5946]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5952]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5958]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5964]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5970]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5976]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5982]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5988]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[5994]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6000]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6006]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6012]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6018]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6024]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6030]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6036]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6042]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6048]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6054]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6060]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6066]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6072]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6078]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6084]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6090]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6096]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6102]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6108]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6114]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6120]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6126]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6132]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6138]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6144]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6150]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6156]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6162]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6168]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6174]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6180]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6186]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6192]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6198]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6204]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6210]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6216]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6222]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6228]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6234]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6240]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6246]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6252]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6258]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6264]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6270]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6276]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6282]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6288]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6294]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6300]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6306]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6312]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6318]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6324]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6330]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6336]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6342]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6348]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6354]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6360]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6366]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6372]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6378]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6384]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6390]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6396]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6402]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6408]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6414]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6420]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6426]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6432]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6438]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6444]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6450]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6456]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6462]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6468]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6474]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6480]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6486]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6492]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6498]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6504]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6510]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6516]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6522]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6528]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6534]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6540]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6546]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6552]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6558]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6564]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6570]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6576]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6582]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6588]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6594]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6600]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6606]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6612]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6618]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6624]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6630]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6636]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6642]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6648]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6654]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6660]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6666]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6672]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6678]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6684]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6690]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6696]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6702]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6708]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6714]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6720]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6726]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6732]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6738]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6744]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6750]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6756]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6762]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6768]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6774]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6780]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6786]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6792]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6798]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6804]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6810]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6816]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6822]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6828]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6834]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6840]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6846]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6852]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6858]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6864]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6870]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6876]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6882]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6888]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6894]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6900]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6906]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6912]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6918]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6924]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6930]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6936]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6942]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6948]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6954]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6960]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6966]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6972]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6978]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6984]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6990]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[6996]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7002]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7008]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7014]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7020]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7026]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7032]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7038]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7044]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7050]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7056]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7062]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7068]);
	glDrawElements(GL_TRIANGLE_STRIP, 294, GL_UNSIGNED_INT, &Indices[7074]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[7368]);
	glDrawElements(GL_TRIANGLE_STRIP, 278, GL_UNSIGNED_INT, &Indices[7371]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[7649]);
	glDrawElements(GL_TRIANGLE_STRIP, 262, GL_UNSIGNED_INT, &Indices[7652]);
	glDrawElements(GL_TRIANGLES, 3, GL_UNSIGNED_INT, &Indices[7914]);
	glDrawElements(GL_TRIANGLE_STRIP, 63, GL_UNSIGNED_INT, &Indices[7917]);

	// Material attributes for surface 'STONE'
	fireplace_Material_Parameters(96.0000f, 0.400000f, 0.400000f, 0.400000f, 0.400000f, 0.400000f, 0.400000f);

	// Set a new diffuse texture map
 //fireplace_Texture_Map(fp1texbind);
 fireplace_Texture_Map(0);

	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7980]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7986]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7992]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[7998]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8004]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8010]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8016]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8022]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8028]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8034]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8040]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8046]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8052]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8058]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8064]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8070]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8076]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8082]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8088]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8094]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8100]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8106]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8112]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8118]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8124]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8130]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8136]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8142]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8148]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8154]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8160]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8166]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8172]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8178]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8184]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8190]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8196]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8202]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8208]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8214]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8220]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8226]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8232]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8238]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8244]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8250]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8256]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8262]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8266]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8270]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8274]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8278]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8282]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8286]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8290]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8294]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8298]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8302]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8306]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8310]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8314]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8320]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8326]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8332]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8338]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8342]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8346]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8350]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8356]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8362]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8368]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8374]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8378]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8382]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8386]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8390]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8394]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8398]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8404]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8410]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8416]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8422]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8428]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8434]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8440]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8446]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8452]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8458]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8464]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8470]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8476]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8482]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8488]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8494]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8500]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8506]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8512]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8518]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8524]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8530]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8536]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8542]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8548]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8554]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8560]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8564]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8568]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8572]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8578]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8584]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8590]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8596]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8600]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8604]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8608]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8612]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8616]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8620]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8624]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8628]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8632]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8636]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8640]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8644]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8648]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8652]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8656]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8662]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8668]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8674]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8680]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8684]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8688]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8692]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8696]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8700]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8704]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8710]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8716]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8722]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8728]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8734]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8740]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8746]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8752]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8758]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8764]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8770]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8776]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8782]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8788]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8794]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8800]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8806]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8812]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8818]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[8824]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8829]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8835]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8841]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8847]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8853]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8859]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8865]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8871]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8877]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8883]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8889]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8895]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8901]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8907]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8913]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8919]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8925]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8931]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8937]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8941]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8945]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8949]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8953]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8957]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8961]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8965]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8969]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8973]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8979]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8985]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[8991]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[8997]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9001]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9005]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9009]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9015]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9021]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9027]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9033]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9039]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9045]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9051]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9057]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9063]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9067]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9071]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9075]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9079]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9083]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9087]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9093]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9099]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9105]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9111]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9115]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9119]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9123]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9127]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9131]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9135]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9141]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9147]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9153]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9159]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9165]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9171]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9177]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9183]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9189]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9195]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9201]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9207]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9213]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9219]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9225]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9231]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9237]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9243]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9249]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9255]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9261]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9267]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9273]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9279]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9285]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9291]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9297]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9301]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9305]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9309]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9313]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9317]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9321]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9325]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9329]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9333]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9339]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9345]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9351]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9357]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9361]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[9365]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9369]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9375]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9381]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9387]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9393]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9399]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9405]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9411]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9417]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9423]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9429]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9435]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9441]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9447]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9453]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9459]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9465]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9471]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9477]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9483]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9489]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9495]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9501]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9507]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9513]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9519]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9525]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9531]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9537]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9543]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9549]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9555]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9561]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9567]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9573]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9579]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9585]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9591]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9597]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9603]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9609]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9615]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9621]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9627]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9633]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9639]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9645]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9651]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9657]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9663]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9669]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9675]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9681]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9687]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9693]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9699]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9705]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9711]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9717]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9723]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9729]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9735]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9741]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9747]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9753]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9759]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9765]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9771]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9777]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9783]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9789]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9795]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9801]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9807]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9813]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9819]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9825]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9831]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9837]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9843]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9849]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9855]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9861]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9867]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9873]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9879]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9885]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9891]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9897]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9903]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9909]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9915]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9921]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9927]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9933]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9939]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9945]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9951]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9957]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9963]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9969]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9975]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9981]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9987]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9993]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[9999]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10005]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10011]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10017]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10023]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10029]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10035]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10041]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10047]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10053]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10059]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10065]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10071]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10077]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10083]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10089]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10095]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10101]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10107]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10113]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10119]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10125]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10131]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10137]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10143]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10149]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10155]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10161]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10167]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10173]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10179]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10185]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10191]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10197]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10203]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10209]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10215]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10221]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10227]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10233]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10239]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10245]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10251]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10257]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10263]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10269]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10275]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10281]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10287]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10293]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10299]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10305]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10311]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10317]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10323]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10329]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10335]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10341]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10347]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10353]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10359]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10365]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10371]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10377]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10383]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10389]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10395]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10401]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10407]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10413]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10419]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10425]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10431]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10437]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10443]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10449]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10455]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10461]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10466]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10472]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10478]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10484]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10490]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10496]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10502]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10508]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10514]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10520]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10526]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10532]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10538]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10544]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[10550]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10555]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10561]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10567]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10573]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10579]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10585]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10591]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10597]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10603]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10609]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10615]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10621]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10627]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10633]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10639]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10645]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10651]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10655]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10659]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10663]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10667]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10671]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10675]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10681]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10687]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10693]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10699]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10703]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10707]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10711]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10715]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10719]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10723]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10729]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10735]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10741]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10747]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10753]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10759]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10765]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10771]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10777]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10783]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10789]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10793]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10797]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10801]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10805]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10809]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10813]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10819]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10825]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10831]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10837]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10841]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10845]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10849]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10853]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[10857]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10861]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10867]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10873]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10879]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10885]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10891]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10897]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10903]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10909]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10915]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10921]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10927]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10933]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10939]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10945]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10951]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10957]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10963]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10969]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10975]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10981]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10987]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10993]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[10999]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11005]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11011]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11017]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11023]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11029]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11035]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11041]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11047]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11053]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11059]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11065]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11071]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11077]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11083]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11089]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11095]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11101]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11107]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11113]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11119]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11125]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11131]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11137]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11143]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11149]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11155]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11161]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11167]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11173]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11179]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11185]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11191]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11197]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11203]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11209]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11215]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11221]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11227]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11233]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11239]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11245]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11249]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11253]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11257]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11263]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11269]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11275]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11281]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11285]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11289]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11293]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11297]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11301]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11305]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11309]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11313]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11317]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11323]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11329]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11335]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11341]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11347]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11353]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11359]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11365]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11371]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11377]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11383]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11389]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11395]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11401]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11407]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11413]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11419]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11425]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11431]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11437]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11443]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11449]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11455]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11461]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11467]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11473]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11479]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11483]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11487]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11491]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11495]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11499]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11503]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11509]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11515]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11521]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11527]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11531]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11535]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11539]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11543]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11547]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11551]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11557]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11563]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11569]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11575]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11581]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11587]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11593]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11599]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11605]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11611]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11617]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11623]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11629]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11635]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11641]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11647]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11653]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11659]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11665]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11671]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11677]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11683]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11689]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11695]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11701]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11707]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11713]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11719]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11725]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11731]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11737]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11743]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11749]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11755]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11761]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11767]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11773]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11779]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11785]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11791]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11797]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11803]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11809]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11815]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11821]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11827]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11833]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11839]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11845]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11851]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11857]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11863]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11869]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11875]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11881]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11887]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11893]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11899]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11905]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11909]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11913]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11917]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11921]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11925]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11929]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11935]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11941]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11947]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11953]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11957]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11961]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11965]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11969]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[11973]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[11977]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11982]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11988]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[11994]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12000]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12006]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12012]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12018]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12024]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12030]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12036]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12042]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12048]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12054]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12060]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[12066]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12071]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12077]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12083]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12089]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12095]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12101]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12107]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12113]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12119]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12125]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12131]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12137]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12143]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12149]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12155]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12161]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12167]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12173]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12179]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12185]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12191]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12197]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12203]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12209]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12215]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12221]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12227]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12233]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12239]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12245]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12251]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12257]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[12263]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12268]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12274]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12280]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12286]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12292]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12298]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12304]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12310]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12316]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12322]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12328]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12334]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12340]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12346]);
	glDrawElements(GL_TRIANGLE_STRIP, 5, GL_UNSIGNED_INT, &Indices[12352]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12357]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12363]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12369]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12375]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12381]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12387]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12393]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12399]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12405]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12411]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12417]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12423]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12427]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12431]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12435]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12441]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12447]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12453]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12459]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12463]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12467]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12471]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12475]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12479]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12483]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12487]);
	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_INT, &Indices[12491]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12495]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12501]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12507]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12513]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12519]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12525]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12531]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12537]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12543]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12549]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12555]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12561]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12567]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12573]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12579]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12585]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12591]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12597]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12603]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12609]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12615]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12621]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12627]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12633]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12639]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12645]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12651]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12657]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12663]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12669]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12675]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12681]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12687]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12693]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12699]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12705]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12711]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12717]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12723]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12729]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12735]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12741]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12747]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12753]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12759]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12765]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12771]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12777]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12783]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12789]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12795]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12801]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12807]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12813]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12819]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12825]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12831]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12837]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12843]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12849]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12855]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12861]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12867]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12873]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12879]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12885]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12891]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12897]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12903]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12909]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12915]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12921]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12927]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12933]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12939]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12945]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12951]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12957]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12963]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12969]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12975]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12981]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12987]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12993]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[12999]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13005]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13011]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13017]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13023]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13029]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13035]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13041]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13047]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13053]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13059]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13065]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13071]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13077]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13083]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13089]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13095]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13101]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13107]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13113]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13119]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13125]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13131]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13137]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13143]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13149]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13155]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13161]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13167]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13173]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13179]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13185]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13191]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13197]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13203]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13209]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13215]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13221]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13227]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13233]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13239]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13245]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13251]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13257]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13263]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13269]);
	glDrawElements(GL_TRIANGLE_STRIP, 6, GL_UNSIGNED_INT, &Indices[13275]);