// { dg-do run { target c++11 } }
// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__" }
//
// Copyright (C) 2016-2021 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  hermite
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>

// Test data for n=0.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data001[201] =
{
  { 1.0000000000000000, 0, -10.000000000000000, 0.0 },
  { 1.0000000000000000, 0, -9.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, -9.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, -9.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, -9.5999999999999996, 0.0 },
  { 1.0000000000000000, 0, -9.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, -9.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, -9.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, -9.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, -9.0999999999999996, 0.0 },
  { 1.0000000000000000, 0, -9.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, -8.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, -8.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, -8.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, -8.5999999999999996, 0.0 },
  { 1.0000000000000000, 0, -8.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, -8.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, -8.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, -8.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, -8.0999999999999996, 0.0 },
  { 1.0000000000000000, 0, -8.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, -7.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, -7.7999999999999998, 0.0 },
  { 1.0000000000000000, 0, -7.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, -7.5999999999999996, 0.0 },
  { 1.0000000000000000, 0, -7.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, -7.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, -7.2999999999999998, 0.0 },
  { 1.0000000000000000, 0, -7.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, -7.0999999999999996, 0.0 },
  { 1.0000000000000000, 0, -7.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, -6.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, -6.7999999999999998, 0.0 },
  { 1.0000000000000000, 0, -6.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, -6.5999999999999996, 0.0 },
  { 1.0000000000000000, 0, -6.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, -6.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, -6.2999999999999998, 0.0 },
  { 1.0000000000000000, 0, -6.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, -6.0999999999999996, 0.0 },
  { 1.0000000000000000, 0, -6.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, -5.8999999999999995, 0.0 },
  { 1.0000000000000000, 0, -5.7999999999999998, 0.0 },
  { 1.0000000000000000, 0, -5.7000000000000002, 0.0 },
  { 1.0000000000000000, 0, -5.5999999999999996, 0.0 },
  { 1.0000000000000000, 0, -5.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, -5.3999999999999995, 0.0 },
  { 1.0000000000000000, 0, -5.2999999999999998, 0.0 },
  { 1.0000000000000000, 0, -5.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, -5.0999999999999996, 0.0 },
  { 1.0000000000000000, 0, -5.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, -4.8999999999999995, 0.0 },
  { 1.0000000000000000, 0, -4.7999999999999998, 0.0 },
  { 1.0000000000000000, 0, -4.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, -4.5999999999999996, 0.0 },
  { 1.0000000000000000, 0, -4.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, -4.3999999999999995, 0.0 },
  { 1.0000000000000000, 0, -4.2999999999999998, 0.0 },
  { 1.0000000000000000, 0, -4.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, -4.0999999999999996, 0.0 },
  { 1.0000000000000000, 0, -4.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, -3.8999999999999995, 0.0 },
  { 1.0000000000000000, 0, -3.7999999999999998, 0.0 },
  { 1.0000000000000000, 0, -3.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, -3.5999999999999996, 0.0 },
  { 1.0000000000000000, 0, -3.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, -3.3999999999999995, 0.0 },
  { 1.0000000000000000, 0, -3.2999999999999998, 0.0 },
  { 1.0000000000000000, 0, -3.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, -3.0999999999999996, 0.0 },
  { 1.0000000000000000, 0, -3.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, -2.8999999999999995, 0.0 },
  { 1.0000000000000000, 0, -2.7999999999999998, 0.0 },
  { 1.0000000000000000, 0, -2.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, -2.5999999999999996, 0.0 },
  { 1.0000000000000000, 0, -2.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, -2.3999999999999995, 0.0 },
  { 1.0000000000000000, 0, -2.2999999999999998, 0.0 },
  { 1.0000000000000000, 0, -2.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, -2.0999999999999996, 0.0 },
  { 1.0000000000000000, 0, -2.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, -1.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, -1.7999999999999989, 0.0 },
  { 1.0000000000000000, 0, -1.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, -1.5999999999999996, 0.0 },
  { 1.0000000000000000, 0, -1.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, -1.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, -1.2999999999999989, 0.0 },
  { 1.0000000000000000, 0, -1.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, -1.0999999999999996, 0.0 },
  { 1.0000000000000000, 0, -1.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, -0.90000000000000036, 0.0 },
  { 1.0000000000000000, 0, -0.79999999999999893, 0.0 },
  { 1.0000000000000000, 0, -0.69999999999999929, 0.0 },
  { 1.0000000000000000, 0, -0.59999999999999964, 0.0 },
  { 1.0000000000000000, 0, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0, -0.39999999999999858, 0.0 },
  { 1.0000000000000000, 0, -0.29999999999999893, 0.0 },
  { 1.0000000000000000, 0, -0.19999999999999929, 0.0 },
  { 1.0000000000000000, 0, -0.099999999999999645, 0.0 },
  { 1.0000000000000000, 0, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0.10000000000000142, 0.0 },
  { 1.0000000000000000, 0, 0.20000000000000107, 0.0 },
  { 1.0000000000000000, 0, 0.30000000000000071, 0.0 },
  { 1.0000000000000000, 0, 0.40000000000000036, 0.0 },
  { 1.0000000000000000, 0, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0.60000000000000142, 0.0 },
  { 1.0000000000000000, 0, 0.70000000000000107, 0.0 },
  { 1.0000000000000000, 0, 0.80000000000000071, 0.0 },
  { 1.0000000000000000, 0, 0.90000000000000036, 0.0 },
  { 1.0000000000000000, 0, 1.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1.1000000000000014, 0.0 },
  { 1.0000000000000000, 0, 1.2000000000000011, 0.0 },
  { 1.0000000000000000, 0, 1.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, 1.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, 1.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1.6000000000000014, 0.0 },
  { 1.0000000000000000, 0, 1.7000000000000011, 0.0 },
  { 1.0000000000000000, 0, 1.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, 1.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, 2.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2.1000000000000014, 0.0 },
  { 1.0000000000000000, 0, 2.2000000000000011, 0.0 },
  { 1.0000000000000000, 0, 2.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, 2.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, 2.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2.6000000000000014, 0.0 },
  { 1.0000000000000000, 0, 2.7000000000000011, 0.0 },
  { 1.0000000000000000, 0, 2.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, 2.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, 3.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 3.1000000000000014, 0.0 },
  { 1.0000000000000000, 0, 3.2000000000000011, 0.0 },
  { 1.0000000000000000, 0, 3.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, 3.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, 3.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, 3.6000000000000014, 0.0 },
  { 1.0000000000000000, 0, 3.7000000000000011, 0.0 },
  { 1.0000000000000000, 0, 3.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, 3.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, 4.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 4.1000000000000014, 0.0 },
  { 1.0000000000000000, 0, 4.2000000000000011, 0.0 },
  { 1.0000000000000000, 0, 4.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, 4.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, 4.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, 4.6000000000000014, 0.0 },
  { 1.0000000000000000, 0, 4.7000000000000011, 0.0 },
  { 1.0000000000000000, 0, 4.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, 4.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, 5.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5.1000000000000014, 0.0 },
  { 1.0000000000000000, 0, 5.2000000000000011, 0.0 },
  { 1.0000000000000000, 0, 5.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, 5.4000000000000004, 0.0 },
  { 1.0000000000000000, 0, 5.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5.6000000000000014, 0.0 },
  { 1.0000000000000000, 0, 5.7000000000000011, 0.0 },
  { 1.0000000000000000, 0, 5.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, 5.9000000000000004, 0.0 },
  { 1.0000000000000000, 0, 6.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 6.1000000000000014, 0.0 },
  { 1.0000000000000000, 0, 6.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, 6.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, 6.4000000000000021, 0.0 },
  { 1.0000000000000000, 0, 6.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, 6.6000000000000014, 0.0 },
  { 1.0000000000000000, 0, 6.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, 6.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, 6.9000000000000021, 0.0 },
  { 1.0000000000000000, 0, 7.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 7.1000000000000014, 0.0 },
  { 1.0000000000000000, 0, 7.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, 7.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, 7.4000000000000021, 0.0 },
  { 1.0000000000000000, 0, 7.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, 7.6000000000000014, 0.0 },
  { 1.0000000000000000, 0, 7.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, 7.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, 7.9000000000000021, 0.0 },
  { 1.0000000000000000, 0, 8.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 8.1000000000000014, 0.0 },
  { 1.0000000000000000, 0, 8.1999999999999993, 0.0 },
  { 1.0000000000000000, 0, 8.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, 8.4000000000000021, 0.0 },
  { 1.0000000000000000, 0, 8.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, 8.6000000000000014, 0.0 },
  { 1.0000000000000000, 0, 8.6999999999999993, 0.0 },
  { 1.0000000000000000, 0, 8.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, 8.9000000000000021, 0.0 },
  { 1.0000000000000000, 0, 9.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 9.1000000000000014, 0.0 },
  { 1.0000000000000000, 0, 9.2000000000000028, 0.0 },
  { 1.0000000000000000, 0, 9.3000000000000007, 0.0 },
  { 1.0000000000000000, 0, 9.4000000000000021, 0.0 },
  { 1.0000000000000000, 0, 9.5000000000000000, 0.0 },
  { 1.0000000000000000, 0, 9.6000000000000014, 0.0 },
  { 1.0000000000000000, 0, 9.7000000000000028, 0.0 },
  { 1.0000000000000000, 0, 9.8000000000000007, 0.0 },
  { 1.0000000000000000, 0, 9.9000000000000021, 0.0 },
  { 1.0000000000000000, 0, 10.000000000000000, 0.0 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for n=1.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data002[201] =
{
  { -20.000000000000000, 1, -10.000000000000000, 0.0 },
  { -19.800000000000001, 1, -9.9000000000000004, 0.0 },
  { -19.600000000000001, 1, -9.8000000000000007, 0.0 },
  { -19.399999999999999, 1, -9.6999999999999993, 0.0 },
  { -19.199999999999999, 1, -9.5999999999999996, 0.0 },
  { -19.000000000000000, 1, -9.5000000000000000, 0.0 },
  { -18.800000000000001, 1, -9.4000000000000004, 0.0 },
  { -18.600000000000001, 1, -9.3000000000000007, 0.0 },
  { -18.399999999999999, 1, -9.1999999999999993, 0.0 },
  { -18.199999999999999, 1, -9.0999999999999996, 0.0 },
  { -18.000000000000000, 1, -9.0000000000000000, 0.0 },
  { -17.800000000000001, 1, -8.9000000000000004, 0.0 },
  { -17.600000000000001, 1, -8.8000000000000007, 0.0 },
  { -17.399999999999999, 1, -8.6999999999999993, 0.0 },
  { -17.199999999999999, 1, -8.5999999999999996, 0.0 },
  { -17.000000000000000, 1, -8.5000000000000000, 0.0 },
  { -16.800000000000001, 1, -8.4000000000000004, 0.0 },
  { -16.600000000000001, 1, -8.3000000000000007, 0.0 },
  { -16.399999999999999, 1, -8.1999999999999993, 0.0 },
  { -16.199999999999999, 1, -8.0999999999999996, 0.0 },
  { -16.000000000000000, 1, -8.0000000000000000, 0.0 },
  { -15.800000000000001, 1, -7.9000000000000004, 0.0 },
  { -15.600000000000000, 1, -7.7999999999999998, 0.0 },
  { -15.399999999999999, 1, -7.6999999999999993, 0.0 },
  { -15.199999999999999, 1, -7.5999999999999996, 0.0 },
  { -15.000000000000000, 1, -7.5000000000000000, 0.0 },
  { -14.800000000000001, 1, -7.4000000000000004, 0.0 },
  { -14.600000000000000, 1, -7.2999999999999998, 0.0 },
  { -14.399999999999999, 1, -7.1999999999999993, 0.0 },
  { -14.199999999999999, 1, -7.0999999999999996, 0.0 },
  { -14.000000000000000, 1, -7.0000000000000000, 0.0 },
  { -13.800000000000001, 1, -6.9000000000000004, 0.0 },
  { -13.600000000000000, 1, -6.7999999999999998, 0.0 },
  { -13.399999999999999, 1, -6.6999999999999993, 0.0 },
  { -13.199999999999999, 1, -6.5999999999999996, 0.0 },
  { -13.000000000000000, 1, -6.5000000000000000, 0.0 },
  { -12.800000000000001, 1, -6.4000000000000004, 0.0 },
  { -12.600000000000000, 1, -6.2999999999999998, 0.0 },
  { -12.399999999999999, 1, -6.1999999999999993, 0.0 },
  { -12.199999999999999, 1, -6.0999999999999996, 0.0 },
  { -12.000000000000000, 1, -6.0000000000000000, 0.0 },
  { -11.799999999999999, 1, -5.8999999999999995, 0.0 },
  { -11.600000000000000, 1, -5.7999999999999998, 0.0 },
  { -11.400000000000000, 1, -5.7000000000000002, 0.0 },
  { -11.199999999999999, 1, -5.5999999999999996, 0.0 },
  { -11.000000000000000, 1, -5.5000000000000000, 0.0 },
  { -10.799999999999999, 1, -5.3999999999999995, 0.0 },
  { -10.600000000000000, 1, -5.2999999999999998, 0.0 },
  { -10.399999999999999, 1, -5.1999999999999993, 0.0 },
  { -10.199999999999999, 1, -5.0999999999999996, 0.0 },
  { -10.000000000000000, 1, -5.0000000000000000, 0.0 },
  { -9.7999999999999989, 1, -4.8999999999999995, 0.0 },
  { -9.5999999999999996, 1, -4.7999999999999998, 0.0 },
  { -9.3999999999999986, 1, -4.6999999999999993, 0.0 },
  { -9.1999999999999993, 1, -4.5999999999999996, 0.0 },
  { -9.0000000000000000, 1, -4.5000000000000000, 0.0 },
  { -8.7999999999999989, 1, -4.3999999999999995, 0.0 },
  { -8.5999999999999996, 1, -4.2999999999999998, 0.0 },
  { -8.3999999999999986, 1, -4.1999999999999993, 0.0 },
  { -8.1999999999999993, 1, -4.0999999999999996, 0.0 },
  { -8.0000000000000000, 1, -4.0000000000000000, 0.0 },
  { -7.7999999999999989, 1, -3.8999999999999995, 0.0 },
  { -7.5999999999999996, 1, -3.7999999999999998, 0.0 },
  { -7.3999999999999986, 1, -3.6999999999999993, 0.0 },
  { -7.1999999999999993, 1, -3.5999999999999996, 0.0 },
  { -7.0000000000000000, 1, -3.5000000000000000, 0.0 },
  { -6.7999999999999989, 1, -3.3999999999999995, 0.0 },
  { -6.5999999999999996, 1, -3.2999999999999998, 0.0 },
  { -6.3999999999999986, 1, -3.1999999999999993, 0.0 },
  { -6.1999999999999993, 1, -3.0999999999999996, 0.0 },
  { -6.0000000000000000, 1, -3.0000000000000000, 0.0 },
  { -5.7999999999999989, 1, -2.8999999999999995, 0.0 },
  { -5.5999999999999996, 1, -2.7999999999999998, 0.0 },
  { -5.3999999999999986, 1, -2.6999999999999993, 0.0 },
  { -5.1999999999999993, 1, -2.5999999999999996, 0.0 },
  { -5.0000000000000000, 1, -2.5000000000000000, 0.0 },
  { -4.7999999999999989, 1, -2.3999999999999995, 0.0 },
  { -4.5999999999999996, 1, -2.2999999999999998, 0.0 },
  { -4.3999999999999986, 1, -2.1999999999999993, 0.0 },
  { -4.1999999999999993, 1, -2.0999999999999996, 0.0 },
  { -4.0000000000000000, 1, -2.0000000000000000, 0.0 },
  { -3.8000000000000007, 1, -1.9000000000000004, 0.0 },
  { -3.5999999999999979, 1, -1.7999999999999989, 0.0 },
  { -3.3999999999999986, 1, -1.6999999999999993, 0.0 },
  { -3.1999999999999993, 1, -1.5999999999999996, 0.0 },
  { -3.0000000000000000, 1, -1.5000000000000000, 0.0 },
  { -2.8000000000000007, 1, -1.4000000000000004, 0.0 },
  { -2.5999999999999979, 1, -1.2999999999999989, 0.0 },
  { -2.3999999999999986, 1, -1.1999999999999993, 0.0 },
  { -2.1999999999999993, 1, -1.0999999999999996, 0.0 },
  { -2.0000000000000000, 1, -1.0000000000000000, 0.0 },
  { -1.8000000000000007, 1, -0.90000000000000036, 0.0 },
  { -1.5999999999999979, 1, -0.79999999999999893, 0.0 },
  { -1.3999999999999986, 1, -0.69999999999999929, 0.0 },
  { -1.1999999999999993, 1, -0.59999999999999964, 0.0 },
  { -1.0000000000000000, 1, -0.50000000000000000, 0.0 },
  { -0.79999999999999716, 1, -0.39999999999999858, 0.0 },
  { -0.59999999999999787, 1, -0.29999999999999893, 0.0 },
  { -0.39999999999999858, 1, -0.19999999999999929, 0.0 },
  { -0.19999999999999929, 1, -0.099999999999999645, 0.0 },
  { 0.0000000000000000, 1, 0.0000000000000000, 0.0 },
  { 0.20000000000000284, 1, 0.10000000000000142, 0.0 },
  { 0.40000000000000213, 1, 0.20000000000000107, 0.0 },
  { 0.60000000000000142, 1, 0.30000000000000071, 0.0 },
  { 0.80000000000000071, 1, 0.40000000000000036, 0.0 },
  { 1.0000000000000000, 1, 0.50000000000000000, 0.0 },
  { 1.2000000000000028, 1, 0.60000000000000142, 0.0 },
  { 1.4000000000000021, 1, 0.70000000000000107, 0.0 },
  { 1.6000000000000014, 1, 0.80000000000000071, 0.0 },
  { 1.8000000000000007, 1, 0.90000000000000036, 0.0 },
  { 2.0000000000000000, 1, 1.0000000000000000, 0.0 },
  { 2.2000000000000028, 1, 1.1000000000000014, 0.0 },
  { 2.4000000000000021, 1, 1.2000000000000011, 0.0 },
  { 2.6000000000000014, 1, 1.3000000000000007, 0.0 },
  { 2.8000000000000007, 1, 1.4000000000000004, 0.0 },
  { 3.0000000000000000, 1, 1.5000000000000000, 0.0 },
  { 3.2000000000000028, 1, 1.6000000000000014, 0.0 },
  { 3.4000000000000021, 1, 1.7000000000000011, 0.0 },
  { 3.6000000000000014, 1, 1.8000000000000007, 0.0 },
  { 3.8000000000000007, 1, 1.9000000000000004, 0.0 },
  { 4.0000000000000000, 1, 2.0000000000000000, 0.0 },
  { 4.2000000000000028, 1, 2.1000000000000014, 0.0 },
  { 4.4000000000000021, 1, 2.2000000000000011, 0.0 },
  { 4.6000000000000014, 1, 2.3000000000000007, 0.0 },
  { 4.8000000000000007, 1, 2.4000000000000004, 0.0 },
  { 5.0000000000000000, 1, 2.5000000000000000, 0.0 },
  { 5.2000000000000028, 1, 2.6000000000000014, 0.0 },
  { 5.4000000000000021, 1, 2.7000000000000011, 0.0 },
  { 5.6000000000000014, 1, 2.8000000000000007, 0.0 },
  { 5.8000000000000007, 1, 2.9000000000000004, 0.0 },
  { 6.0000000000000000, 1, 3.0000000000000000, 0.0 },
  { 6.2000000000000028, 1, 3.1000000000000014, 0.0 },
  { 6.4000000000000021, 1, 3.2000000000000011, 0.0 },
  { 6.6000000000000014, 1, 3.3000000000000007, 0.0 },
  { 6.8000000000000007, 1, 3.4000000000000004, 0.0 },
  { 7.0000000000000000, 1, 3.5000000000000000, 0.0 },
  { 7.2000000000000028, 1, 3.6000000000000014, 0.0 },
  { 7.4000000000000021, 1, 3.7000000000000011, 0.0 },
  { 7.6000000000000014, 1, 3.8000000000000007, 0.0 },
  { 7.8000000000000007, 1, 3.9000000000000004, 0.0 },
  { 8.0000000000000000, 1, 4.0000000000000000, 0.0 },
  { 8.2000000000000028, 1, 4.1000000000000014, 0.0 },
  { 8.4000000000000021, 1, 4.2000000000000011, 0.0 },
  { 8.6000000000000014, 1, 4.3000000000000007, 0.0 },
  { 8.8000000000000007, 1, 4.4000000000000004, 0.0 },
  { 9.0000000000000000, 1, 4.5000000000000000, 0.0 },
  { 9.2000000000000028, 1, 4.6000000000000014, 0.0 },
  { 9.4000000000000021, 1, 4.7000000000000011, 0.0 },
  { 9.6000000000000014, 1, 4.8000000000000007, 0.0 },
  { 9.8000000000000007, 1, 4.9000000000000004, 0.0 },
  { 10.000000000000000, 1, 5.0000000000000000, 0.0 },
  { 10.200000000000003, 1, 5.1000000000000014, 0.0 },
  { 10.400000000000002, 1, 5.2000000000000011, 0.0 },
  { 10.600000000000001, 1, 5.3000000000000007, 0.0 },
  { 10.800000000000001, 1, 5.4000000000000004, 0.0 },
  { 11.000000000000000, 1, 5.5000000000000000, 0.0 },
  { 11.200000000000003, 1, 5.6000000000000014, 0.0 },
  { 11.400000000000002, 1, 5.7000000000000011, 0.0 },
  { 11.600000000000001, 1, 5.8000000000000007, 0.0 },
  { 11.800000000000001, 1, 5.9000000000000004, 0.0 },
  { 12.000000000000000, 1, 6.0000000000000000, 0.0 },
  { 12.200000000000003, 1, 6.1000000000000014, 0.0 },
  { 12.399999999999999, 1, 6.1999999999999993, 0.0 },
  { 12.600000000000001, 1, 6.3000000000000007, 0.0 },
  { 12.800000000000004, 1, 6.4000000000000021, 0.0 },
  { 13.000000000000000, 1, 6.5000000000000000, 0.0 },
  { 13.200000000000003, 1, 6.6000000000000014, 0.0 },
  { 13.399999999999999, 1, 6.6999999999999993, 0.0 },
  { 13.600000000000001, 1, 6.8000000000000007, 0.0 },
  { 13.800000000000004, 1, 6.9000000000000021, 0.0 },
  { 14.000000000000000, 1, 7.0000000000000000, 0.0 },
  { 14.200000000000003, 1, 7.1000000000000014, 0.0 },
  { 14.399999999999999, 1, 7.1999999999999993, 0.0 },
  { 14.600000000000001, 1, 7.3000000000000007, 0.0 },
  { 14.800000000000004, 1, 7.4000000000000021, 0.0 },
  { 15.000000000000000, 1, 7.5000000000000000, 0.0 },
  { 15.200000000000003, 1, 7.6000000000000014, 0.0 },
  { 15.399999999999999, 1, 7.6999999999999993, 0.0 },
  { 15.600000000000001, 1, 7.8000000000000007, 0.0 },
  { 15.800000000000004, 1, 7.9000000000000021, 0.0 },
  { 16.000000000000000, 1, 8.0000000000000000, 0.0 },
  { 16.200000000000003, 1, 8.1000000000000014, 0.0 },
  { 16.399999999999999, 1, 8.1999999999999993, 0.0 },
  { 16.600000000000001, 1, 8.3000000000000007, 0.0 },
  { 16.800000000000004, 1, 8.4000000000000021, 0.0 },
  { 17.000000000000000, 1, 8.5000000000000000, 0.0 },
  { 17.200000000000003, 1, 8.6000000000000014, 0.0 },
  { 17.399999999999999, 1, 8.6999999999999993, 0.0 },
  { 17.600000000000001, 1, 8.8000000000000007, 0.0 },
  { 17.800000000000004, 1, 8.9000000000000021, 0.0 },
  { 18.000000000000000, 1, 9.0000000000000000, 0.0 },
  { 18.200000000000003, 1, 9.1000000000000014, 0.0 },
  { 18.400000000000006, 1, 9.2000000000000028, 0.0 },
  { 18.600000000000001, 1, 9.3000000000000007, 0.0 },
  { 18.800000000000004, 1, 9.4000000000000021, 0.0 },
  { 19.000000000000000, 1, 9.5000000000000000, 0.0 },
  { 19.200000000000003, 1, 9.6000000000000014, 0.0 },
  { 19.400000000000006, 1, 9.7000000000000028, 0.0 },
  { 19.600000000000001, 1, 9.8000000000000007, 0.0 },
  { 19.800000000000004, 1, 9.9000000000000021, 0.0 },
  { 20.000000000000000, 1, 10.000000000000000, 0.0 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for n=2.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data003[201] =
{
  { 398.00000000000000, 2, -10.000000000000000, 0.0 },
  { 390.04000000000002, 2, -9.9000000000000004, 0.0 },
  { 382.16000000000008, 2, -9.8000000000000007, 0.0 },
  { 374.35999999999996, 2, -9.6999999999999993, 0.0 },
  { 366.63999999999999, 2, -9.5999999999999996, 0.0 },
  { 359.00000000000000, 2, -9.5000000000000000, 0.0 },
  { 351.44000000000005, 2, -9.4000000000000004, 0.0 },
  { 343.96000000000004, 2, -9.3000000000000007, 0.0 },
  { 336.55999999999995, 2, -9.1999999999999993, 0.0 },
  { 329.23999999999995, 2, -9.0999999999999996, 0.0 },
  { 322.00000000000000, 2, -9.0000000000000000, 0.0 },
  { 314.84000000000003, 2, -8.9000000000000004, 0.0 },
  { 307.76000000000005, 2, -8.8000000000000007, 0.0 },
  { 300.75999999999993, 2, -8.6999999999999993, 0.0 },
  { 293.83999999999997, 2, -8.5999999999999996, 0.0 },
  { 287.00000000000000, 2, -8.5000000000000000, 0.0 },
  { 280.24000000000001, 2, -8.4000000000000004, 0.0 },
  { 273.56000000000006, 2, -8.3000000000000007, 0.0 },
  { 266.95999999999998, 2, -8.1999999999999993, 0.0 },
  { 260.44000000000000, 2, -8.0999999999999996, 0.0 },
  { 254.00000000000000, 2, -8.0000000000000000, 0.0 },
  { 247.64000000000001, 2, -7.9000000000000004, 0.0 },
  { 241.35999999999999, 2, -7.7999999999999998, 0.0 },
  { 235.15999999999997, 2, -7.6999999999999993, 0.0 },
  { 229.03999999999999, 2, -7.5999999999999996, 0.0 },
  { 223.00000000000000, 2, -7.5000000000000000, 0.0 },
  { 217.04000000000002, 2, -7.4000000000000004, 0.0 },
  { 211.16000000000000, 2, -7.2999999999999998, 0.0 },
  { 205.35999999999996, 2, -7.1999999999999993, 0.0 },
  { 199.63999999999999, 2, -7.0999999999999996, 0.0 },
  { 194.00000000000000, 2, -7.0000000000000000, 0.0 },
  { 188.44000000000003, 2, -6.9000000000000004, 0.0 },
  { 182.95999999999998, 2, -6.7999999999999998, 0.0 },
  { 177.55999999999997, 2, -6.6999999999999993, 0.0 },
  { 172.23999999999998, 2, -6.5999999999999996, 0.0 },
  { 167.00000000000000, 2, -6.5000000000000000, 0.0 },
  { 161.84000000000003, 2, -6.4000000000000004, 0.0 },
  { 156.75999999999999, 2, -6.2999999999999998, 0.0 },
  { 151.75999999999996, 2, -6.1999999999999993, 0.0 },
  { 146.83999999999997, 2, -6.0999999999999996, 0.0 },
  { 142.00000000000000, 2, -6.0000000000000000, 0.0 },
  { 137.23999999999998, 2, -5.8999999999999995, 0.0 },
  { 132.56000000000000, 2, -5.7999999999999998, 0.0 },
  { 127.96000000000001, 2, -5.7000000000000002, 0.0 },
  { 123.43999999999998, 2, -5.5999999999999996, 0.0 },
  { 119.00000000000000, 2, -5.5000000000000000, 0.0 },
  { 114.63999999999997, 2, -5.3999999999999995, 0.0 },
  { 110.36000000000000, 2, -5.2999999999999998, 0.0 },
  { 106.15999999999997, 2, -5.1999999999999993, 0.0 },
  { 102.03999999999999, 2, -5.0999999999999996, 0.0 },
  { 98.000000000000000, 2, -5.0000000000000000, 0.0 },
  { 94.039999999999978, 2, -4.8999999999999995, 0.0 },
  { 90.159999999999997, 2, -4.7999999999999998, 0.0 },
  { 86.359999999999971, 2, -4.6999999999999993, 0.0 },
  { 82.639999999999986, 2, -4.5999999999999996, 0.0 },
  { 79.000000000000000, 2, -4.5000000000000000, 0.0 },
  { 75.439999999999984, 2, -4.3999999999999995, 0.0 },
  { 71.959999999999994, 2, -4.2999999999999998, 0.0 },
  { 68.559999999999974, 2, -4.1999999999999993, 0.0 },
  { 65.239999999999995, 2, -4.0999999999999996, 0.0 },
  { 62.000000000000000, 2, -4.0000000000000000, 0.0 },
  { 58.839999999999982, 2, -3.8999999999999995, 0.0 },
  { 55.759999999999998, 2, -3.7999999999999998, 0.0 },
  { 52.759999999999977, 2, -3.6999999999999993, 0.0 },
  { 49.839999999999989, 2, -3.5999999999999996, 0.0 },
  { 47.000000000000000, 2, -3.5000000000000000, 0.0 },
  { 44.239999999999988, 2, -3.3999999999999995, 0.0 },
  { 41.559999999999995, 2, -3.2999999999999998, 0.0 },
  { 38.959999999999980, 2, -3.1999999999999993, 0.0 },
  { 36.439999999999991, 2, -3.0999999999999996, 0.0 },
  { 34.000000000000000, 2, -3.0000000000000000, 0.0 },
  { 31.639999999999986, 2, -2.8999999999999995, 0.0 },
  { 29.359999999999996, 2, -2.7999999999999998, 0.0 },
  { 27.159999999999986, 2, -2.6999999999999993, 0.0 },
  { 25.039999999999992, 2, -2.5999999999999996, 0.0 },
  { 23.000000000000000, 2, -2.5000000000000000, 0.0 },
  { 21.039999999999988, 2, -2.3999999999999995, 0.0 },
  { 19.159999999999997, 2, -2.2999999999999998, 0.0 },
  { 17.359999999999989, 2, -2.1999999999999993, 0.0 },
  { 15.639999999999993, 2, -2.0999999999999996, 0.0 },
  { 14.000000000000000, 2, -2.0000000000000000, 0.0 },
  { 12.440000000000005, 2, -1.9000000000000004, 0.0 },
  { 10.959999999999985, 2, -1.7999999999999989, 0.0 },
  { 9.5599999999999898, 2, -1.6999999999999993, 0.0 },
  { 8.2399999999999949, 2, -1.5999999999999996, 0.0 },
  { 7.0000000000000000, 2, -1.5000000000000000, 0.0 },
  { 5.8400000000000043, 2, -1.4000000000000004, 0.0 },
  { 4.7599999999999891, 2, -1.2999999999999989, 0.0 },
  { 3.7599999999999936, 2, -1.1999999999999993, 0.0 },
  { 2.8399999999999972, 2, -1.0999999999999996, 0.0 },
  { 2.0000000000000000, 2, -1.0000000000000000, 0.0 },
  { 1.2400000000000024, 2, -0.90000000000000036, 0.0 },
  { 0.55999999999999339, 2, -0.79999999999999893, 0.0 },
  { -0.040000000000004032, 2, -0.69999999999999929, 0.0 },
  { -0.56000000000000161, 2, -0.59999999999999964, 0.0 },
  { -1.0000000000000000, 2, -0.50000000000000000, 0.0 },
  { -1.3600000000000045, 2, -0.39999999999999858, 0.0 },
  { -1.6400000000000026, 2, -0.29999999999999893, 0.0 },
  { -1.8400000000000012, 2, -0.19999999999999929, 0.0 },
  { -1.9600000000000002, 2, -0.099999999999999645, 0.0 },
  { -2.0000000000000000, 2, 0.0000000000000000, 0.0 },
  { -1.9599999999999989, 2, 0.10000000000000142, 0.0 },
  { -1.8399999999999983, 2, 0.20000000000000107, 0.0 },
  { -1.6399999999999983, 2, 0.30000000000000071, 0.0 },
  { -1.3599999999999990, 2, 0.40000000000000036, 0.0 },
  { -1.0000000000000000, 2, 0.50000000000000000, 0.0 },
  { -0.55999999999999317, 2, 0.60000000000000142, 0.0 },
  { -0.039999999999994040, 2, 0.70000000000000107, 0.0 },
  { 0.56000000000000449, 2, 0.80000000000000071, 0.0 },
  { 1.2400000000000024, 2, 0.90000000000000036, 0.0 },
  { 2.0000000000000000, 2, 1.0000000000000000, 0.0 },
  { 2.8400000000000123, 2, 1.1000000000000014, 0.0 },
  { 3.7600000000000104, 2, 1.2000000000000011, 0.0 },
  { 4.7600000000000078, 2, 1.3000000000000007, 0.0 },
  { 5.8400000000000043, 2, 1.4000000000000004, 0.0 },
  { 7.0000000000000000, 2, 1.5000000000000000, 0.0 },
  { 8.2400000000000180, 2, 1.6000000000000014, 0.0 },
  { 9.5600000000000147, 2, 1.7000000000000011, 0.0 },
  { 10.960000000000010, 2, 1.8000000000000007, 0.0 },
  { 12.440000000000005, 2, 1.9000000000000004, 0.0 },
  { 14.000000000000000, 2, 2.0000000000000000, 0.0 },
  { 15.640000000000025, 2, 2.1000000000000014, 0.0 },
  { 17.360000000000017, 2, 2.2000000000000011, 0.0 },
  { 19.160000000000014, 2, 2.3000000000000007, 0.0 },
  { 21.040000000000006, 2, 2.4000000000000004, 0.0 },
  { 23.000000000000000, 2, 2.5000000000000000, 0.0 },
  { 25.040000000000031, 2, 2.6000000000000014, 0.0 },
  { 27.160000000000021, 2, 2.7000000000000011, 0.0 },
  { 29.360000000000017, 2, 2.8000000000000007, 0.0 },
  { 31.640000000000008, 2, 2.9000000000000004, 0.0 },
  { 34.000000000000000, 2, 3.0000000000000000, 0.0 },
  { 36.440000000000033, 2, 3.1000000000000014, 0.0 },
  { 38.960000000000029, 2, 3.2000000000000011, 0.0 },
  { 41.560000000000016, 2, 3.3000000000000007, 0.0 },
  { 44.240000000000009, 2, 3.4000000000000004, 0.0 },
  { 47.000000000000000, 2, 3.5000000000000000, 0.0 },
  { 49.840000000000039, 2, 3.6000000000000014, 0.0 },
  { 52.760000000000034, 2, 3.7000000000000011, 0.0 },
  { 55.760000000000019, 2, 3.8000000000000007, 0.0 },
  { 58.840000000000011, 2, 3.9000000000000004, 0.0 },
  { 62.000000000000000, 2, 4.0000000000000000, 0.0 },
  { 65.240000000000052, 2, 4.1000000000000014, 0.0 },
  { 68.560000000000031, 2, 4.2000000000000011, 0.0 },
  { 71.960000000000022, 2, 4.3000000000000007, 0.0 },
  { 75.440000000000012, 2, 4.4000000000000004, 0.0 },
  { 79.000000000000000, 2, 4.5000000000000000, 0.0 },
  { 82.640000000000057, 2, 4.6000000000000014, 0.0 },
  { 86.360000000000042, 2, 4.7000000000000011, 0.0 },
  { 90.160000000000025, 2, 4.8000000000000007, 0.0 },
  { 94.040000000000020, 2, 4.9000000000000004, 0.0 },
  { 98.000000000000000, 2, 5.0000000000000000, 0.0 },
  { 102.04000000000006, 2, 5.1000000000000014, 0.0 },
  { 106.16000000000004, 2, 5.2000000000000011, 0.0 },
  { 110.36000000000003, 2, 5.3000000000000007, 0.0 },
  { 114.64000000000001, 2, 5.4000000000000004, 0.0 },
  { 119.00000000000000, 2, 5.5000000000000000, 0.0 },
  { 123.44000000000007, 2, 5.6000000000000014, 0.0 },
  { 127.96000000000004, 2, 5.7000000000000011, 0.0 },
  { 132.56000000000003, 2, 5.8000000000000007, 0.0 },
  { 137.24000000000001, 2, 5.9000000000000004, 0.0 },
  { 142.00000000000000, 2, 6.0000000000000000, 0.0 },
  { 146.84000000000006, 2, 6.1000000000000014, 0.0 },
  { 151.75999999999996, 2, 6.1999999999999993, 0.0 },
  { 156.76000000000005, 2, 6.3000000000000007, 0.0 },
  { 161.84000000000012, 2, 6.4000000000000021, 0.0 },
  { 167.00000000000000, 2, 6.5000000000000000, 0.0 },
  { 172.24000000000007, 2, 6.6000000000000014, 0.0 },
  { 177.55999999999997, 2, 6.6999999999999993, 0.0 },
  { 182.96000000000004, 2, 6.8000000000000007, 0.0 },
  { 188.44000000000011, 2, 6.9000000000000021, 0.0 },
  { 194.00000000000000, 2, 7.0000000000000000, 0.0 },
  { 199.64000000000007, 2, 7.1000000000000014, 0.0 },
  { 205.35999999999996, 2, 7.1999999999999993, 0.0 },
  { 211.16000000000005, 2, 7.3000000000000007, 0.0 },
  { 217.04000000000013, 2, 7.4000000000000021, 0.0 },
  { 223.00000000000000, 2, 7.5000000000000000, 0.0 },
  { 229.04000000000008, 2, 7.6000000000000014, 0.0 },
  { 235.15999999999997, 2, 7.6999999999999993, 0.0 },
  { 241.36000000000004, 2, 7.8000000000000007, 0.0 },
  { 247.64000000000013, 2, 7.9000000000000021, 0.0 },
  { 254.00000000000000, 2, 8.0000000000000000, 0.0 },
  { 260.44000000000011, 2, 8.1000000000000014, 0.0 },
  { 266.95999999999998, 2, 8.1999999999999993, 0.0 },
  { 273.56000000000006, 2, 8.3000000000000007, 0.0 },
  { 280.24000000000012, 2, 8.4000000000000021, 0.0 },
  { 287.00000000000000, 2, 8.5000000000000000, 0.0 },
  { 293.84000000000009, 2, 8.6000000000000014, 0.0 },
  { 300.75999999999993, 2, 8.6999999999999993, 0.0 },
  { 307.76000000000005, 2, 8.8000000000000007, 0.0 },
  { 314.84000000000015, 2, 8.9000000000000021, 0.0 },
  { 322.00000000000000, 2, 9.0000000000000000, 0.0 },
  { 329.24000000000012, 2, 9.1000000000000014, 0.0 },
  { 336.56000000000023, 2, 9.2000000000000028, 0.0 },
  { 343.96000000000004, 2, 9.3000000000000007, 0.0 },
  { 351.44000000000017, 2, 9.4000000000000021, 0.0 },
  { 359.00000000000000, 2, 9.5000000000000000, 0.0 },
  { 366.64000000000010, 2, 9.6000000000000014, 0.0 },
  { 374.36000000000024, 2, 9.7000000000000028, 0.0 },
  { 382.16000000000008, 2, 9.8000000000000007, 0.0 },
  { 390.04000000000019, 2, 9.9000000000000021, 0.0 },
  { 398.00000000000000, 2, 10.000000000000000, 0.0 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for n=5.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data004[201] =
{
  { -3041200.0000000000, 5, -10.000000000000000, 0.0 },
  { -2889108.3196800007, 5, -9.9000000000000004, 0.0 },
  { -2743131.8297600015, 5, -9.8000000000000007, 0.0 },
  { -2603085.2022399991, 5, -9.6999999999999993, 0.0 },
  { -2468786.8723199992, 5, -9.5999999999999996, 0.0 },
  { -2340059.0000000000, 5, -9.5000000000000000, 0.0 },
  { -2216727.4316800009, 5, -9.4000000000000004, 0.0 },
  { -2098621.6617600010, 5, -9.3000000000000007, 0.0 },
  { -1985574.7942399993, 5, -9.1999999999999993, 0.0 },
  { -1877423.5043199996, 5, -9.0999999999999996, 0.0 },
  { -1774008.0000000000, 5, -9.0000000000000000, 0.0 },
  { -1675171.9836800008, 5, -8.9000000000000004, 0.0 },
  { -1580762.6137600006, 5, -8.8000000000000007, 0.0 },
  { -1490630.4662399990, 5, -8.6999999999999993, 0.0 },
  { -1404629.4963199999, 5, -8.5999999999999996, 0.0 },
  { -1322617.0000000000, 5, -8.5000000000000000, 0.0 },
  { -1244453.5756800002, 5, -8.4000000000000004, 0.0 },
  { -1170003.0857600006, 5, -8.3000000000000007, 0.0 },
  { -1099132.6182399995, 5, -8.1999999999999993, 0.0 },
  { -1031712.4483199996, 5, -8.0999999999999996, 0.0 },
  { -967616.00000000000, 5, -8.0000000000000000, 0.0 },
  { -906719.80768000009, 5, -7.9000000000000004, 0.0 },
  { -848903.47775999992, 5, -7.7999999999999998, 0.0 },
  { -794049.65023999964, 5, -7.6999999999999993, 0.0 },
  { -742043.96031999995, 5, -7.5999999999999996, 0.0 },
  { -692775.00000000000, 5, -7.5000000000000000, 0.0 },
  { -646134.27968000027, 5, -7.4000000000000004, 0.0 },
  { -602016.18975999986, 5, -7.2999999999999998, 0.0 },
  { -560317.96223999979, 5, -7.1999999999999993, 0.0 },
  { -520939.63231999992, 5, -7.0999999999999996, 0.0 },
  { -483784.00000000000, 5, -7.0000000000000000, 0.0 },
  { -448756.59168000019, 5, -6.9000000000000004, 0.0 },
  { -415765.62176000001, 5, -6.7999999999999998, 0.0 },
  { -384721.95423999976, 5, -6.6999999999999993, 0.0 },
  { -355539.06431999995, 5, -6.5999999999999996, 0.0 },
  { -328133.00000000000, 5, -6.5000000000000000, 0.0 },
  { -302422.34368000011, 5, -6.4000000000000004, 0.0 },
  { -278328.17375999998, 5, -6.2999999999999998, 0.0 },
  { -255774.02623999983, 5, -6.1999999999999993, 0.0 },
  { -234685.85631999990, 5, -6.0999999999999996, 0.0 },
  { -214992.00000000000, 5, -6.0000000000000000, 0.0 },
  { -196623.13567999989, 5, -5.8999999999999995, 0.0 },
  { -179512.24575999999, 5, -5.7999999999999998, 0.0 },
  { -163594.57824000003, 5, -5.7000000000000002, 0.0 },
  { -148807.60831999997, 5, -5.5999999999999996, 0.0 },
  { -135091.00000000000, 5, -5.5000000000000000, 0.0 },
  { -122386.56767999992, 5, -5.3999999999999995, 0.0 },
  { -110638.23776000000, 5, -5.2999999999999998, 0.0 },
  { -99792.010239999945, 5, -5.1999999999999993, 0.0 },
  { -89795.920319999976, 5, -5.0999999999999996, 0.0 },
  { -80600.000000000000, 5, -5.0000000000000000, 0.0 },
  { -72156.239679999941, 5, -4.8999999999999995, 0.0 },
  { -64418.549759999994, 5, -4.7999999999999998, 0.0 },
  { -57342.722239999952, 5, -4.6999999999999993, 0.0 },
  { -50886.392319999970, 5, -4.5999999999999996, 0.0 },
  { -45009.000000000000, 5, -4.5000000000000000, 0.0 },
  { -39671.751679999965, 5, -4.3999999999999995, 0.0 },
  { -34837.581759999986, 5, -4.2999999999999998, 0.0 },
  { -30471.114239999963, 5, -4.1999999999999993, 0.0 },
  { -26538.624319999992, 5, -4.0999999999999996, 0.0 },
  { -23008.000000000000, 5, -4.0000000000000000, 0.0 },
  { -19848.703679999981, 5, -3.8999999999999995, 0.0 },
  { -17031.733759999996, 5, -3.7999999999999998, 0.0 },
  { -14529.586239999979, 5, -3.6999999999999993, 0.0 },
  { -12316.216319999992, 5, -3.5999999999999996, 0.0 },
  { -10367.000000000000, 5, -3.5000000000000000, 0.0 },
  { -8658.6956799999934, 5, -3.3999999999999995, 0.0 },
  { -7169.4057599999960, 5, -3.2999999999999998, 0.0 },
  { -5878.5382399999908, 5, -3.1999999999999993, 0.0 },
  { -4766.7683199999965, 5, -3.0999999999999996, 0.0 },
  { -3816.0000000000000, 5, -3.0000000000000000, 0.0 },
  { -3009.3276799999958, 5, -2.8999999999999995, 0.0 },
  { -2330.9977599999988, 5, -2.7999999999999998, 0.0 },
  { -1766.3702399999963, 5, -2.6999999999999993, 0.0 },
  { -1301.8803199999984, 5, -2.5999999999999996, 0.0 },
  { -925.00000000000000, 5, -2.5000000000000000, 0.0 },
  { -624.19967999999858, 5, -2.3999999999999995, 0.0 },
  { -388.90975999999978, 5, -2.2999999999999998, 0.0 },
  { -209.48223999999891, 5, -2.1999999999999993, 0.0 },
  { -77.152319999999520, 5, -2.0999999999999996, 0.0 },
  { 16.000000000000000, 5, -2.0000000000000000, 0.0 },
  { 77.088319999999840, 5, -1.9000000000000004, 0.0 },
  { 112.45824000000026, 5, -1.7999999999999989, 0.0 },
  { 127.72576000000002, 5, -1.6999999999999993, 0.0 },
  { 127.81567999999996, 5, -1.5999999999999996, 0.0 },
  { 117.00000000000000, 5, -1.5000000000000000, 0.0 },
  { 98.936320000000080, 5, -1.4000000000000004, 0.0 },
  { 76.706239999999752, 5, -1.2999999999999989, 0.0 },
  { 52.853759999999838, 5, -1.1999999999999993, 0.0 },
  { 29.423679999999933, 5, -1.0999999999999996, 0.0 },
  { 8.0000000000000000, 5, -1.0000000000000000, 0.0 },
  { -10.255679999999948, 5, -0.90000000000000036, 0.0 },
  { -24.565760000000125, 5, -0.79999999999999893, 0.0 },
  { -34.498240000000052, 5, -0.69999999999999929, 0.0 },
  { -39.928320000000006, 5, -0.59999999999999964, 0.0 },
  { -41.000000000000000, 5, -0.50000000000000000, 0.0 },
  { -38.087679999999935, 5, -0.39999999999999858, 0.0 },
  { -31.757759999999919, 5, -0.29999999999999893, 0.0 },
  { -22.730239999999931, 5, -0.19999999999999929, 0.0 },
  { -11.840319999999959, 5, -0.099999999999999645, 0.0 },
  { 0.0000000000000000, 5, 0.0000000000000000, 0.0 },
  { 11.840320000000162, 5, 0.10000000000000142, 0.0 },
  { 22.730240000000109, 5, 0.20000000000000107, 0.0 },
  { 31.757760000000054, 5, 0.30000000000000071, 0.0 },
  { 38.087680000000020, 5, 0.40000000000000036, 0.0 },
  { 41.000000000000000, 5, 0.50000000000000000, 0.0 },
  { 39.928319999999957, 5, 0.60000000000000142, 0.0 },
  { 34.498239999999925, 5, 0.70000000000000107, 0.0 },
  { 24.565759999999916, 5, 0.80000000000000071, 0.0 },
  { 10.255679999999948, 5, 0.90000000000000036, 0.0 },
  { -8.0000000000000000, 5, 1.0000000000000000, 0.0 },
  { -29.423680000000317, 5, 1.1000000000000014, 0.0 },
  { -52.853760000000264, 5, 1.2000000000000011, 0.0 },
  { -76.706240000000179, 5, 1.3000000000000007, 0.0 },
  { -98.936320000000080, 5, 1.4000000000000004, 0.0 },
  { -117.00000000000000, 5, 1.5000000000000000, 0.0 },
  { -127.81568000000010, 5, 1.6000000000000014, 0.0 },
  { -127.72575999999992, 5, 1.7000000000000011, 0.0 },
  { -112.45823999999980, 5, 1.8000000000000007, 0.0 },
  { -77.088319999999840, 5, 1.9000000000000004, 0.0 },
  { -16.000000000000000, 5, 2.0000000000000000, 0.0 },
  { 77.152320000001623, 5, 2.1000000000000014, 0.0 },
  { 209.48224000000164, 5, 2.2000000000000011, 0.0 },
  { 388.90976000000148, 5, 2.3000000000000007, 0.0 },
  { 624.19968000000074, 5, 2.4000000000000004, 0.0 },
  { 925.00000000000000, 5, 2.5000000000000000, 0.0 },
  { 1301.8803200000059, 5, 2.6000000000000014, 0.0 },
  { 1766.3702400000057, 5, 2.7000000000000011, 0.0 },
  { 2330.9977600000047, 5, 2.8000000000000007, 0.0 },
  { 3009.3276800000026, 5, 2.9000000000000004, 0.0 },
  { 3816.0000000000000, 5, 3.0000000000000000, 0.0 },
  { 4766.7683200000147, 5, 3.1000000000000014, 0.0 },
  { 5878.5382400000126, 5, 3.2000000000000011, 0.0 },
  { 7169.4057600000087, 5, 3.3000000000000007, 0.0 },
  { 8658.6956800000080, 5, 3.4000000000000004, 0.0 },
  { 10367.000000000000, 5, 3.5000000000000000, 0.0 },
  { 12316.216320000027, 5, 3.6000000000000014, 0.0 },
  { 14529.586240000028, 5, 3.7000000000000011, 0.0 },
  { 17031.733760000021, 5, 3.8000000000000007, 0.0 },
  { 19848.703680000013, 5, 3.9000000000000004, 0.0 },
  { 23008.000000000000, 5, 4.0000000000000000, 0.0 },
  { 26538.624320000057, 5, 4.1000000000000014, 0.0 },
  { 30471.114240000043, 5, 4.2000000000000011, 0.0 },
  { 34837.581760000037, 5, 4.3000000000000007, 0.0 },
  { 39671.751680000008, 5, 4.4000000000000004, 0.0 },
  { 45009.000000000000, 5, 4.5000000000000000, 0.0 },
  { 50886.392320000086, 5, 4.6000000000000014, 0.0 },
  { 57342.722240000076, 5, 4.7000000000000011, 0.0 },
  { 64418.549760000053, 5, 4.8000000000000007, 0.0 },
  { 72156.239680000028, 5, 4.9000000000000004, 0.0 },
  { 80600.000000000000, 5, 5.0000000000000000, 0.0 },
  { 89795.920320000136, 5, 5.1000000000000014, 0.0 },
  { 99792.010240000105, 5, 5.2000000000000011, 0.0 },
  { 110638.23776000006, 5, 5.3000000000000007, 0.0 },
  { 122386.56768000004, 5, 5.4000000000000004, 0.0 },
  { 135091.00000000000, 5, 5.5000000000000000, 0.0 },
  { 148807.60832000020, 5, 5.6000000000000014, 0.0 },
  { 163594.57824000015, 5, 5.7000000000000011, 0.0 },
  { 179512.24576000011, 5, 5.8000000000000007, 0.0 },
  { 196623.13568000006, 5, 5.9000000000000004, 0.0 },
  { 214992.00000000000, 5, 6.0000000000000000, 0.0 },
  { 234685.85632000031, 5, 6.1000000000000014, 0.0 },
  { 255774.02623999983, 5, 6.1999999999999993, 0.0 },
  { 278328.17376000021, 5, 6.3000000000000007, 0.0 },
  { 302422.34368000063, 5, 6.4000000000000021, 0.0 },
  { 328133.00000000000, 5, 6.5000000000000000, 0.0 },
  { 355539.06432000035, 5, 6.6000000000000014, 0.0 },
  { 384721.95423999976, 5, 6.6999999999999993, 0.0 },
  { 415765.62176000018, 5, 6.8000000000000007, 0.0 },
  { 448756.59168000077, 5, 6.9000000000000021, 0.0 },
  { 483784.00000000000, 5, 7.0000000000000000, 0.0 },
  { 520939.63232000044, 5, 7.1000000000000014, 0.0 },
  { 560317.96223999979, 5, 7.1999999999999993, 0.0 },
  { 602016.18976000033, 5, 7.3000000000000007, 0.0 },
  { 646134.27968000097, 5, 7.4000000000000021, 0.0 },
  { 692775.00000000000, 5, 7.5000000000000000, 0.0 },
  { 742043.96032000054, 5, 7.6000000000000014, 0.0 },
  { 794049.65023999964, 5, 7.6999999999999993, 0.0 },
  { 848903.47776000027, 5, 7.8000000000000007, 0.0 },
  { 906719.80768000125, 5, 7.9000000000000021, 0.0 },
  { 967616.00000000000, 5, 8.0000000000000000, 0.0 },
  { 1031712.4483200011, 5, 8.1000000000000014, 0.0 },
  { 1099132.6182399995, 5, 8.1999999999999993, 0.0 },
  { 1170003.0857600006, 5, 8.3000000000000007, 0.0 },
  { 1244453.5756800014, 5, 8.4000000000000021, 0.0 },
  { 1322617.0000000000, 5, 8.5000000000000000, 0.0 },
  { 1404629.4963200013, 5, 8.6000000000000014, 0.0 },
  { 1490630.4662399990, 5, 8.6999999999999993, 0.0 },
  { 1580762.6137600006, 5, 8.8000000000000007, 0.0 },
  { 1675171.9836800022, 5, 8.9000000000000021, 0.0 },
  { 1774008.0000000000, 5, 9.0000000000000000, 0.0 },
  { 1877423.5043200015, 5, 9.1000000000000014, 0.0 },
  { 1985574.7942400032, 5, 9.2000000000000028, 0.0 },
  { 2098621.6617600010, 5, 9.3000000000000007, 0.0 },
  { 2216727.4316800022, 5, 9.4000000000000021, 0.0 },
  { 2340059.0000000000, 5, 9.5000000000000000, 0.0 },
  { 2468786.8723200019, 5, 9.6000000000000014, 0.0 },
  { 2603085.2022400037, 5, 9.7000000000000028, 0.0 },
  { 2743131.8297600015, 5, 9.8000000000000007, 0.0 },
  { 2889108.3196800039, 5, 9.9000000000000021, 0.0 },
  { 3041200.0000000000, 5, 10.000000000000000, 0.0 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for n=10.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data005[201] =
{
  { 8093278209760.0000, 10, -10.000000000000000, 0.0 },
  { 7282867075495.3066, 10, -9.9000000000000004, 0.0 },
  { 6545846221520.6768, 10, -9.8000000000000007, 0.0 },
  { 5876279006180.6377, 10, -9.6999999999999993, 0.0 },
  { 5268651052510.4668, 10, -9.5999999999999996, 0.0 },
  { 4717844376391.0000, 10, -9.5000000000000000, 0.0 },
  { 4219112842239.1147, 10, -9.4000000000000004, 0.0 },
  { 3768058891466.0469, 10, -9.3000000000000007, 0.0 },
  { 3360611490639.0889, 10, -9.1999999999999993, 0.0 },
  { 2993005247949.7607, 10, -9.0999999999999996, 0.0 },
  { 2661760648224.0000, 10, -9.0000000000000000, 0.0 },
  { 2363665358307.8496, 10, -8.9000000000000004, 0.0 },
  { 2095756556225.3428, 10, -8.8000000000000007, 0.0 },
  { 1855304239034.7983, 10, -8.6999999999999993, 0.0 },
  { 1639795465805.4746, 10, -8.5999999999999996, 0.0 },
  { 1446919493599.0000, 10, -8.5000000000000000, 0.0 },
  { 1274553765769.7463, 10, -8.4000000000000004, 0.0 },
  { 1120750713295.2778, 10, -8.3000000000000007, 0.0 },
  { 983725331213.07190, 10, -8.1999999999999993, 0.0 },
  { 861843493572.90051, 10, -8.0999999999999996, 0.0 },
  { 753610971616.00000, 10, -8.0000000000000000, 0.0 },
  { 657663121163.02454, 10, -7.9000000000000004, 0.0 },
  { 572755206432.81335, 10, -7.7999999999999998, 0.0 },
  { 497753328723.87476, 10, -7.6999999999999993, 0.0 },
  { 431625929570.40063, 10, -7.5999999999999996, 0.0 },
  { 373435839135.00000, 10, -7.5000000000000000, 0.0 },
  { 322332841721.55731, 10, -7.4000000000000004, 0.0 },
  { 277546731384.01782, 10, -7.2999999999999998, 0.0 },
  { 238380831670.89960, 10, -7.1999999999999993, 0.0 },
  { 204205954581.24731, 10, -7.0999999999999996, 0.0 },
  { 174454774816.00000, 10, -7.0000000000000000, 0.0 },
  { 148616596389.67230, 10, -6.9000000000000004, 0.0 },
  { 126232489621.23923, 10, -6.7999999999999998, 0.0 },
  { 106890777450.54652, 10, -6.6999999999999993, 0.0 },
  { 90222850927.787979, 10, -6.5999999999999996, 0.0 },
  { 75899294599.000000, 10, -6.5000000000000000, 0.0 },
  { 63626303360.468109, 10, -6.4000000000000004, 0.0 },
  { 53142373179.806053, 10, -6.2999999999999998, 0.0 },
  { 44215248881.625443, 10, -6.1999999999999993, 0.0 },
  { 36639112971.527679, 10, -6.0999999999999996, 0.0 },
  { 30232000224.000000, 10, -6.0000000000000000, 0.0 },
  { 24833423488.050575, 10, -5.8999999999999995, 0.0 },
  { 20302196869.444584, 10, -5.7999999999999998, 0.0 },
  { 16514443130.579359, 10, -5.7000000000000002, 0.0 },
  { 13361772808.732477, 10, -5.5999999999999996, 0.0 },
  { 10749623191.000000, 10, -5.5000000000000000, 0.0 },
  { 8595745900.0898018, 10, -5.3999999999999995, 0.0 },
  { 6828832439.6160822, 10, -5.2999999999999998, 0.0 },
  { 5387267621.0258913, 10, -5.1999999999999993, 0.0 },
  { 4218001347.1524582, 10, -5.0999999999999996, 0.0 },
  { 3275529760.0000000, 10, -5.0000000000000000, 0.0 },
  { 2520977273.0966735, 10, -4.8999999999999995, 0.0 },
  { 1921271501.9744270, 10, -4.7999999999999998, 0.0 },
  { 1448403580.4203794, 10, -4.6999999999999993, 0.0 },
  { 1078766805.4651456, 10, -4.5999999999999996, 0.0 },
  { 792566991.00000000, 10, -4.5000000000000000, 0.0 },
  { 573298328.81993365, 10, -4.3999999999999995, 0.0 },
  { 407278957.14375639, 10, -4.2999999999999998, 0.0 },
  { 283240820.63788199, 10, -4.1999999999999993, 0.0 },
  { 191968773.03860721, 10, -4.0999999999999996, 0.0 },
  { 125984224.00000000, 10, -4.0000000000000000, 0.0 },
  { 79268966.162877351, 10, -3.8999999999999995, 0.0 },
  { 47025137.016035721, 10, -3.7999999999999998, 0.0 },
  { 25467573.275709212, 10, -3.6999999999999993, 0.0 },
  { 11645103.614666298, 10, -3.5999999999999996, 0.0 },
  { 3287599.0000000000, 10, -3.5000000000000000, 0.0 },
  { -1324140.9798373580, 10, -3.3999999999999995, 0.0 },
  { -3468342.2313268245, 10, -3.2999999999999998, 0.0 },
  { -4074495.5241857003, 10, -3.1999999999999993, 0.0 },
  { -3800107.4878923763, 10, -3.0999999999999996, 0.0 },
  { -3093984.0000000000, 10, -3.0000000000000000, 0.0 },
  { -2247873.5653938125, 10, -2.8999999999999995, 0.0 },
  { -1438117.1978829810, 10, -2.7999999999999998, 0.0 },
  { -758781.93281033845, 10, -2.6999999999999993, 0.0 },
  { -247597.05012469599, 10, -2.5999999999999996, 0.0 },
  { 94135.000000000000, 10, -2.5000000000000000, 0.0 },
  { 286617.47398410313, 10, -2.3999999999999995, 0.0 },
  { 360718.79745525768, 10, -2.2999999999999998, 0.0 },
  { 350419.82826741732, 10, -2.1999999999999993, 0.0 },
  { 287863.09027338214, 10, -2.0999999999999996, 0.0 },
  { 200416.00000000000, 10, -2.0000000000000000, 0.0 },
  { 109249.22783242268, 10, -1.9000000000000004, 0.0 },
  { 29012.094015896859, 10, -1.7999999999999989, 0.0 },
  { -31740.330680422732, 10, -1.6999999999999993, 0.0 },
  { -69648.597834137676, 10, -1.5999999999999996, 0.0 },
  { -85401.000000000000, 10, -1.5000000000000000, 0.0 },
  { -82507.675752857642, 10, -1.4000000000000004, 0.0 },
  { -66123.413033062170, 10, -1.2999999999999989, 0.0 },
  { -42007.465141862223, 10, -1.1999999999999993, 0.0 },
  { -15676.055823257526, 10, -1.0999999999999996, 0.0 },
  { 8224.0000000000000, 10, -1.0000000000000000, 0.0 },
  { 26314.366684262357, 10, -0.90000000000000036, 0.0 },
  { 36668.344916377660, 10, -0.79999999999999893, 0.0 },
  { 38802.826035097583, 10, -0.69999999999999929, 0.0 },
  { 33513.167890022363, 10, -0.59999999999999964, 0.0 },
  { 22591.000000000000, 10, -0.50000000000000000, 0.0 },
  { 8467.6907597821937, 10, -0.39999999999999858, 0.0 },
  { -6173.8524877825521, 10, -0.29999999999999893, 0.0 },
  { -18778.856957542470, 10, -0.19999999999999929, 0.0 },
  { -27256.158950297624, 10, -0.099999999999999645, 0.0 },
  { -30240.000000000000, 10, 0.0000000000000000, 0.0 },
  { -27256.158950297515, 10, 0.10000000000000142, 0.0 },
  { -18778.856957542288, 10, 0.20000000000000107, 0.0 },
  { -6173.8524877822965, 10, 0.30000000000000071, 0.0 },
  { 8467.6907597824556, 10, 0.40000000000000036, 0.0 },
  { 22591.000000000000, 10, 0.50000000000000000, 0.0 },
  { 33513.167890022516, 10, 0.60000000000000142, 0.0 },
  { 38802.826035097620, 10, 0.70000000000000107, 0.0 },
  { 36668.344916377559, 10, 0.80000000000000071, 0.0 },
  { 26314.366684262357, 10, 0.90000000000000036, 0.0 },
  { 8224.0000000000000, 10, 1.0000000000000000, 0.0 },
  { -15676.055823257961, 10, 1.1000000000000014, 0.0 },
  { -42007.465141862689, 10, 1.2000000000000011, 0.0 },
  { -66123.413033062563, 10, 1.3000000000000007, 0.0 },
  { -82507.675752857642, 10, 1.4000000000000004, 0.0 },
  { -85401.000000000000, 10, 1.5000000000000000, 0.0 },
  { -69648.597834137239, 10, 1.6000000000000014, 0.0 },
  { -31740.330680421859, 10, 1.7000000000000011, 0.0 },
  { 29012.094015898125, 10, 1.8000000000000007, 0.0 },
  { 109249.22783242268, 10, 1.9000000000000004, 0.0 },
  { 200416.00000000000, 10, 2.0000000000000000, 0.0 },
  { 287863.09027338354, 10, 2.1000000000000014, 0.0 },
  { 350419.82826741802, 10, 2.2000000000000011, 0.0 },
  { 360718.79745525745, 10, 2.3000000000000007, 0.0 },
  { 286617.47398410190, 10, 2.4000000000000004, 0.0 },
  { 94135.000000000000, 10, 2.5000000000000000, 0.0 },
  { -247597.05012470379, 10, 2.6000000000000014, 0.0 },
  { -758781.93281034881, 10, 2.7000000000000011, 0.0 },
  { -1438117.1978829878, 10, 2.8000000000000007, 0.0 },
  { -2247873.5653938209, 10, 2.9000000000000004, 0.0 },
  { -3093984.0000000000, 10, 3.0000000000000000, 0.0 },
  { -3800107.4878923851, 10, 3.1000000000000014, 0.0 },
  { -4074495.5241857045, 10, 3.2000000000000011, 0.0 },
  { -3468342.2313268133, 10, 3.3000000000000007, 0.0 },
  { -1324140.9798373245, 10, 3.4000000000000004, 0.0 },
  { 3287599.0000000000, 10, 3.5000000000000000, 0.0 },
  { 11645103.614666503, 10, 3.6000000000000014, 0.0 },
  { 25467573.275709510, 10, 3.7000000000000011, 0.0 },
  { 47025137.016035900, 10, 3.8000000000000007, 0.0 },
  { 79268966.162877649, 10, 3.9000000000000004, 0.0 },
  { 125984224.00000000, 10, 4.0000000000000000, 0.0 },
  { 191968773.03860855, 10, 4.1000000000000014, 0.0 },
  { 283240820.63788390, 10, 4.2000000000000011, 0.0 },
  { 407278957.14375770, 10, 4.3000000000000007, 0.0 },
  { 573298328.81993556, 10, 4.4000000000000004, 0.0 },
  { 792566991.00000000, 10, 4.5000000000000000, 0.0 },
  { 1078766805.4651513, 10, 4.6000000000000014, 0.0 },
  { 1448403580.4203873, 10, 4.7000000000000011, 0.0 },
  { 1921271501.9744320, 10, 4.8000000000000007, 0.0 },
  { 2520977273.0966806, 10, 4.9000000000000004, 0.0 },
  { 3275529760.0000000, 10, 5.0000000000000000, 0.0 },
  { 4218001347.1524763, 10, 5.1000000000000014, 0.0 },
  { 5387267621.0259113, 10, 5.2000000000000011, 0.0 },
  { 6828832439.6160927, 10, 5.3000000000000007, 0.0 },
  { 8595745900.0898170, 10, 5.4000000000000004, 0.0 },
  { 10749623191.000000, 10, 5.5000000000000000, 0.0 },
  { 13361772808.732529, 10, 5.6000000000000014, 0.0 },
  { 16514443130.579391, 10, 5.7000000000000011, 0.0 },
  { 20302196869.444618, 10, 5.8000000000000007, 0.0 },
  { 24833423488.050617, 10, 5.9000000000000004, 0.0 },
  { 30232000224.000000, 10, 6.0000000000000000, 0.0 },
  { 36639112971.527824, 10, 6.1000000000000014, 0.0 },
  { 44215248881.625443, 10, 6.1999999999999993, 0.0 },
  { 53142373179.806152, 10, 6.3000000000000007, 0.0 },
  { 63626303360.468330, 10, 6.4000000000000021, 0.0 },
  { 75899294599.000000, 10, 6.5000000000000000, 0.0 },
  { 90222850927.788208, 10, 6.6000000000000014, 0.0 },
  { 106890777450.54652, 10, 6.6999999999999993, 0.0 },
  { 126232489621.23946, 10, 6.8000000000000007, 0.0 },
  { 148616596389.67273, 10, 6.9000000000000021, 0.0 },
  { 174454774816.00000, 10, 7.0000000000000000, 0.0 },
  { 204205954581.24780, 10, 7.1000000000000014, 0.0 },
  { 238380831670.89960, 10, 7.1999999999999993, 0.0 },
  { 277546731384.01831, 10, 7.3000000000000007, 0.0 },
  { 322332841721.55811, 10, 7.4000000000000021, 0.0 },
  { 373435839135.00000, 10, 7.5000000000000000, 0.0 },
  { 431625929570.40161, 10, 7.6000000000000014, 0.0 },
  { 497753328723.87476, 10, 7.6999999999999993, 0.0 },
  { 572755206432.81396, 10, 7.8000000000000007, 0.0 },
  { 657663121163.02625, 10, 7.9000000000000021, 0.0 },
  { 753610971616.00000, 10, 8.0000000000000000, 0.0 },
  { 861843493572.90283, 10, 8.1000000000000014, 0.0 },
  { 983725331213.07190, 10, 8.1999999999999993, 0.0 },
  { 1120750713295.2778, 10, 8.3000000000000007, 0.0 },
  { 1274553765769.7490, 10, 8.4000000000000021, 0.0 },
  { 1446919493599.0000, 10, 8.5000000000000000, 0.0 },
  { 1639795465805.4785, 10, 8.6000000000000014, 0.0 },
  { 1855304239034.7983, 10, 8.6999999999999993, 0.0 },
  { 2095756556225.3428, 10, 8.8000000000000007, 0.0 },
  { 2363665358307.8540, 10, 8.9000000000000021, 0.0 },
  { 2661760648224.0000, 10, 9.0000000000000000, 0.0 },
  { 2993005247949.7671, 10, 9.1000000000000014, 0.0 },
  { 3360611490639.1025, 10, 9.2000000000000028, 0.0 },
  { 3768058891466.0469, 10, 9.3000000000000007, 0.0 },
  { 4219112842239.1221, 10, 9.4000000000000021, 0.0 },
  { 4717844376391.0000, 10, 9.5000000000000000, 0.0 },
  { 5268651052510.4785, 10, 9.6000000000000014, 0.0 },
  { 5876279006180.6602, 10, 9.7000000000000028, 0.0 },
  { 6545846221520.6768, 10, 9.8000000000000007, 0.0 },
  { 7282867075495.3213, 10, 9.9000000000000021, 0.0 },
  { 8093278209760.0000, 10, 10.000000000000000, 0.0 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for n=20.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data006[201] =
{
  { 3.6536710970888030e+25, 20, -10.000000000000000, 0.0 },
  { 2.9174932703098834e+25, 20, -9.9000000000000004, 0.0 },
  { 2.3228769039548404e+25, 20, -9.8000000000000007, 0.0 },
  { 1.8439144509496016e+25, 20, -9.6999999999999993, 0.0 },
  { 1.4591971834545420e+25, 20, -9.5999999999999996, 0.0 },
  { 1.1510764882450827e+25, 20, -9.5000000000000000, 0.0 },
  { 9.0503941245991605e+24, 20, -9.4000000000000004, 0.0 },
  { 7.0918188910312152e+24, 20, -9.3000000000000007, 0.0 },
  { 5.5376531405202033e+24, 20, -9.1999999999999993, 0.0 },
  { 4.3084410724035914e+24, 20, -9.0999999999999996, 0.0 },
  { 3.3395360269524137e+24, 20, -9.0000000000000000, 0.0 },
  { 2.5784910430831484e+24, 20, -8.9000000000000004, 0.0 },
  { 1.9828824261062853e+24, 20, -8.8000000000000007, 0.0 },
  { 1.5184989558235974e+24, 20, -8.6999999999999993, 0.0 },
  { 1.1578391431515818e+24, 20, -8.5999999999999996, 0.0 },
  { 8.7886740525023878e+23, 20, -8.5000000000000000, 0.0 },
  { 6.6398733801206072e+23, 20, -8.4000000000000004, 0.0 },
  { 4.9919656538201190e+23, 20, -8.3000000000000007, 0.0 },
  { 3.7339306542317994e+23, 20, -8.1999999999999993, 0.0 },
  { 2.7780752653950559e+23, 20, -8.0999999999999996, 0.0 },
  { 2.0554027373991249e+23, 20, -8.0000000000000000, 0.0 },
  { 1.5118471231121695e+23, 20, -7.9000000000000004, 0.0 },
  { 1.1052214218386250e+23, 20, -7.7999999999999998, 0.0 },
  { 8.0275268594719286e+22, 20, -7.6999999999999993, 0.0 },
  { 5.7909832934009042e+22, 20, -7.5999999999999996, 0.0 },
  { 4.1475563998692745e+22, 20, -7.5000000000000000, 0.0 },
  { 2.9479149729249250e+22, 20, -7.4000000000000004, 0.0 },
  { 2.0783192485964573e+22, 20, -7.2999999999999998, 0.0 },
  { 1.4526171451238465e+22, 20, -7.1999999999999993, 0.0 },
  { 1.0059323685871305e+22, 20, -7.0999999999999996, 0.0 },
  { 6.8970965604502329e+21, 20, -7.0000000000000000, 0.0 },
  { 4.6784410379528280e+21, 20, -6.9000000000000004, 0.0 },
  { 3.1367268160419670e+21, 20, -6.7999999999999998, 0.0 },
  { 2.0764831558419680e+21, 20, -6.6999999999999993, 0.0 },
  { 1.3555174744148132e+21, 20, -6.5999999999999996, 0.0 },
  { 8.7124954970091579e+20, 20, -6.5000000000000000, 0.0 },
  { 5.5033278133788108e+20, 20, -6.4000000000000004, 0.0 },
  { 3.4082412197533739e+20, 20, -6.2999999999999998, 0.0 },
  { 2.0631845648712086e+20, 20, -6.1999999999999993, 0.0 },
  { 1.2158762212269028e+20, 20, -6.0999999999999996, 0.0 },
  { 6.9364200641629315e+19, 20, -6.0000000000000000, 0.0 },
  { 3.7990093270095700e+19, 20, -5.8999999999999995, 0.0 },
  { 1.9713403927925858e+19, 20, -5.7999999999999998, 0.0 },
  { 9.4673798488533340e+18, 20, -5.7000000000000002, 0.0 },
  { 4.0046403628787825e+18, 20, -5.5999999999999996, 0.0 },
  { 1.2907686705724293e+18, 20, -5.5000000000000000, 0.0 },
  { 85277679782819584., 20, -5.3999999999999995, 0.0 },
  { -3.4359547179069376e+17, 20, -5.2999999999999998, 0.0 },
  { -4.0970873501577562e+17, 20, -5.1999999999999993, 0.0 },
  { -3.3419585613348250e+17, 20, -5.0999999999999996, 0.0 },
  { -2.2571776716382720e+17, 20, -5.0000000000000000, 0.0 },
  { -1.3051120203565493e+17, 20, -4.8999999999999995, 0.0 },
  { -62555669197021992., 20, -4.7999999999999998, 0.0 },
  { -20974173561009776., 20, -4.6999999999999993, 0.0 },
  { 519073301695656.00, 20, -4.5999999999999996, 0.0 },
  { 8939556693761121.0, 20, -4.5000000000000000, 0.0 },
  { 10070625675125174., 20, -4.3999999999999995, 0.0 },
  { 7940371996960715.0, 20, -4.2999999999999998, 0.0 },
  { 4973623686173539.0, 20, -4.1999999999999993, 0.0 },
  { 2389023282480410.0, 20, -4.0999999999999996, 0.0 },
  { 619678016654336.00, 20, -4.0000000000000000, 0.0 },
  { -339773491011950.50, 20, -3.8999999999999995, 0.0 },
  { -687467334428204.38, 20, -3.7999999999999998, 0.0 },
  { -663019129550482.25, 20, -3.6999999999999993, 0.0 },
  { -469585152350670.25, 20, -3.5999999999999996, 0.0 },
  { -245659781875039.00, 20, -3.5000000000000000, 0.0 },
  { -66042773886777.562, 20, -3.3999999999999995, 0.0 },
  { 43442261337436.312, 20, -3.2999999999999998, 0.0 },
  { 87626632986465.438, 20, -3.1999999999999993, 0.0 },
  { 85786202388511.375, 20, -3.0999999999999996, 0.0 },
  { 59990281399296.000, 20, -3.0000000000000000, 0.0 },
  { 28343496696717.773, 20, -2.8999999999999995, 0.0 },
  { 2296898915036.0859, 20, -2.7999999999999998, 0.0 },
  { -13249381789941.586, 20, -2.6999999999999993, 0.0 },
  { -18328180426561.059, 20, -2.5999999999999996, 0.0 },
  { -15799429886575.000, 20, -2.5000000000000000, 0.0 },
  { -9442592050214.2422, 20, -2.3999999999999995, 0.0 },
  { -2602375356373.2393, 20, -2.2999999999999998, 0.0 },
  { 2521759315047.8770, 20, -2.1999999999999993, 0.0 },
  { 5027779307352.6660, 20, -2.0999999999999996, 0.0 },
  { 5080118660096.0000, 20, -2.0000000000000000, 0.0 },
  { 3490463276000.5425, 20, -1.9000000000000004, 0.0 },
  { 1277254793997.0737, 20, -1.7999999999999989, 0.0 },
  { -682119355279.28784, 20, -1.6999999999999993, 0.0 },
  { -1851544254412.3203, 20, -1.5999999999999996, 0.0 },
  { -2085387081039.0000, 20, -1.5000000000000000, 0.0 },
  { -1559402933581.5054, 20, -1.4000000000000004, 0.0 },
  { -634265763221.85437, 20, -1.2999999999999989, 0.0 },
  { 295481874887.33429, 20, -1.1999999999999993, 0.0 },
  { 924603483429.34241, 20, -1.0999999999999996, 0.0 },
  { 1107214478336.0000, 20, -1.0000000000000000, 0.0 },
  { 867235623835.12463, 20, -0.90000000000000036, 0.0 },
  { 358848462745.14441, 20, -0.79999999999999893, 0.0 },
  { -202944086511.71936, 20, -0.69999999999999929, 0.0 },
  { -617730863561.32617, 20, -0.59999999999999964, 0.0 },
  { -759627879679.00000, 20, -0.50000000000000000, 0.0 },
  { -607451728035.02795, 20, -0.39999999999999858, 0.0 },
  { -240424854484.41342, 20, -0.29999999999999893, 0.0 },
  { 195759209122.61337, 20, -0.19999999999999929, 0.0 },
  { 540334019322.52014, 20, -0.099999999999999645, 0.0 },
  { 670442572800.00000, 20, 0.0000000000000000, 0.0 },
  { 540334019322.51575, 20, 0.10000000000000142, 0.0 },
  { 195759209122.60626, 20, 0.20000000000000107, 0.0 },
  { -240424854484.42111, 20, 0.30000000000000071, 0.0 },
  { -607451728035.03271, 20, 0.40000000000000036, 0.0 },
  { -759627879679.00000, 20, 0.50000000000000000, 0.0 },
  { -617730863561.32117, 20, 0.60000000000000142, 0.0 },
  { -202944086511.71027, 20, 0.70000000000000107, 0.0 },
  { 358848462745.15466, 20, 0.80000000000000071, 0.0 },
  { 867235623835.12463, 20, 0.90000000000000036, 0.0 },
  { 1107214478336.0000, 20, 1.0000000000000000, 0.0 },
  { 924603483429.33521, 20, 1.1000000000000014, 0.0 },
  { 295481874887.31995, 20, 1.2000000000000011, 0.0 },
  { -634265763221.87231, 20, 1.3000000000000007, 0.0 },
  { -1559402933581.5054, 20, 1.4000000000000004, 0.0 },
  { -2085387081039.0000, 20, 1.5000000000000000, 0.0 },
  { -1851544254412.3086, 20, 1.6000000000000014, 0.0 },
  { -682119355279.25952, 20, 1.7000000000000011, 0.0 },
  { 1277254793997.1128, 20, 1.8000000000000007, 0.0 },
  { 3490463276000.5425, 20, 1.9000000000000004, 0.0 },
  { 5080118660096.0000, 20, 2.0000000000000000, 0.0 },
  { 5027779307352.6436, 20, 2.1000000000000014, 0.0 },
  { 2521759315047.8071, 20, 2.2000000000000011, 0.0 },
  { -2602375356373.2969, 20, 2.3000000000000007, 0.0 },
  { -9442592050214.3027, 20, 2.4000000000000004, 0.0 },
  { -15799429886575.000, 20, 2.5000000000000000, 0.0 },
  { -18328180426561.039, 20, 2.6000000000000014, 0.0 },
  { -13249381789941.420, 20, 2.7000000000000011, 0.0 },
  { 2296898915036.2812, 20, 2.8000000000000007, 0.0 },
  { 28343496696718.070, 20, 2.9000000000000004, 0.0 },
  { 59990281399296.000, 20, 3.0000000000000000, 0.0 },
  { 85786202388511.641, 20, 3.1000000000000014, 0.0 },
  { 87626632986465.219, 20, 3.2000000000000011, 0.0 },
  { 43442261337435.672, 20, 3.3000000000000007, 0.0 },
  { -66042773886778.938, 20, 3.4000000000000004, 0.0 },
  { -245659781875039.00, 20, 3.5000000000000000, 0.0 },
  { -469585152350674.31, 20, 3.6000000000000014, 0.0 },
  { -663019129550484.62, 20, 3.7000000000000011, 0.0 },
  { -687467334428203.38, 20, 3.8000000000000007, 0.0 },
  { -339773491011946.00, 20, 3.9000000000000004, 0.0 },
  { 619678016654336.00, 20, 4.0000000000000000, 0.0 },
  { 2389023282480449.0, 20, 4.1000000000000014, 0.0 },
  { 4973623686173592.0, 20, 4.2000000000000011, 0.0 },
  { 7940371996960741.0, 20, 4.3000000000000007, 0.0 },
  { 10070625675125180., 20, 4.4000000000000004, 0.0 },
  { 8939556693761121.0, 20, 4.5000000000000000, 0.0 },
  { 519073301695404.00, 20, 4.6000000000000014, 0.0 },
  { -20974173561010304., 20, 4.7000000000000011, 0.0 },
  { -62555669197022528., 20, 4.8000000000000007, 0.0 },
  { -1.3051120203565566e+17, 20, 4.9000000000000004, 0.0 },
  { -2.2571776716382720e+17, 20, 5.0000000000000000, 0.0 },
  { -3.3419585613348416e+17, 20, 5.1000000000000014, 0.0 },
  { -4.0970873501577613e+17, 20, 5.2000000000000011, 0.0 },
  { -3.4359547179069216e+17, 20, 5.3000000000000007, 0.0 },
  { 85277679782823936., 20, 5.4000000000000004, 0.0 },
  { 1.2907686705724293e+18, 20, 5.5000000000000000, 0.0 },
  { 4.0046403628788460e+18, 20, 5.6000000000000014, 0.0 },
  { 9.4673798488534159e+18, 20, 5.7000000000000011, 0.0 },
  { 1.9713403927925973e+19, 20, 5.8000000000000007, 0.0 },
  { 3.7990093270095905e+19, 20, 5.9000000000000004, 0.0 },
  { 6.9364200641629315e+19, 20, 6.0000000000000000, 0.0 },
  { 1.2158762212269156e+20, 20, 6.1000000000000014, 0.0 },
  { 2.0631845648712086e+20, 20, 6.1999999999999993, 0.0 },
  { 3.4082412197533902e+20, 20, 6.3000000000000007, 0.0 },
  { 5.5033278133788620e+20, 20, 6.4000000000000021, 0.0 },
  { 8.7124954970091579e+20, 20, 6.5000000000000000, 0.0 },
  { 1.3555174744148243e+21, 20, 6.6000000000000014, 0.0 },
  { 2.0764831558419680e+21, 20, 6.6999999999999993, 0.0 },
  { 3.1367268160419775e+21, 20, 6.8000000000000007, 0.0 },
  { 4.6784410379528606e+21, 20, 6.9000000000000021, 0.0 },
  { 6.8970965604502329e+21, 20, 7.0000000000000000, 0.0 },
  { 1.0059323685871368e+22, 20, 7.1000000000000014, 0.0 },
  { 1.4526171451238465e+22, 20, 7.1999999999999993, 0.0 },
  { 2.0783192485964666e+22, 20, 7.3000000000000007, 0.0 },
  { 2.9479149729249434e+22, 20, 7.4000000000000021, 0.0 },
  { 4.1475563998692745e+22, 20, 7.5000000000000000, 0.0 },
  { 5.7909832934009378e+22, 20, 7.6000000000000014, 0.0 },
  { 8.0275268594719286e+22, 20, 7.6999999999999993, 0.0 },
  { 1.1052214218386286e+23, 20, 7.8000000000000007, 0.0 },
  { 1.5118471231121759e+23, 20, 7.9000000000000021, 0.0 },
  { 2.0554027373991249e+23, 20, 8.0000000000000000, 0.0 },
  { 2.7780752653950703e+23, 20, 8.1000000000000014, 0.0 },
  { 3.7339306542317994e+23, 20, 8.1999999999999993, 0.0 },
  { 4.9919656538201190e+23, 20, 8.3000000000000007, 0.0 },
  { 6.6398733801206421e+23, 20, 8.4000000000000021, 0.0 },
  { 8.7886740525023878e+23, 20, 8.5000000000000000, 0.0 },
  { 1.1578391431515869e+24, 20, 8.6000000000000014, 0.0 },
  { 1.5184989558235974e+24, 20, 8.6999999999999993, 0.0 },
  { 1.9828824261062853e+24, 20, 8.8000000000000007, 0.0 },
  { 2.5784910430831597e+24, 20, 8.9000000000000021, 0.0 },
  { 3.3395360269524137e+24, 20, 9.0000000000000000, 0.0 },
  { 4.3084410724036123e+24, 20, 9.1000000000000014, 0.0 },
  { 5.5376531405202538e+24, 20, 9.2000000000000028, 0.0 },
  { 7.0918188910312152e+24, 20, 9.3000000000000007, 0.0 },
  { 9.0503941245991948e+24, 20, 9.4000000000000021, 0.0 },
  { 1.1510764882450827e+25, 20, 9.5000000000000000, 0.0 },
  { 1.4591971834545491e+25, 20, 9.6000000000000014, 0.0 },
  { 1.8439144509496166e+25, 20, 9.7000000000000028, 0.0 },
  { 2.3228769039548404e+25, 20, 9.8000000000000007, 0.0 },
  { 2.9174932703098967e+25, 20, 9.9000000000000021, 0.0 },
  { 3.6536710970888030e+25, 20, 10.000000000000000, 0.0 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for n=50.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data007[201] =
{
  { 1.3516643049819314e+61, 50, -10.000000000000000, 0.0 },
  { 5.8466703062266110e+60, 50, -9.9000000000000004, 0.0 },
  { 2.4344814863741168e+60, 50, -9.8000000000000007, 0.0 },
  { 9.6739828066585787e+59, 50, -9.6999999999999993, 0.0 },
  { 3.6194312967780128e+59, 50, -9.5999999999999996, 0.0 },
  { 1.2454022521696361e+59, 50, -9.5000000000000000, 0.0 },
  { 3.7546881918013145e+58, 50, -9.4000000000000004, 0.0 },
  { 8.6500158470917270e+57, 50, -9.3000000000000007, 0.0 },
  { 5.3163209769527426e+56, 50, -9.1999999999999993, 0.0 },
  { -9.7863165370930473e+56, 50, -9.0999999999999996, 0.0 },
  { -8.0563930902368911e+56, 50, -9.0000000000000000, 0.0 },
  { -4.3145937406321933e+56, 50, -8.9000000000000004, 0.0 },
  { -1.8210771577645630e+56, 50, -8.8000000000000007, 0.0 },
  { -6.0082225302289557e+55, 50, -8.6999999999999993, 0.0 },
  { -1.2392013720948442e+55, 50, -8.5999999999999996, 0.0 },
  { 1.5935887905806307e+54, 50, -8.5000000000000000, 0.0 },
  { 3.4325365049909381e+54, 50, -8.4000000000000004, 0.0 },
  { 2.2368641272300899e+54, 50, -8.3000000000000007, 0.0 },
  { 1.0009712198862341e+54, 50, -8.1999999999999993, 0.0 },
  { 3.0699480272357337e+53, 50, -8.0999999999999996, 0.0 },
  { 2.9492797132685063e+52, 50, -8.0000000000000000, 0.0 },
  { -3.9982544106300062e+52, 50, -7.9000000000000004, 0.0 },
  { -3.5678031330023779e+52, 50, -7.7999999999999998, 0.0 },
  { -1.8076371748762319e+52, 50, -7.6999999999999993, 0.0 },
  { -5.7887622198708925e+51, 50, -7.5999999999999996, 0.0 },
  { -3.5808467693113330e+50, 50, -7.5000000000000000, 0.0 },
  { 1.0219511166806405e+51, 50, -7.4000000000000004, 0.0 },
  { 8.4241263694549560e+50, 50, -7.2999999999999998, 0.0 },
  { 3.9143899315095070e+50, 50, -7.1999999999999993, 0.0 },
  { 9.3178966245756654e+49, 50, -7.0999999999999996, 0.0 },
  { -2.4714855983436561e+49, 50, -7.0000000000000000, 0.0 },
  { -4.1428217272044600e+49, 50, -6.9000000000000004, 0.0 },
  { -2.4864980414057334e+49, 50, -6.7999999999999998, 0.0 },
  { -8.0684355476446876e+48, 50, -6.6999999999999993, 0.0 },
  { 4.2529238530179841e+47, 50, -6.5999999999999996, 0.0 },
  { 2.4709663739849681e+48, 50, -6.5000000000000000, 0.0 },
  { 1.7500305481204125e+48, 50, -6.4000000000000004, 0.0 },
  { 6.3834558285146007e+47, 50, -6.2999999999999998, 0.0 },
  { -1.1477672402384868e+46, 50, -6.1999999999999993, 0.0 },
  { -1.9304630401841983e+47, 50, -6.0999999999999996, 0.0 },
  { -1.4355266959903589e+47, 50, -6.0000000000000000, 0.0 },
  { -5.1482200905565497e+46, 50, -5.8999999999999995, 0.0 },
  { 4.6577356827463283e+45, 50, -5.7999999999999998, 0.0 },
  { 1.9676012349652066e+46, 50, -5.7000000000000002, 0.0 },
  { 1.3630554018675846e+46, 50, -5.5999999999999996, 0.0 },
  { 4.0920495328093750e+45, 50, -5.5000000000000000, 0.0 },
  { -1.3680638882145570e+45, 50, -5.3999999999999995, 0.0 },
  { -2.4465265559935436e+45, 50, -5.2999999999999998, 0.0 },
  { -1.4270495629649337e+45, 50, -5.1999999999999993, 0.0 },
  { -2.4845518743338381e+44, 50, -5.0999999999999996, 0.0 },
  { 3.1953926721271990e+44, 50, -5.0000000000000000, 0.0 },
  { 3.4169399444879477e+44, 50, -4.8999999999999995, 0.0 },
  { 1.4896819114978755e+44, 50, -4.7999999999999998, 0.0 },
  { -1.3078430866969463e+43, 50, -4.6999999999999993, 0.0 },
  { -6.8449168639700716e+43, 50, -4.5999999999999996, 0.0 },
  { -4.9181639709997461e+43, 50, -4.5000000000000000, 0.0 },
  { -1.1434943490344838e+43, 50, -4.3999999999999995, 0.0 },
  { 1.1214652543461432e+43, 50, -4.2999999999999998, 0.0 },
  { 1.3843548994480566e+43, 50, -4.1999999999999993, 0.0 },
  { 6.3349790205303262e+42, 50, -4.0999999999999996, 0.0 },
  { -9.5599640670553907e+41, 50, -4.0000000000000000, 0.0 },
  { -3.6202558158287989e+42, 50, -3.8999999999999995, 0.0 },
  { -2.5206461734624493e+42, 50, -3.7999999999999998, 0.0 },
  { -3.7818051510730675e+41, 50, -3.6999999999999993, 0.0 },
  { 8.8921371165335050e+41, 50, -3.5999999999999996, 0.0 },
  { 9.2055485763852770e+41, 50, -3.5000000000000000, 0.0 },
  { 3.2535765707282432e+41, 50, -3.3999999999999995, 0.0 },
  { -1.9358941418244578e+41, 50, -3.2999999999999998, 0.0 },
  { -3.3076282847915616e+41, 50, -3.1999999999999993, 0.0 },
  { -1.7764977066639160e+41, 50, -3.0999999999999996, 0.0 },
  { 2.6751882008697154e+40, 50, -3.0000000000000000, 0.0 },
  { 1.2025382369996071e+41, 50, -2.8999999999999995, 0.0 },
  { 8.8383035103557973e+40, 50, -2.7999999999999998, 0.0 },
  { 7.7733606479635628e+39, 50, -2.6999999999999993, 0.0 },
  { -4.4696811758713757e+40, 50, -2.5999999999999996, 0.0 },
  { -4.3715062488963453e+40, 50, -2.5000000000000000, 0.0 },
  { -1.1390080390574979e+40, 50, -2.3999999999999995, 0.0 },
  { 1.6938519751181342e+40, 50, -2.2999999999999998, 0.0 },
  { 2.2284509952956162e+40, 50, -2.1999999999999993, 0.0 },
  { 9.0967994280570531e+39, 50, -2.0999999999999996, 0.0 },
  { -6.4126677997472978e+39, 50, -2.0000000000000000, 0.0 },
  { -1.1926839454034341e+40, 50, -1.9000000000000004, 0.0 },
  { -6.5436654274697603e+39, 50, -1.7999999999999989, 0.0 },
  { 2.2779499542550411e+39, 50, -1.6999999999999993, 0.0 },
  { 6.7720530889699639e+39, 50, -1.5999999999999996, 0.0 },
  { 4.6884851188034300e+39, 50, -1.5000000000000000, 0.0 },
  { -5.9005001052557463e+38, 50, -1.4000000000000004, 0.0 },
  { -4.1028320210430837e+39, 50, -1.2999999999999989, 0.0 },
  { -3.4780049977083965e+39, 50, -1.1999999999999993, 0.0 },
  { -1.3484918476373692e+38, 50, -1.0999999999999996, 0.0 },
  { 2.6586815431645456e+39, 50, -1.0000000000000000, 0.0 },
  { 2.7225429473661429e+39, 50, -0.90000000000000036, 0.0 },
  { 4.7785441024946841e+38, 50, -0.79999999999999893, 0.0 },
  { -1.8416784378790159e+39, 50, -0.69999999999999929, 0.0 },
  { -2.2725918816693132e+39, 50, -0.59999999999999964, 0.0 },
  { -6.7948375014926916e+38, 50, -0.50000000000000000, 0.0 },
  { 1.3581645858906036e+39, 50, -0.39999999999999858, 0.0 },
  { 2.0349661043040443e+39, 50, -0.29999999999999893, 0.0 },
  { 8.5049248815817037e+38, 50, -0.19999999999999929, 0.0 },
  { -1.0564542132990048e+39, 50, -0.099999999999999645, 0.0 },
  { -1.9607814681608194e+39, 50, 0.0000000000000000, 0.0 },
  { -1.0564542132989758e+39, 50, 0.10000000000000142, 0.0 },
  { 8.5049248815820240e+38, 50, 0.20000000000000107, 0.0 },
  { 2.0349661043040497e+39, 50, 0.30000000000000071, 0.0 },
  { 1.3581645858905750e+39, 50, 0.40000000000000036, 0.0 },
  { -6.7948375014926916e+38, 50, 0.50000000000000000, 0.0 },
  { -2.2725918816693268e+39, 50, 0.60000000000000142, 0.0 },
  { -1.8416784378789875e+39, 50, 0.70000000000000107, 0.0 },
  { 4.7785441024951729e+38, 50, 0.80000000000000071, 0.0 },
  { 2.7225429473661429e+39, 50, 0.90000000000000036, 0.0 },
  { 2.6586815431645456e+39, 50, 1.0000000000000000, 0.0 },
  { -1.3484918476380069e+38, 50, 1.1000000000000014, 0.0 },
  { -3.4780049977084394e+39, 50, 1.2000000000000011, 0.0 },
  { -4.1028320210430589e+39, 50, 1.3000000000000007, 0.0 },
  { -5.9005001052557463e+38, 50, 1.4000000000000004, 0.0 },
  { 4.6884851188034300e+39, 50, 1.5000000000000000, 0.0 },
  { 6.7720530889699470e+39, 50, 1.6000000000000014, 0.0 },
  { 2.2779499542549072e+39, 50, 1.7000000000000011, 0.0 },
  { -6.5436654274699114e+39, 50, 1.8000000000000007, 0.0 },
  { -1.1926839454034341e+40, 50, 1.9000000000000004, 0.0 },
  { -6.4126677997472978e+39, 50, 2.0000000000000000, 0.0 },
  { 9.0967994280573626e+39, 50, 2.1000000000000014, 0.0 },
  { 2.2284509952956273e+40, 50, 2.2000000000000011, 0.0 },
  { 1.6938519751181172e+40, 50, 2.3000000000000007, 0.0 },
  { -1.1390080390575289e+40, 50, 2.4000000000000004, 0.0 },
  { -4.3715062488963453e+40, 50, 2.5000000000000000, 0.0 },
  { -4.4696811758713303e+40, 50, 2.6000000000000014, 0.0 },
  { 7.7733606479648733e+39, 50, 2.7000000000000011, 0.0 },
  { 8.8383035103558611e+40, 50, 2.8000000000000007, 0.0 },
  { 1.2025382369996052e+41, 50, 2.9000000000000004, 0.0 },
  { 2.6751882008697154e+40, 50, 3.0000000000000000, 0.0 },
  { -1.7764977066639554e+41, 50, 3.1000000000000014, 0.0 },
  { -3.3076282847915716e+41, 50, 3.2000000000000011, 0.0 },
  { -1.9358941418244260e+41, 50, 3.3000000000000007, 0.0 },
  { 3.2535765707283020e+41, 50, 3.4000000000000004, 0.0 },
  { 9.2055485763852770e+41, 50, 3.5000000000000000, 0.0 },
  { 8.8921371165333905e+41, 50, 3.6000000000000014, 0.0 },
  { -3.7818051510734018e+41, 50, 3.7000000000000011, 0.0 },
  { -2.5206461734624660e+42, 50, 3.8000000000000007, 0.0 },
  { -3.6202558158287927e+42, 50, 3.9000000000000004, 0.0 },
  { -9.5599640670553907e+41, 50, 4.0000000000000000, 0.0 },
  { 6.3349790205304773e+42, 50, 4.1000000000000014, 0.0 },
  { 1.3843548994480653e+43, 50, 4.2000000000000011, 0.0 },
  { 1.1214652543461340e+43, 50, 4.3000000000000007, 0.0 },
  { -1.1434943490345182e+43, 50, 4.4000000000000004, 0.0 },
  { -4.9181639709997461e+43, 50, 4.5000000000000000, 0.0 },
  { -6.8449168639700617e+43, 50, 4.6000000000000014, 0.0 },
  { -1.3078430866967542e+43, 50, 4.7000000000000011, 0.0 },
  { 1.4896819114978953e+44, 50, 4.8000000000000007, 0.0 },
  { 3.4169399444879600e+44, 50, 4.9000000000000004, 0.0 },
  { 3.1953926721271990e+44, 50, 5.0000000000000000, 0.0 },
  { -2.4845518743340037e+44, 50, 5.1000000000000014, 0.0 },
  { -1.4270495629649556e+45, 50, 5.2000000000000011, 0.0 },
  { -2.4465265559935458e+45, 50, 5.3000000000000007, 0.0 },
  { -1.3680638882145392e+45, 50, 5.4000000000000004, 0.0 },
  { 4.0920495328093750e+45, 50, 5.5000000000000000, 0.0 },
  { 1.3630554018676023e+46, 50, 5.6000000000000014, 0.0 },
  { 1.9676012349652035e+46, 50, 5.7000000000000011, 0.0 },
  { 4.6577356827460393e+45, 50, 5.8000000000000007, 0.0 },
  { -5.1482200905566146e+46, 50, 5.9000000000000004, 0.0 },
  { -1.4355266959903589e+47, 50, 6.0000000000000000, 0.0 },
  { -1.9304630401841966e+47, 50, 6.1000000000000014, 0.0 },
  { -1.1477672402384868e+46, 50, 6.1999999999999993, 0.0 },
  { 6.3834558285146981e+47, 50, 6.3000000000000007, 0.0 },
  { 1.7500305481204346e+48, 50, 6.4000000000000021, 0.0 },
  { 2.4709663739849681e+48, 50, 6.5000000000000000, 0.0 },
  { 4.2529238530171793e+47, 50, 6.6000000000000014, 0.0 },
  { -8.0684355476446876e+48, 50, 6.6999999999999993, 0.0 },
  { -2.4864980414057495e+49, 50, 6.8000000000000007, 0.0 },
  { -4.1428217272044745e+49, 50, 6.9000000000000021, 0.0 },
  { -2.4714855983436561e+49, 50, 7.0000000000000000, 0.0 },
  { 9.3178966245760310e+49, 50, 7.1000000000000014, 0.0 },
  { 3.9143899315095070e+50, 50, 7.1999999999999993, 0.0 },
  { 8.4241263694549925e+50, 50, 7.3000000000000007, 0.0 },
  { 1.0219511166806373e+51, 50, 7.4000000000000021, 0.0 },
  { -3.5808467693113330e+50, 50, 7.5000000000000000, 0.0 },
  { -5.7887622198710268e+51, 50, 7.6000000000000014, 0.0 },
  { -1.8076371748762319e+52, 50, 7.6999999999999993, 0.0 },
  { -3.5678031330023971e+52, 50, 7.8000000000000007, 0.0 },
  { -3.9982544106299987e+52, 50, 7.9000000000000021, 0.0 },
  { 2.9492797132685063e+52, 50, 8.0000000000000000, 0.0 },
  { 3.0699480272358086e+53, 50, 8.1000000000000014, 0.0 },
  { 1.0009712198862341e+54, 50, 8.1999999999999993, 0.0 },
  { 2.2368641272300899e+54, 50, 8.3000000000000007, 0.0 },
  { 3.4325365049909476e+54, 50, 8.4000000000000021, 0.0 },
  { 1.5935887905806307e+54, 50, 8.5000000000000000, 0.0 },
  { -1.2392013720948937e+55, 50, 8.6000000000000014, 0.0 },
  { -6.0082225302289557e+55, 50, 8.6999999999999993, 0.0 },
  { -1.8210771577645630e+56, 50, 8.8000000000000007, 0.0 },
  { -4.3145937406322482e+56, 50, 8.9000000000000021, 0.0 },
  { -8.0563930902368911e+56, 50, 9.0000000000000000, 0.0 },
  { -9.7863165370930194e+56, 50, 9.1000000000000014, 0.0 },
  { 5.3163209769540389e+56, 50, 9.2000000000000028, 0.0 },
  { 8.6500158470917270e+57, 50, 9.3000000000000007, 0.0 },
  { 3.7546881918013903e+58, 50, 9.4000000000000021, 0.0 },
  { 1.2454022521696361e+59, 50, 9.5000000000000000, 0.0 },
  { 3.6194312967780793e+59, 50, 9.6000000000000014, 0.0 },
  { 9.6739828066589016e+59, 50, 9.7000000000000028, 0.0 },
  { 2.4344814863741168e+60, 50, 9.8000000000000007, 0.0 },
  { 5.8466703062266974e+60, 50, 9.9000000000000021, 0.0 },
  { 1.3516643049819314e+61, 50, 10.000000000000000, 0.0 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for n=100.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data008[201] =
{
  { -1.8738689223256612e+115, 100, -10.000000000000000, 0.0 },
  { -4.4232904120311186e+114, 100, -9.9000000000000004, 0.0 },
  { 8.3761676654305186e+113, 100, -9.8000000000000007, 0.0 },
  { 9.4857435427570856e+113, 100, -9.6999999999999993, 0.0 },
  { 2.4904626130429828e+113, 100, -9.5999999999999996, 0.0 },
  { -4.2265051766934789e+112, 100, -9.5000000000000000, 0.0 },
  { -5.3374224541142079e+112, 100, -9.4000000000000004, 0.0 },
  { -1.3977488190034162e+112, 100, -9.3000000000000007, 0.0 },
  { 2.9686037583393142e+111, 100, -9.1999999999999993, 0.0 },
  { 3.3341330166544008e+111, 100, -9.0999999999999996, 0.0 },
  { 7.7294136683043515e+110, 100, -9.0000000000000000, 0.0 },
  { -2.6071876743328352e+110, 100, -8.9000000000000004, 0.0 },
  { -2.2669773300293168e+110, 100, -8.8000000000000007, 0.0 },
  { -3.8930624477368766e+109, 100, -8.6999999999999993, 0.0 },
  { 2.5386102824684956e+109, 100, -8.5999999999999996, 0.0 },
  { 1.6203702280499544e+109, 100, -8.5000000000000000, 0.0 },
  { 1.2481735250539652e+108, 100, -8.4000000000000004, 0.0 },
  { -2.5611278359589723e+108, 100, -8.3000000000000007, 0.0 },
  { -1.1534178973583771e+108, 100, -8.1999999999999993, 0.0 },
  { 8.4932594446954126e+106, 100, -8.0999999999999996, 0.0 },
  { 2.5761505535443451e+107, 100, -8.0000000000000000, 0.0 },
  { 7.3445622927437730e+106, 100, -7.9000000000000004, 0.0 },
  { -2.7252309851017323e+106, 100, -7.7999999999999998, 0.0 },
  { -2.4850432648123868e+106, 100, -7.6999999999999993, 0.0 },
  { -2.7486638813238851e+105, 100, -7.5999999999999996, 0.0 },
  { 4.4772364475394960e+105, 100, -7.5000000000000000, 0.0 },
  { 2.1375121759800508e+105, 100, -7.4000000000000004, 0.0 },
  { -2.9237691057265876e+104, 100, -7.2999999999999998, 0.0 },
  { -5.9348804074874565e+104, 100, -7.1999999999999993, 0.0 },
  { -1.2947583568692734e+104, 100, -7.0999999999999996, 0.0 },
  { 1.0002273523275075e+104, 100, -7.0000000000000000, 0.0 },
  { 6.4900499886057735e+103, 100, -6.9000000000000004, 0.0 },
  { -3.7817730019124298e+102, 100, -6.7999999999999998, 0.0 },
  { -1.7849709684883083e+103, 100, -6.6999999999999993, 0.0 },
  { -4.8039047085580619e+102, 100, -6.5999999999999996, 0.0 },
  { 3.2072472002047670e+102, 100, -6.5000000000000000, 0.0 },
  { 2.3341289432999226e+102, 100, -6.4000000000000004, 0.0 },
  { -1.4587350659146165e+101, 100, -6.2999999999999998, 0.0 },
  { -7.0672139150705246e+101, 100, -6.1999999999999993, 0.0 },
  { -1.8039133351601998e+101, 100, -6.0999999999999996, 0.0 },
  { 1.5170693933260738e+101, 100, -6.0000000000000000, 0.0 },
  { 1.0141407690966841e+101, 100, -5.8999999999999995, 0.0 },
  { -1.5140717605507886e+100, 100, -5.7999999999999998, 0.0 },
  { -3.6379102593330533e+100, 100, -5.7000000000000002, 0.0 },
  { -6.2933057672779134e+99, 100, -5.5999999999999996, 0.0 },
  { 9.9309186425970402e+99, 100, -5.5000000000000000, 0.0 },
  { 5.0935670879055936e+99, 100, -5.3999999999999995, 0.0 },
  { -1.8337906983006129e+99, 100, -5.2999999999999998, 0.0 },
  { -2.3096466887887237e+99, 100, -5.1999999999999993, 0.0 },
  { -4.0259235416602546e+97, 100, -5.0999999999999996, 0.0 },
  { 8.1931937130591466e+98, 100, -5.0000000000000000, 0.0 },
  { 2.5601172475776284e+98, 100, -4.8999999999999995, 0.0 },
  { -2.3193021196802698e+98, 100, -4.7999999999999998, 0.0 },
  { -1.6545238014142650e+98, 100, -4.6999999999999993, 0.0 },
  { 4.2440218943299170e+97, 100, -4.5999999999999996, 0.0 },
  { 7.8073853756187101e+97, 100, -4.5000000000000000, 0.0 },
  { 5.2136163919270720e+96, 100, -4.3999999999999995, 0.0 },
  { -3.0837503404959950e+97, 100, -4.2999999999999998, 0.0 },
  { -1.0988290456447506e+97, 100, -4.1999999999999993, 0.0 },
  { 1.0173847230741884e+97, 100, -4.0999999999999996, 0.0 },
  { 7.7070682747643550e+96, 100, -4.0000000000000000, 0.0 },
  { -2.3947326745293985e+96, 100, -3.8999999999999995, 0.0 },
  { -4.1993887070961596e+96, 100, -3.7999999999999998, 0.0 },
  { -5.5521768050503009e+94, 100, -3.6999999999999993, 0.0 },
  { 1.9852724296241180e+96, 100, -3.5999999999999996, 0.0 },
  { 5.7841213444838915e+95, 100, -3.5000000000000000, 0.0 },
  { -8.2433116644948985e+95, 100, -3.3999999999999995, 0.0 },
  { -5.2035951331058195e+95, 100, -3.2999999999999998, 0.0 },
  { 2.8212012454566478e+95, 100, -3.1999999999999993, 0.0 },
  { 3.5161870090563867e+95, 100, -3.0999999999999996, 0.0 },
  { -5.5084542871196523e+94, 100, -3.0000000000000000, 0.0 },
  { -2.0784160746797530e+95, 100, -2.8999999999999995, 0.0 },
  { -2.6058116248679496e+94, 100, -2.7999999999999998, 0.0 },
  { 1.1147132226581881e+95, 100, -2.6999999999999993, 0.0 },
  { 4.5607706742532875e+94, 100, -2.5999999999999996, 0.0 },
  { -5.3758761713337664e+94, 100, -2.5000000000000000, 0.0 },
  { -4.2303228932575310e+94, 100, -2.3999999999999995, 0.0 },
  { 2.1691501564685499e+94, 100, -2.2999999999999998, 0.0 },
  { 3.2602488340116774e+94, 100, -2.1999999999999993, 0.0 },
  { -5.0527155039787607e+93, 100, -2.0999999999999996, 0.0 },
  { -2.2785574311661325e+94, 100, -2.0000000000000000, 0.0 },
  { -2.8549527653152903e+93, 100, -1.9000000000000004, 0.0 },
  { 1.4787573463714434e+94, 100, -1.7999999999999989, 0.0 },
  { 6.0554070654771248e+93, 100, -1.6999999999999993, 0.0 },
  { -8.8496828346970978e+93, 100, -1.5999999999999996, 0.0 },
  { -6.8402151897169509e+93, 100, -1.5000000000000000, 0.0 },
  { 4.6555468819923166e+93, 100, -1.4000000000000004, 0.0 },
  { 6.4625437128322607e+93, 100, -1.2999999999999989, 0.0 },
  { -1.7820042440391653e+93, 100, -1.1999999999999993, 0.0 },
  { -5.5814393347235886e+93, 100, -1.0999999999999996, 0.0 },
  { -1.4487067293379347e+92, 100, -1.0000000000000000, 0.0 },
  { 4.5268398678911204e+93, 100, -0.90000000000000036, 0.0 },
  { 1.4120762149477404e+93, 100, -0.79999999999999893, 0.0 },
  { -3.4510765981144258e+93, 100, -0.69999999999999929, 0.0 },
  { -2.2242581581553176e+93, 100, -0.59999999999999964, 0.0 },
  { 2.4129827902061037e+93, 100, -0.50000000000000000, 0.0 },
  { 2.7195429139752020e+93, 100, -0.39999999999999858, 0.0 },
  { -1.4235309630837636e+93, 100, -0.29999999999999893, 0.0 },
  { -2.9850618739468043e+93, 100, -0.19999999999999929, 0.0 },
  { 4.7017027479251074e+92, 100, -0.099999999999999645, 0.0 },
  { 3.0685187562549660e+93, 100, 0.0000000000000000, 0.0 },
  { 4.7017027479243444e+92, 100, 0.10000000000000142, 0.0 },
  { -2.9850618739468293e+93, 100, 0.20000000000000107, 0.0 },
  { -1.4235309630836904e+93, 100, 0.30000000000000071, 0.0 },
  { 2.7195429139752497e+93, 100, 0.40000000000000036, 0.0 },
  { 2.4129827902061037e+93, 100, 0.50000000000000000, 0.0 },
  { -2.2242581581553936e+93, 100, 0.60000000000000142, 0.0 },
  { -3.4510765981143827e+93, 100, 0.70000000000000107, 0.0 },
  { 1.4120762149478435e+93, 100, 0.80000000000000071, 0.0 },
  { 4.5268398678911204e+93, 100, 0.90000000000000036, 0.0 },
  { -1.4487067293379347e+92, 100, 1.0000000000000000, 0.0 },
  { -5.5814393347236145e+93, 100, 1.1000000000000014, 0.0 },
  { -1.7820042440390210e+93, 100, 1.2000000000000011, 0.0 },
  { 6.4625437128323579e+93, 100, 1.3000000000000007, 0.0 },
  { 4.6555468819923166e+93, 100, 1.4000000000000004, 0.0 },
  { -6.8402151897169509e+93, 100, 1.5000000000000000, 0.0 },
  { -8.8496828346969644e+93, 100, 1.6000000000000014, 0.0 },
  { 6.0554070654774249e+93, 100, 1.7000000000000011, 0.0 },
  { 1.4787573463714363e+94, 100, 1.8000000000000007, 0.0 },
  { -2.8549527653152903e+93, 100, 1.9000000000000004, 0.0 },
  { -2.2785574311661325e+94, 100, 2.0000000000000000, 0.0 },
  { -5.0527155039780687e+93, 100, 2.1000000000000014, 0.0 },
  { 3.2602488340117204e+94, 100, 2.2000000000000011, 0.0 },
  { 2.1691501564685076e+94, 100, 2.3000000000000007, 0.0 },
  { -4.2303228932575769e+94, 100, 2.4000000000000004, 0.0 },
  { -5.3758761713337664e+94, 100, 2.5000000000000000, 0.0 },
  { 4.5607706742535083e+94, 100, 2.6000000000000014, 0.0 },
  { 1.1147132226581835e+95, 100, 2.7000000000000011, 0.0 },
  { -2.6058116248681564e+94, 100, 2.8000000000000007, 0.0 },
  { -2.0784160746797610e+95, 100, 2.9000000000000004, 0.0 },
  { -5.5084542871196523e+94, 100, 3.0000000000000000, 0.0 },
  { 3.5161870090564436e+95, 100, 3.1000000000000014, 0.0 },
  { 2.8212012454565588e+95, 100, 3.2000000000000011, 0.0 },
  { -5.2035951331058918e+95, 100, 3.3000000000000007, 0.0 },
  { -8.2433116644948570e+95, 100, 3.4000000000000004, 0.0 },
  { 5.7841213444838915e+95, 100, 3.5000000000000000, 0.0 },
  { 1.9852724296241191e+96, 100, 3.6000000000000014, 0.0 },
  { -5.5521768050576049e+94, 100, 3.7000000000000011, 0.0 },
  { -4.1993887070961795e+96, 100, 3.8000000000000007, 0.0 },
  { -2.3947326745293331e+96, 100, 3.9000000000000004, 0.0 },
  { 7.7070682747643550e+96, 100, 4.0000000000000000, 0.0 },
  { 1.0173847230741732e+97, 100, 4.1000000000000014, 0.0 },
  { -1.0988290456448056e+97, 100, 4.2000000000000011, 0.0 },
  { -3.0837503404959957e+97, 100, 4.3000000000000007, 0.0 },
  { 5.2136163919277588e+96, 100, 4.4000000000000004, 0.0 },
  { 7.8073853756187101e+97, 100, 4.5000000000000000, 0.0 },
  { 4.2440218943296749e+97, 100, 4.6000000000000014, 0.0 },
  { -1.6545238014143033e+98, 100, 4.7000000000000011, 0.0 },
  { -2.3193021196802549e+98, 100, 4.8000000000000007, 0.0 },
  { 2.5601172475776894e+98, 100, 4.9000000000000004, 0.0 },
  { 8.1931937130591466e+98, 100, 5.0000000000000000, 0.0 },
  { -4.0259235416636422e+97, 100, 5.1000000000000014, 0.0 },
  { -2.3096466887887553e+99, 100, 5.2000000000000011, 0.0 },
  { -1.8337906983005823e+99, 100, 5.3000000000000007, 0.0 },
  { 5.0935670879056567e+99, 100, 5.4000000000000004, 0.0 },
  { 9.9309186425970402e+99, 100, 5.5000000000000000, 0.0 },
  { -6.2933057672784165e+99, 100, 5.6000000000000014, 0.0 },
  { -3.6379102593330720e+100, 100, 5.7000000000000011, 0.0 },
  { -1.5140717605507249e+100, 100, 5.8000000000000007, 0.0 },
  { 1.0141407690966954e+101, 100, 5.9000000000000004, 0.0 },
  { 1.5170693933260738e+101, 100, 6.0000000000000000, 0.0 },
  { -1.8039133351602961e+101, 100, 6.1000000000000014, 0.0 },
  { -7.0672139150705246e+101, 100, 6.1999999999999993, 0.0 },
  { -1.4587350659144549e+101, 100, 6.3000000000000007, 0.0 },
  { 2.3341289432999758e+102, 100, 6.4000000000000021, 0.0 },
  { 3.2072472002047670e+102, 100, 6.5000000000000000, 0.0 },
  { -4.8039047085582927e+102, 100, 6.6000000000000014, 0.0 },
  { -1.7849709684883083e+103, 100, 6.6999999999999993, 0.0 },
  { -3.7817730019120996e+102, 100, 6.8000000000000007, 0.0 },
  { 6.4900499886059199e+103, 100, 6.9000000000000021, 0.0 },
  { 1.0002273523275075e+104, 100, 7.0000000000000000, 0.0 },
  { -1.2947583568693485e+104, 100, 7.1000000000000014, 0.0 },
  { -5.9348804074874565e+104, 100, 7.1999999999999993, 0.0 },
  { -2.9237691057264679e+104, 100, 7.3000000000000007, 0.0 },
  { 2.1375121759801080e+105, 100, 7.4000000000000021, 0.0 },
  { 4.4772364475394960e+105, 100, 7.5000000000000000, 0.0 },
  { -2.7486638813241244e+105, 100, 7.6000000000000014, 0.0 },
  { -2.4850432648123868e+106, 100, 7.6999999999999993, 0.0 },
  { -2.7252309851017070e+106, 100, 7.8000000000000007, 0.0 },
  { 7.3445622927440321e+106, 100, 7.9000000000000021, 0.0 },
  { 2.5761505535443451e+107, 100, 8.0000000000000000, 0.0 },
  { 8.4932594446944218e+106, 100, 8.1000000000000014, 0.0 },
  { -1.1534178973583771e+108, 100, 8.1999999999999993, 0.0 },
  { -2.5611278359589723e+108, 100, 8.3000000000000007, 0.0 },
  { 1.2481735250541195e+108, 100, 8.4000000000000021, 0.0 },
  { 1.6203702280499544e+109, 100, 8.5000000000000000, 0.0 },
  { 2.5386102824684747e+109, 100, 8.6000000000000014, 0.0 },
  { -3.8930624477368766e+109, 100, 8.6999999999999993, 0.0 },
  { -2.2669773300293168e+110, 100, 8.8000000000000007, 0.0 },
  { -2.6071876743327728e+110, 100, 8.9000000000000021, 0.0 },
  { 7.7294136683043515e+110, 100, 9.0000000000000000, 0.0 },
  { 3.3341330166544429e+111, 100, 9.1000000000000014, 0.0 },
  { 2.9686037583391038e+111, 100, 9.2000000000000028, 0.0 },
  { -1.3977488190034162e+112, 100, 9.3000000000000007, 0.0 },
  { -5.3374224541142660e+112, 100, 9.4000000000000021, 0.0 },
  { -4.2265051766934789e+112, 100, 9.5000000000000000, 0.0 },
  { 2.4904626130430740e+113, 100, 9.6000000000000014, 0.0 },
  { 9.4857435427573289e+113, 100, 9.7000000000000028, 0.0 },
  { 8.3761676654305186e+113, 100, 9.8000000000000007, 0.0 },
  { -4.4232904120312991e+114, 100, 9.9000000000000021, 0.0 },
  { -1.8738689223256612e+115, 100, 10.000000000000000, 0.0 },
};
const double toler008 = 2.5000000000000020e-13;
//  hermite

// Test data for n=8.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data009[9] =
{
  { 5324432.0000000000, 8, 4.0000000000000000, 0.0 },
  { 279702672.00000000, 8, 6.0000000000000000, 0.0 },
  { 3409634960.0000000, 8, 8.0000000000000000, 0.0 },
  { 22149057680.000000, 8, 10.000000000000000, 0.0 },
  { 99650305680.000000, 8, 12.000000000000000, 0.0 },
  { 1040259450512.0000, 8, 16.000000000000000, 0.0 },
  { 6326369025680.0000, 8, 20.000000000000000, 0.0 },
  { 9944083966401680.0, 8, 50.000000000000000, 0.0 },
  { 2.5564173438656015e+18, 8, 100.00000000000000, 0.0 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for n=18.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data010[9] =
{
  { 54268892282368.000, 18, 4.0000000000000000, 0.0 },
  { 1.3505976034605665e+18, 18, 6.0000000000000000, 0.0 },
  { 1.1719308290279925e+21, 18, 8.0000000000000000, 0.0 },
  { 1.1336099533194677e+23, 18, 10.000000000000000, 0.0 },
  { 3.9670688759298557e+24, 18, 12.000000000000000, 0.0 },
  { 9.0887304967960375e+26, 18, 16.000000000000000, 0.0 },
  { 5.6525959758874797e+28, 18, 20.000000000000000, 0.0 },
  { 9.6976497965812384e+35, 18, 50.000000000000000, 0.0 },
  { 2.6014460548774723e+41, 18, 100.00000000000000, 0.0 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for n=32.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data011[9] =
{
  { 3.4488006171532706e+25, 32, 4.0000000000000000, 0.0 },
  { 8.6646829675369123e+29, 32, 6.0000000000000000, 0.0 },
  { 1.2445939522057109e+36, 32, 8.0000000000000000, 0.0 },
  { 2.1381589300683108e+40, 32, 10.000000000000000, 0.0 },
  { 2.0979395756455302e+43, 32, 12.000000000000000, 0.0 },
  { 5.2024646069361253e+47, 32, 16.000000000000000, 0.0 },
  { 9.6759233738497726e+50, 32, 20.000000000000000, 0.0 },
  { 9.0500820467530134e+63, 32, 50.000000000000000, 0.0 },
  { 4.1896031916819710e+73, 32, 100.00000000000000, 0.0 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for n=50.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data012[9] =
{
  { -9.5599640670553907e+41, 50, 4.0000000000000000, 0.0 },
  { -1.4355266959903589e+47, 50, 6.0000000000000000, 0.0 },
  { 2.9492797132685063e+52, 50, 8.0000000000000000, 0.0 },
  { 1.3516643049819314e+61, 50, 10.000000000000000, 0.0 },
  { 5.1746552169783233e+66, 50, 12.000000000000000, 0.0 },
  { 1.2608506104917666e+74, 50, 16.000000000000000, 0.0 },
  { 2.4719364545684313e+79, 50, 20.000000000000000, 0.0 },
  { 7.8081628444405771e+99, 50, 50.000000000000000, 0.0 },
  { 1.0588500951956526e+115, 50, 100.00000000000000, 0.0 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for n=72.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data013[9] =
{
  { -5.0016344249093296e+65, 72, 4.0000000000000000, 0.0 },
  { 1.1604343420664594e+70, 72, 6.0000000000000000, 0.0 },
  { 1.1307673578364519e+76, 72, 8.0000000000000000, 0.0 },
  { -6.9227458950910379e+83, 72, 10.000000000000000, 0.0 },
  { 4.2761121656851757e+93, 72, 12.000000000000000, 0.0 },
  { 6.4057452391049260e+105, 72, 16.000000000000000, 0.0 },
  { 6.5532144335168848e+113, 72, 20.000000000000000, 0.0 },
  { 5.9536449994832570e+143, 72, 50.000000000000000, 0.0 },
  { 4.1539384208364770e+165, 72, 100.00000000000000, 0.0 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for n=128.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data014[9] =
{
  { 7.4843015969363893e+129, 128, 4.0000000000000000, 0.0 },
  { 1.9427207779012687e+134, 128, 6.0000000000000000, 0.0 },
  { -2.5332076374233721e+140, 128, 8.0000000000000000, 0.0 },
  { -3.6481920485874574e+146, 128, 10.000000000000000, 0.0 },
  { -6.6019131304361279e+157, 128, 12.000000000000000, 0.0 },
  { 1.7909969314519483e+182, 128, 16.000000000000000, 0.0 },
  { 4.6773285529590986e+199, 128, 20.000000000000000, 0.0 },
  { 1.8851953794407319e+255, 128, 50.000000000000000, 0.0 },
  { 2.2605490449873036e+294, 128, 100.00000000000000, 0.0 },
};
const double toler014 = 2.5000000000000020e-13;

// Divergence at n=200 x=50.000000000000000 f=-nan f_GSL=inf
// Divergence at n=200 x=100.00000000000000 f=-nan f_GSL=inf
// Divergence at n=200 x=100.00000000000000 f=-nan f_GSL=inf
// Test data for n=200.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hermite<double>
data015[7] =
{
  { -1.3224398396684072e+220, 200, 4.0000000000000000, 0.0 },
  { 2.8108557561597729e+224, 200, 6.0000000000000000, 0.0 },
  { 2.2034127668580903e+230, 200, 8.0000000000000000, 0.0 },
  { -4.7005387186273384e+238, 200, 10.000000000000000, 0.0 },
  { 6.8125674650192333e+247, 200, 12.000000000000000, 0.0 },
  { 2.8932855639383936e+272, 200, 16.000000000000000, 0.0 },
  { 9.8757526545830183e+303, 200, 20.000000000000000, 0.0 },
};
const double toler015 = 2.5000000000000020e-13;

// Divergence at n=1250 x=4.0000000000000000 f=-nan f_GSL=-inf
// Divergence at n=1250 x=6.0000000000000000 f=-nan f_GSL=inf
// Divergence at n=1250 x=8.0000000000000000 f=-nan f_GSL=inf
// ...
// Divergence at n=1250 x=100.00000000000000 f=-nan f_GSL=inf
// Divergence at n=5000 x=4.0000000000000000 f=-nan f_GSL=-inf
// Divergence at n=5000 x=6.0000000000000000 f=-nan f_GSL=-inf
// Divergence at n=5000 x=8.0000000000000000 f=-nan f_GSL=inf
// ...
// Divergence at n=5000 x=100.00000000000000 f=-nan f_GSL=inf
template<typename Ret, unsigned int Num>
  void
  test(const testcase_hermite<Ret> (&data)[Num], Ret toler)
  {
    bool test __attribute__((unused)) = true;
    const Ret eps = std::numeric_limits<Ret>::epsilon();
    Ret max_abs_diff = -Ret(1);
    Ret max_abs_frac = -Ret(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
      {
	const Ret f = std::hermite(data[i].n, data[i].x);
	const Ret f0 = data[i].f0;
	const Ret diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Ret(10) * eps
	 && std::abs(f) > Ret(10) * eps)
	  {
	    const Ret frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  return 0;
}
