from HMMEditingContext import *
import ghmm

# DISCRETE Model

alpha = ghmm.DNA

my_new_hmm = HMMEditingContext(alpha)
s1 = my_new_hmm.addState([0.1,0.3,0.6])
s2 = my_new_hmm.addState([0.1,0.3,0.6], initial=0.3)
s3 = my_new_hmm.addState() # uniform
t12 = my_new_hmm.addTransition(s1, s2)
t23 = my_new_hmm.addTransition(s2, s3, p= 0.1)
t31 = my_new_hmm.addTransition(s3, s1, p= 0.1)

hmm = my_new_hmm.finalize()


# Alternativ
c = HMMEditingContext(alpha)
c.addState([0.1,0.3,0.6])
c.addState([0.1,0.3,0.6], initial=0.3)
c.addState() # uniform
c.addTransition('1', '2')
c.addTransition('2', '3', p= 0.1)
c.addTransition('3', '1', p= 0.1)

hmm = c.finalize()
c.save('bla.xml')
print c

# Zugriffe auf Zust?nde: Object, id, name (possibly non-unique)


# HMM 
c = HMMEditingContext(hmm)
c['3'].emission = [0.1,0.3,0.6]

# doesn't work with python lists
#c['3'].emission = .5 * (c['2'].emission + [0.1,0.3,0.6])

c[('2','3')].p = 0.2
print c[(2,3)]
c[(2,3)].p = 0.1
print c[('2','3')]

c['3'].initial = 0.2
hmm = c.finalize()
print c

# delete state 3
del c[3]
# delete transition from state 1 to state 2
del c[(1,2)]
hmm = c.finalize()
print c

c = HMMEditingContext("test.xml")
hmm = c.finalize()
print "\n###############################\n"
print c
#print hmm.verbose_str()
print "\n###############################\n"

# CONTINOUS Model

c = HMMEditingContext(ghmm.Float())
c = HMMEditingContext(GaussianDistribution)

c.addState((0.0,1.0))
c.addState((0.1,0.3), initial=0.3)
c.addState() # uniform
c.addTransition('1', '2')
c.addTransition('3', '2', p= 0.1)

print c
c.finalize()
print c


c = HMMEditingContext(ghmm.Float())
c.addState(GaussianDistribution(0.0,1.0))

c = HMMEditingContext(GaussianMixtureDistribution)
c.addState(
    [
    (GaussianDistribution(0.0, 1.0), 0.1),
    (GaussianDistribution(1.0, 1.0), 0.3),
    (GaussianDistribution(2.0, 1.0), 0.6)
    ],
    initial = 0.1
    )
    
c = HMMEditingContext(ContinuousMixtureDistribution)
c.addState(
    [
    (GaussianDistribution(0.0, 1.0), 0.1),
    (LeftTruncGaussianDistribution(1.0, 1.0, trunc=.7), 0.3),
    (GaussianDistribution(2.0, 1.0), 0.6)
    ],
    initial = 0.1
    )
c.addState(
    [
    (UniformDistribution(-1, 1),     0.6),
    (GaussianDistribution(0.0, 1.0), 0.1),
    (GaussianDistribution(1.0, 1.0), 0.3),
    (GaussianDistribution(2.0, 1.0), 0.6)
    ],
    initial = 0.1
    )
c.addState(
    [
    (GaussianDistribution(2.0, 2.0), 0.1),
    (GaussianDistribution(1.0, 1.0), 0.3),
    (GaussianDistribution(2.0, 2.0), 0.6)
    ],
    initial = 0.9
    )
c.addTransition('1', '2')
c.addTransition('2', '3', p= 0.1)
c.addTransition('3', '1', p= 0.1)

print c
hmm = c.finalize()
print c
print hmm
