/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */


package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.util.Set;

/**
 * Assertion
 *
 *  A stateful session bean should not be injected into a servlet.
 *
 * @author bshankar@sun.com
 */
public class StatefulSessionBeanInjection extends WebTest implements WebCheck  {
    
    final static String className = StatefulSessionBeanInjection.class.getName();
    
    public Result check(WebBundleDescriptor descriptor) {
        // initialize the result object
        Result result = getInitializedResult();
        addWarningDetails(result,
                getVerifierContext().getComponentNameConstructor());
        result.setStatus(Result.PASSED); //default status is PASSED
        
        Set<EjbReferenceDescriptor> s = descriptor.getEjbReferenceDescriptors();
        if (s == null) return result;
        
        for(EjbReferenceDescriptor ejbRefDesc : s) {
            EjbDescriptor ejbDescriptor = ejbRefDesc.getEjbDescriptor();
            if (ejbDescriptor instanceof EjbSessionDescriptor) { // instaceof returns false if ejbDescriptor=null.
                String stateType = ((EjbSessionDescriptor)ejbDescriptor).getSessionType();
                if(EjbSessionDescriptor.STATEFUL.equals(stateType)) {
                    Set<InjectionTarget> injectionTargets = ejbRefDesc.getInjectionTargets();
                    if(injectionTargets != null) {
                        for(InjectionTarget it : injectionTargets) {
                            String itClassName = it.getClassName();
                            result.warning(smh.getLocalString(className + ".warning",
                                    "Found a stateful session bean [ {0} ] injected into [ {1} ].",
                                    new Object[]{ejbDescriptor.getEjbClassName(), itClassName}));
                        }
                    }
                }
            }
        }
        return result;
    }
    
}
