------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2006 Maxim Reznik                                         --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  DB Change notification Example.
--  Working only with Oracle 10.2 and later.

--  $Id: subscr2.adb,v 1.2 2007/06/20 06:56:21 vagul Exp $

with Ada.Text_IO;
with Ada.Command_Line;

with Change_Subscriber;

with OCI.Thick.Statements;
with OCI.Thick.Connections;

procedure Subscr2 is

   use OCI.Thick.Statements;
   use OCI.Thick.Connections;
   use Change_Subscriber;
   use Ada.Text_IO;

   Connect  : Connection;
   Consumer : Subscriber_Type;
   Query    : Statement;

begin
   Put_Line ("=========");

   if Ada.Command_Line.Argument_Count = 1 then
      Connect := Logon (Ada.Command_Line.Argument (1));
   else
      Connect := Logon ("scott/tiger");
   end if;

   Create (Consumer, Need_Rowids => True);

   Query := Prepare (Connect, "select * from acct");

   Register (Consumer, Connect);

   Associate (Consumer, Query);

   delay 30.0;

   Unregister (Consumer);
end Subscr2;
