/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// SecurityGroupEntitiesRequest struct for SecurityGroupEntitiesRequest
type SecurityGroupEntitiesRequest struct {
	Rules *FirewallRules `json:"rules,omitempty"`
}

// NewSecurityGroupEntitiesRequest instantiates a new SecurityGroupEntitiesRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSecurityGroupEntitiesRequest() *SecurityGroupEntitiesRequest {
	this := SecurityGroupEntitiesRequest{}

	return &this
}

// NewSecurityGroupEntitiesRequestWithDefaults instantiates a new SecurityGroupEntitiesRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSecurityGroupEntitiesRequestWithDefaults() *SecurityGroupEntitiesRequest {
	this := SecurityGroupEntitiesRequest{}
	return &this
}

// GetRules returns the Rules field value
// If the value is explicit nil, nil is returned
func (o *SecurityGroupEntitiesRequest) GetRules() *FirewallRules {
	if o == nil {
		return nil
	}

	return o.Rules

}

// GetRulesOk returns a tuple with the Rules field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SecurityGroupEntitiesRequest) GetRulesOk() (*FirewallRules, bool) {
	if o == nil {
		return nil, false
	}

	return o.Rules, true
}

// SetRules sets field value
func (o *SecurityGroupEntitiesRequest) SetRules(v FirewallRules) {

	o.Rules = &v

}

// HasRules returns a boolean if a field has been set.
func (o *SecurityGroupEntitiesRequest) HasRules() bool {
	if o != nil && o.Rules != nil {
		return true
	}

	return false
}

func (o SecurityGroupEntitiesRequest) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Rules != nil {
		toSerialize["rules"] = o.Rules
	}

	return json.Marshal(toSerialize)
}

type NullableSecurityGroupEntitiesRequest struct {
	value *SecurityGroupEntitiesRequest
	isSet bool
}

func (v NullableSecurityGroupEntitiesRequest) Get() *SecurityGroupEntitiesRequest {
	return v.value
}

func (v *NullableSecurityGroupEntitiesRequest) Set(val *SecurityGroupEntitiesRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableSecurityGroupEntitiesRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableSecurityGroupEntitiesRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSecurityGroupEntitiesRequest(val *SecurityGroupEntitiesRequest) *NullableSecurityGroupEntitiesRequest {
	return &NullableSecurityGroupEntitiesRequest{value: val, isSet: true}
}

func (v NullableSecurityGroupEntitiesRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSecurityGroupEntitiesRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
