% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script_file.R
\name{script_file}
\alias{script_file}
\alias{script_path}
\title{Determine the directory or full path to the currently executing script}
\usage{
script_file(fail = c("stop", "warning", "quiet"))

script_path(fail = c("stop", "warning", "quiet"))
}
\arguments{
\item{fail}{character, one of "stop", "warning", "quiet". specifying what
 should be done when the script path cannot be determined:
 "stop" causes an error to be generated,
 "warn" generates a warning message and returns NA,
 "quiet" silently returns NA.

These function should work with \code{Rscript}, \code{source()},
\code{Rmarkdown} \code{RStudio}'s "Run selection", and the \code{RStudio}
Console.}
}
\value{
A character scalar containing the full path to the currently
  executing script file (\code{script_file}) or its directory
  (\code{script_path}).  If unable to determine the script path, it generates
  a warning and returns \code{""} (empty string).
}
\description{
Determine the directory or full path to the currently executing script
}
\section{Functions}{
\itemize{
\item \code{script_file()}: Determine the full path of the currently executing
script

\item \code{script_path()}: Determine the directory of the currently executing script

}}
\examples{

getwd()
commandArgs(trailingOnly = FALSE)

script_file("warning")
script_path("warning")
}
\author{
Greg Warnes \email{greg@warnes.net} based on on a Stack Overflow post by
  jerry-t (\url{https://stackoverflow.com/users/2292993/jerry-t}) at
  \url{https://stackoverflow.com/a/36777602/2744062}.
}
