/* Generated by re2c 0.14.3 */
#line 1 "zend_language_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2017 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner.h"
#include "zend_language_scanner_defs.h"
#include "zend_language_parser.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
//ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
//ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

/*
static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}
*/


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(on_event) = NULL;
}

ZEND_API void zend_lex_tstring(zval *zv)
{
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char*)SCNG(yy_text), SCNG(yy_leng));
}

void zend_stop_lexing(void)
{
	if (LANG_SCNG(on_event)) {
		LANG_SCNG(on_event)(ON_STOP, END, 0, LANG_SCNG(on_event_context));
	}

	LANG_SCNG(yy_cursor) = LANG_SCNG(yy_limit);
}

ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}



// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) ZVAL_STRINGL(zendlval, yytext, yyleng)

static int zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'r':
					*t++ = '\r';
					Z_STRLEN_P(zendlval)--;
					break;
				case 't':
					*t++ = '\t';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'f':
					*t++ = '\f';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'v':
					*t++ = '\v';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					Z_STRLEN_P(zendlval)--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						Z_STRLEN_P(zendlval)--; /* for the 'x' */

						hex_buf[0] = *(++s);
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;
						size_t byte_len = 0;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							byte_len = 1;
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							byte_len = 2;
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							byte_len = 3;
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							byte_len = 4;
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}

						Z_STRLEN_P(zendlval) -= 2; /* \u */
						Z_STRLEN_P(zendlval) -= (len - byte_len);
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								Z_STRLEN_P(zendlval)--;
							}
						}
						if (octal_buf[2] &&
						    (octal_buf[0] > '3')) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

static zend_always_inline int emit_token(int token, int token_line)
{
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, token_line, SCNG(on_event_context));
	}

	return token;
}

#define RETURN_TOKEN(token) return emit_token(token, start_line);

int lex_scan(zval *zendlval)
{

int start_line = CG(zend_lineno);

restart:
	SCNG(yy_text) = YYCURSOR;


#line 468 "zend_language_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 7) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				goto yyc_ST_VAR_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 8) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 9) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(1, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych != '<') goto yy5;
	YYDEBUG(3, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '?') goto yy6;
yy4:
	YYDEBUG(4, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1161 "zend_language_scanner.l"
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */

				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_INLINE_HTML);
}
#line 566 "zend_language_scanner.c"
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy4;
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy8;
	} else {
		if (yych <= 'P') goto yy10;
		if (yych == 'p') goto yy10;
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1152 "zend_language_scanner.l"
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
#line 593 "zend_language_scanner.c"
yy8:
	YYDEBUG(8, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(9, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1139 "zend_language_scanner.l"
	{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
#line 604 "zend_language_scanner.c"
yy10:
	YYDEBUG(10, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy12;
	if (yych == 'h') goto yy12;
yy11:
	YYDEBUG(11, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy7;
yy12:
	YYDEBUG(12, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy13;
	if (yych != 'p') goto yy11;
yy13:
	YYDEBUG(13, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy11;
		if (yych >= '\v') goto yy11;
	} else {
		if (yych <= '\r') goto yy16;
		if (yych != ' ') goto yy11;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	++YYCURSOR;
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1145 "zend_language_scanner.l"
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_OPEN_TAG);
}
#line 641 "zend_language_scanner.c"
yy16:
	YYDEBUG(16, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '\n') goto yy14;
	goto yy15;
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(17, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy24;
		} else {
			if (yych <= '`') goto yy22;
			if (yych == '{') goto yy21;
			goto yy24;
		}
		YYDEBUG(19, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy20;
			if (yych <= 'Z') goto yy27;
			if (yych >= '_') goto yy27;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy27;
			} else {
				if (yych <= '{') goto yy30;
				if (yych >= 0x80) goto yy27;
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1574 "zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`');
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 752 "zend_language_scanner.c"
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy25;
		goto yy20;
yy22:
		YYDEBUG(22, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(23, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1518 "zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
#line 768 "zend_language_scanner.c"
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy20;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1505 "zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 785 "zend_language_scanner.c"
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy27;
		}
		if (yych == '-') goto yy32;
		if (yych <= '@') goto yy29;
		if (yych <= '[') goto yy34;
yy29:
		YYDEBUG(29, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1226 "zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 807 "zend_language_scanner.c"
yy30:
		YYDEBUG(30, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(31, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 944 "zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 818 "zend_language_scanner.c"
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy36;
yy33:
		YYDEBUG(33, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy29;
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(35, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1219 "zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 839 "zend_language_scanner.c"
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy33;
			if (yych <= 'Z') goto yy37;
			if (yych <= '^') goto yy33;
		} else {
			if (yych <= '`') goto yy33;
			if (yych <= 'z') goto yy37;
			if (yych <= 0x7F) goto yy33;
		}
yy37:
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(38, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1210 "zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 864 "zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(39, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy44;
			goto yy46;
		} else {
			if (yych <= '$') goto yy41;
			if (yych == '{') goto yy43;
			goto yy46;
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy42;
			if (yych <= 'Z') goto yy49;
			if (yych >= '_') goto yy49;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy49;
			} else {
				if (yych <= '{') goto yy52;
				if (yych >= 0x80) goto yy49;
			}
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1524 "zend_language_scanner.l"
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"');
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 981 "zend_language_scanner.c"
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy47;
		goto yy42;
yy44:
		YYDEBUG(44, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(45, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1513 "zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
#line 997 "zend_language_scanner.c"
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy42;
yy47:
		YYDEBUG(47, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(48, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1505 "zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 1014 "zend_language_scanner.c"
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(50, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy49;
		}
		if (yych == '-') goto yy54;
		if (yych <= '@') goto yy51;
		if (yych <= '[') goto yy56;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1226 "zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1036 "zend_language_scanner.c"
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(53, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 944 "zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 1047 "zend_language_scanner.c"
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy58;
yy55:
		YYDEBUG(55, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy51;
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(57, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1219 "zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1068 "zend_language_scanner.c"
yy58:
		YYDEBUG(58, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy55;
			if (yych <= 'Z') goto yy59;
			if (yych <= '^') goto yy55;
		} else {
			if (yych <= '`') goto yy55;
			if (yych <= 'z') goto yy59;
			if (yych <= 0x7F) goto yy55;
		}
yy59:
		YYDEBUG(59, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(60, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1210 "zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1093 "zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(61, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(63, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(64, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1491 "zend_language_scanner.l"
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
#line 1117 "zend_language_scanner.c"
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(65, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy67;
		if (yych == '{') goto yy69;
		goto yy70;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy68;
			if (yych <= 'Z') goto yy73;
			if (yych >= '_') goto yy73;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy73;
			} else {
				if (yych <= '{') goto yy76;
				if (yych >= 0x80) goto yy73;
			}
		}
yy68:
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1616 "zend_language_scanner.l"
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0);
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 1252 "zend_language_scanner.c"
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy71;
		goto yy68;
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy68;
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(72, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1505 "zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 1274 "zend_language_scanner.c"
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy73;
		}
		if (yych == '-') goto yy78;
		if (yych <= '@') goto yy75;
		if (yych <= '[') goto yy80;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1226 "zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1296 "zend_language_scanner.c"
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 944 "zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 1307 "zend_language_scanner.c"
yy78:
		YYDEBUG(78, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy82;
yy79:
		YYDEBUG(79, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy75;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1219 "zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1328 "zend_language_scanner.c"
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy79;
			if (yych <= 'Z') goto yy83;
			if (yych <= '^') goto yy79;
		} else {
			if (yych <= '`') goto yy79;
			if (yych <= 'z') goto yy83;
			if (yych <= 0x7F) goto yy79;
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1210 "zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1353 "zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 60,  60,  44,  44,  44,  44,  44,  44, 
			 44,  44,   0,   0,   0,   0,   0,   0, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   0, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
		};
		YYDEBUG(85, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\v':
		case '\f':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy148;
		case '\t':
		case '\n':
		case '\r':
		case ' ':	goto yy104;
		case '!':	goto yy119;
		case '"':	goto yy144;
		case '#':	goto yy140;
		case '$':	goto yy130;
		case '%':	goto yy124;
		case '&':	goto yy125;
		case '\'':	goto yy142;
		case '(':	goto yy113;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy131;
		case '*':	goto yy122;
		case '+':	goto yy118;
		case '-':	goto yy102;
		case '.':	goto yy109;
		case '/':	goto yy123;
		case '0':	goto yy136;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy138;
		case ':':	goto yy106;
		case '<':	goto yy120;
		case '=':	goto yy116;
		case '>':	goto yy121;
		case '?':	goto yy110;
		case 'A':
		case 'a':	goto yy97;
		case 'B':
		case 'b':	goto yy99;
		case 'C':
		case 'c':	goto yy91;
		case 'D':
		case 'd':	goto yy89;
		case 'E':
		case 'e':	goto yy87;
		case 'F':
		case 'f':	goto yy90;
		case 'G':
		case 'g':	goto yy100;
		case 'I':
		case 'i':	goto yy95;
		case 'L':
		case 'l':	goto yy117;
		case 'N':
		case 'n':	goto yy111;
		case 'O':
		case 'o':	goto yy128;
		case 'P':
		case 'p':	goto yy101;
		case 'R':
		case 'r':	goto yy92;
		case 'S':
		case 's':	goto yy98;
		case 'T':
		case 't':	goto yy94;
		case 'U':
		case 'u':	goto yy114;
		case 'V':
		case 'v':	goto yy112;
		case 'W':
		case 'w':	goto yy96;
		case 'X':
		case 'x':	goto yy129;
		case 'Y':
		case 'y':	goto yy93;
		case '\\':	goto yy107;
		case '^':	goto yy127;
		case '_':	goto yy115;
		case '`':	goto yy146;
		case '{':	goto yy132;
		case '|':	goto yy126;
		case '}':	goto yy134;
		default:	goto yy139;
		}
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(-1, yych);
		switch ((yych = *YYCURSOR)) {
		case 'C':
		case 'c':	goto yy706;
		case 'L':
		case 'l':	goto yy707;
		case 'M':
		case 'm':	goto yy708;
		case 'N':
		case 'n':	goto yy709;
		case 'V':
		case 'v':	goto yy710;
		case 'X':
		case 'x':	goto yy711;
		default:	goto yy151;
		}
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1249 "zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_STRING);
}
#line 1542 "zend_language_scanner.c"
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy688;
				goto yy151;
			} else {
				if (yych <= 'I') goto yy689;
				if (yych <= 'N') goto yy151;
				goto yy690;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy688;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy689;
				if (yych == 'o') goto yy690;
				goto yy151;
			}
		}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'N') {
				if (yych == 'I') goto yy664;
				goto yy151;
			} else {
				if (yych <= 'O') goto yy665;
				if (yych <= 'T') goto yy151;
				goto yy666;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy664;
				goto yy151;
			} else {
				if (yych <= 'o') goto yy665;
				if (yych == 'u') goto yy666;
				goto yy151;
			}
		}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy629;
				goto yy151;
			} else {
				if (yych <= 'L') goto yy630;
				if (yych <= 'N') goto yy151;
				goto yy631;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy629;
				goto yy151;
			} else {
				if (yych <= 'l') goto yy630;
				if (yych == 'o') goto yy631;
				goto yy151;
			}
		}
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy611;
		if (yych == 'e') goto yy611;
		goto yy151;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy598;
		if (yych == 'i') goto yy598;
		goto yy151;
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy586;
			if (yych <= 'Q') goto yy151;
			goto yy587;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy151;
				goto yy586;
			} else {
				if (yych == 'r') goto yy587;
				goto yy151;
			}
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy533;
				goto yy151;
			} else {
				if (yych <= 'M') goto yy535;
				if (yych <= 'N') goto yy536;
				if (yych <= 'R') goto yy151;
				goto yy537;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy533;
				if (yych <= 'l') goto yy151;
				goto yy535;
			} else {
				if (yych <= 'n') goto yy536;
				if (yych == 's') goto yy537;
				goto yy151;
			}
		}
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy528;
		if (yych == 'h') goto yy528;
		goto yy151;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy510;
				goto yy151;
			} else {
				if (yych <= 'N') goto yy511;
				if (yych <= 'Q') goto yy151;
				if (yych <= 'R') goto yy512;
				goto yy513;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy510;
				if (yych <= 'm') goto yy151;
				goto yy511;
			} else {
				if (yych <= 'q') goto yy151;
				if (yych <= 'r') goto yy512;
				if (yych <= 's') goto yy513;
				goto yy151;
			}
		}
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy498;
			if (yych <= 'V') goto yy151;
			goto yy499;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy151;
				goto yy498;
			} else {
				if (yych == 'w') goto yy499;
				goto yy151;
			}
		}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy151;
				goto yy490;
			} else {
				if (yych == '\'') goto yy491;
				goto yy151;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy489;
				if (yych <= 'Q') goto yy151;
				goto yy492;
			} else {
				if (yych == 'r') goto yy492;
				goto yy151;
			}
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy479;
			if (yych <= 'N') goto yy151;
			goto yy480;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy151;
				goto yy479;
			} else {
				if (yych == 'o') goto yy480;
				goto yy151;
			}
		}
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy455;
			if (yych <= 'T') goto yy151;
			goto yy456;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy151;
				goto yy455;
			} else {
				if (yych == 'u') goto yy456;
				goto yy151;
			}
		}
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy451;
		} else {
			if (yych <= '=') goto yy449;
			if (yych <= '>') goto yy453;
		}
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 933 "zend_language_scanner.l"
		{
	RETURN_TOKEN(yytext[0]);
}
#line 1778 "zend_language_scanner.c"
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy448;
yy105:
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 648 "zend_language_scanner.l"
		{
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_WHITESPACE);
}
#line 1792 "zend_language_scanner.c"
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy445;
		goto yy103;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 673 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
#line 1807 "zend_language_scanner.c"
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy442;
			goto yy103;
		} else {
			if (yych <= '9') goto yy438;
			if (yych == '=') goto yy440;
			goto yy103;
		}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '=') goto yy103;
		if (yych <= '>') goto yy432;
		if (yych <= '?') goto yy434;
		goto yy103;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy420;
			if (yych <= 'D') goto yy151;
			goto yy421;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy151;
				goto yy420;
			} else {
				if (yych == 'e') goto yy421;
				goto yy151;
			}
		}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy417;
		if (yych == 'a') goto yy417;
		goto yy151;
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy342;
					if (yych <= 0x1F) goto yy103;
					goto yy342;
				} else {
					if (yych <= '@') goto yy103;
					if (yych == 'C') goto yy103;
					goto yy342;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy342;
					if (yych <= 'H') goto yy103;
					goto yy342;
				} else {
					if (yych == 'O') goto yy342;
					if (yych <= 'Q') goto yy103;
					goto yy342;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy342;
					if (yych <= '`') goto yy103;
					goto yy342;
				} else {
					if (yych == 'd') goto yy342;
					if (yych <= 'e') goto yy103;
					goto yy342;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy342;
					if (yych <= 'n') goto yy103;
					goto yy342;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy103;
						goto yy342;
					} else {
						if (yych == 'u') goto yy342;
						goto yy103;
					}
				}
			}
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy333;
			if (yych <= 'R') goto yy151;
			goto yy334;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy151;
				goto yy333;
			} else {
				if (yych == 's') goto yy334;
				goto yy151;
			}
		}
yy115:
		YYDEBUG(115, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy251;
		goto yy151;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy103;
		if (yych <= '=') goto yy245;
		if (yych <= '>') goto yy247;
		goto yy103;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy241;
		if (yych == 'i') goto yy241;
		goto yy151;
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy239;
		if (yych == '=') goto yy237;
		goto yy103;
yy119:
		YYDEBUG(119, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy234;
		goto yy103;
yy120:
		YYDEBUG(120, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy103;
		if (yych <= '<') goto yy210;
		if (yych <= '=') goto yy212;
		if (yych <= '>') goto yy214;
		goto yy103;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy103;
		if (yych <= '=') goto yy206;
		if (yych <= '>') goto yy204;
		goto yy103;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy198;
		if (yych == '=') goto yy200;
		goto yy103;
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy190;
			goto yy103;
		} else {
			if (yych <= '/') goto yy192;
			if (yych == '=') goto yy193;
			goto yy103;
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy188;
		goto yy103;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy184;
		if (yych == '=') goto yy186;
		goto yy103;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy182;
		if (yych == '|') goto yy180;
		goto yy103;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy178;
		goto yy103;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy176;
		if (yych == 'r') goto yy176;
		goto yy151;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy173;
		if (yych == 'o') goto yy173;
		goto yy151;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy103;
			if (yych <= 'Z') goto yy170;
			if (yych <= '^') goto yy103;
			goto yy170;
		} else {
			if (yych <= '`') goto yy103;
			if (yych <= 'z') goto yy170;
			if (yych <= 0x7F) goto yy103;
			goto yy170;
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy103;
yy132:
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(133, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 938 "zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN('{');
}
#line 2041 "zend_language_scanner.c"
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 950 "zend_language_scanner.l"
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_TOKEN('}');
}
#line 2055 "zend_language_scanner.c"
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '9') {
				if (yych == '.') goto yy152;
				if (yych >= '0') goto yy155;
			} else {
				if (yych == 'B') goto yy163;
				if (yych >= 'E') goto yy157;
			}
		} else {
			if (yych <= 'b') {
				if (yych == 'X') goto yy162;
				if (yych >= 'b') goto yy163;
			} else {
				if (yych <= 'e') {
					if (yych >= 'e') goto yy157;
				} else {
					if (yych == 'x') goto yy162;
				}
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1003 "zend_language_scanner.l"
		{
	char *end;
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		/* This isn't an assert, we need to ensure 019 isn't valid octal
		 * Because the lexing itself doesn't do that for us
		 */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			RETURN_TOKEN(T_LNUMBER);
		}
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (yytext[0] == '0') { /* octal overflow */
				errno = 0;
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(yytext, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(yytext, (const char **)&end));
			}
			/* Also not an assert for the same reason */
			if (end != yytext + yyleng) {
				zend_throw_exception(zend_ce_parse_error,
					"Invalid numeric literal", 0);
				ZVAL_UNDEF(zendlval);
				RETURN_TOKEN(T_DNUMBER);
			}
			ZEND_ASSERT(!errno);
			RETURN_TOKEN(T_DNUMBER);
		}
		/* Also not an assert for the same reason */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			RETURN_TOKEN(T_DNUMBER);
		}
	}
	ZEND_ASSERT(!errno);
	RETURN_TOKEN(T_LNUMBER);
}
#line 2128 "zend_language_scanner.c"
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy152;
			if (yych <= '/') goto yy137;
			goto yy155;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy137;
				goto yy157;
			} else {
				if (yych == 'e') goto yy157;
				goto yy137;
			}
		}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy151;
yy140:
		YYDEBUG(140, *YYCURSOR);
		++YYCURSOR;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1255 "zend_language_scanner.l"
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	RETURN_TOKEN(T_COMMENT);
}
#line 2185 "zend_language_scanner.c"
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1326 "zend_language_scanner.l"
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		ZVAL_STRINGL(zendlval, str, sz);
	}
	RETURN_TOKEN(T_CONSTANT_ENCAPSED_STRING);
}
#line 2260 "zend_language_scanner.c"
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1395 "zend_language_scanner.l"
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"');
				RETURN_TOKEN(T_CONSTANT_ENCAPSED_STRING);
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
#line 2308 "zend_language_scanner.c"
yy146:
		YYDEBUG(146, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(147, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1485 "zend_language_scanner.l"
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
#line 2319 "zend_language_scanner.c"
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1747 "zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 2334 "zend_language_scanner.c"
yy150:
		YYDEBUG(150, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy151:
		YYDEBUG(151, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy150;
		}
		goto yy88;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(153, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy152;
		}
		if (yych == 'E') goto yy157;
		if (yych == 'e') goto yy157;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1097 "zend_language_scanner.l"
		{
	const char *end;

	ZVAL_DOUBLE(zendlval, zend_strtod(yytext, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == yytext + yyleng);
	RETURN_TOKEN(T_DNUMBER);
}
#line 2370 "zend_language_scanner.c"
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(156, *YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy152;
			if (yych <= '/') goto yy137;
			goto yy155;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy137;
			} else {
				if (yych != 'e') goto yy137;
			}
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy159;
		} else {
			if (yych <= '-') goto yy159;
			if (yych <= '/') goto yy158;
			if (yych <= '9') goto yy160;
		}
yy158:
		YYDEBUG(158, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy88;
				} else {
					goto yy103;
				}
			} else {
				if (yyaccept == 2) {
					goto yy137;
				} else {
					goto yy154;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy191;
				} else {
					goto yy211;
				}
			} else {
				goto yy602;
			}
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy158;
		if (yych >= ':') goto yy158;
yy160:
		YYDEBUG(160, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(161, *YYCURSOR);
		if (yych <= '/') goto yy154;
		if (yych <= '9') goto yy160;
		goto yy154;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy167;
		}
		goto yy158;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy164;
		}
		goto yy158;
yy164:
		YYDEBUG(164, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(165, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy164;
		}
		YYDEBUG(166, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 975 "zend_language_scanner.l"
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == yytext + yyleng);
		}
		RETURN_TOKEN(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == yytext + yyleng);
		RETURN_TOKEN(T_DNUMBER);
	}
}
#line 2494 "zend_language_scanner.c"
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(168, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy167;
		}
		YYDEBUG(169, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1048 "zend_language_scanner.l"
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		RETURN_TOKEN(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		RETURN_TOKEN(T_DNUMBER);
	}
}
#line 2534 "zend_language_scanner.c"
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(171, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy170;
			} else {
				if (yych <= '@') goto yy172;
				if (yych <= 'Z') goto yy170;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy170;
			} else {
				if (yych <= 'z') goto yy170;
				if (yych >= 0x80) goto yy170;
			}
		}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1226 "zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 2564 "zend_language_scanner.c"
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy174;
		if (yych != 'r') goto yy151;
yy174:
		YYDEBUG(174, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(175, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 921 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_XOR);
}
#line 2582 "zend_language_scanner.c"
yy176:
		YYDEBUG(176, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(177, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 913 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_OR);
}
#line 2595 "zend_language_scanner.c"
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 901 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
#line 2605 "zend_language_scanner.c"
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 905 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
#line 2615 "zend_language_scanner.c"
yy182:
		YYDEBUG(182, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(183, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 897 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
#line 2625 "zend_language_scanner.c"
yy184:
		YYDEBUG(184, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(185, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 909 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
#line 2635 "zend_language_scanner.c"
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 893 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
#line 2645 "zend_language_scanner.c"
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 881 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
#line 2655 "zend_language_scanner.c"
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy195;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1284 "zend_language_scanner.l"
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_TOKEN(T_DOC_COMMENT);
	}

	RETURN_TOKEN(T_COMMENT);
}
#line 2697 "zend_language_scanner.c"
yy192:
		YYDEBUG(192, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy141;
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 873 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
#line 2711 "zend_language_scanner.c"
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy196;
		}
		goto yy158;
yy196:
		YYDEBUG(196, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(197, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy196;
		}
		goto yy191;
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy202;
		YYDEBUG(199, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 865 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_POW);
}
#line 2739 "zend_language_scanner.c"
yy200:
		YYDEBUG(200, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(201, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 861 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
#line 2749 "zend_language_scanner.c"
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(203, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 869 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
#line 2759 "zend_language_scanner.c"
yy204:
		YYDEBUG(204, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy208;
		YYDEBUG(205, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 929 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SR);
}
#line 2770 "zend_language_scanner.c"
yy206:
		YYDEBUG(206, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(207, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 849 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
#line 2780 "zend_language_scanner.c"
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(209, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 889 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
#line 2790 "zend_language_scanner.c"
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy211;
		if (yych <= '<') goto yy220;
		if (yych <= '=') goto yy218;
yy211:
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 925 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SL);
}
#line 2805 "zend_language_scanner.c"
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy216;
		YYDEBUG(213, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 845 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
#line 2816 "zend_language_scanner.c"
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
yy215:
		YYDEBUG(215, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 837 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
#line 2827 "zend_language_scanner.c"
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 841 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SPACESHIP);
}
#line 2837 "zend_language_scanner.c"
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(219, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 885 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
#line 2847 "zend_language_scanner.c"
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy220;
		}
		if (yych <= 'Z') {
			if (yych <= '&') {
				if (yych == '"') goto yy225;
				goto yy158;
			} else {
				if (yych <= '\'') goto yy224;
				if (yych <= '@') goto yy158;
			}
		} else {
			if (yych <= '`') {
				if (yych != '_') goto yy158;
			} else {
				if (yych <= 'z') goto yy222;
				if (yych <= 0x7F) goto yy158;
			}
		}
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy229;
				goto yy158;
			} else {
				if (yych <= '\r') goto yy231;
				if (yych <= '/') goto yy158;
				if (yych <= '9') goto yy222;
				goto yy158;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy222;
				if (yych <= '^') goto yy158;
				goto yy222;
			} else {
				if (yych <= '`') goto yy158;
				if (yych <= 'z') goto yy222;
				if (yych <= 0x7F) goto yy158;
				goto yy222;
			}
		}
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy158;
		if (yych <= '/') goto yy233;
		if (yych <= '9') goto yy158;
		goto yy233;
yy225:
		YYDEBUG(225, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy158;
		if (yych <= '/') goto yy227;
		if (yych <= '9') goto yy158;
		goto yy227;
yy226:
		YYDEBUG(226, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy227:
		YYDEBUG(227, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych != '"') goto yy158;
			} else {
				if (yych <= '9') goto yy226;
				if (yych <= '@') goto yy158;
				goto yy226;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy226;
				goto yy158;
			} else {
				if (yych <= 'z') goto yy226;
				if (yych <= 0x7F) goto yy158;
				goto yy226;
			}
		}
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy229;
		if (yych == '\r') goto yy231;
		goto yy158;
yy229:
		YYDEBUG(229, *YYCURSOR);
		++YYCURSOR;
yy230:
		YYDEBUG(230, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1437 "zend_language_scanner.l"
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	RETURN_TOKEN(T_START_HEREDOC);
}
#line 2999 "zend_language_scanner.c"
yy231:
		YYDEBUG(231, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy229;
		goto yy230;
yy232:
		YYDEBUG(232, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy233:
		YYDEBUG(233, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy228;
				goto yy158;
			} else {
				if (yych <= '9') goto yy232;
				if (yych <= '@') goto yy158;
				goto yy232;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy232;
				goto yy158;
			} else {
				if (yych <= 'z') goto yy232;
				if (yych <= 0x7F) goto yy158;
				goto yy232;
			}
		}
yy234:
		YYDEBUG(234, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy215;
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 829 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
#line 3043 "zend_language_scanner.c"
yy237:
		YYDEBUG(237, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 853 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
#line 3053 "zend_language_scanner.c"
yy239:
		YYDEBUG(239, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(240, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 817 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INC);
}
#line 3063 "zend_language_scanner.c"
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy242;
		if (yych != 's') goto yy151;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy243;
		if (yych != 't') goto yy151;
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 805 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LIST);
}
#line 3086 "zend_language_scanner.c"
yy245:
		YYDEBUG(245, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy249;
		YYDEBUG(246, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 833 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
#line 3097 "zend_language_scanner.c"
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(248, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 801 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
#line 3107 "zend_language_scanner.c"
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 825 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
#line 3117 "zend_language_scanner.c"
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'C':
		case 'c':	goto yy253;
		case 'D':
		case 'd':	goto yy258;
		case 'F':
		case 'f':	goto yy255;
		case 'H':
		case 'h':	goto yy252;
		case 'L':
		case 'l':	goto yy257;
		case 'M':
		case 'm':	goto yy256;
		case 'N':
		case 'n':	goto yy259;
		case 'T':
		case 't':	goto yy254;
		default:	goto yy151;
		}
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy320;
		if (yych == 'a') goto yy320;
		goto yy151;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy313;
		if (yych == 'l') goto yy313;
		goto yy151;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy306;
		if (yych == 'r') goto yy306;
		goto yy151;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy290;
			if (yych <= 'T') goto yy151;
			goto yy291;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy151;
				goto yy290;
			} else {
				if (yych == 'u') goto yy291;
				goto yy151;
			}
		}
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy282;
		if (yych == 'e') goto yy282;
		goto yy151;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy276;
		if (yych == 'i') goto yy276;
		goto yy151;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy271;
		if (yych == 'i') goto yy271;
		goto yy151;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy260;
		if (yych != 'a') goto yy151;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy261;
		if (yych != 'm') goto yy151;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy262;
		if (yych != 'e') goto yy151;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy263;
		if (yych != 's') goto yy151;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy264;
		if (yych != 'p') goto yy151;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy265;
		if (yych != 'a') goto yy151;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy266;
		if (yych != 'c') goto yy151;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy267;
		if (yych != 'e') goto yy151;
yy267:
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(268, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(269, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(270, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1134 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NS_C);
}
#line 3251 "zend_language_scanner.c"
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy272;
		if (yych != 'r') goto yy151;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(273, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(274, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(275, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1130 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DIR);
}
#line 3275 "zend_language_scanner.c"
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy277;
		if (yych != 'n') goto yy151;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy278;
		if (yych != 'e') goto yy151;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(280, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(281, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1122 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LINE);
}
#line 3304 "zend_language_scanner.c"
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy283;
		if (yych != 't') goto yy151;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy284;
		if (yych != 'h') goto yy151;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy285;
		if (yych != 'o') goto yy151;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy286;
		if (yych != 'd') goto yy151;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(288, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(289, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1118 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_METHOD_C);
}
#line 3343 "zend_language_scanner.c"
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy301;
		if (yych == 'l') goto yy301;
		goto yy151;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy292;
		if (yych != 'n') goto yy151;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy293;
		if (yych != 'c') goto yy151;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy294;
		if (yych != 't') goto yy151;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy295;
		if (yych != 'i') goto yy151;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy296;
		if (yych != 'o') goto yy151;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy297;
		if (yych != 'n') goto yy151;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(298, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(299, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(300, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1114 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FUNC_C);
}
#line 3398 "zend_language_scanner.c"
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy302;
		if (yych != 'e') goto yy151;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(304, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(305, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1126 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FILE);
}
#line 3422 "zend_language_scanner.c"
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy307;
		if (yych != 'a') goto yy151;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy308;
		if (yych != 'i') goto yy151;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy309;
		if (yych != 't') goto yy151;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(311, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(312, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1110 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRAIT_C);
}
#line 3456 "zend_language_scanner.c"
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy314;
		if (yych != 'a') goto yy151;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy315;
		if (yych != 's') goto yy151;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy316;
		if (yych != 's') goto yy151;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(318, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(319, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1106 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLASS_C);
}
#line 3490 "zend_language_scanner.c"
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy321;
		if (yych != 'l') goto yy151;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy322;
		if (yych != 't') goto yy151;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy324;
		if (yych != 'c') goto yy151;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy325;
		if (yych != 'o') goto yy151;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy326;
		if (yych != 'm') goto yy151;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy327;
		if (yych != 'p') goto yy151;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy328;
		if (yych != 'i') goto yy151;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy329;
		if (yych != 'l') goto yy151;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy330;
		if (yych != 'e') goto yy151;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy331;
		if (yych != 'r') goto yy151;
yy331:
		YYDEBUG(331, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(332, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 769 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_HALT_COMPILER);
}
#line 3556 "zend_language_scanner.c"
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy337;
		if (yych == 's') goto yy337;
		goto yy151;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy335;
		if (yych != 'e') goto yy151;
yy335:
		YYDEBUG(335, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(336, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 749 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_USE);
}
#line 3580 "zend_language_scanner.c"
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy338;
		if (yych != 'e') goto yy151;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy339;
		if (yych != 't') goto yy151;
yy339:
		YYDEBUG(339, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(340, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 797 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_UNSET);
}
#line 3603 "zend_language_scanner.c"
yy341:
		YYDEBUG(341, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy342:
		YYDEBUG(342, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy341;
					if (yych <= 0x1F) goto yy158;
					goto yy341;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy158;
						goto yy346;
					} else {
						if (yych <= 'B') goto yy344;
						if (yych <= 'C') goto yy158;
						goto yy349;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy350;
					if (yych <= 'H') goto yy158;
					goto yy351;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy158;
						goto yy345;
					} else {
						if (yych <= 'Q') goto yy158;
						if (yych <= 'R') goto yy348;
						goto yy347;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy343;
					if (yych <= '`') goto yy158;
					goto yy346;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy344;
						goto yy158;
					} else {
						if (yych <= 'd') goto yy349;
						if (yych <= 'e') goto yy158;
						goto yy350;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy158;
						goto yy351;
					} else {
						if (yych == 'o') goto yy345;
						goto yy158;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy348;
						goto yy347;
					} else {
						if (yych != 'u') goto yy158;
					}
				}
			}
		}
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy410;
		if (yych == 'n') goto yy410;
		goto yy158;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy397;
			if (yych <= 'N') goto yy158;
			goto yy398;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy158;
				goto yy397;
			} else {
				if (yych == 'o') goto yy398;
				goto yy158;
			}
		}
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy389;
		if (yych == 'b') goto yy389;
		goto yy158;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy382;
		if (yych == 'r') goto yy382;
		goto yy158;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy374;
		if (yych == 't') goto yy374;
		goto yy158;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy372;
		if (yych == 'e') goto yy372;
		goto yy158;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy368;
		if (yych == 'o') goto yy368;
		goto yy158;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy361;
		if (yych == 'l') goto yy361;
		goto yy158;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy352;
		if (yych != 'n') goto yy158;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy353;
		if (yych != 't') goto yy158;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy354;
		if (yych != 'e') goto yy356;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy359;
		if (yych == 'g') goto yy359;
		goto yy158;
yy355:
		YYDEBUG(355, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy356:
		YYDEBUG(356, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy355;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy355;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(357, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(358, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 697 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INT_CAST);
}
#line 3779 "zend_language_scanner.c"
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy360;
		if (yych != 'e') goto yy158;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy355;
		if (yych == 'r') goto yy355;
		goto yy158;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy362;
		if (yych != 'o') goto yy158;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy363;
		if (yych != 'a') goto yy158;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy364;
		if (yych != 't') goto yy158;
yy364:
		YYDEBUG(364, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(365, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy364;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy364;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(366, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(367, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 701 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
#line 3827 "zend_language_scanner.c"
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy369;
		if (yych != 'u') goto yy158;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy370;
		if (yych != 'b') goto yy158;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy371;
		if (yych != 'l') goto yy158;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy364;
		if (yych == 'e') goto yy364;
		goto yy158;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy373;
		if (yych != 'a') goto yy158;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy364;
		if (yych == 'l') goto yy364;
		goto yy158;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy375;
		if (yych != 'r') goto yy158;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy376;
		if (yych != 'i') goto yy158;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy377;
		if (yych != 'n') goto yy158;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy378;
		if (yych != 'g') goto yy158;
yy378:
		YYDEBUG(378, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(379, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy378;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy378;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(380, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(381, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 705 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_STRING_CAST);
}
#line 3901 "zend_language_scanner.c"
yy382:
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy383;
		if (yych != 'r') goto yy158;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy384;
		if (yych != 'a') goto yy158;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy385;
		if (yych != 'y') goto yy158;
yy385:
		YYDEBUG(385, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(386, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy385;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy385;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(387, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(388, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 709 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
#line 3938 "zend_language_scanner.c"
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy390;
		if (yych != 'j') goto yy158;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy391;
		if (yych != 'e') goto yy158;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy392;
		if (yych != 'c') goto yy158;
yy392:
		YYDEBUG(392, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy393;
		if (yych != 't') goto yy158;
yy393:
		YYDEBUG(393, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(394, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy393;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy393;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(395, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(396, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 713 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
#line 3980 "zend_language_scanner.c"
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy407;
		if (yych == 'n') goto yy407;
		goto yy158;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy399;
		if (yych != 'o') goto yy158;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy400;
		if (yych != 'l') goto yy158;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy405;
		if (yych == 'e') goto yy405;
		goto yy402;
yy401:
		YYDEBUG(401, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy402:
		YYDEBUG(402, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy401;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy401;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(403, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(404, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 717 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
#line 4025 "zend_language_scanner.c"
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy406;
		if (yych != 'a') goto yy158;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy401;
		if (yych == 'n') goto yy401;
		goto yy158;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy408;
		if (yych != 'a') goto yy158;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy409;
		if (yych != 'r') goto yy158;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy378;
		if (yych == 'y') goto yy378;
		goto yy158;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy411;
		if (yych != 's') goto yy158;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy412;
		if (yych != 'e') goto yy158;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy413;
		if (yych != 't') goto yy158;
yy413:
		YYDEBUG(413, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(414, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy413;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy413;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(415, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(416, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 721 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
#line 4089 "zend_language_scanner.c"
yy417:
		YYDEBUG(417, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy418;
		if (yych != 'r') goto yy151;
yy418:
		YYDEBUG(418, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(419, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 693 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_VAR);
}
#line 4107 "zend_language_scanner.c"
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy424;
		if (yych == 'm') goto yy424;
		goto yy151;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy422;
		if (yych != 'w') goto yy151;
yy422:
		YYDEBUG(422, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(423, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 685 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NEW);
}
#line 4131 "zend_language_scanner.c"
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy425;
		if (yych != 'e') goto yy151;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy426;
		if (yych != 's') goto yy151;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy427;
		if (yych != 'p') goto yy151;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy428;
		if (yych != 'a') goto yy151;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy429;
		if (yych != 'c') goto yy151;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy430;
		if (yych != 'e') goto yy151;
yy430:
		YYDEBUG(430, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(431, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 745 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NAMESPACE);
}
#line 4174 "zend_language_scanner.c"
yy432:
		YYDEBUG(432, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy436;
		if (yych == '\r') goto yy437;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1317 "zend_language_scanner.l"
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	RETURN_TOKEN(T_CLOSE_TAG);  /* implicit ';' at php-end tag */
}
#line 4191 "zend_language_scanner.c"
yy434:
		YYDEBUG(434, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(435, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 681 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_COALESCE);
}
#line 4201 "zend_language_scanner.c"
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy433;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy436;
		goto yy433;
yy438:
		YYDEBUG(438, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(439, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy154;
			if (yych <= '9') goto yy438;
			goto yy154;
		} else {
			if (yych <= 'E') goto yy157;
			if (yych == 'e') goto yy157;
			goto yy154;
		}
yy440:
		YYDEBUG(440, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(441, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 877 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
#line 4236 "zend_language_scanner.c"
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '.') goto yy158;
		YYDEBUG(443, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(444, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 677 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
#line 4249 "zend_language_scanner.c"
yy445:
		YYDEBUG(445, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(446, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 669 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
#line 4259 "zend_language_scanner.c"
yy447:
		YYDEBUG(447, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy448:
		YYDEBUG(448, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy105;
			if (yych <= '\n') goto yy447;
			goto yy105;
		} else {
			if (yych <= '\r') goto yy447;
			if (yych == ' ') goto yy447;
			goto yy105;
		}
yy449:
		YYDEBUG(449, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(450, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 857 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
#line 4285 "zend_language_scanner.c"
yy451:
		YYDEBUG(451, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(452, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 821 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DEC);
}
#line 4295 "zend_language_scanner.c"
yy453:
		YYDEBUG(453, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(454, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 643 "zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
#line 4306 "zend_language_scanner.c"
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy462;
			if (yych <= 'N') goto yy151;
			goto yy463;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy151;
				goto yy462;
			} else {
				if (yych == 'o') goto yy463;
				goto yy151;
			}
		}
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy457;
		if (yych != 'b') goto yy151;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy458;
		if (yych != 'l') goto yy151;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy459;
		if (yych != 'i') goto yy151;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy460;
		if (yych != 'c') goto yy151;
yy460:
		YYDEBUG(460, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(461, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 793 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PUBLIC);
}
#line 4355 "zend_language_scanner.c"
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy471;
			if (yych <= 'U') goto yy151;
			goto yy472;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy151;
				goto yy471;
			} else {
				if (yych == 'v') goto yy472;
				goto yy151;
			}
		}
yy463:
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy464;
		if (yych != 't') goto yy151;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy465;
		if (yych != 'e') goto yy151;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy466;
		if (yych != 'c') goto yy151;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy467;
		if (yych != 't') goto yy151;
yy467:
		YYDEBUG(467, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy468;
		if (yych != 'e') goto yy151;
yy468:
		YYDEBUG(468, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy469;
		if (yych != 'd') goto yy151;
yy469:
		YYDEBUG(469, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(470, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 789 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PROTECTED);
}
#line 4414 "zend_language_scanner.c"
yy471:
		YYDEBUG(471, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy477;
		if (yych == 't') goto yy477;
		goto yy151;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy473;
		if (yych != 'a') goto yy151;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy474;
		if (yych != 't') goto yy151;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy475;
		if (yych != 'e') goto yy151;
yy475:
		YYDEBUG(475, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(476, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 785 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PRIVATE);
}
#line 4448 "zend_language_scanner.c"
yy477:
		YYDEBUG(477, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(478, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 619 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PRINT);
}
#line 4461 "zend_language_scanner.c"
yy479:
		YYDEBUG(479, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy484;
		if (yych == 'o') goto yy484;
		goto yy151;
yy480:
		YYDEBUG(480, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy481;
		if (yych != 't') goto yy151;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy482;
		if (yych != 'o') goto yy151;
yy482:
		YYDEBUG(482, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(483, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 611 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_GOTO);
}
#line 4490 "zend_language_scanner.c"
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy485;
		if (yych != 'b') goto yy151;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy486;
		if (yych != 'a') goto yy151;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy487;
		if (yych != 'l') goto yy151;
yy487:
		YYDEBUG(487, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(488, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 757 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_GLOBAL);
}
#line 4518 "zend_language_scanner.c"
yy489:
		YYDEBUG(489, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy497;
		goto yy158;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy145;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy143;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy493;
		if (yych != 'e') goto yy151;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy494;
		if (yych != 'a') goto yy151;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy495;
		if (yych != 'k') goto yy151;
yy495:
		YYDEBUG(495, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(496, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 603 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BREAK);
}
#line 4559 "zend_language_scanner.c"
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy220;
		goto yy158;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy505;
		if (yych == 'a') goto yy505;
		goto yy151;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy500;
		if (yych != 'i') goto yy151;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy501;
		if (yych != 't') goto yy151;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy502;
		if (yych != 'c') goto yy151;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy503;
		if (yych != 'h') goto yy151;
yy503:
		YYDEBUG(503, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(504, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 587 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SWITCH);
}
#line 4603 "zend_language_scanner.c"
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy506;
		if (yych != 't') goto yy151;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy507;
		if (yych != 'i') goto yy151;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy508;
		if (yych != 'c') goto yy151;
yy508:
		YYDEBUG(508, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(509, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 773 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_STATIC);
}
#line 4631 "zend_language_scanner.c"
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy521;
		if (yych == 's') goto yy521;
		goto yy151;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy519;
		if (yych == 'd') goto yy519;
		goto yy151;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy515;
		if (yych == 'r') goto yy515;
		goto yy151;
yy513:
		YYDEBUG(513, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(514, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 583 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_AS);
}
#line 4662 "zend_language_scanner.c"
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy516;
		if (yych != 'a') goto yy151;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy517;
		if (yych != 'y') goto yy151;
yy517:
		YYDEBUG(517, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(518, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 809 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ARRAY);
}
#line 4685 "zend_language_scanner.c"
yy519:
		YYDEBUG(519, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(520, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 917 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_AND);
}
#line 4698 "zend_language_scanner.c"
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy522;
		if (yych != 't') goto yy151;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy523;
		if (yych != 'r') goto yy151;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy524;
		if (yych != 'a') goto yy151;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy525;
		if (yych != 'c') goto yy151;
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy526;
		if (yych != 't') goto yy151;
yy526:
		YYDEBUG(526, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(527, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 777 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ABSTRACT);
}
#line 4736 "zend_language_scanner.c"
yy528:
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy529;
		if (yych != 'i') goto yy151;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy530;
		if (yych != 'l') goto yy151;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy531;
		if (yych != 'e') goto yy151;
yy531:
		YYDEBUG(531, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(532, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 543 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_WHILE);
}
#line 4764 "zend_language_scanner.c"
yy533:
		YYDEBUG(533, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(534, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 527 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IF);
}
#line 4777 "zend_language_scanner.c"
yy535:
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy577;
		if (yych == 'p') goto yy577;
		goto yy151;
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy151;
				goto yy544;
			} else {
				if (yych <= 'R') goto yy151;
				if (yych <= 'S') goto yy542;
				goto yy543;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy544;
				goto yy151;
			} else {
				if (yych <= 's') goto yy542;
				if (yych <= 't') goto yy543;
				goto yy151;
			}
		}
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy538;
		if (yych != 's') goto yy151;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy539;
		if (yych != 'e') goto yy151;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy540;
		if (yych != 't') goto yy151;
yy540:
		YYDEBUG(540, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(541, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 761 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ISSET);
}
#line 4833 "zend_language_scanner.c"
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy563;
		if (yych == 't') goto yy563;
		goto yy151;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy556;
		if (yych == 'e') goto yy556;
		goto yy151;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy545;
		if (yych != 'l') goto yy151;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy546;
		if (yych != 'u') goto yy151;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy547;
		if (yych != 'd') goto yy151;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy548;
		if (yych != 'e') goto yy151;
yy548:
		YYDEBUG(548, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy150;
			} else {
				if (yych <= '@') goto yy549;
				if (yych <= 'Z') goto yy150;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy550;
			} else {
				if (yych <= 'z') goto yy150;
				if (yych >= 0x80) goto yy150;
			}
		}
yy549:
		YYDEBUG(549, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 729 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INCLUDE);
}
#line 4891 "zend_language_scanner.c"
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy551;
		if (yych != 'o') goto yy151;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy552;
		if (yych != 'n') goto yy151;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy553;
		if (yych != 'c') goto yy151;
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy554;
		if (yych != 'e') goto yy151;
yy554:
		YYDEBUG(554, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(555, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 733 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INCLUDE_ONCE);
}
#line 4924 "zend_language_scanner.c"
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy557;
		if (yych != 'r') goto yy151;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy558;
		if (yych != 'f') goto yy151;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy559;
		if (yych != 'a') goto yy151;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy560;
		if (yych != 'c') goto yy151;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy561;
		if (yych != 'e') goto yy151;
yy561:
		YYDEBUG(561, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(562, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 627 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INTERFACE);
}
#line 4962 "zend_language_scanner.c"
yy563:
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy564;
			if (yych <= 'D') goto yy151;
			goto yy565;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy151;
			} else {
				if (yych == 'e') goto yy565;
				goto yy151;
			}
		}
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy571;
		if (yych == 'n') goto yy571;
		goto yy151;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy566;
		if (yych != 'a') goto yy151;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy567;
		if (yych != 'd') goto yy151;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy568;
		if (yych != 'o') goto yy151;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy569;
		if (yych != 'f') goto yy151;
yy569:
		YYDEBUG(569, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(570, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 753 "zend_language_scanner.l"
		{
    RETURN_TOKEN(T_INSTEADOF);
}
#line 5016 "zend_language_scanner.c"
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy572;
		if (yych != 'c') goto yy151;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy573;
		if (yych != 'e') goto yy151;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy574;
		if (yych != 'o') goto yy151;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy575;
		if (yych != 'f') goto yy151;
yy575:
		YYDEBUG(575, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(576, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 579 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INSTANCEOF);
}
#line 5049 "zend_language_scanner.c"
yy577:
		YYDEBUG(577, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy578;
		if (yych != 'l') goto yy151;
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy579;
		if (yych != 'e') goto yy151;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy580;
		if (yych != 'm') goto yy151;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy581;
		if (yych != 'e') goto yy151;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy582;
		if (yych != 'n') goto yy151;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy583;
		if (yych != 't') goto yy151;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy584;
		if (yych != 's') goto yy151;
yy584:
		YYDEBUG(584, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(585, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 639 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IMPLEMENTS);
}
#line 5097 "zend_language_scanner.c"
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy594;
		if (yych == 'r') goto yy594;
		goto yy151;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'Y') {
			if (yych == 'A') goto yy590;
			if (yych <= 'X') goto yy151;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy151;
				goto yy590;
			} else {
				if (yych != 'y') goto yy151;
			}
		}
		YYDEBUG(588, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(589, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 511 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRY);
}
#line 5129 "zend_language_scanner.c"
yy590:
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy591;
		if (yych != 'i') goto yy151;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy592;
		if (yych != 't') goto yy151;
yy592:
		YYDEBUG(592, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(593, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 631 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRAIT);
}
#line 5152 "zend_language_scanner.c"
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy595;
		if (yych != 'o') goto yy151;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy596;
		if (yych != 'w') goto yy151;
yy596:
		YYDEBUG(596, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(597, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 523 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_THROW);
}
#line 5175 "zend_language_scanner.c"
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy599;
		if (yych != 'e') goto yy151;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy600;
		if (yych != 'l') goto yy151;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy601;
		if (yych != 'd') goto yy151;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy150;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy602;
			if (yych <= '\n') goto yy603;
		} else {
			if (yych <= '\r') goto yy603;
			if (yych == ' ') goto yy603;
		}
yy602:
		YYDEBUG(602, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 507 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_YIELD);
}
#line 5212 "zend_language_scanner.c"
yy603:
		YYDEBUG(603, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(604, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy158;
				goto yy603;
			} else {
				if (yych == '\r') goto yy603;
				goto yy158;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy603;
				if (yych <= 'E') goto yy158;
			} else {
				if (yych != 'f') goto yy158;
			}
		}
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy606;
		if (yych != 'r') goto yy158;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy607;
		if (yych != 'o') goto yy158;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy608;
		if (yych != 'm') goto yy158;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy158;
			} else {
				if (yych <= '@') goto yy609;
				if (yych <= 'Z') goto yy158;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy158;
			} else {
				if (yych <= 'z') goto yy158;
				if (yych >= 0x80) goto yy158;
			}
		}
yy609:
		YYDEBUG(609, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(610, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 501 "zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_YIELD_FROM);
}
#line 5278 "zend_language_scanner.c"
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy613;
			if (yych <= 'S') goto yy151;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy151;
				goto yy613;
			} else {
				if (yych != 't') goto yy151;
			}
		}
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy625;
		if (yych == 'u') goto yy625;
		goto yy151;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy614;
		if (yych != 'u') goto yy151;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy615;
		if (yych != 'i') goto yy151;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy616;
		if (yych != 'r') goto yy151;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy617;
		if (yych != 'e') goto yy151;
yy617:
		YYDEBUG(617, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy150;
			} else {
				if (yych <= '@') goto yy618;
				if (yych <= 'Z') goto yy150;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy619;
			} else {
				if (yych <= 'z') goto yy150;
				if (yych >= 0x80) goto yy150;
			}
		}
yy618:
		YYDEBUG(618, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 737 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_REQUIRE);
}
#line 5343 "zend_language_scanner.c"
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy620;
		if (yych != 'o') goto yy151;
yy620:
		YYDEBUG(620, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy621;
		if (yych != 'n') goto yy151;
yy621:
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy622;
		if (yych != 'c') goto yy151;
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy623;
		if (yych != 'e') goto yy151;
yy623:
		YYDEBUG(623, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(624, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 741 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_REQUIRE_ONCE);
}
#line 5376 "zend_language_scanner.c"
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy626;
		if (yych != 'r') goto yy151;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy627;
		if (yych != 'n') goto yy151;
yy627:
		YYDEBUG(627, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(628, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 497 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_RETURN);
}
#line 5399 "zend_language_scanner.c"
yy629:
		YYDEBUG(629, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy151;
				goto yy652;
			} else {
				if (yych <= 'R') goto yy151;
				if (yych <= 'S') goto yy651;
				goto yy650;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy652;
				goto yy151;
			} else {
				if (yych <= 's') goto yy651;
				if (yych <= 't') goto yy650;
				goto yy151;
			}
		}
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy642;
			if (yych <= 'N') goto yy151;
			goto yy643;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy151;
				goto yy642;
			} else {
				if (yych == 'o') goto yy643;
				goto yy151;
			}
		}
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy632;
		if (yych != 'n') goto yy151;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy151;
			if (yych >= 'T') goto yy634;
		} else {
			if (yych <= 'r') goto yy151;
			if (yych <= 's') goto yy633;
			if (yych <= 't') goto yy634;
			goto yy151;
		}
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy640;
		if (yych == 't') goto yy640;
		goto yy151;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy635;
		if (yych != 'i') goto yy151;
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy636;
		if (yych != 'n') goto yy151;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy637;
		if (yych != 'u') goto yy151;
yy637:
		YYDEBUG(637, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy638;
		if (yych != 'e') goto yy151;
yy638:
		YYDEBUG(638, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(639, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 607 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONTINUE);
}
#line 5493 "zend_language_scanner.c"
yy640:
		YYDEBUG(640, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(641, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 493 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONST);
}
#line 5506 "zend_language_scanner.c"
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy647;
		if (yych == 's') goto yy647;
		goto yy151;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy644;
		if (yych != 'n') goto yy151;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy645;
		if (yych != 'e') goto yy151;
yy645:
		YYDEBUG(645, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(646, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 689 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLONE);
}
#line 5535 "zend_language_scanner.c"
yy647:
		YYDEBUG(647, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy648;
		if (yych != 's') goto yy151;
yy648:
		YYDEBUG(648, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(649, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 623 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLASS);
}
#line 5553 "zend_language_scanner.c"
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy661;
		if (yych == 'c') goto yy661;
		goto yy151;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy659;
		if (yych == 'e') goto yy659;
		goto yy151;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy653;
		if (yych != 'l') goto yy151;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy654;
		if (yych != 'a') goto yy151;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy655;
		if (yych != 'b') goto yy151;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy656;
		if (yych != 'l') goto yy151;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy657;
		if (yych != 'e') goto yy151;
yy657:
		YYDEBUG(657, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(658, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 813 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CALLABLE);
}
#line 5603 "zend_language_scanner.c"
yy659:
		YYDEBUG(659, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(660, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 595 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CASE);
}
#line 5616 "zend_language_scanner.c"
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy662;
		if (yych != 'h') goto yy151;
yy662:
		YYDEBUG(662, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(663, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 515 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CATCH);
}
#line 5634 "zend_language_scanner.c"
yy664:
		YYDEBUG(664, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy681;
		if (yych == 'n') goto yy681;
		goto yy151;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy674;
		if (yych == 'r') goto yy674;
		goto yy151;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy667;
		if (yych != 'n') goto yy151;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy668;
		if (yych != 'c') goto yy151;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy669;
		if (yych != 't') goto yy151;
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy670;
		if (yych != 'i') goto yy151;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy671;
		if (yych != 'o') goto yy151;
yy671:
		YYDEBUG(671, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy672;
		if (yych != 'n') goto yy151;
yy672:
		YYDEBUG(672, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(673, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 489 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FUNCTION);
}
#line 5689 "zend_language_scanner.c"
yy674:
		YYDEBUG(674, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy675;
				if (yych <= '9') goto yy150;
			} else {
				if (yych == 'E') goto yy676;
				if (yych <= 'Z') goto yy150;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy150;
			} else {
				if (yych <= 'e') goto yy676;
				if (yych <= 'z') goto yy150;
				if (yych >= 0x80) goto yy150;
			}
		}
yy675:
		YYDEBUG(675, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 555 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FOR);
}
#line 5717 "zend_language_scanner.c"
yy676:
		YYDEBUG(676, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy677;
		if (yych != 'a') goto yy151;
yy677:
		YYDEBUG(677, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy678;
		if (yych != 'c') goto yy151;
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy679;
		if (yych != 'h') goto yy151;
yy679:
		YYDEBUG(679, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(680, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 563 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FOREACH);
}
#line 5745 "zend_language_scanner.c"
yy681:
		YYDEBUG(681, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy682;
		if (yych != 'a') goto yy151;
yy682:
		YYDEBUG(682, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy683;
		if (yych != 'l') goto yy151;
yy683:
		YYDEBUG(683, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy684;
				if (yych <= '9') goto yy150;
			} else {
				if (yych == 'L') goto yy685;
				if (yych <= 'Z') goto yy150;
			}
		} else {
			if (yych <= 'k') {
				if (yych != '`') goto yy150;
			} else {
				if (yych <= 'l') goto yy685;
				if (yych <= 'z') goto yy150;
				if (yych >= 0x80) goto yy150;
			}
		}
yy684:
		YYDEBUG(684, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 781 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FINAL);
}
#line 5783 "zend_language_scanner.c"
yy685:
		YYDEBUG(685, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy686;
		if (yych != 'y') goto yy151;
yy686:
		YYDEBUG(686, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(687, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 519 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FINALLY);
}
#line 5801 "zend_language_scanner.c"
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy694;
			if (yych <= 'E') goto yy151;
			goto yy695;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy151;
				goto yy694;
			} else {
				if (yych == 'f') goto yy695;
				goto yy151;
			}
		}
yy689:
		YYDEBUG(689, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy692;
		if (yych == 'e') goto yy692;
		goto yy151;
yy690:
		YYDEBUG(690, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(691, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 551 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DO);
}
#line 5836 "zend_language_scanner.c"
yy692:
		YYDEBUG(692, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(693, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 485 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXIT);
}
#line 5849 "zend_language_scanner.c"
yy694:
		YYDEBUG(694, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy701;
		if (yych == 'l') goto yy701;
		goto yy151;
yy695:
		YYDEBUG(695, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy696;
		if (yych != 'a') goto yy151;
yy696:
		YYDEBUG(696, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy697;
		if (yych != 'u') goto yy151;
yy697:
		YYDEBUG(697, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy698;
		if (yych != 'l') goto yy151;
yy698:
		YYDEBUG(698, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy699;
		if (yych != 't') goto yy151;
yy699:
		YYDEBUG(699, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(700, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 599 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DEFAULT);
}
#line 5888 "zend_language_scanner.c"
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy702;
		if (yych != 'a') goto yy151;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy703;
		if (yych != 'r') goto yy151;
yy703:
		YYDEBUG(703, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy704;
		if (yych != 'e') goto yy151;
yy704:
		YYDEBUG(704, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(705, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 571 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DECLARE);
}
#line 5916 "zend_language_scanner.c"
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy768;
		if (yych == 'h') goto yy768;
		goto yy151;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy762;
		if (yych == 's') goto yy762;
		goto yy151;
yy708:
		YYDEBUG(708, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy758;
		if (yych == 'p') goto yy758;
		goto yy151;
yy709:
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy724;
		if (yych == 'd') goto yy724;
		goto yy151;
yy710:
		YYDEBUG(710, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy721;
		if (yych == 'a') goto yy721;
		goto yy151;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy712;
			if (yych <= 'S') goto yy151;
			goto yy713;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy151;
			} else {
				if (yych == 't') goto yy713;
				goto yy151;
			}
		}
yy712:
		YYDEBUG(712, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy719;
		if (yych == 't') goto yy719;
		goto yy151;
yy713:
		YYDEBUG(713, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy714;
		if (yych != 'e') goto yy151;
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy715;
		if (yych != 'n') goto yy151;
yy715:
		YYDEBUG(715, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy716;
		if (yych != 'd') goto yy151;
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy717;
		if (yych != 's') goto yy151;
yy717:
		YYDEBUG(717, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 635 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXTENDS);
}
#line 6000 "zend_language_scanner.c"
yy719:
		YYDEBUG(719, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(720, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 481 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXIT);
}
#line 6013 "zend_language_scanner.c"
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy722;
		if (yych != 'l') goto yy151;
yy722:
		YYDEBUG(722, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(723, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 725 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EVAL);
}
#line 6031 "zend_language_scanner.c"
yy724:
		YYDEBUG(724, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'D':
		case 'd':	goto yy725;
		case 'F':
		case 'f':	goto yy726;
		case 'I':
		case 'i':	goto yy727;
		case 'S':
		case 's':	goto yy728;
		case 'W':
		case 'w':	goto yy729;
		default:	goto yy151;
		}
yy725:
		YYDEBUG(725, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy751;
		if (yych == 'e') goto yy751;
		goto yy151;
yy726:
		YYDEBUG(726, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy743;
		if (yych == 'o') goto yy743;
		goto yy151;
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy741;
		if (yych == 'f') goto yy741;
		goto yy151;
yy728:
		YYDEBUG(728, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy735;
		if (yych == 'w') goto yy735;
		goto yy151;
yy729:
		YYDEBUG(729, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy730;
		if (yych != 'h') goto yy151;
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy731;
		if (yych != 'i') goto yy151;
yy731:
		YYDEBUG(731, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy732;
		if (yych != 'l') goto yy151;
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy733;
		if (yych != 'e') goto yy151;
yy733:
		YYDEBUG(733, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(734, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 547 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDWHILE);
}
#line 6105 "zend_language_scanner.c"
yy735:
		YYDEBUG(735, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy736;
		if (yych != 'i') goto yy151;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy737;
		if (yych != 't') goto yy151;
yy737:
		YYDEBUG(737, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy738;
		if (yych != 'c') goto yy151;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy739;
		if (yych != 'h') goto yy151;
yy739:
		YYDEBUG(739, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(740, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 591 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDSWITCH);
}
#line 6138 "zend_language_scanner.c"
yy741:
		YYDEBUG(741, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(742, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 535 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDIF);
}
#line 6151 "zend_language_scanner.c"
yy743:
		YYDEBUG(743, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy744;
		if (yych != 'r') goto yy151;
yy744:
		YYDEBUG(744, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy745;
				if (yych <= '9') goto yy150;
			} else {
				if (yych == 'E') goto yy746;
				if (yych <= 'Z') goto yy150;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy150;
			} else {
				if (yych <= 'e') goto yy746;
				if (yych <= 'z') goto yy150;
				if (yych >= 0x80) goto yy150;
			}
		}
yy745:
		YYDEBUG(745, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 559 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDFOR);
}
#line 6184 "zend_language_scanner.c"
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy747;
		if (yych != 'a') goto yy151;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy748;
		if (yych != 'c') goto yy151;
yy748:
		YYDEBUG(748, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy749;
		if (yych != 'h') goto yy151;
yy749:
		YYDEBUG(749, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(750, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 567 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDFOREACH);
}
#line 6212 "zend_language_scanner.c"
yy751:
		YYDEBUG(751, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy752;
		if (yych != 'c') goto yy151;
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy753;
		if (yych != 'l') goto yy151;
yy753:
		YYDEBUG(753, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy754;
		if (yych != 'a') goto yy151;
yy754:
		YYDEBUG(754, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy755;
		if (yych != 'r') goto yy151;
yy755:
		YYDEBUG(755, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy756;
		if (yych != 'e') goto yy151;
yy756:
		YYDEBUG(756, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(757, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 575 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDDECLARE);
}
#line 6250 "zend_language_scanner.c"
yy758:
		YYDEBUG(758, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy759;
		if (yych != 't') goto yy151;
yy759:
		YYDEBUG(759, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy760;
		if (yych != 'y') goto yy151;
yy760:
		YYDEBUG(760, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(761, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 765 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EMPTY);
}
#line 6273 "zend_language_scanner.c"
yy762:
		YYDEBUG(762, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy763;
		if (yych != 'e') goto yy151;
yy763:
		YYDEBUG(763, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy764;
				if (yych <= '9') goto yy150;
			} else {
				if (yych == 'I') goto yy765;
				if (yych <= 'Z') goto yy150;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy150;
			} else {
				if (yych <= 'i') goto yy765;
				if (yych <= 'z') goto yy150;
				if (yych >= 0x80) goto yy150;
			}
		}
yy764:
		YYDEBUG(764, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 539 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELSE);
}
#line 6306 "zend_language_scanner.c"
yy765:
		YYDEBUG(765, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy766;
		if (yych != 'f') goto yy151;
yy766:
		YYDEBUG(766, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(767, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 531 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELSEIF);
}
#line 6324 "zend_language_scanner.c"
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy769;
		if (yych != 'o') goto yy151;
yy769:
		YYDEBUG(769, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(770, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 615 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ECHO);
}
#line 6342 "zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(771, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy779;
				if (yych <= '\n') goto yy773;
				if (yych <= '\f') goto yy779;
			} else {
				if (yych == ' ') goto yy773;
				if (yych <= ',') goto yy779;
				goto yy775;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy779;
				if (yych <= 'Z') goto yy777;
				if (yych <= '^') goto yy779;
				goto yy777;
			} else {
				if (yych <= '`') goto yy779;
				if (yych <= 'z') goto yy777;
				if (yych <= 0x7F) goto yy779;
				goto yy777;
			}
		}
yy773:
		YYDEBUG(773, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy785;
yy774:
		YYDEBUG(774, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 648 "zend_language_scanner.l"
		{
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_WHITESPACE);
}
#line 6420 "zend_language_scanner.c"
yy775:
		YYDEBUG(775, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy782;
yy776:
		YYDEBUG(776, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 663 "zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
#line 6434 "zend_language_scanner.c"
yy777:
		YYDEBUG(777, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy781;
yy778:
		YYDEBUG(778, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 657 "zend_language_scanner.l"
		{
	yy_pop_state();
	zend_copy_value(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_STRING);
}
#line 6449 "zend_language_scanner.c"
yy779:
		YYDEBUG(779, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy776;
yy780:
		YYDEBUG(780, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy781:
		YYDEBUG(781, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy780;
		}
		goto yy778;
yy782:
		YYDEBUG(782, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(783, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 653 "zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
#line 6474 "zend_language_scanner.c"
yy784:
		YYDEBUG(784, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy785:
		YYDEBUG(785, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy784;
		}
		goto yy774;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(786, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy790;
			if (yych <= 'Z') goto yy788;
			if (yych <= '^') goto yy790;
		} else {
			if (yych <= '`') goto yy790;
			if (yych <= 'z') goto yy788;
			if (yych <= 0x7F) goto yy790;
		}
yy788:
		YYDEBUG(788, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy789;
				if (yych <= '9') goto yy792;
			} else {
				if (yych <= '[') goto yy792;
				if (yych >= '_') goto yy792;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy789;
				if (yych <= 'z') goto yy792;
			} else {
				if (yych <= '}') goto yy792;
				if (yych >= 0x80) goto yy792;
			}
		}
yy789:
		YYDEBUG(789, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 968 "zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
#line 6567 "zend_language_scanner.c"
yy790:
		YYDEBUG(790, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy789;
yy791:
		YYDEBUG(791, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy792:
		YYDEBUG(792, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy791;
		}
		if (yych <= '@') goto yy793;
		if (yych <= '[') goto yy794;
		if (yych == '}') goto yy794;
yy793:
		YYDEBUG(793, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy789;
yy794:
		YYDEBUG(794, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(795, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 959 "zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_STRING_VARNAME);
}
#line 6602 "zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(796, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(798, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(799, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1690 "zend_language_scanner.l"
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 6669 "zend_language_scanner.c"
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 112, 112, 112, 112, 112, 112, 
			112, 112,   0,   0,   0,   0,   0,   0, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(800, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy814;
					if (yych <= '\n') goto yy810;
					goto yy814;
				} else {
					if (yych <= '\r') goto yy810;
					if (yych <= 0x1F) goto yy814;
					goto yy810;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy809;
					if (yych <= '#') goto yy810;
					goto yy805;
				} else {
					if (yych == '\'') goto yy810;
					if (yych <= '/') goto yy809;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy804;
					if (yych <= '@') goto yy809;
					goto yy812;
				} else {
					if (yych <= '[') goto yy809;
					if (yych <= '\\') goto yy810;
					goto yy807;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy812;
					goto yy809;
				} else {
					if (yych <= 'z') goto yy812;
					if (yych <= '~') goto yy809;
					if (yych <= 0x7F) goto yy814;
					goto yy812;
				}
			}
		}
		YYDEBUG(802, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych <= '9') {
				if (yych >= '0') goto yy826;
			} else {
				if (yych == 'B') goto yy823;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= 'X') goto yy825;
				if (yych >= 'b') goto yy823;
			} else {
				if (yych == 'x') goto yy825;
			}
		}
yy803:
		YYDEBUG(803, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1076 "zend_language_scanner.l"
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN(T_NUM_STRING);
}
#line 6790 "zend_language_scanner.c"
yy804:
		YYDEBUG(804, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy822;
yy805:
		YYDEBUG(805, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy806;
			if (yych <= 'Z') goto yy818;
			if (yych >= '_') goto yy818;
		} else {
			if (yych <= '`') goto yy806;
			if (yych <= 'z') goto yy818;
			if (yych >= 0x80) goto yy818;
		}
yy806:
		YYDEBUG(806, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1236 "zend_language_scanner.l"
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
#line 6815 "zend_language_scanner.c"
yy807:
		YYDEBUG(807, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(808, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1231 "zend_language_scanner.l"
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
#line 6826 "zend_language_scanner.c"
yy809:
		YYDEBUG(809, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy806;
yy810:
		YYDEBUG(810, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(811, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1241 "zend_language_scanner.l"
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 6844 "zend_language_scanner.c"
yy812:
		YYDEBUG(812, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy817;
yy813:
		YYDEBUG(813, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1249 "zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_STRING);
}
#line 6858 "zend_language_scanner.c"
yy814:
		YYDEBUG(814, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(815, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1747 "zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 6873 "zend_language_scanner.c"
yy816:
		YYDEBUG(816, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy817:
		YYDEBUG(817, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy816;
		}
		goto yy813;
yy818:
		YYDEBUG(818, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(819, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy818;
			} else {
				if (yych <= '@') goto yy820;
				if (yych <= 'Z') goto yy818;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy818;
			} else {
				if (yych <= 'z') goto yy818;
				if (yych >= 0x80) goto yy818;
			}
		}
yy820:
		YYDEBUG(820, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1226 "zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 6914 "zend_language_scanner.c"
yy821:
		YYDEBUG(821, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy822:
		YYDEBUG(822, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy821;
		}
		goto yy803;
yy823:
		YYDEBUG(823, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy831;
		}
yy824:
		YYDEBUG(824, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy803;
yy825:
		YYDEBUG(825, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy829;
		}
		goto yy824;
yy826:
		YYDEBUG(826, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(827, *YYCURSOR);
		if (yych <= '/') goto yy828;
		if (yych <= '9') goto yy826;
yy828:
		YYDEBUG(828, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1092 "zend_language_scanner.l"
		{ /* Offset must be treated as a string */
	ZVAL_STRINGL(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_NUM_STRING);
}
#line 6959 "zend_language_scanner.c"
yy829:
		YYDEBUG(829, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(830, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy829;
		}
		goto yy828;
yy831:
		YYDEBUG(831, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(832, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy831;
		}
		goto yy828;
	}
}
#line 1756 "zend_language_scanner.l"

}
