/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
// This interface provides help text for iObject types and keys
//

#ifndef IOBJECTHELP_H
#define IOBJECTHELP_H


#include "istring.h"


class iHelpDataBuffer;
class iObjectType;
class iObjectKey;


class iObjectHelpBase
{

public:

	inline const char* GetTag() const { return mTag; }
	iString GetText(int length = 0) const;
	iString GetHTML() const;

	//
	//  Extra controls
	//
	const iString GetExtraTag(int type) const;

protected:

	//
	//  Cannot be created except by children
	//
	iObjectHelpBase(const char *tag);
	virtual ~iObjectHelpBase();

	iHelpDataBuffer* mData;
	char mTag[16];

private:

  	iObjectHelpBase(const iObjectHelpBase&);  // Not implemented.
	void operator=(const iObjectHelpBase&);  // Not implemented.
};


class iObjectTypeHelp : public iObjectHelpBase
{

public:

	iObjectTypeHelp(const iObjectType *type = 0);
	virtual ~iObjectTypeHelp();

private:

	const iObjectType *mType;
};


class iObjectKeyHelp : public iObjectHelpBase
{

//	friend class iShell;

public:

	iObjectKeyHelp(const iObjectKey *key = 0);
	virtual ~iObjectKeyHelp();

private:

	const iObjectKey *mKey;
};


#endif // IOBJECTHELP_H

