/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class FirefoxChromeLauncher
extends AbstractBrowserLauncher {
    static Log log = LogFactory.getLog(FirefoxChromeLauncher.class);
    private static final String[] DEFAULT_NONWINDOWS_LOCATIONS = new String[]{"/usr/lib/firefox/firefox-bin", "/Applications/Firefox.app/Contents/MacOS/firefox-bin"};
    private static boolean simple = false;
    private int port;
    private File customProfileDir;
    private String[] cmdarray;
    private boolean closed = false;
    private String commandPath;
    private Process process;
    private static AsyncExecute exe = new AsyncExecute();
    private static boolean changeMaxConnections = false;

    public FirefoxChromeLauncher(int port, String sessionId) {
        this(port, sessionId, FirefoxChromeLauncher.findBrowserLaunchLocation());
    }

    public FirefoxChromeLauncher(int port, String sessionId, String browserLaunchLocation) {
        super(sessionId);
        this.commandPath = browserLaunchLocation;
        this.port = port;
        this.sessionId = sessionId;
        exe.setEnvironment(new String[]{"MOZ_NO_REMOTE=1"});
        if (!WindowsUtils.thisIsWindows()) {
            File execDirect;
            File firefoxBin = AsyncExecute.whichExec(this.commandPath);
            if (firefoxBin == null && (execDirect = new File(this.commandPath)).isAbsolute() && execDirect.exists()) {
                firefoxBin = execDirect;
            }
            if (firefoxBin != null) {
                LauncherUtils.assertNotScriptFile(firefoxBin);
                String libPathKey = FirefoxChromeLauncher.getLibPathKey();
                String libPath = WindowsUtils.loadEnvironment().getProperty(libPathKey);
                exe.setEnvironment(new String[]{"MOZ_NO_REMOTE=1", libPathKey + "=" + libPath + ":" + firefoxBin.getParent()});
            }
        }
    }

    private static String getLibPathKey() {
        if (WindowsUtils.thisIsWindows()) {
            return WindowsUtils.getExactPathEnvKey();
        }
        if (Os.isFamily("mac")) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    private static String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("firefoxDefaultPath");
        if (defaultPath == null) {
            if (WindowsUtils.thisIsWindows()) {
                defaultPath = WindowsUtils.getProgramFilesPath() + "\\Mozilla Firefox\\firefox.exe";
            } else {
                for (int x = 0; x < DEFAULT_NONWINDOWS_LOCATIONS.length && !new File(defaultPath = DEFAULT_NONWINDOWS_LOCATIONS[x]).exists(); ++x) {
                }
            }
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        if (WindowsUtils.thisIsWindows()) {
            File firefoxEXE = AsyncExecute.whichExec("firefox.exe");
            if (firefoxEXE != null) {
                return firefoxEXE.getAbsolutePath();
            }
            throw new RuntimeException("Firefox couldn't be found in the path!\nPlease add the directory containing firefox.exe to your PATH environment\nvariable, or explicitly specify a path to Firefox like this:\n*firefox c:\\blah\\firefox.exe");
        }
        File firefoxBin = AsyncExecute.whichExec("firefox-bin");
        if (firefoxBin != null) {
            return firefoxBin.getAbsolutePath();
        }
        throw new RuntimeException("Firefox couldn't be found in the path!\nPlease add the directory containing 'firefox-bin' to your PATH environment\nvariable, or explicitly specify a path to Firefox like this:\n*firefox /blah/blah/firefox-bin");
    }

    protected void launch(String url) {
        try {
            String homePage = new ChromeUrlConvert().convert(url, this.port);
            String profilePath = this.makeCustomProfile(homePage);
            String chromeURL = "chrome://killff/content/kill.html";
            this.cmdarray = new String[]{this.commandPath, "-profile", profilePath, "-chrome", chromeURL};
            log.info("Preparing Firefox profile...");
            exe.setCommandline(this.cmdarray);
            exe.execute();
            this.waitForFullProfileToBeCreated(20000L);
            log.info("Launching Firefox...");
            this.cmdarray = new String[]{this.commandPath, "-profile", profilePath};
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String makeCustomProfile(String homePage) throws IOException {
        this.customProfileDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        if (simple) {
            return this.customProfileDir.getAbsolutePath();
        }
        String sourceLocationName = "/customProfileDirCUSTFFCHROME";
        File firefoxProfileTemplate = SeleniumServer.getFirefoxProfileTemplate();
        if (firefoxProfileTemplate != null) {
            LauncherUtils.copyDirectory(firefoxProfileTemplate, this.customProfileDir);
        }
        ResourceExtractor.extractResourcePath(this.getClass(), sourceLocationName, this.customProfileDir);
        this.copyRunnerHtmlFiles();
        LauncherUtils.generatePacAndPrefJs(this.customProfileDir, this.port, LauncherUtils.ProxySetting.NO_PROXY, homePage, changeMaxConnections);
        return this.customProfileDir.getAbsolutePath();
    }

    private void copyRunnerHtmlFiles() {
        String guid = "{503A0CD4-EDC8-489b-853B-19E0BAA8F0A4}";
        File extensionDir = new File(this.customProfileDir, "extensions/" + guid);
        File htmlDir = new File(extensionDir, "chrome");
        htmlDir.mkdirs();
        LauncherUtils.extractHTAFile(htmlDir, this.port, "/core/TestRunner.html", "TestRunner.html");
        LauncherUtils.extractHTAFile(htmlDir, this.port, "/core/RemoteRunner.html", "RemoteRunner.html");
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.process == null) {
            return;
        }
        log.info("Killing Firefox...");
        Throwable taskKillException = null;
        FileLockRemainedException fileLockException = null;
        int exitValue = AsyncExecute.killProcess(this.process);
        if (exitValue == 0) {
            log.warn("Firefox seems to have ended on its own (did we kill the real browser???)");
        }
        try {
            this.waitForFileLockToGoAway(0L, 500L);
        }
        catch (FileLockRemainedException e1) {
            fileLockException = e1;
        }
        try {
            LauncherUtils.deleteTryTryAgain(this.customProfileDir, 6);
        }
        catch (RuntimeException e) {
            if (taskKillException != null || fileLockException != null) {
                log.error("Couldn't delete custom Firefox profile directory", e);
                log.error("Perhaps caused by this exception:");
                if (taskKillException != null) {
                    log.error("Perhaps caused by this exception:", taskKillException);
                }
                if (fileLockException != null) {
                    log.error("Perhaps caused by this exception:", fileLockException);
                }
                throw new RuntimeException("Couldn't delete custom Firefox profile directory, presumably because task kill failed; see error log!", e);
            }
            throw e;
        }
        this.closed = true;
    }

    public Process getProcess() {
        return this.process;
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir, "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            AsyncExecute.sleepTight(500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    private void waitForFullProfileToBeCreated(long timeout) {
        File testFile = new File(this.customProfileDir, "extensions.ini");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (!testFile.exists()) continue;
        }
        if (!testFile.exists()) {
            throw new RuntimeException("Timed out waiting for profile to be created!");
        }
        long subTimeout = timeout - (System.currentTimeMillis() - start);
        try {
            this.waitForFileLockToGoAway(subTimeout, 500L);
        }
        catch (FileLockRemainedException e) {
            throw new RuntimeException("Firefox refused shutdown while preparing a profile", e);
        }
    }

    public static void setChangeMaxConnections(boolean changeMaxConnections) {
        FirefoxChromeLauncher.changeMaxConnections = changeMaxConnections;
    }

    public static void main(String[] args) throws Exception {
        FirefoxChromeLauncher l = new FirefoxChromeLauncher(4444, "CUSTFFCHROME");
        l.launch("http://www.google.com");
        int seconds = 15000;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        AsyncExecute.sleepTight(seconds * 1000);
        l.close();
        System.out.println("He's dead now, right?");
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL, boolean multiWindow, String defaultLogLevel) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl, multiWindow, this.port, defaultLogLevel));
    }

    public void launchRemoteSession(String browserURL, boolean multiWindow) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId, multiWindow, this.port));
    }

    public static class ChromeUrlConvert {
        public String convert(String httpUrl, int port) throws MalformedURLException {
            String query = LauncherUtils.getQueryString(httpUrl);
            String file = new File(new URL(httpUrl).getPath()).getName();
            return "chrome://src/content/" + file + "?" + query;
        }
    }

    private class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

