/*
 * junixsocket
 *
 * Copyright 2009-2022 Christian Kohlschütter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.newsclub.net.unix.vsock;

import static org.junit.jupiter.api.Assertions.assertNotEquals;

import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFVSOCKSocketAddress;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;

/**
 * Tests some otherwise uncovered methods of {@link AFVSOCKSocket}.
 * 
 * @author Christian Kohlschütter
 */
@AFSocketCapabilityRequirement(AFSocketCapability.CAPABILITY_VSOCK)
@SuppressFBWarnings({
    "THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION",
    "NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class SocketTest extends org.newsclub.net.unix.SocketTest<AFVSOCKSocketAddress> {

  public SocketTest() {
    super(AFVSOCKAddressSpecifics.INSTANCE);
  }

  @Test
  public void testMain() throws Exception {
    AFVSOCKSocket.main(new String[0]);
  }

  @Test
  public void testVersion() throws Exception {
    assertNotEquals("", AFVSOCKSocket.getVersion());
    // see junixsocket-rmi JunixSocketVersionTest
  }

  @Test
  public void testSupported() throws Exception {
    AFVSOCKSocket.isSupported();
  }

  @Test
  public void testLoadedLibrary() throws Exception {
    assertNotEquals("", AFVSOCKSocket.getLoadedLibrary());
  }
}
