/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#ifndef PLASMA_KIFER_H
#define PLASMA_KIFER_H

#include <KIcon>
#include <KDialog>
#include <KMenu>
#include <KConfig>
#include <KConfigGroup>

#include <Plasma/Applet>
#include <Plasma/Svg>
#include <plasma/widgets/iconwidget.h>

#include "../lib/buddylist.h"
#include "../lib/servicelocator.h"

#include "../lib/ui_config.h"

#include "../libkpf/ServerWizard.h"
#include "../libkpf/WebServerManager.h"
#include "../libkpf/WebServer.h"
#include "../libkpf/ActiveMonitorWindow.h"
#include "../libkpf/SingleServerConfigDialog.h"


using namespace KPF;
 
class QSizeF;

namespace Plasma
{
    class IconWidget;
}

 
class PlasmaKifer : public Plasma::Applet
{
    Q_OBJECT
public:

        PlasmaKifer(QObject *parent, const QVariantList &args);
        ~PlasmaKifer();
 
	void init();
	
	void dragEnterEvent(QGraphicsSceneDragDropEvent *event);
	void dropEvent(QGraphicsSceneDragDropEvent *event);
	void showConfigurationInterface();
	void constraintsEvent(Plasma::Constraints constraints);
 
private:
        Plasma::Svg m_svg;
	Plasma::IconWidget* m_icon;
        QSizeF m_size;
	BuddyList* buddylist;
	ServiceLocator* avahiClient;
	Ui::Config ui;
	KDialog* m_dialog;
	KMenu m_menu;
	QMenu* clipMenu;
	QAction* clipAction;
	QAction* monitorAction;
	QAction* pauseAction;
	QAction* removeAction;
	QAction* restartAction;
	QAction* prefAction;
	QMenu* kpfMenu;
	QMenu* newServerMenu;


	QDBusConnection* dbus;

	ServerWizard* publicServerWiz;
	QHash<QString,WebServer*>* webServerHash;
	QHash<QString,QMenu*>* webServerMenuHash;
	QHash<QString,QAction*>* actionHash;
	WebServer* webSrv;
	SingleServerConfigDialog* configDialog;

	KConfig* config;
	KConfigGroup* confGroup;

	void createMenu();

public slots:	
	void configAccepted();
	void slotSelectDir();
	void slotBuddyList(bool);
	void slotFileSelect(bool);
	void popup(bool pressed);
	void addClipEntries();
	void slotSendClipEntry(QAction*);
	void failedToStart();

	void slotWizardDying(ServerWizard * wiz);
	void slotMonitorAction(QAction*);
	void slotRemoveServerAction(QAction*);
	void slotPauseServerAction(QAction*);
	void slotRestartServerAction(QAction*);
	void slotPrefsServerAction(QAction*);
	void slotConfigDialogDying(SingleServerConfigDialog* dialog);
	void slotServerMenuTriggered(QAction*);
	void slotServerWizard(bool);

};
 
K_EXPORT_PLASMA_APPLET(kepas, PlasmaKifer)
#endif
