#ifndef __SPCIALLIST_H__
#define __SPCIALLIST_H__

#include <pthread.h>

typedef struct _speciallist_node_t{
        struct _speciallist_node_t 	*next;
        void 				*data;
} speciallist_node_t;

typedef struct _speciallist_t{
	pthread_mutex_t mutex;
	speciallist_node_t *first;	
	speciallist_node_t *last;
	speciallist_node_t *latest;
} speciallist_t;

speciallist_t*	speciallist_new			();
void 		speciallist_destroy		(speciallist_t *list);
void 		speciallist_lock		(speciallist_t *list);
void		speciallist_unlock		(speciallist_t *list);
int		speciallist_count		(speciallist_t *list);
int 		speciallist_append		(speciallist_t *list, void *data);
int 		speciallist_delete		(speciallist_t *list, void *data);
void*		speciallist_get_first		(speciallist_t *list);
void*		speciallist_get_last		(speciallist_t *list);
void*		speciallist_get_next		(speciallist_t *list, void *data);
void*		speciallist_get_previous	(speciallist_t *list, void *data);
int		speciallist_count_nolock	(speciallist_t *list);
int             speciallist_append_nolock	(speciallist_t *list, void *data);
int             speciallist_delete_nolock      	(speciallist_t *list, void *data);
void*		speciallist_get_first_nolock	(speciallist_t *list);
void*		speciallist_get_last_nolock	(speciallist_t *list);
void*           speciallist_get_next_nolock    	(speciallist_t *list, void *data);
void* 		speciallist_get_previous_nolock (speciallist_t *list, void *data);



#endif
