package junit.test.svg;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGElements;
import latexDraw.parsers.svg.elements.SVGPatternElement;

import org.junit.Test;

/** 
 * This class contains tests for the SVGPatternElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/12/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGPatternElement extends AbstractTestSVGElement
{
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGPatternElement(null, null);
			fail();
		}
		catch(Exception e){/**/}
		
		try { new SVGPatternElement(node, null); }
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetHeight()
	{
		try
		{
			SVGPatternElement e = new SVGPatternElement(node, null);
			assertEquals(e.getHeight(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			e = new SVGPatternElement(node, null);
			assertEquals(e.getHeight(), 20.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetWidth()
	{
		try
		{
			SVGPatternElement e = new SVGPatternElement(node, null);
			assertEquals(e.getWidth(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "30");
			e = new SVGPatternElement(node, null);
			assertEquals(e.getWidth(), 30.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetPatternUnits()
	{
		try
		{
			SVGPatternElement e = new SVGPatternElement(node, null);
			assertEquals(e.getPatternUnits(), SVGAttributes.SVG_UNITS_VALUE_OBJ);
			
			node.setAttribute(SVGAttributes.SVG_PATTERN_UNITS, SVGAttributes.SVG_UNITS_VALUE_USR);
			e = new SVGPatternElement(node, null);
			assertEquals(e.getPatternUnits(), SVGAttributes.SVG_UNITS_VALUE_USR);
			
			node.setAttribute(SVGAttributes.SVG_PATTERN_UNITS, SVGAttributes.SVG_UNITS_VALUE_OBJ);
			e = new SVGPatternElement(node, null);
			assertEquals(e.getPatternUnits(), SVGAttributes.SVG_UNITS_VALUE_OBJ);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetPatternContentUnits()
	{
		try
		{
			SVGPatternElement e = new SVGPatternElement(node, null);
			assertEquals(e.getPatternContentUnits(), SVGAttributes.SVG_UNITS_VALUE_USR);
			
			node.setAttribute(SVGAttributes.SVG_PATTERN_CONTENTS_UNITS, SVGAttributes.SVG_UNITS_VALUE_USR);
			e = new SVGPatternElement(node, null);
			assertEquals(e.getPatternContentUnits(), SVGAttributes.SVG_UNITS_VALUE_USR);
			
			node.setAttribute(SVGAttributes.SVG_PATTERN_CONTENTS_UNITS, SVGAttributes.SVG_UNITS_VALUE_OBJ);
			e = new SVGPatternElement(node, null);
			assertEquals(e.getPatternContentUnits(), SVGAttributes.SVG_UNITS_VALUE_OBJ);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testEnableRendering()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "0");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "0");
			SVGPatternElement e = new SVGPatternElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "0");
			e = new SVGPatternElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "0");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "10");
			e = new SVGPatternElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "10");
			e = new SVGPatternElement(node, null);
			assertTrue(e.enableRendering());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetY()
	{
		try
		{
			SVGPatternElement e = new SVGPatternElement(node, null);
			assertEquals(e.getY(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_Y, "1");
			e = new SVGPatternElement(node, null);
			assertEquals(1., e.getY());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetX()
	{
		try
		{
			SVGPatternElement e = new SVGPatternElement(node, null);
			assertEquals(e.getX(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_X, "2");
			e = new SVGPatternElement(node, null);
			assertEquals(2., e.getX());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_PATTERN;
	}
}
