package latexDraw.ui.dialog;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

import latexDraw.figures.Figure;
import latexDraw.figures.Rhombus;
import latexDraw.ui.DrawPanel;
import latexDraw.util.LaTeXDrawPoint2D;


/** 
 * This class defines the frame which allows to change the parameters of rhombus.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ParametersRhombusFrame extends AbstractParametersFrame
{
	private static final long serialVersionUID = 1L;

	/** Allows to change the x-coordinates of the centre of the figure */
	protected JSpinner centerXField;
	
	/** Allows to change the y-coordinates of the centre of the figure */
	protected JSpinner centerYField;
	
	/** Allows to change the width of the triangle */
	protected JSpinner widthField;
	
	/** Allows to change the height of the triangle */
	protected JSpinner heightField;
	
	
	

	/**
	 * The constructor by default
	 */
	public ParametersRhombusFrame(Frame parent, DrawPanel p, boolean attachToMainFrame) 
	{
		super(parent, p, attachToMainFrame);
		try
		{
	  		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	  		JTabbedPane tabbedPane = new JTabbedPane();
	  		JPanel pButton  = createButtonsPanel(this);
	  		JPanel pGeneral = new JPanel();
	  		pGeneral.setLayout(new BoxLayout(pGeneral, BoxLayout.Y_AXIS));
	  		JPanel coordP = new JPanel(new GridBagLayout());
	  		GridBagConstraints constraint = new GridBagConstraints();
	    	constraint.gridx = 0;
	     	constraint.gridy = 0;
	     	constraint.gridwidth = 1;
	     	constraint.gridheight = 1;
	     	constraint.weightx = 0.1;
	     	constraint.weighty = 0.1;
	     	constraint.fill = GridBagConstraints.NONE;
	     	constraint.anchor = GridBagConstraints.CENTER;
	     	coordP.add(new JLabel(LABEL_CENTER_X), constraint);
	  		
	     	SpinnerModel model = new SpinnerNumberModel(0,0,10000,0.1);
	     	centerXField = new JSpinner(model);
			centerXField.setEditor(new JSpinner.NumberEditor(centerXField, "0.0"));//$NON-NLS-1$
			centerXField.addChangeListener(this);
	     	centerXField.setName(LABEL_CENTER_X);
	     	constraint.gridx++;
	     	coordP.add(centerXField, constraint);

	    	constraint.gridx++;
	     	coordP.add(new JLabel(LABEL_CENTER_Y), constraint);
	  		
	     	model = new SpinnerNumberModel(0,0,10000,0.1);
	     	centerYField = new JSpinner(model);
	     	centerYField.setEditor(new JSpinner.NumberEditor(centerYField, "0.0"));//$NON-NLS-1$
			centerYField.addChangeListener(this);
	     	centerYField.setName(LABEL_CENTER_Y);
	     	constraint.gridx++;	
	     	coordP.add(centerYField, constraint);
	     	
	    	constraint.gridx = 0;	constraint.gridy++;
	     	coordP.add(new JLabel(LABEL_WIDTH), constraint);
	  		
	     	model = new SpinnerNumberModel(0.1,0.1,10000,0.1);
	     	widthField = new JSpinner(model);
	     	widthField.setEditor(new JSpinner.NumberEditor(widthField, "0.0"));//$NON-NLS-1$
	     	widthField.addChangeListener(this);
	     	widthField.setName(LABEL_WIDTH);
	     	constraint.gridx++;
	     	coordP.add(widthField, constraint);
	   
	     	constraint.gridx++;
	     	coordP.add(new JLabel(LABEL_HEIGHT), constraint);
	  		
	     	model = new SpinnerNumberModel(0.1,0.1,10000,0.1);
	     	heightField = new JSpinner(model);
	     	heightField.setEditor(new JSpinner.NumberEditor(heightField, "0.0"));//$NON-NLS-1$
	     	heightField.addChangeListener(this);
	     	heightField.setName(LABEL_HEIGHT);
	     	constraint.gridx++;	
	     	coordP.add(heightField, constraint);
	     	
	     	constraint.gridx = 0;	constraint.gridy++;
	     	coordP.add(new JLabel(LABEL_ROTATION), constraint);
	     	constraint.gridx++;
	     	coordP.add(rotationField, constraint);
	     	
	     	coordP.setBorder(new CompoundBorder(new TitledBorder(null, LABEL_POSITION_DIMENSIONS, 
							  TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
	     	pGeneral.add(coordP);
	     	
	     	pGeneral.add(createBordersPanel(true));
	     	pGeneral.add(createDoubleLinePanel());
	     	pGeneral.add(createFillPanel());
	     	
	     	JPanel pOther = new JPanel();
	     	pOther.setLayout(new BoxLayout(pOther, BoxLayout.Y_AXIS));
	     	pOther.add(createShadowPanel());
	     	pOther.add(createGradientPanel());
	     	pOther.add(createHatchingPanel());
	     	
	     	tabbedPane.addTab(TITLE_TABBED_PANE_GENERAL, pGeneral);
	     	tabbedPane.addTab(TITLE_TABBED_PANE_OTHERS, pOther);
	     	BoxLayout bl = new BoxLayout(getContentPane(), BoxLayout.Y_AXIS);
	     	getContentPane().setLayout(bl);
	     	getContentPane().add(glimpsePanelZoom);
	     	getContentPane().add(tabbedPane);
			getContentPane().add(pButton);
	  		pack();
	  		setLocation(dim.width/2-getWidth()/2, dim.height/2-getHeight()/2);
			setVisible(false);
		}
		catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}

	
	
	
	
	@Override
	public void saveParameters()
	{
		super.saveParameters();
		
		Rhombus r = (Rhombus)figure;
		LaTeXDrawPoint2D p1 = r.getPoint(0), p2 = r.getPoint(1), p3 = r.getPoint(2), p4 = r.getPoint(3);
		float demiWidth = (float) (Float.valueOf(widthField.getValue().toString()).floatValue()/2.);
		float demiHeight = (float) (Float.valueOf(heightField.getValue().toString()).floatValue()/2.);
		float x = Float.valueOf(centerXField.getValue().toString()).floatValue();
		float y = Float.valueOf(centerYField.getValue().toString()).floatValue();
		
		p1.y = y - demiHeight;
		p2.y = y - demiHeight;
		p3.y = y + demiHeight;
		p4.y = y + demiHeight;

		p1.x = x - demiWidth;
		p2.x = x + demiWidth;
		p3.x = x - demiWidth;
		p4.x = x + demiWidth;

		r.updateShape();
		r.getBorders().updateNSEWDelimitors();
		
		drawPanel.getDraw().updateBorders();
		drawPanel.updateDraw(true);
	}
	

	

	@Override
	public void setFigureFrameField()
	{
		Rhombus r = (Rhombus)figure;
		Rhombus r2 = (Rhombus) glimpsePanel.getGlimpseFigure();
		LaTeXDrawPoint2D NW = r.getTheNWPoint(), SE = r.getTheSEPoint();
		
		centerXField.removeChangeListener(this);
		centerYField.removeChangeListener(this);
		widthField.removeChangeListener(this);
		heightField.removeChangeListener(this);
		
		centerXField.setValue((NW.x+SE.x)/2.);
		centerYField.setValue((NW.y+SE.y)/2.);
		widthField.setValue(SE.x-NW.x);
		heightField.setValue(SE.y-NW.y);
		
		centerXField.addChangeListener(this);
		centerYField.addChangeListener(this);
		widthField.addChangeListener(this);
		heightField.addChangeListener(this);
		
		for(int i=0; i<Rhombus.NB_POINTS_RHOMBUS; i++)
			r2.getPoint(i).setLocation(r.getPoint(i));
		
		r2.updateGravityCenter();
		r2.updateShape();
		glimpsePanel.repaint();
	}

	
	
	@Override
	public void stateChanged(ChangeEvent e) 
	{
		try
		{
			Object o = e.getSource();
			
			Rhombus r = (Rhombus) glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JSpinner)
			{
				String name = ((JSpinner)o).getName();
				LaTeXDrawPoint2D p1 = r.getPoint(0), p2 = r.getPoint(1), p3 = r.getPoint(2), p4 = r.getPoint(3);

				float demiWidth  = (float)(Float.valueOf(widthField.getValue().toString())/2.);
				float demiHeight = (float)(Float.valueOf(heightField.getValue().toString())/2.);
				float x = Float.valueOf(centerXField.getValue().toString());
				float y = Float.valueOf(centerYField.getValue().toString());

				if(name.equals(LABEL_CENTER_X))
				{
					p1.x = x - demiWidth;
					p2.x = x + demiWidth;
					p3.x = x - demiWidth;
					p4.x = x + demiWidth;
					r.updateGravityCenter();
					r.updateShape();
					glimpsePanel.repaint();
					setModified(true);
					return ;
				}
				
				if(name.equals(LABEL_CENTER_Y))
				{
					p1.y = y - demiHeight;
					p2.y = y - demiHeight;
					p3.y = y + demiHeight;
					p4.y = y + demiHeight;
					r.updateGravityCenter();
					r.updateShape();
					glimpsePanel.repaint();
					setModified(true);
					return ;
				}
				
				if(name.equals(LABEL_HEIGHT))
				{
					p1.y = y - demiHeight;
					p2.y = y - demiHeight;
					p3.y = y + demiHeight;
					p4.y = y + demiHeight;
					r.updateGravityCenter();
					r.updateShape();
					glimpsePanel.repaint();
					setModified(true);
					return ;
				}
				
				if(name.equals(LABEL_WIDTH))
				{
					p1.x = x - demiWidth;
					p2.x = x + demiWidth;
					p3.x = x - demiWidth;
					p4.x = x + demiWidth;
					r.updateGravityCenter();
					r.updateShape();
					glimpsePanel.repaint();
					setModified(true);
					return ;
				}
			}
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
		
		super.stateChanged(e);
	}
	
	
	

	@Override
	public void setVisible(boolean visible, Figure selected, boolean deleteOnCancel, boolean isFramedBox) 
	{
		try
		{
			if(!(selected instanceof Rhombus))
				throw new ClassCastException();
			
			if(isFramedBox)
			{
				centerXField.setEnabled(false);
				centerYField.setEnabled(false);
				widthField.setEnabled(false);
				heightField.setEnabled(false);
			}
			
			super.setVisible(visible, selected, deleteOnCancel, isFramedBox);
		}
		catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}	
	}
}
