package latexDraw.ui.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFileChooser;

import latexDraw.installer.InstallerUI;


/** 
 * This class defines the listener of the installer.
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 01/21/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 * @since 1.9<br>
 */
public class InstallerListener implements ActionListener
{
	protected InstallerUI installer;
	
	protected JFileChooser fileChooser;
	
	
	public InstallerListener(InstallerUI installerUI)
	{
		if(installerUI==null)
			throw new IllegalArgumentException();
		
		installer = installerUI;
		
		fileChooser = new JFileChooser();
		fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		fileChooser.setMultiSelectionEnabled(false);
	}

	
	
	public void actionPerformed(ActionEvent e)
	{
		Object o = e.getSource();
		
		if(o instanceof JButton)
		{
			String actionCmd = ((JButton)o).getActionCommand();
			
			if(actionCmd==null)
				return ;
			
			if(actionCmd.equals(InstallerUI.ACTION_CANCEL))
			{
				if(installer.isContinueInstall())
					installer.setContinueInstall(false);
				else
					System.exit(0);
				
				return ;
			}
			
			if(actionCmd.equals(InstallerUI.ACTION_TERMINATE))
			{
				System.exit(0);
				return ;
			}
			
			if(actionCmd.equals(InstallerUI.ACTION_NEXT))
			{
				installer.incrementSlidePosition();
				return ;
			}
			
			if(actionCmd.equals(InstallerUI.ACTION_PREVIOUS))
			{
				installer.decrementSlidePosition();
				return ;
			}
			
			if(actionCmd.equals(InstallerUI.ACTION_CHOOSE_FOLDER))
			{
				int id = fileChooser.showDialog(installer, "Select");
				
				if(id == JFileChooser.APPROVE_OPTION)
					installer.setPathInstall(fileChooser.getSelectedFile().getPath());
				
				return ;
			}
			
			return ;
		}
	}
}
