/* account_action.vala
 *
 * Copyright (C) 2009-2010  troorl
 * Copyright (C) 2010 Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	troorl <troorl@gmail.com>
 */

using Gtk;
using Gee;
using Auth;


public class AccountAction : Action {
	
	private Accounts accounts;
	private MenuItem menu_item;
	private Menu menu;
	
	public signal void current_account(string login, string pass, string service, string proxy);
	
	
	public AccountAction(MenuItem m) {
		name = "AccountAct";
		label = _("Accounts");
		tooltip = null;
		stock_id = null;
		menu_item = m;
		
	}
	
	/* set item linked with this action */
	public void set_ui(Accounts _ac) {
		accounts = new Accounts();
		setup();
	
	}
	
	/* setup accounts in submenu */
	private void setup() {
		menu = new Menu();
		
		unowned SList<RadioMenuItem> group = null;
		
		foreach(Account acc in accounts.accounts) {
			RadioMenuItem item = new RadioMenuItem.with_label(group,
				"%s (%s)".printf(acc.login, acc.service));
			group = item.get_group();
			item.active = acc.active;
			//debug(acc.login);
			item.toggled.connect(() => {
				if(item.active) {
					accounts.set_active_account(acc.login + acc.service + acc.proxy);
					current_account(acc.login , acc.password , acc.service , acc.proxy);

					accounts.write();
				}
			});
			
			menu.append(item);
			
			//If this is the current active account then try to reconnect and refresh the categories
			if (acc.active | (accounts.accounts.size == 1))
			    current_account(acc.login , acc.password , acc.service , acc.proxy);
		}
		
		menu_item.set_submenu(menu);
		menu.show_all();
	}
	
	
	public void set_accounts(Accounts _accounts) {
		accounts = _accounts;
		var acc = accounts.get_current_account();
		accounts.changed.connect(() => {
			setup();
		});
		
		accounts.active_changed.connect(acc_changed);
		
		
		tooltip = "%s (%s)".printf(acc.login, acc.service);
	}
	
	public void acc_changed(){
			var acc = accounts.get_current_account();
            //Set wp details here
            //may be through a signal
            current_account(acc.login , acc.password , acc.service , acc.proxy);
            //debug("changed");
			tooltip = "%s (%s)".printf(acc.login, acc.service);
	}
	
}
