/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.launch;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.swt.widgets.Display;
import org.lisaac.ldt.launch.LisaacCompiler;
import org.lisaac.ldt.views.ConsoleFactory;
import org.lisaac.ldt.views.LisaacConsole;

public class LisaacLauncher {
    public static boolean executeCommandInConsole(ILaunch launch, IProgressMonitor monitorParent, IContainer container, String[] commandLine, LisaacCompiler compiler) throws CoreException {
        LisaacConsole console = ConsoleFactory.getConsole();
        console.clearConsole();
        if (compiler == null) {
            console.activate();
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        Runnable getStandardOutput = new Runnable((IProgressMonitor)monitor, compiler, commandLine, container, launch){
            private final /* synthetic */ IProgressMonitor val$monitor;
            private final /* synthetic */ LisaacCompiler val$compiler;
            private final /* synthetic */ String[] val$commandLine;
            private final /* synthetic */ IContainer val$container;
            private final /* synthetic */ ILaunch val$launch;
            {
                this.val$monitor = iProgressMonitor;
                this.val$compiler = lisaacCompiler;
                this.val$commandLine = stringArray;
                this.val$container = iContainer;
                this.val$launch = iLaunch;
            }

            public void run() {
                this.val$monitor.beginTask("Executing... ", 100);
                if (this.val$compiler != null) {
                    try {
                        this.val$compiler.cleanFiles();
                    }
                    catch (CoreException coreException) {}
                    this.val$monitor.worked(10);
                }
                Process process = null;
                try {
                    process = LisaacLauncher.launchProcess(this.val$commandLine, this.val$container);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.val$monitor.worked(20);
                if (this.val$monitor.isCanceled()) {
                    return;
                }
                if (process != null) {
                    this.val$monitor.setTaskName("Reading output...");
                    this.val$monitor.worked(20);
                    IProcess eclipseProcess = DebugPlugin.newProcess((ILaunch)this.val$launch, (Process)process, (String)"Lisaac Session");
                    final StringBuffer buffer = new StringBuffer();
                    IStreamListener listener = new IStreamListener(){

                        public void streamAppended(String text, IStreamMonitor monitor) {
                            buffer.append(text);
                        }
                    };
                    eclipseProcess.getStreamsProxy().getOutputStreamMonitor().addListener(listener);
                    eclipseProcess.getStreamsProxy().getErrorStreamMonitor().addListener(listener);
                    if (this.val$compiler != null) {
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {}
                        try {
                            this.val$compiler.moveFiles(this.val$container);
                            while (!eclipseProcess.isTerminated()) {
                            }
                            this.val$compiler.showErrors(buffer.toString());
                        }
                        catch (CoreException coreException) {}
                    }
                }
                this.val$monitor.done();
            }
        };
        Display.getDefault().asyncExec(getStandardOutput);
        return true;
    }

    public static Process executeCommand(IProgressMonitor monitor, IContainer container, String[] commandLine) throws CoreException {
        monitor.beginTask("Executing...", 100);
        Process process = null;
        try {
            process = LisaacLauncher.launchProcess(commandLine, container);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        monitor.worked(20);
        if (monitor.isCanceled()) {
            return null;
        }
        return process;
    }

    public static Process launchProcess(String[] commandLine, IContainer directory) throws IOException {
        File projectDirectory = directory != null ? new File(directory.getLocationURI()) : null;
        String cmd = LisaacLauncher.concatCommandLine(commandLine);
        Process process = Runtime.getRuntime().exec(cmd, null, projectDirectory);
        return process;
    }

    private static String concatCommandLine(String[] commandLine) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(commandLine[i]);
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }
}

