/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.items;

import java.util.ArrayList;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.IArgument;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.model.types.IType;
import org.lisaac.ldt.model.types.TypeMulti;
import org.lisaac.ldt.outline.OutlineImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITMArgs
implements IArgument {
    protected String[] name;
    protected TypeMulti type;
    protected Position position;

    public ITMArgs(String[] name, TypeMulti type, Position position) {
        this.name = name;
        this.type = type;
        this.position = position;
    }

    @Override
    public String getName() {
        StringBuffer buffer = new StringBuffer("(");
        int i = 0;
        while (i < this.name.length) {
            buffer.append(this.name[i]);
            if (i != this.name.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    private int lastIndexOf(String word) {
        int i = 0;
        while (i < this.name.length) {
            if (this.name[i].compareTo(word) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean hasName(String word) {
        return this.lastIndexOf(word) != -1;
    }

    @Override
    public IType getType() {
        return null;
    }

    public IType getArgType(String name) {
        int index = this.lastIndexOf(name);
        if (index != -1) {
            return this.type.getSubType(index);
        }
        return null;
    }

    @Override
    public void printIn(StringBuffer buffer) {
        buffer.append("(");
        int i = 0;
        while (i < this.name.length) {
            IType subType = this.type.getSubType(i);
            buffer.append(this.name[i]);
            buffer.append(" : ");
            buffer.append(subType);
            if (i != this.name.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(")");
    }

    @Override
    public void styledPrintIn(StyledString buffer) {
        ColorManager colors = ColorManager.getDefault();
        buffer.append("(");
        int i = 0;
        while (i < this.name.length) {
            IType subType = this.type.getSubType(i);
            buffer.append(this.name[i], colors.getVariableStyler());
            buffer.append(" : ");
            buffer.append(subType.toString(), colors.getPrototypeStyler());
            if (i != this.name.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(")");
    }

    @Override
    public String getHoverInformation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<I>Arguments</I> : ");
        buffer.append("(");
        int i = 0;
        while (i < this.name.length) {
            IType subType = this.type.getSubType(i);
            buffer.append("<b>" + this.name[i] + "</b>");
            buffer.append(" : ");
            buffer.append("<g>" + subType + "</g>");
            if (i != this.name.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void getMatchProposals(String n, ArrayList<ICompletionProposal> matchList, int offset, int length) {
        int i = 0;
        while (i < this.name.length) {
            String match;
            if (this.name[i].startsWith(n) && Slot.checkUnicity(matchList, match = this.name[i])) {
                Image image = OutlineImages.PRIVATE_NONSHARED;
                String partialMatch = match.substring(n.length());
                matchList.add((ICompletionProposal)new CompletionProposal(partialMatch, offset, length, partialMatch.length(), image, match, null, null));
            }
            ++i;
        }
    }
}

