/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2009 Apogee Instruments, Inc. 
* \class UdpSocketWin 
* \brief Windows platform implemenation of the UdpSocketBase class for a upd socket that finds apogee devices on a subnet 
* 
*/ 


#ifndef UDPSOCKETWIN_INCLUDE_H__ 
#define UDPSOCKETWIN_INCLUDE_H__ 

#include "UdpSocketBase.h" 
#include "winsock2.h"
#include <string>

class UdpSocketWin : public UdpSocketBase
{ 
    public: 
        UdpSocketWin();
        virtual ~UdpSocketWin(); 

    protected:
        void CloseSocket();

    private:
        const std::string m_fileName;
        WSADATA m_WinSockData;

        //disabling the copy ctor and assignment operator
        //generated by the compiler - don't want them
        //Effective C++ Item 6
        UdpSocketWin(const UdpSocketWin&);
        UdpSocketWin& operator=(UdpSocketWin&);
}; 

#endif