/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "message.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "./message_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */
GWEN_LIST_FUNCTIONS(AB_MESSAGE, AB_Message)
GWEN_LIST2_FUNCTIONS(AB_MESSAGE, AB_Message)


AB_MESSAGE_SOURCE AB_Message_Source_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AB_Message_SourceNone;
    else if (strcasecmp(p_s, "system")==0)
      return AB_Message_SourceSystem;
    else if (strcasecmp(p_s, "bank")==0)
      return AB_Message_SourceBank;
  }
  return AB_Message_SourceUnknown;
}

const char *AB_Message_Source_toString(AB_MESSAGE_SOURCE p_i)
{
  switch (p_i) {
  case AB_Message_SourceNone:
    return "none";
  case AB_Message_SourceSystem:
    return "system";
  case AB_Message_SourceBank:
    return "bank";
  case AB_Message_SourceUnknown:
  default:
    return "unknown";
  }
}

AB_MESSAGE *AB_Message_new(void)
{
  AB_MESSAGE *p_struct;

  GWEN_NEW_OBJECT(AB_MESSAGE, p_struct)
  p_struct->_refCount=1;
  GWEN_LIST_INIT(AB_MESSAGE, p_struct)
  /* members */
  p_struct->source=AB_Message_SourceUnknown;
  p_struct->userId=0;
  p_struct->accountId=0;
  p_struct->subject=NULL;
  p_struct->text=NULL;
  p_struct->dateReceived=NULL;
  /* virtual functions */

  return p_struct;
}

void AB_Message_free(AB_MESSAGE *p_struct)
{
  if (p_struct) {
    assert(p_struct->_refCount);
    if (p_struct->_refCount==1) {
      GWEN_LIST_FINI(AB_MESSAGE, p_struct)
      /* members */
      free(p_struct->subject);
      p_struct->subject=NULL;
      free(p_struct->text);
      p_struct->text=NULL;
      GWEN_Time_free(p_struct->dateReceived);
      p_struct->dateReceived=NULL;
      p_struct->_refCount=0;
      GWEN_FREE_OBJECT(p_struct);
    }
    else
      p_struct->_refCount--;
  }
}

void AB_Message_Attach(AB_MESSAGE *p_struct)
{
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

AB_MESSAGE *AB_Message_dup(const AB_MESSAGE *p_src)
{
  AB_MESSAGE *p_struct;

  assert(p_src);
  p_struct=AB_Message_new();
  /* member "source" */
  p_struct->source=p_src->source;

  /* member "userId" */
  p_struct->userId=p_src->userId;

  /* member "accountId" */
  p_struct->accountId=p_src->accountId;

  /* member "subject" */
  if (p_struct->subject) {
    free(p_struct->subject);
    p_struct->subject=NULL;
    p_struct->subject=NULL;
  }
  if (p_src->subject) {
    p_struct->subject=strdup(p_src->subject);
  }

  /* member "text" */
  if (p_struct->text) {
    free(p_struct->text);
    p_struct->text=NULL;
    p_struct->text=NULL;
  }
  if (p_src->text) {
    p_struct->text=strdup(p_src->text);
  }

  /* member "dateReceived" */
  if (p_struct->dateReceived) {
    GWEN_Time_free(p_struct->dateReceived);
    p_struct->dateReceived=NULL;
    p_struct->dateReceived=NULL;
  }
  if (p_src->dateReceived) {
    p_struct->dateReceived=GWEN_Time_dup(p_src->dateReceived);
  }

  return p_struct;
}

AB_MESSAGE *AB_Message_copy(AB_MESSAGE *p_struct, const AB_MESSAGE *p_src)
{
  assert(p_struct);
  assert(p_src);
  /* member "source" */
  p_struct->source=p_src->source;

  /* member "userId" */
  p_struct->userId=p_src->userId;

  /* member "accountId" */
  p_struct->accountId=p_src->accountId;

  /* member "subject" */
  if (p_struct->subject) {
    free(p_struct->subject);
    p_struct->subject=NULL;
    p_struct->subject=NULL;
  }
  if (p_src->subject) {
    p_struct->subject=strdup(p_src->subject);
  }

  /* member "text" */
  if (p_struct->text) {
    free(p_struct->text);
    p_struct->text=NULL;
    p_struct->text=NULL;
  }
  if (p_src->text) {
    p_struct->text=strdup(p_src->text);
  }

  /* member "dateReceived" */
  if (p_struct->dateReceived) {
    GWEN_Time_free(p_struct->dateReceived);
    p_struct->dateReceived=NULL;
    p_struct->dateReceived=NULL;
  }
  if (p_src->dateReceived) {
    p_struct->dateReceived=GWEN_Time_dup(p_src->dateReceived);
  }

  return p_struct;
}

AB_MESSAGE_SOURCE AB_Message_GetSource(const AB_MESSAGE *p_struct)
{
  assert(p_struct);
  return p_struct->source;
}

uint32_t AB_Message_GetUserId(const AB_MESSAGE *p_struct)
{
  assert(p_struct);
  return p_struct->userId;
}

uint32_t AB_Message_GetAccountId(const AB_MESSAGE *p_struct)
{
  assert(p_struct);
  return p_struct->accountId;
}

const char *AB_Message_GetSubject(const AB_MESSAGE *p_struct)
{
  assert(p_struct);
  return p_struct->subject;
}

const char *AB_Message_GetText(const AB_MESSAGE *p_struct)
{
  assert(p_struct);
  return p_struct->text;
}

const GWEN_TIME *AB_Message_GetDateReceived(const AB_MESSAGE *p_struct)
{
  assert(p_struct);
  return p_struct->dateReceived;
}

void AB_Message_SetSource(AB_MESSAGE *p_struct, AB_MESSAGE_SOURCE  p_src)
{
  assert(p_struct);
  p_struct->source=p_src;
}

void AB_Message_SetUserId(AB_MESSAGE *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->userId=p_src;
}

void AB_Message_SetAccountId(AB_MESSAGE *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->accountId=p_src;
}

void AB_Message_SetSubject(AB_MESSAGE *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->subject) {
    free(p_struct->subject);
    p_struct->subject=NULL;
  }
  if (p_src) {
    p_struct->subject=strdup(p_src);
  }
  else {
    p_struct->subject=NULL;
  }
}

void AB_Message_SetText(AB_MESSAGE *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->text) {
    free(p_struct->text);
    p_struct->text=NULL;
  }
  if (p_src) {
    p_struct->text=strdup(p_src);
  }
  else {
    p_struct->text=NULL;
  }
}

void AB_Message_SetDateReceived(AB_MESSAGE *p_struct, const GWEN_TIME *p_src)
{
  assert(p_struct);
  if (p_struct->dateReceived) {
    GWEN_Time_free(p_struct->dateReceived);
    p_struct->dateReceived=NULL;
  }
  if (p_src) {
    p_struct->dateReceived=GWEN_Time_dup(p_src);
  }
  else {
    p_struct->dateReceived=NULL;
  }
}

/* list1 functions */
AB_MESSAGE_LIST *AB_Message_List_dup(const AB_MESSAGE_LIST *p_src)
{
  AB_MESSAGE_LIST *p_dest;
  AB_MESSAGE *p_elem;

  assert(p_src);
  p_dest=AB_Message_List_new();
  p_elem=AB_Message_List_First(p_src);
  while (p_elem) {
    AB_MESSAGE *p_cpy;

    p_cpy=AB_Message_dup(p_elem);
    AB_Message_List_Add(p_cpy, p_dest);
    p_elem=AB_Message_List_Next(p_elem);
  }

  return p_dest;
}

void AB_Message_ReadDb(AB_MESSAGE *p_struct, GWEN_DB_NODE *p_db)
{
  assert(p_struct);
  /* member "source" */
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "source", 0, NULL);
    if (s)
      p_struct->source=AB_Message_Source_fromString(s);
    else
      p_struct->source=AB_Message_SourceUnknown;
  }

  /* member "userId" */
  p_struct->userId=GWEN_DB_GetIntValue(p_db, "userId", 0, 0);

  /* member "accountId" */
  p_struct->accountId=GWEN_DB_GetIntValue(p_db, "accountId", 0, 0);

  /* member "subject" */
  if (p_struct->subject) {
    free(p_struct->subject);
    p_struct->subject=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "subject", 0, NULL);
    if (s)
      p_struct->subject=strdup(s);
  }
  if (p_struct->subject==NULL) {
    p_struct->subject=NULL;
  }

  /* member "text" */
  if (p_struct->text) {
    free(p_struct->text);
    p_struct->text=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "text", 0, NULL);
    if (s)
      p_struct->text=strdup(s);
  }
  if (p_struct->text==NULL) {
    p_struct->text=NULL;
  }

  /* member "dateReceived" */
  if (p_struct->dateReceived) {
    GWEN_Time_free(p_struct->dateReceived);
    p_struct->dateReceived=NULL;
  }
  {
    GWEN_DB_NODE *dbDest;
    dbDest=GWEN_DB_GetGroup(p_db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "dateReceived");
    if (dbDest)
      p_struct->dateReceived=GWEN_Time_fromDb(dbDest);
  }
  if (p_struct->dateReceived==NULL) {
    p_struct->dateReceived=NULL;
  }

}

int AB_Message_WriteDb(const AB_MESSAGE *p_struct, GWEN_DB_NODE *p_db)
{
  int p_rv;

  assert(p_struct);
  /* member "source" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "source", AB_Message_Source_toString(p_struct->source));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "userId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "userId", p_struct->userId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "accountId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "accountId", p_struct->accountId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "subject" */
  if (p_struct->subject)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "subject", p_struct->subject);
  else {
    GWEN_DB_DeleteVar(p_db, "subject");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "text" */
  if (p_struct->text)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "text", p_struct->text);
  else {
    GWEN_DB_DeleteVar(p_db, "text");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "dateReceived" */
  if (p_struct->dateReceived) {
    GWEN_DB_NODE *dbDest;
    dbDest=GWEN_DB_GetGroup(p_db, GWEN_DB_FLAGS_OVERWRITE_GROUPS, "dateReceived");
    assert(dbDest);
    p_rv=GWEN_Time_toDb(p_struct->dateReceived, dbDest);
  }
  else
    p_rv=0;
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  return 0;
}

AB_MESSAGE *AB_Message_fromDb(GWEN_DB_NODE *p_db)
{
  AB_MESSAGE *p_struct;
  p_struct=AB_Message_new();
  AB_Message_ReadDb(p_struct, p_db);
  return p_struct;
}

int AB_Message_toDb(const AB_MESSAGE *p_struct, GWEN_DB_NODE *p_db)
{
  return AB_Message_WriteDb(p_struct, p_db);
}

void AB_Message_ReadXml(AB_MESSAGE *p_struct, GWEN_XMLNODE *p_db)
{
  assert(p_struct);
  /* member "source" */
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "source", NULL);
    if (s)
      p_struct->source=AB_Message_Source_fromString(s);
    else
      p_struct->source=AB_Message_SourceUnknown;
  }

  /* member "userId" */
  p_struct->userId=GWEN_XMLNode_GetIntValue(p_db, "userId", 0);

  /* member "accountId" */
  p_struct->accountId=GWEN_XMLNode_GetIntValue(p_db, "accountId", 0);

  /* member "subject" */
  if (p_struct->subject) {
    free(p_struct->subject);
    p_struct->subject=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "subject", NULL);
    if (s)
      p_struct->subject=strdup(s);
  }
  if (p_struct->subject==NULL) {  /* preset member "subject" if empty */
    p_struct->subject=NULL;
  }

  /* member "text" */
  if (p_struct->text) {
    free(p_struct->text);
    p_struct->text=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "text", NULL);
    if (s)
      p_struct->text=strdup(s);
  }
  if (p_struct->text==NULL) {  /* preset member "text" if empty */
    p_struct->text=NULL;
  }

  /* member "dateReceived" */
  if (p_struct->dateReceived) {
    GWEN_Time_free(p_struct->dateReceived);
    p_struct->dateReceived=NULL;
  }
  {
    const char *s;
    s=GWEN_XMLNode_GetCharValue(p_db, "dateReceived", NULL);
    if (s && *s)
      p_struct->dateReceived=GWEN_Time_fromString(s, "YYYY/MM/DD-hh:mm");
  }
  if (p_struct->dateReceived==NULL) {  /* preset member "dateReceived" if empty */
    p_struct->dateReceived=NULL;
  }

}

void AB_Message_WriteXml(const AB_MESSAGE *p_struct, GWEN_XMLNODE *p_db)
{
  assert(p_struct);
  /* member "source" */
  GWEN_XMLNode_SetCharValue(p_db, "source", AB_Message_Source_toString(p_struct->source));

  /* member "userId" */
  GWEN_XMLNode_SetIntValue(p_db, "userId", p_struct->userId);

  /* member "accountId" */
  GWEN_XMLNode_SetIntValue(p_db, "accountId", p_struct->accountId);

  /* member "subject" */
  GWEN_XMLNode_SetCharValue(p_db, "subject", p_struct->subject);

  /* member "text" */
  GWEN_XMLNode_SetCharValue(p_db, "text", p_struct->text);

  /* member "dateReceived" */
  if (p_struct->dateReceived) {
    GWEN_BUFFER *xbuf;
    int rv;
    xbuf=GWEN_Buffer_new(0, 32, 0, 1);
    rv=GWEN_Time_toString(p_struct->dateReceived, "YYYY/MM/DD-hh:mm", xbuf);
    if (rv>=0)
      GWEN_XMLNode_SetCharValue(p_db, "dateReceived", GWEN_Buffer_GetStart(xbuf));
    GWEN_Buffer_free(xbuf);
  }

}

void AB_Message_toXml(const AB_MESSAGE *p_struct, GWEN_XMLNODE *p_db)
{
  AB_Message_WriteXml(p_struct, p_db);
}

AB_MESSAGE *AB_Message_fromXml(GWEN_XMLNODE *p_db)
{
  AB_MESSAGE *p_struct;
  p_struct=AB_Message_new();
  AB_Message_ReadXml(p_struct, p_db);
  return p_struct;
}

void AB_Message_toHashString(const AB_MESSAGE *p_struct, GWEN_BUFFER *p_buffer)
{
  assert(p_struct);
  /* member "source" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->source);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "userId" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->userId);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "accountId" */
  {
    char numbuf[32];
    snprintf(numbuf, sizeof(numbuf)-1, "%d", p_struct->accountId);
    numbuf[sizeof(numbuf)-1]=0;
    GWEN_Buffer_AppendString(p_buffer, numbuf);
  }
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "subject" */
  if (p_struct->subject)
    GWEN_Buffer_AppendString(p_buffer, p_struct->subject);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "text" */
  if (p_struct->text)
    GWEN_Buffer_AppendString(p_buffer, p_struct->text);
  GWEN_Buffer_AppendByte(p_buffer, ':');
  /* member "dateReceived" */
  if (p_struct->dateReceived)
    GWEN_Time_toUtcString(p_struct->dateReceived, "YYYY/MM/DD-hh:mm", p_buffer);
  GWEN_Buffer_AppendByte(p_buffer, ':');
}

static AB_MESSAGE *AB_Message_List2__freeAll_cb(AB_MESSAGE *t, void *user_data)
{
  AB_Message_free(t);
  return NULL;
}
int AB_Message_List2_freeAll(AB_MESSAGE_LIST2 *tl)
{
  if (tl) {
    AB_Message_List2_ForEach(tl, AB_Message_List2__freeAll_cb, NULL);
    AB_Message_List2_free(tl);
  }
  else {
    DBG_ERROR(AQBANKING_LOGDOMAIN, "List missing");
    return GWEN_ERROR_INVALID;
  }
  return 0;
}

/* code headers */

