/* kakinoki-to-csa.cc
 */
#include "osl/record/kakinoki.h"
#include "osl/record/ki2.h"
#include "osl/record/csa.h"
#include "osl/record/record.h"
#include <boost/algorithm/string/predicate.hpp>
#include <iostream>
#include <sstream>

using namespace osl;
void convert(const char *filename)
{
  vector<Move> moves;
  vector<int> time;
  vector<std::string> comment;
  vector<record::SearchInfo> move_comment;
  Record record;
  NumEffectState state;
  if (boost::algorithm::iends_with(filename, ".ki2")) {
    Ki2File file(filename);
    record = file.getRecord();
    state = file.getInitialState();
  }
  else {
    KakinokiFile file(filename);
    record = file.getRecord();
    state = file.getInitialState();
  }
  std::cout << "N+" << record.getPlayer(BLACK) << std::endl;
  std::cout << "N-" << record.getPlayer(WHITE) << std::endl;
  record.getMoves(moves, time, comment, move_comment);
  std::cout << state;
  for (size_t i=0; i<moves.size(); ++i) 
  {
    std::cout << record::csa::show(moves[i]) << std::endl;
    if (i < comment.size()) 
    {
      std::istringstream is(comment[i]);
      std::string line;
      while (std::getline(is, line)) 
	std::cout << "'* " << line << std::endl;
    }
  }
}

int main(int argc, char **argv)
{
  for (int i=1; i<argc; ++i)
    convert(argv[i]);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
