/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.tests;

import gr.zeus.ui.JConsolePane;
import gr.zeus.ui.JMessage;
import gr.zeus.util.GUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class JConsolePaneTester
extends JFrame {
    private static JConsolePane s_consolePane = JConsolePane.getConsolePane();
    private boolean m_realExit = true;
    private JPanel centerPanel;
    private JComboBox comboBox;
    private JButton errorButton;
    private JButton exceptionButton;
    private JButton helloButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel northPanel;
    private JButton showConsole;
    private JPanel southPanel;
    private JButton submitButton;
    private JTextField textField;
    private JToggleButton toggleButton;

    public JConsolePaneTester() {
        this.initComponents();
        this.centerPanel.add(s_consolePane);
        GUIUtils.centerOnScreen(this);
    }

    public void setExitMode(boolean exit) {
        this.m_realExit = exit;
    }

    private void myExit(int code) {
        if (code != 0) {
            try {
                s_consolePane.dumpConsole("dump.log", false);
            }
            catch (IOException ex) {
                JMessage.showErrorMessage(this, "Error saving logfile!", ex);
            }
            JMessage.showErrorMessage(this, "Application Error!\nCheck dump.log for details!");
        }
        s_consolePane.destroyConsole();
        System.out.println("Hello again from stdout");
        System.err.println("Hello again from stderr");
        if (this.m_realExit) {
            System.exit(code);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void initComponents() {
        this.northPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.textField = new JTextField();
        this.comboBox = new JComboBox();
        this.submitButton = new JButton();
        this.jLabel1 = new JLabel();
        this.centerPanel = new JPanel();
        this.southPanel = new JPanel();
        this.helloButton = new JButton();
        this.errorButton = new JButton();
        this.exceptionButton = new JButton();
        this.toggleButton = new JToggleButton();
        this.showConsole = new JButton();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem consoleMenuItem = new JMenuItem();
        JMenuItem errorExitMenuItem = new JMenuItem();
        JMenuItem normalExitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("JConsolePaneTester");
        this.northPanel.setLayout(new BorderLayout());
        this.textField.setText("Type something");
        this.jPanel1.add(this.textField);
        this.comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"One", "Two", "Three"}));
        this.jPanel1.add(this.comboBox);
        this.submitButton.setText("Submit");
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePaneTester.this.submitButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.submitButton);
        this.northPanel.add((Component)this.jPanel1, "Center");
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("This is a JConsole inside another JFrame!");
        this.northPanel.add((Component)this.jLabel1, "South");
        this.getContentPane().add((Component)this.northPanel, "North");
        this.centerPanel.setBorder(BorderFactory.createTitledBorder("JConsole"));
        this.centerPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.helloButton.setText("Hello");
        this.helloButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePaneTester.this.helloButtonActionPerformed(evt);
            }
        });
        this.southPanel.add(this.helloButton);
        this.errorButton.setText("Error");
        this.errorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePaneTester.this.errorButtonActionPerformed(evt);
            }
        });
        this.southPanel.add(this.errorButton);
        this.exceptionButton.setText("Exception");
        this.exceptionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePaneTester.this.exceptionButtonActionPerformed(evt);
            }
        });
        this.southPanel.add(this.exceptionButton);
        this.toggleButton.setText("Show/Hide Control Buttons");
        this.toggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePaneTester.this.toggleButtonActionPerformed(evt);
            }
        });
        this.southPanel.add(this.toggleButton);
        this.showConsole.setText("Show Console");
        this.showConsole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePaneTester.this.showConsoleActionPerformed(evt);
            }
        });
        this.southPanel.add(this.showConsole);
        this.getContentPane().add((Component)this.southPanel, "South");
        fileMenu.setText("File");
        consoleMenuItem.setText("Show Console");
        consoleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePaneTester.this.consoleMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(consoleMenuItem);
        errorExitMenuItem.setText("Exit with error code");
        errorExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePaneTester.this.errorExitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(errorExitMenuItem);
        normalExitMenuItem.setText("Normal Exit");
        normalExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsolePaneTester.this.normalExitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(normalExitMenuItem);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.setBounds(0, 0, 640, 480);
    }

    private void normalExitMenuItemActionPerformed(ActionEvent evt) {
        this.myExit(0);
    }

    private void errorExitMenuItemActionPerformed(ActionEvent evt) {
        this.myExit(1);
    }

    private void consoleMenuItemActionPerformed(ActionEvent evt) {
        s_consolePane.setVisible(true);
    }

    private void showConsoleActionPerformed(ActionEvent evt) {
        s_consolePane.showConsole();
    }

    private void toggleButtonActionPerformed(ActionEvent evt) {
        if (this.toggleButton.isSelected()) {
            s_consolePane.showControlButtons();
        } else {
            s_consolePane.hideControlButtons();
        }
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        System.out.println("comboBox=" + this.comboBox.getSelectedItem());
        System.out.println("textField=" + this.textField.getText());
    }

    private void exceptionButtonActionPerformed(ActionEvent evt) {
        String numS = "this is not a number!";
        int num = Integer.parseInt(numS);
        System.out.println("num=" + num);
    }

    private void errorButtonActionPerformed(ActionEvent evt) {
        System.err.println("Hello new stderr!");
    }

    private void helloButtonActionPerformed(ActionEvent evt) {
        System.out.println("Hello new stdout!");
    }

    private static void init_lnf() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            s_consolePane.updateLNF();
        }
        catch (Exception e) {
            System.err.println("Cannot initialize the look & feel");
            e.printStackTrace();
        }
    }

    private static void init_console() {
        System.out.println("Hello and goodbye from stdout");
        System.err.println("Hello and goodbye from stderr");
        s_consolePane.setBackgroundColor(Color.WHITE);
        s_consolePane.setForegroundColor(Color.BLACK);
        s_consolePane.setSelectedTextColor(Color.WHITE);
        s_consolePane.setSelectionColor(Color.DARK_GRAY);
        s_consolePane.setAppendFirstTime(false);
        s_consolePane.setAutoSave(true);
        s_consolePane.hideControlButtons();
        s_consolePane.startConsole();
        System.out.println("This is the very first message logged to JConsole (stdout)");
        System.err.println("This is the very first message logged to JConsole (stderr)");
    }

    public static void main(String[] args) {
        JConsolePaneTester.init_lnf();
        JConsolePaneTester.init_console();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JConsolePaneTester().setVisible(true);
            }
        });
    }
}

