/*
  This file is part of MADNESS.

  Copyright (C) 2014 Virgina Tech

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  For more information please contact:

  Robert J. Harrison
  Oak Ridge National Laboratory
  One Bethel Valley Road
  P.O. Box 2008, MS-6367

  email: harrisonrj@ornl.gov
  tel:   865-241-3937
  fax:   865-572-0680
*/

/**
 \file madness.h
 \brief General header file for using MADNESS.
 \ingroup applications
*/

#ifndef MADNESS_H__INCLUDED
#define MADNESS_H__INCLUDED

#include <madness/mra/mra.h>

// Documentation for MADNESS namespaces.

/// Namespace for all elements and tools of MADNESS.
namespace madness {

    /// Namespace for I/O tools.
    namespace archive { 
    }

    /// \todo Description needed
    namespace cblas {
    }

    /// Namespace storing mathematical and physical constants.
    namespace constants {
    }

    /// \todo Description needed
    namespace detail {
    }

    /// \todo Description needed
    namespace Hash_private {
    }

    /// Runtime details on the configuration and version of MADNESS.
    namespace info {
    }

    /// \todo Description needed
    namespace profiling {
    }

    /// \todo Description needed
    namespace tr1 {
    }

} // namespace madness

#endif // MADNESS_H__INCLUDED
