/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef HOVAREA_H
#define HOVAREA_H

#include "Hovmoeller.h"
#include "HovToolkit.h"

class HovAreaToolkit : public HovToolkit
{
public:
    HovAreaToolkit();
    ~HovAreaToolkit(){};

    // Common functions
    string GetTitle(ParamInfo*);
    const char* GetSecondCoordName();
    bool SecondAuxiliaryCoord() { return false; }
    const char* ApplicationType() { return "AREA_HOVM"; }
    bool NcWriteSecondCoord();
    void NcWriteGlobalAttributesApp();

    // Calculate diagram values
    bool ComputeValues(MvField&, int = 0);

    // Compute coordinates
    bool ComputeSecondCoord();

    // Initialize variables
    bool GetInputInfo(MvRequest&);  //from user interface
    bool GetInputInfo(MvNetCDF*);   //from the netCDF file

    // Check if parameters between two requests are consistent
    bool consistencyCheck(MvRequest&, MvRequest&);

private:
    // Create View request
    MvRequest CreateViewRequest();

    int geoDir_;  // average direction: East-West or North-South
};

//---------------------------------------------------------------------

class AreaHovmoeller : public HovAreaToolkit, public Hovmoeller
{
public:
    AreaHovmoeller() :
        Hovmoeller("AREA_HOVM"){};
    AreaHovmoeller(const char* kw) :
        Hovmoeller(kw){};

    ~AreaHovmoeller(){};

    // Entry point
    void serve(MvRequest& in, MvRequest& out);
};

static SimpleObjectMaker<HovAreaToolkit, HovToolkit> area("AREA");

//---------------------------------------------------------------------

class AreaHovmoellerM3 : public AreaHovmoeller
{
public:
    AreaHovmoellerM3() :
        AreaHovmoeller("AREA_HOV"){};
    ~AreaHovmoellerM3(){};

    // Entry point
    void serve(MvRequest&, MvRequest&);
};

#endif
