/*************************************************
 * fax.c                                         *
 *						 *
 * Version : 0.1 				 *
 * Date    : 05.06.95 				 *
 * Author  : Fabian Hoppe 			 *
 *						 *
 * Fax Enhancement for XTeXSh                    *
 *************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <string.h>

/* 
 * fax.c scans for the appearence of the string FaxNumberString 
 * within the TeX-File by comparing the _first_ characters of each line 
 * with the contents of the string FaxNumberString. If it finds the first 
 * occurence, it copies the next line into the string phonenumber, 
 * deleting any non-numeric character. If you adapt the program and 
 * the faxheader to your needs, change the FaxNumberString to the string 
 * which proceeds the line containing the actual faxnumber.
 */

#define FaxNumberString		"Fax-Nummer"

/*
 * This is the actual location of faxspool. 
 */

#define LocationOfFaxspool	"/usr/local/bin/faxspool"

main(argc,argv)
int 	argc;
char   *argv[];
{
	char	*phonenumber;
	char	*filename;
	char	*dvifilename;
	char	*row;
	char	*tmp1;
	char	*tmp2;
	FILE	*fd;

	phonenumber=(char *)malloc(100);
	filename=(char *)malloc(100);
	dvifilename=(char *)malloc(100);
	row=(char *)malloc(200);

	/* 
	 * Get the filename w/o extention and 
	 * compose the TeX- and the DVI-Filename
	 */

	(void) strcpy(filename,argv[1]);
	(void) strcat(filename,".tex");

	(void) strcpy(dvifilename,argv[1]);
	(void) strcat(dvifilename,".dvi");

	fd=fopen(filename,"r");

	if (fd==NULL) 
	{
		(void) fprintf(stderr,"File %s not found!\n",filename);
		exit(1);
	}
	
	/*
	 * As long there are lines to read, get them...
	 */

	while (fgets(row,200,fd)!=NULL) 
	{
		/*
		 * Compare the _first_ characters of the actual row
		 * with the string FaxNumberString.
		 */
		
		if (strncmp(row,FaxNumberString,strlen(FaxNumberString))==0) 
		{

			/*
			 * FaxNumberString found. Now read the next 
			 * line, which should contain the actual
			 * faxnumber.
			 */

			(void) fgets(row,200,fd);

			tmp1=phonenumber;
			tmp2=row;

			/*
			 * Get all numeric characters in this 
			 * line. The line delimiter is a backslash.
			 */

			while (*tmp2!='\134') 
			{
				if ((*tmp2>='0') && (*tmp2<='9')) 
				{
					*tmp1=*tmp2;
					tmp1++;
				}
				tmp2++;
			}
		}
	}
	fclose(fd);

	/*
	 * Any phonenumber found ? 
	 */

	if (strlen(phonenumber)!=0)
	{
		/*
		 * .. then execute faxspool with parameter
		 * phonenumber and DVI-Filename
		 */

		execl(LocationOfFaxspool,
                      "faxspool",
                      phonenumber,
                      dvifilename,
                      0);
	}
	else
	{
		fprintf(stderr,"No phonenumber found!\n");
		exit(2);
	}
}


