/*
 * Copyright (C) 2003-2013 The Music Player Daemon Project
 * http://www.musicpd.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*
 * This program is a command line interface to MPD's software volume
 * library (pcm_volume.c).
 *
 */

#include "config.h"
#include "pcm/PcmVolume.hxx"
#include "AudioParser.hxx"
#include "AudioFormat.hxx"
#include "util/Error.hxx"
#include "stdbin.h"

#include <glib.h>

#include <stddef.h>
#include <unistd.h>

int main(int argc, char **argv)
{
	static char buffer[4096];
	ssize_t nbytes;

	if (argc > 2) {
		g_printerr("Usage: software_volume [FORMAT] <IN >OUT\n");
		return 1;
	}

	Error error;
	AudioFormat audio_format(48000, SampleFormat::S16, 2);
	if (argc > 1) {
		if (!audio_format_parse(audio_format, argv[1], false, error)) {
			g_printerr("Failed to parse audio format: %s\n",
				   error.GetMessage());
			return 1;
		}
	}

	while ((nbytes = read(0, buffer, sizeof(buffer))) > 0) {
		if (!pcm_volume(buffer, nbytes,
				audio_format.format,
				PCM_VOLUME_1 / 2)) {
			g_printerr("pcm_volume() has failed\n");
			return 2;
		}

		gcc_unused ssize_t ignored = write(1, buffer, nbytes);
	}
}
