# ----------------------------------------------------------------------------
#  Loads the current version number:
# ----------------------------------------------------------------------------
file(STRINGS "${CMAKE_CURRENT_SOURCE_DIR}/version_prefix.txt" CMAKE_MRPT_VERSION_NUMBER LIMIT_COUNT 1) # Read only the first line

# For example: "0.5.1"
string(REGEX MATCHALL "[0-9]+" CMAKE_MRPT_VERSION_PARTS "${CMAKE_MRPT_VERSION_NUMBER}")

list(GET CMAKE_MRPT_VERSION_PARTS 0 CMAKE_MRPT_VERSION_NUMBER_MAJOR)
list(GET CMAKE_MRPT_VERSION_PARTS 1 CMAKE_MRPT_VERSION_NUMBER_MINOR)
list(GET CMAKE_MRPT_VERSION_PARTS 2 CMAKE_MRPT_VERSION_NUMBER_PATCH)
set(CMAKE_MRPT_FULL_VERSION "${CMAKE_MRPT_VERSION_NUMBER_MAJOR}.${CMAKE_MRPT_VERSION_NUMBER_MINOR}.${CMAKE_MRPT_VERSION_NUMBER_PATCH}")

if(WIN32)
	if (MSVC)
		# 1700 = VC 11.0 (2012)
		# 1800 = VC 12.0 (2013)
		#           ... (13 was skipped!)
		# 1900 = VC 14.0 (2015)
		# 1910 = VC 14.1 (2017)
		math(EXPR MSVC_VERSION_3D "(${MSVC_VERSION}/10)-60")
		if (MSVC_VERSION_3D GREATER 120)
			math(EXPR MSVC_VERSION_3D "${MSVC_VERSION_3D}+10")
		endif()
		set(CMAKE_MRPT_COMPILER_NAME "_msvc${MSVC_VERSION_3D}")
	else()
		set(CMAKE_MRPT_COMPILER_NAME "_${CMAKE_CXX_COMPILER_ID}")
	endif()
	set(MRPT_DLL_VERSION_POSTFIX "${CMAKE_MRPT_VERSION_NUMBER_MAJOR}${CMAKE_MRPT_VERSION_NUMBER_MINOR}${CMAKE_MRPT_VERSION_NUMBER_PATCH}${CMAKE_MRPT_COMPILER_NAME}_x${CMAKE_MRPT_WORD_SIZE}")
else(WIN32)
	set(MRPT_DLL_VERSION_POSTFIX "")
endif(WIN32)
