C
C $Id: gtpzbd.f,v 1.9 2008-07-27 00:17:08 haley Exp $
C
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C
      SUBROUTINE GTPZBD
C
C Calling this do-nothing subroutine forces "ld" to load the following
C block data routine (but only if they are in the same ".f" file).
C
        RETURN
C
      END
CNOSPLIT
      BLOCKDATA GTPZBDX
C
        COMMON /PRINZ0/ IPEMSG,IPELUN,IPPARM,IPPLUN
        SAVE   /PRINZ0/
C
        COMMON /STPLCH/ NM27,NM83
          CHARACTER*32 NM27(134),NM83(134)
        SAVE   /STPLCH/
C
        COMMON /STPLDP/ PA27,PA83
          DOUBLE PRECISION PA27(9,134),PA83(9,134)
        SAVE   /STPLDP/
C
        COMMON /STPLIR/ ID27,ID83
          INTEGER ID27(134),ID83(134)
        SAVE   /STPLIR/
C
        COMMON /USGSC1/  UTPA(15),UUMN,UUMX,UVMN,UVMX,IPRF
        DOUBLE PRECISION UTPA,UUMN,UUMX,UVMN,UVMX
        INTEGER IPRF
        SAVE   /USGSC1/
C
        DATA IPEMSG /    1    /
        DATA IPELUN /    6    /
        DATA IPPARM /    1    /
        DATA IPPLUN /    6    /
        DATA UTPA   / 15*0.D0 /
        DATA UUMN   /    0.D0 /
        DATA UUMX   /    0.D0 /
        DATA UVMN   /    0.D0 /
        DATA UVMX   /    0.D0 /
        DATA IPRF   /    0    /
C
        DATA NM27(  1),ID27(  1) /'ALABAMA         EAST            ',1/
        DATA (PA27(I,  1),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8550000000000000D+06 ,
     +             0.9999600000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3030000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(  2),ID27(  2) /'ALABAMA         WEST            ',1/
        DATA (PA27(I,  2),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8730000000000000D+06 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3000000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(  3),ID27(  3) /'ALASKA          ZONE NO. 10     ',2/
        DATA (PA27(I,  3),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1760000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.5350000000000000D+06 ,
     +             0.5150000000000000D+06 ,    0.5100000000000000D+06 ,
     +             0.9144018288036576D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(  4),ID27(  4) /'AMERICAN SAMOA                  ',2/
        DATA (PA27(I,  4),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1700000000000000D+07 ,
     +             0.1000000000000000D+01 ,   -0.1416000000000000D+06 ,
     +            -0.1416000000000000D+06 ,   -0.1416000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.9516931165862332D+05 /
C
        DATA NM27(  5),ID27(  5) /'ARIZONA         EAST            ',1/
        DATA (PA27(I,  5),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1101000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(  6),ID27(  6) /'ARIZONA         CENTRAL         ',1/
        DATA (PA27(I,  6),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1115500000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(  7),ID27(  7) /'ARIZONA         WEST            ',1/
        DATA (PA27(I,  7),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1134500000000000D+07 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(  8),ID27(  8) /'ARKANSAS        NORTH           ',2/
        DATA (PA27(I,  8),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9200000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3614000000000000D+06 ,
     +             0.3456000000000000D+06 ,    0.3420000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(  9),ID27(  9) /'ARKANSAS        SOUTH           ',2/
        DATA (PA27(I,  9),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9200000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3446000000000000D+06 ,
     +             0.3318000000000000D+06 ,    0.3240000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 10),ID27( 10) /'CALIFORNIA      I               ',2/
        DATA (PA27(I, 10),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1220000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4140000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.3920000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 11),ID27( 11) /'CALIFORNIA      II              ',2/
        DATA (PA27(I, 11),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1220000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3950000000000000D+06 ,
     +             0.3820000000000000D+06 ,    0.3740000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 12),ID27( 12) /'CALIFORNIA      III             ',2/
        DATA (PA27(I, 12),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1203000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3826000000000000D+06 ,
     +             0.3704000000000000D+06 ,    0.3630000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 13),ID27( 13) /'CALIFORNIA      IV              ',2/
        DATA (PA27(I, 13),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1190000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3715000000000000D+06 ,
     +             0.3600000000000000D+06 ,    0.3520000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 14),ID27( 14) /'CALIFORNIA      V               ',2/
        DATA (PA27(I, 14),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1180000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3528000000000000D+06 ,
     +             0.3402000000000000D+06 ,    0.3330000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 15),ID27( 15) /'CALIFORNIA      VI              ',2/
        DATA (PA27(I, 15),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1161500000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3353000000000000D+06 ,
     +             0.3247000000000000D+06 ,    0.3210000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 16),ID27( 16) /'CALIFORNIA      VII             ',2/
        DATA (PA27(I, 16),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1182000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3425000000000000D+06 ,
     +             0.3352000000000000D+06 ,    0.3408000000000000D+06 ,
     +             0.1276106450596901D+07 ,    0.1268253006858014D+07 /
C
        DATA NM27( 17),ID27( 17) /'COLORADO        NORTH           ',2/
        DATA (PA27(I, 17),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1053000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4047000000000000D+06 ,
     +             0.3943000000000000D+06 ,    0.3920000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 18),ID27( 18) /'COLORADO        CENTRAL         ',2/
        DATA (PA27(I, 18),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1053000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3945000000000000D+06 ,
     +             0.3827000000000000D+06 ,    0.3750000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 19),ID27( 19) /'COLORADO        SOUTH           ',2/
        DATA (PA27(I, 19),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1053000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3826000000000000D+06 ,
     +             0.3714000000000000D+06 ,    0.3640000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 20),ID27( 20) /'CONNECTICUT     ---             ',2/
        DATA (PA27(I, 20),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7245000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4152000000000000D+06 ,
     +             0.4112000000000000D+06 ,    0.4050000000000000D+06 ,
     +             0.1828803657607315D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 21),ID27( 21) /'DELAWARE        ---             ',1/
        DATA (PA27(I, 21),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7525000000000000D+06 ,
     +             0.9999950000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3800000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 22),ID27( 22) /'FLORIDA         EAST            ',1/
        DATA (PA27(I, 22),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8100000000000000D+06 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2420000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 23),ID27( 23) /'FLORIDA         WEST            ',1/
        DATA (PA27(I, 23),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8200000000000000D+06 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2420000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 24),ID27( 24) /'FLORIDA         NORTH           ',2/
        DATA (PA27(I, 24),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8430000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3045000000000000D+06 ,
     +             0.2935000000000000D+06 ,    0.2900000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 25),ID27( 25) /'GEORGIA         EAST            ',1/
        DATA (PA27(I, 25),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8210000000000000D+06 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3000000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 26),ID27( 26) /'GEORGIA         WEST            ',1/
        DATA (PA27(I, 26),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8410000000000000D+06 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3000000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 27),ID27( 27) /'HAWAII          1               ',1/
        DATA (PA27(I, 27),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1553000000000000D+07 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.1850000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 28),ID27( 28) /'HAWAII          2               ',1/
        DATA (PA27(I, 28),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1564000000000000D+07 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2020000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 29),ID27( 29) /'HAWAII          3               ',1/
        DATA (PA27(I, 29),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1580000000000000D+07 ,
     +             0.9999900000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2110000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 30),ID27( 30) /'HAWAII          4               ',1/
        DATA (PA27(I, 30),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1593000000000000D+07 ,
     +             0.9999900000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2150000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 31),ID27( 31) /'HAWAII          5               ',1/
        DATA (PA27(I, 31),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1601000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2140000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 32),ID27( 32) /'IDAHO           EAST            ',1/
        DATA (PA27(I, 32),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1121000000000000D+07 ,
     +             0.9999473684210526D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4140000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 33),ID27( 33) /'IDAHO           CENTRAL         ',1/
        DATA (PA27(I, 33),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1140000000000000D+07 ,
     +             0.9999473684210526D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4140000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 34),ID27( 34) /'IDAHO           WEST            ',1/
        DATA (PA27(I, 34),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1154500000000000D+07 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4140000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 35),ID27( 35) /'ILLINOIS        EAST            ',1/
        DATA (PA27(I, 35),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8820000000000000D+06 ,
     +             0.9999750000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3640000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 36),ID27( 36) /'ILLINOIS        WEST            ',1/
        DATA (PA27(I, 36),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9010000000000000D+06 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3640000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 37),ID27( 37) /'INDIANA         EAST            ',1/
        DATA (PA27(I, 37),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8540000000000000D+06 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3730000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 38),ID27( 38) /'INDIANA         WEST            ',1/
        DATA (PA27(I, 38),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8705000000000000D+06 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3730000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 39),ID27( 39) /'IOWA            NORTH           ',2/
        DATA (PA27(I, 39),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9330000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4316000000000000D+06 ,
     +             0.4204000000000000D+06 ,    0.4130000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 40),ID27( 40) /'IOWA            SOUTH           ',2/
        DATA (PA27(I, 40),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9330000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4147000000000000D+06 ,
     +             0.4037000000000000D+06 ,    0.4000000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 41),ID27( 41) /'KANSAS          NORTH           ',2/
        DATA (PA27(I, 41),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9800000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3947000000000000D+06 ,
     +             0.3843000000000000D+06 ,    0.3820000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 42),ID27( 42) /'KANSAS          SOUTH           ',2/
        DATA (PA27(I, 42),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9830000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3834000000000000D+06 ,
     +             0.3716000000000000D+06 ,    0.3640000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 43),ID27( 43) /'KENTUCKY        NORTH           ',2/
        DATA (PA27(I, 43),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8415000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3858000000000000D+06 ,
     +             0.3758000000000000D+06 ,    0.3730000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 44),ID27( 44) /'KENTUCKY        SOUTH           ',2/
        DATA (PA27(I, 44),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8545000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3756000000000000D+06 ,
     +             0.3644000000000000D+06 ,    0.3620000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 45),ID27( 45) /'LOUISIANA       NORTH           ',2/
        DATA (PA27(I, 45),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9230000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3240000000000000D+06 ,
     +             0.3110000000000000D+06 ,    0.3040000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 46),ID27( 46) /'LOUISIANA       SOUTH           ',2/
        DATA (PA27(I, 46),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9120000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3042000000000000D+06 ,
     +             0.2918000000000000D+06 ,    0.2840000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 47),ID27( 47) /'LOUISIANA       OFFSHORE        ',2/
        DATA (PA27(I, 47),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9120000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.2750000000000000D+06 ,
     +             0.2610000000000000D+06 ,    0.2540000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 48),ID27( 48) /'MAINE           EAST            ',1/
        DATA (PA27(I, 48),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.6830000000000000D+06 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4350000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 49),ID27( 49) /'MAINE           WEST            ',1/
        DATA (PA27(I, 49),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7010000000000000D+06 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4250000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 50),ID27( 50) /'MARYLAND        ---             ',2/
        DATA (PA27(I, 50),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7700000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3927000000000000D+06 ,
     +             0.3818000000000000D+06 ,    0.3750000000000000D+06 ,
     +             0.2438404876809754D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 51),ID27( 51) /'MASSACHUSETTS   MAINLAND        ',2/
        DATA (PA27(I, 51),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7130000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4241000000000000D+06 ,
     +             0.4143000000000000D+06 ,    0.4100000000000000D+06 ,
     +             0.1828803657607315D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 52),ID27( 52) /'MASSACHUSETTS   ISLAND          ',2/
        DATA (PA27(I, 52),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7030000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4129000000000000D+06 ,
     +             0.4117000000000000D+06 ,    0.4100000000000000D+06 ,
     +             0.6096012192024384D+05 ,    0.0000000000000000D+00 /
C
        DATA NM27( 53),ID27( 53) /'MICHIGAN        EAST            ',1/
        DATA (PA27(I, 53),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8340000000000000D+06 ,
     +             0.9999428571428571D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4130000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 54),ID27( 54) /'MICHIGAN        CENTRAL/M       ',1/
        DATA (PA27(I, 54),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8545000000000000D+06 ,
     +             0.9999090909090909D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4130000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 55),ID27( 55) /'MICHIGAN        WEST            ',1/
        DATA (PA27(I, 55),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8845000000000000D+06 ,
     +             0.9999090909090909D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4130000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 56),ID27( 56) /'MICHIGAN        NORTH           ',2/
        DATA (PA27(I, 56),I=1,9) /             0.6378450047000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8700000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4705000000000000D+06 ,
     +             0.4529000000000000D+06 ,    0.4447000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 57),ID27( 57) /'MICHIGAN        CENTRAL/L       ',2/
        DATA (PA27(I, 57),I=1,9) /             0.6378450047000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8420000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4542000000000000D+06 ,
     +             0.4411000000000000D+06 ,    0.4319000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 58),ID27( 58) /'MICHIGAN        SOUTH           ',2/
        DATA (PA27(I, 58),I=1,9) /             0.6378450047000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8420000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4340000000000000D+06 ,
     +             0.4206000000000000D+06 ,    0.4130000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 59),ID27( 59) /'MINNESOTA       NORTH           ',2/
        DATA (PA27(I, 59),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9306000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4838000000000000D+06 ,
     +             0.4702000000000000D+06 ,    0.4630000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 60),ID27( 60) /'MINNESOTA       CENTRAL         ',2/
        DATA (PA27(I, 60),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9415000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4703000000000000D+06 ,
     +             0.4537000000000000D+06 ,    0.4500000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 61),ID27( 61) /'MINNESOTA       SOUTH           ',2/
        DATA (PA27(I, 61),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9400000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4513000000000000D+06 ,
     +             0.4347000000000000D+06 ,    0.4300000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 62),ID27( 62) /'MISSISSIPPI     EAST            ',1/
        DATA (PA27(I, 62),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8850000000000000D+06 ,
     +             0.9999600000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2940000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 63),ID27( 63) /'MISSISSIPPI     WEST            ',1/
        DATA (PA27(I, 63),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9020000000000000D+06 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3030000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 64),ID27( 64) /'MISSOURI        EAST            ',1/
        DATA (PA27(I, 64),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9030000000000000D+06 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3550000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 65),ID27( 65) /'MISSOURI        CENTRAL         ',1/
        DATA (PA27(I, 65),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9230000000000000D+06 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3550000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 66),ID27( 66) /'MISSOURI        WEST            ',1/
        DATA (PA27(I, 66),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9430000000000000D+06 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3610000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 67),ID27( 67) /'MONTANA         NORTH           ',2/
        DATA (PA27(I, 67),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1093000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4843000000000000D+06 ,
     +             0.4751000000000000D+06 ,    0.4700000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 68),ID27( 68) /'MONTANA         CENTRAL         ',2/
        DATA (PA27(I, 68),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1093000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4753000000000000D+06 ,
     +             0.4627000000000000D+06 ,    0.4550000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 69),ID27( 69) /'MONTANA         SOUTH           ',2/
        DATA (PA27(I, 69),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1093000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4624000000000000D+06 ,
     +             0.4452000000000000D+06 ,    0.4400000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 70),ID27( 70) /'NEBRASKA        NORTH           ',2/
        DATA (PA27(I, 70),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1000000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4249000000000000D+06 ,
     +             0.4151000000000000D+06 ,    0.4120000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 71),ID27( 71) /'NEBRASKA        SOUTH           ',2/
        DATA (PA27(I, 71),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9930000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4143000000000000D+06 ,
     +             0.4017000000000000D+06 ,    0.3940000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 72),ID27( 72) /'NEVADA          EAST            ',1/
        DATA (PA27(I, 72),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1153500000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3445000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 73),ID27( 73) /'NEVADA          CENTRAL         ',1/
        DATA (PA27(I, 73),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1164000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3445000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 74),ID27( 74) /'NEVADA          WEST            ',1/
        DATA (PA27(I, 74),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1183500000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3445000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 75),ID27( 75) /'NEW HAMPSHIRE   ---             ',1/
        DATA (PA27(I, 75),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7140000000000000D+06 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4230000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 76),ID27( 76) /'NEW JERSEY      ---             ',1/
        DATA (PA27(I, 76),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7440000000000000D+06 ,
     +             0.9999750000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3850000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 77),ID27( 77) /'NEW MEXICO      EAST            ',1/
        DATA (PA27(I, 77),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1042000000000000D+07 ,
     +             0.9999090909090909D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 78),ID27( 78) /'NEW MEXICO      CENTRAL         ',1/
        DATA (PA27(I, 78),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1061500000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 79),ID27( 79) /'NEW MEXICO      WEST            ',1/
        DATA (PA27(I, 79),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1075000000000000D+07 ,
     +             0.9999166666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 80),ID27( 80) /'NEW YORK        EAST            ',1/
        DATA (PA27(I, 80),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7420000000000000D+06 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4000000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 81),ID27( 81) /'NEW YORK        CENTRAL         ',1/
        DATA (PA27(I, 81),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7635000000000000D+06 ,
     +             0.9999375000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4000000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 82),ID27( 82) /'NEW YORK        WEST            ',1/
        DATA (PA27(I, 82),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7835000000000000D+06 ,
     +             0.9999375000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4000000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 83),ID27( 83) /'NEW YORK        LONG ISLAND     ',2/
        DATA (PA27(I, 83),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7400000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4102000000000000D+06 ,
     +             0.4040000000000000D+06 ,    0.4030000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.3048006096012192D+05 /
C
        DATA NM27( 84),ID27( 84) /'NORTH CAROLINA  ---             ',2/
        DATA (PA27(I, 84),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7900000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3610000000000000D+06 ,
     +             0.3420000000000000D+06 ,    0.3345000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 85),ID27( 85) /'NORTH DAKOTA    NORTH           ',2/
        DATA (PA27(I, 85),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1003000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4844000000000000D+06 ,
     +             0.4726000000000000D+06 ,    0.4700000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 86),ID27( 86) /'NORTH DAKOTA    SOUTH           ',2/
        DATA (PA27(I, 86),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1003000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4729000000000000D+06 ,
     +             0.4611000000000000D+06 ,    0.4540000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 87),ID27( 87) /'OHIO            NORTH           ',2/
        DATA (PA27(I, 87),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8230000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4142000000000000D+06 ,
     +             0.4026000000000000D+06 ,    0.3940000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 88),ID27( 88) /'OHIO            SOUTH           ',2/
        DATA (PA27(I, 88),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8230000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4002000000000000D+06 ,
     +             0.3844000000000000D+06 ,    0.3800000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 89),ID27( 89) /'OKLAHOMA        NORTH           ',2/
        DATA (PA27(I, 89),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9800000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3646000000000000D+06 ,
     +             0.3534000000000000D+06 ,    0.3500000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 90),ID27( 90) /'OKLAHOMA        SOUTH           ',2/
        DATA (PA27(I, 90),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9800000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3514000000000000D+06 ,
     +             0.3356000000000000D+06 ,    0.3320000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 91),ID27( 91) /'OREGON          NORTH           ',2/
        DATA (PA27(I, 91),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1203000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4600000000000000D+06 ,
     +             0.4420000000000000D+06 ,    0.4340000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 92),ID27( 92) /'OREGON          SOUTH           ',2/
        DATA (PA27(I, 92),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1203000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4400000000000000D+06 ,
     +             0.4220000000000000D+06 ,    0.4140000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 93),ID27( 93) /'PENNSYLVANIA    NORTH           ',2/
        DATA (PA27(I, 93),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7745000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4157000000000000D+06 ,
     +             0.4053000000000000D+06 ,    0.4010000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 94),ID27( 94) /'PENNSYLVANIA    SOUTH           ',2/
        DATA (PA27(I, 94),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7745000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4058000000000000D+06 ,
     +             0.3956000000000000D+06 ,    0.3920000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 95),ID27( 95) /'RHODE ISLAND    ---             ',1/
        DATA (PA27(I, 95),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7130000000000000D+06 ,
     +             0.9999937500000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4105000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 96),ID27( 96) /'SOUTH CAROLINA  NORTH           ',2/
        DATA (PA27(I, 96),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8100000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3458000000000000D+06 ,
     +             0.3346000000000000D+06 ,    0.3300000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 97),ID27( 97) /'SOUTH CAROLINA  SOUTH           ',2/
        DATA (PA27(I, 97),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8100000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3340000000000000D+06 ,
     +             0.3220000000000000D+06 ,    0.3150000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 98),ID27( 98) /'SOUTH DAKOTA    NORTH           ',2/
        DATA (PA27(I, 98),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1000000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4541000000000000D+06 ,
     +             0.4425000000000000D+06 ,    0.4350000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27( 99),ID27( 99) /'SOUTH DAKOTA    SOUTH           ',2/
        DATA (PA27(I, 99),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1002000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4424000000000000D+06 ,
     +             0.4250000000000000D+06 ,    0.4220000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(100),ID27(100) /'TENNESSEE       ---             ',2/
        DATA (PA27(I,100),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8600000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3625000000000000D+06 ,
     +             0.3515000000000000D+06 ,    0.3440000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.3048006096012192D+05 /
C
        DATA NM27(101),ID27(101) /'TEXAS           NORTH           ',2/
        DATA (PA27(I,101),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1013000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3611000000000000D+06 ,
     +             0.3439000000000000D+06 ,    0.3400000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(102),ID27(102) /'TEXAS           NORTH CENTRAL   ',2/
        DATA (PA27(I,102),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9730000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3358000000000000D+06 ,
     +             0.3208000000000000D+06 ,    0.3140000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(103),ID27(103) /'TEXAS           CENTRAL         ',2/
        DATA (PA27(I,103),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1002000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3153000000000000D+06 ,
     +             0.3007000000000000D+06 ,    0.2940000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(104),ID27(104) /'TEXAS           SOUTH CENTRAL   ',2/
        DATA (PA27(I,104),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9900000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3017000000000000D+06 ,
     +             0.2823000000000000D+06 ,    0.2750000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(105),ID27(105) /'TEXAS           SOUTH           ',2/
        DATA (PA27(I,105),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9830000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.2750000000000000D+06 ,
     +             0.2610000000000000D+06 ,    0.2540000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(106),ID27(106) /'UTAH            NORTH           ',2/
        DATA (PA27(I,106),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1113000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4147000000000000D+06 ,
     +             0.4043000000000000D+06 ,    0.4020000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(107),ID27(107) /'UTAH            CENTRAL         ',2/
        DATA (PA27(I,107),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1113000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4039000000000000D+06 ,
     +             0.3901000000000000D+06 ,    0.3820000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(108),ID27(108) /'UTAH            SOUTH           ',2/
        DATA (PA27(I,108),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1113000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3821000000000000D+06 ,
     +             0.3713000000000000D+06 ,    0.3640000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(109),ID27(109) /'VERMONT         ---             ',1/
        DATA (PA27(I,109),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7230000000000000D+06 ,
     +             0.9999642857142857D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4230000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(110),ID27(110) /'VIRGINIA        NORTH           ',2/
        DATA (PA27(I,110),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7830000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3912000000000000D+06 ,
     +             0.3802000000000000D+06 ,    0.3740000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(111),ID27(111) /'VIRGINIA        SOUTH           ',2/
        DATA (PA27(I,111),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7830000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3758000000000000D+06 ,
     +             0.3646000000000000D+06 ,    0.3620000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(112),ID27(112) /'WASHINGTON      NORTH           ',2/
        DATA (PA27(I,112),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1205000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4844000000000000D+06 ,
     +             0.4730000000000000D+06 ,    0.4700000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(113),ID27(113) /'WASHINGTON      SOUTH           ',2/
        DATA (PA27(I,113),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1203000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4720000000000000D+06 ,
     +             0.4550000000000000D+06 ,    0.4520000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(114),ID27(114) /'WEST VIRGINIA   NORTH           ',2/
        DATA (PA27(I,114),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.7930000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4015000000000000D+06 ,
     +             0.3900000000000000D+06 ,    0.3830000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(115),ID27(115) /'WEST VIRGINIA   SOUTH           ',2/
        DATA (PA27(I,115),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.8100000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3853000000000000D+06 ,
     +             0.3729000000000000D+06 ,    0.3700000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(116),ID27(116) /'WISCONSIN       NORTH           ',2/
        DATA (PA27(I,116),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9000000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4646000000000000D+06 ,
     +             0.4534000000000000D+06 ,    0.4510000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(117),ID27(117) /'WISCONSIN       CENTRAL         ',2/
        DATA (PA27(I,117),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9000000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4530000000000000D+06 ,
     +             0.4415000000000000D+06 ,    0.4350000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(118),ID27(118) /'WISCONSIN       SOUTH           ',2/
        DATA (PA27(I,118),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.9000000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4404000000000000D+06 ,
     +             0.4244000000000000D+06 ,    0.4200000000000000D+06 ,
     +             0.6096012192024384D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(119),ID27(119) /'WYOMING         EAST            ',1/
        DATA (PA27(I,119),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1051000000000000D+07 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4040000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(120),ID27(120) /'WYOMING         EAST CENTRAL    ',1/
        DATA (PA27(I,120),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1072000000000000D+07 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4040000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(121),ID27(121) /'WYOMING         WEST CENTRAL    ',1/
        DATA (PA27(I,121),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1084500000000000D+07 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4040000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(122),ID27(122) /'WYOMING         WEST            ',1/
        DATA (PA27(I,122),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1100500000000000D+07 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4040000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(123),ID27(123) /'ALASKA          ZONE NO. 1      ',4/
        DATA (PA27(I,123),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1334000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +            -0.3652116315000000D+06 ,    0.5700000000000000D+06 ,
     +             0.8185855672270928D+06 ,    0.5752192451072642D+06 /
C
        DATA NM27(124),ID27(124) /'ALASKA          ZONE NO. 2      ',1/
        DATA (PA27(I,124),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1420000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(125),ID27(125) /'ALASKA          ZONE NO. 3      ',1/
        DATA (PA27(I,125),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1460000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(126),ID27(126) /'ALASKA          ZONE NO. 4      ',1/
        DATA (PA27(I,126),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1500000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(127),ID27(127) /'ALASKA          ZONE NO. 5      ',1/
        DATA (PA27(I,127),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1540000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(128),ID27(128) /'ALASKA          ZONE NO. 6      ',1/
        DATA (PA27(I,128),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1580000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(129),ID27(129) /'ALASKA          ZONE NO. 7      ',1/
        DATA (PA27(I,129),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1620000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.2133604267208534D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(130),ID27(130) /'ALASKA          ZONE NO. 8      ',1/
        DATA (PA27(I,130),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1660000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(131),ID27(131) /'ALASKA          ZONE NO. 9      ',1/
        DATA (PA27(I,131),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.1700000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.1828803657607315D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(132),ID27(132) /'PUERTO RICO AND VIRGIN ISLANDS  ',2/
        DATA (PA27(I,132),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.6626000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.1826000000000000D+06 ,
     +             0.1802000000000000D+06 ,    0.1750000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM27(133),ID27(133) /'VIRGIN ISLANDS  ST. CROIX       ',2/
        DATA (PA27(I,133),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,   -0.6626000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.1826000000000000D+06 ,
     +             0.1802000000000000D+06 ,    0.1750000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.3048006096012192D+05 /
C
        DATA NM27(134),ID27(134) /'GUAM ISLAND                     ',3/
        DATA (PA27(I,134),I=1,9) /             0.6378206400000000D+07 ,
     +             0.6768657997291094D-02 ,    0.1444455502540000D+07 ,
     +             0.1328208788700000D+06 ,    0.5000000000000000D+05 ,
     +             0.5000000000000000D+05 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.0000000000000000D+00 /
C
        DATA NM83(  1),ID83(  1) /'ALABAMA         EAST            ',1/
        DATA (PA83(I,  1),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8550000000000000D+06 ,
     +             0.9999600000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3030000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(  2),ID83(  2) /'ALABAMA         WEST            ',1/
        DATA (PA83(I,  2),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8730000000000000D+06 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3000000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(  3),ID83(  3) /'ALASKA          ZONE NO. 10     ',2/
        DATA (PA83(I,  3),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1760000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.5350000000000000D+06 ,
     +             0.5150000000000000D+06 ,    0.5100000000000000D+06 ,
     +             0.1000000000000000D+07 ,    0.0000000000000000D+00 /
C
        DATA NM83(  4),ID83(  4) /'AMERICAN SAMOA                  ',0/
        DATA (PA83(I,  4),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1700000000000000D+07 ,
     +             0.1000000000000000D+01 ,   -0.1416000000000000D+06 ,
     +            -0.1416000000000000D+06 ,   -0.1416000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.9516931165862332D+05 /
C
        DATA NM83(  5),ID83(  5) /'ARIZONA         EAST            ',1/
        DATA (PA83(I,  5),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1101000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.2133600000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(  6),ID83(  6) /'ARIZONA         CENTRAL         ',1/
        DATA (PA83(I,  6),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1115500000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.2133600000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(  7),ID83(  7) /'ARIZONA         WEST            ',1/
        DATA (PA83(I,  7),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1134500000000000D+07 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.2133600000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(  8),ID83(  8) /'ARKANSAS        NORTH           ',2/
        DATA (PA83(I,  8),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9200000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3614000000000000D+06 ,
     +             0.3456000000000000D+06 ,    0.3420000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(  9),ID83(  9) /'ARKANSAS        SOUTH           ',2/
        DATA (PA83(I,  9),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9200000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3446000000000000D+06 ,
     +             0.3318000000000000D+06 ,    0.3240000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.4000000000000000D+06 /
C
        DATA NM83( 10),ID83( 10) /'CALIFORNIA      I               ',2/
        DATA (PA83(I, 10),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1220000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4140000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.3920000000000000D+06 ,
     +             0.2000000000000000D+07 ,    0.5000000000000000D+06 /
C
        DATA NM83( 11),ID83( 11) /'CALIFORNIA      II              ',2/
        DATA (PA83(I, 11),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1220000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3950000000000000D+06 ,
     +             0.3820000000000000D+06 ,    0.3740000000000000D+06 ,
     +             0.2000000000000000D+07 ,    0.5000000000000000D+06 /
C
        DATA NM83( 12),ID83( 12) /'CALIFORNIA      III             ',2/
        DATA (PA83(I, 12),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1203000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3826000000000000D+06 ,
     +             0.3704000000000000D+06 ,    0.3630000000000000D+06 ,
     +             0.2000000000000000D+07 ,    0.5000000000000000D+06 /
C
        DATA NM83( 13),ID83( 13) /'CALIFORNIA      IV              ',2/
        DATA (PA83(I, 13),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1190000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3715000000000000D+06 ,
     +             0.3600000000000000D+06 ,    0.3520000000000000D+06 ,
     +             0.2000000000000000D+07 ,    0.5000000000000000D+06 /
C
        DATA NM83( 14),ID83( 14) /'CALIFORNIA      V               ',2/
        DATA (PA83(I, 14),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1180000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3528000000000000D+06 ,
     +             0.3402000000000000D+06 ,    0.3330000000000000D+06 ,
     +             0.2000000000000000D+07 ,    0.5000000000000000D+06 /
C
        DATA NM83( 15),ID83( 15) /'CALIFORNIA      VI              ',2/
        DATA (PA83(I, 15),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1161500000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3353000000000000D+06 ,
     +             0.3247000000000000D+06 ,    0.3210000000000000D+06 ,
     +             0.2000000000000000D+07 ,    0.5000000000000000D+06 /
C
        DATA NM83( 16),ID83( 16) /'CALIFORNIA      VII             ',0/
        DATA (PA83(I, 16),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1182000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3425000000000000D+06 ,
     +             0.3352000000000000D+06 ,    0.3408000000000000D+06 ,
     +             0.1276106450596901D+07 ,    0.1268253006858014D+07 /
C
        DATA NM83( 17),ID83( 17) /'COLORADO        NORTH           ',2/
        DATA (PA83(I, 17),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1053000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4047000000000000D+06 ,
     +             0.3943000000000000D+06 ,    0.3920000000000000D+06 ,
     +             0.9144018289000000D+06 ,    0.3048006096000000D+06 /
C
        DATA NM83( 18),ID83( 18) /'COLORADO        CENTRAL         ',2/
        DATA (PA83(I, 18),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1053000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3945000000000000D+06 ,
     +             0.3827000000000000D+06 ,    0.3750000000000000D+06 ,
     +             0.9144018289000000D+06 ,    0.3048006096000000D+06 /
C
        DATA NM83( 19),ID83( 19) /'COLORADO        SOUTH           ',2/
        DATA (PA83(I, 19),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1053000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3826000000000000D+06 ,
     +             0.3714000000000000D+06 ,    0.3640000000000000D+06 ,
     +             0.9144018289000000D+06 ,    0.3048006096000000D+06 /
C
        DATA NM83( 20),ID83( 20) /'CONNECTICUT     ---             ',2/
        DATA (PA83(I, 20),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7245000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4152000000000000D+06 ,
     +             0.4112000000000000D+06 ,    0.4050000000000000D+06 ,
     +             0.3048006096000000D+06 ,    0.1524003048000000D+06 /
C
        DATA NM83( 21),ID83( 21) /'DELAWARE        ---             ',1/
        DATA (PA83(I, 21),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7525000000000000D+06 ,
     +             0.9999950000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3800000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 22),ID83( 22) /'FLORIDA         EAST            ',1/
        DATA (PA83(I, 22),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8100000000000000D+06 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2420000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 23),ID83( 23) /'FLORIDA         WEST            ',1/
        DATA (PA83(I, 23),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8200000000000000D+06 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2420000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 24),ID83( 24) /'FLORIDA         NORTH           ',2/
        DATA (PA83(I, 24),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8430000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3045000000000000D+06 ,
     +             0.2935000000000000D+06 ,    0.2900000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 25),ID83( 25) /'GEORGIA         EAST            ',1/
        DATA (PA83(I, 25),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8210000000000000D+06 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3000000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 26),ID83( 26) /'GEORGIA         WEST            ',1/
        DATA (PA83(I, 26),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8410000000000000D+06 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3000000000000000D+06 ,
     +             0.7000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 27),ID83( 27) /'HAWAII          1               ',1/
        DATA (PA83(I, 27),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1553000000000000D+07 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.1850000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 28),ID83( 28) /'HAWAII          2               ',1/
        DATA (PA83(I, 28),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1564000000000000D+07 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2020000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 29),ID83( 29) /'HAWAII          3               ',1/
        DATA (PA83(I, 29),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1580000000000000D+07 ,
     +             0.9999900000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2110000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 30),ID83( 30) /'HAWAII          4               ',1/
        DATA (PA83(I, 30),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1593000000000000D+07 ,
     +             0.9999900000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2150000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 31),ID83( 31) /'HAWAII          5               ',1/
        DATA (PA83(I, 31),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1601000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2140000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 32),ID83( 32) /'IDAHO           EAST            ',1/
        DATA (PA83(I, 32),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1121000000000000D+07 ,
     +             0.9999473684210526D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4140000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 33),ID83( 33) /'IDAHO           CENTRAL         ',1/
        DATA (PA83(I, 33),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1140000000000000D+07 ,
     +             0.9999473684210526D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4140000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 34),ID83( 34) /'IDAHO           WEST            ',1/
        DATA (PA83(I, 34),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1154500000000000D+07 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4140000000000000D+06 ,
     +             0.8000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 35),ID83( 35) /'ILLINOIS        EAST            ',1/
        DATA (PA83(I, 35),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8820000000000000D+06 ,
     +             0.9999750000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3640000000000000D+06 ,
     +             0.3000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 36),ID83( 36) /'ILLINOIS        WEST            ',1/
        DATA (PA83(I, 36),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9010000000000000D+06 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3640000000000000D+06 ,
     +             0.7000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 37),ID83( 37) /'INDIANA         EAST            ',1/
        DATA (PA83(I, 37),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8540000000000000D+06 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3730000000000000D+06 ,
     +             0.1000000000000000D+06 ,    0.2500000000000000D+06 /
C
        DATA NM83( 38),ID83( 38) /'INDIANA         WEST            ',1/
        DATA (PA83(I, 38),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8705000000000000D+06 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3730000000000000D+06 ,
     +             0.9000000000000000D+06 ,    0.2500000000000000D+06 /
C
        DATA NM83( 39),ID83( 39) /'IOWA            NORTH           ',2/
        DATA (PA83(I, 39),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9330000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4316000000000000D+06 ,
     +             0.4204000000000000D+06 ,    0.4130000000000000D+06 ,
     +             0.1500000000000000D+07 ,    0.1000000000000000D+07 /
C
        DATA NM83( 40),ID83( 40) /'IOWA            SOUTH           ',2/
        DATA (PA83(I, 40),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9330000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4147000000000000D+06 ,
     +             0.4037000000000000D+06 ,    0.4000000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 41),ID83( 41) /'KANSAS          NORTH           ',2/
        DATA (PA83(I, 41),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9800000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3947000000000000D+06 ,
     +             0.3843000000000000D+06 ,    0.3820000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 42),ID83( 42) /'KANSAS          SOUTH           ',2/
        DATA (PA83(I, 42),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9830000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3834000000000000D+06 ,
     +             0.3716000000000000D+06 ,    0.3640000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.4000000000000000D+06 /
C
        DATA NM83( 43),ID83( 43) /'KENTUCKY        NORTH           ',2/
        DATA (PA83(I, 43),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8415000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3858000000000000D+06 ,
     +             0.3758000000000000D+06 ,    0.3730000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 44),ID83( 44) /'KENTUCKY        SOUTH           ',2/
        DATA (PA83(I, 44),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8545000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3756000000000000D+06 ,
     +             0.3644000000000000D+06 ,    0.3620000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.5000000000000000D+06 /
C
        DATA NM83( 45),ID83( 45) /'LOUISIANA       NORTH           ',2/
        DATA (PA83(I, 45),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9230000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3240000000000000D+06 ,
     +             0.3110000000000000D+06 ,    0.3030000000000000D+06 ,
     +             0.1000000000000000D+07 ,    0.0000000000000000D+00 /
C
        DATA NM83( 46),ID83( 46) /'LOUISIANA       SOUTH           ',2/
        DATA (PA83(I, 46),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9120000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3042000000000000D+06 ,
     +             0.2918000000000000D+06 ,    0.2830000000000000D+06 ,
     +             0.1000000000000000D+07 ,    0.0000000000000000D+00 /
C
        DATA NM83( 47),ID83( 47) /'LOUISIANA       OFFSHORE        ',2/
        DATA (PA83(I, 47),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9120000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.2750000000000000D+06 ,
     +             0.2610000000000000D+06 ,    0.2530000000000000D+06 ,
     +             0.1000000000000000D+07 ,    0.0000000000000000D+00 /
C
        DATA NM83( 48),ID83( 48) /'MAINE           EAST            ',1/
        DATA (PA83(I, 48),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.6830000000000000D+06 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4340000000000000D+06 ,
     +             0.3000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 49),ID83( 49) /'MAINE           WEST            ',1/
        DATA (PA83(I, 49),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7010000000000000D+06 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4250000000000000D+06 ,
     +             0.9000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 50),ID83( 50) /'MARYLAND        ---             ',2/
        DATA (PA83(I, 50),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7700000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3927000000000000D+06 ,
     +             0.3818000000000000D+06 ,    0.3740000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 51),ID83( 51) /'MASSACHUSETTS   MAINLAND        ',2/
        DATA (PA83(I, 51),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7130000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4241000000000000D+06 ,
     +             0.4143000000000000D+06 ,    0.4100000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.7500000000000000D+06 /
C
        DATA NM83( 52),ID83( 52) /'MASSACHUSETTS   ISLAND          ',2/
        DATA (PA83(I, 52),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7030000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4129000000000000D+06 ,
     +             0.4117000000000000D+06 ,    0.4100000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 53),ID83( 53) /'MICHIGAN        EAST            ',0/
        DATA (PA83(I, 53),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8340000000000000D+06 ,
     +             0.9999428571428571D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4130000000000000D+06 ,
     +             0.0000000000000000D+00 ,    0.0000000000000000D+00 /
C
        DATA NM83( 54),ID83( 54) /'MICHIGAN        CENTRAL/M       ',0/
        DATA (PA83(I, 54),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8545000000000000D+06 ,
     +             0.9999090909090909D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4130000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 55),ID83( 55) /'MICHIGAN        WEST            ',0/
        DATA (PA83(I, 55),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8845000000000000D+06 ,
     +             0.9999090909090909D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4130000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 56),ID83( 56) /'MICHIGAN        NORTH           ',2/
        DATA (PA83(I, 56),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8700000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4705000000000000D+06 ,
     +             0.4529000000000000D+06 ,    0.4447000000000000D+06 ,
     +             0.8000000000000000D+07 ,    0.0000000000000000D+00 /
C
        DATA NM83( 57),ID83( 57) /'MICHIGAN        CENTRAL/L       ',2/
        DATA (PA83(I, 57),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8422000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4542000000000000D+06 ,
     +             0.4411000000000000D+06 ,    0.4319000000000000D+06 ,
     +             0.6000000000000000D+07 ,    0.0000000000000000D+00 /
C
        DATA NM83( 58),ID83( 58) /'MICHIGAN        SOUTH           ',2/
        DATA (PA83(I, 58),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8422000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4340000000000000D+06 ,
     +             0.4206000000000000D+06 ,    0.4130000000000000D+06 ,
     +             0.4000000000000000D+07 ,    0.0000000000000000D+00 /
C
        DATA NM83( 59),ID83( 59) /'MINNESOTA       NORTH           ',2/
        DATA (PA83(I, 59),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9306000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4838000000000000D+06 ,
     +             0.4702000000000000D+06 ,    0.4630000000000000D+06 ,
     +             0.8000000000000000D+06 ,    0.1000000000000000D+06 /
C
        DATA NM83( 60),ID83( 60) /'MINNESOTA       CENTRAL         ',2/
        DATA (PA83(I, 60),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9415000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4703000000000000D+06 ,
     +             0.4537000000000000D+06 ,    0.4500000000000000D+06 ,
     +             0.8000000000000000D+06 ,    0.1000000000000000D+06 /
C
        DATA NM83( 61),ID83( 61) /'MINNESOTA       SOUTH           ',2/
        DATA (PA83(I, 61),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9400000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4513000000000000D+06 ,
     +             0.4347000000000000D+06 ,    0.4300000000000000D+06 ,
     +             0.8000000000000000D+06 ,    0.1000000000000000D+06 /
C
        DATA NM83( 62),ID83( 62) /'MISSISSIPPI     EAST            ',1/
        DATA (PA83(I, 62),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8850000000000000D+06 ,
     +             0.9999500000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2930000000000000D+06 ,
     +             0.3000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 63),ID83( 63) /'MISSISSIPPI     WEST            ',1/
        DATA (PA83(I, 63),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9020000000000000D+06 ,
     +             0.9999500000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.2930000000000000D+06 ,
     +             0.7000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 64),ID83( 64) /'MISSOURI        EAST            ',1/
        DATA (PA83(I, 64),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9030000000000000D+06 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3550000000000000D+06 ,
     +             0.2500000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 65),ID83( 65) /'MISSOURI        CENTRAL         ',1/
        DATA (PA83(I, 65),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9230000000000000D+06 ,
     +             0.9999333333333333D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3550000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 66),ID83( 66) /'MISSOURI        WEST            ',1/
        DATA (PA83(I, 66),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9430000000000000D+06 ,
     +             0.9999411764705882D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3610000000000000D+06 ,
     +             0.8500000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 67),ID83( 67) /'MONTANA                         ',2/
        DATA (PA83(I, 67),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1093000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4900000000000000D+06 ,
     +             0.4500000000000000D+06 ,    0.4415000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 68),ID83( 68) /'MONTANA                         ',0/
        DATA (PA83(I, 68),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1093000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4900000000000000D+06 ,
     +             0.4500000000000000D+06 ,    0.4415000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 69),ID83( 69) /'MONTANA                         ',0/
        DATA (PA83(I, 69),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1093000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4900000000000000D+06 ,
     +             0.4500000000000000D+06 ,    0.4415000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 70),ID83( 70) /'NEBRASKA                        ',2/
        DATA (PA83(I, 70),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1000000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4300000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.3950000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 71),ID83( 71) /'NEBRASKA                        ',0/
        DATA (PA83(I, 71),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1000000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4300000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.3950000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 72),ID83( 72) /'NEVADA          EAST            ',1/
        DATA (PA83(I, 72),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1153500000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3445000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.8000000000000000D+07 /
C
        DATA NM83( 73),ID83( 73) /'NEVADA          CENTRAL         ',1/
        DATA (PA83(I, 73),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1164000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3445000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.6000000000000000D+07 /
C
        DATA NM83( 74),ID83( 74) /'NEVADA          WEST            ',1/
        DATA (PA83(I, 74),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1183500000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3445000000000000D+06 ,
     +             0.8000000000000000D+06 ,    0.4000000000000000D+07 /
C
        DATA NM83( 75),ID83( 75) /'NEW HAMPSHIRE   ---             ',1/
        DATA (PA83(I, 75),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7140000000000000D+06 ,
     +             0.9999666666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4230000000000000D+06 ,
     +             0.3000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 76),ID83( 76) /'NEW JERSEY      ---             ',1/
        DATA (PA83(I, 76),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7430000000000000D+06 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3850000000000000D+06 ,
     +             0.1500000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 77),ID83( 77) /'NEW MEXICO      EAST            ',1/
        DATA (PA83(I, 77),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1042000000000000D+07 ,
     +             0.9999090909090909D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.1650000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 78),ID83( 78) /'NEW MEXICO      CENTRAL         ',1/
        DATA (PA83(I, 78),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1061500000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 79),ID83( 79) /'NEW MEXICO      WEST            ',1/
        DATA (PA83(I, 79),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1075000000000000D+07 ,
     +             0.9999166666666667D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3100000000000000D+06 ,
     +             0.8300000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 80),ID83( 80) /'NEW YORK        EAST            ',1/
        DATA (PA83(I, 80),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7430000000000000D+06 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.3850000000000000D+06 ,
     +             0.1500000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 81),ID83( 81) /'NEW YORK        CENTRAL         ',1/
        DATA (PA83(I, 81),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7635000000000000D+06 ,
     +             0.9999375000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4000000000000000D+06 ,
     +             0.2500000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 82),ID83( 82) /'NEW YORK        WEST            ',1/
        DATA (PA83(I, 82),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7835000000000000D+06 ,
     +             0.9999375000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4000000000000000D+06 ,
     +             0.3500000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 83),ID83( 83) /'NEW YORK        LONG ISLAND     ',2/
        DATA (PA83(I, 83),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7400000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4102000000000000D+06 ,
     +             0.4040000000000000D+06 ,    0.4010000000000000D+06 ,
     +             0.3000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 84),ID83( 84) /'NORTH CAROLINA  ---             ',2/
        DATA (PA83(I, 84),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7900000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3610000000000000D+06 ,
     +             0.3420000000000000D+06 ,    0.3345000000000000D+06 ,
     +             0.6096012200000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 85),ID83( 85) /'NORTH DAKOTA    NORTH           ',2/
        DATA (PA83(I, 85),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1003000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4844000000000000D+06 ,
     +             0.4726000000000000D+06 ,    0.4700000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 86),ID83( 86) /'NORTH DAKOTA    SOUTH           ',2/
        DATA (PA83(I, 86),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1003000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4729000000000000D+06 ,
     +             0.4611000000000000D+06 ,    0.4540000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 87),ID83( 87) /'OHIO            NORTH           ',2/
        DATA (PA83(I, 87),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8230000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4142000000000000D+06 ,
     +             0.4026000000000000D+06 ,    0.3940000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 88),ID83( 88) /'OHIO            SOUTH           ',2/
        DATA (PA83(I, 88),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8230000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4002000000000000D+06 ,
     +             0.3844000000000000D+06 ,    0.3800000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 89),ID83( 89) /'OKLAHOMA        NORTH           ',2/
        DATA (PA83(I, 89),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9800000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3646000000000000D+06 ,
     +             0.3534000000000000D+06 ,    0.3500000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 90),ID83( 90) /'OKLAHOMA        SOUTH           ',2/
        DATA (PA83(I, 90),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9800000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3514000000000000D+06 ,
     +             0.3356000000000000D+06 ,    0.3320000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 91),ID83( 91) /'OREGON          NORTH           ',2/
        DATA (PA83(I, 91),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1203000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4600000000000000D+06 ,
     +             0.4420000000000000D+06 ,    0.4340000000000000D+06 ,
     +             0.2500000000000000D+07 ,    0.0000000000000000D+00 /
C
        DATA NM83( 92),ID83( 92) /'OREGON          SOUTH           ',2/
        DATA (PA83(I, 92),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1203000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4400000000000000D+06 ,
     +             0.4220000000000000D+06 ,    0.4140000000000000D+06 ,
     +             0.1500000000000000D+07 ,    0.0000000000000000D+00 /
C
        DATA NM83( 93),ID83( 93) /'PENNSYLVANIA    NORTH           ',2/
        DATA (PA83(I, 93),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7745000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4157000000000000D+06 ,
     +             0.4053000000000000D+06 ,    0.4010000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 94),ID83( 94) /'PENNSYLVANIA    SOUTH           ',2/
        DATA (PA83(I, 94),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7745000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4058000000000000D+06 ,
     +             0.3956000000000000D+06 ,    0.3920000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 95),ID83( 95) /'RHODE ISLAND    ---             ',1/
        DATA (PA83(I, 95),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7130000000000000D+06 ,
     +             0.9999937500000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4105000000000000D+06 ,
     +             0.1000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 96),ID83( 96) /'SOUTH CAROLINA                  ',2/
        DATA (PA83(I, 96),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8100000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3450000000000000D+06 ,
     +             0.3230000000000000D+06 ,    0.3150000000000000D+06 ,
     +             0.6096000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 97),ID83( 97) /'SOUTH CAROLINA                  ',0/
        DATA (PA83(I, 97),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8100000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3450000000000000D+06 ,
     +             0.3230000000000000D+06 ,    0.3150000000000000D+06 ,
     +             0.6096000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 98),ID83( 98) /'SOUTH DAKOTA    NORTH           ',2/
        DATA (PA83(I, 98),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1000000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4541000000000000D+06 ,
     +             0.4425000000000000D+06 ,    0.4350000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83( 99),ID83( 99) /'SOUTH DAKOTA    SOUTH           ',2/
        DATA (PA83(I, 99),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1002000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4424000000000000D+06 ,
     +             0.4250000000000000D+06 ,    0.4220000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(100),ID83(100) /'TENNESSEE       ---             ',2/
        DATA (PA83(I,100),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8600000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3625000000000000D+06 ,
     +             0.3515000000000000D+06 ,    0.3420000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(101),ID83(101) /'TEXAS           NORTH           ',2/
        DATA (PA83(I,101),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1013000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3611000000000000D+06 ,
     +             0.3439000000000000D+06 ,    0.3400000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.1000000000000000D+07 /
C
        DATA NM83(102),ID83(102) /'TEXAS           NORTH CENTRAL   ',2/
        DATA (PA83(I,102),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9830000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3358000000000000D+06 ,
     +             0.3208000000000000D+06 ,    0.3140000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.2000000000000000D+07 /
C
        DATA NM83(103),ID83(103) /'TEXAS           CENTRAL         ',2/
        DATA (PA83(I,103),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1002000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3153000000000000D+06 ,
     +             0.3007000000000000D+06 ,    0.2940000000000000D+06 ,
     +             0.7000000000000000D+06 ,    0.3000000000000000D+07 /
C
        DATA NM83(104),ID83(104) /'TEXAS           SOUTH CENTRAL   ',2/
        DATA (PA83(I,104),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9900000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3017000000000000D+06 ,
     +             0.2823000000000000D+06 ,    0.2750000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.4000000000000000D+07 /
C
        DATA NM83(105),ID83(105) /'TEXAS           SOUTH           ',2/
        DATA (PA83(I,105),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9830000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.2750000000000000D+06 ,
     +             0.2610000000000000D+06 ,    0.2540000000000000D+06 ,
     +             0.3000000000000000D+06 ,    0.5000000000000000D+07 /
C
        DATA NM83(106),ID83(106) /'UTAH            NORTH           ',2/
        DATA (PA83(I,106),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1113000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4147000000000000D+06 ,
     +             0.4043000000000000D+06 ,    0.4020000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.1000000000000000D+07 /
C
        DATA NM83(107),ID83(107) /'UTAH            CENTRAL         ',2/
        DATA (PA83(I,107),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1113000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4039000000000000D+06 ,
     +             0.3901000000000000D+06 ,    0.3820000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.2000000000000000D+07 /
C
        DATA NM83(108),ID83(108) /'UTAH            SOUTH           ',2/
        DATA (PA83(I,108),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1113000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.3821000000000000D+06 ,
     +             0.3713000000000000D+06 ,    0.3640000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.3000000000000000D+07 /
C
        DATA NM83(109),ID83(109) /'VERMONT         ---             ',1/
        DATA (PA83(I,109),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7230000000000000D+06 ,
     +             0.9999642857142857D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4230000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(110),ID83(110) /'VIRGINIA        NORTH           ',2/
        DATA (PA83(I,110),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7830000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3912000000000000D+06 ,
     +             0.3802000000000000D+06 ,    0.3740000000000000D+06 ,
     +             0.3500000000000000D+07 ,    0.2000000000000000D+07 /
C
        DATA NM83(111),ID83(111) /'VIRGINIA        SOUTH           ',2/
        DATA (PA83(I,111),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7830000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3758000000000000D+06 ,
     +             0.3646000000000000D+06 ,    0.3620000000000000D+06 ,
     +             0.3500000000000000D+07 ,    0.1000000000000000D+07 /
C
        DATA NM83(112),ID83(112) /'WASHINGTON      NORTH           ',2/
        DATA (PA83(I,112),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1205000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4844000000000000D+06 ,
     +             0.4730000000000000D+06 ,    0.4700000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(113),ID83(113) /'WASHINGTON      SOUTH           ',2/
        DATA (PA83(I,113),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1203000000000000D+07 ,
     +             0.1000000000000000D+01 ,    0.4720000000000000D+06 ,
     +             0.4550000000000000D+06 ,    0.4520000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(114),ID83(114) /'WEST VIRGINIA   NORTH           ',2/
        DATA (PA83(I,114),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.7930000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4015000000000000D+06 ,
     +             0.3900000000000000D+06 ,    0.3830000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(115),ID83(115) /'WEST VIRGINIA   SOUTH           ',2/
        DATA (PA83(I,115),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.8100000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.3853000000000000D+06 ,
     +             0.3729000000000000D+06 ,    0.3700000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(116),ID83(116) /'WISCONSIN       NORTH           ',2/
        DATA (PA83(I,116),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9000000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4646000000000000D+06 ,
     +             0.4534000000000000D+06 ,    0.4510000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(117),ID83(117) /'WISCONSIN       CENTRAL         ',2/
        DATA (PA83(I,117),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9000000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4530000000000000D+06 ,
     +             0.4415000000000000D+06 ,    0.4350000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(118),ID83(118) /'WISCONSIN       SOUTH           ',2/
        DATA (PA83(I,118),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.9000000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.4404000000000000D+06 ,
     +             0.4244000000000000D+06 ,    0.4200000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(119),ID83(119) /'WYOMING         EAST            ',1/
        DATA (PA83(I,119),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1051000000000000D+07 ,
     +             0.9999375000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4030000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(120),ID83(120) /'WYOMING         EAST CENTRAL    ',1/
        DATA (PA83(I,120),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1072000000000000D+07 ,
     +             0.9999375000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4030000000000000D+06 ,
     +             0.4000000000000000D+06 ,    0.1000000000000000D+06 /
C
        DATA NM83(121),ID83(121) /'WYOMING         WEST CENTRAL    ',1/
        DATA (PA83(I,121),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1084500000000000D+07 ,
     +             0.9999375000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4030000000000000D+06 ,
     +             0.6000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(122),ID83(122) /'WYOMING         WEST            ',1/
        DATA (PA83(I,122),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1100500000000000D+07 ,
     +             0.9999375000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.4030000000000000D+06 ,
     +             0.8000000000000000D+06 ,    0.1000000000000000D+06 /
C
        DATA NM83(123),ID83(123) /'ALASKA          ZONE NO. 1      ',4/
        DATA (PA83(I,123),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1334000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +            -0.3652116315000000D+06 ,    0.5700000000000000D+06 ,
     +             0.8186767344011233D+06 ,    0.5750976888751927D+06 /
C
        DATA NM83(124),ID83(124) /'ALASKA          ZONE NO. 2      ',1/
        DATA (PA83(I,124),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1420000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(125),ID83(125) /'ALASKA          ZONE NO. 3      ',1/
        DATA (PA83(I,125),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1460000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(126),ID83(126) /'ALASKA          ZONE NO. 4      ',1/
        DATA (PA83(I,126),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1500000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(127),ID83(127) /'ALASKA          ZONE NO. 5      ',1/
        DATA (PA83(I,127),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1540000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(128),ID83(128) /'ALASKA          ZONE NO. 6      ',1/
        DATA (PA83(I,128),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1580000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(129),ID83(129) /'ALASKA          ZONE NO. 7      ',1/
        DATA (PA83(I,129),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1620000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(130),ID83(130) /'ALASKA          ZONE NO. 8      ',1/
        DATA (PA83(I,130),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1660000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(131),ID83(131) /'ALASKA          ZONE NO. 9      ',1/
        DATA (PA83(I,131),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.1700000000000000D+07 ,
     +             0.9999000000000000D+00 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.5400000000000000D+06 ,
     +             0.5000000000000000D+06 ,    0.0000000000000000D+00 /
C
        DATA NM83(132),ID83(132) /'PUERTO RICO AND VIRGIN ISLANDS  ',2/
        DATA (PA83(I,132),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.6626000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.1826000000000000D+06 ,
     +             0.1802000000000000D+06 ,    0.1750000000000000D+06 ,
     +             0.2000000000000000D+06 ,    0.2000000000000000D+06 /
C
        DATA NM83(133),ID83(133) /'VIRGIN ISLANDS  ST. CROIX       ',0/
        DATA (PA83(I,133),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,   -0.6626000000000000D+06 ,
     +             0.1000000000000000D+01 ,    0.1826000000000000D+06 ,
     +             0.1802000000000000D+06 ,    0.1750000000000000D+06 ,
     +             0.1524003048006096D+06 ,    0.3048006096012192D+05 /
C
        DATA NM83(134),ID83(134) /'GUAM ISLAND                     ',0/
        DATA (PA83(I,134),I=1,9) /             0.6378137000000000D+07 ,
     +             0.6694380022900000D-02 ,    0.1444455502540000D+07 ,
     +             0.1328208788700000D+06 ,    0.5000000000000000D+05 ,
     +             0.5000000000000000D+05 ,    0.0000000000000000D+00 ,
     +             0.0000000000000000D+00 ,    0.0000000000000000D+00 /
C
      END
