/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2014 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2014 Sun Microsystems, Inc.
 */
package org.netbeans.modules.netbinox;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import static junit.framework.Assert.assertEquals;
import org.netbeans.MockEvents;
import org.netbeans.MockModuleInstaller;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.SetupHid;
import static org.netbeans.SetupHid.createTestJAR;

/**
 *
 * @author Jaroslav Tulach
 */
public class NetbinoxDuplicatedBuddyForNameTest extends NetigsoHid {
    private File simpleModule;
    private File simpleModule2;
    private File dependsModule;
    public NetbinoxDuplicatedBuddyForNameTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        Locale.setDefault(new Locale("te", "ST"));
        clearWorkDir();
        File ud = new File(getWorkDir(), "ud");
        ud.mkdirs();
        System.setProperty("netbeans.user", ud.getPath());

        data = new File(getDataDir(), "jars");
        jars = new File(getWorkDir(), "space in path");
        jars.mkdirs();
        simpleModule = createTestJAR("simple-module", null);
        
        String snd =
            "Manifest-Version: 1.0\n" +
"Bundle-SymbolicName: org.foo2\n" +
"Bundle-Version: 1.2\n" +
"Require-Bundle: org.has.foo.as.buddy\n\n" +
"";
        simpleModule2 = changeManifest(simpleModule, snd);
        
        String buddy =
            "Manifest-Version: 1.0\n" +
"Bundle-SymbolicName: org.has.foo.as.buddy\n" +
"Eclipse-BuddyPolicy: dependent\n" + 
"Bundle-Version: 1.2\n" +
"";
        dependsModule = changeManifest(createTestJAR("depends-on-simple-module", null, simpleModule), buddy);
    }
    
    public void testDuplicatedClassStillGetsLoaded() throws Exception {
        MockModuleInstaller installer = new MockModuleInstaller();
        MockEvents ev = new MockEvents();
        ModuleManager mgr = new ModuleManager(installer, ev);
        mgr.mutexPrivileged().enterWriteAccess();
        HashSet<Module> all = null;
        try {
            Module m1 = mgr.create(simpleModule, null, false, false, false);
            Module m2 = mgr.create(simpleModule2, null, false, false, false);
            Module m3 = mgr.create(dependsModule, null, false, false, false);
            
            HashSet<Module> b = new HashSet<Module>(Arrays.asList(m1, m2, m3));
            mgr.enable(b);
            all = b;

            Class<?> clazz = m3.getClassLoader().loadClass("org.bar.SomethingReflective");
            
            Class<?> sprclass = m2.getClassLoader().loadClass("org.foo.Something");
            
            Thread.currentThread().setContextClassLoader(mgr.getClassLoader());
            Object res = clazz.getMethod("loadClass").invoke(null);

            assertEquals("forName loaded the right class", sprclass, res);
        } finally {
            if (all != null) {
                mgr.disable(all);
            }
            mgr.mutexPrivileged().exitWriteAccess();
        }
    }
}
